<?php

declare (strict_types=1);
namespace PHPStan;

class Php8StubsMap
{
    /** @var array<string, string> */
    public $classes;
    /** @var array<string, string> */
    public $functions;
    public function __construct(int $phpVersionId)
    {
        $classes = ['addressinfo' => 'stubs/ext/sockets/AddressInfo.stub', 'appenditerator' => 'stubs/ext/spl/AppendIterator.stub', 'argumentcounterror' => 'stubs/Zend/ArgumentCountError.stub', 'arithmeticerror' => 'stubs/Zend/ArithmeticError.stub', 'arrayaccess' => 'stubs/Zend/ArrayAccess.stub', 'arrayiterator' => 'stubs/ext/spl/ArrayIterator.stub', 'arrayobject' => 'stubs/ext/spl/ArrayObject.stub', 'attribute' => 'stubs/Zend/Attribute.stub', 'cachingiterator' => 'stubs/ext/spl/CachingIterator.stub', 'callbackfilteriterator' => 'stubs/ext/spl/CallbackFilterIterator.stub', 'closedgeneratorexception' => 'stubs/Zend/ClosedGeneratorException.stub', 'closure' => 'stubs/Zend/Closure.stub', 'collator' => 'stubs/ext/intl/collator/Collator.stub', 'com' => 'stubs/ext/com_dotnet/com.stub', 'com_exception' => 'stubs/ext/com_dotnet/com_exception.stub', 'compersisthelper' => 'stubs/ext/com_dotnet/COMPersistHelper.stub', 'compileerror' => 'stubs/Zend/CompileError.stub', 'countable' => 'stubs/Zend/Countable.stub', 'curlfile' => 'stubs/ext/curl/CURLFile.stub', 'curlhandle' => 'stubs/ext/curl/CurlHandle.stub', 'curlmultihandle' => 'stubs/ext/curl/CurlMultiHandle.stub', 'curlsharehandle' => 'stubs/ext/curl/CurlShareHandle.stub', 'dateinterval' => 'stubs/ext/date/DateInterval.stub', 'dateperiod' => 'stubs/ext/date/DatePeriod.stub', 'datetime' => 'stubs/ext/date/DateTime.stub', 'datetimeimmutable' => 'stubs/ext/date/DateTimeImmutable.stub', 'datetimeinterface' => 'stubs/ext/date/DateTimeInterface.stub', 'datetimezone' => 'stubs/ext/date/DateTimeZone.stub', 'deflatecontext' => 'stubs/ext/zlib/DeflateContext.stub', 'directory' => 'stubs/ext/standard/Directory.stub', 'directoryiterator' => 'stubs/ext/spl/DirectoryIterator.stub', 'divisionbyzeroerror' => 'stubs/Zend/DivisionByZeroError.stub', 'domattr' => 'stubs/ext/dom/DOMAttr.stub', 'domcdatasection' => 'stubs/ext/dom/DOMCdataSection.stub', 'domcharacterdata' => 'stubs/ext/dom/DOMCharacterData.stub', 'domchildnode' => 'stubs/ext/dom/DOMChildNode.stub', 'domcomment' => 'stubs/ext/dom/DOMComment.stub', 'domdocument' => 'stubs/ext/dom/DOMDocument.stub', 'domdocumentfragment' => 'stubs/ext/dom/DOMDocumentFragment.stub', 'domdocumenttype' => 'stubs/ext/dom/DOMDocumentType.stub', 'domelement' => 'stubs/ext/dom/DOMElement.stub', 'domentity' => 'stubs/ext/dom/DOMEntity.stub', 'domentityreference' => 'stubs/ext/dom/DOMEntityReference.stub', 'domexception' => 'stubs/ext/dom/DOMException.stub', 'domimplementation' => 'stubs/ext/dom/DOMImplementation.stub', 'domnamednodemap' => 'stubs/ext/dom/DOMNamedNodeMap.stub', 'domnamespacenode' => 'stubs/ext/dom/DOMNameSpaceNode.stub', 'domnode' => 'stubs/ext/dom/DOMNode.stub', 'domnodelist' => 'stubs/ext/dom/DOMNodeList.stub', 'domnotation' => 'stubs/ext/dom/DOMNotation.stub', 'domparentnode' => 'stubs/ext/dom/DOMParentNode.stub', 'domprocessinginstruction' => 'stubs/ext/dom/DOMProcessingInstruction.stub', 'domtext' => 'stubs/ext/dom/DOMText.stub', 'domxpath' => 'stubs/ext/dom/DOMXPath.stub', 'dotnet' => 'stubs/ext/com_dotnet/dotnet.stub', 'emptyiterator' => 'stubs/ext/spl/EmptyIterator.stub', 'enchantbroker' => 'stubs/ext/enchant/EnchantBroker.stub', 'enchantdictionary' => 'stubs/ext/enchant/EnchantDictionary.stub', 'error' => 'stubs/Zend/Error.stub', 'errorexception' => 'stubs/Zend/ErrorException.stub', 'exception' => 'stubs/Zend/Exception.stub', 'ffi' => 'stubs/ext/ffi/FFI.stub', 'ffi\\cdata' => 'stubs/ext/ffi/FFI/CData.stub', 'ffi\\ctype' => 'stubs/ext/ffi/FFI/CType.stub', 'ffi\\exception' => 'stubs/ext/ffi/FFI/Exception.stub', 'ffi\\parserexception' => 'stubs/ext/ffi/FFI/ParserException.stub', 'filesystemiterator' => 'stubs/ext/spl/FilesystemIterator.stub', 'filteriterator' => 'stubs/ext/spl/FilterIterator.stub', 'finfo' => 'stubs/ext/fileinfo/finfo.stub', 'gdimage' => 'stubs/ext/gd/GdImage.stub', 'generator' => 'stubs/Zend/Generator.stub', 'globiterator' => 'stubs/ext/spl/GlobIterator.stub', 'gmp' => 'stubs/ext/gmp/GMP.stub', 'hashcontext' => 'stubs/ext/hash/HashContext.stub', 'infiniteiterator' => 'stubs/ext/spl/InfiniteIterator.stub', 'inflatecontext' => 'stubs/ext/zlib/InflateContext.stub', 'internaliterator' => 'stubs/Zend/InternalIterator.stub', 'intlbreakiterator' => 'stubs/ext/intl/breakiterator/IntlBreakIterator.stub', 'intlcalendar' => 'stubs/ext/intl/calendar/IntlCalendar.stub', 'intlchar' => 'stubs/ext/intl/uchar/IntlChar.stub', 'intlcodepointbreakiterator' => 'stubs/ext/intl/breakiterator/IntlCodePointBreakIterator.stub', 'intldateformatter' => 'stubs/ext/intl/dateformat/IntlDateFormatter.stub', 'intlexception' => 'stubs/ext/intl/IntlException.stub', 'intlgregoriancalendar' => 'stubs/ext/intl/calendar/IntlGregorianCalendar.stub', 'intliterator' => 'stubs/ext/intl/common/IntlIterator.stub', 'intlpartsiterator' => 'stubs/ext/intl/breakiterator/IntlPartsIterator.stub', 'intlrulebasedbreakiterator' => 'stubs/ext/intl/breakiterator/IntlRuleBasedBreakIterator.stub', 'intltimezone' => 'stubs/ext/intl/timezone/IntlTimeZone.stub', 'iterator' => 'stubs/Zend/Iterator.stub', 'iteratoraggregate' => 'stubs/Zend/IteratorAggregate.stub', 'iteratoriterator' => 'stubs/ext/spl/IteratorIterator.stub', 'jsonexception' => 'stubs/ext/json/JsonException.stub', 'jsonserializable' => 'stubs/ext/json/JsonSerializable.stub', 'libxmlerror' => 'stubs/ext/libxml/LibXMLError.stub', 'limititerator' => 'stubs/ext/spl/LimitIterator.stub', 'locale' => 'stubs/ext/intl/locale/Locale.stub', 'messageformatter' => 'stubs/ext/intl/msgformat/MessageFormatter.stub', 'multipleiterator' => 'stubs/ext/spl/MultipleIterator.stub', 'mysqli' => 'stubs/ext/mysqli/mysqli.stub', 'mysqli_driver' => 'stubs/ext/mysqli/mysqli_driver.stub', 'mysqli_result' => 'stubs/ext/mysqli/mysqli_result.stub', 'mysqli_sql_exception' => 'stubs/ext/mysqli/mysqli_sql_exception.stub', 'mysqli_stmt' => 'stubs/ext/mysqli/mysqli_stmt.stub', 'mysqli_warning' => 'stubs/ext/mysqli/mysqli_warning.stub', 'norewinditerator' => 'stubs/ext/spl/NoRewindIterator.stub', 'normalizer' => 'stubs/ext/intl/normalizer/Normalizer.stub', 'numberformatter' => 'stubs/ext/intl/formatter/NumberFormatter.stub', 'ocicollection' => 'stubs/ext/oci8/OCICollection.stub', 'ocilob' => 'stubs/ext/oci8/OCILob.stub', 'opensslasymmetrickey' => 'stubs/ext/openssl/OpenSSLAsymmetricKey.stub', 'opensslcertificate' => 'stubs/ext/openssl/OpenSSLCertificate.stub', 'opensslcertificatesigningrequest' => 'stubs/ext/openssl/OpenSSLCertificateSigningRequest.stub', 'outeriterator' => 'stubs/ext/spl/OuterIterator.stub', 'parentiterator' => 'stubs/ext/spl/ParentIterator.stub', 'parseerror' => 'stubs/Zend/ParseError.stub', 'pdo' => 'stubs/ext/pdo/PDO.stub', 'pdo_pgsql_ext' => 'stubs/ext/pdo_pgsql/PDO_PGSql_Ext.stub', 'pdo_sqlite_ext' => 'stubs/ext/pdo_sqlite/PDO_SQLite_Ext.stub', 'pdoexception' => 'stubs/ext/pdo/PDOException.stub', 'pdorow' => 'stubs/ext/pdo/PDORow.stub', 'pdostatement' => 'stubs/ext/pdo/PDOStatement.stub', 'phar' => 'stubs/ext/phar/Phar.stub', 'phardata' => 'stubs/ext/phar/PharData.stub', 'pharexception' => 'stubs/ext/phar/PharException.stub', 'pharfileinfo' => 'stubs/ext/phar/PharFileInfo.stub', 'php_user_filter' => 'stubs/ext/standard/php_user_filter.stub', 'phptoken' => 'stubs/ext/tokenizer/PhpToken.stub', 'recursivearrayiterator' => 'stubs/ext/spl/RecursiveArrayIterator.stub', 'recursivecachingiterator' => 'stubs/ext/spl/RecursiveCachingIterator.stub', 'recursivecallbackfilteriterator' => 'stubs/ext/spl/RecursiveCallbackFilterIterator.stub', 'recursivedirectoryiterator' => 'stubs/ext/spl/RecursiveDirectoryIterator.stub', 'recursivefilteriterator' => 'stubs/ext/spl/RecursiveFilterIterator.stub', 'recursiveiterator' => 'stubs/ext/spl/RecursiveIterator.stub', 'recursiveiteratoriterator' => 'stubs/ext/spl/RecursiveIteratorIterator.stub', 'recursiveregexiterator' => 'stubs/ext/spl/RecursiveRegexIterator.stub', 'recursivetreeiterator' => 'stubs/ext/spl/RecursiveTreeIterator.stub', 'reflection' => 'stubs/ext/reflection/Reflection.stub', 'reflectionattribute' => 'stubs/ext/reflection/ReflectionAttribute.stub', 'reflectionclass' => 'stubs/ext/reflection/ReflectionClass.stub', 'reflectionclassconstant' => 'stubs/ext/reflection/ReflectionClassConstant.stub', 'reflectionexception' => 'stubs/ext/reflection/ReflectionException.stub', 'reflectionextension' => 'stubs/ext/reflection/ReflectionExtension.stub', 'reflectionfunction' => 'stubs/ext/reflection/ReflectionFunction.stub', 'reflectionfunctionabstract' => 'stubs/ext/reflection/ReflectionFunctionAbstract.stub', 'reflectiongenerator' => 'stubs/ext/reflection/ReflectionGenerator.stub', 'reflectionmethod' => 'stubs/ext/reflection/ReflectionMethod.stub', 'reflectionnamedtype' => 'stubs/ext/reflection/ReflectionNamedType.stub', 'reflectionobject' => 'stubs/ext/reflection/ReflectionObject.stub', 'reflectionparameter' => 'stubs/ext/reflection/ReflectionParameter.stub', 'reflectionproperty' => 'stubs/ext/reflection/ReflectionProperty.stub', 'reflectionreference' => 'stubs/ext/reflection/ReflectionReference.stub', 'reflectiontype' => 'stubs/ext/reflection/ReflectionType.stub', 'reflectionuniontype' => 'stubs/ext/reflection/ReflectionUnionType.stub', 'reflectionzendextension' => 'stubs/ext/reflection/ReflectionZendExtension.stub', 'reflector' => 'stubs/ext/reflection/Reflector.stub', 'regexiterator' => 'stubs/ext/spl/RegexIterator.stub', 'resourcebundle' => 'stubs/ext/intl/resourcebundle/ResourceBundle.stub', 'seekableiterator' => 'stubs/ext/spl/SeekableIterator.stub', 'serializable' => 'stubs/Zend/Serializable.stub', 'sessionhandler' => 'stubs/ext/session/SessionHandler.stub', 'sessionhandlerinterface' => 'stubs/ext/session/SessionHandlerInterface.stub', 'sessionidinterface' => 'stubs/ext/session/SessionIdInterface.stub', 'sessionupdatetimestamphandlerinterface' => 'stubs/ext/session/SessionUpdateTimestampHandlerInterface.stub', 'shmop' => 'stubs/ext/shmop/Shmop.stub', 'simplexmlelement' => 'stubs/ext/simplexml/SimpleXMLElement.stub', 'simplexmliterator' => 'stubs/ext/simplexml/SimpleXMLIterator.stub', 'snmp' => 'stubs/ext/snmp/SNMP.stub', 'snmpexception' => 'stubs/ext/snmp/SNMPException.stub', 'soapclient' => 'stubs/ext/soap/SoapClient.stub', 'soapfault' => 'stubs/ext/soap/SoapFault.stub', 'soapheader' => 'stubs/ext/soap/SoapHeader.stub', 'soapparam' => 'stubs/ext/soap/SoapParam.stub', 'soapserver' => 'stubs/ext/soap/SoapServer.stub', 'soapvar' => 'stubs/ext/soap/SoapVar.stub', 'socket' => 'stubs/ext/sockets/Socket.stub', 'sodiumexception' => 'stubs/ext/sodium/SodiumException.stub', 'spldoublylinkedlist' => 'stubs/ext/spl/SplDoublyLinkedList.stub', 'splfileinfo' => 'stubs/ext/spl/SplFileInfo.stub', 'splfileobject' => 'stubs/ext/spl/SplFileObject.stub', 'splfixedarray' => 'stubs/ext/spl/SplFixedArray.stub', 'splheap' => 'stubs/ext/spl/SplHeap.stub', 'splmaxheap' => 'stubs/ext/spl/SplMaxHeap.stub', 'splminheap' => 'stubs/ext/spl/SplMinHeap.stub', 'splobjectstorage' => 'stubs/ext/spl/SplObjectStorage.stub', 'splobserver' => 'stubs/ext/spl/SplObserver.stub', 'splpriorityqueue' => 'stubs/ext/spl/SplPriorityQueue.stub', 'splqueue' => 'stubs/ext/spl/SplQueue.stub', 'splstack' => 'stubs/ext/spl/SplStack.stub', 'splsubject' => 'stubs/ext/spl/SplSubject.stub', 'spltempfileobject' => 'stubs/ext/spl/SplTempFileObject.stub', 'spoofchecker' => 'stubs/ext/intl/spoofchecker/Spoofchecker.stub', 'sqlite3' => 'stubs/ext/sqlite3/SQLite3.stub', 'sqlite3result' => 'stubs/ext/sqlite3/SQLite3Result.stub', 'sqlite3stmt' => 'stubs/ext/sqlite3/SQLite3Stmt.stub', 'stringable' => 'stubs/Zend/Stringable.stub', 'sysvmessagequeue' => 'stubs/ext/sysvmsg/SysvMessageQueue.stub', 'sysvsemaphore' => 'stubs/ext/sysvsem/SysvSemaphore.stub', 'sysvsharedmemory' => 'stubs/ext/sysvshm/SysvSharedMemory.stub', 'throwable' => 'stubs/Zend/Throwable.stub', 'tidy' => 'stubs/ext/tidy/tidy.stub', 'tidynode' => 'stubs/ext/tidy/tidyNode.stub', 'transliterator' => 'stubs/ext/intl/transliterator/Transliterator.stub', 'traversable' => 'stubs/Zend/Traversable.stub', 'typeerror' => 'stubs/Zend/TypeError.stub', 'uconverter' => 'stubs/ext/intl/converter/UConverter.stub', 'unhandledmatcherror' => 'stubs/Zend/UnhandledMatchError.stub', 'valueerror' => 'stubs/Zend/ValueError.stub', 'variant' => 'stubs/ext/com_dotnet/variant.stub', 'weakmap' => 'stubs/Zend/WeakMap.stub', 'weakreference' => 'stubs/Zend/WeakReference.stub', 'xmlparser' => 'stubs/ext/xml/XMLParser.stub', 'xmlreader' => 'stubs/ext/xmlreader/XMLReader.stub', 'xmlwriter' => 'stubs/ext/xmlwriter/XMLWriter.stub', 'xsltprocessor' => 'stubs/ext/xsl/XSLTProcessor.stub', 'ziparchive' => 'stubs/ext/zip/ZipArchive.stub'];
        $functions = ['_' => 'stubs/ext/gettext/_.stub', 'abs' => 'stubs/ext/standard/abs.stub', 'acos' => 'stubs/ext/standard/acos.stub', 'acosh' => 'stubs/ext/standard/acosh.stub', 'addcslashes' => 'stubs/ext/standard/addcslashes.stub', 'addslashes' => 'stubs/ext/standard/addslashes.stub', 'apache_child_terminate' => 'stubs/sapi/cgi/apache_child_terminate.stub', 'apache_get_modules' => 'stubs/sapi/apache2handler/apache_get_modules.stub', 'apache_get_version' => 'stubs/sapi/apache2handler/apache_get_version.stub', 'apache_getenv' => 'stubs/sapi/apache2handler/apache_getenv.stub', 'apache_lookup_uri' => 'stubs/sapi/apache2handler/apache_lookup_uri.stub', 'apache_note' => 'stubs/sapi/apache2handler/apache_note.stub', 'apache_request_headers' => 'stubs/sapi/apache2handler/apache_request_headers.stub', 'apache_response_headers' => 'stubs/sapi/apache2handler/apache_response_headers.stub', 'apache_setenv' => 'stubs/sapi/apache2handler/apache_setenv.stub', 'array_change_key_case' => 'stubs/ext/standard/array_change_key_case.stub', 'array_chunk' => 'stubs/ext/standard/array_chunk.stub', 'array_column' => 'stubs/ext/standard/array_column.stub', 'array_combine' => 'stubs/ext/standard/array_combine.stub', 'array_count_values' => 'stubs/ext/standard/array_count_values.stub', 'array_diff' => 'stubs/ext/standard/array_diff.stub', 'array_diff_assoc' => 'stubs/ext/standard/array_diff_assoc.stub', 'array_diff_key' => 'stubs/ext/standard/array_diff_key.stub', 'array_diff_uassoc' => 'stubs/ext/standard/array_diff_uassoc.stub', 'array_diff_ukey' => 'stubs/ext/standard/array_diff_ukey.stub', 'array_fill' => 'stubs/ext/standard/array_fill.stub', 'array_fill_keys' => 'stubs/ext/standard/array_fill_keys.stub', 'array_filter' => 'stubs/ext/standard/array_filter.stub', 'array_flip' => 'stubs/ext/standard/array_flip.stub', 'array_intersect' => 'stubs/ext/standard/array_intersect.stub', 'array_intersect_assoc' => 'stubs/ext/standard/array_intersect_assoc.stub', 'array_intersect_key' => 'stubs/ext/standard/array_intersect_key.stub', 'array_intersect_uassoc' => 'stubs/ext/standard/array_intersect_uassoc.stub', 'array_intersect_ukey' => 'stubs/ext/standard/array_intersect_ukey.stub', 'array_key_exists' => 'stubs/ext/standard/array_key_exists.stub', 'array_key_first' => 'stubs/ext/standard/array_key_first.stub', 'array_key_last' => 'stubs/ext/standard/array_key_last.stub', 'array_keys' => 'stubs/ext/standard/array_keys.stub', 'array_map' => 'stubs/ext/standard/array_map.stub', 'array_merge' => 'stubs/ext/standard/array_merge.stub', 'array_merge_recursive' => 'stubs/ext/standard/array_merge_recursive.stub', 'array_multisort' => 'stubs/ext/standard/array_multisort.stub', 'array_pad' => 'stubs/ext/standard/array_pad.stub', 'array_pop' => 'stubs/ext/standard/array_pop.stub', 'array_product' => 'stubs/ext/standard/array_product.stub', 'array_push' => 'stubs/ext/standard/array_push.stub', 'array_rand' => 'stubs/ext/standard/array_rand.stub', 'array_reduce' => 'stubs/ext/standard/array_reduce.stub', 'array_replace' => 'stubs/ext/standard/array_replace.stub', 'array_replace_recursive' => 'stubs/ext/standard/array_replace_recursive.stub', 'array_reverse' => 'stubs/ext/standard/array_reverse.stub', 'array_search' => 'stubs/ext/standard/array_search.stub', 'array_shift' => 'stubs/ext/standard/array_shift.stub', 'array_slice' => 'stubs/ext/standard/array_slice.stub', 'array_splice' => 'stubs/ext/standard/array_splice.stub', 'array_sum' => 'stubs/ext/standard/array_sum.stub', 'array_udiff' => 'stubs/ext/standard/array_udiff.stub', 'array_udiff_assoc' => 'stubs/ext/standard/array_udiff_assoc.stub', 'array_udiff_uassoc' => 'stubs/ext/standard/array_udiff_uassoc.stub', 'array_uintersect' => 'stubs/ext/standard/array_uintersect.stub', 'array_uintersect_assoc' => 'stubs/ext/standard/array_uintersect_assoc.stub', 'array_uintersect_uassoc' => 'stubs/ext/standard/array_uintersect_uassoc.stub', 'array_unique' => 'stubs/ext/standard/array_unique.stub', 'array_unshift' => 'stubs/ext/standard/array_unshift.stub', 'array_values' => 'stubs/ext/standard/array_values.stub', 'array_walk' => 'stubs/ext/standard/array_walk.stub', 'array_walk_recursive' => 'stubs/ext/standard/array_walk_recursive.stub', 'arsort' => 'stubs/ext/standard/arsort.stub', 'asin' => 'stubs/ext/standard/asin.stub', 'asinh' => 'stubs/ext/standard/asinh.stub', 'asort' => 'stubs/ext/standard/asort.stub', 'assert' => 'stubs/ext/standard/assert.stub', 'assert_options' => 'stubs/ext/standard/assert_options.stub', 'atan' => 'stubs/ext/standard/atan.stub', 'atan2' => 'stubs/ext/standard/atan2.stub', 'atanh' => 'stubs/ext/standard/atanh.stub', 'base64_decode' => 'stubs/ext/standard/base64_decode.stub', 'base64_encode' => 'stubs/ext/standard/base64_encode.stub', 'base_convert' => 'stubs/ext/standard/base_convert.stub', 'basename' => 'stubs/ext/standard/basename.stub', 'bcadd' => 'stubs/ext/bcmath/bcadd.stub', 'bccomp' => 'stubs/ext/bcmath/bccomp.stub', 'bcdiv' => 'stubs/ext/bcmath/bcdiv.stub', 'bcmod' => 'stubs/ext/bcmath/bcmod.stub', 'bcmul' => 'stubs/ext/bcmath/bcmul.stub', 'bcpow' => 'stubs/ext/bcmath/bcpow.stub', 'bcpowmod' => 'stubs/ext/bcmath/bcpowmod.stub', 'bcscale' => 'stubs/ext/bcmath/bcscale.stub', 'bcsqrt' => 'stubs/ext/bcmath/bcsqrt.stub', 'bcsub' => 'stubs/ext/bcmath/bcsub.stub', 'bin2hex' => 'stubs/ext/standard/bin2hex.stub', 'bind_textdomain_codeset' => 'stubs/ext/gettext/bind_textdomain_codeset.stub', 'bindec' => 'stubs/ext/standard/bindec.stub', 'bindtextdomain' => 'stubs/ext/gettext/bindtextdomain.stub', 'boolval' => 'stubs/ext/standard/boolval.stub', 'bzclose' => 'stubs/ext/bz2/bzclose.stub', 'bzcompress' => 'stubs/ext/bz2/bzcompress.stub', 'bzdecompress' => 'stubs/ext/bz2/bzdecompress.stub', 'bzerrno' => 'stubs/ext/bz2/bzerrno.stub', 'bzerror' => 'stubs/ext/bz2/bzerror.stub', 'bzerrstr' => 'stubs/ext/bz2/bzerrstr.stub', 'bzflush' => 'stubs/ext/bz2/bzflush.stub', 'bzopen' => 'stubs/ext/bz2/bzopen.stub', 'bzread' => 'stubs/ext/bz2/bzread.stub', 'bzwrite' => 'stubs/ext/bz2/bzwrite.stub', 'cal_days_in_month' => 'stubs/ext/calendar/cal_days_in_month.stub', 'cal_from_jd' => 'stubs/ext/calendar/cal_from_jd.stub', 'cal_info' => 'stubs/ext/calendar/cal_info.stub', 'cal_to_jd' => 'stubs/ext/calendar/cal_to_jd.stub', 'call_user_func' => 'stubs/ext/standard/call_user_func.stub', 'call_user_func_array' => 'stubs/ext/standard/call_user_func_array.stub', 'ceil' => 'stubs/ext/standard/ceil.stub', 'chdir' => 'stubs/ext/standard/chdir.stub', 'checkdate' => 'stubs/ext/date/checkdate.stub', 'checkdnsrr' => 'stubs/ext/standard/checkdnsrr.stub', 'chgrp' => 'stubs/ext/standard/chgrp.stub', 'chmod' => 'stubs/ext/standard/chmod.stub', 'chop' => 'stubs/ext/standard/chop.stub', 'chown' => 'stubs/ext/standard/chown.stub', 'chr' => 'stubs/ext/standard/chr.stub', 'chroot' => 'stubs/ext/standard/chroot.stub', 'chunk_split' => 'stubs/ext/standard/chunk_split.stub', 'class_alias' => 'stubs/Zend/class_alias.stub', 'class_exists' => 'stubs/Zend/class_exists.stub', 'class_implements' => 'stubs/ext/spl/class_implements.stub', 'class_parents' => 'stubs/ext/spl/class_parents.stub', 'class_uses' => 'stubs/ext/spl/class_uses.stub', 'clearstatcache' => 'stubs/ext/standard/clearstatcache.stub', 'cli_get_process_title' => 'stubs/sapi/cli/cli_get_process_title.stub', 'cli_set_process_title' => 'stubs/sapi/cli/cli_set_process_title.stub', 'closedir' => 'stubs/ext/standard/closedir.stub', 'closelog' => 'stubs/ext/standard/closelog.stub', 'collator_asort' => 'stubs/ext/intl/collator_asort.stub', 'collator_compare' => 'stubs/ext/intl/collator_compare.stub', 'collator_create' => 'stubs/ext/intl/collator_create.stub', 'collator_get_attribute' => 'stubs/ext/intl/collator_get_attribute.stub', 'collator_get_error_code' => 'stubs/ext/intl/collator_get_error_code.stub', 'collator_get_error_message' => 'stubs/ext/intl/collator_get_error_message.stub', 'collator_get_locale' => 'stubs/ext/intl/collator_get_locale.stub', 'collator_get_sort_key' => 'stubs/ext/intl/collator_get_sort_key.stub', 'collator_get_strength' => 'stubs/ext/intl/collator_get_strength.stub', 'collator_set_attribute' => 'stubs/ext/intl/collator_set_attribute.stub', 'collator_set_strength' => 'stubs/ext/intl/collator_set_strength.stub', 'collator_sort' => 'stubs/ext/intl/collator_sort.stub', 'collator_sort_with_sort_keys' => 'stubs/ext/intl/collator_sort_with_sort_keys.stub', 'com_create_guid' => 'stubs/ext/com_dotnet/com_create_guid.stub', 'com_event_sink' => 'stubs/ext/com_dotnet/com_event_sink.stub', 'com_get_active_object' => 'stubs/ext/com_dotnet/com_get_active_object.stub', 'com_load_typelib' => 'stubs/ext/com_dotnet/com_load_typelib.stub', 'com_message_pump' => 'stubs/ext/com_dotnet/com_message_pump.stub', 'com_print_typeinfo' => 'stubs/ext/com_dotnet/com_print_typeinfo.stub', 'compact' => 'stubs/ext/standard/compact.stub', 'config_get_hash' => 'stubs/ext/standard/config_get_hash.stub', 'connection_aborted' => 'stubs/ext/standard/connection_aborted.stub', 'connection_status' => 'stubs/ext/standard/connection_status.stub', 'constant' => 'stubs/ext/standard/constant.stub', 'convert_uudecode' => 'stubs/ext/standard/convert_uudecode.stub', 'convert_uuencode' => 'stubs/ext/standard/convert_uuencode.stub', 'copy' => 'stubs/ext/standard/copy.stub', 'cos' => 'stubs/ext/standard/cos.stub', 'cosh' => 'stubs/ext/standard/cosh.stub', 'count' => 'stubs/ext/standard/count.stub', 'count_chars' => 'stubs/ext/standard/count_chars.stub', 'crc32' => 'stubs/ext/standard/crc32.stub', 'crypt' => 'stubs/ext/standard/crypt.stub', 'ctype_alnum' => 'stubs/ext/ctype/ctype_alnum.stub', 'ctype_alpha' => 'stubs/ext/ctype/ctype_alpha.stub', 'ctype_cntrl' => 'stubs/ext/ctype/ctype_cntrl.stub', 'ctype_digit' => 'stubs/ext/ctype/ctype_digit.stub', 'ctype_graph' => 'stubs/ext/ctype/ctype_graph.stub', 'ctype_lower' => 'stubs/ext/ctype/ctype_lower.stub', 'ctype_print' => 'stubs/ext/ctype/ctype_print.stub', 'ctype_punct' => 'stubs/ext/ctype/ctype_punct.stub', 'ctype_space' => 'stubs/ext/ctype/ctype_space.stub', 'ctype_upper' => 'stubs/ext/ctype/ctype_upper.stub', 'ctype_xdigit' => 'stubs/ext/ctype/ctype_xdigit.stub', 'curl_close' => 'stubs/ext/curl/curl_close.stub', 'curl_copy_handle' => 'stubs/ext/curl/curl_copy_handle.stub', 'curl_errno' => 'stubs/ext/curl/curl_errno.stub', 'curl_error' => 'stubs/ext/curl/curl_error.stub', 'curl_escape' => 'stubs/ext/curl/curl_escape.stub', 'curl_exec' => 'stubs/ext/curl/curl_exec.stub', 'curl_file_create' => 'stubs/ext/curl/curl_file_create.stub', 'curl_getinfo' => 'stubs/ext/curl/curl_getinfo.stub', 'curl_init' => 'stubs/ext/curl/curl_init.stub', 'curl_multi_add_handle' => 'stubs/ext/curl/curl_multi_add_handle.stub', 'curl_multi_close' => 'stubs/ext/curl/curl_multi_close.stub', 'curl_multi_errno' => 'stubs/ext/curl/curl_multi_errno.stub', 'curl_multi_exec' => 'stubs/ext/curl/curl_multi_exec.stub', 'curl_multi_getcontent' => 'stubs/ext/curl/curl_multi_getcontent.stub', 'curl_multi_info_read' => 'stubs/ext/curl/curl_multi_info_read.stub', 'curl_multi_init' => 'stubs/ext/curl/curl_multi_init.stub', 'curl_multi_remove_handle' => 'stubs/ext/curl/curl_multi_remove_handle.stub', 'curl_multi_select' => 'stubs/ext/curl/curl_multi_select.stub', 'curl_multi_setopt' => 'stubs/ext/curl/curl_multi_setopt.stub', 'curl_multi_strerror' => 'stubs/ext/curl/curl_multi_strerror.stub', 'curl_pause' => 'stubs/ext/curl/curl_pause.stub', 'curl_reset' => 'stubs/ext/curl/curl_reset.stub', 'curl_setopt' => 'stubs/ext/curl/curl_setopt.stub', 'curl_setopt_array' => 'stubs/ext/curl/curl_setopt_array.stub', 'curl_share_close' => 'stubs/ext/curl/curl_share_close.stub', 'curl_share_errno' => 'stubs/ext/curl/curl_share_errno.stub', 'curl_share_init' => 'stubs/ext/curl/curl_share_init.stub', 'curl_share_setopt' => 'stubs/ext/curl/curl_share_setopt.stub', 'curl_share_strerror' => 'stubs/ext/curl/curl_share_strerror.stub', 'curl_strerror' => 'stubs/ext/curl/curl_strerror.stub', 'curl_unescape' => 'stubs/ext/curl/curl_unescape.stub', 'curl_version' => 'stubs/ext/curl/curl_version.stub', 'current' => 'stubs/ext/standard/current.stub', 'date' => 'stubs/ext/date/date.stub', 'date_add' => 'stubs/ext/date/date_add.stub', 'date_create' => 'stubs/ext/date/date_create.stub', 'date_create_from_format' => 'stubs/ext/date/date_create_from_format.stub', 'date_create_immutable' => 'stubs/ext/date/date_create_immutable.stub', 'date_create_immutable_from_format' => 'stubs/ext/date/date_create_immutable_from_format.stub', 'date_date_set' => 'stubs/ext/date/date_date_set.stub', 'date_default_timezone_get' => 'stubs/ext/date/date_default_timezone_get.stub', 'date_default_timezone_set' => 'stubs/ext/date/date_default_timezone_set.stub', 'date_diff' => 'stubs/ext/date/date_diff.stub', 'date_format' => 'stubs/ext/date/date_format.stub', 'date_get_last_errors' => 'stubs/ext/date/date_get_last_errors.stub', 'date_interval_create_from_date_string' => 'stubs/ext/date/date_interval_create_from_date_string.stub', 'date_interval_format' => 'stubs/ext/date/date_interval_format.stub', 'date_isodate_set' => 'stubs/ext/date/date_isodate_set.stub', 'date_modify' => 'stubs/ext/date/date_modify.stub', 'date_offset_get' => 'stubs/ext/date/date_offset_get.stub', 'date_parse' => 'stubs/ext/date/date_parse.stub', 'date_parse_from_format' => 'stubs/ext/date/date_parse_from_format.stub', 'date_sub' => 'stubs/ext/date/date_sub.stub', 'date_sun_info' => 'stubs/ext/date/date_sun_info.stub', 'date_sunrise' => 'stubs/ext/date/date_sunrise.stub', 'date_sunset' => 'stubs/ext/date/date_sunset.stub', 'date_time_set' => 'stubs/ext/date/date_time_set.stub', 'date_timestamp_get' => 'stubs/ext/date/date_timestamp_get.stub', 'date_timestamp_set' => 'stubs/ext/date/date_timestamp_set.stub', 'date_timezone_get' => 'stubs/ext/date/date_timezone_get.stub', 'date_timezone_set' => 'stubs/ext/date/date_timezone_set.stub', 'datefmt_create' => 'stubs/ext/intl/datefmt_create.stub', 'datefmt_format' => 'stubs/ext/intl/datefmt_format.stub', 'datefmt_format_object' => 'stubs/ext/intl/datefmt_format_object.stub', 'datefmt_get_calendar' => 'stubs/ext/intl/datefmt_get_calendar.stub', 'datefmt_get_calendar_object' => 'stubs/ext/intl/datefmt_get_calendar_object.stub', 'datefmt_get_datetype' => 'stubs/ext/intl/datefmt_get_datetype.stub', 'datefmt_get_error_code' => 'stubs/ext/intl/datefmt_get_error_code.stub', 'datefmt_get_error_message' => 'stubs/ext/intl/datefmt_get_error_message.stub', 'datefmt_get_locale' => 'stubs/ext/intl/datefmt_get_locale.stub', 'datefmt_get_pattern' => 'stubs/ext/intl/datefmt_get_pattern.stub', 'datefmt_get_timetype' => 'stubs/ext/intl/datefmt_get_timetype.stub', 'datefmt_get_timezone' => 'stubs/ext/intl/datefmt_get_timezone.stub', 'datefmt_get_timezone_id' => 'stubs/ext/intl/datefmt_get_timezone_id.stub', 'datefmt_is_lenient' => 'stubs/ext/intl/datefmt_is_lenient.stub', 'datefmt_localtime' => 'stubs/ext/intl/datefmt_localtime.stub', 'datefmt_parse' => 'stubs/ext/intl/datefmt_parse.stub', 'datefmt_set_calendar' => 'stubs/ext/intl/datefmt_set_calendar.stub', 'datefmt_set_lenient' => 'stubs/ext/intl/datefmt_set_lenient.stub', 'datefmt_set_pattern' => 'stubs/ext/intl/datefmt_set_pattern.stub', 'datefmt_set_timezone' => 'stubs/ext/intl/datefmt_set_timezone.stub', 'dba_close' => 'stubs/ext/dba/dba_close.stub', 'dba_delete' => 'stubs/ext/dba/dba_delete.stub', 'dba_exists' => 'stubs/ext/dba/dba_exists.stub', 'dba_fetch' => 'stubs/ext/dba/dba_fetch.stub', 'dba_firstkey' => 'stubs/ext/dba/dba_firstkey.stub', 'dba_handlers' => 'stubs/ext/dba/dba_handlers.stub', 'dba_insert' => 'stubs/ext/dba/dba_insert.stub', 'dba_key_split' => 'stubs/ext/dba/dba_key_split.stub', 'dba_list' => 'stubs/ext/dba/dba_list.stub', 'dba_nextkey' => 'stubs/ext/dba/dba_nextkey.stub', 'dba_open' => 'stubs/ext/dba/dba_open.stub', 'dba_optimize' => 'stubs/ext/dba/dba_optimize.stub', 'dba_popen' => 'stubs/ext/dba/dba_popen.stub', 'dba_replace' => 'stubs/ext/dba/dba_replace.stub', 'dba_sync' => 'stubs/ext/dba/dba_sync.stub', 'dcgettext' => 'stubs/ext/gettext/dcgettext.stub', 'dcngettext' => 'stubs/ext/gettext/dcngettext.stub', 'debug_backtrace' => 'stubs/Zend/debug_backtrace.stub', 'debug_print_backtrace' => 'stubs/Zend/debug_print_backtrace.stub', 'debug_zval_dump' => 'stubs/ext/standard/debug_zval_dump.stub', 'decbin' => 'stubs/ext/standard/decbin.stub', 'dechex' => 'stubs/ext/standard/dechex.stub', 'decoct' => 'stubs/ext/standard/decoct.stub', 'define' => 'stubs/Zend/define.stub', 'defined' => 'stubs/Zend/defined.stub', 'deflate_add' => 'stubs/ext/zlib/deflate_add.stub', 'deflate_init' => 'stubs/ext/zlib/deflate_init.stub', 'deg2rad' => 'stubs/ext/standard/deg2rad.stub', 'dgettext' => 'stubs/ext/gettext/dgettext.stub', 'dir' => 'stubs/ext/standard/dir.stub', 'dirname' => 'stubs/ext/standard/dirname.stub', 'disk_free_space' => 'stubs/ext/standard/disk_free_space.stub', 'disk_total_space' => 'stubs/ext/standard/disk_total_space.stub', 'diskfreespace' => 'stubs/ext/standard/diskfreespace.stub', 'dl' => 'stubs/ext/standard/dl.stub', 'dngettext' => 'stubs/ext/gettext/dngettext.stub', 'dns_check_record' => 'stubs/ext/standard/dns_check_record.stub', 'dns_get_mx' => 'stubs/ext/standard/dns_get_mx.stub', 'dns_get_record' => 'stubs/ext/standard/dns_get_record.stub', 'dom_import_simplexml' => 'stubs/ext/dom/dom_import_simplexml.stub', 'doubleval' => 'stubs/ext/standard/doubleval.stub', 'easter_date' => 'stubs/ext/calendar/easter_date.stub', 'easter_days' => 'stubs/ext/calendar/easter_days.stub', 'enchant_broker_describe' => 'stubs/ext/enchant/enchant_broker_describe.stub', 'enchant_broker_dict_exists' => 'stubs/ext/enchant/enchant_broker_dict_exists.stub', 'enchant_broker_free' => 'stubs/ext/enchant/enchant_broker_free.stub', 'enchant_broker_free_dict' => 'stubs/ext/enchant/enchant_broker_free_dict.stub', 'enchant_broker_get_dict_path' => 'stubs/ext/enchant/enchant_broker_get_dict_path.stub', 'enchant_broker_get_error' => 'stubs/ext/enchant/enchant_broker_get_error.stub', 'enchant_broker_init' => 'stubs/ext/enchant/enchant_broker_init.stub', 'enchant_broker_list_dicts' => 'stubs/ext/enchant/enchant_broker_list_dicts.stub', 'enchant_broker_request_dict' => 'stubs/ext/enchant/enchant_broker_request_dict.stub', 'enchant_broker_request_pwl_dict' => 'stubs/ext/enchant/enchant_broker_request_pwl_dict.stub', 'enchant_broker_set_dict_path' => 'stubs/ext/enchant/enchant_broker_set_dict_path.stub', 'enchant_broker_set_ordering' => 'stubs/ext/enchant/enchant_broker_set_ordering.stub', 'enchant_dict_add' => 'stubs/ext/enchant/enchant_dict_add.stub', 'enchant_dict_add_to_personal' => 'stubs/ext/enchant/enchant_dict_add_to_personal.stub', 'enchant_dict_add_to_session' => 'stubs/ext/enchant/enchant_dict_add_to_session.stub', 'enchant_dict_check' => 'stubs/ext/enchant/enchant_dict_check.stub', 'enchant_dict_describe' => 'stubs/ext/enchant/enchant_dict_describe.stub', 'enchant_dict_get_error' => 'stubs/ext/enchant/enchant_dict_get_error.stub', 'enchant_dict_is_added' => 'stubs/ext/enchant/enchant_dict_is_added.stub', 'enchant_dict_is_in_session' => 'stubs/ext/enchant/enchant_dict_is_in_session.stub', 'enchant_dict_quick_check' => 'stubs/ext/enchant/enchant_dict_quick_check.stub', 'enchant_dict_store_replacement' => 'stubs/ext/enchant/enchant_dict_store_replacement.stub', 'enchant_dict_suggest' => 'stubs/ext/enchant/enchant_dict_suggest.stub', 'end' => 'stubs/ext/standard/end.stub', 'error_clear_last' => 'stubs/ext/standard/error_clear_last.stub', 'error_get_last' => 'stubs/ext/standard/error_get_last.stub', 'error_log' => 'stubs/ext/standard/error_log.stub', 'error_reporting' => 'stubs/Zend/error_reporting.stub', 'escapeshellarg' => 'stubs/ext/standard/escapeshellarg.stub', 'escapeshellcmd' => 'stubs/ext/standard/escapeshellcmd.stub', 'exec' => 'stubs/ext/standard/exec.stub', 'exif_imagetype' => 'stubs/ext/exif/exif_imagetype.stub', 'exif_read_data' => 'stubs/ext/exif/exif_read_data.stub', 'exif_tagname' => 'stubs/ext/exif/exif_tagname.stub', 'exif_thumbnail' => 'stubs/ext/exif/exif_thumbnail.stub', 'exp' => 'stubs/ext/standard/exp.stub', 'explode' => 'stubs/ext/standard/explode.stub', 'expm1' => 'stubs/ext/standard/expm1.stub', 'extension_loaded' => 'stubs/Zend/extension_loaded.stub', 'extract' => 'stubs/ext/standard/extract.stub', 'fastcgi_finish_request' => 'stubs/sapi/fpm/fpm/fastcgi_finish_request.stub', 'fclose' => 'stubs/ext/standard/fclose.stub', 'fdiv' => 'stubs/ext/standard/fdiv.stub', 'feof' => 'stubs/ext/standard/feof.stub', 'fflush' => 'stubs/ext/standard/fflush.stub', 'fgetc' => 'stubs/ext/standard/fgetc.stub', 'fgetcsv' => 'stubs/ext/standard/fgetcsv.stub', 'fgets' => 'stubs/ext/standard/fgets.stub', 'file' => 'stubs/ext/standard/file.stub', 'file_exists' => 'stubs/ext/standard/file_exists.stub', 'file_get_contents' => 'stubs/ext/standard/file_get_contents.stub', 'file_put_contents' => 'stubs/ext/standard/file_put_contents.stub', 'fileatime' => 'stubs/ext/standard/fileatime.stub', 'filectime' => 'stubs/ext/standard/filectime.stub', 'filegroup' => 'stubs/ext/standard/filegroup.stub', 'fileinode' => 'stubs/ext/standard/fileinode.stub', 'filemtime' => 'stubs/ext/standard/filemtime.stub', 'fileowner' => 'stubs/ext/standard/fileowner.stub', 'fileperms' => 'stubs/ext/standard/fileperms.stub', 'filesize' => 'stubs/ext/standard/filesize.stub', 'filetype' => 'stubs/ext/standard/filetype.stub', 'filter_has_var' => 'stubs/ext/filter/filter_has_var.stub', 'filter_id' => 'stubs/ext/filter/filter_id.stub', 'filter_input' => 'stubs/ext/filter/filter_input.stub', 'filter_input_array' => 'stubs/ext/filter/filter_input_array.stub', 'filter_list' => 'stubs/ext/filter/filter_list.stub', 'filter_var' => 'stubs/ext/filter/filter_var.stub', 'filter_var_array' => 'stubs/ext/filter/filter_var_array.stub', 'finfo_buffer' => 'stubs/ext/fileinfo/finfo_buffer.stub', 'finfo_close' => 'stubs/ext/fileinfo/finfo_close.stub', 'finfo_file' => 'stubs/ext/fileinfo/finfo_file.stub', 'finfo_open' => 'stubs/ext/fileinfo/finfo_open.stub', 'finfo_set_flags' => 'stubs/ext/fileinfo/finfo_set_flags.stub', 'floatval' => 'stubs/ext/standard/floatval.stub', 'flock' => 'stubs/ext/standard/flock.stub', 'floor' => 'stubs/ext/standard/floor.stub', 'flush' => 'stubs/ext/standard/flush.stub', 'fmod' => 'stubs/ext/standard/fmod.stub', 'fnmatch' => 'stubs/ext/standard/fnmatch.stub', 'fopen' => 'stubs/ext/standard/fopen.stub', 'forward_static_call' => 'stubs/ext/standard/forward_static_call.stub', 'forward_static_call_array' => 'stubs/ext/standard/forward_static_call_array.stub', 'fpassthru' => 'stubs/ext/standard/fpassthru.stub', 'fpm_get_status' => 'stubs/sapi/fpm/fpm/fpm_get_status.stub', 'fprintf' => 'stubs/ext/standard/fprintf.stub', 'fputcsv' => 'stubs/ext/standard/fputcsv.stub', 'fputs' => 'stubs/ext/standard/fputs.stub', 'fread' => 'stubs/ext/standard/fread.stub', 'frenchtojd' => 'stubs/ext/calendar/frenchtojd.stub', 'fscanf' => 'stubs/ext/standard/fscanf.stub', 'fseek' => 'stubs/ext/standard/fseek.stub', 'fsockopen' => 'stubs/ext/standard/fsockopen.stub', 'fstat' => 'stubs/ext/standard/fstat.stub', 'ftell' => 'stubs/ext/standard/ftell.stub', 'ftok' => 'stubs/ext/standard/ftok.stub', 'ftp_alloc' => 'stubs/ext/ftp/ftp_alloc.stub', 'ftp_append' => 'stubs/ext/ftp/ftp_append.stub', 'ftp_cdup' => 'stubs/ext/ftp/ftp_cdup.stub', 'ftp_chdir' => 'stubs/ext/ftp/ftp_chdir.stub', 'ftp_chmod' => 'stubs/ext/ftp/ftp_chmod.stub', 'ftp_close' => 'stubs/ext/ftp/ftp_close.stub', 'ftp_connect' => 'stubs/ext/ftp/ftp_connect.stub', 'ftp_delete' => 'stubs/ext/ftp/ftp_delete.stub', 'ftp_exec' => 'stubs/ext/ftp/ftp_exec.stub', 'ftp_fget' => 'stubs/ext/ftp/ftp_fget.stub', 'ftp_fput' => 'stubs/ext/ftp/ftp_fput.stub', 'ftp_get' => 'stubs/ext/ftp/ftp_get.stub', 'ftp_get_option' => 'stubs/ext/ftp/ftp_get_option.stub', 'ftp_login' => 'stubs/ext/ftp/ftp_login.stub', 'ftp_mdtm' => 'stubs/ext/ftp/ftp_mdtm.stub', 'ftp_mkdir' => 'stubs/ext/ftp/ftp_mkdir.stub', 'ftp_mlsd' => 'stubs/ext/ftp/ftp_mlsd.stub', 'ftp_nb_continue' => 'stubs/ext/ftp/ftp_nb_continue.stub', 'ftp_nb_fget' => 'stubs/ext/ftp/ftp_nb_fget.stub', 'ftp_nb_fput' => 'stubs/ext/ftp/ftp_nb_fput.stub', 'ftp_nb_get' => 'stubs/ext/ftp/ftp_nb_get.stub', 'ftp_nb_put' => 'stubs/ext/ftp/ftp_nb_put.stub', 'ftp_nlist' => 'stubs/ext/ftp/ftp_nlist.stub', 'ftp_pasv' => 'stubs/ext/ftp/ftp_pasv.stub', 'ftp_put' => 'stubs/ext/ftp/ftp_put.stub', 'ftp_pwd' => 'stubs/ext/ftp/ftp_pwd.stub', 'ftp_quit' => 'stubs/ext/ftp/ftp_quit.stub', 'ftp_raw' => 'stubs/ext/ftp/ftp_raw.stub', 'ftp_rawlist' => 'stubs/ext/ftp/ftp_rawlist.stub', 'ftp_rename' => 'stubs/ext/ftp/ftp_rename.stub', 'ftp_rmdir' => 'stubs/ext/ftp/ftp_rmdir.stub', 'ftp_set_option' => 'stubs/ext/ftp/ftp_set_option.stub', 'ftp_site' => 'stubs/ext/ftp/ftp_site.stub', 'ftp_size' => 'stubs/ext/ftp/ftp_size.stub', 'ftp_ssl_connect' => 'stubs/ext/ftp/ftp_ssl_connect.stub', 'ftp_systype' => 'stubs/ext/ftp/ftp_systype.stub', 'ftruncate' => 'stubs/ext/standard/ftruncate.stub', 'func_get_arg' => 'stubs/Zend/func_get_arg.stub', 'func_get_args' => 'stubs/Zend/func_get_args.stub', 'func_num_args' => 'stubs/Zend/func_num_args.stub', 'function_exists' => 'stubs/Zend/function_exists.stub', 'fwrite' => 'stubs/ext/standard/fwrite.stub', 'gc_collect_cycles' => 'stubs/Zend/gc_collect_cycles.stub', 'gc_disable' => 'stubs/Zend/gc_disable.stub', 'gc_enable' => 'stubs/Zend/gc_enable.stub', 'gc_enabled' => 'stubs/Zend/gc_enabled.stub', 'gc_mem_caches' => 'stubs/Zend/gc_mem_caches.stub', 'gc_status' => 'stubs/Zend/gc_status.stub', 'gd_info' => 'stubs/ext/gd/gd_info.stub', 'get_browser' => 'stubs/ext/standard/get_browser.stub', 'get_called_class' => 'stubs/Zend/get_called_class.stub', 'get_cfg_var' => 'stubs/ext/standard/get_cfg_var.stub', 'get_class' => 'stubs/Zend/get_class.stub', 'get_class_methods' => 'stubs/Zend/get_class_methods.stub', 'get_class_vars' => 'stubs/Zend/get_class_vars.stub', 'get_current_user' => 'stubs/ext/standard/get_current_user.stub', 'get_debug_type' => 'stubs/ext/standard/get_debug_type.stub', 'get_declared_classes' => 'stubs/Zend/get_declared_classes.stub', 'get_declared_interfaces' => 'stubs/Zend/get_declared_interfaces.stub', 'get_declared_traits' => 'stubs/Zend/get_declared_traits.stub', 'get_defined_constants' => 'stubs/Zend/get_defined_constants.stub', 'get_defined_functions' => 'stubs/Zend/get_defined_functions.stub', 'get_defined_vars' => 'stubs/Zend/get_defined_vars.stub', 'get_extension_funcs' => 'stubs/Zend/get_extension_funcs.stub', 'get_headers' => 'stubs/ext/standard/get_headers.stub', 'get_html_translation_table' => 'stubs/ext/standard/get_html_translation_table.stub', 'get_include_path' => 'stubs/ext/standard/get_include_path.stub', 'get_included_files' => 'stubs/Zend/get_included_files.stub', 'get_loaded_extensions' => 'stubs/Zend/get_loaded_extensions.stub', 'get_mangled_object_vars' => 'stubs/Zend/get_mangled_object_vars.stub', 'get_meta_tags' => 'stubs/ext/standard/get_meta_tags.stub', 'get_object_vars' => 'stubs/Zend/get_object_vars.stub', 'get_parent_class' => 'stubs/Zend/get_parent_class.stub', 'get_required_files' => 'stubs/Zend/get_required_files.stub', 'get_resource_id' => 'stubs/Zend/get_resource_id.stub', 'get_resource_type' => 'stubs/Zend/get_resource_type.stub', 'get_resources' => 'stubs/Zend/get_resources.stub', 'getallheaders' => 'stubs/sapi/apache2handler/getallheaders.stub', 'getcwd' => 'stubs/ext/standard/getcwd.stub', 'getdate' => 'stubs/ext/date/getdate.stub', 'getenv' => 'stubs/ext/standard/getenv.stub', 'gethostbyaddr' => 'stubs/ext/standard/gethostbyaddr.stub', 'gethostbyname' => 'stubs/ext/standard/gethostbyname.stub', 'gethostbynamel' => 'stubs/ext/standard/gethostbynamel.stub', 'gethostname' => 'stubs/ext/standard/gethostname.stub', 'getimagesize' => 'stubs/ext/standard/getimagesize.stub', 'getimagesizefromstring' => 'stubs/ext/standard/getimagesizefromstring.stub', 'getlastmod' => 'stubs/ext/standard/getlastmod.stub', 'getmxrr' => 'stubs/ext/standard/getmxrr.stub', 'getmygid' => 'stubs/ext/standard/getmygid.stub', 'getmyinode' => 'stubs/ext/standard/getmyinode.stub', 'getmypid' => 'stubs/ext/standard/getmypid.stub', 'getmyuid' => 'stubs/ext/standard/getmyuid.stub', 'getopt' => 'stubs/ext/standard/getopt.stub', 'getprotobyname' => 'stubs/ext/standard/getprotobyname.stub', 'getprotobynumber' => 'stubs/ext/standard/getprotobynumber.stub', 'getrandmax' => 'stubs/ext/standard/getrandmax.stub', 'getrusage' => 'stubs/ext/standard/getrusage.stub', 'getservbyname' => 'stubs/ext/standard/getservbyname.stub', 'getservbyport' => 'stubs/ext/standard/getservbyport.stub', 'gettext' => 'stubs/ext/gettext/gettext.stub', 'gettimeofday' => 'stubs/ext/standard/gettimeofday.stub', 'gettype' => 'stubs/ext/standard/gettype.stub', 'glob' => 'stubs/ext/standard/glob.stub', 'gmdate' => 'stubs/ext/date/gmdate.stub', 'gmmktime' => 'stubs/ext/date/gmmktime.stub', 'gmp_abs' => 'stubs/ext/gmp/gmp_abs.stub', 'gmp_add' => 'stubs/ext/gmp/gmp_add.stub', 'gmp_and' => 'stubs/ext/gmp/gmp_and.stub', 'gmp_binomial' => 'stubs/ext/gmp/gmp_binomial.stub', 'gmp_clrbit' => 'stubs/ext/gmp/gmp_clrbit.stub', 'gmp_cmp' => 'stubs/ext/gmp/gmp_cmp.stub', 'gmp_com' => 'stubs/ext/gmp/gmp_com.stub', 'gmp_div' => 'stubs/ext/gmp/gmp_div.stub', 'gmp_div_q' => 'stubs/ext/gmp/gmp_div_q.stub', 'gmp_div_qr' => 'stubs/ext/gmp/gmp_div_qr.stub', 'gmp_div_r' => 'stubs/ext/gmp/gmp_div_r.stub', 'gmp_divexact' => 'stubs/ext/gmp/gmp_divexact.stub', 'gmp_export' => 'stubs/ext/gmp/gmp_export.stub', 'gmp_fact' => 'stubs/ext/gmp/gmp_fact.stub', 'gmp_gcd' => 'stubs/ext/gmp/gmp_gcd.stub', 'gmp_gcdext' => 'stubs/ext/gmp/gmp_gcdext.stub', 'gmp_hamdist' => 'stubs/ext/gmp/gmp_hamdist.stub', 'gmp_import' => 'stubs/ext/gmp/gmp_import.stub', 'gmp_init' => 'stubs/ext/gmp/gmp_init.stub', 'gmp_intval' => 'stubs/ext/gmp/gmp_intval.stub', 'gmp_invert' => 'stubs/ext/gmp/gmp_invert.stub', 'gmp_jacobi' => 'stubs/ext/gmp/gmp_jacobi.stub', 'gmp_kronecker' => 'stubs/ext/gmp/gmp_kronecker.stub', 'gmp_lcm' => 'stubs/ext/gmp/gmp_lcm.stub', 'gmp_legendre' => 'stubs/ext/gmp/gmp_legendre.stub', 'gmp_mod' => 'stubs/ext/gmp/gmp_mod.stub', 'gmp_mul' => 'stubs/ext/gmp/gmp_mul.stub', 'gmp_neg' => 'stubs/ext/gmp/gmp_neg.stub', 'gmp_nextprime' => 'stubs/ext/gmp/gmp_nextprime.stub', 'gmp_or' => 'stubs/ext/gmp/gmp_or.stub', 'gmp_perfect_power' => 'stubs/ext/gmp/gmp_perfect_power.stub', 'gmp_perfect_square' => 'stubs/ext/gmp/gmp_perfect_square.stub', 'gmp_popcount' => 'stubs/ext/gmp/gmp_popcount.stub', 'gmp_pow' => 'stubs/ext/gmp/gmp_pow.stub', 'gmp_powm' => 'stubs/ext/gmp/gmp_powm.stub', 'gmp_prob_prime' => 'stubs/ext/gmp/gmp_prob_prime.stub', 'gmp_random_bits' => 'stubs/ext/gmp/gmp_random_bits.stub', 'gmp_random_range' => 'stubs/ext/gmp/gmp_random_range.stub', 'gmp_random_seed' => 'stubs/ext/gmp/gmp_random_seed.stub', 'gmp_root' => 'stubs/ext/gmp/gmp_root.stub', 'gmp_rootrem' => 'stubs/ext/gmp/gmp_rootrem.stub', 'gmp_scan0' => 'stubs/ext/gmp/gmp_scan0.stub', 'gmp_scan1' => 'stubs/ext/gmp/gmp_scan1.stub', 'gmp_setbit' => 'stubs/ext/gmp/gmp_setbit.stub', 'gmp_sign' => 'stubs/ext/gmp/gmp_sign.stub', 'gmp_sqrt' => 'stubs/ext/gmp/gmp_sqrt.stub', 'gmp_sqrtrem' => 'stubs/ext/gmp/gmp_sqrtrem.stub', 'gmp_strval' => 'stubs/ext/gmp/gmp_strval.stub', 'gmp_sub' => 'stubs/ext/gmp/gmp_sub.stub', 'gmp_testbit' => 'stubs/ext/gmp/gmp_testbit.stub', 'gmp_xor' => 'stubs/ext/gmp/gmp_xor.stub', 'gmstrftime' => 'stubs/ext/date/gmstrftime.stub', 'grapheme_extract' => 'stubs/ext/intl/grapheme_extract.stub', 'grapheme_stripos' => 'stubs/ext/intl/grapheme_stripos.stub', 'grapheme_stristr' => 'stubs/ext/intl/grapheme_stristr.stub', 'grapheme_strlen' => 'stubs/ext/intl/grapheme_strlen.stub', 'grapheme_strpos' => 'stubs/ext/intl/grapheme_strpos.stub', 'grapheme_strripos' => 'stubs/ext/intl/grapheme_strripos.stub', 'grapheme_strrpos' => 'stubs/ext/intl/grapheme_strrpos.stub', 'grapheme_strstr' => 'stubs/ext/intl/grapheme_strstr.stub', 'grapheme_substr' => 'stubs/ext/intl/grapheme_substr.stub', 'gregoriantojd' => 'stubs/ext/calendar/gregoriantojd.stub', 'gzclose' => 'stubs/ext/zlib/gzclose.stub', 'gzcompress' => 'stubs/ext/zlib/gzcompress.stub', 'gzdecode' => 'stubs/ext/zlib/gzdecode.stub', 'gzdeflate' => 'stubs/ext/zlib/gzdeflate.stub', 'gzencode' => 'stubs/ext/zlib/gzencode.stub', 'gzeof' => 'stubs/ext/zlib/gzeof.stub', 'gzfile' => 'stubs/ext/zlib/gzfile.stub', 'gzgetc' => 'stubs/ext/zlib/gzgetc.stub', 'gzgets' => 'stubs/ext/zlib/gzgets.stub', 'gzinflate' => 'stubs/ext/zlib/gzinflate.stub', 'gzopen' => 'stubs/ext/zlib/gzopen.stub', 'gzpassthru' => 'stubs/ext/zlib/gzpassthru.stub', 'gzputs' => 'stubs/ext/zlib/gzputs.stub', 'gzread' => 'stubs/ext/zlib/gzread.stub', 'gzrewind' => 'stubs/ext/zlib/gzrewind.stub', 'gzseek' => 'stubs/ext/zlib/gzseek.stub', 'gztell' => 'stubs/ext/zlib/gztell.stub', 'gzuncompress' => 'stubs/ext/zlib/gzuncompress.stub', 'gzwrite' => 'stubs/ext/zlib/gzwrite.stub', 'hash' => 'stubs/ext/hash/hash.stub', 'hash_algos' => 'stubs/ext/hash/hash_algos.stub', 'hash_copy' => 'stubs/ext/hash/hash_copy.stub', 'hash_equals' => 'stubs/ext/hash/hash_equals.stub', 'hash_file' => 'stubs/ext/hash/hash_file.stub', 'hash_final' => 'stubs/ext/hash/hash_final.stub', 'hash_hkdf' => 'stubs/ext/hash/hash_hkdf.stub', 'hash_hmac' => 'stubs/ext/hash/hash_hmac.stub', 'hash_hmac_algos' => 'stubs/ext/hash/hash_hmac_algos.stub', 'hash_hmac_file' => 'stubs/ext/hash/hash_hmac_file.stub', 'hash_init' => 'stubs/ext/hash/hash_init.stub', 'hash_pbkdf2' => 'stubs/ext/hash/hash_pbkdf2.stub', 'hash_update' => 'stubs/ext/hash/hash_update.stub', 'hash_update_file' => 'stubs/ext/hash/hash_update_file.stub', 'hash_update_stream' => 'stubs/ext/hash/hash_update_stream.stub', 'header' => 'stubs/ext/standard/header.stub', 'header_register_callback' => 'stubs/ext/standard/header_register_callback.stub', 'header_remove' => 'stubs/ext/standard/header_remove.stub', 'headers_list' => 'stubs/ext/standard/headers_list.stub', 'headers_sent' => 'stubs/ext/standard/headers_sent.stub', 'hebrev' => 'stubs/ext/standard/hebrev.stub', 'hex2bin' => 'stubs/ext/standard/hex2bin.stub', 'hexdec' => 'stubs/ext/standard/hexdec.stub', 'highlight_file' => 'stubs/ext/standard/highlight_file.stub', 'highlight_string' => 'stubs/ext/standard/highlight_string.stub', 'hrtime' => 'stubs/ext/standard/hrtime.stub', 'html_entity_decode' => 'stubs/ext/standard/html_entity_decode.stub', 'htmlentities' => 'stubs/ext/standard/htmlentities.stub', 'htmlspecialchars' => 'stubs/ext/standard/htmlspecialchars.stub', 'htmlspecialchars_decode' => 'stubs/ext/standard/htmlspecialchars_decode.stub', 'http_build_query' => 'stubs/ext/standard/http_build_query.stub', 'http_response_code' => 'stubs/ext/standard/http_response_code.stub', 'hypot' => 'stubs/ext/standard/hypot.stub', 'iconv' => 'stubs/ext/iconv/iconv.stub', 'iconv_get_encoding' => 'stubs/ext/iconv/iconv_get_encoding.stub', 'iconv_mime_decode' => 'stubs/ext/iconv/iconv_mime_decode.stub', 'iconv_mime_decode_headers' => 'stubs/ext/iconv/iconv_mime_decode_headers.stub', 'iconv_mime_encode' => 'stubs/ext/iconv/iconv_mime_encode.stub', 'iconv_set_encoding' => 'stubs/ext/iconv/iconv_set_encoding.stub', 'iconv_strlen' => 'stubs/ext/iconv/iconv_strlen.stub', 'iconv_strpos' => 'stubs/ext/iconv/iconv_strpos.stub', 'iconv_strrpos' => 'stubs/ext/iconv/iconv_strrpos.stub', 'iconv_substr' => 'stubs/ext/iconv/iconv_substr.stub', 'idate' => 'stubs/ext/date/idate.stub', 'idn_to_ascii' => 'stubs/ext/intl/idn_to_ascii.stub', 'idn_to_utf8' => 'stubs/ext/intl/idn_to_utf8.stub', 'ignore_user_abort' => 'stubs/ext/standard/ignore_user_abort.stub', 'image_type_to_extension' => 'stubs/ext/standard/image_type_to_extension.stub', 'image_type_to_mime_type' => 'stubs/ext/standard/image_type_to_mime_type.stub', 'imageaffine' => 'stubs/ext/gd/imageaffine.stub', 'imageaffinematrixconcat' => 'stubs/ext/gd/imageaffinematrixconcat.stub', 'imageaffinematrixget' => 'stubs/ext/gd/imageaffinematrixget.stub', 'imagealphablending' => 'stubs/ext/gd/imagealphablending.stub', 'imageantialias' => 'stubs/ext/gd/imageantialias.stub', 'imagearc' => 'stubs/ext/gd/imagearc.stub', 'imagebmp' => 'stubs/ext/gd/imagebmp.stub', 'imagechar' => 'stubs/ext/gd/imagechar.stub', 'imagecharup' => 'stubs/ext/gd/imagecharup.stub', 'imagecolorallocate' => 'stubs/ext/gd/imagecolorallocate.stub', 'imagecolorallocatealpha' => 'stubs/ext/gd/imagecolorallocatealpha.stub', 'imagecolorat' => 'stubs/ext/gd/imagecolorat.stub', 'imagecolorclosest' => 'stubs/ext/gd/imagecolorclosest.stub', 'imagecolorclosestalpha' => 'stubs/ext/gd/imagecolorclosestalpha.stub', 'imagecolorclosesthwb' => 'stubs/ext/gd/imagecolorclosesthwb.stub', 'imagecolordeallocate' => 'stubs/ext/gd/imagecolordeallocate.stub', 'imagecolorexact' => 'stubs/ext/gd/imagecolorexact.stub', 'imagecolorexactalpha' => 'stubs/ext/gd/imagecolorexactalpha.stub', 'imagecolormatch' => 'stubs/ext/gd/imagecolormatch.stub', 'imagecolorresolve' => 'stubs/ext/gd/imagecolorresolve.stub', 'imagecolorresolvealpha' => 'stubs/ext/gd/imagecolorresolvealpha.stub', 'imagecolorset' => 'stubs/ext/gd/imagecolorset.stub', 'imagecolorsforindex' => 'stubs/ext/gd/imagecolorsforindex.stub', 'imagecolorstotal' => 'stubs/ext/gd/imagecolorstotal.stub', 'imagecolortransparent' => 'stubs/ext/gd/imagecolortransparent.stub', 'imageconvolution' => 'stubs/ext/gd/imageconvolution.stub', 'imagecopy' => 'stubs/ext/gd/imagecopy.stub', 'imagecopymerge' => 'stubs/ext/gd/imagecopymerge.stub', 'imagecopymergegray' => 'stubs/ext/gd/imagecopymergegray.stub', 'imagecopyresampled' => 'stubs/ext/gd/imagecopyresampled.stub', 'imagecopyresized' => 'stubs/ext/gd/imagecopyresized.stub', 'imagecreate' => 'stubs/ext/gd/imagecreate.stub', 'imagecreatefrombmp' => 'stubs/ext/gd/imagecreatefrombmp.stub', 'imagecreatefromgd' => 'stubs/ext/gd/imagecreatefromgd.stub', 'imagecreatefromgd2' => 'stubs/ext/gd/imagecreatefromgd2.stub', 'imagecreatefromgd2part' => 'stubs/ext/gd/imagecreatefromgd2part.stub', 'imagecreatefromgif' => 'stubs/ext/gd/imagecreatefromgif.stub', 'imagecreatefromjpeg' => 'stubs/ext/gd/imagecreatefromjpeg.stub', 'imagecreatefrompng' => 'stubs/ext/gd/imagecreatefrompng.stub', 'imagecreatefromstring' => 'stubs/ext/gd/imagecreatefromstring.stub', 'imagecreatefromtga' => 'stubs/ext/gd/imagecreatefromtga.stub', 'imagecreatefromwbmp' => 'stubs/ext/gd/imagecreatefromwbmp.stub', 'imagecreatefromwebp' => 'stubs/ext/gd/imagecreatefromwebp.stub', 'imagecreatefromxbm' => 'stubs/ext/gd/imagecreatefromxbm.stub', 'imagecreatefromxpm' => 'stubs/ext/gd/imagecreatefromxpm.stub', 'imagecreatetruecolor' => 'stubs/ext/gd/imagecreatetruecolor.stub', 'imagecrop' => 'stubs/ext/gd/imagecrop.stub', 'imagecropauto' => 'stubs/ext/gd/imagecropauto.stub', 'imagedashedline' => 'stubs/ext/gd/imagedashedline.stub', 'imagedestroy' => 'stubs/ext/gd/imagedestroy.stub', 'imageellipse' => 'stubs/ext/gd/imageellipse.stub', 'imagefill' => 'stubs/ext/gd/imagefill.stub', 'imagefilledarc' => 'stubs/ext/gd/imagefilledarc.stub', 'imagefilledellipse' => 'stubs/ext/gd/imagefilledellipse.stub', 'imagefilledpolygon' => 'stubs/ext/gd/imagefilledpolygon.stub', 'imagefilledrectangle' => 'stubs/ext/gd/imagefilledrectangle.stub', 'imagefilltoborder' => 'stubs/ext/gd/imagefilltoborder.stub', 'imagefilter' => 'stubs/ext/gd/imagefilter.stub', 'imageflip' => 'stubs/ext/gd/imageflip.stub', 'imagefontheight' => 'stubs/ext/gd/imagefontheight.stub', 'imagefontwidth' => 'stubs/ext/gd/imagefontwidth.stub', 'imageftbbox' => 'stubs/ext/gd/imageftbbox.stub', 'imagefttext' => 'stubs/ext/gd/imagefttext.stub', 'imagegammacorrect' => 'stubs/ext/gd/imagegammacorrect.stub', 'imagegd' => 'stubs/ext/gd/imagegd.stub', 'imagegd2' => 'stubs/ext/gd/imagegd2.stub', 'imagegetclip' => 'stubs/ext/gd/imagegetclip.stub', 'imagegetinterpolation' => 'stubs/ext/gd/imagegetinterpolation.stub', 'imagegif' => 'stubs/ext/gd/imagegif.stub', 'imagegrabscreen' => 'stubs/ext/gd/imagegrabscreen.stub', 'imagegrabwindow' => 'stubs/ext/gd/imagegrabwindow.stub', 'imageinterlace' => 'stubs/ext/gd/imageinterlace.stub', 'imageistruecolor' => 'stubs/ext/gd/imageistruecolor.stub', 'imagejpeg' => 'stubs/ext/gd/imagejpeg.stub', 'imagelayereffect' => 'stubs/ext/gd/imagelayereffect.stub', 'imageline' => 'stubs/ext/gd/imageline.stub', 'imageloadfont' => 'stubs/ext/gd/imageloadfont.stub', 'imageopenpolygon' => 'stubs/ext/gd/imageopenpolygon.stub', 'imagepalettecopy' => 'stubs/ext/gd/imagepalettecopy.stub', 'imagepalettetotruecolor' => 'stubs/ext/gd/imagepalettetotruecolor.stub', 'imagepng' => 'stubs/ext/gd/imagepng.stub', 'imagepolygon' => 'stubs/ext/gd/imagepolygon.stub', 'imagerectangle' => 'stubs/ext/gd/imagerectangle.stub', 'imageresolution' => 'stubs/ext/gd/imageresolution.stub', 'imagerotate' => 'stubs/ext/gd/imagerotate.stub', 'imagesavealpha' => 'stubs/ext/gd/imagesavealpha.stub', 'imagescale' => 'stubs/ext/gd/imagescale.stub', 'imagesetbrush' => 'stubs/ext/gd/imagesetbrush.stub', 'imagesetclip' => 'stubs/ext/gd/imagesetclip.stub', 'imagesetinterpolation' => 'stubs/ext/gd/imagesetinterpolation.stub', 'imagesetpixel' => 'stubs/ext/gd/imagesetpixel.stub', 'imagesetstyle' => 'stubs/ext/gd/imagesetstyle.stub', 'imagesetthickness' => 'stubs/ext/gd/imagesetthickness.stub', 'imagesettile' => 'stubs/ext/gd/imagesettile.stub', 'imagestring' => 'stubs/ext/gd/imagestring.stub', 'imagestringup' => 'stubs/ext/gd/imagestringup.stub', 'imagesx' => 'stubs/ext/gd/imagesx.stub', 'imagesy' => 'stubs/ext/gd/imagesy.stub', 'imagetruecolortopalette' => 'stubs/ext/gd/imagetruecolortopalette.stub', 'imagettfbbox' => 'stubs/ext/gd/imagettfbbox.stub', 'imagettftext' => 'stubs/ext/gd/imagettftext.stub', 'imagetypes' => 'stubs/ext/gd/imagetypes.stub', 'imagewbmp' => 'stubs/ext/gd/imagewbmp.stub', 'imagewebp' => 'stubs/ext/gd/imagewebp.stub', 'imagexbm' => 'stubs/ext/gd/imagexbm.stub', 'imap_8bit' => 'stubs/ext/imap/imap_8bit.stub', 'imap_alerts' => 'stubs/ext/imap/imap_alerts.stub', 'imap_append' => 'stubs/ext/imap/imap_append.stub', 'imap_base64' => 'stubs/ext/imap/imap_base64.stub', 'imap_binary' => 'stubs/ext/imap/imap_binary.stub', 'imap_body' => 'stubs/ext/imap/imap_body.stub', 'imap_bodystruct' => 'stubs/ext/imap/imap_bodystruct.stub', 'imap_check' => 'stubs/ext/imap/imap_check.stub', 'imap_clearflag_full' => 'stubs/ext/imap/imap_clearflag_full.stub', 'imap_close' => 'stubs/ext/imap/imap_close.stub', 'imap_create' => 'stubs/ext/imap/imap_create.stub', 'imap_createmailbox' => 'stubs/ext/imap/imap_createmailbox.stub', 'imap_delete' => 'stubs/ext/imap/imap_delete.stub', 'imap_deletemailbox' => 'stubs/ext/imap/imap_deletemailbox.stub', 'imap_errors' => 'stubs/ext/imap/imap_errors.stub', 'imap_expunge' => 'stubs/ext/imap/imap_expunge.stub', 'imap_fetch_overview' => 'stubs/ext/imap/imap_fetch_overview.stub', 'imap_fetchbody' => 'stubs/ext/imap/imap_fetchbody.stub', 'imap_fetchheader' => 'stubs/ext/imap/imap_fetchheader.stub', 'imap_fetchmime' => 'stubs/ext/imap/imap_fetchmime.stub', 'imap_fetchstructure' => 'stubs/ext/imap/imap_fetchstructure.stub', 'imap_fetchtext' => 'stubs/ext/imap/imap_fetchtext.stub', 'imap_gc' => 'stubs/ext/imap/imap_gc.stub', 'imap_get_quota' => 'stubs/ext/imap/imap_get_quota.stub', 'imap_get_quotaroot' => 'stubs/ext/imap/imap_get_quotaroot.stub', 'imap_getacl' => 'stubs/ext/imap/imap_getacl.stub', 'imap_getmailboxes' => 'stubs/ext/imap/imap_getmailboxes.stub', 'imap_getsubscribed' => 'stubs/ext/imap/imap_getsubscribed.stub', 'imap_headerinfo' => 'stubs/ext/imap/imap_headerinfo.stub', 'imap_headers' => 'stubs/ext/imap/imap_headers.stub', 'imap_last_error' => 'stubs/ext/imap/imap_last_error.stub', 'imap_list' => 'stubs/ext/imap/imap_list.stub', 'imap_listmailbox' => 'stubs/ext/imap/imap_listmailbox.stub', 'imap_listscan' => 'stubs/ext/imap/imap_listscan.stub', 'imap_listsubscribed' => 'stubs/ext/imap/imap_listsubscribed.stub', 'imap_lsub' => 'stubs/ext/imap/imap_lsub.stub', 'imap_mail' => 'stubs/ext/imap/imap_mail.stub', 'imap_mail_compose' => 'stubs/ext/imap/imap_mail_compose.stub', 'imap_mail_copy' => 'stubs/ext/imap/imap_mail_copy.stub', 'imap_mail_move' => 'stubs/ext/imap/imap_mail_move.stub', 'imap_mailboxmsginfo' => 'stubs/ext/imap/imap_mailboxmsginfo.stub', 'imap_mime_header_decode' => 'stubs/ext/imap/imap_mime_header_decode.stub', 'imap_msgno' => 'stubs/ext/imap/imap_msgno.stub', 'imap_mutf7_to_utf8' => 'stubs/ext/imap/imap_mutf7_to_utf8.stub', 'imap_num_msg' => 'stubs/ext/imap/imap_num_msg.stub', 'imap_num_recent' => 'stubs/ext/imap/imap_num_recent.stub', 'imap_open' => 'stubs/ext/imap/imap_open.stub', 'imap_ping' => 'stubs/ext/imap/imap_ping.stub', 'imap_qprint' => 'stubs/ext/imap/imap_qprint.stub', 'imap_rename' => 'stubs/ext/imap/imap_rename.stub', 'imap_renamemailbox' => 'stubs/ext/imap/imap_renamemailbox.stub', 'imap_reopen' => 'stubs/ext/imap/imap_reopen.stub', 'imap_rfc822_parse_adrlist' => 'stubs/ext/imap/imap_rfc822_parse_adrlist.stub', 'imap_rfc822_parse_headers' => 'stubs/ext/imap/imap_rfc822_parse_headers.stub', 'imap_rfc822_write_address' => 'stubs/ext/imap/imap_rfc822_write_address.stub', 'imap_savebody' => 'stubs/ext/imap/imap_savebody.stub', 'imap_scan' => 'stubs/ext/imap/imap_scan.stub', 'imap_scanmailbox' => 'stubs/ext/imap/imap_scanmailbox.stub', 'imap_search' => 'stubs/ext/imap/imap_search.stub', 'imap_set_quota' => 'stubs/ext/imap/imap_set_quota.stub', 'imap_setacl' => 'stubs/ext/imap/imap_setacl.stub', 'imap_setflag_full' => 'stubs/ext/imap/imap_setflag_full.stub', 'imap_sort' => 'stubs/ext/imap/imap_sort.stub', 'imap_status' => 'stubs/ext/imap/imap_status.stub', 'imap_subscribe' => 'stubs/ext/imap/imap_subscribe.stub', 'imap_thread' => 'stubs/ext/imap/imap_thread.stub', 'imap_timeout' => 'stubs/ext/imap/imap_timeout.stub', 'imap_uid' => 'stubs/ext/imap/imap_uid.stub', 'imap_undelete' => 'stubs/ext/imap/imap_undelete.stub', 'imap_unsubscribe' => 'stubs/ext/imap/imap_unsubscribe.stub', 'imap_utf7_decode' => 'stubs/ext/imap/imap_utf7_decode.stub', 'imap_utf7_encode' => 'stubs/ext/imap/imap_utf7_encode.stub', 'imap_utf8' => 'stubs/ext/imap/imap_utf8.stub', 'imap_utf8_to_mutf7' => 'stubs/ext/imap/imap_utf8_to_mutf7.stub', 'implode' => 'stubs/ext/standard/implode.stub', 'in_array' => 'stubs/ext/standard/in_array.stub', 'inet_ntop' => 'stubs/ext/standard/inet_ntop.stub', 'inet_pton' => 'stubs/ext/standard/inet_pton.stub', 'inflate_add' => 'stubs/ext/zlib/inflate_add.stub', 'inflate_get_read_len' => 'stubs/ext/zlib/inflate_get_read_len.stub', 'inflate_get_status' => 'stubs/ext/zlib/inflate_get_status.stub', 'inflate_init' => 'stubs/ext/zlib/inflate_init.stub', 'ini_alter' => 'stubs/ext/standard/ini_alter.stub', 'ini_get' => 'stubs/ext/standard/ini_get.stub', 'ini_get_all' => 'stubs/ext/standard/ini_get_all.stub', 'ini_restore' => 'stubs/ext/standard/ini_restore.stub', 'ini_set' => 'stubs/ext/standard/ini_set.stub', 'intdiv' => 'stubs/ext/standard/intdiv.stub', 'interface_exists' => 'stubs/Zend/interface_exists.stub', 'intl_error_name' => 'stubs/ext/intl/intl_error_name.stub', 'intl_get_error_code' => 'stubs/ext/intl/intl_get_error_code.stub', 'intl_get_error_message' => 'stubs/ext/intl/intl_get_error_message.stub', 'intl_is_failure' => 'stubs/ext/intl/intl_is_failure.stub', 'intlcal_add' => 'stubs/ext/intl/intlcal_add.stub', 'intlcal_after' => 'stubs/ext/intl/intlcal_after.stub', 'intlcal_before' => 'stubs/ext/intl/intlcal_before.stub', 'intlcal_clear' => 'stubs/ext/intl/intlcal_clear.stub', 'intlcal_create_instance' => 'stubs/ext/intl/intlcal_create_instance.stub', 'intlcal_equals' => 'stubs/ext/intl/intlcal_equals.stub', 'intlcal_field_difference' => 'stubs/ext/intl/intlcal_field_difference.stub', 'intlcal_from_date_time' => 'stubs/ext/intl/intlcal_from_date_time.stub', 'intlcal_get' => 'stubs/ext/intl/intlcal_get.stub', 'intlcal_get_actual_maximum' => 'stubs/ext/intl/intlcal_get_actual_maximum.stub', 'intlcal_get_actual_minimum' => 'stubs/ext/intl/intlcal_get_actual_minimum.stub', 'intlcal_get_available_locales' => 'stubs/ext/intl/intlcal_get_available_locales.stub', 'intlcal_get_day_of_week_type' => 'stubs/ext/intl/intlcal_get_day_of_week_type.stub', 'intlcal_get_error_code' => 'stubs/ext/intl/intlcal_get_error_code.stub', 'intlcal_get_error_message' => 'stubs/ext/intl/intlcal_get_error_message.stub', 'intlcal_get_first_day_of_week' => 'stubs/ext/intl/intlcal_get_first_day_of_week.stub', 'intlcal_get_greatest_minimum' => 'stubs/ext/intl/intlcal_get_greatest_minimum.stub', 'intlcal_get_keyword_values_for_locale' => 'stubs/ext/intl/intlcal_get_keyword_values_for_locale.stub', 'intlcal_get_least_maximum' => 'stubs/ext/intl/intlcal_get_least_maximum.stub', 'intlcal_get_locale' => 'stubs/ext/intl/intlcal_get_locale.stub', 'intlcal_get_maximum' => 'stubs/ext/intl/intlcal_get_maximum.stub', 'intlcal_get_minimal_days_in_first_week' => 'stubs/ext/intl/intlcal_get_minimal_days_in_first_week.stub', 'intlcal_get_minimum' => 'stubs/ext/intl/intlcal_get_minimum.stub', 'intlcal_get_now' => 'stubs/ext/intl/intlcal_get_now.stub', 'intlcal_get_repeated_wall_time_option' => 'stubs/ext/intl/intlcal_get_repeated_wall_time_option.stub', 'intlcal_get_skipped_wall_time_option' => 'stubs/ext/intl/intlcal_get_skipped_wall_time_option.stub', 'intlcal_get_time' => 'stubs/ext/intl/intlcal_get_time.stub', 'intlcal_get_time_zone' => 'stubs/ext/intl/intlcal_get_time_zone.stub', 'intlcal_get_type' => 'stubs/ext/intl/intlcal_get_type.stub', 'intlcal_get_weekend_transition' => 'stubs/ext/intl/intlcal_get_weekend_transition.stub', 'intlcal_in_daylight_time' => 'stubs/ext/intl/intlcal_in_daylight_time.stub', 'intlcal_is_equivalent_to' => 'stubs/ext/intl/intlcal_is_equivalent_to.stub', 'intlcal_is_lenient' => 'stubs/ext/intl/intlcal_is_lenient.stub', 'intlcal_is_set' => 'stubs/ext/intl/intlcal_is_set.stub', 'intlcal_is_weekend' => 'stubs/ext/intl/intlcal_is_weekend.stub', 'intlcal_roll' => 'stubs/ext/intl/intlcal_roll.stub', 'intlcal_set' => 'stubs/ext/intl/intlcal_set.stub', 'intlcal_set_first_day_of_week' => 'stubs/ext/intl/intlcal_set_first_day_of_week.stub', 'intlcal_set_lenient' => 'stubs/ext/intl/intlcal_set_lenient.stub', 'intlcal_set_minimal_days_in_first_week' => 'stubs/ext/intl/intlcal_set_minimal_days_in_first_week.stub', 'intlcal_set_repeated_wall_time_option' => 'stubs/ext/intl/intlcal_set_repeated_wall_time_option.stub', 'intlcal_set_skipped_wall_time_option' => 'stubs/ext/intl/intlcal_set_skipped_wall_time_option.stub', 'intlcal_set_time' => 'stubs/ext/intl/intlcal_set_time.stub', 'intlcal_set_time_zone' => 'stubs/ext/intl/intlcal_set_time_zone.stub', 'intlcal_to_date_time' => 'stubs/ext/intl/intlcal_to_date_time.stub', 'intlgregcal_create_instance' => 'stubs/ext/intl/intlgregcal_create_instance.stub', 'intlgregcal_get_gregorian_change' => 'stubs/ext/intl/intlgregcal_get_gregorian_change.stub', 'intlgregcal_is_leap_year' => 'stubs/ext/intl/intlgregcal_is_leap_year.stub', 'intlgregcal_set_gregorian_change' => 'stubs/ext/intl/intlgregcal_set_gregorian_change.stub', 'intltz_count_equivalent_ids' => 'stubs/ext/intl/intltz_count_equivalent_ids.stub', 'intltz_create_default' => 'stubs/ext/intl/intltz_create_default.stub', 'intltz_create_enumeration' => 'stubs/ext/intl/intltz_create_enumeration.stub', 'intltz_create_time_zone' => 'stubs/ext/intl/intltz_create_time_zone.stub', 'intltz_create_time_zone_id_enumeration' => 'stubs/ext/intl/intltz_create_time_zone_id_enumeration.stub', 'intltz_from_date_time_zone' => 'stubs/ext/intl/intltz_from_date_time_zone.stub', 'intltz_get_canonical_id' => 'stubs/ext/intl/intltz_get_canonical_id.stub', 'intltz_get_display_name' => 'stubs/ext/intl/intltz_get_display_name.stub', 'intltz_get_dst_savings' => 'stubs/ext/intl/intltz_get_dst_savings.stub', 'intltz_get_equivalent_id' => 'stubs/ext/intl/intltz_get_equivalent_id.stub', 'intltz_get_error_code' => 'stubs/ext/intl/intltz_get_error_code.stub', 'intltz_get_error_message' => 'stubs/ext/intl/intltz_get_error_message.stub', 'intltz_get_gmt' => 'stubs/ext/intl/intltz_get_gmt.stub', 'intltz_get_id' => 'stubs/ext/intl/intltz_get_id.stub', 'intltz_get_id_for_windows_id' => 'stubs/ext/intl/intltz_get_id_for_windows_id.stub', 'intltz_get_offset' => 'stubs/ext/intl/intltz_get_offset.stub', 'intltz_get_raw_offset' => 'stubs/ext/intl/intltz_get_raw_offset.stub', 'intltz_get_region' => 'stubs/ext/intl/intltz_get_region.stub', 'intltz_get_tz_data_version' => 'stubs/ext/intl/intltz_get_tz_data_version.stub', 'intltz_get_unknown' => 'stubs/ext/intl/intltz_get_unknown.stub', 'intltz_get_windows_id' => 'stubs/ext/intl/intltz_get_windows_id.stub', 'intltz_has_same_rules' => 'stubs/ext/intl/intltz_has_same_rules.stub', 'intltz_to_date_time_zone' => 'stubs/ext/intl/intltz_to_date_time_zone.stub', 'intltz_use_daylight_time' => 'stubs/ext/intl/intltz_use_daylight_time.stub', 'intval' => 'stubs/ext/standard/intval.stub', 'ip2long' => 'stubs/ext/standard/ip2long.stub', 'iptcembed' => 'stubs/ext/standard/iptcembed.stub', 'iptcparse' => 'stubs/ext/standard/iptcparse.stub', 'is_a' => 'stubs/Zend/is_a.stub', 'is_array' => 'stubs/ext/standard/is_array.stub', 'is_bool' => 'stubs/ext/standard/is_bool.stub', 'is_callable' => 'stubs/ext/standard/is_callable.stub', 'is_countable' => 'stubs/ext/standard/is_countable.stub', 'is_dir' => 'stubs/ext/standard/is_dir.stub', 'is_double' => 'stubs/ext/standard/is_double.stub', 'is_executable' => 'stubs/ext/standard/is_executable.stub', 'is_file' => 'stubs/ext/standard/is_file.stub', 'is_finite' => 'stubs/ext/standard/is_finite.stub', 'is_float' => 'stubs/ext/standard/is_float.stub', 'is_infinite' => 'stubs/ext/standard/is_infinite.stub', 'is_int' => 'stubs/ext/standard/is_int.stub', 'is_integer' => 'stubs/ext/standard/is_integer.stub', 'is_iterable' => 'stubs/ext/standard/is_iterable.stub', 'is_link' => 'stubs/ext/standard/is_link.stub', 'is_long' => 'stubs/ext/standard/is_long.stub', 'is_nan' => 'stubs/ext/standard/is_nan.stub', 'is_null' => 'stubs/ext/standard/is_null.stub', 'is_numeric' => 'stubs/ext/standard/is_numeric.stub', 'is_object' => 'stubs/ext/standard/is_object.stub', 'is_readable' => 'stubs/ext/standard/is_readable.stub', 'is_resource' => 'stubs/ext/standard/is_resource.stub', 'is_scalar' => 'stubs/ext/standard/is_scalar.stub', 'is_soap_fault' => 'stubs/ext/soap/is_soap_fault.stub', 'is_string' => 'stubs/ext/standard/is_string.stub', 'is_subclass_of' => 'stubs/Zend/is_subclass_of.stub', 'is_uploaded_file' => 'stubs/ext/standard/is_uploaded_file.stub', 'is_writable' => 'stubs/ext/standard/is_writable.stub', 'is_writeable' => 'stubs/ext/standard/is_writeable.stub', 'iterator_apply' => 'stubs/ext/spl/iterator_apply.stub', 'iterator_count' => 'stubs/ext/spl/iterator_count.stub', 'iterator_to_array' => 'stubs/ext/spl/iterator_to_array.stub', 'jddayofweek' => 'stubs/ext/calendar/jddayofweek.stub', 'jdmonthname' => 'stubs/ext/calendar/jdmonthname.stub', 'jdtofrench' => 'stubs/ext/calendar/jdtofrench.stub', 'jdtogregorian' => 'stubs/ext/calendar/jdtogregorian.stub', 'jdtojewish' => 'stubs/ext/calendar/jdtojewish.stub', 'jdtojulian' => 'stubs/ext/calendar/jdtojulian.stub', 'jdtounix' => 'stubs/ext/calendar/jdtounix.stub', 'jewishtojd' => 'stubs/ext/calendar/jewishtojd.stub', 'join' => 'stubs/ext/standard/join.stub', 'json_decode' => 'stubs/ext/json/json_decode.stub', 'json_encode' => 'stubs/ext/json/json_encode.stub', 'json_last_error' => 'stubs/ext/json/json_last_error.stub', 'json_last_error_msg' => 'stubs/ext/json/json_last_error_msg.stub', 'juliantojd' => 'stubs/ext/calendar/juliantojd.stub', 'key' => 'stubs/ext/standard/key.stub', 'key_exists' => 'stubs/ext/standard/key_exists.stub', 'krsort' => 'stubs/ext/standard/krsort.stub', 'ksort' => 'stubs/ext/standard/ksort.stub', 'lcfirst' => 'stubs/ext/standard/lcfirst.stub', 'lcg_value' => 'stubs/ext/standard/lcg_value.stub', 'lchgrp' => 'stubs/ext/standard/lchgrp.stub', 'lchown' => 'stubs/ext/standard/lchown.stub', 'ldap_8859_to_t61' => 'stubs/ext/ldap/ldap_8859_to_t61.stub', 'ldap_add' => 'stubs/ext/ldap/ldap_add.stub', 'ldap_add_ext' => 'stubs/ext/ldap/ldap_add_ext.stub', 'ldap_bind' => 'stubs/ext/ldap/ldap_bind.stub', 'ldap_bind_ext' => 'stubs/ext/ldap/ldap_bind_ext.stub', 'ldap_close' => 'stubs/ext/ldap/ldap_close.stub', 'ldap_compare' => 'stubs/ext/ldap/ldap_compare.stub', 'ldap_connect' => 'stubs/ext/ldap/ldap_connect.stub', 'ldap_count_entries' => 'stubs/ext/ldap/ldap_count_entries.stub', 'ldap_count_references' => 'stubs/ext/ldap/ldap_count_references.stub', 'ldap_delete' => 'stubs/ext/ldap/ldap_delete.stub', 'ldap_delete_ext' => 'stubs/ext/ldap/ldap_delete_ext.stub', 'ldap_dn2ufn' => 'stubs/ext/ldap/ldap_dn2ufn.stub', 'ldap_err2str' => 'stubs/ext/ldap/ldap_err2str.stub', 'ldap_errno' => 'stubs/ext/ldap/ldap_errno.stub', 'ldap_error' => 'stubs/ext/ldap/ldap_error.stub', 'ldap_escape' => 'stubs/ext/ldap/ldap_escape.stub', 'ldap_exop' => 'stubs/ext/ldap/ldap_exop.stub', 'ldap_exop_passwd' => 'stubs/ext/ldap/ldap_exop_passwd.stub', 'ldap_exop_refresh' => 'stubs/ext/ldap/ldap_exop_refresh.stub', 'ldap_exop_whoami' => 'stubs/ext/ldap/ldap_exop_whoami.stub', 'ldap_explode_dn' => 'stubs/ext/ldap/ldap_explode_dn.stub', 'ldap_first_attribute' => 'stubs/ext/ldap/ldap_first_attribute.stub', 'ldap_first_entry' => 'stubs/ext/ldap/ldap_first_entry.stub', 'ldap_first_reference' => 'stubs/ext/ldap/ldap_first_reference.stub', 'ldap_free_result' => 'stubs/ext/ldap/ldap_free_result.stub', 'ldap_get_attributes' => 'stubs/ext/ldap/ldap_get_attributes.stub', 'ldap_get_dn' => 'stubs/ext/ldap/ldap_get_dn.stub', 'ldap_get_entries' => 'stubs/ext/ldap/ldap_get_entries.stub', 'ldap_get_option' => 'stubs/ext/ldap/ldap_get_option.stub', 'ldap_get_values' => 'stubs/ext/ldap/ldap_get_values.stub', 'ldap_get_values_len' => 'stubs/ext/ldap/ldap_get_values_len.stub', 'ldap_list' => 'stubs/ext/ldap/ldap_list.stub', 'ldap_mod_add' => 'stubs/ext/ldap/ldap_mod_add.stub', 'ldap_mod_add_ext' => 'stubs/ext/ldap/ldap_mod_add_ext.stub', 'ldap_mod_del' => 'stubs/ext/ldap/ldap_mod_del.stub', 'ldap_mod_del_ext' => 'stubs/ext/ldap/ldap_mod_del_ext.stub', 'ldap_mod_replace' => 'stubs/ext/ldap/ldap_mod_replace.stub', 'ldap_mod_replace_ext' => 'stubs/ext/ldap/ldap_mod_replace_ext.stub', 'ldap_modify' => 'stubs/ext/ldap/ldap_modify.stub', 'ldap_modify_batch' => 'stubs/ext/ldap/ldap_modify_batch.stub', 'ldap_next_attribute' => 'stubs/ext/ldap/ldap_next_attribute.stub', 'ldap_next_entry' => 'stubs/ext/ldap/ldap_next_entry.stub', 'ldap_next_reference' => 'stubs/ext/ldap/ldap_next_reference.stub', 'ldap_parse_exop' => 'stubs/ext/ldap/ldap_parse_exop.stub', 'ldap_parse_reference' => 'stubs/ext/ldap/ldap_parse_reference.stub', 'ldap_parse_result' => 'stubs/ext/ldap/ldap_parse_result.stub', 'ldap_read' => 'stubs/ext/ldap/ldap_read.stub', 'ldap_rename' => 'stubs/ext/ldap/ldap_rename.stub', 'ldap_rename_ext' => 'stubs/ext/ldap/ldap_rename_ext.stub', 'ldap_sasl_bind' => 'stubs/ext/ldap/ldap_sasl_bind.stub', 'ldap_search' => 'stubs/ext/ldap/ldap_search.stub', 'ldap_set_option' => 'stubs/ext/ldap/ldap_set_option.stub', 'ldap_set_rebind_proc' => 'stubs/ext/ldap/ldap_set_rebind_proc.stub', 'ldap_start_tls' => 'stubs/ext/ldap/ldap_start_tls.stub', 'ldap_t61_to_8859' => 'stubs/ext/ldap/ldap_t61_to_8859.stub', 'ldap_unbind' => 'stubs/ext/ldap/ldap_unbind.stub', 'levenshtein' => 'stubs/ext/standard/levenshtein.stub', 'libxml_clear_errors' => 'stubs/ext/libxml/libxml_clear_errors.stub', 'libxml_disable_entity_loader' => 'stubs/ext/libxml/libxml_disable_entity_loader.stub', 'libxml_get_errors' => 'stubs/ext/libxml/libxml_get_errors.stub', 'libxml_get_last_error' => 'stubs/ext/libxml/libxml_get_last_error.stub', 'libxml_set_external_entity_loader' => 'stubs/ext/libxml/libxml_set_external_entity_loader.stub', 'libxml_set_streams_context' => 'stubs/ext/libxml/libxml_set_streams_context.stub', 'libxml_use_internal_errors' => 'stubs/ext/libxml/libxml_use_internal_errors.stub', 'link' => 'stubs/ext/standard/link.stub', 'linkinfo' => 'stubs/ext/standard/linkinfo.stub', 'litespeed_finish_request' => 'stubs/sapi/litespeed/litespeed_finish_request.stub', 'litespeed_request_headers' => 'stubs/sapi/litespeed/litespeed_request_headers.stub', 'litespeed_response_headers' => 'stubs/sapi/litespeed/litespeed_response_headers.stub', 'locale_accept_from_http' => 'stubs/ext/intl/locale_accept_from_http.stub', 'locale_canonicalize' => 'stubs/ext/intl/locale_canonicalize.stub', 'locale_compose' => 'stubs/ext/intl/locale_compose.stub', 'locale_filter_matches' => 'stubs/ext/intl/locale_filter_matches.stub', 'locale_get_all_variants' => 'stubs/ext/intl/locale_get_all_variants.stub', 'locale_get_default' => 'stubs/ext/intl/locale_get_default.stub', 'locale_get_display_language' => 'stubs/ext/intl/locale_get_display_language.stub', 'locale_get_display_name' => 'stubs/ext/intl/locale_get_display_name.stub', 'locale_get_display_region' => 'stubs/ext/intl/locale_get_display_region.stub', 'locale_get_display_script' => 'stubs/ext/intl/locale_get_display_script.stub', 'locale_get_display_variant' => 'stubs/ext/intl/locale_get_display_variant.stub', 'locale_get_keywords' => 'stubs/ext/intl/locale_get_keywords.stub', 'locale_get_primary_language' => 'stubs/ext/intl/locale_get_primary_language.stub', 'locale_get_region' => 'stubs/ext/intl/locale_get_region.stub', 'locale_get_script' => 'stubs/ext/intl/locale_get_script.stub', 'locale_lookup' => 'stubs/ext/intl/locale_lookup.stub', 'locale_parse' => 'stubs/ext/intl/locale_parse.stub', 'locale_set_default' => 'stubs/ext/intl/locale_set_default.stub', 'localeconv' => 'stubs/ext/standard/localeconv.stub', 'localtime' => 'stubs/ext/date/localtime.stub', 'log' => 'stubs/ext/standard/log.stub', 'log10' => 'stubs/ext/standard/log10.stub', 'log1p' => 'stubs/ext/standard/log1p.stub', 'long2ip' => 'stubs/ext/standard/long2ip.stub', 'lstat' => 'stubs/ext/standard/lstat.stub', 'ltrim' => 'stubs/ext/standard/ltrim.stub', 'mail' => 'stubs/ext/standard/mail.stub', 'max' => 'stubs/ext/standard/max.stub', 'mb_check_encoding' => 'stubs/ext/mbstring/mb_check_encoding.stub', 'mb_chr' => 'stubs/ext/mbstring/mb_chr.stub', 'mb_convert_case' => 'stubs/ext/mbstring/mb_convert_case.stub', 'mb_convert_encoding' => 'stubs/ext/mbstring/mb_convert_encoding.stub', 'mb_convert_kana' => 'stubs/ext/mbstring/mb_convert_kana.stub', 'mb_convert_variables' => 'stubs/ext/mbstring/mb_convert_variables.stub', 'mb_decode_mimeheader' => 'stubs/ext/mbstring/mb_decode_mimeheader.stub', 'mb_decode_numericentity' => 'stubs/ext/mbstring/mb_decode_numericentity.stub', 'mb_detect_encoding' => 'stubs/ext/mbstring/mb_detect_encoding.stub', 'mb_detect_order' => 'stubs/ext/mbstring/mb_detect_order.stub', 'mb_encode_mimeheader' => 'stubs/ext/mbstring/mb_encode_mimeheader.stub', 'mb_encode_numericentity' => 'stubs/ext/mbstring/mb_encode_numericentity.stub', 'mb_encoding_aliases' => 'stubs/ext/mbstring/mb_encoding_aliases.stub', 'mb_ereg' => 'stubs/ext/mbstring/mb_ereg.stub', 'mb_ereg_match' => 'stubs/ext/mbstring/mb_ereg_match.stub', 'mb_ereg_replace' => 'stubs/ext/mbstring/mb_ereg_replace.stub', 'mb_ereg_replace_callback' => 'stubs/ext/mbstring/mb_ereg_replace_callback.stub', 'mb_ereg_search' => 'stubs/ext/mbstring/mb_ereg_search.stub', 'mb_ereg_search_getpos' => 'stubs/ext/mbstring/mb_ereg_search_getpos.stub', 'mb_ereg_search_getregs' => 'stubs/ext/mbstring/mb_ereg_search_getregs.stub', 'mb_ereg_search_init' => 'stubs/ext/mbstring/mb_ereg_search_init.stub', 'mb_ereg_search_pos' => 'stubs/ext/mbstring/mb_ereg_search_pos.stub', 'mb_ereg_search_regs' => 'stubs/ext/mbstring/mb_ereg_search_regs.stub', 'mb_ereg_search_setpos' => 'stubs/ext/mbstring/mb_ereg_search_setpos.stub', 'mb_eregi' => 'stubs/ext/mbstring/mb_eregi.stub', 'mb_eregi_replace' => 'stubs/ext/mbstring/mb_eregi_replace.stub', 'mb_get_info' => 'stubs/ext/mbstring/mb_get_info.stub', 'mb_http_input' => 'stubs/ext/mbstring/mb_http_input.stub', 'mb_http_output' => 'stubs/ext/mbstring/mb_http_output.stub', 'mb_internal_encoding' => 'stubs/ext/mbstring/mb_internal_encoding.stub', 'mb_language' => 'stubs/ext/mbstring/mb_language.stub', 'mb_list_encodings' => 'stubs/ext/mbstring/mb_list_encodings.stub', 'mb_ord' => 'stubs/ext/mbstring/mb_ord.stub', 'mb_output_handler' => 'stubs/ext/mbstring/mb_output_handler.stub', 'mb_parse_str' => 'stubs/ext/mbstring/mb_parse_str.stub', 'mb_preferred_mime_name' => 'stubs/ext/mbstring/mb_preferred_mime_name.stub', 'mb_regex_encoding' => 'stubs/ext/mbstring/mb_regex_encoding.stub', 'mb_regex_set_options' => 'stubs/ext/mbstring/mb_regex_set_options.stub', 'mb_scrub' => 'stubs/ext/mbstring/mb_scrub.stub', 'mb_send_mail' => 'stubs/ext/mbstring/mb_send_mail.stub', 'mb_split' => 'stubs/ext/mbstring/mb_split.stub', 'mb_str_split' => 'stubs/ext/mbstring/mb_str_split.stub', 'mb_strcut' => 'stubs/ext/mbstring/mb_strcut.stub', 'mb_strimwidth' => 'stubs/ext/mbstring/mb_strimwidth.stub', 'mb_stripos' => 'stubs/ext/mbstring/mb_stripos.stub', 'mb_stristr' => 'stubs/ext/mbstring/mb_stristr.stub', 'mb_strlen' => 'stubs/ext/mbstring/mb_strlen.stub', 'mb_strpos' => 'stubs/ext/mbstring/mb_strpos.stub', 'mb_strrchr' => 'stubs/ext/mbstring/mb_strrchr.stub', 'mb_strrichr' => 'stubs/ext/mbstring/mb_strrichr.stub', 'mb_strripos' => 'stubs/ext/mbstring/mb_strripos.stub', 'mb_strrpos' => 'stubs/ext/mbstring/mb_strrpos.stub', 'mb_strstr' => 'stubs/ext/mbstring/mb_strstr.stub', 'mb_strtolower' => 'stubs/ext/mbstring/mb_strtolower.stub', 'mb_strtoupper' => 'stubs/ext/mbstring/mb_strtoupper.stub', 'mb_strwidth' => 'stubs/ext/mbstring/mb_strwidth.stub', 'mb_substitute_character' => 'stubs/ext/mbstring/mb_substitute_character.stub', 'mb_substr' => 'stubs/ext/mbstring/mb_substr.stub', 'mb_substr_count' => 'stubs/ext/mbstring/mb_substr_count.stub', 'md5' => 'stubs/ext/standard/md5.stub', 'md5_file' => 'stubs/ext/standard/md5_file.stub', 'memory_get_peak_usage' => 'stubs/ext/standard/memory_get_peak_usage.stub', 'memory_get_usage' => 'stubs/ext/standard/memory_get_usage.stub', 'metaphone' => 'stubs/ext/standard/metaphone.stub', 'method_exists' => 'stubs/Zend/method_exists.stub', 'mhash' => 'stubs/ext/hash/mhash.stub', 'mhash_count' => 'stubs/ext/hash/mhash_count.stub', 'mhash_get_block_size' => 'stubs/ext/hash/mhash_get_block_size.stub', 'mhash_get_hash_name' => 'stubs/ext/hash/mhash_get_hash_name.stub', 'mhash_keygen_s2k' => 'stubs/ext/hash/mhash_keygen_s2k.stub', 'microtime' => 'stubs/ext/standard/microtime.stub', 'mime_content_type' => 'stubs/ext/fileinfo/mime_content_type.stub', 'min' => 'stubs/ext/standard/min.stub', 'mkdir' => 'stubs/ext/standard/mkdir.stub', 'mktime' => 'stubs/ext/date/mktime.stub', 'move_uploaded_file' => 'stubs/ext/standard/move_uploaded_file.stub', 'msg_get_queue' => 'stubs/ext/sysvmsg/msg_get_queue.stub', 'msg_queue_exists' => 'stubs/ext/sysvmsg/msg_queue_exists.stub', 'msg_receive' => 'stubs/ext/sysvmsg/msg_receive.stub', 'msg_remove_queue' => 'stubs/ext/sysvmsg/msg_remove_queue.stub', 'msg_send' => 'stubs/ext/sysvmsg/msg_send.stub', 'msg_set_queue' => 'stubs/ext/sysvmsg/msg_set_queue.stub', 'msg_stat_queue' => 'stubs/ext/sysvmsg/msg_stat_queue.stub', 'msgfmt_create' => 'stubs/ext/intl/msgfmt_create.stub', 'msgfmt_format' => 'stubs/ext/intl/msgfmt_format.stub', 'msgfmt_format_message' => 'stubs/ext/intl/msgfmt_format_message.stub', 'msgfmt_get_error_code' => 'stubs/ext/intl/msgfmt_get_error_code.stub', 'msgfmt_get_error_message' => 'stubs/ext/intl/msgfmt_get_error_message.stub', 'msgfmt_get_locale' => 'stubs/ext/intl/msgfmt_get_locale.stub', 'msgfmt_get_pattern' => 'stubs/ext/intl/msgfmt_get_pattern.stub', 'msgfmt_parse' => 'stubs/ext/intl/msgfmt_parse.stub', 'msgfmt_parse_message' => 'stubs/ext/intl/msgfmt_parse_message.stub', 'msgfmt_set_pattern' => 'stubs/ext/intl/msgfmt_set_pattern.stub', 'mt_getrandmax' => 'stubs/ext/standard/mt_getrandmax.stub', 'mt_rand' => 'stubs/ext/standard/mt_rand.stub', 'mt_srand' => 'stubs/ext/standard/mt_srand.stub', 'mysqli_affected_rows' => 'stubs/ext/mysqli/mysqli_affected_rows.stub', 'mysqli_autocommit' => 'stubs/ext/mysqli/mysqli_autocommit.stub', 'mysqli_begin_transaction' => 'stubs/ext/mysqli/mysqli_begin_transaction.stub', 'mysqli_change_user' => 'stubs/ext/mysqli/mysqli_change_user.stub', 'mysqli_character_set_name' => 'stubs/ext/mysqli/mysqli_character_set_name.stub', 'mysqli_close' => 'stubs/ext/mysqli/mysqli_close.stub', 'mysqli_commit' => 'stubs/ext/mysqli/mysqli_commit.stub', 'mysqli_connect' => 'stubs/ext/mysqli/mysqli_connect.stub', 'mysqli_connect_errno' => 'stubs/ext/mysqli/mysqli_connect_errno.stub', 'mysqli_connect_error' => 'stubs/ext/mysqli/mysqli_connect_error.stub', 'mysqli_data_seek' => 'stubs/ext/mysqli/mysqli_data_seek.stub', 'mysqli_debug' => 'stubs/ext/mysqli/mysqli_debug.stub', 'mysqli_dump_debug_info' => 'stubs/ext/mysqli/mysqli_dump_debug_info.stub', 'mysqli_errno' => 'stubs/ext/mysqli/mysqli_errno.stub', 'mysqli_error' => 'stubs/ext/mysqli/mysqli_error.stub', 'mysqli_error_list' => 'stubs/ext/mysqli/mysqli_error_list.stub', 'mysqli_escape_string' => 'stubs/ext/mysqli/mysqli_escape_string.stub', 'mysqli_execute' => 'stubs/ext/mysqli/mysqli_execute.stub', 'mysqli_fetch_all' => 'stubs/ext/mysqli/mysqli_fetch_all.stub', 'mysqli_fetch_array' => 'stubs/ext/mysqli/mysqli_fetch_array.stub', 'mysqli_fetch_assoc' => 'stubs/ext/mysqli/mysqli_fetch_assoc.stub', 'mysqli_fetch_field' => 'stubs/ext/mysqli/mysqli_fetch_field.stub', 'mysqli_fetch_field_direct' => 'stubs/ext/mysqli/mysqli_fetch_field_direct.stub', 'mysqli_fetch_fields' => 'stubs/ext/mysqli/mysqli_fetch_fields.stub', 'mysqli_fetch_lengths' => 'stubs/ext/mysqli/mysqli_fetch_lengths.stub', 'mysqli_fetch_object' => 'stubs/ext/mysqli/mysqli_fetch_object.stub', 'mysqli_fetch_row' => 'stubs/ext/mysqli/mysqli_fetch_row.stub', 'mysqli_field_count' => 'stubs/ext/mysqli/mysqli_field_count.stub', 'mysqli_field_seek' => 'stubs/ext/mysqli/mysqli_field_seek.stub', 'mysqli_field_tell' => 'stubs/ext/mysqli/mysqli_field_tell.stub', 'mysqli_free_result' => 'stubs/ext/mysqli/mysqli_free_result.stub', 'mysqli_get_charset' => 'stubs/ext/mysqli/mysqli_get_charset.stub', 'mysqli_get_client_info' => 'stubs/ext/mysqli/mysqli_get_client_info.stub', 'mysqli_get_client_stats' => 'stubs/ext/mysqli/mysqli_get_client_stats.stub', 'mysqli_get_client_version' => 'stubs/ext/mysqli/mysqli_get_client_version.stub', 'mysqli_get_connection_stats' => 'stubs/ext/mysqli/mysqli_get_connection_stats.stub', 'mysqli_get_host_info' => 'stubs/ext/mysqli/mysqli_get_host_info.stub', 'mysqli_get_links_stats' => 'stubs/ext/mysqli/mysqli_get_links_stats.stub', 'mysqli_get_proto_info' => 'stubs/ext/mysqli/mysqli_get_proto_info.stub', 'mysqli_get_server_info' => 'stubs/ext/mysqli/mysqli_get_server_info.stub', 'mysqli_get_server_version' => 'stubs/ext/mysqli/mysqli_get_server_version.stub', 'mysqli_get_warnings' => 'stubs/ext/mysqli/mysqli_get_warnings.stub', 'mysqli_info' => 'stubs/ext/mysqli/mysqli_info.stub', 'mysqli_init' => 'stubs/ext/mysqli/mysqli_init.stub', 'mysqli_insert_id' => 'stubs/ext/mysqli/mysqli_insert_id.stub', 'mysqli_kill' => 'stubs/ext/mysqli/mysqli_kill.stub', 'mysqli_more_results' => 'stubs/ext/mysqli/mysqli_more_results.stub', 'mysqli_multi_query' => 'stubs/ext/mysqli/mysqli_multi_query.stub', 'mysqli_next_result' => 'stubs/ext/mysqli/mysqli_next_result.stub', 'mysqli_num_fields' => 'stubs/ext/mysqli/mysqli_num_fields.stub', 'mysqli_num_rows' => 'stubs/ext/mysqli/mysqli_num_rows.stub', 'mysqli_options' => 'stubs/ext/mysqli/mysqli_options.stub', 'mysqli_ping' => 'stubs/ext/mysqli/mysqli_ping.stub', 'mysqli_poll' => 'stubs/ext/mysqli/mysqli_poll.stub', 'mysqli_prepare' => 'stubs/ext/mysqli/mysqli_prepare.stub', 'mysqli_query' => 'stubs/ext/mysqli/mysqli_query.stub', 'mysqli_real_connect' => 'stubs/ext/mysqli/mysqli_real_connect.stub', 'mysqli_real_escape_string' => 'stubs/ext/mysqli/mysqli_real_escape_string.stub', 'mysqli_real_query' => 'stubs/ext/mysqli/mysqli_real_query.stub', 'mysqli_reap_async_query' => 'stubs/ext/mysqli/mysqli_reap_async_query.stub', 'mysqli_refresh' => 'stubs/ext/mysqli/mysqli_refresh.stub', 'mysqli_release_savepoint' => 'stubs/ext/mysqli/mysqli_release_savepoint.stub', 'mysqli_report' => 'stubs/ext/mysqli/mysqli_report.stub', 'mysqli_rollback' => 'stubs/ext/mysqli/mysqli_rollback.stub', 'mysqli_savepoint' => 'stubs/ext/mysqli/mysqli_savepoint.stub', 'mysqli_select_db' => 'stubs/ext/mysqli/mysqli_select_db.stub', 'mysqli_set_charset' => 'stubs/ext/mysqli/mysqli_set_charset.stub', 'mysqli_set_opt' => 'stubs/ext/mysqli/mysqli_set_opt.stub', 'mysqli_sqlstate' => 'stubs/ext/mysqli/mysqli_sqlstate.stub', 'mysqli_ssl_set' => 'stubs/ext/mysqli/mysqli_ssl_set.stub', 'mysqli_stat' => 'stubs/ext/mysqli/mysqli_stat.stub', 'mysqli_stmt_affected_rows' => 'stubs/ext/mysqli/mysqli_stmt_affected_rows.stub', 'mysqli_stmt_attr_get' => 'stubs/ext/mysqli/mysqli_stmt_attr_get.stub', 'mysqli_stmt_attr_set' => 'stubs/ext/mysqli/mysqli_stmt_attr_set.stub', 'mysqli_stmt_bind_param' => 'stubs/ext/mysqli/mysqli_stmt_bind_param.stub', 'mysqli_stmt_bind_result' => 'stubs/ext/mysqli/mysqli_stmt_bind_result.stub', 'mysqli_stmt_close' => 'stubs/ext/mysqli/mysqli_stmt_close.stub', 'mysqli_stmt_data_seek' => 'stubs/ext/mysqli/mysqli_stmt_data_seek.stub', 'mysqli_stmt_errno' => 'stubs/ext/mysqli/mysqli_stmt_errno.stub', 'mysqli_stmt_error' => 'stubs/ext/mysqli/mysqli_stmt_error.stub', 'mysqli_stmt_error_list' => 'stubs/ext/mysqli/mysqli_stmt_error_list.stub', 'mysqli_stmt_execute' => 'stubs/ext/mysqli/mysqli_stmt_execute.stub', 'mysqli_stmt_fetch' => 'stubs/ext/mysqli/mysqli_stmt_fetch.stub', 'mysqli_stmt_field_count' => 'stubs/ext/mysqli/mysqli_stmt_field_count.stub', 'mysqli_stmt_free_result' => 'stubs/ext/mysqli/mysqli_stmt_free_result.stub', 'mysqli_stmt_get_result' => 'stubs/ext/mysqli/mysqli_stmt_get_result.stub', 'mysqli_stmt_get_warnings' => 'stubs/ext/mysqli/mysqli_stmt_get_warnings.stub', 'mysqli_stmt_init' => 'stubs/ext/mysqli/mysqli_stmt_init.stub', 'mysqli_stmt_insert_id' => 'stubs/ext/mysqli/mysqli_stmt_insert_id.stub', 'mysqli_stmt_more_results' => 'stubs/ext/mysqli/mysqli_stmt_more_results.stub', 'mysqli_stmt_next_result' => 'stubs/ext/mysqli/mysqli_stmt_next_result.stub', 'mysqli_stmt_num_rows' => 'stubs/ext/mysqli/mysqli_stmt_num_rows.stub', 'mysqli_stmt_param_count' => 'stubs/ext/mysqli/mysqli_stmt_param_count.stub', 'mysqli_stmt_prepare' => 'stubs/ext/mysqli/mysqli_stmt_prepare.stub', 'mysqli_stmt_reset' => 'stubs/ext/mysqli/mysqli_stmt_reset.stub', 'mysqli_stmt_result_metadata' => 'stubs/ext/mysqli/mysqli_stmt_result_metadata.stub', 'mysqli_stmt_send_long_data' => 'stubs/ext/mysqli/mysqli_stmt_send_long_data.stub', 'mysqli_stmt_sqlstate' => 'stubs/ext/mysqli/mysqli_stmt_sqlstate.stub', 'mysqli_stmt_store_result' => 'stubs/ext/mysqli/mysqli_stmt_store_result.stub', 'mysqli_store_result' => 'stubs/ext/mysqli/mysqli_store_result.stub', 'mysqli_thread_id' => 'stubs/ext/mysqli/mysqli_thread_id.stub', 'mysqli_thread_safe' => 'stubs/ext/mysqli/mysqli_thread_safe.stub', 'mysqli_use_result' => 'stubs/ext/mysqli/mysqli_use_result.stub', 'mysqli_warning_count' => 'stubs/ext/mysqli/mysqli_warning_count.stub', 'natcasesort' => 'stubs/ext/standard/natcasesort.stub', 'natsort' => 'stubs/ext/standard/natsort.stub', 'net_get_interfaces' => 'stubs/ext/standard/net_get_interfaces.stub', 'next' => 'stubs/ext/standard/next.stub', 'ngettext' => 'stubs/ext/gettext/ngettext.stub', 'nl2br' => 'stubs/ext/standard/nl2br.stub', 'nl_langinfo' => 'stubs/ext/standard/nl_langinfo.stub', 'normalizer_get_raw_decomposition' => 'stubs/ext/intl/normalizer_get_raw_decomposition.stub', 'normalizer_is_normalized' => 'stubs/ext/intl/normalizer_is_normalized.stub', 'normalizer_normalize' => 'stubs/ext/intl/normalizer_normalize.stub', 'number_format' => 'stubs/ext/standard/number_format.stub', 'numfmt_create' => 'stubs/ext/intl/numfmt_create.stub', 'numfmt_format' => 'stubs/ext/intl/numfmt_format.stub', 'numfmt_format_currency' => 'stubs/ext/intl/numfmt_format_currency.stub', 'numfmt_get_attribute' => 'stubs/ext/intl/numfmt_get_attribute.stub', 'numfmt_get_error_code' => 'stubs/ext/intl/numfmt_get_error_code.stub', 'numfmt_get_error_message' => 'stubs/ext/intl/numfmt_get_error_message.stub', 'numfmt_get_locale' => 'stubs/ext/intl/numfmt_get_locale.stub', 'numfmt_get_pattern' => 'stubs/ext/intl/numfmt_get_pattern.stub', 'numfmt_get_symbol' => 'stubs/ext/intl/numfmt_get_symbol.stub', 'numfmt_get_text_attribute' => 'stubs/ext/intl/numfmt_get_text_attribute.stub', 'numfmt_parse' => 'stubs/ext/intl/numfmt_parse.stub', 'numfmt_parse_currency' => 'stubs/ext/intl/numfmt_parse_currency.stub', 'numfmt_set_attribute' => 'stubs/ext/intl/numfmt_set_attribute.stub', 'numfmt_set_pattern' => 'stubs/ext/intl/numfmt_set_pattern.stub', 'numfmt_set_symbol' => 'stubs/ext/intl/numfmt_set_symbol.stub', 'numfmt_set_text_attribute' => 'stubs/ext/intl/numfmt_set_text_attribute.stub', 'ob_clean' => 'stubs/ext/standard/ob_clean.stub', 'ob_end_clean' => 'stubs/ext/standard/ob_end_clean.stub', 'ob_end_flush' => 'stubs/ext/standard/ob_end_flush.stub', 'ob_flush' => 'stubs/ext/standard/ob_flush.stub', 'ob_get_clean' => 'stubs/ext/standard/ob_get_clean.stub', 'ob_get_contents' => 'stubs/ext/standard/ob_get_contents.stub', 'ob_get_flush' => 'stubs/ext/standard/ob_get_flush.stub', 'ob_get_length' => 'stubs/ext/standard/ob_get_length.stub', 'ob_get_level' => 'stubs/ext/standard/ob_get_level.stub', 'ob_get_status' => 'stubs/ext/standard/ob_get_status.stub', 'ob_gzhandler' => 'stubs/ext/zlib/ob_gzhandler.stub', 'ob_implicit_flush' => 'stubs/ext/standard/ob_implicit_flush.stub', 'ob_list_handlers' => 'stubs/ext/standard/ob_list_handlers.stub', 'ob_start' => 'stubs/ext/standard/ob_start.stub', 'oci_bind_array_by_name' => 'stubs/ext/oci8/oci_bind_array_by_name.stub', 'oci_bind_by_name' => 'stubs/ext/oci8/oci_bind_by_name.stub', 'oci_cancel' => 'stubs/ext/oci8/oci_cancel.stub', 'oci_client_version' => 'stubs/ext/oci8/oci_client_version.stub', 'oci_close' => 'stubs/ext/oci8/oci_close.stub', 'oci_collection_append' => 'stubs/ext/oci8/oci_collection_append.stub', 'oci_collection_assign' => 'stubs/ext/oci8/oci_collection_assign.stub', 'oci_collection_element_assign' => 'stubs/ext/oci8/oci_collection_element_assign.stub', 'oci_collection_element_get' => 'stubs/ext/oci8/oci_collection_element_get.stub', 'oci_collection_max' => 'stubs/ext/oci8/oci_collection_max.stub', 'oci_collection_size' => 'stubs/ext/oci8/oci_collection_size.stub', 'oci_collection_trim' => 'stubs/ext/oci8/oci_collection_trim.stub', 'oci_commit' => 'stubs/ext/oci8/oci_commit.stub', 'oci_connect' => 'stubs/ext/oci8/oci_connect.stub', 'oci_define_by_name' => 'stubs/ext/oci8/oci_define_by_name.stub', 'oci_error' => 'stubs/ext/oci8/oci_error.stub', 'oci_execute' => 'stubs/ext/oci8/oci_execute.stub', 'oci_fetch' => 'stubs/ext/oci8/oci_fetch.stub', 'oci_fetch_all' => 'stubs/ext/oci8/oci_fetch_all.stub', 'oci_fetch_array' => 'stubs/ext/oci8/oci_fetch_array.stub', 'oci_fetch_assoc' => 'stubs/ext/oci8/oci_fetch_assoc.stub', 'oci_fetch_object' => 'stubs/ext/oci8/oci_fetch_object.stub', 'oci_fetch_row' => 'stubs/ext/oci8/oci_fetch_row.stub', 'oci_field_is_null' => 'stubs/ext/oci8/oci_field_is_null.stub', 'oci_field_name' => 'stubs/ext/oci8/oci_field_name.stub', 'oci_field_precision' => 'stubs/ext/oci8/oci_field_precision.stub', 'oci_field_scale' => 'stubs/ext/oci8/oci_field_scale.stub', 'oci_field_size' => 'stubs/ext/oci8/oci_field_size.stub', 'oci_field_type' => 'stubs/ext/oci8/oci_field_type.stub', 'oci_field_type_raw' => 'stubs/ext/oci8/oci_field_type_raw.stub', 'oci_free_collection' => 'stubs/ext/oci8/oci_free_collection.stub', 'oci_free_cursor' => 'stubs/ext/oci8/oci_free_cursor.stub', 'oci_free_descriptor' => 'stubs/ext/oci8/oci_free_descriptor.stub', 'oci_free_statement' => 'stubs/ext/oci8/oci_free_statement.stub', 'oci_get_implicit_resultset' => 'stubs/ext/oci8/oci_get_implicit_resultset.stub', 'oci_lob_append' => 'stubs/ext/oci8/oci_lob_append.stub', 'oci_lob_copy' => 'stubs/ext/oci8/oci_lob_copy.stub', 'oci_lob_eof' => 'stubs/ext/oci8/oci_lob_eof.stub', 'oci_lob_erase' => 'stubs/ext/oci8/oci_lob_erase.stub', 'oci_lob_export' => 'stubs/ext/oci8/oci_lob_export.stub', 'oci_lob_flush' => 'stubs/ext/oci8/oci_lob_flush.stub', 'oci_lob_import' => 'stubs/ext/oci8/oci_lob_import.stub', 'oci_lob_is_equal' => 'stubs/ext/oci8/oci_lob_is_equal.stub', 'oci_lob_load' => 'stubs/ext/oci8/oci_lob_load.stub', 'oci_lob_read' => 'stubs/ext/oci8/oci_lob_read.stub', 'oci_lob_rewind' => 'stubs/ext/oci8/oci_lob_rewind.stub', 'oci_lob_save' => 'stubs/ext/oci8/oci_lob_save.stub', 'oci_lob_seek' => 'stubs/ext/oci8/oci_lob_seek.stub', 'oci_lob_size' => 'stubs/ext/oci8/oci_lob_size.stub', 'oci_lob_tell' => 'stubs/ext/oci8/oci_lob_tell.stub', 'oci_lob_truncate' => 'stubs/ext/oci8/oci_lob_truncate.stub', 'oci_lob_write' => 'stubs/ext/oci8/oci_lob_write.stub', 'oci_new_collection' => 'stubs/ext/oci8/oci_new_collection.stub', 'oci_new_connect' => 'stubs/ext/oci8/oci_new_connect.stub', 'oci_new_cursor' => 'stubs/ext/oci8/oci_new_cursor.stub', 'oci_new_descriptor' => 'stubs/ext/oci8/oci_new_descriptor.stub', 'oci_num_fields' => 'stubs/ext/oci8/oci_num_fields.stub', 'oci_num_rows' => 'stubs/ext/oci8/oci_num_rows.stub', 'oci_parse' => 'stubs/ext/oci8/oci_parse.stub', 'oci_password_change' => 'stubs/ext/oci8/oci_password_change.stub', 'oci_pconnect' => 'stubs/ext/oci8/oci_pconnect.stub', 'oci_register_taf_callback' => 'stubs/ext/oci8/oci_register_taf_callback.stub', 'oci_result' => 'stubs/ext/oci8/oci_result.stub', 'oci_rollback' => 'stubs/ext/oci8/oci_rollback.stub', 'oci_server_version' => 'stubs/ext/oci8/oci_server_version.stub', 'oci_set_action' => 'stubs/ext/oci8/oci_set_action.stub', 'oci_set_call_timeout' => 'stubs/ext/oci8/oci_set_call_timeout.stub', 'oci_set_client_identifier' => 'stubs/ext/oci8/oci_set_client_identifier.stub', 'oci_set_client_info' => 'stubs/ext/oci8/oci_set_client_info.stub', 'oci_set_db_operation' => 'stubs/ext/oci8/oci_set_db_operation.stub', 'oci_set_edition' => 'stubs/ext/oci8/oci_set_edition.stub', 'oci_set_module_name' => 'stubs/ext/oci8/oci_set_module_name.stub', 'oci_set_prefetch' => 'stubs/ext/oci8/oci_set_prefetch.stub', 'oci_statement_type' => 'stubs/ext/oci8/oci_statement_type.stub', 'oci_unregister_taf_callback' => 'stubs/ext/oci8/oci_unregister_taf_callback.stub', 'ocibindbyname' => 'stubs/ext/oci8/ocibindbyname.stub', 'ocicancel' => 'stubs/ext/oci8/ocicancel.stub', 'ocicollappend' => 'stubs/ext/oci8/ocicollappend.stub', 'ocicollassignelem' => 'stubs/ext/oci8/ocicollassignelem.stub', 'ocicollgetelem' => 'stubs/ext/oci8/ocicollgetelem.stub', 'ocicollmax' => 'stubs/ext/oci8/ocicollmax.stub', 'ocicollsize' => 'stubs/ext/oci8/ocicollsize.stub', 'ocicolltrim' => 'stubs/ext/oci8/ocicolltrim.stub', 'ocicolumnisnull' => 'stubs/ext/oci8/ocicolumnisnull.stub', 'ocicolumnname' => 'stubs/ext/oci8/ocicolumnname.stub', 'ocicolumnprecision' => 'stubs/ext/oci8/ocicolumnprecision.stub', 'ocicolumnscale' => 'stubs/ext/oci8/ocicolumnscale.stub', 'ocicolumnsize' => 'stubs/ext/oci8/ocicolumnsize.stub', 'ocicolumntype' => 'stubs/ext/oci8/ocicolumntype.stub', 'ocicolumntyperaw' => 'stubs/ext/oci8/ocicolumntyperaw.stub', 'ocicommit' => 'stubs/ext/oci8/ocicommit.stub', 'ocidefinebyname' => 'stubs/ext/oci8/ocidefinebyname.stub', 'ocierror' => 'stubs/ext/oci8/ocierror.stub', 'ociexecute' => 'stubs/ext/oci8/ociexecute.stub', 'ocifetch' => 'stubs/ext/oci8/ocifetch.stub', 'ocifetchinto' => 'stubs/ext/oci8/ocifetchinto.stub', 'ocifetchstatement' => 'stubs/ext/oci8/ocifetchstatement.stub', 'ocifreecollection' => 'stubs/ext/oci8/ocifreecollection.stub', 'ocifreecursor' => 'stubs/ext/oci8/ocifreecursor.stub', 'ocifreedesc' => 'stubs/ext/oci8/ocifreedesc.stub', 'ocifreestatement' => 'stubs/ext/oci8/ocifreestatement.stub', 'ocigetbufferinglob' => 'stubs/ext/oci8/ocigetbufferinglob.stub', 'ociloadlob' => 'stubs/ext/oci8/ociloadlob.stub', 'ocilogoff' => 'stubs/ext/oci8/ocilogoff.stub', 'ocilogon' => 'stubs/ext/oci8/ocilogon.stub', 'ocinewcollection' => 'stubs/ext/oci8/ocinewcollection.stub', 'ocinewcursor' => 'stubs/ext/oci8/ocinewcursor.stub', 'ocinewdescriptor' => 'stubs/ext/oci8/ocinewdescriptor.stub', 'ocinlogon' => 'stubs/ext/oci8/ocinlogon.stub', 'ocinumcols' => 'stubs/ext/oci8/ocinumcols.stub', 'ociparse' => 'stubs/ext/oci8/ociparse.stub', 'ocipasswordchange' => 'stubs/ext/oci8/ocipasswordchange.stub', 'ociplogon' => 'stubs/ext/oci8/ociplogon.stub', 'ociresult' => 'stubs/ext/oci8/ociresult.stub', 'ocirollback' => 'stubs/ext/oci8/ocirollback.stub', 'ocirowcount' => 'stubs/ext/oci8/ocirowcount.stub', 'ocisavelob' => 'stubs/ext/oci8/ocisavelob.stub', 'ocisavelobfile' => 'stubs/ext/oci8/ocisavelobfile.stub', 'ociserverversion' => 'stubs/ext/oci8/ociserverversion.stub', 'ocisetbufferinglob' => 'stubs/ext/oci8/ocisetbufferinglob.stub', 'ocisetprefetch' => 'stubs/ext/oci8/ocisetprefetch.stub', 'ocistatementtype' => 'stubs/ext/oci8/ocistatementtype.stub', 'ociwritelobtofile' => 'stubs/ext/oci8/ociwritelobtofile.stub', 'octdec' => 'stubs/ext/standard/octdec.stub', 'odbc_autocommit' => 'stubs/ext/odbc/odbc_autocommit.stub', 'odbc_binmode' => 'stubs/ext/odbc/odbc_binmode.stub', 'odbc_close' => 'stubs/ext/odbc/odbc_close.stub', 'odbc_close_all' => 'stubs/ext/odbc/odbc_close_all.stub', 'odbc_columnprivileges' => 'stubs/ext/odbc/odbc_columnprivileges.stub', 'odbc_columns' => 'stubs/ext/odbc/odbc_columns.stub', 'odbc_commit' => 'stubs/ext/odbc/odbc_commit.stub', 'odbc_connect' => 'stubs/ext/odbc/odbc_connect.stub', 'odbc_cursor' => 'stubs/ext/odbc/odbc_cursor.stub', 'odbc_data_source' => 'stubs/ext/odbc/odbc_data_source.stub', 'odbc_do' => 'stubs/ext/odbc/odbc_do.stub', 'odbc_error' => 'stubs/ext/odbc/odbc_error.stub', 'odbc_errormsg' => 'stubs/ext/odbc/odbc_errormsg.stub', 'odbc_exec' => 'stubs/ext/odbc/odbc_exec.stub', 'odbc_execute' => 'stubs/ext/odbc/odbc_execute.stub', 'odbc_fetch_array' => 'stubs/ext/odbc/odbc_fetch_array.stub', 'odbc_fetch_into' => 'stubs/ext/odbc/odbc_fetch_into.stub', 'odbc_fetch_object' => 'stubs/ext/odbc/odbc_fetch_object.stub', 'odbc_fetch_row' => 'stubs/ext/odbc/odbc_fetch_row.stub', 'odbc_field_len' => 'stubs/ext/odbc/odbc_field_len.stub', 'odbc_field_name' => 'stubs/ext/odbc/odbc_field_name.stub', 'odbc_field_num' => 'stubs/ext/odbc/odbc_field_num.stub', 'odbc_field_precision' => 'stubs/ext/odbc/odbc_field_precision.stub', 'odbc_field_scale' => 'stubs/ext/odbc/odbc_field_scale.stub', 'odbc_field_type' => 'stubs/ext/odbc/odbc_field_type.stub', 'odbc_foreignkeys' => 'stubs/ext/odbc/odbc_foreignkeys.stub', 'odbc_free_result' => 'stubs/ext/odbc/odbc_free_result.stub', 'odbc_gettypeinfo' => 'stubs/ext/odbc/odbc_gettypeinfo.stub', 'odbc_longreadlen' => 'stubs/ext/odbc/odbc_longreadlen.stub', 'odbc_next_result' => 'stubs/ext/odbc/odbc_next_result.stub', 'odbc_num_fields' => 'stubs/ext/odbc/odbc_num_fields.stub', 'odbc_num_rows' => 'stubs/ext/odbc/odbc_num_rows.stub', 'odbc_pconnect' => 'stubs/ext/odbc/odbc_pconnect.stub', 'odbc_prepare' => 'stubs/ext/odbc/odbc_prepare.stub', 'odbc_primarykeys' => 'stubs/ext/odbc/odbc_primarykeys.stub', 'odbc_procedurecolumns' => 'stubs/ext/odbc/odbc_procedurecolumns.stub', 'odbc_procedures' => 'stubs/ext/odbc/odbc_procedures.stub', 'odbc_result' => 'stubs/ext/odbc/odbc_result.stub', 'odbc_result_all' => 'stubs/ext/odbc/odbc_result_all.stub', 'odbc_rollback' => 'stubs/ext/odbc/odbc_rollback.stub', 'odbc_setoption' => 'stubs/ext/odbc/odbc_setoption.stub', 'odbc_specialcolumns' => 'stubs/ext/odbc/odbc_specialcolumns.stub', 'odbc_statistics' => 'stubs/ext/odbc/odbc_statistics.stub', 'odbc_tableprivileges' => 'stubs/ext/odbc/odbc_tableprivileges.stub', 'odbc_tables' => 'stubs/ext/odbc/odbc_tables.stub', 'opcache_compile_file' => 'stubs/ext/opcache/opcache_compile_file.stub', 'opcache_get_configuration' => 'stubs/ext/opcache/opcache_get_configuration.stub', 'opcache_get_status' => 'stubs/ext/opcache/opcache_get_status.stub', 'opcache_invalidate' => 'stubs/ext/opcache/opcache_invalidate.stub', 'opcache_is_script_cached' => 'stubs/ext/opcache/opcache_is_script_cached.stub', 'opcache_reset' => 'stubs/ext/opcache/opcache_reset.stub', 'opendir' => 'stubs/ext/standard/opendir.stub', 'openlog' => 'stubs/ext/standard/openlog.stub', 'openssl_cipher_iv_length' => 'stubs/ext/openssl/openssl_cipher_iv_length.stub', 'openssl_cms_decrypt' => 'stubs/ext/openssl/openssl_cms_decrypt.stub', 'openssl_cms_encrypt' => 'stubs/ext/openssl/openssl_cms_encrypt.stub', 'openssl_cms_read' => 'stubs/ext/openssl/openssl_cms_read.stub', 'openssl_cms_sign' => 'stubs/ext/openssl/openssl_cms_sign.stub', 'openssl_cms_verify' => 'stubs/ext/openssl/openssl_cms_verify.stub', 'openssl_csr_export' => 'stubs/ext/openssl/openssl_csr_export.stub', 'openssl_csr_export_to_file' => 'stubs/ext/openssl/openssl_csr_export_to_file.stub', 'openssl_csr_get_public_key' => 'stubs/ext/openssl/openssl_csr_get_public_key.stub', 'openssl_csr_get_subject' => 'stubs/ext/openssl/openssl_csr_get_subject.stub', 'openssl_csr_new' => 'stubs/ext/openssl/openssl_csr_new.stub', 'openssl_csr_sign' => 'stubs/ext/openssl/openssl_csr_sign.stub', 'openssl_decrypt' => 'stubs/ext/openssl/openssl_decrypt.stub', 'openssl_dh_compute_key' => 'stubs/ext/openssl/openssl_dh_compute_key.stub', 'openssl_digest' => 'stubs/ext/openssl/openssl_digest.stub', 'openssl_encrypt' => 'stubs/ext/openssl/openssl_encrypt.stub', 'openssl_error_string' => 'stubs/ext/openssl/openssl_error_string.stub', 'openssl_free_key' => 'stubs/ext/openssl/openssl_free_key.stub', 'openssl_get_cert_locations' => 'stubs/ext/openssl/openssl_get_cert_locations.stub', 'openssl_get_cipher_methods' => 'stubs/ext/openssl/openssl_get_cipher_methods.stub', 'openssl_get_curve_names' => 'stubs/ext/openssl/openssl_get_curve_names.stub', 'openssl_get_md_methods' => 'stubs/ext/openssl/openssl_get_md_methods.stub', 'openssl_get_privatekey' => 'stubs/ext/openssl/openssl_get_privatekey.stub', 'openssl_get_publickey' => 'stubs/ext/openssl/openssl_get_publickey.stub', 'openssl_open' => 'stubs/ext/openssl/openssl_open.stub', 'openssl_pbkdf2' => 'stubs/ext/openssl/openssl_pbkdf2.stub', 'openssl_pkcs12_export' => 'stubs/ext/openssl/openssl_pkcs12_export.stub', 'openssl_pkcs12_export_to_file' => 'stubs/ext/openssl/openssl_pkcs12_export_to_file.stub', 'openssl_pkcs12_read' => 'stubs/ext/openssl/openssl_pkcs12_read.stub', 'openssl_pkcs7_decrypt' => 'stubs/ext/openssl/openssl_pkcs7_decrypt.stub', 'openssl_pkcs7_encrypt' => 'stubs/ext/openssl/openssl_pkcs7_encrypt.stub', 'openssl_pkcs7_read' => 'stubs/ext/openssl/openssl_pkcs7_read.stub', 'openssl_pkcs7_sign' => 'stubs/ext/openssl/openssl_pkcs7_sign.stub', 'openssl_pkcs7_verify' => 'stubs/ext/openssl/openssl_pkcs7_verify.stub', 'openssl_pkey_derive' => 'stubs/ext/openssl/openssl_pkey_derive.stub', 'openssl_pkey_export' => 'stubs/ext/openssl/openssl_pkey_export.stub', 'openssl_pkey_export_to_file' => 'stubs/ext/openssl/openssl_pkey_export_to_file.stub', 'openssl_pkey_free' => 'stubs/ext/openssl/openssl_pkey_free.stub', 'openssl_pkey_get_details' => 'stubs/ext/openssl/openssl_pkey_get_details.stub', 'openssl_pkey_get_private' => 'stubs/ext/openssl/openssl_pkey_get_private.stub', 'openssl_pkey_get_public' => 'stubs/ext/openssl/openssl_pkey_get_public.stub', 'openssl_pkey_new' => 'stubs/ext/openssl/openssl_pkey_new.stub', 'openssl_private_decrypt' => 'stubs/ext/openssl/openssl_private_decrypt.stub', 'openssl_private_encrypt' => 'stubs/ext/openssl/openssl_private_encrypt.stub', 'openssl_public_decrypt' => 'stubs/ext/openssl/openssl_public_decrypt.stub', 'openssl_public_encrypt' => 'stubs/ext/openssl/openssl_public_encrypt.stub', 'openssl_random_pseudo_bytes' => 'stubs/ext/openssl/openssl_random_pseudo_bytes.stub', 'openssl_seal' => 'stubs/ext/openssl/openssl_seal.stub', 'openssl_sign' => 'stubs/ext/openssl/openssl_sign.stub', 'openssl_spki_export' => 'stubs/ext/openssl/openssl_spki_export.stub', 'openssl_spki_export_challenge' => 'stubs/ext/openssl/openssl_spki_export_challenge.stub', 'openssl_spki_new' => 'stubs/ext/openssl/openssl_spki_new.stub', 'openssl_spki_verify' => 'stubs/ext/openssl/openssl_spki_verify.stub', 'openssl_verify' => 'stubs/ext/openssl/openssl_verify.stub', 'openssl_x509_check_private_key' => 'stubs/ext/openssl/openssl_x509_check_private_key.stub', 'openssl_x509_checkpurpose' => 'stubs/ext/openssl/openssl_x509_checkpurpose.stub', 'openssl_x509_export' => 'stubs/ext/openssl/openssl_x509_export.stub', 'openssl_x509_export_to_file' => 'stubs/ext/openssl/openssl_x509_export_to_file.stub', 'openssl_x509_fingerprint' => 'stubs/ext/openssl/openssl_x509_fingerprint.stub', 'openssl_x509_free' => 'stubs/ext/openssl/openssl_x509_free.stub', 'openssl_x509_parse' => 'stubs/ext/openssl/openssl_x509_parse.stub', 'openssl_x509_read' => 'stubs/ext/openssl/openssl_x509_read.stub', 'openssl_x509_verify' => 'stubs/ext/openssl/openssl_x509_verify.stub', 'ord' => 'stubs/ext/standard/ord.stub', 'output_add_rewrite_var' => 'stubs/ext/standard/output_add_rewrite_var.stub', 'output_reset_rewrite_vars' => 'stubs/ext/standard/output_reset_rewrite_vars.stub', 'pack' => 'stubs/ext/standard/pack.stub', 'parse_ini_file' => 'stubs/ext/standard/parse_ini_file.stub', 'parse_ini_string' => 'stubs/ext/standard/parse_ini_string.stub', 'parse_str' => 'stubs/ext/standard/parse_str.stub', 'parse_url' => 'stubs/ext/standard/parse_url.stub', 'passthru' => 'stubs/ext/standard/passthru.stub', 'password_algos' => 'stubs/ext/standard/password_algos.stub', 'password_get_info' => 'stubs/ext/standard/password_get_info.stub', 'password_hash' => 'stubs/ext/standard/password_hash.stub', 'password_needs_rehash' => 'stubs/ext/standard/password_needs_rehash.stub', 'password_verify' => 'stubs/ext/standard/password_verify.stub', 'pathinfo' => 'stubs/ext/standard/pathinfo.stub', 'pclose' => 'stubs/ext/standard/pclose.stub', 'pcntl_alarm' => 'stubs/ext/pcntl/pcntl_alarm.stub', 'pcntl_async_signals' => 'stubs/ext/pcntl/pcntl_async_signals.stub', 'pcntl_errno' => 'stubs/ext/pcntl/pcntl_errno.stub', 'pcntl_exec' => 'stubs/ext/pcntl/pcntl_exec.stub', 'pcntl_fork' => 'stubs/ext/pcntl/pcntl_fork.stub', 'pcntl_get_last_error' => 'stubs/ext/pcntl/pcntl_get_last_error.stub', 'pcntl_getpriority' => 'stubs/ext/pcntl/pcntl_getpriority.stub', 'pcntl_setpriority' => 'stubs/ext/pcntl/pcntl_setpriority.stub', 'pcntl_signal' => 'stubs/ext/pcntl/pcntl_signal.stub', 'pcntl_signal_dispatch' => 'stubs/ext/pcntl/pcntl_signal_dispatch.stub', 'pcntl_signal_get_handler' => 'stubs/ext/pcntl/pcntl_signal_get_handler.stub', 'pcntl_sigprocmask' => 'stubs/ext/pcntl/pcntl_sigprocmask.stub', 'pcntl_sigtimedwait' => 'stubs/ext/pcntl/pcntl_sigtimedwait.stub', 'pcntl_sigwaitinfo' => 'stubs/ext/pcntl/pcntl_sigwaitinfo.stub', 'pcntl_strerror' => 'stubs/ext/pcntl/pcntl_strerror.stub', 'pcntl_unshare' => 'stubs/ext/pcntl/pcntl_unshare.stub', 'pcntl_wait' => 'stubs/ext/pcntl/pcntl_wait.stub', 'pcntl_waitpid' => 'stubs/ext/pcntl/pcntl_waitpid.stub', 'pcntl_wexitstatus' => 'stubs/ext/pcntl/pcntl_wexitstatus.stub', 'pcntl_wifcontinued' => 'stubs/ext/pcntl/pcntl_wifcontinued.stub', 'pcntl_wifexited' => 'stubs/ext/pcntl/pcntl_wifexited.stub', 'pcntl_wifsignaled' => 'stubs/ext/pcntl/pcntl_wifsignaled.stub', 'pcntl_wifstopped' => 'stubs/ext/pcntl/pcntl_wifstopped.stub', 'pcntl_wstopsig' => 'stubs/ext/pcntl/pcntl_wstopsig.stub', 'pcntl_wtermsig' => 'stubs/ext/pcntl/pcntl_wtermsig.stub', 'pdo_drivers' => 'stubs/ext/pdo/pdo_drivers.stub', 'pfsockopen' => 'stubs/ext/standard/pfsockopen.stub', 'pg_affected_rows' => 'stubs/ext/pgsql/pg_affected_rows.stub', 'pg_cancel_query' => 'stubs/ext/pgsql/pg_cancel_query.stub', 'pg_client_encoding' => 'stubs/ext/pgsql/pg_client_encoding.stub', 'pg_clientencoding' => 'stubs/ext/pgsql/pg_clientencoding.stub', 'pg_close' => 'stubs/ext/pgsql/pg_close.stub', 'pg_cmdtuples' => 'stubs/ext/pgsql/pg_cmdtuples.stub', 'pg_connect' => 'stubs/ext/pgsql/pg_connect.stub', 'pg_connect_poll' => 'stubs/ext/pgsql/pg_connect_poll.stub', 'pg_connection_busy' => 'stubs/ext/pgsql/pg_connection_busy.stub', 'pg_connection_reset' => 'stubs/ext/pgsql/pg_connection_reset.stub', 'pg_connection_status' => 'stubs/ext/pgsql/pg_connection_status.stub', 'pg_consume_input' => 'stubs/ext/pgsql/pg_consume_input.stub', 'pg_convert' => 'stubs/ext/pgsql/pg_convert.stub', 'pg_copy_from' => 'stubs/ext/pgsql/pg_copy_from.stub', 'pg_copy_to' => 'stubs/ext/pgsql/pg_copy_to.stub', 'pg_dbname' => 'stubs/ext/pgsql/pg_dbname.stub', 'pg_delete' => 'stubs/ext/pgsql/pg_delete.stub', 'pg_end_copy' => 'stubs/ext/pgsql/pg_end_copy.stub', 'pg_errormessage' => 'stubs/ext/pgsql/pg_errormessage.stub', 'pg_escape_bytea' => 'stubs/ext/pgsql/pg_escape_bytea.stub', 'pg_escape_identifier' => 'stubs/ext/pgsql/pg_escape_identifier.stub', 'pg_escape_literal' => 'stubs/ext/pgsql/pg_escape_literal.stub', 'pg_escape_string' => 'stubs/ext/pgsql/pg_escape_string.stub', 'pg_exec' => 'stubs/ext/pgsql/pg_exec.stub', 'pg_execute' => 'stubs/ext/pgsql/pg_execute.stub', 'pg_fetch_all' => 'stubs/ext/pgsql/pg_fetch_all.stub', 'pg_fetch_all_columns' => 'stubs/ext/pgsql/pg_fetch_all_columns.stub', 'pg_fetch_array' => 'stubs/ext/pgsql/pg_fetch_array.stub', 'pg_fetch_assoc' => 'stubs/ext/pgsql/pg_fetch_assoc.stub', 'pg_fetch_object' => 'stubs/ext/pgsql/pg_fetch_object.stub', 'pg_fetch_result' => 'stubs/ext/pgsql/pg_fetch_result.stub', 'pg_fetch_row' => 'stubs/ext/pgsql/pg_fetch_row.stub', 'pg_field_is_null' => 'stubs/ext/pgsql/pg_field_is_null.stub', 'pg_field_name' => 'stubs/ext/pgsql/pg_field_name.stub', 'pg_field_num' => 'stubs/ext/pgsql/pg_field_num.stub', 'pg_field_prtlen' => 'stubs/ext/pgsql/pg_field_prtlen.stub', 'pg_field_size' => 'stubs/ext/pgsql/pg_field_size.stub', 'pg_field_table' => 'stubs/ext/pgsql/pg_field_table.stub', 'pg_field_type' => 'stubs/ext/pgsql/pg_field_type.stub', 'pg_field_type_oid' => 'stubs/ext/pgsql/pg_field_type_oid.stub', 'pg_fieldisnull' => 'stubs/ext/pgsql/pg_fieldisnull.stub', 'pg_fieldname' => 'stubs/ext/pgsql/pg_fieldname.stub', 'pg_fieldnum' => 'stubs/ext/pgsql/pg_fieldnum.stub', 'pg_fieldprtlen' => 'stubs/ext/pgsql/pg_fieldprtlen.stub', 'pg_fieldsize' => 'stubs/ext/pgsql/pg_fieldsize.stub', 'pg_fieldtype' => 'stubs/ext/pgsql/pg_fieldtype.stub', 'pg_flush' => 'stubs/ext/pgsql/pg_flush.stub', 'pg_free_result' => 'stubs/ext/pgsql/pg_free_result.stub', 'pg_freeresult' => 'stubs/ext/pgsql/pg_freeresult.stub', 'pg_get_notify' => 'stubs/ext/pgsql/pg_get_notify.stub', 'pg_get_pid' => 'stubs/ext/pgsql/pg_get_pid.stub', 'pg_get_result' => 'stubs/ext/pgsql/pg_get_result.stub', 'pg_getlastoid' => 'stubs/ext/pgsql/pg_getlastoid.stub', 'pg_host' => 'stubs/ext/pgsql/pg_host.stub', 'pg_insert' => 'stubs/ext/pgsql/pg_insert.stub', 'pg_last_error' => 'stubs/ext/pgsql/pg_last_error.stub', 'pg_last_notice' => 'stubs/ext/pgsql/pg_last_notice.stub', 'pg_last_oid' => 'stubs/ext/pgsql/pg_last_oid.stub', 'pg_lo_close' => 'stubs/ext/pgsql/pg_lo_close.stub', 'pg_lo_create' => 'stubs/ext/pgsql/pg_lo_create.stub', 'pg_lo_export' => 'stubs/ext/pgsql/pg_lo_export.stub', 'pg_lo_import' => 'stubs/ext/pgsql/pg_lo_import.stub', 'pg_lo_open' => 'stubs/ext/pgsql/pg_lo_open.stub', 'pg_lo_read' => 'stubs/ext/pgsql/pg_lo_read.stub', 'pg_lo_read_all' => 'stubs/ext/pgsql/pg_lo_read_all.stub', 'pg_lo_seek' => 'stubs/ext/pgsql/pg_lo_seek.stub', 'pg_lo_tell' => 'stubs/ext/pgsql/pg_lo_tell.stub', 'pg_lo_truncate' => 'stubs/ext/pgsql/pg_lo_truncate.stub', 'pg_lo_unlink' => 'stubs/ext/pgsql/pg_lo_unlink.stub', 'pg_lo_write' => 'stubs/ext/pgsql/pg_lo_write.stub', 'pg_loclose' => 'stubs/ext/pgsql/pg_loclose.stub', 'pg_locreate' => 'stubs/ext/pgsql/pg_locreate.stub', 'pg_loexport' => 'stubs/ext/pgsql/pg_loexport.stub', 'pg_loimport' => 'stubs/ext/pgsql/pg_loimport.stub', 'pg_loopen' => 'stubs/ext/pgsql/pg_loopen.stub', 'pg_loread' => 'stubs/ext/pgsql/pg_loread.stub', 'pg_loreadall' => 'stubs/ext/pgsql/pg_loreadall.stub', 'pg_lounlink' => 'stubs/ext/pgsql/pg_lounlink.stub', 'pg_lowrite' => 'stubs/ext/pgsql/pg_lowrite.stub', 'pg_meta_data' => 'stubs/ext/pgsql/pg_meta_data.stub', 'pg_num_fields' => 'stubs/ext/pgsql/pg_num_fields.stub', 'pg_num_rows' => 'stubs/ext/pgsql/pg_num_rows.stub', 'pg_numfields' => 'stubs/ext/pgsql/pg_numfields.stub', 'pg_numrows' => 'stubs/ext/pgsql/pg_numrows.stub', 'pg_options' => 'stubs/ext/pgsql/pg_options.stub', 'pg_parameter_status' => 'stubs/ext/pgsql/pg_parameter_status.stub', 'pg_pconnect' => 'stubs/ext/pgsql/pg_pconnect.stub', 'pg_ping' => 'stubs/ext/pgsql/pg_ping.stub', 'pg_port' => 'stubs/ext/pgsql/pg_port.stub', 'pg_prepare' => 'stubs/ext/pgsql/pg_prepare.stub', 'pg_put_line' => 'stubs/ext/pgsql/pg_put_line.stub', 'pg_query' => 'stubs/ext/pgsql/pg_query.stub', 'pg_query_params' => 'stubs/ext/pgsql/pg_query_params.stub', 'pg_result' => 'stubs/ext/pgsql/pg_result.stub', 'pg_result_error' => 'stubs/ext/pgsql/pg_result_error.stub', 'pg_result_error_field' => 'stubs/ext/pgsql/pg_result_error_field.stub', 'pg_result_seek' => 'stubs/ext/pgsql/pg_result_seek.stub', 'pg_result_status' => 'stubs/ext/pgsql/pg_result_status.stub', 'pg_select' => 'stubs/ext/pgsql/pg_select.stub', 'pg_send_execute' => 'stubs/ext/pgsql/pg_send_execute.stub', 'pg_send_prepare' => 'stubs/ext/pgsql/pg_send_prepare.stub', 'pg_send_query' => 'stubs/ext/pgsql/pg_send_query.stub', 'pg_send_query_params' => 'stubs/ext/pgsql/pg_send_query_params.stub', 'pg_set_client_encoding' => 'stubs/ext/pgsql/pg_set_client_encoding.stub', 'pg_set_error_verbosity' => 'stubs/ext/pgsql/pg_set_error_verbosity.stub', 'pg_setclientencoding' => 'stubs/ext/pgsql/pg_setclientencoding.stub', 'pg_socket' => 'stubs/ext/pgsql/pg_socket.stub', 'pg_trace' => 'stubs/ext/pgsql/pg_trace.stub', 'pg_transaction_status' => 'stubs/ext/pgsql/pg_transaction_status.stub', 'pg_tty' => 'stubs/ext/pgsql/pg_tty.stub', 'pg_unescape_bytea' => 'stubs/ext/pgsql/pg_unescape_bytea.stub', 'pg_untrace' => 'stubs/ext/pgsql/pg_untrace.stub', 'pg_update' => 'stubs/ext/pgsql/pg_update.stub', 'pg_version' => 'stubs/ext/pgsql/pg_version.stub', 'php_ini_loaded_file' => 'stubs/ext/standard/php_ini_loaded_file.stub', 'php_ini_scanned_files' => 'stubs/ext/standard/php_ini_scanned_files.stub', 'php_sapi_name' => 'stubs/ext/standard/php_sapi_name.stub', 'php_strip_whitespace' => 'stubs/ext/standard/php_strip_whitespace.stub', 'php_uname' => 'stubs/ext/standard/php_uname.stub', 'phpcredits' => 'stubs/ext/standard/phpcredits.stub', 'phpdbg_break_file' => 'stubs/sapi/phpdbg/phpdbg_break_file.stub', 'phpdbg_break_function' => 'stubs/sapi/phpdbg/phpdbg_break_function.stub', 'phpdbg_break_method' => 'stubs/sapi/phpdbg/phpdbg_break_method.stub', 'phpdbg_break_next' => 'stubs/sapi/phpdbg/phpdbg_break_next.stub', 'phpdbg_clear' => 'stubs/sapi/phpdbg/phpdbg_clear.stub', 'phpdbg_color' => 'stubs/sapi/phpdbg/phpdbg_color.stub', 'phpdbg_end_oplog' => 'stubs/sapi/phpdbg/phpdbg_end_oplog.stub', 'phpdbg_exec' => 'stubs/sapi/phpdbg/phpdbg_exec.stub', 'phpdbg_get_executable' => 'stubs/sapi/phpdbg/phpdbg_get_executable.stub', 'phpdbg_prompt' => 'stubs/sapi/phpdbg/phpdbg_prompt.stub', 'phpdbg_start_oplog' => 'stubs/sapi/phpdbg/phpdbg_start_oplog.stub', 'phpinfo' => 'stubs/ext/standard/phpinfo.stub', 'phpversion' => 'stubs/ext/standard/phpversion.stub', 'pi' => 'stubs/ext/standard/pi.stub', 'popen' => 'stubs/ext/standard/popen.stub', 'pos' => 'stubs/ext/standard/pos.stub', 'posix_access' => 'stubs/ext/posix/posix_access.stub', 'posix_ctermid' => 'stubs/ext/posix/posix_ctermid.stub', 'posix_errno' => 'stubs/ext/posix/posix_errno.stub', 'posix_get_last_error' => 'stubs/ext/posix/posix_get_last_error.stub', 'posix_getcwd' => 'stubs/ext/posix/posix_getcwd.stub', 'posix_getegid' => 'stubs/ext/posix/posix_getegid.stub', 'posix_geteuid' => 'stubs/ext/posix/posix_geteuid.stub', 'posix_getgid' => 'stubs/ext/posix/posix_getgid.stub', 'posix_getgrgid' => 'stubs/ext/posix/posix_getgrgid.stub', 'posix_getgrnam' => 'stubs/ext/posix/posix_getgrnam.stub', 'posix_getgroups' => 'stubs/ext/posix/posix_getgroups.stub', 'posix_getlogin' => 'stubs/ext/posix/posix_getlogin.stub', 'posix_getpgid' => 'stubs/ext/posix/posix_getpgid.stub', 'posix_getpgrp' => 'stubs/ext/posix/posix_getpgrp.stub', 'posix_getpid' => 'stubs/ext/posix/posix_getpid.stub', 'posix_getppid' => 'stubs/ext/posix/posix_getppid.stub', 'posix_getpwnam' => 'stubs/ext/posix/posix_getpwnam.stub', 'posix_getpwuid' => 'stubs/ext/posix/posix_getpwuid.stub', 'posix_getrlimit' => 'stubs/ext/posix/posix_getrlimit.stub', 'posix_getsid' => 'stubs/ext/posix/posix_getsid.stub', 'posix_getuid' => 'stubs/ext/posix/posix_getuid.stub', 'posix_initgroups' => 'stubs/ext/posix/posix_initgroups.stub', 'posix_isatty' => 'stubs/ext/posix/posix_isatty.stub', 'posix_kill' => 'stubs/ext/posix/posix_kill.stub', 'posix_mkfifo' => 'stubs/ext/posix/posix_mkfifo.stub', 'posix_mknod' => 'stubs/ext/posix/posix_mknod.stub', 'posix_setegid' => 'stubs/ext/posix/posix_setegid.stub', 'posix_seteuid' => 'stubs/ext/posix/posix_seteuid.stub', 'posix_setgid' => 'stubs/ext/posix/posix_setgid.stub', 'posix_setpgid' => 'stubs/ext/posix/posix_setpgid.stub', 'posix_setrlimit' => 'stubs/ext/posix/posix_setrlimit.stub', 'posix_setsid' => 'stubs/ext/posix/posix_setsid.stub', 'posix_setuid' => 'stubs/ext/posix/posix_setuid.stub', 'posix_strerror' => 'stubs/ext/posix/posix_strerror.stub', 'posix_times' => 'stubs/ext/posix/posix_times.stub', 'posix_ttyname' => 'stubs/ext/posix/posix_ttyname.stub', 'posix_uname' => 'stubs/ext/posix/posix_uname.stub', 'pow' => 'stubs/ext/standard/pow.stub', 'preg_filter' => 'stubs/ext/pcre/preg_filter.stub', 'preg_grep' => 'stubs/ext/pcre/preg_grep.stub', 'preg_last_error' => 'stubs/ext/pcre/preg_last_error.stub', 'preg_last_error_msg' => 'stubs/ext/pcre/preg_last_error_msg.stub', 'preg_match' => 'stubs/ext/pcre/preg_match.stub', 'preg_match_all' => 'stubs/ext/pcre/preg_match_all.stub', 'preg_quote' => 'stubs/ext/pcre/preg_quote.stub', 'preg_replace' => 'stubs/ext/pcre/preg_replace.stub', 'preg_replace_callback' => 'stubs/ext/pcre/preg_replace_callback.stub', 'preg_replace_callback_array' => 'stubs/ext/pcre/preg_replace_callback_array.stub', 'preg_split' => 'stubs/ext/pcre/preg_split.stub', 'prev' => 'stubs/ext/standard/prev.stub', 'print_r' => 'stubs/ext/standard/print_r.stub', 'printf' => 'stubs/ext/standard/printf.stub', 'proc_close' => 'stubs/ext/standard/proc_close.stub', 'proc_get_status' => 'stubs/ext/standard/proc_get_status.stub', 'proc_nice' => 'stubs/ext/standard/proc_nice.stub', 'proc_open' => 'stubs/ext/standard/proc_open.stub', 'proc_terminate' => 'stubs/ext/standard/proc_terminate.stub', 'property_exists' => 'stubs/Zend/property_exists.stub', 'pspell_add_to_personal' => 'stubs/ext/pspell/pspell_add_to_personal.stub', 'pspell_add_to_session' => 'stubs/ext/pspell/pspell_add_to_session.stub', 'pspell_check' => 'stubs/ext/pspell/pspell_check.stub', 'pspell_clear_session' => 'stubs/ext/pspell/pspell_clear_session.stub', 'pspell_config_create' => 'stubs/ext/pspell/pspell_config_create.stub', 'pspell_config_data_dir' => 'stubs/ext/pspell/pspell_config_data_dir.stub', 'pspell_config_dict_dir' => 'stubs/ext/pspell/pspell_config_dict_dir.stub', 'pspell_config_ignore' => 'stubs/ext/pspell/pspell_config_ignore.stub', 'pspell_config_mode' => 'stubs/ext/pspell/pspell_config_mode.stub', 'pspell_config_personal' => 'stubs/ext/pspell/pspell_config_personal.stub', 'pspell_config_repl' => 'stubs/ext/pspell/pspell_config_repl.stub', 'pspell_config_runtogether' => 'stubs/ext/pspell/pspell_config_runtogether.stub', 'pspell_config_save_repl' => 'stubs/ext/pspell/pspell_config_save_repl.stub', 'pspell_new' => 'stubs/ext/pspell/pspell_new.stub', 'pspell_new_config' => 'stubs/ext/pspell/pspell_new_config.stub', 'pspell_new_personal' => 'stubs/ext/pspell/pspell_new_personal.stub', 'pspell_save_wordlist' => 'stubs/ext/pspell/pspell_save_wordlist.stub', 'pspell_store_replacement' => 'stubs/ext/pspell/pspell_store_replacement.stub', 'pspell_suggest' => 'stubs/ext/pspell/pspell_suggest.stub', 'putenv' => 'stubs/ext/standard/putenv.stub', 'quoted_printable_decode' => 'stubs/ext/standard/quoted_printable_decode.stub', 'quoted_printable_encode' => 'stubs/ext/standard/quoted_printable_encode.stub', 'quotemeta' => 'stubs/ext/standard/quotemeta.stub', 'rad2deg' => 'stubs/ext/standard/rad2deg.stub', 'rand' => 'stubs/ext/standard/rand.stub', 'random_bytes' => 'stubs/ext/standard/random_bytes.stub', 'random_int' => 'stubs/ext/standard/random_int.stub', 'range' => 'stubs/ext/standard/range.stub', 'rawurldecode' => 'stubs/ext/standard/rawurldecode.stub', 'rawurlencode' => 'stubs/ext/standard/rawurlencode.stub', 'readdir' => 'stubs/ext/standard/readdir.stub', 'readfile' => 'stubs/ext/standard/readfile.stub', 'readgzfile' => 'stubs/ext/zlib/readgzfile.stub', 'readline' => 'stubs/ext/readline/readline.stub', 'readline_add_history' => 'stubs/ext/readline/readline_add_history.stub', 'readline_callback_handler_install' => 'stubs/ext/readline/readline_callback_handler_install.stub', 'readline_callback_handler_remove' => 'stubs/ext/readline/readline_callback_handler_remove.stub', 'readline_callback_read_char' => 'stubs/ext/readline/readline_callback_read_char.stub', 'readline_clear_history' => 'stubs/ext/readline/readline_clear_history.stub', 'readline_completion_function' => 'stubs/ext/readline/readline_completion_function.stub', 'readline_info' => 'stubs/ext/readline/readline_info.stub', 'readline_list_history' => 'stubs/ext/readline/readline_list_history.stub', 'readline_on_new_line' => 'stubs/ext/readline/readline_on_new_line.stub', 'readline_read_history' => 'stubs/ext/readline/readline_read_history.stub', 'readline_redisplay' => 'stubs/ext/readline/readline_redisplay.stub', 'readline_write_history' => 'stubs/ext/readline/readline_write_history.stub', 'readlink' => 'stubs/ext/standard/readlink.stub', 'realpath' => 'stubs/ext/standard/realpath.stub', 'realpath_cache_get' => 'stubs/ext/standard/realpath_cache_get.stub', 'realpath_cache_size' => 'stubs/ext/standard/realpath_cache_size.stub', 'register_shutdown_function' => 'stubs/ext/standard/register_shutdown_function.stub', 'register_tick_function' => 'stubs/ext/standard/register_tick_function.stub', 'rename' => 'stubs/ext/standard/rename.stub', 'reset' => 'stubs/ext/standard/reset.stub', 'resourcebundle_count' => 'stubs/ext/intl/resourcebundle_count.stub', 'resourcebundle_create' => 'stubs/ext/intl/resourcebundle_create.stub', 'resourcebundle_get' => 'stubs/ext/intl/resourcebundle_get.stub', 'resourcebundle_get_error_code' => 'stubs/ext/intl/resourcebundle_get_error_code.stub', 'resourcebundle_get_error_message' => 'stubs/ext/intl/resourcebundle_get_error_message.stub', 'resourcebundle_locales' => 'stubs/ext/intl/resourcebundle_locales.stub', 'restore_error_handler' => 'stubs/Zend/restore_error_handler.stub', 'restore_exception_handler' => 'stubs/Zend/restore_exception_handler.stub', 'rewind' => 'stubs/ext/standard/rewind.stub', 'rewinddir' => 'stubs/ext/standard/rewinddir.stub', 'rmdir' => 'stubs/ext/standard/rmdir.stub', 'round' => 'stubs/ext/standard/round.stub', 'rsort' => 'stubs/ext/standard/rsort.stub', 'rtrim' => 'stubs/ext/standard/rtrim.stub', 'sapi_windows_cp_conv' => 'stubs/ext/standard/sapi_windows_cp_conv.stub', 'sapi_windows_cp_get' => 'stubs/ext/standard/sapi_windows_cp_get.stub', 'sapi_windows_cp_is_utf8' => 'stubs/ext/standard/sapi_windows_cp_is_utf8.stub', 'sapi_windows_cp_set' => 'stubs/ext/standard/sapi_windows_cp_set.stub', 'sapi_windows_generate_ctrl_event' => 'stubs/ext/standard/sapi_windows_generate_ctrl_event.stub', 'sapi_windows_set_ctrl_handler' => 'stubs/ext/standard/sapi_windows_set_ctrl_handler.stub', 'sapi_windows_vt100_support' => 'stubs/ext/standard/sapi_windows_vt100_support.stub', 'scandir' => 'stubs/ext/standard/scandir.stub', 'sem_acquire' => 'stubs/ext/sysvsem/sem_acquire.stub', 'sem_get' => 'stubs/ext/sysvsem/sem_get.stub', 'sem_release' => 'stubs/ext/sysvsem/sem_release.stub', 'sem_remove' => 'stubs/ext/sysvsem/sem_remove.stub', 'serialize' => 'stubs/ext/standard/serialize.stub', 'session_abort' => 'stubs/ext/session/session_abort.stub', 'session_cache_expire' => 'stubs/ext/session/session_cache_expire.stub', 'session_cache_limiter' => 'stubs/ext/session/session_cache_limiter.stub', 'session_commit' => 'stubs/ext/session/session_commit.stub', 'session_create_id' => 'stubs/ext/session/session_create_id.stub', 'session_decode' => 'stubs/ext/session/session_decode.stub', 'session_destroy' => 'stubs/ext/session/session_destroy.stub', 'session_encode' => 'stubs/ext/session/session_encode.stub', 'session_gc' => 'stubs/ext/session/session_gc.stub', 'session_get_cookie_params' => 'stubs/ext/session/session_get_cookie_params.stub', 'session_id' => 'stubs/ext/session/session_id.stub', 'session_module_name' => 'stubs/ext/session/session_module_name.stub', 'session_name' => 'stubs/ext/session/session_name.stub', 'session_regenerate_id' => 'stubs/ext/session/session_regenerate_id.stub', 'session_register_shutdown' => 'stubs/ext/session/session_register_shutdown.stub', 'session_reset' => 'stubs/ext/session/session_reset.stub', 'session_save_path' => 'stubs/ext/session/session_save_path.stub', 'session_set_cookie_params' => 'stubs/ext/session/session_set_cookie_params.stub', 'session_set_save_handler' => 'stubs/ext/session/session_set_save_handler.stub', 'session_start' => 'stubs/ext/session/session_start.stub', 'session_status' => 'stubs/ext/session/session_status.stub', 'session_unset' => 'stubs/ext/session/session_unset.stub', 'session_write_close' => 'stubs/ext/session/session_write_close.stub', 'set_error_handler' => 'stubs/Zend/set_error_handler.stub', 'set_exception_handler' => 'stubs/Zend/set_exception_handler.stub', 'set_file_buffer' => 'stubs/ext/standard/set_file_buffer.stub', 'set_include_path' => 'stubs/ext/standard/set_include_path.stub', 'set_time_limit' => 'stubs/ext/standard/set_time_limit.stub', 'setcookie' => 'stubs/ext/standard/setcookie.stub', 'setlocale' => 'stubs/ext/standard/setlocale.stub', 'setrawcookie' => 'stubs/ext/standard/setrawcookie.stub', 'settype' => 'stubs/ext/standard/settype.stub', 'sha1' => 'stubs/ext/standard/sha1.stub', 'sha1_file' => 'stubs/ext/standard/sha1_file.stub', 'shell_exec' => 'stubs/ext/standard/shell_exec.stub', 'shm_attach' => 'stubs/ext/sysvshm/shm_attach.stub', 'shm_detach' => 'stubs/ext/sysvshm/shm_detach.stub', 'shm_get_var' => 'stubs/ext/sysvshm/shm_get_var.stub', 'shm_has_var' => 'stubs/ext/sysvshm/shm_has_var.stub', 'shm_put_var' => 'stubs/ext/sysvshm/shm_put_var.stub', 'shm_remove' => 'stubs/ext/sysvshm/shm_remove.stub', 'shm_remove_var' => 'stubs/ext/sysvshm/shm_remove_var.stub', 'shmop_close' => 'stubs/ext/shmop/shmop_close.stub', 'shmop_delete' => 'stubs/ext/shmop/shmop_delete.stub', 'shmop_open' => 'stubs/ext/shmop/shmop_open.stub', 'shmop_read' => 'stubs/ext/shmop/shmop_read.stub', 'shmop_size' => 'stubs/ext/shmop/shmop_size.stub', 'shmop_write' => 'stubs/ext/shmop/shmop_write.stub', 'show_source' => 'stubs/ext/standard/show_source.stub', 'shuffle' => 'stubs/ext/standard/shuffle.stub', 'similar_text' => 'stubs/ext/standard/similar_text.stub', 'simplexml_import_dom' => 'stubs/ext/simplexml/simplexml_import_dom.stub', 'simplexml_load_file' => 'stubs/ext/simplexml/simplexml_load_file.stub', 'simplexml_load_string' => 'stubs/ext/simplexml/simplexml_load_string.stub', 'sin' => 'stubs/ext/standard/sin.stub', 'sinh' => 'stubs/ext/standard/sinh.stub', 'sizeof' => 'stubs/ext/standard/sizeof.stub', 'sleep' => 'stubs/ext/standard/sleep.stub', 'snmp2_get' => 'stubs/ext/snmp/snmp2_get.stub', 'snmp2_getnext' => 'stubs/ext/snmp/snmp2_getnext.stub', 'snmp2_real_walk' => 'stubs/ext/snmp/snmp2_real_walk.stub', 'snmp2_set' => 'stubs/ext/snmp/snmp2_set.stub', 'snmp2_walk' => 'stubs/ext/snmp/snmp2_walk.stub', 'snmp3_get' => 'stubs/ext/snmp/snmp3_get.stub', 'snmp3_getnext' => 'stubs/ext/snmp/snmp3_getnext.stub', 'snmp3_real_walk' => 'stubs/ext/snmp/snmp3_real_walk.stub', 'snmp3_set' => 'stubs/ext/snmp/snmp3_set.stub', 'snmp3_walk' => 'stubs/ext/snmp/snmp3_walk.stub', 'snmp_get_quick_print' => 'stubs/ext/snmp/snmp_get_quick_print.stub', 'snmp_get_valueretrieval' => 'stubs/ext/snmp/snmp_get_valueretrieval.stub', 'snmp_read_mib' => 'stubs/ext/snmp/snmp_read_mib.stub', 'snmp_set_enum_print' => 'stubs/ext/snmp/snmp_set_enum_print.stub', 'snmp_set_oid_numeric_print' => 'stubs/ext/snmp/snmp_set_oid_numeric_print.stub', 'snmp_set_oid_output_format' => 'stubs/ext/snmp/snmp_set_oid_output_format.stub', 'snmp_set_quick_print' => 'stubs/ext/snmp/snmp_set_quick_print.stub', 'snmp_set_valueretrieval' => 'stubs/ext/snmp/snmp_set_valueretrieval.stub', 'snmpget' => 'stubs/ext/snmp/snmpget.stub', 'snmpgetnext' => 'stubs/ext/snmp/snmpgetnext.stub', 'snmprealwalk' => 'stubs/ext/snmp/snmprealwalk.stub', 'snmpset' => 'stubs/ext/snmp/snmpset.stub', 'snmpwalk' => 'stubs/ext/snmp/snmpwalk.stub', 'snmpwalkoid' => 'stubs/ext/snmp/snmpwalkoid.stub', 'socket_accept' => 'stubs/ext/sockets/socket_accept.stub', 'socket_addrinfo_bind' => 'stubs/ext/sockets/socket_addrinfo_bind.stub', 'socket_addrinfo_connect' => 'stubs/ext/sockets/socket_addrinfo_connect.stub', 'socket_addrinfo_explain' => 'stubs/ext/sockets/socket_addrinfo_explain.stub', 'socket_addrinfo_lookup' => 'stubs/ext/sockets/socket_addrinfo_lookup.stub', 'socket_bind' => 'stubs/ext/sockets/socket_bind.stub', 'socket_clear_error' => 'stubs/ext/sockets/socket_clear_error.stub', 'socket_close' => 'stubs/ext/sockets/socket_close.stub', 'socket_cmsg_space' => 'stubs/ext/sockets/socket_cmsg_space.stub', 'socket_connect' => 'stubs/ext/sockets/socket_connect.stub', 'socket_create' => 'stubs/ext/sockets/socket_create.stub', 'socket_create_listen' => 'stubs/ext/sockets/socket_create_listen.stub', 'socket_create_pair' => 'stubs/ext/sockets/socket_create_pair.stub', 'socket_export_stream' => 'stubs/ext/sockets/socket_export_stream.stub', 'socket_get_option' => 'stubs/ext/sockets/socket_get_option.stub', 'socket_get_status' => 'stubs/ext/standard/socket_get_status.stub', 'socket_getopt' => 'stubs/ext/sockets/socket_getopt.stub', 'socket_getpeername' => 'stubs/ext/sockets/socket_getpeername.stub', 'socket_getsockname' => 'stubs/ext/sockets/socket_getsockname.stub', 'socket_import_stream' => 'stubs/ext/sockets/socket_import_stream.stub', 'socket_last_error' => 'stubs/ext/sockets/socket_last_error.stub', 'socket_listen' => 'stubs/ext/sockets/socket_listen.stub', 'socket_read' => 'stubs/ext/sockets/socket_read.stub', 'socket_recv' => 'stubs/ext/sockets/socket_recv.stub', 'socket_recvfrom' => 'stubs/ext/sockets/socket_recvfrom.stub', 'socket_recvmsg' => 'stubs/ext/sockets/socket_recvmsg.stub', 'socket_select' => 'stubs/ext/sockets/socket_select.stub', 'socket_send' => 'stubs/ext/sockets/socket_send.stub', 'socket_sendmsg' => 'stubs/ext/sockets/socket_sendmsg.stub', 'socket_sendto' => 'stubs/ext/sockets/socket_sendto.stub', 'socket_set_block' => 'stubs/ext/sockets/socket_set_block.stub', 'socket_set_blocking' => 'stubs/ext/standard/socket_set_blocking.stub', 'socket_set_nonblock' => 'stubs/ext/sockets/socket_set_nonblock.stub', 'socket_set_option' => 'stubs/ext/sockets/socket_set_option.stub', 'socket_set_timeout' => 'stubs/ext/standard/socket_set_timeout.stub', 'socket_setopt' => 'stubs/ext/sockets/socket_setopt.stub', 'socket_shutdown' => 'stubs/ext/sockets/socket_shutdown.stub', 'socket_strerror' => 'stubs/ext/sockets/socket_strerror.stub', 'socket_write' => 'stubs/ext/sockets/socket_write.stub', 'socket_wsaprotocol_info_export' => 'stubs/ext/sockets/socket_wsaprotocol_info_export.stub', 'socket_wsaprotocol_info_import' => 'stubs/ext/sockets/socket_wsaprotocol_info_import.stub', 'socket_wsaprotocol_info_release' => 'stubs/ext/sockets/socket_wsaprotocol_info_release.stub', 'sodium_add' => 'stubs/ext/sodium/sodium_add.stub', 'sodium_base642bin' => 'stubs/ext/sodium/sodium_base642bin.stub', 'sodium_bin2base64' => 'stubs/ext/sodium/sodium_bin2base64.stub', 'sodium_bin2hex' => 'stubs/ext/sodium/sodium_bin2hex.stub', 'sodium_compare' => 'stubs/ext/sodium/sodium_compare.stub', 'sodium_crypto_aead_aes256gcm_decrypt' => 'stubs/ext/sodium/sodium_crypto_aead_aes256gcm_decrypt.stub', 'sodium_crypto_aead_aes256gcm_encrypt' => 'stubs/ext/sodium/sodium_crypto_aead_aes256gcm_encrypt.stub', 'sodium_crypto_aead_aes256gcm_is_available' => 'stubs/ext/sodium/sodium_crypto_aead_aes256gcm_is_available.stub', 'sodium_crypto_aead_aes256gcm_keygen' => 'stubs/ext/sodium/sodium_crypto_aead_aes256gcm_keygen.stub', 'sodium_crypto_aead_chacha20poly1305_decrypt' => 'stubs/ext/sodium/sodium_crypto_aead_chacha20poly1305_decrypt.stub', 'sodium_crypto_aead_chacha20poly1305_encrypt' => 'stubs/ext/sodium/sodium_crypto_aead_chacha20poly1305_encrypt.stub', 'sodium_crypto_aead_chacha20poly1305_ietf_decrypt' => 'stubs/ext/sodium/sodium_crypto_aead_chacha20poly1305_ietf_decrypt.stub', 'sodium_crypto_aead_chacha20poly1305_ietf_encrypt' => 'stubs/ext/sodium/sodium_crypto_aead_chacha20poly1305_ietf_encrypt.stub', 'sodium_crypto_aead_chacha20poly1305_ietf_keygen' => 'stubs/ext/sodium/sodium_crypto_aead_chacha20poly1305_ietf_keygen.stub', 'sodium_crypto_aead_chacha20poly1305_keygen' => 'stubs/ext/sodium/sodium_crypto_aead_chacha20poly1305_keygen.stub', 'sodium_crypto_aead_xchacha20poly1305_ietf_decrypt' => 'stubs/ext/sodium/sodium_crypto_aead_xchacha20poly1305_ietf_decrypt.stub', 'sodium_crypto_aead_xchacha20poly1305_ietf_encrypt' => 'stubs/ext/sodium/sodium_crypto_aead_xchacha20poly1305_ietf_encrypt.stub', 'sodium_crypto_aead_xchacha20poly1305_ietf_keygen' => 'stubs/ext/sodium/sodium_crypto_aead_xchacha20poly1305_ietf_keygen.stub', 'sodium_crypto_auth' => 'stubs/ext/sodium/sodium_crypto_auth.stub', 'sodium_crypto_auth_keygen' => 'stubs/ext/sodium/sodium_crypto_auth_keygen.stub', 'sodium_crypto_auth_verify' => 'stubs/ext/sodium/sodium_crypto_auth_verify.stub', 'sodium_crypto_box' => 'stubs/ext/sodium/sodium_crypto_box.stub', 'sodium_crypto_box_keypair' => 'stubs/ext/sodium/sodium_crypto_box_keypair.stub', 'sodium_crypto_box_keypair_from_secretkey_and_publickey' => 'stubs/ext/sodium/sodium_crypto_box_keypair_from_secretkey_and_publickey.stub', 'sodium_crypto_box_open' => 'stubs/ext/sodium/sodium_crypto_box_open.stub', 'sodium_crypto_box_publickey' => 'stubs/ext/sodium/sodium_crypto_box_publickey.stub', 'sodium_crypto_box_publickey_from_secretkey' => 'stubs/ext/sodium/sodium_crypto_box_publickey_from_secretkey.stub', 'sodium_crypto_box_seal' => 'stubs/ext/sodium/sodium_crypto_box_seal.stub', 'sodium_crypto_box_seal_open' => 'stubs/ext/sodium/sodium_crypto_box_seal_open.stub', 'sodium_crypto_box_secretkey' => 'stubs/ext/sodium/sodium_crypto_box_secretkey.stub', 'sodium_crypto_box_seed_keypair' => 'stubs/ext/sodium/sodium_crypto_box_seed_keypair.stub', 'sodium_crypto_generichash' => 'stubs/ext/sodium/sodium_crypto_generichash.stub', 'sodium_crypto_generichash_final' => 'stubs/ext/sodium/sodium_crypto_generichash_final.stub', 'sodium_crypto_generichash_init' => 'stubs/ext/sodium/sodium_crypto_generichash_init.stub', 'sodium_crypto_generichash_keygen' => 'stubs/ext/sodium/sodium_crypto_generichash_keygen.stub', 'sodium_crypto_generichash_update' => 'stubs/ext/sodium/sodium_crypto_generichash_update.stub', 'sodium_crypto_kdf_derive_from_key' => 'stubs/ext/sodium/sodium_crypto_kdf_derive_from_key.stub', 'sodium_crypto_kdf_keygen' => 'stubs/ext/sodium/sodium_crypto_kdf_keygen.stub', 'sodium_crypto_kx_client_session_keys' => 'stubs/ext/sodium/sodium_crypto_kx_client_session_keys.stub', 'sodium_crypto_kx_keypair' => 'stubs/ext/sodium/sodium_crypto_kx_keypair.stub', 'sodium_crypto_kx_publickey' => 'stubs/ext/sodium/sodium_crypto_kx_publickey.stub', 'sodium_crypto_kx_secretkey' => 'stubs/ext/sodium/sodium_crypto_kx_secretkey.stub', 'sodium_crypto_kx_seed_keypair' => 'stubs/ext/sodium/sodium_crypto_kx_seed_keypair.stub', 'sodium_crypto_kx_server_session_keys' => 'stubs/ext/sodium/sodium_crypto_kx_server_session_keys.stub', 'sodium_crypto_pwhash' => 'stubs/ext/sodium/sodium_crypto_pwhash.stub', 'sodium_crypto_pwhash_scryptsalsa208sha256' => 'stubs/ext/sodium/sodium_crypto_pwhash_scryptsalsa208sha256.stub', 'sodium_crypto_pwhash_scryptsalsa208sha256_str' => 'stubs/ext/sodium/sodium_crypto_pwhash_scryptsalsa208sha256_str.stub', 'sodium_crypto_pwhash_scryptsalsa208sha256_str_verify' => 'stubs/ext/sodium/sodium_crypto_pwhash_scryptsalsa208sha256_str_verify.stub', 'sodium_crypto_pwhash_str' => 'stubs/ext/sodium/sodium_crypto_pwhash_str.stub', 'sodium_crypto_pwhash_str_needs_rehash' => 'stubs/ext/sodium/sodium_crypto_pwhash_str_needs_rehash.stub', 'sodium_crypto_pwhash_str_verify' => 'stubs/ext/sodium/sodium_crypto_pwhash_str_verify.stub', 'sodium_crypto_scalarmult' => 'stubs/ext/sodium/sodium_crypto_scalarmult.stub', 'sodium_crypto_scalarmult_base' => 'stubs/ext/sodium/sodium_crypto_scalarmult_base.stub', 'sodium_crypto_secretbox' => 'stubs/ext/sodium/sodium_crypto_secretbox.stub', 'sodium_crypto_secretbox_keygen' => 'stubs/ext/sodium/sodium_crypto_secretbox_keygen.stub', 'sodium_crypto_secretbox_open' => 'stubs/ext/sodium/sodium_crypto_secretbox_open.stub', 'sodium_crypto_secretstream_xchacha20poly1305_init_pull' => 'stubs/ext/sodium/sodium_crypto_secretstream_xchacha20poly1305_init_pull.stub', 'sodium_crypto_secretstream_xchacha20poly1305_init_push' => 'stubs/ext/sodium/sodium_crypto_secretstream_xchacha20poly1305_init_push.stub', 'sodium_crypto_secretstream_xchacha20poly1305_keygen' => 'stubs/ext/sodium/sodium_crypto_secretstream_xchacha20poly1305_keygen.stub', 'sodium_crypto_secretstream_xchacha20poly1305_pull' => 'stubs/ext/sodium/sodium_crypto_secretstream_xchacha20poly1305_pull.stub', 'sodium_crypto_secretstream_xchacha20poly1305_push' => 'stubs/ext/sodium/sodium_crypto_secretstream_xchacha20poly1305_push.stub', 'sodium_crypto_secretstream_xchacha20poly1305_rekey' => 'stubs/ext/sodium/sodium_crypto_secretstream_xchacha20poly1305_rekey.stub', 'sodium_crypto_shorthash' => 'stubs/ext/sodium/sodium_crypto_shorthash.stub', 'sodium_crypto_shorthash_keygen' => 'stubs/ext/sodium/sodium_crypto_shorthash_keygen.stub', 'sodium_crypto_sign' => 'stubs/ext/sodium/sodium_crypto_sign.stub', 'sodium_crypto_sign_detached' => 'stubs/ext/sodium/sodium_crypto_sign_detached.stub', 'sodium_crypto_sign_ed25519_pk_to_curve25519' => 'stubs/ext/sodium/sodium_crypto_sign_ed25519_pk_to_curve25519.stub', 'sodium_crypto_sign_ed25519_sk_to_curve25519' => 'stubs/ext/sodium/sodium_crypto_sign_ed25519_sk_to_curve25519.stub', 'sodium_crypto_sign_keypair' => 'stubs/ext/sodium/sodium_crypto_sign_keypair.stub', 'sodium_crypto_sign_keypair_from_secretkey_and_publickey' => 'stubs/ext/sodium/sodium_crypto_sign_keypair_from_secretkey_and_publickey.stub', 'sodium_crypto_sign_open' => 'stubs/ext/sodium/sodium_crypto_sign_open.stub', 'sodium_crypto_sign_publickey' => 'stubs/ext/sodium/sodium_crypto_sign_publickey.stub', 'sodium_crypto_sign_publickey_from_secretkey' => 'stubs/ext/sodium/sodium_crypto_sign_publickey_from_secretkey.stub', 'sodium_crypto_sign_secretkey' => 'stubs/ext/sodium/sodium_crypto_sign_secretkey.stub', 'sodium_crypto_sign_seed_keypair' => 'stubs/ext/sodium/sodium_crypto_sign_seed_keypair.stub', 'sodium_crypto_sign_verify_detached' => 'stubs/ext/sodium/sodium_crypto_sign_verify_detached.stub', 'sodium_crypto_stream' => 'stubs/ext/sodium/sodium_crypto_stream.stub', 'sodium_crypto_stream_keygen' => 'stubs/ext/sodium/sodium_crypto_stream_keygen.stub', 'sodium_crypto_stream_xor' => 'stubs/ext/sodium/sodium_crypto_stream_xor.stub', 'sodium_hex2bin' => 'stubs/ext/sodium/sodium_hex2bin.stub', 'sodium_increment' => 'stubs/ext/sodium/sodium_increment.stub', 'sodium_memcmp' => 'stubs/ext/sodium/sodium_memcmp.stub', 'sodium_memzero' => 'stubs/ext/sodium/sodium_memzero.stub', 'sodium_pad' => 'stubs/ext/sodium/sodium_pad.stub', 'sodium_unpad' => 'stubs/ext/sodium/sodium_unpad.stub', 'sort' => 'stubs/ext/standard/sort.stub', 'soundex' => 'stubs/ext/standard/soundex.stub', 'spl_autoload' => 'stubs/ext/spl/spl_autoload.stub', 'spl_autoload_call' => 'stubs/ext/spl/spl_autoload_call.stub', 'spl_autoload_extensions' => 'stubs/ext/spl/spl_autoload_extensions.stub', 'spl_autoload_functions' => 'stubs/ext/spl/spl_autoload_functions.stub', 'spl_autoload_register' => 'stubs/ext/spl/spl_autoload_register.stub', 'spl_autoload_unregister' => 'stubs/ext/spl/spl_autoload_unregister.stub', 'spl_classes' => 'stubs/ext/spl/spl_classes.stub', 'spl_object_hash' => 'stubs/ext/spl/spl_object_hash.stub', 'spl_object_id' => 'stubs/ext/spl/spl_object_id.stub', 'sprintf' => 'stubs/ext/standard/sprintf.stub', 'sqrt' => 'stubs/ext/standard/sqrt.stub', 'srand' => 'stubs/ext/standard/srand.stub', 'sscanf' => 'stubs/ext/standard/sscanf.stub', 'stat' => 'stubs/ext/standard/stat.stub', 'str_contains' => 'stubs/ext/standard/str_contains.stub', 'str_ends_with' => 'stubs/ext/standard/str_ends_with.stub', 'str_getcsv' => 'stubs/ext/standard/str_getcsv.stub', 'str_ireplace' => 'stubs/ext/standard/str_ireplace.stub', 'str_pad' => 'stubs/ext/standard/str_pad.stub', 'str_repeat' => 'stubs/ext/standard/str_repeat.stub', 'str_replace' => 'stubs/ext/standard/str_replace.stub', 'str_rot13' => 'stubs/ext/standard/str_rot13.stub', 'str_shuffle' => 'stubs/ext/standard/str_shuffle.stub', 'str_split' => 'stubs/ext/standard/str_split.stub', 'str_starts_with' => 'stubs/ext/standard/str_starts_with.stub', 'str_word_count' => 'stubs/ext/standard/str_word_count.stub', 'strcasecmp' => 'stubs/Zend/strcasecmp.stub', 'strchr' => 'stubs/ext/standard/strchr.stub', 'strcmp' => 'stubs/Zend/strcmp.stub', 'strcoll' => 'stubs/ext/standard/strcoll.stub', 'strcspn' => 'stubs/ext/standard/strcspn.stub', 'stream_bucket_append' => 'stubs/ext/standard/stream_bucket_append.stub', 'stream_bucket_make_writeable' => 'stubs/ext/standard/stream_bucket_make_writeable.stub', 'stream_bucket_new' => 'stubs/ext/standard/stream_bucket_new.stub', 'stream_bucket_prepend' => 'stubs/ext/standard/stream_bucket_prepend.stub', 'stream_context_create' => 'stubs/ext/standard/stream_context_create.stub', 'stream_context_get_default' => 'stubs/ext/standard/stream_context_get_default.stub', 'stream_context_get_options' => 'stubs/ext/standard/stream_context_get_options.stub', 'stream_context_get_params' => 'stubs/ext/standard/stream_context_get_params.stub', 'stream_context_set_default' => 'stubs/ext/standard/stream_context_set_default.stub', 'stream_context_set_option' => 'stubs/ext/standard/stream_context_set_option.stub', 'stream_context_set_params' => 'stubs/ext/standard/stream_context_set_params.stub', 'stream_copy_to_stream' => 'stubs/ext/standard/stream_copy_to_stream.stub', 'stream_filter_append' => 'stubs/ext/standard/stream_filter_append.stub', 'stream_filter_prepend' => 'stubs/ext/standard/stream_filter_prepend.stub', 'stream_filter_register' => 'stubs/ext/standard/stream_filter_register.stub', 'stream_filter_remove' => 'stubs/ext/standard/stream_filter_remove.stub', 'stream_get_contents' => 'stubs/ext/standard/stream_get_contents.stub', 'stream_get_filters' => 'stubs/ext/standard/stream_get_filters.stub', 'stream_get_line' => 'stubs/ext/standard/stream_get_line.stub', 'stream_get_meta_data' => 'stubs/ext/standard/stream_get_meta_data.stub', 'stream_get_transports' => 'stubs/ext/standard/stream_get_transports.stub', 'stream_get_wrappers' => 'stubs/ext/standard/stream_get_wrappers.stub', 'stream_is_local' => 'stubs/ext/standard/stream_is_local.stub', 'stream_isatty' => 'stubs/ext/standard/stream_isatty.stub', 'stream_register_wrapper' => 'stubs/ext/standard/stream_register_wrapper.stub', 'stream_resolve_include_path' => 'stubs/ext/standard/stream_resolve_include_path.stub', 'stream_select' => 'stubs/ext/standard/stream_select.stub', 'stream_set_blocking' => 'stubs/ext/standard/stream_set_blocking.stub', 'stream_set_chunk_size' => 'stubs/ext/standard/stream_set_chunk_size.stub', 'stream_set_read_buffer' => 'stubs/ext/standard/stream_set_read_buffer.stub', 'stream_set_timeout' => 'stubs/ext/standard/stream_set_timeout.stub', 'stream_set_write_buffer' => 'stubs/ext/standard/stream_set_write_buffer.stub', 'stream_socket_accept' => 'stubs/ext/standard/stream_socket_accept.stub', 'stream_socket_client' => 'stubs/ext/standard/stream_socket_client.stub', 'stream_socket_enable_crypto' => 'stubs/ext/standard/stream_socket_enable_crypto.stub', 'stream_socket_get_name' => 'stubs/ext/standard/stream_socket_get_name.stub', 'stream_socket_pair' => 'stubs/ext/standard/stream_socket_pair.stub', 'stream_socket_recvfrom' => 'stubs/ext/standard/stream_socket_recvfrom.stub', 'stream_socket_sendto' => 'stubs/ext/standard/stream_socket_sendto.stub', 'stream_socket_server' => 'stubs/ext/standard/stream_socket_server.stub', 'stream_socket_shutdown' => 'stubs/ext/standard/stream_socket_shutdown.stub', 'stream_supports_lock' => 'stubs/ext/standard/stream_supports_lock.stub', 'stream_wrapper_register' => 'stubs/ext/standard/stream_wrapper_register.stub', 'stream_wrapper_restore' => 'stubs/ext/standard/stream_wrapper_restore.stub', 'stream_wrapper_unregister' => 'stubs/ext/standard/stream_wrapper_unregister.stub', 'strftime' => 'stubs/ext/date/strftime.stub', 'strip_tags' => 'stubs/ext/standard/strip_tags.stub', 'stripcslashes' => 'stubs/ext/standard/stripcslashes.stub', 'stripos' => 'stubs/ext/standard/stripos.stub', 'stripslashes' => 'stubs/ext/standard/stripslashes.stub', 'stristr' => 'stubs/ext/standard/stristr.stub', 'strlen' => 'stubs/Zend/strlen.stub', 'strnatcasecmp' => 'stubs/ext/standard/strnatcasecmp.stub', 'strnatcmp' => 'stubs/ext/standard/strnatcmp.stub', 'strncasecmp' => 'stubs/Zend/strncasecmp.stub', 'strncmp' => 'stubs/Zend/strncmp.stub', 'strpbrk' => 'stubs/ext/standard/strpbrk.stub', 'strpos' => 'stubs/ext/standard/strpos.stub', 'strptime' => 'stubs/ext/standard/strptime.stub', 'strrchr' => 'stubs/ext/standard/strrchr.stub', 'strrev' => 'stubs/ext/standard/strrev.stub', 'strripos' => 'stubs/ext/standard/strripos.stub', 'strrpos' => 'stubs/ext/standard/strrpos.stub', 'strspn' => 'stubs/ext/standard/strspn.stub', 'strstr' => 'stubs/ext/standard/strstr.stub', 'strtok' => 'stubs/ext/standard/strtok.stub', 'strtolower' => 'stubs/ext/standard/strtolower.stub', 'strtotime' => 'stubs/ext/date/strtotime.stub', 'strtoupper' => 'stubs/ext/standard/strtoupper.stub', 'strtr' => 'stubs/ext/standard/strtr.stub', 'strval' => 'stubs/ext/standard/strval.stub', 'substr' => 'stubs/ext/standard/substr.stub', 'substr_compare' => 'stubs/ext/standard/substr_compare.stub', 'substr_count' => 'stubs/ext/standard/substr_count.stub', 'substr_replace' => 'stubs/ext/standard/substr_replace.stub', 'symlink' => 'stubs/ext/standard/symlink.stub', 'sys_get_temp_dir' => 'stubs/ext/standard/sys_get_temp_dir.stub', 'sys_getloadavg' => 'stubs/ext/standard/sys_getloadavg.stub', 'syslog' => 'stubs/ext/standard/syslog.stub', 'system' => 'stubs/ext/standard/system.stub', 'tan' => 'stubs/ext/standard/tan.stub', 'tanh' => 'stubs/ext/standard/tanh.stub', 'tempnam' => 'stubs/ext/standard/tempnam.stub', 'textdomain' => 'stubs/ext/gettext/textdomain.stub', 'tidy_access_count' => 'stubs/ext/tidy/tidy_access_count.stub', 'tidy_clean_repair' => 'stubs/ext/tidy/tidy_clean_repair.stub', 'tidy_config_count' => 'stubs/ext/tidy/tidy_config_count.stub', 'tidy_diagnose' => 'stubs/ext/tidy/tidy_diagnose.stub', 'tidy_error_count' => 'stubs/ext/tidy/tidy_error_count.stub', 'tidy_get_body' => 'stubs/ext/tidy/tidy_get_body.stub', 'tidy_get_config' => 'stubs/ext/tidy/tidy_get_config.stub', 'tidy_get_error_buffer' => 'stubs/ext/tidy/tidy_get_error_buffer.stub', 'tidy_get_head' => 'stubs/ext/tidy/tidy_get_head.stub', 'tidy_get_html' => 'stubs/ext/tidy/tidy_get_html.stub', 'tidy_get_html_ver' => 'stubs/ext/tidy/tidy_get_html_ver.stub', 'tidy_get_opt_doc' => 'stubs/ext/tidy/tidy_get_opt_doc.stub', 'tidy_get_output' => 'stubs/ext/tidy/tidy_get_output.stub', 'tidy_get_release' => 'stubs/ext/tidy/tidy_get_release.stub', 'tidy_get_root' => 'stubs/ext/tidy/tidy_get_root.stub', 'tidy_get_status' => 'stubs/ext/tidy/tidy_get_status.stub', 'tidy_getopt' => 'stubs/ext/tidy/tidy_getopt.stub', 'tidy_is_xhtml' => 'stubs/ext/tidy/tidy_is_xhtml.stub', 'tidy_is_xml' => 'stubs/ext/tidy/tidy_is_xml.stub', 'tidy_parse_file' => 'stubs/ext/tidy/tidy_parse_file.stub', 'tidy_parse_string' => 'stubs/ext/tidy/tidy_parse_string.stub', 'tidy_repair_file' => 'stubs/ext/tidy/tidy_repair_file.stub', 'tidy_repair_string' => 'stubs/ext/tidy/tidy_repair_string.stub', 'tidy_warning_count' => 'stubs/ext/tidy/tidy_warning_count.stub', 'time' => 'stubs/ext/date/time.stub', 'time_nanosleep' => 'stubs/ext/standard/time_nanosleep.stub', 'time_sleep_until' => 'stubs/ext/standard/time_sleep_until.stub', 'timezone_abbreviations_list' => 'stubs/ext/date/timezone_abbreviations_list.stub', 'timezone_identifiers_list' => 'stubs/ext/date/timezone_identifiers_list.stub', 'timezone_location_get' => 'stubs/ext/date/timezone_location_get.stub', 'timezone_name_from_abbr' => 'stubs/ext/date/timezone_name_from_abbr.stub', 'timezone_name_get' => 'stubs/ext/date/timezone_name_get.stub', 'timezone_offset_get' => 'stubs/ext/date/timezone_offset_get.stub', 'timezone_open' => 'stubs/ext/date/timezone_open.stub', 'timezone_transitions_get' => 'stubs/ext/date/timezone_transitions_get.stub', 'timezone_version_get' => 'stubs/ext/date/timezone_version_get.stub', 'tmpfile' => 'stubs/ext/standard/tmpfile.stub', 'token_get_all' => 'stubs/ext/tokenizer/token_get_all.stub', 'token_name' => 'stubs/ext/tokenizer/token_name.stub', 'touch' => 'stubs/ext/standard/touch.stub', 'trait_exists' => 'stubs/Zend/trait_exists.stub', 'transliterator_create' => 'stubs/ext/intl/transliterator_create.stub', 'transliterator_create_from_rules' => 'stubs/ext/intl/transliterator_create_from_rules.stub', 'transliterator_create_inverse' => 'stubs/ext/intl/transliterator_create_inverse.stub', 'transliterator_get_error_code' => 'stubs/ext/intl/transliterator_get_error_code.stub', 'transliterator_get_error_message' => 'stubs/ext/intl/transliterator_get_error_message.stub', 'transliterator_list_ids' => 'stubs/ext/intl/transliterator_list_ids.stub', 'transliterator_transliterate' => 'stubs/ext/intl/transliterator_transliterate.stub', 'trigger_error' => 'stubs/Zend/trigger_error.stub', 'trim' => 'stubs/ext/standard/trim.stub', 'uasort' => 'stubs/ext/standard/uasort.stub', 'ucfirst' => 'stubs/ext/standard/ucfirst.stub', 'ucwords' => 'stubs/ext/standard/ucwords.stub', 'uksort' => 'stubs/ext/standard/uksort.stub', 'umask' => 'stubs/ext/standard/umask.stub', 'uniqid' => 'stubs/ext/standard/uniqid.stub', 'unixtojd' => 'stubs/ext/calendar/unixtojd.stub', 'unlink' => 'stubs/ext/standard/unlink.stub', 'unpack' => 'stubs/ext/standard/unpack.stub', 'unregister_tick_function' => 'stubs/ext/standard/unregister_tick_function.stub', 'unserialize' => 'stubs/ext/standard/unserialize.stub', 'urldecode' => 'stubs/ext/standard/urldecode.stub', 'urlencode' => 'stubs/ext/standard/urlencode.stub', 'use_soap_error_handler' => 'stubs/ext/soap/use_soap_error_handler.stub', 'user_error' => 'stubs/Zend/user_error.stub', 'usleep' => 'stubs/ext/standard/usleep.stub', 'usort' => 'stubs/ext/standard/usort.stub', 'utf8_decode' => 'stubs/ext/standard/utf8_decode.stub', 'utf8_encode' => 'stubs/ext/standard/utf8_encode.stub', 'var_dump' => 'stubs/ext/standard/var_dump.stub', 'var_export' => 'stubs/ext/standard/var_export.stub', 'variant_abs' => 'stubs/ext/com_dotnet/variant_abs.stub', 'variant_add' => 'stubs/ext/com_dotnet/variant_add.stub', 'variant_and' => 'stubs/ext/com_dotnet/variant_and.stub', 'variant_cast' => 'stubs/ext/com_dotnet/variant_cast.stub', 'variant_cat' => 'stubs/ext/com_dotnet/variant_cat.stub', 'variant_cmp' => 'stubs/ext/com_dotnet/variant_cmp.stub', 'variant_date_from_timestamp' => 'stubs/ext/com_dotnet/variant_date_from_timestamp.stub', 'variant_date_to_timestamp' => 'stubs/ext/com_dotnet/variant_date_to_timestamp.stub', 'variant_div' => 'stubs/ext/com_dotnet/variant_div.stub', 'variant_eqv' => 'stubs/ext/com_dotnet/variant_eqv.stub', 'variant_fix' => 'stubs/ext/com_dotnet/variant_fix.stub', 'variant_get_type' => 'stubs/ext/com_dotnet/variant_get_type.stub', 'variant_idiv' => 'stubs/ext/com_dotnet/variant_idiv.stub', 'variant_imp' => 'stubs/ext/com_dotnet/variant_imp.stub', 'variant_int' => 'stubs/ext/com_dotnet/variant_int.stub', 'variant_mod' => 'stubs/ext/com_dotnet/variant_mod.stub', 'variant_mul' => 'stubs/ext/com_dotnet/variant_mul.stub', 'variant_neg' => 'stubs/ext/com_dotnet/variant_neg.stub', 'variant_not' => 'stubs/ext/com_dotnet/variant_not.stub', 'variant_or' => 'stubs/ext/com_dotnet/variant_or.stub', 'variant_pow' => 'stubs/ext/com_dotnet/variant_pow.stub', 'variant_round' => 'stubs/ext/com_dotnet/variant_round.stub', 'variant_set' => 'stubs/ext/com_dotnet/variant_set.stub', 'variant_set_type' => 'stubs/ext/com_dotnet/variant_set_type.stub', 'variant_sub' => 'stubs/ext/com_dotnet/variant_sub.stub', 'variant_xor' => 'stubs/ext/com_dotnet/variant_xor.stub', 'version_compare' => 'stubs/ext/standard/version_compare.stub', 'vfprintf' => 'stubs/ext/standard/vfprintf.stub', 'virtual' => 'stubs/sapi/apache2handler/virtual.stub', 'vprintf' => 'stubs/ext/standard/vprintf.stub', 'vsprintf' => 'stubs/ext/standard/vsprintf.stub', 'wordwrap' => 'stubs/ext/standard/wordwrap.stub', 'xml_error_string' => 'stubs/ext/xml/xml_error_string.stub', 'xml_get_current_byte_index' => 'stubs/ext/xml/xml_get_current_byte_index.stub', 'xml_get_current_column_number' => 'stubs/ext/xml/xml_get_current_column_number.stub', 'xml_get_current_line_number' => 'stubs/ext/xml/xml_get_current_line_number.stub', 'xml_get_error_code' => 'stubs/ext/xml/xml_get_error_code.stub', 'xml_parse' => 'stubs/ext/xml/xml_parse.stub', 'xml_parse_into_struct' => 'stubs/ext/xml/xml_parse_into_struct.stub', 'xml_parser_create' => 'stubs/ext/xml/xml_parser_create.stub', 'xml_parser_create_ns' => 'stubs/ext/xml/xml_parser_create_ns.stub', 'xml_parser_free' => 'stubs/ext/xml/xml_parser_free.stub', 'xml_parser_get_option' => 'stubs/ext/xml/xml_parser_get_option.stub', 'xml_parser_set_option' => 'stubs/ext/xml/xml_parser_set_option.stub', 'xml_set_character_data_handler' => 'stubs/ext/xml/xml_set_character_data_handler.stub', 'xml_set_default_handler' => 'stubs/ext/xml/xml_set_default_handler.stub', 'xml_set_element_handler' => 'stubs/ext/xml/xml_set_element_handler.stub', 'xml_set_end_namespace_decl_handler' => 'stubs/ext/xml/xml_set_end_namespace_decl_handler.stub', 'xml_set_external_entity_ref_handler' => 'stubs/ext/xml/xml_set_external_entity_ref_handler.stub', 'xml_set_notation_decl_handler' => 'stubs/ext/xml/xml_set_notation_decl_handler.stub', 'xml_set_object' => 'stubs/ext/xml/xml_set_object.stub', 'xml_set_processing_instruction_handler' => 'stubs/ext/xml/xml_set_processing_instruction_handler.stub', 'xml_set_start_namespace_decl_handler' => 'stubs/ext/xml/xml_set_start_namespace_decl_handler.stub', 'xml_set_unparsed_entity_decl_handler' => 'stubs/ext/xml/xml_set_unparsed_entity_decl_handler.stub', 'xmlwriter_end_attribute' => 'stubs/ext/xmlwriter/xmlwriter_end_attribute.stub', 'xmlwriter_end_cdata' => 'stubs/ext/xmlwriter/xmlwriter_end_cdata.stub', 'xmlwriter_end_comment' => 'stubs/ext/xmlwriter/xmlwriter_end_comment.stub', 'xmlwriter_end_document' => 'stubs/ext/xmlwriter/xmlwriter_end_document.stub', 'xmlwriter_end_dtd' => 'stubs/ext/xmlwriter/xmlwriter_end_dtd.stub', 'xmlwriter_end_dtd_attlist' => 'stubs/ext/xmlwriter/xmlwriter_end_dtd_attlist.stub', 'xmlwriter_end_dtd_element' => 'stubs/ext/xmlwriter/xmlwriter_end_dtd_element.stub', 'xmlwriter_end_dtd_entity' => 'stubs/ext/xmlwriter/xmlwriter_end_dtd_entity.stub', 'xmlwriter_end_element' => 'stubs/ext/xmlwriter/xmlwriter_end_element.stub', 'xmlwriter_end_pi' => 'stubs/ext/xmlwriter/xmlwriter_end_pi.stub', 'xmlwriter_flush' => 'stubs/ext/xmlwriter/xmlwriter_flush.stub', 'xmlwriter_full_end_element' => 'stubs/ext/xmlwriter/xmlwriter_full_end_element.stub', 'xmlwriter_open_memory' => 'stubs/ext/xmlwriter/xmlwriter_open_memory.stub', 'xmlwriter_open_uri' => 'stubs/ext/xmlwriter/xmlwriter_open_uri.stub', 'xmlwriter_output_memory' => 'stubs/ext/xmlwriter/xmlwriter_output_memory.stub', 'xmlwriter_set_indent' => 'stubs/ext/xmlwriter/xmlwriter_set_indent.stub', 'xmlwriter_set_indent_string' => 'stubs/ext/xmlwriter/xmlwriter_set_indent_string.stub', 'xmlwriter_start_attribute' => 'stubs/ext/xmlwriter/xmlwriter_start_attribute.stub', 'xmlwriter_start_attribute_ns' => 'stubs/ext/xmlwriter/xmlwriter_start_attribute_ns.stub', 'xmlwriter_start_cdata' => 'stubs/ext/xmlwriter/xmlwriter_start_cdata.stub', 'xmlwriter_start_comment' => 'stubs/ext/xmlwriter/xmlwriter_start_comment.stub', 'xmlwriter_start_document' => 'stubs/ext/xmlwriter/xmlwriter_start_document.stub', 'xmlwriter_start_dtd' => 'stubs/ext/xmlwriter/xmlwriter_start_dtd.stub', 'xmlwriter_start_dtd_attlist' => 'stubs/ext/xmlwriter/xmlwriter_start_dtd_attlist.stub', 'xmlwriter_start_dtd_element' => 'stubs/ext/xmlwriter/xmlwriter_start_dtd_element.stub', 'xmlwriter_start_dtd_entity' => 'stubs/ext/xmlwriter/xmlwriter_start_dtd_entity.stub', 'xmlwriter_start_element' => 'stubs/ext/xmlwriter/xmlwriter_start_element.stub', 'xmlwriter_start_element_ns' => 'stubs/ext/xmlwriter/xmlwriter_start_element_ns.stub', 'xmlwriter_start_pi' => 'stubs/ext/xmlwriter/xmlwriter_start_pi.stub', 'xmlwriter_text' => 'stubs/ext/xmlwriter/xmlwriter_text.stub', 'xmlwriter_write_attribute' => 'stubs/ext/xmlwriter/xmlwriter_write_attribute.stub', 'xmlwriter_write_attribute_ns' => 'stubs/ext/xmlwriter/xmlwriter_write_attribute_ns.stub', 'xmlwriter_write_cdata' => 'stubs/ext/xmlwriter/xmlwriter_write_cdata.stub', 'xmlwriter_write_comment' => 'stubs/ext/xmlwriter/xmlwriter_write_comment.stub', 'xmlwriter_write_dtd' => 'stubs/ext/xmlwriter/xmlwriter_write_dtd.stub', 'xmlwriter_write_dtd_attlist' => 'stubs/ext/xmlwriter/xmlwriter_write_dtd_attlist.stub', 'xmlwriter_write_dtd_element' => 'stubs/ext/xmlwriter/xmlwriter_write_dtd_element.stub', 'xmlwriter_write_dtd_entity' => 'stubs/ext/xmlwriter/xmlwriter_write_dtd_entity.stub', 'xmlwriter_write_element' => 'stubs/ext/xmlwriter/xmlwriter_write_element.stub', 'xmlwriter_write_element_ns' => 'stubs/ext/xmlwriter/xmlwriter_write_element_ns.stub', 'xmlwriter_write_pi' => 'stubs/ext/xmlwriter/xmlwriter_write_pi.stub', 'xmlwriter_write_raw' => 'stubs/ext/xmlwriter/xmlwriter_write_raw.stub', 'zend_thread_id' => 'stubs/Zend/zend_thread_id.stub', 'zend_version' => 'stubs/Zend/zend_version.stub', 'zip_close' => 'stubs/ext/zip/zip_close.stub', 'zip_entry_close' => 'stubs/ext/zip/zip_entry_close.stub', 'zip_entry_compressedsize' => 'stubs/ext/zip/zip_entry_compressedsize.stub', 'zip_entry_compressionmethod' => 'stubs/ext/zip/zip_entry_compressionmethod.stub', 'zip_entry_filesize' => 'stubs/ext/zip/zip_entry_filesize.stub', 'zip_entry_name' => 'stubs/ext/zip/zip_entry_name.stub', 'zip_entry_open' => 'stubs/ext/zip/zip_entry_open.stub', 'zip_entry_read' => 'stubs/ext/zip/zip_entry_read.stub', 'zip_open' => 'stubs/ext/zip/zip_open.stub', 'zip_read' => 'stubs/ext/zip/zip_read.stub', 'zlib_decode' => 'stubs/ext/zlib/zlib_decode.stub', 'zlib_encode' => 'stubs/ext/zlib/zlib_encode.stub', 'zlib_get_coding_type' => 'stubs/ext/zlib/zlib_get_coding_type.stub'];
        if ($phpVersionId >= 80100) {
            $classes = \array_merge($classes, ['__php_incomplete_class' => 'stubs/ext/standard/__PHP_Incomplete_Class.stub', 'assertionerror' => 'stubs/ext/standard/AssertionError.stub', 'backedenum' => 'stubs/Zend/BackedEnum.stub', 'badfunctioncallexception' => 'stubs/ext/spl/BadFunctionCallException.stub', 'badmethodcallexception' => 'stubs/ext/spl/BadMethodCallException.stub', 'com_safearray_proxy' => 'stubs/ext/com_dotnet/com_safearray_proxy.stub', 'curlstringfile' => 'stubs/ext/curl/CURLStringFile.stub', 'domainexception' => 'stubs/ext/spl/DomainException.stub', 'fiber' => 'stubs/Zend/Fiber.stub', 'fibererror' => 'stubs/Zend/FiberError.stub', 'ftp\\connection' => 'stubs/ext/ftp/FTP/Connection.stub', 'gdfont' => 'stubs/ext/gd/GdFont.stub', 'imap\\connection' => 'stubs/ext/imap/IMAP/Connection.stub', 'intldatepatterngenerator' => 'stubs/ext/intl/dateformat/IntlDatePatternGenerator.stub', 'invalidargumentexception' => 'stubs/ext/spl/InvalidArgumentException.stub', 'ldap\\connection' => 'stubs/ext/ldap/LDAP/Connection.stub', 'ldap\\result' => 'stubs/ext/ldap/LDAP/Result.stub', 'ldap\\resultentry' => 'stubs/ext/ldap/LDAP/ResultEntry.stub', 'lengthexception' => 'stubs/ext/spl/LengthException.stub', 'logicexception' => 'stubs/ext/spl/LogicException.stub', 'outofboundsexception' => 'stubs/ext/spl/OutOfBoundsException.stub', 'outofrangeexception' => 'stubs/ext/spl/OutOfRangeException.stub', 'overflowexception' => 'stubs/ext/spl/OverflowException.stub', 'pgsql\\connection' => 'stubs/ext/pgsql/PgSql/Connection.stub', 'pgsql\\lob' => 'stubs/ext/pgsql/PgSql/Lob.stub', 'pgsql\\result' => 'stubs/ext/pgsql/PgSql/Result.stub', 'pspell\\config' => 'stubs/ext/pspell/PSpell/Config.stub', 'pspell\\dictionary' => 'stubs/ext/pspell/PSpell/Dictionary.stub', 'rangeexception' => 'stubs/ext/spl/RangeException.stub', 'reflectionenum' => 'stubs/ext/reflection/ReflectionEnum.stub', 'reflectionenumbackedcase' => 'stubs/ext/reflection/ReflectionEnumBackedCase.stub', 'reflectionenumunitcase' => 'stubs/ext/reflection/ReflectionEnumUnitCase.stub', 'reflectionfiber' => 'stubs/ext/reflection/ReflectionFiber.stub', 'reflectionintersectiontype' => 'stubs/ext/reflection/ReflectionIntersectionType.stub', 'returntypewillchange' => 'stubs/Zend/ReturnTypeWillChange.stub', 'runtimeexception' => 'stubs/ext/spl/RuntimeException.stub', 'stdclass' => 'stubs/Zend/stdClass.stub', 'underflowexception' => 'stubs/ext/spl/UnderflowException.stub', 'unexpectedvalueexception' => 'stubs/ext/spl/UnexpectedValueException.stub', 'unitenum' => 'stubs/Zend/UnitEnum.stub']);
            $functions = \array_merge($functions, ['array_is_list' => 'stubs/ext/standard/array_is_list.stub', 'enum_exists' => 'stubs/Zend/enum_exists.stub', 'fdatasync' => 'stubs/ext/standard/fdatasync.stub', 'fsync' => 'stubs/ext/standard/fsync.stub', 'imageavif' => 'stubs/ext/gd/imageavif.stub', 'imagecreatefromavif' => 'stubs/ext/gd/imagecreatefromavif.stub', 'mysqli_fetch_column' => 'stubs/ext/mysqli/mysqli_fetch_column.stub', 'pcntl_rfork' => 'stubs/ext/pcntl/pcntl_rfork.stub', 'sodium_crypto_core_ristretto255_add' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_add.stub', 'sodium_crypto_core_ristretto255_from_hash' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_from_hash.stub', 'sodium_crypto_core_ristretto255_is_valid_point' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_is_valid_point.stub', 'sodium_crypto_core_ristretto255_random' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_random.stub', 'sodium_crypto_core_ristretto255_scalar_add' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_add.stub', 'sodium_crypto_core_ristretto255_scalar_complement' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_complement.stub', 'sodium_crypto_core_ristretto255_scalar_invert' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_invert.stub', 'sodium_crypto_core_ristretto255_scalar_mul' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_mul.stub', 'sodium_crypto_core_ristretto255_scalar_negate' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_negate.stub', 'sodium_crypto_core_ristretto255_scalar_random' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_random.stub', 'sodium_crypto_core_ristretto255_scalar_reduce' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_reduce.stub', 'sodium_crypto_core_ristretto255_scalar_sub' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_scalar_sub.stub', 'sodium_crypto_core_ristretto255_sub' => 'stubs/ext/sodium/sodium_crypto_core_ristretto255_sub.stub', 'sodium_crypto_scalarmult_ristretto255' => 'stubs/ext/sodium/sodium_crypto_scalarmult_ristretto255.stub', 'sodium_crypto_scalarmult_ristretto255_base' => 'stubs/ext/sodium/sodium_crypto_scalarmult_ristretto255_base.stub', 'sodium_crypto_stream_xchacha20' => 'stubs/ext/sodium/sodium_crypto_stream_xchacha20.stub', 'sodium_crypto_stream_xchacha20_keygen' => 'stubs/ext/sodium/sodium_crypto_stream_xchacha20_keygen.stub', 'sodium_crypto_stream_xchacha20_xor' => 'stubs/ext/sodium/sodium_crypto_stream_xchacha20_xor.stub']);
        }
        if ($phpVersionId >= 80200) {
            $classes = \array_merge($classes, ['allowdynamicproperties' => 'stubs/Zend/AllowDynamicProperties.stub', 'random\\brokenrandomengineerror' => 'stubs/ext/random/Random/BrokenRandomEngineError.stub', 'random\\cryptosafeengine' => 'stubs/ext/random/Random/CryptoSafeEngine.stub', 'random\\engine' => 'stubs/ext/random/Random/Engine.stub', 'random\\engine\\mt19937' => 'stubs/ext/random/Random/Engine/Mt19937.stub', 'random\\engine\\pcgoneseq128xslrr64' => 'stubs/ext/random/Random/Engine/PcgOneseq128XslRr64.stub', 'random\\engine\\secure' => 'stubs/ext/random/Random/Engine/Secure.stub', 'random\\engine\\xoshiro256starstar' => 'stubs/ext/random/Random/Engine/Xoshiro256StarStar.stub', 'random\\randomerror' => 'stubs/ext/random/Random/RandomError.stub', 'random\\randomexception' => 'stubs/ext/random/Random/RandomException.stub', 'random\\randomizer' => 'stubs/ext/random/Random/Randomizer.stub', 'sensitiveparameter' => 'stubs/Zend/SensitiveParameter.stub', 'sensitiveparametervalue' => 'stubs/Zend/SensitiveParameterValue.stub']);
            $functions = \array_merge($functions, ['curl_upkeep' => 'stubs/ext/curl/curl_upkeep.stub', 'getrandmax' => 'stubs/ext/random/getrandmax.stub', 'imap_is_open' => 'stubs/ext/imap/imap_is_open.stub', 'ini_parse_quantity' => 'stubs/ext/standard/ini_parse_quantity.stub', 'lcg_value' => 'stubs/ext/random/lcg_value.stub', 'libxml_get_external_entity_loader' => 'stubs/ext/libxml/libxml_get_external_entity_loader.stub', 'memory_reset_peak_usage' => 'stubs/ext/standard/memory_reset_peak_usage.stub', 'mt_getrandmax' => 'stubs/ext/random/mt_getrandmax.stub', 'mt_rand' => 'stubs/ext/random/mt_rand.stub', 'mt_srand' => 'stubs/ext/random/mt_srand.stub', 'mysqli_execute_query' => 'stubs/ext/mysqli/mysqli_execute_query.stub', 'oci_set_prefetch_lob' => 'stubs/ext/oci8/oci_set_prefetch_lob.stub', 'odbc_connection_string_is_quoted' => 'stubs/ext/odbc/odbc_connection_string_is_quoted.stub', 'odbc_connection_string_quote' => 'stubs/ext/odbc/odbc_connection_string_quote.stub', 'odbc_connection_string_should_quote' => 'stubs/ext/odbc/odbc_connection_string_should_quote.stub', 'openssl_cipher_key_length' => 'stubs/ext/openssl/openssl_cipher_key_length.stub', 'pcntl_forkx' => 'stubs/ext/pcntl/pcntl_forkx.stub', 'rand' => 'stubs/ext/random/rand.stub', 'random_bytes' => 'stubs/ext/random/random_bytes.stub', 'random_int' => 'stubs/ext/random/random_int.stub', 'sodium_crypto_stream_xchacha20_xor_ic' => 'stubs/ext/sodium/sodium_crypto_stream_xchacha20_xor_ic.stub', 'srand' => 'stubs/ext/random/srand.stub']);
        }
        if ($phpVersionId >= 80300) {
            $classes = \array_merge($classes, ['dateerror' => 'stubs/ext/date/DateError.stub', 'dateexception' => 'stubs/ext/date/DateException.stub', 'dateinvalidoperationexception' => 'stubs/ext/date/DateInvalidOperationException.stub', 'dateinvalidtimezoneexception' => 'stubs/ext/date/DateInvalidTimeZoneException.stub', 'datemalformedintervalstringexception' => 'stubs/ext/date/DateMalformedIntervalStringException.stub', 'datemalformedperiodstringexception' => 'stubs/ext/date/DateMalformedPeriodStringException.stub', 'datemalformedstringexception' => 'stubs/ext/date/DateMalformedStringException.stub', 'dateobjecterror' => 'stubs/ext/date/DateObjectError.stub', 'daterangeerror' => 'stubs/ext/date/DateRangeError.stub', 'override' => 'stubs/Zend/Override.stub', 'sqlite3exception' => 'stubs/ext/sqlite3/SQLite3Exception.stub']);
            $functions = \array_merge($functions, ['json_validate' => 'stubs/ext/json/json_validate.stub', 'ldap_connect_wallet' => 'stubs/ext/ldap/ldap_connect_wallet.stub', 'ldap_exop_sync' => 'stubs/ext/ldap/ldap_exop_sync.stub', 'mb_str_pad' => 'stubs/ext/mbstring/mb_str_pad.stub', 'pg_set_error_context_visibility' => 'stubs/ext/pgsql/pg_set_error_context_visibility.stub', 'posix_eaccess' => 'stubs/ext/posix/posix_eaccess.stub', 'posix_fpathconf' => 'stubs/ext/posix/posix_fpathconf.stub', 'posix_pathconf' => 'stubs/ext/posix/posix_pathconf.stub', 'posix_sysconf' => 'stubs/ext/posix/posix_sysconf.stub', 'random\\intervalboundary' => 'stubs/ext/random/Random/IntervalBoundary.stub', 'socket_atmark' => 'stubs/ext/sockets/socket_atmark.stub', 'str_decrement' => 'stubs/ext/standard/str_decrement.stub', 'str_increment' => 'stubs/ext/standard/str_increment.stub', 'stream_context_set_options' => 'stubs/ext/standard/stream_context_set_options.stub']);
        }
        // UPDATE BELONGS HERE
        $this->classes = $classes;
        $this->functions = $functions;
    }
}
