<?php

/**
 * Hoa
 *
 *
 * @license
 *
 * New BSD License
 *
 * Copyright © 2007-2017, Hoa community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the Hoa nor the names of its contributors may be
 *       used to endorse or promote products derived from this software without
 *       specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
namespace Hoa\Ustring\Bin;

use Hoa\Console;
use Hoa\Ustring;
/**
 * Class Hoa\Ustring\Bin\Tocode.
 *
 * Transform a character into its code. Please, see Hoa\Ustring\Ustring::toCode.
 *
 * @copyright  Copyright © 2007-2017 Hoa community
 * @license    New BSD License
 */
class Tocode extends Console\Dispatcher\Kit
{
    /**
     * Options description.
     *
     * @var array
     */
    protected $options = [['base', Console\GetOption::REQUIRED_ARGUMENT, 'b'], ['help', Console\GetOption::NO_ARGUMENT, 'h'], ['help', Console\GetOption::NO_ARGUMENT, '?']];
    /**
     * The entry method.
     *
     * @return  int
     */
    public function main()
    {
        $base = 16;
        while (\false !== ($c = $this->getOption($v))) {
            switch ($c) {
                case 'b':
                    $base = \intval($v);
                    break;
                case '__ambiguous':
                    $this->resolveOptionAmbiguity($v);
                    break;
                case 'h':
                case '?':
                default:
                    return $this->usage();
            }
        }
        $this->parser->listInputs($char);
        $code = \base_convert((string) Ustring::toCode($char), 10, $base);
        echo $code, "\n";
        return;
    }
    /**
     * The command usage.
     *
     * @return  int
     */
    public function usage()
    {
        echo 'Usage   : ustring:tocode <char>', "\n", 'Options :', "\n", $this->makeUsageOptionsList(['b' => 'Get the code in a specific base (16 by default).', 'help' => 'This help.']), "\n";
        return;
    }
}
__halt_compiler();
Transform a character into its code.

