<?php

/**
 * Hoa
 *
 *
 * @license
 *
 * New BSD License
 *
 * Copyright © 2007-2017, Hoa community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the Hoa nor the names of its contributors may be
 *       used to endorse or promote products derived from this software without
 *       specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
namespace Hoa\Stream\IStream;

/**
 * Interface \Hoa\Stream\IStream\Pointable.
 *
 * Interface for pointable input/output.
 *
 * @copyright  Copyright © 2007-2017 Hoa community
 * @license    New BSD License
 */
interface Pointable extends \Hoa\Stream\IStream\Stream
{
    /**
     * Set position equal to $offset bytes.
     *
     * @const int
     */
    const SEEK_SET = \SEEK_SET;
    /**
     * Set position to current location plus $offset.
     *
     * @const int
     */
    const SEEK_CURRENT = \SEEK_CUR;
    /**
     * Set position to end-of-file plus $offset.
     *
     * @const int
     */
    const SEEK_END = \SEEK_END;
    /**
     * Rewind the position of a stream pointer.
     *
     * @return  bool
     */
    public function rewind();
    /**
     * Seek on a stream pointer.
     *
     * @param   int     $offset    Offset (negative value should be supported).
     * @param   int     $whence    Whence, use the self::SEEK_* constants.
     * @return  int
     */
    public function seek($offset, $whence = self::SEEK_SET);
    /**
     * Get the current position of the stream pointer.
     *
     * @return  int
     */
    public function tell();
}
