<?php

declare (strict_types=1);
namespace PHPStan\Type\Traits;

use PHPStan\TrinaryLogic;
use PHPStan\Type\MixedType;
use PHPStan\Type\Type;
trait MaybeOffsetAccessibleTypeTrait
{
    public function isOffsetAccessible() : TrinaryLogic
    {
        return TrinaryLogic::createMaybe();
    }
    public function hasOffsetValueType(Type $offsetType) : TrinaryLogic
    {
        return TrinaryLogic::createMaybe();
    }
    public function getOffsetValueType(Type $offsetType) : Type
    {
        return new MixedType();
    }
    public function setOffsetValueType(?Type $offsetType, Type $valueType, bool $unionValues = \true) : Type
    {
        return $this;
    }
    public function setExistingOffsetValueType(Type $offsetType, Type $valueType) : Type
    {
        return $this;
    }
    public function unsetOffset(Type $offsetType) : Type
    {
        return $this;
    }
}
