<?php

declare (strict_types=1);
namespace PHPStan\Type\Php;

use PhpParser\Node\Expr\StaticCall;
use PHPStan\Analyser\Scope;
use PHPStan\Reflection\MethodReflection;
use PHPStan\Type\ClassStringType;
use PHPStan\Type\DynamicStaticMethodThrowTypeExtension;
use PHPStan\Type\ObjectWithoutClassType;
use PHPStan\Type\Type;
use PHPStan\Type\UnionType;
use ReflectionClass;
use function count;
class ReflectionClassConstructorThrowTypeExtension implements DynamicStaticMethodThrowTypeExtension
{
    public function isStaticMethodSupported(MethodReflection $methodReflection) : bool
    {
        return $methodReflection->getName() === '__construct' && $methodReflection->getDeclaringClass()->getName() === ReflectionClass::class;
    }
    public function getThrowTypeFromStaticMethodCall(MethodReflection $methodReflection, StaticCall $methodCall, Scope $scope) : ?Type
    {
        if (count($methodCall->getArgs()) < 1) {
            return $methodReflection->getThrowType();
        }
        $valueType = $scope->getType($methodCall->getArgs()[0]->value);
        $classOrString = new UnionType([new ClassStringType(), new ObjectWithoutClassType()]);
        if ($classOrString->isSuperTypeOf($valueType)->yes()) {
            return null;
        }
        return $methodReflection->getThrowType();
    }
}
