<?php

declare (strict_types=1);
namespace PHPStan\Type\Php;

use PhpParser\Node\Expr\FuncCall;
use PHPStan\Analyser\Scope;
use PHPStan\Reflection\FunctionReflection;
use PHPStan\TrinaryLogic;
use PHPStan\Type\Accessory\AccessoryArrayListType;
use PHPStan\Type\ArrayType;
use PHPStan\Type\BitwiseFlagHelper;
use PHPStan\Type\Constant\ConstantArrayType;
use PHPStan\Type\Constant\ConstantBooleanType;
use PHPStan\Type\Constant\ConstantIntegerType;
use PHPStan\Type\DynamicFunctionReturnTypeExtension;
use PHPStan\Type\IntegerRangeType;
use PHPStan\Type\IntegerType;
use PHPStan\Type\StringType;
use PHPStan\Type\Type;
use PHPStan\Type\TypeCombinator;
use function strtolower;
class PregSplitDynamicReturnTypeExtension implements DynamicFunctionReturnTypeExtension
{
    /**
     * @var BitwiseFlagHelper
     */
    private $bitwiseFlagAnalyser;
    public function __construct(BitwiseFlagHelper $bitwiseFlagAnalyser)
    {
        $this->bitwiseFlagAnalyser = $bitwiseFlagAnalyser;
    }
    public function isFunctionSupported(FunctionReflection $functionReflection) : bool
    {
        return strtolower($functionReflection->getName()) === 'preg_split';
    }
    public function getTypeFromFunctionCall(FunctionReflection $functionReflection, FuncCall $functionCall, Scope $scope) : ?Type
    {
        $flagsArg = $functionCall->getArgs()[3] ?? null;
        if ($flagsArg !== null && $this->bitwiseFlagAnalyser->bitwiseOrContainsConstant($flagsArg->value, $scope, 'PREG_SPLIT_OFFSET_CAPTURE')->yes()) {
            $type = new ArrayType(new IntegerType(), new ConstantArrayType([new ConstantIntegerType(0), new ConstantIntegerType(1)], [new StringType(), IntegerRangeType::fromInterval(0, null)], [2], [], TrinaryLogic::createYes()));
            return TypeCombinator::union(AccessoryArrayListType::intersectWith($type), new ConstantBooleanType(\false));
        }
        return null;
    }
}
