<?php

declare (strict_types=1);
namespace PHPStan\Type\Php;

use Closure;
use PhpParser\Node\Expr\StaticCall;
use PHPStan\Analyser\Scope;
use PHPStan\Reflection\MethodReflection;
use PHPStan\Type\ClosureType;
use PHPStan\Type\DynamicStaticMethodReturnTypeExtension;
use PHPStan\Type\Type;
class ClosureBindDynamicReturnTypeExtension implements DynamicStaticMethodReturnTypeExtension
{
    public function getClass() : string
    {
        return Closure::class;
    }
    public function isStaticMethodSupported(MethodReflection $methodReflection) : bool
    {
        return $methodReflection->getName() === 'bind';
    }
    public function getTypeFromStaticMethodCall(MethodReflection $methodReflection, StaticCall $methodCall, Scope $scope) : ?Type
    {
        $closureType = $scope->getType($methodCall->getArgs()[0]->value);
        if (!$closureType instanceof ClosureType) {
            return null;
        }
        return $closureType;
    }
}
