<?php

declare (strict_types=1);
namespace PHPStan\Rules\Traits;

use PhpParser\Node;
use PHPStan\Analyser\Scope;
use PHPStan\Collectors\Collector;
/**
 * @implements Collector<Node\Stmt\Trait_, array{string, int}>
 */
class TraitDeclarationCollector implements Collector
{
    public function getNodeType() : string
    {
        return Node\Stmt\Trait_::class;
    }
    public function processNode(Node $node, Scope $scope)
    {
        if ($node->namespacedName === null) {
            return null;
        }
        return [$node->namespacedName->toString(), $node->getLine()];
    }
}
