<?php

declare (strict_types=1);
namespace PHPStan\Rules\Constants;

use PhpParser\Node;
use PHPStan\Analyser\Scope;
use PHPStan\Php\PhpVersion;
use PHPStan\Rules\Rule;
use PHPStan\Rules\RuleErrorBuilder;
/**
 * @implements Rule<Node\Stmt\ClassConst>
 */
class NativeTypedClassConstantRule implements Rule
{
    /**
     * @var PhpVersion
     */
    private $phpVersion;
    public function __construct(PhpVersion $phpVersion)
    {
        $this->phpVersion = $phpVersion;
    }
    public function getNodeType() : string
    {
        return Node\Stmt\ClassConst::class;
    }
    public function processNode(Node $node, Scope $scope) : array
    {
        if ($node->type === null) {
            return [];
        }
        if ($this->phpVersion->supportsNativeTypesInClassConstants()) {
            return [];
        }
        return [RuleErrorBuilder::message('Class constants with native types are supported only on PHP 8.3 and later.')->identifier('classConstant.nativeTypeNotSupported')->nonIgnorable()->build()];
    }
}
