<?php

declare (strict_types=1);
namespace PHPStan\Node;

use PhpParser\Node\Expr;
class IssetExpr extends Expr implements \PHPStan\Node\VirtualNode
{
    /**
     * @var Expr
     */
    private $expr;
    public function __construct(Expr $expr)
    {
        $this->expr = $expr;
        parent::__construct([]);
    }
    public function getExpr() : Expr
    {
        return $this->expr;
    }
    public function getType() : string
    {
        return 'PHPStan_Node_IssetExpr';
    }
    /**
     * @return string[]
     */
    public function getSubNodeNames() : array
    {
        return [];
    }
}
