<?php
/**
 * DocumentUpdateInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.13-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * DocumentUpdateInfo Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DocumentUpdateInfo implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'documentUpdateInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'data' => '?string',
        'document_id' => '?string',
        'document_security_store' => '\DocuSign\eSign\Model\DocumentSecurityStore',
        'name' => '?string',
        'return_format' => '?string',
        'signature_data_infos' => '\DocuSign\eSign\Model\SignatureDataInfo[]',
        'time_stamp_field' => '\DocuSign\eSign\Model\TimeStampField'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'data' => null,
        'document_id' => null,
        'document_security_store' => null,
        'name' => null,
        'return_format' => null,
        'signature_data_infos' => null,
        'time_stamp_field' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'data' => 'data',
        'document_id' => 'documentId',
        'document_security_store' => 'documentSecurityStore',
        'name' => 'name',
        'return_format' => 'returnFormat',
        'signature_data_infos' => 'signatureDataInfos',
        'time_stamp_field' => 'timeStampField'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'data' => 'setData',
        'document_id' => 'setDocumentId',
        'document_security_store' => 'setDocumentSecurityStore',
        'name' => 'setName',
        'return_format' => 'setReturnFormat',
        'signature_data_infos' => 'setSignatureDataInfos',
        'time_stamp_field' => 'setTimeStampField'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'data' => 'getData',
        'document_id' => 'getDocumentId',
        'document_security_store' => 'getDocumentSecurityStore',
        'name' => 'getName',
        'return_format' => 'getReturnFormat',
        'signature_data_infos' => 'getSignatureDataInfos',
        'time_stamp_field' => 'getTimeStampField'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['data'] = isset($data['data']) ? $data['data'] : null;
        $this->container['document_id'] = isset($data['document_id']) ? $data['document_id'] : null;
        $this->container['document_security_store'] = isset($data['document_security_store']) ? $data['document_security_store'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['return_format'] = isset($data['return_format']) ? $data['return_format'] : null;
        $this->container['signature_data_infos'] = isset($data['signature_data_infos']) ? $data['signature_data_infos'] : null;
        $this->container['time_stamp_field'] = isset($data['time_stamp_field']) ? $data['time_stamp_field'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets data
     *
     * @return ?string
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     *
     * @param ?string $data 
     *
     * @return $this
     */
    public function setData($data)
    {
        $this->container['data'] = $data;

        return $this;
    }

    /**
     * Gets document_id
     *
     * @return ?string
     */
    public function getDocumentId()
    {
        return $this->container['document_id'];
    }

    /**
     * Sets document_id
     *
     * @param ?string $document_id Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.
     *
     * @return $this
     */
    public function setDocumentId($document_id)
    {
        $this->container['document_id'] = $document_id;

        return $this;
    }

    /**
     * Gets document_security_store
     *
     * @return \DocuSign\eSign\Model\DocumentSecurityStore
     */
    public function getDocumentSecurityStore()
    {
        return $this->container['document_security_store'];
    }

    /**
     * Sets document_security_store
     *
     * @param \DocuSign\eSign\Model\DocumentSecurityStore $document_security_store document_security_store
     *
     * @return $this
     */
    public function setDocumentSecurityStore($document_security_store)
    {
        $this->container['document_security_store'] = $document_security_store;

        return $this;
    }

    /**
     * Gets name
     *
     * @return ?string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param ?string $name 
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets return_format
     *
     * @return ?string
     */
    public function getReturnFormat()
    {
        return $this->container['return_format'];
    }

    /**
     * Sets return_format
     *
     * @param ?string $return_format 
     *
     * @return $this
     */
    public function setReturnFormat($return_format)
    {
        $this->container['return_format'] = $return_format;

        return $this;
    }

    /**
     * Gets signature_data_infos
     *
     * @return \DocuSign\eSign\Model\SignatureDataInfo[]
     */
    public function getSignatureDataInfos()
    {
        return $this->container['signature_data_infos'];
    }

    /**
     * Sets signature_data_infos
     *
     * @param \DocuSign\eSign\Model\SignatureDataInfo[] $signature_data_infos 
     *
     * @return $this
     */
    public function setSignatureDataInfos($signature_data_infos)
    {
        $this->container['signature_data_infos'] = $signature_data_infos;

        return $this;
    }

    /**
     * Gets time_stamp_field
     *
     * @return \DocuSign\eSign\Model\TimeStampField
     */
    public function getTimeStampField()
    {
        return $this->container['time_stamp_field'];
    }

    /**
     * Sets time_stamp_field
     *
     * @param \DocuSign\eSign\Model\TimeStampField $time_stamp_field time_stamp_field
     *
     * @return $this
     */
    public function setTimeStampField($time_stamp_field)
    {
        $this->container['time_stamp_field'] = $time_stamp_field;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

