<?php
declare(strict_types=1);

/**
 * UsersApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\UsersApi;


/**
 * ListOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListOptions
{
    /**
      * $additional_info When set to **true**, the full list of user information is returned for each user in the account.
      * @var ?string
      */
    protected ?string $additional_info = null;

    /**
     * Gets additional_info
     *
     * @return ?string
     */
    public function getAdditionalInfo(): ?string
    {
        return $this->additional_info;
    }

    /**
     * Sets additional_info
     * @param ?string $additional_info When set to **true**, the full list of user information is returned for each user in the account.
     *
     * @return self
     */
    public function setAdditionalInfo(?string $additional_info): self
    {
        $this->additional_info = $additional_info;
        return $this;
    }
    /**
      * $alternate_admins_only 
      * @var ?string
      */
    protected ?string $alternate_admins_only = null;

    /**
     * Gets alternate_admins_only
     *
     * @return ?string
     */
    public function getAlternateAdminsOnly(): ?string
    {
        return $this->alternate_admins_only;
    }

    /**
     * Sets alternate_admins_only
     * @param ?string $alternate_admins_only 
     *
     * @return self
     */
    public function setAlternateAdminsOnly(?string $alternate_admins_only): self
    {
        $this->alternate_admins_only = $alternate_admins_only;
        return $this;
    }
    /**
      * $count Number of records to return. The number must be greater than 0 and less than or equal to 100.
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count Number of records to return. The number must be greater than 0 and less than or equal to 100.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $domain_users_only 
      * @var ?string
      */
    protected ?string $domain_users_only = null;

    /**
     * Gets domain_users_only
     *
     * @return ?string
     */
    public function getDomainUsersOnly(): ?string
    {
        return $this->domain_users_only;
    }

    /**
     * Sets domain_users_only
     * @param ?string $domain_users_only 
     *
     * @return self
     */
    public function setDomainUsersOnly(?string $domain_users_only): self
    {
        $this->domain_users_only = $domain_users_only;
        return $this;
    }
    /**
      * $email 
      * @var ?string
      */
    protected ?string $email = null;

    /**
     * Gets email
     *
     * @return ?string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * Sets email
     * @param ?string $email 
     *
     * @return self
     */
    public function setEmail(?string $email): self
    {
        $this->email = $email;
        return $this;
    }
    /**
      * $email_substring Filters the returned user records by the email address or a sub-string of email address.
      * @var ?string
      */
    protected ?string $email_substring = null;

    /**
     * Gets email_substring
     *
     * @return ?string
     */
    public function getEmailSubstring(): ?string
    {
        return $this->email_substring;
    }

    /**
     * Sets email_substring
     * @param ?string $email_substring Filters the returned user records by the email address or a sub-string of email address.
     *
     * @return self
     */
    public function setEmailSubstring(?string $email_substring): self
    {
        $this->email_substring = $email_substring;
        return $this;
    }
    /**
      * $group_id Filters user records returned by one or more group Id's.
      * @var ?string
      */
    protected ?string $group_id = null;

    /**
     * Gets group_id
     *
     * @return ?string
     */
    public function getGroupId(): ?string
    {
        return $this->group_id;
    }

    /**
     * Sets group_id
     * @param ?string $group_id Filters user records returned by one or more group Id's.
     *
     * @return self
     */
    public function setGroupId(?string $group_id): self
    {
        $this->group_id = $group_id;
        return $this;
    }
    /**
      * $include_usersettings_for_csv 
      * @var ?string
      */
    protected ?string $include_usersettings_for_csv = null;

    /**
     * Gets include_usersettings_for_csv
     *
     * @return ?string
     */
    public function getIncludeUsersettingsForCsv(): ?string
    {
        return $this->include_usersettings_for_csv;
    }

    /**
     * Sets include_usersettings_for_csv
     * @param ?string $include_usersettings_for_csv 
     *
     * @return self
     */
    public function setIncludeUsersettingsForCsv(?string $include_usersettings_for_csv): self
    {
        $this->include_usersettings_for_csv = $include_usersettings_for_csv;
        return $this;
    }
    /**
      * $login_status 
      * @var ?string
      */
    protected ?string $login_status = null;

    /**
     * Gets login_status
     *
     * @return ?string
     */
    public function getLoginStatus(): ?string
    {
        return $this->login_status;
    }

    /**
     * Sets login_status
     * @param ?string $login_status 
     *
     * @return self
     */
    public function setLoginStatus(?string $login_status): self
    {
        $this->login_status = $login_status;
        return $this;
    }
    /**
      * $not_group_id 
      * @var ?string
      */
    protected ?string $not_group_id = null;

    /**
     * Gets not_group_id
     *
     * @return ?string
     */
    public function getNotGroupId(): ?string
    {
        return $this->not_group_id;
    }

    /**
     * Sets not_group_id
     * @param ?string $not_group_id 
     *
     * @return self
     */
    public function setNotGroupId(?string $not_group_id): self
    {
        $this->not_group_id = $not_group_id;
        return $this;
    }
    /**
      * $start_position Starting value for the list.
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position Starting value for the list.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status 
      * @var ?string
      */
    protected ?string $status = null;

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets status
     * @param ?string $status 
     *
     * @return self
     */
    public function setStatus(?string $status): self
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $user_name_substring Filters the user records returned by the user name or a sub-string of user name.
      * @var ?string
      */
    protected ?string $user_name_substring = null;

    /**
     * Gets user_name_substring
     *
     * @return ?string
     */
    public function getUserNameSubstring(): ?string
    {
        return $this->user_name_substring;
    }

    /**
     * Sets user_name_substring
     * @param ?string $user_name_substring Filters the user records returned by the user name or a sub-string of user name.
     *
     * @return self
     */
    public function setUserNameSubstring(?string $user_name_substring): self
    {
        $this->user_name_substring = $user_name_substring;
        return $this;
    }
}


/**
 * DeleteOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DeleteOptions
{
    /**
      * $delete 
      * @var ?string
      */
    protected ?string $delete = null;

    /**
     * Gets delete
     *
     * @return ?string
     */
    public function getDelete(): ?string
    {
        return $this->delete;
    }

    /**
     * Sets delete
     * @param ?string $delete 
     *
     * @return self
     */
    public function setDelete(?string $delete): self
    {
        $this->delete = $delete;
        return $this;
    }
}


/**
 * GetContactByIdOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetContactByIdOptions
{
    /**
      * $cloud_provider 
      * @var ?string
      */
    protected ?string $cloud_provider = null;

    /**
     * Gets cloud_provider
     *
     * @return ?string
     */
    public function getCloudProvider(): ?string
    {
        return $this->cloud_provider;
    }

    /**
     * Sets cloud_provider
     * @param ?string $cloud_provider 
     *
     * @return self
     */
    public function setCloudProvider(?string $cloud_provider): self
    {
        $this->cloud_provider = $cloud_provider;
        return $this;
    }
}


/**
 * GetInformationOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetInformationOptions
{
    /**
      * $additional_info When set to **true**, the full list of user information is returned for each user in the account.
      * @var ?string
      */
    protected ?string $additional_info = null;

    /**
     * Gets additional_info
     *
     * @return ?string
     */
    public function getAdditionalInfo(): ?string
    {
        return $this->additional_info;
    }

    /**
     * Sets additional_info
     * @param ?string $additional_info When set to **true**, the full list of user information is returned for each user in the account.
     *
     * @return self
     */
    public function setAdditionalInfo(?string $additional_info): self
    {
        $this->additional_info = $additional_info;
        return $this;
    }
    /**
      * $email 
      * @var ?string
      */
    protected ?string $email = null;

    /**
     * Gets email
     *
     * @return ?string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * Sets email
     * @param ?string $email 
     *
     * @return self
     */
    public function setEmail(?string $email): self
    {
        $this->email = $email;
        return $this;
    }
}


/**
 * GetProfileImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetProfileImageOptions
{
    /**
      * $encoding 
      * @var ?string
      */
    protected ?string $encoding = null;

    /**
     * Gets encoding
     *
     * @return ?string
     */
    public function getEncoding(): ?string
    {
        return $this->encoding;
    }

    /**
     * Sets encoding
     * @param ?string $encoding 
     *
     * @return self
     */
    public function setEncoding(?string $encoding): self
    {
        $this->encoding = $encoding;
        return $this;
    }
}


/**
 * GetSignatureImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetSignatureImageOptions
{
    /**
      * $include_chrome 
      * @var ?string
      */
    protected ?string $include_chrome = null;

    /**
     * Gets include_chrome
     *
     * @return ?string
     */
    public function getIncludeChrome(): ?string
    {
        return $this->include_chrome;
    }

    /**
     * Sets include_chrome
     * @param ?string $include_chrome 
     *
     * @return self
     */
    public function setIncludeChrome(?string $include_chrome): self
    {
        $this->include_chrome = $include_chrome;
        return $this;
    }
}


/**
 * ListSignaturesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListSignaturesOptions
{
    /**
      * $stamp_type 
      * @var ?string
      */
    protected ?string $stamp_type = null;

    /**
     * Gets stamp_type
     *
     * @return ?string
     */
    public function getStampType(): ?string
    {
        return $this->stamp_type;
    }

    /**
     * Sets stamp_type
     * @param ?string $stamp_type 
     *
     * @return self
     */
    public function setStampType(?string $stamp_type): self
    {
        $this->stamp_type = $stamp_type;
        return $this;
    }
}


/**
 * UpdateSettingsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateSettingsOptions
{
    /**
      * $allow_all_languages 
      * @var ?string
      */
    protected ?string $allow_all_languages = null;

    /**
     * Gets allow_all_languages
     *
     * @return ?string
     */
    public function getAllowAllLanguages(): ?string
    {
        return $this->allow_all_languages;
    }

    /**
     * Sets allow_all_languages
     * @param ?string $allow_all_languages 
     *
     * @return self
     */
    public function setAllowAllLanguages(?string $allow_all_languages): self
    {
        $this->allow_all_languages = $allow_all_languages;
        return $this;
    }
}


/**
 * UpdateSignatureOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateSignatureOptions
{
    /**
      * $close_existing_signature When set to **true**, closes the current signature.
      * @var ?string
      */
    protected ?string $close_existing_signature = null;

    /**
     * Gets close_existing_signature
     *
     * @return ?string
     */
    public function getCloseExistingSignature(): ?string
    {
        return $this->close_existing_signature;
    }

    /**
     * Sets close_existing_signature
     * @param ?string $close_existing_signature When set to **true**, closes the current signature.
     *
     * @return self
     */
    public function setCloseExistingSignature(?string $close_existing_signature): self
    {
        $this->close_existing_signature = $close_existing_signature;
        return $this;
    }
}


/**
 * UpdateSignatureImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateSignatureImageOptions
{
    /**
      * $transparent_png 
      * @var ?string
      */
    protected ?string $transparent_png = null;

    /**
     * Gets transparent_png
     *
     * @return ?string
     */
    public function getTransparentPng(): ?string
    {
        return $this->transparent_png;
    }

    /**
     * Sets transparent_png
     * @param ?string $transparent_png 
     *
     * @return self
     */
    public function setTransparentPng(?string $transparent_png): self
    {
        $this->transparent_png = $transparent_png;
        return $this;
    }
}


/**
 * UpdateUserOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateUserOptions
{
    /**
      * $allow_all_languages 
      * @var ?string
      */
    protected ?string $allow_all_languages = null;

    /**
     * Gets allow_all_languages
     *
     * @return ?string
     */
    public function getAllowAllLanguages(): ?string
    {
        return $this->allow_all_languages;
    }

    /**
     * Sets allow_all_languages
     * @param ?string $allow_all_languages 
     *
     * @return self
     */
    public function setAllowAllLanguages(?string $allow_all_languages): self
    {
        $this->allow_all_languages = $allow_all_languages;
        return $this;
    }
}


/**
 * UpdateUsersOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateUsersOptions
{
    /**
      * $allow_all_languages 
      * @var ?string
      */
    protected ?string $allow_all_languages = null;

    /**
     * Gets allow_all_languages
     *
     * @return ?string
     */
    public function getAllowAllLanguages(): ?string
    {
        return $this->allow_all_languages;
    }

    /**
     * Sets allow_all_languages
     * @param ?string $allow_all_languages 
     *
     * @return self
     */
    public function setAllowAllLanguages(?string $allow_all_languages): self
    {
        $this->allow_all_languages = $allow_all_languages;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * UsersApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UsersApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation callList
     *
     * Retrieves the list of users for the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\UsersApi\ListOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserInformationList
     */
    public function callList($account_id, \DocuSign\eSign\Api\UsersApi\ListOptions $options = null)
    {
        list($response) = $this->callListWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation callListWithHttpInfo
     *
     * Retrieves the list of users for the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\UsersApi\ListOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserInformationList, HTTP status code, HTTP response headers (array of strings)
     */
    public function callListWithHttpInfo($account_id, \DocuSign\eSign\Api\UsersApi\ListOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling callList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAdditionalInfo() != 'null') {
                $queryParams['additional_info'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdditionalInfo());
            }
            if ($options->getAlternateAdminsOnly() != 'null') {
                $queryParams['alternate_admins_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getAlternateAdminsOnly());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getDomainUsersOnly() != 'null') {
                $queryParams['domain_users_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getDomainUsersOnly());
            }
            if ($options->getEmail() != 'null') {
                $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
            }
            if ($options->getEmailSubstring() != 'null') {
                $queryParams['email_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmailSubstring());
            }
            if ($options->getGroupId() != 'null') {
                $queryParams['group_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getGroupId());
            }
            if ($options->getIncludeUsersettingsForCsv() != 'null') {
                $queryParams['include_usersettings_for_csv'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeUsersettingsForCsv());
            }
            if ($options->getLoginStatus() != 'null') {
                $queryParams['login_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getLoginStatus());
            }
            if ($options->getNotGroupId() != 'null') {
                $queryParams['not_group_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getNotGroupId());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getStatus() != 'null') {
                $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
            }
            if ($options->getUserNameSubstring() != 'null') {
                $queryParams['user_name_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserNameSubstring());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserInformationList',
                '/v2.1/accounts/{accountId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserInformationList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserInformationList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation create
     *
     * Adds news user to the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\NewUsersDefinition $new_users_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\NewUsersSummary
     */
    public function create($account_id, $new_users_definition = null)
    {
        list($response) = $this->createWithHttpInfo($account_id, $new_users_definition);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * Adds news user to the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\NewUsersDefinition $new_users_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\NewUsersSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($account_id, $new_users_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling create');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($new_users_definition)) {
            $_tempBody = $new_users_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\NewUsersSummary',
                '/v2.1/accounts/{accountId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\NewUsersSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\NewUsersSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createSignatures
     *
     * Adds user Signature and initials images to a Signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSignaturesInformation $user_signatures_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignaturesInformation
     */
    public function createSignatures($account_id, $user_id, $user_signatures_information = null)
    {
        list($response) = $this->createSignaturesWithHttpInfo($account_id, $user_id, $user_signatures_information);
        return $response;
    }

    /**
     * Operation createSignaturesWithHttpInfo
     *
     * Adds user Signature and initials images to a Signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSignaturesInformation $user_signatures_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignaturesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSignaturesWithHttpInfo($account_id, $user_id, $user_signatures_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createSignatures');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling createSignatures');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_signatures_information)) {
            $_tempBody = $user_signatures_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignaturesInformation',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignaturesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignaturesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation delete
     *
     * Removes users account privileges.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\DeleteOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UsersResponse
     */
    public function delete($account_id, $user_info_list = null, \DocuSign\eSign\Api\UsersApi\DeleteOptions $options = null)
    {
        list($response) = $this->deleteWithHttpInfo($account_id, $user_info_list, $options);
        return $response;
    }

    /**
     * Operation deleteWithHttpInfo
     *
     * Removes users account privileges.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\DeleteOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UsersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWithHttpInfo($account_id, $user_info_list = null, \DocuSign\eSign\Api\UsersApi\DeleteOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling delete');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getDelete() != 'null') {
                $queryParams['delete'] = $this->apiClient->getSerializer()->toQueryValue($options->getDelete());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_info_list)) {
            $_tempBody = $user_info_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UsersResponse',
                '/v2.1/accounts/{accountId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UsersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UsersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteContactWithId
     *
     * Replaces a particular contact associated with an account for the DocuSign service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $contact_id The unique identifier of a person in the contacts address book.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ContactUpdateResponse
     */
    public function deleteContactWithId($account_id, $contact_id)
    {
        list($response) = $this->deleteContactWithIdWithHttpInfo($account_id, $contact_id);
        return $response;
    }

    /**
     * Operation deleteContactWithIdWithHttpInfo
     *
     * Replaces a particular contact associated with an account for the DocuSign service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $contact_id The unique identifier of a person in the contacts address book.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ContactUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteContactWithIdWithHttpInfo($account_id, $contact_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteContactWithId');
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $contact_id when calling deleteContactWithId');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/contacts/{contactId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($contact_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "contactId", $contact_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ContactUpdateResponse',
                '/v2.1/accounts/{accountId}/contacts/{contactId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ContactUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ContactUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteContacts
     *
     * Delete contacts associated with an account for the DocuSign service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ContactModRequest $contact_mod_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ContactUpdateResponse
     */
    public function deleteContacts($account_id, $contact_mod_request = null)
    {
        list($response) = $this->deleteContactsWithHttpInfo($account_id, $contact_mod_request);
        return $response;
    }

    /**
     * Operation deleteContactsWithHttpInfo
     *
     * Delete contacts associated with an account for the DocuSign service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ContactModRequest $contact_mod_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ContactUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteContactsWithHttpInfo($account_id, $contact_mod_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteContacts');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/contacts";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($contact_mod_request)) {
            $_tempBody = $contact_mod_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ContactUpdateResponse',
                '/v2.1/accounts/{accountId}/contacts'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ContactUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ContactUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCustomSettings
     *
     * Deletes custom user settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CustomSettingsInformation $custom_settings_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomSettingsInformation
     */
    public function deleteCustomSettings($account_id, $user_id, $custom_settings_information = null)
    {
        list($response) = $this->deleteCustomSettingsWithHttpInfo($account_id, $user_id, $custom_settings_information);
        return $response;
    }

    /**
     * Operation deleteCustomSettingsWithHttpInfo
     *
     * Deletes custom user settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CustomSettingsInformation $custom_settings_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomSettingsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomSettingsWithHttpInfo($account_id, $user_id, $custom_settings_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCustomSettings');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteCustomSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/custom_settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($custom_settings_information)) {
            $_tempBody = $custom_settings_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomSettingsInformation',
                '/v2.1/accounts/{accountId}/users/{userId}/custom_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomSettingsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomSettingsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProfileImage
     *
     * Deletes the user profile image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteProfileImage($account_id, $user_id)
    {
        list($response) = $this->deleteProfileImageWithHttpInfo($account_id, $user_id);
        return $response;
    }

    /**
     * Operation deleteProfileImageWithHttpInfo
     *
     * Deletes the user profile image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProfileImageWithHttpInfo($account_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteProfileImage');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteProfileImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/profile/image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/users/{userId}/profile/image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteSignature
     *
     * Removes removes signature information for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteSignature($account_id, $signature_id, $user_id)
    {
        list($response) = $this->deleteSignatureWithHttpInfo($account_id, $signature_id, $user_id);
        return $response;
    }

    /**
     * Operation deleteSignatureWithHttpInfo
     *
     * Removes removes signature information for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSignatureWithHttpInfo($account_id, $signature_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteSignature');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling deleteSignature');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteSignature');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteSignatureImage
     *
     * Deletes the user initials image or the  user signature image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignature
     */
    public function deleteSignatureImage($account_id, $image_type, $signature_id, $user_id)
    {
        list($response) = $this->deleteSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $user_id);
        return $response;
    }

    /**
     * Operation deleteSignatureImageWithHttpInfo
     *
     * Deletes the user initials image or the  user signature image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteSignatureImage');
        }
        // verify the required parameter 'image_type' is set
        if ($image_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image_type when calling deleteSignatureImage');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling deleteSignatureImage');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($image_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "imageType", $image_type);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignature',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getContactById
     *
     * Gets a particular contact associated with the user's account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $contact_id The unique identifier of a person in the contacts address book.
     * @param  \DocuSign\eSign\Api\UsersApi\GetContactByIdOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ContactGetResponse
     */
    public function getContactById($account_id, $contact_id, \DocuSign\eSign\Api\UsersApi\GetContactByIdOptions $options = null)
    {
        list($response) = $this->getContactByIdWithHttpInfo($account_id, $contact_id, $options);
        return $response;
    }

    /**
     * Operation getContactByIdWithHttpInfo
     *
     * Gets a particular contact associated with the user's account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $contact_id The unique identifier of a person in the contacts address book.
     * @param  \DocuSign\eSign\Api\UsersApi\GetContactByIdOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ContactGetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getContactByIdWithHttpInfo($account_id, $contact_id, \DocuSign\eSign\Api\UsersApi\GetContactByIdOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getContactById');
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $contact_id when calling getContactById');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/contacts/{contactId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCloudProvider() != 'null') {
                $queryParams['cloud_provider'] = $this->apiClient->getSerializer()->toQueryValue($options->getCloudProvider());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($contact_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "contactId", $contact_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ContactGetResponse',
                '/v2.1/accounts/{accountId}/contacts/{contactId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ContactGetResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ContactGetResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getInformation
     *
     * Gets the user information for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\GetInformationOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserInformation
     */
    public function getInformation($account_id, $user_id, \DocuSign\eSign\Api\UsersApi\GetInformationOptions $options = null)
    {
        list($response) = $this->getInformationWithHttpInfo($account_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation getInformationWithHttpInfo
     *
     * Gets the user information for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\GetInformationOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInformationWithHttpInfo($account_id, $user_id, \DocuSign\eSign\Api\UsersApi\GetInformationOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getInformation');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getInformation');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAdditionalInfo() != 'null') {
                $queryParams['additional_info'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdditionalInfo());
            }
            if ($options->getEmail() != 'null') {
                $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserInformation',
                '/v2.1/accounts/{accountId}/users/{userId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProfile
     *
     * Retrieves the user profile for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserProfile
     */
    public function getProfile($account_id, $user_id)
    {
        list($response) = $this->getProfileWithHttpInfo($account_id, $user_id);
        return $response;
    }

    /**
     * Operation getProfileWithHttpInfo
     *
     * Retrieves the user profile for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserProfile, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProfileWithHttpInfo($account_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getProfile');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getProfile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/profile";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserProfile',
                '/v2.1/accounts/{accountId}/users/{userId}/profile'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserProfile', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProfileImage
     *
     * Retrieves the user profile image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\GetProfileImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getProfileImage($account_id, $user_id, \DocuSign\eSign\Api\UsersApi\GetProfileImageOptions $options = null)
    {
        list($response) = $this->getProfileImageWithHttpInfo($account_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation getProfileImageWithHttpInfo
     *
     * Retrieves the user profile image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\GetProfileImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProfileImageWithHttpInfo($account_id, $user_id, \DocuSign\eSign\Api\UsersApi\GetProfileImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getProfileImage');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getProfileImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/profile/image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/gif']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getEncoding() != 'null') {
                $queryParams['encoding'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncoding());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/users/{userId}/profile/image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getSettings
     *
     * Gets the user account settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSettingsInformation
     */
    public function getSettings($account_id, $user_id)
    {
        list($response) = $this->getSettingsWithHttpInfo($account_id, $user_id);
        return $response;
    }

    /**
     * Operation getSettingsWithHttpInfo
     *
     * Gets the user account settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSettingsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingsWithHttpInfo($account_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getSettings');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSettingsInformation',
                '/v2.1/accounts/{accountId}/users/{userId}/settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSettingsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSettingsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getSignature
     *
     * Gets the user signature information for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignature
     */
    public function getSignature($account_id, $signature_id, $user_id)
    {
        list($response) = $this->getSignatureWithHttpInfo($account_id, $signature_id, $user_id);
        return $response;
    }

    /**
     * Operation getSignatureWithHttpInfo
     *
     * Gets the user signature information for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSignatureWithHttpInfo($account_id, $signature_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getSignature');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling getSignature');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getSignature');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignature',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getSignatureImage
     *
     * Retrieves the user initials image or the  user signature image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\GetSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getSignatureImage($account_id, $image_type, $signature_id, $user_id, \DocuSign\eSign\Api\UsersApi\GetSignatureImageOptions $options = null)
    {
        list($response) = $this->getSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation getSignatureImageWithHttpInfo
     *
     * Retrieves the user initials image or the  user signature image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\GetSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $user_id, \DocuSign\eSign\Api\UsersApi\GetSignatureImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getSignatureImage');
        }
        // verify the required parameter 'image_type' is set
        if ($image_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image_type when calling getSignatureImage');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling getSignatureImage');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/gif']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeChrome() != 'null') {
                $queryParams['include_chrome'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeChrome());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($image_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "imageType", $image_type);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listCustomSettings
     *
     * Retrieves the custom user settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomSettingsInformation
     */
    public function listCustomSettings($account_id, $user_id)
    {
        list($response) = $this->listCustomSettingsWithHttpInfo($account_id, $user_id);
        return $response;
    }

    /**
     * Operation listCustomSettingsWithHttpInfo
     *
     * Retrieves the custom user settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomSettingsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomSettingsWithHttpInfo($account_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listCustomSettings');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling listCustomSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/custom_settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomSettingsInformation',
                '/v2.1/accounts/{accountId}/users/{userId}/custom_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomSettingsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomSettingsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listSignatures
     *
     * Retrieves a list of user signature definitions for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\ListSignaturesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignaturesInformation
     */
    public function listSignatures($account_id, $user_id, \DocuSign\eSign\Api\UsersApi\ListSignaturesOptions $options = null)
    {
        list($response) = $this->listSignaturesWithHttpInfo($account_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation listSignaturesWithHttpInfo
     *
     * Retrieves a list of user signature definitions for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\UsersApi\ListSignaturesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignaturesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSignaturesWithHttpInfo($account_id, $user_id, \DocuSign\eSign\Api\UsersApi\ListSignaturesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listSignatures');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling listSignatures');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getStampType() != 'null') {
                $queryParams['stamp_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getStampType());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignaturesInformation',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignaturesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignaturesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postContacts
     *
     * Imports multiple new contacts into the contacts collection from CSV, JSON, or XML (based on content type).
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ContactModRequest $contact_mod_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ContactUpdateResponse
     */
    public function postContacts($account_id, $contact_mod_request = null)
    {
        list($response) = $this->postContactsWithHttpInfo($account_id, $contact_mod_request);
        return $response;
    }

    /**
     * Operation postContactsWithHttpInfo
     *
     * Imports multiple new contacts into the contacts collection from CSV, JSON, or XML (based on content type).
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ContactModRequest $contact_mod_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ContactUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postContactsWithHttpInfo($account_id, $contact_mod_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling postContacts');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/contacts";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($contact_mod_request)) {
            $_tempBody = $contact_mod_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ContactUpdateResponse',
                '/v2.1/accounts/{accountId}/contacts'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ContactUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ContactUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putContacts
     *
     * Replaces contacts associated with an account for the DocuSign service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ContactModRequest $contact_mod_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ContactUpdateResponse
     */
    public function putContacts($account_id, $contact_mod_request = null)
    {
        list($response) = $this->putContactsWithHttpInfo($account_id, $contact_mod_request);
        return $response;
    }

    /**
     * Operation putContactsWithHttpInfo
     *
     * Replaces contacts associated with an account for the DocuSign service.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ContactModRequest $contact_mod_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ContactUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function putContactsWithHttpInfo($account_id, $contact_mod_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling putContacts');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/contacts";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($contact_mod_request)) {
            $_tempBody = $contact_mod_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ContactUpdateResponse',
                '/v2.1/accounts/{accountId}/contacts'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ContactUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ContactUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateCustomSettings
     *
     * Adds or updates custom user settings for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CustomSettingsInformation $custom_settings_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomSettingsInformation
     */
    public function updateCustomSettings($account_id, $user_id, $custom_settings_information = null)
    {
        list($response) = $this->updateCustomSettingsWithHttpInfo($account_id, $user_id, $custom_settings_information);
        return $response;
    }

    /**
     * Operation updateCustomSettingsWithHttpInfo
     *
     * Adds or updates custom user settings for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CustomSettingsInformation $custom_settings_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomSettingsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomSettingsWithHttpInfo($account_id, $user_id, $custom_settings_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateCustomSettings');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateCustomSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/custom_settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($custom_settings_information)) {
            $_tempBody = $custom_settings_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomSettingsInformation',
                '/v2.1/accounts/{accountId}/users/{userId}/custom_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomSettingsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomSettingsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProfile
     *
     * Updates the user profile information for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserProfile $user_profile  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateProfile($account_id, $user_id, $user_profile = null)
    {
        list($response) = $this->updateProfileWithHttpInfo($account_id, $user_id, $user_profile);
        return $response;
    }

    /**
     * Operation updateProfileWithHttpInfo
     *
     * Updates the user profile information for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserProfile $user_profile  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProfileWithHttpInfo($account_id, $user_id, $user_profile = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateProfile');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateProfile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/profile";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_profile)) {
            $_tempBody = $user_profile;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/users/{userId}/profile'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateProfileImage
     *
     * Updates the user profile image for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateProfileImage($account_id, $user_id)
    {
        list($response) = $this->updateProfileImageWithHttpInfo($account_id, $user_id);
        return $response;
    }

    /**
     * Operation updateProfileImageWithHttpInfo
     *
     * Updates the user profile image for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateProfileImageWithHttpInfo($account_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateProfileImage');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateProfileImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/profile/image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['image/gif']);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/users/{userId}/profile/image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSettings
     *
     * Updates the user account settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSettingsInformation $user_settings_information  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateSettingsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateSettings($account_id, $user_id, $user_settings_information = null, \DocuSign\eSign\Api\UsersApi\UpdateSettingsOptions $options = null)
    {
        list($response) = $this->updateSettingsWithHttpInfo($account_id, $user_id, $user_settings_information, $options);
        return $response;
    }

    /**
     * Operation updateSettingsWithHttpInfo
     *
     * Updates the user account settings for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSettingsInformation $user_settings_information  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateSettingsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSettingsWithHttpInfo($account_id, $user_id, $user_settings_information = null, \DocuSign\eSign\Api\UsersApi\UpdateSettingsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSettings');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAllowAllLanguages() != 'null') {
                $queryParams['allow_all_languages'] = $this->apiClient->getSerializer()->toQueryValue($options->getAllowAllLanguages());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_settings_information)) {
            $_tempBody = $user_settings_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/users/{userId}/settings'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSignature
     *
     * Updates the user signature for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSignatureDefinition $user_signature_definition  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateSignatureOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignature
     */
    public function updateSignature($account_id, $signature_id, $user_id, $user_signature_definition = null, \DocuSign\eSign\Api\UsersApi\UpdateSignatureOptions $options = null)
    {
        list($response) = $this->updateSignatureWithHttpInfo($account_id, $signature_id, $user_id, $user_signature_definition, $options);
        return $response;
    }

    /**
     * Operation updateSignatureWithHttpInfo
     *
     * Updates the user signature for a specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSignatureDefinition $user_signature_definition  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateSignatureOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSignatureWithHttpInfo($account_id, $signature_id, $user_id, $user_signature_definition = null, \DocuSign\eSign\Api\UsersApi\UpdateSignatureOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSignature');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling updateSignature');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateSignature');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCloseExistingSignature() != 'null') {
                $queryParams['close_existing_signature'] = $this->apiClient->getSerializer()->toQueryValue($options->getCloseExistingSignature());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_signature_definition)) {
            $_tempBody = $user_signature_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignature',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSignatureImage
     *
     * Updates the user signature image or user initials image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param ?string $image_bytes Image content. (required)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignature
     */
    public function updateSignatureImage($account_id, $image_type, $signature_id, $user_id, $image_bytes, \DocuSign\eSign\Api\UsersApi\UpdateSignatureImageOptions $options = null)
    {
        list($response) = $this->updateSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $user_id, $image_bytes, $options);
        return $response;
    }

    /**
     * Operation updateSignatureImageWithHttpInfo
     *
     * Updates the user signature image or user initials image for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param ?string $image_bytes Image content. (required)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $user_id, $image_bytes, \DocuSign\eSign\Api\UsersApi\UpdateSignatureImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSignatureImage');
        }
        // verify the required parameter 'image_type' is set
        if ($image_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image_type when calling updateSignatureImage');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling updateSignatureImage');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateSignatureImage');
        }
        // verify the required parameter 'image_bytes' is set
        if ($image_bytes === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image_bytes when calling updateSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['image/gif']);

        if ($options != null)
        {
            // query params
            if ($options->getTransparentPng() != 'null') {
                $queryParams['transparent_png'] = $this->apiClient->getSerializer()->toQueryValue($options->getTransparentPng());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($image_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "imageType", $image_type);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($image_bytes)) {
            $_tempBody = $image_bytes;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignature',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSignatures
     *
     * Adds/updates a user signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSignaturesInformation $user_signatures_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignaturesInformation
     */
    public function updateSignatures($account_id, $user_id, $user_signatures_information = null)
    {
        list($response) = $this->updateSignaturesWithHttpInfo($account_id, $user_id, $user_signatures_information);
        return $response;
    }

    /**
     * Operation updateSignaturesWithHttpInfo
     *
     * Adds/updates a user signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserSignaturesInformation $user_signatures_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignaturesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSignaturesWithHttpInfo($account_id, $user_id, $user_signatures_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSignatures');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateSignatures');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/signatures";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_signatures_information)) {
            $_tempBody = $user_signatures_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignaturesInformation',
                '/v2.1/accounts/{accountId}/users/{userId}/signatures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignaturesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignaturesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateUser
     *
     * Updates the specified user information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserInformation $user_information  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateUserOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserInformation
     */
    public function updateUser($account_id, $user_id, $user_information = null, \DocuSign\eSign\Api\UsersApi\UpdateUserOptions $options = null)
    {
        list($response) = $this->updateUserWithHttpInfo($account_id, $user_id, $user_information, $options);
        return $response;
    }

    /**
     * Operation updateUserWithHttpInfo
     *
     * Updates the specified user information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserInformation $user_information  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateUserOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUserWithHttpInfo($account_id, $user_id, $user_information = null, \DocuSign\eSign\Api\UsersApi\UpdateUserOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateUser');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateUser');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAllowAllLanguages() != 'null') {
                $queryParams['allow_all_languages'] = $this->apiClient->getSerializer()->toQueryValue($options->getAllowAllLanguages());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_information)) {
            $_tempBody = $user_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserInformation',
                '/v2.1/accounts/{accountId}/users/{userId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateUsers
     *
     * Change one or more user in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\UserInformationList $user_information_list  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserInformationList
     */
    public function updateUsers($account_id, $user_information_list = null, \DocuSign\eSign\Api\UsersApi\UpdateUsersOptions $options = null)
    {
        list($response) = $this->updateUsersWithHttpInfo($account_id, $user_information_list, $options);
        return $response;
    }

    /**
     * Operation updateUsersWithHttpInfo
     *
     * Change one or more user in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\UserInformationList $user_information_list  (optional)
     * @param  \DocuSign\eSign\Api\UsersApi\UpdateUsersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserInformationList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUsersWithHttpInfo($account_id, $user_information_list = null, \DocuSign\eSign\Api\UsersApi\UpdateUsersOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateUsers');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAllowAllLanguages() != 'null') {
                $queryParams['allow_all_languages'] = $this->apiClient->getSerializer()->toQueryValue($options->getAllowAllLanguages());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_information_list)) {
            $_tempBody = $user_information_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserInformationList',
                '/v2.1/accounts/{accountId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserInformationList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserInformationList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
