<?php
declare(strict_types=1);

/**
 * AccountsApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\AccountsApi;


/**
 * CreateOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CreateOptions
{
    /**
      * $preview_billing_plan When set to **true**, creates the account using a preview billing plan.
      * @var ?string
      */
    protected ?string $preview_billing_plan = null;

    /**
     * Gets preview_billing_plan
     *
     * @return ?string
     */
    public function getPreviewBillingPlan(): ?string
    {
        return $this->preview_billing_plan;
    }

    /**
     * Sets preview_billing_plan
     * @param ?string $preview_billing_plan When set to **true**, creates the account using a preview billing plan.
     *
     * @return self
     */
    public function setPreviewBillingPlan(?string $preview_billing_plan): self
    {
        $this->preview_billing_plan = $preview_billing_plan;
        return $this;
    }
}


/**
 * CreateAccountSignaturesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CreateAccountSignaturesOptions
{
    /**
      * $decode_only 
      * @var ?string
      */
    protected ?string $decode_only = null;

    /**
     * Gets decode_only
     *
     * @return ?string
     */
    public function getDecodeOnly(): ?string
    {
        return $this->decode_only;
    }

    /**
     * Sets decode_only
     * @param ?string $decode_only 
     *
     * @return self
     */
    public function setDecodeOnly(?string $decode_only): self
    {
        $this->decode_only = $decode_only;
        return $this;
    }
}


/**
 * CreateCustomFieldOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CreateCustomFieldOptions
{
    /**
      * $apply_to_templates 
      * @var ?string
      */
    protected ?string $apply_to_templates = null;

    /**
     * Gets apply_to_templates
     *
     * @return ?string
     */
    public function getApplyToTemplates(): ?string
    {
        return $this->apply_to_templates;
    }

    /**
     * Sets apply_to_templates
     * @param ?string $apply_to_templates 
     *
     * @return self
     */
    public function setApplyToTemplates(?string $apply_to_templates): self
    {
        $this->apply_to_templates = $apply_to_templates;
        return $this;
    }
}


/**
 * CreatePermissionProfileOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CreatePermissionProfileOptions
{
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * DeleteOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DeleteOptions
{
    /**
      * $redact_user_data 
      * @var ?string
      */
    protected ?string $redact_user_data = null;

    /**
     * Gets redact_user_data
     *
     * @return ?string
     */
    public function getRedactUserData(): ?string
    {
        return $this->redact_user_data;
    }

    /**
     * Sets redact_user_data
     * @param ?string $redact_user_data 
     *
     * @return self
     */
    public function setRedactUserData(?string $redact_user_data): self
    {
        $this->redact_user_data = $redact_user_data;
        return $this;
    }
}


/**
 * DeleteCustomFieldOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DeleteCustomFieldOptions
{
    /**
      * $apply_to_templates 
      * @var ?string
      */
    protected ?string $apply_to_templates = null;

    /**
     * Gets apply_to_templates
     *
     * @return ?string
     */
    public function getApplyToTemplates(): ?string
    {
        return $this->apply_to_templates;
    }

    /**
     * Sets apply_to_templates
     * @param ?string $apply_to_templates 
     *
     * @return self
     */
    public function setApplyToTemplates(?string $apply_to_templates): self
    {
        $this->apply_to_templates = $apply_to_templates;
        return $this;
    }
}


/**
 * DeletePermissionProfileOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class DeletePermissionProfileOptions
{
    /**
      * $move_users_to 
      * @var ?string
      */
    protected ?string $move_users_to = null;

    /**
     * Gets move_users_to
     *
     * @return ?string
     */
    public function getMoveUsersTo(): ?string
    {
        return $this->move_users_to;
    }

    /**
     * Sets move_users_to
     * @param ?string $move_users_to 
     *
     * @return self
     */
    public function setMoveUsersTo(?string $move_users_to): self
    {
        $this->move_users_to = $move_users_to;
        return $this;
    }
}


/**
 * GetAccountIdentityVerificationOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetAccountIdentityVerificationOptions
{
    /**
      * $identity_verification_workflow_status 
      * @var ?string
      */
    protected ?string $identity_verification_workflow_status = null;

    /**
     * Gets identity_verification_workflow_status
     *
     * @return ?string
     */
    public function getIdentityVerificationWorkflowStatus(): ?string
    {
        return $this->identity_verification_workflow_status;
    }

    /**
     * Sets identity_verification_workflow_status
     * @param ?string $identity_verification_workflow_status 
     *
     * @return self
     */
    public function setIdentityVerificationWorkflowStatus(?string $identity_verification_workflow_status): self
    {
        $this->identity_verification_workflow_status = $identity_verification_workflow_status;
        return $this;
    }
}


/**
 * GetAccountInformationOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetAccountInformationOptions
{
    /**
      * $include_account_settings When set to **true**, includes the account settings for the account in the response.
      * @var ?string
      */
    protected ?string $include_account_settings = null;

    /**
     * Gets include_account_settings
     *
     * @return ?string
     */
    public function getIncludeAccountSettings(): ?string
    {
        return $this->include_account_settings;
    }

    /**
     * Sets include_account_settings
     * @param ?string $include_account_settings When set to **true**, includes the account settings for the account in the response.
     *
     * @return self
     */
    public function setIncludeAccountSettings(?string $include_account_settings): self
    {
        $this->include_account_settings = $include_account_settings;
        return $this;
    }
}


/**
 * GetAccountSignatureImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetAccountSignatureImageOptions
{
    /**
      * $include_chrome 
      * @var ?string
      */
    protected ?string $include_chrome = null;

    /**
     * Gets include_chrome
     *
     * @return ?string
     */
    public function getIncludeChrome(): ?string
    {
        return $this->include_chrome;
    }

    /**
     * Sets include_chrome
     * @param ?string $include_chrome 
     *
     * @return self
     */
    public function setIncludeChrome(?string $include_chrome): self
    {
        $this->include_chrome = $include_chrome;
        return $this;
    }
}


/**
 * GetAccountSignaturesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetAccountSignaturesOptions
{
    /**
      * $stamp_format 
      * @var ?string
      */
    protected ?string $stamp_format = null;

    /**
     * Gets stamp_format
     *
     * @return ?string
     */
    public function getStampFormat(): ?string
    {
        return $this->stamp_format;
    }

    /**
     * Sets stamp_format
     * @param ?string $stamp_format 
     *
     * @return self
     */
    public function setStampFormat(?string $stamp_format): self
    {
        $this->stamp_format = $stamp_format;
        return $this;
    }
    /**
      * $stamp_name 
      * @var ?string
      */
    protected ?string $stamp_name = null;

    /**
     * Gets stamp_name
     *
     * @return ?string
     */
    public function getStampName(): ?string
    {
        return $this->stamp_name;
    }

    /**
     * Sets stamp_name
     * @param ?string $stamp_name 
     *
     * @return self
     */
    public function setStampName(?string $stamp_name): self
    {
        $this->stamp_name = $stamp_name;
        return $this;
    }
    /**
      * $stamp_type 
      * @var ?string
      */
    protected ?string $stamp_type = null;

    /**
     * Gets stamp_type
     *
     * @return ?string
     */
    public function getStampType(): ?string
    {
        return $this->stamp_type;
    }

    /**
     * Sets stamp_type
     * @param ?string $stamp_type 
     *
     * @return self
     */
    public function setStampType(?string $stamp_type): self
    {
        $this->stamp_type = $stamp_type;
        return $this;
    }
}


/**
 * GetAgentUserAuthorizationsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetAgentUserAuthorizationsOptions
{
    /**
      * $active_only 
      * @var ?string
      */
    protected ?string $active_only = null;

    /**
     * Gets active_only
     *
     * @return ?string
     */
    public function getActiveOnly(): ?string
    {
        return $this->active_only;
    }

    /**
     * Sets active_only
     * @param ?string $active_only 
     *
     * @return self
     */
    public function setActiveOnly(?string $active_only): self
    {
        $this->active_only = $active_only;
        return $this;
    }
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $email_substring Part (substring) of email we are searching for.
      * @var ?string
      */
    protected ?string $email_substring = null;

    /**
     * Gets email_substring
     *
     * @return ?string
     */
    public function getEmailSubstring(): ?string
    {
        return $this->email_substring;
    }

    /**
     * Sets email_substring
     * @param ?string $email_substring Part (substring) of email we are searching for.
     *
     * @return self
     */
    public function setEmailSubstring(?string $email_substring): self
    {
        $this->email_substring = $email_substring;
        return $this;
    }
    /**
      * $include_closed_users 
      * @var ?string
      */
    protected ?string $include_closed_users = null;

    /**
     * Gets include_closed_users
     *
     * @return ?string
     */
    public function getIncludeClosedUsers(): ?string
    {
        return $this->include_closed_users;
    }

    /**
     * Sets include_closed_users
     * @param ?string $include_closed_users 
     *
     * @return self
     */
    public function setIncludeClosedUsers(?string $include_closed_users): self
    {
        $this->include_closed_users = $include_closed_users;
        return $this;
    }
    /**
      * $permissions 
      * @var ?string
      */
    protected ?string $permissions = null;

    /**
     * Gets permissions
     *
     * @return ?string
     */
    public function getPermissions(): ?string
    {
        return $this->permissions;
    }

    /**
     * Sets permissions
     * @param ?string $permissions 
     *
     * @return self
     */
    public function setPermissions(?string $permissions): self
    {
        $this->permissions = $permissions;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $user_name_substring 
      * @var ?string
      */
    protected ?string $user_name_substring = null;

    /**
     * Gets user_name_substring
     *
     * @return ?string
     */
    public function getUserNameSubstring(): ?string
    {
        return $this->user_name_substring;
    }

    /**
     * Sets user_name_substring
     * @param ?string $user_name_substring 
     *
     * @return self
     */
    public function setUserNameSubstring(?string $user_name_substring): self
    {
        $this->user_name_substring = $user_name_substring;
        return $this;
    }
}


/**
 * GetBillingChargesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetBillingChargesOptions
{
    /**
      * $include_charges Specifies which billing charges to return. Valid values are:  * envelopes * seats
      * @var ?string
      */
    protected ?string $include_charges = null;

    /**
     * Gets include_charges
     *
     * @return ?string
     */
    public function getIncludeCharges(): ?string
    {
        return $this->include_charges;
    }

    /**
     * Sets include_charges
     * @param ?string $include_charges Specifies which billing charges to return. Valid values are:  * envelopes * seats
     *
     * @return self
     */
    public function setIncludeCharges(?string $include_charges): self
    {
        $this->include_charges = $include_charges;
        return $this;
    }
}


/**
 * GetBrandOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetBrandOptions
{
    /**
      * $include_external_references 
      * @var ?string
      */
    protected ?string $include_external_references = null;

    /**
     * Gets include_external_references
     *
     * @return ?string
     */
    public function getIncludeExternalReferences(): ?string
    {
        return $this->include_external_references;
    }

    /**
     * Sets include_external_references
     * @param ?string $include_external_references 
     *
     * @return self
     */
    public function setIncludeExternalReferences(?string $include_external_references): self
    {
        $this->include_external_references = $include_external_references;
        return $this;
    }
    /**
      * $include_logos 
      * @var ?string
      */
    protected ?string $include_logos = null;

    /**
     * Gets include_logos
     *
     * @return ?string
     */
    public function getIncludeLogos(): ?string
    {
        return $this->include_logos;
    }

    /**
     * Sets include_logos
     * @param ?string $include_logos 
     *
     * @return self
     */
    public function setIncludeLogos(?string $include_logos): self
    {
        $this->include_logos = $include_logos;
        return $this;
    }
}


/**
 * GetBrandResourcesByContentTypeOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetBrandResourcesByContentTypeOptions
{
    /**
      * $langcode 
      * @var ?string
      */
    protected ?string $langcode = null;

    /**
     * Gets langcode
     *
     * @return ?string
     */
    public function getLangcode(): ?string
    {
        return $this->langcode;
    }

    /**
     * Sets langcode
     * @param ?string $langcode 
     *
     * @return self
     */
    public function setLangcode(?string $langcode): self
    {
        $this->langcode = $langcode;
        return $this;
    }
    /**
      * $return_master 
      * @var ?string
      */
    protected ?string $return_master = null;

    /**
     * Gets return_master
     *
     * @return ?string
     */
    public function getReturnMaster(): ?string
    {
        return $this->return_master;
    }

    /**
     * Sets return_master
     * @param ?string $return_master 
     *
     * @return self
     */
    public function setReturnMaster(?string $return_master): self
    {
        $this->return_master = $return_master;
        return $this;
    }
}


/**
 * GetConsumerDisclosureDefaultOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetConsumerDisclosureDefaultOptions
{
    /**
      * $lang_code Specifies the language used in the response. The supported languages, with the language value shown in parenthesis, are: Arabic (ar), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk), and Vietnamese (vi).  Additionally, the value can be set to `browser` to automatically detect the browser language being used by the viewer and display the disclosure in that language.
      * @var ?string
      */
    protected ?string $lang_code = null;

    /**
     * Gets lang_code
     *
     * @return ?string
     */
    public function getLangCode(): ?string
    {
        return $this->lang_code;
    }

    /**
     * Sets lang_code
     * @param ?string $lang_code Specifies the language used in the response. The supported languages, with the language value shown in parenthesis, are: Arabic (ar), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk), and Vietnamese (vi).  Additionally, the value can be set to `browser` to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     *
     * @return self
     */
    public function setLangCode(?string $lang_code): self
    {
        $this->lang_code = $lang_code;
        return $this;
    }
}


/**
 * GetPermissionProfileOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetPermissionProfileOptions
{
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * GetPrincipalUserAuthorizationsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetPrincipalUserAuthorizationsOptions
{
    /**
      * $active_only 
      * @var ?string
      */
    protected ?string $active_only = null;

    /**
     * Gets active_only
     *
     * @return ?string
     */
    public function getActiveOnly(): ?string
    {
        return $this->active_only;
    }

    /**
     * Sets active_only
     * @param ?string $active_only 
     *
     * @return self
     */
    public function setActiveOnly(?string $active_only): self
    {
        $this->active_only = $active_only;
        return $this;
    }
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $email_substring Part (substring) of email we are searching for.
      * @var ?string
      */
    protected ?string $email_substring = null;

    /**
     * Gets email_substring
     *
     * @return ?string
     */
    public function getEmailSubstring(): ?string
    {
        return $this->email_substring;
    }

    /**
     * Sets email_substring
     * @param ?string $email_substring Part (substring) of email we are searching for.
     *
     * @return self
     */
    public function setEmailSubstring(?string $email_substring): self
    {
        $this->email_substring = $email_substring;
        return $this;
    }
    /**
      * $include_closed_users 
      * @var ?string
      */
    protected ?string $include_closed_users = null;

    /**
     * Gets include_closed_users
     *
     * @return ?string
     */
    public function getIncludeClosedUsers(): ?string
    {
        return $this->include_closed_users;
    }

    /**
     * Sets include_closed_users
     * @param ?string $include_closed_users 
     *
     * @return self
     */
    public function setIncludeClosedUsers(?string $include_closed_users): self
    {
        $this->include_closed_users = $include_closed_users;
        return $this;
    }
    /**
      * $permissions 
      * @var ?string
      */
    protected ?string $permissions = null;

    /**
     * Gets permissions
     *
     * @return ?string
     */
    public function getPermissions(): ?string
    {
        return $this->permissions;
    }

    /**
     * Sets permissions
     * @param ?string $permissions 
     *
     * @return self
     */
    public function setPermissions(?string $permissions): self
    {
        $this->permissions = $permissions;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $user_name_substring 
      * @var ?string
      */
    protected ?string $user_name_substring = null;

    /**
     * Gets user_name_substring
     *
     * @return ?string
     */
    public function getUserNameSubstring(): ?string
    {
        return $this->user_name_substring;
    }

    /**
     * Sets user_name_substring
     * @param ?string $user_name_substring 
     *
     * @return self
     */
    public function setUserNameSubstring(?string $user_name_substring): self
    {
        $this->user_name_substring = $user_name_substring;
        return $this;
    }
}


/**
 * ListBrandsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListBrandsOptions
{
    /**
      * $exclude_distributor_brand When set to **true**, excludes distributor brand information from the response set.
      * @var ?string
      */
    protected ?string $exclude_distributor_brand = null;

    /**
     * Gets exclude_distributor_brand
     *
     * @return ?string
     */
    public function getExcludeDistributorBrand(): ?string
    {
        return $this->exclude_distributor_brand;
    }

    /**
     * Sets exclude_distributor_brand
     * @param ?string $exclude_distributor_brand When set to **true**, excludes distributor brand information from the response set.
     *
     * @return self
     */
    public function setExcludeDistributorBrand(?string $exclude_distributor_brand): self
    {
        $this->exclude_distributor_brand = $exclude_distributor_brand;
        return $this;
    }
    /**
      * $include_logos When set to **true**, returns the logos associated with the brand.
      * @var ?string
      */
    protected ?string $include_logos = null;

    /**
     * Gets include_logos
     *
     * @return ?string
     */
    public function getIncludeLogos(): ?string
    {
        return $this->include_logos;
    }

    /**
     * Sets include_logos
     * @param ?string $include_logos When set to **true**, returns the logos associated with the brand.
     *
     * @return self
     */
    public function setIncludeLogos(?string $include_logos): self
    {
        $this->include_logos = $include_logos;
        return $this;
    }
}


/**
 * ListPermissionsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListPermissionsOptions
{
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * ListRecipientNamesByEmailOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListRecipientNamesByEmailOptions
{
    /**
      * $email The email address for the user
      * @var ?string
      */
    protected ?string $email = null;

    /**
     * Gets email
     *
     * @return ?string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * Sets email
     * @param ?string $email The email address for the user
     *
     * @return self
     */
    public function setEmail(?string $email): self
    {
        $this->email = $email;
        return $this;
    }
}


/**
 * ListSharedAccessOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListSharedAccessOptions
{
    /**
      * $count Specifies maximum number of results included in the response. If no value is specified, this defaults to 1000.
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count Specifies maximum number of results included in the response. If no value is specified, this defaults to 1000.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $envelopes_not_shared_user_status 
      * @var ?string
      */
    protected ?string $envelopes_not_shared_user_status = null;

    /**
     * Gets envelopes_not_shared_user_status
     *
     * @return ?string
     */
    public function getEnvelopesNotSharedUserStatus(): ?string
    {
        return $this->envelopes_not_shared_user_status;
    }

    /**
     * Sets envelopes_not_shared_user_status
     * @param ?string $envelopes_not_shared_user_status 
     *
     * @return self
     */
    public function setEnvelopesNotSharedUserStatus(?string $envelopes_not_shared_user_status): self
    {
        $this->envelopes_not_shared_user_status = $envelopes_not_shared_user_status;
        return $this;
    }
    /**
      * $folder_ids 
      * @var ?string
      */
    protected ?string $folder_ids = null;

    /**
     * Gets folder_ids
     *
     * @return ?string
     */
    public function getFolderIds(): ?string
    {
        return $this->folder_ids;
    }

    /**
     * Sets folder_ids
     * @param ?string $folder_ids 
     *
     * @return self
     */
    public function setFolderIds(?string $folder_ids): self
    {
        $this->folder_ids = $folder_ids;
        return $this;
    }
    /**
      * $item_type Specifies the type of shared item being requested. The accepted values are: -envelopes: returns information about envelope sharing between users.
      * @var ?string
      */
    protected ?string $item_type = null;

    /**
     * Gets item_type
     *
     * @return ?string
     */
    public function getItemType(): ?string
    {
        return $this->item_type;
    }

    /**
     * Sets item_type
     * @param ?string $item_type Specifies the type of shared item being requested. The accepted values are: -envelopes: returns information about envelope sharing between users.
     *
     * @return self
     */
    public function setItemType(?string $item_type): self
    {
        $this->item_type = $item_type;
        return $this;
    }
    /**
      * $search_text This can be used to filter user names in the response. The wild-card '*' (asterisk) can be used around the string.
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text This can be used to filter user names in the response. The wild-card '*' (asterisk) can be used around the string.
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $shared Specifies which users should be included in the response. Multiple values can be used in the query by using a comma separated list of shared values. If the requestor does not have account administrator privileges, the shared_to value is used. Requestors that do not have account administrator privileges can only use the shared_to, any other setting will result in an error. The accepted values are:  -not_shared: Returns account users that the specified item type is not being shared with and that are not sharing the specified item type with the user.  User X (Share) X Account user  -shared_to: Returns account users that the specified item type is not being shared with and who are sharing the specified item type with the user (only shared to the user).  User X (Share) Account user  -shared_from: Returns account users that the specified item type is being shared with and who are not sharing the specified item type with the user (only shared from the user).  User (Share) >> Account user  -shared_to_and_from: Returns account users that the specified item type is being shared with and who are sharing the specified item type with the user.  User << (Share) >> Account user
      * @var ?string
      */
    protected ?string $shared = null;

    /**
     * Gets shared
     *
     * @return ?string
     */
    public function getShared(): ?string
    {
        return $this->shared;
    }

    /**
     * Sets shared
     * @param ?string $shared Specifies which users should be included in the response. Multiple values can be used in the query by using a comma separated list of shared values. If the requestor does not have account administrator privileges, the shared_to value is used. Requestors that do not have account administrator privileges can only use the shared_to, any other setting will result in an error. The accepted values are:  -not_shared: Returns account users that the specified item type is not being shared with and that are not sharing the specified item type with the user.  User X (Share) X Account user  -shared_to: Returns account users that the specified item type is not being shared with and who are sharing the specified item type with the user (only shared to the user).  User X (Share) Account user  -shared_from: Returns account users that the specified item type is being shared with and who are not sharing the specified item type with the user (only shared from the user).  User (Share) >> Account user  -shared_to_and_from: Returns account users that the specified item type is being shared with and who are sharing the specified item type with the user.  User << (Share) >> Account user
     *
     * @return self
     */
    public function setShared(?string $shared): self
    {
        $this->shared = $shared;
        return $this;
    }
    /**
      * $start_position If the response set exceeds Count, this can be used to specify that the method should return users starting at the specified index. The first index is 0, and should be used in the first GET call. Typically this number is a multiple of Count. If no value is specified, this defaults to be 0.
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position If the response set exceeds Count, this can be used to specify that the method should return users starting at the specified index. The first index is 0, and should be used in the first GET call. Typically this number is a multiple of Count. If no value is specified, this defaults to be 0.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $user_ids A comma separated list of userIds for whom the shared item information is being requested.
      * @var ?string
      */
    protected ?string $user_ids = null;

    /**
     * Gets user_ids
     *
     * @return ?string
     */
    public function getUserIds(): ?string
    {
        return $this->user_ids;
    }

    /**
     * Sets user_ids
     * @param ?string $user_ids A comma separated list of userIds for whom the shared item information is being requested.
     *
     * @return self
     */
    public function setUserIds(?string $user_ids): self
    {
        $this->user_ids = $user_ids;
        return $this;
    }
}


/**
 * UpdateAccountSignatureByIdOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateAccountSignatureByIdOptions
{
    /**
      * $close_existing_signature 
      * @var ?string
      */
    protected ?string $close_existing_signature = null;

    /**
     * Gets close_existing_signature
     *
     * @return ?string
     */
    public function getCloseExistingSignature(): ?string
    {
        return $this->close_existing_signature;
    }

    /**
     * Sets close_existing_signature
     * @param ?string $close_existing_signature 
     *
     * @return self
     */
    public function setCloseExistingSignature(?string $close_existing_signature): self
    {
        $this->close_existing_signature = $close_existing_signature;
        return $this;
    }
}


/**
 * UpdateAccountSignatureImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateAccountSignatureImageOptions
{
    /**
      * $transparent_png 
      * @var ?string
      */
    protected ?string $transparent_png = null;

    /**
     * Gets transparent_png
     *
     * @return ?string
     */
    public function getTransparentPng(): ?string
    {
        return $this->transparent_png;
    }

    /**
     * Sets transparent_png
     * @param ?string $transparent_png 
     *
     * @return self
     */
    public function setTransparentPng(?string $transparent_png): self
    {
        $this->transparent_png = $transparent_png;
        return $this;
    }
}


/**
 * UpdateBrandOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateBrandOptions
{
    /**
      * $replace_brand 
      * @var ?string
      */
    protected ?string $replace_brand = null;

    /**
     * Gets replace_brand
     *
     * @return ?string
     */
    public function getReplaceBrand(): ?string
    {
        return $this->replace_brand;
    }

    /**
     * Sets replace_brand
     * @param ?string $replace_brand 
     *
     * @return self
     */
    public function setReplaceBrand(?string $replace_brand): self
    {
        $this->replace_brand = $replace_brand;
        return $this;
    }
}


/**
 * UpdateConsumerDisclosureOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateConsumerDisclosureOptions
{
    /**
      * $include_metadata 
      * @var ?string
      */
    protected ?string $include_metadata = null;

    /**
     * Gets include_metadata
     *
     * @return ?string
     */
    public function getIncludeMetadata(): ?string
    {
        return $this->include_metadata;
    }

    /**
     * Sets include_metadata
     * @param ?string $include_metadata 
     *
     * @return self
     */
    public function setIncludeMetadata(?string $include_metadata): self
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
}


/**
 * UpdateCustomFieldOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateCustomFieldOptions
{
    /**
      * $apply_to_templates 
      * @var ?string
      */
    protected ?string $apply_to_templates = null;

    /**
     * Gets apply_to_templates
     *
     * @return ?string
     */
    public function getApplyToTemplates(): ?string
    {
        return $this->apply_to_templates;
    }

    /**
     * Sets apply_to_templates
     * @param ?string $apply_to_templates 
     *
     * @return self
     */
    public function setApplyToTemplates(?string $apply_to_templates): self
    {
        $this->apply_to_templates = $apply_to_templates;
        return $this;
    }
}


/**
 * UpdatePermissionProfileOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdatePermissionProfileOptions
{
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * UpdateSharedAccessOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateSharedAccessOptions
{
    /**
      * $item_type 
      * @var ?string
      */
    protected ?string $item_type = null;

    /**
     * Gets item_type
     *
     * @return ?string
     */
    public function getItemType(): ?string
    {
        return $this->item_type;
    }

    /**
     * Sets item_type
     * @param ?string $item_type 
     *
     * @return self
     */
    public function setItemType(?string $item_type): self
    {
        $this->item_type = $item_type;
        return $this;
    }
    /**
      * $preserve_existing_shared_access 
      * @var ?string
      */
    protected ?string $preserve_existing_shared_access = null;

    /**
     * Gets preserve_existing_shared_access
     *
     * @return ?string
     */
    public function getPreserveExistingSharedAccess(): ?string
    {
        return $this->preserve_existing_shared_access;
    }

    /**
     * Sets preserve_existing_shared_access
     * @param ?string $preserve_existing_shared_access 
     *
     * @return self
     */
    public function setPreserveExistingSharedAccess(?string $preserve_existing_shared_access): self
    {
        $this->preserve_existing_shared_access = $preserve_existing_shared_access;
        return $this;
    }
    /**
      * $user_ids 
      * @var ?string
      */
    protected ?string $user_ids = null;

    /**
     * Gets user_ids
     *
     * @return ?string
     */
    public function getUserIds(): ?string
    {
        return $this->user_ids;
    }

    /**
     * Sets user_ids
     * @param ?string $user_ids 
     *
     * @return self
     */
    public function setUserIds(?string $user_ids): self
    {
        $this->user_ids = $user_ids;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * AccountsApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class AccountsApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation create
     *
     * Creates new accounts.
     *
     * @param \DocuSign\eSign\Model\NewAccountDefinition $new_account_definition  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreateOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\NewAccountSummary
     */
    public function create($new_account_definition = null, \DocuSign\eSign\Api\AccountsApi\CreateOptions $options = null)
    {
        list($response) = $this->createWithHttpInfo($new_account_definition, $options);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * Creates new accounts.
     *
     * @param \DocuSign\eSign\Model\NewAccountDefinition $new_account_definition  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreateOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\NewAccountSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($new_account_definition = null, \DocuSign\eSign\Api\AccountsApi\CreateOptions $options = null): array
    {
        // parse inputs
        $resourcePath = "/v2.1/accounts";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getPreviewBillingPlan() != 'null') {
                $queryParams['preview_billing_plan'] = $this->apiClient->getSerializer()->toQueryValue($options->getPreviewBillingPlan());
            }
        }


        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($new_account_definition)) {
            $_tempBody = $new_account_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\NewAccountSummary',
                '/v2.1/accounts'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\NewAccountSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\NewAccountSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createAccountSignatures
     *
     * Adds/updates one or more account signatures. This request may include images in multi-part format.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSignaturesInformation $account_signatures_information  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreateAccountSignaturesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignaturesInformation
     */
    public function createAccountSignatures($account_id, $account_signatures_information = null, \DocuSign\eSign\Api\AccountsApi\CreateAccountSignaturesOptions $options = null)
    {
        list($response) = $this->createAccountSignaturesWithHttpInfo($account_id, $account_signatures_information, $options);
        return $response;
    }

    /**
     * Operation createAccountSignaturesWithHttpInfo
     *
     * Adds/updates one or more account signatures. This request may include images in multi-part format.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSignaturesInformation $account_signatures_information  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreateAccountSignaturesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignaturesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAccountSignaturesWithHttpInfo($account_id, $account_signatures_information = null, \DocuSign\eSign\Api\AccountsApi\CreateAccountSignaturesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createAccountSignatures');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getDecodeOnly() != 'null') {
                $queryParams['decode_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getDecodeOnly());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($account_signatures_information)) {
            $_tempBody = $account_signatures_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignaturesInformation',
                '/v2.1/accounts/{accountId}/signatures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignaturesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignaturesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createBrand
     *
     * Creates one or more brand profile files for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID GUID.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function createBrand($account_id, $brand = null)
    {
        list($response) = $this->createBrandWithHttpInfo($account_id, $brand);
        return $response;
    }

    /**
     * Operation createBrandWithHttpInfo
     *
     * Creates one or more brand profile files for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID GUID.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandWithHttpInfo($account_id, $brand = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createBrand');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($brand)) {
            $_tempBody = $brand;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2.1/accounts/{accountId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createCustomField
     *
     * Creates an acount custom field.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\CustomField $custom_field  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreateCustomFieldOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function createCustomField($account_id, $custom_field = null, \DocuSign\eSign\Api\AccountsApi\CreateCustomFieldOptions $options = null)
    {
        list($response) = $this->createCustomFieldWithHttpInfo($account_id, $custom_field, $options);
        return $response;
    }

    /**
     * Operation createCustomFieldWithHttpInfo
     *
     * Creates an acount custom field.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\CustomField $custom_field  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreateCustomFieldOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomFieldWithHttpInfo($account_id, $custom_field = null, \DocuSign\eSign\Api\AccountsApi\CreateCustomFieldOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createCustomField');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getApplyToTemplates() != 'null') {
                $queryParams['apply_to_templates'] = $this->apiClient->getSerializer()->toQueryValue($options->getApplyToTemplates());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($custom_field)) {
            $_tempBody = $custom_field;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createPermissionProfile
     *
     * Creates a new permission profile in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreatePermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfile
     */
    public function createPermissionProfile($account_id, $permission_profile = null, \DocuSign\eSign\Api\AccountsApi\CreatePermissionProfileOptions $options = null)
    {
        list($response) = $this->createPermissionProfileWithHttpInfo($account_id, $permission_profile, $options);
        return $response;
    }

    /**
     * Operation createPermissionProfileWithHttpInfo
     *
     * Creates a new permission profile in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\CreatePermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfile, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPermissionProfileWithHttpInfo($account_id, $permission_profile = null, \DocuSign\eSign\Api\AccountsApi\CreatePermissionProfileOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createPermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/permission_profiles";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($permission_profile)) {
            $_tempBody = $permission_profile;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfile',
                '/v2.1/accounts/{accountId}/permission_profiles'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfile', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createUserAuthorization
     *
     * Creates the user authorization
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationCreateRequest $user_authorization_create_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserAuthorization
     */
    public function createUserAuthorization($account_id, $user_id, $user_authorization_create_request = null)
    {
        list($response) = $this->createUserAuthorizationWithHttpInfo($account_id, $user_id, $user_authorization_create_request);
        return $response;
    }

    /**
     * Operation createUserAuthorizationWithHttpInfo
     *
     * Creates the user authorization
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationCreateRequest $user_authorization_create_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserAuthorization, HTTP status code, HTTP response headers (array of strings)
     */
    public function createUserAuthorizationWithHttpInfo($account_id, $user_id, $user_authorization_create_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createUserAuthorization');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling createUserAuthorization');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorization";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_authorization_create_request)) {
            $_tempBody = $user_authorization_create_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserAuthorization',
                '/v2.1/accounts/{accountId}/users/{userId}/authorization'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserAuthorization', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserAuthorization', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createUserAuthorizations
     *
     * Creates ot updates user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationsRequest $user_authorizations_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserAuthorizationsResponse
     */
    public function createUserAuthorizations($account_id, $user_id, $user_authorizations_request = null)
    {
        list($response) = $this->createUserAuthorizationsWithHttpInfo($account_id, $user_id, $user_authorizations_request);
        return $response;
    }

    /**
     * Operation createUserAuthorizationsWithHttpInfo
     *
     * Creates ot updates user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationsRequest $user_authorizations_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserAuthorizationsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createUserAuthorizationsWithHttpInfo($account_id, $user_id, $user_authorizations_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createUserAuthorizations');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling createUserAuthorizations');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorizations";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_authorizations_request)) {
            $_tempBody = $user_authorizations_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserAuthorizationsResponse',
                '/v2.1/accounts/{accountId}/users/{userId}/authorizations'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserAuthorizationsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserAuthorizationsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation delete
     *
     * Deletes the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\DeleteOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function delete($account_id, \DocuSign\eSign\Api\AccountsApi\DeleteOptions $options = null)
    {
        list($response) = $this->deleteWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation deleteWithHttpInfo
     *
     * Deletes the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\DeleteOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\DeleteOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling delete');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getRedactUserData() != 'null') {
                $queryParams['redact_user_data'] = $this->apiClient->getSerializer()->toQueryValue($options->getRedactUserData());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteAccountSignature
     *
     * Close the specified signature by Id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteAccountSignature($account_id, $signature_id)
    {
        list($response) = $this->deleteAccountSignatureWithHttpInfo($account_id, $signature_id);
        return $response;
    }

    /**
     * Operation deleteAccountSignatureWithHttpInfo
     *
     * Close the specified signature by Id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAccountSignatureWithHttpInfo($account_id, $signature_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteAccountSignature');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling deleteAccountSignature');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures/{signatureId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/signatures/{signatureId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteAccountSignatureImage
     *
     * Deletes a signature, initials, or stamps image.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignature
     */
    public function deleteAccountSignatureImage($account_id, $image_type, $signature_id)
    {
        list($response) = $this->deleteAccountSignatureImageWithHttpInfo($account_id, $image_type, $signature_id);
        return $response;
    }

    /**
     * Operation deleteAccountSignatureImageWithHttpInfo
     *
     * Deletes a signature, initials, or stamps image.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAccountSignatureImageWithHttpInfo($account_id, $image_type, $signature_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteAccountSignatureImage');
        }
        // verify the required parameter 'image_type' is set
        if ($image_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image_type when calling deleteAccountSignatureImage');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling deleteAccountSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures/{signatureId}/{imageType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($image_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "imageType", $image_type);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignature',
                '/v2.1/accounts/{accountId}/signatures/{signatureId}/{imageType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrand
     *
     * Removes a brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteBrand($account_id, $brand_id)
    {
        list($response) = $this->deleteBrandWithHttpInfo($account_id, $brand_id);
        return $response;
    }

    /**
     * Operation deleteBrandWithHttpInfo
     *
     * Removes a brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandWithHttpInfo($account_id, $brand_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrand');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling deleteBrand');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/brands/{brandId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrandLogoByType
     *
     * Delete one branding logo.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param ?string $logo_type One of **Primary**, **Secondary** or **Email**.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteBrandLogoByType($account_id, $brand_id, $logo_type)
    {
        list($response) = $this->deleteBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type);
        return $response;
    }

    /**
     * Operation deleteBrandLogoByTypeWithHttpInfo
     *
     * Delete one branding logo.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param ?string $logo_type One of **Primary**, **Secondary** or **Email**.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrandLogoByType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling deleteBrandLogoByType');
        }
        // verify the required parameter 'logo_type' is set
        if ($logo_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $logo_type when calling deleteBrandLogoByType');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}/logos/{logoType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }
        // path params
        if ($logo_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "logoType", $logo_type);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/brands/{brandId}/logos/{logoType}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrands
     *
     * Deletes one or more brand profiles.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function deleteBrands($account_id, $brands_request = null)
    {
        list($response) = $this->deleteBrandsWithHttpInfo($account_id, $brands_request);
        return $response;
    }

    /**
     * Operation deleteBrandsWithHttpInfo
     *
     * Deletes one or more brand profiles.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandsWithHttpInfo($account_id, $brands_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrands');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($brands_request)) {
            $_tempBody = $brands_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2.1/accounts/{accountId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCaptiveRecipient
     *
     * Deletes the signature for one or more captive recipient records.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_part 
     * @param \DocuSign\eSign\Model\CaptiveRecipientInformation $captive_recipient_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CaptiveRecipientInformation
     */
    public function deleteCaptiveRecipient($account_id, $recipient_part, $captive_recipient_information = null)
    {
        list($response) = $this->deleteCaptiveRecipientWithHttpInfo($account_id, $recipient_part, $captive_recipient_information);
        return $response;
    }

    /**
     * Operation deleteCaptiveRecipientWithHttpInfo
     *
     * Deletes the signature for one or more captive recipient records.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_part 
     * @param \DocuSign\eSign\Model\CaptiveRecipientInformation $captive_recipient_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CaptiveRecipientInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCaptiveRecipientWithHttpInfo($account_id, $recipient_part, $captive_recipient_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCaptiveRecipient');
        }
        // verify the required parameter 'recipient_part' is set
        if ($recipient_part === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_part when calling deleteCaptiveRecipient');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/captive_recipients/{recipientPart}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_part !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientPart", $recipient_part);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($captive_recipient_information)) {
            $_tempBody = $captive_recipient_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CaptiveRecipientInformation',
                '/v2.1/accounts/{accountId}/captive_recipients/{recipientPart}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CaptiveRecipientInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CaptiveRecipientInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCustomField
     *
     * Delete an existing account custom field.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $custom_field_id 
     * @param  \DocuSign\eSign\Api\AccountsApi\DeleteCustomFieldOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteCustomField($account_id, $custom_field_id, \DocuSign\eSign\Api\AccountsApi\DeleteCustomFieldOptions $options = null)
    {
        list($response) = $this->deleteCustomFieldWithHttpInfo($account_id, $custom_field_id, $options);
        return $response;
    }

    /**
     * Operation deleteCustomFieldWithHttpInfo
     *
     * Delete an existing account custom field.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $custom_field_id 
     * @param  \DocuSign\eSign\Api\AccountsApi\DeleteCustomFieldOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomFieldWithHttpInfo($account_id, $custom_field_id, \DocuSign\eSign\Api\AccountsApi\DeleteCustomFieldOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCustomField');
        }
        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field_id when calling deleteCustomField');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/custom_fields/{customFieldId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getApplyToTemplates() != 'null') {
                $queryParams['apply_to_templates'] = $this->apiClient->getSerializer()->toQueryValue($options->getApplyToTemplates());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($custom_field_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "customFieldId", $custom_field_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/custom_fields/{customFieldId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteENoteConfiguration
     *
     * Deletes configuration information for the eNote eOriginal integration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteENoteConfiguration($account_id)
    {
        list($response) = $this->deleteENoteConfigurationWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation deleteENoteConfigurationWithHttpInfo
     *
     * Deletes configuration information for the eNote eOriginal integration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteENoteConfigurationWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteENoteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/enote_configuration";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/settings/enote_configuration'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deletePermissionProfile
     *
     * Deletes a permissions profile within the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $permission_profile_id 
     * @param  \DocuSign\eSign\Api\AccountsApi\DeletePermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deletePermissionProfile($account_id, $permission_profile_id, \DocuSign\eSign\Api\AccountsApi\DeletePermissionProfileOptions $options = null)
    {
        list($response) = $this->deletePermissionProfileWithHttpInfo($account_id, $permission_profile_id, $options);
        return $response;
    }

    /**
     * Operation deletePermissionProfileWithHttpInfo
     *
     * Deletes a permissions profile within the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $permission_profile_id 
     * @param  \DocuSign\eSign\Api\AccountsApi\DeletePermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePermissionProfileWithHttpInfo($account_id, $permission_profile_id, \DocuSign\eSign\Api\AccountsApi\DeletePermissionProfileOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deletePermissionProfile');
        }
        // verify the required parameter 'permission_profile_id' is set
        if ($permission_profile_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $permission_profile_id when calling deletePermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/permission_profiles/{permissionProfileId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getMoveUsersTo() != 'null') {
                $queryParams['move_users_to'] = $this->apiClient->getSerializer()->toQueryValue($options->getMoveUsersTo());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($permission_profile_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "permissionProfileId", $permission_profile_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/permission_profiles/{permissionProfileId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteUserAuthorization
     *
     * Deletes the user authorization
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $authorization_id 
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteUserAuthorization($account_id, $authorization_id, $user_id)
    {
        list($response) = $this->deleteUserAuthorizationWithHttpInfo($account_id, $authorization_id, $user_id);
        return $response;
    }

    /**
     * Operation deleteUserAuthorizationWithHttpInfo
     *
     * Deletes the user authorization
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $authorization_id 
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUserAuthorizationWithHttpInfo($account_id, $authorization_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteUserAuthorization');
        }
        // verify the required parameter 'authorization_id' is set
        if ($authorization_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $authorization_id when calling deleteUserAuthorization');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteUserAuthorization');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorization/{authorizationId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($authorization_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "authorizationId", $authorization_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/users/{userId}/authorization/{authorizationId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteUserAuthorizations
     *
     * Creates ot updates user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationsDeleteRequest $user_authorizations_delete_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserAuthorizationsDeleteResponse
     */
    public function deleteUserAuthorizations($account_id, $user_id, $user_authorizations_delete_request = null)
    {
        list($response) = $this->deleteUserAuthorizationsWithHttpInfo($account_id, $user_id, $user_authorizations_delete_request);
        return $response;
    }

    /**
     * Operation deleteUserAuthorizationsWithHttpInfo
     *
     * Creates ot updates user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationsDeleteRequest $user_authorizations_delete_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserAuthorizationsDeleteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUserAuthorizationsWithHttpInfo($account_id, $user_id, $user_authorizations_delete_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteUserAuthorizations');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteUserAuthorizations');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorizations";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_authorizations_delete_request)) {
            $_tempBody = $user_authorizations_delete_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserAuthorizationsDeleteResponse',
                '/v2.1/accounts/{accountId}/users/{userId}/authorizations'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserAuthorizationsDeleteResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserAuthorizationsDeleteResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountIdentityVerification
     *
     * Get the list of identity verification options for an account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountIdentityVerificationOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountIdentityVerificationResponse
     */
    public function getAccountIdentityVerification($account_id, \DocuSign\eSign\Api\AccountsApi\GetAccountIdentityVerificationOptions $options = null)
    {
        list($response) = $this->getAccountIdentityVerificationWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getAccountIdentityVerificationWithHttpInfo
     *
     * Get the list of identity verification options for an account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountIdentityVerificationOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountIdentityVerificationResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountIdentityVerificationWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\GetAccountIdentityVerificationOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountIdentityVerification');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/identity_verification";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIdentityVerificationWorkflowStatus() != 'null') {
                $queryParams['identity_verification_workflow_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getIdentityVerificationWorkflowStatus());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountIdentityVerificationResponse',
                '/v2.1/accounts/{accountId}/identity_verification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountIdentityVerificationResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountIdentityVerificationResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountInformation
     *
     * Retrieves the account information for the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountInformationOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountInformation
     */
    public function getAccountInformation($account_id, \DocuSign\eSign\Api\AccountsApi\GetAccountInformationOptions $options = null)
    {
        list($response) = $this->getAccountInformationWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getAccountInformationWithHttpInfo
     *
     * Retrieves the account information for the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountInformationOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountInformationWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\GetAccountInformationOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountInformation');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeAccountSettings() != 'null') {
                $queryParams['include_account_settings'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAccountSettings());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountInformation',
                '/v2.1/accounts/{accountId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountSignature
     *
     * Returns information about a single signature by specifed signatureId.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignature
     */
    public function getAccountSignature($account_id, $signature_id)
    {
        list($response) = $this->getAccountSignatureWithHttpInfo($account_id, $signature_id);
        return $response;
    }

    /**
     * Operation getAccountSignatureWithHttpInfo
     *
     * Returns information about a single signature by specifed signatureId.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountSignatureWithHttpInfo($account_id, $signature_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountSignature');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling getAccountSignature');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures/{signatureId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignature',
                '/v2.1/accounts/{accountId}/signatures/{signatureId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountSignatureImage
     *
     * Returns a signature, initials, or stamps image.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getAccountSignatureImage($account_id, $image_type, $signature_id, \DocuSign\eSign\Api\AccountsApi\GetAccountSignatureImageOptions $options = null)
    {
        list($response) = $this->getAccountSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $options);
        return $response;
    }

    /**
     * Operation getAccountSignatureImageWithHttpInfo
     *
     * Returns a signature, initials, or stamps image.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, \DocuSign\eSign\Api\AccountsApi\GetAccountSignatureImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountSignatureImage');
        }
        // verify the required parameter 'image_type' is set
        if ($image_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image_type when calling getAccountSignatureImage');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling getAccountSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures/{signatureId}/{imageType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/gif']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeChrome() != 'null') {
                $queryParams['include_chrome'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeChrome());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($image_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "imageType", $image_type);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/signatures/{signatureId}/{imageType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountSignatures
     *
     * Returns the managed signature definitions for the account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountSignaturesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignaturesInformation
     */
    public function getAccountSignatures($account_id, \DocuSign\eSign\Api\AccountsApi\GetAccountSignaturesOptions $options = null)
    {
        list($response) = $this->getAccountSignaturesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getAccountSignaturesWithHttpInfo
     *
     * Returns the managed signature definitions for the account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAccountSignaturesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignaturesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountSignaturesWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\GetAccountSignaturesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountSignatures');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getStampFormat() != 'null') {
                $queryParams['stamp_format'] = $this->apiClient->getSerializer()->toQueryValue($options->getStampFormat());
            }
            if ($options->getStampName() != 'null') {
                $queryParams['stamp_name'] = $this->apiClient->getSerializer()->toQueryValue($options->getStampName());
            }
            if ($options->getStampType() != 'null') {
                $queryParams['stamp_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getStampType());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignaturesInformation',
                '/v2.1/accounts/{accountId}/signatures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignaturesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignaturesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountTabSettings
     *
     * Returns tab settings list for specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TabAccountSettings
     */
    public function getAccountTabSettings($account_id)
    {
        list($response) = $this->getAccountTabSettingsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getAccountTabSettingsWithHttpInfo
     *
     * Returns tab settings list for specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TabAccountSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountTabSettingsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountTabSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TabAccountSettings',
                '/v2.1/accounts/{accountId}/settings/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TabAccountSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TabAccountSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAgentUserAuthorizations
     *
     * Returns the agent user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAgentUserAuthorizationsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserAuthorizations
     */
    public function getAgentUserAuthorizations($account_id, $user_id, \DocuSign\eSign\Api\AccountsApi\GetAgentUserAuthorizationsOptions $options = null)
    {
        list($response) = $this->getAgentUserAuthorizationsWithHttpInfo($account_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation getAgentUserAuthorizationsWithHttpInfo
     *
     * Returns the agent user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetAgentUserAuthorizationsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserAuthorizations, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAgentUserAuthorizationsWithHttpInfo($account_id, $user_id, \DocuSign\eSign\Api\AccountsApi\GetAgentUserAuthorizationsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAgentUserAuthorizations');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getAgentUserAuthorizations');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorizations/agent";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getActiveOnly() != 'null') {
                $queryParams['active_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getActiveOnly());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getEmailSubstring() != 'null') {
                $queryParams['email_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmailSubstring());
            }
            if ($options->getIncludeClosedUsers() != 'null') {
                $queryParams['include_closed_users'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeClosedUsers());
            }
            if ($options->getPermissions() != 'null') {
                $queryParams['permissions'] = $this->apiClient->getSerializer()->toQueryValue($options->getPermissions());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getUserNameSubstring() != 'null') {
                $queryParams['user_name_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserNameSubstring());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserAuthorizations',
                '/v2.1/accounts/{accountId}/users/{userId}/authorizations/agent'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserAuthorizations', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserAuthorizations', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAllPaymentGatewayAccounts
     *
     * Get all payment gateway account for the provided accountId
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PaymentGatewayAccountsInfo
     */
    public function getAllPaymentGatewayAccounts($account_id)
    {
        list($response) = $this->getAllPaymentGatewayAccountsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getAllPaymentGatewayAccountsWithHttpInfo
     *
     * Get all payment gateway account for the provided accountId
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PaymentGatewayAccountsInfo, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllPaymentGatewayAccountsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAllPaymentGatewayAccounts');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/payment_gateway_accounts";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PaymentGatewayAccountsInfo',
                '/v2.1/accounts/{accountId}/payment_gateway_accounts'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PaymentGatewayAccountsInfo', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PaymentGatewayAccountsInfo', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBillingCharges
     *
     * Gets list of recurring and usage charges for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetBillingChargesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingChargeResponse
     */
    public function getBillingCharges($account_id, \DocuSign\eSign\Api\AccountsApi\GetBillingChargesOptions $options = null)
    {
        list($response) = $this->getBillingChargesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getBillingChargesWithHttpInfo
     *
     * Gets list of recurring and usage charges for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetBillingChargesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingChargeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBillingChargesWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\GetBillingChargesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBillingCharges');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/billing_charges";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeCharges() != 'null') {
                $queryParams['include_charges'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeCharges());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingChargeResponse',
                '/v2.1/accounts/{accountId}/billing_charges'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingChargeResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingChargeResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrand
     *
     * Get information for a specific brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetBrandOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Brand
     */
    public function getBrand($account_id, $brand_id, \DocuSign\eSign\Api\AccountsApi\GetBrandOptions $options = null)
    {
        list($response) = $this->getBrandWithHttpInfo($account_id, $brand_id, $options);
        return $response;
    }

    /**
     * Operation getBrandWithHttpInfo
     *
     * Get information for a specific brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetBrandOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Brand, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandWithHttpInfo($account_id, $brand_id, \DocuSign\eSign\Api\AccountsApi\GetBrandOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrand');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrand');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeExternalReferences() != 'null') {
                $queryParams['include_external_references'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeExternalReferences());
            }
            if ($options->getIncludeLogos() != 'null') {
                $queryParams['include_logos'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeLogos());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Brand',
                '/v2.1/accounts/{accountId}/brands/{brandId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Brand', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Brand', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrandExportFile
     *
     * Export a specific brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function getBrandExportFile($account_id, $brand_id)
    {
        list($response) = $this->getBrandExportFileWithHttpInfo($account_id, $brand_id);
        return $response;
    }

    /**
     * Operation getBrandExportFileWithHttpInfo
     *
     * Export a specific brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandExportFileWithHttpInfo($account_id, $brand_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrandExportFile');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandExportFile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}/file";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/brands/{brandId}/file'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrandLogoByType
     *
     * Obtains the specified image for a brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param ?string $logo_type One of **Primary**, **Secondary** or **Email**.
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getBrandLogoByType($account_id, $brand_id, $logo_type)
    {
        list($response) = $this->getBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type);
        return $response;
    }

    /**
     * Operation getBrandLogoByTypeWithHttpInfo
     *
     * Obtains the specified image for a brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param ?string $logo_type One of **Primary**, **Secondary** or **Email**.
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrandLogoByType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandLogoByType');
        }
        // verify the required parameter 'logo_type' is set
        if ($logo_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $logo_type when calling getBrandLogoByType');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}/logos/{logoType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/png']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }
        // path params
        if ($logo_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "logoType", $logo_type);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/brands/{brandId}/logos/{logoType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrandResources
     *
     * Returns the specified account's list of branding resources (metadata).
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandResourcesList
     */
    public function getBrandResources($account_id, $brand_id)
    {
        list($response) = $this->getBrandResourcesWithHttpInfo($account_id, $brand_id);
        return $response;
    }

    /**
     * Operation getBrandResourcesWithHttpInfo
     *
     * Returns the specified account's list of branding resources (metadata).
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandResourcesList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandResourcesWithHttpInfo($account_id, $brand_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrandResources');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandResources');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}/resources";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandResourcesList',
                '/v2.1/accounts/{accountId}/brands/{brandId}/resources'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandResourcesList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandResourcesList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrandResourcesByContentType
     *
     * Returns the specified branding resource file.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param ?string $resource_content_type 
     * @param  \DocuSign\eSign\Api\AccountsApi\GetBrandResourcesByContentTypeOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function getBrandResourcesByContentType($account_id, $brand_id, $resource_content_type, \DocuSign\eSign\Api\AccountsApi\GetBrandResourcesByContentTypeOptions $options = null)
    {
        list($response) = $this->getBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type, $options);
        return $response;
    }

    /**
     * Operation getBrandResourcesByContentTypeWithHttpInfo
     *
     * Returns the specified branding resource file.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param ?string $resource_content_type 
     * @param  \DocuSign\eSign\Api\AccountsApi\GetBrandResourcesByContentTypeOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type, \DocuSign\eSign\Api\AccountsApi\GetBrandResourcesByContentTypeOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrandResourcesByContentType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandResourcesByContentType');
        }
        // verify the required parameter 'resource_content_type' is set
        if ($resource_content_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $resource_content_type when calling getBrandResourcesByContentType');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getLangcode() != 'null') {
                $queryParams['langcode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangcode());
            }
            if ($options->getReturnMaster() != 'null') {
                $queryParams['return_master'] = $this->apiClient->getSerializer()->toQueryValue($options->getReturnMaster());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }
        // path params
        if ($resource_content_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "resourceContentType", $resource_content_type);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosure
     *
     * Gets the Electronic Record and Signature Disclosure.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosure($account_id, $lang_code)
    {
        list($response) = $this->getConsumerDisclosureWithHttpInfo($account_id, $lang_code);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureWithHttpInfo
     *
     * Gets the Electronic Record and Signature Disclosure.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureWithHttpInfo($account_id, $lang_code): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosure');
        }
        // verify the required parameter 'lang_code' is set
        if ($lang_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lang_code when calling getConsumerDisclosure');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/consumer_disclosure/{langCode}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($lang_code !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "langCode", $lang_code);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2.1/accounts/{accountId}/consumer_disclosure/{langCode}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosureDefault
     *
     * Gets the Electronic Record and Signature Disclosure for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetConsumerDisclosureDefaultOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosureDefault($account_id, \DocuSign\eSign\Api\AccountsApi\GetConsumerDisclosureDefaultOptions $options = null)
    {
        list($response) = $this->getConsumerDisclosureDefaultWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureDefaultWithHttpInfo
     *
     * Gets the Electronic Record and Signature Disclosure for the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetConsumerDisclosureDefaultOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureDefaultWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\GetConsumerDisclosureDefaultOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosureDefault');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/consumer_disclosure";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getLangCode() != 'null') {
                $queryParams['langCode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangCode());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2.1/accounts/{accountId}/consumer_disclosure'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getENoteConfiguration
     *
     * Returns the configuration information for the eNote eOriginal integration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ENoteConfiguration
     */
    public function getENoteConfiguration($account_id)
    {
        list($response) = $this->getENoteConfigurationWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getENoteConfigurationWithHttpInfo
     *
     * Returns the configuration information for the eNote eOriginal integration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ENoteConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function getENoteConfigurationWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getENoteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/enote_configuration";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ENoteConfiguration',
                '/v2.1/accounts/{accountId}/settings/enote_configuration'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ENoteConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ENoteConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopePurgeConfiguration
     *
     * Select envelope purge configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopePurgeConfiguration
     */
    public function getEnvelopePurgeConfiguration($account_id)
    {
        list($response) = $this->getEnvelopePurgeConfigurationWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getEnvelopePurgeConfigurationWithHttpInfo
     *
     * Select envelope purge configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopePurgeConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopePurgeConfigurationWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopePurgeConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/envelope_purge_configuration";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopePurgeConfiguration',
                '/v2.1/accounts/{accountId}/settings/envelope_purge_configuration'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopePurgeConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopePurgeConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFavoriteTemplates
     *
     * Retrieves the list of favorited templates for this caller
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\FavoriteTemplatesInfo
     */
    public function getFavoriteTemplates($account_id)
    {
        list($response) = $this->getFavoriteTemplatesWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getFavoriteTemplatesWithHttpInfo
     *
     * Retrieves the list of favorited templates for this caller
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\FavoriteTemplatesInfo, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFavoriteTemplatesWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getFavoriteTemplates');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/favorite_templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\FavoriteTemplatesInfo',
                '/v2.1/accounts/{accountId}/favorite_templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\FavoriteTemplatesInfo', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\FavoriteTemplatesInfo', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNotificationDefaults
     *
     * Returns default user level settings for a specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\NotificationDefaults
     */
    public function getNotificationDefaults($account_id)
    {
        list($response) = $this->getNotificationDefaultsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getNotificationDefaultsWithHttpInfo
     *
     * Returns default user level settings for a specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\NotificationDefaults, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationDefaultsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getNotificationDefaults');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/notification_defaults";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\NotificationDefaults',
                '/v2.1/accounts/{accountId}/settings/notification_defaults'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\NotificationDefaults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\NotificationDefaults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPasswordRules
     *
     * Get the password rules
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountPasswordRules
     */
    public function getPasswordRules($account_id)
    {
        list($response) = $this->getPasswordRulesWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getPasswordRulesWithHttpInfo
     *
     * Get the password rules
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountPasswordRules, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPasswordRulesWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPasswordRules');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/password_rules";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountPasswordRules',
                '/v2.1/accounts/{accountId}/settings/password_rules'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountPasswordRules', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountPasswordRules', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPasswordRules_0
     *
     * Get membership account password rules
     *
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserPasswordRules
     */
    public function getPasswordRules_0()
    {
        list($response) = $this->getPasswordRules_0WithHttpInfo();
        return $response;
    }

    /**
     * Operation getPasswordRules_0WithHttpInfo
     *
     * Get membership account password rules
     *
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserPasswordRules, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPasswordRules_0WithHttpInfo(): array
    {
        // parse inputs
        $resourcePath = "/v2.1/current_user/password_rules";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);



        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserPasswordRules',
                '/v2.1/current_user/password_rules'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserPasswordRules', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserPasswordRules', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPermissionProfile
     *
     * Returns a permissions profile in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $permission_profile_id 
     * @param  \DocuSign\eSign\Api\AccountsApi\GetPermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfile
     */
    public function getPermissionProfile($account_id, $permission_profile_id, \DocuSign\eSign\Api\AccountsApi\GetPermissionProfileOptions $options = null)
    {
        list($response) = $this->getPermissionProfileWithHttpInfo($account_id, $permission_profile_id, $options);
        return $response;
    }

    /**
     * Operation getPermissionProfileWithHttpInfo
     *
     * Returns a permissions profile in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $permission_profile_id 
     * @param  \DocuSign\eSign\Api\AccountsApi\GetPermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfile, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPermissionProfileWithHttpInfo($account_id, $permission_profile_id, \DocuSign\eSign\Api\AccountsApi\GetPermissionProfileOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPermissionProfile');
        }
        // verify the required parameter 'permission_profile_id' is set
        if ($permission_profile_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $permission_profile_id when calling getPermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/permission_profiles/{permissionProfileId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($permission_profile_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "permissionProfileId", $permission_profile_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfile',
                '/v2.1/accounts/{accountId}/permission_profiles/{permissionProfileId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfile', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPrincipalUserAuthorizations
     *
     * Returns the principal user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetPrincipalUserAuthorizationsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserAuthorizations
     */
    public function getPrincipalUserAuthorizations($account_id, $user_id, \DocuSign\eSign\Api\AccountsApi\GetPrincipalUserAuthorizationsOptions $options = null)
    {
        list($response) = $this->getPrincipalUserAuthorizationsWithHttpInfo($account_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation getPrincipalUserAuthorizationsWithHttpInfo
     *
     * Returns the principal user authorizations
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\AccountsApi\GetPrincipalUserAuthorizationsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserAuthorizations, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPrincipalUserAuthorizationsWithHttpInfo($account_id, $user_id, \DocuSign\eSign\Api\AccountsApi\GetPrincipalUserAuthorizationsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPrincipalUserAuthorizations');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getPrincipalUserAuthorizations');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorizations";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getActiveOnly() != 'null') {
                $queryParams['active_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getActiveOnly());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getEmailSubstring() != 'null') {
                $queryParams['email_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmailSubstring());
            }
            if ($options->getIncludeClosedUsers() != 'null') {
                $queryParams['include_closed_users'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeClosedUsers());
            }
            if ($options->getPermissions() != 'null') {
                $queryParams['permissions'] = $this->apiClient->getSerializer()->toQueryValue($options->getPermissions());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getUserNameSubstring() != 'null') {
                $queryParams['user_name_substring'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserNameSubstring());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserAuthorizations',
                '/v2.1/accounts/{accountId}/users/{userId}/authorizations'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserAuthorizations', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserAuthorizations', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProvisioning
     *
     * Retrieves the account provisioning information for the account.
     *
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ProvisioningInformation
     */
    public function getProvisioning()
    {
        list($response) = $this->getProvisioningWithHttpInfo();
        return $response;
    }

    /**
     * Operation getProvisioningWithHttpInfo
     *
     * Retrieves the account provisioning information for the account.
     *
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ProvisioningInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProvisioningWithHttpInfo(): array
    {
        // parse inputs
        $resourcePath = "/v2.1/accounts/provisioning";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);



        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ProvisioningInformation',
                '/v2.1/accounts/provisioning'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ProvisioningInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ProvisioningInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getSupportedLanguages
     *
     * Gets list of supported languages for recipient language setting.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\SupportedLanguages
     */
    public function getSupportedLanguages($account_id)
    {
        list($response) = $this->getSupportedLanguagesWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getSupportedLanguagesWithHttpInfo
     *
     * Gets list of supported languages for recipient language setting.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\SupportedLanguages, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSupportedLanguagesWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getSupportedLanguages');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/supported_languages";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\SupportedLanguages',
                '/v2.1/accounts/{accountId}/supported_languages'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\SupportedLanguages', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\SupportedLanguages', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getUserAuthorization
     *
     * Returns the user authorization for a given authorization id
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $authorization_id 
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserAuthorization
     */
    public function getUserAuthorization($account_id, $authorization_id, $user_id)
    {
        list($response) = $this->getUserAuthorizationWithHttpInfo($account_id, $authorization_id, $user_id);
        return $response;
    }

    /**
     * Operation getUserAuthorizationWithHttpInfo
     *
     * Returns the user authorization for a given authorization id
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $authorization_id 
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserAuthorization, HTTP status code, HTTP response headers (array of strings)
     */
    public function getUserAuthorizationWithHttpInfo($account_id, $authorization_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getUserAuthorization');
        }
        // verify the required parameter 'authorization_id' is set
        if ($authorization_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $authorization_id when calling getUserAuthorization');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getUserAuthorization');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorization/{authorizationId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($authorization_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "authorizationId", $authorization_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserAuthorization',
                '/v2.1/accounts/{accountId}/users/{userId}/authorization/{authorizationId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserAuthorization', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserAuthorization', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWatermark
     *
     * Get watermark information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Watermark
     */
    public function getWatermark($account_id)
    {
        list($response) = $this->getWatermarkWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getWatermarkWithHttpInfo
     *
     * Get watermark information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Watermark, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWatermarkWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getWatermark');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/watermark";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Watermark',
                '/v2.1/accounts/{accountId}/watermark'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Watermark', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Watermark', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWatermarkPreview
     *
     * Get watermark preview.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Watermark $watermark  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Watermark
     */
    public function getWatermarkPreview($account_id, $watermark = null)
    {
        list($response) = $this->getWatermarkPreviewWithHttpInfo($account_id, $watermark);
        return $response;
    }

    /**
     * Operation getWatermarkPreviewWithHttpInfo
     *
     * Get watermark preview.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Watermark $watermark  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Watermark, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWatermarkPreviewWithHttpInfo($account_id, $watermark = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getWatermarkPreview');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/watermark/preview";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($watermark)) {
            $_tempBody = $watermark;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Watermark',
                '/v2.1/accounts/{accountId}/watermark/preview'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Watermark', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Watermark', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listBrands
     *
     * Gets a list of brand profiles.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListBrandsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function listBrands($account_id, \DocuSign\eSign\Api\AccountsApi\ListBrandsOptions $options = null)
    {
        list($response) = $this->listBrandsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listBrandsWithHttpInfo
     *
     * Gets a list of brand profiles.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListBrandsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listBrandsWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\ListBrandsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listBrands');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getExcludeDistributorBrand() != 'null') {
                $queryParams['exclude_distributor_brand'] = $this->apiClient->getSerializer()->toQueryValue($options->getExcludeDistributorBrand());
            }
            if ($options->getIncludeLogos() != 'null') {
                $queryParams['include_logos'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeLogos());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2.1/accounts/{accountId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listCustomFields
     *
     * Gets a list of custom fields associated with the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function listCustomFields($account_id)
    {
        list($response) = $this->listCustomFieldsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listCustomFieldsWithHttpInfo
     *
     * Gets a list of custom fields associated with the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomFieldsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPermissions
     *
     * Gets a list of permission profiles.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListPermissionsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfileInformation
     */
    public function listPermissions($account_id, \DocuSign\eSign\Api\AccountsApi\ListPermissionsOptions $options = null)
    {
        list($response) = $this->listPermissionsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listPermissionsWithHttpInfo
     *
     * Gets a list of permission profiles.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListPermissionsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfileInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listPermissionsWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\ListPermissionsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listPermissions');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/permission_profiles";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfileInformation',
                '/v2.1/accounts/{accountId}/permission_profiles'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfileInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfileInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listRecipientNamesByEmail
     *
     * Gets recipient names associated with an email address.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListRecipientNamesByEmailOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\RecipientNamesResponse
     */
    public function listRecipientNamesByEmail($account_id, \DocuSign\eSign\Api\AccountsApi\ListRecipientNamesByEmailOptions $options = null)
    {
        list($response) = $this->listRecipientNamesByEmailWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listRecipientNamesByEmailWithHttpInfo
     *
     * Gets recipient names associated with an email address.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListRecipientNamesByEmailOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\RecipientNamesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRecipientNamesByEmailWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\ListRecipientNamesByEmailOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listRecipientNamesByEmail');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/recipient_names";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getEmail() != 'null') {
                $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\RecipientNamesResponse',
                '/v2.1/accounts/{accountId}/recipient_names'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\RecipientNamesResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\RecipientNamesResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listSettings
     *
     * Gets account settings information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSettingsInformation
     */
    public function listSettings($account_id)
    {
        list($response) = $this->listSettingsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listSettingsWithHttpInfo
     *
     * Gets account settings information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSettingsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSettingsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSettingsInformation',
                '/v2.1/accounts/{accountId}/settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSettingsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSettingsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listSharedAccess
     *
     * Reserved: Gets the shared item status for one or more users.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListSharedAccessOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSharedAccess
     */
    public function listSharedAccess($account_id, \DocuSign\eSign\Api\AccountsApi\ListSharedAccessOptions $options = null)
    {
        list($response) = $this->listSharedAccessWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listSharedAccessWithHttpInfo
     *
     * Reserved: Gets the shared item status for one or more users.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\AccountsApi\ListSharedAccessOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSharedAccess, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSharedAccessWithHttpInfo($account_id, \DocuSign\eSign\Api\AccountsApi\ListSharedAccessOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listSharedAccess');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/shared_access";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getEnvelopesNotSharedUserStatus() != 'null') {
                $queryParams['envelopes_not_shared_user_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getEnvelopesNotSharedUserStatus());
            }
            if ($options->getFolderIds() != 'null') {
                $queryParams['folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderIds());
            }
            if ($options->getItemType() != 'null') {
                $queryParams['item_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getItemType());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getShared() != 'null') {
                $queryParams['shared'] = $this->apiClient->getSerializer()->toQueryValue($options->getShared());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getUserIds() != 'null') {
                $queryParams['user_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserIds());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSharedAccess',
                '/v2.1/accounts/{accountId}/shared_access'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSharedAccess', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSharedAccess', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listSignatureProviders
     *
     * Returns Account available signature providers for specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignatureProviders
     */
    public function listSignatureProviders($account_id)
    {
        list($response) = $this->listSignatureProvidersWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listSignatureProvidersWithHttpInfo
     *
     * Returns Account available signature providers for specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignatureProviders, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSignatureProvidersWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listSignatureProviders');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatureProviders";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignatureProviders',
                '/v2.1/accounts/{accountId}/signatureProviders'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignatureProviders', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignatureProviders', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listUnsupportedFileTypes
     *
     * Gets a list of unsupported file types.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\FileTypeList
     */
    public function listUnsupportedFileTypes($account_id)
    {
        list($response) = $this->listUnsupportedFileTypesWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listUnsupportedFileTypesWithHttpInfo
     *
     * Gets a list of unsupported file types.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\FileTypeList, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUnsupportedFileTypesWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listUnsupportedFileTypes');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/unsupported_file_types";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\FileTypeList',
                '/v2.1/accounts/{accountId}/unsupported_file_types'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\FileTypeList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\FileTypeList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation unFavoriteTemplate
     *
     * Unfavorite a template
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\FavoriteTemplatesInfo $favorite_templates_info  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\FavoriteTemplatesInfo
     */
    public function unFavoriteTemplate($account_id, $favorite_templates_info = null)
    {
        list($response) = $this->unFavoriteTemplateWithHttpInfo($account_id, $favorite_templates_info);
        return $response;
    }

    /**
     * Operation unFavoriteTemplateWithHttpInfo
     *
     * Unfavorite a template
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\FavoriteTemplatesInfo $favorite_templates_info  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\FavoriteTemplatesInfo, HTTP status code, HTTP response headers (array of strings)
     */
    public function unFavoriteTemplateWithHttpInfo($account_id, $favorite_templates_info = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling unFavoriteTemplate');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/favorite_templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($favorite_templates_info)) {
            $_tempBody = $favorite_templates_info;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\FavoriteTemplatesInfo',
                '/v2.1/accounts/{accountId}/favorite_templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\FavoriteTemplatesInfo', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\FavoriteTemplatesInfo', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateAccountSignature
     *
     * Updates a account signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSignaturesInformation $account_signatures_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignaturesInformation
     */
    public function updateAccountSignature($account_id, $account_signatures_information = null)
    {
        list($response) = $this->updateAccountSignatureWithHttpInfo($account_id, $account_signatures_information);
        return $response;
    }

    /**
     * Operation updateAccountSignatureWithHttpInfo
     *
     * Updates a account signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSignaturesInformation $account_signatures_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignaturesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAccountSignatureWithHttpInfo($account_id, $account_signatures_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateAccountSignature');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($account_signatures_information)) {
            $_tempBody = $account_signatures_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignaturesInformation',
                '/v2.1/accounts/{accountId}/signatures'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignaturesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignaturesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateAccountSignatureById
     *
     * Updates a account signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param \DocuSign\eSign\Model\AccountSignatureDefinition $account_signature_definition  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureByIdOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignature
     */
    public function updateAccountSignatureById($account_id, $signature_id, $account_signature_definition = null, \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureByIdOptions $options = null)
    {
        list($response) = $this->updateAccountSignatureByIdWithHttpInfo($account_id, $signature_id, $account_signature_definition, $options);
        return $response;
    }

    /**
     * Operation updateAccountSignatureByIdWithHttpInfo
     *
     * Updates a account signature.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param \DocuSign\eSign\Model\AccountSignatureDefinition $account_signature_definition  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureByIdOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAccountSignatureByIdWithHttpInfo($account_id, $signature_id, $account_signature_definition = null, \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureByIdOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateAccountSignatureById');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling updateAccountSignatureById');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures/{signatureId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCloseExistingSignature() != 'null') {
                $queryParams['close_existing_signature'] = $this->apiClient->getSerializer()->toQueryValue($options->getCloseExistingSignature());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($account_signature_definition)) {
            $_tempBody = $account_signature_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignature',
                '/v2.1/accounts/{accountId}/signatures/{signatureId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateAccountSignatureImage
     *
     * Sets a signature, initials, or stamps image.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignature
     */
    public function updateAccountSignatureImage($account_id, $image_type, $signature_id, \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureImageOptions $options = null)
    {
        list($response) = $this->updateAccountSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, $options);
        return $response;
    }

    /**
     * Operation updateAccountSignatureImageWithHttpInfo
     *
     * Sets a signature, initials, or stamps image.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $image_type One of **signature_image** or **initials_image**.
     * @param ?string $signature_id The ID of the signature being accessed.
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAccountSignatureImageWithHttpInfo($account_id, $image_type, $signature_id, \DocuSign\eSign\Api\AccountsApi\UpdateAccountSignatureImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateAccountSignatureImage');
        }
        // verify the required parameter 'image_type' is set
        if ($image_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $image_type when calling updateAccountSignatureImage');
        }
        // verify the required parameter 'signature_id' is set
        if ($signature_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $signature_id when calling updateAccountSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/signatures/{signatureId}/{imageType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['image/gif']);

        if ($options != null)
        {
            // query params
            if ($options->getTransparentPng() != 'null') {
                $queryParams['transparent_png'] = $this->apiClient->getSerializer()->toQueryValue($options->getTransparentPng());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($image_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "imageType", $image_type);
        }
        // path params
        if ($signature_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "signatureId", $signature_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignature',
                '/v2.1/accounts/{accountId}/signatures/{signatureId}/{imageType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateAccountTabSettings
     *
     * Modifies tab settings for specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\TabAccountSettings $tab_account_settings  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TabAccountSettings
     */
    public function updateAccountTabSettings($account_id, $tab_account_settings = null)
    {
        list($response) = $this->updateAccountTabSettingsWithHttpInfo($account_id, $tab_account_settings);
        return $response;
    }

    /**
     * Operation updateAccountTabSettingsWithHttpInfo
     *
     * Modifies tab settings for specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\TabAccountSettings $tab_account_settings  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TabAccountSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAccountTabSettingsWithHttpInfo($account_id, $tab_account_settings = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateAccountTabSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($tab_account_settings)) {
            $_tempBody = $tab_account_settings;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TabAccountSettings',
                '/v2.1/accounts/{accountId}/settings/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TabAccountSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TabAccountSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrand
     *
     * Updates an existing brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateBrandOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Brand
     */
    public function updateBrand($account_id, $brand_id, $brand = null, \DocuSign\eSign\Api\AccountsApi\UpdateBrandOptions $options = null)
    {
        list($response) = $this->updateBrandWithHttpInfo($account_id, $brand_id, $brand, $options);
        return $response;
    }

    /**
     * Operation updateBrandWithHttpInfo
     *
     * Updates an existing brand.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $brand_id The unique identifier of a brand.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateBrandOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Brand, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandWithHttpInfo($account_id, $brand_id, $brand = null, \DocuSign\eSign\Api\AccountsApi\UpdateBrandOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrand');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrand');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getReplaceBrand() != 'null') {
                $queryParams['replace_brand'] = $this->apiClient->getSerializer()->toQueryValue($options->getReplaceBrand());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($brand)) {
            $_tempBody = $brand;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Brand',
                '/v2.1/accounts/{accountId}/brands/{brandId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Brand', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Brand', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrandLogoByType
     *
     * Put one branding logo.
     *
     * @param ?string $account_id The external account number (int) or account ID GUID.
     * @param ?string $brand_id The ID of the brand.
     * @param ?string $logo_type The type of logo. Valid values are:  - &#x60;primary&#x60;  - &#x60;secondary&#x60;  - &#x60;email&#x60;
     * @param ?string $logo_file_bytes Brand logo binary Stream. Supported formats: JPG, GIF, PNG. Maximum file size: 300 KB. Recommended dimensions: 296 x 76 pixels (larger images will be resized). Changes may take up to one hour to display in all places (required)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateBrandLogoByType($account_id, $brand_id, $logo_type, $logo_file_bytes)
    {
        list($response) = $this->updateBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type, $logo_file_bytes);
        return $response;
    }

    /**
     * Operation updateBrandLogoByTypeWithHttpInfo
     *
     * Put one branding logo.
     *
     * @param ?string $account_id The external account number (int) or account ID GUID.
     * @param ?string $brand_id The ID of the brand.
     * @param ?string $logo_type The type of logo. Valid values are:  - &#x60;primary&#x60;  - &#x60;secondary&#x60;  - &#x60;email&#x60;
     * @param ?string $logo_file_bytes Brand logo binary Stream. Supported formats: JPG, GIF, PNG. Maximum file size: 300 KB. Recommended dimensions: 296 x 76 pixels (larger images will be resized). Changes may take up to one hour to display in all places (required)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type, $logo_file_bytes): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrandLogoByType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrandLogoByType');
        }
        // verify the required parameter 'logo_type' is set
        if ($logo_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $logo_type when calling updateBrandLogoByType');
        }
        // verify the required parameter 'logo_file_bytes' is set
        if ($logo_file_bytes === null) {
            throw new \InvalidArgumentException('Missing the required parameter $logo_file_bytes when calling updateBrandLogoByType');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}/logos/{logoType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['image/png']);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }
        // path params
        if ($logo_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "logoType", $logo_type);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($logo_file_bytes)) {
            $_tempBody = $logo_file_bytes;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/brands/{brandId}/logos/{logoType}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrandResourcesByContentType
     *
     * Uploads a branding resource file.
     *
     * @param ?string $account_id The external account number (int) or account ID GUID.
     * @param ?string $brand_id The ID of the brand.
     * @param ?string $resource_content_type The type of brand resource file that you are updating. Valid values are:  - &#x60;sending&#x60; - &#x60;signing&#x60; - &#x60;email&#x60; - &#x60;signing_captive&#x60;
    * @param \SplFileObject $file_xml Brand resource XML file. (required)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandResources
     */
    public function updateBrandResourcesByContentType($account_id, $brand_id, $resource_content_type, $file_xml)
    {
        list($response) = $this->updateBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type, $file_xml);
        return $response;
    }

    /**
     * Operation updateBrandResourcesByContentTypeWithHttpInfo
     *
     * Uploads a branding resource file.
     *
     * @param ?string $account_id The external account number (int) or account ID GUID.
     * @param ?string $brand_id The ID of the brand.
     * @param ?string $resource_content_type The type of brand resource file that you are updating. Valid values are:  - &#x60;sending&#x60; - &#x60;signing&#x60; - &#x60;email&#x60; - &#x60;signing_captive&#x60;
    * @param \SplFileObject $file_xml Brand resource XML file. (required)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandResources, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type, $file_xml): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrandResourcesByContentType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrandResourcesByContentType');
        }
        // verify the required parameter 'resource_content_type' is set
        if ($resource_content_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $resource_content_type when calling updateBrandResourcesByContentType');
        }
        // verify the required parameter 'file_xml' is set
        if ($file_xml === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_xml when calling updateBrandResourcesByContentType');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['multipart/form-data']);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "brandId", $brand_id);
        }
        // path params
        if ($resource_content_type !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "resourceContentType", $resource_content_type);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // form params
        if ($file_xml !== null) {
            // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
            // See: https://wiki.php.net/rfc/curl-file-upload
            if (function_exists('curl_file_create')) {
                $formParams['file.xml'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($file_xml));
            } else {
                $formParams['file.xml'] = '@' . $this->apiClient->getSerializer()->toFormValue($file_xml);
            }
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandResources',
                '/v2.1/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandResources', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandResources', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateConsumerDisclosure
     *
     * Update Consumer Disclosure.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     * @param \DocuSign\eSign\Model\ConsumerDisclosure $consumer_disclosure  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateConsumerDisclosureOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function updateConsumerDisclosure($account_id, $lang_code, $consumer_disclosure = null, \DocuSign\eSign\Api\AccountsApi\UpdateConsumerDisclosureOptions $options = null)
    {
        list($response) = $this->updateConsumerDisclosureWithHttpInfo($account_id, $lang_code, $consumer_disclosure, $options);
        return $response;
    }

    /**
     * Operation updateConsumerDisclosureWithHttpInfo
     *
     * Update Consumer Disclosure.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     * @param \DocuSign\eSign\Model\ConsumerDisclosure $consumer_disclosure  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateConsumerDisclosureOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateConsumerDisclosureWithHttpInfo($account_id, $lang_code, $consumer_disclosure = null, \DocuSign\eSign\Api\AccountsApi\UpdateConsumerDisclosureOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateConsumerDisclosure');
        }
        // verify the required parameter 'lang_code' is set
        if ($lang_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lang_code when calling updateConsumerDisclosure');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/consumer_disclosure/{langCode}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeMetadata() != 'null') {
                $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($lang_code !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "langCode", $lang_code);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($consumer_disclosure)) {
            $_tempBody = $consumer_disclosure;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2.1/accounts/{accountId}/consumer_disclosure/{langCode}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateCustomField
     *
     * Updates an existing account custom field.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $custom_field_id 
     * @param \DocuSign\eSign\Model\CustomField $custom_field  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateCustomFieldOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function updateCustomField($account_id, $custom_field_id, $custom_field = null, \DocuSign\eSign\Api\AccountsApi\UpdateCustomFieldOptions $options = null)
    {
        list($response) = $this->updateCustomFieldWithHttpInfo($account_id, $custom_field_id, $custom_field, $options);
        return $response;
    }

    /**
     * Operation updateCustomFieldWithHttpInfo
     *
     * Updates an existing account custom field.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $custom_field_id 
     * @param \DocuSign\eSign\Model\CustomField $custom_field  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateCustomFieldOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomFieldWithHttpInfo($account_id, $custom_field_id, $custom_field = null, \DocuSign\eSign\Api\AccountsApi\UpdateCustomFieldOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateCustomField');
        }
        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field_id when calling updateCustomField');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/custom_fields/{customFieldId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getApplyToTemplates() != 'null') {
                $queryParams['apply_to_templates'] = $this->apiClient->getSerializer()->toQueryValue($options->getApplyToTemplates());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($custom_field_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "customFieldId", $custom_field_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($custom_field)) {
            $_tempBody = $custom_field;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/custom_fields/{customFieldId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateENoteConfiguration
     *
     * Updates configuration information for the eNote eOriginal integration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ENoteConfiguration $e_note_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ENoteConfiguration
     */
    public function updateENoteConfiguration($account_id, $e_note_configuration = null)
    {
        list($response) = $this->updateENoteConfigurationWithHttpInfo($account_id, $e_note_configuration);
        return $response;
    }

    /**
     * Operation updateENoteConfigurationWithHttpInfo
     *
     * Updates configuration information for the eNote eOriginal integration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ENoteConfiguration $e_note_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ENoteConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateENoteConfigurationWithHttpInfo($account_id, $e_note_configuration = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateENoteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/enote_configuration";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($e_note_configuration)) {
            $_tempBody = $e_note_configuration;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ENoteConfiguration',
                '/v2.1/accounts/{accountId}/settings/enote_configuration'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ENoteConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ENoteConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopePurgeConfiguration
     *
     * Updates envelope purge configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopePurgeConfiguration $envelope_purge_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopePurgeConfiguration
     */
    public function updateEnvelopePurgeConfiguration($account_id, $envelope_purge_configuration = null)
    {
        list($response) = $this->updateEnvelopePurgeConfigurationWithHttpInfo($account_id, $envelope_purge_configuration);
        return $response;
    }

    /**
     * Operation updateEnvelopePurgeConfigurationWithHttpInfo
     *
     * Updates envelope purge configuration.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopePurgeConfiguration $envelope_purge_configuration  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopePurgeConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopePurgeConfigurationWithHttpInfo($account_id, $envelope_purge_configuration = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopePurgeConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/envelope_purge_configuration";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_purge_configuration)) {
            $_tempBody = $envelope_purge_configuration;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopePurgeConfiguration',
                '/v2.1/accounts/{accountId}/settings/envelope_purge_configuration'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopePurgeConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopePurgeConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateFavoriteTemplate
     *
     * Favorites a template
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\FavoriteTemplatesInfo $favorite_templates_info  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\FavoriteTemplatesInfo
     */
    public function updateFavoriteTemplate($account_id, $favorite_templates_info = null)
    {
        list($response) = $this->updateFavoriteTemplateWithHttpInfo($account_id, $favorite_templates_info);
        return $response;
    }

    /**
     * Operation updateFavoriteTemplateWithHttpInfo
     *
     * Favorites a template
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\FavoriteTemplatesInfo $favorite_templates_info  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\FavoriteTemplatesInfo, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateFavoriteTemplateWithHttpInfo($account_id, $favorite_templates_info = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateFavoriteTemplate');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/favorite_templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($favorite_templates_info)) {
            $_tempBody = $favorite_templates_info;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\FavoriteTemplatesInfo',
                '/v2.1/accounts/{accountId}/favorite_templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\FavoriteTemplatesInfo', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\FavoriteTemplatesInfo', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNotificationDefaults
     *
     * Updates default user level settings for a specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\NotificationDefaults $notification_defaults  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\NotificationDefaults
     */
    public function updateNotificationDefaults($account_id, $notification_defaults = null)
    {
        list($response) = $this->updateNotificationDefaultsWithHttpInfo($account_id, $notification_defaults);
        return $response;
    }

    /**
     * Operation updateNotificationDefaultsWithHttpInfo
     *
     * Updates default user level settings for a specified account
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\NotificationDefaults $notification_defaults  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\NotificationDefaults, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateNotificationDefaultsWithHttpInfo($account_id, $notification_defaults = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateNotificationDefaults');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/notification_defaults";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($notification_defaults)) {
            $_tempBody = $notification_defaults;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\NotificationDefaults',
                '/v2.1/accounts/{accountId}/settings/notification_defaults'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\NotificationDefaults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\NotificationDefaults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePasswordRules
     *
     * Update the password rules
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountPasswordRules $account_password_rules  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountPasswordRules
     */
    public function updatePasswordRules($account_id, $account_password_rules = null)
    {
        list($response) = $this->updatePasswordRulesWithHttpInfo($account_id, $account_password_rules);
        return $response;
    }

    /**
     * Operation updatePasswordRulesWithHttpInfo
     *
     * Update the password rules
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountPasswordRules $account_password_rules  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountPasswordRules, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePasswordRulesWithHttpInfo($account_id, $account_password_rules = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updatePasswordRules');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings/password_rules";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($account_password_rules)) {
            $_tempBody = $account_password_rules;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountPasswordRules',
                '/v2.1/accounts/{accountId}/settings/password_rules'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountPasswordRules', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountPasswordRules', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePermissionProfile
     *
     * Updates a permission profile within the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $permission_profile_id 
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdatePermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfile
     */
    public function updatePermissionProfile($account_id, $permission_profile_id, $permission_profile = null, \DocuSign\eSign\Api\AccountsApi\UpdatePermissionProfileOptions $options = null)
    {
        list($response) = $this->updatePermissionProfileWithHttpInfo($account_id, $permission_profile_id, $permission_profile, $options);
        return $response;
    }

    /**
     * Operation updatePermissionProfileWithHttpInfo
     *
     * Updates a permission profile within the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $permission_profile_id 
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdatePermissionProfileOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfile, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePermissionProfileWithHttpInfo($account_id, $permission_profile_id, $permission_profile = null, \DocuSign\eSign\Api\AccountsApi\UpdatePermissionProfileOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updatePermissionProfile');
        }
        // verify the required parameter 'permission_profile_id' is set
        if ($permission_profile_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $permission_profile_id when calling updatePermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/permission_profiles/{permissionProfileId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($permission_profile_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "permissionProfileId", $permission_profile_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($permission_profile)) {
            $_tempBody = $permission_profile;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfile',
                '/v2.1/accounts/{accountId}/permission_profiles/{permissionProfileId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfile', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSettings
     *
     * Updates the account settings for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSettingsInformation $account_settings_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateSettings($account_id, $account_settings_information = null)
    {
        list($response) = $this->updateSettingsWithHttpInfo($account_id, $account_settings_information);
        return $response;
    }

    /**
     * Operation updateSettingsWithHttpInfo
     *
     * Updates the account settings for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSettingsInformation $account_settings_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSettingsWithHttpInfo($account_id, $account_settings_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($account_settings_information)) {
            $_tempBody = $account_settings_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/settings'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSharedAccess
     *
     * Reserved: Sets the shared access information for users.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSharedAccess $account_shared_access  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateSharedAccessOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSharedAccess
     */
    public function updateSharedAccess($account_id, $account_shared_access = null, \DocuSign\eSign\Api\AccountsApi\UpdateSharedAccessOptions $options = null)
    {
        list($response) = $this->updateSharedAccessWithHttpInfo($account_id, $account_shared_access, $options);
        return $response;
    }

    /**
     * Operation updateSharedAccessWithHttpInfo
     *
     * Reserved: Sets the shared access information for users.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSharedAccess $account_shared_access  (optional)
     * @param  \DocuSign\eSign\Api\AccountsApi\UpdateSharedAccessOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSharedAccess, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSharedAccessWithHttpInfo($account_id, $account_shared_access = null, \DocuSign\eSign\Api\AccountsApi\UpdateSharedAccessOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSharedAccess');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/shared_access";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getItemType() != 'null') {
                $queryParams['item_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getItemType());
            }
            if ($options->getPreserveExistingSharedAccess() != 'null') {
                $queryParams['preserve_existing_shared_access'] = $this->apiClient->getSerializer()->toQueryValue($options->getPreserveExistingSharedAccess());
            }
            if ($options->getUserIds() != 'null') {
                $queryParams['user_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserIds());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($account_shared_access)) {
            $_tempBody = $account_shared_access;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSharedAccess',
                '/v2.1/accounts/{accountId}/shared_access'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSharedAccess', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSharedAccess', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateUserAuthorization
     *
     * Updates the user authorization
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $authorization_id 
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationUpdateRequest $user_authorization_update_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserAuthorization
     */
    public function updateUserAuthorization($account_id, $authorization_id, $user_id, $user_authorization_update_request = null)
    {
        list($response) = $this->updateUserAuthorizationWithHttpInfo($account_id, $authorization_id, $user_id, $user_authorization_update_request);
        return $response;
    }

    /**
     * Operation updateUserAuthorizationWithHttpInfo
     *
     * Updates the user authorization
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $authorization_id 
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\UserAuthorizationUpdateRequest $user_authorization_update_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserAuthorization, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUserAuthorizationWithHttpInfo($account_id, $authorization_id, $user_id, $user_authorization_update_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateUserAuthorization');
        }
        // verify the required parameter 'authorization_id' is set
        if ($authorization_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $authorization_id when calling updateUserAuthorization');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling updateUserAuthorization');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/authorization/{authorizationId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($authorization_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "authorizationId", $authorization_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($user_authorization_update_request)) {
            $_tempBody = $user_authorization_update_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserAuthorization',
                '/v2.1/accounts/{accountId}/users/{userId}/authorization/{authorizationId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserAuthorization', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserAuthorization', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateWatermark
     *
     * Update watermark information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Watermark $watermark  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Watermark
     */
    public function updateWatermark($account_id, $watermark = null)
    {
        list($response) = $this->updateWatermarkWithHttpInfo($account_id, $watermark);
        return $response;
    }

    /**
     * Operation updateWatermarkWithHttpInfo
     *
     * Update watermark information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Watermark $watermark  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Watermark, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWatermarkWithHttpInfo($account_id, $watermark = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateWatermark');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/watermark";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($watermark)) {
            $_tempBody = $watermark;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Watermark',
                '/v2.1/accounts/{accountId}/watermark'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Watermark', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Watermark', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
