<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

namespace Sugarcrm\Sugarcrm\IdentityProvider\Authentication\UserProvider;

use Sugarcrm\IdentityProvider\Srn\Converter;
use Sugarcrm\Sugarcrm\IdentityProvider\Authentication\ServiceAccount\ServiceAccount;
use Sugarcrm\Sugarcrm\IdentityProvider\Authentication\User;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;

class SugarOIDCUserProvider implements UserProviderInterface
{
    /**
     * @var SugarLocalUserProvider
     */
    protected $sugarLocalUserProvider;

    /**
     * SugarOIDCUserProvider constructor.
     * @param UserProviderInterface $sugarLocalUserProvider
     */
    public function __construct(UserProviderInterface $sugarLocalUserProvider)
    {
        $this->sugarLocalUserProvider = $sugarLocalUserProvider;
    }

    /**
     * Set allow inactive user
     *
     * @param bool $allowInactive
     */
    public function setAllowInactive(bool $allowInactive)
    {
        $this->sugarLocalUserProvider->setAllowInactive($allowInactive);
    }

    /**
     * @param string $username
     * @return User
     */
    public function loadUserByUsername($username)
    {
        return new User($username);
    }

    /**
     * @param string $srn
     * @return User
     */
    public function loadUserBySrn(string $srn): User
    {
        $userSrn = Converter::fromString($srn);
        $srnObject = $userSrn->getResource();

        if ($srnObject[0] === 'sa') {
            $user = new ServiceAccount('', '');
        } else {
            $user = new User('', '');
        }
        $user->setSrn($srn);
        return $user;
    }

    /**
     * Get user by field value.
     *
     * @param string $value
     * @param string $field
     * @return User
     */
    public function loadUserByField($value, $field)
    {
        return $this->sugarLocalUserProvider->loadUserByField($value, $field);
    }

    /**
     * {@inheritdoc}
     */
    public function refreshUser(UserInterface $user)
    {
        return $this->loadUserByUsername($user->getUsername());
    }

    /**
     * {@inheritdoc}
     */
    public function supportsClass($class)
    {
        return $class === User::class;
    }
}
