<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */


$dictionary['pmse_Project'] = [
    'table' => 'pmse_project',
    'color' => 'orange',
    'icon' => 'sicon-process-definitions-lg',
    'archive' => false,
    'audited' => false,
    'activity_enabled' => true,
    'duplicate_merge' => true,
    // Will be uncommented when BR-6677 is merged
    //'unified_search' => true,
    //'full_text_search' => true,
    //'unified_search_default_enabled' => true,
    'fields' => [
        'prj_uid' => [
            'name' => 'prj_uid',
            'vname' => 'LBL_PRJ_UID',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '36',
            'size' => '20',
        ],
        'prj_target_namespace' => [
            'required' => false,
            'name' => 'prj_target_namespace',
            'vname' => 'LBL_PRJ_TARGET_NAMESPACE',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'prj_expression_language' => [
            'required' => false,
            'name' => 'prj_expression_language',
            'vname' => 'LBL_PRJ_EXPRESSION_LANGUAGE',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'prj_type_language' => [
            'required' => false,
            'name' => 'prj_type_language',
            'vname' => 'LBL_PRJ_TYPE_LANGUAGE',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'prj_exporter' => [
            'required' => false,
            'name' => 'prj_exporter',
            'vname' => 'LBL_PRJ_EXPORTER',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'prj_exporter_version' => [
            'required' => false,
            'name' => 'prj_exporter_version',
            'vname' => 'LBL_PRJ_EXPORTER_VERSION',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'prj_author' => [
            'required' => false,
            'name' => 'prj_author',
            'vname' => 'LBL_PRJ_AUTHOR',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'prj_author_version' => [
            'required' => false,
            'name' => 'prj_author_version',
            'vname' => 'LBL_PRJ_AUTHOR_VERSION',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'prj_original_source' => [
            'required' => false,
            'name' => 'prj_original_source',
            'vname' => 'LBL_PRJ_ORIGINAL_SOURCE',
            'type' => 'varchar',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '20',
        ],
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'type' => 'name',
            'dbType' => 'varchar',
            'len' => '255',
            'unified_search' => true,
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 1.55],
            'required' => true,
            'importable' => 'required',
            'duplicate_merge' => 'enabled',
            'merge_filter' => 'selected',
            'duplicate_on_record_copy' => 'always',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'duplicate_merge_dom_value' => '3',
            'audited' => false,
            'reportable' => true,
            'calculated' => false,
            'size' => '20',
        ],
        'prj_status' => [
            'name' => 'prj_status',
            'vname' => 'LBL_PRJ_STATUS',
            'type' => 'enum',
            'len' => 10,
            'options' => 'process_definition_status_dom',
            'comment' => 'Process Definition status (ex: Enabled, Disabled)',
            'default' => 'INACTIVE',
            'duplicate_on_record_copy' => 'no',
        ],
        'prj_module' => [
            'required' => true,
            'name' => 'prj_module',
            'vname' => 'LBL_PRJ_MODULE',
            'type' => 'enum',
            'massupdate' => true,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'options' => '',
            'studio' => 'visible',
            'dependency' => false,
            'function' => [
                'name' => 'getTargetsModules',
                'include' => 'modules/pmse_Project/pmse_ProjectHelper.php',
            ],
        ],
        'prj_run_order' => [
            'required' => false,
            'default' => 1,
            'name' => 'prj_run_order',
            'vname' => 'LBL_PRJ_RUN_ORDER',
            'type' => 'int',
            'importable' => 'true',
            'calculated' => false,
            'studio' => 'visible',
            'min' => '1',
        ],
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$or' => [
                        ['name' => ['$equals' => '$name']],
                    ],
                ],
            ],
            'ranking_fields' => [
                ['in_field_name' => 'name', 'dupe_field_name' => 'name'],
            ],
        ],
    ],
    'relationships' => [],
    'optimistic_locking' => true,
    'unified_search' => true,
    'acls' => [
        'SugarACLDeveloperOrAdmin' => [
            'allowUserRead' => false,
            'aclModule' => 'pmse_Project',
        ],
        'SugarACLDeveloperForTarget' => [
            'targetModuleField' => 'prj_module',
            'allowUserRead' => false,
        ],
    ],
    'visibility' => [
        'TargetModuleDeveloperVisibility' => [
            'targetModuleField' => 'prj_module',
        ],
    ],
    'hidden_to_role_assignment' => true,
    // @TODO Fix the Default and Basic SugarObject templates so that Basic
    // implements Default. This would allow the application of various
    // implementations on Basic without forcing Default to have those so that
    // situations like this - implementing taggable - doesn't have to apply to
    // EVERYTHING. Since there is no distinction between basic and default for
    // sugar objects templates yet, we need to forecefully remove the taggable
    // implementation fields. Once there is a separation of default and basic
    // templates we can safely remove these as this module will implement
    // default instead of basic.
    'ignore_templates' => [
        'lockable_fields',
    ],
    'portal_visibility' => [
        'class' => 'PMSE',
    ],
    'uses' => [
        'basic',
        'team_security',
        'assignable',
        'taggable',
    ],
];

VardefManager::createVardef('pmse_Project', 'pmse_Project');
