<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

// Needed by VarDef manager when running the load_fields directive
SugarAutoLoader::load('modules/pmse_Project/pmse_BpmProcessDefinition/LockedFieldsRelatedModulesUtilities.php');

$dictionary['pmse_BpmProcessDefinition'] = [
    'table' => 'pmse_bpm_process_definition',
    'archive' => false,
    'audited' => false,
    'activity_enabled' => false,
    'duplicate_merge' => true,
    'reassignable' => false,
    'fields' => [
        'prj_id' => [
            'required' => true,
            'name' => 'prj_id',
            'vname' => 'Project Identifier',
            'type' => 'varchar',
            'massupdate' => false,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '36',
            'size' => '36',
        ],
        'pro_module' => [
            'required' => true,
            'name' => 'pro_module',
            'vname' => 'The default Module Name for the whole process',
            'type' => 'varchar',
            'massupdate' => false,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '255',
        ],
        'pro_status' => [
            'required' => true,
            'name' => 'pro_status',
            'vname' => 'The process status, can be ACTIVE, INACTIVE',
            'type' => 'varchar',
            'massupdate' => false,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '255',
            'size' => '255',
        ],
        'pro_locked_variables' => [
            'required' => true,
            'name' => 'pro_locked_variables',
            'vname' => 'array of locked variables, these variables are not able to be modified by SugarCrm Forms',
            'type' => 'text',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'size' => '20',
            'rows' => '4',
            'cols' => '20',
        ],
        'pro_terminate_variables' => [
            'required' => true,
            'name' => 'pro_terminate_variables',
            'vname' => 'array of variables and their values used to halt (terminate) the case',
            'type' => 'text',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'size' => '20',
            'rows' => '4',
            'cols' => '20',
        ],
        'execution_mode' => [
            'required' => true,
            'name' => 'execution_mode',
            'vname' => 'script to be executed',
            'type' => 'varchar',
            'massupdate' => false,
            'default' => 'SYNC',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => '10',
            'size' => '10',
        ],
    ],
    'optimistic_locking' => true,
    'unified_search' => true,
    'relationships' => [],
    'indices' => [
        'prj_id' => [
            'name' => 'idx_pd_prj_id',
            'type' => 'index',
            'fields' => ['prj_id'],
        ],
        'pro_status' => [
            'name' => 'idx_pd_pro_status',
            'type' => 'index',
            'fields' => ['pro_status'],
        ],
    ],
    'uses' => [
        'basic',
        'assignable',
    ],
    'load_fields' => [
        'class' => 'LockedFieldsRelatedModulesUtilities',
        'method' => 'getRelatedFields',
    ],
    'portal_visibility' => [
        'class' => 'PMSE',
    ],
    'ignore_templates' => [
        'taggable',
        'lockable_fields',
        'commentlog',
    ],
];

VardefManager::createVardef('pmse_BpmProcessDefinition', 'pmse_BpmProcessDefinition');
