<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
global $current_user;
//Only allow admins to enter this screen
if (!is_admin($current_user)) {
    $GLOBALS['log']->error("Non-admin user ($current_user->user_name) attempted to enter the WorkFlow EditView screen");
    session_destroy();
    include 'modules/Users/Logout.php';
}

global $mod_strings;
global $app_list_strings;
global $app_strings;
// Unimplemented until jscalendar language files are fixed
// global $current_language;
// global $default_language;
// global $cal_codes;

$focus = BeanFactory::newBean('WorkFlow');

if (!empty($_REQUEST['record'])) {
    $focus->retrieve($_REQUEST['record']);
}

if (isset($_REQUEST['isDuplicate']) && $_REQUEST['isDuplicate'] == 'true') {
    $focus->id = '';
}
echo getClassicModuleTitle($mod_strings['LBL_MODULE_NAME'], [$mod_strings['LBL_MODULE_NAME'], $focus->name], true);


$GLOBALS['log']->info('WorkFlow edit view');

$xtpl = new XTemplate('modules/WorkFlow/EditView.html');
$xtpl->assign('MOD', $mod_strings);
$xtpl->assign('APP', $app_strings);

if (isset($_REQUEST['return_module'])) {
    $xtpl->assign('RETURN_MODULE', $_REQUEST['return_module']);
}
if (isset($_REQUEST['return_action'])) {
    $xtpl->assign('RETURN_ACTION', $_REQUEST['return_action']);
}
if (isset($_REQUEST['return_id'])) {
    $xtpl->assign('RETURN_ID', $_REQUEST['return_id']);
}
// handle Create $module then Cancel
if (empty($_REQUEST['return_id'])) {
    $xtpl->assign('RETURN_ACTION', 'index');
}
$xtpl->assign('PRINT_website', 'index.php?' . $GLOBALS['request_string']);
$xtpl->assign('JAVASCRIPT', get_set_focus_js());


$xtpl->assign('ID', $focus->id);
$xtpl->assign('NAME', $focus->name);
$xtpl->assign('DESCRIPTION', nl2br($focus->description));

if ($focus->status == 'on') {
    $xtpl->assign('STATUS', 'checked');
}

$xtpl->assign('TYPE', get_select_options_with_id($app_list_strings['wflow_type_dom'], $focus->type));
$xtpl->assign('BASE_MODULE', get_select_options_with_id($focus->get_module_array(), $focus->base_module));

global $current_user;

//Add Custom Fields
require_once 'modules/DynamicFields/templates/Files/EditView.php';

$xtpl->parse('main');
$xtpl->out('main');

$javascript = new javascript();
$javascript->setFormName('EditView');
$javascript->setSugarBean($focus);
$javascript->addAllFields('');
echo $javascript->getScript();
