<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
/*********************************************************************************
 * Description:
 ********************************************************************************/


require_once 'include/workflow/workflow_utils.php';


global $process_dictionary;
require_once 'modules/WorkFlowActionShells/MetaArray.php';

// WorkFlowActionShell is used to store the shell action information.
class WorkFlowActionShell extends SugarBean
{
    // Stored fields
    public $id;
    public $deleted;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $created_by;
    public $created_by_name;
    public $modified_by_name;
    public $name;


    //construction
    public $action_type;
    public $rel_module;
    public $action_module;
    public $parent_id;
    public $parent_base_module;
    public $parent_type;

    public $parameters;

    public $rel_module_type = 'all';

    public $table_name = 'workflow_actionshells';
    public $module_dir = 'WorkFlowActionShells';
    public $object_name = 'WorkFlowActionShell';
    public $rel_action_table = 'workflow_actions';
    public $rel_workflow_table = 'workflow';


    public $new_schema = true;

    public $column_fields = ['id'
        , 'date_entered'
        , 'date_modified'
        , 'modified_user_id'
        , 'created_by'
        , 'action_type'
        , 'rel_module'
        , 'action_module'
        , 'parent_id'
        , 'rel_module_type',
        'parameters'
        , 'parent_base_module'
        , 'parent_type',
    ];


    //meta array for loading required info on the fields selection
    public $action_array = [

        'new' => ['set_required' => true],
        'new_rel' => ['set_required' => true],
        'update' => ['set_required' => false],
        'update_rel' => ['set_required' => false],

    ];


    // This is used to retrieve related fields from form posts.
    public $additional_column_fields = [];

    // This is the list of fields that are in the lists.
    public $list_fields = ['action_type', 'action_module', 'rel_module'];


    // This is the list of fields that are required
    public $required_fields = [];

    public function __construct()
    {
        parent::__construct();

        $this->disable_row_level_security = true;
    }


    public function get_summary_text()
    {
        return "$this->name";
    }


    public function save($check_notify = false)
    {
        parent::save($check_notify);
        //check for an remove invalid actions from this shell
        if (!empty($this->id)) {
            $actions = $this->get_actions($this->id);
            $workflow_object = $this->get_workflow_object();
            $temp_module = BeanFactory::newBean($workflow_object->base_module);
            $temp_module->call_vardef_handler('action_filter');
            $field_array = $temp_module->vardef_handler->get_vardef_array();
            foreach ($actions as $action) {
                if (!empty($action->field)) {
                    //Check if the actions field is still valid, if not remove the action
                    if (empty($field_array[$action->field])) {
                        $action->mark_deleted($action->id);
                    }
                }
            }
        }
    }

    public function save_relationship_changes($is_update, $exclude = [])
    {
    }


    public function mark_relationships_deleted($id)
    {
    }

    public function fill_in_additional_list_fields()
    {
    }

    public function fill_in_additional_detail_fields()
    {
    }


    public function get_list_view_data($filter_fields = [])
    {

        global $app_strings, $mod_strings;
        global $app_list_strings;
        global $mod_strings;
        global $beanList;
        global $current_module_strings2;

        global $current_user;

        //begin - rsmith
        include_once 'include/ListView/ProcessView.php';
        $ProcessView = new ProcessView($this->get_workflow_object(), $this);
        $results = $ProcessView->get_action_shell_display_text($this, false);
        $result = $results['RESULT_ARRAY'];
        $table_html = "<table id='tbl_$this->id' style='display:none'>";
        foreach ($result as $key => $value) {
            if (isset($value['ACTION_DISPLAY_TEXT'])) {
                if ($value['ACTION_DISPLAY_TEXT'] === false) {
                    $table_html .= '<tr><td>';
                    $table_html .= "<span class='error'>" . translate('LBL_ACTION_ERROR') . '</span>';
                    $table_html .= '</td></tr>';
                    if (empty($this->hasError)) {
                        $this->hasError = true;
                        echo '<p class="error"><b>' . translate('LBL_ACTION_ERRORS') . '</b></p>';
                    }
                } else {
                    $table_html .= '<tr><td>';
                    $table_html .= '<li>' . $mod_strings['LBL_SET'] . ' ' . $value['FIELD_NAME'] . ' ' . $mod_strings['LBL_AS'] . ' ' . $value['ACTION_DISPLAY_TEXT'];
                    $table_html .= '</td></tr>';
                }
            }
        }
        $table_html .= '</table>';
        //end - rsmith

        $temp_array = [];

        //Grab event
        $ProcessView->local_strings = $current_module_strings2;
        //BEGIN WFLOW PLUGINS
        global $process_dictionary;
        get_plugin('workflow', 'action_createstep1', $this);
        //END WFLOW PLUGINS
        $prev_display_text = $ProcessView->get_prev_text('ActionsCreateStep1', $this->action_type);
        unset($ProcessView);
        $natural_language = '<b>' . $prev_display_text . '</b>';


        $temp_array['HREF_EDIT'] = "'javascript:get_popup(\"" . $this->parent_id . '","' . $this->id . "\",\"CreateStep2\",\"\",\"\",\"400\",\"500\")'";
        $temp_array['HREF_DELETE'] = 'index.php?action=Delete&module=WorkFlowActionShells&record=' . $this->id . '';
        $temp_array['TYPE'] = $current_module_strings2['LBL_MODULE_NAME'];
        $temp_array['STATEMENT'] = '<i>' . $natural_language . '</i>';
        $temp_array['DETAILS_TABLE'] = $table_html;
        $temp_array['ID'] = $this->id;


        //Component information for either invitees (Meetings & Calls ONLY)
        if ($this->action_module == 'Meetings' ||
            $this->action_module == 'Calls' ||
            $this->action_module == 'meetings' ||
            $this->action_module == 'calls') {
            $recipient_icon = SugarThemeRegistry::current()->getImage('Users', 'align="absmiddle" border="0"', null, null, '.gif', $app_strings['LNK_REMOVE']);

            $bridge_list = $this->get_linked_beans('action_bridge', 'WorkFlow');

            if (!empty($bridge_list)) {
                $alertshell_list = $bridge_list[0]->get_linked_beans('alerts', 'WorkFlowAlertShell');
                if (!empty($alertshell_list)) {
                    //check for any invitees
                    $invitees_list = $alertshell_list[0]->get_linked_beans('alert_components', 'WorkFlowAlert');

                    if (empty($invitees_list)) {
                        $invitee_notice = "<font color='red'><b>" . $mod_strings['LBL_INVITEE_NOTICE'] . ' ' . $app_list_strings['moduleListSingular'][ucfirst($this->action_module)] . ' </b></font><BR>';
                        $temp_array['STATEMENT_NOTICE'] = $invitee_notice;
                    }

                    $temp_array['COMPONENT_HREF_EDIT'] = 'index.php?action=DetailView&module=WorkFlowAlertShells&module_tab=WorkFlow&record=' . $alertshell_list[0]->id . '&workflow_id=' . $alertshell_list[0]->parent_id;
                    $temp_array['COMPONENT_STATEMENT'] = $recipient_icon . $mod_strings['LBL_INVITEES'];
                }
            }
        }


        //BEGIN WFLOW PLUGINS
        $list_data_array = get_plugin('workflow', 'action_listview', $this);
        if (!empty($list_data_array['action_processed']) && $list_data_array['action_processed'] == true) {
            //a custom plugin was found with data
            foreach ($list_data_array['list_data'] as $list_key => $list_value) {
                $temp_array[$list_key] = $list_value;
                //loop through and fill the temp_array
            }
        }
        //END WFLOW PLUGINS


        return $temp_array;
    }

    public function clear_deleted($id)
    {

        //end function clear_deleted
    }


    public function build_generic_where_clause($the_query_string)
    {
    }


////////////////////Action Shell components


    public function get_action_id($field_name)
    {
        $query = "	SELECT $this->rel_action_table.id
					FROM $this->rel_action_table 
					WHERE $this->rel_action_table.parent_id = " . $this->db->quoted($this->id) . '
					AND ' . $this->rel_action_table . '.field = ' . $this->db->quoted($field_name) . '
					AND ' . $this->rel_action_table . '.deleted=0';
        $result = $this->db->query($query, true, ' Error grabbing action id: ');
        // Get the id and the name.
        $row = $this->db->fetchByAssoc($result);

        if ($row != null) {
            return $row['id'];
        } else {
            return false;
        }

        //end function
    }

    public function get_actions($id)
    {

        $query = "	SELECT $this->rel_action_table.id
					FROM $this->rel_action_table 
					WHERE $this->rel_action_table.parent_id = " . $this->db->quoted($id) . '
					AND ' . $this->rel_action_table . '.deleted=0';
        $result = $this->db->query($query, true, ' Error grabbing action id: ');
        // Get the id and the name.
        $actions = [];
        while ($row = $this->db->fetchByAssoc($result)) {
            $action = BeanFactory::getBean('WorkFlowActions', $row['id']);
            $actions[] = $action;
        }
        return $actions;
        //end function
    }

    public function copy($parent_id)
    {
        $orig_id = $this->id;
        $new_action_shell =& $this;
        $new_action_shell->id = '';
        $new_action_shell->parent_id = $parent_id;
        if (isset($new_action_shell->date_entered)) {
            $new_action_shell->date_entered = null;
        }
        if (isset($new_action_shell->created_by)) {
            $new_action_shell->created_by = null;
        }

        $new_action_shell->save();
        $new_id = $new_action_shell->id;
        $this->retrieve($orig_id);

        $actions = $this->get_actions($this->id);
        foreach ($actions as $an_action) {
            $new_action =& $an_action;
            $new_action->id = '';
            $new_action->parent_id = $new_id;
            if (isset($new_action->date_entered)) {
                $new_action->date_entered = null;
            }
            if (isset($new_action->created_by)) {
                $new_action->created_by = null;
            }
            $new_action->save();
        }
        return $new_id;
    }


    public function get_workflow_object()
    {
        $workflow_object = BeanFactory::getBean('WorkFlow', $this->parent_id);
        return $workflow_object;

        //end function get_workflow_type
    }


    //checks to see if the field is required
    public function check_required_field($type, $target_module, $target_field, $action = false)
    {

        //if override is true or this action_type is ok for checking for set required
        if ($action == true || $this->action_array[$this->action_type]['set_required'] == true) {
            global $app_strings;

            if (isset($target_module->required_fields[$target_field])) {
                if ($type == 'start_display') {
                    return '';
                }
                if ($type == 'iframe_display') {
                    return 'disabled checked';
                }
                if ($type == 'span_req_display') {
                    return '&nbsp;<span class="required">' . $app_strings['LBL_REQUIRED_SYMBOL'] . '</span>';
                }
                //required is true so set display to '';
            }

            //end if the override is true or this is a valid action type to check for the set required output
        }

        if ($type == 'start_display') {
            return 'none';
        }
        if ($type == 'iframe_display') {
            return '';
        }
        if ($type == 'span_req_display') {
            return '';
        }


        //end function check_required_field
    }


    public function check_for_invitee_bridge($workflow_object)
    {


        /*Conditions where the below is true
            -new record that is a meeting or call
            -new related record that is a meeting or a call
        */

        if ($this->action_module == 'Meetings' ||
            $this->action_module == 'Calls' ||
            $this->action_module == 'meetings' ||
            $this->action_module == 'calls') {
            //Build bridging workflow object
            $bridge_object = BeanFactory::newBean('WorkFlow');
            $bridge_object->parent_id = $this->id;
            $bridge_object->name = 'Meeting/Call Bridging Object';
            $bridge_object->status = 'on';
            $bridge_object->base_module = ucfirst($this->action_module);//base module must be ucfirst
            $bridge_object->type = 'Normal';
            $bridge_object->fire_order = 'alerts_actions';
            $bridge_object->record_type = 'All';
            $bridge_object->save();

            //Add or Build Logic File if necessary
            $bridge_object->check_logic_hook_file();


            //Predefine AlertShell Object
            $alert_shell_object = BeanFactory::newBean('WorkFlowAlertShells');
            $alert_shell_object->name = 'Invite People';
            $alert_shell_object->alert_type = 'Invite';
            $alert_shell_object->source_type = 'System Default';
            $alert_shell_object->parent_id = $bridge_object->id;
            $alert_shell_object->save();

            $bridge_object->write_workflow();


            //end if action_module is Meetings Or Calls
        }

        //end function check_for_invitee_bridge
    }


    public function check_for_invitee_bridge_meta($action_array)
    {

        //This function needs to be re-worked.

        if ($action_array['action_module'] == 'Meetings' ||
            $action_array['action_module'] == 'Calls' ||
            $action_array['action_module'] == 'meetings' ||
            $action_array['action_module'] == 'calls') {
            $this->retrieve($action_array['id']);

            //grab the bridge object
            $bridge_list = $this->get_linked_beans('action_bridge', 'WorkFlow');

            if (!empty($bridge_list[0])) {
                return "\t\t 'bridge_id' => '" . $bridge_list[0]->id . "', \n";
            }

            //end check to see if we need the meta data
        }

        return '';

        //end function check_for_invitee_bridge_meta
    }

    public function check_for_child_bridge($delete = false)
    {
        $sql = 'SELECT id FROM workflow WHERE parent_id=?';
        $row = DBManagerFactory::getInstance()
            ->getConnection()
            ->executeQuery($sql, [$this->id])
            ->fetchAssociative();
        if ($row !== false) {
            if ($delete) {
                $workflow_object = BeanFactory::getBean('WorkFlow', $row['id']);
                $workflow_object->check_controller = false;
                $workflow_object->mark_deleted($row['id']);
            } else {
                return $row['id'];
            }
        }
    }

    public function check_for_child_invitee($action_shell_id)
    {

        $this->retrieve($action_shell_id);
        $workflow_id = $this->check_for_child_bridge(false);

        if ($workflow_id != '') {
            $child_workflow_object = BeanFactory::getBean('WorkFlow', $workflow_id);

            $child_alertshell_list = &$child_workflow_object->get_linked_beans('alerts', 'WorkFlowAlertShell');

            if (!empty($child_alertshell_list[0])) {
                //now check for an actual invitee
                $alert_list = $child_alertshell_list[0]->get_linked_beans('alert_components', 'WorkFlowAlert');


                if (!empty($alert_list)) {
                    //an invitee must be present!
                    return true;

                    //end if not empty alert list
                }

                //end if there is a child alertshell
            }

            //end if workflow_id is not empty
        }


        return false;


        //end function check_for_child_invitees
    }

///End Class WorkFlowActionShells
}
