<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
/*********************************************************************************
 * Description:  TODO: To be written.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 * Contributor(s): ______________________________________..
 ********************************************************************************/


require_once 'modules/Teams/Forms.php';

global $app_strings;
global $app_list_strings;
global $mod_strings;
global $current_user;

$GLOBALS['log']->info('Team edit view');

if (!$GLOBALS['current_user']->isAdminForModule('Users')) {
    sugar_die('Unauthorized access to administration.');
}

$focus = BeanFactory::newBean('Teams');

if (isset($_REQUEST['record']) && isset($_REQUEST['record'])) {
    $focus->retrieve($_REQUEST['record']);
}


echo getClassicModuleTitle($mod_strings['LBL_MODULE_NAME'], [$mod_strings['LBL_MODULE_NAME'], $focus->get_summary_text()], true);

$xtpl = new XTemplate('modules/Teams/EditView.html');
$xtpl->assign('MOD', $mod_strings);
$xtpl->assign('APP', $app_strings);

$return_id = $_REQUEST['return_id'] ?? '';
$return_module = $_REQUEST['return_module'] ?? '';
$return_action = $_REQUEST['return_action'] ?? '';
if (empty($return_id)) {
    $return_action = 'index';
}
if (isset($_REQUEST['error_string'])) {
    $xtpl->assign('ERROR_STRING', "<span class='error'>Error: " . $_REQUEST['error_string'] . '</span>');
}
$xtpl->assign('RETURN_MODULE', $return_module);
$xtpl->assign('RETURN_ID', $return_id);
$xtpl->assign('RETURN_ACTION', $return_action);

if (isset($_REQUEST['isDuplicate'])) {
    $xtpl->assign('IS_DUPLICATE', $_REQUEST['isDuplicate']);
}
$xtpl->assign('ID', $focus->id);
$xtpl->assign('NAME', Team::getDisplayName($focus->name, $focus->name_2));
$xtpl->assign('DESCRIPTION', $focus->description);

global $current_user;

$javascript = new javascript();
$javascript->setFormName('EditView');

$javascript->addFieldGeneric('name', 'varchar', $mod_strings['LBL_NAME'], true, '');


$xtpl->parse('main');
$xtpl->out('main');


echo $javascript->getScript();
