<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$renamedefs = [
    'modules' => [
        'Accounts' => [
            ['name' => 'ACCOUNT_REMOVE_PROJECT_CONFIRM', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_BUG_FORM_TITLE', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_BUGS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'LBL_CALLS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_CAMPAIGN_ID', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGN_LIST_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_DUPLICATE', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_INVITEE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_LIST_CONTACT_NAME', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_MEETINGS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_MODULE_ID', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_PARENT_ACCOUNT_ID', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_PRODUCTS_TITLE', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_TASKS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Tasks'],
            ['name' => 'LBL_CAMPAIGNS', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'MSG_DUPLICATE', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_PROSPECT_LIST', 'type' => 'singular', 'source' => 'Prospects'],
            ['name' => 'LBL_ACCOUNTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_TYPE', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CAMPAIGN_ID', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_CONTACT_HISTORY_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_REVENUELINEITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_ACCOUNTS_LIST_DASHBOARD', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNTS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNTS_MULTI_LINE_DASHBOARD', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_RENEWALS_CONSOLE_ACCOUNT_NAME_INDUSTRY', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_FILTER_ACCOUNTS_REPORTS', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Accounts'],
        ],
        'Administration' => [
            ['name' => 'LBL_FORECAST_TITLE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_DESC', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_MANAGE_FORECASTS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_MANAGE_FORECASTS_TITLE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_HISTORY_CONTACTS_EMAILS', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_HISTORY_CONTACTS_EMAILS', 'type' => 'plural', 'source' => 'Emails'],
            ['name' => 'LBL_OPPORTUNITIES_DESC', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITIES_DESC', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITIES_DESC', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_MANAGE_OPPORTUNITIES_TITLE', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_MANAGE_OPPORTUNITIES_DESC', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_MANAGE_QUOTES_TITLE', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'LBL_MANAGE_QUOTES', 'type' => 'singular', 'source' => 'Quotes'],
        ],
        'Bugs' => [
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_BUGS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'LBL_BUGS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Bugs',],
        ],
        'BusinessCenters' => [
            [
                'name' => 'LBL_BUSINESS_CENTERS_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'BusinessCenters',
            ],
            ['name' => 'LBL_BUSINESS_CENTER_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'BusinessCenters',],
        ],
        'Calls' => [
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_LIST_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CALL', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LNK_NEW_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'NTC_REMOVE_INVITEE', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_LOG_CALL', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LNK_SELECT_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LNK_NEW_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LNK_NEW_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_HISTORY_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_CREATE_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CREATE_LEAD', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_SYNCED_RECURRING_MSG', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_CREATE_MODULE', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_RELATED_RECORD_DEFAULT_NAME', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_REMINDER_TITLE', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_REVENUELINEITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_LIST_MY_CALLS', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_MY_SCHEDULED_CALLS', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_GUEST_CALLS', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_GUEST_SCHEDULED_CALLS', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_CALLS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'LBL_CALLS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Calls',],
            ['name' => 'LBL_LEAD_ID', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_LEAD_NAME', 'type' => 'singular', 'source' => 'Leads'],
        ],
        'Campaigns' => [
            ['name' => 'LBL_ACCOUNTS', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_CONTACTS', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_LIST_CAMPAIGN_NAME', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_LOG_ENTRIES_CONTACT_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_LOG_ENTRIES_LEAD_TITLE', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'LBL_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_PROSPECT_LIST_SUBPANEL_TITLE', 'type' => 'singular', 'source' => 'Targets'],
        ],
        'Cases' => [
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_ATTACH_NOTE', 'type' => 'singular', 'source' => 'Notes'],
            ['name' => 'LBL_BUGS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'LBL_CASE_NUMBER', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_CASE_SUBJECT', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_CASE', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_CONTACT_CASE_TITLE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_CASE_TITLE', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LBL_INVITEE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_MEMBER_OF', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_SHOW_MORE', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LNK_CREATE_WHEN_EMPTY', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'NTC_REMOVE_FROM_BUG_CONFIRMATION', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'NTC_REMOVE_FROM_BUG_CONFIRMATION', 'type' => 'singular', 'source' => 'Bugs'],
            ['name' => 'NTC_REMOVE_INVITEE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'NTC_REMOVE_INVITEE', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_ACCOUNT_NAME_OWNER', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_NAME_MOD', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CONTACT_HISTORY_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_PORTAL_TOUR_RECORDS_INTRO', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LBL_PORTAL_TOUR_RECORDS_INTRO', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_PORTAL_TOUR_RECORDS_PAGE', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LBL_PORTAL_TOUR_RECORDS_PAGE', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_PORTAL_TOUR_RECORDS_FILTER', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LBL_PORTAL_TOUR_RECORDS_CREATE', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_CASES_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LBL_CASES_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Cases',],
        ],
        'Contacts' => [
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_INFORMATION', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_CONTACT_OPP_FORM_TITLE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_OPP_FORM_TITLE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTRACTS', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_CREATED_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CREATED_CALL', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_CREATED_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CREATED_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_CREATED_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_DUPLICATE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_EXISTING_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_EXISTING_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_EXISTING_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_IMPORT_VCARDTEXT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_LEAD_SOURCE', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_LIST_CONTACT_NAME', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_VIEW_FORM_TITLE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_NOTE_SUBJECT', 'type' => 'singular', 'source' => 'Notes'],
            ['name' => 'LBL_OPP_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY_ROLE_ID', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY_ROLE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_PRODUCTS_TITLE', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_REVENUELINEITEMS_TITLE', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_RELATED_CONTACTS_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_SELECT_CHECKED_BUTTON_LABEL', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_SELECT_CHECKED_BUTTON_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LNK_NEW_CASE', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LNK_NEW_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LNK_NEW_NOTE', 'type' => 'singular', 'source' => 'Notes'],
            ['name' => 'LNK_NEW_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LNK_NEW_TASK', 'type' => 'singular', 'source' => 'Tasks'],
            ['name' => 'LNK_SELECT_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'MSG_DUPLICATE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'NTC_OPPORTUNITY_REQUIRES_ACCOUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'NTC_OPPORTUNITY_REQUIRES_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'NTC_REMOVE_CONFIRMATION', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'NTC_REMOVE_CONFIRMATION', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_BUGS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'LBL_TARGET_OF_CAMPAIGNS', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGNS', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGN_LIST_SUBPANEL_TITLE', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_CONTACTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_CAMPAIGNS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGN_ID', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_CONTACT_HISTORY_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_PORTAL_TOUR_PROFILE_INTRO', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_CONTACTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACTS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Contacts',],
        ],
        'Contracts' => [
            ['name' => 'LBL_CONTRACT_NAME', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_CONTRACT_TERM', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_DOCUMENTS', 'type' => 'plural', 'source' => 'Documents'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_LIST_CONTRACT_NAME', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_TOTAL_CONTRACT_VALUE', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_TOTAL_CONTRACT_VALUE_USDOLLAR', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_OPPORTUNITY_ID', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CONTRACTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_CONTRACTS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Contracts',],
        ],
        'DataPrivacy' => [
            ['name' => 'LBL_DATA_PRIVACY_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'DataPrivacy'],
            ['name' => 'LBL_DATA_PRIVACY_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'DataPrivacy',],
        ],
        'DocumentRevisions' => [
            ['name' => 'LBL_REVISIONS_FOR_DOC', 'type' => 'singular', 'source' => 'Documents'],
        ],
        'Documents' => [
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Documents'],
            ['name' => 'LBL_DOC_REV_HEADER', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_DOCUMENT_ID', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_DOCUMENT_NAME', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_RELATED_DOCUMENT_ID', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_RELATED_DOCUMENT_REVISION_ID', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_TEMPLATE_TYPE', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_DOCUMENT', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_DOCUMENT_REVISION_ID', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_DOC_NAME', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_CONTRACT_STATUS', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_CONTRACT_NAME', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_DET_RELATED_DOCUMENT_VERSION', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_DET_TEMPLATE_TYPE', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_LIST_DOCUMENT', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_SF_DOCUMENT', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'DEF_CREATE_LOG', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'ERR_DOC_NAME', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'ERR_DOC_VERSION', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'ERR_DELETE_CONFIRM', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'ERR_DELETE_LATEST_VERSION', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'ERR_MISSING_FILE', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_TREE_TITLE', 'type' => 'plural', 'source' => 'Documents'],
            ['name' => 'LBL_LIST_TEMPLATE_TYPE', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_CONTRACTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'contracts'],
            ['name' => 'LBL_CONTRACTS', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_DOC_ID', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_DOC_URL', 'type' => 'singular', 'source' => 'Documents'],
            ['name' => 'LBL_BUGS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'LBL_DOCUMENTS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Documents'],
            ['name' => 'LBL_MY_DOCUMENTS', 'type' => 'plural', 'source' => 'Documents'],
        ],
        'Emails' => [
            ['name' => 'LBL_EMAILS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Emails'],
            ['name' => 'LBL_EMAILS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Emails'],
            ['name' => 'LBL_EMAILS_ACCOUNTS_REL', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_EMAILS_BUGS_REL', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'LBL_EMAILS_CASES_REL', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'LBL_EMAILS_CONTACTS_REL', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_EMAILS_LEADS_REL', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'LBL_EMAILS_OPPORTUNITIES_REL', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_EMAILS_NOTES_REL', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_EMAILS_PROJECT_REL', 'type' => 'plural', 'source' => 'Project'],
            ['name' => 'LBL_EMAILS_PROJECT_TASK_REL', 'type' => 'plural', 'source' => 'ProjectTask'],
            ['name' => 'LBL_EMAILS_TASKS_REL', 'type' => 'plural', 'source' => 'Tasks'],
            ['name' => 'LBL_EMAILS_USERS_REL', 'type' => 'plural', 'source' => 'Users'],
            ['name' => 'LBL_EMAILS_PRODUCTS_REL', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_EMAILS_REVENUELINEITEMS_REL', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_EMAILS_QUOTES_REL', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'LBL_EMAILS_ESCALATIONS_REL', 'type' => 'plural', 'source' => 'Escalations'],
            ['name' => 'LBL_EMAILS_MESSAGES_REL', 'type' => 'plural', 'source' => 'Messages'],
            ['name' => 'LBL_EMAILS_PURCHASES_REL', 'type' => 'plural', 'source' => 'Purchases'],
            ['name' => 'LBL_EMAILS_PURCHASEDLINEITEMS_REL', 'type' => 'plural', 'source' => 'PurchasedLineItems'],
        ],
        'EmailAddresses' => [
            ['name' => 'LBL_MODULE_NAME', 'type' => 'singular', 'source' => 'EmailAddresses'],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'EmailAddresses'],
        ],
        'EmailParticipants' => [
            ['name' => 'LBL_MODULE_NAME', 'type' => 'singular', 'source' => 'EmailParticipants'],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'EmailParticipants'],
        ],
        'Escalations' => [
            ['name' => 'LBL_ESCALATIONS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Escalations'],
        ],
        'Forecasts' => [
            ['name' => 'LNK_NEW_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LNK_UPD_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_QUOTA', 'type' => 'plural', 'source' => 'Quotas'],
            ['name' => 'LBL_FORECAST_HISTORY', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_TIMEPERIOD_NAME', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECAST_ID', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_TIME_ID', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECAST_TYPE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_OPP_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_FORECAST_PIPELINE_OPP_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_QC_TIME_PERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_QC_OPPORTUNITY_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_QC_DIRECT_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QC_ROLLUP_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QC_UPCOMING_FORECASTS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_OW_OPPORTUNITIES', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OW_ACCOUNTNAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_OW_MODULE_TITLE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LNK_NEW_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LNK_TIMEPERIOD_LIST', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_SVFS_HEADER', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FS_TIMEPERIOD_ID', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FS_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FS_FORECAST_START_DATE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FS_MODULE_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FDR_OPPORTUNITIES', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FDR_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_FDR_WEIGH', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_DV_HEADER', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_MY_FORECASTS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_MY_TEAM', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_TIMEPERIODS', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_DV_FORECAST_PERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_DV_FORECAST_PERIOD', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_OPPORTUNITY', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_OPPORTUNITY', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_COMMIT_HEADER', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_ROLLUP', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_LV_TIMPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_LV_TYPE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_LV_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_NO_ACTIVE_TIMEPERIOD', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_NO_ACTIVE_TIMEPERIOD', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_RESET_CHECK', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_QUOTA_ADJUSTED', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_FORECAST_FOR', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_GRAPH_TITLE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_GRAPH_QUOTA_ALTTEXT', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_GRAPH_OPPS_ALTTEXT', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_GRAPH_QUOTA_LEGEND', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_GRAPH_COMMIT_LEGEND', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_GRAPH_OPPS_LEGEND', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_TP_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_CHART_FOOTER', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_CHART_FOOTER', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_CHART_FOOTER', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CHART_TITLE', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QUOTA_ID', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_ERROR_NOT_MANAGER', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_COMMITTED_HISTORY_SETUP_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_COMMITTED_HISTORY_UPDATED_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_EXPECTED_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_DISTANCE_ABOVE_LIKELY_FROM_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_DISTANCE_LEFT_LIKELY_TO_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_DISTANCE_ABOVE_BEST_FROM_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_DISTANCE_LEFT_BEST_TO_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_DISTANCE_ABOVE_WORST_FROM_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_DISTANCE_LEFT_WORST_TO_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_PIPELINE_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_IN_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_TITLE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_TITLE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_MISSING_STAGE_TITLE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_MISSING_SALES_STAGE_VALUES', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_ACLS_NO_ACCESS_TITLE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_ACLS_NO_ACCESS_MSG', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_BREADCRUMB_TIMEPERIODS', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TITLE_FORECAST_SETTINGS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_TITLE_TIMEPERIODS', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TITLE_RANGES', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_TITLE_FORECAST_BY', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_HOWTO_TITLE_FORECAST_BY', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_TIMEPERIODS', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_TIMEPERIODS', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_TIMEPERIODS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_TIMEPERIODS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_RANGES', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_SCENARIOS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_WORKSHEET_COLUMNS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_HELP_FORECAST_BY', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_SETTINGS_SAVED', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIOD_SETUP_NOTICE', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIOD_DESC', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIOD_DESC', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_LEAFPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIODS_FORWARD', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIODS_FORWARD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIODS_BACKWARD', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_TIMEPERIODS_BACKWARD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_CONFIG_GENERAL_FORECAST_BY_TEXT', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_GENERAL_FORECAST_BY_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_FORECASTS_CONFIG_GENERAL_FORECAST_BY_PRODUCT_LINE_ITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_REVENUELINEITEM_NAME', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_FORECASTS_CONFIG_RANGES_SETUP_NOTICE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_RANGES', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_SHOW_BINARY_RANGES_DESCRIPTION', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_SHOW_BUCKETS_RANGES_DESCRIPTION', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_SHOW_CUSTOM_BUCKETS_RANGES_DESCRIPTION', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_RANGES_EXCLUDE_INFO', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_CONFIG_WORKSHEET_SCENARIOS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_WIZARD_SUCCESS_MESSAGE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_TABBED_CONFIG_SUCCESS_MESSAGE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_WORKSHEET_SAVE_DRAFT_SUCCESS', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECASTS_WORKSHEET_SAVE_DRAFT_SUCCESS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_WORKSHEET_COMMIT_SUCCESS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_WORKSHEET_COMMIT_SUCCESS_TO', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_UNAUTH_FORECASTS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_OPPORTUNITY_STATUS', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CAMPAIGN', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_TEAMS', 'type' => 'singular', 'source' => 'Teams'],
            ['name' => 'LBL_DASHLET_FORECAST_NOT_SETUP', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DASHLET_FORECAST_NOT_SETUP_ADMIN', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DASHLET_FORECAST_NOT_SETUP_ADMIN', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DASHLET_PIPELINE_CHART_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_DETAILS_MEETING_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_ASSIGN_QUOTA_BUTTON', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_ASSIGNING_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_QUOTA_ASSIGNED', 'type' => 'plural', 'source' => 'Quotas'],
            ['name' => 'LBL_FORECASTS_NO_ACCESS_TO_CFG_TITLE', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_NO_ACCESS_TO_CFG_MSG', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DASHLET_MY_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DASHLET_MY_TEAMS_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DASHLET_FORECAST_NOT_SETUP_ADMIN', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DASHLET_FORECAST_CONFIG_LINK_TEXT', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECASTS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Forecasts',],
            ['name' => 'LBL_FORECAST_SETTINGS', 'type' => 'singular', 'source' => 'Forecasts',],
            ['name' => 'LBL_OPPORTUNITY_FORECAST', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_REVENUELINEITEM_FORECAST', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_HELP_MAIN_BODY', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_FORECAST_HELP', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_INCLUDED_PIPELINE_HELP', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_INCLUDED_PIPELINE_HELP_CUSTOM_RANGE', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_UPSIDE_PIPELINE_HELP', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_EXCLUDED_PIPELINE_HELP', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_EXCLUDED_PIPELINE_HELP_CUSTOM_RANGE', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_WON_HELP', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_LOST_HELP', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_ALL_HELP', 'type' => 'plural', 'source' => 'Opportunities'],
        ],
        'ForecastManagerWorksheets' => [
            ['name' => 'LBL_MODULE_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_NEW_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_UPD_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_QUOTA', 'type' => 'plural', 'source' => 'Quotas'],
            ['name' => 'LNK_FORECAST_LIST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_HISTORY', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_TIMEPERIOD_NAME', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECAST_ID', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_TIME_ID', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECAST_TYPE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_OPP_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_FORECAST_PIPELINE_OPP_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_QC_TIME_PERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_QC_OPPORTUNITY_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_QC_DIRECT_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QC_ROLLUP_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QC_UPCOMING_FORECASTS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_OW_OPPORTUNITIES', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OW_ACCOUNTNAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_OW_MODULE_TITLE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LNK_NEW_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LNK_TIMEPERIOD_LIST', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_SVFS_HEADER', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FS_TIMEPERIOD_ID', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FS_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FS_FORECAST_START_DATE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FS_MODULE_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FDR_OPPORTUNITIES', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FDR_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_FDR_WEIGH', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_DV_HEADER', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_MY_FORECASTS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_MY_TEAM', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_TIMEPERIODS', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_DV_FORECAST_PERIOD', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_PERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_DV_FORECAST_OPPORTUNITY', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_OPPORTUNITY', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_COMMIT_HEADER', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_ROLLUP', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_LV_TIMPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_LV_TYPE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_LV_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_COMMIT_NOTE', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_NO_ACTIVE_TIMEPERIOD', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_NO_ACTIVE_TIMEPERIOD', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_RESET_CHECK', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_QUOTA_ADJUSTED', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QUOTA_ID', 'type' => 'singular', 'source' => 'Quotas'],
        ],
        'ForecastWorksheets' => [
            ['name' => 'LBL_MODULE_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_NEW_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_UPD_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_QUOTA', 'type' => 'plural', 'source' => 'Quotas'],
            ['name' => 'LNK_FORECAST_LIST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_HISTORY', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_REVENUELINEITEM_NAME', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LNK_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LNK_ACCOUNTS', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_TIMEPERIOD_NAME', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECAST_ID', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_TIME_ID', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECAST_TYPE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FORECAST_OPP_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_FORECAST_PIPELINE_OPP_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_QC_TIME_PERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_QC_OPPORTUNITY_COUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_QC_DIRECT_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QC_ROLLUP_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QC_UPCOMING_FORECASTS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_OW_OPPORTUNITIES', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OW_ACCOUNTNAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_OW_MODULE_TITLE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LNK_NEW_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LNK_TIMEPERIOD_LIST', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_SVFS_HEADER', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FS_TIMEPERIOD_ID', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FS_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FS_FORECAST_START_DATE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FS_MODULE_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FDR_OPPORTUNITIES', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_FDR_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_FDR_WEIGH', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_DV_HEADER', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_MY_FORECASTS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_MY_TEAM', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_TIMEPERIODS', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_DV_FORECAST_PERIOD', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_PERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_DV_FORECAST_OPPORTUNITY', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_OPPORTUNITY', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_COMMIT_HEADER', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_FORECAST_ROLLUP', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_DV_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_LV_TIMPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_LV_TYPE', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_LV_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_COMMIT_NOTE', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_NO_ACTIVE_TIMEPERIOD', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_NO_ACTIVE_TIMEPERIOD', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_RESET_CHECK', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_QUOTA', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_QUOTA_ID', 'type' => 'singular', 'source' => 'Quotas'],
        ],
        'KBContents' => [
            ['name' => 'LBL_KBCONTENTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'KBContents'],
            ['name' => 'LBL_KBCONTENTS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'KBContents',],
        ],
        'Leads' => [
            ['name' => 'LNK_SELECT_###MODULE_PLURAL###', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LNK_SELECT_###MODULE_SINGULAR###', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_ACCOUNT_DESCRIPTION', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_ID', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CAMPAIGN_ID', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGN_LEAD', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGN_LIST_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'LBL_CONTACT_ID', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_LEAD_SOURCE', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_LEAD_SOURCE_DESCRIPTION', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_OPPORTUNITY_AMOUNT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY_ID', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CONVERTED_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LNK_SELECT_ACCOUNTS', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LNK_NEW_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CONVERTED_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONVERTED_OPP', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_LEADS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'LBL_LEADS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Leads',],
            ['name' => 'LBL_AI_LEADS_CONVERSION_PREDICTION_NAME', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'LBL_AI_LEADS_CONVERSION_PREDICTION_DESC', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_ENABLE_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_REQUIRE_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_REQUIRE_RLIS', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_COPY_DATA_RLIS', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_COPY_DATA_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_COPY_DATA_RLIS', 'type' => 'singular', 'source' => 'Opportunities'],
        ],
        'Manufacturers' => [
            ['name' => 'LNK_NEW_PRODUCT', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LNK_PRODUCT_LIST', 'type' => 'plural', 'source' => 'ProductTemplates'],
        ],
        'Meetings' => [
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_HISTORY_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_LIST_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_SEQUENCE', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_TYPE', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_PASSWORD', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_URL', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_CREATOR', 'type' => 'singular', 'singular' => 'Meetings'],
            ['name' => 'NTC_REMOVE_INVITEE', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_LIST_JOIN_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_JOIN_EXT_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_HOST_EXT_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_EXTNOT_MAIN', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_EXTNOT_RECORD_LINK', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_EXTNOSTART_HEADER', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_EXTNOSTART_MAIN', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_CREATE_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CREATE_LEAD', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_RECURRING_LIMIT_ERROR', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_SYNCED_RECURRING_MSG', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_CREATE_MODULE', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_RELATED_RECORD_DEFAULT_NAME', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_REMINDER_TITLE', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_REVENUELINEITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_LIST_MY_MEETINGS', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_MY_SCHEDULED_MEETINGS', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_GUEST_MEETINGS', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_GUEST_SCHEDULED_MEETINGS', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_MEETINGS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'LBL_MEETINGS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Meetings',],
            ['name' => 'LBL_LEAD_GUESTS', 'type' => 'singular', 'source' => 'Leads',],
            ['name' => 'LBL_CONTACT_GUESTS', 'type' => 'singular', 'source' => 'Contacts',],
        ],
        'Messages' => [
            ['name' => 'LBL_CONTACT_ID', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_NAME', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_LEAD_ID', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_LEAD_NAME', 'type' => 'singular', 'source' => 'Leads'],
        ],
        'ModuleBuilder' => [
            ['name' => 'LBL_JS_DELETE_REQUIRED_DDL_ITEM_NEW', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_JS_DELETE_REQUIRED_DDL_ITEM_NEW', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_JS_DELETE_REQUIRED_DDL_ITEM_IN_PROGRESS', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_JS_DELETE_REQUIRED_DDL_ITEM_IN_PROGRESS', 'type' => 'singular', 'source' => 'RevenueLineItems'],
        ],
        'Notes' => [
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_ID', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CASE_ID', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_CONTACT_ID', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_LEAD_ID', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_LIST_CONTACT_NAME', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_LIST_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_NOTE_STATUS', 'type' => 'singular', 'source' => 'Notes'],
            ['name' => 'LBL_NOTE', 'type' => 'singular', 'source' => 'Notes'],
            ['name' => 'LBL_OPPORTUNITY_ID', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_PRODUCT_ID', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_QUOTE_ID', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_REVENUELINEITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_RELATED_CONTACT', 'type' => 'singular', 'source' => 'Contacts',],
            ['name' => 'LBL_NOTES_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_NOTES_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Notes',],
        ],
        'Opportunities' => [
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_VIEW_FORM_TITLE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_INVITEE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CURRENCIES', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CURRENCY_RATE', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_ID', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_NAME', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_SYMBOL', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'UPDATE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'UPDATE', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'UPDATE_VERIFY_TXT', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'UPDATE_DOLLARAMOUNTS_TXT', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'UPDATE_DOLLARAMOUNTS_TXT', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'UPDATE_CREATE_CURRENCY', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'UPDATE_VERIFY_NEWCURRENCY', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'UPDATE_BUG_COUNT', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'UPDATE_BUGFOUND_COUNT', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'UPDATE_MERGE', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'UPDATE_MERGE_TXT', 'type' => 'plural', 'source' => 'Currencies'],
            ['name' => 'UPDATE_MERGE_TXT', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_DUPLICATE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'MSG_DUPLICATE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'NTC_REMOVE_OPP_CONFIRMATION', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'OPPORTUNITY_REMOVE_PROJECT_CONFIRM', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_ACTIVITIES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Activities'],
            ['name' => 'LBL_TOTAL_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_CLOSED_WON_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_CAMPAIGN_OPPORTUNITY', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGN_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_EXPORT_CAMPAIGN_ID', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_OPPORTUNITY_TYPE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CONTACT_HISTORY_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_PRIMARY_QUOTE_ID', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CONTRACTS', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_CONTRACTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_PRODUCTS', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_QUOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'LBL_TIMEPERIODS', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_TIMEPERIOD_ID', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'TPL_RLI_CREATE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'TPL_RLI_CREATE', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'TPL_RLI_CREATE_LINK_TEXT', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_PRODUCTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_TOTAL_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CLOSED_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CLOSED_WON_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'NOTICE_NO_DELETE_CLOSED_RLIS', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'NOTICE_NO_DELETE_CLOSED_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_RLI', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_INCLUDED_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_SERVICE_START_DATE_INVALID', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_QUOTE_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'LBL_OPPORTUNITY_ROLE', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_CONFIG_TITLE_OPPS_SETTINGS', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPS_CONFIG_VIEW_BY_LABEL', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPS_CONFIG_VIEW_BY_DATE_ROLLUP', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_OPPS_CONFIG_VIEW_BY_DATE_ROLLUP', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPS_CONFIG_ALERT', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPS_CONFIG_ALERT', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_OPPS_CONFIG_ALERT_TO_OPPS', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPS_CONFIG_ALERT_TO_OPPS', 'type' => 'plural', 'source' => 'Forecasts'],
            ['name' => 'LBL_OPPS_CONFIG_ALERT_TO_OPPS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_OPPS_CONFIG_SALES_STAGE_1a', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_OPPS_CONFIG_SALES_STAGE_1b', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPS_CONFIG_SALES_STAGE_2a', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_OPPS_CONFIG_SALES_STAGE_2b', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPS_CONFIG_SALES_STAGE_3a', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_OPPS_CONFIG_SALES_STAGE_3b', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_HELP_CONFIG_OPPS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_HELP_CONFIG_OPPS', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_HELP_CONFIG_RLIS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_HELP_CONFIG_RLIS', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_OPPORTUNITIES_LIST_DASHBOARD', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITIES_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITIES_MULTI_LINE_DASHBOARD', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_RENEWAL_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_RENEWAL_PARENT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_RENEWAL_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITIES_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_CASCADE_RLI_EDIT', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CASCADE_RLI_CREATE', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CASCADE_SERVICE_WARNING', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CASCADE_DURATION_WARNING', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_AI_OPPORTUNITY_CLOSE_PREDICTION_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_AI_OPPORTUNITY_CLOSE_PREDICTION_DESC', 'type' => 'singular', 'source' => 'Opportunities'],
        ],
        'OutboundEmail' => [
            ['name' => 'LBL_MODULE_NAME', 'type' => 'singular', 'source' => 'OutboundEmail'],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'OutboundEmail'],
            [
                'name' => 'LBL_OUTBOUND_EMAILS_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'OutboundEmail',
            ],
        ],
        'PdfManager' => [
            ['name' => 'LBL_TPL_RLI', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_TPL_QUOTE_SERVICES_NAME', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_TPL_QUOTE_SERVICES_DESCRIPTION', 'type' => 'singular', 'source' => 'Quotes'],
        ],
        'pmse_Business_Rules' => [
            [
                'name' => 'LBL_PMSE_BUSINESS_RULES_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'pmse_Business_Rules',
            ],
            [
                'name' => 'LBL_PMSE_BUSINESS_RULES_RECORD_DASHBOARD',
                'type' => 'plural',
                'source' => 'pmse_Business_Rules',
            ],
        ],
        'pmse_Emails_Templates' => [
            [
                'name' => 'LBL_PMSE_EMAILS_TEMPLATES_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'pmse_Emails_Templates',
            ],
            [
                'name' => 'LBL_PMSE_EMAILS_TEMPLATES_RECORD_DASHBOARD',
                'type' => 'plural',
                'source' => 'pmse_Emails_Templates',
            ],
        ],
        'pmse_Inbox' => [
            ['name' => 'LBL_PMSE_INBOX_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'pmse_Inbox'],
            ['name' => 'LBL_PMSE_INBOX_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'pmse_Inbox',],
        ],
        'pmse_Project' => [
            ['name' => 'LBL_PMSE_PROJECT_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'pmse_Project'],
            ['name' => 'LBL_PMSE_PROJECT_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'pmse_Project',],
        ],
        'ProductBundles' => [
            ['name' => 'LBL_QUOTE_BUNDLE_POSITION', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'EXCEPTION_INVALID_QUOTE_ID', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'EXCEPTION_NOT_FOUND_QUOTE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CREATE_QLI_BUTTON_LABEL', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_CREATE_QLI_BUTTON_TOOLTIP', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_QUOTE_DATA_EMPTY_ROW_DEFAULT_GROUP', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE_BUNDLE_DEFAULT_GROUP', 'type' => 'singular', 'source' => 'ProductBundles'],
            ['name' => 'LBL_QUOTE_BUNDLE_DEFAULT_GROUP', 'type' => 'singular', 'source' => 'Quotes'],
        ],
        'ProductCategories' => [
            ['name' => 'LNK_NEW_PRODUCT', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LNK_PRODUCT_LIST', 'type' => 'plural', 'source' => 'ProductTemplates'],
        ],
        'ProductTypes' => [
            ['name' => 'LNK_NEW_PRODUCT', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LNK_PRODUCT_LIST', 'type' => 'plural', 'source' => 'ProductTemplates'],
        ],
        'ProductTemplates' => [
            ['name' => 'LBL_PRODUCT_ID', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LNK_NEW_PRODUCT', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LNK_PRODUCT_LIST', 'type' => 'plural', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_TEMPLATES', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            [
                'name' => 'LBL_PRODUCT_TEMPLATES_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'ProductTemplates',
            ],
            ['name' => 'LBL_PRODUCT_TEMPLATE_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'ProductTemplates',],
        ],
        'Products' => [
            ['name' => 'LBL_ACCOUNT_ID', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_ID', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTRACTS', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_LIST_NAME', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_NAME', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_QUOTE_ID', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_RELATED_PRODUCTS', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_PRODUCT_TEMPLATE', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_URL', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_REVENUELINEITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_REVENUELINEITEM_ID', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_REVENUELINEITEM', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_PRODUCTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_PRODUCTS_QUOTE_DATA_LIST', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_PRODUCTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_QUOTED_LINE_ITEMS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Products',],
        ],
        'ProjectTask' => [
            ['name' => 'LBL_PARENT_NAME', 'type' => 'singular', 'source' => 'Projects'],
            ['name' => 'LBL_PROJECT_ID', 'type' => 'singular', 'source' => 'Projects'],
            ['name' => 'LBL_PROJECT_NAME', 'type' => 'singular', 'source' => 'Projects'],
            ['name' => 'LBL_PROJECT_TASK_ID', 'type' => 'singular', 'source' => 'Projects'],
        ],
        'Project' => [
            ['name' => 'LBL_BUGS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Bugs'],
            ['name' => 'LBL_CONTACTS_RESOURCE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_PROJECT_HOLIDAYS_TITLE', 'type' => 'singular', 'source' => 'Projects'],
            ['name' => 'LBL_PROJECT_TASKS_SUBPANEL_TITLE', 'type' => 'singular', 'source' => 'Projects'],
        ],
        'ProspectLists' => [
            [
                'name' => 'LBL_PROSPECTS_LISTS_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'ProspectLists',
            ],
            ['name' => 'LBL_RELATED_ACCOUNTS', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_RELATED_CONTACTS', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_RELATED_LEADS_TARGETS', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'LBL_RELATED_LEADS_TARGETS', 'type' => 'plural', 'source' => 'Prospects'],
            ['name' => 'LBL_PROSPECT_LISTS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'ProspectLists',],
        ],
        'Prospects' => [
            ['name' => 'LBL_PROSPECTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Prospects'],
        ],
        'Purchases' => [
            ['name' => 'LBL_ACCOUNT_ID', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_PRODUCT_TYPE', 'type' => 'singular', 'source' => 'ProductTypes'],
            ['name' => 'LBL_PRODUCT_TEMPLATE_ID', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_TEMPLATE_NAME', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_TEMPLATES', 'type' => 'plural', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PURCHASED_LINE_ITEMS', 'type' => 'plural', 'source' => 'PurchasedLineItems'],
            ['name' => 'LBL_RELATED_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_PURCHASES_LIST_DASHBOARD', 'type' => 'plural', 'source' => 'Purchases'],
            ['name' => 'LBL_PURCHASES_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Purchases'],
            ['name' => 'LBL_PURCHASES_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Purchases'],
        ],
        'PurchasedLineItems' => [
            ['name' => 'LBL_CATEGORY_ID', 'type' => 'singular', 'source' => 'ProductCategories'],
            ['name' => 'LBL_CATEGORY_NAME', 'type' => 'singular', 'source' => 'ProductCategories'],
            ['name' => 'LBL_MANUFACTURER', 'type' => 'singular', 'source' => 'Manufacturers'],
            ['name' => 'LBL_MANUFACTURERS', 'type' => 'plural', 'source' => 'Manufacturers'],
            ['name' => 'LBL_MANUFACTURER_NAME', 'type' => 'singular', 'source' => 'Manufacturers'],
            ['name' => 'LBL_PRODUCT', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_PRODUCT_CATEGORIES', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_PRODUCT_TEMPLATE', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_TEMPLATES', 'type' => 'plural', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_TEMPLATE_ID', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_TYPE', 'type' => 'singular', 'source' => 'ProductTypes'],
            ['name' => 'LBL_PURCHASE', 'type' => 'singular', 'source' => 'Purchases'],
            ['name' => 'LBL_RLI', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_RLI_ID', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_RLI_NAME', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_NEW_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_EXISTING_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_PARENT_PURCHASE', 'type' => 'singular', 'source' => 'Purchases'],
            ['name' => 'LBL_PURCHASEDLINEITEMS_LIST_DASHBOARD', 'type' => 'plural', 'source' => 'PurchasedLineItems'],
            ['name' => 'LBL_PURCHASEDLINEITEMS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'PurchasedLineItems'],
            [
                'name' => 'LBL_PURCHASED_LINE_ITEMS_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'PurchasedLineItems',
            ],
        ],
        'Quotes' => [
            ['name' => 'LBL_ACCOUNT_ID', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CONTRACTS', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_QUOTE_NAME', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE_NUM', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE_STAGE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE_TYPE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_EMAIL_QUOTE_FOR', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_LIST_FORM_TITLE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_NAME', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_PDF_QUOTE_NUMBER', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_PDF_QUOTE_TITLE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_PROPOSAL', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_SALES_STAGE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_SEARCH_FORM_TITLE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTESETTINGS', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_PRODUCT_TEMPLATE', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_LIST_PRODUCT_NAME', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_REVENUELINEITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_QUOTES_NAME', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'EXCEPTION_QUOTE_ALREADY_CONVERTED', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'EXCEPTION_QUOTE_ALREADY_CONVERTED', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_QUOTE_HEADER_TOTALS', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE_DATA_GRAND_TOTALS_HEADER', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE_DATA_GRAND_TOTALS_FOOTER', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CREATE_QLI_BUTTON_LABEL', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_CREATE_QLI_BUTTON_TOOLTIP', 'type' => 'singular', 'source' => 'Products'],
            ['name' => 'LBL_SEARCH_CATALOG_PLACEHOLDER', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_NO_PRODUCT_CATALOG_RESULTS', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_CATALOG_NAME', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_CATALOG_DASHLET_NAME', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_CATALOG_DESC', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_CATALOG_DASHLET_DESC', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_QUOTE_COPY_ALERT_MESSAGE', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_QUOTE_COPY_ALERT_MESSAGE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE_COPY_ALERT_MESSAGE_LONG_TIME', 'type' => 'plural', 'source' => 'Products'],
            ['name' => 'LBL_QUOTE_COPY_ALERT_MESSAGE_LONG_TIME', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_HELP_MORE_INFO', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'LBL_CONFIG_TITLE_MODULE_SETTINGS', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTES_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'TPL_ACTIVITY_TIMELINE_DASHLET', 'type' => 'singular', 'source' => 'Quotes',],
            ['name' => 'LBL_QUOTES_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Quotes',],
            ['name' => 'LBL_QUOTES_CONVERSION_LOCK_CONFIRM', 'type' => 'plural', 'source' => 'Products',],
            ['name' => 'LBL_QUOTES_CONVERSION_LOCK_CONFIRM', 'type' => 'singular', 'source' => 'Quotes',],
            ['name' => 'LBL_QUOTES_CONVERSION_UNLOCK_CONFIRM', 'type' => 'plural', 'source' => 'Products',],
            ['name' => 'LBL_QUOTES_CONVERSION_UNLOCK_CONFIRM', 'type' => 'singular', 'source' => 'Quotes',],
            ['name' => 'LBL_QUOTES_CONVERSION_LOCK_MASSUPDATE_CONFIRM', 'type' => 'plural', 'source' => 'Products',],
            ['name' => 'LBL_QUOTES_CONVERSION_LOCK_MASSUPDATE_CONFIRM', 'type' => 'plural', 'source' => 'Quotes',],
            ['name' => 'LBL_QUOTES_CONVERSION_UNLOCK_MASSUPDATE_CONFIRM', 'type' => 'plural', 'source' => 'Products',],
            ['name' => 'LBL_QUOTES_CONVERSION_UNLOCK_MASSUPDATE_CONFIRM', 'type' => 'plural', 'source' => 'Quotes',],
        ],
        'Quotas' => [
            ['name' => 'LNK_FORECAST_LIST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_FORECAST_HISTORY', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LNK_UPD_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_MODULE_FORECASTS_NAME', 'type' => 'plural', 'source' => 'Forecasts'],
        ],
        'RevenueLineItems' => [
            ['name' => 'LBL_CAMPAIGN_PRODUCT', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_RELATED_PRODUCTS', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_LEAD_SOURCE', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_LIST_NAME', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_LIST_OPPORTUNITY_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_LIST_QUOTE_NAME', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_LIST_PRODUCT_TEMPLATE', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_NAME', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_ASSOCIATED_QUOTE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CURRENCY', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_ID', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_NAME', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_SYMBOL', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_DEFAULT_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_ACCOUNT_ID', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CONTACT_ID', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_DOCUMENTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Documents'],
            ['name' => 'LBL_CONTRACTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_QUOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Quotes'],
            ['name' => 'LBL_LEADS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'LBL_CONTACTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTRACTS', 'type' => 'plural', 'source' => 'Contracts'],
            ['name' => 'LBL_PRODUCT_TEMPLATES', 'type' => 'plural', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_CATEGORIES', 'type' => 'plural', 'source' => 'ProductCategories'],
            ['name' => 'LBL_PRODUCT_TYPES', 'type' => 'plural', 'source' => 'ProductTypes'],
            ['name' => 'LBL_PRODUCT_TEMPLATE', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_PRODUCT_TEMPLATE_ID', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_QUOTE_ID', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_QUOTE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_OPPORTUNITY_ID', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_CALCULATED_LINE_ITEM_AMOUNT', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CURRENCY_SYMBOL_NAME', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_RLI_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_EXPORT_CURRENCY_ID', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_RATE', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_COMMIT_STAGE_FORECAST', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_CONVERT_TO_QUOTE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CONVERT_TO_QUOTE_INFO_MESSAGE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CONVERT_TO_QUOTE_INFO_MESSAGE', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONVERT_INVALID_RLI', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONVERT_INVALID_RLI', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CONVERT_INVALID_RLI_PRODUCT', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONVERT_INVALID_RLI_PRODUCT', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CONVERT_INVALID_RLI_PRODUCT_PLURAL', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONVERT_INVALID_RLI_PRODUCT_PLURAL', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CONVERT_INVALID_RLI_ALREADYQUOTED_PLURAL', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONVERT_TO_QUOTE_ERROR_MESSAGE', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONVERT_TO_QUOTE_ERROR_MESSAGE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'SAVE_RLI_QUOTE_NOTICE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'WARNING_MERGE_RLIS_WITH_DIFFERENT_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_CONVERT_RLI_TO_QUOTE', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CONVERT_RLI_TO_QUOTE', 'type' => 'singular', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONVERT_INVALID_RLI_ALREADYQUOTED', 'type' => 'singular',
                'source' => 'RevenueLineItems'],
            ['name' => 'LBL_GENERATE_PURCHASE', 'type' => 'singular', 'source' => 'Purchases'],
            ['name' => 'LBL_PURCHASED_LINE_ITEM', 'type' => 'singular', 'source' => 'PurchasedLineItem'],
            [
                'name' => 'LBL_REVENUE_LINE_ITEMS_FOCUS_DRAWER_DASHBOARD',
                'type' => 'plural',
                'source' => 'RevenueLineItems',
            ],
            ['name' => 'LBL_REVENUE_LINE_ITEMS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'RevenueLineItems',],
            ['name' => 'LBL_REVENUE_LINE_ITEMS_LIST_DASHBOARD', 'type' => 'plural', 'source' => 'RevenueLineItems',],
        ],
        'Reports' => [
            ['name' => 'LNK_NEW_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LNK_NEW_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LNK_NEW_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LNK_NEW_CASE', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LNK_NEW_NOTE', 'type' => 'singular', 'source' => 'Notes'],
            ['name' => 'LNK_NEW_CALL', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LNK_NEW_EMAIL', 'type' => 'singular', 'source' => 'Emails'],
            ['name' => 'LNK_NEW_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LNK_NEW_TASK', 'type' => 'singular', 'source' => 'Tasks'],
            ['name' => 'LBL_ACCOUNTS', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'LBL_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_REVENUELINEITEMS', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CONTACTS', 'type' => 'plural', 'source' => 'Contacts'],
            ['name' => 'LBL_LEADS', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'LBL_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_LEAD', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_ACCOUNT_REPORTS', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CONTACT_REPORTS', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_OPPORTUNITY_REPORTS', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CASE_REPORTS', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_BUG_REPORTS', 'type' => 'singular', 'source' => 'Bugs'],
            ['name' => 'LBL_LEAD_REPORTS', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_QUOTE_REPORTS', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_CALL_REPORTS', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_MEETING_REPORTS', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_TASK_REPORTS', 'type' => 'singular', 'source' => 'Tasks'],
            ['name' => 'LBL_EMAIL_REPORTS', 'type' => 'singular', 'source' => 'Emails'],
            ['name' => 'LBL_MY_TEAM_ACCOUNT_REPORTS', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_MY_TEAM_OPPORTUNITY_REPORTS', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_MY_TEAM_CONTACT_REPORTS', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_MY_TEAM_CASE_REPORTS', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_MY_TEAM_BUG_REPORTS', 'type' => 'singular', 'source' => 'Bugs'],
            ['name' => 'LBL_MY_TEAM_LEAD_REPORTS', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_MY_TEAM_QUOTE_REPORTS', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_MY_TEAM_CALL_REPORTS', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_MY_TEAM_MEETING_REPORTS', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_MY_TEAM_TASK_REPORTS', 'type' => 'singular', 'source' => 'Tasks'],
            ['name' => 'LBL_MY_TEAM_EMAIL_REPORTS', 'type' => 'singular', 'source' => 'Emails'],
            ['name' => 'LBL_MY_TEAM_FORECAST_REPORTS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_MY_TEAM_PROSPECT_REPORTS', 'type' => 'singular', 'source' => 'Prospects'],
            ['name' => 'LBL_MY_TEAM_CONTRACT_REPORTS', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_MY_TEAM_PROJECT_TASK_REPORTS', 'type' => 'singular', 'source' => 'Projects'],
            ['name' => 'LBL_MY_ACCOUNT_REPORTS', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_MY_OPPORTUNITY_REPORTS', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_MY_CONTACT_REPORTS', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_MY_CASE_REPORTS', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_MY_BUG_REPORTS', 'type' => 'singular', 'source' => 'Bugs'],
            ['name' => 'LBL_MY_LEAD_REPORTS', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_MY_QUOTE_REPORTS', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_MY_CALL_REPORTS', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_MY_MEETING_REPORTS', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_MY_TASK_REPORTS', 'type' => 'singular', 'source' => 'Tasks'],
            ['name' => 'LBL_MY_EMAIL_REPORTS', 'type' => 'singular', 'source' => 'Emails'],
            ['name' => 'LBL_MY_FORECAST_REPORTS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_PUBLISHED_ACCOUNT_REPORTS', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_PUBLISHED_CONTACT_REPORTS', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_PUBLISHED_OPPORTUNITY_REPORTS', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_PUBLISHED_CASE_REPORTS', 'type' => 'singular', 'source' => 'Cases'],
            ['name' => 'LBL_PUBLISHED_BUG_REPORTS', 'type' => 'singular', 'source' => 'Bugs'],
            ['name' => 'LBL_PUBLISHED_LEAD_REPORTS', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_PUBLISHED_QUOTE_REPORTS', 'type' => 'singular', 'source' => 'Quotes'],
            ['name' => 'LBL_PUBLISHED_QUOTA_REPORTS', 'type' => 'singular', 'source' => 'Quotas'],
            ['name' => 'LBL_PUBLISHED_CALL_REPORTS', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'LBL_PUBLISHED_MEETING_REPORTS', 'type' => 'singular', 'source' => 'Meetings'],
            ['name' => 'LBL_PUBLISHED_TASK_REPORTS', 'type' => 'singular', 'source' => 'Tasks'],
            ['name' => 'LBL_PUBLISHED_EMAIL_REPORTS', 'type' => 'singular', 'source' => 'Emails'],
            ['name' => 'LBL_PUBLISHED_FORECAST_REPORTS', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'LBL_PUBLISHED_PROSPECT_REPORTS', 'type' => 'singular', 'source' => 'Prospects'],
            ['name' => 'LBL_TEAM', 'type' => 'singular', 'source' => 'Teams'],
            ['name' => 'LBL_CONTRACT_REPORTS', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_MY_CONTRACT_REPORTS', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'LBL_PUBLISHED_CONTRACT_REPORTS', 'type' => 'singular', 'source' => 'Contracts'],
            ['name' => 'DEFAULT_REPORT_TITLE_1', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'DEFAULT_REPORT_TITLE_2', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'DEFAULT_REPORT_TITLE_3', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'DEFAULT_REPORT_TITLE_4', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'DEFAULT_REPORT_TITLE_5', 'type' => 'singular', 'source' => 'Calls'],
            ['name' => 'DEFAULT_REPORT_TITLE_6', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_7', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'DEFAULT_REPORT_TITLE_8', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'DEFAULT_REPORT_TITLE_9', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'DEFAULT_REPORT_TITLE_10', 'type' => 'plural', 'source' => 'Cases'],
            ['name' => 'DEFAULT_REPORT_TITLE_17', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_13', 'type' => 'plural', 'source' => 'Tasks'],
            ['name' => 'DEFAULT_REPORT_TITLE_14', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'DEFAULT_REPORT_TITLE_15', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'DEFAULT_REPORT_TITLE_16', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'DEFAULT_REPORT_TITLE_18', 'type' => 'plural', 'source' => 'Leads'],
            ['name' => 'DEFAULT_REPORT_TITLE_43', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'DEFAULT_REPORT_TITLE_44', 'type' => 'plural', 'source' => 'Accounts'],
            ['name' => 'DEFAULT_REPORT_TITLE_45', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_46', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_47', 'type' => 'plural', 'source' => 'Calls'],
            ['name' => 'DEFAULT_REPORT_TITLE_48', 'type' => 'plural', 'source' => 'Meetings'],
            ['name' => 'DEFAULT_REPORT_TITLE_49', 'type' => 'plural', 'source' => 'Tasks'],
            ['name' => 'DEFAULT_REPORT_TITLE_50', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_51', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_52', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_53', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_56', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_57', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'DEFAULT_REPORT_TITLE_58', 'type' => 'singular', 'source' => 'Forecasts'],
            ['name' => 'DEFAULT_REPORT_TITLE_59', 'type' => 'plural', 'source' => 'Opportunities'],
            ['name' => 'LBL_REPORT_SCHEDULES_BUTTON_LABEL', 'type' => 'singular', 'source' => 'Reports'],
            ['name' => 'LBL_REPORT_SCHEDULES_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Reports'],
            ['name' => 'LBL_REPORT_DETAILS_BUTTON_LABEL', 'type' => 'singular', 'source' => 'Reports'],
            ['name' => 'LBL_REPORT_DETAILS_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Reports'],
            ['name' => 'LBL_REPORTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Reports'],
        ],
        'Shifts' => [
            ['name' => 'LBL_SHIFTS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Shifts'],
            ['name' => 'LBL_SHIFT_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Shifts',],
            ['name' => 'LBL_MY_SHIFTS', 'type' => 'plural', 'source' => 'Shifts',],
        ],
        'Tags' => [
            ['name' => 'LBL_TAGS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Tags'],
            ['name' => 'LBL_TAGS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Tags',],
            ['name' => 'LBL_MY_TAGS', 'type' => 'plural', 'source' => 'Tags',],
            ['name' => 'LBL_MY_FAVORITE_TAGS', 'type' => 'plural', 'source' => 'Tags',],
            ['name' => 'LBL_MORE_TAGS', 'type' => 'plural', 'source' => 'Tags',],
        ],
        'Targets' => [
            ['name' => 'LBL_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
            ['name' => 'LBL_CAMPAIGN_ID', 'type' => 'plural', 'source' => 'Campaigns'],
            ['name' => 'LBL_CAMPAIGN_LIST_SUBPANEL_TITLE', 'type' => 'singular', 'source' => 'Campaigns'],
            ['name' => 'LBL_PROSPECT_LIST', 'type' => 'singular', 'source' => 'Prospects'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_LEAD', 'type' => 'singular', 'source' => 'Leads'],
            ['name' => 'LBL_TARGETS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Targets',],
        ],
        'Tasks' => [
            ['name' => 'LBL_TASK', 'type' => 'plural', 'source' => 'Tasks'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'Tasks'],
            ['name' => 'LBL_LIST_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'ERR_DELETE_RECORD', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_FIRST_NAME', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_LAST_NAME', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_ID', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_CONTACT_PHONE', 'type' => 'singular', 'source' => 'Contacts'],
            ['name' => 'LBL_HISTORY_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_TASK_CLOSE_SUCCESS', 'type' => 'singular', 'source' => 'Tasks'],
            ['name' => 'LBL_NOTES_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Notes'],
            ['name' => 'LBL_RELATED_CONTACT', 'type' => 'singular', 'source' => 'Contacts',],
            ['name' => 'LBL_TASKS_FOCUS_DRAWER_DASHBOARD', 'type' => 'plural', 'source' => 'Tasks'],
            ['name' => 'LBL_TASKS_RECORD_DASHBOARD', 'type' => 'plural', 'source' => 'Tasks',],
        ],
        'TimePeriods' => [
            ['name' => 'LBL_TP_TYPE', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'TimePeriods'],
            ['name' => 'LBL_SEARCH_TP_NAME', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'ERR_TIME_PERIOD_DATE_RANGE', 'type' => 'singular', 'source' => 'TimePeriods'],
            ['name' => 'LBL_LIST_WARNING', 'type' => 'singular', 'source' => 'TimePeriods'],
        ],
        'Users' => [
            ['name' => 'LBL_CURRENCY_CREATE_IN_PREFERRED', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CURRENCY_CREATE_IN_PREFERRED', 'type' => 'singular', 'source' => 'Currencies'],
            ['name' => 'LBL_CURRENCY_CREATE_IN_PREFERRED_TEXT', 'type' => 'plural', 'source' => 'RevenueLineItems'],
            ['name' => 'LBL_CURRENCY_CREATE_IN_PREFERRED_TEXT', 'type' => 'singular', 'source' => 'Opportunities'],
            ['name' => 'LBL_CURRENCY_CREATE_IN_PREFERRED_TEXT', 'type' => 'singular', 'source' => 'ProductTemplates'],
            ['name' => 'LBL_CURRENCY_CREATE_IN_PREFERRED_TEXT', 'type' => 'plural', 'source' => 'Currencies'],
            ['name' => 'LBL_FAVORITE_REPORTS', 'type' => 'plural', 'source' => 'Reports'],
        ],
        'DRI_Workflows' => [
            ['name' => 'LBL_LEAD', 'type' => 'singular', 'source' => 'Leads',],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_CURRENT_ACTIVITY_MEETING', 'type' => 'singular', 'source' => 'Meetings',],
            ['name' => 'LBL_CURRENT_ACTIVITY_CALL', 'type' => 'singular', 'source' => 'Calls',],
            ['name' => 'LBL_CURRENT_ACTIVITY_TASK', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_NO_RELATED_WORKFLOWS', 'type' => 'plural', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_NO_ACTIVE_WORKFLOWS_TITLE', 'type' => 'plural', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_LOADING_WORKFLOW', 'type' => 'singular', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'singular', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_MODULE_NAME', 'type' => 'plural', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_MODULE_ID', 'type' => 'plural', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_NEW_FORM_TITLE', 'type' => 'singular', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_NO_RELATED_WORKFLOWS', 'type' => 'plural', 'source' => 'DRI_Workflows',],
            ['name' => 'LNK_LIST', 'type' => 'plural', 'source' => 'DRI_Workflows',],
            ['name' => 'LNK_DRI_WORKFLOW_LIST', 'type' => 'plural', 'source' => 'DRI_Workflows',],
            ['name' => 'LNK_NEW_RECORD', 'type' => 'singular', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_LOADING_WORKFLOW', 'type' => 'singular', 'source' => 'DRI_Workflows',],
            ['name' => 'LBL_CONFIG_USERS', 'type' => 'plural', 'source' => 'Users',],
            ['name' => 'LBL_CONFIG_USERS_DESCRIPTION', 'type' => 'plural', 'source' => 'Users',],
            ['name' => 'LBL_CONFIG_ADD_USERS', 'type' => 'plural', 'source' => 'Users',],
            ['name' => 'LNK_VIEW_RECORDS', 'type' => 'plural', 'source' => 'DRI_Workflows',],
        ],
        'DRI_Workflow_Task_Templates' => [
            ['name' => 'LBL_SMART_GUIDE_ACTIVITY_TYPE', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_SMART_GUIDE_ACTIVITY_TYPE', 'type' => 'singular', 'source' => 'Calls',],
            ['name' => 'LBL_SMART_GUIDE_ACTIVITY_TYPE', 'type' => 'singular', 'source' => 'Meetings',],
            ['name' => 'LBL_SMART_GUIDE_PRIORITY', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_TYPE', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_ADD_SUB_TASK_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_ADD_SUB_MEETING_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Meetings',],
            ['name' => 'LBL_ADD_SUB_CALL_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Calls',],
            ['name' => 'LNK_VIEW_RECORDS', 'type' => 'plural', 'source' => 'DRI_Workflow_Task_Templates',],
            ['name' => 'LNK_DRI_WORKFLOW_TASK_TEMPLATE_LIST', 'type' => 'plural', 'source' => 'DRI_Workflow_Task_Templates',],
        ],
        'DRI_SubWorkflow_Templates' => [
            ['name' => 'LBL_ADD_TASK_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_ADD_MEETING_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Meetings',],
            ['name' => 'LBL_ADD_CALL_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Calls',],
            ['name' => 'LBL_MODULE_NAME', 'type' => 'singular', 'source' => 'DRI_SubWorkflow_Templates',],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'DRI_SubWorkflow_Templates',],
            ['name' => 'LNK_LIST', 'type' => 'plural', 'source' => 'DRI_SubWorkflow_Templates',],
            ['name' => 'LNK_NEW_RECORD', 'type' => 'plural', 'source' => 'DRI_SubWorkflow_Templates',],
            ['name' => 'LNK_VIEW_RECORDS', 'type' => 'plural', 'source' => 'DRI_SubWorkflow_Templates',],
            ['name' => 'LNK_DRI_SUBWORKFLOW_TEMPLATE_LIST', 'type' => 'plural', 'source' => 'DRI_SubWorkflow_Templates',],
        ],
        'DRI_SubWorkflows' => [
            ['name' => 'LBL_ADD_TASK_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_ADD_MEETING_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Meetings',],
            ['name' => 'LBL_ADD_CALL_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Calls',],
            ['name' => 'LBL_ADD_CALL_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Calls',],
            ['name' => 'LNK_VIEW_RECORDS', 'type' => 'plural', 'source' => 'DRI_SubWorkflows',],
            ['name' => 'LNK_DRI_SUBWORKFLOW_LIST', 'type' => 'plural', 'source' => 'DRI_SubWorkflows',],
        ],
        'DRI_Workflow_Templates' => [
            ['name' => 'LBL_ADD_TASK_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Tasks',],
            ['name' => 'LBL_ADD_MEETING_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Meetings',],
            ['name' => 'LBL_ADD_CALL_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Calls',],
            ['name' => 'LNK_VIEW_RECORDS', 'type' => 'plural', 'source' => 'DRI_Workflow_Templates',],
            ['name' => 'LNK_IMPORT_CUSTOMER_JOURNEY_TEMPLATES', 'type' => 'plural', 'source' => 'DRI_Workflow_Templates',],
            ['name' => 'LNK_DRI_WORKFLOW_TEMPLATE_LIST', 'type' => 'plural', 'source' => 'DRI_Workflow_Templates',],
        ],
        'CJ_Forms' => [
            ['name' => 'LBL_LIST_FORM_TITLE', 'type' => 'plural', 'source' => 'CJ_Forms',],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'CJ_Forms',],
            ['name' => 'LBL_HOMEPAGE_TITLE', 'type' => 'plural', 'source' => 'CJ_Forms',],
            ['name' => 'LNK_VIEW_RECORDS', 'type' => 'plural', 'source' => 'CJ_Forms',],
            ['name' => 'LNK_CJ_FORM_LIST', 'type' => 'plural', 'source' => 'CJ_Forms',],
            ['name' => 'LNK_LIST', 'type' => 'plural', 'source' => 'CJ_Forms',],
            ['name' => 'LBL_MODULE_NAME', 'type' => 'plural', 'source' => 'CJ_Forms',],
            ['name' => 'LNK_NEW_RECORD', 'type' => 'singular', 'source' => 'CJ_Forms',],
            ['name' => 'LBL_SEARCH_FORM_TITLE', 'type' => 'singular', 'source' => 'CJ_Forms',],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'CJ_Forms',],
        ],
        'CJ_WebHooks' => [
            ['name' => 'LBL_LIST_FORM_TITLE', 'type' => 'plural', 'source' => 'CJ_WebHooks',],
            ['name' => 'LBL_MODULE_TITLE', 'type' => 'plural', 'source' => 'CJ_WebHooks',],
            ['name' => 'LBL_HOMEPAGE_TITLE', 'type' => 'plural', 'source' => 'CJ_WebHooks',],
            ['name' => 'LNK_VIEW_RECORDS', 'type' => 'plural', 'source' => 'CJ_WebHooks',],
            ['name' => 'LNK_CJ_WEBHOOK_LIST', 'type' => 'plural', 'source' => 'CJ_WebHooks',],
            ['name' => 'LNK_LIST', 'type' => 'plural', 'source' => 'CJ_WebHooks',],
            ['name' => 'LBL_MODULE_NAME', 'type' => 'plural', 'source' => 'CJ_WebHooks',],
            ['name' => 'LNK_NEW_RECORD', 'type' => 'singular', 'source' => 'CJ_WebHooks',],
            ['name' => 'LBL_SEARCH_FORM_TITLE', 'type' => 'singular', 'source' => 'CJ_WebHooks',],
            ['name' => 'LBL_MODULE_NAME_SINGULAR', 'type' => 'singular', 'source' => 'CJ_WebHooks',],
        ],
        'DRI_Workflow_Task_Templates' => [
            ['name' => 'CJ_FORMS_LBL_PARENT_NAME', 'type' => 'singular', 'source' => 'DRI_Workflow_Task_Templates',],
        ],
        'DRI_SubWorkflow_Templates' => [
            ['name' => 'CJ_FORMS_LBL_PARENT_NAME', 'type' => 'singular', 'source' => 'DRI_SubWorkflow_Templates',],
        ],
        'DRI_Workflow_Templates' => [
            ['name' => 'CJ_FORMS_LBL_PARENT_NAME', 'type' => 'singular', 'source' => 'DRI_Workflow_Templates',],
        ],
        'PubSub_ModuleEvent_PushSubs' => [
            [
                'name' => 'LBL_MODULE_NAME',
                'type' => 'singular',
                'source' => 'PubSub_ModuleEvent_PushSubs',
            ],
            [
                'name' => 'LBL_MODULE_NAME_SINGULAR',
                'type' => 'singular',
                'source' => 'PubSub_ModuleEvent_PushSubs',
            ],
        ],
    ],
    'global' => [
        // Accounts
        ['name' => 'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_OLD_ACCOUNT_LINK', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_ACCOUNTS', 'type' => 'plural', 'source' => 'Accounts'],
        ['name' => 'LBL_BILL_TO_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_LIST_ACCOUNT_NAME', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_SHIP_TO_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_DASHLET_OPPORTUNITY_DESCRIPTION', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT', 'type' => 'singular', 'source' => 'Accounts'],

        // Calls
        ['name' => 'LBL_CALLS', 'type' => 'plural', 'source' => 'Calls'],
        ['name' => 'LBL_CALL', 'type' => 'singular', 'source' => 'Calls'],
        ['name' => 'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG', 'type' => 'singular', 'source' => 'Calls'],
        ['name' => 'LBL_SCHEDULE_CALL', 'type' => 'singular', 'source' => 'Calls'],
        ['name' => 'LBL_CALLS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Calls'],
        ['name' => 'LBL_MOBILE_LOG_CALL_CONFIRM', 'type' => 'singular', 'source' => 'Calls'],
        ['name' => 'LBL_HISTORY_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Calls'],
        ['name' => 'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Calls'],

        // Campaigns
        ['name' => 'LBL_CAMPAIGNS_SEND_QUEUED', 'type' => 'singular', 'source' => 'Campaigns'],
        ['name' => 'LBL_CAMPAIGN', 'type' => 'singular', 'source' => 'Campaigns'],
        ['name' => 'LBL_CAMPAIGNS', 'type' => 'plural', 'source' => 'Campaigns'],
        ['name' => 'LBL_CAMPAIGN_CONTACT', 'type' => 'plural', 'source' => 'Campaigns'],
        ['name' => 'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE', 'type' => 'singular', 'source' => 'Campaigns'],
        ['name' => 'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL', 'type' => 'singular', 'source' => 'Campaigns'],
        ['name' => 'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE', 'type' => 'singular', 'source' => 'Campaigns'],
        ['name' => 'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL', 'type' => 'singular', 'source' => 'Campaigns'],
        ['name' => 'LBL_RELATED_CAMPAIGN', 'type' => 'singular', 'source' => 'Campaigns'],

        // Cases
        ['name' => 'LBL_EMAIL_QC_CASES', 'type' => 'singular', 'source' => 'Cases'],
        ['name' => 'LBL_CASE', 'type' => 'singular', 'source' => 'Cases'],
        ['name' => 'LBL_CASES', 'type' => 'plural', 'source' => 'Cases'],
        ['name' => 'LBL_CREATE_CASE', 'type' => 'singular', 'source' => 'Cases'],
        ['name' => 'LBL_DASHLET_CASES_SUMMARY_NAME', 'type' => 'singular', 'source' => 'Cases'],
        ['name' => 'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES', 'type' => 'plural', 'source' => 'Cases'],
        ['name' => 'LBL_DASHLET_CASESSUMMARY_OPEN_CASES', 'type' => 'plural', 'source' => 'Cases'],
        ['name' => 'LBL_CREATE_CASE', 'type' => 'singular', 'source' => 'Cases'],
        ['name' => 'LBL_PORTAL_MIN_MODULES', 'type' => 'plural', 'source' => 'Cases'],
        ['name' => 'LBL_CASE_SUMMARY_CHART', 'type' => 'singular', 'source' => 'Cases'],
        ['name' => 'LBL_CASE_SUMMARY_CHART_DESC', 'type' => 'plural', 'source' => 'Cases'],

        // Contacts
        ['name' => 'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS', 'type' => 'plural', 'source' => 'Contacts'],
        ['name' => 'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS', 'type' => 'plural', 'source' => 'Contacts'],
        ['name' => 'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS', 'type' => 'plural', 'source' => 'Contacts'],
        ['name' => 'LBL_EMAIL_QC_CONTACTS', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_BILL_TO_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_CONTACT_LIST', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_CONTACTS', 'type' => 'plural', 'source' => 'Contacts'],
        ['name' => 'LBL_LIST_CONTACT_NAME', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_LIST_CONTACT_ROLE', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_SELECT_CONTACT_BUTTON_LABEL', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_SELECT_CONTACT_BUTTON_TITLE', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_SHIP_TO_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_CREATE_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],
        ['name' => 'LBL_RELATED_CONTACT', 'type' => 'singular', 'source' => 'Contacts'],

        // Contracts
        ['name' => 'LBL_CONTRACTS', 'type' => 'plural', 'source' => 'Contracts'],

        // Documents
        ['name' => 'LBL_EMAIL_ATTACHMENTS2', 'type' => 'plural', 'source' => 'Documents'],
        ['name' => 'LBL_EMAIL_ATTACHMENTS_DOCUMENT', 'type' => 'singular', 'source' => 'Documents'],
        ['name' => 'LBL_ADD_DOCUMENT', 'type' => 'singular', 'source' => 'Documents'],
        ['name' => 'LBL_DOCUMENTS', 'type' => 'plural', 'source' => 'Documents'],
        ['name' => 'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL', 'type' => 'plural', 'source' => 'Documents'],
        ['name' => 'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE', 'type' => 'plural', 'source' => 'Documents'],
        ['name' => 'ERR_NO_DOCS', 'type' => 'plural', 'source' => 'Documents'],
        ['name' => 'LBL_MOBILE_DOC', 'type' => 'singular', 'source' => 'Documents'],

        // Emails
        ['name' => 'LBL_EMAILS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Emails'],
        ['name' => 'LBL_HISTORY_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Emails'],
        ['name' => 'LBL_HISTORY_DASHLET_EMAIL_SINGULAR', 'type' => 'singular', 'source' => 'Emails'],
        ['name' => 'LBL_HISTORY_DASHLET_EMAIL_PLURAL', 'type' => 'plural', 'source' => 'Emails'],

        // Email Participants
        ['name' => 'LBL_EMAIL_PARTICIPANTS', 'type' => 'plural', 'source' => 'EmailParticipants'],
        ['name' => 'LBL_EMAIL_PARTICIPANT', 'type' => 'singular', 'source' => 'EmailParticipants'],

        // Forecasts
        ['name' => 'LBL_TOUR_SCREEN_2_DESCRIPTION_670', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_TOUR_SCREEN_2_DESCRIPTION_670', 'type' => 'plural', 'source' => 'TimePeriods'],
        ['name' => 'LBL_TOUR_SCREEN_2_DESCRIPTION_670', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_TOUR_SCREEN_3_DESCRIPTION_670', 'type' => 'singular', 'source' => 'TimePeriods'],
        ['name' => 'LBL_TOUR_SCREEN_3_DESCRIPTION_670', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_TOUR_SCREEN_4_DESCRIPTION_670', 'type' => 'singular', 'source' => 'Quotas'],
        ['name' => 'LBL_TOUR_SCREEN_5_DESCRIPTION_670', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_TOUR_SCREEN_5_DESCRIPTION_670', 'type' => 'singular', 'source' => 'TimePeriods'],
        ['name' => 'LBL_TOUR_SCREEN_6_DESCRIPTION_670', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_TOUR_SCREEN_6_DESCRIPTION_670', 'type' => 'singular', 'source' => 'Quotas'],
        ['name' => 'LBL_TOUR_FORECAST_INTRO', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_TOUR_FORECASTS_TIMEPERIODS', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_TOUR_FORECASTS_PROGRESS', 'type' => 'singular', 'source' => 'Quotas'],
        ['name' => 'LBL_TOUR_FORECASTS_CHART', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_DASHLET_FORECAST_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_DASHLET_FORECASTS_CHART_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_DASHLET_FORECASTS_FOR_CHART_NAME', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_DASHLET_FORECASTS_CHART_DESC', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_DASHLET_FORECASTS_DETAILS_DESC', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_FORECAST_WORKSHEETS', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_FORECAST_WORKSHEET', 'type' => 'singular', 'source' => 'Forecasts'],
        ['name' => 'LBL_TOUR_FEATURES_670', 'type' => 'plural', 'source' => 'Forecasts'],
        ['name' => 'LBL_DASHLET_FORECASTS_DETAILS', 'type' => 'plural', 'source' => 'Forecasts'],
        ['name' => 'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS', 'type' => 'singular', 'source' => 'RevenueLineItems'],

        // Leads
        ['name' => 'LBL_HELP_PREVIEW', 'type' => 'plural', 'source' => 'Leads'],
        ['name' => 'LBL_LEAD', 'type' => 'singular', 'source' => 'Leads'],

        // Meetings
        ['name' => 'LBL_MEETINGS', 'type' => 'plural', 'source' => 'Meetings'],
        ['name' => 'LBL_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
        ['name' => 'LBL_MEETING_GO_BACK', 'type' => 'singular', 'source' => 'Meetings'],
        ['name' => 'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG', 'type' => 'singular', 'source' => 'Meetings'],
        ['name' => 'LBL_SCHEDULE_MEETING', 'type' => 'singular', 'source' => 'Meetings'],
        ['name' => 'LBL_MEETINGS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Meetings'],
        ['name' => 'LBL_HISTORY_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Meetings'],
        ['name' => 'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Meetings'],

        // Notes
        ['name' => 'LBL_CREATE_NOTE', 'type' => 'singular', 'source' => 'Notes'],
        ['name' => 'LBL_DASHLET_ATTACHMENTS_NAME', 'type' => 'plural', 'source' => 'Notes'],
        ['name' => 'LBL_DASHLET_ATTACHMENTS_DESCRIPTION', 'type' => 'plural', 'source' => 'Notes'],

        // Outbound Email
        ['name' => 'LBL_OUTBOUND_EMAIL', 'type' => 'plural', 'source' => 'OutboundEmail'],
        ['name' => 'LBL_OUTBOUND_EMAIL', 'type' => 'singular', 'source' => 'OutboundEmail'],

        // Opportunities
        ['name' => 'ERR_OPPORTUNITY_NAME_DUPE', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'ERR_OPPORTUNITY_NAME_MISSING', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_OPPORTUNITIES', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_TOUR_SCREEN_2_DESCRIPTION_670', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_TOUR_SCREEN_6_DESCRIPTION_670', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_OPPORTUNITY_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_EMAIL_QC_OPPORTUNITIES', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_OPPORTUNITY_METRICS', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_CREATE_OPPORTUNITY', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_DASHLET_OPPORTUNITY_NAME', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_DASHLET_OPPORTUNITY_DESCRIPTION', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'ERR_QUOTE_CONVERTED', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_QUOTE_TO_OPPORTUNITY_LABEL', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_QUOTE_TO_OPPORTUNITY_TITLE', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_QUOTE_TO_OPPORTUNITY_STATUS', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'ERR_OPPORTUNITY_NAME_DUPE', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'ERR_OPPORTUNITY_NAME_MISSING', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'ERR_QUOTE_CONVERTED', 'type' => 'singular', 'source' => 'Opportunities'],

        // Products
        ['name' => 'LBL_PRODUCTS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Products'],

        // Quotes
        ['name' => 'ERR_QUOTE_CONVERTED', 'type' => 'singular', 'source' => 'Quotes'],
        ['name' => 'LBL_QUOTE_TO_OPPORTUNITY_LABEL', 'type' => 'singular', 'source' => 'Quotes'],
        ['name' => 'LBL_QUOTE_TO_OPPORTUNITY_TITLE', 'type' => 'singular', 'source' => 'Quotes'],
        ['name' => 'LBL_QUOTE_TO_OPPORTUNITY_STATUS', 'type' => 'singular', 'source' => 'Quotes'],
        ['name' => 'LBL_GENERATE_QUOTE', 'type' => 'singular', 'source' => 'Quotes'],
        ['name' => 'LBL_QUOTES_SHIP_TO', 'type' => 'plural', 'source' => 'Quotes'],
        ['name' => 'LBL_QUOTES', 'type' => 'plural', 'source' => 'Quotes'],
        ['name' => 'LBL_QUOTES_BILL_TO', 'type' => 'plural', 'source' => 'Quotes'],

        // Revenue Line Item(s)
        ['name' => 'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_TOP10_OPPORTUNITIES_CHART_DESC', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_TOP10_OPPORTUNITIES_MY_OPP', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP', 'type' => 'plural', 'source' => 'RevenueLineItems'],

        // Tasks
        ['name' => 'LBL_EMAIL_QC_TASKS', 'type' => 'singular', 'source' => 'Tasks'],
        ['name' => 'LBL_PROJECT_TASKS', 'type' => 'plural', 'source' => 'Tasks'],
        ['name' => 'LBL_TASKS', 'type' => 'plural', 'source' => 'Tasks'],
        ['name' => 'LBL_CREATE_TASK', 'type' => 'singular', 'source' => 'Tasks'],
        ['name' => 'LBL_TASKS_SUBPANEL_TITLE', 'type' => 'plural', 'source' => 'Tasks'],
        ['name' => 'LBL_ACTIVE_TASKS_DASHLET', 'type' => 'plural', 'source' => 'Tasks'],
        ['name' => 'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Tasks'],
        ['name' => 'LBL_INACTIVE_TASKS_DASHLET', 'type' => 'plural', 'source' => 'Tasks'],
        ['name' => 'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Tasks'],

        // Time Periods
        ['name' => 'ERR_TIMEPERIOD_ALREADY_LEAF', 'type' => 'plural', 'source' => 'TimePeriods'],
        ['name' => 'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST', 'type' => 'plural', 'source' => 'TimePeriods'],
        ['name' => 'LBL_CURRENT_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
        ['name' => 'LBL_PREVIOUS_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
        ['name' => 'LBL_NEXT_TIMEPERIOD', 'type' => 'singular', 'source' => 'TimePeriods'],
        ['name' => 'LBL_TOUR_FORECASTS_TIMEPERIODS', 'type' => 'singular', 'source' => 'TimePeriods'],

        // Job Notifications
        ['name' => 'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY', 'type' => 'plural', 'source' => 'RevenueLineItems'],
        ['name' => 'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY', 'type' => 'singular', 'source' => 'RevenueLineItems'],

        ['name' => 'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY', 'type' => 'singular', 'source' => 'Opportunities'],
        ['name' => 'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY', 'type' => 'plural', 'source' => 'Opportunities'],
        ['name' => 'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT', 'type' => 'plural', 'source' => 'Opportunities'],

        ['name' => 'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT', 'type' => 'plural', 'source' => 'Forecasts'],
        ['name' => 'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY', 'type' => 'plural', 'source' => 'Forecasts'],

        // Active Subscriptions and Purchase History dashlets
        ['name' => 'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_PURCHASE_HISTORY_UNAVAILABLE', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_PURCHASE_HISTORY_UNAVAILABLE', 'type' => 'singular', 'source' => 'Purchases'],
        ['name' => 'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD', 'type' => 'plural', 'source' => 'Purchases'],
        ['name' => 'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_PURCHASE_HISTORY_DASHLET', 'type' => 'singular', 'source' => 'Purchases'],
        ['name' => 'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION', 'type' => 'plural', 'source' => 'Purchases'],
        ['name' => 'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_PURCHASE_HISTORY_UNAVAILABLE', 'type' => 'singular', 'source' => 'Purchases'],
        ['name' => 'LBL_PURCHASE_HISTORY_UNAVAILABLE', 'type' => 'singular', 'source' => 'Accounts'],
        ['name' => 'LBL_NO_PURCHASE_HISTORY', 'type' => 'plural', 'source' => 'Purchases'],
        ['name' => 'LBL_REQUIRE_PURCHASES_AND_PLIS', 'type' => 'plural', 'source' => 'Purchases'],
        ['name' => 'LBL_REQUIRE_PURCHASES_AND_PLIS', 'type' => 'plural', 'source' => 'PurchasedLineItems'],
        ['name' => 'LBL_NO_PLIS', 'type' => 'plural', 'source' => 'PurchasedLineItems'],
        ['name' => 'LBL_SEARCH_PURCHASE_NAME', 'type' => 'singular', 'source' => 'Purchases'],

        // Focus Drawer related labels
        ['name' => 'LBL_MY_FAVORITE_TASKS', 'type' => 'plural', 'source' => 'Tasks'],
        ['name' => 'LBL_MY_TASKS', 'type' => 'plural', 'source' => 'Tasks'],

        // Pub/Sub
        [
            'name' => 'LBL_PUBSUB_MODULEEVENT_PUSHSUBS',
            'type' => 'plural',
            'source' => 'PubSub_ModuleEvent_PushSubs',
        ],
        [
            'name' => 'LBL_PUBSUB_MODULEEVENT_PUSHSUB',
            'type' => 'singular',
            'source' => 'PubSub_ModuleEvent_PushSubs',
        ],
    ],
];
