<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['RevenueLineItem'] = [
    'table' => 'revenue_line_items',
    'color' => 'ocean',
    'icon' => 'sicon-revenue-line-items-lg',
    'archive' => false,
    'optimistic_locking' => true,
    'audited' => true,
    'activity_enabled' => true,
    'unified_search' => false,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'dynamic_subpanel_name' => 'subpanel-with-massupdate',
    'comment' => 'The user (not Admin)) view of a RevenueLineItem definition; an instance of a product used in the worksheets and opportunities',
    'fields' => [
        'product_template_id' => [
            'name' => 'product_template_id',
            'type' => 'id',
            'vname' => 'LBL_PRODUCT_TEMPLATE_ID',
            'required' => false,
            'reportable' => false,
            'comment' => 'Product (in Admin Products) from which this product is derived (in user Products)',
        ],
        'product_template_name' => [
            'name' => 'product_template_name',
            'rname' => 'name',
            'id_name' => 'product_template_id',
            'vname' => 'LBL_PRODUCT',
            'join_name' => 'templates',
            'type' => 'relate',
            'save' => true,
            'link' => 'rli_templates_link',
            'table' => 'product_templates',
            'isnull' => 'true',
            'module' => 'ProductTemplates',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
            'studio' => ['editview' => false, 'detailview' => false, 'quickcreate' => false],
            'auto_populate' => true,
            'populate_list' => [
                'name' => 'name',
                'category_id' => 'category_id',
                'category_name' => 'category_name',
                'mft_part_num' => 'mft_part_num',
                'list_price' => 'list_price',
                'cost_price' => 'cost_price',
                'discount_price' => 'discount_price',
                'list_usdollar' => 'list_usdollar',
                'cost_usdollar' => 'cost_usdollar',
                'discount_usdollar' => 'discount_usdollar',
                'currency_id' => 'currency_id',
                'base_rate' => 'base_rate',
                'tax_class' => 'tax_class',
                'weight' => 'weight',
                'manufacturer_id' => 'manufacturer_id',
                'manufacturer_name' => 'manufacturer_name',
                'type_id' => 'type_id',
                'type_name' => 'type_name',
                'service_duration_value' => ['service_duration_value', 'catalog_service_duration_value'],
                'service_duration_unit' => ['service_duration_unit', 'catalog_service_duration_unit'],
                'renewable' => 'renewable',
                'service' => 'service',
                'lock_duration' => 'lock_duration',
            ],
        ],
        'lock_duration' => [
            'name' => 'lock_duration',
            'vname' => 'LBL_LOCK_DURATION',
            'type' => 'bool',
            'default' => 0,
            'studio' => false,
            'enforced' => true,
            'calculated' => true,
            'massupdate' => false,
            'formula' => 'related($rli_templates_link, "lock_duration")',
            'comment' => 'Turn on or off a user ability to directly edit the duration field',
        ],
        'account_id' => [
            'name' => 'account_id',
            'type' => 'id',
            'vname' => 'LBL_ACCOUNT_ID',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'comment' => 'Account this product is associated with',
            'formula' => 'ifElse(related($opportunities, "account_id"), related($opportunities, "account_id"), $account_id)',
            'enforced' => true,
            'calculated' => true,
        ],
        'subtotal' => [
            'name' => 'subtotal',
            'vname' => 'LBL_SUBTOTAL',
            'type' => 'currency',
            'len' => '26,6',
            'calculated' => true,
            'enforced' => true,
            'formula' => '
                ifElse(
                    and(isNumeric($discount_price), isNumeric($quantity)),
                    ifElse(
                        and(
                            isNumeric($service_duration_value),
                            isNumeric($catalog_service_duration_value),
                            not(equal($service_duration_unit, "")),
                            not(equal($catalog_service_duration_unit, ""))
                        ),
                        prorateValue(
                            multiply($discount_price, $quantity),
                            number($service_duration_value),
                            $service_duration_unit,
                            number($catalog_service_duration_value),
                            $catalog_service_duration_unit
                        ),
                        multiply($discount_price, $quantity)
                    ),
                    0
                )
            ',
            'comment' => 'Stores the total of the line item before any discounts are applied, taking proration into consideration',
            'related_fields' => [
                'discount_price',
                'quantity',
                'service_duration_value',
                'service_duration_unit',
                'catalog_service_duration_value',
                'catalog_service_duration_unit',
            ],
            'additionalCalculationTriggerFields' => [
                'discount_amount',
                'discount_select',
            ],
        ],
        'total_amount' => [
            'name' => 'total_amount',
            'formula' => '
                ifElse(and(isNumeric($quantity), isNumeric($discount_price)),
                    ifElse(equal($quantity, 0),
                        $total_amount,
                        currencySubtract(
                            ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)),
                            ifElse(equal($discount_select, "1"),
                                currencyMultiply(
                                    ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)),
                                    currencyDivide($discount_amount, 100)
                                ),
                                ifElse(greaterThan($quantity, 0),
                                    ifElse(isNumeric(toString($discount_amount)),
                                    ifElse(greaterThan(0, $discount_price),
                                        negate($discount_amount), $discount_amount
                                    ), 0
                                ),
                                ifElse(isNumeric(toString($discount_amount)), negate($discount_amount), 0))
                            )
                        )
                    ), ""
                )',
            'calculated' => true,
            'enforced' => true,
            'vname' => 'LBL_CALCULATED_LINE_ITEM_AMOUNT',
            'reportable' => false,
            'type' => 'currency',
            'related_fields' => [
                'discount_price',
                'quantity',
                'discount_amount',
                'discount_select',
                'subtotal',
            ],
        ],
        'type_id' => [
            'name' => 'type_id',
            'vname' => 'LBL_TYPE',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'comment' => 'Product type (ex: hardware, software)',
        ],
        'quote_id' => [
            'name' => 'quote_id',
            'type' => 'id',
            'vname' => 'LBL_QUOTE_ID',
            'required' => false,
            'reportable' => false,
            'comment' => 'If product created via Quote, this is quote ID',
        ],
        'manufacturer_id' => [
            'name' => 'manufacturer_id',
            'vname' => 'LBL_MANUFACTURER',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'massupdate' => false,
            'comment' => 'Manufacturer of product',
        ],
        'manufacturer_name' => [
            'name' => 'manufacturer_name',
            'rname' => 'name',
            'id_name' => 'manufacturer_id',
            'type' => 'relate',
            'vname' => 'LBL_MANUFACTURER_NAME',
            'join_name' => 'manufacturers',
            'link' => 'manufacturers',
            'table' => 'manufacturers',
            'isnull' => 'true',
            'source' => 'non-db',
            'module' => 'Manufacturers',
            'dbType' => 'varchar',
            'len' => '255',
            'massupdate' => false,
            'related_fields' => [
                'manufacturer_id',
            ],
        ],
        'category_id' => [
            'name' => 'category_id',
            'vname' => 'LBL_CATEGORY_ID',
            'type' => 'id',
            'group' => 'category_name',
            'required' => false,
            'reportable' => true,
            'comment' => 'Product category',
        ],
        'category_name' => [
            'name' => 'category_name',
            'rname' => 'name',
            'id_name' => 'category_id',
            'vname' => 'LBL_CATEGORY_NAME',
            'join_name' => 'categories',
            'type' => 'relate',
            'link' => 'rli_categories_link',
            'table' => 'product_categories',
            'isnull' => 'true',
            'module' => 'ProductCategories',
            'dbType' => 'varchar',
            'len' => '255',
            'save' => true,
            'source' => 'non-db',
            'required' => false,
            'studio' => ['editview' => false, 'detailview' => false, 'quickcreate' => false],
        ],
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'dbType' => 'varchar',
            'type' => 'name',
            'len' => '255',
            'unified_search' => true,
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.57,
            ],
            'comment' => 'Name of the product',
            'reportable' => true,
            'importable' => 'required',
            'required' => true,
            'audited' => true,
        ],
        'mft_part_num' => [
            'name' => 'mft_part_num',
            'vname' => 'LBL_MFT_PART_NUM',
            'type' => 'varchar',
            'len' => '50',
            'comment' => 'Manufacturer part number',
        ],
        'cost_price' => [
            'name' => 'cost_price',
            'vname' => 'LBL_COST_PRICE',
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'comment' => 'Product cost ("Cost" in Quote)',
        ],
        'discount_price' => [
            'name' => 'discount_price',
            'vname' => 'LBL_DISCOUNT_PRICE',
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'comment' => 'Discounted price ("Unit Price" in Quote)',
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => '
            ifElse(
                and(
                    equal($product_template_id, ""),
                    not(isNumeric($discount_price)),
                    not(equal($quantity, 0))
                ),
                divide($likely_case, $quantity),
                $discount_price
            )',
            'enforced' => false,
            'calculated' => true,
        ],
        'discount_amount' => [
            'name' => 'discount_amount',
            'vname' => 'LBL_DISCOUNT_AMOUNT',
            'dbType' => 'currency',
            'type' => 'discount-amount',
            'len' => '26,6',
            'default' => '0',
            'precision' => '6',
            'comment' => 'Discounted amount',
            'related_fields' => [
                'currency_id',
                'base_rate',
                'discount_select',
            ],
            'studio' => false,
        ],
        'discount_select' => [
            'name' => 'discount_select',
            'vname' => 'LBL_DISCOUNT_SELECT',
            'type' => 'bool',
            'default' => true,
            'reportable' => false,
            'studio' => false,
        ],
        'discount_rate_percent' => [
            'name' => 'discount_rate_percent',
            'formula' => 'ifElse(isNumeric($discount_amount),ifElse(equal($discount_amount,0),0,multiply(divide($discount_amount,ifElse(equal(add($discount_amount,$total_amount), 0), $discount_amount, add($discount_amount,$total_amount))),100)),"")',
            'calculated' => true,
            'enforced' => true,
            'vname' => 'LBL_DISCOUNT_AS_PERCENT',
            'reportable' => false,
            'type' => 'decimal',
            'precision' => 2,
            'len' => '26,2',
        ],
        'discount_amount_usdollar' => [
            'name' => 'discount_amount_usdollar',
            'vname' => 'LBL_DISCOUNT_RATE_USDOLLAR',
            'type' => 'decimal',
            'len' => '26,6',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'formula' => 'ifElse(isNumeric($discount_amount), currencyDivide($discount_amount, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'discount_amount_signed' => [
            'name' => 'discount_amount_signed',
            'vname' => 'LBL_DISCOUNT_AMOUNT_SIGNED',
            'type' => 'currency',
            'len' => '26,6',
            'default' => '0',
            'audited' => true,
            'comment' => 'Discounted Amount Signed',
            'formula' => 'subtract(ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)), $total_amount)',
            'calculated' => true,
            'studio' => false,
            'enforced' => true,
        ],
        'deal_calc' => [
            'name' => 'deal_calc',
            'vname' => 'LBL_DISCOUNT_TOTAL',
            'type' => 'currency',
            'len' => '26,6',
            'group' => 'deal_calc',
            'comment' => 'deal_calc',
            'calculated' => true,
            'enforced' => true,
            'formula' => 'ifElse(equal($discount_select, "1"),
                            currencyMultiply(ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)), currencyDivide($discount_amount, 100)),
                            ifElse(isNumeric($discount_amount_signed), $discount_amount_signed, 0)
                        )',
            'customCode' => '{$fields.currency_symbol.value}{$fields.deal_calc.value}&nbsp;',
            'related_fields' => [
                'currency_id',
                'base_rate',
                'discount_select',
                'discount_amount',
                'discount_price',
            ],
        ],
        'deal_calc_usdollar' => [
            'name' => 'deal_calc_usdollar',
            'vname' => 'LBL_DISCOUNT_TOTAL_USDOLLAR',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'group' => 'deal_calc',
            'comment' => 'deal_calc_usdollar',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($deal_calc), currencyDivide($deal_calc, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'cost_usdollar' => [
            'name' => 'cost_usdollar',
            'vname' => 'LBL_COST_USDOLLAR',
            'group' => 'cost_price',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'comment' => 'Cost expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($cost_price), currencyDivide($cost_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'discount_usdollar' => [
            'name' => 'discount_usdollar',
            'vname' => 'LBL_DISCOUNT_USDOLLAR',
            'group' => 'discount_price',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'comment' => 'Discount price expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($discount_price), currencyDivide($discount_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'list_usdollar' => [
            'name' => 'list_usdollar',
            'vname' => 'LBL_LIST_USDOLLAR',
            'type' => 'currency',
            'currency_id' => '-99',
            'group' => 'list_price',
            'len' => '26,6',
            'comment' => 'List price expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($list_price), currencyDivide($list_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'status' => [
            'name' => 'status',
            'vname' => 'LBL_STATUS',
            'type' => 'enum',
            'options' => 'product_status_dom',
            'default' => '',
            'len' => 100,
            'audited' => true,
            'comment' => 'Product status (ex: Quoted, Ordered, Shipped)',
        ],
        'book_value_usdollar' => [
            'name' => 'book_value_usdollar',
            'vname' => 'LBL_BOOK_VALUE_USDOLLAR',
            'group' => 'book_value',
            'type' => 'currency',
            'len' => '26,6',
            'comment' => 'Book value expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($book_value), currencyDivide($book_value, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'quotes' => [
            'name' => 'quotes',
            'type' => 'link',
            'relationship' => 'quote_revenuelineitems',
            'vname' => 'LBL_QUOTE',
            'source' => 'non-db',
        ],
        'generate_purchase' => [
            'name' => 'generate_purchase',
            'vname' => 'LBL_GENERATE_PURCHASE',
            'type' => 'enum',
            'options' => 'generate_purchase_dom',
            'default' => 'Yes',
            // Prevent appending defaults on upgrade
            'no_default' => true,
            'len' => 25,
            'importable' => 'true',
            'reportable' => true,
            'massupdate' => true,
            'comment' => 'Generate Purchase Options (ex: Yes, No, Completed)',
        ],
        'purchasedlineitem' => [
            'name' => 'purchasedlineitem',
            'type' => 'link',
            'relationship' => 'purchasedlineitem_revenuelineitem',
            'module' => 'PurchasedLineItems',
            'source' => 'non-db',
            'vname' => 'LBL_PURCHASED_LINE_ITEM',
        ],
        'purchasedlineitem_id' => [
            'name' => 'purchasedlineitem_id',
            'type' => 'id',
            'vname' => 'LBL_PLI_ID',
            'required' => false,
            'reportable' => false,
            'comment' => 'If PLI was created from this RLI, this is that PLIs ID',
        ],
        'purchasedlineitem_name' => [
            'name' => 'purchasedlineitem_name',
            'rname' => 'name',
            'id_name' => 'purchasedlineitem_id',
            'join_name' => 'purchased_line_items',
            'type' => 'relate',
            'link' => 'purchasedlineitem',
            'table' => 'purchased_line_items',
            'isnull' => true,
            'required' => false,
            'module' => 'PurchasedLineItems',
            'dbType' => 'varchar',
            'len' => '255',
            'vname' => 'LBL_PURCHASED_LINE_ITEM',
            'source' => 'non-db',
            'comment' => 'PLI Name',
        ],
        'best_case' => [
            'formula' => 'ifElse(equal($best_case, ""), string($total_amount), $best_case)',
            'calculated' => true,
            'name' => 'best_case',
            'vname' => 'LBL_BEST',
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'showTransactionalAmount' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
                'total_amount',
                'quantity',
                'discount_amount',
                'discount_price',
            ],
        ],
        'likely_case' => [
            'formula' => 'ifElse(equal($likely_case,""),string($total_amount),$likely_case)',
            'calculated' => true,
            'name' => 'likely_case',
            'vname' => 'LBL_LIKELY',
            'required' => true,
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'showTransactionalAmount' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
                'total_amount',
                'quantity',
                'discount_amount',
                'discount_price',
            ],
        ],
        'worst_case' => [
            'formula' => 'ifElse(equal($worst_case, ""), string($total_amount), $worst_case)',
            'calculated' => true,
            'name' => 'worst_case',
            'vname' => 'LBL_WORST',
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'showTransactionalAmount' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
                'total_amount',
                'quantity',
                'discount_amount',
                'discount_price',
            ],
        ],
        'date_closed' => [
            'name' => 'date_closed',
            'vname' => 'LBL_DATE_CLOSED',
            'required' => true,
            'type' => 'date',
            'audited' => true,
            'comment' => 'Expected or actual date the product (for opportunity) will close',
            'importable' => 'required',
            'enable_range_search' => true,
            'options' => 'date_range_search_dom',
            'related_fields' => [
                'date_closed_timestamp',
            ],
            'full_text_search' => [
                'enabled' => true,
                'searchable' => false,
            ],
        ],
        'date_closed_timestamp' => [
            'name' => 'date_closed_timestamp',
            'vname' => 'LBL_DATE_CLOSED_TIMESTAMP',
            'type' => 'ulong',
            'studio' => [
                'formula' => true,
                'related' => true,
                'recordview' => false,
                'listview' => false,
                'detailview' => false,
                'searchview' => false,
                'createview' => false,
                'editField' => false,
            ],
            'reportable' => false,
            'audited' => true,
            'activity_enabled' => false,
            'formula' => 'timestamp($date_closed)',
            'calculated' => true,
            'enforced' => true,
            'importable' => false,
        ],
        'next_step' => [
            'name' => 'next_step',
            'vname' => 'LBL_NEXT_STEP',
            'type' => 'varchar',
            'len' => '100',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 0.49,
            ],
            'comment' => 'The next step in the sales process',
            'merge_filter' => 'enabled',
        ],
        'commit_stage' => [
            'name' => 'commit_stage',
            'vname' => 'LBL_COMMIT_STAGE_FORECAST',
            'type' => 'enum',
            'len' => '50',
            'comment' => 'Forecast commit category: Include, Likely, Omit etc.',
            'function' => 'getCommitStageDropdown',
            'function_bean' => 'Forecasts',
            'default' => 'exclude',
            'formula' => 'forecastCommitStage($probability)',
            'calculated' => true,
            'duplicate_merge' => 'enabled',
            'related_fields' => [
                'probability',
            ],
        ],
        'sales_stage' => [
            'name' => 'sales_stage',
            'vname' => 'LBL_SALES_STAGE',
            'type' => 'enum',
            'options' => 'sales_stage_dom',
            'default' => 'Prospecting',
            'len' => '255',
            'audited' => true,
            'comment' => 'Indication of progression towards closure',
            'merge_filter' => 'enabled',
            'importable' => 'required',
            'required' => true,
        ],
        'probability' => [
            'name' => 'probability',
            'vname' => 'LBL_PROBABILITY',
            'type' => 'int',
            'dbType' => 'double',
            'audited' => true,
            'comment' => 'The probability of closure',
            'validation' => ['type' => 'range', 'min' => 0, 'max' => 100],
            'merge_filter' => 'enabled',
            'formula' => 'getDropdownValue("sales_probability_dom",$sales_stage)',
            'calculated' => true,
            'enforced' => true,
            'workflow' => false,
        ],
        'lead_source' => [
            'name' => 'lead_source',
            'vname' => 'LBL_LEAD_SOURCE',
            'type' => 'enum',
            'options' => 'lead_source_dom',
            'len' => '50',
            'comment' => 'Source of the product',
            'merge_filter' => 'enabled',
        ],
        'campaign_id' => [
            'name' => 'campaign_id',
            'comment' => 'Campaign that generated lead',
            'vname' => 'LBL_CAMPAIGN_ID',
            'rname' => 'id',
            'type' => 'id',
            'dbType' => 'id',
            'table' => 'campaigns',
            'isnull' => 'true',
            'module' => 'Campaigns',
            'reportable' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'campaign_name' => [
            'name' => 'campaign_name',
            'rname' => 'name',
            'id_name' => 'campaign_id',
            'vname' => 'LBL_CAMPAIGN',
            'type' => 'relate',
            'save' => true,
            'link' => 'campaign_revenuelineitems',
            'isnull' => 'true',
            'table' => 'campaigns',
            'module' => 'Campaigns',
            'source' => 'non-db',
            'studio' => [
                'mobile' => false,
            ],
        ],
        'campaign_revenuelineitems' => [
            'name' => 'campaign_revenuelineitems',
            'type' => 'link',
            'vname' => 'LBL_CAMPAIGN_PRODUCT',
            'relationship' => 'campaign_revenuelineitems',
            'source' => 'non-db',
        ],
        'notes' => [
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'revenuelineitem_notes',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'forecasted_likely' => [
            'name' => 'forecasted_likely',
            'vname' => 'LBL_FORECASTED_LIKELY',
            'type' => 'currency',
            'dbType' => 'currency',
            'comment' => 'Rollup of included RLIs on the Opportunity',
            'readonly' => true,
            'massupdate' => false,
            'importable' => false,
            'duplicate_merge' => false,
            'required' => false,
            'studio' => true,
            'options' => 'numeric_range_search_dom',
            'audited' => false,
            'formula' => 'ifElse(equal(indexOf($commit_stage, forecastIncludedCommitStages()), -1), 0, $likely_case)',
            'calculated' => true,
            'enforced' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'convertToBase' => true,
            'showTransactionalAmount' => true,
        ],
        'messages' => [
            'name' => 'messages',
            'type' => 'link',
            'relationship' => 'revenuelineitem_messages',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'tasks' => [
            'name' => 'tasks',
            'type' => 'link',
            'relationship' => 'revenuelineitem_tasks',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'archived_emails' => [
            'name' => 'archived_emails',
            'type' => 'link',
            'link_class' => 'ArchivedEmailsLink',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'module' => 'Emails',
            'link_type' => 'many',
            'relationship' => '',
            'hideacl' => true,
            'readonly' => true,
        ],
        'documents' => [
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_revenuelineitems',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
        ],
        'quote_name' => [
            'name' => 'quote_name',
            'rname' => 'name',
            'id_name' => 'quote_id',
            'join_name' => 'quotes',
            'type' => 'relate',
            'link' => 'quotes',
            'table' => 'quotes',
            'isnull' => 'true',
            'module' => 'Quotes',
            'dbType' => 'varchar',
            'len' => '255',
            'vname' => 'LBL_QUOTE_NAME',
            'source' => 'non-db',
            'comment' => 'Quote Name',
        ],
        'opportunity_id' => [
            'name' => 'opportunity_id',
            'type' => 'id',
            'vname' => 'LBL_OPPORTUNITY_ID',
            'required' => true,
            'reportable' => false,
            'isnull' => 'true',
            'comment' => 'The opportunity id for the line item entry',
        ],
        'opportunity_name' => [
            'name' => 'opportunity_name',
            'rname' => 'name',
            'id_name' => 'opportunity_id',
            'vname' => 'LBL_OPPORTUNITY_NAME',
            'required' => true,
            'join_name' => 'opportunities',
            'type' => 'relate',
            'save' => true,
            'link' => 'opportunities',
            'table' => 'opportunities',
            'isnull' => 'true',
            'module' => 'Opportunities',
            'source' => 'non-db',
            'comment' => 'The opportunity name associated with the opportunity_id',
            'auto_populate' => true,
            'populate_list' => [
                'account_id' => 'account_id',
                'account_name' => 'account_name',
            ],
        ],
        'product_type' => [
            'name' => 'product_type',
            'vname' => 'LBL_TYPE',
            'type' => 'enum',
            'options' => 'opportunity_type_dom',
            'len' => '255',
            'audited' => true,
            'comment' => 'Type of product ( from opportunities opportunity_type ex: Existing, New)',
            'merge_filter' => 'enabled',
        ],
        'opportunities' => [
            'name' => 'opportunities',
            'type' => 'link',
            'relationship' => 'opportunities_revenuelineitems',
            'source' => 'non-db',
            'link_type' => 'one',
            'module' => 'Opportunities',
            'bean_name' => 'Opportunity',
            'vname' => 'LBL_OPPORTUNITIES',
        ],
        'assigned_user_link' => [
            'name' => 'assigned_user_link',
            'type' => 'link',
            'relationship' => 'revenuelineitems_assigned_user',
            'vname' => 'LBL_USERS',
            'link_type' => 'one',
            'module' => 'Users',
            'bean_name' => 'User',
            'source' => 'non-db',
            'duplicate_merge' => 'enabled',
            'id_name' => 'assigned_user_id',
            'table' => 'users',
        ],
        'type_name' => [
            'name' => 'type_name',
            'rname' => 'name',
            'id_name' => 'type_id',
            'vname' => 'LBL_PRODUCT_TYPE',
            'join_name' => 'types',
            'type' => 'relate',
            'save' => true,
            'link' => 'revenuelineitem_types_link',
            'table' => 'product_types',
            'isnull' => 'true',
            'module' => 'ProductTypes',
            'importable' => 'false',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
        ],
        'account_link' => [
            'name' => 'account_link',
            'type' => 'link',
            'relationship' => 'revenuelineitems_accounts',
            'vname' => 'LBL_ACCOUNT',
            'link_type' => 'one',
            'module' => 'Accounts',
            'bean_name' => 'Account',
            'source' => 'non-db',
        ],
        'rli_categories_link' => [
            'name' => 'rli_categories_link',
            'type' => 'link',
            'relationship' => 'revenuelineitem_categories',
            'vname' => 'LBL_PRODUCT_CATEGORIES',
            'link_type' => 'one',
            'module' => 'ProductCategories',
            'bean_name' => 'ProductCategory',
            'source' => 'non-db',
        ],
        'rli_templates_link' => [
            'name' => 'rli_templates_link',
            'type' => 'link',
            'relationship' => 'revenuelineitem_templates',
            'vname' => 'LBL_PRODUCT_TEMPLATES',
            'link_type' => 'one',
            'module' => 'ProductTemplates',
            'bean_name' => 'ProductTemplate',
            'source' => 'non-db',
        ],
        'revenuelineitem_types_link' => [
            'name' => 'revenuelineitem_types_link',
            'type' => 'link',
            'relationship' => 'revenuelineitem_types',
            'vname' => 'LBL_PRODUCT_TYPES',
            'link_type' => 'one',
            'module' => 'ProductTypes',
            'bean_name' => 'ProductType',
            'source' => 'non-db',
        ],
        'pli_addons_link' => [
            'name' => 'pli_addons_link',
            'type' => 'link',
            'relationship' => 'revenuelineitem_pli_addons',
            'vname' => 'LBL_ADD_ON_TO',
            'link_type' => 'one',
            'module' => 'PurchasedLineItems',
            'bean_name' => 'PurchasedLineItem',
            'source' => 'non-db',
        ],
        'products' => [
            'name' => 'products',
            'type' => 'link',
            'relationship' => 'products_revenuelineitems',
            'vname' => 'LBL_PRODUCTS',
            'source' => 'non-db',
        ],
        'generated_products' => [
            'name' => 'generated_products',
            'type' => 'link',
            'relationship' => 'products_parent_rli',
            'vname' => 'LBL_PRODUCTS',
            'source' => 'non-db',
        ],
        'account_name' => [
            'name' => 'account_name',
            'rname' => 'name',
            'id_name' => 'account_id',
            'save' => true,
            'vname' => 'LBL_ACCOUNT_NAME',
            'join_name' => 'accounts',
            'type' => 'relate',
            'link' => 'account_link',
            'table' => 'accounts',
            'module' => 'Accounts',
            'source' => 'non-db',
            'massupdate' => false,
        ],
        'projects' => [
            'name' => 'projects',
            'type' => 'link',
            'relationship' => 'projects_revenuelineitems',
            'source' => 'non-db',
            'vname' => 'LBL_PROJECTS',
        ],
        'emails' => [
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'emails_revenuelineitems_rel', /* reldef in emails */
            'module' => 'Emails',
            'bean_name' => 'Email',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'studio' => ['formula' => false],
        ],
        'calls' => [
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'revenuelineitem_calls',
            'module' => 'Calls',
            'bean_name' => 'Call',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
        ],
        'meetings' => [
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'revenuelineitem_meetings',
            'module' => 'Meetings',
            'bean_name' => 'Meeting',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
        ],
        'manufacturers' => [
            'name' => 'manufacturers',
            'type' => 'link',
            'relationship' => 'revenuelineitems_manufacturers',
            'vname' => 'LBL_MANUFACTURERS',
            'link_type' => 'one',
            'module' => 'Manufacturers',
            'bean_name' => 'Manufacturer',
            'source' => 'non-db',
        ],
        'add_on_to_id' => [
            'name' => 'add_on_to_id',
            'comment' => 'Purchased line item that this is an add-on to',
            'vname' => 'LBL_ADD_ON_TO_ID',
            'rname' => 'id',
            'type' => 'id',
            'dbType' => 'id',
            'table' => 'purchased_line_items',
            'isnull' => 'true',
            'module' => 'PurchasedLineItems',
            'reportable' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'add_on_to_name' => [
            'name' => 'add_on_to_name',
            'rname' => 'name',
            'id_name' => 'add_on_to_id',
            'vname' => 'LBL_ADD_ON_TO',
            'type' => 'relate',
            'save' => true,
            'link' => 'pli_addons_link',
            'isnull' => 'true',
            'table' => 'purchased_line_items',
            'module' => 'PurchasedLineItems',
            'source' => 'non-db',
            'massupdate' => false,
            'copyFromPurchasedLineItem' => [
                'product_template_id' => 'product_template_id',
                'product_template_name' => 'product_template_name',
                'service_end_date' => 'service_end_date',
            ],
            'copyFromProductTemplate' => [
                'name' => 'name',
                'category_id' => 'category_id',
                'category_name' => 'category_name',
                'mft_part_num' => 'mft_part_num',
                'list_price' => 'list_price',
                'cost_price' => 'cost_price',
                'discount_price' => 'discount_price',
                'list_usdollar' => 'list_usdollar',
                'cost_usdollar' => 'cost_usdollar',
                'discount_usdollar' => 'discount_usdollar',
                'currency_id' => 'currency_id',
                'base_rate' => 'base_rate',
                'tax_class' => 'tax_class',
                'weight' => 'weight',
                'manufacturer_id' => 'manufacturer_id',
                'manufacturer_name' => 'manufacturer_name',
                'type_id' => 'type_id',
                'type_name' => 'type_name',
                'renewable' => 'renewable',
                'service' => 'service',
                'service_duration_value' => 'catalog_service_duration_value',
                'service_duration_unit' => 'catalog_service_duration_unit',
            ],
        ],
        'parent_rlis_link' => [
            'name' => 'parent_rlis_link',
            'type' => 'link',
            'relationship' => 'revenuelineitems_renewal_rli',
            'module' => 'RevenueLineItems',
            'bean_name' => 'RevenueLineItem',
            'source' => 'non-db',
            'vname' => 'LBL_PARENT_RLIS',
            'side' => 'left',
        ],
        'renewal_rli_link' => [
            'name' => 'renewal_rli_link',
            'type' => 'link',
            'relationship' => 'revenuelineitems_renewal_rli',
            'module' => 'RevenueLineItems',
            'bean_name' => 'RevenueLineItem',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_RENEWAL_RLI_NAME',
            'side' => 'right',
        ],
        'renewal_rli_id' => [
            'name' => 'renewal_rli_id',
            'vname' => 'LBL_RENEWAL_RLI_ID',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'comment' => 'Renewal RLI of this RLI, set during renewal generation',
        ],
        'renewal_rli_name' => [
            'name' => 'renewal_rli_name',
            'rname' => 'name',
            'id_name' => 'renewal_rli_id',
            'vname' => 'LBL_RENEWAL_RLI_NAME',
            'type' => 'relate',
            'save' => true,
            'link' => 'renewal_rli_link',
            'isnull' => true,
            'massupdate' => false,
            'table' => 'revenue_line_items',
            'module' => 'RevenueLineItems',
            'source' => 'non-db',
        ],
    ],
    'indices' => [
        ['name' => 'idx_revenuelineitem_sales_stage', 'type' => 'index', 'fields' => ['sales_stage']],
        ['name' => 'idx_revenuelineitem_oppid', 'type' => 'index', 'fields' => ['opportunity_id']],
        [
            'name' => 'idx_rli_account_id_del',
            'type' => 'index',
            'fields' => [
                'deleted',
                'account_id',
                'id',
            ],
        ],
        [
            'name' => 'idx_rli_quote_id_del',
            'type' => 'index',
            'fields' => [
                'deleted',
                'quote_id',
                'id',
            ],
        ],
        [
            'name' => 'idx_rli_name_dm',
            'type' => 'index',
            'fields' => [
                'deleted',
                'name',
                'date_modified',
            ],
        ],
        [
            'name' => 'idx_rli_del_created_by_pt_id',
            'type' => 'index',
            'fields' => [
                'deleted',
                'created_by',
                'product_template_id',
            ],
        ],
        [
            'name' => 'idx_accountid_type_ren_dateclosed',
            'type' => 'index',
            'fields' => [
                'account_id',
                'product_type',
                'renewable',
                'date_closed',
            ],
        ],
        [
            'name' => 'idx_renewal_rli_id_del',
            'type' => 'index',
            'fields' => [
                'deleted',
                'renewal_rli_id',
                'id',
            ],
        ],
        [
            'name' => 'idx_del_addontoid',
            'type' => 'index',
            'fields' => [
                'deleted',
                'add_on_to_id',
            ],
        ],
    ],
    'relationships' => [
        'revenuelineitem_tasks' => [
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'RevenueLineItems',
        ],
        'revenuelineitem_notes' => [
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'RevenueLineItems',
        ],
        'revenuelineitem_messages' => [
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'Messages',
            'rhs_table' => 'messages',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'RevenueLineItems',
        ],
        'revenuelineitems_accounts' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'account_id',
            'relationship_type' => 'one-to-many',
        ],
        'revenuelineitem_categories' => [
            'lhs_module' => 'ProductCategories',
            'lhs_table' => 'product_categories',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'category_id',
            'relationship_type' => 'one-to-many',
        ],
        'revenuelineitem_templates' => [
            'lhs_module' => 'ProductTemplates',
            'lhs_table' => 'product_templates',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'product_template_id',
            'relationship_type' => 'one-to-many',
        ],
        'revenuelineitem_types' => [
            'lhs_module' => 'ProductTypes',
            'lhs_table' => 'product_types',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'type_id',
            'relationship_type' => 'one-to-many',
        ],
        'revenuelineitems_modified_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'modified_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'revenuelineitem_calls' => [
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'RevenueLineItems',
        ],
        'revenuelineitem_meetings' => [
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'RevenueLineItems',
        ],
        'revenuelineitems_manufacturers' => [
            'lhs_module' => 'Manufacturers',
            'lhs_table' => 'manufacturers',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'manufacturer_id',
            'relationship_type' => 'one-to-many',
        ],
        'revenuelineitem_pli_addons' => [
            'lhs_module' => 'PurchasedLineItems',
            'lhs_table' => 'purchased_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'add_on_to_id',
            'relationship_type' => 'one-to-many',
        ],
        'revenuelineitems_renewal_rli' => [
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'renewal_rli_id',
            'relationship_type' => 'one-to-many',
        ],
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$and' => [
                        ['opportunity_id' => ['$equals' => '$opportunity_id']],
                        ['name' => ['$starts' => '$name']],
                    ],
                ],
            ],
            'ranking_fields' => [
                ['in_field_name' => 'opportunity_id', 'dupe_field_name' => 'opportunity_id'],
                ['in_field_name' => 'name', 'dupe_field_name' => 'name'],
            ],
        ],
    ],
];

VardefManager::createVardef(
    'RevenueLineItems',
    'RevenueLineItem',
    [
        'default',
        'assignable',
        'team_security',
        'sales_item',
        'audit',
    ]
);

$dictionary['RevenueLineItem']['fields']['base_rate']['readonly'] = true;

//boost value for full text search
$dictionary['RevenueLineItem']['fields']['description']['full_text_search']['boost'] = 0.47;
