<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

function get_sales_marketing_reports($is_upgrade = false)
{
    global $current_language;

    $lang_strings = return_module_language($current_language, 'Reports');
    $stock_reports = [];
    $stock_reports[] = ['Tasks', 'Number of Open Tasks by Users by Week', '{"display_columns":[],"module":"Tasks","group_defs":[{"name":"date_due","label":"Week: Due Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo"},{"name":"user_name","label":"User Name","table_key":"Tasks:assigned_user_link","type":"username"}],"summary_columns":[{"name":"date_due","label":"Week: Due Date","column_function":"week","qualifier":"week","table_key":"self"},{"name":"count","label":"Number of Tasks","field_type":"","group_function":"count","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Tasks:assigned_user_link"}],"report_name":"Number of Open Tasks by Users by Week","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Tasks","module":"Tasks","label":"Tasks","dependents":[]},"Tasks:assigned_user_link":{"name":"Tasks  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tasks_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Tasks:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_3","display_summaries_row_group_by_row_3"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["Not Started","In Progress","Pending Input"]}}}}', 'Matrix', 'none', 'Number of open tasks by each user by week due.', 'a4dc3c18-bea3-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Accounts', 'Accounts by Assigned to User', '{"display_columns":[],"module":"Accounts","group_defs":[{"name":"user_name","label":"User Name","table_key":"Accounts:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Accounts:assigned_user_link"},{"name":"count","label":"Number of Accounts ","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Accounts by Assigned to User","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Accounts","module":"Accounts","label":"Accounts","dependents":[]},"Accounts:assigned_user_link":{"name":"Accounts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"accounts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Accounts:assigned_user_link"},"dependents":["display_cols_row_7","display_cols_row_7","display_cols_row_7","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_9","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"account_type","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Customer"]},"1":{"name":"industry","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'summary', 'none', 'Number of accounts for each assigned user. This report helps in making sure that account workload is optimized across the sales team. Use run time filters to narrow down by type or industry.', 'd4c56cec-bea3-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Open Quotes by Stage by Close Month', '{"display_columns":[],"module":"Quotes","group_defs":[{"name":"date_quote_expected_closed","label":"Month: Valid Until","column_function":"month","qualifier":"month","table_key":"self","type":"date"},{"name":"quote_stage","label":"Quote Stage","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_quote_expected_closed","label":"Month: Valid Until","column_function":"month","qualifier":"month","table_key":"self"},{"name":"quote_stage","label":"Quote Stage","table_key":"self"},{"name":"total","label":"SUM: Total","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Open Quotes by Stage by Close Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:total:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"quote_type","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Quotes"]},"1":{"name":"quote_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Draft","Negotiation","Delivered","On Hold","Confirmed"]}}}}', 'Matrix', 'vBarF', 'Summary of quoted amounts that are open by their expected close month and grouped by stage. This report indicates which quotes to prioritize and close.', 'f13c9be8-bea3-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Open Quotes Expiring This Month', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"quote_num","label":"Quote Number","table_key":"self"},{"name":"name","label":"Quote Subject","table_key":"self"},{"name":"total","label":"Quote Total","table_key":"self"},{"name":"date_quote_expected_closed","label":"Quote Valid Until","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Quotes:billing_accounts"},{"name":"full_name","label":"Bill to Contact Name","table_key":"Quotes:billing_contacts"},{"name":"full_name","label":"Assigned To ","table_key":"Quotes:assigned_user_link"}],"module":"Quotes","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"report_name":"Open Quotes Expiring This Month","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]},"Quotes:billing_accounts":{"name":"Quotes  \u003E  Bill to Account","parent":"self","link_def":{"name":"billing_accounts","relationship_name":"quotes_billto_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Quotes:billing_accounts"},"dependents":["display_cols_row_4","display_cols_row_7","display_cols_row_6"],"module":"Accounts","label":"Account Name","optional":true},"Quotes:billing_contacts":{"name":"Quotes  \u003E  Bill to Contact","parent":"self","link_def":{"name":"billing_contacts","relationship_name":"quotes_contacts_billto","bean_is_lhs":false,"link_type":"one","label":"Bill to Contact","module":"Contacts","table_key":"Quotes:billing_contacts"},"dependents":["display_cols_row_5","display_cols_row_8","display_cols_row_7"],"module":"Contacts","label":"Bill to Contact","optional":true},"Quotes:assigned_user_link":{"name":"Quotes  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"quotes_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Quotes:assigned_user_link"},"dependents":["display_cols_row_6","display_cols_row_9","display_cols_row_8"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"quote_type","table_key":"self","qualifier_name":"is","input_name0":["Quotes"]},"1":{"name":"quote_stage","table_key":"self","qualifier_name":"one_of","input_name0":["Draft","Negotiation","Delivered","On Hold","Confirmed"]},"2":{"name":"date_quote_expected_closed","table_key":"self","qualifier_name":"tp_this_month","runtime":1,"input_name0":"tp_this_month","input_name1":"on"}}}}', 'tabular', 'none', 'A list of quotes that are expiring this month. Time period can be adjusted in the report using the run time filter.', 'f7d82bf2-bea3-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Calls', 'Upcoming Calls Scheduled by Account', '{"display_columns":[{"name":"date_start","label":"Start Date","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"full_name","label":"Assigned To  ","table_key":"Calls:assigned_user_link"}],"module":"Calls","group_defs":[{"name":"name","label":"Name","table_key":"Calls:accounts","type":"name","force_label":"Name"}],"summary_columns":[{"name":"name","label":"Account Name","table_key":"Calls:accounts"},{"name":"count","label":"Number of Calls ","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Upcoming Calls Scheduled by Account ","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Calls","module":"Calls","label":"Calls","dependents":[]},"Calls:accounts":{"name":"Calls  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_calls","bean_is_lhs":false,"link_type":"one","label":"Account","module":"Accounts","table_key":"Calls:accounts"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Accounts","label":"Account","optional":true},"Calls:assigned_user_link":{"name":"Calls  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"calls_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Calls:assigned_user_link"},"dependents":["display_cols_row_6","display_cols_row_6","display_cols_row_5","display_cols_row_5"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Planned"]}}}}', 'detailed_summary', 'none', 'Number of calls scheduled by account in the coming weeks.', '03f3dc24-bea4-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Open Leads by User', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link"},{"name":"count","label":"Number of Leads ","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Leads by User","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads","dependents":[]},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["display_cols_row_8","display_cols_row_8","display_cols_row_8","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","In Process","Recycled"]}}}}', 'summary', 'none', 'List of open leads grouped by assigned user.', '2afc803c-bea4-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Tasks', 'Tasks Completed by Users by Week This Quarter', '{"display_columns":[],"module":"Tasks","group_defs":[{"name":"date_due","label":"Week: Due Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo","force_label":"Week: Due Date"},{"name":"user_name","label":"User Name","table_key":"Tasks:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"date_due","label":"Week: Due Date","column_function":"week","qualifier":"week","table_key":"self","sort_dir":"a"},{"name":"user_name","label":"User Name","table_key":"Tasks:assigned_user_link"},{"name":"count","label":"Number of Tasks","field_type":"","group_function":"count","table_key":"self"}],"summary_order_by":[{"name":"date_due","group_function":"week","column_function":"week","table_key":"self","sort_dir":"a"}],"report_name":"Tasks Completed by Users by Week this Quarter","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Tasks","module":"Tasks","label":"Tasks","dependents":[]},"Tasks:assigned_user_link":{"name":"Tasks  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tasks_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Tasks:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["Completed"]},"1":{"name":"date_due","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'none', 'Number of tasks completed by each user by week in this quarter. Time period can be adjusted in the report using the run time filter.', '111bc970-bea4-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Leads Converted - Lost by Month', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime"},{"name":"status","label":"Status","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Leads Converted - Lost by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"1":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["Converted","Dead"]}}}}', 'Matrix', 'vBarF', 'Number of leads converted and lost each month. Time period can be adjusted in the report using the run time filters.', '3aaff0c2-bea4-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Calls', 'Weekly Calls Scheduled this Quarter by User', '{"display_columns":[],"module":"Calls","group_defs":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo","force_label":"Week: Start Date"},{"name":"user_name","label":"Assigned To ","table_key":"Calls:assigned_user_link","type":"username","force_label":"Assigned To "}],"summary_columns":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self"},{"name":"user_name","label":"Assigned To ","table_key":"Calls:assigned_user_link"},{"name":"count","label":"Number of Calls","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Weekly Calls Scheduled This Quarter by User","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Calls","module":"Calls","label":"Calls"},"Calls:assigned_user_link":{"name":"Calls  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"calls_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Calls:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_start","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"},"1":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Planned"]}}}}', 'Matrix', 'vBarF', 'Number of calls scheduled by each user by week in this quarter. Time period can be adjusted in the report using the run time filter.', '40b5a5fc-bea4-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Meetings', 'Weekly Meetings Held This Quarter by User', '{"display_columns":[],"module":"Meetings","group_defs":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo","force_label":"Week: Start Date"},{"name":"user_name","label":"Assigned To ","table_key":"Meetings:assigned_user_link","type":"username","force_label":"Assigned To "}],"summary_columns":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self"},{"name":"user_name","label":"Assigned To ","table_key":"Meetings:assigned_user_link"},{"name":"count","label":"Number of Meetings","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Weekly Meetings Held This Quarter by User","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Meetings","module":"Meetings","label":"Meetings"},"Meetings:assigned_user_link":{"name":"Meetings  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"meetings_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Meetings:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_start","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"},"1":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Held"]}}}}', 'Matrix', 'vBarF', 'Number of meetings held by each user by week in this quarter. Time period can be adjusted in the report using the run time filter.', '4b8b32d0-bea4-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Quotes Won Lost by User', '{"display_columns":[],"module":"Quotes","group_defs":[{"name":"user_name","label":"Assigned To","table_key":"Quotes:assigned_user_link","type":"username","force_label":"Assigned To"},{"name":"quote_stage","label":"Quote Stage","table_key":"self","type":"enum","force_label":"Quote Stage"}],"summary_columns":[{"name":"user_name","label":"Assigned To","table_key":"Quotes:assigned_user_link"},{"name":"quote_stage","label":"Quote Stage","table_key":"self","sort_dir":"a"},{"name":"total","label":"SUM: Total","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Quotes Won Lost by User","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:total:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","summary_order_by":[{"name":"quote_stage","vname":"Quote Stage","type":"enum","options":[{"value":"Draft","text":"Draft"},{"value":"Negotiation","text":"Negotiation"},{"value":"Delivered","text":"Delivered"},{"value":"On Hold","text":"On Hold"},{"value":"Confirmed","text":"Confirmed"},{"value":"Closed Accepted","text":"Closed Accepted"},{"value":"Closed Lost","text":"Closed Lost"},{"value":"Closed Dead","text":"Closed Dead"}],"len":100,"audited":true,"importable":"required","required":true,"table_key":"self","sort_dir":"a"}],"full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]},"Quotes:assigned_user_link":{"name":"Quotes  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"quotes_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Quotes:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"quote_type","table_key":"self","qualifier_name":"is","input_name0":["Quotes"]},"1":{"name":"quote_stage","table_key":"self","qualifier_name":"one_of","input_name0":["Closed Accepted","Closed Lost","Closed Dead"]},"2":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'none', 'Quoted amounts won and lost this quarter by each assigned user. Time period can be adjusted in the report using the run time filter.', '568d88d6-bea4-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Accounts', 'Accounts By Type By Industry', '{"report_type":"summary","display_columns":[],"summary_columns":[{"name":"count","label":"Count","group_function":"count","table_key":"self"},{"name":"account_type","label":"Accounts: Type","table_key":"self","is_group_by":"visible"},{"name":"industry","label":"Accounts: Industry","table_key":"self","is_group_by":"visible"}],"filters_def":{"Filter_1":{"operator":"AND"}},"filters_combiner":"AND","group_defs":[{"name":"account_type","label":"Type","table_key":"self"},{"name":"industry","label":"Industry","table_key":"self"}],"full_table_list":{"self":{"parent":"","value":"Accounts","module":"Accounts","label":"Accounts","children":[]}},"module":"Accounts","report_name":"Accounts By Type By Industry","chart_type":"hBarF","chart_description":"","numerical_chart_column":"self:count","assigned_user_id":"1"}', 'summary', 'hBarF', 'Number of accounts summarized by account type and industry', '3e896e98-bea5-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Accounts', 'My New Customer Accounts', '{"display_columns":[{"name":"name","label":"Name","table_key":"self"},{"name":"website","label":"Website","table_key":"self"},{"name":"phone_office","label":"Phone Office","table_key":"self"},{"name":"billing_address_city","label":"Billing City","table_key":"self"},{"name":"billing_address_country","label":"Billing Country","table_key":"self"}],"module":"Accounts","group_defs":[],"summary_columns":[],"report_name":"My New Customer Accounts","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Accounts","module":"Accounts","label":"Accounts"},"Accounts:assigned_user_link":{"name":"Accounts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"accounts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Accounts:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"account_type","table_key":"self","qualifier_name":"is","input_name0":["Customer"]},"1":{"name":"user_name","table_key":"Accounts:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]},"2":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"undefined","input_name1":"on"}}},"chart_type":"none"}', 'tabular', 'none', 'List of new customers recently opened and assigned to me.', '57718930-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Meetings', 'Open Meetings', '{"display_columns":[{"name":"name","label":"Subject","table_key":"self"},{"name":"description","label":"Description","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Meetings:assigned_user_link"}],"module":"Meetings","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","table_key":"self","sort_dir":"a"}],"report_name":"Open Meetings","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Meetings","module":"Meetings","label":"Meetings"},"Meetings:assigned_user_link":{"name":"Meetings  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"meetings_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Meetings:assigned_user_link"},"dependents":["Filter.1_table_filter_row_3","display_cols_row_4"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Planned","Not Held"]},"1":{"name":"date_start","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"undefined","input_name1":"on"},"2":{"name":"user_name","table_key":"Meetings:assigned_user_link","qualifier_name":"one_of","runtime":1,"input_name0":["Current User"]}}},"chart_type":"none"}', 'tabular', 'none', 'List of Open Meetings', '7e3a6564-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Tasks', 'Open Tasks', '{"display_columns":[{"name":"name","label":"Subject","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"date_due","label":"Due Date","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Tasks:assigned_user_link"}],"module":"Tasks","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_due","vname":"Due Date","type":"datetime","group":"date_due","table_key":"self","sort_dir":"d"}],"report_name":"Open Tasks","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Tasks","module":"Tasks","label":"Tasks"},"Tasks:assigned_user_link":{"name":"Tasks  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tasks_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Tasks:assigned_user_link"},"dependents":["Filter.1_table_filter_row_4","display_cols_row_6"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Not Started","In Progress","Pending Input"]},"1":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"undefined","input_name1":"on"},"2":{"name":"user_name","table_key":"Tasks:assigned_user_link","qualifier_name":"one_of","runtime":1,"input_name0":["Current User"]}}},"chart_type":"none"}', 'tabular', 'none', 'List of Open Tasks', '8c8e6ee4-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Number of Leads Created by Week', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime","force_label":"Week: Date Created"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"count","label":"Number of Leads ","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Number of Leads Created by Week","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","input_name0":"tp_this_year","input_name1":"on"}}}}', 'summary', 'vBarF', 'Number of leads created for each week this year. Time period can be adjusted in the report using the run time filters.', '97f0d9ca-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Meetings', 'Weekly Meetings Scheduled This Quarter by User', '{"display_columns":[],"module":"Meetings","group_defs":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo","force_label":"Week: Start Date"},{"name":"user_name","label":"Assigned To","table_key":"Meetings:assigned_user_link","type":"username","force_label":"Assigned To"}],"summary_columns":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self","sort_dir":"a"},{"name":"user_name","label":"Assigned To","table_key":"Meetings:assigned_user_link"},{"name":"count","label":"Number of Meetings","field_type":"","group_function":"count","table_key":"self"}],"summary_order_by":[{"name":"date_start","group_function":"week","column_function":"week","table_key":"self","sort_dir":"a"}],"report_name":"Weekly Meetings Scheduled This Quarter by User","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Meetings","module":"Meetings","label":"Meetings","dependents":[]},"Meetings:assigned_user_link":{"name":"Meetings  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"meetings_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Meetings:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Planned"]}}}}', 'Matrix', 'none', 'Number of meetings scheduled by each user by week.', 'afa1176a-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'My Open Leads', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"salutation","label":"Salutation","table_key":"self"},{"name":"full_name","label":"Lead Name","table_key":"self"},{"name":"account_name","label":"Account Name","table_key":"self"},{"name":"lead_source","label":"Lead Source","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"email_address","label":"Email Address","table_key":"Leads:email_addresses_primary"},{"name":"opt_out","label":"Opted Out","table_key":"Leads:email_addresses_primary"},{"name":"do_not_call","label":"Do Not Call","table_key":"self"},{"name":"preferred_language","label":"Language Preference","table_key":"self"},{"name":"full_name","label":"Assigned To ","table_key":"Leads:assigned_user_link"}],"module":"Leads","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"report_name":"My Open Leads","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads","dependents":[]},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["display_cols_row_4","display_cols_row_11","display_cols_row_11","Filter.1_table_filter_row_3"],"module":"Users","label":"Assigned to User","optional":true},"Leads:email_addresses_primary":{"name":"Leads  \u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"leads_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Leads:email_addresses_primary"},"dependents":["display_cols_row_6","display_cols_row_7","display_cols_row_7","display_cols_row_8","display_cols_row_7","display_cols_row_8"],"module":"EmailAddresses","label":"Email Address","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","In Process","Recycled"]},"1":{"name":"user_name","table_key":"Leads:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'tabular', 'none', 'List of all leads assigned to me.', 'd8a0a374-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Accounts', 'Accounts Created by User by Month', '{"display_columns":[],"module":"Accounts","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime","force_label":"Month: Date Created"},{"name":"user_name","label":"User Name","table_key":"Accounts:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Accounts:assigned_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Accounts Created by User by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Accounts","module":"Accounts","label":"Accounts"},"Accounts:assigned_user_link":{"name":"Accounts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"accounts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Accounts:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"1":{"name":"account_type","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Customer"]}}}}', 'Matrix', 'vBarF', 'Number of accounts created by month by assigned user during the current year. Time period can be adjusted in the report using the run time filters.', 'e57b30be-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Calls', 'Weekly Calls Held this Quarter by User', '{"display_columns":[],"module":"Calls","group_defs":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo","force_label":"Week: Start Date"},{"name":"user_name","label":"Assigned To ","table_key":"Calls:assigned_user_link","type":"username","force_label":"Assigned To "}],"summary_columns":[{"name":"date_start","label":"Week: Start Date","column_function":"week","qualifier":"week","table_key":"self"},{"name":"user_name","label":"Assigned To ","table_key":"Calls:assigned_user_link"},{"name":"count","label":"Number of Calls","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Weekly Calls Held This Quarter by User","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Calls","module":"Calls","label":"Calls"},"Calls:assigned_user_link":{"name":"Calls  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"calls_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Calls:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_start","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"},"1":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Held"]}}}}', 'Matrix', 'vBarF', 'Number of calls held by each user by week in this quarter. Time period can be adjusted in the report using the run time filter.', '0cf53324-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Leads Created by User per Month', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime"},{"name":"user_name","label":"User Name","table_key":"Leads:created_by_link","type":"username"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"Created By","table_key":"Leads:created_by_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Leads Created by User per Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads"},"Leads:created_by_link":{"name":"Leads  \u003E  Created User","parent":"self","link_def":{"name":"created_by_link","relationship_name":"leads_created_by","bean_is_lhs":false,"link_type":"one","label":"Created User","module":"Users","table_key":"Leads:created_by_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Created User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Leads created each month by user. Time period can be adjusted in the report using the run time filters.', '18cc8684-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Contacts', 'Contacts Created by User by Month', '{"display_columns":[],"module":"Contacts","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime","force_label":"Month: Date Created"},{"name":"user_name","label":"User Name","table_key":"Contacts:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Contacts:assigned_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Contacts Created by User by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Contacts","module":"Contacts","label":"Contacts"},"Contacts:assigned_user_link":{"name":"Contacts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"contacts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Contacts:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true},"Contacts:accounts":{"name":"Contacts  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"accounts_contacts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Contacts:accounts"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Accounts","label":"Account Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"1":{"name":"account_type","table_key":"Contacts:accounts","qualifier_name":"one_of","runtime":1,"input_name0":["Customer"]}}}}', 'Matrix', 'vBarF', 'Count of all contacts created this year by each assigned user by month. Time period can be adjusted in the report using the run time filters.', '28444b1a-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Quotes Created by Users by Month', '{"display_columns":[],"module":"Quotes","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime","force_label":"Month: Date Created"},{"name":"user_name","label":"User Name","table_key":"Quotes:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Quotes:assigned_user_link"},{"name":"total","label":"SUM: Total","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Quotes Created by Users by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:total:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]},"Quotes:assigned_user_link":{"name":"Quotes  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"quotes_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Quotes:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"1":{"name":"quote_type","table_key":"self","qualifier_name":"is","input_name0":["Quotes"]}}}}', 'Matrix', 'vBarF', 'Total quote amount created by each user by month. Time period can be adjusted in the report using the run time filter.', '3ea1a45c-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Leads with No Calls, Meetings, Tasks, or Emails', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link","type":"username"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link"},{"name":"count","label":"Number of Leads","field_type":"","group_function":"count","table_key":"self","sort_dir":"d"}],"summary_order_by":[{"name":"count","vname":"Count","group_function":"count","summary_type":"group","table_key":"self","sort_dir":"d"}],"report_name":"Leads with No Calls, Meetings, Tasks, or Emails","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads"},"Leads:calls":{"name":"Leads  \u003E  Calls","parent":"self","link_def":{"name":"calls","relationship_name":"calls_leads","bean_is_lhs":false,"link_type":"many","label":"Calls","module":"Calls","table_key":"Leads:calls"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Calls","label":"Calls","optional":true},"Leads:meetings":{"name":"Leads  \u003E  Meetings","parent":"self","link_def":{"name":"meetings","relationship_name":"meetings_leads","bean_is_lhs":false,"link_type":"many","label":"Meetings","module":"Meetings","table_key":"Leads:meetings"},"dependents":["Filter.1_table_filter_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3"],"module":"Meetings","label":"Meetings","optional":true},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true},"Leads:tasks":{"name":"Leads  \u003E  Tasks","parent":"self","link_def":{"name":"tasks","relationship_name":"lead_tasks","bean_is_lhs":true,"link_type":"many","label":"Tasks","module":"Tasks","table_key":"Leads:tasks"},"dependents":["Filter.1_table_filter_row_4","Filter.1_table_filter_row_4","Filter.1_table_filter_row_4","Filter.1_table_filter_row_4"],"module":"Tasks","label":"Tasks","optional":true},"Leads:emails":{"name":"Leads  \u003E  Emails","parent":"self","link_def":{"name":"emails","relationship_name":"emails_leads_rel","bean_is_lhs":false,"link_type":"many","label":"Emails","module":"Emails","table_key":"Leads:emails"},"dependents":["Filter.1_table_filter_row_5"],"module":"Emails","label":"Emails","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","In Process","Recycled"]},"1":{"name":"id","table_key":"Leads:calls","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"2":{"name":"id","table_key":"Leads:meetings","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"3":{"name":"id","table_key":"Leads:tasks","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"4":{"name":"id","table_key":"Leads:emails","qualifier_name":"empty","input_name0":"empty","input_name1":"on"}}}}', 'summary', 'none', 'Summary count of leads where no activity has taken place or is scheduled.  Those leads are counted that have no calls, meetings or tasks scheduled or completed.', '4988800c-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Quotes Won Lost by Month', '{"display_columns":[],"module":"Quotes","group_defs":[{"name":"date_quote_expected_closed","label":"Month: Valid Until","column_function":"month","qualifier":"month","table_key":"self","type":"date","force_label":"Month: Valid Until"},{"name":"quote_stage","label":"Quote Stage","table_key":"self","type":"enum","force_label":"Quote Stage"}],"summary_columns":[{"name":"date_quote_expected_closed","label":"Month: Valid Until","column_function":"month","qualifier":"month","table_key":"self"},{"name":"quote_stage","label":"Quote Stage","table_key":"self"},{"name":"total","label":"SUM: Total","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Quotes Won Lost by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:total:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"quote_type","table_key":"self","qualifier_name":"is","input_name0":["Quotes"]},"1":{"name":"quote_stage","table_key":"self","qualifier_name":"one_of","input_name0":["Closed Accepted","Closed Lost","Closed Dead"]},"2":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Quoted amounts won and lost each month this year. Time period can be adjusted in the report using the run time filter.', '58aaf3b2-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Open Quotes by Stage', '{"display_columns":[],"module":"Quotes","group_defs":[{"name":"quote_stage","label":"Quote Stage","table_key":"self","type":"enum","force_label":"Quote Stage"}],"summary_columns":[{"name":"quote_stage","label":"Quote Stage","table_key":"self"},{"name":"total","label":"SUM: Total","field_type":"currency","group_function":"sum","table_key":"self"},{"name":"count","label":"Number of Quotes","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Quotes by Stage","chart_type":"pieF","do_round":1,"chart_description":"","numerical_chart_column":"self:total:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"quote_stage","table_key":"self","qualifier_name":"one_of","input_name0":["Draft","Negotiation","Delivered","On Hold","Confirmed"]}}}}', 'summary', 'pieF', 'A list of all open quotes summarized by stage.', '66aff106-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Number of Quotes Created by Users by Month', '{"display_columns":[],"module":"Quotes","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime"},{"name":"user_name","label":"User Name","table_key":"Quotes:assigned_user_link","type":"username"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Quotes:assigned_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Number of Quotes created by Users by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]},"Quotes:assigned_user_link":{"name":"Quotes  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"quotes_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Quotes:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of quotes created by each user by month. Time period can be adjusted in the report using the run time filter.', '6fbd2e9e-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Accounts', 'My Customers by Area', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"name","label":"Account Name","table_key":"self"},{"name":"billing_address_city","label":"Billing City","table_key":"self"},{"name":"billing_address_country","label":"Billing Country","table_key":"self"},{"name":"billing_address_state","label":"Billing State","table_key":"self"},{"name":"industry","label":"Industry","table_key":"self"},{"name":"full_name","label":"Assigned To ","table_key":"Accounts:assigned_user_link"},{"name":"full_name","label":"Created By ","table_key":"Accounts:created_by_link"}],"module":"Accounts","group_defs":[],"summary_columns":[],"report_name":"My Customers by Area","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Accounts","module":"Accounts","label":"Accounts","dependents":[]},"Accounts:assigned_user_link":{"name":"Accounts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"accounts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Accounts:assigned_user_link"},"dependents":["display_cols_row_7","display_cols_row_7","Filter.1.1_table_filter_row_4","Filter.1.2_table_filter_row_5","Filter.1.2_table_filter_row_6","Filter.1.1_table_filter_row_1","display_cols_row_7","Filter.1.1_table_filter_row_1","display_cols_row_7","Filter.1.1_table_filter_row_1","display_cols_row_7","Filter.1.1_table_filter_row_1","display_cols_row_7"],"module":"Users","label":"Assigned to User","optional":true},"Accounts:created_by_link":{"name":"Accounts  \u003E  Created by User","parent":"self","link_def":{"name":"created_by_link","relationship_name":"accounts_created_by","bean_is_lhs":false,"link_type":"one","label":"Created by User","module":"Users","table_key":"Accounts:created_by_link"},"dependents":["display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8"],"module":"Users","label":"Created by User","optional":true}},"filters_def":{"Filter_1":{"0":{"operator":"AND","0":{"name":"user_name","table_key":"Accounts:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]}},"1":{"operator":"OR","0":{"name":"billing_address_postalcode","table_key":"self","qualifier_name":"starts_with","runtime":1,"input_name0":"Enter Postal Code","input_name1":"on"},"1":{"name":"billing_address_city","table_key":"self","qualifier_name":"starts_with","runtime":1,"input_name0":"Enter City","input_name1":"on"}},"operator":"AND"}}}', 'tabular', 'none', 'A list of customers in a given area (City or Zip Code). This report only lists accounts that are assigned to the person viewing the report. You can use this report to create a trip plan.', '7bdfeda6-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Tasks', 'Tasks due This Week', '{"display_columns":[{"name":"date_due","label":"Due Date","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"full_name","label":"Assigned To ","table_key":"Tasks:assigned_user_link"}],"module":"Tasks","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_due","vname":"Due Date","type":"datetimecombo","dbType":"datetime","group":"date_due","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"table_key":"self","sort_dir":"a"}],"report_name":"Tasks Due This week","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Tasks","module":"Tasks","label":"Tasks"},"Tasks:assigned_user_link":{"name":"Tasks  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tasks_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Tasks:assigned_user_link"},"dependents":["display_cols_row_5"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_due","table_key":"self","qualifier_name":"tp_next_7_days","runtime":1,"input_name0":"tp_next_7_days","input_name1":"on"}}},"chart_type":"none"}', 'tabular', 'none', 'List of tasks due this week. Time period can be adjusted in the report using the run time filter.', '83913064-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Leads Converted by User', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self","sort_dir":"d"}],"summary_order_by":[{"name":"count","vname":"Count","group_function":"count","summary_type":"group","table_key":"self","sort_dir":"d"}],"report_name":"Leads Converted by User","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads"},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Converted"]},"1":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'summary', 'none', 'This report provides the number of leads converted by each user in the current quarter. Time period can be adjusted in the run time filter.', '8cee1a8c-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Meetings', 'Upcoming Meetings Scheduled by Account', '{"display_columns":[{"name":"date_start","label":"Start Date","table_key":"self"},{"name":"type","label":"Meeting Type","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"full_name","label":"Assigned To ","table_key":"Meetings:assigned_user_link"},{"name":"location","label":"Location","table_key":"self"}],"module":"Meetings","group_defs":[{"name":"name","label":"Name","table_key":"Meetings:accounts","type":"name"}],"summary_columns":[{"name":"name","label":"Account Name","table_key":"Meetings:accounts"},{"name":"count","label":"Number of Meetings","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Upcoming Meetings Scheduled by Account ","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Meetings","module":"Meetings","label":"Meetings","dependents":[]},"Meetings:accounts":{"name":"Meetings  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_meetings","bean_is_lhs":false,"link_type":"one","label":"Account","module":"Accounts","table_key":"Meetings:accounts"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Accounts","label":"Account","optional":true},"Meetings:assigned_user_link":{"name":"Meetings  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"meetings_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Meetings:assigned_user_link"},"dependents":["display_cols_row_8"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Planned"]}}}}', 'detailed_summary', 'none', 'Number of meetings scheduled by account in the coming weeks.', '959b60cc-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Open Quotes by Stage by User', '{"display_columns":[],"module":"Quotes","group_defs":[{"name":"user_name","label":"User Name","table_key":"Quotes:assigned_user_link","type":"username"},{"name":"quote_stage","label":"Quote Stage","table_key":"self","type":"enum"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Quotes:assigned_user_link"},{"name":"quote_stage","label":"Quote Stage","table_key":"self"},{"name":"total","label":"SUM: Total","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Open Quotes by Stage by User","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:total:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes"},"Quotes:assigned_user_link":{"name":"Quotes  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"quotes_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Quotes:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"quote_type","table_key":"self","qualifier_name":"is","input_name0":["Quotes"]},"1":{"name":"quote_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Draft","Negotiation","Delivered","On Hold","Confirmed"]}}}}', 'Matrix', 'none', 'Summary of quoted amounts that are open for each assigned user grouped by stage. This report gives a sense of where the quotes are in terms of stages for each sales person.', 'a6e900d2-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Quotes', 'Recently Closed Quotes', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"quote_num","label":"Quote Number","table_key":"self"},{"name":"name","label":"Quote Subject","table_key":"self"},{"name":"total","label":"Quote Total","table_key":"self"},{"name":"date_quote_expected_closed","label":"Quote Valid Until","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Quotes:billing_accounts"},{"name":"full_name","label":"Bill to Contact Name","table_key":"Quotes:billing_contacts"},{"name":"full_name","label":"Assigned To ","table_key":"Quotes:assigned_user_link"}],"module":"Quotes","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"report_name":"Recently Closed Quotes","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Quotes","module":"Quotes","label":"Quotes","dependents":[]},"Quotes:billing_accounts":{"name":"Quotes  \u003E  Bill to Account","parent":"self","link_def":{"name":"billing_accounts","relationship_name":"quotes_billto_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Quotes:billing_accounts"},"dependents":["display_cols_row_4","display_cols_row_7"],"module":"Accounts","label":"Account Name","optional":true},"Quotes:billing_contacts":{"name":"Quotes  \u003E  Bill to Contact","parent":"self","link_def":{"name":"billing_contacts","relationship_name":"quotes_contacts_billto","bean_is_lhs":false,"link_type":"one","label":"Bill to Contact","module":"Contacts","table_key":"Quotes:billing_contacts"},"dependents":["display_cols_row_5","display_cols_row_8"],"module":"Contacts","label":"Bill to Contact","optional":true},"Quotes:assigned_user_link":{"name":"Quotes  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"quotes_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Quotes:assigned_user_link"},"dependents":["display_cols_row_6","display_cols_row_9"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"tp_last_7_days","input_name1":"on"},"1":{"name":"quote_type","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Quotes"]},"2":{"name":"quote_stage","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Closed Accepted"]}}}}', 'tabular', 'none', 'A list of all recently closed quotes.', 'f915c2b4-bea7-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Leads Created by Source per Month', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime","force_label":"Month: Date Created"},{"name":"lead_source","label":"Lead Source","table_key":"self","type":"enum","force_label":"Lead Source"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"lead_source","label":"Lead Source","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Leads Created by Source per Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Leads created each month by source. Time period can be adjusted in the report using the run time filters.', '07f99648-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Sales Pipeline', '{"display_columns":[{"name":"name","label":"RLI Name","table_key":"self"},{"name":"name","label":"Opportunity Name","table_key":"RevenueLineItems:opportunities"},{"name":"name","label":"Account Name","table_key":"RevenueLineItems:account_link"},{"name":"date_closed","label":"Expected Close Date","table_key":"self"},{"name":"likely_case","label":"Likely","table_key":"self"},{"name":"full_name","label":"Sales Rep Name","table_key":"RevenueLineItems:assigned_user_link"}],"module":"RevenueLineItems","group_defs":[{"name":"sales_stage","label":"Sales Stage","table_key":"self","type":"enum","force_label":"Sales Stage"}],"summary_columns":[{"name":"sales_stage","label":"Sales Stage","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Sales Pipeline","chart_type":"funnelF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]},"RevenueLineItems:assigned_user_link":{"name":"Revenue Line Items  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"revenuelineitems_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"RevenueLineItems:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_7","Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_8"],"module":"Users","label":"Assigned to User"},"RevenueLineItems:opportunities":{"name":"Revenue Line Items  \u003E  Opportunities","parent":"self","link_def":{"name":"opportunities","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":false,"link_type":"one","label":"Opportunity Name","module":"Opportunities","table_key":"RevenueLineItems:opportunities"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4"],"module":"Opportunities","label":"Opportunity Name"},"RevenueLineItems:account_link":{"name":"Revenue Line Items  \u003E  Account","parent":"self","link_def":{"name":"account_link","relationship_name":"revenuelineitems_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"RevenueLineItems:account_link"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]},"1":{"name":"user_name","table_key":"RevenueLineItems:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything", "input_name1":"on"},"2":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'detailed_summary', 'funnelF', '', '638702cc-b609-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'New Leads This Quarter by Lead Source', '{"display_columns":[{"name":"full_name","label":"Name","table_key":"self"},{"name":"account_name","label":"Account Name","table_key":"self"},{"name":"title","label":"Title","table_key":"self"},{"name":"account_name","label":"Account Name","table_key":"self"},{"name":"phone_mobile","label":"Mobile","table_key":"self"},{"name":"email_address","label":"Email Address","table_key":"Leads:email_addresses_primary"},{"name":"phone_work","label":"Office Phone","table_key":"self"},{"name":"full_name","label":"Assigned To","table_key":"Leads:assigned_user_link"}],"module":"Leads","group_defs":[{"name":"lead_source","label":"Leads: Lead Source","table_key":"self","type":"enum","force_label":"Leads: Lead Source"}],"summary_columns":[{"name":"lead_source","label":"Leads: Lead Source","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"New Leads This Quarter by Lead Source","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"parent":"","value":"Leads","module":"Leads","label":"Leads","children":{"self_link_0":"self_link_0"}},"Leads:email_addresses_primary":{"name":"Leads  \u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"leads_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Leads:email_addresses_primary"},"dependents":["display_cols_row_9","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8"],"module":"EmailAddresses","label":"Email Address"},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["display_cols_row_10","display_cols_row_10","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","display_cols_row_10","Filter.1_table_filter_row_2","display_cols_row_10","Filter.1_table_filter_row_2","display_cols_row_10","Filter.1_table_filter_row_2","display_cols_row_10"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"lead_source","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Cold Call","Existing Customer","Self Generated","Employee","Partner","Public Relations","Direct Mail","Conference","Trade Show","Web Site","Word of mouth","Email","Campaign","Support Portal User Registration","Other"]},"1":{"name":"user_name","table_key":"Leads:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"},"2":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["New","Assigned","In Process","Converted","Recycled","Dead"]},"3":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'detailed_summary', 'hBarF', '', '038bbe8e-b60a-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Pipeline by Rep and Stage', '{"display_columns":[{"name":"full_name","label":"Sales Rep Name","table_key":"RevenueLineItems:assigned_user_link"},{"name":"name","label":"RLI Name","table_key":"self"},{"name":"name","label":"Opportunity Name","table_key":"RevenueLineItems:opportunities"},{"name":"name","label":"Account Name","table_key":"RevenueLineItems:account_link"},{"name":"date_closed","label":"Expected Close Date","table_key":"self"},{"name":"likely_case","label":"Likely","table_key":"self"}],"module":"RevenueLineItems","group_defs":[{"name":"user_name","label":"User Name","table_key":"RevenueLineItems:assigned_user_link","type":"username","force_label":"User Name"},{"name":"sales_stage","label":"Sales Stage","table_key":"self","type":"enum","force_label":"Sales Stage"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"RevenueLineItems:assigned_user_link"},{"name":"sales_stage","label":"Sales Stage","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Pipeline by Rep and Stage","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","order_by":[{"calculated":true,"name":"likely_case","vname":"Likely","required":true,"type":"currency","len":"26,6","audited":true,"showTransactionalAmount":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]},"RevenueLineItems:assigned_user_link":{"name":"Revenue Line Items  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"revenuelineitems_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"RevenueLineItems:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_7","group_by_row_2","display_summaries_row_group_by_row_2","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_3","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_4","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_4","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_4"],"module":"Users","label":"Assigned to User"},"RevenueLineItems:opportunities":{"name":"Revenue Line Items  \u003E  Opportunities","parent":"self","link_def":{"name":"opportunities","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":false,"link_type":"one","label":"Opportunity Name","module":"Opportunities","table_key":"RevenueLineItems:opportunities"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_5","display_cols_row_6","display_cols_row_6","display_cols_row_6"],"module":"Opportunities","label":"Opportunity Name"},"RevenueLineItems:account_link":{"name":"Revenue Line Items  \u003E  Account","parent":"self","link_def":{"name":"account_link","relationship_name":"revenuelineitems_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"RevenueLineItems:account_link"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_6","display_cols_row_7","display_cols_row_7","display_cols_row_7"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]},"1":{"name":"user_name","table_key":"RevenueLineItems:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"},"2":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'detailed_summary', 'hBarF', '', '5e59f588-b60a-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'My Pipeline Funnel (Revenue Line Items)', '{"display_columns":[{"name":"name","label":"RLI Name","table_key":"self"},{"name":"name","label":"Opportunity Name","table_key":"RevenueLineItems:opportunities"},{"name":"name","label":"Account Name","table_key":"RevenueLineItems:account_link"},{"name":"date_closed","label":"Expected Close Date","table_key":"self"},{"name":"likely_case","label":"Likely","table_key":"self"},{"name":"full_name","label":"Sales Rep Name","table_key":"RevenueLineItems:assigned_user_link"}],"module":"RevenueLineItems","group_defs":[{"name":"sales_stage","label":"Sales Stage","table_key":"self","type":"enum","force_label":"Sales Stage"}],"summary_columns":[{"name":"sales_stage","label":"Sales Stage","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"My Pipeline Funnel (Revenue Line Items)","chart_type":"funnelF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]},"RevenueLineItems:assigned_user_link":{"name":"Revenue Line Items  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"revenuelineitems_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"RevenueLineItems:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_7","Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_8"],"module":"Users","label":"Assigned to User"},"RevenueLineItems:opportunities":{"name":"Revenue Line Items  \u003E  Opportunities","parent":"self","link_def":{"name":"opportunities","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":false,"link_type":"one","label":"Opportunity Name","module":"Opportunities","table_key":"RevenueLineItems:opportunities"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4"],"module":"Opportunities","label":"Opportunity Name"},"RevenueLineItems:account_link":{"name":"Revenue Line Items  \u003E  Account","parent":"self","link_def":{"name":"account_link","relationship_name":"revenuelineitems_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"RevenueLineItems:account_link"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]},"1":{"name":"user_name","table_key":"RevenueLineItems:assigned_user_link","qualifier_name":"is","runtime":1,"input_name0":["Current User"]},"2":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'detailed_summary', 'funnelF', '', 'c197f334-b60a-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Opps Closed Won v Lost by Rep', '{"display_columns":[{"name":"full_name","label":"Rep Name","table_key":"Opportunities:assigned_user_link"},{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Opportunities:accounts"},{"name":"amount","label":"Likely","table_key":"self"}],"module":"Opportunities","group_defs":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link","type":"username","force_label":"User Name"},{"name":"sales_status","label":"Status","table_key":"self","type":"enum","force_label":"Status"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"},{"name":"sales_status","label":"Status","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Opps Closed Won v Lost by Rep","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_4","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_4","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_4","Filter.1_table_filter_row_3","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_4"],"module":"Users","label":"Assigned to User","optional":true},"Opportunities:accounts":{"name":"Opportunities  \u003E  Accounts","parent":"self","link_def":{"name":"accounts","relationship_name":"accounts_opportunities","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Opportunities:accounts"},"dependents":["display_cols_row_7","display_cols_row_6","display_cols_row_6","display_cols_row_6"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Closed Won","Closed Lost"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"},"2":{"name":"user_name","table_key":"Opportunities:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"}}}}', 'detailed_summary', 'vBarF', '', '55a10bf6-b60b-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'New Sales by Month', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self","type":"date","force_label":"Month: Expected Close Date"}],"summary_columns":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"New Sales by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_closed","table_key":"self","qualifier_name":"tp_current_fiscal_year","runtime":1,"input_name0":"tp_current_fiscal_year","input_name1":"on"}}}}', 'summary', 'vBarF', '', '72b638a6-b60b-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Pipeline by Month: Forecast Include/Exclude', '{"display_columns":[{"name":"name","label":"RLI Name","table_key":"self"},{"name":"name","label":"Opportunity Name","table_key":"RevenueLineItems:opportunities"},{"name":"name","label":"Account Name","table_key":"RevenueLineItems:account_link"},{"name":"date_closed","label":"Expected Close Date","table_key":"self"},{"name":"likely_case","label":"Likely","table_key":"self"},{"name":"full_name","label":"Sales Rep Name","table_key":"RevenueLineItems:assigned_user_link"}],"module":"RevenueLineItems","group_defs":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self","type":"date","force_label":"Month: Expected Close Date"},{"name":"commit_stage","label":"Forecast Stage","table_key":"self","type":"enum","force_label":"Forecast Stage"}],"summary_columns":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self"},{"name":"commit_stage","label":"Forecast Stage","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Pipeline by Month: Forecast Include/Exclude","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]},"RevenueLineItems:assigned_user_link":{"name":"Revenue Line Items  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"revenuelineitems_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"RevenueLineItems:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_7","Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_9","Filter.1_table_filter_row_2","display_cols_row_9","Filter.1_table_filter_row_2","display_cols_row_9"],"module":"Users","label":"Assigned to User"},"RevenueLineItems:opportunities":{"name":"Revenue Line Items  \u003E  Opportunities","parent":"self","link_def":{"name":"opportunities","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":false,"link_type":"one","label":"Opportunity Name","module":"Opportunities","table_key":"RevenueLineItems:opportunities"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5"],"module":"Opportunities","label":"Opportunity Name"},"RevenueLineItems:account_link":{"name":"Revenue Line Items  \u003E  Account","parent":"self","link_def":{"name":"account_link","relationship_name":"revenuelineitems_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"RevenueLineItems:account_link"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_6","display_cols_row_6","display_cols_row_6","display_cols_row_6"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]},"1":{"name":"user_name","table_key":"RevenueLineItems:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"},"2":{"name":"commit_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["include","exclude"]},"3":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'detailed_summary', 'vBarF', '', '8b5f5b6c-b60b-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Sales Leaderboard', '{"display_columns":[{"name":"full_name","label":"Sales Rep Name","table_key":"RevenueLineItems:assigned_user_link"},{"name":"name","label":"RLI Name","table_key":"self"},{"name":"name","label":"Opportunity Name","table_key":"RevenueLineItems:opportunities"},{"name":"name","label":"Account Name","table_key":"RevenueLineItems:account_link"},{"name":"date_closed","label":"Close Date","table_key":"self"},{"name":"likely_case","label":"Likely","table_key":"self"}],"module":"RevenueLineItems","group_defs":[{"name":"user_name","label":"User Name","table_key":"RevenueLineItems:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"RevenueLineItems:assigned_user_link"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Sales Leaderboard","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]},"RevenueLineItems:assigned_user_link":{"name":"Revenue Line Items  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"revenuelineitems_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"RevenueLineItems:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_7","group_by_row_2","display_summaries_row_group_by_row_2","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_3","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_3","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_3","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_3"],"module":"Users","label":"Assigned to User"},"RevenueLineItems:opportunities":{"name":"Revenue Line Items  \u003E  Opportunities","parent":"self","link_def":{"name":"opportunities","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":false,"link_type":"one","label":"Opportunity Name","module":"Opportunities","table_key":"RevenueLineItems:opportunities"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5"],"module":"Opportunities","label":"Opportunity Name"},"RevenueLineItems:account_link":{"name":"Revenue Line Items  \u003E  Account","parent":"self","link_def":{"name":"account_link","relationship_name":"revenuelineitems_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"RevenueLineItems:account_link"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_6","display_cols_row_6","display_cols_row_6","display_cols_row_6"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Closed Won"]},"1":{"name":"user_name","table_key":"RevenueLineItems:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"},"2":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'detailed_summary', 'hBarF', '', 'b10c0d56-b60b-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'BDR Revenue By Period', '{"display_columns":[{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Opportunities:accounts"},{"name":"full_name","label":"BDR Name","table_key":"Opportunities:leads:assigned_user_link"},{"name":"date_closed","label":"Close Date","table_key":"self"},{"name":"amount","label":"Amount","table_key":"self"},{"name":"full_name","label":"Sales Rep Name","table_key":"Opportunities:assigned_user_link"}],"module":"Opportunities","group_defs":[{"name":"user_name","label":"User Name","table_key":"Opportunities:leads:assigned_user_link","type":"username"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Opportunities:leads:assigned_user_link"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"BDR Revenue By Period","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:accounts":{"name":"Opportunities  \u003E  Accounts","parent":"self","link_def":{"name":"accounts","relationship_name":"accounts_opportunities","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Opportunities:accounts"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4","display_cols_row_4"],"module":"Accounts","label":"Account Name","optional":true},"Opportunities:leads":{"name":"Opportunities  \u003E  Leads ","parent":"self","link_def":{"name":"leads","relationship_name":"opportunity_leads","bean_is_lhs":true,"link_type":"many","label":"Leads","module":"Leads","table_key":"Opportunities:leads"},"dependents":["display_cols_row_5","display_cols_row_5","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_3","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5"],"module":"Leads","label":"Leads","optional":true},"Opportunities:leads:assigned_user_link":{"name":"Opportunities  \u003E  Leads  \u003E  Assigned to User","parent":"Opportunities:leads","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:leads:assigned_user_link"},"dependents":["display_cols_row_5","display_cols_row_5","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_3","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5"],"module":"Users","label":"Assigned to User","optional":true},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["display_cols_row_9","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Closed Won"]},"1":{"name":"user_name","table_key":"Opportunities:leads:assigned_user_link","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"},"2":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'detailed_summary', 'hBarF', '', 'af654b2e-b60c-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Lead Conversion Rate', '{"display_columns":[{"name":"lead_source","label":"Lead Source","table_key":"self"},{"name":"full_name","label":"Name","table_key":"self"},{"name":"account_name","label":"Account Name","table_key":"self"},{"name":"phone_work","label":"Office Phone","table_key":"self"},{"name":"phone_mobile","label":"Mobile","table_key":"self"},{"name":"email_address","label":"Email Address","table_key":"Leads:email_addresses_primary"}],"module":"Leads","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum","force_label":"Status"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Lead Conversion Rate","chart_type":"pieF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads"},"Leads:email_addresses_primary":{"name":"Leads  u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"leads_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Leads:email_addresses_primary"},"dependents":["display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_8"],"module":"EmailAddresses","label":"Email Address"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["New","Assigned","In Process","Converted"]}}}}', 'detailed_summary', 'pieF', '', 'cb5004fa-b60c-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Marketing Campaign ROI', '{"display_columns":[{"name":"name","label":"Campaign Name","table_key":"Opportunities:campaign_opportunities"},{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Opportunities:accounts"},{"name":"date_closed","label":"Close Date","table_key":"self"},{"name":"amount","label":"Revenue","table_key":"self"},{"name":"full_name","label":"Rep Name","table_key":"Opportunities:assigned_user_link"}],"module":"Opportunities","group_defs":[{"name":"name","label":"Name","table_key":"Opportunities:campaign_opportunities","type":"name","force_label":"Name"}],"summary_columns":[{"name":"name","label":"Name","table_key":"Opportunities:campaign_opportunities"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Marketing Campaign ROI","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:accounts":{"name":"Opportunities  \u003E  Accounts","parent":"self","link_def":{"name":"accounts","relationship_name":"accounts_opportunities","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Opportunities:accounts"},"dependents":["display_cols_row_4","display_cols_row_5","display_cols_row_5"],"module":"Accounts","label":"Account Name"},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["display_cols_row_7","display_cols_row_8","Filter.1_table_filter_row_4","Filter.1_table_filter_row_4","display_cols_row_8"],"module":"Users","label":"Assigned to User"},"Opportunities:campaign_opportunities":{"name":"Opportunities  \u003E  Campaign Opportunity","parent":"self","link_def":{"name":"campaign_opportunities","relationship_name":"campaign_opportunities","bean_is_lhs":false,"link_type":"one","label":"Campaign","module":"Campaigns","table_key":"Opportunities:campaign_opportunities"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","display_cols_row_10","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_3","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_3"],"module":"Campaigns","label":"Campaign"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Closed Won"]},"1":{"name":"lead_source","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Campaign"]},"2":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"},"3":{"name":"user_name","table_key":"Opportunities:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"}}}}', 'detailed_summary', 'vBarF', '', '126bc068-b60d-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'SQL Leads by Rep', '{"display_columns":[{"name":"full_name","label":"Name","table_key":"self"},{"name":"account_name","label":"Account Name","table_key":"self"},{"name":"email_address","label":"Email Address","table_key":"Leads:email_addresses_primary"},{"name":"phone_mobile","label":"Mobile","table_key":"self"},{"name":"phone_work","label":"Office Phone","table_key":"self"},{"name":"primary_address_city","label":"Primary Address City","table_key":"self"},{"name":"primary_address_state","label":"Primary Address State","table_key":"self"},{"name":"primary_address_postalcode","label":"Primary Address Postal Code","table_key":"self"},{"name":"full_name","label":"Assigned To","table_key":"Leads:assigned_user_link"}],"module":"Leads","group_defs":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Leads:assigned_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"SQL Leads by Rep","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads"},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_8","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_11","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_11","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_11"],"module":"Users","label":"Assigned to User","optional":true},"Leads:email_addresses_primary":{"name":"Leads  \u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"leads_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Leads:email_addresses_primary"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5"],"module":"EmailAddresses","label":"Email Address"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Converted"]},"1":{"name":"date_entered","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"},"2":{"name":"user_name","table_key":"Leads:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"}}}}', 'detailed_summary', 'vBarF', '', '56b54528-b60d-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Revenue Year Over Year', '{"display_columns":[{"name":"full_name","label":"Sales Rep Name","table_key":"RevenueLineItems:assigned_user_link"},{"name":"name","label":"RLI Name","table_key":"self"},{"name":"name","label":"Opportunity Name","table_key":"RevenueLineItems:opportunities"},{"name":"name","label":"Account Name","table_key":"RevenueLineItems:account_link"},{"name":"date_closed","label":"Close Date","table_key":"self"},{"name":"likely_case","label":"Likely","table_key":"self"}],"module":"RevenueLineItems","group_defs":[{"name":"date_closed","label":"Year: Expected Close Date","column_function":"year","qualifier":"year","table_key":"self","type":"date","force_label":"Year: Expected Close Date"}],"summary_columns":[{"name":"date_closed","label":"Year: Expected Close Date","column_function":"year","qualifier":"year","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Revenue Year Over Year ","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]},"RevenueLineItems:assigned_user_link":{"name":"Revenue Line Items  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"revenuelineitems_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"RevenueLineItems:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","display_cols_row_8","Filter.1_table_filter_row_2","display_cols_row_7","group_by_row_2","display_summaries_row_group_by_row_2","Filter.1_table_filter_row_2","display_cols_row_3","Filter.1_table_filter_row_2","display_cols_row_3","Filter.1_table_filter_row_2","display_cols_row_3","Filter.1_table_filter_row_2","display_cols_row_3","Filter.1_table_filter_row_2","display_cols_row_3"],"module":"Users","label":"Assigned to User"},"RevenueLineItems:opportunities":{"name":"Revenue Line Items  \u003E  Opportunities","parent":"self","link_def":{"name":"opportunities","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":false,"link_type":"one","label":"Opportunity Name","module":"Opportunities","table_key":"RevenueLineItems:opportunities"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5","display_cols_row_5"],"module":"Opportunities","label":"Opportunity Name"},"RevenueLineItems:account_link":{"name":"Revenue Line Items  \u003E  Account","parent":"self","link_def":{"name":"account_link","relationship_name":"revenuelineitems_accounts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"RevenueLineItems:account_link"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_6","display_cols_row_6","display_cols_row_6","display_cols_row_6","display_cols_row_6"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Closed Won"]},"1":{"name":"user_name","table_key":"RevenueLineItems:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"},"2":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'detailed_summary', 'vBarF', '', 'd9e6e668-b60d-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'MQL Leads by Period by Status', '{"display_columns":[{"name":"full_name","label":"Name","table_key":"self"},{"name":"title","label":"Title","table_key":"self"},{"name":"account_name","label":"Account Name","table_key":"self"},{"name":"email_address","label":"Email Address","table_key":"Leads:email_addresses_primary"},{"name":"phone_mobile","label":"Mobile","table_key":"self"},{"name":"phone_work","label":"Office Phone","table_key":"self"},{"name":"primary_address_street","label":"Primary Address Street","table_key":"self"},{"name":"primary_address_city","label":"Primary Address City","table_key":"self"},{"name":"primary_address_state","label":"Primary Address State","table_key":"self"},{"name":"primary_address_postalcode","label":"Primary Address Postal Code","table_key":"self"},{"name":"full_name","label":"Assigned To","table_key":"Leads:assigned_user_link"}],"module":"Leads","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum","force_label":"Status"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Q2 MQL Leads by Status","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads","dependents":[]},"Leads:email_addresses_primary":{"name":"Leads  \u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"leads_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Leads:email_addresses_primary"},"dependents":["display_cols_row_8","display_cols_row_6","display_cols_row_6","display_cols_row_6","display_cols_row_6"],"module":"EmailAddresses","label":"Email Address"},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["display_cols_row_18","display_cols_row_13","display_cols_row_13","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","display_cols_row_13","Filter.1_table_filter_row_2","display_cols_row_13"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["New","Assigned","In Process","Converted","Recycled","Dead"]},"1":{"name":"user_name","table_key":"Leads:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"},"2":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'detailed_summary', 'vBarF', '', '0ef7b53a-b60e-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Leads By Lead Source', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"lead_source","label":"Leads: Lead Source","table_key":"self","type":"enum","force_label":"Leads: Lead Source"}],"summary_columns":[{"name":"lead_source","label":"Leads: Lead Source","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Leads By Lead Source","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"parent":"","value":"Leads","module":"Leads","label":"Leads","children":{"self_link_0":"self_link_0"}}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"lead_source","table_key":"self","qualifier_name":"anything","runtime":1,"input_name0":"anything"}}}}', 'summary', 'vBarF', 'Number of leads created by lead source', '7ca07da6-b60e-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Total Sales by Quarter', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self","type":"date","force_label":"Quarter: Expected Close Date"},{"name":"opportunity_type","label":"Type","table_key":"self","type":"enum","force_label":"Type"}],"summary_columns":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self"},{"name":"opportunity_type","label":"Type","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Total Sales by Quarter","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["Filter.1_table_filter_row_3","Filter.1_table_filter_row_3"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"is","input_name0":["Closed Won"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"2":{"name":"user_name","table_key":"Opportunities:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'This report provides a chart of total sales broken down by type for each quarter of this year. Time period can be adjusted in the report using the run time filters. ', 'e314b4ee-b60e-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Top Grossing Products This Year', '{"display_columns":[],"module":"RevenueLineItems","group_defs":[{"name":"name","label":"Product Category","table_key":"RevenueLineItems:rli_categories_link","type":"name","force_label":"Product Category"}],"summary_columns":[{"name":"name","label":"Product Category","table_key":"RevenueLineItems:rli_categories_link"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self","sort_dir":"d"}],"summary_order_by":[{"name":"likely_case","group_function":"sum","column_function":"sum","table_key":"self","sort_dir":"d"}],"report_name":"Top Grossing Products This Year","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]},"RevenueLineItems:rli_categories_link":{"name":"Revenue Line Items  \u003E  Product Categories","parent":"self","link_def":{"name":"rli_categories_link","relationship_name":"revenuelineitem_categories","bean_is_lhs":false,"link_type":"one","label":"Product Category","module":"ProductCategories","table_key":"RevenueLineItems:rli_categories_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"ProductCategories","label":"Product Category","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"is","input_name0":["Closed Won"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'summary', 'hBarF', 'Monthly sales of products this year. Time period can be adjusted in the report using the run time filters.', '6722c41e-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Opportunities with No Calls, Meetings, Tasks, or Emails', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link","type":"username"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"},{"name":"count","label":"Number of Opportunities","field_type":"","group_function":"count","table_key":"self","sort_dir":"d"}],"summary_order_by":[{"name":"count","vname":"Count","group_function":"count","summary_type":"group","table_key":"self","sort_dir":"d"}],"report_name":"Opportunities with No Calls, Meetings, Tasks, or Emails","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:calls":{"name":"Opportunities  \u003E  Calls","parent":"self","link_def":{"name":"calls","relationship_name":"opportunity_calls","bean_is_lhs":true,"link_type":"many","label":"Calls","module":"Calls","table_key":"Opportunities:calls"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_1","Filter.1_table_filter_row_1","Filter.1_table_filter_row_1"],"module":"Calls","label":"Calls","optional":true},"Opportunities:meetings":{"name":"Opportunities  \u003E  Meetings","parent":"self","link_def":{"name":"meetings","relationship_name":"opportunity_meetings","bean_is_lhs":true,"link_type":"many","label":"Meetings","module":"Meetings","table_key":"Opportunities:meetings"},"dependents":["Filter.1_table_filter_row_3","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Meetings","label":"Meetings","optional":true},"Opportunities:tasks":{"name":"Opportunities  \u003E  Tasks","parent":"self","link_def":{"name":"tasks","relationship_name":"opportunity_tasks","bean_is_lhs":true,"link_type":"many","label":"Tasks","module":"Tasks","table_key":"Opportunities:tasks"},"dependents":["Filter.1_table_filter_row_4","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3"],"module":"Tasks","label":"Tasks","optional":true},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true},"Opportunities:emails":{"name":"Opportunities  \u003E  Emails","parent":"self","link_def":{"name":"emails","relationship_name":"emails_opportunities_rel","bean_is_lhs":false,"link_type":"many","label":"Emails","module":"Emails","table_key":"Opportunities:emails"},"dependents":["Filter.1_table_filter_row_5"],"module":"Emails","label":"Emails","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"id","table_key":"Opportunities:calls","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"1":{"name":"id","table_key":"Opportunities:meetings","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"2":{"name":"id","table_key":"Opportunities:tasks","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"3":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","input_name0":["New","In Progress"]},"4":{"name":"id","table_key":"Opportunities:emails","qualifier_name":"empty","input_name0":"empty","input_name1":"on"}}}}', 'summary', 'hBarF', 'Summary count of opportunities where no activity has taken place or is scheduled.  Those opportunities are counted that have no calls, meetings or tasks scheduled or completed.', '7b2bf4b2-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Top Sales Reps This Quarter', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link","type":"username"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self","sort_dir":"d"}],"summary_order_by":[{"name":"amount","group_function":"sum","column_function":"sum","table_key":"self","sort_dir":"d"}],"report_name":"Top Sales Reps This Quarter","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"is","input_name0":["Closed Won"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'summary', 'none', 'This report summarizes total sales by each assigned user for the current quarter and identify the top selling reps. Time period can be adjusted in the report using the run time filters.', '812bca7c-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Pipeline Funnel (Revenue Line Items)', '{"display_columns":[],"module":"RevenueLineItems","group_defs":[{"name":"sales_stage","label":"Sales Stage","table_key":"self","type":"enum","force_label":"Sales Stage"}],"summary_columns":[{"name":"sales_stage","label":"Sales Stage","table_key":"self"},{"name":"likely_case","label":"Pipeline Amount ","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Pipeline Funnel (Revenue Line Items)","chart_type":"funnelF","do_round":1,"chart_description":"Pipeline Funnel (RLI)","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"commit_stage","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"},"1":{"name":"sales_stage","table_key":"self","qualifier_name":"one_of","input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]},"2":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'summary', 'funnelF', 'This report shows a funnel chart of the revenue line item pipeline. Use the run time filters to include only forecasted revenue line items.', '8fbe83b8-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Open Opportunities and Number of Meetings', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"name","label":"Opportunity Name","table_key":"self","type":"name","force_label":"Opportunity Name"}],"summary_columns":[{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"count","label":"Number of Meetings","field_type":"","group_function":"count","table_key":"Opportunities:meetings","sort_dir":"a"}],"report_name":"Open Opportunities and Number of Meetings","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"Opportunities:meetings:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","summary_order_by":[{"name":"count","vname":"Count","group_function":"count","summary_type":"group","table_key":"Opportunities:meetings","sort_dir":"a"}],"full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:meetings":{"name":"Opportunities  \u003E  Meetings","parent":"self","link_def":{"name":"meetings","relationship_name":"opportunity_meetings","bean_is_lhs":true,"link_type":"many","label":"Meetings","module":"Meetings","table_key":"Opportunities:meetings"},"dependents":["display_summaries_row_2","display_summaries_row_2","Filter.1_table_filter_row_2"],"module":"Meetings","label":"Meetings","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["New","In Progress"]},"1":{"name":"status","table_key":"Opportunities:meetings","qualifier_name":"is","runtime":1,"input_name0":["Planned"]}}}}', 'summary', 'none', 'A list of all open opportunities and the number of meetings currently scheduled for each. Use the run time filters to select only scheduled or held meetings. Select the opportunity status to filter on opportunities that are closed won or lost.', 'a2aad4cc-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Total Sales by Quarter by User', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self","type":"date"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link","type":"username"}],"summary_columns":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Total Sales by Quarter by User","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"is","input_name0":["Closed Won"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'This report summarizes total sales by each assigned user for each quarter of this year. This report can be used to compare sales person performance. Time period can be adjusted in the report using the run time filters.', 'b0c09632-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Open Opportunities by User by Expected Close Month', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self","type":"date"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link","type":"username"}],"summary_columns":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Open Opportunities by User by Expected Close Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","input_name0":["New","In Progress"]}}}}', 'Matrix', 'vBarF', 'Summary of opportunities for each user by expected close month.', 'c115200c-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Number of Opportunities Created by Users by Month', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link","type":"username"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Number of Opportunities created by User by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"1":{"name":"sales_status","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Summary of the number of all opportunities created this year by each user. This gives a sense of which sales persons are generating the opportunities. Time period can also be adjusted in the run time filters.', 'ce0cd890-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'My Open Opportunities', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Opportunities:accounts"},{"name":"amount","label":"Likely","table_key":"self"},{"name":"sales_status","label":"Status","table_key":"self"},{"name":"date_closed","label":"Expected Close Date","table_key":"self"},{"name":"next_step","label":"Next Step","table_key":"self"}],"module":"Opportunities","group_defs":[],"summary_columns":[],"report_name":"My Open Opportunities","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["Filter.1_table_filter_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_3"],"module":"Users","label":"Assigned to User","optional":true},"Opportunities:accounts":{"name":"Opportunities  \u003E  Accounts","parent":"self","link_def":{"name":"accounts","relationship_name":"accounts_opportunities","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Opportunities:accounts"},"dependents":["display_cols_row_8","display_cols_row_3","display_cols_row_3"],"module":"Accounts","label":"Account Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_month","runtime":1,"input_name0":"tp_this_month","input_name1":"on"},"1":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["New","In Progress"]},"2":{"name":"user_name","table_key":"Opportunities:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'tabular', 'none', 'List of Opportunities assigned to me that are still open and are expected to close this month. Time period can be adjusted in the report using the run time filters.', 'e3e8ce08-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Number of Opportunities created by Team by Month', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self","type":"date"},{"name":"name","label":"Primary Team Name","table_key":"Opportunities:team_link","type":"name"}],"summary_columns":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self"},{"name":"name","label":"Primary Team Name","table_key":"Opportunities:team_link"},{"name":"count","label":"Number of Opportunities","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Number of Opportunities Created by Team by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"},"Opportunities:team_link":{"name":"Opportunities  \u003E  Teams","parent":"self","link_def":{"name":"team_link","relationship_name":"opportunities_team","bean_is_lhs":false,"link_type":"one","label":"Teams","module":"Teams","table_key":"Opportunities:team_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Teams","label":"Teams","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Summary of the number of all opportunities created this year grouped by primary team assigned. This gives a sense of which teams are generating the opportunities. Time period can also be adjusted in the run time filters.', 'ed1cbd18-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Pipeline By Type By Team', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"name","label":"Primary Team Name","table_key":"Opportunities:team_link","type":"name"},{"name":"opportunity_type","label":"Type","table_key":"self","type":"enum"}],"summary_columns":[{"name":"name","label":"Team: Team Name","table_key":"Opportunities:team_link"},{"name":"opportunity_type","label":"Opportunities: Type","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"Opportunities:revenuelineitems"}],"report_name":"Pipeline By Type By Team","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"Opportunities:revenuelineitems:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:team_link":{"parent":"self","label":"Team","link_def":{"name":"team_link","relationship_name":"opportunities_team","bean_is_lhs":"","link_type":"one","label":"Team","table_key":"Opportunities:team_link"},"module":"Teams","name":"Opportunities  \u003E  Teams","dependents":["group_by_row_1","display_summaries_row_group_by_row_1"]},"Opportunities:revenuelineitems":{"name":"Opportunities  \u003E  Revenue Line Items","parent":"self","link_def":{"name":"revenuelineitems","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":true,"link_type":"many","label":"Revenue Line Items","module":"RevenueLineItems","table_key":"Opportunities:revenuelineitems"},"module":"RevenueLineItems","label":"Revenue Line Items"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"Opportunities:revenuelineitems","qualifier_name":"one_of","input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]}}}}', 'summary', 'hBarF', 'Summarizes the open pipeline by team.', 'f507ad80-bea8-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Pipeline By Team By User', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"name","label":"Team: Team Name","table_key":"Opportunities:team_link","type":"name","force_label":"Team: Team Name"},{"name":"user_name","label":"Assigned to User: User Name","table_key":"Opportunities:assigned_user_link","type":"username","force_label":"Assigned to User: User Name"}],"summary_columns":[{"name":"name","label":"Team: Team Name","table_key":"Opportunities:team_link"},{"name":"user_name","label":"Assigned to User: User Name","table_key":"Opportunities:assigned_user_link"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"Opportunities:revenuelineitems"}],"report_name":"Pipeline By Team By User","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"Opportunities:revenuelineitems:likely_case:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:team_link":{"parent":"self","label":"Team","link_def":{"name":"team_link","relationship_name":"opportunities_team","bean_is_lhs":"","link_type":"one","label":"Team","table_key":"Opportunities:team_link"},"module":"Teams","name":"Opportunities  \u003E  Teams","dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"]},"Opportunities:assigned_user_link":{"parent":"self","label":"Assigned to User","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":"","link_type":"one","label":"Assigned to User","table_key":"Opportunities:assigned_user_link"},"module":"Users","name":"Opportunities  \u003E  Assigned to User","dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"]},"Opportunities:revenuelineitems":{"name":"Opportunities  \u003E  Revenue Line Items","parent":"self","link_def":{"name":"revenuelineitems","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":true,"link_type":"many","label":"Revenue Line Items","module":"RevenueLineItems","table_key":"Opportunities:revenuelineitems"},"module":"RevenueLineItems","label":"Revenue Line Items","dependents":["Filter.1_table_filter_row_1","display_summaries_row_3"]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"Opportunities:revenuelineitems","qualifier_name":"one_of","input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]}}}}', 'summary', 'hBarF', 'Summarizes the open pipeline by user.', '04074656-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'All Open Opportunities', '{"display_columns":[{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"opportunity_type","label":"Type","table_key":"self"},{"name":"sales_stage","label":"Sales Stage","table_key":"Opportunities:revenuelineitems"},{"name":"date_closed","label":"Expected Close Date","table_key":"self"},{"name":"amount_usdollar","label":"Amount","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"}],"module":"Opportunities","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_closed","vname":"Expected Close Date","type":"date","audited":"1","importable":"required","table_key":"self","sort_dir":"a"}],"report_name":"All Open Opportunities","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Opportunities:assigned_user_link"},"dependents":["display_cols_row_6","display_cols_row_6"],"module":"Users","label":"Assigned to User"},"Opportunities:revenuelineitems":{"name":"Opportunities  \u003E  Revenue Line Items","parent":"self","link_def":{"name":"revenuelineitems","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":true,"link_type":"many","label":"Revenue Line Items","module":"RevenueLineItems","table_key":"Opportunities:revenuelineitems"},"module":"RevenueLineItems","label":"Revenue Line Items"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"Opportunities:revenuelineitems","qualifier_name":"one_of","runtime":1,"input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"undefined","input_name1":"on"}}}}', 'tabular', 'none', 'List of open opportunities', '0c9bd1e2-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'All Closed Opportunities', '{"display_columns":[{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"opportunity_type","label":"Type","table_key":"self"},{"name":"sales_stage","label":"Sales Stage","table_key":"Opportunities:revenuelineitems"},{"name":"date_closed","label":"Expected Close Date","table_key":"self"},{"name":"amount_usdollar","label":"Amount","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"}],"module":"Opportunities","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_closed","vname":"Expected Close Date","type":"date","audited":"1","importable":"required","table_key":"self","sort_dir":"a"}],"report_name":"All Closed Opportunities","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Opportunities:assigned_user_link"},"dependents":["display_cols_row_8"],"module":"Users","label":"Assigned to User"},"Opportunities:revenuelineitems":{"name":"Opportunities  \u003E  Revenue Line Items","parent":"self","link_def":{"name":"revenuelineitems","relationship_name":"opportunities_revenuelineitems","bean_is_lhs":true,"link_type":"many","label":"Revenue Line Items","module":"RevenueLineItems","table_key":"Opportunities:revenuelineitems"},"module":"RevenueLineItems","label":"Revenue Line Items"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"Opportunities:revenuelineitems","qualifier_name":"one_of","runtime":1,"input_name0":["Closed Won","Closed Lost"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"undefined","input_name1":"on"}}},"chart_type":"none"}', 'tabular', 'none', 'List of all closed opportunities', '13a3e0ce-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Revenue Line Items Sold by Type this Quarter', '{"display_columns":[],"module":"RevenueLineItems","group_defs":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self","type":"date"},{"name":"product_type","label":"Type","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self"},{"name":"product_type","label":"Type","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Revenue Line Items Sold by Type this Quarter","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"is","input_name0":["Closed Won"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'This report provides a chart of total sales broken down by type for each quarter of this year. Time period can be adjusted in the report using the run time filters.', '1f3e0f22-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Open Opportunities by Expected Close Month', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self","type":"date"}],"summary_columns":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Open Opportunities by Expected Close Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"},"1":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","input_name0":["New","In Progress"]}}}}', 'summary', 'vBarF', 'Summary of all open opportunities by expected close month. Details of the opportunities are also listed in this report.', '2f627140-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['RevenueLineItems', 'Revenue Line Items by Product', '{"display_columns":[],"module":"RevenueLineItems","group_defs":[{"name":"name","label":"Revenue Line Item","table_key":"self","type":"name"}],"summary_columns":[{"name":"name","label":"Revenue Line Item","table_key":"self"},{"name":"likely_case","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Revenue Line Items by Product","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:likely_case:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"RevenueLineItems","module":"RevenueLineItems","label":"RevenueLineItems"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_stage","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Prospecting","Qualification","Needs Analysis","Value Proposition","Id. Decision Makers","Perception Analysis","Proposal\/Price Quote","Negotiation\/Review"]},"1":{"name":"commit_stage","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"},"2":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'summary', 'none', 'Summary of all RLI\'s by product. Use the run time filters to include only forecasted revenue line items. You can also change the time period and the sales stage of the revenue line item.', '35eab9f0-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Wins and Losses by Users this Quarter', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link","type":"username","force_label":"User Name"},{"name":"sales_status","label":"Status","table_key":"self","type":"enum","force_label":"Status"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Opportunities:assigned_user_link"},{"name":"sales_status","label":"Status","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Wins and Losses by Users this Quarter","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"},"Opportunities:assigned_user_link":{"name":"Opportunities  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"opportunities_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Opportunities:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","input_name0":["Closed Won","Closed Lost"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'none', 'The total amount of opportunities won vs lost by each assigned user in the current quarter. Time period can be adjusted in the run time filters.', '410d4c30-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Open Opportunities and Number of Calls', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"name","label":"Opportunity Name","table_key":"self","type":"name"}],"summary_columns":[{"name":"name","label":"Opportunity Name","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"Opportunities:calls","sort_dir":"a"}],"summary_order_by":[{"name":"count","vname":"Count","group_function":"count","summary_type":"group","table_key":"Opportunities:calls","sort_dir":"a"}],"report_name":"Open Opportunities and Number of Calls","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"Opportunities:calls:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities","dependents":[]},"Opportunities:calls":{"name":"Opportunities  \u003E  Calls","parent":"self","link_def":{"name":"calls","relationship_name":"opportunity_calls","bean_is_lhs":true,"link_type":"many","label":"Calls","module":"Calls","table_key":"Opportunities:calls"},"dependents":["Filter.1_table_filter_row_3","display_summaries_row_3"],"module":"Calls","label":"Calls","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["New","In Progress"]},"1":{"name":"status","table_key":"Opportunities:calls","qualifier_name":"is","runtime":1,"input_name0":["Planned"]}}}}', 'summary', 'none', 'A list of all open opportunities and the number of calls currently scheduled for each. Use the run time filters to select only scheduled or held meetings. Select the opportunity status to filter on opportunities that are closed won or lost.', '4a92f61a-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Sales per Quarter by Lead Source', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self","type":"date"},{"name":"lead_source","label":"Lead Source","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_closed","label":"Quarter: Expected Close Date","column_function":"quarter","qualifier":"quarter","table_key":"self"},{"name":"lead_source","label":"Lead Source","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Sales per Quarter by Lead Source","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"1":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","input_name0":["Closed Won"]}}}}', 'Matrix', 'vBarF', 'This report provides a summary of all closed won sales for each quarter this year grouped by the lead source. This provides an indication of which sources of leads are generating sales. Time period can be adjusted on the report using the run time filter.', '4f96dc3a-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Open Opportunities by Type by Expected Closed Month', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self","type":"date"},{"name":"opportunity_type","label":"Type","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_closed","label":"Month: Expected Close Date","column_function":"month","qualifier":"month","table_key":"self"},{"name":"opportunity_type","label":"Type","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Open Opportunities by Type by Expected Closed Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"currency","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"sales_status","table_key":"self","qualifier_name":"one_of","input_name0":["New","In Progress"]}}}}', 'Matrix', 'vBarF', 'Summary of opportunities by expected close month grouped by type.', '5a09ac60-bea9-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Opportunities', 'Opportunities Created by Lead Source by Month', '{"display_columns":[],"module":"Opportunities","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime","force_label":"Month: Date Created"},{"name":"lead_source","label":"Lead Source","table_key":"self","type":"enum","force_label":"Lead Source"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"lead_source","label":"Lead Source","table_key":"self"},{"name":"amount","label":"SUM: Likely","field_type":"currency","group_function":"sum","table_key":"self"}],"report_name":"Opportunities Created by Lead Source by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:amount:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Opportunities","module":"Opportunities","label":"Opportunities"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"1":{"name":"sales_status","table_key":"self","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Monthly summary of all opportunities created this year grouped by lead source. This report gives a sense of which source are generating most opportunities.  You can also toggle between open or closed won opportunities. Use the run time filter to change time period.', '60c080c4-bea9-11ee-9d94-095590d26ca4'];

    return $stock_reports;
}

function get_customer_service_reports($is_upgrade = false)
{
    global $current_language;

    $lang_strings = return_module_language($current_language, 'Reports');
    $stock_reports = [];
    $stock_reports[] = ['Bugs', 'My Open Bugs by Priority', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Open Bugs by Priority","chart_type":"pieF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs"},"Bugs:assigned_user_link":{"name":"Bugs  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"bugs_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Bugs:assigned_user_link"},"dependents":["Filter.1_table_filter_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Bugs:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending"]}}}}', 'summary', 'pieF', 'List of my open bugs summarized by priority.', 'f794d4d6-beaa-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Open Cases by User by Priority', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","type":"username"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Cases by User by Priority","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending Input"]}}}}', 'Matrix', 'hBarF', 'Number of cases assigned to each user and the priority of the bug. This report gives a sense of the workload of users working on the cases.', '21fee7de-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Bugs Created by Month By Priority', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"date_entered","label":"Quarter: Date Created","column_function":"quarter","qualifier":"quarter","table_key":"self","type":"datetime"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Quarter: Date Created","column_function":"quarter","qualifier":"quarter","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Bugs Created by Month By Priority","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of bugs created each month summarized by their priority. This report provides a trend on the number of bugs.', '2bbb14be-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Open Cases by User by Status', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","type":"username"},{"name":"status","label":"Status","table_key":"self","type":"enum"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link"},{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Cases by User by Status","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending Input"]}}}}', 'Matrix', 'hBarF', 'Number of cases assigned to each user and the current status of the bug. This report gives a sense of which cases needs attention the most.', '3b90b1dc-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Bugs by Product Category by Status', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"product_category","label":"Category","table_key":"self","type":"enum"},{"name":"status","label":"Status","table_key":"self","type":"enum"}],"summary_columns":[{"name":"product_category","label":"Category","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Bugs by Product Category by Status","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'hBarF', 'Number of bugs created by category and their current status. This report gives a sense of which area of the product generates bugs. Time period can be adjusted in the report using run time filters.', '4a831996-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Bugs Created by Month By Category', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime"},{"name":"product_category","label":"Category","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"product_category","label":"Category","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Bugs Created by Month By Category","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of bugs created each month summarized by the category. This report provides a trend on the number of bugs being generated across category.', '552cbbc2-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Summary of Bugs by Status by Week Created', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"},{"name":"status","label":"Status","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Summary of Bugs by Status by Week Created ","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of bugs created each week by status.  Time period can be adjusted in the report using the run time filters.', '5d18bbd8-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Summary of Bugs by Source by Week Created', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"},{"name":"source","label":"Source","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"source","label":"Source","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Summary of Bugs by Source by Week Created","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of bugs created each week by source.  Time period can be adjusted in the report using the run time filters.', '6971012e-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Summary of Open Cases by Priority', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"priority","label":"Priority","table_key":"self","type":"enum","force_label":"Priority"}],"summary_columns":[{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Summary of Open Cases by Priority","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending Input"]}}}}', 'summary', 'hBarF', 'Number of cases that are still open summarized by priority of bug.', '70441cb6-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Open Cases By Month By User', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime"},{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","type":"username"}],"summary_columns":[{"name":"date_entered","label":"Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"user_name","label":"Assigned to User","table_key":"Cases:assigned_user_link"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Cases By Month By User","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"parent":"self","label":"Assigned to User","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":"","link_type":"one","label":"Assigned to User","table_key":"Cases:assigned_user_link"},"module":"Users","name":"Cases  \u003E  Assigned to User","dependents":["group_by_row_2","display_summaries_row_group_by_row_2"],"optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending Input"]}}}}', 'summary', 'vBarF', 'List of open cases by created month and grouped by user.', '89941d10-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My Open Cases by Priority', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Open Cases by Priority","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["Filter.1_table_filter_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'summary', 'hBarF', 'List of my open cases summarized by priority.', 'a2d6a900-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Summary of Bugs by Priority by Week Created', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Summary of Bugs by Priority by Week Created ","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of bugs created each week by priority.  Time period can be adjusted in the report using the run time filters.', 'ab73a400-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Summary of Cases by Status by Week Created', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime","force_label":"Week: Date Created"},{"name":"status","label":"Status","table_key":"self","type":"enum","force_label":"Status"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Summary of Cases by Status by Week Created","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of cases created each week by status.  Time period can be adjusted in the report using the run time filters.', 'b35ea2a0-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Cases with No Calls, Meetings, Tasks, or Emails', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","type":"username"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Cases with No Calls, Meetings, Tasks, or Emails","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:calls":{"name":"Cases  \u003E  Calls","parent":"self","link_def":{"name":"calls","relationship_name":"case_calls","bean_is_lhs":true,"link_type":"many","label":"Calls","module":"Calls","table_key":"Cases:calls"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Calls","label":"Calls","optional":true},"Cases:tasks":{"name":"Cases  \u003E  Tasks","parent":"self","link_def":{"name":"tasks","relationship_name":"case_tasks","bean_is_lhs":true,"link_type":"many","label":"Tasks","module":"Tasks","table_key":"Cases:tasks"},"dependents":["Filter.1_table_filter_row_3","Filter.1_table_filter_row_3"],"module":"Tasks","label":"Tasks","optional":true},"Cases:meetings":{"name":"Cases  \u003E  Meetings","parent":"self","link_def":{"name":"meetings","relationship_name":"case_meetings","bean_is_lhs":true,"link_type":"many","label":"Meetings","module":"Meetings","table_key":"Cases:meetings"},"dependents":["Filter.1_table_filter_row_4","Filter.1_table_filter_row_4"],"module":"Meetings","label":"Meetings","optional":true},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true},"Cases:emails":{"name":"Cases  \u003E  Emails","parent":"self","link_def":{"name":"emails","relationship_name":"emails_cases_rel","bean_is_lhs":false,"link_type":"many","label":"Emails","module":"Emails","table_key":"Cases:emails"},"dependents":["Filter.1_table_filter_row_5"],"module":"Emails","label":"Emails","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending Input"]},"1":{"name":"id","table_key":"Cases:calls","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"2":{"name":"id","table_key":"Cases:tasks","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"3":{"name":"id","table_key":"Cases:meetings","qualifier_name":"empty","input_name0":"empty","input_name1":"on"},"4":{"name":"id","table_key":"Cases:emails","qualifier_name":"empty","input_name0":"empty","input_name1":"on"}}}}', 'Matrix', 'none', 'Summary count of cases where no activity has taken place or is scheduled.  Those cases are counted that have no calls, meetings or tasks scheduled or completed.', 'cd00118a-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Summary of Cases by Priority by Week Created', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Summary of Cases by Priority by Week Created ","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of cases created each week by priority.  Time period can be adjusted in the report using the run time filters.', 'd6b4bff0-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Open Bugs by User by Priority', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"user_name","label":"User Name","table_key":"Bugs:assigned_user_link","type":"username"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Bugs:assigned_user_link"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Bugs by User by Priority","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs","dependents":[]},"Bugs:assigned_user_link":{"name":"Bugs  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"bugs_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Bugs:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_3","display_summaries_row_group_by_row_3"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending"]}}}}', 'Matrix', 'none', 'Number of bugs assigned to each user grouped by priority of the bug. This report gives a sense of which bugs needs attention the most.', 'dc7ed948-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Summary of Cases by Source by Week Created', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"},{"name":"source","label":"Source","table_key":"self","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"source","label":"Source","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Summary of Cases by Source by Week Created ","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of cases created each week by source.  Time period can be adjusted in the report using the run time filters.', 'e8aab08e-beab-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Bugs', 'Open Bugs by User by Status', '{"display_columns":[],"module":"Bugs","group_defs":[{"name":"user_name","label":"User Name","table_key":"Bugs:assigned_user_link","type":"username"},{"name":"status","label":"Status","table_key":"self","type":"enum"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Bugs:assigned_user_link"},{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Bugs by User by Status","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Bugs","module":"Bugs","label":"Bugs","dependents":[]},"Bugs:assigned_user_link":{"name":"Bugs  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"bugs_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Bugs:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["New","Assigned","Pending"]}}}}', 'Matrix', 'none', 'Number of bugs assigned to each user and the priority of the bug. This report gives a sense of the workload of users working on the bugs.', 'f7fb307a-bead-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'New Cases Opened by Month', '{"display_columns":[{"name":"name","label":"Subject","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"full_name","label":"Assigned To","table_key":"Cases:assigned_user_link"}],"module":"Cases","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"date","force_label":"Month: Date Created"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"New Cases Opened by Month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:accounts":{"name":"Cases  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_4"],"module":"Accounts","label":"Account Name"},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["display_cols_row_8","display_cols_row_7","display_cols_row_7"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","input_name0":"tp_this_year","input_name1":"on","runtime":1}}}}', 'detailed_summary', 'vBarF', '', 'f4b4c6be-b60c-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Closed Cases by Time to Resolution', '{"display_columns":[{"name":"name","label":"Subject","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"date_entered","label":"Date Opened","table_key":"self"},{"name":"hours_to_resolution","label":"Hours to Resolution","table_key":"self"}],"module":"Cases","group_defs":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link"},{"name":"hours_to_resolution","label":"AVG: Hours to Resolution","field_type":"decimal","group_function":"avg","table_key":"self"}],"report_name":"Closed Cases by Time to Resolution","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:hours_to_resolution:avg","numerical_chart_column_type":"decimal","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User"},"Cases:accounts":{"name":"Cases  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_4","display_cols_row_4","display_cols_row_4"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Closed"]},"1":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"anything","input_name0":"anything","input_name0":"on"}}}}', 'detailed_summary', 'hBarF', '', 'fb59371c-b60b-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Cases That Missed the First Response SLA', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Day: Date Created","column_function":"day","qualifier":"day","table_key":"self","type":"datetime"},{"name":"user_name","label":"User Name","table_key":"Cases:first_response_user_link","type":"username"}],"summary_columns":[{"name":"date_entered","label":"Day: Date Created","column_function":"day","qualifier":"day","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Cases:first_response_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Cases That Missed the First Response SLA","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:first_response_user_link":{"name":"Cases  \u003E  First Response User","parent":"self","link_def":{"name":"first_response_user_link","relationship_name":"cases_first_response_user","bean_is_lhs":false,"link_type":"one","label":"First Response User","module":"Users","table_key":"Cases:first_response_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"First Response User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"tp_last_7_days","input_name1":"on"},"1":{"name":"first_response_sla_met","table_key":"self","qualifier_name":"is","input_name0":["No"]}}}}', 'Matrix', 'vBarF', 'The number of cases that missed their first response SLA in the last 7 days. The time period can be changed using the run-time filter.', 'b70b8bb8-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Users', 'AUDIT: User Status', '{"display_columns":[{"name":"id","label":"ID","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"first_name","label":"First Name","table_key":"self"},{"name":"last_name","label":"Last Name","table_key":"self"},{"name":"full_name","label":"Full Name","table_key":"self"},{"name":"address_city","label":"Address City","table_key":"self"},{"name":"address_country","label":"Address Country","table_key":"self"},{"name":"is_admin","label":"Is Administrator","table_key":"self"},{"name":"portal_only","label":"Portal API User","table_key":"self"},{"name":"date_entered","label":"Date Entered","table_key":"self"},{"name":"date_modified","label":"Date Modified","table_key":"self"},{"name":"last_login","label":"last login","table_key":"self"},{"name":"pwd_last_changed","label":"Password Last Changed","table_key":"self"}],"module":"Users","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum","force_label":"Status"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"AUDIT: User Status","chart_type":"vGBarF","do_round":1,"chart_description":"This report displays the number of users per status.","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","order_by":[{"name":"date_entered","vname":"Date Entered","type":"datetime","required":true,"readonly":true,"calculation_visible":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Users","module":"Users","label":"Users"}},"filters_def":{"Filter_1":{"operator":"AND"}}}', 'detailed_summary', 'vGBarF', 'This report displays the number of users per status.', '1a094f7e-1ba3-11ef-b364-9ec2aa760073'];
    $stock_reports[] = ['Contacts', 'AUDIT: Portal Enabled Contacts', '{"display_columns":[{"name":"id","label":"ID","table_key":"self"},{"name":"portal_name","label":"Portal Name","table_key":"self"},{"name":"portal_user_company_name","label":"Portal User Company Name","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"date_modified","label":"Date Modified","table_key":"self"},{"name":"portal_active","label":"Portal Active","table_key":"self"}],"module":"Contacts","group_defs":[{"name":"portal_active","label":"Portal Active","table_key":"self","type":"bool"}],"summary_columns":[{"name":"portal_active","label":"Portal Active","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"report_name":"AUDIT: Portal Enabled Contacts","chart_type":"vGBarF","do_round":1,"chart_description":"This report displays the number of contacts whose Portal Active field is enabled.","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Contacts","module":"Contacts","label":"Contacts"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"portal_active","table_key":"self","qualifier_name":"equals","input_name0":["yes"]}}}}', 'detailed_summary', 'vGBarF', 'This report displays the number of contacts whose Portal Active field is enabled.', '9ffae228-1ba3-11ef-a143-9ec2aa760073'];

    // added in 9.1.0 & 9.3.0
    $stock_reports[] = ['Cases', 'Total Cases Resolved this Month by Agent', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"user_name","label":"Assigned to User","table_key":"Cases:assigned_user_link","type":"username","force_label":"Assigned to User"},{"name":"priority","label":"Priority","table_key":"self","type":"enum","force_label":"Priority"}],"summary_columns":[{"name":"user_name","label":"Assigned to User","table_key":"Cases:assigned_user_link"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Number of Cases ","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Total Cases Resolved this Month by Agent","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Closed"]},"1":{"name":"resolved_datetime","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"}}}}', 'Matrix', 'hBarF', 'This report summarizes the number of cases that were resolved during the month grouped by agent and priority. Time period can be adjusted in the report.', '037e02ec-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Tasks', 'Status of Open Tasks Assigned by Me', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"date_due","label":"Due Date","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Tasks:assigned_user_link"}],"module":"Tasks","group_defs":[{"name":"user_name","label":"Tasks Assigned to","table_key":"Tasks:assigned_user_link","type":"username","force_label":"Tasks Assigned to"}],"summary_columns":[{"name":"user_name","label":"Tasks Assigned to","table_key":"Tasks:assigned_user_link"},{"name":"count","label":"Number of Tasks  ","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Status of  Open Tasks Assigned by Me","chart_type":"vGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Tasks","module":"Tasks","label":"Tasks"},"Tasks:assigned_user_link":{"name":"Tasks  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tasks_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Tasks:assigned_user_link"},"dependents":["Filter.1_table_filter_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_8","Filter.1_table_filter_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_6","Filter.1_table_filter_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_8"],"module":"Users","label":"Assigned to User","optional":true},"Tasks:created_by_link":{"name":"Tasks  \\u003E  Created by User","parent":"self","link_def":{"name":"created_by_link","relationship_name":"tasks_created_by","bean_is_lhs":false,"link_type":"one","label":"Created by User","module":"Users","table_key":"Tasks:created_by_link"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Users","label":"Created by User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Tasks:assigned_user_link","qualifier_name":"is_not","input_name0":["Current User"]},"1":{"name":"user_name","table_key":"Tasks:created_by_link","qualifier_name":"is","input_name0":["Current User"]},"2":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Completed","Deferred"]}}}}', 'detailed_summary', 'vGBarF', 'This report shows open tasks that the user viewing the report has assigned to others, so they can followup with them.', '0da8f498-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My Cases Due Today and Overdue', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Cases Due Today and Overdue","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"follow_up_datetime","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]},"2":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]}}}}', 'summary', 'hBarF', 'This report summarizes cases assigned to the user who is viewing the report, and whose followup date has either passed or is today. Report defaults to all cases with followup date in the past 30 days. The time period can be adjusted on the report.', '14572508-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'New Cases by Customer Tier by Week', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"},{"name":"service_level","label":"Service Level","table_key":"Cases:accounts","type":"enum"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"service_level","label":"Service Level","table_key":"Cases:accounts"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"New Cases by Customer Tier by Week","chart_type":"vGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:accounts":{"name":"Cases  \\u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Accounts","label":"Account Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_quarter","runtime":1,"input_name0":"tp_this_quarter","input_name1":"on"}}}}', 'summary', 'vGBarF', 'This report displays the number of cases created by customer tier by week. This helps show the volume of cases coming in by customer\'s service level tier. Time period can be adjusted in the report.', '1c079fda-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Open Cases by Customer Tier and Priority', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"service_level","label":"Service Level","table_key":"Cases:accounts","type":"enum"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"service_level","label":"Service Level","table_key":"Cases:accounts"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Cases by Customer Tier and Priority","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:accounts":{"name":"Cases  \\u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Accounts","label":"Account Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]}}}}', 'Matrix', 'hBarF', 'This report provides a summary of all open cases and groups them by the service level of the customer (customer tier) and priority. This helps a support manager identify the sources of cases and optimize workload, if needed. ', '23a1664a-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'All Open Cases by Followup Date', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"name","label":"Subject","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"follow_up_datetime","label":"Follow Up Date","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"}],"module":"Cases","group_defs":[{"name":"follow_up_datetime","label":"Day: Follow Up Date","column_function":"day","qualifier":"day","table_key":"self","type":"datetimecombo"}],"summary_columns":[{"name":"follow_up_datetime","label":"Day: Follow Up Date","column_function":"day","qualifier":"day","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"All Open Cases by Followup Date","chart_type":"vGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:accounts":{"name":"Cases  \\u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_8","display_cols_row_4","display_cols_row_4","display_cols_row_4"],"module":"Accounts","label":"Account Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]}}}}', 'detailed_summary', 'vGBarF', 'This report displays number of all open cases grouped by the follow up date.', '2971af08-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Total Cases Resolved this Month by Business Center', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"name","label":"Name","table_key":"Cases:business_centers","type":"name"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"name","label":"Business Center","table_key":"Cases:business_centers"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Number of Cases ","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Total Cases Resolved this Month by Business Center","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:business_centers":{"name":"Cases  \\u003E  Business Center","parent":"self","link_def":{"name":"business_centers","relationship_name":"business_center_cases","bean_is_lhs":false,"link_type":"one","label":"Business Center Name","module":"BusinessCenters","table_key":"Cases:business_centers"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"BusinessCenters","label":"Business Center Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Closed"]},"1":{"name":"resolved_datetime","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"}}}}', 'Matrix', 'hBarF', 'This report summarizes the number of cases that were resolved during the month grouped by business center and priority. Time period can be adjusted in the report. ', '3a6aeb6c-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My Cases in the Last Week by Status', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Cases in the Last Week by Status","chart_type":"hGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"tp_last_7_days","input_name1":"on"},"1":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'summary', 'hGBarF', 'This report summarizes all the cases modified by the user viewing the report in the last 7 days, grouped by status of the case. Time period can be adjusted in the report. This report makes it easy to identify recently worked on cases. ', '490c8d6a-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'List of Recently Resolved Cases', '{"display_columns":[{"name":"case_number","label":"Case Number","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"resolved_datetime","label":"Resolved Date","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"name","label":"Subject","table_key":"self"},{"name":"resolution","label":"Resolution","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"full_name","label":"Assigned To","table_key":"Cases:assigned_user_link"},{"name":"name","label":"Business Center ","table_key":"Cases:business_centers"}],"module":"Cases","group_defs":[],"summary_columns":[],"order_by":[{"name":"resolved_datetime","vname":"Resolved Date","type":"datetimecombo","dbType":"datetime","audited":true,"table_key":"self","sort_dir":"d"}],"report_name":"List of Recently Resolved Cases","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["display_cols_row_6","display_cols_row_7","display_cols_row_7","display_cols_row_7","display_cols_row_8","display_cols_row_8","display_cols_row_9"],"module":"Users","label":"Assigned to User","optional":true},"Cases:business_centers":{"name":"Cases  \\u003E  Business Center","parent":"self","link_def":{"name":"business_centers","relationship_name":"business_center_cases","bean_is_lhs":false,"link_type":"one","label":"Business Center Name","module":"BusinessCenters","table_key":"Cases:business_centers"},"dependents":["display_cols_row_7","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_9","display_cols_row_9","display_cols_row_10"],"module":"BusinessCenters","label":"Business Center Name","optional":true},"Cases:accounts":{"name":"Cases  \\u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_5"],"module":"Accounts","label":"Account Name"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Closed"]},"1":{"name":"resolved_datetime","table_key":"self","qualifier_name":"tp_last_n_days","runtime":1,"input_name0":"7","input_name1":"on"}}}}', 'tabular', 'none', 'This report provides a list of all recently closed cases across all business centers. Time period can be adjusted in the report.', '5340a58c-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Recently Created Cases', '{"display_columns":[{"name":"case_number","label":"Case Number","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"name","label":"Subject","table_key":"self"},{"name":"follow_up_datetime","label":"Follow Up Date","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"full_name","label":"Assigned To","table_key":"Cases:assigned_user_link"},{"name":"name","label":"Business Center ","table_key":"Cases:business_centers"}],"module":"Cases","group_defs":[],"summary_columns":[],"report_name":"Recently Created Cases","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["display_cols_row_6","display_cols_row_7","display_cols_row_7","display_cols_row_7","display_cols_row_8","display_cols_row_8"],"module":"Users","label":"Assigned to User","optional":true},"Cases:business_centers":{"name":"Cases  \\u003E  Business Center","parent":"self","link_def":{"name":"business_centers","relationship_name":"business_center_cases","bean_is_lhs":false,"link_type":"one","label":"Business Center Name","module":"BusinessCenters","table_key":"Cases:business_centers"},"dependents":["display_cols_row_7","display_cols_row_8","display_cols_row_8","display_cols_row_8","display_cols_row_9","display_cols_row_9"],"module":"BusinessCenters","label":"Business Center Name","optional":true},"Cases:accounts":{"name":"Cases  \\u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_9","display_cols_row_4","display_cols_row_4"],"module":"Accounts","label":"Account Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_n_days","runtime":1,"input_name0":"3","input_name1":"on"}}}}', 'tabular', 'none', 'This report provides a list of all recently created cases across all business centers. Time period can be adjusted in the report.', '59e972c4-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My Open Cases by Status', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Open Cases by Status","chart_type":"pieF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["Filter.1_table_filter_row_1","Filter.1_table_filter_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]}}}}', 'summary', 'pieF', 'This pie chart shows the percent of cases that are open by status for the user viewing the report. ', '67f4d7d2-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'All Cases Due Today and Overdue', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum"},{"name":"priority","label":"Priority","table_key":"self","type":"enum"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"All Cases Due Today and Overdue","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"follow_up_datetime","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]}}}}', 'summary', 'hBarF', 'This report summarizes all cases whose followup date has either passed or is today. Report defaults to all cases with followup date in the past 30 days. The time period can be adjusted on the report.', '6f471cde-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'New Cases by Business Center by Week', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"name","label":"Name","table_key":"Cases:business_centers","type":"name"},{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"}],"summary_columns":[{"name":"name","label":"Business Center ","table_key":"Cases:business_centers"},{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"New Cases by Business Center by Week","chart_type":"vGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:business_centers":{"name":"Cases  \\u003E  Business Center","parent":"self","link_def":{"name":"business_centers","relationship_name":"business_center_cases","bean_is_lhs":false,"link_type":"one","label":"Business Center Name","module":"BusinessCenters","table_key":"Cases:business_centers"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"BusinessCenters","label":"Business Center Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"}}}}', 'summary', 'vGBarF', 'This report displays the number of cases created for each business center by week. This helps show the volume of cases coming in for each support organization and help optimize workload. Time period can be adjusted in the report. ', '77cdb2aa-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My Open Cases by Followup Date', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"name","label":"Subject","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"follow_up_datetime","label":"Follow Up Date","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"}],"module":"Cases","group_defs":[{"name":"follow_up_datetime","label":"Day: Follow Up Date","column_function":"day","qualifier":"day","table_key":"self","type":"datetimecombo"}],"summary_columns":[{"name":"follow_up_datetime","label":"Day: Follow Up Date","column_function":"day","qualifier":"day","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Open Cases by Followup Date","chart_type":"vGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["Filter.1_table_filter_row_1","Filter.1_table_filter_row_1","Filter.1_table_filter_row_1"],"module":"Users","label":"Assigned to User","optional":true},"Cases:accounts":{"name":"Cases  \\u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_8","display_cols_row_4","display_cols_row_4"],"module":"Accounts","label":"Account Name","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]}}}}', 'detailed_summary', 'vGBarF', 'This report displays number of all open cases assigned to the user viewing the report grouped by the follow up date. ', '87e0c5c4-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My Cases Resolved this Month by Week', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"resolved_datetime","label":"Week: Resolved Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo"}],"summary_columns":[{"name":"resolved_datetime","label":"Week: Resolved Date","column_function":"week","qualifier":"week","table_key":"self"},{"name":"count","label":"Number of Cases","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Cases Resolved this Month by Week","chart_type":"vGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \\u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["Filter.1_table_filter_row_3","Filter.1_table_filter_row_3"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["Closed","Rejected","Duplicate"]},"1":{"name":"resolved_datetime","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"2":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'summary', 'vGBarF', 'This report displays a chart for all cases that were closed in the selected time period and groups them by week', 'aee89246-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My SLA Success Rate', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Day: Date Created","column_function":"day","qualifier":"day","table_key":"self","type":"datetime"}],"summary_columns":[{"name":"date_entered","label":"Day: Date Created","column_function":"day","qualifier":"day","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My SLA Success Rate","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:first_response_user_link":{"name":"Cases  \u003E  First Response User","parent":"self","link_def":{"name":"first_response_user_link","relationship_name":"cases_first_response_user","bean_is_lhs":false,"link_type":"one","label":"First Response User","module":"Users","table_key":"Cases:first_response_user_link"},"dependents":["Filter.1_table_filter_row_3"],"module":"Users","label":"First Response User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"first_response_sla_met","table_key":"self","qualifier_name":"one_of","input_name0":["Yes","No"]},"2":{"name":"user_name","table_key":"Cases:first_response_user_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'summary', 'vBarF', 'The history of cases the current user responded to that either met or missed their first response SLA. Includes cases in the last 30 days, but this range can be changed using the run-time filter.', 'be6a8990-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Contacts', 'New Portal Users Awaiting Activation', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"full_name","label":"Contact Name","table_key":"self"},{"name":"email_address","label":"Contact Email Address","table_key":"Contacts:email_addresses_primary"},{"name":"name","label":"Account Name","table_key":"Contacts:accounts"},{"name":"portal_name","label":"Portal Name","table_key":"self"},{"name":"portal_user_company_name","label":"Portal User Company Name","table_key":"self"},{"name":"user_name","label":"User Assigned To  ","table_key":"Contacts:assigned_user_link"}],"module":"Contacts","group_defs":[],"summary_columns":[],"report_name":"New Portal Users Awaiting Activation","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Contacts","module":"Contacts","label":"Contacts"},"Contacts:assigned_user_link":{"name":"Contacts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"contacts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Contacts:assigned_user_link"},"dependents":["display_cols_row_5"],"module":"Users","label":"Assigned to User","optional":true},"Contacts:accounts":{"name":"Contacts  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"accounts_contacts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Contacts:accounts"},"dependents":["display_cols_row_6"],"module":"Accounts","label":"Account Name","optional":true},"Contacts:email_addresses_primary":{"name":"Contacts  \u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"contacts_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Contacts:email_addresses_primary"},"dependents":["display_cols_row_7"],"module":"EmailAddresses","label":"Email Address","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"portal_active","table_key":"self","qualifier_name":"equals","input_name0":["no"]},"1":{"name":"entry_source","table_key":"self","qualifier_name":"is","input_name0":["external"]},"2":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"tp_last_7_days","input_name1":"on"}}},"chart_type":"none"}', 'tabular', 'none', 'A list of portal users created but not yet activated. Includes contacts created in the last 7 days, but this range can be changed using the run-time filter.', 'c679d7bc-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Daily Average Time to First Response', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Day: Date Created","column_function":"day","qualifier":"day","table_key":"self","type":"datetime"}],"summary_columns":[{"name":"date_entered","label":"Day: Date Created","column_function":"day","qualifier":"day","table_key":"self","sort_dir":"a"},{"name":"business_hrs_to_first_response","label":"AVG: Business Hours to First Response","field_type":"decimal","group_function":"avg","table_key":"self"}],"summary_order_by":[{"name":"date_entered","group_function":"day","column_function":"day","table_key":"self","sort_dir":"a"}],"report_name":"Daily Average Time to First Response","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:business_hrs_to_first_response:avg","numerical_chart_column_type":"decimal","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"tp_last_7_days","input_name1":"on"},"1":{"name":"first_response_sent","table_key":"self","qualifier_name":"equals","input_name0":["yes"]}}}}', 'summary', 'hBarF', 'The daily average time in business hours until the first response on a case. Includes cases created in the last 7 days, but this range can be changed using the run-time filter.', 'ce94b20a-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Average Time to Resolution by Week by Type', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"resolved_datetime","label":"Week: Resolved Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo"},{"name":"type","label":"Type","table_key":"self","type":"enum"}],"summary_columns":[{"name":"resolved_datetime","label":"Week: Resolved Date","column_function":"week","qualifier":"week","table_key":"self"},{"name":"type","label":"Case Type","table_key":"self"},{"name":"business_hours_to_resolution","label":"AVG: Business Hours to Resolution","field_type":"decimal","group_function":"avg","table_key":"self"}],"report_name":"Average Time to Resolution by Week by Type","chart_type":"hGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:business_hours_to_resolution:avg","numerical_chart_column_type":"decimal","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Closed"]}}}}', 'summary', 'hGBarF', 'The average time in business hours it takes to resolve cases by week for each case type. Includes cases resolved in the last 30 days, but this range can be changed using the run-time filter.', 'd5e0acd0-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'My Average Difference From Follow-Up Date by Week', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"first_response_var_from_target","label":"AVG: First Response Variance from Target","field_type":"decimal","group_function":"avg","table_key":"self"}],"report_name":"My Average Difference From Follow-Up Date by Week","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:first_response_var_from_target:avg","numerical_chart_column_type":"decimal","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"first_response_sent","table_key":"self","qualifier_name":"equals","input_name0":["yes"]},"2":{"name":"first_response_sla_met","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Yes","No"]}}}}', 'summary', 'vBarF', 'The average difference from the targeted follow-up date in business hours by week for the current user. Includes cases created in the last 30 days, but this range can be changed using the run-time filter. A run-time filter can also be used to filter by cases that either met or missed their first response SLA.', 'de0f77ce-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Open Cases Awaiting First Response That Missed SLA', '{"display_columns":[{"name":"case_number","label":"Number","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"type","label":"Type","table_key":"self"},{"name":"follow_up_datetime","label":"Targeted Follow Up Date","table_key":"self"},{"name":"user_name","label":"Assigned to User","table_key":"Cases:assigned_user_link"}],"module":"Cases","group_defs":[],"summary_columns":[],"report_name":"Open Cases Awaiting First Response That Missed SLA","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:accounts":{"name":"Cases  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_8"],"module":"Accounts","label":"Account Name","optional":true},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["display_cols_row_9"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]},"1":{"name":"first_response_sent","table_key":"self","qualifier_name":"equals","input_name0":["no"]},"2":{"name":"first_response_sla_met","table_key":"self","qualifier_name":"is","input_name0":["No"]}}},"chart_type":"none"}', 'tabular', 'none', 'All open cases that missed the first response SLA and are still awaiting first response.', 'ec31bd3a-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'First Response SLA Success Rate', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"first_response_sla_met","label":"First Response SLA Met","table_key":"self","type":"enum"}],"summary_columns":[{"name":"first_response_sla_met","label":"First Response SLA Met","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"First Response SLA Success Rate","chart_type":"pieF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2","Filter.1_table_filter_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"user_name","table_key":"Cases:assigned_user_link","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"},"2":{"name":"first_response_sla_met","table_key":"self","qualifier_name":"one_of","input_name0":["Yes","No"]}}}}', 'summary', 'pieF', 'All cases created in the last 30 days, separated by whether or not their first response SLA was met. The run-time filters can be used to change the time period or narrow the results to only cases assigned to a specific agent.', 'f8298f0a-beae-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Average Difference From Follow-Up Date by Week by Agent', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self","type":"datetime"},{"name":"user_name","label":"User Name","table_key":"Cases:first_response_user_link","type":"username"}],"summary_columns":[{"name":"date_entered","label":"Week: Date Created","column_function":"week","qualifier":"week","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Cases:first_response_user_link"},{"name":"first_response_var_from_target","label":"AVG: First Response Variance from Target","field_type":"decimal","group_function":"avg","table_key":"self"}],"report_name":"Average Difference From Follow-Up Date by Week by Agent","chart_type":"vGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:first_response_var_from_target:avg","numerical_chart_column_type":"decimal","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:first_response_user_link":{"name":"Cases  \u003E  First Response User","parent":"self","link_def":{"name":"first_response_user_link","relationship_name":"cases_first_response_user","bean_is_lhs":false,"link_type":"one","label":"First Response User","module":"Users","table_key":"Cases:first_response_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Users","label":"First Response User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"first_response_sent","table_key":"self","qualifier_name":"equals","input_name0":["yes"]},"2":{"name":"first_response_sla_met","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Yes","No"]}}}}', 'Matrix', 'vGBarF', 'The average difference from the targeted follow-up date in business hours by week for each agent. Includes cases created in the last 30 days, but this range can be changed using the run-time filter. A run-time filter can also be used to filter by cases that either met or missed their first response SLA.', '08f61592-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Average Time to Resolution by Week by Agent', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"resolved_datetime","label":"Week: Resolved Date","column_function":"week","qualifier":"week","table_key":"self","type":"datetimecombo"},{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","type":"username"}],"summary_columns":[{"name":"resolved_datetime","label":"Week: Resolved Date","column_function":"week","qualifier":"week","table_key":"self"},{"name":"business_hours_to_resolution","label":"AVG: Business Hours to Resolution","field_type":"decimal","group_function":"avg","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link"}],"report_name":"Average Time to Resolution by Week by Agent","chart_type":"hGBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:business_hours_to_resolution:avg","numerical_chart_column_type":"decimal","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["group_by_row_3","display_summaries_row_group_by_row_3"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Closed"]}}}}', 'summary', 'hGBarF', 'The average time in business hours it takes to resolve cases by week for each agent. Includes cases resolved in the last 30 days, but this range can be changed using the run-time filter.', '1115687c-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Open Cases Awaiting First Response Within SLA', '{"display_columns":[{"name":"case_number","label":"Number","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Cases:accounts"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"type","label":"Type","table_key":"self"},{"name":"follow_up_datetime","label":"Targeted Follow Up Date","table_key":"self"},{"name":"user_name","label":"Assigned to User","table_key":"Cases:assigned_user_link"}],"module":"Cases","group_defs":[],"summary_columns":[],"report_name":"Open Cases Awaiting First Response Within SLA","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases","dependents":[]},"Cases:accounts":{"name":"Cases  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["display_cols_row_8","display_cols_row_3"],"module":"Accounts","label":"Account Name","optional":true},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["display_cols_row_9","display_cols_row_8"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]},"1":{"name":"first_response_sent","table_key":"self","qualifier_name":"equals","input_name0":["no"]},"2":{"name":"first_response_sla_met","table_key":"self","qualifier_name":"empty","input_name0":"empty","input_name1":"on"}}}}', 'tabular', 'none', 'All open cases that are within their SLA and awaiting first response.', '183adcea-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Average Time to First Response by Agent', '{"display_columns":[],"module":"Cases","group_defs":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","type":"username"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Cases:assigned_user_link","sort_dir":"a"},{"name":"business_hrs_to_first_response","label":"AVG: Business Hours to First Response","field_type":"decimal","group_function":"avg","table_key":"self"}],"summary_order_by":[{"name":"user_name","vname":"User Name","type":"username","dbType":"varchar","len":"60","importable":"required","required":true,"idm_mode_disabled":true,"table_key":"Cases:assigned_user_link","sort_dir":"a"}],"report_name":"Average Time to First Response by Agent","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:business_hrs_to_first_response:avg","numerical_chart_column_type":"decimal","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:assigned_user_link":{"name":"Cases  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"cases_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"1":{"name":"first_response_sent","table_key":"self","qualifier_name":"equals","input_name0":["yes"]}}}}', 'summary', 'hBarF', 'The average time in business hours until the first response on a case, per agent. Includes cases created in the last 30 days, but this range can be changed using the run-time filter.', '1f52bcfa-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['ChangeTimers', 'Total Time Spent on Cases by Week by Case Type', '{"display_columns":[],"module":"ChangeTimers","group_defs":[{"name":"date_entered","label":"Week Status Changed","column_function":"week","qualifier":"week","table_key":"self","type":"datetime","force_label":"Week Status Changed"},{"name":"type","label":"Case Type","table_key":"ChangeTimers:cases","type":"enum","force_label":"Case Type"}],"summary_columns":[{"name":"date_entered","label":"Week Status Changed","column_function":"week","qualifier":"week","table_key":"self"},{"name":"type","label":"Case Type","table_key":"ChangeTimers:cases"},{"name":"business_hours","label":"SUM: Business Hours","field_type":"decimal","group_function":"sum","table_key":"self"}],"report_name":"Total Time Spent on Cases by Week by Case Type","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:business_hours:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"ChangeTimers","module":"ChangeTimers","label":"ChangeTimers","dependents":[]},"ChangeTimers:cases":{"name":"Change Timers  \u003E  Cases","parent":"self","link_def":{"name":"cases","relationship_name":"cases_changetimers","bean_is_lhs":false,"link_type":"one","label":"Cases","module":"Cases","table_key":"ChangeTimers:cases"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_2","display_summaries_row_group_by_row_2"],"module":"Cases","label":"Cases","optional":true}},"filters_def":{"Filter_1":{"0":{"operator":"AND","0":{"name":"parent_type","table_key":"self","qualifier_name":"is","input_name0":["Cases"]},"1":{"name":"field_name","table_key":"self","qualifier_name":"equals","input_name0":"status","input_name1":"on"},"2":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"}},"1":{"operator":"OR","0":{"name":"value_string","table_key":"self","qualifier_name":"equals","input_name0":"New","input_name1":"on"},"1":{"name":"value_string","table_key":"self","qualifier_name":"equals","input_name0":"Assigned","input_name1":"on"}},"operator":"AND"}}}', 'summary', 'vBarF', 'The total time in business hours spent on cases for each week by case type. Includes cases created in the last 30 days, but this range can be changed using the run-time filter.', '26145fc6-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['ChangeTimers', 'List of Changes to Case Status', '{"display_columns":[{"name":"case_number","label":"Case Number","table_key":"ChangeTimers:cases"},{"name":"date_entered","label":"Date Created","table_key":"ChangeTimers:cases"},{"name":"name","label":"Case Subject","table_key":"ChangeTimers:cases"},{"name":"field_name","label":"Field Name","table_key":"self"},{"name":"value_string","label":"Value","table_key":"self"},{"name":"from_datetime","label":"From Time","table_key":"self"},{"name":"to_datetime","label":"To Time","table_key":"self"},{"name":"hours","label":"Time in Hours","table_key":"self"},{"name":"business_hours","label":"Time in Business Hours","table_key":"self"}],"module":"ChangeTimers","group_defs":[],"summary_columns":[],"order_by":[{"name":"case_number","vname":"Number","type":"int","readonly":true,"len":11,"required":true,"auto_increment":true,"unified_search":true,"duplicate_merge":"disabled","disable_num_format":true,"duplicate_on_record_copy":"no","table_key":"ChangeTimers:cases","sort_dir":"a"}],"report_name":"List of Changes to Case Status","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"ChangeTimers","module":"ChangeTimers","label":"ChangeTimers","dependents":[]},"ChangeTimers:cases":{"name":"Change Timers  \u003E  Cases","parent":"self","link_def":{"name":"cases","relationship_name":"cases_changetimers","bean_is_lhs":false,"link_type":"one","label":"Cases","module":"Cases","table_key":"ChangeTimers:cases"},"dependents":["display_cols_row_10","display_cols_row_11","display_cols_row_14","display_cols_row_2","display_cols_row_3","display_cols_row_10","display_cols_row_1","display_cols_row_2","display_cols_row_9","display_cols_row_1","display_cols_row_2","display_cols_row_3","display_cols_row_1","display_cols_row_2","display_cols_row_3","display_cols_row_1","display_cols_row_2","display_cols_row_3","Filter.1.1_table_filter_row_6","display_cols_row_1","display_cols_row_2","display_cols_row_3","display_cols_row_1","display_cols_row_2","display_cols_row_3","display_cols_row_1","display_cols_row_2","display_cols_row_3","Filter.1_table_filter_row_8","Filter.1_table_filter_row_9","Filter.1_table_filter_row_3","Filter.1_table_filter_row_4","display_cols_row_1","display_cols_row_2","display_cols_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_4","display_cols_row_1","display_cols_row_2","display_cols_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_4","display_cols_row_1","display_cols_row_2","display_cols_row_3","Filter.1_table_filter_row_3","Filter.1_table_filter_row_4","display_cols_row_1","display_cols_row_2","display_cols_row_3"],"module":"Cases","label":"Cases","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"parent_type","table_key":"self","qualifier_name":"is","input_name0":["Cases"]},"1":{"name":"field_name","table_key":"self","qualifier_name":"equals","input_name0":"status","input_name1":"on"},"2":{"name":"date_entered","table_key":"ChangeTimers:cases","qualifier_name":"tp_last_30_days","runtime":1,"input_name0":"tp_last_30_days","input_name1":"on"},"3":{"name":"case_number","table_key":"ChangeTimers:cases","qualifier_name":"not_empty","runtime":1,"input_name0":"not_empty","input_name1":"on"}}}}', 'tabular', 'none', 'List of all changes to case status. Includes cases created in the last 30 days, but this range can be changed using the run-time filter.', '2d50a25e-beaf-11ee-9d94-095590d26ca4'];

    return $stock_reports;
}

function get_data_privacy_reports($is_upgrade = false)
{
    global $current_language;

    $lang_strings = return_module_language($current_language, 'Reports');
    $stock_reports = [];
    $stock_reports[] = ['Leads', 'List of Leads with no Consent', '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"full_name","label":"Lead Name","table_key":"self"},{"name":"account_name","label":"Account Name","table_key":"self"},{"name":"full_name","label":"Assigned To ","table_key":"Leads:assigned_user_link"},{"name":"email_address","label":"Email Address","table_key":"Leads:email_addresses_primary"},{"name":"opt_out","label":"Opted Out","table_key":"Leads:email_addresses_primary"},{"name":"lead_source","label":"Lead Source","table_key":"self"},{"name":"do_not_call","label":"Do Not Call","table_key":"self"}],"module":"Leads","group_defs":[],"summary_columns":[],"report_name":"List of Leads with no Consent","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads","dependents":[]},"Leads:assigned_user_link":{"name":"Leads  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"leads_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Leads:assigned_user_link"},"dependents":["display_cols_row_4","display_cols_row_4"],"module":"Users","label":"Assigned to User","optional":true},"Leads:email_addresses_primary":{"name":"Leads  \u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"leads_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Leads:email_addresses_primary"},"dependents":["display_cols_row_5","display_cols_row_6","display_cols_row_5","display_cols_row_6"],"module":"EmailAddresses","label":"Email Address","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"dp_business_purpose","table_key":"self","qualifier_name":"empty","runtime":1,"input_name0":"empty","input_name1":"on"}}}}', 'tabular', 'none', 'List of all leads who have not provided any consent for any business purpose.', '3dd43fd2-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_9'], '{"display_columns":[],"module":"DataPrivacy","group_defs":[{"name":"date_closed","label":"Month: Date Closed","column_function":"month","qualifier":"month","table_key":"self","type":"date","force_label":"Month: Date Closed"},{"name":"status","label":"Status","table_key":"self","type":"enum","force_label":"Status"}],"summary_columns":[{"name":"date_closed","label":"Month: Date Closed","column_function":"month","qualifier":"month","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Data privacy activity completed and rejected each month","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","input_name0":["Closed","Rejected"]},"1":{"name":"date_closed","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of data privacy activities completed or rejected each month. The month is based on date closed. ', '437b3f80-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_10'], '{"display_columns":[{"name":"dataprivacy_number","label":"Number","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"type","label":"Type","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"requested_by","label":"Requested By","table_key":"self"},{"name":"source","label":"Source","table_key":"self"},{"name":"description","label":"Description","table_key":"self"},{"name":"date_due","label":"Due Date","table_key":"self"}],"module":"DataPrivacy","group_defs":[],"summary_columns":[],"report_name":" Recently Created Data Privacy Activity","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"tp_last_7_days","input_name1":"on"}}}}', 'tabular', 'none', 'A list of all recently created data privacy activity.  Time period can be adjusted in the report using the run time filters. ', '53278056-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Leads', 'Count of Leads (unconverted) by Country', '{"display_columns":[],"module":"Leads","group_defs":[{"name":"primary_address_country","label":"Primary Address Country","table_key":"self","type":"varchar","force_label":"Primary Address Country"}],"summary_columns":[{"name":"primary_address_country","label":"Primary Address Country","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Count of Leads (unconverted) by Country","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Leads","module":"Leads","label":"Leads"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["New","Assigned","In Process","Recycled"]}}}}', 'summary', 'none', 'Total count of existing leads (unconverted) grouped by country.', '5d6388ee-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_17'], '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"dataprivacy_number","label":"Number","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"source","label":"Source","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"date_due","label":"Due Date","table_key":"self"}],"module":"DataPrivacy","group_defs":[{"name":"user_name","label":"User Name","table_key":"DataPrivacy:assigned_user_link","type":"username"},{"name":"type","label":"Type","table_key":"self","type":"enum"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"DataPrivacy:assigned_user_link"},{"name":"type","label":"Type","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Data Privacy Activity Overdue","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy"},"DataPrivacy:assigned_user_link":{"name":"Data Privacy  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"dataprivacy_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"DataPrivacy:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_due","table_key":"self","qualifier_name":"tp_last_n_days","runtime":1,"input_name0":"99999","input_name1":"on"}}}}', 'detailed_summary', 'hBarF', 'List of all Data Privacy Activity that are still open and the due date is in the past. ', '6323d28e-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Prospects', 'Count of Targets by Country', '{"display_columns":[],"module":"Prospects","group_defs":[{"name":"primary_address_country","label":"Primary Address Country","table_key":"self","type":"varchar","force_label":"Primary Address Country"}],"summary_columns":[{"name":"primary_address_country","label":"Primary Address Country","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Count of Targets by Country","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Prospects","module":"Prospects","label":"Prospects"}},"filters_def":{"Filter_1":{"operator":"AND"}}}', 'summary', 'none', 'Total count of existing targets grouped by country.', '70b7333c-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_29'], '{"display_columns":[],"module":"DataPrivacy","group_defs":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self","type":"datetime","force_label":"Month: Date Created"},{"name":"type","label":"Type","table_key":"self","type":"enum","force_label":"Type"}],"summary_columns":[{"name":"date_entered","label":"Month: Date Created","column_function":"month","qualifier":"month","table_key":"self"},{"name":"type","label":"Type","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Number of Data Privacy Activity created each month by type","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_entered","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"}}}}', 'Matrix', 'vBarF', 'Number of data privacy activity created each month by activity type', '76fe7a2a-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_32'], '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"dataprivacy_number","label":"Number","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"source","label":"Source","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"date_due","label":"Due Date","table_key":"self"}],"module":"DataPrivacy","group_defs":[{"name":"user_name","label":"User Name","table_key":"DataPrivacy:assigned_user_link","type":"username"},{"name":"type","label":"Type","table_key":"self","type":"enum"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"DataPrivacy:assigned_user_link"},{"name":"type","label":"Type","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Data Privacy Activity Due Now","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy"},"DataPrivacy:assigned_user_link":{"name":"Data Privacy  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"dataprivacy_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"DataPrivacy:assigned_user_link"},"dependents":["group_by_row_2","display_summaries_row_group_by_row_2","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_due","table_key":"self","qualifier_name":"tp_next_7_days","runtime":1,"input_name0":"tp_next_7_days","input_name1":"on"}}}}', 'detailed_summary', 'hBarF', 'List of all Data Privacy Activity that is due shortly. Use the run time filter to adjust the time period. ', '7e6aebf4-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_66'], '{"display_columns":[{"name":"dataprivacy_number","label":"Number","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"description","label":"Description","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"requested_by","label":"Requested By","table_key":"self"},{"name":"source","label":"Source","table_key":"self"}],"module":"DataPrivacy","group_defs":[{"name":"type","label":"Type","table_key":"self","type":"enum"}],"summary_columns":[{"name":"type","label":"Type","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Data Privacy Activities by Type","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Open"]}}}}', 'detailed_summary', 'hBarF', 'List of all open data privacy activity grouped by activity type.', '879c3c46-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Contacts', $lang_strings['STOCK_REPORT_TITLE_67'], '{"display_columns":[{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"full_name","label":"Contact Name","table_key":"self"},{"name":"name","label":"Account Name","table_key":"Contacts:accounts"},{"name":"full_name","label":"Assigned To ","table_key":"Contacts:assigned_user_link"},{"name":"email_address","label":"Email Address","table_key":"Contacts:email_addresses_primary"},{"name":"opt_out","label":"Opted Out","table_key":"Contacts:email_addresses_primary"},{"name":"do_not_call","label":"Do Not Call","table_key":"self"}],"module":"Contacts","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","enable_range_search":true,"options":[{"value":"=","text":"Equals"},{"value":"not_equal","text":"Not On"},{"value":"greater_than","text":"After"},{"value":"less_than","text":"Before"},{"value":"last_7_days","text":"Last 7 Days"},{"value":"next_7_days","text":"Next 7 Days"},{"value":"last_30_days","text":"Last 30 Days"},{"value":"next_30_days","text":"Next 30 Days"},{"value":"last_month","text":"Last Month"},{"value":"this_month","text":"This Month"},{"value":"next_month","text":"Next Month"},{"value":"last_year","text":"Last Year"},{"value":"this_year","text":"This Year"},{"value":"next_year","text":"Next Year"},{"value":"between","text":"Is Between"}],"duplicate_on_record_copy":"no","readonly":true,"table_key":"self","sort_dir":"d"}],"report_name":"List of Contacts with No Consent","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Contacts","module":"Contacts","label":"Contacts","dependents":[]},"Contacts:assigned_user_link":{"name":"Contacts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"contacts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Contacts:assigned_user_link"},"dependents":["display_cols_row_12"],"module":"Users","label":"Assigned to User","optional":true},"Contacts:accounts":{"name":"Contacts  \u003E  Account","parent":"self","link_def":{"name":"accounts","relationship_name":"accounts_contacts","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Contacts:accounts"},"dependents":["display_cols_row_13"],"module":"Accounts","label":"Account Name","optional":true},"Contacts:email_addresses_primary":{"name":"Contacts  \u003E  Email Address","parent":"self","link_def":{"name":"email_addresses_primary","relationship_name":"contacts_email_addresses_primary","bean_is_lhs":true,"link_type":"many","label":"Email Address","module":"EmailAddresses","table_key":"Contacts:email_addresses_primary"},"dependents":["display_cols_row_14","display_cols_row_15"],"module":"EmailAddresses","label":"Email Address","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"dp_business_purpose","table_key":"self","qualifier_name":"empty","runtime":1,"input_name0":"empty","input_name1":"on"}}}}', 'tabular', 'none', 'List of all contacts who have not provided any consent for any business purpose. ', '8dff86ba-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_72'], '{"display_columns":[{"name":"dataprivacy_number","label":"Number","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"type","label":"Type","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"requested_by","label":"Requested By","table_key":"self"},{"name":"source","label":"Source","table_key":"self"},{"name":"description","label":"Description","table_key":"self"},{"name":"date_due","label":"Due Date","table_key":"self"}],"module":"DataPrivacy","group_defs":[],"summary_columns":[],"report_name":" List of Open Data Privacy Activities","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Open"]}}},"chart_type":"none"}', 'tabular', 'none', 'A list of all data privacy activity that have a status of open.', '95564318-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['EmailAddresses', $lang_strings['STOCK_REPORT_TITLE_85'], '{"display_columns":[{"name":"email_address","label":"Email Address","table_key":"self"}],"module":"EmailAddresses","group_defs":[],"summary_columns":[],"report_name":"List of Emails Opted Out","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"EmailAddresses","module":"EmailAddresses","label":"EmailAddresses","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"opt_out","table_key":"self","qualifier_name":"equals","input_name0":["yes"]}}},"chart_type":"none"}', 'tabular', 'none', 'List of all emails currently opted out.', '9c1c8b08-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['DataPrivacy', $lang_strings['STOCK_REPORT_TITLE_86'], '{"display_columns":[{"name":"dataprivacy_number","label":"Number","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"type","label":"Type","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"requested_by","label":"Requested By","table_key":"self"},{"name":"source","label":"Source","table_key":"self"},{"name":"description","label":"Description","table_key":"self"},{"name":"date_due","label":"Due Date","table_key":"self"}],"module":"DataPrivacy","group_defs":[],"summary_columns":[],"report_name":" List of Open Data Privacy Activities assigned to me","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"DataPrivacy","module":"DataPrivacy","label":"DataPrivacy"},"DataPrivacy:assigned_user_link":{"name":"Data Privacy  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"dataprivacy_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"DataPrivacy:assigned_user_link"},"dependents":["Filter.1_table_filter_row_2"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Open"]},"1":{"name":"user_name","table_key":"DataPrivacy:assigned_user_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'tabular', 'none', 'List of open data privacy activity assigned to me', 'a2520412-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['EmailAddresses', $lang_strings['STOCK_REPORT_TITLE_88'], '{"display_columns":[{"name":"email_address","label":"Email Address","table_key":"self"}],"module":"EmailAddresses","group_defs":[],"summary_columns":[],"report_name":"List of Emails Opted In","chart_type":"none","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"EmailAddresses","module":"EmailAddresses","label":"EmailAddresses","dependents":[]}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"opt_out","table_key":"self","qualifier_name":"equals","input_name0":["no"]}}}}', 'tabular', 'none', 'List of all emails currently opted in.', 'b0657a0c-beaf-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Contacts', $lang_strings['STOCK_REPORT_TITLE_92'], '{"display_columns":[],"module":"Contacts","group_defs":[{"name":"primary_address_country","label":"Primary Address Country","table_key":"self","type":"varchar","force_label":"Primary Address Country"}],"summary_columns":[{"name":"primary_address_country","label":"Primary Address Country","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Count of Contacts by Country","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Contacts","module":"Contacts","label":"Contacts"}},"filters_def":{"Filter_1":{"operator":"AND"}}}', 'summary', 'none', 'Total count of existing contacts grouped by country. ', 'b93616fa-beaf-11ee-9d94-095590d26ca4'];

    return $stock_reports;
}

function get_admin_reports($is_upgrade = false)
{
    global $current_language;

    $lang_strings = return_module_language($current_language, 'Reports');
    $stock_reports = [];
    if (!$is_upgrade) {
        $stock_reports[] = ['TrackerPerfs', $lang_strings['STOCK_REPORT_TITLE_41'], '{"display_columns":[],"module":"Trackers","report_name":"My Usage Metrics (Today)","group_defs":[],"summary_columns":[{"name":"server_response_time","label":"Total Server Response Time (secs)","group_function":"sum","table_key":"Trackers:tracker_monitor_id"},{"name":"db_round_trips","label":"Total Database Roundtrips","group_function":"sum","table_key":"Trackers:tracker_monitor_id"},{"name":"files_opened","label":"Total Files Accessed","group_function":"sum","table_key":"Trackers:tracker_monitor_id"}],"chart_type":"none","chart_description":"My Usage Metrics (Today)","numerical_chart_column":"Trackers\u003Etracker_monitor_id-\u003Eserver_response_time","report_type":"summary","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"},"Trackers:tracker_monitor_id":{"name":"Trackers  \u003E  Monitor Id","label":"TrackerPerfs","parent":"self","link_def":{"name":"monitor_id_link","relationship_name":"tracker_monitor_id","bean_is_lhs":false,"link_type":"one","label":"Monitor Id","table_key":"Trackers:tracker_monitor_id"},"dependents":["display_summaries_row_1","display_summaries_row_2","display_summaries_row_3"],"module":"TrackerPerfs"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_today","input_name0":"tp_today"}}}}', 'summary', 'none', '', 'c0da6000-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['TrackerPerfs', $lang_strings['STOCK_REPORT_TITLE_42'], '{"display_columns":[],"module":"Trackers","report_name":"My Usage Metrics (Last 7 Days)","group_defs":[],"summary_columns":[{"name":"server_response_time","label":"Total Server Response Time (secs)","group_function":"sum","table_key":"Trackers:tracker_monitor_id"},{"name":"db_round_trips","label":"Total Database Roundtrips","group_function":"sum","table_key":"Trackers:tracker_monitor_id"},{"name":"files_opened","label":"Total Files Accessed","group_function":"sum","table_key":"Trackers:tracker_monitor_id"}],"chart_type":"none","chart_description":"My Usage Metrics (Last 7 Days)","numerical_chart_column":"Trackers\u003Etracker_monitor_id-\u003Eserver_response_time","report_type":"summary","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"},"Trackers:tracker_monitor_id":{"name":"Trackers  \u003E  Monitor Id","label":"TrackerPerfs","parent":"self","link_def":{"name":"monitor_id_link","relationship_name":"tracker_monitor_id","bean_is_lhs":false,"link_type":"one","label":"Monitor Id","table_key":"Trackers:tracker_monitor_id"},"dependents":["display_summaries_row_1","display_summaries_row_2","display_summaries_row_3"],"module":"TrackerPerfs"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_7_days","input_name0":"tp_last_7_days"}}}}', 'summary', 'none', '', 'd033a228-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['TrackerPerfs', $lang_strings['STOCK_REPORT_TITLE_43'], '{"display_columns":[],"module":"Trackers","report_name":"My Usage Metrics (Last 30 Days)","group_defs":[],"summary_columns":[{"name":"server_response_time","label":"Total Server Response Time (secs)","group_function":"sum","table_key":"Trackers:tracker_monitor_id"},{"name":"db_round_trips","label":"Total Database Roundtrips","group_function":"sum","table_key":"Trackers:tracker_monitor_id"},{"name":"files_opened","label":"Total Files Accessed","group_function":"sum","table_key":"Trackers:tracker_monitor_id"}],"chart_type":"none","chart_description":"My Usage Metrics (Last 30 Days)","numerical_chart_column":"Trackers\u003Etracker_monitor_id-\u003Eserver_response_time","report_type":"summary","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"},"Trackers:tracker_monitor_id":{"name":"Trackers  \u003E  Monitor Id","label":"TrackerPerfs","parent":"self","link_def":{"name":"monitor_id_link","relationship_name":"tracker_monitor_id","bean_is_lhs":false,"link_type":"one","label":"Monitor Id","table_key":"Trackers:tracker_monitor_id"},"dependents":["display_summaries_row_1","display_summaries_row_2","display_summaries_row_3"],"module":"TrackerPerfs"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_30_days","input_name0":"tp_last_30_days"}}}}', 'summary', 'none', '', 'd8fb3538-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['Trackers', $lang_strings['STOCK_REPORT_TITLE_44'], '{"display_columns":[],"module":"Trackers","report_name":"My Module Usage (Today)","group_defs":[{"name":"module_name","label":"Module Name","table_key":"self"}],"summary_columns":[{"name":"module_name","label":"Trackers \u003E Module Name","table_key":"self"},{"name":"count","label":"Trackers \u003E Count","group_function":"count","table_key":"self"}],"chart_type":"hBarF","chart_description":"My Module Usage (Today)","numerical_chart_column":"self:count","report_type":"summary","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_today","input_name0":"tp_today"}}}}', 'summary', 'hBarF', '', 'dff8f08c-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['Trackers', $lang_strings['STOCK_REPORT_TITLE_45'], '{"display_columns":[],"module":"Trackers","report_name":"My Module Usage (Last 7 Days)","group_defs":[{"name":"module_name","label":"Module Name","table_key":"self"}],"summary_columns":[{"name":"module_name","label":"Trackers \u003E Module Name","table_key":"self"},{"name":"count","label":"Trackers \u003E Count","group_function":"count","table_key":"self"}],"chart_type":"hBarF","chart_description":"My Module Usage (Last 7 Days)","numerical_chart_column":"self:count","report_type":"summary","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_7_days","input_name0":"tp_last_7_days"}}}}', 'summary', 'hBarF', '', 'e66c2d1c-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['Trackers', $lang_strings['STOCK_REPORT_TITLE_46'], '{"display_columns":[],"module":"Trackers","report_name":"My Module Usage (Last 30 Days)","group_defs":[{"name":"module_name","label":"Module Name","table_key":"self"}],"summary_columns":[{"name":"module_name","label":"Trackers \u003E Module Name","table_key":"self"},{"name":"count","label":"Trackers \u003E Count","group_function":"count","table_key":"self"}],"chart_type":"hBarF","chart_description":"My Module Usage (Last 30 Days)","numerical_chart_column":"self:count","report_type":"summary","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_30_days","input_name0":"tp_last_30_days"}}}}', 'summary', 'hBarF', '', 'ed77bb9e-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['TrackerPerfs', $lang_strings['STOCK_REPORT_TITLE_47'], '{"report_type":"summary","display_columns":[],"summary_columns":[{"name":"user_id","label":"User Id","table_key":"self","is_group_by":"visible"},{"name":"server_response_time","label":"Total Server Response Time (secs)","group_function":"sum","table_key":"Trackers:monitor_id_link"},{"name":"db_round_trips","label":"Total Database Roundtrips","group_function":"sum","table_key":"Trackers:monitor_id_link"},{"name":"files_opened","label":"Total Files Accessed","group_function":"sum","table_key":"Trackers:monitor_id_link"}],"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_7_days","input_name0":"tp_last_7_days"}}},"filters_combiner":"AND","group_defs":[{"name":"user_id","label":"User Id","table_key":"self"}],"full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Tracker"},"Trackers:monitor_id_link":{"parent":"self","label":"Monitor Id","link_def":{"name":"monitor_id_link","relationship_name":"tracker_monitor_id","bean_is_lhs":false,"link_type":"one","label":"Monitor Id","table_key":"Trackers:monitor_id_link"},"module":"TrackerPerfs","name":"Trackers \u003E TrackerPerfs"}},"module":"Trackers","report_name":"Users Usage Metrics (Last 7 Days)","chart_type":"none","chart_description":"Users Usage Metrics (Last 7 Days)","numerical_chart_column":"self_link_0:server_response_time:sum","assigned_user_id":"1"}', 'summary', 'none', '', 'f6bb8410-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['TrackerPerfs', $lang_strings['STOCK_REPORT_TITLE_48'], '{"report_type":"summary","display_columns":[],"summary_columns":[{"name":"user_id","label":"User Id","table_key":"self","is_group_by":"visible"},{"name":"server_response_time","label":"Total Server Response Time (secs)","group_function":"sum","table_key":"Trackers:monitor_id_link"},{"name":"db_round_trips","label":"Total Database Roundtrips","group_function":"sum","table_key":"Trackers:monitor_id_link"},{"name":"files_opened","label":"Total Files Accessed","group_function":"sum","table_key":"Trackers:monitor_id_link"}],"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_30_days","input_name0":"tp_last_30_days"}}},"filters_combiner":"AND","group_defs":[{"name":"user_id","label":"User Id","table_key":"self"}],"full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Tracker"},"Trackers:monitor_id_link":{"parent":"self","label":"Monitor Id","link_def":{"name":"monitor_id_link","relationship_name":"tracker_monitor_id","bean_is_lhs":false,"link_type":"one","label":"Monitor Id","table_key":"Trackers:monitor_id_link"},"module":"TrackerPerfs","name":"Trackers \u003E TrackerPerfs"}},"module":"Trackers","report_name":"Users Usage Metrics (Last 30 Days)","chart_type":"none","chart_description":"Users Usage Metrics (Last 30 Days)","numerical_chart_column":"self_link_0:server_response_time:sum","assigned_user_id":"1"}', 'summary', 'none', '', 'fdd0e1fa-beaf-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['Trackers', $lang_strings['STOCK_REPORT_TITLE_49'], '{"display_columns":[],"module":"Trackers","group_defs":[{"name":"module_name","label":"Module Name","table_key":"self","type":"varchar"}],"summary_columns":[{"name":"module_name","label":"Module Name","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Modules Used By My Direct Reports (Last 30 Days)","chart_type":"hBarF","chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:assigned_user_link":{"name":"Trackers  \u003E  Assigned to User ","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:assigned_user_link"},"dependents":["Filter.1_table_filter_row_3"],"module":"Users","label":"Assigned to User"},"Trackers:assigned_user_link:reports_to_link":{"name":"Trackers  \u003E  Assigned to User  \u003E  Reports To","parent":"Trackers:assigned_user_link","link_def":{"name":"reports_to_link","relationship_name":"user_direct_reports","bean_is_lhs":false,"link_type":"one","label":"Reports to","table_key":"Trackers:assigned_user_link:reports_to_link"},"dependents":["Filter.1_table_filter_row_3"],"module":"Users","label":"Reports to"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"module_name","table_key":"self","qualifier_name":"not_equals_str","input_name0":"UserPreferences","input_name1":"on"},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_30_days","input_name0":"undefined","input_name1":"on"},"2":{"name":"user_name","table_key":"Trackers:assigned_user_link:reports_to_link","qualifier_name":"one_of","input_name0":["Current User"]}}}}', 'summary', 'hBarF', '', '053bfbf0-beb0-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['TrackerQueries', $lang_strings['STOCK_REPORT_TITLE_50'], '{"report_type":"tabular","display_columns":[{"name":"text","label":"SQL STATEMENT","table_key":"self"},{"name":"sec_avg","label":"Average Seconds","table_key":"self"},{"name":"sec_total","label":"Seconds Total","table_key":"self"},{"name":"run_count","label":"Execution Count","table_key":"self"}],"summary_columns":[],"filters_def":{"Filter_1":{"operator":"AND"}},"filters_combiner":"AND","group_defs":[],"full_table_list":{"self":{"parent":"","value":"TrackerQueries","module":"TrackerQueries","label":"Tracker Queries","children":[]}},"module":"TrackerQueries","report_name":"Slow Queries","chart_type":"none","chart_description":"","numerical_chart_column":"self:count","assigned_user_id":"1"}', 'tabular', 'none', '', '0c6ddce0-beb0-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['Trackers', $lang_strings['STOCK_REPORT_TITLE_51'], '{"display_columns":[{"name":"item_id","label":"Trackers \u003E Item Id","table_key":"self"},{"name":"item_summary","label":"Trackers \u003E Item Summary","table_key":"self"},{"name":"module_name","label":"Trackers \u003E Module Name","table_key":"self"},{"name":"action","label":"Trackers \u003E Action","table_key":"self"},{"name":"date_modified","label":"Trackers \u003E Last Modified","table_key":"self"}],"module":"Trackers","report_name":"My Records Modified (Last 7 Days)","group_defs":[],"summary_columns":[],"chart_type":"none","numerical_chart_column":"","report_type":"tabular","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"action","table_key":"self","qualifier_name":"equals","input_name0":"save","input_name1":"on"},"2":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_7_days","input_name0":"tp_last_7_days"}}}}', 'tabular', 'none', '', '14d84424-beb0-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['Trackers', $lang_strings['STOCK_REPORT_TITLE_52'], '{"display_columns":[{"name":"item_id","label":"Trackers \u003E Item Id","table_key":"self"},{"name":"item_summary","label":"Trackers \u003E Item Summary","table_key":"self"},{"name":"module_name","label":"Trackers \u003E Module Name","table_key":"self"},{"name":"action","label":"Trackers \u003E Action","table_key":"self"},{"name":"date_modified","label":"Trackers \u003E Last Modified","table_key":"self"}],"module":"Trackers","report_name":"My Recently Modified Records (Last 30 Days)","group_defs":[],"summary_columns":[],"chart_type":"none","numerical_chart_column":"","report_type":"tabular","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:tracker_user_id":{"name":"Trackers  \u003E  Assigned to User","label":"Users","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:tracker_user_id"},"dependents":["Filter_1_table_filter_row_1"],"module":"Users"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Trackers:tracker_user_id","qualifier_name":"is","input_name0":["Current User"]},"1":{"name":"action","table_key":"self","qualifier_name":"equals","input_name0":"save","input_name1":"on"},"2":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_30_days","input_name0":"tp_last_30_days"}}}}', 'tabular', 'none', '', '1cb6c210-beb0-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['Trackers', $lang_strings['STOCK_REPORT_TITLE_53'], '{"display_columns":[{"name":"user_id","label":"User Id","table_key":"self"},{"name":"item_id","label":"Item Id","table_key":"self"},{"name":"item_summary","label":"Item Summary","table_key":"self"},{"name":"module_name","label":"Module Name","table_key":"self"},{"name":"date_modified","label":"Last Modified","table_key":"self"}],"module":"Trackers","group_defs":[],"summary_columns":[],"report_name":"Records Modified By My Direct Reports (Last 30 Days)","chart_type":"none","numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Trackers","module":"Trackers","label":"Trackers"},"Trackers:assigned_user_link":{"name":"Trackers  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Trackers:assigned_user_link"},"dependents":["Filter.1_table_filter_row_4","Filter.1_table_filter_row_5","Filter.1_table_filter_row_4","Filter.1_table_filter_row_4"],"module":"Users","label":"Assigned to User","optional":false},"Trackers:assigned_user_link:reports_to_link":{"name":"Trackers  \u003E  Assigned to User  \u003E  Reports To","parent":"Trackers:assigned_user_link","link_def":{"name":"reports_to_link","relationship_name":"user_direct_reports","bean_is_lhs":false,"link_type":"one","label":"Reports to","table_key":"Trackers:assigned_user_link:reports_to_link"},"dependents":["Filter.1_table_filter_row_5","Filter.1_table_filter_row_4","Filter.1_table_filter_row_4"],"module":"Users","label":"Reports to"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"action","table_key":"self","qualifier_name":"equals","input_name0":"save","input_name1":"on"},"1":{"name":"date_modified","table_key":"self","qualifier_name":"tp_last_30_days","input_name0":"tp_last_30_days","input_name1":"on"},"2":{"name":"module_name","table_key":"self","qualifier_name":"not_equals_str","input_name0":"UserPreferences","input_name1":"on"},"3":{"name":"user_name","table_key":"Trackers:assigned_user_link:reports_to_link","qualifier_name":"is","input_name0":["Current User"]}}}}', 'tabular', 'none', '', '24706f1a-beb0-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['TrackerSessions', $lang_strings['STOCK_REPORT_TITLE_54'], '{"display_columns":[{"name":"user_name","label":"User Name","table_key":"TrackerSessions:assigned_user_link"},{"name":"first_name","label":"First Name","table_key":"TrackerSessions:assigned_user_link"},{"name":"last_name","label":"Last Name","table_key":"TrackerSessions:assigned_user_link"}],"module":"TrackerSessions","group_defs":[],"summary_columns":[],"report_name":"Active User Sessions (Last 7 Days)","chart_type":"none","numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"TrackerSessions","module":"TrackerSessions","label":"TrackerSessions"},"TrackerSessions:assigned_user_link":{"name":"TrackerSessions  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tracker_user_id","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"TrackerSessions:assigned_user_link"},"dependents":["display_cols_row_1","display_cols_row_2","display_cols_row_3","display_cols_row_1","display_cols_row_2","display_cols_row_3"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_start","table_key":"self","qualifier_name":"tp_last_7_days","input_name0":"tp_last_7_days","input_name1":"on"},"1":{"name":"active","table_key":"self","qualifier_name":"equals","input_name0":["1"]}}}}', 'tabular', 'none', '', '2a87574c-beb0-11ee-9d94-095590d26ca4'];
        $stock_reports[] = ['TrackerSessions', $lang_strings['STOCK_REPORT_TITLE_55'], '{"display_columns":[],"module":"TrackerSessions","group_defs":[{"name":"user_id","label":"User Id","table_key":"self","type":"varchar"}],"summary_columns":[{"name":"user_id","label":"User Id","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"},{"name":"seconds","label":"SUM: Seconds","field_type":"int","group_function":"sum","table_key":"self"}],"report_name":"User Sessions Summary (Last 7 Days)","chart_type":"none","chart_description":"","numerical_chart_column":"self:seconds:sum","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"TrackerSessions","module":"TrackerSessions","label":"TrackerSessions"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"date_end","table_key":"self","qualifier_name":"tp_last_7_days","input_name0":"tp_last_7_days","input_name1":"on"}}}}', 'summary', 'none', '', '3633dff2-beb0-11ee-9d94-095590d26ca4'];
    }
    $stock_reports[] = ['Users', $lang_strings['STOCK_REPORT_TITLE_68'], '{"display_columns":[{"name":"date_entered","label":"Date Entered","table_key":"self"},{"name":"full_name","label":"Full Name","table_key":"self"},{"name":"title","label":"Title","table_key":"self"},{"name":"address_city","label":"Address City","table_key":"Users:reports_to_link"},{"name":"address_state","label":"Address State","table_key":"Users:reports_to_link"},{"name":"address_country","label":"Address Country","table_key":"Users:reports_to_link"},{"name":"name","label":"Primary Team Name","table_key":"Users:team_link"},{"name":"full_name","label":"Manager\u0027s Name Name","table_key":"Users:reports_to_link"},{"name":"title","label":"Manager\u0027s Title","table_key":"Users:reports_to_link"}],"module":"Users","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_entered","vname":"Date Entered","type":"datetime","required":true,"readonly":true,"table_key":"self","sort_dir":"d"}],"report_name":"Licensed User List","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Users","module":"Users","label":"Users"},"Users:team_link":{"name":"Users  \u003E  Default Primary Team","parent":"self","link_def":{"name":"team_link","relationship_name":"users_team","bean_is_lhs":false,"link_type":"one","label":"Default Primary Team","module":"Teams","table_key":"Users:team_link"},"dependents":["display_cols_row_4"],"module":"Teams","label":"Default Primary Team","optional":true},"Users:reports_to_link":{"name":"Users  \u003E  Reports to","parent":"self","link_def":{"name":"reports_to_link","relationship_name":"user_direct_reports","bean_is_lhs":false,"link_type":"one","label":"Reports to","module":"Users","table_key":"Users:reports_to_link"},"dependents":["display_cols_row_5","display_cols_row_6","display_cols_row_7","display_cols_row_8","display_cols_row_9"],"module":"Users","label":"Reports to","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","input_name0":["Active"]},"1":{"name":"is_group","table_key":"self","qualifier_name":"equals","input_name0":["no"]},"2":{"name":"portal_only","table_key":"self","qualifier_name":"equals","input_name0":["no"]}}},"chart_type":"none"}', 'tabular', 'none', 'Administrators can refer to this report in order to periodically check the number of active users counting against their license and ensure that they are not close to exceeding their limit.', '42a1bfac-beb0-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Teams', $lang_strings['STOCK_REPORT_TITLE_93'], '{"display_columns":[{"name":"date_entered","label":"Date Entered","table_key":"Teams:users"},{"name":"full_name","label":"Full Name","table_key":"Teams:users"},{"name":"title","label":"Title","table_key":"Teams:users"},{"name":"department","label":"Department","table_key":"Teams:users"},{"name":"full_name","label":"Reports To","table_key":"Teams:users:reports_to_link"}],"module":"Teams","group_defs":[{"name":"name","label":"Primary Team Name","table_key":"self","type":"name","force_label":"Primary Team Name"}],"summary_columns":[{"name":"name","label":"Primary Team Name","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"List of Teams and Licensed Users","chart_type":"none","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Teams","module":"Teams","label":"Teams","dependents":[]},"Teams:users":{"name":"Teams  \u003E  Users","parent":"self","link_def":{"name":"users","relationship_name":"team_memberships","bean_is_lhs":true,"link_type":"many","label":"Users","module":"Users","table_key":"Teams:users"},"dependents":["display_cols_row_3","display_cols_row_4","display_cols_row_5","display_cols_row_6","display_cols_row_7","Filter.1_table_filter_row_1","display_cols_row_3","display_cols_row_4","display_cols_row_5","display_cols_row_6","display_cols_row_7","Filter.1_table_filter_row_1","display_cols_row_3","display_cols_row_4","display_cols_row_5","display_cols_row_6","display_cols_row_7","Filter.1_table_filter_row_2","Filter.1_table_filter_row_3","Filter.1_table_filter_row_1","Filter.1_table_filter_row_2","Filter.1_table_filter_row_3","display_cols_row_3","display_cols_row_4","display_cols_row_5","display_cols_row_6","display_cols_row_7"],"module":"Users","label":"Users","optional":true},"Teams:users:reports_to_link":{"name":"Teams  \u003E  Users  \u003E  Reports to","parent":"Teams:users","link_def":{"name":"reports_to_link","relationship_name":"user_direct_reports","bean_is_lhs":false,"link_type":"one","label":"Reports to","module":"Users","table_key":"Teams:users:reports_to_link"},"dependents":["display_cols_row_6","display_cols_row_7","display_cols_row_7","display_cols_row_7"],"module":"Users","label":"Reports to","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"Teams:users","qualifier_name":"is","input_name0":["Active"]},"1":{"name":"portal_only","table_key":"Teams:users","qualifier_name":"equals","input_name0":["no"]},"2":{"name":"is_group","table_key":"Teams:users","qualifier_name":"equals","input_name0":["no"]}}}}', 'detailed_summary', 'none', 'Provides the list of teams and the number users in the team. Group and portal users are excluded in this list. ', '542f4cd0-beb0-11ee-9d94-095590d26ca4'];

    return $stock_reports;
}

function get_customer_sales_reports($is_upgrade = false)
{
    $stock_reports = [];
    $stock_reports[] = ['Calls', 'Open Calls', '{"display_columns":[{"name":"name","label":"Subject","table_key":"self"},{"name":"status","label":"Status","table_key":"self"},{"name":"date_entered","label":"Date Created","table_key":"self"},{"name":"user_name","label":"User Name","table_key":"Calls:assigned_user_link"}],"module":"Calls","group_defs":[],"summary_columns":[],"order_by":[{"name":"date_entered","vname":"Date Created","type":"datetime","group":"created_by_name","table_key":"self","sort_dir":"a"}],"report_name":"Open Calls","do_round":1,"numerical_chart_column":"","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"tabular","full_table_list":{"self":{"value":"Calls","module":"Calls","label":"Calls"},"Calls:assigned_user_link":{"name":"Calls  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"calls_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","table_key":"Calls:assigned_user_link"},"dependents":["display_cols_row_4","Filter.1_table_filter_row_3"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Planned","Not Held"]},"1":{"name":"date_start","table_key":"self","qualifier_name":"tp_last_7_days","runtime":1,"input_name0":"undefined","input_name1":"on"},"2":{"name":"user_name","table_key":"Calls:assigned_user_link","qualifier_name":"one_of","runtime":1,"input_name0":["Current User"]}}},"chart_type":"none"}', 'tabular', 'none', 'List of open calls', '624d8cb4-bea6-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Calls', 'Call Activity by User', '{"display_columns":[{"name":"name","label":"Subject","table_key":"self"},{"name":"date_start","label":"Start Date","table_key":"self"},{"name":"full_name","label":"Name","table_key":"Calls:contacts"}],"module":"Calls","group_defs":[{"name":"user_name","label":"User Name","table_key":"Calls:assigned_user_link","type":"username","force_label":"User Name"}],"summary_columns":[{"name":"user_name","label":"User Name","table_key":"Calls:assigned_user_link"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Call Activity by BDR","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Calls","module":"Calls","label":"Calls","dependents":[]},"Calls:assigned_user_link":{"name":"Calls  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"calls_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Calls:assigned_user_link"},"dependents":["group_by_row_1","display_summaries_row_group_by_row_1","group_by_row_1","display_summaries_row_group_by_row_1","Filter.1.1_table_filter_row_5","Filter.1.1_table_filter_row_3","group_by_row_1","display_summaries_row_group_by_row_1"],"module":"Users","label":"Assigned to User"},"Calls:contacts":{"name":"Calls  \u003E  Contacts","parent":"self","link_def":{"name":"contacts","relationship_name":"calls_contacts","bean_is_lhs":true,"link_type":"many","label":"Contact","module":"Contacts","table_key":"Calls:contacts"},"dependents":["display_cols_row_5","display_cols_row_5","display_cols_row_5"],"module":"Contacts","label":"Contact"}},"filters_def":{"Filter_1":{"0":{"operator":"AND","0":{"name":"status","table_key":"self","qualifier_name":"is","runtime":1,"input_name0":["Held"]},"1":{"name":"date_start","table_key":"self","qualifier_name":"tp_this_year","runtime":1,"input_name0":"tp_this_year","input_name1":"on"},"2":{"name":"user_name","table_key":"Calls:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"}},"operator":"AND"}}}', 'detailed_summary', 'vBarF', '', '8b5cfd80-b60c-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Tasks', 'My Open Tasks by Priority and Status', '{"display_columns":[],"module":"Tasks","group_defs":[{"name":"status","label":"Status","table_key":"self","type":"enum","force_label":"Status"},{"name":"priority","label":"Priority","table_key":"self","type":"enum","force_label":"Priority"}],"summary_columns":[{"name":"status","label":"Status","table_key":"self"},{"name":"priority","label":"Priority","table_key":"self"},{"name":"count","label":"Number of Tasks","field_type":"","group_function":"count","table_key":"self"}],"report_name":"My Open Tasks by Priority and Status","chart_type":"hBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","layout_options":"2x2","full_table_list":{"self":{"value":"Tasks","module":"Tasks","label":"Tasks"},"Tasks:assigned_user_link":{"name":"Tasks  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"tasks_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Tasks:assigned_user_link"},"dependents":["Filter.1_table_filter_row_1","Filter.1_table_filter_row_1","Filter.1_table_filter_row_1","Filter.1_table_filter_row_1"],"module":"Users","label":"Assigned to User","optional":true}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Tasks:assigned_user_link","qualifier_name":"is","runtime":1,"input_name0":["Current User"]},"1":{"name":"status","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["Not Started","In Progress","Pending Input"]}}}}', 'Matrix', 'hBarF', 'My open tasks  grouped by priority and status. This report allows one to focus on higher priority tasks that are near completion. ', '2ef63fe2-b60d-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Accounts', 'Customers By Tier', '{"display_columns":[],"module":"Accounts","group_defs":[{"name":"service_level","label":"Service Level","table_key":"self","type":"enum","force_label":"Service Level"}],"summary_columns":[{"name":"service_level","label":"Service Level","table_key":"self"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Customers By Tier","chart_type":"vBarF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Accounts","module":"Accounts","label":"Accounts","dependents":[]},"Accounts:assigned_user_link":{"name":"Accounts  \u003E  Assigned to User","parent":"self","link_def":{"name":"assigned_user_link","relationship_name":"accounts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Accounts:assigned_user_link"},"dependents":["Filter.1.2_table_filter_row_4","Filter.1.2_table_filter_row_4","Filter.1.2_table_filter_row_4","Filter.1_table_filter_row_5"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Accounts:assigned_user_link","qualifier_name":"anything","runtime":1,"input_name0":"anything","input_name1":"on"},"1":{"name":"service_level","table_key":"self","qualifier_name":"one_of","runtime":1,"input_name0":["T1","T2","T3","T4"]}}}}', 'summary', 'vBarF', '', '87277fa4-b609-11ee-9d94-095590d26ca4'];
    $stock_reports[] = ['Cases', 'Open Cases for My Customers', '{"display_columns":[{"name":"case_number","label":"Number","table_key":"self"},{"name":"name","label":"Subject","table_key":"self"},{"name":"name","label":"Account","table_key":"Cases:accounts"},{"name":"status","label":"Status","table_key":"self"}],"module":"Cases","group_defs":[{"name":"name","label":"Name","table_key":"Cases:accounts","type":"name","force_label":"Name"}],"summary_columns":[{"name":"name","label":"Name","table_key":"Cases:accounts"},{"name":"count","label":"Count","field_type":"","group_function":"count","table_key":"self"}],"report_name":"Open Cases for My Customers","chart_type":"treemapF","do_round":1,"chart_description":"","numerical_chart_column":"self:count","numerical_chart_column_type":"","assigned_user_id":"1","report_type":"summary","full_table_list":{"self":{"value":"Cases","module":"Cases","label":"Cases"},"Cases:accounts":{"name":"Cases  \u003E  Account ","parent":"self","link_def":{"name":"accounts","relationship_name":"account_cases","bean_is_lhs":false,"link_type":"one","label":"Account Name","module":"Accounts","table_key":"Cases:accounts"},"dependents":["Filter.1_table_filter_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5","Filter.1_table_filter_row_1","group_by_row_1","display_summaries_row_group_by_row_1","display_cols_row_5"],"module":"Accounts","label":"Account Name"},"Cases:accounts:assigned_user_link":{"name":"Cases  \u003E  Account  \u003E  Assigned to User","parent":"Cases:accounts","link_def":{"name":"assigned_user_link","relationship_name":"accounts_assigned_user","bean_is_lhs":false,"link_type":"one","label":"Assigned to User","module":"Users","table_key":"Cases:accounts:assigned_user_link"},"dependents":["Filter.1_table_filter_row_1","Filter.1_table_filter_row_1","Filter.1_table_filter_row_1"],"module":"Users","label":"Assigned to User"}},"filters_def":{"Filter_1":{"operator":"AND","0":{"name":"user_name","table_key":"Cases:accounts:assigned_user_link","qualifier_name":"is","runtime":1,"input_name0":["Current User"]},"1":{"name":"status","table_key":"self","qualifier_name":"not_one_of","input_name0":["Closed","Rejected","Duplicate"]}}}}', 'detailed_summary', 'treemapF', '', '929e70ea-b60e-11ee-9d94-095590d26ca4'];

    return $stock_reports;
}

function create_default_reports($is_upgrade = false, $reportlist = [])
{
    $ootb_reports = [];
    $stock_tags = [
        'sales_marketing' => ['Sales and Marketing', 'Template'],
        'customer_service' => ['Customer Service', 'Template'],
        'data_privacy' => ['Data Privacy', 'Template'],
        'administrative' => ['Administrative', 'Template'],
        'customer_sales' => ['Customer Service', 'Sales and Marketing', 'Template'],
    ];

    $ootb_reports['administrative'] = get_admin_reports($is_upgrade);
    $ootb_reports['data_privacy'] = get_data_privacy_reports($is_upgrade);
    $ootb_reports['customer_service'] = get_customer_service_reports($is_upgrade);
    $ootb_reports['sales_marketing'] = get_sales_marketing_reports($is_upgrade);
    $ootb_reports['customer_sales'] = get_customer_sales_reports($is_upgrade);

    // refresh tags links and fields
    if (!isset(VardefManager::$linkFields)) {
        VardefManager::$linkFields = [];
    }

    VardefManager::$linkFields['Tag'] = [];

    foreach ($ootb_reports as $key => $reports) {
        foreach ($reports as $report) {
            if (!empty($reportlist) && !safeInArray($report[1], $reportlist)) {
                continue;
            }
            $saved_report = BeanFactory::newBean('Reports');
            /*
                Report:
                    0: Module
                    1: Name
                    2: Def
                    3: Report Type
                    4: Chart Type
                    5: Description
                    6: Default UUID
                    7: Owner ID
             */

            if ($report[3] == 'tabular') {
                $result = $saved_report->save_report(null, 1, $report[1], $report[0], $report[3], $report[2], 1, '1', 'none', null, $report[5], $report[6] ?? null, 1);
            } else {
                $result = $saved_report->save_report(null, 1, $report[1], $report[0], $report[3], $report[2], 1, '1', $report[4], null, $report[5], $report[6] ?? null, 1);
            }

            $saved_report->load_relationship('tag_link');

            $tagBean = new SugarFieldTag('tag');
            $relBeans = [];
            $addedTags = [];
            foreach ($stock_tags[$key] as $tag) {
                $relBeans[] = $tagBean->getTagBean($tag);
                $addedTags[strtolower($tag)] = $tag;
            }

            $tagBean->addTagsToBean($saved_report, $relBeans, 'tag_link', $addedTags);
        }
    }
}

/**
 * Get the date for the current quarter
 *
 * @return array
 */
function get_quarter()
{
    $y = date('Y');
    $m = date('m');
    switch ($m) {
        case $m >= 1 && $m <= 3:
            $start = $y . '-01-01';
            $end = $y . '-03-31';
            break;
        case $m >= 4 && $m <= 6:
            $start = $y . '-04-01';
            $end = $y . '-06-30';
            break;
        case $m >= 7 && $m <= 9:
            $start = $y . '-07-01';
            $end = $y . '-09-30';
            break;
        case $m >= 10 && $m <= 12:
            $start = $y . '-10-01';
            $end = $y . '-12-31';
            break;
    }
    return [
        'start' => $start,
        'end' => $end,
    ];
}
