<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
/*********************************************************************************
 * Description:
 ********************************************************************************/

if (!is_admin($current_user)) {
    sugar_die($app_strings['LBL_UNAUTH_ADMIN']);
}

$focus = BeanFactory::getBean('ReportMaker', $_POST['record']);

foreach ($focus->column_fields as $field) {
    if (isset($_POST[$field])) {
        $focus->$field = $_POST[$field];
    }
}

foreach ($focus->additional_column_fields as $field) {
    if (isset($_POST[$field])) {
        $value = $_POST[$field];
        $focus->$field = $value;
    }
}

// replace currently assigned teams with the one from request
// since the UI doesn't allow to specify multiple teams
if ($focus->load_relationship('teams')) {
    $focus->teams->replace([$focus->team_id]);
}

$focus->save();

$return_id = $focus->id;

if (isset($_POST['return_module']) && $_POST['return_module'] != '') {
    $return_module = $_POST['return_module'];
} else {
    $return_module = 'ReportMaker';
}
if (isset($_POST['return_action']) && $_POST['return_action'] != '') {
    $return_action = $_POST['return_action'];
} else {
    $return_action = 'DetailView';
}
if (isset($_POST['return_id']) && $_POST['return_id'] != '') {
    $return_id = $_POST['return_id'];
}

$GLOBALS['log']->debug('Saved record with id of ' . $return_id);

$query_data = [
    'action' => $return_action,
    'module' => $return_module,
    'record' => $return_id,
];

$location = 'index.php?' . http_build_query($query_data);
header("Location: $location");
