<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

/*********************************************************************************
 * $Id: view.detail.php
 * Description: This file is used to override the default Meta-data DetailView behavior
 * to provide customization specific to the Campaigns module.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 * Contributor(s): ______________________________________..
 ********************************************************************************/
class ProductsViewDetail extends ViewDetail
{
    public function display()
    {

        $currency = BeanFactory::newBean('Currencies');
        if (isset($this->bean->currency_id) && !empty($this->bean->currency_id)) {
            $currency->retrieve($this->bean->currency_id);
            if ($currency->deleted != 1) {
                $this->ss->assign('CURRENCY', $currency->iso4217 . ' ' . $currency->symbol);
            } else {
                $this->ss->assign('CURRENCY', $currency->getDefaultISO4217() . ' ' . $currency->getDefaultCurrencySymbol());
            }
        } else {
            $this->ss->assign('CURRENCY', $currency->getDefaultISO4217() . ' ' . $currency->getDefaultCurrencySymbol());
        }

        parent::display();
    }
}
