<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['Product'] = [
    'table' => 'products',
    'color' => 'purple',
    'icon' => 'sicon-quoted-line-items-lg',
    'optimistic_locking' => true,
    'audited' => true,
    'activity_enabled' => true,
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'comment' => 'The user (not Admin)) view of a Product definition; an instance of a product',
    'fields' => [
        'revenuelineitem_id' => [
            'name' => 'revenuelineitem_id',
            'type' => 'id',
            'vname' => 'LBL_REVENUELINEITEM_ID',
            'required' => false,
            'reportable' => false,
            'comment' => 'Associated Revenue Line Item that served as the source.',
        ],
        'revenuelineitem_name' => [
            'name' => 'revenuelineitem_name',
            'rname' => 'name',
            'id_name' => 'revenuelineitem_id',
            'vname' => 'LBL_REVENUELINEITEM_NAME',
            'type' => 'relate',
            'link' => 'revenuelineitems',
            'isnull' => 'true',
            'module' => 'RevenueLineItems',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
            'studio' => false,
            'massupdate' => false,
        ],
        'product_template_id' => [
            'name' => 'product_template_id',
            'type' => 'id',
            'vname' => 'LBL_PRODUCT_TEMPLATE_ID',
            'required' => false,
            'reportable' => false,
            'related_fields' => [
                'service',
                'service_start_date',
                'service_end_date',
                'renewable',
                'service_duration_value',
                'service_duration_unit',
            ],
            'comment' => 'Product (in Admin Products) from which this product is derived (in user Products)',
        ],
        'product_template_name' => [
            'name' => 'product_template_name',
            'rname' => 'name',
            'id_name' => 'product_template_id',
            'vname' => 'LBL_PRODUCT_TEMPLATE',
            'join_name' => 'templates',
            'type' => 'relate',
            'link' => 'product_templates_link',
            'table' => 'product_templates',
            'isnull' => 'true',
            'module' => 'ProductTemplates',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
            'studio' => ['editview' => false, 'detailview' => false, 'quickcreate' => false],
            'auto_populate' => true,
            'populate_list' => [
                'name' => 'name',
                'category_id' => 'category_id',
                'category_name' => 'category_name',
                'mft_part_num' => 'mft_part_num',
                'list_price' => 'list_price',
                'cost_price' => 'cost_price',
                'discount_price' => 'discount_price',
                'list_usdollar' => 'list_usdollar',
                'cost_usdollar' => 'cost_usdollar',
                'discount_usdollar' => 'discount_usdollar',
                'tax_class' => 'tax_class',
                'weight' => 'weight',
                'type_id' => 'type_id',
                'type_name' => 'type_name',
                'manufacturer_id' => 'manufacturer_id',
                'manufacturer_name' => 'manufacturer_name',
                'currency_id' => 'currency_id',
                'base_rate' => 'base_rate',
                'service_start_date' => 'service_start_date',
                'service_end_date' => 'service_end_date',
                'service_duration_value' => ['service_duration_value', 'catalog_service_duration_value'],
                'service_duration_unit' => ['service_duration_unit', 'catalog_service_duration_unit'],
                'renewable' => 'renewable',
                'service' => 'service',
            ],
        ],
        'lock_duration' => [
            'name' => 'lock_duration',
            'vname' => 'LBL_LOCK_DURATION',
            'type' => 'bool',
            'default' => 0,
            'studio' => false,
            'enforced' => true,
            'calculated' => true,
            'massupdate' => false,
            'formula' => 'related($product_templates_link, "lock_duration")',
            'comment' => 'Turn on or off a user ability to directly edit the duration field',
        ],
        'account_id' => [
            'name' => 'account_id',
            'type' => 'id',
            'vname' => 'LBL_ACCOUNT_ID',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'readonly' => true,
            'comment' => 'Account this product is associated with',
        ],
        'contact_id' => [
            'name' => 'contact_id',
            'type' => 'id',
            'vname' => 'LBL_CONTACT_ID',
            'group' => 'contact_name',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'comment' => 'Contact this product is associated with',
        ],
        'subtotal' => [
            'name' => 'subtotal',
            'vname' => 'LBL_SUBTOTAL',
            'type' => 'currency',
            'len' => '26,6',
            'default' => '0',
            'related_fields' => [
                'currency_id',
                'base_rate',
                'discount_price',
                'quantity',
                'service_duration_value',
                'service_duration_unit',
                'catalog_service_duration_value',
                'catalog_service_duration_unit',
            ],
            'formula' => '
                ifElse(
                    and(isNumeric($discount_price), isNumeric($quantity)),
                    ifElse(
                        and(
                            isNumeric($service_duration_value),
                            isNumeric($catalog_service_duration_value),
                            not(equal($service_duration_unit, "")),
                            not(equal($catalog_service_duration_unit, ""))
                        ),
                        prorateValue(
                            multiply($discount_price, $quantity),
                            number($service_duration_value),
                            $service_duration_unit,
                            number($catalog_service_duration_value),
                            $catalog_service_duration_unit
                        ),
                        multiply($discount_price, $quantity)
                    ),
                    0
                )
            ',
            'calculated' => true,
            'enforced' => true,
            'comment' => 'The total of the line item before any discounts are applied, taking proration into consideration',
            'additionalCalculationTriggerFields' => [
                'discount_amount',
                'discount_select',
            ],
        ],
        'total_amount' => [
            'name' => 'total_amount',
            'default' => '0.00',
            'formula' => '
                ifElse(and(isNumeric(toString($quantity)), isNumeric(toString($discount_price))),
                    currencySubtract(
                        ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)),
                        ifElse(equal($discount_select, "1"),
                            currencyMultiply(ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)), currencyDivide($discount_amount, 100)),
                            ifElse(greaterThan($quantity, 0), ifElse(isNumeric(toString($discount_amount)),
                                ifElse(greaterThan(0, $discount_price), negate($discount_amount), $discount_amount), 0),
                            ifElse(isNumeric(toString($discount_amount)), negate($discount_amount), 0))
                        )
                    ),
                    ""
                )
            ',
            'calculated' => true,
            'enforced' => true,
            'vname' => 'LBL_CALCULATED_LINE_ITEM_AMOUNT',
            'reportable' => false,
            'type' => 'currency',
            'related_fields' => [
                'currency_id',
                'base_rate',
                'quantity',
                'discount_price',
                'discount_select',
                'discount_amount',
                'subtotal',
            ],
        ],
        'contact_name' => [
            'name' => 'contact_name',
            'rname' => 'name',
            'source' => 'non-db',
            'len' => '510',
            'group' => 'contact_name',
            'vname' => 'LBL_CONTACT_NAME',
            'reportable' => false,
            'id_name' => 'contact_id',
            'join_name' => 'contacts',
            'type' => 'relate',
            'module' => 'Contacts',
            'link' => 'contact_link',
            'table' => 'contacts',
        ],
        'type_id' => [
            'name' => 'type_id',
            'vname' => 'LBL_TYPE',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'comment' => 'Product type (ex: hardware, software)',
        ],
        'quote_id' => [
            'name' => 'quote_id',
            'type' => 'id',
            'vname' => 'LBL_QUOTE_ID',
            'required' => false,
            'reportable' => false,
            'comment' => 'If product created via Quote, this is quote ID',
        ],
        'manufacturer_id' => [
            'name' => 'manufacturer_id',
            'vname' => 'LBL_MANUFACTURER',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'massupdate' => false,
            'comment' => 'Manufacturer of product',
        ],
        'manufacturer_name' => [
            'name' => 'manufacturer_name',
            'rname' => 'name',
            'id_name' => 'manufacturer_id',
            'type' => 'relate',
            'vname' => 'LBL_MANUFACTURER_NAME',
            'join_name' => 'manufacturers',
            'link' => 'manufacturers',
            'table' => 'manufacturers',
            'isnull' => 'true',
            'source' => 'non-db',
            'module' => 'Manufacturers',
            'dbType' => 'varchar',
            'len' => '255',
            'massupdate' => false,
            'related_fields' => [
                'manufacturer_id',
            ],
        ],
        'category_id' => [
            'name' => 'category_id',
            'vname' => 'LBL_CATEGORY',
            'type' => 'id',
            'group' => 'category_name',
            'reportable' => true,
            'comment' => 'Product category',
        ],
        'category_name' => [
            'name' => 'category_name',
            'rname' => 'name',
            'id_name' => 'category_id',
            'vname' => 'LBL_CATEGORY_NAME',
            'join_name' => 'categories',
            'type' => 'relate',
            'link' => 'product_categories_link',
            'table' => 'product_categories',
            'isnull' => 'true',
            'module' => 'ProductCategories',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
            'studio' => ['editview' => false, 'detailview' => false, 'quickcreate' => false],
        ],
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'dbType' => 'varchar',
            'type' => 'name',
            'len' => '255',
            'unified_search' => true,
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 0.80,
            ],
            'comment' => 'Name of the product',
            'reportable' => true,
            'importable' => 'required',
            'required' => true,
            // always keep product_template_name in sync if it is not empty
            'formula' => 'ifElse(equal($product_template_name, ""), $name, $product_template_name)',
        ],
        'mft_part_num' => [
            'name' => 'mft_part_num',
            'vname' => 'LBL_MFT_PART_NUM',
            'type' => 'varchar',
            'len' => '50',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.15,
            ],
            'comment' => 'Manufacturer part number',
        ],
        'cost_price' => [
            'name' => 'cost_price',
            'vname' => 'LBL_COST_PRICE',
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'comment' => 'Product cost ("Cost" in Quote)',
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
        ],
        'discount_amount_signed' => [
            'name' => 'discount_amount_signed',
            'vname' => 'LBL_DISCOUNT_AMOUNT_SIGNED',
            'type' => 'currency',
            'len' => '26,6',
            'default' => '0',
            'audited' => true,
            'comment' => 'Discounted Amount Signed',
            'formula' => 'subtract(ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)), $total_amount)',
            'calculated' => true,
            'studio' => false,
            'enforced' => true,
        ],
        'discount_price' => [
            'name' => 'discount_price',
            'vname' => 'LBL_DISCOUNT_PRICE',
            'type' => 'currency',
            'len' => '26,6',
            'default' => '0',
            'audited' => true,
            'comment' => 'Discounted price ("Unit Price" in Quote)',
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
        ],
        'discount_amount' => [
            'name' => 'discount_amount',
            'vname' => 'LBL_DISCOUNT_AMOUNT',
            'dbType' => 'currency',
            'type' => 'discount-amount',
            'len' => '26,6',
            'default' => '0',
            'precision' => '6',
            'comment' => 'Discounted amount',
            'related_fields' => [
                'currency_id',
                'base_rate',
                'discount_select',
            ],
        ],
        'discount_rate_percent' => [
            'name' => 'discount_rate_percent',
            'formula' => 'ifElse(isNumeric($discount_price), ifElse(equal($discount_price, 0), 0, multiply(divide($discount_amount, $discount_price), 100)), 0)',
            'calculated' => true,
            'enforced' => true,
            'vname' => 'LBL_DISCOUNT_RATE',
            'reportable' => false,
            'type' => 'decimal',
            'precision' => 2,
            'len' => '26,2',
        ],
        'discount_amount_usdollar' => [
            'name' => 'discount_amount_usdollar',
            'vname' => 'LBL_DISCOUNT_RATE_USDOLLAR',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'formula' => 'ifElse(isNumeric($discount_amount), currencyDivide($discount_amount, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'discount_select' => [
            'name' => 'discount_select',
            'vname' => 'LBL_DISCOUNT_AS_PERCENT',
            'type' => 'bool',
            'default' => true,
            'reportable' => false,
        ],
        'deal_calc' => [
            'name' => 'deal_calc',
            'vname' => 'LBL_DISCOUNT_TOTAL',
            'type' => 'currency',
            'len' => '26,6',
            'group' => 'deal_calc',
            'comment' => 'deal_calc',
            'formula' => 'ifElse(equal($discount_select, "1"),
                            currencyMultiply(ifElse(isNumeric($subtotal), $subtotal, multiply($discount_price, $quantity)), currencyDivide($discount_amount, 100)),
                            ifElse(isNumeric($discount_amount_signed), $discount_amount_signed, 0)
                        )',
            'calculated' => true,
            'enforced' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
                'discount_price',
                'quantity',
                'discount_amount',
                'subtotal',
            ],
        ],
        'deal_calc_usdollar' => [
            'name' => 'deal_calc_usdollar',
            'vname' => 'LBL_DISCOUNT_TOTAL_USDOLLAR',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'group' => 'deal_calc',
            'comment' => 'deal_calc_usdollar',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($deal_calc), currencyDivide($deal_calc, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'cost_usdollar' => [
            'name' => 'cost_usdollar',
            'vname' => 'LBL_COST_USDOLLAR',
            'dbType' => 'decimal',
            'group' => 'cost_price',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'comment' => 'Cost expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($cost_price), currencyDivide($cost_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'discount_usdollar' => [
            'name' => 'discount_usdollar',
            'vname' => 'LBL_DISCOUNT_USDOLLAR',
            'dbType' => 'decimal',
            'group' => 'discount_price',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'comment' => 'Discount price expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'formula' => 'divide($discount_price, $base_rate)',
            'calculated' => true,
            'enforced' => true,
        ],
        'list_usdollar' => [
            'name' => 'list_usdollar',
            'vname' => 'LBL_LIST_USDOLLAR',
            'dbType' => 'decimal',
            'type' => 'currency',
            'currency_id' => '-99',
            'group' => 'list_price',
            'len' => '26,6',
            'comment' => 'List price expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($list_price), currencyDivide($list_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'status' => [
            'name' => 'status',
            'vname' => 'LBL_STATUS',
            'type' => 'enum',
            'options' => 'product_status_dom',
            'default' => '',
            'len' => 100,
            'audited' => true,
            'comment' => 'Product status (ex: Quoted, Ordered, Shipped)',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => false,
            ],
        ],
        'book_value_usdollar' => [
            'name' => 'book_value_usdollar',
            'vname' => 'LBL_BOOK_VALUE_USDOLLAR',
            'group' => 'book_value',
            'type' => 'currency',
            'len' => '26,6',
            'comment' => 'Book value expressed in USD',
            'studio' => [
                'editview' => false,
                'mobile' => false,
            ],
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($book_value), currencyDivide($book_value, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'quotes' => [
            'name' => 'quotes',
            'type' => 'link',
            'relationship' => 'quote_products',
            'vname' => 'LBL_QUOTE',
            'source' => 'non-db',
        ],
        'revenuelineitems' => [
            'name' => 'revenuelineitems',
            'type' => 'link',
            'relationship' => 'products_revenuelineitems',
            'vname' => 'LBL_REVENUELINEITEM',
            'source' => 'non-db',
            'workflow' => false,
        ],
        'date_closed' => [
            'name' => 'date_closed',
            'vname' => 'LBL_DATE_CLOSED',
            'type' => 'date',
            'audited' => true,
            'comment' => 'Expected or actual date the product (for opportunity) will close',
            'enable_range_search' => true,
            'options' => 'date_range_search_dom',
        ],
        'date_closed_timestamp' => [
            'name' => 'date_closed_timestamp',
            'vname' => 'LBL_DATE_CLOSED_TIMESTAMP',
            'type' => 'ulong',
            'reportable' => false,
            'studio' => false,
            'enforced' => true,
            'calculated' => true,
            'formula' => 'timestamp($date_closed)',
            'importable' => false,
        ],
        'next_step' => [
            'name' => 'next_step',
            'vname' => 'LBL_NEXT_STEP',
            'type' => 'varchar',
            'len' => '100',
            'comment' => 'The next step in the sales process',
            'merge_filter' => 'enabled',
        ],
        'campaign_id' => [
            'name' => 'campaign_id',
            'comment' => 'Campaign that generated lead',
            'vname' => 'LBL_CAMPAIGN_ID',
            'rname' => 'id',
            'type' => 'id',
            'dbType' => 'id',
            'table' => 'campaigns',
            'isnull' => 'true',
            'module' => 'Campaigns',
            'reportable' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'campaign_name' => [
            'name' => 'campaign_name',
            'rname' => 'name',
            'id_name' => 'campaign_id',
            'vname' => 'LBL_CAMPAIGN',
            'type' => 'relate',
            'link' => 'campaign_products',
            'isnull' => 'true',
            'table' => 'campaigns',
            'module' => 'Campaigns',
            'source' => 'non-db',
            'studio' => [
                'mobile' => false,
            ],
        ],
        'campaign_products' => [
            'name' => 'campaign_products',
            'type' => 'link',
            'vname' => 'LBL_CAMPAIGN_PRODUCT',
            'relationship' => 'campaign_products',
            'source' => 'non-db',
        ],
        'related_products' => [
            'name' => 'related_products',
            'type' => 'link',
            'relationship' => 'product_product',
            'source' => 'non-db',
            'vname' => 'LBL_RELATED_PRODUCTS',
        ],
        'notes' => [
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'product_notes',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'messages' => [
            'name' => 'messages',
            'type' => 'link',
            'relationship' => 'product_messages',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'documents' => [
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_products',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
        ],
        'contracts' => [
            'name' => 'contracts',
            'type' => 'link',
            'vname' => 'LBL_CONTRACTS',
            'relationship' => 'contracts_products',
            'link_type' => 'one',
            'source' => 'non-db',
        ],
        'quote_name' => [
            'name' => 'quote_name',
            'rname' => 'name',
            'id_name' => 'quote_id',
            'join_name' => 'quotes',
            'type' => 'relate',
            'link' => 'quotes',
            'table' => 'quotes',
            'isnull' => 'true',
            'module' => 'Quotes',
            'dbType' => 'varchar',
            'len' => '255',
            'vname' => 'LBL_QUOTE_NAME',
            'source' => 'non-db',
            'comment' => 'Quote Name',
        ],
        'quote_locked_currency_rates' => [
            'name' => 'quote_locked_currency_rates',
            'rname' => 'locked_currency_rates',
            'id_name' => 'quote_id',
            'join_name' => 'quotes',
            'type' => 'relate',
            'link' => 'quotes',
            'table' => 'quotes',
            'module' => 'Quotes',
            'dbType' => 'longtext',
            'vname' => 'locked_currency_rates',
            'source' => 'non-db',
            'comment' => 'Quote Locked Currency Rates',
        ],
        'opportunity_id' => [
            'name' => 'opportunity_id',
            'type' => 'id',
            'vname' => 'LBL_OPPORTUNITY_ID',
            'required' => false,
            'isnull' => true,
            'reportable' => false,
            'comment' => 'The opportunity id for the line item entry',
        ],
        'opportunity_name' => [
            'name' => 'opportunity_name',
            'rname' => 'name',
            'id_name' => 'opportunity_id',
            'vname' => 'LBL_OPPORTUNITY_NAME',
            'join_name' => 'opportunities',
            'type' => 'relate',
            'link' => 'opportunities',
            'table' => 'opportunities',
            'isnull' => 'true',
            'module' => 'Opportunities',
            'source' => 'non-db',
            'comment' => 'The opportunity name associated with the opportunity_id',
            'auto_populate' => true,
            'populate_list' => [
                'account_id' => 'account_id',
                'account_name' => 'account_name',
            ],
        ],
        'opportunities' => [
            'name' => 'opportunities',
            'type' => 'link',
            'relationship' => 'opportunities_products',
            'source' => 'non-db',
            'link_type' => 'one',
            'module' => 'Opportunities',
            'bean_name' => 'Opportunity',
            'vname' => 'LBL_OPPORTUNITIES',
        ],
        'type_name' => [
            'name' => 'type_name',
            'rname' => 'name',
            'id_name' => 'type_id',
            'vname' => 'LBL_PRODUCT_TYPE',
            'join_name' => 'types',
            'type' => 'relate',
            'link' => 'product_types_link',
            'table' => 'product_types',
            'isnull' => 'true',
            'module' => 'ProductTypes',
            'importable' => 'false',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
        ],
        'account_link' => [
            'name' => 'account_link',
            'type' => 'link',
            'relationship' => 'products_accounts',
            'link_class' => 'AccountLink',
            'vname' => 'LBL_ACCOUNT',
            'link_type' => 'one',
            'module' => 'Accounts',
            'bean_name' => 'Account',
            'source' => 'non-db',
        ],
        'product_categories_link' => [
            'name' => 'product_categories_link',
            'type' => 'link',
            'relationship' => 'product_categories',
            'vname' => 'LBL_PRODUCT_CATEGORIES',
            'link_type' => 'one',
            'module' => 'ProductCategories',
            'bean_name' => 'ProductCategory',
            'source' => 'non-db',
        ],
        'product_templates_link' => [
            'name' => 'product_templates_link',
            'type' => 'link',
            'relationship' => 'product_templates',
            'vname' => 'LBL_PRODUCT_TEMPLATES',
            'link_type' => 'one',
            'module' => 'ProductTemplates',
            'bean_name' => 'ProductTemplate',
            'source' => 'non-db',
        ],
        'product_types_link' => [
            'name' => 'product_types_link',
            'type' => 'link',
            'relationship' => 'product_types',
            'vname' => 'LBL_PRODUCT_TYPES',
            'link_type' => 'one',
            'module' => 'ProductTypes',
            'bean_name' => 'ProductType',
            'source' => 'non-db',
        ],
        'contact_link' => [
            'name' => 'contact_link',
            'type' => 'link',
            'relationship' => 'contact_products',
            'vname' => 'LBL_CONTACT',
            'link_type' => 'one',
            'module' => 'Contacts',
            'bean_name' => 'Contact',
            'source' => 'non-db',
            'duplicate_merge' => 'disabled',
        ], //bug 20184, add contact_link field
        'pli_addons_link' => [
            'name' => 'pli_addons_link',
            'type' => 'link',
            'relationship' => 'product_pli_addons',
            'vname' => 'LBL_ADD_ON_TO',
            'link_type' => 'one',
            'module' => 'PurchasedLineItems',
            'bean_name' => 'PurchasedLineItem',
            'source' => 'non-db',
        ],
        'parent_rli_link' => [
            'name' => 'parent_rli_link',
            'type' => 'link',
            'relationship' => 'products_parent_rli',
            'vname' => 'LBL_REVENUELINEITEM',
            'link_type' => 'one',
            'module' => 'RevenueLineItems',
            'bean_name' => 'RevenueLineItem',
            'source' => 'non-db',
        ],
        'account_name' => [
            'name' => 'account_name',
            'rname' => 'name',
            'id_name' => 'account_id',
            'vname' => 'LBL_ACCOUNT_NAME',
            'join_name' => 'accounts',
            'type' => 'relate',
            'link' => 'account_link',
            'table' => 'accounts',
            'module' => 'Accounts',
            'source' => 'non-db',
            'readonly' => true,
        ],
        'emails' => [
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'emails_products_rel', /* reldef in emails */
            'module' => 'Emails',
            'bean_name' => 'Email',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'studio' => ['formula' => false],
        ],
        'projects' => [
            'name' => 'projects',
            'type' => 'link',
            'relationship' => 'projects_products',
            'source' => 'non-db',
            'vname' => 'LBL_PROJECTS',
        ],
        'product_bundles' => [
            'name' => 'product_bundles',
            'type' => 'link',
            'relationship' => 'product_bundle_product',
            'module' => 'ProductBundles',
            'bean_name' => 'ProductBundle',
            'source' => 'non-db',
            'rel_fields' => ['product_index' => ['type' => 'integer']],
            'vname' => 'LBL_PRODUCTS',
        ],
        'position' => [
            'massupdate' => false,
            'name' => 'position',
            'type' => 'integer',
            'studio' => false,
            'source' => 'non-db',
            'vname' => 'LBL_PRODUCT_POSITION',
            'importable' => false,
            'link' => 'product_bundles',
            'rname_link' => 'product_index',
        ],
        'calls' => [
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'product_calls',
            'module' => 'Calls',
            'bean_name' => 'Call',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
        ],
        'meetings' => [
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'product_meetings',
            'module' => 'Meetings',
            'bean_name' => 'Meeting',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
        ],
        'manufacturers' => [
            'name' => 'manufacturers',
            'type' => 'link',
            'relationship' => 'product_manufacturers',
            'vname' => 'LBL_MANUFACTURERS',
            'link_type' => 'one',
            'module' => 'Manufacturers',
            'bean_name' => 'Manufacturer',
            'source' => 'non-db',
        ],
        'parent_rli_id' => [
            'name' => 'parent_rli_id',
            'comment' => 'RLI this product was generated from',
            'vname' => 'LBL_REVENUELINEITEM_ID',
            'rname' => 'id',
            'type' => 'id',
            'dbType' => 'id',
            'is_null' => true,
            'reportable' => false,
            'massupdate' => false,
            'table' => 'revenue_line_items',
            'module' => 'RevenueLineItems',
            'duplicate_merge' => 'disabled',
        ],
        'parent_rli_name' => [
            'name' => 'parent_rli_name',
            'rname' => 'name',
            'id_name' => 'parent_rli_id',
            'vname' => 'LBL_REVENUELINEITEM',
            'type' => 'relate',
            'save' => true,
            'isnull' => true,
            'link' => 'parent_rli_link',
            'table' => 'revenue_line_items',
            'module' => 'RevenueLineItems',
            'source' => 'non-db',
            'studio' => false,
        ],
        'add_on_to_id' => [
            'name' => 'add_on_to_id',
            'comment' => 'Purchased line item that this is an add-on to',
            'vname' => 'LBL_ADD_ON_TO_ID',
            'rname' => 'id',
            'type' => 'id',
            'dbType' => 'id',
            'table' => 'purchased_line_items',
            'isnull' => 'true',
            'module' => 'PurchasedLineItems',
            'reportable' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'add_on_to_name' => [
            'name' => 'add_on_to_name',
            'rname' => 'name',
            'id_name' => 'add_on_to_id',
            'vname' => 'LBL_ADD_ON_TO',
            'type' => 'relate',
            'save' => true,
            'link' => 'pli_addons_link',
            'isnull' => 'true',
            'table' => 'purchased_line_items',
            'module' => 'PurchasedLineItems',
            'source' => 'non-db',
            'massupdate' => false,
            'copyFromPurchasedLineItem' => [
                'product_template_id' => 'product_template_id',
                'product_template_name' => 'product_template_name',
                'service_end_date' => 'service_end_date',
            ],
            'copyFromProductTemplate' => [
                'name' => 'name',
                'category_id' => 'category_id',
                'category_name' => 'category_name',
                'mft_part_num' => 'mft_part_num',
                'list_price' => 'list_price',
                'cost_price' => 'cost_price',
                'discount_price' => 'discount_price',
                'list_usdollar' => 'list_usdollar',
                'cost_usdollar' => 'cost_usdollar',
                'discount_usdollar' => 'discount_usdollar',
                'currency_id' => 'currency_id',
                'base_rate' => 'base_rate',
                'tax_class' => 'tax_class',
                'weight' => 'weight',
                'manufacturer_id' => 'manufacturer_id',
                'manufacturer_name' => 'manufacturer_name',
                'type_id' => 'type_id',
                'type_name' => 'type_name',
                'renewable' => 'renewable',
                'service' => 'service',
                'service_duration_value' => 'catalog_service_duration_value',
                'service_duration_unit' => 'catalog_service_duration_unit',
            ],
        ],
    ],
    'indices' => [
        [
            'name' => 'idx_prod_user_dc_timestamp',
            'type' => 'index',
            'fields' => ['id', 'assigned_user_id', 'date_closed_timestamp'],
        ],
        ['name' => 'idx_product_quantity', 'type' => 'index', 'fields' => ['quantity']],
        ['name' => 'idx_product_contact', 'type' => 'index', 'fields' => ['contact_id']],
        ['name' => 'idx_product_account', 'type' => 'index', 'fields' => ['account_id']],
        ['name' => 'idx_product_opp', 'type' => 'index', 'fields' => ['opportunity_id']],
        ['name' => 'idx_product_quote', 'type' => 'index', 'fields' => ['quote_id']],
        ['name' => 'idx_product_rli', 'type' => 'index', 'fields' => ['revenuelineitem_id']],
        [
            'name' => 'idx_product_del_created_by_pt_id',
            'type' => 'index',
            'fields' => [
                'deleted',
                'created_by',
                'product_template_id',
            ],
        ],
        [
            'name' => 'idx_del_p_rli_id',
            'type' => 'index',
            'fields' => [
                'deleted',
                'parent_rli_id',
            ],
        ],
    ],
    'relationships' => [
        'product_notes' => [
            'lhs_module' => 'Products',
            'lhs_table' => 'products',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Products',
        ],
        'product_messages' => [
            'lhs_module' => 'Products',
            'lhs_table' => 'products',
            'lhs_key' => 'id',
            'rhs_module' => 'Messages',
            'rhs_table' => 'messages',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Products',
        ],
        'opportunities_products' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'opportunity_id',
            'relationship_type' => 'one-to-many',
        ],
        'products_accounts' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'account_id',
            'relationship_type' => 'one-to-many',
        ],
        'product_categories' => [
            'lhs_module' => 'ProductCategories',
            'lhs_table' => 'product_categories',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'category_id',
            'relationship_type' => 'one-to-many',
        ],
        'product_templates' => [
            'lhs_module' => 'ProductTemplates',
            'lhs_table' => 'product_templates',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'product_template_id',
            'relationship_type' => 'one-to-many',
        ],
        'product_types' => [
            'lhs_module' => 'ProductTypes',
            'lhs_table' => 'product_types',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'type_id',
            'relationship_type' => 'one-to-many',
        ],
        'products_modified_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'modified_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'products_assigned_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'assigned_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'products_created_by' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'created_by',
            'relationship_type' => 'one-to-many',
        ],
        'products_revenuelineitems' => [
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'revenuelineitem_id',
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'relationship_type' => 'one-to-one',
        ],
        'product_calls' => [
            'lhs_module' => 'Products',
            'lhs_table' => 'products',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Products',
        ],
        'product_meetings' => [
            'lhs_module' => 'Products',
            'lhs_table' => 'products',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Products',
        ],
        'product_manufacturers' => [
            'lhs_module' => 'Manufacturers',
            'lhs_table' => 'manufacturers',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'manufacturer_id',
            'relationship_type' => 'one-to-many',
        ],
        'products_parent_rli' => [
            'lhs_module' => 'RevenueLineItems',
            'lhs_table' => 'revenue_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'parent_rli_id',
            'relationship_type' => 'one-to-many',
        ],
        'product_pli_addons' => [
            'lhs_module' => 'PurchasedLineItems',
            'lhs_table' => 'purchased_line_items',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'add_on_to_id',
            'relationship_type' => 'one-to-many',
        ],
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$and' => [
                        ['opportunity_id' => ['$equals' => '$opportunity_id']],
                        ['name' => ['$starts' => '$name']],
                    ],
                ],
            ],
            'ranking_fields' => [
                ['in_field_name' => 'opportunity_id', 'dupe_field_name' => 'opportunity_id'],
                ['in_field_name' => 'name', 'dupe_field_name' => 'name'],
            ],
        ],
    ],
];

VardefManager::createVardef(
    'Products',
    'Product',
    [
        'default',
        'assignable',
        'team_security',
        'sales_item',
        'commentlog',
        'audit',
    ]
);

//boost value for full text search
$dictionary['Product']['fields']['description']['full_text_search']['boost'] = 0.40;
