<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['ProductTemplate'] = [
    'table' => 'product_templates',
    'color' => 'pink',
    'icon' => 'sicon-catalog',
    'comment' => 'The Admin view of a Product in Product Catalog; used as template for a product instance',
    'audited' => true,
    'full_text_search' => true,
    'default_relate_filter' => [
        'initial_filter' => 'product_template_status',
        'initial_filter_label' => 'LBL_FILTER_ACTIVE_STATUS',
        'filter_populate' => [
            'active_status' => ['Active'],
        ],
    ],
    'fields' => [
        'type_id' => [
            'name' => 'type_id',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'vname' => 'LBL_TYPE_ID',
            'importable' => 'true',
            'comment' => 'Product type (ex: hardware, software)',
        ],
        'manufacturer_id' => [
            'name' => 'manufacturer_id',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'vname' => 'LBL_LIST_MANUFACTURER_ID',
            'importable' => 'true',
            'comment' => 'Manufacturer of the product',
        ],
        'manufacturer_name' => [
            'name' => 'manufacturer_name',
            'rname' => 'name',
            'id_name' => 'manufacturer_id',
            'type' => 'relate',
            'vname' => 'LBL_MANUFACTURER_NAME',
            'join_name' => 'manufacturers',
            'link' => 'manufacturer_link',
            'table' => 'manufacturers',
            'isnull' => 'true',
            'source' => 'non-db',
            'module' => 'Manufacturers',
            'dbType' => 'varchar',
            'len' => '255',
            'studio' => 'false',
        ],
        'category_id' => [
            'name' => 'category_id',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'vname' => 'LBL_LIST_CATEGORY_ID',
            'importable' => 'true',
            'comment' => 'Category of the product',
        ],
        'category_name' => [
            'name' => 'category_name',
            'rname' => 'name',
            'id_name' => 'category_id',
            'vname' => 'LBL_CATEGORY_NAME',
            'join_name' => 'product_categories',
            'type' => 'relate',
            'link' => 'category_link',
            'table' => 'product_categories',
            'isnull' => 'true',
            'module' => 'ProductCategories',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
        ],
        'type_name' => [
            'name' => 'type_name',
            'rname' => 'name',
            'id_name' => 'type_id',
            'vname' => 'LBL_PRODUCT_TYPE',
            'join_name' => 'product_types',
            'type' => 'relate',
            'link' => 'type_link',
            'table' => 'product_types',
            'isnull' => 'true',
            'module' => 'ProductTypes',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
            'importable' => 'true',
        ],
        'mft_part_num' => [
            'name' => 'mft_part_num',
            'vname' => 'LBL_MFT_PART_NUM',
            'type' => 'varchar',
            'len' => '50',
            'comment' => 'Manufacturer part number',
        ],
        'vendor_part_num' => [
            'name' => 'vendor_part_num',
            'vname' => 'LBL_VENDOR_PART_NUM',
            'type' => 'varchar',
            'len' => '50',
            'comment' => 'Vendor part number',
        ],
        'date_cost_price' => [
            'name' => 'date_cost_price',
            'vname' => 'LBL_DATE_COST_PRICE',
            'type' => 'date',
            'massupdate' => false,
            'comment' => 'Starting date cost price is valid',
        ],
        'cost_price' => [
            'name' => 'cost_price',
            'vname' => 'LBL_COST_PRICE',
            'type' => 'currency',
            'required' => true,
            'len' => '26,6',
            'comment' => 'Product cost ("Cost" in Quote)',
            'importable' => 'required',
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
        ],
        'discount_price' => [
            'name' => 'discount_price',
            'vname' => 'LBL_DISCOUNT_PRICE',
            'type' => 'currency',
            'len' => '26,6',
            'comment' => 'Discounted price ("Unit Price" in Quote)',
            'importable' => 'required',
            'required' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
        ],
        'list_price' => [
            'name' => 'list_price',
            'vname' => 'LBL_LIST_PRICE',
            'type' => 'currency',
            'len' => '26,6',
            'importable' => 'required',
            'required' => true,
            'comment' => 'List price of product ("List" in Quote)',
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
        ],
        'cost_usdollar' => [
            'name' => 'cost_usdollar',
            'vname' => 'LBL_COST_USDOLLAR',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'comment' => 'Cost expressed in USD',
            'studio' => [
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($cost_price), currencyDivide($cost_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'discount_usdollar' => [
            'name' => 'discount_usdollar',
            'vname' => 'LBL_DISCOUNT_USDOLLAR',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'comment' => 'Discount price expressed in USD',
            'studio' => [
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($discount_price), currencyDivide($discount_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'list_usdollar' => [
            'name' => 'list_usdollar',
            'vname' => 'LBL_LIST_USDOLLAR',
            'type' => 'currency',
            'currency_id' => '-99',
            'len' => '26,6',
            'comment' => 'List price expressed in USD',
            'studio' => [
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($list_price), currencyDivide($list_price, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'status' => [
            'name' => 'status',
            'vname' => 'LBL_STATUS',
            'type' => 'enum',
            'options' => 'product_template_status_dom',
            'len' => 100,
            'comment' => 'Product status (not used in product Catalog)',
        ],
        'tax_class' => [
            'name' => 'tax_class',
            'vname' => 'LBL_TAX_CLASS',
            'type' => 'enum',
            'options' => 'tax_class_dom',
            'len' => 100,
            'comment' => 'Tax classification (ex: Taxable, Non-taxable)',
        ],
        'active_status' => [
            'name' => 'active_status',
            'vname' => 'LBL_ACTIVE_STATUS',
            'type' => 'enum',
            'options' => 'active_status_dom',
            'default' => 'Active',
            'len' => 100,
            'comment' => 'Active status (ex: Active, Inactive or Retired)',
            'studio' => [
                'wirelesslistview' => false,
                'wirelesseditview' => false,
                'wirelessdetailview' => false,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
                'mobile' => false,
            ],
            'massupdate' => true,
        ],
        'date_available' => [
            'name' => 'date_available',
            'vname' => 'LBL_DATE_AVAILABLE',
            'type' => 'date',
            'comment' => 'Availability date',
        ],
        'website' => [
            'name' => 'website',
            'vname' => 'LBL_URL',
            'type' => 'varchar',
            'len' => '255',
            'comment' => 'Product URL',
        ],
        'weight' => [
            'name' => 'weight',
            'vname' => 'LBL_WEIGHT',
            'type' => 'decimal',
            'len' => '12',
            'precision' => '2',
            'comment' => 'Weight of the product',
        ],
        'qty_in_stock' => [
            'name' => 'qty_in_stock',
            'vname' => 'LBL_QUANTITY',
            'type' => 'int',
            'len' => '5',
            'comment' => 'Quantity on hand',
        ],
        'support_name' => [
            'name' => 'support_name',
            'vname' => 'LBL_SUPPORT_NAME',
            'type' => 'varchar',
            'len' => '50',
            'comment' => 'Name of product for support purposes',
        ],
        'support_description' => [
            'name' => 'support_description',
            'vname' => 'LBL_SUPPORT_DESCRIPTION',
            'type' => 'varchar',
            'len' => '255',
            'comment' => 'Description of product for support purposes',
        ],
        'support_contact' => [
            'name' => 'support_contact',
            'vname' => 'LBL_SUPPORT_CONTACT',
            'type' => 'varchar',
            'len' => '50',
            'comment' => 'Contact for support purposes',
        ],
        'support_term' => [
            'name' => 'support_term',
            'vname' => 'LBL_SUPPORT_TERM',
            'type' => 'enum',
            'options' => 'support_term_dom',
            'len' => 100,
            'comment' => 'Term (length) of support contract',
        ],
        'pricing_formula' => [
            'name' => 'pricing_formula',
            'vname' => 'LBL_PRICING_FORMULA',
            'type' => 'pricing-formula',
            'dbType' => 'enum',
            'options' => 'pricing_formula_dom',
            'len' => 100,
            'comment' => 'Pricing formula (ex: Fixed, Markup over Cost)',
            'studio' => [
                'field' => [
                    'options' => false,
                ],
            ],
            'related_fields' => [
                'pricing_factor',
            ],
        ],
        'pricing_factor' => [
            'name' => 'pricing_factor',
            'vname' => 'LBL_PRICING_FACTOR',
            'type' => 'decimal',
            'len' => '8',
            'precision' => '2',
            'comment' => 'Variable pricing factor depending on pricing_formula',
            'related_fields' => [
                'pricing_formula',
            ],
        ],
        'category_link' => [
            'name' => 'category_link',
            'type' => 'link',
            'relationship' => 'product_templates_product_categories',
            'vname' => 'LBL_PRODUCT_CATEGORIES',
            'link_type' => 'one',
            'module' => 'ProductCategories',
            'bean_name' => 'ProductCategory',
            'source' => 'non-db',
        ],
        'type_link' => [
            'name' => 'type_link',
            'type' => 'link',
            'relationship' => 'product_templates_product_types',
            'vname' => 'LBL_PRODUCT_TYPES',
            'link_type' => 'one',
            'module' => 'ProductTypes',
            'bean_name' => 'ProductType',
            'source' => 'non-db',
        ],
        'manufacturer_link' => [
            'name' => 'manufacturer_link',
            'type' => 'link',
            'relationship' => 'product_templates_manufacturers',
            'vname' => 'LBL_MANUFACTURERS',
            'link_type' => 'one',
            'module' => 'Manufacturers',
            'bean_name' => 'Manufacturer',
            'source' => 'non-db',
        ],
        'forecastworksheet' => [
            'name' => 'forecastworksheet',
            'type' => 'link',
            'relationship' => 'forecastworksheets_templates',
            'source' => 'non-db',
            'vname' => 'LBL_FORECAST_WORKSHEET',
        ],
        'service_duration_value' => [
            'name' => 'service_duration_value',
            'vname' => 'LBL_SERVICE_DURATION_VALUE',
            'type' => 'int',
            'min' => '1',
            'len' => '5',
            'studio' => false,
            'required' => false,
            'comment' => 'Value of the service duration, if service duration is 4 Months the value is 4',
        ],
        'service_duration_unit' => [
            'name' => 'service_duration_unit',
            'vname' => 'LBL_SERVICE_DURATION_UNIT',
            'type' => 'enum',
            'options' => 'service_duration_unit_dom',
            'len' => 50,
            'studio' => false,
            'audited' => false,
            'comment' => 'Service Duration unit like Year(s), Month(s) or Day(s)',
        ],
        'renewable' => [
            'name' => 'renewable',
            'vname' => 'LBL_RENEWABLE',
            'type' => 'bool',
            'default' => 0,
            'comment' => 'Indicates whether the sales item is renewable (e.g. a service)',
        ],
        'service' => [
            'name' => 'service',
            'vname' => 'LBL_SERVICE',
            'type' => 'bool',
            'default' => 0,
            'comment' => 'Indicates whether the sales item is a service or a product',
        ],
        'lock_duration' => [
            'name' => 'lock_duration',
            'vname' => 'LBL_LOCK_DURATION',
            'type' => 'bool',
            'default' => 0,
            'comment' => 'Indicates whether the duration can be manually changed',
        ],
    ],
    'relationships' => [
        'product_templates_product_categories' => [
            'lhs_module' => 'ProductCategories',
            'lhs_table' => 'product_categories',
            'lhs_key' => 'id',
            'rhs_module' => 'ProductTemplates',
            'rhs_table' => 'product_templates',
            'rhs_key' => 'category_id',
            'relationship_type' => 'one-to-many',
        ],
        'product_templates_product_types' => [
            'lhs_module' => 'ProductTypes',
            'lhs_table' => 'product_types',
            'lhs_key' => 'id',
            'rhs_module' => 'ProductTemplates',
            'rhs_table' => 'product_templates',
            'rhs_key' => 'type_id',
            'relationship_type' => 'one-to-many',
        ],
        'product_templates_manufacturers' => [
            'lhs_module' => 'Manufacturers',
            'lhs_table' => 'manufacturers',
            'lhs_key' => 'id',
            'rhs_module' => 'ProductTemplates',
            'rhs_table' => 'product_templates',
            'rhs_key' => 'manufacturer_id',
            'relationship_type' => 'one-to-many',
        ],
    ],
    'indices' => [
        ['name' => 'idx_producttemplate_qty_in_stock', 'type' => 'index', 'fields' => ['qty_in_stock']],
        ['name' => 'idx_producttemplate_category', 'type' => 'index', 'fields' => ['category_id', 'active_status', 'deleted']],
        [
            'name' => 'idx_id_name',
            'type' => 'index',
            'fields' => [
                'id',
                'name',
            ],
        ],
    ],
];

VardefManager::createVardef(
    'ProductTemplates',
    'ProductTemplate',
    [
        'default',
        'assignable',
        'currency',
        'team_security',
        'audit',
    ]
);
