<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['Opportunity'] = [
    'table' => 'opportunities',
    'color' => 'red',
    'icon' => 'sicon-opportunity-lg',
    'audited' => true,
    'escalatable' => true,
    'activity_enabled' => true,
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'duplicate_merge' => true,
    'comment' => 'An opportunity is the target of selling activities',
    'fields' => [
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_OPPORTUNITY_NAME',
            'type' => 'name',
            'dbType' => 'varchar',
            'len' => '255',
            'unified_search' => true,
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 1.65],
            'comment' => 'Name of the opportunity',
            'merge_filter' => 'selected',
            'importable' => 'required',
            'required' => true,
        ],
        'opportunity_type' => [
            'name' => 'opportunity_type',
            'vname' => 'LBL_TYPE',
            'type' => 'enum',
            'options' => 'opportunity_type_dom',
            'len' => '255',
            'audited' => true,
            'comment' => 'Type of opportunity (ex: Existing, New)',
            'merge_filter' => 'enabled',
        ],
        'account_name' => [
            'name' => 'account_name',
            'rname' => 'name',
            'id_name' => 'account_id',
            'vname' => 'LBL_ACCOUNT_NAME',
            'type' => 'relate',
            'table' => 'accounts',
            'join_name' => 'accounts',
            'isnull' => true,
            'module' => 'Accounts',
            'dbType' => 'varchar',
            'link' => 'accounts',
            'len' => '255',
            'source' => 'non-db',
            'unified_search' => true,
            'required' => true,
            'importable' => 'required',
            'related_fields' => [
                'account_id',
            ],
            'exportable' => true,
            'export_link_type' => 'one',//relationship type to be used during export
        ],
        'account_id' => [
            'name' => 'account_id',
            'vname' => 'LBL_ACCOUNT_ID',
            'id_name' => 'account_id',
            'type' => 'relate',
            'link' => 'accounts',
            'rname' => 'id',
            'source' => 'non-db',
            'audited' => true,
            'dbType' => 'id',
            'module' => 'Accounts',
            'massupdate' => false,
            'label' => 'LBL_ACCOUNT_NAME',
        ],
        'campaign_id' => [
            'name' => 'campaign_id',
            'comment' => 'Campaign that generated lead',
            'vname' => 'LBL_CAMPAIGN_ID',
            'rname' => 'id',
            'type' => 'id',
            'dbType' => 'id',
            'table' => 'campaigns',
            'isnull' => true,
            'module' => 'Campaigns',
            'reportable' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'campaign_name' => [
            'name' => 'campaign_name',
            'rname' => 'name',
            'id_name' => 'campaign_id',
            'vname' => 'LBL_CAMPAIGN',
            'type' => 'relate',
            'related_fields' => [
                'campaign_id',
            ],
            'link' => 'campaign_opportunities',
            'isnull' => true,
            'table' => 'campaigns',
            'module' => 'Campaigns',
            'source' => 'non-db',
            'studio' => [
                'mobile' => false,
            ],
        ],
        'campaign_opportunities' => [
            'name' => 'campaign_opportunities',
            'type' => 'link',
            'vname' => 'LBL_CAMPAIGN_OPPORTUNITY',
            'relationship' => 'campaign_opportunities',
            'source' => 'non-db',
        ],
        'lead_source' => [
            'name' => 'lead_source',
            'vname' => 'LBL_LEAD_SOURCE',
            'type' => 'enum',
            'options' => 'lead_source_dom',
            'len' => '50',
            'comment' => 'Source of the opportunity',
            'merge_filter' => 'enabled',
        ],
        'amount' => [
            'name' => 'amount',
            'vname' => 'LBL_LIKELY',
            'type' => 'currency',
            'dbType' => 'currency',
            'comment' => 'Unconverted amount of the opportunity',
            'importable' => 'required',
            'duplicate_merge' => '1',
            'required' => true,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'audited' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'convertToBase' => true,
            'showTransactionalAmount' => true,
        ],
        'amount_usdollar' => [
            'name' => 'amount_usdollar',
            'vname' => 'LBL_AMOUNT_USDOLLAR',
            'type' => 'currency',
            'group' => 'amount',
            'dbType' => 'currency',
            'disable_num_format' => true,
            'duplicate_merge' => '0',
            'comment' => 'Formatted amount of the opportunity',
            'studio' => [
                'wirelesslistview' => false,
                'wirelesseditview' => false,
                'wirelessdetailview' => false,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
                'editview' => false,
                'detailview' => false,
                'quickcreate' => false,
                'mobile' => false,
            ],
            'readonly' => true,
            'is_base_currency' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'formula' => 'ifElse(isNumeric($amount), currencyDivide($amount, $base_rate), "")',
            'calculated' => true,
            'enforced' => true,
        ],
        'date_closed' => [
            'name' => 'date_closed',
            'vname' => 'LBL_DATE_CLOSED',
            'type' => 'date',
            'comment' => 'Expected or actual date the oppportunity will close',
            'audited' => true,
            'importable' => 'required',
            'required' => true,
            'enable_range_search' => true,
            'options' => 'date_range_search_dom',
            'related_fields' => [
                'date_closed_timestamp',
            ],
            'full_text_search' => [
                'enabled' => true,
                'searchable' => false,
            ],
        ],
        'date_closed_timestamp' => [
            'name' => 'date_closed_timestamp',
            'vname' => 'LBL_DATE_CLOSED_TIMESTAMP',
            'type' => 'ulong',
            'studio' => [
                'formula' => true,
                'related' => true,
                'recordview' => false,
                'listview' => false,
                'detailview' => false,
                'searchview' => false,
                'createview' => false,
                'editField' => false,
            ],
            'reportable' => false,
            'workflow' => false,
            'massupdate' => false,
            'enforced' => true,
            'calculated' => true,
            'formula' => 'timestamp($date_closed)',
            'importable' => false,
        ],
        'next_step' => [
            'name' => 'next_step',
            'vname' => 'LBL_NEXT_STEP',
            'type' => 'varchar',
            'len' => '100',
            'full_text_search' => ['enabled' => true, 'searchable' => true, 'boost' => 0.74],
            'comment' => 'The next step in the sales process',
            'merge_filter' => 'enabled',
            'massupdate' => true,
        ],
        'sales_stage' => [
            'name' => 'sales_stage',
            'vname' => 'LBL_SALES_STAGE',
            'type' => 'enum',
            'options' => 'sales_stage_dom',
            'default' => 'Prospecting',
            'len' => '255',
            'comment' => 'Indication of progression towards closure',
            'merge_filter' => 'enabled',
            'importable' => 'required',
            'audited' => true,
            'required' => true,
        ],
        'sales_status' => [
            'name' => 'sales_status',
            'vname' => 'LBL_SALES_STATUS',
            'type' => 'enum',
            'options' => 'sales_status_dom',
            'len' => '255',
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
            'audited' => true,
            'reportable' => false,
            'massupdate' => false,
            'importable' => false,
            'default' => 'New',
        ],
        'probability' => [
            'name' => 'probability',
            'vname' => 'LBL_PROBABILITY',
            'type' => 'int',
            'dbType' => 'double',
            'audited' => true,
            'formula' => 'getDropdownValue("sales_probability_dom",$sales_stage)',
            'calculated' => true,
            'enforced' => true,
            'workflow' => false,
            'comment' => 'The probability of closure',
            'validation' => ['type' => 'range', 'min' => 0, 'max' => 100],
            'merge_filter' => 'enabled',
        ],
        'best_case' => [
            'name' => 'best_case',
            'vname' => 'LBL_BEST',
            'dbType' => 'currency',
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'convertToBase' => true,
            'showTransactionalAmount' => true,
        ],
        'worst_case' => [
            'name' => 'worst_case',
            'vname' => 'LBL_WORST',
            'dbType' => 'currency',
            'type' => 'currency',
            'len' => '26,6',
            'audited' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'convertToBase' => true,
            'showTransactionalAmount' => true,
        ],
        'commit_stage' => [
            'name' => 'commit_stage',
            'vname' => 'LBL_COMMIT_STAGE_FORECAST',
            'type' => 'enum',
            'len' => '50',
            'comment' => 'Forecast commit ranges: Include, Likely, Omit etc.',
            'function' => 'getCommitStageDropdown',
            'function_bean' => 'Forecasts',
            'formula' => 'forecastCommitStage($probability)',
            'calculated' => true,
            'related_fields' => [
                'probability',
                'closed_won_revenue_line_items',
            ],
        ],
        'forecasted_likely' => [
            'name' => 'forecasted_likely',
            'vname' => 'LBL_FORECASTED_LIKELY',
            'type' => 'currency',
            'dbType' => 'currency',
            'comment' => 'Rollup of included RLIs on the Opportunity',
            'readonly' => true,
            'massupdate' => false,
            'importable' => false,
            'duplicate_merge' => false,
            'required' => false,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'audited' => false,
            'formula' => 'rollupSum($revenuelineitems, "forecasted_likely")',
            'calculated' => true,
            'enforced' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'convertToBase' => true,
            'showTransactionalAmount' => true,
        ],
        'lost' => [
            'name' => 'lost',
            'vname' => 'LBL_LOST',
            'type' => 'currency',
            'dbType' => 'currency',
            'comment' => 'Rollup of lost RLIs on the Opportunity',
            'readonly' => true,
            'massupdate' => false,
            'importable' => false,
            'duplicate_merge' => false,
            'required' => false,
            'enable_range_search' => true,
            'audited' => false,
            'formula' => 'rollupConditionalSum($revenuelineitems, "likely_case", "sales_stage", forecastOnlySalesStages(false,true,false))',
            'calculated' => true,
            'enforced' => true,
            'related_fields' => [
                'currency_id',
                'base_rate',
            ],
            'convertToBase' => true,
            'showTransactionalAmount' => true,
        ],
        'commit_stage_cascade' => [
            'name' => 'commit_stage_cascade',
            'vname' => 'LBL_COMMIT_STAGE',
            'type' => 'varchar',
            'len' => '50',
            'source' => 'non-db',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'studio' => false,
            'importable' => false,
            'massupdate' => false,
        ],
        'closed_won_revenue_line_items' => [
            'name' => 'closed_won_revenue_line_items',
            'vname' => 'LBL_CLOSED_WON_RLIS',
            'type' => 'int',
            'formula' => 'countConditional($revenuelineitems, "sales_stage", forecastOnlySalesStages(true, false, false))',
            'calculated' => true,
            'enforced' => true,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
        ],
        'service_start_date' => [
            'name' => 'service_start_date',
            'vname' => 'LBL_SERVICE_START_DATE',
            'type' => 'date',
            'comment' => 'Service start date field.',
            'related_fields' => [
                'service_open_revenue_line_items',
            ],
            'studio' => [
                'calculated' => false,
            ],
        ],
        'service_open_revenue_line_items' => [
            'name' => 'service_open_revenue_line_items',
            'vname' => 'LBL_CLOSED_RLIS',
            'type' => 'int',
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
        ],
        'service_start_date_cascade' => [
            'name' => 'service_start_date_cascade',
            'type' => 'date',
            'source' => 'non-db',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'studio' => false,
            'importable' => false,
            'massupdate' => false,
        ],
        'total_revenue_line_items' => [
            'name' => 'total_revenue_line_items',
            'vname' => 'LBL_TOTAL_RLIS',
            'type' => 'int',
            'formula' => 'count($revenuelineitems)',
            'calculated' => true,
            'enforced' => true,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
        ],
        'closed_revenue_line_items' => [
            'name' => 'closed_revenue_line_items',
            'vname' => 'LBL_CLOSED_RLIS',
            'type' => 'int',
            'formula' => 'countConditional($revenuelineitems, "sales_stage", forecastOnlySalesStages(true, true, false))',
            'calculated' => true,
            'enforced' => true,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
        ],
        'included_revenue_line_items' => [
            'name' => 'included_revenue_line_items',
            'vname' => 'LBL_INCLUDED_RLIS',
            'type' => 'int',
            'formula' => 'countConditional($revenuelineitems,"commit_stage", forecastIncludedCommitStages())',
            'calculated' => true,
            'enforced' => true,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
        ],
        'renewal_opportunities' => [
            'name' => 'renewal_opportunities',
            'type' => 'link',
            'relationship' => 'renewals_opportunities',
            'module' => 'Opportunities',
            'bean_name' => 'Opportunity',
            'source' => 'non-db',
            'vname' => 'LBL_RENEWAL_OPPORTUNITIES',
            'side' => 'left',
        ],
        'renewal_parent' => [
            'name' => 'renewal_parent',
            'type' => 'link',
            'relationship' => 'renewals_opportunities',
            'module' => 'Opportunities',
            'bean_name' => 'Opportunity',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_RENEWAL_PARENT',
            'side' => 'right',
        ],
        'renewal_parent_id' => [
            'name' => 'renewal_parent_id',
            'vname' => 'LBL_PARENT_RENEWAL_OPPORTUNITY_ID',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'audited' => true,
        ],
        'renewal_parent_name' => [
            'name' => 'renewal_parent_name',
            'rname' => 'name',
            'id_name' => 'renewal_parent_id',
            'vname' => 'LBL_RENEWAL_PARENT',
            'type' => 'relate',
            'isnull' => 'true',
            'module' => 'Opportunities',
            'table' => 'opportunities',
            'massupdate' => false,
            'source' => 'non-db',
            'link' => 'renewal_parent',
            'unified_search' => true,
            'importable' => 'true',
        ],
        'widget_sales_stage' => [
            'name' => 'widget_sales_stage',
            'vname' => 'LBL_WIDGET_SALES_STAGE',
            'type' => 'widget',
            'multiline' => false,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
            'source' => 'non-db',
            'console' => [
                'name' => 'sales_stage',
                'label' => 'LBL_WIDGET_SALES_STAGE',
                'type' => 'fieldset-cascade',
                'show_child_labels' => false,
                'label' => 'LBL_WIDGET_SALES_STAGE',
                'fields' => [
                    [
                        'name' => 'sales_stage',
                        'label' => 'LBL_SALES_STAGE',
                        'type' => 'enum-colorcoded-fore-bkgd',
                    ],
                ],
                'disable_field' => [
                    'total_revenue_line_items',
                    'closed_revenue_line_items',
                ],
            ],
        ],
        'widget_date_closed' => [
            'name' => 'widget_date_closed',
            'vname' => 'LBL_WIDGET_DATE_CLOSED',
            'type' => 'widget',
            'multiline' => false,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
            'source' => 'non-db',
            'console' => [
                'name' => 'date_closed',
                'label' => 'LBL_WIDGET_DATE_CLOSED',
                'type' => 'relative-date',
            ],
        ],
        'widget_amount' => [
            'name' => 'widget_amount',
            'vname' => 'LBL_WIDGET_AMOUNT',
            'type' => 'widget',
            'multiline' => true,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
            'source' => 'non-db',
            'console' => [
                'name' => 'amount',
                'label' => 'LBL_WIDGET_AMOUNT',
                'type' => 'boxplot',
                'related_fields' => [
                    'best_case',
                    'worst_case',
                ],
            ],
        ],
        'sales_stage_cascade' => [
            'name' => 'sales_stage_cascade',
            'vname' => 'LBL_SALES_STAGE',
            'type' => 'enum',
            'options' => 'sales_stage_dom',
            'source' => 'non-db',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'studio' => false,
            'importable' => false,
            'massupdate' => false,
        ],
        'date_closed_cascade' => [
            'name' => 'date_closed_cascade',
            'type' => 'date',
            'source' => 'non-db',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'studio' => false,
            'importable' => false,
            'massupdate' => false,
        ],
        'external_users' => [
            'name' => 'external_users',
            'type' => 'link',
            'relationship' => 'external_users_opportunities',
            'module' => 'ExternalUsers',
            'bean_name' => 'ExternalUser',
            'source' => 'non-db',
            'vname' => 'LBL_EXTERNAL_USERS',
        ],
        'accounts' => [
            'name' => 'accounts',
            'type' => 'link',
            'relationship' => 'accounts_opportunities',
            'source' => 'non-db',
            'link_type' => 'one',
            'module' => 'Accounts',
            'bean_name' => 'Account',
            'vname' => 'LBL_ACCOUNTS',
        ],
        'contacts' => [
            'name' => 'contacts',
            'type' => 'link',
            'relationship' => 'opportunities_contacts',
            'source' => 'non-db',
            'module' => 'Contacts',
            'bean_name' => 'Contact',
            'rel_fields' => [
                'contact_role' => [
                    'type' => 'enum',
                    'options' => 'opportunity_relationship_type_dom',
                ],
            ],
            'vname' => 'LBL_CONTACTS',
            'populate_list' => [
                'account_id' => 'account_id',
                'account_name' => 'account_name',
            ],
        ],
        'contact_role' => [
            'name' => 'contact_role',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'massupdate' => false,
            'vname' => 'LBL_OPPORTUNITY_ROLE',
            'options' => 'opportunity_relationship_type_dom',
            'link' => 'contacts',
            'rname_link' => 'contact_role',
        ],
        'tasks' => [
            'name' => 'tasks',
            'type' => 'link',
            'relationship' => 'opportunity_tasks',
            'source' => 'non-db',
            'vname' => 'LBL_TASKS',
        ],
        'notes' => [
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'opportunity_notes',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'messages' => [
            'name' => 'messages',
            'type' => 'link',
            'relationship' => 'opportunity_messages',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'escalations' => [
            'name' => 'escalations',
            'type' => 'link',
            'relationship' => 'opportunity_escalations',
            'module' => 'Escalations',
            'bean_name' => 'Escalation',
            'source' => 'non-db',
            'vname' => 'LBL_ESCALATIONS',
        ],
        'meetings' => [
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'opportunity_meetings',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
        ],
        'calls' => [
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'opportunity_calls',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
        ],
        'emails' => [
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'emails_opportunities_rel', /* reldef in emails */
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
        ],
        'archived_emails' => [
            'name' => 'archived_emails',
            'type' => 'link',
            'link_class' => 'ArchivedEmailsBeanLink',
            'link' => 'contacts',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'module' => 'Emails',
            'link_type' => 'many',
            'relationship' => '',
            'hideacl' => true,
            'readonly' => true,
        ],
        'documents' => [
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_opportunities',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
        ],
        'quotes' => [
            'name' => 'quotes',
            'type' => 'link',
            'relationship' => 'quotes_opportunities',
            'source' => 'non-db',
            'vname' => 'LBL_QUOTES',
        ],

        'project' => [
            'name' => 'project',
            'type' => 'link',
            'relationship' => 'projects_opportunities',
            'source' => 'non-db',
            'vname' => 'LBL_PROJECTS',
        ],
        'leads' => [
            'name' => 'leads',
            'type' => 'link',
            'relationship' => 'opportunity_leads',
            'source' => 'non-db',
            'vname' => 'LBL_LEADS',
        ],
        'campaigns' => [
            'name' => 'campaigns',
            'type' => 'link',
            'relationship' => 'campaignlog_created_opportunities',
            'module' => 'CampaignLog',
            'bean_name' => 'CampaignLog',
            'source' => 'non-db',
            'vname' => 'LBL_CAMPAIGNS',
            'reportable' => false,
        ],
        'contracts' => [
            'name' => 'contracts',
            'type' => 'link',
            'vname' => 'LBL_CONTRACTS',
            'relationship' => 'contracts_opportunities',
            //'link_type' => 'one', bug# 31652 relationship is one to many from opportunities to contracts
            'source' => 'non-db',
            'populate_list' => [
                'account_id' => 'account_id',
                'account_name' => 'account_name',
            ],
        ],
        'revenuelineitems' => [
            'name' => 'revenuelineitems',
            'type' => 'link',
            'vname' => 'LBL_RLI',
            'relationship' => 'opportunities_revenuelineitems',
            'source' => 'non-db',
            'workflow' => false,
        ],
        'forecastworksheets' => [
            'name' => 'forecastworksheets',
            'type' => 'link',
            'relationship' => 'forecastworksheets_opportunities',
            'vname' => 'LBL_FORECAST_WORKSHEET',
            'module' => 'ForecastWorksheets',
            'bean_name' => 'ForecastWorksheet',
            'source' => 'non-db',
        ],
        'products' => [
            'name' => 'products',
            'type' => 'link',
            'vname' => 'LBL_PRODUCTS',
            'relationship' => 'opportunities_products',
            'source' => 'non-db',
        ],
        'ai_opp_conv_score_absolute' => [
            'name' => 'ai_opp_conv_score_absolute',
            'vname' => 'LBL_AI_CONV_SCORE_ABSOLUTE',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'ai_opp_conv_bin_accuracy' => [
            'name' => 'ai_opp_conv_bin_accuracy',
            'vname' => 'LBL_AI_CONV_BIN_ACCURACY',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'ai_opp_conv_multiplier' => [
            'name' => 'ai_opp_conv_multiplier',
            'vname' => 'LBL_AI_CONV_MULTIPLIER',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'purchasedlineitems' => [
            'name' => 'purchasedlineitems',
            'type' => 'link',
            'vname' => 'LBL_PURCHASED_LINE_ITEMS',
            'relationship' => 'purchasedlineitem_renewal_opp',
            'module' => 'PurchasedLineItems',
            'bean_name' => 'PurchasedLineItem',
            'source' => 'non-db',
        ],
        'service_duration_value' => [
            'name' => 'service_duration_value',
            'vname' => 'LBL_SERVICE_DURATION_VALUE',
            'type' => 'int',
            'min' => '1',
            'len' => '5',
            'required' => false,
            'studio' => false,
            'massupdate' => false,
            'importable' => false,
            'comment' => 'Value of the service duration, if service duration is 4 Months the value is 4',
        ],
        'service_duration_unit' => [
            'name' => 'service_duration_unit',
            'vname' => 'LBL_SERVICE_DURATION_UNIT',
            'type' => 'enum',
            'options' => 'service_duration_unit_dom',
            'len' => 50,
            'audited' => false,
            'studio' => false,
            'massupdate' => false,
            'importable' => false,
            'comment' => 'Service duration unit: day, month, or year',
        ],
        'service_duration_value_cascade' => [
            'name' => 'service_duration_value_cascade',
            'type' => 'int',
            'source' => 'non-db',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'studio' => false,
            'importable' => false,
            'massupdate' => false,
        ],
        'service_duration_unit_cascade' => [
            'name' => 'service_duration_unit_cascade',
            'vname' => 'LBL_SERVICE_DURATION_UNIT',
            'type' => 'enum',
            'options' => 'service_duration_unit_dom',
            'source' => 'non-db',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'studio' => false,
            'importable' => false,
            'massupdate' => false,
        ],
        'service_open_flex_duration_rlis' => [
            'name' => 'service_open_flex_duration_rlis',
            'vname' => 'LBL_SERVICE_OPEN_FLEX_DURATION_RLIS',
            'type' => 'int',
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
            'default' => 0,
        ],
        'geocode_status' => [
            'studio' => hasMapsLicense() ? [
                'editField' => true,
                'recordview' => true,
                'previewview' => false,
                'recorddashletview' => false,
                'listview' => false,
                'wirelesseditview' => false,
                'wirelesslistview' => false,
                'wirelessdetailview' => false,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ] : false,
            'name' => 'geocode_status',
            'vname' => 'LBL_MAPS_GEOCODE_STATUS',
            'label' => 'LBL_MAPS_GEOCODE_STATUS',
            'type' => 'geocodestatus',
            'len' => 255,
            'comment' => '',
            'dbType' => 'varchar',
            'licenseFilter' => ['MAPS'],
            'readonly' => true,
            'reportable' => false,
        ],

        // Marketo Fields
        'mkto_sync' => [
            'name' => 'mkto_sync',
            'vname' => 'LBL_MKTO_SYNC',
            'type' => 'bool',
            'default' => '0',
            'comment' => 'Should the Lead be synced to Marketo',
            'massupdate' => true,
            'audited' => true,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'true',
        ],
        'mkto_id' => [
            'name' => 'mkto_id',
            'vname' => 'LBL_MKTO_ID',
            'comment' => 'Associated Marketo Lead ID',
            'type' => 'int',
            'default' => null,
            'audited' => true,
            'mass_update' => false,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'false',
        ],
        'ai_opp_close_week_scores' => [
            'name' => 'ai_opp_close_week_scores',
            'vname' => 'LBL_AI_OPP_CLOSE_WEEK_SCORES',
            'type' => 'json',
            'dbType' => 'longtext',
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'renewal' => [
            'name' => 'renewal',
            'vname' => 'LBL_RENEWAL',
            'type' => 'bool',
            'default' => 0,
            'comment' => 'Indicates whether the opportunity is a renewal',
        ],
        'ai_opp_conv_score_enum' => [
            'name' => 'ai_opp_conv_score_enum',
            'vname' => 'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD',
            'type' => 'enum',
            'options' => 'ai_conv_score_classification_dropdown',
            'default_value' => '',
            'reportable' => true,
            'audited' => true,
            'importable' => false,
            'listview' => true,
            'readonly' => true,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
            'displayParams' => [
                'icon' => [
                    'type' => 'sicon-sugar-predict',
                    'tooltip' => 'LBL_PREDICT_TOOLTIP',
                ],
            ],
        ],
        'dri_workflows' => [
            'name' => 'dri_workflows',
            'vname' => 'LBL_DRI_WORKFLOWS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow',
            'relationship' => 'dri_workflow_opportunities',
            'module' => 'DRI_Workflows',
        ],
    ],
    'indices' => [
        [
            'name' => 'idx_opp_name',
            'type' => 'index',
            'fields' => [
                'deleted',
                'name',
                'date_modified',
            ],
        ],
        [
            'name' => 'idx_opportunity_next_step',
            'type' => 'index',
            'fields' => [
                'deleted',
                'next_step',
                'date_modified',
            ],
        ],
        [
            'name' => 'idx_opp_del_renewal_pid',
            'type' => 'index',
            'fields' => [
                'deleted',
                'renewal_parent_id',
                'id',
            ],
        ],
    ],
    'relationships' => [
        'opportunity_calls' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Opportunities',
        ],
        'opportunity_meetings' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Opportunities',
        ],
        'opportunity_tasks' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Opportunities',
        ],
        'opportunity_notes' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Opportunities',
        ],
        'opportunity_emails' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Emails',
            'rhs_table' => 'emails',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Opportunities',
        ],
        'opportunity_leads' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Leads',
            'rhs_table' => 'leads',
            'rhs_key' => 'opportunity_id',
            'relationship_type' => 'one-to-many',
        ],
        'opportunities_assigned_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Opportunities',
            'rhs_table' => 'opportunities',
            'rhs_key' => 'assigned_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'opportunities_modified_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Opportunities',
            'rhs_table' => 'opportunities',
            'rhs_key' => 'modified_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'opportunities_created_by' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Opportunities',
            'rhs_table' => 'opportunities',
            'rhs_key' => 'created_by',
            'relationship_type' => 'one-to-many',
        ],
        'opportunities_revenuelineitems' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'RevenueLineItems',
            'rhs_table' => 'revenue_line_items',
            'rhs_key' => 'opportunity_id',
            'relationship_type' => 'one-to-many',
        ],
        'opportunity_messages' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Messages',
            'rhs_table' => 'messages',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Opportunities',
        ],
        'renewals_opportunities' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Opportunities',
            'rhs_table' => 'opportunities',
            'rhs_key' => 'renewal_parent_id',
            'relationship_type' => 'one-to-many',
        ],
        'opportunity_escalations' => [
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'lhs_key' => 'id',
            'rhs_module' => 'Escalations',
            'rhs_table' => 'escalations',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Opportunities',
        ],
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$and' => [
                        ['name' => ['$starts' => '$name']],
                        ['sales_stage' => ['$not_equals' => 'Closed Lost']],
                        ['sales_stage' => ['$not_equals' => 'Closed Won']],
                        ['accounts.id' => ['$equals' => '$account_id']],
                    ],
                ],
            ],
            'ranking_fields' => [
                ['in_field_name' => 'name', 'dupe_field_name' => 'name'],
            ],
        ],
    ],
//This enables optimistic locking for Saves From EditView
    'optimistic_locking' => true,
];
VardefManager::createVardef(
    'Opportunities',
    'Opportunity',
    [
        'default',
        'assignable',
        'team_security',
        'currency',
        'audit',
        'escalatable',
        'customer_journey_parent',
    ]
);

$dictionary['Opportunity']['fields']['base_rate']['readonly'] = true;

//boost value for full text search
$dictionary['Opportunity']['fields']['description']['full_text_search']['boost'] = 0.59;
