<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['OAuthToken'] = [
    'table' => 'oauth_tokens',
    'favorites' => false,
    'comment' => 'OAuth tokens',
    'audited' => false,
    'fields' => [
        'id' => [
            'name' => 'id',
            'vname' => 'LBL_ID',
            'type' => 'id',
            'required' => true,
            'reportable' => true,
            'comment' => 'Unique identifier',
        ],
        'secret' => [
            'name' => 'secret',
            'type' => 'varchar',
            'len' => 32,
            'required' => true,
            'comment' => 'Secret key',
        ],
        'tstate' => [
            'name' => 'tstate',
            'type' => 'enum',
            'len' => 1,
            'options' => 'token_status',
            'required' => true,
            'comment' => 'Token state',

        ],
        'consumer' => [
            'name' => 'consumer',
            'type' => 'id',
            'required' => true,
            'comment' => 'Token related to the consumer',
        ],
        'token_ts' => [
            'name' => 'token_ts',
            'type' => 'long',
            'required' => true,
            'comment' => 'Token timestamp',
            'function' => ['name' => 'displayDateFromTs', 'returns' => 'html', 'onListView' => true],
        ],
        'expire_ts' => [
            'name' => 'expire_ts',
            'type' => 'long',
            'required' => true,
            'default' => -1,
            'comment' => 'Token expiration, defaults to -1 for no expiration date',
            'function' => ['name' => 'displayDateFromTs', 'returns' => 'html', 'onListView' => true],
        ],
        'verify' => [
            'name' => 'verify',
            'type' => 'varchar',
            'len' => 32,
            'comment' => 'Token verification info',
        ],
        'download_token' => [
            'name' => 'download_token',
            'type' => 'varchar',
            'len' => 36,
            'comment' => 'A token used to download images and files.',
        ],
        'platform' => [
            'name' => 'platform',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'Which platform is this token attached to',
            'default' => 'base',
        ],
        'deleted' => [
            'name' => 'deleted',
            'vname' => 'LBL_DELETED',
            'type' => 'bool',
            'default' => '0',
            'reportable' => false,
            'required' => true,
            'isnull' => false,
            'comment' => 'Record deletion indicator',
        ],
        'callback_url' => [
            'name' => 'callback_url',
            'type' => 'url',
            'len' => 255,
            'required' => false,
            'comment' => 'Callback URL for Authorization',
        ],
        'consumer_link' => [
            'name' => 'consumer_link',
            'type' => 'link',
            'relationship' => 'consumer_tokens',
            'vname' => 'LBL_CONSUMER',
            'link_type' => 'one',
            'module' => 'OAuthKeys',
            'bean_name' => 'OAuthKey',
            'source' => 'non-db',
        ],
        'consumer_name' => [
            'name' => 'consumer_name',
            'link' => 'consumer_link',
            'vname' => 'LBL_CONSUMER',
            'rname' => 'name',
            'type' => 'relate',
            'reportable' => false,
            'source' => 'non-db',
            'table' => 'oauth_consumer',
            'id_name' => 'consumer',
            'module' => 'OAuthKeys',
            'duplicate_merge' => 'disabled',
        ],
        'contact_id' =>
            [
                'name' => 'contact_id',
                'vname' => 'LBL_CONTACTS',
                'type' => 'id',
                'required' => false,
                'reportable' => false,
                'comment' => 'Contact ID this oauth token is associated with (via portal)',
            ],
        'contact_name' =>
            [
                'name' => 'contact_name',
                'rname' => 'name',
                'id_name' => 'contact_id',
                'vname' => 'LBL_CONTACTS',
                'table' => 'contacts',
                'type' => 'relate',
                'link' => 'contacts',
                'join_name' => 'contacts',
                'db_concat_fields' => [0 => 'first_name', 1 => 'last_name'],
                'isnull' => 'true',
                'module' => 'Contacts',
                'bean_name' => 'Contact',
                'source' => 'non-db',
            ],

        'assigned_user_id' => [
            'name' => 'assigned_user_id',
            'vname' => 'LBL_ASSIGNED_TO_ID',
            'group' => 'assigned_user_name',
            'type' => 'id',
            'reportable' => true,
            'isnull' => 'false',
            'audited' => true,
            'comment' => 'User ID assigned to record',
            'duplicate_merge' => 'disabled',
        ],
            'assigned_user_name' => [
            'name' => 'assigned_user_name',
            'link' => 'assigned_user_link',
            'vname' => 'LBL_ASSIGNED_TO_NAME',
            'rname' => 'user_name',
            'type' => 'relate',
            'reportable' => false,
            'source' => 'non-db',
            'table' => 'users',
            'id_name' => 'assigned_user_id',
            'module' => 'Users',
            'duplicate_merge' => 'disabled',
            'exportable' => true,
            ],
            'assigned_user_link' => [
            'name' => 'assigned_user_link',
            'type' => 'link',
            'relationship' => 'oauthtokens_assigned_user',
            'vname' => 'LBL_ASSIGNED_TO_USER',
            'link_type' => 'one',
            'module' => 'Users',
            'bean_name' => 'User',
            'source' => 'non-db',
            'duplicate_merge' => 'enabled',
            'rname' => 'user_name',
            'id_name' => 'assigned_user_id',
            'table' => 'users',
            ],
        'contacts' => [
            'name' => 'contacts',
            'type' => 'link',
            'relationship' => 'contacts_oauthtokens',
            'vname' => 'LBL_CONTACTS',
            'source' => 'non-db',
        ],

    ],
    'acls' => ['SugarACLOAuthTokens' => true],
    'indices' => [
        'id' => ['name' => 'oauthtokenpk', 'type' => 'primary', 'fields' => ['id', 'deleted']],
        'state_ts' => ['name' => 'oauth_state_ts', 'type' => 'index', 'fields' => ['tstate', 'token_ts']],
        'consumer' => ['name' => 'constoken_key', 'type' => 'index', 'fields' => ['consumer']],
        'platform_assigned_tstate' => [
            'name' => 'idx_platform_assigned_tstate',
            'type' => 'index',
            'fields' => [
                'platform',
                'assigned_user_id',
                'tstate',
            ],
        ],
        'expire_ts' => [
            'name' => 'idx_oauth_tstate_expire_ts',
            'type' => 'index',
            'fields' => [
                'tstate',
                'expire_ts',
            ],
        ],
    ],
    'relationships' => [
        'consumer_tokens' => ['lhs_module' => 'OAuthKeys', 'lhs_table' => 'oauth_consumer', 'lhs_key' => 'id',
            'rhs_module' => 'OAuthTokens', 'rhs_table' => 'oauth_tokens', 'rhs_key' => 'consumer',
            'relationship_type' => 'one-to-many'],
        'oauthtokens_assigned_user' => ['lhs_module' => 'Users', 'lhs_table' => 'users', 'lhs_key' => 'id',
            'rhs_module' => 'OAuthTokens', 'rhs_table' => 'oauth_tokens', 'rhs_key' => 'assigned_user_id',
            'relationship_type' => 'one-to-many'],
        'contacts_oauthtokens' => ['lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'OAuthTokens',
            'rhs_table' => 'oauth_tokens',
            'rhs_key' => 'contact_id',
            'relationship_type' => 'one-to-many'],

    ],
];
