<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['Lead'] = [
    'table' => 'leads',
    'color' => 'purple',
    'icon' => 'sicon-lead-lg',
    'audited' => true,
    'activity_enabled' => true,
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'duplicate_merge' => true,
    'comment' => 'Leads are persons of interest early in a sales cycle',
    'fields' => [


        'converted' => [
            'name' => 'converted',
            'vname' => 'LBL_CONVERTED',
            'type' => 'bool',
            'default' => '0',
            'comment' => 'Has Lead been converted to a Contact (and other Sugar objects)',
            'massupdate' => false,
            'studio' => false,
        ],
        'refered_by' => [
            'name' => 'refered_by',
            'vname' => 'LBL_REFERED_BY',
            'type' => 'varchar',
            'len' => '100',
            'comment' => 'Identifies who refered the lead',
            'merge_filter' => 'enabled',
        ],
        'lead_source' => [
            'name' => 'lead_source',
            'vname' => 'LBL_LEAD_SOURCE',
            'type' => 'enum',
            'options' => 'lead_source_dom',
            'len' => '100',
            'audited' => true,
            'comment' => 'Lead source (ex: Web, print)',
            'merge_filter' => 'enabled',
        ],
        'lead_source_description' => [
            'name' => 'lead_source_description',
            'vname' => 'LBL_LEAD_SOURCE_DESCRIPTION',
            'type' => 'text',
            'group' => 'lead_source',
            'comment' => 'Description of the lead source',
        ],
        'status' => [
            'name' => 'status',
            'vname' => 'LBL_STATUS',
            'type' => 'enum',
            'len' => '100',
            'options' => 'lead_status_dom',
            'default' => 'New',
            'audited' => true,
            'comment' => 'Status of the lead',
            'merge_filter' => 'enabled',
            //Fixme PAT-2241 will remove this when SugarLogic is supported in preview
            'previewEdit' => false,
        ],
        'status_description' => [
            'name' => 'status_description',
            'vname' => 'LBL_STATUS_DESCRIPTION',
            'type' => 'text',
            'group' => 'status',
            'comment' => 'Description of the status of the lead',
        ],
        'department' => [
            'name' => 'department',
            'vname' => 'LBL_DEPARTMENT',
            'type' => 'varchar',
            'len' => '100',
            'comment' => 'Department the lead belongs to',
            'merge_filter' => 'enabled',
        ],
        'reports_to_id' => [
            'name' => 'reports_to_id',
            'vname' => 'LBL_REPORTS_TO_ID',
            'type' => 'id',
            'reportable' => false,
            'comment' => 'ID of Contact the Lead reports to',
        ],
        'report_to_name' => [
            'name' => 'report_to_name',
            'rname' => 'name',
            'id_name' => 'reports_to_id',
            'vname' => 'LBL_REPORTS_TO',
            'type' => 'relate',
            'related_fields' => [
                'reports_to_id',
            ],
            'table' => 'contacts',
            'isnull' => 'true',
            'module' => 'Contacts',
            'dbType' => 'varchar',
            'len' => 'id',
            'source' => 'non-db',
            'reportable' => false,
            'massupdate' => false,
        ],
        'reports_to_link' => [
            'name' => 'reports_to_link',
            'type' => 'link',
            'relationship' => 'lead_direct_reports',
            'link_type' => 'one',
            'side' => 'right',
            'source' => 'non-db',
            'vname' => 'LBL_REPORTS_TO',
            'reportable' => false,
        ],
        'reportees' => [
            'name' => 'reportees',
            'type' => 'link',
            'relationship' => 'lead_direct_reports',
            'link_type' => 'many',
            'side' => 'left',
            'source' => 'non-db',
            'vname' => 'LBL_REPORTS_TO',
            'reportable' => false,
        ],
        'contacts' => [
            'name' => 'contacts',
            'type' => 'link',
            'relationship' => 'contact_leads',
            'module' => 'Contacts',
            'source' => 'non-db',
            'vname' => 'LBL_CONTACTS',
            'reportable' => false,
        ],
        'dataprivacy' => [
            'name' => 'dataprivacy',
            'type' => 'link',
            'relationship' => 'leads_dataprivacy',
            'source' => 'non-db',
            'vname' => 'LBL_DATAPRIVACY',
        ],
        'dp_business_purpose' => [
            'name' => 'dp_business_purpose',
            'vname' => 'LBL_DATAPRIVACY_BUSINESS_PURPOSE',
            'type' => 'multienum',
            'isMultiSelect' => true,
            'audited' => true,
            'options' => 'dataprivacy_business_purpose_dom',
            'default' => '',
            'len' => 255,
            'comment' => 'Business purposes consented for',
        ],
        'dp_consent_last_updated' => [
            'name' => 'dp_consent_last_updated',
            'vname' => 'LBL_DATAPRIVACY_CONSENT_LAST_UPDATED',
            'type' => 'date',
            'display_default' => 'now',
            'audited' => true,
            'enable_range_search' => true,
            'options' => 'date_range_search_dom',
            'comment' => 'Date consent last updated',
        ],
        //d&b principal id, a unique id assigned to a contact by D&B API
        //this contact is used for dupe check
        'dnb_principal_id' => [
            'name' => 'dnb_principal_id',
            'vname' => 'LBL_DNB_PRINCIPAL_ID',
            'type' => 'varchar',
            'len' => 30,
            'comment' => 'Unique Id For D&B Contact',
        ],
        'account_name' => [
            'name' => 'account_name',
            'vname' => 'LBL_ACCOUNT_NAME',
            'type' => 'varchar',
            'len' => '255',
            'unified_search' => true,
            'comment' => 'Account name for lead',
        ],
        'account_to_lead' => [
            'name' => 'account_to_lead',
            'rname' => 'name',
            'id_name' => 'account_id',
            'type' => 'relate',
            'related_fields' => [
                'account_id',
            ],
            'link' => 'accounts',
            'isnull' => 'true',
            'module' => 'Accounts',
            'source' => 'non-db',
            'unified_search' => false,
            'studio' => false,
            'massupdate' => false,
            'populate_list' => [
                'billing_address_street' => 'primary_address_street',
                'billing_address_city' => 'primary_address_city',
                'billing_address_state' => 'primary_address_state',
                'billing_address_postalcode' => 'primary_address_postalcode',
                'billing_address_country' => 'primary_address_country',
                'phone_office' => 'phone_work',
            ],
            'importable' => 'false',
        ],
        'accounts' => [
            'name' => 'accounts',
            'type' => 'link',
            'relationship' => 'account_leads',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_ACCOUNT',
            'duplicate_merge' => 'disabled',
        ],
        'account_description' => [
            'name' => 'account_description',
            'vname' => 'LBL_ACCOUNT_DESCRIPTION',
            'type' => 'text',
            'group' => 'account_name',
            'unified_search' => true,
            'comment' => 'Description of lead account',
        ],
        'contact_id' => [
            'name' => 'contact_id',
            'type' => 'id',
            'reportable' => false,
            'vname' => 'LBL_CONTACT_ID',
            'comment' => 'If converted, Contact ID resulting from the conversion',
        ],
        'contact' => [
            'name' => 'contact',
            'type' => 'link',
            'link_type' => 'one',
            'relationship' => 'contact_leads',
            'source' => 'non-db',
            'vname' => 'LBL_LEADS',
            'reportable' => false,
            'side' => 'right',
        ],
        'contact_name' => [
            'name' => 'contact_name',
            'rname' => 'name',
            'id_name' => 'contact_id',
            'vname' => 'LBL_CONTACT_NAME',
            'join_name' => 'contacts',
            'type' => 'relate',
            'related_fields' => [
                'contact_id',
            ],
            'link' => 'contacts',
            'table' => 'contacts',
            'isnull' => 'true',
            'module' => 'Contacts',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
            'unified_search' => false,
            'massupdate' => false,
        ],
        'account_id' => [
            'name' => 'account_id',
            'type' => 'id',
            'reportable' => false,
            'vname' => 'LBL_ACCOUNT_ID',
            'comment' => 'If converted, Account ID resulting from the conversion',
        ],
        'opportunity_id' => [
            'name' => 'opportunity_id',
            'type' => 'id',
            'reportable' => false,
            'vname' => 'LBL_OPPORTUNITY_ID',
            'comment' => 'If converted, Opportunity ID resulting from the conversion',
        ],
        'opportunity' => [
            'name' => 'opportunity',
            'type' => 'link',
            'link_type' => 'one',
            'relationship' => 'opportunity_leads',
            'source' => 'non-db',
            'vname' => 'LBL_OPPORTUNITIES',
        ],
        'converted_opp_name' => [
            'name' => 'converted_opp_name',
            'rname' => 'name',
            'id_name' => 'opportunity_id',
            'vname' => 'LBL_CONVERTED_OPPORTUNITY_NAME',
            'type' => 'relate',
            'related_fields' => [
                'opportunity_id',
            ],
            'link' => 'opportunity',
            'module' => 'Opportunities',
            'source' => 'non-db',
        ],
        'opportunity_name' => [
            'name' => 'opportunity_name',
            'vname' => 'LBL_OPPORTUNITY_NAME',
            'type' => 'varchar',
            'len' => '255',
            'comment' => 'Opportunity name associated with lead',
        ],
        'opportunity_amount' => [
            'name' => 'opportunity_amount',
            'vname' => 'LBL_OPPORTUNITY_AMOUNT',
            'type' => 'varchar',
            'group' => 'opportunity_name',
            'len' => '50',
            'comment' => 'Amount of the opportunity',
        ],
        'campaign_id' => [
            'name' => 'campaign_id',
            'type' => 'id',
            'reportable' => false,
            'vname' => 'LBL_CAMPAIGN_ID',
            'comment' => 'Campaign that generated lead',
        ],
        'campaign_name' => [
            'name' => 'campaign_name',
            'rname' => 'name',
            'id_name' => 'campaign_id',
            'vname' => 'LBL_CAMPAIGN',
            'type' => 'relate',
            'related_fields' => [
                'campaign_id',
            ],
            'link' => 'campaign_leads',
            'table' => 'campaigns',
            'isnull' => 'true',
            'module' => 'Campaigns',
            'source' => 'non-db',
            'additionalFields' => ['id' => 'campaign_id'],
            'massupdate' => false,
            'studio' => [
                'mobile' => false,
            ],
        ],
        'campaign_leads' => [
            'name' => 'campaign_leads',
            'type' => 'link',
            'vname' => 'LBL_CAMPAIGN_LEAD',
            'relationship' => 'campaign_leads',
            'source' => 'non-db',
        ],
        //Deprecated: Use rname_link instead
        'c_accept_status_fields' => [
            'name' => 'c_accept_status_fields',
            'rname' => 'id',
            'relationship_fields' => ['id' => 'accept_status_id', 'accept_status' => 'accept_status_name'],
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'type' => 'relate',
            'link' => 'calls',
            'link_type' => 'relationship_info',
            'source' => 'non-db',
            'importable' => 'false',
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        //Deprecated: Use rname_link instead
        'm_accept_status_fields' => [
            'name' => 'm_accept_status_fields',
            'rname' => 'id',
            'relationship_fields' => ['id' => 'accept_status_id', 'accept_status' => 'accept_status_name'],
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'type' => 'relate',
            'link' => 'meetings',
            'link_type' => 'relationship_info',
            'source' => 'non-db',
            'importable' => 'false',
            'hideacl' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        //Deprecated: Use rname_link instead
        'accept_status_id' => [
            'name' => 'accept_status_id',
            'type' => 'varchar',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'studio' => ['listview' => false],
        ],
        //Deprecated: Use rname_link instead
        'accept_status_name' => [
            'massupdate' => false,
            'name' => 'accept_status_name',
            'type' => 'enum',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
        ],
        'accept_status_calls' => [
            'massupdate' => false,
            'name' => 'accept_status_calls',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
            'link' => 'calls',
            'rname_link' => 'accept_status',
        ],
        'accept_status_meetings' => [
            'massupdate' => false,
            'name' => 'accept_status_meetings',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
            'link' => 'meetings',
            'rname_link' => 'accept_status',
        ],
        'accept_status_messages' => [
            'massupdate' => false,
            'name' => 'accept_status_messages',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
            'link' => 'meetings',
            'rname_link' => 'accept_status',
        ],
        'webtolead_email1' => [
            'name' => 'webtolead_email1',
            'vname' => 'LBL_EMAIL_ADDRESS',
            'type' => 'email',
            'len' => '100',
            'source' => 'non-db',
            'comment' => 'Main email address of lead',
            'importable' => 'false',
            'studio' => 'false',
        ],
        'webtolead_email2' => [
            'name' => 'webtolead_email2',
            'vname' => 'LBL_OTHER_EMAIL_ADDRESS',
            'type' => 'email',
            'len' => '100',
            'source' => 'non-db',
            'comment' => 'Secondary email address of lead',
            'importable' => 'false',
            'studio' => 'false',
        ],
        'webtolead_email_opt_out' => [
            'name' => 'webtolead_email_opt_out',
            'vname' => 'LBL_EMAIL_OPT_OUT',
            'type' => 'bool',
            'source' => 'non-db',
            'comment' => 'Indicator signaling if lead elects to opt out of email campaigns',
            'importable' => 'false',
            'massupdate' => false,
            'studio' => 'false',
        ],
        'webtolead_invalid_email' => [
            'name' => 'webtolead_invalid_email',
            'vname' => 'LBL_INVALID_EMAIL',
            'type' => 'bool',
            'source' => 'non-db',
            'comment' => 'Indicator that email address for lead is invalid',
            'importable' => 'false',
            'massupdate' => false,
            'studio' => 'false',
        ],
        'birthdate' => [
            'name' => 'birthdate',
            'vname' => 'LBL_BIRTHDATE',
            'massupdate' => false,
            'type' => 'date',
            'comment' => 'The birthdate of the contact',
            'audited' => true,
            'pii' => true,
        ],
        'portal_name' => [
            'name' => 'portal_name',
            'vname' => 'LBL_PORTAL_NAME',
            'type' => 'varchar',
            'len' => '255',
            'group' => 'portal',
            'group_label' => 'LBL_PORTAL',
            'comment' => 'Portal user name when lead created via lead portal',
            'studio' => true,
        ],
        'portal_app' => [
            'name' => 'portal_app',
            'vname' => 'LBL_PORTAL_APP',
            'type' => 'varchar',
            'group' => 'portal',
            'len' => '255',
            'comment' => 'Portal application that resulted in created of lead',
            'studio' => true,
        ],
        'business_center_name' => [
            'name' => 'business_center_name',
            'rname' => 'name',
            'id_name' => 'business_center_id',
            'vname' => 'LBL_BUSINESS_CENTER_NAME',
            'type' => 'relate',
            'link' => 'business_centers',
            'table' => 'business_centers',
            'join_name' => 'business_centers',
            'isnull' => 'true',
            'module' => 'BusinessCenters',
            'dbType' => 'varchar',
            'len' => 255,
            'source' => 'non-db',
            'unified_search' => true,
            'comment' => 'The name of the business center represented by the business_center_id field',
            'required' => false,
        ],
        'business_center_id' => [
            'name' => 'business_center_id',
            'type' => 'relate',
            'dbType' => 'id',
            'rname' => 'id',
            'module' => 'BusinessCenters',
            'id_name' => 'business_center_id',
            'reportable' => false,
            'vname' => 'LBL_BUSINESS_CENTER_ID',
            'audited' => true,
            'massupdate' => false,
            'comment' => 'The business center to which the case is associated',
        ],
        'business_centers' => [
            'name' => 'business_centers',
            'type' => 'link',
            'relationship' => 'business_center_leads',
            'link_type' => 'one',
            'side' => 'right',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER',
        ],
        'messages' => [
            'name' => 'messages',
            'type' => 'link',
            'relationship' => 'lead_messages',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'message_invites' => [
            'name' => 'message_invites',
            'type' => 'link',
            'relationship' => 'messages_leads',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'website' => [
            'name' => 'website',
            'vname' => 'LBL_WEBSITE',
            'type' => 'url',
            'dbType' => 'varchar',
            'len' => 255,
            'link_target' => '_blank',
            'comment' => 'URL of website for the company',
        ],
        'tasks' => [
            'name' => 'tasks',
            'type' => 'link',
            'relationship' => 'lead_tasks',
            'source' => 'non-db',
            'vname' => 'LBL_TASKS',
        ],
        'notes' => [
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'lead_notes',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'meetings' => [
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'meetings_leads',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
        ],
        'meetings_parent' => [
            'name' => 'meetings_parent',
            'type' => 'link',
            'relationship' => 'lead_meetings',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
            'reportable' => false,
        ],
        'calls' => [
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'calls_leads',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
        ],
        'calls_parent' => [
            'name' => 'calls_parent',
            'type' => 'link',
            'relationship' => 'lead_calls',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
            'reportable' => false,
        ],
        'emails' => [
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'emails_leads_rel',
            'source' => 'non-db',
            'unified_search' => true,
            'vname' => 'LBL_EMAILS',
        ],
        'archived_emails' => [
            'name' => 'archived_emails',
            'type' => 'link',
            'link_class' => 'ArchivedEmailsLink',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'module' => 'Emails',
            'link_type' => 'many',
            'relationship' => '',
            'hideacl' => true,
            'readonly' => true,
        ],
        'campaigns' => [
            'name' => 'campaigns',
            'type' => 'link',
            'relationship' => 'lead_campaign_log',
            'module' => 'CampaignLog',
            'bean_name' => 'CampaignLog',
            'source' => 'non-db',
            'vname' => 'LBL_CAMPAIGNLOG',
        ],
        'prospect_lists' => [
            'name' => 'prospect_lists',
            'type' => 'link',
            'relationship' => 'prospect_list_leads',
            'module' => 'ProspectLists',
            'source' => 'non-db',
            'vname' => 'LBL_PROSPECT_LIST',
        ],
        'prospect' => [
            'name' => 'prospect',
            'type' => 'link',
            'relationship' => 'lead_prospect',
            'module' => 'Prospects',
            'source' => 'non-db',
            'vname' => 'LBL_PROSPECT',
        ],
        'preferred_language' => [
            'name' => 'preferred_language',
            'type' => 'enum',
            'vname' => 'LBL_PREFERRED_LANGUAGE',
            'options' => 'available_language_dom',
        ],
        // Marketo Fields
        'mkto_sync' => [
            'name' => 'mkto_sync',
            'vname' => 'LBL_MKTO_SYNC',
            'type' => 'bool',
            'default' => '0',
            'comment' => 'Should the Lead be synced to Marketo',
            'massupdate' => true,
            'audited' => true,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'true',
        ],
        'mkto_id' => [
            'name' => 'mkto_id',
            'vname' => 'LBL_MKTO_ID',
            'comment' => 'Associated Marketo Lead ID',
            'type' => 'int',
            'default' => null,
            'audited' => true,
            'mass_update' => false,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'false',
        ],
        'mkto_lead_score' => [
            'name' => 'mkto_lead_score',
            'vname' => 'LBL_MKTO_LEAD_SCORE',
            'comment' => null,
            'type' => 'int',
            'default_value' => null,
            'audited' => true,
            'mass_update' => false,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'true',
        ],
        'ai_conv_score_classification' => [
            'name' => 'ai_conv_score_classification',
            'vname' => 'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD',
            'type' => 'enum',
            'options' => 'ai_conv_score_classification_dropdown',
            'default_value' => '',
            'reportable' => true,
            'audited' => true,
            'importable' => false,
            'listview' => true,
            'readonly' => true,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
            'displayParams' => [
                'icon' => [
                    'type' => 'sicon-sugar-predict',
                    'tooltip' => 'LBL_PREDICT_TOOLTIP',
                ],
            ],
        ],
        'ai_icp_fit_score_classification' => [
            'name' => 'ai_icp_fit_score_classification',
            'vname' => 'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD',
            'type' => 'enum',
            'options' => 'ai_icp_fit_score_classification_dropdown',
            'default_value' => '',
            'reportable' => true,
            'audited' => false,
            'importable' => false,
            'readonly' => true,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'market_interest_prediction_score' => [
            'name' => 'market_interest_prediction_score',
            'vname' => 'LBL_MARKET_INTEREST_PREDICTION',
            'type' => 'enum',
            'help' => 'Sugar Predict score',
            'options' => 'market_interest_prediction_dom',
            'default' => '',
            'readonly' => true,
            'massupdate' => false,
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => true,
            'duplicate_merge' => true,
        ],
        'market_score' => [
            'name' => 'market_score',
            'vname' => 'LBL_MARKET_SCORE',
            'type' => 'int',
            'help' => 'Score based on Market profiles',
            'readonly' => true,
            'massupdate' => false,
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => true,
            'duplicate_merge' => true,
            'enable_range_search' => true,
        ],
        'ai_conv_score_absolute' => [
            'name' => 'ai_conv_score_absolute',
            'vname' => 'LBL_AI_CONV_SCORE_ABSOLUTE',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'ai_conv_bin_accuracy' => [
            'name' => 'ai_conv_bin_accuracy',
            'vname' => 'LBL_AI_CONV_BIN_ACCURACY',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'ai_conv_multiplier' => [
            'name' => 'ai_conv_multiplier',
            'vname' => 'LBL_AI_CONV_MULTIPLIER',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'ai_icp_fit_score_absolute' => [
            'name' => 'ai_icp_fit_score_absolute',
            'vname' => 'LBL_AI_ICP_FIT_SCORE_ABSOLUTE',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'ai_icp_fit_bin_accuracy' => [
            'name' => 'ai_icp_fit_bin_accuracy',
            'vname' => 'LBL_AI_ICP_FIT_BIN_ACCURACY',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'ai_icp_fit_multiplier' => [
            'name' => 'ai_icp_fit_multiplier',
            'vname' => 'LBL_AI_ICP_FIT_MULTIPLIER',
            'type' => 'decimal',
            'len' => 10,
            'precision' => 8,
            'reportable' => true,
            'importable' => false,
            'readonly' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        'hint_account_size' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_size',
            'vname' => 'LBL_HINT_COMPANY_SIZE',
            'label' => 'LBL_HINT_COMPANY_SIZE',
            'type' => 'varchar',
            'len' => 20,
            'comment' => 'Company Size',
            'reportable' => false,
        ],
        'hint_account_industry' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_industry',
            'vname' => 'LBL_HINT_COMPANY_INDUSTRY',
            'label' => 'LBL_HINT_COMPANY_INDUSTRY',
            'type' => 'varchar',
            'len' => 120,
            'comment' => 'Company Industry',
            'reportable' => false,
        ],
        'hint_account_location' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_location',
            'vname' => 'LBL_HINT_COMPANY_LOCATION',
            'label' => 'LBL_HINT_COMPANY_LOCATION',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'Company Location',
            'reportable' => false,
        ],
        'hint_account_description' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_description',
            'vname' => 'LBL_HINT_COMPANY_DESCRIPTION',
            'label' => 'LBL_HINT_COMPANY_DESCRIPTION',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'Company Description',
            'reportable' => false,
        ],
        'hint_job_2' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_job_2',
            'vname' => 'LBL_HINT_JOB_2',
            'label' => 'LBL_HINT_JOB_2',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'Job 2',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_education' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_education',
            'vname' => 'LBL_HINT_EDUCATION',
            'label' => 'LBL_HINT_EDUCATION',
            'type' => 'varchar',
            'len' => 225,
            'comment' => 'Education',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_education_2' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_education_2',
            'vname' => 'LBL_HINT_EDUCATION_2',
            'label' => 'LBL_HINT_EDUCATION_2',
            'type' => 'varchar',
            'len' => 225,
            'comment' => 'Education 2',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_facebook' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_facebook',
            'type' => 'url',
            'vname' => 'LBL_HINT_FACEBOOK',
            'label' => 'LBL_HINT_FACEBOOK',
            'len' => 120,
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_twitter' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_twitter',
            'vname' => 'LBL_HINT_TWITTER',
            'label' => 'LBL_HINT_TWITTER',
            'type' => 'url',
            'len' => 120,
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_industry_tags' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_industry_tags',
            'vname' => 'LBL_HINT_COMPANY_INDUSTRY_TAGS',
            'label' => 'LBL_HINT_COMPANY_INDUSTRY_TAGS',
            'type' => 'varchar',
            'len' => 225,
            'comment' => 'industry tags',
            'reportable' => false,
        ],
        'hint_account_founded_year' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_founded_year',
            'vname' => 'LBL_HINT_COMPANY_FOUNDED_YEAR',
            'label' => 'LBL_HINT_COMPANY_FOUNDED_YEAR',
            'type' => 'varchar',
            'len' => 5,
            'comment' => 'company founded year',
            'reportable' => false,
        ],
        'hint_account_facebook_handle' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_facebook_handle',
            'vname' => 'LBL_HINT_COMPANY_FACEBOOK',
            'label' => 'LBL_HINT_COMPANY_FACEBOOK',
            'type' => 'url',
            'len' => 120,
            'comment' => 'company facebook',
            'reportable' => false,
        ],
        'hint_account_twitter_handle' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_twitter_handle',
            'vname' => 'LBL_HINT_COMPANY_TWITTER',
            'label' => 'LBL_HINT_COMPANY_TWITTER',
            'type' => 'url',
            'len' => 120,
            'comment' => 'company twitter',
            'reportable' => false,
        ],
        'hint_account_logo' => [
            'name' => 'hint_account_logo',
            'vname' => 'LBL_HINT_COMPANY_LOGO',
            'label' => 'LBL_HINT_COMPANY_LOGO',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'company logo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_contact_pic' => [
            'name' => 'hint_contact_pic',
            'vname' => 'LBL_HINT_CONTACT_PIC',
            'label' => 'LBL_HINT_CONTACT_PIC',
            'type' => 'text',
            'comment' => 'Hint Contact logo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_photo' => [
            'name' => 'hint_photo',
            'vname' => 'LBL_HINT_PHOTO',
            'label' => 'LBL_HINT_PHOTO',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'person photo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_phone_1' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_phone_1',
            'vname' => 'LBL_HINT_PHONE_1',
            'label' => 'LBL_HINT_PHONE_1',
            'type' => 'varchar',
            'len' => 15,
            'comment' => 'extra phone field',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_phone_2' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_phone_2',
            'vname' => 'LBL_HINT_PHONE_2',
            'label' => 'LBL_HINT_PHONE_2',
            'type' => 'varchar',
            'len' => 15,
            'comment' => 'extra phone field',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_account_naics_code_lbl' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_naics_code_lbl',
            'vname' => 'LBL_HINT_COMPANY_NAICS_CODE_LABEL',
            'label' => 'LBL_HINT_COMPANY_NAICS_CODE_LABEL',
            'type' => 'varchar',
            'len' => 170,
            'comment' => 'NAICS Code',
            'reportable' => false,
        ],
        'hint_account_sic_code_label' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_sic_code_label',
            'vname' => 'LBL_HINT_COMPANY_SIC_CODE_LABEL',
            'label' => 'LBL_HINT_COMPANY_SIC_CODE_LABEL',
            'type' => 'varchar',
            'len' => 120,
            'comment' => 'SIC Code',
            'reportable' => false,
        ],
        'hint_account_fiscal_year_end' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_fiscal_year_end',
            'vname' => 'LBL_HINT_COMPANY_FISCAL_YEAR_END',
            'label' => 'LBL_HINT_COMPANY_FISCAL_YEAR_END',
            'type' => 'varchar',
            'len' => 5,
            'comment' => 'FY End',
            'reportable' => false,
        ],
        'hint_account_annual_revenue' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_annual_revenue',
            'vname' => 'LBL_HINT_COMPANY_ANNUAL_REVENUE',
            'label' => 'LBL_HINT_COMPANY_ANNUAL_REVENUE',
            'type' => 'varchar',
            'len' => 25,
            'comment' => 'Annual Rev',
            'reportable' => false,
        ],
        'hint_account_website' => [
            'name' => 'hint_account_website',
            'vname' => 'LBL_HINT_COMPANY_WEBSITE',
            'label' => 'LBL_HINT_COMPANY_WEBSITE',
            'type' => 'url',
            'len' => 255,
            'comment' => 'company website',
            'studio' => false,
            'reportable' => false,
        ],
        'geocode_status' => [
            'studio' => hasMapsLicense() ? [
                'editField' => true,
                'recordview' => true,
                'previewview' => false,
                'recorddashletview' => false,
                'listview' => false,
                'wirelesseditview' => false,
                'wirelesslistview' => false,
                'wirelessdetailview' => false,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ] : false,
            'name' => 'geocode_status',
            'vname' => 'LBL_MAPS_GEOCODE_STATUS',
            'label' => 'LBL_MAPS_GEOCODE_STATUS',
            'type' => 'geocodestatus',
            'len' => 255,
            'comment' => '',
            'dbType' => 'varchar',
            'licenseFilter' => ['MAPS'],
            'readonly' => true,
            'reportable' => false,
        ],
        'dri_workflows' => [
            'name' => 'dri_workflows',
            'vname' => 'LBL_DRI_WORKFLOWS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow',
            'relationship' => 'dri_workflow_leads',
            'module' => 'DRI_Workflows',
        ],
    ],
    'indices' => [
        [
            'name' => 'idx_lead_acct_name_first',
            'type' => 'index',
            'fields' => [
                'deleted',
                'account_name',
                'date_modified',
                'id',
                'team_set_id',
            ],
        ],
        [
            'name' => 'idx_lead_idx_del_last_name',
            'type' => 'index',
            'fields' => [
                'deleted',
                'last_name',
            ],
        ],
        [
            'name' => 'idx_leads_status',
            'type' => 'index',
            'fields' => [
                'deleted',
                'status',
            ],
        ],
        ['name' => 'idx_lead_opp_del', 'type' => 'index',
            'fields' => [
                'deleted',
                'opportunity_id',
                'id',
            ],
        ],
        ['name' => 'idx_leads_acct_del', 'type' => 'index', 'fields' => ['account_id', 'deleted',]],
        ['name' => 'idx_lead_contact', 'type' => 'index', 'fields' => ['contact_id']],
        ['name' => 'idx_reports_to', 'type' => 'index',
            'fields' => [
                'deleted',
                'reports_to_id',
                'id',
            ],
        ],
        ['name' => 'idx_lead_phone_work', 'type' => 'index', 'fields' => ['phone_work']],
        ['name' => 'idx_lead_mkto_id', 'type' => 'index', 'fields' => ['mkto_id']],
        [
            'name' => 'idx_leads_del_businesscenter',
            'type' => 'index',
            'fields' => [
                'deleted',
                'business_center_id',
            ],
        ],
    ],
    'relationships' => [
        'lead_prospect' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Prospects',
            'rhs_table' => 'prospects',
            'rhs_key' => 'lead_id',
            'relationship_type' => 'one-to-one',
        ],
        'lead_direct_reports' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Leads',
            'rhs_table' => 'leads',
            'rhs_key' => 'reports_to_id',
            'relationship_type' => 'one-to-many',
        ],
        'lead_tasks' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Leads',
        ],
        'lead_notes' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Leads',
        ],
        'lead_messages' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Messages',
            'rhs_table' => 'messages',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Leads',
        ],
        'lead_meetings' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Leads',
        ],
        'lead_calls' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Leads',
        ],
        'lead_emails' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'Emails',
            'rhs_table' => 'emails',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Leads',
        ],
        'lead_campaign_log' => [
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'lhs_key' => 'id',
            'rhs_module' => 'CampaignLog',
            'rhs_table' => 'campaign_log',
            'rhs_key' => 'target_id',
            'relationship_type' => 'one-to-many',
        ],

    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$and' => [
                        [
                            '$or' => [
                                ['status' => ['$not_equals' => 'Converted']],
                                ['status' => ['$is_null' => '']],
                            ],
                        ],
                        [
                            '$or' => [
                                [
                                    '$and' => [
                                        ['account_name' => ['$starts' => '$account_name']],
                                        ['first_name' => ['$starts' => '$first_name']],
                                        ['last_name' => ['$starts' => '$last_name']],
                                        ['dnb_principal_id' => ['$equals' => '$dnb_principal_id']],
                                    ],
                                ],
                                ['phone_work' => ['$equals' => '$phone_work']],
                            ],
                        ],
                    ],
                ],
            ],
            'ranking_fields' => [
                ['in_field_name' => 'phone_work', 'dupe_field_name' => 'phone_work'],
                ['in_field_name' => 'account_name', 'dupe_field_name' => 'account_name'],
                ['in_field_name' => 'last_name', 'dupe_field_name' => 'last_name'],
                ['in_field_name' => 'first_name', 'dupe_field_name' => 'first_name'],
            ],
        ],
    ],
    //This enables optimistic locking for Saves From EditView
    'optimistic_locking' => true,
];

VardefManager::createVardef(
    'Leads',
    'Lead',
    [
        'default',
        'assignable',
        'team_security',
        'person',
        'audit',
        'customer_journey_parent',
    ]
);

//boost value for full text search
$dictionary['Lead']['fields']['first_name']['full_text_search']['boost'] = 1.87;
$dictionary['Lead']['fields']['last_name']['full_text_search']['boost'] = 1.85;
$dictionary['Lead']['fields']['email']['full_text_search']['boost'] = 1.83;
$dictionary['Lead']['fields']['phone_home']['full_text_search']['boost'] = 1.02;
$dictionary['Lead']['fields']['phone_mobile']['full_text_search']['boost'] = 1.01;
$dictionary['Lead']['fields']['phone_work']['full_text_search']['boost'] = 1.00;
$dictionary['Lead']['fields']['phone_other']['full_text_search']['boost'] = 0.99;
$dictionary['Lead']['fields']['phone_fax']['full_text_search']['boost'] = 0.98;
$dictionary['Lead']['fields']['description']['full_text_search']['boost'] = 0.70;
$dictionary['Lead']['fields']['primary_address_street']['full_text_search']['boost'] = 0.31;
$dictionary['Lead']['fields']['alt_address_street']['full_text_search']['boost'] = 0.30;

$dictionary['Lead']['fields']['dri_workflow_template_id']['duplicate_on_record_copy'] = 'no';
