<?php


/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
return [
    'metadata' => [
        'dashlets' => [
            [
                'width' => 6,
                'height' => 9,
                'x' => 0,
                'y' => 0,
                'id' => '33903c7c-bd12-41e7-afd1-bd9df931594b',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'My Open Opportunities',
                    'type' => 'dashablelist',
                    'module' => 'Opportunities',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 10,
                    'filter_id' => 'my_open_opportunities',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'amount',
                        'account_name',
                        'sales_stage',
                    ],
                ],
            ], [
                'width' => 6,
                'height' => 9,
                'x' => 6,
                'y' => 0,
                'id' => 'ca463efe-4021-4716-9ffe-7422cf96d779',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'My Leads',
                    'type' => 'dashablelist',
                    'module' => 'Leads',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 10,
                    'filter_id' => 'my_follow_up_leads',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'amount',
                        'account_name',
                        'sales_stage',
                        'phone_mobile',
                        'email',
                    ],
                ],
            ], [
                'width' => 4,
                'height' => 11,
                'x' => 0,
                'y' => 9,
                'id' => '2f3faf41-d402-444f-9579-9280b5b0c9c7',
                'autoPosition' => false,
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'My Pipeline',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'My Pipeline',
                    'reportId' => 'c197f334-b60a-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'db7e13cf-aab5-47b4-99b1-b27274308c68',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Current User',
                                ],
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'funnelF',
                    'groupDefs' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Sales Stage',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'My Pipeline',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Sales Stage',
                    'yAxisLabel' => 'SUM: Likely',
                    'showTitle' => true,
                    'showLegend' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 4,
                'height' => 11,
                'x' => 4,
                'y' => 9,
                'id' => 'fda6ebaa-e570-412f-acb0-a4490b8bd7b4',
                'autoPosition' => false,
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Sales Leaderboard YTD',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Sales Leaderboard',
                    'reportId' => 'b10c0d56-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '11c1c812-3cf6-4274-800b-1bc23dce9976',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Closed Won',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_year',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_year',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Sales Leaderboard',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'showValues' => 'end',
                    'showTitle' => true,
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'linkedFields' => '',
                    'link' => null,
                    'showLegend' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'config' => false,
                ],
            ], [
                'width' => 4,
                'height' => 11,
                'x' => 8,
                'y' => 9,
                'id' => '7a96c338-7097-4cdb-83d9-fd910a73fc98',
                'autoPosition' => false,
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Pipeline by Rep and Stage',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Pipeline by Rep and Stage',
                    'reportId' => '5e59f588-b60a-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '974e804a-b07e-4cee-a713-218cd1085e27',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_7',
                                'display_cols_row_7',
                                'display_cols_row_7',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                        ],
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Sales Stage',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Pipeline by Rep and Stage',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'sortColumnList' => 'likely_case',
                    'listOrderBy' => [
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'showLegend' => true,
                    'showTitle' => true,
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'linkedFields' => '',
                    'link' => null,
                    'config' => false,
                ],
            ], [
                'width' => 4,
                'height' => 10,
                'x' => 0,
                'y' => 20,
                'id' => '3a3a4d0b-036e-469d-abe1-b72675b7e4f5',
                'autoPosition' => false,
                'view' => [
                    'label' => 'Active Tasks',
                    'type' => 'active-tasks',
                    'template' => 'tabbed-dashlet',
                    'module' => null,
                    'limit' => 10,
                    'visibility' => 'user',
                    'last_state' => [
                        'id' => 'a23e0174-b54a-11ee-9d94-095590d26ca4:active-tasks',
                        'defaults' => [
                            'visibility' => 'user',
                        ],
                    ],
                ],
            ], [
                'width' => 4,
                'height' => 10,
                'x' => 4,
                'y' => 20,
                'id' => 'dca7f062-7378-4e9d-bbd3-90664cab7e4d',
                'autoPosition' => false,
                'view' => [
                    'label' => 'Planned Activities',
                    'type' => 'planned-activities',
                    'template' => 'tabbed-dashlet',
                    'module' => null,
                    'limit' => 10,
                    'visibility' => 'user',
                    'date' => 'future',
                    'last_state' => [
                        'id' => '6483f6a4-b54a-11ee-9d94-095590d26ca4:planned-activities',
                        'defaults' => [
                            'visibility' => 'group',
                        ],
                    ],
                ],
            ], [
                'width' => 4,
                'height' => 10,
                'x' => 8,
                'y' => 20,
                'id' => '431c50ab-0eb8-4f69-892c-7e9cbc3337fd',
                'autoPosition' => false,
                'content' => [
                    'module' => 'Home',
                ],
                'view' => [
                    'label' => 'Sugar Hint Insights',
                    'type' => 'hint-news-dashlet',
                    'module' => 'Home',
                    'limit' => 20,
                ],
            ],
        ],
        'filters' => [
            '0293795c-c224-479d-8e38-afcc8443f32a' => [
                'label' => 'Expected Close Date',
                'fieldType' => 'date',
                'fields' => [
                    [
                        'dashletId' => '2f3faf41-d402-444f-9579-9280b5b0c9c7',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'required' => true,
                            'type' => 'date',
                            'audited' => true,
                            'comment' => 'Expected or actual date the product (for opportunity) will close',
                            'importable' => 'required',
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => ['date_closed_timestamp'],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => true,
                        ],
                        'targetModule' => 'RevenueLineItems',
                        'tableKey' => 'self',
                        'dashletLabel' => 'My Pipeline',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => 'c197f334-b60a-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => 'fda6ebaa-e570-412f-acb0-a4490b8bd7b4',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'required' => true,
                            'type' => 'date',
                            'audited' => true,
                            'comment' => 'Expected or actual date the product (for opportunity) will close',
                            'importable' => 'required',
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => ['date_closed_timestamp'],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => true,
                        ],
                        'targetModule' => 'RevenueLineItems',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Sales Leaderboard YTD',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => 'b10c0d56-b60b-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => '7a96c338-7097-4cdb-83d9-fd910a73fc98',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'required' => true,
                            'type' => 'date',
                            'audited' => true,
                            'comment' => 'Expected or actual date the product (for opportunity) will close',
                            'importable' => 'required',
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => ['date_closed_timestamp'],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => true,
                        ],
                        'targetModule' => 'RevenueLineItems',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Pipeline by Rep and Stage',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => '5e59f588-b60a-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                ],
                'filterDef' => [
                    'qualifier_name' => 'not_empty',
                ],
                'fieldsDashlet' => [],
            ],
        ],
    ],
    'name' => 'LBL_SALES_REP_CONSOLE',
    'id' => '6483f6a4-b54a-11ee-9d94-095590d26ca4',
    'is_template' => true,
    'assigned_user_id' => '1',
];
