<?php


/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
return [
    'metadata' => [
        'dashlets' => [
            [
                'width' => 3,
                'height' => 9,
                'x' => 0,
                'y' => 0,
                'context' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'Today\'s New Leads',
                    'type' => 'dashablelist',
                    'module' => 'Leads',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 10,
                    'filter_id' => 'todays_leads',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'status',
                        'account_name',
                        'phone_mobile',
                        'phone_work',
                        'email',
                        'assigned_user_name',
                    ],
                ],
                'id' => 'ca463efe-4021-4716-9ffe-7422cf96d779',
            ], [
                'width' => 3,
                'height' => 9,
                'x' => 3,
                'y' => 0,
                'id' => 'ed698bdd-4e5d-43bb-b3e2-ba98d82d3d12',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Sales Pipeline',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Sales Pipeline',
                    'reportId' => '638702cc-b609-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'bd7ac25d-1907-46f0-8c17-356ed3ac0ddf',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'funnelF',
                    'groupDefs' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Sales Stage',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Sales Pipeline',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Sales Stage',
                    'yAxisLabel' => 'SUM: Likely',
                    'showLegend' => true,
                    'showTitle' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 3,
                'height' => 9,
                'x' => 6,
                'y' => 0,
                'id' => 'd1b19a2a-0221-4790-b364-0106cca010f1',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Pipeline by Month: Forecast Include/Exclude',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Pipeline by Month: Forecast Include/Exclude',
                    'reportId' => '8b5f5b6c-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'bcb6839b-343c-413a-befe-41becbdd65f1',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'commit_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'include',
                                    'exclude',
                                ],
                            ],
                            '3' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_9',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_9',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_9',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Month: Expected Close Date',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                            'type' => 'date',
                            'force_label' => 'Month: Expected Close Date',
                        ],
                        [
                            'name' => 'commit_stage',
                            'label' => 'Forecast Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Forecast Stage',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Month: Expected Close Date',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'commit_stage',
                            'label' => 'Forecast Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Pipeline by Month: Forecast Include/Exclude',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Month: Expected Close Date',
                    'yAxisLabel' => 'SUM: Likely',
                    'showLegend' => true,
                    'showValues' => 'top',
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 3,
                'height' => 9,
                'x' => 9,
                'y' => 0,
                'id' => 'fda6ebaa-e570-412f-acb0-a4490b8bd7b4',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Sales Leaderboard',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Sales Leaderboard',
                    'reportId' => 'b10c0d56-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '11c1c812-3cf6-4274-800b-1bc23dce9976',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Closed Won',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_year',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_year',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        'name' => 'user_name',
                        'label' => 'User Name',
                        'table_key' => 'RevenueLineItems:assigned_user_link',
                        'type' => 'username',
                        'force_label' => 'User Name',
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Sales Leaderboard',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'showValues' => 'end',
                    'showTitle' => true,
                    'linkedFields' => '',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'link' => null,
                    'config' => false,
                ],
            ], [
                'width' => 6,
                'height' => 8,
                'x' => 0,
                'y' => 9,
                'id' => 'd8b26454-ac0f-4476-b276-71e1e14cd019',
                'context' => [
                    'module' => 'pmse_Inbox',
                ],
                'view' => [
                    'label' => 'Quotes In Need of Approval',
                    'type' => 'dashlet-inbox',
                    'module' => 'pmse_Inbox',
                    'template' => 'tabbed-dashlet',
                    'limit' => 10,
                    'last_state' => [
                        'id' => 'a23e0174-b54a-11ee-9d94-095590d26ca4:dashlet-inbox',
                        'defaults' => [
                        ],
                    ],
                ],
            ], [
                'width' => 6,
                'height' => 8,
                'x' => 6,
                'y' => 9,
                'id' => '33903c7c-bd12-41e7-afd1-bd9df931594b',
                'context' => [
                    'module' => 'Opportunities',
                ],
                'link' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'My Open Opportunities',
                    'type' => 'dashablelist',
                    'module' => 'Opportunities',
                    'limit' => 5,
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'freeze_first_column' => 'true',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => '0',
                    'filter_id' => 'my_open_opportunities',
                    'display_columns' => [
                        'name',
                        'account_name',
                        'date_closed',
                        'sales_stage',
                        'amount',
                        'opportunity_type',
                        'assigned_user_name',
                        'team_name',
                        'lead_source',
                        'next_step',
                    ],
                ],
            ], [
                'width' => 4,
                'height' => 8,
                'x' => 0,
                'y' => 17,
                'id' => '7a96c338-7097-4cdb-83d9-fd910a73fc98',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Pipeline by Rep and Stage',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Pipeline by Rep and Stage',
                    'reportId' => '5e59f588-b60a-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '974e804a-b07e-4cee-a713-218cd1085e27',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Sales Stage',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items > Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items > Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items > Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_7',
                                'display_cols_row_7',
                                'display_cols_row_7',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Sales Stage',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'reportName' => 'Pipeline by Rep and Stage',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => true,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'showLegend' => true,
                    'showTitle' => true,
                    'linkedFields' => '',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'sortOrderList' => 'desc',
                    'sortColumnList' => 'likely_case',
                    'listOrderBy' => [
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'link' => null,
                    'primaryChartColumn' => 'self:likely_case:sum',
                    'secondaryChartColumn' => 'sales_stage',
                    'config' => false,
                ],
            ], [
                'width' => 4,
                'height' => 8,
                'x' => 4,
                'y' => 17,
                'id' => '3a3a4d0b-036e-469d-abe1-b72675b7e4f5',
                'view' => [
                    'label' => 'Active Tasks',
                    'type' => 'active-tasks',
                    'visibility' => 'user',
                    'template' => 'tabbed-dashlet',
                    'limit' => 10,
                    'last_state' => [
                        'id' => 'a23e0174-b54a-11ee-9d94-095590d26ca4:active-tasks',
                        'defaults' => [
                            'visibility' => 'user',
                        ],
                    ],
                ],
            ], [
                'width' => 4,
                'height' => 8,
                'x' => 8,
                'y' => 17,
                'id' => '061fa69b-806f-470c-903c-c3e33d4c78a6',
                'context' => [
                    'module' => 'Cases',
                ],
                'link' => [
                    'module' => 'Cases',
                ],
                'view' => [
                    'label' => 'Escalated Cases',
                    'type' => 'dashablelist',
                    'module' => 'Cases',
                    'limit' => 5,
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'freeze_first_column' => 'true',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => '0',
                    'filter_id' => 'escalated_cases',
                    'display_columns' => [
                        'is_escalated',
                        'case_number',
                        'name',
                        'account_name',
                        'primary_contact_name',
                        'service_level',
                        'priority',
                        'status',
                        'assigned_user_name',
                        'first_response_sla_met',
                        'follow_up_datetime',
                        'request_close_date',
                        'business_center_name',
                    ],
                ],
            ],
        ],
        'filters' => [
            "8c1f7995-0b31-4aee-b796-0211afde6d31" => [
                "label" => "Rep Name",
                "fieldType" => "username",
                "fields" => [
                    [
                        "dashletId" => "ed698bdd-4e5d-43bb-b3e2-ba98d82d3d12",
                        "fieldName" => "user_name",
                        "fieldDef" => [
                            "name" => "user_name",
                            "vname" => "LBL_USER_NAME",
                            "type" => "username",
                            "dbType" => "varchar",
                            "len" => 60,
                            "importable" => "required",
                            "required" => true,
                            "studio" => [
                                "no_duplicate" => true,
                                "editview" => false,
                                "detailview" => true,
                                "quickcreate" => false,
                                "basic_search" => false,
                                "advanced_search" => false,
                                "wirelesseditview" => false,
                                "wirelessdetailview" => true,
                                "wirelesslistview" => false,
                                "wireless_basic_search" => false,
                                "wireless_advanced_search" => false,
                                "rollup" => false,
                            ],
                            "idm_mode_disabled" => true,
                        ],
                        "targetModule" => "Users",
                        "tableKey" => "RevenueLineItems:assigned_user_link",
                        "dashletLabel" => "Sales Pipeline",
                        "isRelated" => true,
                        "dashletSpecificData" => [
                            "reportId" => "638702cc-b609-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                    [
                        "dashletId" => "d1b19a2a-0221-4790-b364-0106cca010f1",
                        "fieldName" => "user_name",
                        "fieldDef" => [
                            "name" => "user_name",
                            "vname" => "LBL_USER_NAME",
                            "type" => "username",
                            "dbType" => "varchar",
                            "len" => 60,
                            "importable" => "required",
                            "required" => true,
                            "studio" => [
                                "no_duplicate" => true,
                                "editview" => false,
                                "detailview" => true,
                                "quickcreate" => false,
                                "basic_search" => false,
                                "advanced_search" => false,
                                "wirelesseditview" => false,
                                "wirelessdetailview" => true,
                                "wirelesslistview" => false,
                                "wireless_basic_search" => false,
                                "wireless_advanced_search" => false,
                                "rollup" => false,
                            ],
                            "idm_mode_disabled" => true,
                        ],
                        "targetModule" => "Users",
                        "tableKey" => "RevenueLineItems:assigned_user_link",
                        "dashletLabel" => "Pipeline by Month: Forecast Include/Exclude",
                        "isRelated" => true,
                        "dashletSpecificData" => [
                            "reportId" => "8b5f5b6c-b60b-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                    [
                        "dashletId" => "fda6ebaa-e570-412f-acb0-a4490b8bd7b4",
                        "fieldName" => "user_name",
                        "fieldDef" => [
                            "name" => "user_name",
                            "vname" => "LBL_USER_NAME",
                            "type" => "username",
                            "dbType" => "varchar",
                            "len" => 60,
                            "importable" => "required",
                            "required" => true,
                            "studio" => [
                                "no_duplicate" => true,
                                "editview" => false,
                                "detailview" => true,
                                "quickcreate" => false,
                                "basic_search" => false,
                                "advanced_search" => false,
                                "wirelesseditview" => false,
                                "wirelessdetailview" => true,
                                "wirelesslistview" => false,
                                "wireless_basic_search" => false,
                                "wireless_advanced_search" => false,
                                "rollup" => false,
                            ],
                            "idm_mode_disabled" => true,
                        ],
                        "targetModule" => "Users",
                        "tableKey" => "RevenueLineItems:assigned_user_link",
                        "dashletLabel" => "Sales Leaderboard",
                        "isRelated" => true,
                        "dashletSpecificData" => [
                            "reportId" => "b10c0d56-b60b-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                    [
                        "dashletId" => "7a96c338-7097-4cdb-83d9-fd910a73fc98",
                        "fieldName" => "user_name",
                        "fieldDef" => [
                            "name" => "user_name",
                            "vname" => "LBL_USER_NAME",
                            "type" => "username",
                            "dbType" => "varchar",
                            "len" => 60,
                            "importable" => "required",
                            "required" => true,
                            "studio" => [
                                "no_duplicate" => true,
                                "editview" => false,
                                "detailview" => true,
                                "quickcreate" => false,
                                "basic_search" => false,
                                "advanced_search" => false,
                                "wirelesseditview" => false,
                                "wirelessdetailview" => true,
                                "wirelesslistview" => false,
                                "wireless_basic_search" => false,
                                "wireless_advanced_search" => false,
                                "rollup" => false,
                            ],
                            "idm_mode_disabled" => true,
                        ],
                        "targetModule" => "Users",
                        "tableKey" => "RevenueLineItems:assigned_user_link",
                        "dashletLabel" => "Pipeline by Rep and Stage",
                        "isRelated" => true,
                        "dashletSpecificData" => [
                            "reportId" => "5e59f588-b60a-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                ],
                "filterDef" => [
                    "qualifier_name" => "not_empty",
                ],
                "fieldsDashlet" => [],
            ],
            "159df442-3686-4451-a93b-1019bcb792d2" => [
                "label" => "Expected Close Date",
                "fieldType" => "date",
                "fields" => [
                    [
                        "dashletId" => "ed698bdd-4e5d-43bb-b3e2-ba98d82d3d12",
                        "fieldName" => "date_closed",
                        "fieldDef" => [
                            "name" => "date_closed",
                            "vname" => "LBL_DATE_CLOSED",
                            "required" => true,
                            "type" => "date",
                            "audited" => true,
                            "comment" => "Expected or actual date the product (for opportunity) will close",
                            "importable" => "required",
                            "enable_range_search" => true,
                            "options" => "date_range_search_dom",
                            "related_fields" => ["date_closed_timestamp"],
                            "full_text_search" => [
                                "enabled" => true,
                                "searchable" => false,
                            ],
                            "massupdate" => true,
                        ],
                        "targetModule" => "RevenueLineItems",
                        "tableKey" => "self",
                        "dashletLabel" => "Sales Pipeline",
                        "isRelated" => false,
                        "dashletSpecificData" => [
                            "reportId" => "638702cc-b609-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                    [
                        "dashletId" => "d1b19a2a-0221-4790-b364-0106cca010f1",
                        "fieldName" => "date_closed",
                        "fieldDef" => [
                            "name" => "date_closed",
                            "vname" => "LBL_DATE_CLOSED",
                            "required" => true,
                            "type" => "date",
                            "audited" => true,
                            "comment" => "Expected or actual date the product (for opportunity) will close",
                            "importable" => "required",
                            "enable_range_search" => true,
                            "options" => "date_range_search_dom",
                            "related_fields" => ["date_closed_timestamp"],
                            "full_text_search" => [
                                "enabled" => true,
                                "searchable" => false,
                            ],
                            "massupdate" => true,
                        ],
                        "targetModule" => "RevenueLineItems",
                        "tableKey" => "self",
                        "dashletLabel" => "Pipeline by Month: Forecast Include/Exclude",
                        "isRelated" => false,
                        "dashletSpecificData" => [
                            "reportId" => "8b5f5b6c-b60b-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                    [
                        "dashletId" => "fda6ebaa-e570-412f-acb0-a4490b8bd7b4",
                        "fieldName" => "date_closed",
                        "fieldDef" => [
                            "name" => "date_closed",
                            "vname" => "LBL_DATE_CLOSED",
                            "required" => true,
                            "type" => "date",
                            "audited" => true,
                            "comment" => "Expected or actual date the product (for opportunity) will close",
                            "importable" => "required",
                            "enable_range_search" => true,
                            "options" => "date_range_search_dom",
                            "related_fields" => ["date_closed_timestamp"],
                            "full_text_search" => [
                                "enabled" => true,
                                "searchable" => false,
                            ],
                            "massupdate" => true,
                        ],
                        "targetModule" => "RevenueLineItems",
                        "tableKey" => "self",
                        "dashletLabel" => "Sales Leaderboard",
                        "isRelated" => false,
                        "dashletSpecificData" => [
                            "reportId" => "b10c0d56-b60b-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                    [
                        "dashletId" => "7a96c338-7097-4cdb-83d9-fd910a73fc98",
                        "fieldName" => "date_closed",
                        "fieldDef" => [
                            "name" => "date_closed",
                            "vname" => "LBL_DATE_CLOSED",
                            "required" => true,
                            "type" => "date",
                            "audited" => true,
                            "comment" => "Expected or actual date the product (for opportunity) will close",
                            "importable" => "required",
                            "enable_range_search" => true,
                            "options" => "date_range_search_dom",
                            "related_fields" => ["date_closed_timestamp"],
                            "full_text_search" => [
                                "enabled" => true,
                                "searchable" => false,
                            ],
                            "massupdate" => true,
                        ],
                        "targetModule" => "RevenueLineItems",
                        "tableKey" => "self",
                        "dashletLabel" => "Pipeline by Rep and Stage",
                        "isRelated" => false,
                        "dashletSpecificData" => [
                            "reportId" => "5e59f588-b60a-11ee-9d94-095590d26ca4",
                            "currentUserRestrictedDashlet" => false,
                        ],
                    ],
                ],
                "filterDef" => [
                    "qualifier_name" => "not_empty",
                ],
                "fieldsDashlet" => [],
            ],
        ],
    ],
    'name' => 'LBL_SALES_MANAGER_CONSOLE',
    'id' => 'a23e0174-b54a-11ee-9d94-095590d26ca4',
    'is_template' => true,
    'assigned_user_id' => '1',
];
