<?php


/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
return [
    'metadata' => [
        'dashlets' => [
            [
                'width' => 4,
                'height' => 9,
                'x' => 0,
                'y' => 0,
                'id' => 'fcba8713-7e4e-45a1-a514-e407a94e6b20',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'link' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'New Leads This Quarter by Lead Source',
                    'type' => 'report-dashlet',
                    'module' => 'Leads',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'New Leads This Quarter by Lead Source',
                    'reportId' => '038bbe8e-b60a-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'c9f884ff-9034-4254-92f7-f1d48b40ba9f',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Lead Source',
                            'type' => 'enum',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'lead_source',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Cold Call',
                                    'Existing Customer',
                                    'Self Generated',
                                    'Employee',
                                    'Partner',
                                    'Public Relations',
                                    'Direct Mail',
                                    'Conference',
                                    'Trade Show',
                                    'Web Site',
                                    'Word of mouth',
                                    'Email',
                                    'Campaign',
                                    'Support Portal User Registration',
                                    'Other',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'Leads:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'New',
                                    'Assigned',
                                    'In Process',
                                    'Converted',
                                    'Recycled',
                                    'Dead',
                                ],
                            ],
                            '3' => [
                                'name' => 'date_entered',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_quarter',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_quarter',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'parent' => '',
                            'value' => 'Leads',
                            'module' => 'Leads',
                            'label' => 'Leads',
                            'children' => [
                                'self_link_0' => 'self_link_0',
                            ],
                        ],
                        'Leads:email_addresses_primary' => [
                            'name' => 'Leads  >  Email Address',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'email_addresses_primary',
                                'relationship_name' => 'leads_email_addresses_primary',
                                'bean_is_lhs' => true,
                                'link_type' => 'many',
                                'label' => 'Email Address',
                                'module' => 'EmailAddresses',
                                'table_key' => 'Leads:email_addresses_primary',
                            ],
                            'dependents' => [
                                'display_cols_row_9',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                            ],
                            'module' => 'EmailAddresses',
                            'label' => 'Email Address',
                        ],
                        'Leads:assigned_user_link' => [
                            'name' => 'Leads  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'leads_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Leads:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_10',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Leads: Lead Source',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Leads: Lead Source',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'account_name',
                            'label' => 'Account Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'title',
                            'label' => 'Title',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'account_name',
                            'label' => 'Account Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'phone_mobile',
                            'label' => 'Mobile',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'email_address',
                            'label' => 'Email Address',
                            'table_key' => 'Leads:email_addresses_primary',
                        ],
                        [
                            'name' => 'phone_work',
                            'label' => 'Office Phone',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Assigned To',
                            'table_key' => 'Leads:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Leads: Lead Source',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'New Leads This Quarter by Lead Source',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Lead Source',
                    'yAxisLabel' => 'Count',
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showValues' => 'top',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'link' => null,
                    'showTitle' => true,
                    'linkedFields' => '',
                    'config' => false,
                ],
            ], [
                'width' => 3,
                'height' => 9,
                'x' => 4,
                'y' => 0,
                'id' => 'b978edf1-e1bd-4381-a955-2e8d9604b4f7',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Opportunities',
                ],
                'link' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'Marketing Campaign ROI',
                    'type' => 'report-dashlet',
                    'module' => 'Opportunities',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Marketing Campaign ROI',
                    'reportId' => '126bc068-b60d-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '2216eada-5b2b-432a-8530-0cff1172b890',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_status',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Closed Won',
                                ],
                            ],
                            '1' => [
                                'name' => 'lead_source',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Campaign',
                                ],
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            '3' => [
                                'name' => 'user_name',
                                'table_key' => 'Opportunities:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Opportunities',
                            'module' => 'Opportunities',
                            'label' => 'Opportunities',
                            'dependents' => [],
                        ],
                        'Opportunities:accounts' => [
                            'name' => 'Opportunities  >  Accounts',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'accounts',
                                'relationship_name' => 'accounts_opportunities',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'Opportunities:accounts',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                        'Opportunities:assigned_user_link' => [
                            'name' => 'Opportunities  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'opportunities_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Opportunities:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_7',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_4',
                                'Filter.1_table_filter_row_4',
                                'display_cols_row_8',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'Opportunities:campaign_opportunities' => [
                            'name' => 'Opportunities  >  Campaign Opportunity',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'campaign_opportunities',
                                'relationship_name' => 'campaign_opportunities',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Campaign',
                                'module' => 'Campaigns',
                                'table_key' => 'Opportunities:campaign_opportunities',
                            ],
                            'dependents' => [
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'display_cols_row_10',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                            ],
                            'module' => 'Campaigns',
                            'label' => 'Campaign',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'name',
                            'label' => 'Name',
                            'table_key' => 'Opportunities:campaign_opportunities',
                            'type' => 'name',
                            'force_label' => 'Name',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Campaign Name',
                            'table_key' => 'Opportunities:campaign_opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'Opportunities:accounts',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'Revenue',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Rep Name',
                            'table_key' => 'Opportunities:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Name',
                            'table_key' => 'Opportunities:campaign_opportunities',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Marketing Campaign ROI',
                    'chartFunction' => 'self:amount:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'showTitle' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showValues' => 'end',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 5,
                'height' => 9,
                'x' => 7,
                'y' => 0,
                'id' => 'f4c79527-981f-45eb-a6eb-970ed29aec2a',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'link' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'MQL Leads by Period by Status',
                    'type' => 'report-dashlet',
                    'module' => 'Leads',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Marketing Campaign ROI',
                    'reportId' => '0ef7b53a-b60e-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '66e2ae70-a9af-4537-8109-59700693b81c',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'New',
                                    'Assigned',
                                    'In Process',
                                    'Converted',
                                    'Recycled',
                                    'Dead',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'Leads:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_entered',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_quarter',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_quarter',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Leads',
                            'module' => 'Leads',
                            'label' => 'Leads',
                            'dependents' => [],
                        ],
                        'Leads:email_addresses_primary' => [
                            'name' => 'Leads  >  Email Address',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'email_addresses_primary',
                                'relationship_name' => 'leads_email_addresses_primary',
                                'bean_is_lhs' => true,
                                'link_type' => 'many',
                                'label' => 'Email Address',
                                'module' => 'EmailAddresses',
                                'table_key' => 'Leads:email_addresses_primary',
                            ],
                            'dependents' => [
                                'display_cols_row_8',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'EmailAddresses',
                            'label' => 'Email Address',
                        ],
                        'Leads:assigned_user_link' => [
                            'name' => 'Leads  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'leads_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Leads:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_18',
                                'display_cols_row_13',
                                'display_cols_row_13',
                                'Filter.1_table_filter_row_2',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_13',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_13',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Status',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'title',
                            'label' => 'Title',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'account_name',
                            'label' => 'Account Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'email_address',
                            'label' => 'Email Address',
                            'table_key' => 'Leads:email_addresses_primary',
                        ],
                        [
                            'name' => 'phone_mobile',
                            'label' => 'Mobile',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'phone_work',
                            'label' => 'Office Phone',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'primary_address_street',
                            'label' => 'Primary Address Street',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'primary_address_city',
                            'label' => 'Primary Address City',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'primary_address_state',
                            'label' => 'Primary Address State',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'primary_address_postalcode',
                            'label' => 'Primary Address Postal Code',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Assigned To',
                            'table_key' => 'Leads:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'MQL Leads by Period by Status',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Status',
                    'yAxisLabel' => 'Count',
                    'showTitle' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showValues' => 'end',
                    'config' => false,
                    'linkedFields' => '',
                    'sortColumnList' => 'full_name',
                    'listOrderBy' => [
                        'name' => 'full_name',
                        'label' => 'Name',
                        'sort' => 'asc',
                        'table_key' => 'self',
                    ],
                ],
            ], [
                'width' => 4,
                'height' => 9,
                'x' => 0,
                'y' => 9,
                'id' => '71bce418-da7d-45a6-99cb-f35e64775516',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'link' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'SQL Leads This Month by Rep',
                    'type' => 'report-dashlet',
                    'module' => 'Leads',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'SQL Leads by Rep',
                    'reportId' => '56b54528-b60d-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '8ef801b5-afc2-4957-8efd-4f798e61a627',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'type' => 'username',
                            'table_key' => 'Leads:assigned_user_link',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Converted',
                                ],
                            ],
                            '1' => [
                                'name' => 'date_entered',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_month',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_month',
                            ],
                            '2' => [
                                'name' => 'user_name',
                                'table_key' => 'Leads:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Leads',
                            'module' => 'Leads',
                            'label' => 'Leads',
                        ],
                        'Leads:assigned_user_link' => [
                            'name' => 'Leads  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'leads_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Leads:assigned_user_link',
                            ],
                            'dependents' => [
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_8',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_11',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_11',
                                'Filter.1_table_filter_row_3',
                                'Filter.1_table_filter_row_3',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_11',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                            'optional' => true,
                        ],
                        'Leads:email_addresses_primary' => [
                            'name' => 'Leads  >  Email Address',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'email_addresses_primary',
                                'relationship_name' => 'leads_email_addresses_primary',
                                'bean_is_lhs' => true,
                                'link_type' => 'many',
                                'label' => 'Email Address',
                                'module' => 'EmailAddresses',
                                'table_key' => 'Leads:email_addresses_primary',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'EmailAddresses',
                            'label' => 'Email Address',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Leads:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'account_name',
                            'label' => 'Account Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'email_address',
                            'label' => 'Email Address',
                            'table_key' => 'Leads:email_addresses_primary',
                        ],
                        [
                            'name' => 'phone_mobile',
                            'label' => 'Mobile',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'phone_work',
                            'label' => 'Office Phone',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'primary_address_city',
                            'label' => 'Primary Address City',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'primary_address_state',
                            'label' => 'Primary Address State',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'primary_address_postalcode',
                            'label' => 'Primary Address Postal Code',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Assigned To',
                            'table_key' => 'Leads:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Leads:assigned_user_link',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'SQL Leads by Rep',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'Count',
                    'showValues' => 'top',
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showTitle' => true,
                    'linkedFields' => '',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'config' => false,
                ],
            ], [
                'width' => 4,
                'height' => 9,
                'x' => 4,
                'y' => 9,
                'id' => 'fdec5041-c71c-4592-b2fd-aaa3b60452ec',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'New Marketing Qualified Leads',
                    'type' => 'dashablelist',
                    'module' => 'Leads',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 5,
                    'filter_id' => 'new_mql_leads',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'status',
                        'mkto_lead_score',
                        'title',
                        'phone_mobile',
                        'phone_work',
                        'account_name',
                        'email',
                        'lead_source',
                        'assigned_user_name',
                        'primary_address_street',
                        'primary_address_city',
                        'primary_address_state',
                        'primary_address_postalcode',
                        'primary_address_country',
                        'campaign_name',
                    ],
                    'templateEdit' => 'edit',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'link' => null,
                ],
            ], [
                'width' => 4,
                'height' => 9,
                'x' => 8,
                'y' => 9,
                'id' => 'a145a69e-bec5-4da7-acd1-44cf710efcc5',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Home',
                ],
                'view' => [
                    'label' => 'Oktopost',
                    'url' => 'https://board.oktopost.com',
                    'type' => 'webpage',
                    'module' => 'Home',
                    'limit' => 3,
                    'templateEdit' => 'edit',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'link' => null,
                ],
            ],
        ],
        'filters' => [],
    ],
    'name' => 'LBL_MARKETING_CONSOLE',
    'id' => 'cf9dde82-b54a-11ee-9d94-095590d26ca4',
    'is_template' => true,
    'assigned_user_id' => '1',
];
