<?php


/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
return [
    'metadata' => [
        'dashlets' => [
            [
                'width' => 3,
                'height' => 9,
                'x' => 0,
                'y' => 0,
                'autoPosition' => false,
                'id' => '3ec81c79-6d10-4ddb-bd5b-fab6f6e0483e',
                'context' => [
                    'module' => 'Opportunities',
                ],
                'link' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'Total Sales by Quarter',
                    'type' => 'report-dashlet',
                    'module' => 'Opportunities',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Total Sales by Quarter',
                    'reportId' => 'e314b4ee-b60e-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '1847cd6c-2ae3-4f09-866b-494ee639f744',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_status',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'input_name0' => ['Closed Won'],
                            ],
                            '1' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_year',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_year',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'user_name',
                                'table_key' => 'Opportunities:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Opportunities',
                            'module' => 'Opportunities',
                            'label' => 'Opportunities',
                            'dependents' => [],
                        ],
                        'Opportunities:assigned_user_link' => [
                            'name' => 'Opportunities  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'opportunities_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Opportunities:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_3',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                    ],
                    'reportType' => 'Matrix',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Quarter: Expected Close Date',
                            'column_function' => 'quarter',
                            'qualifier' => 'quarter',
                            'table_key' => 'self',
                            'type' => 'date',
                            'force_label' => 'Quarter: Expected Close Date',
                        ],
                        [
                            'name' => 'opportunity_type',
                            'label' => 'Type',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Type',
                        ],
                    ],
                    'displayColumns' => [],
                    'summaryColumns' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Quarter: Expected Close Date',
                            'column_function' => 'quarter',
                            'qualifier' => 'quarter',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'opportunity_type',
                            'label' => 'Type',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Total Sales by Quarter',
                    'chartFunction' => 'self:amount:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Quarter: Expected Close Date',
                    'yAxisLabel' => 'SUM: Likely',
                    'showTotalRecordCount' => false,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showValues' => 'end',
                    'showTitle' => true,
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'showLegend' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 3,
                'height' => 9,
                'x' => 3,
                'y' => 0,
                'autoPosition' => false,
                'id' => 'f28e820e-6cd1-4d62-87bf-ecb0b56699a7',
                'context' => [
                    'module' => 'Opportunities',
                ],
                'link' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'Rep Win/Loss Ratio',
                    'type' => 'report-dashlet',
                    'module' => 'Opportunities',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Opps Closed Won v Lost by Rep',
                    'reportId' => '55a10bf6-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'cd8a22fc-92ba-4e20-8d95-11d60fd16e68',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_status',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => ['Closed Won', 'Closed Lost'],
                            ],
                            '1' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'user_name',
                                'table_key' => 'Opportunities:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Opportunities',
                            'module' => 'Opportunities',
                            'label' => 'Opportunities',
                        ],
                        'Opportunities:assigned_user_link' => [
                            'name' => 'Opportunities  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'opportunities_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Opportunities:assigned_user_link',
                            ],
                            'dependents' => [
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                                'Filter.1_table_filter_row_3',
                                'Filter.1_table_filter_row_3',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_4',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                            'optional' => true,
                        ],
                        'Opportunities:accounts' => [
                            'name' => 'Opportunities  >  Accounts',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'accounts',
                                'relationship_name' => 'accounts_opportunities',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'Opportunities:accounts',
                            ],
                            'dependents' => [
                                'display_cols_row_7',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Opportunities:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                        ],
                        [
                            'name' => 'sales_status',
                            'label' => 'Status',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Status',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Rep Name',
                            'table_key' => 'Opportunities:assigned_user_link',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'Opportunities:accounts',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Opportunities:assigned_user_link',
                        ],
                        [
                            'name' => 'sales_status',
                            'label' => 'Status',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Opps Closed Won v Lost by Rep',
                    'chartFunction' => 'self:amount:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'showTitle' => true,
                    'showLegend' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 3,
                'height' => 9,
                'x' => 6,
                'y' => 0,
                'autoPosition' => false,
                'id' => '66eb2636-e4da-4089-9830-cfdfc6199f4f',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Sales Leaderboard',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Sales Leaderboard',
                    'reportId' => 'b10c0d56-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '994d517c-a3a0-4f09-a4fa-259eee160aa2',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => ['Closed Won'],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_year',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_year',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Sales Leaderboard',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showTitle' => false,
                    'linkedFields' => '',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'link' => null,
                    'config' => false,
                ],
            ], [
                'width' => 3,
                'height' => 9,
                'x' => 9,
                'y' => 0,
                'autoPosition' => false,
                'id' => '20a2342b-671a-4efd-9fd7-19a664f6d930',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Revenue Year Over Year ',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Revenue Year Over Year ',
                    'reportId' => 'd9e6e668-b60d-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '4b825698-2260-421a-b47d-7885fa88c836',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => ['Closed Won'],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_3',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        '0' => [
                            'name' => 'date_closed',
                            'label' => 'Year: Expected Close Date',
                            'column_function' => 'year',
                            'qualifier' => 'year',
                            'table_key' => 'self',
                            'type' => 'date',
                            'force_label' => 'Year: Expected Close Date',
                        ],
                    ],
                    'displayColumns' => [
                        '0' => [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        '1' => [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        '2' => [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        '3' => [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        '4' => [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        '5' => [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        '0' => [
                            'name' => 'date_closed',
                            'label' => 'Year: Expected Close Date',
                            'column_function' => 'year',
                            'qualifier' => 'year',
                            'table_key' => 'self',
                        ],
                        '1' => [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Revenue Year Over Year',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Year: Close Date',
                    'yAxisLabel' => 'SUM: Amount',
                    'showValues' => 'top',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'showTitle' => true,
                    'link' => null,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showLegend' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 3,
                'height' => 11,
                'x' => 0,
                'y' => 9,
                'autoPosition' => false,
                'id' => 'aafcf46e-90c2-43be-a927-0a10011e6b9d',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Sales Pipeline',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Sales Pipeline',
                    'reportId' => '638702cc-b609-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '77fbe3cb-5838-403a-918d-d04f9ba632ec',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'funnelF',
                    'groupDefs' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Sales Stage',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Sales Pipeline',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Sales Stage',
                    'yAxisLabel' => 'SUM: Likely',
                    'showLegend' => true,
                    'showTitle' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 4,
                'height' => 11,
                'x' => 3,
                'y' => 9,
                'autoPosition' => false,
                'id' => 'c34ee73f-f84b-413f-aca2-9047285cc808',
                'context' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'Deals this Quarter',
                    'type' => 'dashablelist',
                    'module' => 'Opportunities',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 10,
                    'filter_id' => 'this_quarter_opportunities',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'amount',
                        'account_name',
                        'sales_stage',
                        'date_closed',
                        'assigned_user_name',
                        'team_name',
                    ],
                    'templateEdit' => 'edit',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'link' => null,
                ],
            ], [
                'width' => 5,
                'height' => 11,
                'x' => 7,
                'y' => 9,
                'autoPosition' => false,
                'id' => '7d3634dc-5c56-4c66-b5e6-ba4ba2ab3ed2',
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Pipeline by Month: Forecast Include/Exclude',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Pipeline by Month: Forecast Include/Exclude',
                    'reportId' => '8b5f5b6c-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'b0df305e-6c2a-4151-a1f9-2b87494366ca',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'commit_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => ['include', 'exclude'],
                            ],
                            '3' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items > Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_9',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_9',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items > Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items > Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Month: Expected Close Date',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                            'type' => 'date',
                            'force_label' => 'Month: Expected Close Date',
                        ],
                        [
                            'name' => 'commit_stage',
                            'label' => 'Forecast Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Forecast Stage',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Month: Expected Close Date',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'commit_stage',
                            'label' => 'Forecast Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Pipeline by Month: Forecast Include/Exclude',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Month: Expected Close Date',
                    'yAxisLabel' => 'SUM: Likely',
                    'showTitle' => true,
                    'showLegend' => true,
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'showValues' => 'end',
                    'link' => null,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 6,
                'height' => 8,
                'x' => 0,
                'y' => 20,
                'autoPosition' => false,
                'id' => 'b9ade46f-5409-4db8-887d-c209344380fd',
                'context' => [
                    'module' => 'Leads',
                ],
                'link' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'New Leads This Quarter by Lead Source',
                    'type' => 'report-dashlet',
                    'module' => 'Leads',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'New Leads This Quarter by Lead Source',
                    'reportId' => '038bbe8e-b60a-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '4efe7481-a46b-46c6-8e0b-ddbafa87b328',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Lead Source',
                            'type' => 'enum',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'lead_source',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Cold Call',
                                    'Existing Customer',
                                    'Self Generated',
                                    'Employee',
                                    'Partner',
                                    'Public Relations',
                                    'Direct Mail',
                                    'Conference',
                                    'Trade Show',
                                    'Web Site',
                                    'Word of mouth',
                                    'Email',
                                    'Campaign',
                                    'Support Portal User Registration',
                                    'Other',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'Leads:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'New',
                                    'Assigned',
                                    'In Process',
                                    'Converted',
                                    'Recycled',
                                    'Dead',
                                ],
                            ],
                            '3' => [
                                'name' => 'date_entered',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_quarter',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_quarter',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'parent' => '',
                            'value' => 'Leads',
                            'module' => 'Leads',
                            'label' => 'Leads',
                            'children' => [
                                'self_link_0' => 'self_link_0',
                            ],
                        ],
                        'Leads:email_addresses_primary' => [
                            'name' => 'Leads > Email Address',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'email_addresses_primary',
                                'relationship_name' => 'leads_email_addresses_primary',
                                'bean_is_lhs' => true,
                                'link_type' => 'many',
                                'label' => 'Email Address',
                                'module' => 'EmailAddresses',
                                'table_key' => 'Leads:email_addresses_primary',
                            ],
                            'dependents' => [
                                'display_cols_row_9',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                            ],
                            'module' => 'EmailAddresses',
                            'label' => 'Email Address',
                        ],
                        'Leads:assigned_user_link' => [
                            'name' => 'Leads > Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'leads_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Leads:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_10',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_10',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Leads: Lead Source',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Leads: Lead Source',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'account_name',
                            'label' => 'Account Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'title',
                            'label' => 'Title',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'account_name',
                            'label' => 'Account Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'phone_mobile',
                            'label' => 'Mobile',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'email_address',
                            'label' => 'Email Address',
                            'table_key' => 'Leads:email_addresses_primary',
                        ],
                        [
                            'name' => 'phone_work',
                            'label' => 'Office Phone',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Assigned To',
                            'table_key' => 'Leads:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Leads: Lead Source',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'New Leads This Quarter by Lead Source',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Lead Source',
                    'yAxisLabel' => 'Count',
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showTitle' => true,
                    'showValues' => 'top',
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 6,
                'height' => 8,
                'x' => 6,
                'y' => 20,
                'autoPosition' => false,
                'id' => '933b0783-09ff-4ae0-8b8e-545c495cfdec',
                'context' => [
                    'module' => 'Opportunities',
                ],
                'link' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'Marketing Campaign ROI',
                    'type' => 'report-dashlet',
                    'module' => 'Opportunities',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Marketing Campaign ROI',
                    'reportId' => '126bc068-b60d-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'b577ea75-1b97-4e43-8254-3a791badc622',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_status',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Closed Won',
                                ],
                            ],
                            '1' => [
                                'name' => 'lead_source',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Campaign',
                                ],
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            '3' => [
                                'name' => 'user_name',
                                'table_key' => 'Opportunities:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Opportunities',
                            'module' => 'Opportunities',
                            'label' => 'Opportunities',
                            'dependents' => [],
                        ],
                        'Opportunities:accounts' => [
                            'name' => 'Opportunities > Accounts',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'accounts',
                                'relationship_name' => 'accounts_opportunities',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'Opportunities:accounts',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                        'Opportunities:assigned_user_link' => [
                            'name' => 'Opportunities > Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'opportunities_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Opportunities:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_7',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_4',
                                'Filter.1_table_filter_row_4',
                                'display_cols_row_8',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'Opportunities:campaign_opportunities' => [
                            'name' => 'Opportunities > Campaign Opportunity',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'campaign_opportunities',
                                'relationship_name' => 'campaign_opportunities',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Campaign',
                                'module' => 'Campaigns',
                                'table_key' => 'Opportunities:campaign_opportunities',
                            ],
                            'dependents' => [
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'display_cols_row_10',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                            ],
                            'module' => 'Campaigns',
                            'label' => 'Campaign',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'name',
                            'label' => 'Name',
                            'table_key' => 'Opportunities:campaign_opportunities',
                            'type' => 'name',
                            'force_label' => 'Name',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Campaign Name',
                            'table_key' => 'Opportunities:campaign_opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'Opportunities:accounts',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'Revenue',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Rep Name',
                            'table_key' => 'Opportunities:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Name',
                            'table_key' => 'Opportunities:campaign_opportunities',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Marketing Campaign ROI',
                    'chartFunction' => 'self:amount:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Name',
                    'yAxisLabel' => 'SUM: Revenue',
                    'showTitle' => true,
                    'showLegend' => false,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'showValues' => 'top',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'link' => null,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 4,
                'height' => 7,
                'x' => 0,
                'y' => 28,
                'autoPosition' => false,
                'id' => '895f92f9-2614-4caf-9579-6d12c9de6a6d',
                'context' => [
                    'module' => 'Cases',
                ],
                'link' => [
                    'module' => 'Cases',
                ],
                'view' => [
                    'label' => 'New Cases Opened by Month',
                    'type' => 'report-dashlet',
                    'module' => 'Cases',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'New Cases Opened by Month',
                    'reportId' => 'f4b4c6be-b60c-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '1e7daff3-16c9-4d61-bc5f-a6361ff494a8',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'date_entered',
                            'label' => 'Month: Date Created',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                            'type' => 'date',
                            'force_label' => 'Month: Date Created',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'date_entered',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                                'runtime' => 1,
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Cases',
                            'module' => 'Cases',
                            'label' => 'Cases',
                            'dependents' => [],
                        ],
                        'Cases:accounts' => [
                            'name' => 'Cases > Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'accounts',
                                'relationship_name' => 'account_cases',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'Cases:accounts',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                        'Cases:assigned_user_link' => [
                            'name' => 'Cases > Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'cases_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Cases:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_8',
                                'display_cols_row_7',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'date_entered',
                            'label' => 'Month: Date Created',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                            'type' => 'date',
                            'force_label' => 'Month: Date Created',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Subject',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'Cases:accounts',
                        ],
                        [
                            'name' => 'date_entered',
                            'label' => 'Date Created',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Assigned To',
                            'table_key' => 'Cases:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'date_entered',
                            'label' => 'Month: Date Created',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'New Cases Opened by Month',
                    'chartFunction' => 'self:count',
                    'isBarChart' => true,
                    'primaryChartColumn' => 'date_entered',
                    'xAxisLabel' => 'Month: Date Created',
                    'yAxisLabel' => 'Count',
                    'sortColumnList' => 'name',
                    'listOrderBy' => [
                        [
                            'name' => 'name',
                            'label' => 'Subject',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'showValues' => 'top',
                    'showTitle' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'config' => false,
                ],
            ], [
                'width' => 4,
                'height' => 7,
                'x' => 4,
                'y' => 28,
                'autoPosition' => false,
                'id' => '86b9c338-4c46-4f32-92ab-975bd15a0c8c',
                'context' => [
                    'module' => 'Cases',
                ],
                'link' => [
                    'module' => 'Cases',
                ],
                'view' => [
                    'label' => 'Cases That Missed the First Response SLA',
                    'type' => 'report-dashlet',
                    'module' => 'Cases',
                    'limit' => 5,
                    'templateEdit' => 'edit',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'sortOrderList' => 'asc',
                    'intelligent' => false,
                    'reportId' => 'b70b8bb8-beae-11ee-9d94-095590d26ca4',
                    'saved_report' => 'Cases That Missed the First Response SLA',
                    'uniqueStateId' => 'e12bdcee-21e2-426f-b22f-657f6877f700',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'date_entered',
                            'label' => 'Day: Date Created',
                            'column_function' => 'day',
                            'qualifier' => 'day',
                            'table_key' => 'self',
                            'type' => 'datetime',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Cases:first_response_user_link',
                            'type' => 'username',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'date_entered',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_last_7_days',
                                'runtime' => 1,
                                'input_name0' => 'tp_last_7_days',
                                'input_name1' => 'on',
                            ],
                            '1' => [
                                'name' => 'first_response_sla_met',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'input_name0' => ['No'],
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => ['value' => 'Cases', 'module' => 'Cases', 'label' => 'Cases'],
                        'Cases:first_response_user_link' => [
                            'name' => 'Cases  >  First Response User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'first_response_user_link',
                                'relationship_name' => 'cases_first_response_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'First Response User',
                                'module' => 'Users',
                                'table_key' => 'Cases:first_response_user_link',
                            ],
                            'dependents' => [
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                            ],
                            'module' => 'Users',
                            'label' => 'First Response User',
                            'optional' => true,
                        ],
                    ],
                    'reportType' => 'Matrix',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'date_entered',
                            'label' => 'Day: Date Created',
                            'column_function' => 'day',
                            'qualifier' => 'day',
                            'table_key' => 'self',
                            'type' => 'datetime',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Cases:first_response_user_link',
                            'type' => 'username',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'displayColumns' => [],
                    'summaryColumns' => [
                        [
                            'name' => 'date_entered',
                            'label' => 'Day: Date Created',
                            'column_function' => 'day',
                            'qualifier' => 'day',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Cases:first_response_user_link',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Cases That Missed the First Response SLA',
                    'chartFunction' => 'self:count',
                    'isBarChart' => true,
                    'primaryChartColumn' => 'date_entered',
                    'secondaryChartColumn' => 'user_name',
                    'xAxisLabel' => 'Day: Date Created',
                    'yAxisLabel' => 'Count',
                    'showTotalRecordCount' => false,
                    'sortColumnList' => 'date_entered',
                    'listOrderBy' => [
                        [
                            'name' => 'date_entered',
                            'label' => 'Day: Date Created',
                            'column_function' => 'day',
                            'qualifier' => 'day',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                    ],
                ],
            ], [
                'width' => 4,
                'height' => 7,
                'x' => 8,
                'y' => 28,
                'autoPosition' => false,
                'id' => '9cef5484-b213-48bd-a8b9-008edc89c3f2',
                'context' => [
                    'module' => 'Cases',
                ],
                'link' => [
                    'module' => 'Cases',
                ],
                'view' => [
                    'label' => 'Closed Cases by Time to Resolution',
                    'type' => 'report-dashlet',
                    'module' => 'Cases',
                    'intelligent' => false,
                    'limit' => 5,
                    'saved_report' => 'Closed Cases by Time to Resolution',
                    'reportId' => 'fb59371c-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'a22b37be-9355-4c31-8180-6a8e5b0a798f',
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'hours_to_resolution',
                            'label' => 'AVG: Hours to Resolution',
                            'field_type' => 'decimal',
                            'group_function' => 'avg',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => ['Closed'],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'Cases:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Cases',
                            'module' => 'Cases',
                            'label' => 'Cases',
                        ],
                        'Cases:assigned_user_link' => [
                            'name' => 'Cases > Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'cases_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Cases:assigned_user_link',
                            ],
                            'dependents' => [
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'Filter.1_table_filter_row_2',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'Cases:accounts' => [
                            'name' => 'Cases > Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'accounts',
                                'relationship_name' => 'account_cases',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'Cases:accounts',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Cases:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Subject',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'Cases:accounts',
                        ],
                        [
                            'name' => 'date_entered',
                            'label' => 'Date Created',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'hours_to_resolution',
                            'label' => 'Hours to Resolution',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Cases:assigned_user_link',
                        ],
                        [
                            'name' => 'hours_to_resolution',
                            'label' => 'AVG: Hours to Resolution',
                            'field_type' => 'decimal',
                            'group_function' => 'avg',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'reportName' => 'Closed Cases by Time to Resolution',
                    'chartFunction' => 'self:hours_to_resolution:avg',
                    'isBarChart' => true,
                    'primaryChartColumn' => 'self:hours_to_resolution:avg',
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'AVG: Hours to Resolution',
                    'sortColumnList' => 'name',
                    'listOrderBy' => [
                        [
                            'name' => 'name',
                            'label' => 'Subject',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'showValues' => 'end',
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'config' => false,
                ],
            ],
        ],
        'filters' => [
            '0875165e-9899-4490-8fa8-1846fcbc3a9e' => [
                'label' => 'Sales Rep Name',
                'fieldType' => 'username',
                'fields' => [
                    [
                        'dashletId' => 'f28e820e-6cd1-4d62-87bf-ecb0b56699a7',
                        'fieldName' => 'user_name',
                        'fieldDef' => [
                            'name' => 'user_name',
                            'vname' => 'LBL_USER_NAME',
                            'type' => 'username',
                            'dbType' => 'varchar',
                            'len' => 60,
                            'importable' => 'required',
                            'required' => true,
                            'studio' => [
                                'no_duplicate' => true,
                                'editview' => false,
                                'detailview' => true,
                                'quickcreate' => false,
                                'basic_search' => false,
                                'advanced_search' => false,
                                'wirelesseditview' => false,
                                'wirelessdetailview' => true,
                                'wirelesslistview' => false,
                                'wireless_basic_search' => false,
                                'wireless_advanced_search' => false,
                                'rollup' => false,
                            ],
                            'idm_mode_disabled' => true,
                        ],
                        'targetModule' => 'Users',
                        'tableKey' => 'Opportunities:assigned_user_link',
                        'dashletLabel' => 'Rep Win/Loss Ratio',
                        'isRelated' => true,
                        'dashletSpecificData' => [
                            'reportId' => '55a10bf6-b60b-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => '66eb2636-e4da-4089-9830-cfdfc6199f4f',
                        'fieldName' => 'user_name',
                        'fieldDef' => [
                            'name' => 'user_name',
                            'vname' => 'LBL_USER_NAME',
                            'type' => 'username',
                            'dbType' => 'varchar',
                            'len' => 60,
                            'importable' => 'required',
                            'required' => true,
                            'studio' => [
                                'no_duplicate' => true,
                                'editview' => false,
                                'detailview' => true,
                                'quickcreate' => false,
                                'basic_search' => false,
                                'advanced_search' => false,
                                'wirelesseditview' => false,
                                'wirelessdetailview' => true,
                                'wirelesslistview' => false,
                                'wireless_basic_search' => false,
                                'wireless_advanced_search' => false,
                                'rollup' => false,
                            ],
                            'idm_mode_disabled' => true,
                        ],
                        'targetModule' => 'Users',
                        'tableKey' => 'RevenueLineItems:assigned_user_link',
                        'dashletLabel' => 'Sales Leaderboard',
                        'isRelated' => true,
                        'dashletSpecificData' => [
                            'reportId' => 'b10c0d56-b60b-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => '20a2342b-671a-4efd-9fd7-19a664f6d930',
                        'fieldName' => 'user_name',
                        'fieldDef' => [
                            'name' => 'user_name',
                            'vname' => 'LBL_USER_NAME',
                            'type' => 'username',
                            'dbType' => 'varchar',
                            'len' => 60,
                            'importable' => 'required',
                            'required' => true,
                            'studio' => [
                                'no_duplicate' => true,
                                'editview' => false,
                                'detailview' => true,
                                'quickcreate' => false,
                                'basic_search' => false,
                                'advanced_search' => false,
                                'wirelesseditview' => false,
                                'wirelessdetailview' => true,
                                'wirelesslistview' => false,
                                'wireless_basic_search' => false,
                                'wireless_advanced_search' => false,
                                'rollup' => false,
                            ],
                            'idm_mode_disabled' => true,
                        ],
                        'targetModule' => 'Users',
                        'tableKey' => 'RevenueLineItems:assigned_user_link',
                        'dashletLabel' => 'Revenue Year Over Year ',
                        'isRelated' => true,
                        'dashletSpecificData' => [
                            'reportId' => 'd9e6e668-b60d-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => 'aafcf46e-90c2-43be-a927-0a10011e6b9d',
                        'fieldName' => 'user_name',
                        'fieldDef' => [
                            'name' => 'user_name',
                            'vname' => 'LBL_USER_NAME',
                            'type' => 'username',
                            'dbType' => 'varchar',
                            'len' => 60,
                            'importable' => 'required',
                            'required' => true,
                            'studio' => [
                                'no_duplicate' => true,
                                'editview' => false,
                                'detailview' => true,
                                'quickcreate' => false,
                                'basic_search' => false,
                                'advanced_search' => false,
                                'wirelesseditview' => false,
                                'wirelessdetailview' => true,
                                'wirelesslistview' => false,
                                'wireless_basic_search' => false,
                                'wireless_advanced_search' => false,
                                'rollup' => false,
                            ],
                            'idm_mode_disabled' => true,
                        ],
                        'targetModule' => 'Users',
                        'tableKey' => 'RevenueLineItems:assigned_user_link',
                        'dashletLabel' => 'Sales Pipeline',
                        'isRelated' => true,
                        'dashletSpecificData' => [
                            'reportId' => '638702cc-b609-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => '7d3634dc-5c56-4c66-b5e6-ba4ba2ab3ed2',
                        'fieldName' => 'user_name',
                        'fieldDef' => [
                            'name' => 'user_name',
                            'vname' => 'LBL_USER_NAME',
                            'type' => 'username',
                            'dbType' => 'varchar',
                            'len' => 60,
                            'importable' => 'required',
                            'required' => true,
                            'studio' => [
                                'no_duplicate' => true,
                                'editview' => false,
                                'detailview' => true,
                                'quickcreate' => false,
                                'basic_search' => false,
                                'advanced_search' => false,
                                'wirelesseditview' => false,
                                'wirelessdetailview' => true,
                                'wirelesslistview' => false,
                                'wireless_basic_search' => false,
                                'wireless_advanced_search' => false,
                                'rollup' => false,
                            ],
                            'idm_mode_disabled' => true,
                        ],
                        'targetModule' => 'Users',
                        'tableKey' => 'RevenueLineItems:assigned_user_link',
                        'dashletLabel' => 'Pipeline by Month: Forecast Include/Exclude',
                        'isRelated' => true,
                        'dashletSpecificData' => [
                            'reportId' => '8b5f5b6c-b60b-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                ],
                'filterDef' => [
                    'qualifier_name' => 'not_empty',
                    'input_name0' => '',
                    'input_name1' => '',
                    'input_name2' => '',
                    'input_name3' => '',
                ],
                'fieldsDashlet' => [],
            ],
            'ba6612b1-5926-4b6e-9708-9bfb57683ac3' => [
                'label' => 'Close Date',
                'fieldType' => 'date',
                'fields' => [
                    [
                        'dashletId' => '3ec81c79-6d10-4ddb-bd5b-fab6f6e0483e',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'type' => 'date',
                            'comment' => 'Expected or actual date the opportunity will close',
                            'audited' => false,
                            'importable' => 'false',
                            'required' => false,
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => [],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => false,
                            'comments' => 'Expected or actual date the opportunity will close',
                            'duplicate_merge' => 'enabled',
                            'duplicate_merge_dom_value' => 1,
                            'merge_filter' => 'disabled',
                            'calculated' => false,
                            'hidemassupdate' => true,
                        ],
                        'targetModule' => 'Opportunities',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Total Sales by Quarter',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => 'e314b4ee-b60e-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => 'f28e820e-6cd1-4d62-87bf-ecb0b56699a7',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'type' => 'date',
                            'comment' => 'Expected or actual date the opportunity will close',
                            'audited' => false,
                            'importable' => 'false',
                            'required' => false,
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => [],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => false,
                            'comments' => 'Expected or actual date the opportunity will close',
                            'duplicate_merge' => 'enabled',
                            'duplicate_merge_dom_value' => 1,
                            'merge_filter' => 'disabled',
                            'calculated' => false,
                            'hidemassupdate' => true,
                        ],
                        'targetModule' => 'Opportunities',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Rep Win/Loss Ratio',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => '55a10bf6-b60b-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => '66eb2636-e4da-4089-9830-cfdfc6199f4f',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'required' => true,
                            'type' => 'date',
                            'audited' => true,
                            'comment' => 'Expected or actual date the product (for opportunity) will close',
                            'importable' => 'required',
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => [
                                'date_closed_timestamp',
                            ],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => true,
                        ],
                        'targetModule' => 'RevenueLineItems',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Sales Leaderboard',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => 'b10c0d56-b60b-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => '20a2342b-671a-4efd-9fd7-19a664f6d930',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'required' => true,
                            'type' => 'date',
                            'audited' => true,
                            'comment' => 'Expected or actual date the product (for opportunity) will close',
                            'importable' => 'required',
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => [
                                'date_closed_timestamp',
                            ],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => true,
                        ],
                        'targetModule' => 'RevenueLineItems',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Revenue Year Over Year ',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => 'd9e6e668-b60d-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => 'aafcf46e-90c2-43be-a927-0a10011e6b9d',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'required' => true,
                            'type' => 'date',
                            'audited' => true,
                            'comment' => 'Expected or actual date the product (for opportunity) will close',
                            'importable' => 'required',
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => [
                                'date_closed_timestamp',
                            ],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => true,
                        ],
                        'targetModule' => 'RevenueLineItems',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Sales Pipeline',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => '638702cc-b609-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                    [
                        'dashletId' => '7d3634dc-5c56-4c66-b5e6-ba4ba2ab3ed2',
                        'fieldName' => 'date_closed',
                        'fieldDef' => [
                            'name' => 'date_closed',
                            'vname' => 'LBL_DATE_CLOSED',
                            'required' => true,
                            'type' => 'date',
                            'audited' => true,
                            'comment' => 'Expected or actual date the product (for opportunity) will close',
                            'importable' => 'required',
                            'enable_range_search' => true,
                            'options' => 'date_range_search_dom',
                            'related_fields' => [
                                'date_closed_timestamp',
                            ],
                            'full_text_search' => [
                                'enabled' => true,
                                'searchable' => false,
                            ],
                            'massupdate' => true,
                        ],
                        'targetModule' => 'RevenueLineItems',
                        'tableKey' => 'self',
                        'dashletLabel' => 'Pipeline by Month: Forecast Include/Exclude',
                        'isRelated' => false,
                        'dashletSpecificData' => [
                            'reportId' => '8b5f5b6c-b60b-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                ],
                'filterDef' => [
                    'qualifier_name' => 'not_empty',
                ],
                'fieldsDashlet' => [],
            ],
        ],
    ],
    'name' => 'LBL_EXECUTIVE_CONSOLE',
    'id' => '1f821616-b54b-11ee-9d94-095590d26ca4',
    'is_template' => true,
    'assigned_user_id' => '1',
];
