<?php


/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
return [
    'metadata' => [
        'dashlets' => [
            [
                'width' => 6,
                'height' => 9,
                'x' => 0,
                'y' => 0,
                'id' => '33903c7c-bd12-41e7-afd1-bd9df931594b',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'My Open Existing Business Opportunities',
                    'type' => 'dashablelist',
                    'module' => 'Opportunities',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 10,
                    'filter_id' => 'my_open_existing_business',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'date_closed',
                        'sales_stage',
                        'amount',
                    ],
                ],
            ], [
                'width' => 6,
                'height' => 9,
                'x' => 6,
                'y' => 0,
                'id' => '7f53e09a-c718-419c-8389-c0c383ee75a9',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Accounts',
                ],
                'link' => [
                    'module' => 'Accounts',
                ],
                'view' => [
                    'label' => 'Tier 1-3 Customers',
                    'type' => 'report-dashlet',
                    'module' => 'Accounts',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Customers By Tier',
                    'reportId' => '87277fa4-b609-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'fce77777-bbc0-415b-af6f-0c5f21fa11e4',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'service_level',
                            'label' => 'Service Level',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Service Level',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'service_level',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'T1',
                                    'T2',
                                    'T3',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'Accounts:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Accounts',
                            'module' => 'Accounts',
                            'label' => 'Accounts',
                            'dependents' => [],
                        ],
                        'Accounts:assigned_user_link' => [
                            'name' => 'Accounts  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'accounts_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Accounts:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1.2_table_filter_row_4',
                                'Filter.1.2_table_filter_row_4',
                                'Filter.1.2_table_filter_row_4',
                                'Filter.1_table_filter_row_5',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                    ],
                    'reportType' => 'summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'service_level',
                            'label' => 'Service Level',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Service Level',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'displayColumns' => [],
                    'summaryColumns' => [
                        [
                            'name' => 'service_level',
                            'label' => 'Service Level',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Customers By Tier',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Service Level',
                    'yAxisLabel' => 'Count',
                    'skipFetch' => true,
                    'link' => null,
                    'showValues' => 'middle',
                    'config' => false,
                    'linkedFields' => '',
                    'sortOrderList' => 'asc',
                    'sortColumnList' => 'service_level',
                    'listOrderBy' => [
                        [
                            'name' => 'service_level',
                            'label' => 'Service Level',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'primaryChartColumn' => 'service_level',
                ],
            ], [
                'width' => 3,
                'height' => 10,
                'x' => 0,
                'y' => 9,
                'id' => '3a3a4d0b-036e-469d-abe1-b72675b7e4f5',
                'autoPosition' => false,
                'view' => [
                    'label' => 'My Tasks',
                    'type' => 'active-tasks',
                    'template' => 'tabbed-dashlet',
                    'module' => null,
                    'templateEdit' => 'edit',
                    'last_state' => [
                        'id' => 'a23e0174-b54a-11ee-9d94-095590d26ca4:active-tasks',
                        'defaults' => [
                            'visibility' => 'user',
                        ],
                    ],
                ],
            ], [
                'width' => 5,
                'height' => 10,
                'x' => 3,
                'y' => 9,
                'id' => 'b058e62f-6bc0-4a1a-bea2-cb1749bbd672',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Cases',
                ],
                'link' => [
                    'module' => 'Cases',
                ],
                'view' => [
                    'label' => 'Open Cases for My Customers',
                    'type' => 'report-dashlet',
                    'module' => 'Cases',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'sortOrderList' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Open Cases for My Customers',
                    'reportId' => '929e70ea-b60e-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '2695015a-58fd-4674-b8fc-b1d57bc4387f',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'name',
                            'label' => 'Name',
                            'table_key' => 'Cases:accounts',
                            'type' => 'name',
                            'force_label' => 'Name',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'user_name',
                                'table_key' => 'Cases:accounts:assigned_user_link',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Current User',
                                ],
                            ],
                            '1' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_one_of',
                                'input_name0' => [
                                    'Closed',
                                    'Rejected',
                                    'Duplicate',
                                ],
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Cases',
                            'module' => 'Cases',
                            'label' => 'Cases',
                        ],
                        'Cases:accounts' => [
                            'name' => 'Cases  >  Account ',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'accounts',
                                'relationship_name' => 'account_cases',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'Cases:accounts',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                        'Cases:accounts:assigned_user_link' => [
                            'name' => 'Cases  >  Account  >  Assigned to User',
                            'parent' => 'Cases:accounts',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'accounts_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Cases:accounts:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_1',
                                'Filter.1_table_filter_row_1',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'groupDefs' => [
                        [
                            'name' => 'name',
                            'label' => 'Name',
                            'table_key' => 'Cases:accounts',
                            'type' => 'name',
                            'force_label' => 'Name',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'case_number',
                            'label' => 'Number',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Subject',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account',
                            'table_key' => 'Cases:accounts',
                        ],
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Name',
                            'table_key' => 'Cases:accounts',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Open Cases for My Customers',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'sortColumnList' => 'case_number',
                    'listOrderBy' => [
                        [
                            'name' => 'case_number',
                            'label' => 'Number',
                            'table_key' => 'self',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'primaryChartColumn' => 'name',
                    'xAxisLabel' => 'Name',
                    'yAxisLabel' => 'Count',
                    'config' => false,

                ],
            ], [
                'width' => 4,
                'height' => 10,
                'x' => 8,
                'y' => 9,
                'id' => '2f3faf41-d402-444f-9579-9280b5b0c9c7',
                'autoPosition' => false,
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'My Pipeline',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'My Pipeline Funnel (Revenue Line Items)',
                    'reportId' => 'c197f334-b60a-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'db7e13cf-aab5-47b4-99b1-b27274308c68',
                    'chartPrimaryOrderBy' => [],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Prospecting',
                                    'Qualification',
                                    'Needs Analysis',
                                    'Value Proposition',
                                    'Id. Decision Makers',
                                    'Perception Analysis',
                                    'Proposal/Price Quote',
                                    'Negotiation/Review',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => ['Current User'],
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'funnelF',
                    'groupDefs' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Sales Stage',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Expected Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'sales_stage',
                            'label' => 'Sales Stage',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'My Pipeline',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Sales Stage',
                    'yAxisLabel' => 'SUM: Likely',
                    'showTitle' => true,
                    'showLegend' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 8,
                'height' => 9,
                'x' => 0,
                'y' => 19,
                'id' => '7a96c338-7097-4cdb-83d9-fd910a73fc98',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Opportunities',
                ],
                'link' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'New Sales by Month',
                    'type' => 'report-dashlet',
                    'module' => 'Opportunities',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'New Sales by Month',
                    'reportId' => '72b638a6-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '974e804a-b07e-4cee-a713-218cd1085e27',
                    'chartPrimaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_current_fiscal_year',
                                'runtime' => 1,
                                'input_name0' => 'tp_current_fiscal_year',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Opportunities',
                            'module' => 'Opportunities',
                            'label' => 'Opportunities',
                            'dependents' => [],
                        ],
                    ],
                    'reportType' => 'summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Month: Expected Close Date',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                            'type' => 'date',
                            'force_label' => 'Month: Expected Close Date',
                        ],
                    ],
                    'displayColumns' => [],
                    'summaryColumns' => [
                        [
                            'name' => 'date_closed',
                            'label' => 'Month: Expected Close Date',
                            'column_function' => 'month',
                            'qualifier' => 'month',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'New Sales by Month',
                    'chartFunction' => 'self:amount:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Month: Expected Close Date',
                    'yAxisLabel' => 'SUM: Likely',
                    'showLegend' => true,
                    'showTitle' => true,
                    'skipFetch' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'link' => null,
                    'config' => false,
                    'linkedFields' => '',
                    'chartSecondaryOrderBy' => [],
                ],
            ], [
                'width' => 4,
                'height' => 18,
                'x' => 8,
                'y' => 19,
                'id' => 'fda6ebaa-e570-412f-acb0-a4490b8bd7b4',
                'autoPosition' => false,
                'context' => [
                    'module' => 'RevenueLineItems',
                ],
                'link' => [
                    'module' => 'RevenueLineItems',
                ],
                'view' => [
                    'label' => 'Sales Leaderboard YTD',
                    'type' => 'report-dashlet',
                    'module' => 'RevenueLineItems',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Sales Leaderboard',
                    'reportId' => 'b10c0d56-b60b-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '11c1c812-3cf6-4274-800b-1bc23dce9976',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_stage',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => ['Closed Won'],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_year',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_year',
                                'input_name1' => 'on',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'RevenueLineItems',
                            'module' => 'RevenueLineItems',
                            'label' => 'RevenueLineItems',
                            'dependents' => [],
                        ],
                        'RevenueLineItems:assigned_user_link' => [
                            'name' => 'Revenue Line Items  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'revenuelineitems_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'RevenueLineItems:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_8',
                                'Filter.1_table_filter_row_2',
                                'display_cols_row_7',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_3',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'RevenueLineItems:opportunities' => [
                            'name' => 'Revenue Line Items  >  Opportunities',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'opportunities',
                                'relationship_name' => 'opportunities_revenuelineitems',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Opportunity Name',
                                'module' => 'Opportunities',
                                'table_key' => 'RevenueLineItems:opportunities',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Opportunities',
                            'label' => 'Opportunity Name',
                        ],
                        'RevenueLineItems:account_link' => [
                            'name' => 'Revenue Line Items  >  Account',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'account_link',
                                'relationship_name' => 'revenuelineitems_accounts',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'RevenueLineItems:account_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                                'display_cols_row_6',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                            'sort_dir' => 'asc',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'RLI Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'RevenueLineItems:opportunities',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'RevenueLineItems:account_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'Likely',
                            'table_key' => 'self',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                        ],
                        [
                            'name' => 'likely_case',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                            'sort_dir' => 'desc',
                        ],
                    ],
                    'reportName' => 'Sales Leaderboard',
                    'chartFunction' => 'self:likely_case:sum',
                    'isBarChart' => true,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'SUM: Likely',
                    'showValues' => 'end',
                    'showTitle' => true,
                    'skipFetch' => true,
                    'linkedFields' => '',
                    'link' => null,
                    'showLegend' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'sortOrderList' => 'asc',
                    'sortColumnList' => 'full_name',
                    'listOrderBy' => [
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'RevenueLineItems:assigned_user_link',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'primaryChartColumn' => 'self:likely_case:sum',
                    'config' => false,
                ],
            ], [
                'width' => 8,
                'height' => 9,
                'x' => 0,
                'y' => 28,
                'id' => '5565c8a4-dd4e-4842-839b-356daa50d15c',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Tasks',
                ],
                'view' => [
                    'label' => 'Tasks Created by Me',
                    'type' => 'dashablelist',
                    'module' => 'Tasks',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 10,
                    'filter_id' => 'created_by_me',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'contact_name',
                        'parent_name',
                        'date_due',
                        'team_name',
                        'assigned_user_name',
                        'date_start',
                        'status',
                        'date_modified',
                        'date_entered',
                    ],
                    'templateEdit' => 'edit',
                    'skipFetch' => true,
                ],
            ],
        ],
    ],
    'name' => 'LBL_CUSTOMER_SUCCESS_CONSOLE',
    'id' => '00aa861a-b54b-11ee-9d94-095590d26ca4',
    'is_template' => true,
    'assigned_user_id' => '1',
];
