<?php


/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
return [
    'metadata' => [
        'dashlets' => [
            [
                'width' => 6,
                'height' => 8,
                'x' => 0,
                'y' => 0,
                'id' => 'b6072d00-3d06-4560-b51b-d6bc8ca23067',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'My Marketing Qualified Leads',
                    'type' => 'dashablelist',
                    'module' => 'Leads',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 5,
                    'filter_id' => 'mql_leads',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'status',
                        'account_name',
                        'phone_mobile',
                        'phone_work',
                        'email',
                        'assigned_user_name',
                        'date_modified',
                        'date_entered',
                        'primary_address_street',
                        'primary_address_city',
                        'primary_address_state',
                        'primary_address_postalcode',
                        'primary_address_country',
                    ],
                ],
            ], [
                'width' => 6,
                'height' => 8,
                'x' => 6,
                'y' => 0,
                'id' => 'c6172c66-7f02-47d8-821f-99c6c05747be',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'My Sales Qualified Leads',
                    'type' => 'dashablelist',
                    'module' => 'Leads',
                    'last_state' => [
                        'id' => 'dashable-list',
                    ],
                    'intelligent' => '0',
                    'limit' => 5,
                    'filter_id' => 'sql_leads',
                    'freeze_first_column' => true,
                    'display_columns' => [
                        'name',
                        'status',
                        'account_name',
                        'phone_mobile',
                        'phone_work',
                        'email',
                        'assigned_user_name',
                        'date_modified',
                        'date_entered',
                        'primary_address_street',
                        'primary_address_city',
                        'primary_address_state',
                        'primary_address_postalcode',
                        'primary_address_country',
                    ],
                ],
            ], [
                'width' => 6,
                'height' => 9,
                'x' => 0,
                'y' => 8,
                'id' => 'c5c6f606-6312-49aa-b7eb-c57f06878352',
                'autoPosition' => false,
                'view' => [
                    'label' => 'Active Tasks',
                    'type' => 'active-tasks',
                    'template' => 'tabbed-dashlet',
                    'module' => null,
                    'last_state' => [
                        'id' => 'dashable-list',
                        'defaults' => [
                            'visibility' => 'user',
                        ],
                    ],
                ],
            ], [
                'width' => 6,
                'height' => 9,
                'x' => 6,
                'y' => 8,
                'id' => '0c288c74-4cb4-4e8b-85d9-f8fe12bc060e',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Tasks',
                ],
                'link' => [
                    'module' => 'Tasks',
                ],
                'view' => [
                    'label' => 'My Open Tasks by Priority and Status',
                    'type' => 'report-dashlet',
                    'module' => 'Leads',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'My Open Tasks by Priority and Status',
                    'reportId' => '2ef63fe2-b60d-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '2036658f-0138-429a-991a-93a07267c598',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'user_name',
                                'table_key' => 'Tasks:assigned_user_link',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Current User',
                                ],
                            ],
                            '1' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Not Started',
                                    'In Progress',
                                    'Pending Input',
                                ],
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Tasks',
                            'module' => 'Tasks',
                            'label' => 'Tasks',
                        ],
                        'Tasks:assigned_user_link' => [
                            'name' => 'Tasks  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'tasks_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Tasks:assigned_user_link',
                            ],
                            'dependents' => [
                                'Filter.1_table_filter_row_1',
                                'Filter.1_table_filter_row_1',
                                'Filter.1_table_filter_row_1',
                                'Filter.1_table_filter_row_1',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                            'optional' => true,
                        ],
                    ],
                    'reportType' => 'Matrix',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Status',
                        ],
                        [
                            'name' => 'priority',
                            'label' => 'Priority',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Priority',
                        ],
                    ],
                    'displayColumns' => [],
                    'summaryColumns' => [
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'priority',
                            'label' => 'Priority',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Number of Tasks',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'My Open Tasks by Priority and Status',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Status',
                    'yAxisLabel' => 'Number of Tasks',
                    'showTotalRecordCount' => false,
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'showLegend' => true,
                    'showTitle' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 4,
                'height' => 9,
                'x' => 0,
                'y' => 17,
                'id' => '61702b26-3734-4e6b-8c2a-2fbc64b3055c',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Opportunities',
                ],
                'link' => [
                    'module' => 'Opportunities',
                ],
                'view' => [
                    'label' => 'BDR Revenue By Period',
                    'type' => 'report-dashlet',
                    'module' => 'Opportunities',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'BDR Revenue By Period',
                    'reportId' => 'af654b2e-b60c-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '0e94b800-5cf2-4175-87da-803a5caa2791',
                    'chartPrimaryOrderBy' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Opportunities:leads:assigned_user_link',
                            'type' => 'username',
                            'sort_dir' => 'asc',
                        ],
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'sales_status',
                                'table_key' => 'self',
                                'qualifier_name' => 'is',
                                'runtime' => 1,
                                'input_name0' => [
                                    'Closed Won',
                                ],
                            ],
                            '1' => [
                                'name' => 'user_name',
                                'table_key' => 'Opportunities:leads:assigned_user_link',
                                'qualifier_name' => 'not_empty',
                                'runtime' => 1,
                                'input_name0' => 'not_empty',
                                'input_name1' => 'on',
                            ],
                            '2' => [
                                'name' => 'date_closed',
                                'table_key' => 'self',
                                'qualifier_name' => 'tp_this_quarter',
                                'runtime' => 1,
                                'input_name0' => 'tp_this_quarter',
                                'input_name1' => 'on',
                            ],
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Opportunities',
                            'module' => 'Opportunities',
                            'label' => 'Opportunities',
                            'dependents' => [],
                        ],
                        'Opportunities:accounts' => [
                            'name' => 'Opportunities  >  Accounts',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'accounts',
                                'relationship_name' => 'accounts_opportunities',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Account Name',
                                'module' => 'Accounts',
                                'table_key' => 'Opportunities:accounts',
                            ],
                            'dependents' => [
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                                'display_cols_row_4',
                            ],
                            'module' => 'Accounts',
                            'label' => 'Account Name',
                            'optional' => true,
                        ],
                        'Opportunities:leads' => [
                            'name' => 'Opportunities  >  Leads ',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'leads',
                                'relationship_name' => 'opportunity_leads',
                                'bean_is_lhs' => true,
                                'link_type' => 'many',
                                'label' => 'Leads',
                                'module' => 'Leads',
                                'table_key' => 'Opportunities:leads',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                            ],
                            'module' => 'Leads',
                            'label' => 'Leads',
                            'optional' => true,
                        ],
                        'Opportunities:leads:assigned_user_link' => [
                            'name' => 'Opportunities  >  Leads  >  Assigned to User',
                            'parent' => 'Opportunities:leads',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'leads_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Opportunities:leads:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'group_by_row_2',
                                'display_summaries_row_group_by_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_3',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                                'Filter.1_table_filter_row_2',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'display_cols_row_5',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                            'optional' => true,
                        ],
                        'Opportunities:assigned_user_link' => [
                            'name' => 'Opportunities  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'opportunities_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Opportunities:assigned_user_link',
                            ],
                            'dependents' => [
                                'display_cols_row_9',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                            'optional' => true,
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'hBarF',
                    'groupDefs' => [
                        'name' => 'user_name',
                        'label' => 'User Name',
                        'table_key' => 'Opportunities:leads:assigned_user_link',
                        'type' => 'username',
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Opportunity Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'name',
                            'label' => 'Account Name',
                            'table_key' => 'Opportunities:accounts',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'BDR Name',
                            'table_key' => 'Opportunities:leads:assigned_user_link',
                        ],
                        [
                            'name' => 'date_closed',
                            'label' => 'Close Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'Amount',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Sales Rep Name',
                            'table_key' => 'Opportunities:assigned_user_link',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Opportunities:leads:assigned_user_link',
                        ],
                        [
                            'name' => 'amount',
                            'label' => 'SUM: Likely',
                            'field_type' => 'currency',
                            'group_function' => 'sum',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'BDR Revenue By Period',
                    'chartFunction' => 'self:amount:sum',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Month: Expected Close Date',
                    'yAxisLabel' => 'SUM: Likely',
                    'showTitle' => true,
                    'showLegend' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'linkedFields' => '',
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'config' => false,
                    'autoPosition' => false,
                    'x' => '0',
                ],
            ], [
                'width' => 4,
                'height' => 9,
                'x' => 4,
                'y' => 17,
                'id' => 'f5f67ff5-148c-49cd-a40c-29717a313373',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'link' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'Lead Conversion Rate',
                    'type' => 'report-dashlet',
                    'module' => 'Leads',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Lead Conversion Rate',
                    'reportId' => 'cb5004fa-b60c-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '28771f08-4c36-4c4f-963d-a0eac012bb52',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'status',
                                'table_key' => 'self',
                                'qualifier_name' => 'one_of',
                                'runtime' => 1,
                                'input_name0' => [
                                    'New',
                                    'Assigned',
                                    'In Process',
                                    'Converted',
                                ],
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Leads',
                            'module' => 'Leads',
                            'label' => 'Leads',
                        ],
                        'Leads:email_addresses_primary' => [
                            'name' => 'Leads  u003E  Email Address',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'email_addresses_primary',
                                'relationship_name' => 'leads_email_addresses_primary',
                                'bean_is_lhs' => true,
                                'link_type' => 'many',
                                'label' => 'Email Address',
                                'module' => 'EmailAddresses',
                                'table_key' => 'Leads:email_addresses_primary',
                            ],
                            'dependents' => [
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                                'display_cols_row_8',
                            ],
                            'module' => 'EmailAddresses',
                            'label' => 'Email Address',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'pieF',
                    'groupDefs' => [
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Status',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Lead Source',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'account_name',
                            'label' => 'Account Name',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'phone_work',
                            'label' => 'Office Phone',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'phone_mobile',
                            'label' => 'Mobile',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'email_address',
                            'label' => 'Email Address',
                            'table_key' => 'Leads:email_addresses_primary',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'status',
                            'label' => 'Status',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Lead Conversion Rate',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Status',
                    'yAxisLabel' => 'Count',
                    'showTitle' => true,
                    'showLegend' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 4,
                'height' => 9,
                'x' => 8,
                'y' => 17,
                'id' => '2ae60bf0-0995-40fc-8a59-8438092acfe9',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Calls',
                ],
                'link' => [
                    'module' => 'Calls',
                ],
                'view' => [
                    'label' => 'Call Activity by User',
                    'type' => 'report-dashlet',
                    'module' => 'Calls',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Call Activity by User',
                    'reportId' => '8b5cfd80-b60c-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => '8434676f-246d-49cf-9008-ab15b1d7866e',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                '0' => [
                                    'name' => 'status',
                                    'table_key' => 'self',
                                    'qualifier_name' => 'is',
                                    'runtime' => 1,
                                    'input_name0' => [
                                        'Held',
                                    ],
                                ],
                                '1' => [
                                    'name' => 'date_start',
                                    'table_key' => 'self',
                                    'qualifier_name' => 'tp_this_year',
                                    'runtime' => 1,
                                    'input_name0' => 'tp_this_year',
                                    'input_name1' => 'on',
                                ],
                                '2' => [
                                    'name' => 'user_name',
                                    'table_key' => 'Calls:assigned_user_link',
                                    'qualifier_name' => 'anything',
                                    'runtime' => 1,
                                    'input_name0' => 'anything',
                                    'input_name1' => 'on',
                                ],
                                'operator' => 'AND',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'value' => 'Calls',
                            'module' => 'Calls',
                            'label' => 'Calls',
                            'dependents' => [],
                        ],
                        'Calls:assigned_user_link' => [
                            'name' => 'Calls  >  Assigned to User',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'assigned_user_link',
                                'relationship_name' => 'calls_assigned_user',
                                'bean_is_lhs' => false,
                                'link_type' => 'one',
                                'label' => 'Assigned to User',
                                'module' => 'Users',
                                'table_key' => 'Calls:assigned_user_link',
                            ],
                            'dependents' => [
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                                'Filter.1.1_table_filter_row_5',
                                'Filter.1.1_table_filter_row_3',
                                'group_by_row_1',
                                'display_summaries_row_group_by_row_1',
                            ],
                            'module' => 'Users',
                            'label' => 'Assigned to User',
                        ],
                        'Calls:contacts' => [
                            'name' => 'Calls  >  Contacts',
                            'parent' => 'self',
                            'link_def' => [
                                'name' => 'contacts',
                                'relationship_name' => 'calls_contacts',
                                'bean_is_lhs' => true,
                                'link_type' => 'many',
                                'label' => 'Contact',
                                'module' => 'Contacts',
                                'table_key' => 'Calls:contacts',
                            ],
                            'dependents' => [
                                'display_cols_row_5',
                                'display_cols_row_5',
                                'display_cols_row_5',
                            ],
                            'module' => 'Contacts',
                            'label' => 'Contact',
                        ],
                    ],
                    'reportType' => 'detailed_summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Calls:assigned_user_link',
                            'type' => 'username',
                            'force_label' => 'User Name',
                        ],
                    ],
                    'displayColumns' => [
                        [
                            'name' => 'name',
                            'label' => 'Subject',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'date_start',
                            'label' => 'Start Date',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'full_name',
                            'label' => 'Name',
                            'table_key' => 'Calls:contacts',
                        ],
                    ],
                    'summaryColumns' => [
                        [
                            'name' => 'user_name',
                            'label' => 'User Name',
                            'table_key' => 'Calls:assigned_user_link',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Call Activity by User',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'User Name',
                    'yAxisLabel' => 'Count',
                    'showValues' => '1',
                    'showTitle' => true,
                    'showLegend' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'skipFetch' => true,
                    'componentType' => 'view',
                    'link' => null,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 6,
                'height' => 9,
                'x' => 0,
                'y' => 26,
                'id' => 'ee5b1ea2-efbb-4af1-be03-d6f511009d9d',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Leads',
                ],
                'link' => [
                    'module' => 'Leads',
                ],
                'view' => [
                    'label' => 'Leads By Lead Source',
                    'type' => 'report-dashlet',
                    'module' => 'Leads',
                    'limit' => 5,
                    'primaryChartOrder' => 'asc',
                    'secondaryChartOrder' => 'asc',
                    'intelligent' => false,
                    'saved_report' => 'Leads By Lead Source',
                    'reportId' => '7ca07da6-b60e-11ee-9d94-095590d26ca4',
                    'uniqueStateId' => 'fac5e683-c187-4f19-80a7-992a4dc405a7',
                    'chartPrimaryOrderBy' => [
                    ],
                    'chartSecondaryOrderBy' => [
                    ],
                    'filtersDef' => [
                        'Filter_1' => [
                            '0' => [
                                'name' => 'lead_source',
                                'table_key' => 'self',
                                'qualifier_name' => 'anything',
                                'runtime' => 1,
                                'input_name0' => 'anything',
                            ],
                            'operator' => 'AND',
                        ],
                    ],
                    'fullTableList' => [
                        'self' => [
                            'parent' => '',
                            'value' => 'Leads',
                            'module' => 'Leads',
                            'label' => 'Leads',
                            'children' => [
                                'self_link_0' => 'self_link_0',
                            ],
                        ],
                    ],
                    'reportType' => 'summary',
                    'chartType' => 'vBarF',
                    'groupDefs' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Leads: Lead Source',
                            'table_key' => 'self',
                            'type' => 'enum',
                            'force_label' => 'Leads: Lead Source',
                        ],
                    ],
                    'displayColumns' => [],
                    'summaryColumns' => [
                        [
                            'name' => 'lead_source',
                            'label' => 'Leads: Lead Source',
                            'table_key' => 'self',
                        ],
                        [
                            'name' => 'count',
                            'label' => 'Count',
                            'field_type' => '',
                            'group_function' => 'count',
                            'table_key' => 'self',
                        ],
                    ],
                    'reportName' => 'Leads By Lead Source',
                    'chartFunction' => 'self:count',
                    'isBarChart' => false,
                    'xAxisLabel' => 'Lead Source',
                    'yAxisLabel' => 'Count',
                    'showValues' => '1',
                    'showTitle' => true,
                    'showLegend' => true,
                    'showXLabel' => true,
                    'showYLabel' => true,
                    'config' => false,
                    'linkedFields' => '',
                ],
            ], [
                'width' => 6,
                'height' => 9,
                'x' => 6,
                'y' => 26,
                'id' => '324cb30d-3dfa-455b-ada6-df4e3f1bdce9',
                'autoPosition' => false,
                'context' => [
                    'module' => 'Forecasts',
                ],
                'view' => [
                    'label' => 'Progress to Goal',
                    'type' => 'forecast-pareto',
                    'module' => 'Forecasts',
                    'last_state' => [
                        'id' => '1c59e4d8-b54a-11ee-9d94-095590d26ca4:forecast-pareto',
                        'defaults' => [
                        ],
                    ],
                    'visibility' => 'user',
                ],
            ],
        ],
        'filters' => [
            '33b80d16-8d11-4ce1-b00f-b77a52c431d0' => [
                'label' => 'BDR Name',
                'fieldType' => 'username',
                'fields' => [
                    [
                        'dashletId' => '61702b26-3734-4e6b-8c2a-2fbc64b3055c',
                        'fieldName' => 'user_name',
                        'fieldDef' => [
                            'name' => 'user_name',
                            'vname' => 'LBL_USER_NAME',
                            'type' => 'username',
                            'dbType' => 'varchar',
                            'len' => 60,
                            'importable' => 'required',
                            'required' => true,
                            'studio' => [
                                'no_duplicate' => true,
                                'editview' => false,
                                'detailview' => true,
                                'quickcreate' => false,
                                'basic_search' => false,
                                'advanced_search' => false,
                                'wirelesseditview' => false,
                                'wirelessdetailview' => true,
                                'wirelesslistview' => false,
                                'wireless_basic_search' => false,
                                'wireless_advanced_search' => false,
                                'rollup' => false,
                            ],
                            'idm_mode_disabled' => true,
                        ],
                        'targetModule' => 'Users',
                        'tableKey' => 'Opportunities:leads:assigned_user_link',
                        'dashletLabel' => 'BDR Revenue By Period',
                        'isRelated' => true,
                        'dashletSpecificData' => [
                            'reportId' => 'af654b2e-b60c-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ], [
                        'dashletId' => '2ae60bf0-0995-40fc-8a59-8438092acfe9',
                        'fieldName' => 'user_name',
                        'fieldDef' => [
                            'name' => 'user_name',
                            'vname' => 'LBL_USER_NAME',
                            'type' => 'username',
                            'dbType' => 'varchar',
                            'len' => 60,
                            'importable' => 'required',
                            'required' => true,
                            'studio' => [
                                'no_duplicate' => true,
                                'editview' => false,
                                'detailview' => true,
                                'quickcreate' => false,
                                'basic_search' => false,
                                'advanced_search' => false,
                                'wirelesseditview' => false,
                                'wirelessdetailview' => true,
                                'wirelesslistview' => false,
                                'wireless_basic_search' => false,
                                'wireless_advanced_search' => false,
                                'rollup' => false,
                            ],
                            'idm_mode_disabled' => true,
                        ],
                        'targetModule' => 'Users',
                        'tableKey' => 'Calls:assigned_user_link',
                        'dashletLabel' => 'Activity KPIs by BDR',
                        'isRelated' => true,
                        'dashletSpecificData' => [
                            'reportId' => '8b5cfd80-b60c-11ee-9d94-095590d26ca4',
                            'currentUserRestrictedDashlet' => false,
                        ],
                    ],
                ],
                'filterDef' => [
                    'qualifier_name' => 'not_empty',
                ],
                'fieldsDashlet' => [],
            ],
        ],
    ],
    'name' => 'LBL_BDR_CONSOLE',
    'id' => '1c59e4d8-b54a-11ee-9d94-095590d26ca4',
    'is_template' => true,
    'assigned_user_id' => '1',
];
