<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['Holiday'] = [
    'table' => 'holidays',
    'archive' => false,
    'favorites' => false,
    'fields' => [
        'id' => [
            'name' => 'id',
            'vname' => 'LBL_ID',
            'required' => true,
            'type' => 'id',
            'reportable' => false,
        ],
        'date_entered' => [
            'name' => 'date_entered',
            'vname' => 'LBL_DATE_ENTERED',
            'type' => 'datetime',
            'group' => 'created_by_name',
            'comment' => 'Date record created',
            'enable_range_search' => true,
            'options' => 'date_range_search_dom',
            'duplicate_on_record_copy' => 'no',
            'readonly' => true,
            'massupdate' => false,
            'full_text_search' => [
                'enabled' => false,
                'searchable' => false,
            ],
        ],
        'date_modified' => [
            'name' => 'date_modified',
            'vname' => 'LBL_DATE_MODIFIED',
            'type' => 'datetime',
            'group' => 'modified_by_name',
            'comment' => 'Date record last modified',
            'enable_range_search' => true,
            'full_text_search' => [
                'enabled' => false,
                'searchable' => false,
            ],
            'options' => 'date_range_search_dom',
            'duplicate_on_record_copy' => 'no',
            'readonly' => true,
            'massupdate' => false,
        ],
        'modified_user_id' => [
            'name' => 'modified_user_id',
            'rname' => 'user_name',
            'id_name' => 'modified_user_id',
            'vname' => 'LBL_MODIFIED',
            'type' => 'assigned_user_name',
            'table' => 'modified_user_id_users',
            'isnull' => false,
            'group' => 'modified_by_name',
            'massupdate' => false,
            'dbType' => 'id',
            'required' => false,
            'len' => 36,
            'reportable' => true,
            'duplicate_on_record_copy' => 'no',
            'readonly' => true,
        ],
        'modified_by_name' => [
            'name' => 'modified_by_name',
            'vname' => 'LBL_MODIFIED',
            'type' => 'relate',
            'reportable' => false,
            'source' => 'non-db',
            'rname' => 'full_name',
            'table' => 'users',
            'id_name' => 'modified_user_id',
            'module' => 'Users',
            'link' => 'modified_user_link',
            'duplicate_merge' => 'disabled',
            'massupdate' => false,
            'duplicate_on_record_copy' => 'no',
            'readonly' => true,
            'sort_on' => ['last_name'],
            'exportable' => true,
        ],
        'created_by' => [
            'name' => 'created_by',
            'rname' => 'user_name',
            'id_name' => 'created_by',
            'vname' => 'LBL_CREATED',
            'type' => 'assigned_user_name',
            'table' => 'users',
            'isnull' => false,
            'dbType' => 'id',
            'len' => 36,
            'group' => 'created_by_name',
            'comment' => 'User who created record',
            'massupdate' => false,
            'duplicate_on_record_copy' => 'no',
            'readonly' => true,
            'full_text_search' => [
                'enabled' => false,
                'searchable' => false,
            ],
        ],
        'created_by_name' => [
            'name' => 'created_by_name',
            'vname' => 'LBL_CREATED',
            'type' => 'relate',
            'reportable' => false,
            'link' => 'created_by_link',
            'rname' => 'full_name',
            'source' => 'non-db',
            'table' => 'users',
            'id_name' => 'created_by',
            'module' => 'Users',
            'duplicate_merge' => 'disabled',
            'importable' => false,
            'massupdate' => false,
            'duplicate_on_record_copy' => 'no',
            'readonly' => true,
            'sort_on' => ['last_name'],
            'exportable' => true,
        ],
        // Link fields for assignment
        'created_by_link' => [
            'name' => 'created_by_link',
            'type' => 'link',
            'relationship' => 'holidays_created_by',
            'vname' => 'LBL_CREATED_USER',
            'link_type' => 'one',
            'module' => 'Users',
            'bean_name' => 'User',
            'source' => 'non-db',
            'side' => 'right',
        ],
        'modified_user_link' => [
            'name' => 'modified_user_link',
            'type' => 'link',
            'relationship' => 'holidays_modified_user',
            'vname' => 'LBL_MODIFIED_USER',
            'link_type' => 'one',
            'module' => 'Users',
            'bean_name' => 'User',
            'source' => 'non-db',
            'side' => 'right',
        ],
        'holiday_date' => [
            'name' => 'holiday_date',
            'type' => 'date',
            'vname' => 'LBL_HOLIDAY_DATE',
            'required' => true,
            'importable' => 'required',
        ],
        'description' => [
            'name' => 'description',
            'vname' => 'LBL_DESCRIPTION',
            'type' => 'text',
        ],
        'deleted' => [
            'name' => 'deleted',
            'vname' => 'LBL_DELETED',
            'type' => 'bool',
            'reportable' => false,
        ],
        'person_id' => [
            'name' => 'person_id',
            'type' => 'id',
            'vname' => 'LBL_PERSON_ID',
        ],
        'person_type' => [
            'name' => 'person_type',
            'type' => 'varchar',
            'vname' => 'LBL_PERSON_TYPE',
        ],
        'related_module' => [
            'name' => 'related_module',
            'type' => 'varchar',
            'vname' => 'LBL_RELATED_MODULE',
        ],
        'related_module_id' => [
            'name' => 'related_module_id',
            'type' => 'id',
            'vname' => 'LBL_RELATED_MODULE_ID',
        ],
        'resource_name' => [
            'name' => 'resource_name',
            'type' => 'varchar',
            'vname' => 'LBL_RESOURCE_NAME',
        ],
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'type' => 'name',
            'dbType' => 'varchar',
            'len' => 255,
            'unified_search' => true,
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.55,
            ],
            'required' => true,
            'importable' => 'required',
            'duplicate_merge' => 'enabled',
            'merge_filter' => 'selected',
            'duplicate_on_record_copy' => 'always',
        ],
        'business_holidays' => [
            'name' => 'business_holidays',
            'type' => 'link',
            'relationship' => 'business_centers_holidays',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_HOLIDAYS',
            'module' => 'BusinessCenters',
            'bean_name' => 'BusinessCenter',
        ],
        'users' => [
            'name' => 'users',
            'type' => 'link',
            'relationship' => 'users_holidays',
            'source' => 'non-db',
            'vname' => 'LBL_USERS',
        ],
    ],
    'relationships' => [
        'holidays_modified_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Holidays',
            'rhs_table' => 'holidays',
            'rhs_key' => 'modified_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'holidays_created_by' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Holidays',
            'rhs_table' => 'holidays',
            'rhs_key' => 'created_by',
            'relationship_type' => 'one-to-many',
        ],
    ],
    'acls' => [
        'SugarACLAdminOnly' => [
            'adminFor' => 'Users',
            'allowUserRead' => true,
        ],
    ],
    'indices' => [
        [
            'name' => 'holidayspk',
            'type' => 'primary',
            'fields' => ['id'],
        ],
        [
            'name' => 'idx_holiday_id_del',
            'type' => 'index',
            'fields' => ['id', 'deleted'],
        ],
        [
            'name' => 'idx_holiday_id_rel',
            'type' => 'index',
            'fields' => ['related_module_id', 'related_module'],
        ],
        [
            'name' => 'idx_holiday_holiday_date',
            'type' => 'index',
            'fields' => ['holiday_date'],
        ],
    ],
];
