<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['EAPM'] = [
    'table' => 'eapm',
    'audited' => false,
    'fields' => [
        'password' => [
            'required' => true,
            'name' => 'password',
            'vname' => 'LBL_PASSWORD',
            'type' => 'encrypt',
            'massupdate' => 0,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => false,
            'len' => '255',
            'size' => '20',
            'write_only' => true,
        ],
        'url' => [
            'required' => true,
            'name' => 'url',
            'vname' => 'LBL_URL',
            'type' => 'varchar',
            'massupdate' => 0,
            'comments' => '',
            'help' => 'LBL_OMIT_URL',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'len' => '255',
            'size' => '20',
        ],
        'application' => [
            'required' => true,
            'name' => 'application',
            'vname' => 'LBL_APPLICATION',
            'type' => 'enum',
            'massupdate' => 0,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'len' => 100,
            'size' => '20',
            'function' => 'getEAPMExternalApiDropDown',
            'studio' => 'visible',
            'default' => 'webex',
        ],
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'type' => 'name',
            'dbType' => 'varchar',
            'len' => '255',
            'unified_search' => true,
            'importable' => 'required',
            'massupdate' => 0,
            'comments' => '',
            'help' => '',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'size' => '20',
        ],
        'api_data' => [
            'name' => 'api_data',
            'vname' => 'LBL_API_DATA',
            'type' => 'text',
            'comment' => 'Any API data that the external API may wish to store on a per-user basis',
            'rows' => 6,
            'cols' => 80,
        ],
        'consumer_key' => [
            'name' => 'consumer_key',
            'type' => 'varchar',
            'vname' => 'LBL_API_CONSKEY',
//        'required' => true,
            'importable' => 'required',
            'massupdate' => 0,
            'audited' => false,
            'reportable' => false,
            'studio' => 'hidden',
        ],
        'consumer_secret' => [
            'name' => 'consumer_secret',
            'type' => 'varchar',
            'vname' => 'LBL_API_CONSSECRET',
//        'required' => true,
            'importable' => 'required',
            'massupdate' => 0,
            'audited' => false,
            'reportable' => false,
            'studio' => 'hidden',
        ],
        'oauth_token' => [
            'name' => 'oauth_token',
            'type' => 'varchar',
            'vname' => 'LBL_API_OAUTHTOKEN',
            'importable' => false,
            'massupdate' => 0,
            'audited' => false,
            'reportable' => false,
            'required' => false,
            'studio' => 'hidden',
        ],
        'oauth_secret' => [
            'name' => 'oauth_secret',
            'type' => 'varchar',
            'vname' => 'LBL_API_OAUTHSECRET',
            'importable' => false,
            'massupdate' => 0,
            'audited' => false,
            'reportable' => false,
            'required' => false,
            'studio' => 'hidden',
        ],
        'validated' => [
            'required' => false,
            'name' => 'validated',
            'vname' => 'LBL_VALIDATED',
            'type' => 'bool',
            'default' => false,
        ],
        'note' => [
            'name' => 'note',
            'vname' => 'LBL_NOTE',
            'required' => false,
            'reportable' => false,
            'importable' => false,
            'massupdate' => false,
            'studio' => 'hidden',
            'type' => 'varchar',
            'source' => 'non-db',
        ],

    ],
    'relationships' => [
    ],
    'indices' => [
        [
            'name' => 'idx_app_active',
            'type' => 'index',
            'fields' => ['assigned_user_id', 'application', 'validated'],
        ],
    ],
    'optimistic_locking' => true,
    'visibility' => ['OwnerOrAdminVisibility' => true],
];
if (!class_exists('VardefManager')) {
}
VardefManager::createVardef('EAPM', 'EAPM', ['basic', 'assignable']);
