<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['DocuSignEnvelope'] = [
    'table' => 'docusign_envelopes',
    'audited' => true,
    'activity_enabled' => false,
    'color' => 'ocean',
    'icon' => 'sicon-contracts',
    'duplicate_merge' => true,
    'optimistic_locking' => true,
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'fields' => [
        'name' => [
            'name' => 'name',
            'vname' => 'LBL_NAME',
            'type' => 'name',
            'dbType' => 'varchar',
            'len' => 255,
            'unified_search' => true,
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.55,
            ],
            'required' => true,
            'importable' => 'required',
            'duplicate_merge' => 'enabled',
            'merge_filter' => 'selected',
            'duplicate_on_record_copy' => 'always',
            'audited' => true,
        ],
        'status' => [
            'name' => 'status',
            'vname' => 'LBL_STATUS',
            'type' => 'enum',
            'options' => 'docusign_envelope_status_list',
            'len' => 100,
            'massupdate' => true,
            'reportable' => true,
            'comment' => 'The status of the envelope',
            'sortable' => true,
            'importable' => true,
            'readonly' => true,
            'audited' => true,
        ],
        'envelope_id' => [
            'name' => 'envelope_id',
            'vname' => 'LBL_ENVELOPE_ID',
            'type' => 'varchar',
            'massupdate' => false,
            'default' => '',
            'importable' => true,
            'duplicate_merge' => 'disabled',
            'reportable' => true,
            'comment' => 'The id of the envelope in DocuSign',
            'len' => '36',
            'size' => '20',
            'readonly' => true,
            'audited' => true,
        ],
        'completed_document' => [
            'name' => 'completed_document',
            'rname' => 'document_name',
            'id_name' => 'document_id',
            'vname' => 'LBL_COMPLETED_DOCUMENT',
            'type' => 'relate',
            'massupdate' => true,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => 1,
            'reportable' => true,
            'comment' => 'The document completed in DocuSign',
            'len' => 255,
            'size' => '20',
            'source' => 'non-db',
            'dbType' => 'varchar',
            'ext2' => 'Documents',
            'module' => 'Documents',
            'studio' => 'visible',
            'audited' => true,
        ],
        'document_id' => [
            'required' => false,
            'readonly' => false,
            'name' => 'document_id',
            'vname' => 'LBL_COMPLETED_DOCUMENT_DOCUMENT_ID',
            'type' => 'id',
            'massupdate' => true,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => 1,
            'reportable' => false,
            'size' => '20',
        ],
        'parent_name' => [
            'labelValue' => 'Parent',
            'source' => 'non-db',
            'name' => 'parent_name',
            'vname' => 'LBL_PARENT',
            'type' => 'parent',
            'massupdate' => false,
            'default' => null,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '1',
            'reportable' => true,
            'comment' => 'The parent record',
            'len' => 36,
            'size' => '20',
            'options' => 'parent_type_display',
            'type_name' => 'parent_type',
            'id_name' => 'parent_id',
            'parent_type' => 'record_type_display',
        ],
        'parent_id' => [
            'name' => 'parent_id',
            'vname' => 'LBL_PARENT_ID',
            'type' => 'id',
            'massupdate' => false,
            'default' => null,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '1',
            'reportable' => true,
            'size' => '20',
        ],
        'parent_type' => [
            'name' => 'parent_type',
            'vname' => 'LBL_PARENT_TYPE',
            'type' => 'parent_type',
            'dbType' => 'varchar',
            'massupdate' => false,
            'default' => null,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => '1',
            'reportable' => true,
            'len' => '255',
            'size' => '20',
            'studio' => 'hidden',
            'group' => 'parent_name',
        ],
        'last_audit' => [
            'name' => 'last_audit',
            'vname' => 'LBL_LAST_AUDIT',
            'type' => 'datetimecombo',
            'dbType' => 'datetime',
            'massupdate' => false,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => 1,
            'reportable' => true,
            'comment' => 'The last time the envelope was fetched from DocuSign',
            'size' => '20',
            'enable_range_search' => false,
        ],
        'cloud_service_type' => [
            'name' => 'cloud_service_type',
            'vname' => 'LBL_CLOUD_SERVICE_TYPE',
            'type' => 'varchar',
            'required' => false,
            'massupdate' => false,
            'importable' => true,
            'default' => '',
            'no_default' => false,
            'comments' => 'The could service type',
            'importable' => true,
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'reportable' => true,
            'len' => '36',
            'size' => '20',
        ],
        'driveId' => [
            'name' => 'driveId',
            'vname' => 'LBL_CLOUD_DRIVE_ID',
            'type' => 'varchar',
            'required' => false,
            'massupdate' => false,
            'importable' => true,
            'default' => '',
            'no_default' => false,
            'comments' => 'The driveId where the file should be saved  on sharepoint',
            'importable' => true,
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'reportable' => true,
            'len' => '400',
            'size' => '20',
        ],
        'cloud_path' => [
            'name' => 'cloud_path',
            'vname' => 'LBL_CLOUD_PATH',
            'type' => 'varchar',
            'required' => false,
            'massupdate' => false,
            'importable' => true,
            'default' => '',
            'no_default' => false,
            'comments' => 'The cloud path',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'reportable' => true,
            'len' => '400',
            'size' => '20',
        ],
    ],
    'indices' => [
        [
            'name' => 'idx_envelope_id',
            'type' => 'index',
            'fields' => [
                'envelope_id',
            ],
        ],
        [
            'name' => 'idx_parent_record',
            'type' => 'index',
            'fields' => [
                'parent_id',
                'parent_type',
            ],
        ],
    ],
    'relationships' => [
    ],
];

VardefManager::createVardef(
    'DocuSignEnvelopes',
    'DocuSignEnvelope',
    [
        'basic',
        'team_security',
        'assignable',
        'taggable',
        'audit',
    ]
);
