<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['DRI_Workflow'] = [
    'table' => 'dri_workflows',
    'audited' => true,
    'unified_search' => false,
    'icon' => 'sicon-customer-journey-lg',
    'duplicate_merge' => true,
    'comment' => 'DRI_Workflow',
    'optimistic_lock' => true,
    'uses' => [
        'default',
        'assignable',
        'team_security',
        'customer_journey_enabled_modules',
    ],
    'fields' => [
        'available_modules' => [
            'name' => 'available_modules',
            'vname' => 'LBL_AVAILABLE_MODULES',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_templates_available_modules_list',
            'type' => 'multienum',
            'isMultiSelect' => true,
        ],
        'enabled_modules' => [
            'name' => 'enabled_modules',
            'vname' => 'LBL_ENABLED_MODULES',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => null,
            'type' => 'multienum',
            'isMultiSelect' => true,
            'source' => 'non-db',
            'function' => [
                'name' => 'listAutomateEnabledModulesEnumOptions',
            ],
        ],
        'state' => [
            'name' => 'state',
            'vname' => 'LBL_STATE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflows_state_list',
            'dbType' => 'varchar',
            'type' => 'enum',
            'default' => 'not_started',
            'readonly' => true,
            'related_fields' => [
                'archived',
            ],
        ],
        'assignee_rule' => [
            'name' => 'assignee_rule',
            'vname' => 'LBL_ASSIGNEE_RULE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_templates_assignee_rule_list',
            'type' => 'enum',
            'default' => 'stage_start',
        ],
        'target_assignee' => [
            'name' => 'target_assignee',
            'vname' => 'LBL_TARGET_ASSIGNEE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_templates_target_assignee_list',
            'type' => 'enum',
            'default' => 'current_user',
        ],
        'stage_numbering' => [
            'name' => 'stage_numbering',
            'vname' => 'LBL_STAGE_NUMBERS',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => 'true',
            'massupdate' => true,
            'type' => 'toggle',
            'dbType' => 'bool',
            'default' => '0',
            'studio' => true,
            'label_right' => 'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW',
            'label_left' => 'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE',
        ],
        'progress' => [
            'name' => 'progress',
            'vname' => 'LBL_PROGRESS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'float',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'validation' => [
                'type' => 'range',
                'min' => 0,
                'max' => 100,
            ],
        ],
        'momentum_ratio' => [
            'name' => 'momentum_ratio',
            'vname' => 'LBL_MOMENTUM_RATIO',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'float',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 1,
            'readonly' => true,
            'validation' => [
                'type' => 'range',
                'min' => 0,
                'max' => 100,
            ],
        ],
        'score' => [
            'name' => 'score',
            'vname' => 'LBL_SCORE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'points' => [
            'name' => 'points',
            'vname' => 'LBL_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'momentum_points' => [
            'name' => 'momentum_points',
            'vname' => 'LBL_MOMENTUM_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'momentum_score' => [
            'name' => 'momentum_score',
            'vname' => 'LBL_MOMENTUM_SCORE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'date_started' => [
            'name' => 'date_started',
            'vname' => 'LBL_DATE_STARTED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'datetime',
            'readonly' => true,
        ],
        'date_completed' => [
            'name' => 'date_completed',
            'vname' => 'LBL_DATE_COMPLETED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'datetime',
            'readonly' => true,
        ],
        'archived' => [
            'name' => 'archived',
            'vname' => 'LBL_ARCHIVED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => '0',
        ],
        'is_cancelled' => [
            'name' => 'is_cancelled',
            'vname' => 'LBL_IS_CANCELLED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => '0',
        ],
        'is_deleted' => [
            'name' => 'is_deleted',
            'vname' => 'LBL_IS_DELETED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => '0',
        ],
        'tasks' => [
            'name' => 'tasks',
            'vname' => 'LBL_TASKS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Task',
            'relationship' => 'task_dri_workflows',
            'module' => 'Tasks',
        ],
        'calls' => [
            'name' => 'calls',
            'vname' => 'LBL_CALLS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Call',
            'relationship' => 'call_dri_workflows',
            'module' => 'Calls',
        ],
        'meetings' => [
            'name' => 'meetings',
            'vname' => 'LBL_MEETINGS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Meeting',
            'relationship' => 'meeting_dri_workflows',
            'module' => 'Meetings',
        ],
        'dri_subworkflows' => [
            'name' => 'dri_subworkflows',
            'vname' => 'LBL_DRI_SUBWORKFLOWS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_SubWorkflow',
            'relationship' => 'dri_subworkflow_dri_workflows',
            'module' => 'DRI_SubWorkflows',
        ],
        'current_stage_id' => [
            'name' => 'current_stage_id',
            'vname' => 'LBL_CURRENT_STAGE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'current_stage_name' => [
            'name' => 'current_stage_name',
            'vname' => 'LBL_CURRENT_STAGE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_subworkflows',
            'id_name' => 'current_stage_id',
            'sort_on' => 'name',
            'module' => 'DRI_SubWorkflows',
            'readonly' => true,
            'link' => 'current_stage_link',
        ],
        'current_stage_link' => [
            'name' => 'current_stage_link',
            'vname' => 'LBL_CURRENT_STAGE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_SubWorkflow',
            'relationship' => 'dri_workflow_current_stage_dri_subworkflows',
            'module' => 'DRI_SubWorkflows',
        ],
        'dri_workflow_template_id' => [
            'name' => 'dri_workflow_template_id',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'dri_workflow_template_name' => [
            'name' => 'dri_workflow_template_name',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'dri_workflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
            'link' => 'dri_workflow_template_link',
        ],
        'dri_workflow_template_link' => [
            'name' => 'dri_workflow_template_link',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => 'dri_workflow_dri_workflow_templates',
            'module' => 'DRI_Workflow_Templates',
        ],

        'parent_id' => [
            'name' => 'parent_id',
            'vname' => 'LBL_PARENT_ID',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
            'readonly' => true,
        ],
        'parent_name' => [
            'name' => 'parent_name',
            'vname' => 'LBL_PARENT_NAME',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'parent',
            'len' => 255,
            'source' => 'non-db',
            'options' => 'dri_workflows_parent_type_list',
            'parent_type' => 'dri_workflows_parent_type_list',
            'readonly' => true,
            'id_name' => 'parent_id',
            'type_name' => 'parent_type',
        ],
        'parent_type' => [
            'name' => 'parent_type',
            'vname' => 'LBL_PARENT_TYPE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'parent_type',
            'len' => 255,
            'dbType' => 'varchar',
            'options' => 'dri_workflows_parent_type_list',
            'parent_type' => 'dri_workflows_parent_type_list',
            'readonly' => true,
        ],
        'current_activity_task' => [
            'name' => 'current_activity_task',
            'vname' => 'LBL_CURRENT_ACTIVITY_TASK',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Task',
            'relationship' => 'tasks_flex_relate_dri_workflows',
            'module' => 'Tasks',
        ],
        'current_activity_call' => [
            'name' => 'current_activity_call',
            'vname' => 'LBL_CURRENT_ACTIVITY_CALL',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Call',
            'relationship' => 'calls_flex_relate_dri_workflows',
            'module' => 'Calls',
        ],
        'current_activity_meeting' => [
            'name' => 'current_activity_meeting',
            'vname' => 'LBL_CURRENT_ACTIVITY_MEETING',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Meeting',
            'relationship' => 'meetings_flex_relate_dri_workflows',
            'module' => 'Meetings',
        ],
        'assigned_user_picture' => [
            'name' => 'assigned_user_picture',
            'link' => 'assigned_user_link',
            'vname' => 'LBL_ASSIGNED_TO',
            'rname' => 'picture',
            'type' => 'relate',
            'reportable' => false,
            'source' => 'non-db',
            'table' => 'users',
            'id_name' => 'assigned_user_id',
            'module' => 'Users',
            'duplicate_merge' => 'disabled',
            'duplicate_on_record_copy' => 'always',
            'sort_on' => [
                0 => 'last_name',
            ],
            'exportable' => true,
            'related_fields' => [
                0 => 'assigned_user_id',
            ],
        ],
        'account_id' => [
            'name' => 'account_id',
            'vname' => 'LBL_ACCOUNT',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'account_name' => [
            'name' => 'account_name',
            'vname' => 'LBL_ACCOUNT',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'accounts',
            'id_name' => 'account_id',
            'sort_on' => 'name',
            'module' => 'Accounts',
            'link' => 'account_link',
            'customer_journey_parent' => [
                'enabled' => true,
                'rank' => 10,
            ],
        ],
        'account_link' => [
            'name' => 'account_link',
            'vname' => 'LBL_ACCOUNT',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'Account',
            'relationship' => 'dri_workflow_accounts',
            'module' => 'Accounts',
        ],
        'contact_id' =>[
            'name' => 'contact_id',
            'vname' => 'LBL_CONTACT',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'contact_name' => [
            'name' => 'contact_name',
            'vname' => 'LBL_CONTACT',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'contacts',
            'id_name' => 'contact_id',
            'sort_on' => 'name',
            'module' => 'Contacts',
            'link' => 'contact_link',
            'customer_journey_parent' => [
                'enabled' => true,
                'rank' => 10,
            ],
        ],
        'contact_link' => [
            'name' => 'contact_link',
            'vname' => 'LBL_CONTACT',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'Contact',
            'relationship' => 'dri_workflow_contacts',
            'module' => 'Contacts',
        ],
        'lead_id' => [
            'name' => 'lead_id',
            'vname' => 'LBL_LEAD',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'lead_name' => [
            'name' => 'lead_name',
            'vname' => 'LBL_LEAD',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'leads',
            'id_name' => 'lead_id',
            'sort_on' => 'name',
            'module' => 'Leads',
            'link' => 'lead_link',
            'customer_journey_parent' => [
                'enabled' => true,
                'rank' => 10,
            ],
        ],
        'lead_link' => [
            'name' => 'lead_link',
            'vname' => 'LBL_LEAD',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'Lead',
            'relationship' => 'dri_workflow_leads',
            'module' => 'Leads',
        ],
        'opportunity_id' => [
            'name' => 'opportunity_id',
            'vname' => 'LBL_OPPORTUNITY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'opportunity_name' => [
            'name' => 'opportunity_name',
            'vname' => 'LBL_OPPORTUNITY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'opportunities',
            'id_name' => 'opportunity_id',
            'sort_on' => 'name',
            'module' => 'Opportunities',
            'link' => 'opportunity_link',
            'customer_journey_parent' => [
                'enabled' => true,
                'rank' => 10,
            ],
        ],
        'opportunity_link' => [
            'name' => 'opportunity_link',
            'vname' => 'LBL_OPPORTUNITY',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'Opportunity',
            'relationship' => 'dri_workflow_opportunities',
            'module' => 'Opportunities',
        ],
        'case_id' => [
            'name' => 'case_id',
            'vname' => 'LBL_CASE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'case_name' => [
            'name' => 'case_name',
            'vname' => 'LBL_CASE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'cases',
            'id_name' => 'case_id',
            'sort_on' => 'name',
            'module' => 'Cases',
            'link' => 'case_link',
            'customer_journey_parent' => [
                'enabled' => true,
                'rank' => 10,
            ],
        ],
        'case_link' => [
            'name' => 'case_link',
            'vname' => 'LBL_CASE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'Case',
            'relationship' => 'dri_workflow_cases',
            'module' => 'Cases',
        ],
    ],
    'relationships' => [
        'dri_workflow_current_stage_dri_subworkflows' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_SubWorkflows',
            'lhs_table' => 'dri_subworkflows',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'rhs_key' => 'current_stage_id',
        ],
        'dri_workflow_dri_workflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Templates',
            'lhs_table' => 'dri_workflow_templates',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'rhs_key' => 'dri_workflow_template_id',
        ],
        'dri_workflow_accounts' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'rhs_key' => 'account_id',
        ],
        'dri_workflow_contacts' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'rhs_key' => 'contact_id',
        ],
        'dri_workflow_leads' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'Leads',
            'lhs_table' => 'leads',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'rhs_key' => 'lead_id',
        ],
        'dri_workflow_opportunities' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'Opportunities',
            'lhs_table' => 'opportunities',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'rhs_key' => 'opportunity_id',
        ],
        'dri_workflow_cases' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'rhs_module' => 'DRI_Workflows',
            'rhs_table' => 'dri_workflows',
            'rhs_key' => 'case_id',
        ],
    ],
    'indices' => [
        'idx_cj_jry_current_stage_id' => [
            'name' => 'idx_cj_jry_current_stage_id',
            'type' => 'index',
            'fields' => [
                'current_stage_id',
            ],
        ],
        'idx_cj_journey_tpl_id' => [
            'name' => 'idx_cj_journey_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_workflow_template_id',
            ],
        ],
        'idx_cj_jry_parent_id' => [
            'name' => 'idx_cj_jry_parent_id',
            'type' => 'index',
            'fields' => [
                'parent_id',
            ],
        ],
        'idx_cj_jry_account_id' => [
            'name' => 'idx_cj_jry_account_id',
            'type' => 'index',
            'fields' => [
                'account_id',
            ],
        ],
        'idx_cj_jry_contact_id' => [
            'name' => 'idx_cj_jry_contact_id',
            'type' => 'index',
            'fields' => [
                'contact_id',
            ],
        ],
        'idx_cj_jry_lead_id' => [
            'name' => 'idx_cj_jry_lead_id',
            'type' => 'index',
            'fields' => [
                'lead_id',
            ],
        ],
        'idx_cj_jry_opportunity_id' => [
            'name' => 'idx_cj_jry_opportunity_id',
            'type' => 'index',
            'fields' => [
                'opportunity_id',
            ],
        ],
        'idx_cj_jry_case_id' => [
            'name' => 'idx_cj_jry_case_id',
            'type' => 'index',
            'fields' => [
                'case_id',
            ],
        ],
    ],
    'duplicate_check' => [
        'enabled' => false,
    ],
    'acls' => [
        'SugarACLCustomerJourney' => true,
    ],
];

VardefManager::createVardef(
    'DRI_Workflows',
    'DRI_Workflow'
);
$dictionary['DRI_Workflow']['fields']['name']['readonly'] = true;

$dictionary['DRI_Workflow']['fields']['description']['readonly'] = true;
$dictionary['DRI_Workflow']['fields']['description']['full_text_search'] = [
    'enabled' => false,
];
