<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['DRI_Workflow_Task_Template'] = [
    'table' => 'dri_workflow_task_templates',
    'audited' => false,
    'unified_search' => false,
    'icon' => 'sicon-customer-journey-lg',
    'duplicate_merge' => true,
    'comment' => 'DRI_Workflow_Task_Template',
    'optimistic_lock' => true,
    'acls' => [
        'SugarACLDeveloperOrAdmin' => [
            'adminFor' => 'DRI_Workflow_Templates',
            'allowUserRead' => true,
        ],
        'SugarACLCustomerJourney' => true,
    ],
    'fields' => [
        'task_start_date_type' => [
            'name' => 'task_start_date_type',
            'vname' => 'LBL_TASK_START_DATE_TYPE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_task_due_date_type_list',
            'type' => 'enum',
            'help' => 'LBL_SMART_GUIDE_START_DATE',
            'visibility_grid' => [
                'trigger' => 'activity_type',
                'values' => [
                    'Tasks' => [
                        '',
                        'days_from_created',
                        'days_from_stage_started',
                        'days_from_previous_activity_completed',
                        'days_from_parent_date_field',
                        'days_from_specific_activity_completed',
                    ],
                    'Meetings' => [
                        'days_from_created',
                        'days_from_stage_started',
                        'days_from_previous_activity_completed',
                        'days_from_parent_date_field',
                        'days_from_specific_activity_completed',
                    ],
                    'Calls' => [
                        'days_from_created',
                        'days_from_stage_started',
                        'days_from_previous_activity_completed',
                        'days_from_parent_date_field',
                        'days_from_specific_activity_completed',
                    ],
                ],
            ],
        ],
        'task_due_date_type' => [
            'name' => 'task_due_date_type',
            'vname' => 'LBL_TASK_DUE_DATE_TYPE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_task_due_date_type_list',
            'type' => 'enum',
            'help' => 'LBL_SMART_GUIDE_TASK_DUE_DATE_TYPE',
            'visibility_grid' => [
                'trigger' => 'activity_type',
                'values' => [
                    'Tasks' => [
                        '',
                        'days_from_created',
                        'days_from_stage_started',
                        'days_from_previous_activity_completed',
                        'days_from_parent_date_field',
                        'days_from_specific_activity_completed',
                    ],
                    'Meetings' => [
                        'days_from_created',
                        'days_from_stage_started',
                        'days_from_previous_activity_completed',
                        'days_from_parent_date_field',
                        'days_from_specific_activity_completed',
                    ],
                    'Calls' => [
                        'days_from_created',
                        'days_from_stage_started',
                        'days_from_previous_activity_completed',
                        'days_from_parent_date_field',
                        'days_from_specific_activity_completed',
                    ],
                ],
            ],
        ],
        'momentum_start_type' => [
            'name' => 'momentum_start_type',
            'vname' => 'LBL_MOMENTUM_START_TYPE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_momentum_start_type_list',
            'type' => 'enum',
            'help' => 'LBL_SMART_GUIDE_MOMENTUM_START_TYPE',
        ],
        'start_date_module' => [
            'name' => 'start_date_module',
            'vname' => 'LBL_START_DATE_MODULE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_templates_available_modules_list',
            'type' => 'enum',
            'dependency' => 'equal($task_start_date_type, "days_from_parent_date_field")',
            'help' => 'LBL_SMART_GUIDE_MODULE_DATE',
        ],
        'due_date_module' => [
            'name' => 'due_date_module',
            'vname' => 'LBL_DUE_DATE_MODULE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_templates_available_modules_list',
            'type' => 'enum',
            'dependency' => 'equal($task_due_date_type, "days_from_parent_date_field")',
            'help' => 'LBL_SMART_GUIDE_MODULE_DUE_DATE',
        ],
        'start_date_field' => [
            'name' => 'start_date_field',
            'vname' => 'LBL_START_DATE_FIELD',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_start_date_field_list',
            'type' => 'enum',
            'dependency' => 'equal($task_start_date_type, "days_from_parent_date_field")',
            'help' => 'LBL_SMART_GUIDE_START_DATE_FIELD',
        ],
        'due_date_field' => [
            'name' => 'due_date_field',
            'vname' => 'LBL_DUE_DATE_FIELD',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_due_date_field_list',
            'type' => 'enum',
            'dependency' => 'equal($task_due_date_type, "days_from_parent_date_field")',
            'help' => 'LBL_SMART_GUIDE_DUE_DATE_FIELD',
        ],
        'due_date_criteria' => [
            'name' => 'due_date_criteria',
            'vname' => 'LBL_DUE_DATE_CRITERIA',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_due_date_criteria_list',
            'type' => 'enum',
            'default' => 'Absolute',
            'dependency' => 'equal($task_due_date_type, "days_from_parent_date_field")',
            'help' => 'LBL_SMART_GUIDE_DUE_DATE_CRITERIA',
        ],
        'momentum_start_module' => [
            'name' => 'momentum_start_module',
            'vname' => 'LBL_MOMENTUM_START_MODULE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_templates_available_modules_list',
            'type' => 'enum',
            'help' => 'LBL_SMART_MOMENTUM_START_MODULE',
            'dependency' => 'equal($momentum_start_type, "parent_date_field")',
        ],
        'momentum_start_field' => [
            'name' => 'momentum_start_field',
            'vname' => 'LBL_MOMENTUM_START_FIELD',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_momentum_start_field_list',
            'type' => 'enum',
            'help' => 'LBL_SMART_GUIDE_MOMENTUM_START_FIELDv',
            'dependency' => 'equal($momentum_start_type, "parent_date_field")',
        ],
        'priority' => [
            'name' => 'priority',
            'vname' => 'LBL_PRIORITY',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'task_priority_dom',
            'type' => 'enum',
            'default' => 'Medium',
            'len' => 100,
            'dependency' => 'equal($activity_type, "Tasks")',
            'help' => 'LBL_SMART_GUIDE_PRIORITY',
        ],
        'type' => [
            'name' => 'type',
            'vname' => 'LBL_TYPE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_type_list',
            'type' => 'enum',
            'default' => 'customer_task',
            'dependency' => 'equal($activity_type, "Tasks")',
            'help' => 'LBL_SMART_GUIDE_TYPE',
        ],
        'activity_type' => [
            'name' => 'activity_type',
            'vname' => 'LBL_ACTIVITY_TYPE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_activity_type_list',
            'type' => 'enum',
            'default' => 'Tasks',
            'help' => 'LBL_SMART_GUIDE_ACTIVITY_TYPE',
        ],
        'duration_minutes' => [
            'name' => 'duration_minutes',
            'vname' => 'LBL_DURATION_MINUTES',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'duration_intervals',
            'type' => 'enum',
            'len' => 2,
            'default' => 0,
        ],
        'direction' => [
            'name' => 'direction',
            'vname' => 'LBL_DIRECTION',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'call_direction_dom',
            'type' => 'enum',
            'len' => 100,
            'default' => 'Outbound',
            'dependency' => 'equal($activity_type, "Calls")',
        ],
        'points' => [
            'name' => 'points',
            'vname' => 'LBL_POINTS',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_points_list',
            'type' => 'enum',
            'default' => 10,
            'dependency' => 'not($is_parent)',
            'dbType' => 'int',
            'len' => 3,
            'help' => 'LBL_SMART_GUIDE_POINTS',
        ],
        'momentum_points' => [
            'name' => 'momentum_points',
            'vname' => 'LBL_MOMENTUM_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_momentum_points_list',
            'type' => 'enum',
            'default' => 100,
            'dependency' => 'and(not($is_parent), not(equal($momentum_start_type, "")))',
            'dbType' => 'int',
            'len' => 8,
            'help' => 'LBL_SMART_GUIDE_MOMENTUM_POINTS',
        ],
        'send_invite_type' => [
            'name' => 'send_invite_type',
            'vname' => 'LBL_SEND_INVITES',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_send_invites_list',
            'type' => 'enum',
            'default' => 'none',
            'dependency' => 'or(equal($activity_type, "Meetings"), equal($activity_type, "Calls"))',
        ],
        'target_assignee' => [
            'name' => 'target_assignee',
            'vname' => 'LBL_TARGET_ASSIGNEE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_target_assignee_list',
            'type' => 'enum',
            'default' => 'inherit',
            'help' => 'LBL_SMART_GUIDE_TARGET_ASSIGNEE',
        ],
        'assignee_rule' => [
            'name' => 'assignee_rule',
            'vname' => 'LBL_ASSIGNEE_RULE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_workflow_task_templates_assignee_rule_list',
            'type' => 'enum',
            'default' => 'inherit',
        ],
        'populate_fields' => [
            'name' => 'populate_fields',
            'vname' => 'LBL_POPULATE_FIELDS',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => false,
            'massupdate' => false,
            'type' => 'text',
            'studio' => false,
        ],
        'select_to_guests' => [
            'name' => 'select_to_guests',
            'vname' => 'LBL_SELECT_TO_GUESTS',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => false,
            'massupdate' => false,
            'type' => 'text',
            'studio' => false,
        ],
        'allow_activity_by' => [
            'name' => 'allow_activity_by',
            'vname' => 'LBL_ALLOW_ACTIVITY_BY',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => false,
            'massupdate' => false,
            'type' => 'text',
            'studio' => false,
        ],
        'time_of_day' => [
            'name' => 'time_of_day',
            'vname' => 'LBL_TIME_OF_DAY',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'dependency' => 'and(or(equal($activity_type, "Meetings"), equal($activity_type, "Calls")), not(equal($task_due_date_type, "")))',
            'default' => '12:00',
        ],
        'sort_order' => [
            'name' => 'sort_order',
            'vname' => 'LBL_SORT_ORDER',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'help' => 'LBL_SMART_GUIDE_SORT_ORDER',
        ],
        'task_start_days' => [
            'name' => 'task_start_days',
            'vname' => 'LBL_TASK_START_DAYS',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'dependency' => 'not(equal($task_start_date_type, ""))',
            'help' => 'LBL_SMART_GUIDE_TASK_START_DAYS',
        ],
        'task_due_days' => [
            'name' => 'task_due_days',
            'vname' => 'LBL_TASK_DUE_DAYS',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'dependency' => 'not(equal($task_due_date_type, ""))',
            'help' => 'LBL_SMART_GUIDE_TASK_DUE_DAYS',
        ],
        'momentum_due_days' => [
            'name' => 'momentum_due_days',
            'vname' => 'LBL_MOMENTUM_DUE_DAYS',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'help' => 'LBL_SMART_GUIDE_MOMENTUM_DUE_DAYS',
            'dependency' => 'not(equal($momentum_start_type, ""))',
            'validation' => [
                'type' => 'range',
                'min' => 0,
            ],
        ],
        'momentum_due_hours' => [
            'name' => 'momentum_due_hours',
            'vname' => 'LBL_MOMENTUM_DUE_HOURS',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'help' => 'LBL_SMART_GUIDE_MOMENTUM_DUE_HOURS',
            'dependency' => 'not(equal($momentum_start_type, ""))',
            'validation' => [
                'type' => 'range',
                'min' => 0,
            ],
        ],
        'duration_hours' => [
            'name' => 'duration_hours',
            'vname' => 'LBL_DURATION_HOURS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 3,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 1,
        ],
        'duration' => [
            'name' => 'duration',
            'vname' => 'LBL_DURATION',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'source' => 'non-db',
            'dependency' => 'and(or(equal($activity_type, "Meetings"), equal($activity_type, "Calls")), not(equal($task_due_date_type, "")))',
        ],
        'is_parent' => [
            'name' => 'is_parent',
            'vname' => 'LBL_IS_PARENT',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => false,
            'readonly' => true,
        ],
        'blocked_by' => [
            'name' => 'blocked_by',
            'vname' => 'LBL_BLOCKED_BY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'json',
            'dbType' => 'text',
            'isMultiSelect' => true,
            'help' => 'LBL_SMART_GUIDE_BLOCKED_BY',
        ],
        'blocked_by_stages' => [
            'name' => 'blocked_by_stages',
            'vname' => 'LBL_BLOCKED_BY_STAGES',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'json',
            'dbType' => 'text',
            'isMultiSelect' => true,
            'help' => 'LBL_SMART_GUIDE_BLOCKED_BY_STAGES',
        ],
        'url' => [
            'name' => 'url',
            'vname' => 'LBL_URL',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'url',
            'dbType' => 'varchar',
            'help' => 'LBL_SMART_GUIDE_URL',
        ],
        'children' => [
            'name' => 'children',
            'vname' => 'LBL_CHILDREN',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_parent_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'assignee_rule_activities' => [
            'name' => 'assignee_rule_activities',
            'vname' => 'LBL_ASSIGNEE_RULE_ACTIVITIES',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_assignee_rule_activity_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'due_date_activities' => [
            'name' => 'due_date_activities',
            'vname' => 'LBL_DUE_DATE_ACTIVITIES',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_due_date_activity_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'momentum_start_activities' => [
            'name' => 'momentum_start_activities',
            'vname' => 'LBL_MOMENTUM_START_ACTIVITIES',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_momentum_start_activity_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'stage_template_label' => [
            'name' => 'stage_template_label',
            'vname' => 'LBL_STAGE_TEMPLATE_LABEL',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'label',
            'table' => 'dri_subworkflow_templates',
            'id_name' => 'dri_subworkflow_template_id',
            'sort_on' => 'stage_template_label',
            'module' => 'DRI_SubWorkflow_Templates',
            'link' => 'dri_subworkflow_template_link',
        ],
        'stage_template_sort_order' => [
            'name' => 'stage_template_sort_order',
            'vname' => 'LBL_STAGE_TEMPLATE_SORT_ORDER',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'sort_order',
            'table' => 'dri_subworkflow_templates',
            'id_name' => 'dri_subworkflow_template_id',
            'sort_on' => 'stage_template_sort_order',
            'module' => 'DRI_SubWorkflow_Templates',
            'link' => 'dri_subworkflow_template_link',
        ],
        'web_hooks' => [
            'name' => 'web_hooks',
            'vname' => 'LBL_WEB_HOOKS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'CJ_WebHook',
            'relationship' => 'dri_workflow_task_templates_flex_relate_cj_web_hooks',
            'module' => 'CJ_WebHooks',
        ],
        'forms' => [
            'name' => 'forms',
            'vname' => 'LBL_FORMS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'CJ_Form',
            'relationship' => 'dri_workflow_task_templates_flex_relate_cj_forms',
            'module' => 'CJ_Forms',
        ],
        'assignee_rule_activity_id' => [
            'name' => 'assignee_rule_activity_id',
            'vname' => 'LBL_ASSIGNEE_RULE_ACTIVITY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'assignee_rule_activity_name' => [
            'name' => 'assignee_rule_activity_name',
            'vname' => 'LBL_ASSIGNEE_RULE_ACTIVITY',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_task_templates',
            'id_name' => 'assignee_rule_activity_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Task_Templates',
            'dependency' => 'equal($assignee_rule, "specific_activity_completed")',
            'link' => 'assignee_rule_activity_link',
        ],
        'assignee_rule_activity_link' => [
            'name' => 'assignee_rule_activity_link',
            'vname' => 'LBL_ASSIGNEE_RULE_ACTIVITY',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_assignee_rule_activity_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'start_date_activity_id' => [
            'name' => 'start_date_activity_id',
            'vname' => 'LBL_START_DATE_ACTIVITY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'start_date_activity_name' => [
            'name' => 'start_date_activity_name',
            'vname' => 'LBL_START_DATE_ACTIVITY',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_task_templates',
            'id_name' => 'start_date_activity_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Task_Templates',
            'dependency' => 'equal($task_start_date_type, "days_from_specific_activity_completed")',
            'link' => 'start_date_activity_link',
        ],
        'start_date_activity_link' => [
            'name' => 'start_date_activity_link',
            'vname' => 'LBL_START_DATE_ACTIVITY',
            'source' => 'non-db',
            'type' => 'link',
            'primary_only' => true,
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_start_date_activity_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'due_date_activity_id' => [
            'name' => 'due_date_activity_id',
            'vname' => 'LBL_DUE_DATE_ACTIVITY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'due_date_activity_name' => [
            'name' => 'due_date_activity_name',
            'vname' => 'LBL_DUE_DATE_ACTIVITY',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_task_templates',
            'id_name' => 'due_date_activity_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Task_Templates',
            'dependency' => 'equal($task_due_date_type, "days_from_specific_activity_completed")',
            'link' => 'due_date_activity_link',
        ],
        'due_date_activity_link' => [
            'name' => 'due_date_activity_link',
            'vname' => 'LBL_DUE_DATE_ACTIVITY',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_due_date_activity_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'momentum_start_activity_id' => [
            'name' => 'momentum_start_activity_id',
            'vname' => 'LBL_MOMENTUM_START_ACTIVITY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'momentum_start_activity_name' => [
            'name' => 'momentum_start_activity_name',
            'vname' => 'LBL_MOMENTUM_START_ACTIVITY',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_task_templates',
            'id_name' => 'momentum_start_activity_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Task_Templates',
            'dependency' => 'equal($momentum_start_type, "specific_activity_completed")',
            'link' => 'momentum_start_activity_link',
        ],
        'momentum_start_activity_link' => [
            'name' => 'momentum_start_activity_link',
            'vname' => 'LBL_MOMENTUM_START_ACTIVITY',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_momentum_start_activity_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'parent_id' => [
            'name' => 'parent_id',
            'vname' => 'LBL_PARENT',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'parent_name' => [
            'name' => 'parent_name',
            'vname' => 'LBL_PARENT',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_task_templates',
            'id_name' => 'parent_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Task_Templates',
            'readonly' => true,
            'dependency' => 'not(equal($parent_id, ""))',
            'link' => 'parent_link',
        ],
        'parent_link' => [
            'name' => 'parent_link',
            'vname' => 'LBL_PARENT',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_parent_dri_workflow_task_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'dri_subworkflow_template_id' => [
            'name' => 'dri_subworkflow_template_id',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'dri_subworkflow_template_name' => [
            'name' => 'dri_subworkflow_template_name',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_subworkflow_templates',
            'id_name' => 'dri_subworkflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_SubWorkflow_Templates',
            'link' => 'dri_subworkflow_template_link',
        ],
        'dri_subworkflow_template_link' => [
            'name' => 'dri_subworkflow_template_link',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_SubWorkflow_Template',
            'relationship' => 'dri_workflow_task_template_dri_subworkflow_templates',
            'module' => 'DRI_SubWorkflow_Templates',
        ],
        'dri_workflow_template_id' => [
            'name' => 'dri_workflow_template_id',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'dri_workflow_template_name' => [
            'name' => 'dri_workflow_template_name',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'dri_workflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
            'readonly' => true,
            'link' => 'dri_workflow_template_link',
        ],
        'dri_workflow_template_link' => [
            'name' => 'dri_workflow_template_link',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => 'dri_workflow_task_template_dri_workflow_templates',
            'module' => 'DRI_Workflow_Templates',
        ],
        'start_next_journey_id' => [
            'name' => 'start_next_journey_id',
            'vname' => 'LBL_START_NEXT_JOURNEY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'start_next_journey_name' => [
            'name' => 'start_next_journey_name',
            'vname' => 'LBL_START_NEXT_JOURNEY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'start_next_journey_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
            'link' => 'start_next_journey_link',
        ],
        'start_next_journey_link' => [
            'name' => 'start_next_journey_link',
            'vname' => 'LBL_START_NEXT_JOURNEY',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => 'dri_workflow_task_template_start_next_journey_dri_workflow_templates',
            'module' => 'DRI_Workflow_Templates',
        ],
        'target_assignee_user_id' => [
            'name' => 'target_assignee_user_id',
            'vname' => 'LBL_TARGET_ASSIGNEE_USER',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'target_assignee_user_name' => [
            'name' => 'target_assignee_user_name',
            'vname' => 'LBL_TARGET_ASSIGNEE_USER',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'users',
            'id_name' => 'target_assignee_user_id',
            'sort_on' => 'name',
            'module' => 'Users',
            'dependency' => 'or(equal($target_assignee, "user"), equal($target_assignee, "user_team"))',
            'link' => 'target_assignee_user_link',
        ],
        'target_assignee_user_link' => [
            'name' => 'target_assignee_user_link',
            'vname' => 'LBL_TARGET_ASSIGNEE_USER',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'User',
            'relationship' => 'dri_workflow_task_template_target_assignee_user_users',
            'module' => 'Users',
        ],
        'target_assignee_team_id' => [
            'name' => 'target_assignee_team_id',
            'vname' => 'LBL_TARGET_ASSIGNEE_TEAM',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'target_assignee_team_name' => [
            'name' => 'target_assignee_team_name',
            'vname' => 'LBL_TARGET_ASSIGNEE_TEAM',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'teams',
            'id_name' => 'target_assignee_team_id',
            'sort_on' => 'name',
            'module' => 'Teams',
            'dependency' => 'or(equal($target_assignee, "team"), equal($target_assignee, "user_team"))',
            'link' => 'target_assignee_team_link',
        ],
        'target_assignee_team_link' => [
            'name' => 'target_assignee_team_link',
            'vname' => 'LBL_TARGET_ASSIGNEE_TEAM',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'Team',
            'relationship' => 'dri_workflow_task_template_target_assignee_team_teams',
            'module' => 'Teams',
        ],
    ],
    'relationships' => [
        'dri_workflow_task_templates_flex_relate_cj_forms' => [
            'lhs_key' => 'id',
            'relationship_type' => 'one-to-many',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'parent_id',
            'rhs_module' => 'CJ_Forms',
            'rhs_table' => 'cj_forms',
            'relationship_role_column_value' => 'DRI_Workflow_Task_Templates',
            'relationship_role_column' => 'parent_type',
        ],
        'dri_workflow_task_template_parent_dri_workflow_task_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'parent_id',
        ],
        'dri_workflow_task_template_assignee_rule_activity_dri_workflow_task_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'assignee_rule_activity_id',
        ],
        'dri_workflow_task_template_due_date_activity_dri_workflow_task_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'due_date_activity_id',
        ],
        'dri_workflow_task_template_momentum_start_activity_dri_workflow_task_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'momentum_start_activity_id',
        ],
        'dri_workflow_task_templates_flex_relate_cj_web_hooks' => [
            'lhs_key' => 'id',
            'relationship_type' => 'one-to-many',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'parent_id',
            'rhs_module' => 'CJ_WebHooks',
            'rhs_table' => 'cj_web_hooks',
            'relationship_role_column_value' => 'DRI_Workflow_Task_Templates',
            'relationship_role_column' => 'parent_type',
        ],
        'dri_workflow_task_template_dri_subworkflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_SubWorkflow_Templates',
            'lhs_table' => 'dri_subworkflow_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'dri_subworkflow_template_id',
        ],
        'dri_workflow_task_template_dri_workflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Templates',
            'lhs_table' => 'dri_workflow_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'dri_workflow_template_id',
        ],
        'dri_workflow_task_template_start_next_journey_dri_workflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Templates',
            'lhs_table' => 'dri_workflow_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'start_next_journey_id',
        ],
        'dri_workflow_task_template_target_assignee_user_users' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'target_assignee_user_id',
        ],
        'dri_workflow_task_template_target_assignee_team_teams' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'Teams',
            'lhs_table' => 'teams',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'target_assignee_team_id',
        ],
        'dri_workflow_task_template_start_date_activity_dri_workflow_task_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Task_Templates',
            'lhs_table' => 'dri_workflow_task_templates',
            'rhs_module' => 'DRI_Workflow_Task_Templates',
            'rhs_table' => 'dri_workflow_task_templates',
            'rhs_key' => 'start_date_activity_id',
        ],
    ],
    'indices' => [
        'idx_cj_act_tpl_stage_tpl_id' => [
            'name' => 'idx_cj_act_tpl_stage_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_subworkflow_template_id',
            ],
        ],
        'idx_cj_act_tpl_jry_tpl_id' => [
            'name' => 'idx_cj_act_tpl_jry_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_workflow_template_id',
            ],
        ],
        'idx_cj_act_tpl_nxt_jry_tpl_id' => [
            'name' => 'idx_cj_act_tpl_nxt_jry_tpl_id',
            'type' => 'index',
            'fields' => [
                'start_next_journey_id',
            ],
        ],
        'idx_cj_act_tpl_trgt_asgn_us_id' => [
            'name' => 'idx_cj_act_tpl_trgt_asgn_us_id',
            'type' => 'index',
            'fields' => [
                'target_assignee_user_id',
            ],
        ],
        'idx_cj_act_tpl_trgt_asgn_te_id' => [
            'name' => 'idx_cj_act_tpl_trgt_asgn_te_id',
            'type' => 'index',
            'fields' => [
                'target_assignee_team_id',
            ],
        ],
        'idx_cj_act_tpl_parent_id' => [
            'name' => 'idx_cj_act_tpl_parent_id',
            'type' => 'index',
            'fields' => [
                'parent_id',
            ],
        ],
        'idx_cj_act_tpl_ass_rl_act_id' => [
            'name' => 'idx_cj_act_tpl_ass_rl_act_id',
            'type' => 'index',
            'fields' => [
                'assignee_rule_activity_id',
            ],
        ],
        'idx_cj_act_tpl_start_dt_act_id' => [
            'name' => 'idx_cj_act_tpl_start_dt_act_id',
            'type' => 'index',
            'fields' => [
                'start_date_activity_id',
            ],
        ],
        'idx_cj_act_tpl_due_dt_act_id' => [
            'name' => 'idx_cj_act_tpl_due_dt_act_id',
            'type' => 'index',
            'fields' => [
                'due_date_activity_id',
            ],
        ],
        'idx_cj_act_tpl_mmt_strt_act_id' => [
            'name' => 'idx_cj_act_tpl_mmt_strt_act_id',
            'type' => 'index',
            'fields' => [
                'momentum_start_activity_id',
            ],
        ],
    ],
    'duplicate_check' => [
        'enabled' => false,
    ],
    'uses' => [
        'default',
        'team_security',
    ],
];

VardefManager::createVardef(
    'DRI_Workflow_Task_Templates',
    'DRI_Workflow_Task_Template'
);
$dictionary['DRI_Workflow_Task_Template']['fields']['name']['len'] = 50;

$dictionary['DRI_Workflow_Task_Template']['fields']['description']['full_text_search'] = [
    'enabled' => false,
];
