<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['DRI_SubWorkflow'] = [
    'table' => 'dri_subworkflows',
    'audited' => false,
    'unified_search' => false,
    'icon' => 'sicon-customer-journey-stages-lg',
    'duplicate_merge' => true,
    'comment' => 'DRI_SubWorkflow',
    'optimistic_lock' => true,
    'uses' => [
        'default',
        'team_security',
        'assignable',
    ],
    'fields' => [
        'label' => [
            'name' => 'label',
            'vname' => 'LBL_LABEL',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'readonly' => true,
        ],
        'state' => [
            'name' => 'state',
            'vname' => 'LBL_STATE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'dri_subworkflows_state_list',
            'type' => 'enum',
            'default' => 'not_started',
            'readonly' => true,
        ],
        'start_next_journey_id' => [
            'name' => 'start_next_journey_id',
            'vname' => 'LBL_START_NEXT_JOURNEY_ID',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',

        ],
        'progress' => [
            'name' => 'progress',
            'vname' => 'LBL_PROGRESS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'float',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'validation' => [
                'type' => 'range',
                'min' => 0,
                'max' => 100,
            ],
        ],
        'momentum_ratio' => [
            'name' => 'momentum_ratio',
            'vname' => 'LBL_MOMENTUM_RATIO',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'float',
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'default' => 1,
            'validation' => [
                'type' => 'range',
                'min' => 0,
                'max' => 100,
            ],
        ],
        'score' => [
            'name' => 'score',
            'vname' => 'LBL_SCORE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'points' => [
            'name' => 'points',
            'vname' => 'LBL_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'momentum_points' => [
            'name' => 'momentum_points',
            'vname' => 'LBL_MOMENTUM_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'momentum_score' => [
            'name' => 'momentum_score',
            'vname' => 'LBL_MOMENTUM_SCORE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 0,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'sort_order' => [
            'name' => 'sort_order',
            'vname' => 'LBL_SORT_ORDER',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'default' => 1,
            'readonly' => false,
            'validation' => [
                'type' => 'range',
                'min' => 1,
                'max' => 1000,
            ],
        ],
        'date_started' => [
            'name' => 'date_started',
            'vname' => 'LBL_DATE_STARTED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'datetime',
            'readonly' => true,
        ],
        'date_completed' => [
            'name' => 'date_completed',
            'vname' => 'LBL_DATE_COMPLETED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'datetime',
            'readonly' => true,
        ],
        'is_journey_saved' => [
            'name' => 'is_journey_saved',
            'vname' => 'LBL_IS_JOURNEY_SAVED',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => false,
        ],
        'tasks' => [
            'name' => 'tasks',
            'vname' => 'LBL_TASKS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Task',
            'relationship' => 'task_dri_subworkflows',
            'module' => 'Tasks',
        ],
        'calls' => [
            'name' => 'calls',
            'vname' => 'LBL_CALLS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Call',
            'relationship' => 'call_dri_subworkflows',
            'module' => 'Calls',
        ],
        'meetings' => [
            'name' => 'meetings',
            'vname' => 'LBL_MEETINGS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Meeting',
            'relationship' => 'meeting_dri_subworkflows',
            'module' => 'Meetings',
        ],
        'current_stage_at' => [
            'name' => 'current_stage_at',
            'vname' => 'LBL_CURRENT_STAGE_AT',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow',
            'relationship' => 'dri_workflow_current_stage_dri_subworkflows',
            'module' => 'DRI_Workflows',
        ],
        'dri_subworkflow_template_id' => [
            'name' => 'dri_subworkflow_template_id',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'dri_subworkflow_template_name' => [
            'name' => 'dri_subworkflow_template_name',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_subworkflow_templates',
            'id_name' => 'dri_subworkflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_SubWorkflow_Templates',
            'link' => 'dri_subworkflow_template_link',
            'readonly' => true,
            'readonly_formula' => 'not(equal($id,""))',
        ],
        'dri_subworkflow_template_link' => [
            'name' => 'dri_subworkflow_template_link',
            'vname' => 'LBL_DRI_SUBWORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_SubWorkflow_Template',
            'relationship' => 'dri_subworkflow_dri_subworkflow_templates',
            'module' => 'DRI_SubWorkflow_Templates',
        ],
        'dri_workflow_id' => [
            'name' => 'dri_workflow_id',
            'vname' => 'LBL_DRI_WORKFLOW',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'dri_workflow_name' => [
            'name' => 'dri_workflow_name',
            'vname' => 'LBL_DRI_WORKFLOW',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflows',
            'id_name' => 'dri_workflow_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflows',
            'link' => 'dri_workflow_link',
            'readonly' => true,
            'readonly_formula' => 'true',
        ],
        'dri_workflow_link' => [
            'name' => 'dri_workflow_link',
            'vname' => 'LBL_DRI_WORKFLOW',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow',
            'relationship' => 'dri_subworkflow_dri_workflows',
            'module' => 'DRI_Workflows',
        ],
    ],
    'relationships' => [
        'dri_subworkflow_dri_subworkflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_SubWorkflow_Templates',
            'lhs_table' => 'dri_subworkflow_templates',
            'rhs_module' => 'DRI_SubWorkflows',
            'rhs_table' => 'dri_subworkflows',
            'rhs_key' => 'dri_subworkflow_template_id',
        ],
        'dri_subworkflow_dri_workflows' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflows',
            'lhs_table' => 'dri_workflows',
            'rhs_module' => 'DRI_SubWorkflows',
            'rhs_table' => 'dri_subworkflows',
            'rhs_key' => 'dri_workflow_id',
        ],
    ],
    'indices' => [
        'idx_cj_stage_org_tpl_id' => [
            'name' => 'idx_cj_stage_org_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_subworkflow_template_id',
            ],
        ],
        'idx_cj_stage_parent_journey_id' => [
            'name' => 'idx_cj_stage_parent_journey_id',
            'type' => 'index',
            'fields' => [
                'dri_workflow_id',
            ],
        ],
    ],
    'duplicate_check' => [
        'enabled' => false,
    ],
    'acls' => [
        'SugarACLCustomerJourney' => true,
    ],
];

VardefManager::createVardef(
    'DRI_SubWorkflows',
    'DRI_SubWorkflow'
);

$dictionary['DRI_SubWorkflow']['fields']['name']['len'] = 30;
$dictionary['DRI_SubWorkflow']['fields']['name']['readonly_formula'] = 'not(equal($dri_subworkflow_template_name, ""))';

$dictionary['DRI_SubWorkflow']['fields']['description']['full_text_search'] = [
    'enabled' => false,
];
$dictionary['DRI_SubWorkflow']['fields']['description']['readonly_formula'] = 'not(equal($dri_subworkflow_template_name, ""))';
