<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['DRI_SubWorkflow_Template'] = [
    'table' => 'dri_subworkflow_templates',
    'audited' => false,
    'unified_search' => false,
    'icon' => 'sicon-customer-journey-stages-lg',
    'duplicate_merge' => true,
    'comment' => 'DRI_SubWorkflow_Template',
    'optimistic_lock' => true,
    'uses' => [
        'default',
        'team_security',
    ],
    'fields' => [
        'label' => [
            'name' => 'label',
            'vname' => 'LBL_LABEL',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'readonly' => true,
        ],
        'sort_order' => [
            'name' => 'sort_order',
            'vname' => 'LBL_SORT_ORDER',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'help' => 'LBL_SMART_GUIDE_STAGE_ORDER',
        ],
        'points' => [
            'name' => 'points',
            'vname' => 'LBL_POINTS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'related_activities' => [
            'name' => 'related_activities',
            'vname' => 'LBL_RELATED_ACTIVITIES',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'int',
            'len' => 8,
            'options' => 'numeric_range_search_dom',
            'enable_range_search' => true,
            'readonly' => true,
            'disable_num_format' => true,
        ],
        'dri_subworkflows' => [
            'name' => 'dri_subworkflows',
            'vname' => 'LBL_DRI_SUBWORKFLOWS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_SubWorkflow',
            'relationship' => 'dri_subworkflow_dri_subworkflow_templates',
            'module' => 'DRI_SubWorkflows',
        ],
        'dri_workflow_task_templates' => [
            'name' => 'dri_workflow_task_templates',
            'vname' => 'LBL_DRI_WORKFLOW_TASK_TEMPLATES',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_template_dri_subworkflow_templates',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'tasks' => [
            'name' => 'tasks',
            'vname' => 'LBL_TASKS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Task',
            'relationship' => 'task_dri_subworkflow_templates',
            'module' => 'Tasks',
        ],
        'meetings' => [
            'name' => 'meetings',
            'vname' => 'LBL_MEETINGS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Meeting',
            'relationship' => 'meeting_dri_subworkflow_templates',
            'module' => 'Meetings',
        ],
        'calls' => [
            'name' => 'calls',
            'vname' => 'LBL_CALLS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'Call',
            'relationship' => 'call_dri_subworkflow_templates',
            'module' => 'Calls',
        ],
        'web_hooks' => [
            'name' => 'web_hooks',
            'vname' => 'LBL_WEB_HOOKS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'CJ_WebHook',
            'relationship' => 'dri_subworkflow_templates_flex_relate_cj_web_hooks',
            'module' => 'CJ_WebHooks',
        ],
        'forms' => [
            'name' => 'forms',
            'vname' => 'LBL_FORMS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'CJ_Form',
            'relationship' => 'dri_subworkflow_templates_flex_relate_cj_forms',
            'module' => 'CJ_Forms',
        ],
        'dri_workflow_template_id' => [
            'name' => 'dri_workflow_template_id',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'dri_workflow_template_name' => [
            'name' => 'dri_workflow_template_name',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'dri_workflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
            'link' => 'dri_workflow_template_link',
        ],
        'dri_workflow_template_link' => [
            'name' => 'dri_workflow_template_link',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => 'dri_subworkflow_template_dri_workflow_templates',
            'module' => 'DRI_Workflow_Templates',
        ],
        'start_next_journey_id' => [
            'name' => 'start_next_journey_id',
            'vname' => 'LBL_START_NEXT_JOURNEY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'start_next_journey_name' => [
            'name' => 'start_next_journey_name',
            'vname' => 'LBL_START_NEXT_JOURNEY',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'start_next_journey_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
            'link' => 'start_next_journey_link',
        ],
        'start_next_journey_link' => [
            'name' => 'start_next_journey_link',
            'vname' => 'LBL_START_NEXT_JOURNEY',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => 'dri_subworkflow_template_start_next_journey_dri_workflow_templates',
            'module' => 'DRI_Workflow_Templates',
        ],
    ],
    'relationships' => [
        'dri_subworkflow_templates_flex_relate_cj_web_hooks' => [
            'lhs_key' => 'id',
            'relationship_type' => 'one-to-many',
            'lhs_module' => 'DRI_SubWorkflow_Templates',
            'lhs_table' => 'dri_subworkflow_templates',
            'rhs_key' => 'parent_id',
            'rhs_module' => 'CJ_WebHooks',
            'rhs_table' => 'cj_web_hooks',
            'relationship_role_column_value' => 'DRI_SubWorkflow_Templates',
            'relationship_role_column' => 'parent_type',
        ],
        'dri_subworkflow_templates_flex_relate_cj_forms' => [
            'lhs_key' => 'id',
            'relationship_type' => 'one-to-many',
            'lhs_module' => 'DRI_SubWorkflow_Templates',
            'lhs_table' => 'dri_subworkflow_templates',
            'rhs_key' => 'parent_id',
            'rhs_module' => 'CJ_Forms',
            'rhs_table' => 'cj_forms',
            'relationship_role_column_value' => 'DRI_SubWorkflow_Templates',
            'relationship_role_column' => 'parent_type',
        ],
        'dri_subworkflow_template_dri_workflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Templates',
            'lhs_table' => 'dri_workflow_templates',
            'rhs_module' => 'DRI_SubWorkflow_Templates',
            'rhs_table' => 'dri_subworkflow_templates',
            'rhs_key' => 'dri_workflow_template_id',
        ],
        'dri_subworkflow_template_start_next_journey_dri_workflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Templates',
            'lhs_table' => 'dri_workflow_templates',
            'rhs_module' => 'DRI_SubWorkflow_Templates',
            'rhs_table' => 'dri_subworkflow_templates',
            'rhs_key' => 'start_next_journey_id',
        ],
    ],
    'indices' => [
        'idx_cj_stage_tpl_jry_tpl_id' => [
            'name' => 'idx_cj_stage_tpl_jry_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_workflow_template_id',
            ],
        ],
        'idx_cj_stg_tpl_nxt_jry_tpl_id' => [
            'name' => 'idx_cj_stg_tpl_nxt_jry_tpl_id',
            'type' => 'index',
            'fields' => [
                'start_next_journey_id',
            ],
        ],
    ],
    'duplicate_check' => [
        'enabled' => false,
    ],
    'acls' => [
        'SugarACLCustomerJourney' => true,
    ],
];

VardefManager::createVardef(
    'DRI_SubWorkflow_Templates',
    'DRI_SubWorkflow_Template'
);

$dictionary['DRI_SubWorkflow_Template']['fields']['name']['len'] = 30;

$dictionary['DRI_SubWorkflow_Template']['fields']['description']['full_text_search'] = [
    'enabled' => false,
];
