<?php

/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['Contact'] = [
    'table' => 'contacts',
    'audited' => true,
    'activity_enabled' => true,
    'color' => 'pink',
    'icon' => 'sicon-contact-lg',
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'duplicate_merge' => true,
    'fields' => [
        'email_and_name1' => [
            'name' => 'email_and_name1',
            'vname' => 'LBL_NAME',
            'type' => 'varchar',
            'source' => 'non-db',
            'len' => '510',
            'importable' => 'false',
            'massupdate' => false,
            'studio' => ['formula' => false],
        ],
        'lead_source' => [
            'name' => 'lead_source',
            'vname' => 'LBL_LEAD_SOURCE',
            'type' => 'enum',
            'options' => 'lead_source_dom',
            'len' => '255',
            'comment' => 'How did the contact come about',
            'merge_filter' => 'enabled',
        ],
        'account_name' => [
            'name' => 'account_name',
            'rname' => 'name',
            'id_name' => 'account_id',
            'vname' => 'LBL_ACCOUNT_NAME',
            'join_name' => 'accounts',
            'type' => 'relate',
            'link' => 'accounts',
            'table' => 'accounts',
            'isnull' => 'true',
            'module' => 'Accounts',
            'dbType' => 'varchar',
            'len' => '255',
            'source' => 'non-db',
            'unified_search' => true,
            'populate_list' => [
                'billing_address_street' => 'primary_address_street',
                'billing_address_city' => 'primary_address_city',
                'billing_address_state' => 'primary_address_state',
                'billing_address_postalcode' => 'primary_address_postalcode',
                'billing_address_country' => 'primary_address_country',
                'phone_office' => 'phone_work',
            ],
            'populate_confirm_label' => 'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR',
            'importable' => 'true',
            'exportable' => true,
            'export_link_type' => 'one',//relationship type to be used during export
        ],
        'account_id' => [
            'name' => 'account_id',
            'rname' => 'id',
            'id_name' => 'account_id',
            'vname' => 'LBL_ACCOUNT_ID',
            'type' => 'relate',
            'table' => 'accounts',
            'isnull' => 'true',
            'module' => 'Accounts',
            'dbType' => 'id',
            'reportable' => false,
            'source' => 'non-db',
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
            'hideacl' => true,
            'link' => 'accounts',
        ],
        //d&b principal id, a unique id assigned to a contact by D&B API
        //this contact is used for dupe check
        'dnb_principal_id' => [
            'name' => 'dnb_principal_id',
            'vname' => 'LBL_DNB_PRINCIPAL_ID',
            'type' => 'varchar',
            'len' => 30,
            'comment' => 'Unique Id For D&B Contact',
        ],
        // Deprecated, use rname_link instead
        'opportunity_role_fields' => [
            'name' => 'opportunity_role_fields',
            'rname' => 'id',
            'relationship_fields' => [
                'id' => 'opportunity_role_id',
                'contact_role' => 'opportunity_role',
            ],
            'vname' => 'LBL_ACCOUNT_NAME',
            'type' => 'relate',
            'link' => 'opportunities',
            'link_type' => 'relationship_info',
            'join_link_name' => 'opportunities_contacts',
            'source' => 'non-db',
            'importable' => 'false',
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        // Deprecated, use rname_link instead
        'opportunity_role_id' => [
            'name' => 'opportunity_role_id',
            'type' => 'varchar',
            'source' => 'non-db',
            'vname' => 'LBL_OPPORTUNITY_ROLE_ID',
            'studio' => ['listview' => false],
        ],
        'opportunity_role' => [
            'name' => 'opportunity_role',
            'type' => 'enum',
            'source' => 'non-db',
            'vname' => 'LBL_OPPORTUNITY_ROLE',
            'options' => 'opportunity_relationship_type_dom',
            'link' => 'opportunities',
            'rname_link' => 'contact_role',
            'massupdate' => false,
        ],
        'reports_to_id' => [
            'name' => 'reports_to_id',
            'vname' => 'LBL_REPORTS_TO_ID',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'comment' => 'The contact this contact reports to',
        ],
        'report_to_name' => [
            'name' => 'report_to_name',
            'rname' => 'name',
            'id_name' => 'reports_to_id',
            'vname' => 'LBL_REPORTS_TO',
            'type' => 'relate',
            'link' => 'reports_to_link',
            'table' => 'contacts',
            'isnull' => 'true',
            'module' => 'Contacts',
            'dbType' => 'varchar',
            'len' => 'id',
            'reportable' => false,
            'source' => 'non-db',
            'populate_list' => [
                'account_id' => 'account_id',
                'account_name' => 'account_name',
            ],
        ],
        'birthdate' => [
            'name' => 'birthdate',
            'vname' => 'LBL_BIRTHDATE',
            'massupdate' => false,
            'type' => 'date',
            'comment' => 'The birthdate of the contact',
            'audited' => true,
            'pii' => true,
        ],
        'portal_name' => [
            'name' => 'portal_name',
            'vname' => 'LBL_PORTAL_NAME',
            'type' => 'username',
            'dbType' => 'varchar',
            'len' => '255',
            'group' => 'portal',
            'group_label' => 'LBL_PORTAL',
            'comment' => 'Name as it appears in the portal',
            'studio' => [
                'portalrecordview' => false,
                'portallistview' => false,
            ],
            'duplicate_on_record_copy' => 'no',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.93,
                'type' => 'exact',
            ],
        ],
        'portal_active' => [
            'name' => 'portal_active',
            'vname' => 'LBL_PORTAL_ACTIVE',
            'type' => 'bool',
            'default' => '0',
            'group' => 'portal',
            'comment' => 'Indicator whether this contact is a portal user',
            'duplicate_on_record_copy' => 'no',
        ],
        'portal_password' => [
            'name' => 'portal_password',
            'vname' => 'LBL_USER_PASSWORD',
            'type' => 'password',
            'dbType' => 'varchar',
            'len' => '255',
            'group' => 'portal',
            'reportable' => false,
            'studio' => [
                'listview' => false,
                'portalrecordview' => false,
                'portallistview' => false,
            ],
            'duplicate_on_record_copy' => 'no',
        ],
        'portal_password1' => [
            'name' => 'portal_password1',
            'vname' => 'LBL_USER_PASSWORD',
            'type' => 'password',
            'source' => 'non-db',
            'len' => '255',
            'group' => 'portal',
            'reportable' => false,
            'importable' => 'false',
            'studio' => [
                'listview' => false,
                'portalrecordview' => false,
                'portallistview' => false,
            ],
        ],
        'portal_app' => [
            'name' => 'portal_app',
            'vname' => 'LBL_PORTAL_APP',
            'type' => 'varchar',
            'group' => 'portal',
            'len' => '255',
            'comment' => 'Reference to the portal',
            'duplicate_on_record_copy' => 'no',
        ],
        'portal_user_company_name' => [
            'name' => 'portal_user_company_name',
            'vname' => 'LBL_PORTAL_USER_COMPANY_NAME',
            'type' => 'varchar',
            'len' => '255',
            'group' => 'portal',
            'comment' => 'User company name in the portal',
            'studio' => [
                'portalrecordview' => false,
                'portallistview' => false,
            ],
            'duplicate_on_record_copy' => 'no',
        ],
        'preferred_language' => [
            'name' => 'preferred_language',
            'type' => 'enum',
            'vname' => 'LBL_PREFERRED_LANGUAGE',
            'options' => 'available_language_dom',
            'popupHelp' => 'LBL_LANG_PREF_TOOLTIP',
        ],
        'cookie_consent' => [
            'name' => 'cookie_consent',
            'vname' => 'LBL_COOKIE_CONSENT',
            'type' => 'bool',
            'default' => '0',
            'audited' => true,
            'comment' => 'Indicator whether this portal user accepts cookies',
            'duplicate_on_record_copy' => 'no',
            'studio' => false,
        ],
        'cookie_consent_received_on' => [
            'name' => 'cookie_consent_received_on',
            'vname' => 'LBL_COOKIE_CONSENT_RECEIVED_ON',
            'type' => 'datetime',
            'audited' => true,
            'enable_range_search' => true,
            'options' => 'date_range_search_dom',
            'comment' => 'Date cookie consent received on',
            'duplicate_on_record_copy' => 'no',
            'studio' => false,
        ],
        'business_center_name' => [
            'name' => 'business_center_name',
            'rname' => 'name',
            'id_name' => 'business_center_id',
            'vname' => 'LBL_BUSINESS_CENTER_NAME',
            'type' => 'relate',
            'link' => 'business_centers',
            'table' => 'business_centers',
            'join_name' => 'business_centers',
            'isnull' => 'true',
            'module' => 'BusinessCenters',
            'dbType' => 'varchar',
            'len' => 255,
            'source' => 'non-db',
            'unified_search' => true,
            'comment' => 'The name of the business center represented by the business_center_id field',
            'required' => false,
        ],
        'business_center_id' => [
            'name' => 'business_center_id',
            'type' => 'relate',
            'dbType' => 'id',
            'rname' => 'id',
            'module' => 'BusinessCenters',
            'id_name' => 'business_center_id',
            'reportable' => false,
            'vname' => 'LBL_BUSINESS_CENTER_ID',
            'audited' => true,
            'massupdate' => false,
            'comment' => 'The business center to which the case is associated',
        ],
        'business_centers' => [
            'name' => 'business_centers',
            'type' => 'link',
            'relationship' => 'business_center_contacts',
            'link_type' => 'one',
            'side' => 'right',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER',
        ],
        'purchases' => [
            'name' => 'purchases',
            'type' => 'link',
            'relationship' => 'contacts_purchases',
            'source' => 'non-db',
            'vname' => 'LBL_PURCHASES_SUBPANEL_TITLE',
        ],
        'escalations' => [
            'name' => 'escalations',
            'type' => 'link',
            'relationship' => 'contacts_escalations',
            'source' => 'non-db',
            'vname' => 'LBL_ESCALATIONS',
        ],
        'accounts' => [
            'name' => 'accounts',
            'type' => 'link',
            'relationship' => 'accounts_contacts',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_ACCOUNT',
            'duplicate_merge' => 'disabled',
            'primary_only' => true,
        ],
        'reports_to_link' => [
            'name' => 'reports_to_link',
            'type' => 'link',
            'relationship' => 'contact_direct_reports',
            'link_type' => 'one',
            'side' => 'right',
            'source' => 'non-db',
            'vname' => 'LBL_REPORTS_TO',
        ],
        'opportunities' => [
            'name' => 'opportunities',
            'type' => 'link',
            'relationship' => 'opportunities_contacts',
            'source' => 'non-db',
            'module' => 'Opportunities',
            'bean_name' => 'Opportunity',
            'vname' => 'LBL_OPPORTUNITIES',
            'populate_list' => [
                'account_id' => 'account_id',
                'account_name' => 'account_name',
            ],
        ],
        'bugs' => [
            'name' => 'bugs',
            'type' => 'link',
            'relationship' => 'contacts_bugs',
            'source' => 'non-db',
            'vname' => 'LBL_BUGS',
        ],
        'calls' => [
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'calls_contacts',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
        ],
        'cases' => [
            'name' => 'cases',
            'type' => 'link',
            'relationship' => 'contacts_cases',
            'source' => 'non-db',
            'vname' => 'LBL_CASES',
            'populate_list' => [
                'account_id',
                'account_name',
            ],
        ],
        'case_contact' => [
            'name' => 'case_contact',
            'type' => 'link',
            'relationship' => 'contact_cases',
            'source' => 'non-db',
            'side' => 'right',
            'vname' => 'LBL_CONTACT',
            'module' => 'Cases',
            'bean_name' => 'aCase',
            'id_name' => 'primary_contact_id',
            'link_type' => 'one',
            'populate_list' => [
                'account_id',
                'account_name',
            ],
        ],
        'dataprivacy' => [
            'name' => 'dataprivacy',
            'type' => 'link',
            'relationship' => 'contacts_dataprivacy',
            'source' => 'non-db',
            'vname' => 'LBL_DATAPRIVACY',
        ],
        'dp_business_purpose' => [
            'name' => 'dp_business_purpose',
            'vname' => 'LBL_DATAPRIVACY_BUSINESS_PURPOSE',
            'type' => 'multienum',
            'isMultiSelect' => true,
            'audited' => true,
            'options' => 'dataprivacy_business_purpose_dom',
            'default' => '',
            'len' => 255,
            'comment' => 'Business purposes consented for',
        ],
        'dp_consent_last_updated' => [
            'name' => 'dp_consent_last_updated',
            'vname' => 'LBL_DATAPRIVACY_CONSENT_LAST_UPDATED',
            'type' => 'date',
            'display_default' => 'now',
            'audited' => true,
            'enable_range_search' => true,
            'options' => 'date_range_search_dom',
            'comment' => 'Date consent last updated',
            'studio' => false,
        ],
        'direct_reports' => [
            'name' => 'direct_reports',
            'type' => 'link',
            'relationship' => 'contact_direct_reports',
            'source' => 'non-db',
            'vname' => 'LBL_DIRECT_REPORTS',
        ],
        'emails' => [
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'emails_contacts_rel',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
        ],
        'archived_emails' => [
            'name' => 'archived_emails',
            'type' => 'link',
            'link_class' => 'ArchivedEmailsLink',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'module' => 'Emails',
            'link_type' => 'many',
            'relationship' => '',
            'readonly' => true,
        ],
        'documents' => [
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_contacts',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
        ],
        'leads' => [
            'name' => 'leads',
            'type' => 'link',
            'relationship' => 'contact_leads',
            'source' => 'non-db',
            'vname' => 'LBL_LEADS',
            'populate_list' => [
                'first_name' => 'first_name',
                'last_name' => 'last_name',
                'account_name' => 'account_name',
                'phone_work' => 'phone_work',
                'id' => 'contact_id',
                'account_id' => 'account_id',
            ],
        ],
        'products' => [
            'name' => 'products',
            'type' => 'link',
            'rname' => ['first_name', 'last_name'],
            'relationship' => 'contact_products',
            'source' => 'non-db',
            'vname' => 'LBL_PRODUCTS_TITLE',
            'populate_list' => [
                'account_id',
                'account_name',
            ],
        ],
        'contracts' => [
            'name' => 'contracts',
            'type' => 'link',
            'vname' => 'LBL_CONTRACTS',
            'relationship' => 'contracts_contacts',
            'source' => 'non-db',
        ],
        'meetings' => [
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'meetings_contacts',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
        ],
        'notes' => [
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'contact_notes',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'messages' => [
            'name' => 'messages',
            'type' => 'link',
            'relationship' => 'contact_messages',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'message_invites' => [
            'name' => 'message_invites',
            'type' => 'link',
            'relationship' => 'messages_contacts',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'project' => [
            'name' => 'project',
            'type' => 'link',
            'relationship' => 'projects_contacts',
            'source' => 'non-db',
            'vname' => 'LBL_PROJECTS',
        ],
        'project_resource' => [
            'name' => 'project_resource',
            'type' => 'link',
            'relationship' => 'projects_contacts_resources',
            'source' => 'non-db',
            'vname' => 'LBL_PROJECTS_RESOURCES',
        ],
        'quotes' => [
            'name' => 'quotes',
            'type' => 'link',
            'relationship' => 'quotes_contacts_shipto',
            'source' => 'non-db',
            'ignore_role' => 'true',
            'module' => 'Quotes',
            'bean_name' => 'Quote',
            'vname' => 'LBL_QUOTES_SHIP_TO',
        ],
        'billing_quotes' => [
            'name' => 'billing_quotes',
            'type' => 'link',
            'relationship' => 'quotes_contacts_billto',
            'source' => 'non-db',
            'ignore_role' => 'true',
            'module' => 'Quotes',
            'bean_name' => 'Quote',
            'vname' => 'LBL_QUOTES_BILL_TO',
        ],
        'tasks' => [
            'name' => 'tasks',
            'type' => 'link',
            'relationship' => 'contact_tasks',
            'source' => 'non-db',
            'vname' => 'LBL_TASKS',
        ],
        'tasks_parent' => [
            'name' => 'tasks_parent',
            'type' => 'link',
            'relationship' => 'contact_tasks_parent',
            'source' => 'non-db',
            'vname' => 'LBL_TASKS',
            'reportable' => false,
        ],
        'notes_parent' => [
            'name' => 'notes_parent',
            'type' => 'link',
            'relationship' => 'contact_notes_parent',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
            'reportable' => false,
        ],
        'calls_parent' => [
            'name' => 'calls_parent',
            'type' => 'link',
            'relationship' => 'contact_calls_parent',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
            'reportable' => false,
        ],
        'meetings_parent' => [
            'name' => 'meetings_parent',
            'type' => 'link',
            'relationship' => 'contact_meetings_parent',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
            'reportable' => false,
        ],
        'all_tasks' => [
            'name' => 'all_tasks',
            'type' => 'link',
            'link_class' => 'FlexRelateChildrenLink',
            'relationship' => 'contact_tasks',
            'source' => 'non-db',
            'vname' => 'LBL_TASKS',
        ],
        'user_sync' => [
            'name' => 'user_sync',
            'type' => 'link',
            'relationship' => 'contacts_users',
            'source' => 'non-db',
            'vname' => 'LBL_USER_SYNC',
        ],
        'created_by_link' => [
            'name' => 'created_by_link',
            'type' => 'link',
            'relationship' => 'contacts_created_by',
            'vname' => 'LBL_CREATED_BY_USER',
            'link_type' => 'one',
            'module' => 'Users',
            'bean_name' => 'User',
            'source' => 'non-db',
        ],
        'modified_user_link' => [
            'name' => 'modified_user_link',
            'type' => 'link',
            'relationship' => 'contacts_modified_user',
            'vname' => 'LBL_MODIFIED_BY_USER',
            'link_type' => 'one',
            'module' => 'Users',
            'bean_name' => 'User',
            'source' => 'non-db',
        ],
        'assigned_user_link' => [
            'name' => 'assigned_user_link',
            'type' => 'link',
            'relationship' => 'contacts_assigned_user',
            'vname' => 'LBL_ASSIGNED_TO_USER',
            'link_type' => 'one',
            'module' => 'Users',
            'bean_name' => 'User',
            'source' => 'non-db',
            'id_name' => 'assigned_user_id',
            'table' => 'users',
            'duplicate_merge' => 'enabled',
        ],
        'campaign_id' => [
            'name' => 'campaign_id',
            'comment' => 'Campaign that generated lead',
            'vname' => 'LBL_CAMPAIGN_ID',
            'rname' => 'id',
            'id_name' => 'campaign_id',
            'type' => 'id',
            'isnull' => 'true',
            'module' => 'Campaigns',
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'campaign_name' => [
            'name' => 'campaign_name',
            'rname' => 'name',
            'vname' => 'LBL_CAMPAIGN',
            'type' => 'relate',
            'link' => 'campaign_contacts',
            'isnull' => 'true',
            'reportable' => false,
            'source' => 'non-db',
            'table' => 'campaigns',
            'id_name' => 'campaign_id',
            'module' => 'Campaigns',
            'duplicate_merge' => 'disabled',
            'comment' => 'The first campaign name for Contact (Meta-data only)',
            'studio' => [
                'mobile' => false,
            ],
        ],
        'campaigns' => [
            'name' => 'campaigns',
            'type' => 'link',
            'relationship' => 'contact_campaign_log',
            'module' => 'CampaignLog',
            'bean_name' => 'CampaignLog',
            'source' => 'non-db',
            'vname' => 'LBL_CAMPAIGNLOG',
        ],
        'campaign_contacts' => [
            'name' => 'campaign_contacts',
            'type' => 'link',
            'vname' => 'LBL_CAMPAIGN_CONTACT',
            'relationship' => 'campaign_contacts',
            'source' => 'non-db',
        ],
        // Deprecated: Use rname_link instead
        'c_accept_status_fields' => [
            'name' => 'c_accept_status_fields',
            'rname' => 'id',
            'relationship_fields' => [
                'id' => 'accept_status_id',
                'accept_status' => 'accept_status_name',
            ],
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'type' => 'relate',
            'link' => 'calls',
            'link_type' => 'relationship_info',
            'source' => 'non-db',
            'importable' => 'false',
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        // Deprecated: Use rname_link instead
        'm_accept_status_fields' => [
            'name' => 'm_accept_status_fields',
            'rname' => 'id',
            'relationship_fields' => [
                'id' => 'accept_status_id',
                'accept_status' => 'accept_status_name',
            ],
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'type' => 'relate',
            'link' => 'meetings',
            'link_type' => 'relationship_info',
            'source' => 'non-db',
            'importable' => 'false',
            'hideacl' => true,
            'duplicate_merge' => 'disabled',
            'studio' => false,
        ],
        // Deprecated: Use rname_link instead
        'accept_status_id' => [
            'name' => 'accept_status_id',
            'type' => 'varchar',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'studio' => ['listview' => false],
        ],
        // Deprecated: Use rname_link instead
        'accept_status_name' => [
            'massupdate' => false,
            'name' => 'accept_status_name',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
        ],
        'accept_status_calls' => [
            'massupdate' => false,
            'name' => 'accept_status_calls',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
            'link' => 'calls',
            'rname_link' => 'accept_status',
        ],
        'accept_status_meetings' => [
            'massupdate' => false,
            'name' => 'accept_status_meetings',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
            'link' => 'meetings',
            'rname_link' => 'accept_status',
        ],
        'accept_status_messages' => [
            'massupdate' => false,
            'name' => 'accept_status_messages',
            'type' => 'enum',
            'studio' => 'false',
            'source' => 'non-db',
            'vname' => 'LBL_LIST_ACCEPT_STATUS',
            'options' => 'dom_meeting_accept_status',
            'importable' => 'false',
            'link' => 'meetings',
            'rname_link' => 'accept_status',
        ],
        'hint_account_size' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_size',
            'vname' => 'LBL_HINT_COMPANY_SIZE',
            'label' => 'LBL_HINT_COMPANY_SIZE',
            'type' => 'varchar',
            'len' => 20,
            'comment' => 'Company Size',
            'reportable' => false,
        ],
        'hint_account_industry' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_industry',
            'vname' => 'LBL_HINT_COMPANY_INDUSTRY',
            'label' => 'LBL_HINT_COMPANY_INDUSTRY',
            'type' => 'varchar',
            'len' => 120,
            'comment' => 'Company Industry',
            'reportable' => false,
        ],
        'hint_account_location' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_location',
            'vname' => 'LBL_HINT_COMPANY_LOCATION',
            'label' => 'LBL_HINT_COMPANY_LOCATION',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'Company Location',
            'reportable' => false,
        ],
        'hint_account_description' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_description',
            'vname' => 'LBL_HINT_COMPANY_DESCRIPTION',
            'label' => 'LBL_HINT_COMPANY_DESCRIPTION',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'Company Description',
            'reportable' => false,
        ],
        'hint_job_2' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_job_2',
            'vname' => 'LBL_HINT_JOB_2',
            'label' => 'LBL_HINT_JOB_2',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'Job 2',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_education' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_education',
            'vname' => 'LBL_HINT_EDUCATION',
            'label' => 'LBL_HINT_EDUCATION',
            'type' => 'varchar',
            'len' => 225,
            'comment' => 'Education',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_education_2' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_education_2',
            'vname' => 'LBL_HINT_EDUCATION_2',
            'label' => 'LBL_HINT_EDUCATION_2',
            'type' => 'varchar',
            'len' => 225,
            'comment' => 'Education 2',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_facebook' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_facebook',
            'vname' => 'LBL_HINT_FACEBOOK',
            'label' => 'LBL_HINT_FACEBOOK',
            'type' => 'url',
            'len' => 120,
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_twitter' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_twitter',
            'vname' => 'LBL_HINT_TWITTER',
            'label' => 'LBL_HINT_TWITTER',
            'type' => 'url',
            'len' => 120,
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_industry_tags' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_industry_tags',
            'vname' => 'LBL_HINT_COMPANY_INDUSTRY_TAGS',
            'label' => 'LBL_HINT_COMPANY_INDUSTRY_TAGS',
            'type' => 'varchar',
            'len' => 225,
            'comment' => 'industry tags',
            'reportable' => false,
        ],
        'hint_account_founded_year' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_founded_year',
            'vname' => 'LBL_HINT_COMPANY_FOUNDED_YEAR',
            'label' => 'LBL_HINT_COMPANY_FOUNDED_YEAR',
            'type' => 'varchar',
            'len' => 5,
            'comment' => 'company founded year',
            'reportable' => false,
        ],
        'hint_account_facebook_handle' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_facebook_handle',
            'vname' => 'LBL_HINT_COMPANY_FACEBOOK',
            'label' => 'LBL_HINT_COMPANY_FACEBOOK',
            'type' => 'url',
            'len' => 120,
            'comment' => 'company facebook',
            'reportable' => false,
        ],
        'hint_account_twitter_handle' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_twitter_handle',
            'vname' => 'LBL_HINT_COMPANY_TWITTER',
            'label' => 'LBL_HINT_COMPANY_TWITTER',
            'type' => 'url',
            'len' => 120,
            'comment' => 'company twitter',
            'reportable' => false,
        ],
        'hint_account_logo' => [
            'name' => 'hint_account_logo',
            'vname' => 'LBL_HINT_COMPANY_LOGO',
            'label' => 'LBL_HINT_COMPANY_LOGO',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'company logo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_contact_pic' => [
            'name' => 'hint_contact_pic',
            'vname' => 'LBL_HINT_CONTACT_PIC',
            'label' => 'LBL_HINT_CONTACT_PIC',
            'type' => 'text',
            'comment' => 'Hint Contact logo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_photo' => [
            'name' => 'hint_photo',
            'vname' => 'LBL_HINT_PHOTO',
            'label' => 'LBL_HINT_PHOTO',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'person photo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_phone_1' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_phone_1',
            'vname' => 'LBL_HINT_PHONE_1',
            'label' => 'LBL_HINT_PHONE_1',
            'type' => 'varchar',
            'len' => 15,
            'comment' => 'extra phone field',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_phone_2' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_phone_2',
            'vname' => 'LBL_HINT_PHONE_2',
            'label' => 'LBL_HINT_PHONE_2',
            'type' => 'varchar',
            'len' => 15,
            'comment' => 'extra phone field',
            'pii' => true,
            'audited' => true,
            'reportable' => false,
        ],
        'hint_account_website' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_website',
            'vname' => 'LBL_HINT_COMPANY_WEBSITE',
            'label' => 'LBL_HINT_COMPANY_WEBSITE',
            'type' => 'url',
            'len' => 255,
            'comment' => 'company website',
            'reportable' => false,
        ],
        'hint_account_naics_code_lbl' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_naics_code_lbl',
            'vname' => 'LBL_HINT_COMPANY_NAICS_CODE_LABEL',
            'label' => 'LBL_HINT_COMPANY_NAICS_CODE_LABEL',
            'type' => 'varchar',
            'len' => 170,
            'comment' => 'NAICS Code',
            'reportable' => false,
        ],
        'hint_account_sic_code_label' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_sic_code_label',
            'vname' => 'LBL_HINT_COMPANY_SIC_CODE_LABEL',
            'label' => 'LBL_HINT_COMPANY_SIC_CODE_LABEL',
            'type' => 'varchar',
            'len' => 120,
            'comment' => 'SIC Code',
            'reportable' => false,
        ],
        'hint_account_fiscal_year_end' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_fiscal_year_end',
            'vname' => 'LBL_HINT_COMPANY_FISCAL_YEAR_END',
            'label' => 'LBL_HINT_COMPANY_FISCAL_YEAR_END',
            'type' => 'varchar',
            'len' => 5,
            'comment' => 'FY End',
            'reportable' => false,
        ],
        'hint_account_annual_revenue' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_annual_revenue',
            'vname' => 'LBL_HINT_COMPANY_ANNUAL_REVENUE',
            'label' => 'LBL_HINT_COMPANY_ANNUAL_REVENUE',
            'type' => 'varchar',
            'len' => 25,
            'comment' => 'Annual Rev',
            'reportable' => false,
        ],
        'geocode_status' => [
            'studio' => hasMapsLicense() ? [
                'editField' => true,
                'recordview' => true,
                'previewview' => false,
                'recorddashletview' => false,
                'listview' => false,
                'wirelesseditview' => false,
                'wirelesslistview' => false,
                'wirelessdetailview' => false,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ] : false,
            'name' => 'geocode_status',
            'vname' => 'LBL_MAPS_GEOCODE_STATUS',
            'label' => 'LBL_MAPS_GEOCODE_STATUS',
            'type' => 'geocodestatus',
            'len' => 255,
            'comment' => '',
            'dbType' => 'varchar',
            'licenseFilter' => ['MAPS'],
            'readonly' => true,
            'reportable' => false,
        ],
        'prospect_lists' => [
            'name' => 'prospect_lists',
            'type' => 'link',
            'relationship' => 'prospect_list_contacts',
            'module' => 'ProspectLists',
            'source' => 'non-db',
            'vname' => 'LBL_PROSPECT_LIST',
        ],
        'sync_contact' => [
            'massupdate' => false,
            'name' => 'sync_contact',
            'vname' => 'LBL_SYNC_CONTACT',
            'type' => 'bool',
            'source' => 'non-db',
            'comment' => 'Synch to outlook?  (Meta-Data only)',
            'studio' => 'true',
            'link' => 'user_sync',
            'rname' => 'id',
            'rname_exists' => true,
        ],
        'market_interest_prediction_score' => [
            'name' => 'market_interest_prediction_score',
            'vname' => 'LBL_MARKET_INTEREST_PREDICTION',
            'type' => 'enum',
            'help' => 'Sugar Predict score',
            'options' => 'market_interest_prediction_dom',
            'default' => '',
            'readonly' => true,
            'massupdate' => false,
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => true,
            'duplicate_merge' => true,
        ],
        'market_score' => [
            'name' => 'market_score',
            'vname' => 'LBL_MARKET_SCORE',
            'type' => 'int',
            'help' => 'Score based on Market profile',
            'readonly' => true,
            'massupdate' => false,
            'required' => false,
            'reportable' => true,
            'audited' => false,
            'importable' => true,
            'duplicate_merge' => true,
            'enable_range_search' => true,
        ],
        // Marketo Fields
        'mkto_sync' => [
            'name' => 'mkto_sync',
            'vname' => 'LBL_MKTO_SYNC',
            'type' => 'bool',
            'default' => '0',
            'comment' => 'Should the Lead be synced to Marketo',
            'massupdate' => true,
            'audited' => true,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'true',
        ],
        'mkto_id' => [
            'name' => 'mkto_id',
            'vname' => 'LBL_MKTO_ID',
            'comment' => 'Associated Marketo Lead ID',
            'type' => 'int',
            'default' => null,
            'audited' => true,
            'mass_update' => false,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'false',
        ],
        'mkto_lead_score' => [
            'name' => 'mkto_lead_score',
            'vname' => 'LBL_MKTO_LEAD_SCORE',
            'comment' => null,
            'type' => 'int',
            'default_value' => null,
            'audited' => true,
            'mass_update' => false,
            'duplicate_merge' => true,
            'reportable' => true,
            'importable' => 'true',
        ],
        'entry_source' => [
            'name' => 'entry_source',
            'vname' => 'LBL_ENTRY_SOURCE',
            'type' => 'enum',
            'function' => 'getSourceTypes',
            'function_bean' => 'Contacts',
            'len' => '255',
            'default' => 'internal',
            'comment' => 'Determines if a record was created internal to the system or external to the system',
            'readonly' => true,
            'studio' => false,
            'processes' => true,
            'reportable' => true,
        ],
        // site_user_id is used as an analytics id
        'site_user_id' => [
            'name' => 'site_user_id',
            'vname' => 'LBL_SITE_USER_ID',
            'type' => 'varchar',
            'len' => '64',
            'reportable' => false,
            'importable' => false,
            'studio' => false,
            'readonly' => true,
        ],
        'dri_workflows' => [
            'name' => 'dri_workflows',
            'vname' => 'LBL_DRI_WORKFLOWS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow',
            'relationship' => 'dri_workflow_contacts',
            'module' => 'DRI_Workflows',
        ],
    ],
    'indices' => [
        [
            'name' => 'idx_contacts_del_last',
            'type' => 'index',
            'fields' => ['deleted', 'last_name'],
        ],
        [
            'name' => 'idx_cont_del_last_dm',
            'type' => 'index',
            'fields' => ['deleted', 'last_name', 'date_modified'],
        ],
        [
            'name' => 'idx_cont_del_reports',
            'type' => 'index',
            'fields' => ['deleted', 'reports_to_id', 'last_name'],
        ],
        [
            'name' => 'idx_reports_to_id',
            'type' => 'index',
            'fields' => [
                'deleted',
                'reports_to_id',
                'id',
            ],
        ],
        [
            'name' => 'idx_del_id_user',
            'type' => 'index',
            'fields' => ['deleted', 'id', 'assigned_user_id'],
        ],
        ['name' => 'idx_contact_title', 'type' => 'index', 'fields' => ['title']],
        [
            'name' => 'idx_contact_mkto_id',
            'type' => 'index',
            'fields' => ['mkto_id'],
        ],
        [
            'name' => 'idx_contacts_del_businesscenter',
            'type' => 'index',
            'fields' => [
                'deleted',
                'business_center_id',
            ],
        ],
        [
            'name' => 'idx_cont_portal_active',
            'type' => 'index',
            'fields' => ['portal_name', 'portal_active', 'deleted'],
        ],
    ],
    'relationships' => [
        'contact_direct_reports' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Contacts',
            'rhs_table' => 'contacts',
            'rhs_key' => 'reports_to_id',
            'relationship_type' => 'one-to-many',
        ],
        'contact_leads' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Leads',
            'rhs_table' => 'leads',
            'rhs_key' => 'contact_id',
            'relationship_type' => 'one-to-many',
        ],
        'contact_notes' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'contact_id',
            'relationship_type' => 'one-to-many',
            'relationship_class' => 'ContactNotesRelationship',
            'relationship_file' => 'data/Relationships/ContactNotesRelationship.php',
        ],
        'contact_messages' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Messages',
            'rhs_table' => 'messages',
            'rhs_key' => 'contact_id',
            'relationship_type' => 'one-to-many',
        ],
        'contact_notes_parent' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Contacts',
        ],
        'contact_calls_parent' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Contacts',
        ],
        'contact_meetings_parent' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Contacts',
        ],
        'contact_tasks' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'contact_id',
            'relationship_type' => 'one-to-many',
        ],
        'contact_tasks_parent' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Contacts',
        ],
        'contacts_assigned_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Contacts',
            'rhs_table' => 'contacts',
            'rhs_key' => 'assigned_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'contacts_modified_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Contacts',
            'rhs_table' => 'contacts',
            'rhs_key' => 'modified_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'contacts_created_by' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Contacts',
            'rhs_table' => 'contacts',
            'rhs_key' => 'created_by',
            'relationship_type' => 'one-to-many',
        ],
        'contact_products' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Products',
            'rhs_table' => 'products',
            'rhs_key' => 'contact_id',
            'relationship_type' => 'one-to-many',
        ],
        'contact_campaign_log' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'CampaignLog',
            'rhs_table' => 'campaign_log',
            'rhs_key' => 'target_id',
            'relationship_type' => 'one-to-many',
        ],
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$and' => [
                        ['first_name' => ['$starts' => '$first_name']],
                        ['last_name' => ['$starts' => '$last_name']],
                        ['accounts.id' => ['$equals' => '$account_id']],
                        ['dnb_principal_id' => ['$equals' => '$dnb_principal_id']],
                    ],
                ],
            ],
            'ranking_fields' => [
                [
                    'in_field_name' => 'account_id',
                    'dupe_field_name' => 'account_id',
                ],
                [
                    'in_field_name' => 'last_name',
                    'dupe_field_name' => 'last_name',
                ],
                [
                    'in_field_name' => 'first_name',
                    'dupe_field_name' => 'first_name',
                ],
            ],
        ],
    ],
    // This enables optimistic locking for Saves From EditView
    'optimistic_locking' => true,
    'uses' => [
        'default',
        'assignable',
        'team_security',
        'person',
        'audit',
        'external_source',
        'customer_journey_parent',
    ],
    'portal_visibility' => [
        'class' => 'Contacts',
        'links' => [
            'Accounts' => 'accounts',
        ],
    ],
];

VardefManager::createVardef(
    'Contacts',
    'Contact'
);

//boost value for full text search
$dictionary['Contact']['fields']['first_name']['full_text_search']['boost'] = 1.99;
$dictionary['Contact']['fields']['last_name']['full_text_search']['boost'] = 1.97;
$dictionary['Contact']['fields']['email']['full_text_search']['boost'] = 1.95;
$dictionary['Contact']['fields']['phone_home']['full_text_search']['boost'] = 1.10;
$dictionary['Contact']['fields']['phone_mobile']['full_text_search']['boost'] = 1.09;
$dictionary['Contact']['fields']['phone_work']['full_text_search']['boost'] = 1.08;
$dictionary['Contact']['fields']['phone_other']['full_text_search']['boost'] = 1.07;
$dictionary['Contact']['fields']['phone_fax']['full_text_search']['boost'] = 1.06;
$dictionary['Contact']['fields']['description']['full_text_search']['boost'] = 0.71;
$dictionary['Contact']['fields']['primary_address_street']['full_text_search']['boost'] = 0.33;
$dictionary['Contact']['fields']['alt_address_street']['full_text_search']['boost'] = 0.32;

// enable assistant_phone for full text search
$dictionary['Contact']['fields']['assistant_phone']['full_text_search'] = [
    'enabled' => true,
    'searchable' => true,
    'boost' => 1.05,
];
