<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['Case'] = [
    'table' => 'cases',
    'audited' => true,
    'escalatable' => true,
    'color' => 'orange',
    'icon' => 'sicon-case-lg',
    'activity_enabled' => true,
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'duplicate_merge' => true,
    'console_tab_badges' => true,
    'comment' => 'Cases are issues or problems that a customer asks a support representative to resolve',
    'change_timer_fields' => [
        'status',
        'assigned_user_id',
    ],
    'fields' => [
        'account_name' => [
            'name' => 'account_name',
            'rname' => 'name',
            'id_name' => 'account_id',
            'vname' => 'LBL_ACCOUNT_NAME',
            'type' => 'relate',
            'related_fields' => [
                'account_id',
            ],
            'link' => 'accounts',
            'table' => 'accounts',
            'join_name' => 'accounts',
            'isnull' => 'true',
            'module' => 'Accounts',
            'dbType' => 'varchar',
            'len' => 100,
            'source' => 'non-db',
            'unified_search' => true,
            'comment' => 'The name of the account represented by the account_id field',
            'required' => true,
            'importable' => 'required',
            'exportable' => true,
            'studio' => [
                'portalrecordview' => false,
                'portallistview' => false,
            ],
        ],
        'account_id' => [
            'name' => 'account_id',
            'type' => 'relate',
            'dbType' => 'id',
            'rname' => 'id',
            'module' => 'Accounts',
            'id_name' => 'account_id',
            'reportable' => false,
            'vname' => 'LBL_ACCOUNT_ID',
            'audited' => true,
            'massupdate' => false,
            'comment' => 'The account to which the case is associated',
        ],
        'service_level' => [
            'name' => 'service_level',
            'rname' => 'service_level',
            'id_name' => 'account_id',
            'vname' => 'LBL_SERVICE_LEVEL',
            'type' => 'relate',
            'link' => 'accounts',
            'table' => 'accounts',
            'join_name' => 'accounts',
            'isnull' => 'true',
            'module' => 'Accounts',
            'source' => 'non-db',
            'reportable' => false,
            'massupdate' => false,
            'comment' => 'Service level of the associated account of case',
            'readonly' => true,
        ],
        'business_center_name' => [
            'name' => 'business_center_name',
            'rname' => 'name',
            'id_name' => 'business_center_id',
            'vname' => 'LBL_BUSINESS_CENTER_NAME',
            'type' => 'relate',
            'link' => 'business_centers',
            'table' => 'business_centers',
            'join_name' => 'business_centers',
            'isnull' => 'true',
            'module' => 'BusinessCenters',
            'dbType' => 'varchar',
            'len' => 255,
            'source' => 'non-db',
            'unified_search' => true,
            'comment' => 'The name of the business center represented by the business_center_id field',
            'required' => false,
        ],
        'business_center_id' => [
            'name' => 'business_center_id',
            'type' => 'relate',
            'dbType' => 'id',
            'rname' => 'id',
            'module' => 'BusinessCenters',
            'id_name' => 'business_center_id',
            'reportable' => false,
            'vname' => 'LBL_BUSINESS_CENTER_ID',
            'audited' => true,
            'massupdate' => false,
            'comment' => 'The business center to which the case is associated',
        ],
        'business_centers' => [
            'name' => 'business_centers',
            'type' => 'link',
            'relationship' => 'business_center_cases',
            'link_type' => 'one',
            'side' => 'right',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER',
        ],
        'source' => [
            'name' => 'source',
            'vname' => 'LBL_SOURCE',
            'type' => 'enum',
            'options' => 'cases_source_dom',
            'len' => 255,
            'comment' => 'An indicator of how the case was entered (ex: via web, email, etc.)',
        ],
        'status' => [
            'name' => 'status',
            'vname' => 'LBL_STATUS',
            'type' => 'enum',
            'options' => 'case_status_dom',
            'len' => 100,
            'audited' => true,
            'comment' => 'The status of the case',
            'merge_filter' => 'enabled',
            'sortable' => true,
        ],
        'priority' => [
            'name' => 'priority',
            'vname' => 'LBL_PRIORITY',
            'type' => 'enum',
            'options' => 'case_priority_dom',
            'len' => 100,
            'audited' => true,
            'comment' => 'The priority of the case',
            'merge_filter' => 'enabled',
            'sortable' => true,
        ],
        'resolution' => [
            'name' => 'resolution',
            'vname' => 'LBL_RESOLUTION',
            'type' => 'text',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 0.65,
            ],
            'comment' => 'The resolution of the case',
        ],
        'request_close' => [
            'name' => 'request_close',
            'type' => 'bool',
            'default' => null,
            'readonly' => true,
            'audited' => true,
            'reportable' => true,
            'vname' => 'LBL_REQUEST_CLOSE',
            'comment' => 'The request close status of the case',
        ],
        'request_close_date' => [
            'name' => 'request_close_date',
            'type' => 'datetimecombo',
            'default' => null,
            'readonly' => true,
            'audited' => true,
            'reportable' => true,
            'vname' => 'LBL_REQUEST_CLOSE_DATE',
            'comment' => 'The date/time that the request close was initiated',
        ],
        'portal_viewable' => [
            'name' => 'portal_viewable',
            'vname' => 'LBL_SHOW_IN_PORTAL',
            'type' => 'bool',
            'default' => 1,
            'reportable' => false,
        ],
        'changetimers' => [
            'name' => 'changetimers',
            'type' => 'link',
            'relationship' => 'cases_changetimers',
            'source' => 'non-db',
            'vname' => 'LBL_CHANGETIMERS',
        ],
        'widget_status' => [
            'name' => 'widget_status',
            'vname' => 'LBL_WIDGET_STATUS',
            'type' => 'widget',
            'multiline' => false,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
            'source' => 'non-db',
            'console' => [
                'name' => 'status',
                'label' => 'LBL_WIDGET_STATUS',
                'type' => 'case-status',
            ],
        ],
        'purchases' => [
            'name' => 'purchases',
            'type' => 'link',
            'relationship' => 'cases_purchases',
            'source' => 'non-db',
            'vname' => 'LBL_PURCHASES_SUBPANEL_TITLE',
        ],
        'messages' => [
            'name' => 'messages',
            'type' => 'link',
            'relationship' => 'case_messages',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'escalations' => [
            'name' => 'escalations',
            'type' => 'link',
            'relationship' => 'case_escalations',
            'module' => 'Escalations',
            'bean_name' => 'Escalation',
            'source' => 'non-db',
            'vname' => 'LBL_ESCALATIONS',
        ],
        'external_users' => [
            'name' => 'external_users',
            'type' => 'link',
            'relationship' => 'external_users_cases',
            'source' => 'non-db',
            'vname' => 'LBL_EXTERNAL_USERS',
        ],
        'tasks' => [
            'name' => 'tasks',
            'type' => 'link',
            'relationship' => 'case_tasks',
            'source' => 'non-db',
            'vname' => 'LBL_TASKS',
        ],
        'notes' => [
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'case_notes',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'meetings' => [
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'case_meetings',
            'bean_name' => 'Meeting',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
        ],
        'emails' => [
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'emails_cases_rel',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
        ],
        'archived_emails' => [
            'name' => 'archived_emails',
            'type' => 'link',
            'link_class' => 'CaseEmailsLink',
            'link' => 'contacts',
            'module' => 'Emails',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'link_type' => 'many',
            'relationship' => '',
            'hideacl' => true,
            'readonly' => true,
        ],
        'documents' => [
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_cases',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
        ],
        'calls' => [
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'case_calls',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
        ],
        'bugs' => [
            'name' => 'bugs',
            'type' => 'link',
            'relationship' => 'cases_bugs',
            'source' => 'non-db',
            'vname' => 'LBL_BUGS',
        ],
        'contacts' => [
            'name' => 'contacts',
            'type' => 'link',
            'relationship' => 'contacts_cases',
            'source' => 'non-db',
            'vname' => 'LBL_CONTACTS',
        ],
        'accounts' => [
            'name' => 'accounts',
            'type' => 'link',
            'relationship' => 'account_cases',
            'link_type' => 'one',
            'side' => 'right',
            'source' => 'non-db',
            'vname' => 'LBL_ACCOUNT',
        ],
        'project' => [
            'name' => 'project',
            'type' => 'link',
            'relationship' => 'projects_cases',
            'source' => 'non-db',
            'vname' => 'LBL_PROJECTS',
        ],
        'kbcontents' => [
            'name' => 'kbcontents',
            'type' => 'link',
            'vname' => 'LBL_KBCONTENTS_SUBPANEL_TITLE',
            'relationship' => 'relcases_kbcontents',
            'source' => 'non-db',
            'link_type' => 'many',
            'side' => 'right',
        ],
        'primary_contact_name' => [
            'name' => 'primary_contact_name',
            'rname' => 'name',
            'db_concat_fields' => [
                0 => 'first_name',
                1 => 'last_name',
            ],
            'related_fields' => [
                'primary_contact_id',
            ],
            'source' => 'non-db',
            'len' => '255',
            'group' => 'primary_contact_name',
            'vname' => 'LBL_PRIMARY_CONTACT_NAME',
            'reportable' => true,
            'id_name' => 'primary_contact_id',
            'join_name' => 'case_contact',
            'type' => 'relate',
            'module' => 'Contacts',
            'link' => 'case_contact',
            'table' => 'contacts',
            'audited' => true,
            'studio' => [
                'portal' => [
                    'portalrecordview' => true,
                    'portallistview' => false,
                ],
            ],
        ],
        'primary_contact_id' => [
            'name' => 'primary_contact_id',
            'type' => 'id',
            'group' => 'primary_contact_name',
            'reportable' => true,
            'vname' => 'LBL_PRIMARY_CONTACT_ID',
            'audited' => true,
        ],
        'case_contact' => [
            'name' => 'case_contact',
            'type' => 'link',
            'relationship' => 'contact_cases',
            'source' => 'non-db',
            'side' => 'right',
            'vname' => 'LBL_CONTACT',
            'module' => 'Contacts',
            'bean_name' => 'Contact',
            'id_name' => 'primary_contact_id',
            'link_type' => 'one',
            'audited' => true,
            'populate_list' => [
                'account_id',
                'account_name',
            ],
        ],
        'attachments' => [
            'name' => 'attachments',
            'vname' => 'LBL_ATTACHMENTS',
            'type' => 'link',
            'relationship' => 'case_attachments',
            'module' => 'Notes',
            'bean_name' => 'Note',
            'source' => 'non-db',
        ],
        'attachment_list' => [
            'name' => 'attachment_list',
            'links' => [
                'attachments',
            ],
            'order_by' => 'name:asc',
            'source' => 'non-db',
            'studio' => [
                'recordview' => true,
                'previewview' => true,
                'recorddashletview' => true,
                'visible' => false,
            ],
            'type' => 'collection',
            'vname' => 'LBL_ATTACHMENTS',
            'reportable' => false,
            'hideacl' => true,
            'filter' => [
                [
                    'attachment_flag' => '1',
                ],
            ],
        ],
        'action_claim' => [
            'name' => 'action_claim',
            'source' => 'non-db',
            'vname' => 'LBL_ACTION_CLAIM',
            'type' => 'actionbutton',
            'massupdate' => false,
            'hidemassupdate' => false,
            'no_default' => false,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => 1,
            'audited' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'studio' => [
                'editField' => true,
                'recordview' => true,
                'previewview' => true,
                'recorddashletview' => true,
                'listview' => false,
                'wirelesseditview' => true,
                'wirelesslistview' => false,
                'wirelessdetailview' => true,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ],
            'options' => '{"settings":{"type":"YnV0dG9u","size":"ZGVmYXVsdA==","showFieldLabel":false,"showInRecordHeader":true,"hideOnEdit":false,"displayOnFocusDashboard":true},"actionMenu":{"orderNumber":1,"listView":true,"recordView":true,"recordViewDashlet":true,"focusDashboardHeader":true,"subpanels":true},"buttons":{"52d8b90b-9ae1-4dd5-a2fc-bfb3dec0782c":{"active":true,"buttonId":"NTJkOGI5MGItOWFlMS00ZGQ1LWEyZmMtYmZiM2RlYzA3ODJj","orderNumber":0,"properties":{"label":"TEJMX0NMQUlNX0JVVFRPTl9URVhU","description":"","showLabel":true,"showIcon":false,"colorScheme":"cHJpbWFyeQ==","icon":"c2ljb24tc2V0dGluZ3M=","isDependent":true,"stopOnError":false,"formula":"bm90KGlzT3duZXIoKSk="},"actions":{"23cea3f5-9b41-499c-bbd2-e0d6e467f25a":{"actionType":"YXNzaWduLXJlY29yZA==","orderNumber":0,"properties":{"id":"","name":"","assignToCurrentUser":true}}}}}}',
        ],
        'action_close' => [
            'name' => 'action_close',
            'source' => 'non-db',
            'vname' => 'LBL_ACTION_CLOSE',
            'type' => 'actionbutton',
            'massupdate' => false,
            'hidemassupdate' => false,
            'no_default' => false,
            'importable' => true,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => 1,
            'audited' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'studio' => [
                'editField' => true,
                'recordview' => true,
                'previewview' => true,
                'recorddashletview' => true,
                'listview' => false,
                'wirelesseditview' => true,
                'wirelesslistview' => false,
                'wirelessdetailview' => true,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ],
            'options' => '{"settings":{"type":"YnV0dG9u","size":"ZGVmYXVsdA==","showFieldLabel":false,"showInRecordHeader":true,"hideOnEdit":false,"displayOnFocusDashboard":true},"actionMenu":{"orderNumber":2,"listView":true,"recordView":true,"recordViewDashlet":true,"focusDashboardHeader":true,"subpanels":true},"buttons":{"2f7d92f4-133f-4f66-aebf-c84e34575bd3":{"active":true,"buttonId":"MmY3ZDkyZjQtMTMzZi00ZjY2LWFlYmYtYzg0ZTM0NTc1YmQz","orderNumber":0,"properties":{"label":"TEJMX0NMT1NFX0JVVFRPTl9URVhU","description":"","showLabel":true,"showIcon":false,"colorScheme":"cHJpbWFyeQ==","icon":"","isDependent":true,"stopOnError":false,"formula":"bm90KGVxdWFsKCRzdGF0dXMsICJDbG9zZWQiKSk="},"actions":{"85baf0f5-ad48-4159-b22e-796a206e934e":{"actionType":"dXBkYXRlLXJlY29yZA==","orderNumber":0,"properties":{"fieldsToBeUpdated":{"status":{"fieldName":"c3RhdHVz","isCalculated":false,"formula":"","value":{"status":"Q2xvc2Vk"}}},"autoSave":true}}}}}}',
        ],
        'action_unassign' => [
            'name' => 'action_unassign',
            'source' => 'non-db',
            'vname' => 'LBL_ACTION_UNASSIGN',
            'type' => 'actionbutton',
            'massupdate' => false,
            'hidemassupdate' => false,
            'no_default' => false,
            'importable' => false,
            'duplicate_merge' => 'enabled',
            'duplicate_merge_dom_value' => 1,
            'audited' => false,
            'reportable' => false,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'studio' => [
                'editField' => true,
                'recordview' => true,
                'previewview' => true,
                'recorddashletview' => true,
                'listview' => false,
                'wirelesseditview' => true,
                'wirelesslistview' => false,
                'wirelessdetailview' => true,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ],
            'options' => '{"settings":{"type":"YnV0dG9u","size":"ZGVmYXVsdA==","showFieldLabel":false,"showInRecordHeader":false,"hideOnEdit":false,"displayOnFocusDashboard":false},"actionMenu":{"orderNumber":"MQ==","listView":true,"recordView":true,"recordViewDashlet":true,"focusDashboardHeader":true,"subpanels":true},"buttons":{"f2b0c260-fd7c-4130-a5d5-de9b9bc9717b":{"active":true,"buttonId":"ZjJiMGMyNjAtZmQ3Yy00MTMwLWE1ZDUtZGU5YjliYzk3MTdi","orderNumber":0,"properties":{"label":"TEJMX1VOQVNTSUdOX0JVVFRPTl9URVhU","description":"","showLabel":true,"showIcon":false,"colorScheme":"cHJpbWFyeQ==","icon":"c2ljb24tc2V0dGluZ3M=","isDependent":true,"stopOnError":false,"formula":"aXNBc3NpZ25lZCgp"},"actions":{"9d083eae-199a-43b7-b206-b36e474d1c94":{"actionType":"YXNzaWduLXJlY29yZA==","orderNumber":0,"properties":{"id":"","name":"","assignToCurrentUser":false},"id":"OWQwODNlYWUtMTk5YS00M2I3LWIyMDYtYjM2ZTQ3NGQxYzk0"}}}}}',
        ],
        'dri_workflows' => [
            'name' => 'dri_workflows',
            'vname' => 'LBL_DRI_WORKFLOWS',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'left',
            'bean_name' => 'DRI_Workflow',
            'relationship' => 'dri_workflow_cases',
            'module' => 'DRI_Workflows',
        ],
    ],
    'indices' => [
        [
            'name' => 'idx_case_del_nam_dm',
            'type' => 'index',
            'fields' => [
                'deleted',
                'name',
                'date_modified',
                'id',
                'team_set_id',
            ],
        ],
        [
            'name' => 'idx_account_id',
            'type' => 'index',
            'fields' => [
                'deleted',
                'account_id',
            ],
        ],
        [
            'name' => 'idx_cases_stat_del',
            'type' => 'index',
            'fields' => [
                'assigned_user_id',
                'status',
                'deleted',
            ],
        ],
        [
            'name' => 'idx_cases_del_prim_contact_id',
            'type' => 'index',
            'fields' => [
                'primary_contact_id',
                'deleted',
            ],
        ],
        [
            'name' => 'idx_cases_del_businesscenter',
            'type' => 'index',
            'fields' => [
                'deleted',
                'business_center_id',
            ],
        ],
    ],
    'relationships' => [
        'case_calls' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Cases',
        ],
        'case_tasks' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Cases',
        ],
        'case_notes' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_columns' => [
                'parent_type' => 'Cases',
                'attachment_flag' => 0,
            ],
        ],
        'case_messages' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Messages',
            'rhs_table' => 'messages',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Cases',
        ],
        'case_escalations' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Escalations',
            'rhs_table' => 'escalations',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Cases',
        ],
        'case_meetings' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Cases',
        ],
        'case_emails' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Emails',
            'rhs_table' => 'emails',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Cases',
        ],
        'cases_assigned_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Cases',
            'rhs_table' => 'cases',
            'rhs_key' => 'assigned_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'cases_modified_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Cases',
            'rhs_table' => 'cases',
            'rhs_key' => 'modified_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'cases_created_by' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Cases',
            'rhs_table' => 'cases',
            'rhs_key' => 'created_by',
            'relationship_type' => 'one-to-many',
        ],
        'contact_cases' => [
            'lhs_module' => 'Contacts',
            'lhs_table' => 'contacts',
            'lhs_key' => 'id',
            'rhs_module' => 'Cases',
            'rhs_table' => 'cases',
            'rhs_key' => 'primary_contact_id',
            'relationship_type' => 'one-to-many',
        ],
        'case_attachments' => [
            'lhs_module' => 'Cases',
            'lhs_table' => 'cases',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_class' => 'AttachmentRelationship',
            'relationship_file' => 'data/Relationships/AttachmentRelationship.php',
            'relationship_role_columns' => [
                'parent_type' => 'Cases',
                'attachment_flag' => 1,
            ],
        ],
    ],
    'acls' => [
        'SugarACLStatic' => true,
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$and' => [
                        [
                            'name' => [
                                '$starts' => '$name',
                            ],
                        ],
                        [
                            'status' => [
                                '$not_equals' => 'Closed',
                            ],
                        ],
                        [
                            'account_id' => [
                                '$equals' => '$account_id',
                            ],
                        ],
                    ],
                ],
            ],
            'ranking_fields' => [
                [
                    'in_field_name' => 'name',
                    'dupe_field_name' => 'name',
                ],
                [
                    'in_field_name' => 'account_id',
                    'dupe_field_name' => 'account_id',
                ],
            ],
        ],
    ],

    // This enables optimistic locking for Saves From EditView
    'optimistic_locking' => true,
    'portal_visibility' => [
        'class' => 'Cases',
        'links' => [
            'Accounts' => 'accounts',
            'Contacts' => 'contacts',
        ],
    ],
];

VardefManager::createVardef('Cases', 'Case', [
    'default',
    'assignable',
    'team_security',
    'issue',
    'external_source',
    'audit',
    'sla_fields',
    'escalatable',
    'customer_journey_parent',
], 'case');

//jc - adding for refactor for import to not use the required_fields array
//defined in the field_arrays.php file
$dictionary['Case']['fields']['name']['importable'] = 'required';

//need to handle large mail
$dictionary['Case']['fields']['description']['dbtype'] = 'longtext';

//boost value for full text search
$dictionary['Case']['fields']['name']['full_text_search']['boost'] = 1.53;
$dictionary['Case']['fields']['case_number']['full_text_search']['boost'] = 1.29;
$dictionary['Case']['fields']['description']['full_text_search']['boost'] = 0.66;
$dictionary['Case']['fields']['work_log']['full_text_search']['boost'] = 0.64;
