<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
$dictionary['CJ_Form'] = [
    'table' => 'cj_forms',
    'audited' => true,
    'unified_search' => false,
    'icon' => 'sicon-customer-journey-lg',
    'duplicate_merge' => true,
    'activity_enabled' => false,
    'comment' => 'CJ_Form',
    'optimistic_lock' => true,
    'fields' => [
        'trigger_event' => [
            'name' => 'trigger_event',
            'vname' => 'LBL_TRIGGER_EVENT',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'cj_forms_trigger_event_list',
            'type' => 'trigger-event',
            'dbType' => 'varchar',
        ],
        'action_type' => [
            'name' => 'action_type',
            'vname' => 'LBL_ACTION_TYPE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'cj_forms_action_type_list',
            'type' => 'enum',
        ],
        'action_trigger_type' => [
            'name' => 'action_trigger_type',
            'vname' => 'LBL_ACTION_TRIGGER_TYPE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'cj_forms_action_trigger_type_list',
            'type' => 'enum',
            'visibility_grid' => [
                'trigger' => 'action_type',
                'values' => [
                    'create_record' => [
                        'manual_create',
                        'automatic_create',
                    ],
                    'update_record' => [
                        'manual_update',
                        'automatic_update',
                    ],
                ],
            ],
        ],
        'relationship' => [
            'name' => 'relationship',
            'vname' => 'LBL_RELATIONSHIP',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'json',
            'dbType' => 'text',
        ],
        'activity_module' => [
            'name' => 'activity_module',
            'vname' => 'LBL_ACTIVITY_MODULE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'enforced' => true,
            'calculated' => true,
            'formula' => 'related($activity_template_link, "activity_type")',
        ],
        'active' => [
            'name' => 'active',
            'vname' => 'LBL_ACTIVE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => true,
        ],
        'ignore_errors' => [
            'name' => 'ignore_errors',
            'vname' => 'LBL_IGNORE_ERRORS',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'bool',
            'default' => false,
        ],
        'populate_fields' => [
            'name' => 'populate_fields',
            'vname' => 'LBL_POPULATE_FIELDS',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => false,
            'massupdate' => false,
            'type' => 'text',
            'studio' => false,
        ],
        'select_to_email_address' => [
            'name' => 'select_to_email_address',
            'vname' => 'LBL_SELECT_TO_EMAIL_ADDRESS',
            'required' => false,
            'reportable' => false,
            'audited' => false,
            'importable' => false,
            'massupdate' => false,
            'type' => 'text',
            'studio' => false,
        ],
        'parent_id' => [
            'name' => 'parent_id',
            'vname' => 'LBL_PARENT_ID',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'parent_name' => [
            'name' => 'parent_name',
            'vname' => 'CJ_FORMS_LBL_PARENT_NAME',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'parent',
            'len' => 255,
            'source' => 'non-db',
            'options' => 'cj_forms_parent_type_list',
            'parent_type' => 'cj_forms_parent_type_list',
            'id_name' => 'parent_id',
            'type_name' => 'parent_type',
        ],
        'parent_type' => [
            'name' => 'parent_type',
            'vname' => 'LBL_PARENT_TYPE',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'parent_type',
            'len' => 255,
            'dbType' => 'varchar',
            'options' => 'cj_forms_parent_type_list',
            'parent_type' => 'cj_forms_parent_type_list',
        ],
        'display_activity_rsa_icon' => [
            'name' => 'display_activity_rsa_icon',
            'vname' => 'LBL_DISPLAY_ACTIVITY_RSA_ICON',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'cj_forms_display_rsa_icon',
            'type' => 'enum',
            'default' => 'yes',
        ],
        'activity_module' => [
            'name' => 'activity_module',
            'vname' => 'LBL_ACTIVITY_MODULE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'varchar',
            'len' => 255,
            'enforced' => true,
            'calculated' => true,
            'formula' => 'related($activity_template_link,"activity_type")',
        ],
        'activity_template_link' => [
            'name' => 'activity_template_link',
            'vname' => 'LBL_ACTIVITY_TEMPLATE_LINK',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Task_Template',
            'relationship' => 'dri_workflow_task_templates_flex_relate_cj_forms',
            'module' => 'DRI_Workflow_Task_Templates',
        ],
        'stage_template_link' => [
            'name' => 'stage_template_link',
            'vname' => 'LBL_STAGE_TEMPLATE_LINK',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_SubWorkflow_Template',
            'relationship' => 'dri_subworkflow_templates_flex_relate_cj_forms',
            'module' => 'DRI_SubWorkflow_Templates',
        ],
        'journey_template_link' => [
            'name' => 'journey_template_link',
            'vname' => 'LBL_JOURNEY_TEMPLATE_LINK',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => 'dri_workflow_templates_flex_relate_cj_forms',
            'module' => 'DRI_Workflow_Templates',
        ],
        'dri_workflow_template_id' => [
            'name' => 'dri_workflow_template_id',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
            'enforced' => true,
            'calculated' => true,
            'formula' => 'ifElse(equal($parent_type, "DRI_SubWorkflow_Templates"), related($stage_template_link, "dri_workflow_template_id"), ifElse(equal($parent_type, "DRI_Workflow_Templates"), related($journey_template_link, "id"), related($activity_template_link, "dri_workflow_template_id")))',
        ],
        'dri_workflow_template_name' => [
            'name' => 'dri_workflow_template_name',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'dri_workflow_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
            'link' => 'dri_workflow_template_link',
        ],
        'dri_workflow_template_link' => [
            'name' => 'dri_workflow_template_link',
            'vname' => 'LBL_DRI_WORKFLOW_TEMPLATE',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'DRI_Workflow_Template',
            'relationship' => 'cj_form_dri_workflow_templates',
            'module' => 'DRI_Workflow_Templates',
        ],
        'email_templates_id' => [
            'name' => 'email_templates_id',
            'vname' => 'LBL_EMAIL_TEMPLATES',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'email_templates_name' => [
            'name' => 'email_templates_name',
            'vname' => 'LBL_EMAIL_TEMPLATES',
            'required' => false,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'email_templates',
            'id_name' => 'email_templates_id',
            'sort_on' => 'name',
            'module' => 'EmailTemplates',
            'link' => 'email_templates_link',
        ],
        'email_templates_link' => [
            'name' => 'email_templates_link',
            'vname' => 'LBL_EMAIL_TEMPLATES',
            'source' => 'non-db',
            'type' => 'link',
            'side' => 'right',
            'bean_name' => 'EmailTemplate',
            'relationship' => 'cj_form_email_templates_emailtemplates',
            'module' => 'EmailTemplates',
        ],
        'main_trigger_type' => [
            'name' => 'main_trigger_type',
            'vname' => 'LBL_MAIN_TRIGGER_TYPE',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'len' => 100,
            'importable' => 'true',
            'massupdate' => false,
            'options' => 'cj_forms_main_trigger_type_list',
            'type' => 'enum',
        ],
        'module_trigger' => [
            'name' => 'module_trigger',
            'vname' => 'LBL_MODULE_TRIGGER',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'len' => 100,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'module-trigger',
            'dbType' => 'varchar',
            'options' => 'cj_forms_module_trigger_list',
        ],
        'field_trigger' => [
            'name' => 'field_trigger',
            'vname' => 'LBL_FIELD_TRIGGER',
            'required' => true,
            'reportable' => false,
            'audited' => false,
            'importable' => false,
            'massupdate' => false,
            'type' => 'field-trigger-filter',
            'dbType' => 'longtext',
            'moduleField' => 'module_trigger',
            'openBuildFilterView' => true,
        ],
        // Field when trigger type is Sugar Action To Smart Guide
        'smart_guide_template_id' => [
            'name' => 'smart_guide_template_id',
            'vname' => 'LBL_SMART_GUIDE_TEMPLATE',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'id',
        ],
        'smart_guide_template_name' => [
            'name' => 'smart_guide_template_name',
            'vname' => 'LBL_SMART_GUIDE_TEMPLATE',
            'required' => true,
            'reportable' => false,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'source' => 'non-db',
            'type' => 'relate',
            'rname' => 'name',
            'table' => 'dri_workflow_templates',
            'id_name' => 'smart_guide_template_id',
            'sort_on' => 'name',
            'module' => 'DRI_Workflow_Templates',
        ],
        'target_action' => [
            'name' => 'target_action',
            'vname' => 'LBL_CJ_TARGET',
            'required' => true,
            'reportable' => true,
            'audited' => true,
            'importable' => 'true',
            'massupdate' => false,
            'type' => 'text',
        ],
    ],
    'indices' => [
        'cj_forms_parent_id' => [
            'name' => 'cj_forms_parent_id',
            'type' => 'index',
            'fields' => [
                'parent_id',
            ],
        ],
        'idx_cj_forms_jry_tpl_id' => [
            'name' => 'idx_cj_forms_jry_tpl_id',
            'type' => 'index',
            'fields' => [
                'dri_workflow_template_id',
            ],
        ],
        'idx_cj_forms_em_tem_id' => [
            'name' => 'idx_cj_forms_em_tem_id',
            'type' => 'index',
            'fields' => [
                'email_templates_id',
            ],
        ],
    ],
    'relationships' => [
        'cj_form_email_templates_emailtemplates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'EmailTemplates',
            'lhs_table' => 'email_templates',
            'rhs_module' => 'CJ_Forms',
            'rhs_table' => 'cj_forms',
            'rhs_key' => 'email_templates_id',
        ],
        'cj_form_dri_workflow_templates' => [
            'relationship_type' => 'one-to-many',
            'lhs_key' => 'id',
            'lhs_module' => 'DRI_Workflow_Templates',
            'lhs_table' => 'dri_workflow_templates',
            'rhs_module' => 'CJ_Forms',
            'rhs_table' => 'cj_forms',
            'rhs_key' => 'dri_workflow_template_id',
        ],
    ],
    'duplicate_check' => [
        'enabled' => false,
    ],
    'acls' => [
        'SugarACLCustomerJourney' => true,
    ],
];

VardefManager::createVardef('CJ_Forms', 'CJ_Form', [
    'basic',
    'team_security',
]);


$dictionary['CJ_Form']['fields']['team_name']['dependency'] = 'or(equal($main_trigger_type, "smart_guide_to_sugar_action"), equal($main_trigger_type, "sugar_action_to_smart_guide"))';
