<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['BusinessCenter'] = [
    'table' => 'business_centers',
    'audited' => true,
    'color' => 'ocean',
    'icon' => 'sicon-business-centers-lg',
    'activity_enabled' => false,
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'duplicate_merge' => false,
    'comment' => 'Business operations center details',
    'fields' => [
        'timezone' => [
            'name' => 'timezone',
            'vname' => 'LBL_TIMEZONE',
            'type' => 'enum',
            'options' => 'timezone_dom',
            'comment' => 'Time Zone in which this Business Center operates',
            'required' => true,
            'audited' => true,
        ],
        'address_street' => [
            'name' => 'address_street',
            'vname' => 'LBL_ADDRESS_STREET',
            'type' => 'text',
            'dbType' => 'varchar',
            'len' => '150',
            'comment' => 'Address of this Business Center',
            'group' => 'address',
            'group_label' => 'LBL_ADDRESS',
            'merge_filter' => 'enabled',
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 0.26,
            ],
            'audited' => true,
        ],
        'address_city' => [
            'name' => 'address_city',
            'vname' => 'LBL_ADDRESS_CITY',
            'type' => 'varchar',
            'len' => '100',
            'comment' => 'City of this Business Center',
            'group' => 'address',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'address_state' => [
            'name' => 'address_state',
            'vname' => 'LBL_ADDRESS_STATE',
            'type' => 'varchar',
            'len' => '100',
            'group' => 'address',
            'comment' => 'State of this Business Center',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'address_postalcode' => [
            'name' => 'address_postalcode',
            'vname' => 'LBL_ADDRESS_POSTALCODE',
            'type' => 'varchar',
            'len' => '20',
            'group' => 'address',
            'comment' => 'Postal Code of this Business Center',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'address_country' => [
            'name' => 'address_country',
            'vname' => 'LBL_ADDRESS_COUNTRY',
            'type' => 'varchar',
            'group' => 'address',
            'comment' => 'Country of this Business Center',
            'merge_filter' => 'enabled',
            'audited' => true,
        ],
        'business_holidays' => [
            'name' => 'business_holidays',
            'type' => 'link',
            'relationship' => 'business_centers_holidays',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_HOLIDAYS',
            'module' => 'Holidays',
            'bean_name' => 'Holiday',
        ],
        'business_center_accounts' => [
            'name' => 'business_center_accounts',
            'type' => 'link',
            'relationship' => 'business_center_accounts',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER_ACCOUNTS_TITLE',
            'module' => 'Accounts',
            'bean_name' => 'Account',
        ],
        'business_center_cases' => [
            'name' => 'business_center_cases',
            'type' => 'link',
            'relationship' => 'business_center_cases',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER_CASES_TITLE',
            'module' => 'Cases',
            'bean_name' => 'aCase',
        ],
        'business_center_contacts' => [
            'name' => 'business_center_contacts',
            'type' => 'link',
            'relationship' => 'business_center_contacts',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER_CONTACTS_TITLE',
            'module' => 'Contacts',
            'bean_name' => 'Contact',
        ],
        'business_center_leads' => [
            'name' => 'business_center_leads',
            'type' => 'link',
            'relationship' => 'business_center_leads',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER_LEADS_TITLE',
            'module' => 'Leads',
            'bean_name' => 'Lead',
        ],
        'business_center_users' => [
            'name' => 'business_center_users',
            'type' => 'link',
            'relationship' => 'business_center_users',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER_USERS_TITLE',
            'module' => 'Users',
            'bean_name' => 'User',
        ],
        'geocode_status' => [
            'studio' => hasMapsLicense() ? [
                'editField' => true,
                'recordview' => true,
                'previewview' => false,
                'recorddashletview' => false,
                'listview' => false,
                'wirelesseditview' => false,
                'wirelesslistview' => false,
                'wirelessdetailview' => false,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ] : false,
            'name' => 'geocode_status',
            'vname' => 'LBL_MAPS_GEOCODE_STATUS',
            'label' => 'LBL_MAPS_GEOCODE_STATUS',
            'type' => 'geocodestatus',
            'len' => 255,
            'comment' => '',
            'dbType' => 'varchar',
            'licenseFilter' => ['MAPS'],
            'readonly' => true,
            'reportable' => false,
        ],
    ],
    'relationships' => [
        'business_center_accounts' => [
            'lhs_module' => 'BusinessCenters',
            'lhs_table' => 'business_centers',
            'lhs_key' => 'id',
            'rhs_module' => 'Accounts',
            'rhs_table' => 'accounts',
            'rhs_key' => 'business_center_id',
            'relationship_type' => 'one-to-many',
        ],
        'business_center_cases' => [
            'lhs_module' => 'BusinessCenters',
            'lhs_table' => 'business_centers',
            'lhs_key' => 'id',
            'rhs_module' => 'Cases',
            'rhs_table' => 'cases',
            'rhs_key' => 'business_center_id',
            'relationship_type' => 'one-to-many',
        ],
        'business_center_contacts' => [
            'lhs_module' => 'BusinessCenters',
            'lhs_table' => 'business_centers',
            'lhs_key' => 'id',
            'rhs_module' => 'Contacts',
            'rhs_table' => 'contacts',
            'rhs_key' => 'business_center_id',
            'relationship_type' => 'one-to-many',
        ],
        'business_center_leads' => [
            'lhs_module' => 'BusinessCenters',
            'lhs_table' => 'business_centers',
            'lhs_key' => 'id',
            'rhs_module' => 'Leads',
            'rhs_table' => 'leads',
            'rhs_key' => 'business_center_id',
            'relationship_type' => 'one-to-many',
        ],
        'business_center_users' => [
            'lhs_module' => 'BusinessCenters',
            'lhs_table' => 'business_centers',
            'lhs_key' => 'id',
            'rhs_module' => 'Users',
            'rhs_table' => 'users',
            'rhs_key' => 'business_center_id',
            'relationship_type' => 'one-to-many',
        ],
    ],
    'acls' => [
        'SugarACLAdminOnly' => [
            'allowUserRead' => true,
        ],
    ],
    'uses' => ['basic', 'assignable', 'team_security', 'business_hours'],
    'portal_visibility' => [
        'class' => 'BusinessCenters',
    ],
];

VardefManager::createVardef('BusinessCenters', 'BusinessCenter');
