<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
/*********************************************************************************
 * Description: TODO:  To be written.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 * Contributor(s): ______________________________________..
 ********************************************************************************/

global $currentModule;
global $current_language;
global $current_user;
global $sugar_flavor;


if (!$current_user->isDeveloperForAnyModule()) {
    sugar_die('Unauthorized access to administration.');
}

echo getClassicModuleTitle(
    translate('LBL_MODULE_NAME', 'Administration'),
    [translate('LBL_MODULE_NAME', 'Administration')],
    false
);

//get the module links..
require 'modules/Administration/metadata/adminpaneldefs.php';
global $admin_group_header;  ///variable defined in the file above.


$tab = [];
$header_image = [];
$url = [];
$onclick = [];
$label_tab = [];
$id_tab = [];
$description = [];
$group = [];
$sugar_smarty = new Sugar_Smarty();
$values_3_tab = [];
$admin_group_header_tab = [];
$j = 0;

foreach ($admin_group_header as $key => $values) {
    $module_index = array_keys($values[3]);
    $addedHeaderGroups = [];
    foreach ($module_index as $mod_key => $mod_val) {
        if ((safeInArray($mod_val, $access) || (is_admin($current_user) && ($mod_val == 'Administration')) ||
                $mod_val == 'studio' || ($mod_val == 'Forecasts')) &&
            (!isset($addedHeaderGroups[$values[0]]))) {
            $admin_group_header_tab[] = $values;
            $group_header_value = get_form_header(translate($values[0], 'Administration'), $values[1], $values[2]);
            $group[$j][0] = '<table cellpadding="0" cellspacing="0" width="100%" class="h3Row"><tr ><td width="20%" valign="bottom"><h3>' . translate($values[0]) . '</h3></td></tr>';
            $addedHeaderGroups[$values[0]] = 1;
            if (isset($values[4])) {
                if (is_array($values[4])) {
                    $modDesc = '';
                    foreach ($values[4] as $modDescPart) {
                        $modDesc = $modDesc . translate($modDescPart, 'Administration');
                    }
                    $group[$j][1] = '<tr><td style="padding-top: 3px; padding-bottom: 5px;">' . $modDesc . '</td></tr></table>';
                } else {
                    $group[$j][1] = '<tr><td style="padding-top: 3px; padding-bottom: 5px;">' . translate($values[4]) . '</td></tr></table>';
                }
            } else {
                $group[$j][2] = '</tr></table>';
            }
            $colnum = 0;
            $i = 0;
            $fix = array_keys($values[3]);
            if (safeCount($values[3]) > 1) {
                if (!is_admin($current_user) && isset($values[3]['Administration'])) {
                    unset($values[3]['Administration']);
                }
                if (displayStudioForCurrentUser() == false) {
                    unset($values[3]['studio']);
                }
                if (displayWorkflowForCurrentUser() == false) {
                    unset($values[3]['any']['workflow_management']);
                }

                // Need this check because Quotes and Products share the header group
                if (!safeInArray('Quotes', $access) && isset($values[3]['Quotes'])) {
                    unset($values[3]['Quotes']);
                }
                if (!safeInArray('Products', $access) && isset($values[3]['Products'])) {
                    unset($values[3]['Products']);
                }
                // Need this check because Emails and Campaigns share the header group
                if (!safeInArray('Campaigns', $access) && isset($values[3]['Campaigns'])) {
                    unset($values[3]['Campaigns']);
                }

                //////////////////
                $tmp_array = $values[3];
                $return_array = [];
                foreach ($tmp_array as $mod => $value) {
                    $keys = array_keys($value);
                    foreach ($keys as $key) {
                        $return_array[$key] = $value[$key];
                    }
                }
                $values_3_tab[] = $return_array;
                $mod = $return_array;
            } else {
                $mod = $values[3][$fix[0]];
                $values_3_tab[] = $mod;
            }

            foreach ($mod as $link_idx => $admin_option) {
                if (!empty($GLOBALS['admin_access_control_links']) && safeInArray($link_idx, $GLOBALS['admin_access_control_links'])) {
                    continue;
                }
                $colnum += 1;
                $header_image[$j][$i] = SugarThemeRegistry::current()->getImage($admin_option[0], 'border="0" align="absmiddle"', null, null, '.gif', translate($admin_option[1], 'Administration'));
                $url[$j][$i] = $admin_option[3];
                if (!empty($admin_option[5])) {
                    $onclick[$j][$i] = $admin_option[5];
                }
                $target[$j][$i] = !empty($admin_option[6]) ? $admin_option[6] : '_self';
                $label = translate($admin_option[1], 'Administration');
                if (!empty($admin_option['additional_label'])) {
                    $label .= ' ' . $admin_option['additional_label'];
                }
                if (!empty($admin_option[4])) {
                    $label = ' <font color="red">' . $label . '</font>';
                }

                $label_tab[$j][$i] = $label;
                $id_tab[$j][$i] = $link_idx;
                if (is_array($admin_option[2])) {
                    $tempDesc = '';
                    foreach ($admin_option[2] as $descPart) {
                        $tempDesc = $tempDesc . translate($descPart, 'Administration');
                    }
                    $description[$j][$i] = $tempDesc;
                } else {
                    $description[$j][$i] = translate($admin_option[2], 'Administration');
                }
                if (($colnum % 2) == 0) {
                    $tab[$j][$i] = ($colnum % 2);
                } else {
                    $tab[$j][$i] = 10;
                }
                $i += 1;
            }

            //if the loop above ends with an odd entry add a blank column.
            if (($colnum % 2) != 0) {
                $tab[$j][$i] = 10;
            }
            $j += 1;
        }
    }
}

$sugar_smarty->assign('VALUES_3_TAB', $values_3_tab);
$sugar_smarty->assign('ADMIN_GROUP_HEADER', $admin_group_header_tab);
$sugar_smarty->assign('GROUP_HEADER', $group);
$sugar_smarty->assign('ITEM_HEADER_IMAGE', $header_image);
$sugar_smarty->assign('ITEM_URL', $url);
$sugar_smarty->assign('ITEM_ONCLICK', $onclick);
$sugar_smarty->assign('ITEM_HEADER_LABEL', $label_tab);
$sugar_smarty->assign('ITEM_DESCRIPTION', $description);
$sugar_smarty->assign('ITEM_TARGET', $target);
$sugar_smarty->assign('COLNUM', $tab);
$sugar_smarty->assign('ID_TAB', $id_tab);

echo $sugar_smarty->fetch('modules/Administration/index.tpl');
