<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

$dictionary['Account'] = [
    'table' => 'accounts',
    'audited' => true,
    'escalatable' => true,
    'color' => 'green',
    'icon' => 'sicon-account-lg',
    'activity_enabled' => true,
    'unified_search' => true,
    'full_text_search' => true,
    'unified_search_default_enabled' => true,
    'duplicate_merge' => true,
    'comment' => 'Accounts are organizations or entities that are the target of selling, support, and marketing activities, or have already purchased products or services',
    'fields' => [
        'parent_id' => [
            'name' => 'parent_id',
            'vname' => 'LBL_PARENT_ACCOUNT_ID',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'audited' => true,
            'comment' => 'Account ID of the parent of this account',
        ],
        'sic_code' => [
            'name' => 'sic_code',
            'vname' => 'LBL_SIC_CODE',
            'type' => 'varchar',
            'len' => 10,
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.21,
                'type' => 'exact',
            ],
            'comment' => 'SIC code of the account',
            'merge_filter' => 'enabled',
        ],
        'duns_num' => [
            'name' => 'duns_num',
            'vname' => 'LBL_DUNS_NUM',
            'type' => 'varchar',
            'len' => 15,
            'full_text_search' => [
                'enabled' => true,
                'searchable' => true,
                'boost' => 1.23,
                'type' => 'exact',
            ],
            'comment' => 'DUNS number of the account',
        ],
        'parent_name' => [
            'name' => 'parent_name',
            'rname' => 'name',
            'id_name' => 'parent_id',
            'vname' => 'LBL_MEMBER_OF',
            'type' => 'relate',
            'isnull' => 'true',
            'module' => 'Accounts',
            'table' => 'accounts',
            'massupdate' => false,
            'source' => 'non-db',
            'link' => 'member_of',
            'unified_search' => true,
            'importable' => 'true',
        ],
        'members' => [
            'name' => 'members',
            'type' => 'link',
            'relationship' => 'member_accounts',
            'module' => 'Accounts',
            'bean_name' => 'Account',
            'source' => 'non-db',
            'vname' => 'LBL_MEMBERS',
        ],
        'member_of' => [
            'name' => 'member_of',
            'type' => 'link',
            'relationship' => 'member_accounts',
            'module' => 'Accounts',
            'bean_name' => 'Account',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_MEMBER_OF',
            'side' => 'right',
        ],
        'cases' => [
            'name' => 'cases',
            'type' => 'link',
            'relationship' => 'account_cases',
            'module' => 'Cases',
            'bean_name' => 'aCase',
            'source' => 'non-db',
            'vname' => 'LBL_CASES',
        ],
        'business_center_name' => [
            'name' => 'business_center_name',
            'rname' => 'name',
            'id_name' => 'business_center_id',
            'vname' => 'LBL_BUSINESS_CENTER_NAME',
            'type' => 'relate',
            'link' => 'business_centers',
            'table' => 'business_centers',
            'join_name' => 'business_centers',
            'isnull' => 'true',
            'module' => 'BusinessCenters',
            'dbType' => 'varchar',
            'len' => 255,
            'source' => 'non-db',
            'unified_search' => true,
            'comment' => 'The name of the business center represented by the business_center_id field',
            'required' => false,
        ],
        'business_center_id' => [
            'name' => 'business_center_id',
            'type' => 'relate',
            'dbType' => 'id',
            'rname' => 'id',
            'module' => 'BusinessCenters',
            'id_name' => 'business_center_id',
            'reportable' => false,
            'vname' => 'LBL_BUSINESS_CENTER_ID',
            'audited' => true,
            'massupdate' => false,
            'comment' => 'The business center to which the case is associated',
        ],
        'business_centers' => [
            'name' => 'business_centers',
            'type' => 'link',
            'relationship' => 'business_center_accounts',
            'link_type' => 'one',
            'side' => 'right',
            'source' => 'non-db',
            'vname' => 'LBL_BUSINESS_CENTER',
        ],
        'messages' => [
            'name' => 'messages',
            'type' => 'link',
            'relationship' => 'account_messages',
            'module' => 'Messages',
            'bean_name' => 'Message',
            'source' => 'non-db',
            'vname' => 'LBL_MESSAGES',
        ],
        'escalations' => [
            'name' => 'escalations',
            'type' => 'link',
            'relationship' => 'account_escalations',
            'module' => 'Escalations',
            'bean_name' => 'Escalation',
            'source' => 'non-db',
            'vname' => 'LBL_ESCALATIONS',
        ],
        'accounts_escalations' => [
            'name' => 'accounts_escalations',
            'type' => 'link',
            'relationship' => 'accounts_escalations',
            'source' => 'non-db',
            'vname' => 'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE',
        ],
        'tasks' => [
            'name' => 'tasks',
            'type' => 'link',
            'relationship' => 'account_tasks',
            'module' => 'Tasks',
            'bean_name' => 'Task',
            'source' => 'non-db',
            'vname' => 'LBL_TASKS',
        ],
        'notes' => [
            'name' => 'notes',
            'type' => 'link',
            'relationship' => 'account_notes',
            'module' => 'Notes',
            'bean_name' => 'Note',
            'source' => 'non-db',
            'vname' => 'LBL_NOTES',
        ],
        'meetings' => [
            'name' => 'meetings',
            'type' => 'link',
            'relationship' => 'account_meetings',
            'module' => 'Meetings',
            'bean_name' => 'Meeting',
            'source' => 'non-db',
            'vname' => 'LBL_MEETINGS',
        ],
        'calls' => [
            'name' => 'calls',
            'type' => 'link',
            'relationship' => 'account_calls',
            'module' => 'Calls',
            'bean_name' => 'Call',
            'source' => 'non-db',
            'vname' => 'LBL_CALLS',
        ],
        'emails' => [
            'name' => 'emails',
            'type' => 'link',
            'relationship' => 'emails_accounts_rel', /* reldef in emails */
            'module' => 'Emails',
            'bean_name' => 'Email',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'studio' => ['formula' => false],
        ],
        'archived_emails' => [
            'name' => 'archived_emails',
            'type' => 'link',
            'link_class' => 'ArchivedEmailsBeanLink',
            'link' => 'contacts',
            'source' => 'non-db',
            'vname' => 'LBL_EMAILS',
            'module' => 'Emails',
            'link_type' => 'many',
            'relationship' => '',
            'hideacl' => true,
            'readonly' => true,
        ],
        'documents' => [
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_accounts',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS_SUBPANEL_TITLE',
        ],
        'bugs' => [
            'name' => 'bugs',
            'type' => 'link',
            'relationship' => 'accounts_bugs',
            'module' => 'Bugs',
            'bean_name' => 'Bug',
            'source' => 'non-db',
            'vname' => 'LBL_BUGS',
        ],
        'contacts' => [
            'name' => 'contacts',
            'type' => 'link',
            'relationship' => 'accounts_contacts',
            'module' => 'Contacts',
            'bean_name' => 'Contact',
            'source' => 'non-db',
            'vname' => 'LBL_CONTACTS',
        ],
        'opportunities' => [
            'name' => 'opportunities',
            'type' => 'link',
            'relationship' => 'accounts_opportunities',
            'module' => 'Opportunities',
            'bean_name' => 'Opportunity',
            'source' => 'non-db',
            'vname' => 'LBL_OPPORTUNITY',
        ],
        'quotes' => [
            'name' => 'quotes',
            'type' => 'link',
            'relationship' => 'quotes_billto_accounts',
            'source' => 'non-db',
            'module' => 'Quotes',
            'bean_name' => 'Quote',
            'ignore_role' => true,
            'vname' => 'LBL_QUOTES',
        ],
        'quotes_shipto' => [
            'name' => 'quotes_shipto',
            'type' => 'link',
            'relationship' => 'quotes_shipto_accounts',
            'module' => 'Quotes',
            'bean_name' => 'Quote',
            'source' => 'non-db',
            'vname' => 'LBL_QUOTES_SHIP_TO',
        ],
        'project' => [
            'name' => 'project',
            'type' => 'link',
            'relationship' => 'projects_accounts',
            'module' => 'Project',
            'bean_name' => 'Project',
            'source' => 'non-db',
            'vname' => 'LBL_PROJECTS',
        ],
        'leads' => [
            'name' => 'leads',
            'type' => 'link',
            'relationship' => 'account_leads',
            'module' => 'Leads',
            'bean_name' => 'Lead',
            'source' => 'non-db',
            'vname' => 'LBL_LEADS',
            'populate_list' => [
                'name' => 'account_name',
                'phone_office' => 'phone_work',
            ],
        ],
        'campaigns' => [
            'name' => 'campaigns',
            'type' => 'link',
            'relationship' => 'account_campaign_log',
            'module' => 'CampaignLog',
            'bean_name' => 'CampaignLog',
            'source' => 'non-db',
            'vname' => 'LBL_CAMPAIGNLOG',
            'studio' => ['formula' => false],
        ],
        'campaign_accounts' => [
            'name' => 'campaign_accounts',
            'type' => 'link',
            'vname' => 'LBL_CAMPAIGNS',
            'relationship' => 'campaign_accounts',
            'source' => 'non-db',
        ],
        'revenuelineitems' => [
            'name' => 'revenuelineitems',
            'type' => 'link',
            'relationship' => 'revenuelineitems_accounts',
            'vname' => 'LBL_REVENUELINEITEMS',
            'module' => 'RevenueLineItems',
            'bean_name' => 'RevenueLineItem',
            'source' => 'non-db',
            'workflow' => false,
        ],
        'external_users' => [
            'name' => 'external_users',
            'type' => 'link',
            'relationship' => 'external_users_accounts',
            'module' => 'ExternalUsers',
            'bean_name' => 'ExternalUser',
            'source' => 'non-db',
            'vname' => 'LBL_EXTERNAL_USERS',
        ],
        'purchasedlineitems' => [
            'name' => 'purchasedlineitems',
            'type' => 'link',
            'relationship' => 'purchasedlineitems_accounts',
            'vname' => 'LBL_PURCHASED_LINE_ITEMS',
            'module' => 'PurchasedLineItems',
            'bean_name' => 'PurchasedLineItem',
            'source' => 'non-db',
            'workflow' => false,
        ],
        'forecastworksheets' => [
            'name' => 'forecastworksheets',
            'type' => 'link',
            'relationship' => 'forecastworksheets_accounts',
            'vname' => 'LBL_FORECAST_WORKSHEET',
            'module' => 'ForecastWorksheets',
            'bean_name' => 'ForecastWorksheet',
            'source' => 'non-db',
        ],
        'products' => [
            'name' => 'products',
            'type' => 'link',
            'link_class' => 'AccountLink',
            'relationship' => 'products_accounts',
            'source' => 'non-db',
            'vname' => 'LBL_PRODUCTS',
        ],
        'contracts' => [
            'name' => 'contracts',
            'type' => 'link',
            'relationship' => 'account_contracts',
            'source' => 'non-db',
            'vname' => 'LBL_CONTRACTS',
        ],
        'dataprivacy' => [
            'name' => 'dataprivacy',
            'type' => 'link',
            'relationship' => 'accounts_dataprivacy',
            'source' => 'non-db',
            'vname' => 'LBL_DATAPRIVACY',
        ],
        'campaign_id' => [
            'name' => 'campaign_id',
            'comment' => 'Campaign that generated Account',
            'vname' => 'LBL_CAMPAIGN_ID',
            'rname' => 'id',
            'id_name' => 'campaign_id',
            'type' => 'id',
            'table' => 'campaigns',
            'isnull' => 'true',
            'module' => 'Campaigns',
            'reportable' => false,
            'massupdate' => false,
            'duplicate_merge' => 'disabled',
        ],
        'campaign_name' => [
            'name' => 'campaign_name',
            'rname' => 'name',
            'vname' => 'LBL_CAMPAIGN',
            'type' => 'relate',
            'reportable' => false,
            'source' => 'non-db',
            'table' => 'campaigns',
            'id_name' => 'campaign_id',
            'link' => 'campaign_accounts',
            'module' => 'Campaigns',
            'duplicate_merge' => 'disabled',
            'comment' => 'The first campaign name for Account (Meta-data only)',
            'studio' => [
                'mobile' => false,
            ],
        ],
        'prospect_lists' => [
            'name' => 'prospect_lists',
            'type' => 'link',
            'relationship' => 'prospect_list_accounts',
            'module' => 'ProspectLists',
            'source' => 'non-db',
            'vname' => 'LBL_PROSPECT_LIST',
        ],
        'next_renewal_date' => [
            'name' => 'next_renewal_date',
            'vname' => 'LBL_NEXT_RENEWAL_DATE',
            'type' => 'date',
            'readonly' => true,
        ],
        'widget_next_renewal_date' => [
            'name' => 'widget_next_renewal_date',
            'vname' => 'LBL_WIDGET_NEXT_RENEWAL_DATE',
            'type' => 'widget',
            'multiline' => false,
            'studio' => false,
            'workflow' => false,
            'reportable' => false,
            'importable' => false,
            'source' => 'non-db',
            'console' => [
                'name' => 'next_renewal_date',
                'label' => 'LBL_WIDGET_NEXT_RENEWAL_DATE',
                'type' => 'relative-date',
            ],
        ],
        'purchases' => [
            'name' => 'purchases',
            'type' => 'link',
            'relationship' => 'account_purchases',
            'source' => 'non-db',
            'vname' => 'LBL_PURCHASES',
        ],
        'hint_account_size' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_size',
            'vname' => 'LBL_HINT_COMPANY_SIZE',
            'label' => 'LBL_HINT_COMPANY_SIZE',
            'type' => 'varchar',
            'len' => 20,
            'comment' => 'Company Size',
            'reportable' => false,
        ],
        'hint_account_industry' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_industry',
            'vname' => 'LBL_HINT_COMPANY_INDUSTRY',
            'label' => 'LBL_HINT_COMPANY_INDUSTRY',
            'type' => 'varchar',
            'len' => 120,
            'comment' => 'Company Industry',
            'reportable' => false,
        ],
        'hint_account_location' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_location',
            'vname' => 'LBL_HINT_COMPANY_LOCATION',
            'label' => 'LBL_HINT_COMPANY_LOCATION',
            'type' => 'varchar',
            'len' => 120,
            'comment' => 'Company Location',
            'reportable' => false,
        ],
        'hint_account_industry_tags' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_industry_tags',
            'vname' => 'LBL_HINT_COMPANY_INDUSTRY_TAGS',
            'label' => 'LBL_HINT_COMPANY_INDUSTRY_TAGS',
            'type' => 'varchar',
            'len' => 225,
            'comment' => 'industry tags',
            'reportable' => false,
        ],
        'hint_account_founded_year' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_founded_year',
            'vname' => 'LBL_HINT_COMPANY_FOUNDED_YEAR',
            'label' => 'LBL_HINT_COMPANY_FOUNDED_YEAR',
            'type' => 'varchar',
            'len' => 5,
            'comment' => 'company founded year',
            'reportable' => false,
        ],
        'hint_account_facebook_handle' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_facebook_handle',
            'vname' => 'LBL_HINT_COMPANY_FACEBOOK',
            'label' => 'LBL_HINT_COMPANY_FACEBOOK',
            'type' => 'url',
            'len' => 120,
            'comment' => 'company facebook',
            'reportable' => false,
        ],
        'hint_account_logo' => [
            'name' => 'hint_account_logo',
            'vname' => 'LBL_HINT_COMPANY_LOGO',
            'label' => 'LBL_HINT_COMPANY_LOGO',
            'type' => 'varchar',
            'len' => 255,
            'comment' => 'company logo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_account_pic' => [
            'name' => 'hint_account_pic',
            'vname' => 'LBL_HINT_COMPANY_PIC',
            'label' => 'LBL_HINT_COMPANY_PIC',
            'type' => 'text',
            'comment' => 'Hint Account logo',
            'studio' => false,
            'reportable' => false,
        ],
        'hint_account_naics_code_lbl' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_naics_code_lbl',
            'vname' => 'LBL_HINT_COMPANY_NAICS_CODE_LABEL',
            'label' => 'LBL_HINT_COMPANY_NAICS_CODE_LABEL',
            'type' => 'varchar',
            'len' => 170,
            'comment' => 'NAICS Code',
            'reportable' => false,
        ],
        'hint_account_fiscal_year_end' => [
            'studio' => hasHintLicense() ? true : false,
            'name' => 'hint_account_fiscal_year_end',
            'vname' => 'LBL_HINT_COMPANY_FISCAL_YEAR_END',
            'label' => 'LBL_HINT_COMPANY_FISCAL_YEAR_END',
            'type' => 'varchar',
            'len' => 5,
            'comment' => 'FY End',
            'reportable' => false,
        ],
        'geocode_status' => [
            'studio' => hasMapsLicense() ? [
                'editField' => true,
                'recordview' => true,
                'previewview' => false,
                'recorddashletview' => false,
                'listview' => false,
                'wirelesseditview' => false,
                'wirelesslistview' => false,
                'wirelessdetailview' => false,
                'wireless_basic_search' => false,
                'wireless_advanced_search' => false,
            ] : false,
            'name' => 'geocode_status',
            'vname' => 'LBL_MAPS_GEOCODE_STATUS',
            'label' => 'LBL_MAPS_GEOCODE_STATUS',
            'type' => 'geocodestatus',
            'len' => 255,
            'comment' => '',
            'dbType' => 'varchar',
            'licenseFilter' => ['MAPS'],
            'readonly' => true,
            'reportable' => false,
        ],
        'dri_workflows' => [
            'name' => 'dri_workflows',
            'vname' => 'LBL_DRI_WORKFLOWS',
            'type' => 'link',
            'relationship' => 'dri_workflow_accounts',
            'module' => 'DRI_Workflows',
            'source' => 'non-db',
        ],
    ],
    'indices' => [
        ['name' => 'idx_accnt_parent_id', 'type' => 'index', 'fields' => ['parent_id']],
        ['name' => 'idx_account_billing_address_city', 'type' => 'index', 'fields' => ['billing_address_city']],
        [
            'name' => 'idx_acc_del_l_name_dm',
            'type' => 'index',
            'fields' => [
                'deleted',
                'name',
                'date_modified',
            ],
        ],
        [
            'name' => 'idx_accounts_del_businesscenter',
            'type' => 'index',
            'fields' => [
                'deleted',
                'business_center_id',
            ],
        ],
    ],
    'relationships' => [
        'member_accounts' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Accounts',
            'rhs_table' => 'accounts',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
        ],
        'account_cases' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Cases',
            'rhs_table' => 'cases',
            'rhs_key' => 'account_id',
            'relationship_type' => 'one-to-many',
        ],
        'account_tasks' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Tasks',
            'rhs_table' => 'tasks',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Accounts',
        ],
        'account_notes' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Notes',
            'rhs_table' => 'notes',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Accounts',
        ],
        'account_meetings' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Meetings',
            'rhs_table' => 'meetings',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Accounts',
        ],
        'account_calls' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Calls',
            'rhs_table' => 'calls',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Accounts',
        ],
        'account_emails' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Emails',
            'rhs_table' => 'emails',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Accounts',
        ],
        'account_leads' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Leads',
            'rhs_table' => 'leads',
            'rhs_key' => 'account_id',
            'relationship_type' => 'one-to-many',
        ],
        'accounts_assigned_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Accounts',
            'rhs_table' => 'accounts',
            'rhs_key' => 'assigned_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'accounts_modified_user' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Accounts',
            'rhs_table' => 'accounts',
            'rhs_key' => 'modified_user_id',
            'relationship_type' => 'one-to-many',
        ],
        'accounts_created_by' => [
            'lhs_module' => 'Users',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'Accounts',
            'rhs_table' => 'accounts',
            'rhs_key' => 'created_by',
            'relationship_type' => 'one-to-many',
        ],
        'account_campaign_log' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'CampaignLog',
            'rhs_table' => 'campaign_log',
            'rhs_key' => 'target_id',
            'relationship_type' => 'one-to-many',
        ],
        'account_messages' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Messages',
            'rhs_table' => 'messages',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Accounts',
        ],
        'account_purchases' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Purchases',
            'rhs_table' => 'purchases',
            'rhs_key' => 'account_id',
            'relationship_type' => 'one-to-many',
        ],
        'account_escalations' => [
            'lhs_module' => 'Accounts',
            'lhs_table' => 'accounts',
            'lhs_key' => 'id',
            'rhs_module' => 'Escalations',
            'rhs_table' => 'escalations',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
            'relationship_role_column' => 'parent_type',
            'relationship_role_column_value' => 'Accounts',
        ],
    ],
    'duplicate_check' => [
        'enabled' => true,
        'FilterDuplicateCheck' => [
            'filter_template' => [
                [
                    '$or' => [
                        ['name' => ['$equals' => '$name']],
                        ['duns_num' => ['$equals' => '$duns_num']],
                        [
                            '$and' => [
                                ['name' => ['$starts' => '$name']],
                                [
                                    '$or' => [
                                        ['billing_address_city' => ['$starts' => '$billing_address_city']],
                                        ['shipping_address_city' => ['$starts' => '$shipping_address_city']],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
            'ranking_fields' => [
                ['in_field_name' => 'name', 'dupe_field_name' => 'name'],
                ['in_field_name' => 'billing_address_city', 'dupe_field_name' => 'billing_address_city'],
                ['in_field_name' => 'shipping_address_city', 'dupe_field_name' => 'shipping_address_city'],
            ],
        ],
    ],
    //This enables optimistic locking for Saves From EditView
    'optimistic_locking' => true,
    'uses' => [
        'default',
        'assignable',
        'team_security',
        'company',
        'audit',
        'escalatable',
        'customer_journey_parent',
    ],
    'portal_visibility' => [
        'class' => 'Accounts',
    ],
];

VardefManager::createVardef(
    'Accounts',
    'Account'
);

//jc - adding for refactor for import to not use the required_fields array
//defined in the field_arrays.php file
$dictionary['Account']['fields']['name']['importable'] = 'required';

//boost value for full text search
$dictionary['Account']['fields']['name']['full_text_search']['boost'] = 1.91;
$dictionary['Account']['fields']['email']['full_text_search']['boost'] = 1.89;
$dictionary['Account']['fields']['phone_office']['full_text_search']['boost'] = 1.05;
$dictionary['Account']['fields']['phone_fax']['full_text_search']['boost'] = 1.04;
$dictionary['Account']['fields']['phone_alternate']['full_text_search']['boost'] = 1.03;
$dictionary['Account']['fields']['description']['full_text_search']['boost'] = 0.72;
$dictionary['Account']['fields']['billing_address_street']['full_text_search']['boost'] = 0.35;
$dictionary['Account']['fields']['shipping_address_street']['full_text_search']['boost'] = 0.34;
