<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => '中文 (台灣)',
    'moduleList' => [
        'Home' => '首頁',
        'Contacts' => '連絡人',
        'Accounts' => '帳戶',
        'Opportunities' => '商機',
        'Cases' => '案件',
        'Notes' => '筆記',
        'Calls' => '通話',
        'Emails' => '電子郵件',
        'Meetings' => '會議',
        'Tasks' => '工作',
        'Calendar' => '行事曆',
        'Leads' => '潛在客戶',
        'Currencies' => '貨幣：',
        'Contracts' => '合約',
        'Quotes' => '報價',
        'Products' => '報價項目',
        'WebLogicHooks' => '網路邏輯掛鉤',
        'ProductCategories' => '產品類別',
        'ProductTypes' => '產品類型',
        'ProductTemplates' => '產品目錄',
        'ProductBundles' => '產品同捆',
        'ProductBundleNotes' => '產品同捆記錄',
        'Reports' => '報表',
        'Forecasts' => '預測',
        'ForecastWorksheets' => '預測工作表',
        'ForecastManagerWorksheets' => '預測管理員工作表',
        'VisualPipeline' => '視覺管道',
        'ConsoleConfiguration' => '控制台配置',
        'SugarLive' => 'SugarLive',
        'Quotas' => '配額',
        'Teams' => '小組',
        'TeamNotices' => '小組通知',
        'Manufacturers' => '製造商',
        'Activities' => '活動',
        'Comments' => '註解',
        'Subscriptions' => '訂閱',
        'Bugs' => '錯誤',
        'Feeds' => 'RSS',
        'iFrames' => '我的網站',
        'TimePeriods' => '時間週期',
        'TaxRates' => '稅率',
        'ContractTypes' => '合約類型',
        'Schedulers' => '排程器',
        'Project' => '專案',
        'ProjectTask' => '專案工作',
        'Campaigns' => '推廣活動',
        'CampaignLog' => '推廣活動記錄',
        'CampaignTrackers' => '推廣活動追蹤器',
        'Documents' => '文件',
        'DocumentRevisions' => '文件修訂',
        'Connectors' => '連接器',
        'Notifications' => '通知',
        'Sync' => '同步',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => '外部用戶',
        'ReportMaker' => '進階報表',
        'DataSets' => '資料格式',
        'CustomQueries' => '自訂查詢',
        'pmse_Inbox' => '流程',
        'pmse_Project' => '流程定義',
        'pmse_Business_Rules' => '流程商務規則',
        'pmse_Emails_Templates' => '流程電子郵件範本',
        'BusinessCenters' => '商務中心',
        'Shifts' => '班表',
        'ShiftExceptions' => '班表的例外',
        'Purchases' => '購買',
        'PurchasedLineItems' => '購買項目',
        'MobileDevices' => '移動設備',
        'PushNotifications' => '推播通知',
        'Escalations' => '升級',
        'DocumentTemplates' => '文件範本',
        'DocumentMerges' => '文檔合併',
        'CloudDrivePaths' => '雲端硬碟路徑',
        'WorkFlow' => '工作流程定義',
        'EAPM' => '外部帳戶',
        'Worksheet' => '工作表',
        'Users' => '使用者',
        'Employees' => '員工',
        'Administration' => '管理',
        'ACLRoles' => '角色',
        'InboundEmail' => '輸入電子郵件',
        'Releases' => '發行版本',
        'Prospects' => '目標',
        'Queues' => '佇列',
        'EmailMarketing' => '電子郵件行銷',
        'EmailTemplates' => '電子郵件範本',
        'SNIP' => '電子郵件正在封存',
        'ProspectLists' => '目標清單',
        'SavedSearch' => '已儲存搜尋',
        'UpgradeWizard' => '升級精靈',
        'Trackers' => '追蹤',
        'TrackerPerfs' => '追蹤履行',
        'TrackerSessions' => '追蹤工作階段',
        'TrackerQueries' => '追蹤查詢',
        'FAQ' => '常見問題集',
        'Newsletters' => '新聞稿',
        'SugarFavorites' => '最愛',
        'PdfManager' => 'PDF 管理員',
        'DataArchiver' => '數據存檔程序',
        'ArchiveRuns' => '歸檔運行',

        'OAuthKeys' => 'OAuth 使用者金鑰',
        'OAuthTokens' => 'OAuth 權杖',
        'Filters' => '篩選器',
        'UserSignatures' => '電子郵件簽名',
        'Shippers' => '運輸服務供應商',
        'Styleguide' => '風格指南',
        'Feedbacks' => '回饋',
        'Tags' => '標籤',
        'Categories' => '類別',
        'Dashboards' => '儀表板',
        'OutboundEmail' => '電子郵件設定',
        'EmailParticipants' => '電子郵件的參與者',
        'DataPrivacy' => '數據隱私',
        'ReportSchedules' => '報表排程',
        'CommentLog' => '評論日誌',
        'Holidays' => '假日',
        'ChangeTimers' => '更改計時器',
        'Metrics' => '量度數據',
        'Messages' => '訊息',
        'Audit' => '稽核',
        'RevenueLineItems' => '營收單項',
        'DocuSignEnvelopes' => 'DocuSign 信封',
        'Geocode' => '地理編碼',
        'DRI_Workflows' => '智慧指南',
        'DRI_Workflow_Task_Templates' => '智慧指南活動範本',
        'DRI_SubWorkflows' => '智慧指南階段',
        'DRI_Workflow_Templates' => '智慧指南範本',
        'CJ_WebHooks' => 'Sugar Automate 網路掛鉤',
        'CJ_Forms' => 'Smart Guide Sugar 操作',
        'DRI_SubWorkflow_Templates' => '智慧指南階段範本',
        'PubSub_ModuleEvent_PushSubs' => '發佈/訂閱模組活動推送訂閱',
    ],

    'moduleIconList' => [
        'Home' => '首頁',
        'Contacts' => '聯絡人',
        'Accounts' => '帳戶',
        'Opportunities' => '機會',
        'Cases' => 'Cs',
        'Notes' => 'Nt',
        'Calls' => 'Cl',
        'Emails' => '電子郵件',
        'Meetings' => '會議',
        'Tasks' => 'Ts',
        'Calendar' => '行事曆',
        'Leads' => '潛在客戶',
        'Currencies' => '貨幣',
        'Contracts' => '合約',
        'Quotes' => '報價',
        'Products' => 'QL',
        'WebLogicHooks' => '網路邏輯掛鉤',
        'ProductCategories' => 'PG',
        'ProductTypes' => '產品類型',
        'ProductTemplates' => '產品範本',
        'ProductBundles' => '產品搭售方案',
        'ProductBundleNotes' => '產品搭售方案記錄',
        'Reports' => '報表',
        'Forecasts' => '預測',
        'ForecastWorksheets' => '預測工作表',
        'ForecastManagerWorksheets' => '預測管理員工作表',
        'Quotas' => 'Fo',
        'VisualPipeline' => '視覺管道',
        'ConsoleConfiguration' => '控制台設定',
        'SugarLive' => 'SugarLive',
        'Teams' => '小組',
        'TeamNotices' => '小組通知',
        'Manufacturers' => '製造商',
        'Activities' => '活動',
        'Comments' => '註解',
        'Subscriptions' => '訂閱',
        'Bugs' => '錯誤',
        'Feeds' => 'RS',
        'iFrames' => 'MS',
        'TimePeriods' => '時間週期',
        'TaxRates' => '稅率',
        'ContractTypes' => '合約類型',
        'Schedulers' => '排程器',
        'Project' => '專案',
        'ProjectTask' => '專案工作',
        'Campaigns' => 'Ca',
        'CampaignLog' => '行銷活動記錄',
        'CampaignTrackers' => '行銷活動追蹤器',
        'Documents' => '文件',
        'DocumentRevisions' => '文件修訂',
        'Connectors' => '連接器',
        'Notifications' => '通知',
        'Sync' => '同步',
        'HintAccountsets' => 'Hint 帳套表',
        'HintNotificationTargets' => 'Hint 通知目標',
        'HintNewsNotifications' => 'Hint 新聞通知',
        'HintEnrichFieldConfigs' => 'Hint 充實欄位設定',
        'ExternalUsers' => '外部使用者',
        'ReportMaker' => 'AR',
        'DataSets' => 'DF',
        'CustomQueries' => '自訂查詢',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'BC',
        'Shifts' => '班表',
        'ShiftExceptions' => '班表例外情況',
        'Purchases' => '購買',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => '行動裝置',
        'PushNotifications' => '推送通知',
        'Escalations' => '升級',
        'DocumentTemplates' => 'DT',
        'DocumentMerges' => 'DM',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'WD',
        'EAPM' => 'EA',
        'Worksheet' => '工作表',
        'Users' => '使用者',
        'Employees' => '員工',
        'Administration' => '管理',
        'ACLRoles' => 'ACL 角色',
        'InboundEmail' => '輸入電子郵件',
        'Releases' => '發行版本',
        'Prospects' => 'Ta',
        'Queues' => '佇列',
        'EmailMarketing' => '電子郵件行銷',
        'EmailTemplates' => '電子郵件範本',
        'SNIP' => 'EA',
        'ProspectLists' => 'TL',
        'SavedSearch' => '已儲存的搜尋',
        'UpgradeWizard' => '升級精靈',
        'Trackers' => '追蹤器',
        'TrackerPerfs' => '追蹤器效能',
        'TrackerSessions' => '追蹤器工作階段',
        'TrackerQueries' => '追蹤器查詢',
        'FAQ' => '常見問題集',
        'Newsletters' => '新聞稿',
        'SugarFavorites' => 'Sugar 最愛項目',
        'PdfManager' => 'PDF 管理員',
        'DataArchiver' => '資料封存工具',
        'ArchiveRuns' => '封存執行',
        'OAuthKeys' => 'OC',
        'OAuthTokens' => 'OAuth 權杖',
        'Filters' => '篩選器',
        'UserSignatures' => 'ES',
        'Shippers' => '運輸服務供應商',
        'Styleguide' => '風格指南',
        'Feedbacks' => '回饋',
        'Tags' => '標籤',
        'Categories' => '類別',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'ES',
        'EmailParticipants' => '電子郵件的參與者',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => '報表安排',
        'CommentLog' => '註解記錄',
        'Holidays' => '假日',
        'ChangeTimers' => '變更計時器',
        'Metrics' => '指標',
        'Messages' => '訊息',
        'Audit' => '審核',
        'RevenueLineItems' => '營收單項',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => '地理編碼',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => '庫',
        'EmailAddresses' => '電子郵件地址',
        'Words' => '字組',
        'Sugar_Favorites' => 'Fa',
        'KBDocuments' => 'KB 文件',
        'KBContents' => 'KB 內容',
        'KBArticles' => 'KB 文章',
        'KBContentTemplates' => 'KB 內容範本',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => '嵌入式檔案',
    ],

    'moduleListSingular' => [
        'Home' => '首頁',
        'Dashboards' => '儀表板',
        'Styleguide' => '風格指南',
        'Contacts' => '連絡人',
        'Accounts' => '帳戶',
        'Opportunities' => '商機',
        'Cases' => '實例',
        'Notes' => '附註',
        'Calls' => '通話',
        'Emails' => '電子郵件',
        'Meetings' => '會議',
        'Tasks' => '工作',
        'Calendar' => '行事曆',
        'Leads' => '潛在客戶',
        'Manufacturers' => '製造商',
        'VisualPipeline' => '視覺管道',
        'ConsoleConfiguration' => '控制台配置',
        'MobileDevices' => '移動設備',
        'SugarLive' => 'SugarLive',
        'Contracts' => '合約',
        'Quotes' => '報價',
        'Products' => '報價項目',
        'ProductCategories' => '產品類別',
        'ProductBundles' => '產品同捆',
        'ProductBundleNotes' => '產品同捆記錄',
        'RevenueLineItems' => '營收項目',
        'WebLogicHooks' => '網路邏輯掛鉤',
        'Reports' => '報表',
        'Forecasts' => '預測',
        'ForecastWorksheets' => '預測工作表',
        'ForecastManagerWorksheets' => '預測管理員工作表',
        'Quotas' => '配額',
        'Teams' => '小組',
        'TeamNotices' => '小組通知',
        'Activities' => '活動',
        'ActivityStream' => '活動流',
        'Bugs' => '錯誤',
        'Feeds' => 'RSS',
        'iFrames' => '我的網站',
        'TimePeriods' => '時間週期',
        'TaxRates' => '稅率',
        'ContractTypes' => '合約類型',
        'Schedulers' => '排程器',
        'Campaigns' => '宣傳活動',
        'CampaignLog' => '推廣活動記錄',
        'Project' => '專案',
        'ProjectTask' => '專案工作',
        'Prospects' => '目標',
        'ProspectLists' => '目標清單',
        'CampaignTrackers' => '推廣活動追蹤器',
        'Documents' => '文件',
        'DocumentRevisions' => '文件修訂',
        'Connectors' => '連接器',
        'Notifications' => '通知',
        'Sync' => '同步',
        'PdfManager' => 'PDF 管理員',
        'DataArchiver' => '數據存檔程序',
        'ArchiveRuns' => '歸檔運行',
        'ExternalUsers' => '外部用戶',
        'ReportMaker' => '進階報表',
        'DataSets' => '日期格式',
        'CustomQueries' => '自訂查詢',
        'pmse_Inbox' => '流程',
        'pmse_Project' => '流程定義',
        'pmse_Business_Rules' => '流程商務規則',
        'pmse_Emails_Templates' => '流程電子郵件範本',
        'BusinessCenters' => '商務中心',
        'Shifts' => '班表',
        'ShiftExceptions' => '班表的例外',
        'Purchases' => '購買',
        'PurchasedLineItems' => '購買項目',
        'PushNotifications' => '推播通知',
        'Escalations' => '升級',
        'DocumentTemplates' => '文件範本',
        'DocumentMerges' => '文檔合併',
        'CloudDrivePaths' => '雲端硬碟路徑',
        'WorkFlow' => '工作流程',
        'EAPM' => '外部帳戶',
        'Worksheet' => '工作表',
        'Users' => '使用者',
        'SugarFavorites' => 'SugarFavorites',
        'Employees' => '員工',
        'Administration' => '管理',
        'ACLRoles' => '角色',
        'InboundEmail' => '輸入電子郵件',
        'Releases' => '發行版本',
        'Queues' => '佇列',
        'EmailMarketing' => '電子郵件行銷',
        'EmailTemplates' => '電子郵件範本',
        'SNIP' => '電子郵件正在封存',
        'SavedSearch' => '已儲存搜尋',
        'UpgradeWizard' => '升級精靈',
        'Trackers' => '追蹤器',
        'TrackerPerfs' => '追蹤器效能',
        'TrackerSessions' => '追蹤器工作階段',
        'TrackerQueries' => '追蹤器查詢',
        'FAQ' => '常見問題集',
        'Newsletters' => '新聞稿',
        'OAuthKeys' => 'OAuth 消費者金鑰',
        'OAuthTokens' => 'OAuth Token',
        'Filters' => '篩選器',
        'Comments' => '註解',
        'CommentLog' => '評論日誌',
        'Currencies' => '貨幣',
        'ProductTemplates' => 'Product',
        'ProductTypes' => '產品類型',
        'Shippers' => '運輸服務供應商',
        'Subscriptions' => '訂閱',
        'UserSignatures' => '電子郵件簽名',
        'Feedbacks' => '回饋',
        'Tags' => '標籤',
        'Categories' => '類別',
        'OutboundEmail' => '電子郵件設定',
        'EmailParticipants' => '電子郵件的參與者',
        'DataPrivacy' => '數據隱私',
        'ReportSchedules' => '報表排程',
        'Holidays' => '假日',
        'ChangeTimers' => '更改計時器',
        'Metrics' => '量度數據',
        'Messages' => '訊息',
        'Audit' => '稽核',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => '地理編碼',
        'DRI_Workflows' => '智慧指南',
        'DRI_Workflow_Task_Templates' => '智慧指南活動範本',
        'DRI_SubWorkflows' => '智慧指南階段',
        'DRI_Workflow_Templates' => '智慧指南範本',
        'CJ_WebHooks' => 'Sugar Automate 網路掛鉤',
        'CJ_Forms' => 'Smart Guide Sugar 操作',
        'DRI_SubWorkflow_Templates' => '智慧指南階段範本',
        'PubSub_ModuleEvent_PushSubs' => '發佈/訂閱模組活動推送訂閱',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => '是',
        '2' => '否',
    ],

    'checkbox_massupdate_dom' => [
        0 => '否',
        1 => '是',
    ],

    'notifications_status_dom' => [
        0 => '未讀取',
        1 => '已讀取',
    ],

    'optout_dom' => [
        '' => '-無-',
        'false' => '否',
        'true' => '是',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => '分析師',
        'Competitor' => '競爭對手',
        'Customer' => '客戶',
        'Integrator' => '整合商',
        'Investor' => '投資者',
        'Partner' => '合作夥伴',
        'Press' => '新聞媒體',
        'Prospect' => '潛在客戶',
        'Reseller' => '經銷商',
        'Other' => '其他',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => '服飾',
        'Banking' => '銀行',
        'Biotechnology' => '生物科技',
        'Chemicals' => '化學',
        'Communications' => '通訊',
        'Construction' => '建築',
        'Consulting' => '諮詢',
        'Education' => '教育',
        'Electronics' => '電子',
        'Energy' => '能源',
        'Engineering' => '工程',
        'Entertainment' => '娛樂',
        'Environmental' => '環境',
        'Finance' => '金融',
        'Government' => '政府',
        'Healthcare' => '醫療',
        'Hospitality' => '旅館',
        'Insurance' => '保險',
        'Machinery' => '機械',
        'Manufacturing' => '製造',
        'Media' => '媒體',
        'Not For Profit' => '非營利',
        'Recreation' => '休閒',
        'Retail' => '零售',
        'Shipping' => '航運',
        'Technology' => '技術',
        'Telecommunications' => '電訊',
        'Transportation' => '交通',
        'Utilities' => '公共事業',
        'Other' => '其他',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF 和 CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => '圖表',
        'Data Table' => '數據表',
        'Chart and Data Table' => '圖表和數據表',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => '進行中',
        'Completed' => '已完成',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => '收件',
        'Outbound' => '外寄',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => '聊天',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => '第1層',
        'T2' => '第2層',
        'T3' => '第3層',
        'T4' => '第4層',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => '是',
        'No' => '否',
        'Completed' => '已完成',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => '未來',
        'Active' => '活動',
        'Past' => '貼上',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => '自我產生式',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => '電話推銷',
        'Existing Customer' => '現有客戶',
        'Self Generated' => '自己產生',
        'Employee' => '員工',
        'Partner' => '合作夥伴',
        'Public Relations' => '公共關係',
        'Direct Mail' => '直接郵遞',
        'Conference' => '會商',
        'Trade Show' => '商展',
        'Web Site' => '網站',
        'Word of mouth' => '口碑',
        'Email' => '電子郵件',
        'Campaign' => '宣傳活動',
        'Support Portal User Registration' => '支援入口網站使用者註冊',
        'Other' => '其他',
    ],
    'metric_status_dom' => [
        'Inactive' => '停用',
        'Active' => '啟用',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => '現成事業',
        'New Business' => '新事業',
    ],
    'taxrate_status_dom' => [
        'Active' => '啟用',
        'Inactive' => '停用',
    ],
    'roi_type_dom' => [
        'Revenue' => '營收',
        'Investment' => '投資',
        'Expected_Revenue' => '預期營收',
        'Budget' => '預算',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => '主要決策者',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '主要決策者',
        'Business Decision Maker' => '商業決策者',
        'Business Evaluator' => '商業評估員',
        'Technical Decision Maker' => '技術決策者',
        'Technical Evaluator' => '技術評估員',
        'Executive Sponsor' => '執行贊助者',
        'Influencer' => '影響者',
        'Other' => '其他',
    ],

    'manufacturer_status_dom' => [
        'Active' => '啟用',
        'Inactive' => '停用',
    ],

    'shipper_status_dom' => [
        'Active' => '啟用',
        'Inactive' => '停用',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => '主要連絡人',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => '主要連絡人',
        'Alternate Contact' => '替代連絡人',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => '欄位值旁邊',
        'field_on_top' => '欄位值上方',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => '網路 15',
        'Net 30' => '網路 30',
    ],
    'sales_stage_default_key' => '潛在客戶',
    'fts_type' => [
        'Elastic' => 'ElasticSearch',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => '勘查',
        'Qualification' => '資格',
        'Needs Analysis' => '需求分析',
        'Value Proposition' => '價值主張',
        'Id. Decision Makers' => 'ID 決策者',
        'Perception Analysis' => '認知分析',
        'Proposal/Price Quote' => '提案/報價',
        'Negotiation/Review' => '交涉檢閱',
        'Closed Won' => '結束並贏得客戶',
        'Closed Lost' => '結束但客戶流失',
    ],
    'sales_status_with_quote_dom' => [
        'New' => '新',
        'In Progress' => '進行中',
        'Closed Won' => '結束並贏得客戶',
        'Closed Lost' => '結束但客戶流失',
        'Converted to Quote' => '已轉換為報價',
    ],
    'sales_status_dom' => [
        'New' => '新',
        'In Progress' => '進行中',
        'Closed Won' => '結束並贏得客戶',
        'Closed Lost' => '結束但客戶流失',
    ],

    'commit_stage_binary_dom' => [
        'include' => '包含',
        'exclude' => '排除',
    ],
    'commit_stage_dom' => [
        'include' => '包含',
        'upside' => '樂觀',
        'exclude' => '排除',
    ],

    'commit_stage_custom_dom' => [
        'include' => '包含',
        'upside' => '樂觀',
        'exclude' => '排除',
    ],

    'in_total_group_stages' => [
        'Draft' => '草稿',
        'Negotiation' => '交涉',
        'Delivered' => '已交付',
        'On Hold' => '保留中',
        'Confirmed' => '已確認',
        'Closed Accepted' => '結束且已接受',
        'Closed Lost' => '結束但客戶流失',
        'Closed Dead' => '結束且無法使用',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => '通話',
        'Meeting' => '會議',
        'Task' => '工作',
        'Email' => '電子郵件',
        'Note' => '附註',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => '先生',
        'Ms.' => '女士',
        'Mrs.' => '夫人',
        'Dr.' => 'Dr.',
        'Prof.' => '教授',
        'Mx.' => 'Mx.',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => '無',
        60 => '1 分鐘前',
        300 => '5 分鐘前',
        600 => '10 分鐘前',
        900 => '15 分鐘前',
        1800 => '30 分鐘前',
        3600 => '1 小時前',
        7200 => '2 小時前',
        10800 => '3 小時前',
        18000 => '5 小時前',
        86400 => '1 天前',
        ],

        'task_priority_default' => '媒體',
        'task_priority_dom' => [
        'High' => '高',
        'Medium' => '媒體',
        'Low' => '低',
        ],
        'task_status_default' => '未開始',
        'task_status_dom' => [
        'Not Started' => '未開始',
        'In Progress' => '進行中',
        'Completed' => '已完成',
        'Pending Input' => '暫止的輸入',
        'Deferred' => '已延期',
        'Not Applicable' => '不適用',
        ],
        'meeting_status_default' => '已規劃',
        'meeting_status_dom' => [
        'Planned' => '已排程',
        'Held' => '已保留',
        'Not Held' => '已取消',
        'Deferred' => '已延期',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => '其他',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => '已規劃',
        'call_status_dom' => [
        'Planned' => '已排程',
        'In Progress' => '進行中',
        'Held' => '已保留',
        'Not Held' => '已取消',
        'Deferred' => '已延期',
        ],
        'call_direction_default' => '外寄',
        'call_direction_dom' => [
        'Inbound' => '傳入',
        'Outbound' => '外撥',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => '新',
        'Assigned' => '已指派',
        'In Process' => '處理中',
        'Converted' => '已轉換',
        'Recycled' => '已回收',
        'Dead' => '失效',
        ],
        'gender_list' => [
        'male' => '男',
        'female' => '女',
        'other' => '其他',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => '新',
        'case_status_dom' => [
        'New' => '新',
        'Assigned' => '已指派',
        'Closed' => '已關閉',
        'Pending Input' => '擱置輸入',
        'Rejected' => '已拒絕',
        'Duplicate' => '重複',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => '高',
        'P2' => '中',
        'P3' => '低',
        ],
        'user_type_dom' => [
        'RegularUser' => '常規使用者',
        'Administrator' => '管理員',
        ],
        'user_type_bool_dom' => [
            false => '常規使用者',
            true => '管理員',
        ],
        'user_type_group_bool_dom' => [
            true => '群組使用者',
        ],
        'user_type_portal_bool_dom' => [
            true => '入口網站 API 使用者',
        ],
        'license_type_dom' => [
        'CURRENT' => '目前產品',
        'SUGAR_SERVE' => 'Sugar Serve',
        'SUGAR_SELL' => 'Sugar Sell',
        ],
        'user_status_dom' => [
        'Active' => '启用',
        'Inactive' => '非使用中',
        ],
        'employee_status_dom' => [
        'Active' => '启用',
        'Terminated' => '已終止',
        'Leave of Absence' => '請假',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => '啟用',
        'Inactive' => '停用',
        ],
        'project_task_priority_options' => [
        'High' => '高',
        'Medium' => '媒體',
        'Low' => '低',
        ],
        'project_task_priority_default' => '媒體',

        'project_task_status_options' => [
        'Not Started' => '未開始',
        'In Progress' => '進行中',
        'Completed' => '已完成',
        'Pending Input' => '暫止的輸入',
        'Deferred' => '已延期',
        ],
        'project_task_utilization_options' => [
        '0' => '無',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => '草稿',
        'In Review' => '檢閱中',
        'Published' => '已發佈',
        ],
        'project_status_default' => '草稿',

        'project_duration_units_dom' => [
        'Days' => '天',
        'Hours' => '小時',
        ],

        'project_priority_options' => [
        'High' => '高',
        'Medium' => '媒體',
        'Low' => '低',
        ],
        'project_priority_default' => '媒體',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => '帳戶',
        'record_type_display' => [
        '' => '',
        'Accounts' => '帳戶',
        'Opportunities' => '商機',
        'Cases' => '實例',
        'Leads' => '潛在客戶',
        'Contacts' => '連絡人', // cn (11/22/2005) added to support Emails
        'Products' => '報價項目',
        'Quotes' => '報價',
        'Bugs' => '錯誤',
        'Project' => '專案',

        'Prospects' => '目標',
        'ProjectTask' => '專案工作',

        'Tasks' => '工作',
        'KBContents' => '知識庫',
        'Notes' => '附註',
        ],

        'record_type_display_notes' => [
        'Accounts' => '帳戶',
        'Contacts' => '連絡人',
        'Opportunities' => '商機',
        'Tasks' => '工作',
        'ProductTemplates' => '產品目錄',
        'Quotes' => '報價',
        'Products' => '報價項目',
        'Contracts' => '合約',
        'Emails' => '電子郵件',

        'Bugs' => '錯誤',
        'Project' => '專案',
        'ProjectTask' => '專案工作',
        'Prospects' => '目標',
        'Cases' => '實例',
        'Leads' => '潛在客戶',

        'Meetings' => '會議',
        'Calls' => '通話',
        'KBContents' => '知識庫',
        'PurchasedLineItems' => '購買項目',
        'Purchases' => '購買',
        'Escalations' => '升級',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => '帳戶',
        'Contacts' => '連絡人',
        'Employees' => '員工',
        'Leads' => '潛在客戶',
        'Prospects' => '目標',
        'Users' => '使用者',
        ],

        'parent_type_display' => [
        'Accounts' => '帳戶',
        'Contacts' => '連絡人',
        'Tasks' => '工作',
        'Opportunities' => '商機',
        'Products' => '報價項目',
        'Quotes' => '報價',

        'Bugs' => '錯誤',
        'Cases' => '實例',
        'Leads' => '潛在客戶',

        'Project' => '專案',
        'ProjectTask' => '專案工作',

        'Prospects' => '目標',
        'KBContents' => '知識庫',
        'Notes' => '附註',
        'PurchasedLineItems' => '購買項目',
        'Purchases' => '購買',
        'Escalations' => '升級',
        ],

        'changetimer_parent_type' => [
        'Cases' => '實例',
        ],

        'product_status_default_key' => '運送',
        'product_status_quote_key' => '報價',
        'product_status_dom' => [
        '' => '',
        'Quotes' => '已報價',
        'Orders' => '已訂購',
        'Ship' => '已送貨',
        ],
        'active_status_dom' => [
        'Active' => '启用',
        'Inactive' => '停用',
        'Retired' => '已過期',
        ],
        'appearance_options' => [
        'system_default' => '使用系統設置',
        'light' => '淺',
        'dark' => '深',
        ],


        'pricing_formula_default_key' => '固定',
        'pricing_formula_dom' => [
        'Fixed' => '固定價格',
        'ProfitMargin' => '利潤率',
        'PercentageMarkup' => '超過成本的加成',
        'PercentageDiscount' => '折扣清單',
        'IsList' => '與清單相同',
        ],
        'product_template_status_dom' => [
        'Available' => '有存貨',
        'Unavailable' => '已脫銷',
        ],
        'tax_class_dom' => [
        'Taxable' => '應稅',
        'Non-Taxable' => '非應稅',
        ],
        'support_term_dom' => [
        '+6 months' => '六個月',
        '+1 year' => '一年',
        '+2 years' => '兩年',
        ],

        'quote_type_dom' => [
        'Quotes' => '報價',
        'Orders' => '順序',
        ],
        'default_quote_stage_key' => '草稿',
        'quote_stage_dom' => [
        'Draft' => '草案',
        'Negotiation' => '交涉',
        'Delivered' => '已交付',
        'On Hold' => '保留中',
        'Confirmed' => '已確認',
        'Closed Accepted' => '結束且已接受',
        'Closed Lost' => '結束但客戶流失',
        'Closed Dead' => '結束且無法使用',
        ],
        'default_order_stage_key' => '擱置中',
        'order_stage_dom' => [
        'Pending' => '擱置中',
        'Confirmed' => '已確認',
        'On Hold' => '保留中',
        'Shipped' => '已送貨',
        'Cancelled' => '已取消',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => '主要決策者',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '主要決策者',
        'Business Decision Maker' => '商業決策者',
        'Business Evaluator' => '商業評估員',
        'Technical Decision Maker' => '技術決策者',
        'Technical Evaluator' => '技術評估員',
        'Executive Sponsor' => '執行贊助者',
        'Influencer' => '影響者',
        'Other' => '其他',
        ],
        'layouts_dom' => [
        'Standard' => '報價',
        'Invoice' => '發票',
        ],
        'issue_priority_default_key' => '媒體',
        'issue_priority_dom' => [
        'Urgent' => '緊急',
        'High' => '高',
        'Medium' => '媒體',
        'Low' => '低',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => '已接受',
        'Duplicate' => '複製',
        'Closed' => '已關閉',
        'Out of Date' => '已過期',
        'Invalid' => '無效',
        ],

        'issue_status_default_key' => '新',
        'issue_status_dom' => [
        'New' => '新',
        'Assigned' => '已指派',
        'Closed' => '已關閉',
        'Pending' => '擱置中',
        'Rejected' => '已拒絕',
        ],

        'bug_priority_default_key' => '媒體',
        'bug_priority_dom' => [
        'Urgent' => '緊急',
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => '已接受',
        'Duplicate' => '複製',
        'Fixed' => '固定',
        'Out of Date' => '已過期',
        'Invalid' => '無效',
        'Later' => '稍後',
        ],
        'bug_status_default_key' => '新',
        'bug_status_dom' => [
        'New' => '新的',
        'Assigned' => '已指派',
        'Closed' => '已關閉',
        'Pending' => '擱置中',
        'Rejected' => '已拒絕',
        ],
        'bug_type_default_key' => '錯誤',
        'bug_type_dom' => [
        'Defect' => '缺陷',
        'Feature' => '功能',
        ],
        'case_type_dom' => [
        'Administration' => '管理',
        'Product' => '產品',
        'User' => '使用者',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => '內部',
        'Forum' => '論壇',
        'Web' => '網路',
        'InboundEmail' => '電子郵件',
        'Twitter' => 'Twitter',
        'Portal' => '入口網站',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => '內部',
        'Forum' => '論壇',
        'Web' => '網路',
        'InboundEmail' => '電子郵件',
        'Twitter' => 'Twitter',
        'Portal' => '入口網站',
        'Phone' => '電話',
        'Chat' => '聊天',
        'Chatbot' => '聊天機器人',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => '請求數據隱私政策',
        'Send Personal Information being processed' => '發送正在處理的個人資訊',
        'Rectify Information' => '糾正資訊',
        'Request to Erase Information' => '請求擦去資訊',
        'Export Information' => '出口資訊',
        'Restrict Processing' => '限制處理',
        'Object to Processing' => '要處理的物件',
        'Consent to Process' => '同意處理',
        'Withdraw Consent' => '撤回同意',
        'Other' => '其他',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => '商務溝通',
        'Marketing Communications by company' => '由公司營銷傳播',
        'Marketing Communications by partners' => '由合作夥伴營銷傳播',
        ],
        'dataprivacy_status_default_key' => '打開',
        'dataprivacy_status_dom' => [
        'Open' => '打開',
        'Closed' => '已完成',
        'Rejected' => '已拒絕',
        ],
        'dataprivacy_priority_default_key' => '低',
        'dataprivacy_priority_dom' => [
        'Low' => '低',
        'Medium' => '中',
        'High' => '高',
        ],
        'business_day_status_dom' => [
        'Open' => '開啟',
        'Open 24 Hours' => '24小時營業',
        'Closed' => '關門',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => '帳戶',
        'Activities' => '活動',
        'Bug Tracker' => '錯誤追蹤器',
        'Calendar' => '行事曆',
        'Calls' => '通話',
        'Campaigns' => '推廣活動',
        'Cases' => '實例',
        'Contacts' => '連絡人',
        'Currencies' => '貨幣：',
        'Dashboard' => '儀表板',
        'Documents' => '文件',
        'Emails' => '電子郵件',
        'Feeds' => '摘要',
        'Forecasts' => '預測',
        'Help' => '說明',
        'Home' => '首頁',
        'Leads' => '潛在客戶',
        'Meetings' => '會議',
        'Notes' => '附註',
        'Opportunities' => '商機',
        'Outlook Plugin' => 'Outlook 外掛程式',
        'Product Catalog' => '產品目錄',
        'Products' => '報價項目',
        'RevenueLineItems' => '營收項目',
        'Projects' => '專案',
        'Quotes' => '報價',
        'Releases' => '發行版本',
        'RSS' => 'RSS',
        'Studio' => '工作室',
        'Upgrade' => '升級',
        'Users' => '使用者',
        'OutboundEmail' => '電子郵件設定',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => '計劃',
        'Active' => '使用中',
        'Inactive' => '非使用中',
        'Complete' => '完整',
        'In Queue' => '排入佇列',
        'Sending' => '正在傳送',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => '電話銷售',
        'Mail' => '郵件',
        'Email' => '電子郵件',
        'Print' => '列印',
        'Web' => '網路',
        'Radio' => '選項按鈕',
        'Television' => '電視',
        'NewsLetter' => '新聞稿',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => '每週',
        'Monthly' => '每月',
        'Quarterly' => '每季度',
        'Annually' => '每年',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => '1 月',
        '2' => '2 月',
        '3' => '3 月',
        '4' => '4 月',
        '5' => '5 月',
        '6' => '6 月',
        '7' => '7 月',
        '8' => '8 月',
        '9' => '9 月',
        '10' => '10 月',
        '11' => '11 月',
        '12' => '12 月',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => '1 月',
        '2' => '2 月',
        '3' => '3 月',
        '4' => '4 月',
        '5' => '5 月',
        '6' => '6 月',
        '7' => '7 月',
        '8' => '8 月',
        '9' => '9 月',
        '10' => '10 月',
        '11' => '11 月',
        '12' => '12 月',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => '星期日',
        '2' => '星期一',
        '3' => '星期二',
        '4' => '星期三',
        '5' => '星期四',
        '6' => '星期五',
        '7' => '星期六',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => '星期日',
        '2' => '星期一',
        '3' => '星期二',
        '4' => '星期三',
        '5' => '星期四',
        '6' => '星期五',
        '7' => '星期六',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => '週日',
        '2' => '週一',
        '3' => '週二',
        '4' => '週三',
        '5' => '週四',
        '6' => '週五',
        '7' => '週六',
        ],
        'dom_cal_day_of_week' => [
        '0' => '星期日',
        '1' => '星期一',
        '2' => '星期二',
        '3' => '星期三',
        '4' => '星期四',
        '5' => '星期五',
        '6' => '星期六',
        ],
        'dom_meridiem_lowercase' => [
        'am' => '上午',
        'pm' => '下午',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => '上午',
        'PM' => '下午',
        ],

        'dom_report_types' => [
        'tabular' => '列和欄',
        'summary' => '總和',
        'detailed_summary' => '總和附明細',
        'Matrix' => '矩陣',
        ],


        'dom_email_types' => [
        'out' => '已傳送',
        'archived' => '已封存',
        'draft' => '草稿',
        'inbound' => '傳入',
        'campaign' => '宣傳活動',
        ],
        'dom_email_status' => [
        'archived' => '已封存',
        'closed' => '已關閉',
        'draft' => '草稿',
        'read' => '已讀取',
        'replied' => '已回覆',
        'sent' => '已傳送',
        'send_error' => '傳送錯誤',
        'unread' => '未讀取',
        ],
        'dom_email_archived_status' => [
        'archived' => '已封存',
        ],

        'dom_email_server_type' => ['' => '--無--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--無--',
        'createcase' => '建立實例',
        'bounce' => '退回處理',
        ],
        'dom_email_distribution' => ['' => '--無--',
        'direct' => '直接指派',
        'roundRobin' => '循環配置資源',
        'leastBusy' => '最悠閒',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => '循環配置資源',
        'leastBusy' => '最悠閒',
        'none' => '無',
        ],
        'dom_email_errors' => [1 => '直接指派項目時只選取一名使用者。',
        2 => '直接指派項目時只能指派核取的項目。',
        ],
        'dom_email_bool' => ['bool_true' => '是',
        'bool_false' => '否',
        ],
        'dom_int_bool' => [1 => '是',
        0 => '否',
        ],
        'dom_switch_bool' => ['on' => '是',
        'off' => '否',
        '' => '否',],

        'dom_email_link_type' => ['sugar' => 'Sugar 電子郵件用戶端',
        'mailto' => '外部電子郵件用戶端'],


        'dom_email_editor_option' => ['' => '預設電子郵件格式',
        'html' => 'HTML 電子郵件',
        'plain' => '純文字電子郵件'],

        'schedulers_times_dom' => ['not run' => '超過執行時間，未執行。',
        'ready' => '準備',
        'in progress' => '進行中',
        'failed' => '失敗',
        'completed' => '已完成',
        'no curl' => '未執行：沒有可用 cURL',
        ],

        'dom_email_states' => [
        'Draft' => '草案',
        'Archived' => '已存檔',
        ],

        'dom_email_direction' => [
        'Unknown' => '未知',
        'Outbound' => '外寄',
        'Inbound' => '傳入',
        'Internal' => '內部',
        ],

        'scheduler_status_dom' => [
        'Active' => '使用中',
        'Inactive' => '非使用中',
        ],

        'scheduler_period_dom' => [
        'min' => '分鐘',
        'hour' => '小時',
        ],
        'forecast_type_dom' => [
        'Direct' => '直接',
        'Rollup' => '彙總',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => '行銷',
        'Knowledge Base' => '知識庫',
        'Sales' => '銷售',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => '行銷材料',
        'Product Brochures' => '產品手冊',
        'FAQ' => '常見問題集',
        ],

        'document_status_dom' => [
        'Active' => '使用中',
        'Draft' => '草稿',
        'FAQ' => '常見問題集',
        'Expired' => '已過期',
        'Under Review' => '正在檢閱',
        'Pending' => '擱置中',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => '合併列印',
        'eula' => 'EULA',
        'nda' => 'NDA',
        'license' => '授權協議',
        ],
        'dom_meeting_accept_options' => [
        'accept' => '接受',
        'decline' => '拒絕',
        'tentative' => '暫訂',
        ],
        'dom_meeting_accept_status' => [
        'accept' => '已接受',
        'decline' => '已拒絕',
        'tentative' => '暫訂',
        'none' => '無',
        ],
        'dataset_output_default_dom' => [
        'table' => '表格',
        ],
        'report_maker_status_dom' => [
        'Single Module' => '單個模組',
        'Multi Module' => '多個模組',
        ],
        'report_align_dom' => [
        'left' => '左側',
        'center' => '中心',
        'right' => '右側',
        ],

        'width_type_dom' => [
        '%' => '百分比 (%)',
        'px' => '像素 (px)',
        ],
        'report_color_dom' => [
        '' => '預設',
        'black' => '黑色',
        'green' => '綠色',
        'blue' => '藍色',
        'red' => '紅色',
        'white' => '白色',
        'DarkGreen' => '深綠色',
        'LightGray' => '淺灰色',
        'DodgerBlue' => '道奇藍',
        'LightBlue' => '淺藍色',
        ],
        'font_size_dom' => [
        '-5' => '更小 (-5)',
        '-4' => '更小 (-4)',
        '-3' => '更小 (-3)',
        '-2' => '更小 (-2)',
        '-1' => '更小 (-1)',
        'Default' => '預設',
        '1' => '更大 (+1)',
        '2' => '更大 (+2)',
        '3' => '更大 (+3)',
        '4' => '更大 (+4)',
        '5' => '更大 (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => '主查詢',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => '顯示',
//  'Group By' => 'Group By',
        'Calculation' => '計算',
        ],
        'query_display_type_dom' => [
        'Default' => '預設',
        'Custom' => '自訂',
        'Hidden' => '已隱藏',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => '天',
        'Week' => '週',
        'Month' => '月',
        'Quarter' => '季度',
        'Year' => '年',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => '現在',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => '總和',
        'AVG' => '平均',
        'COUNT' => '計數',
        'STDDEV' => '標準差',
        'VARIANCE' => '變異數',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => '標準欄位',
        'Time' => '時間間隔',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => '列（Y 軸）',
        'Columns' => '欄（X 軸）',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => '總計（合計）',
        'AVG' => '平均值',
        'MAX' => '最大值',
        'MIN' => '最小值',
        'COUNT' => '計數',
        'STDDEV' => '標準差',
        'VARIANCE' => '變異數',
        ],
        'query_calc_type_dom' => [
        'Standard' => '標準',
//  'Sub-Query' => 'Sub Query',
        'Math' => '數學計算',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => '欄位',
        'Value' => '值',
        'Group' => '群組',
        ],


        'dataset_layout_type_dom' => [
        'Column' => '欄',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => '已停用',
        'Enabled' => '已啟用',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => '標準',
        'Scalar' => '純量',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => '文字',
        'Accounting' => '會計',
        'Date' => '日期',
        'Datetime' => '日期時間',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => '年',
        'Quarter' => '季度',
        'Month' => '月',
        'Week' => '週',
        'Day' => '天',
        ],
        'dataset_style_dom' => [
        'normal' => '標準',
        'bold' => '粗體',
        'italic' => '斜體',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) 加',
        '-' => '(-) 減',
        '*' => '(X) 乘',
        '/' => '(/) 除',
        ],
        'wflow_type_dom' => [
        'Normal' => '儲存記錄時',
        'Time' => '時間過去後',
        ],
        'mselect_type_dom' => [
        'Equals' => '是',
        'in' => '是一個',
        ],
        'mselect_multi_type_dom' => [
        'in' => '是一個',
        'not_in' => '不是一個',
        ],
        'cselect_type_dom' => [
        'Equals' => '等於',
        'Does not Equal' => '不等於',
        ],
        'dselect_type_dom' => [
        'Equals' => '等於',
        'Less Than' => '小於',
        'More Than' => '超過',
        'Does not Equal' => '不等於',
        ],
        'bselect_type_dom' => [
        'bool_true' => '是',
        'bool_false' => '否',
        ],
        'bopselect_type_dom' => [
        'Equals' => '等於',
        ],
        'tselect_type_dom' => [
        '0' => '0 小時',
        '14440' => '4 小時',
        '28800' => '8 小時',
        '43200' => '12 小時',
        '86400' => '1 天',
        '172800' => '2 天',
        '259200' => '3 天',
        '345600' => '4 天',
        '432000' => '5 天',
        '604800' => '1 週',
        '1209600' => '2 週',
        '1814400' => '3 週',
        '2592000' => '30 天',
        '5184000' => '60 天',
        '7776000' => '90 天',
        '10368000' => '120 天',
        '12960000' => '150 天',
        '15552000' => '180 天',
        ],
        'dtselect_type_dom' => [
        'More Than' => '多於',
        'Less Than' => '小於',
        ],
        'wflow_alert_type_dom' => [
        'Email' => '電子郵件',
        'Invite' => '邀請',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => '標準訊息',
        'Custom Template' => '自訂範本',
        'System Default' => '系統預設',
        ],
        'wflow_user_type_dom' => [
        'current_user' => '目前使用者',
        'rel_user' => '關聯使用者',
        'rel_user_custom' => '關聯至自訂使用者',
        'specific_team' => '特定小組',
        'specific_role' => '特定角色',
        'specific_user' => '特定使用者',
        ],
        'wflow_array_type_dom' => [
        'future' => '新值',
        'past' => '舊值',
        ],
        'wflow_relate_type_dom' => [
        'Self' => '使用者',
        'Manager' => "使用者的經理",
        ],
        'wflow_address_type_dom' => [
        'to' => '收件者：',
        'cc' => '抄送：',
        'bcc' => '密件抄送：',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => '收件者：',
        'cc' => '抄送：',
        'bcc' => '密件抄送：',
        'invite_only' => '（僅邀請）',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => '收件者：',
        ],
        'wflow_action_type_dom' => [
        'update' => '更新記錄',
        'update_rel' => '更新關聯記錄',
        'new' => '新記錄',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => '觸發日期',
        'Existing Value' => '現有值',
        ],
        'wflow_set_type_dom' => [
        'Basic' => '基礎選項',
        'Advanced' => '進階選項',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => '指派至已觸發記錄的使用者',
        'modified_user_id' => '最近一次修改已觸發記錄的使用者',
        'created_by' => '建立已觸發記錄的使用者',
        'current_user' => '已登入使用者',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => '目前觸發記錄小組',
        'team_set_id' => '目前已觸發記錄的小組集合',
        'current_team' => '已登入使用者小組',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => '向後移動下拉式清單',
        'advance' => '向前移動下拉式清單',
        ],
        'wflow_record_type_dom' => [
        'All' => '新增和已更新記錄',
        'New' => '僅限新記錄',
        'Update' => '僅限已更新記錄',
        ],
        'wflow_rel_type_dom' => [
        'all' => '所有關聯的',
        //'first' => 'The first related',
        'filter' => '篩選關聯的',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => '所有關聯的',
        'any' => '任何關聯的',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => '警示後行動',
        'actions_alerts' => '行動後警示'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => '無',
        'Daily' => '每天',
        'Weekly' => '每週',
        'Monthly' => '每月',
        'Yearly' => '年',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => '天',
        'Weekly' => '週',
        'Monthly' => '月',
        'Yearly' => '年',
        ],

        'repeat_end_types' => [
        'Until' => '直到',
        'Occurrences' => '發生次數',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => '無',
        'Each' => '每個',
        'On' => '在',
        ],

        'repeat_ordinal_dom' => [
        'first' => '第一',
        'second' => '第二',
        'third' => '第三',
        'fourth' => '第四',
        'fifth' => '第五',
        'last' => '最後',
        ],

        'repeat_unit_dom' => [
        'Sun' => '星期日',
        'Mon' => '星期一',
        'Tue' => '星期二',
        'Wed' => '星期三',
        'Thu' => '星期四',
        'Fri' => '星期五',
        'Sat' => '星期六',
        'Day' => '天',
        'WD' => '工作日',
        'WE' => '週末',
        ],

        'duration_dom' => [
        '' => '無',
        '900' => '15 分鐘',
        '1800' => '30 分鐘',
        '2700' => '45 分鐘',
        '3600' => '1 小時',
        '5400' => '1.5 小時',
        '7200' => '2 小時',
        '10800' => '3 小時',
        '21600' => '6 小時',
        '86400' => '1 天',
        '172800' => '2 天',
        '259200' => '3 天',
        '604800' => '1 週',
        ],
        'repeat_month_dom' => [
        '1' => '1 月',
        '2' => '2 月',
        '3' => '3 月',
        '4' => '4 月',
        '5' => '5 月',
        '6' => '6 月',
        '7' => '7 月',
        '8' => '8 月',
        '9' => '9 月',
        '10' => '10 月',
        '11' => '11 月',
        '12' => '12 月',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => '預設',
        'seed' => '種子',
        'exempt_domain' => '隱藏清單－按網域',
        'exempt_address' => '隱藏清單－按電子郵件地址',
        'exempt' => '隱藏清單－按 ID',
        'test' => '測試',
        ],
        'currency_status_dom' => [
        'Active' => '啟用',
        'Inactive' => '停用',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => '使用中',
        'inactive' => '非使用中',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => '訊息已傳送 / 已嘗試',
        'send error' => '退回的訊息，其他',
        'invalid email' => '退回的訊息，無效電子郵件',
        'link' => '點選連結',
        'viewed' => '已檢視訊息',
        'removed' => '選擇退出',
        'lead' => '已建立潛在客戶',
        'contact' => '已建立連絡人',
        'blocked' => '按電子郵件或網域隱藏',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => '連絡人',
        'Users' => '使用者',
        'Prospects' => '目標',
        'Leads' => '潛在客戶',
        'Accounts' => '帳戶',
        ],
        'merge_operators_dom' => [
        'like' => '包含',
        'exact' => '完全',
        'start' => '開始於',
        ],

        'custom_fields_importable_dom' => [
        'true' => '是',
        'false' => '否',
        'required' => '必填',
        ],

        'fts_field_config' => [
        '0' => '已停用',
        '2' => '可搜尋',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => '已停用',
        1 => '已啟用',
        2 => '篩選器',
        3 => '預設選取的篩選器',
        4 => '僅限篩選器',
        ],

        'navigation_paradigms' => [
        'm' => '模組',
        'gm' => '群組模組',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => '未開始',
        'inprogress' => '進行中',
        'signed' => '已簽名',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => '每月',
        'quarterly' => '每季度',
        'halfyearly' => '半年',
        'yearly' => '年',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 天',
        '3' => '3 天',
        '5' => '5 天',
        '7' => '1 週',
        '14' => '2 週',
        '21' => '3 週',
        '31' => '1 個月',
        ],
        'projects_priority_options' => [
        'high' => '高',
        'medium' => '媒體',
        'low' => '低',
        ],

        'projects_status_options' => [
        'notstarted' => '未開始',
        'inprogress' => '進行中',
        'completed' => '已完成',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => '展開圖例',
        'collapselegend' => '摺疊圖例',
        'clickfordrilldown' => '按一下以向下切入',
        'drilldownoptions' => '向下切入選項',
        'detailview' => '更多詳細資料...',
        'piechart' => '圓形圖',
        'groupchart' => '群組圖表',
        'stackedchart' => '堆疊圖表',
        'barchart' => '橫條圖',
        'horizontalbarchart' => '水平橫條圖',
        'linechart' => '折線圖',
        'noData' => '資料不可用',
        'print' => '列印',
        'pieWedgeName' => '區段',
        ],
        'chart_types' => [
        'hBarF' => '水平長條（堆疊）',
        'hGBarF' => '水平長條（群組）',
        'vBarF' => '垂直長條（堆疊）',
        'vGBarF' => '垂直長條（群組）',
        'pieF' => '圓形圖',
        'funnelF' => '漏斗形圖',
        'lineF' => '折線圖',
        'donutF' => '圓環',
        'treemapF' => '樹狀圖',
        ],
        'd3_value_placement' => [
        '0' => '無',
        '1' => '預設',
        'start' => '開始',
        'middle' => '中間',
        'end' => '結束',
        'top' => '頂部',
        'total' => '總計',
        ],
        'pipeline_chart_dom' => [
        'fun' => '漏斗',
        'hbar' => '水平軸',
        ],
        'release_status_dom' => [
        'Active' => '使用中',
        'Inactive' => '非使用中',
        ],
        'email_settings_for_ssl' => [
        '0' => '無',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google Less Secure 應用程式',
        'exchange' => '交流',
        'other' => '其他',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => '其他',
        ],
        'import_enclosure_options' => [
        '&#39;' => '單引號 (&#39;)',
        '"' => '雙引號 (")',
        '' => '無',
        'other' => '其他：',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '。',
        ':' => '：',
        '|' => '|',
        'other' => '其他：',
        ],
        'link_target_dom' => [
        '_blank' => '新視窗',
        '_self' => '相同視窗',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => '不要自動重新整理',
        '30' => '每 30 秒',
        '60' => '每 1 分鐘',
        '180' => '每 3 分鐘',
        '300' => '每 5 分鐘',
        '600' => '每 10 分鐘',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => '無',
        '15' => '每 15 分鐘',
        '30' => '每 30 分鐘',
        '45' => '每 45 分鐘',
        '60' => '每小時',
        '120' => '每 2 小時',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => '從不',
        '30' => '每 30 秒',
        '60' => '每 1 分鐘',
        '180' => '每 3 分鐘',
        '300' => '每 5 分鐘',
        '600' => '每 10 分鐘',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => '無',
        '1' => '每 1 分鐘',
        '5' => '每 5 分鐘',
        '10' => '每 10 分鐘',
        '15' => '每 15 分鐘',
        '30' => '每 30 分鐘',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => '等於',
        'not_equal' => '不位於',
        'greater_than' => '之後',
        'less_than' => '之前',
        'last_7_days' => '過去 7 天',
        'next_7_days' => '未來 7 天',
        'last_30_days' => '過去 30 天',
        'next_30_days' => '未來 30 天',
        'last_month' => '上個月',
        'this_month' => '本月',
        'next_month' => '下個月',
        'last_year' => '去年',
        'this_year' => '今年',
        'next_year' => '明年',
        'between' => '之間',
        ],
        'date_range_operator_dom' => [
        'last_year' => '去年',
        'last_month' => '上個月',
        'last_30_days' => '過去 30 天',
        'last_7_days' => '過去 7 天',
        'this_month' => '本月',
        'this_year' => '今年',
        'next_7_days' => '未來 7 天',
        'next_30_days' => '未來 30 天',
        'next_month' => '下個月',
        'next_year' => '明年',
        ],
        'numeric_range_search_dom' => [
        '=' => '等於',
        'not_equal' => '不等於',
        'greater_than' => '大於',
        'greater_than_equals' => '大於或等於',
        'less_than' => '小於',
        'less_than_equals' => '小於或等於',
        'between' => '之間',
        ],

        'filter_checkbox_dom' => [
        0 => '假值',
        1 => '是',
        ],

        'opportunity_metrics_dom' => [
        'won' => '贏得的客戶',
        'lost' => '流失的客戶',
        'active' => '使用中',
        ],

        'sweetspot_theme_options' => [
        'default' => '預設',
        'light' => '淺',
        'dark' => '深',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => '移動',
        'donothing' => '不操作',
        ],
        'processes_auto_save_interval' => [
        0 => '從不',
        30000 => '每30秒',
        60000 => '每1分鐘',
        120000 => '每2分鐘',
        180000 => '每3分鐘',
        240000 => '每4分鐘',
        300000 => '每5分鐘',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => '是',
        'No' => '否',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => '預測',
        'sales_stage' => '銷售階段',
        'probability' => '可能性',
        ],
        'forecasts_options_dataset' => [
        'likely' => '可能',
        'best' => '最佳',
        'worst' => '最差',
        ],
        'webLogicHookList' => [
        'after_save' => '儲存後',
        'after_delete' => '刪除後',
        'after_relationship_add' => '新增關係後',
        'after_relationship_delete' => '刪除關係後',
        'after_login' => '登入後',
        'after_logout' => '登出後',
        'after_login_failed' => '登入失敗後',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => '已啟用',
        'INACTIVE' => '已停用',
        ],
        'dashboard_view_name_list' => [
        'record' => '記錄',
        'records' => '清單',
        'activities' => '活動流',
        'multi-line' => '多行清單',
        'omnichannel' => '全渠道',
        'home' => 'Home',
        'focus' => '關注抽屜',
        ],
        'metric_context_list' => [
        'service_console' => '服務控制台',
        'renewals_console' => '續訂控制台',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => '每小時',
        '21600' => '每 6 小時',
        '43200' => '每 12 小時',
        '86400' => '每天',
        '604800' => '每週',
        '1209600' => '每 2 週',
        '2419200' => '每 4 週',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => '年',
        'month' => '月',
        'day' => '天',
        ],
        'shift_exception_type_dom' => [
        'time_off' => '休息',
        'event' => '事件',
        'other' => '其他',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => '日期(最後一個 {{module}})',
        'start_date:asc' => '日期(第一個 {{module}})',
        'total_revenue:desc' => '價格(最高總計)',
        'total_revenue:asc' => '價格(最低總計)',
        ],
        'calendar_type_list' => [
        'main' => '行事曆中心',
        ],
        'calendar_views_options' => [
        'day' => '天',
        'week' => '週',
        'workWeek' => '工作週',
        'expandedMonth' => '月',
        'agenda' => '議程',
        'timeline' => '時間軸',
        'monthSchedule' => '排程器',
        ],
        'docusign_envelope_status_list' => [
        'created' => '已建立',
        'completed' => '已完成',
        'declined' => '已拒絕',
        'delivered' => '已交付',
        'sent' => '已傳送',
        'signed' => '已簽名',
        'voided' => '無效',
        ],
        'docusign_recipient_selection_list' => [
        'show' => '顯示潛在收件人列表',
        'dont_show' => '不要顯示潛在的收件人',
        ],
        'docusign_recipient_type_list' => [
        'signer' => '簽名者',
        'carbon_copy' => '查看器(複寫本)',
        'certified_delivery' => '查看器(認證交付)',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => '預設',
        'color' => '顏色',
        'image' => '圖像',
        ],
        'module_display_type_dom' => [
        'abbreviation' => '縮寫',
        'icon' => '圖示',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => '向下箭頭',
        'sicon-chevron-left' => '左＞形箭號',
        'sicon-check' => '檢查',
        'sicon-clock' => '時鐘',
        'sicon-dashboard-default' => '儀表板預設值',
        'sicon-dashboard' => '儀表板',
        'sicon-edit' => '編輯',
        'sicon-caret-down' => '向下插入符號',
        'sicon-folder' => '資料夾',
        'sicon-info' => '資訊',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => '連結',
        'sicon-list' => '清單',
        'sicon-logout' => '登出',
        'sicon-minus' => '減號',
        'sicon-folder-open' => '資料夾開啟',
        'sicon-plus-sm' => '加 Sm',
        'sicon-refresh' => '重新整理',
        'sicon-plus' => '加',
        'sicon-settings' => '設定',
        'sicon-arrow-right-double' => '右雙箭頭',
        'sicon-reports' => '報表',
        'sicon-user' => '使用者',
        'sicon-upload' => '上傳',
        'sicon-user-group' => '使用者群組',
        'sicon-arrow-left-double' => '左雙箭頭',
        'sicon-chevron-up' => '倒 Ｖ 字形',
        'sicon-caret-up' => '向上插入符號',
        'sicon-star-fill' => '星形填入',
        'sicon-download' => '下載',
        'sicon-close' => '關閉',
        'sicon-tile-view' => '並排檢視',
        'sicon-list-view' => '清單檢視',
        'sicon-thumbs-down' => '大拇指向下',
        'sicon-warning-circle' => '警告圈',
        'sicon-phone' => '電話',
        'sicon-email' => '電子郵件',
        'sicon-document' => '文件',
        'sicon-note' => '附註',
        'sicon-preview' => '預覽',
        'sicon-copy' => '複製',
        'sicon-launch' => '啟動',
        'sicon-lock' => '鎖定',
        'sicon-arrow-top-right' => '右上角箭頭',
        'sicon-full-screen' => '全螢幕',
        'sicon-full-screen-exit' => '全螢幕退出',
        'sicon-expand-left' => '向左展開',
        'sicon-expand-right' => '向右展開',
        'sicon-focus-drawer' => 'Focus Drawer',
        'sicon-ban' => '禁止',
        'sicon-thumbs-up' => '大拇指向上',
        'sicon-search' => '搜尋',
        'sicon-calendar' => '行事曆',
        'sicon-calendar-lg' => '行事曆 Lg',
        'sicon-mobile-lg' => '行動 Lg',
        'sicon-star-fill-lg' => '星形填入 Lg',
        'sicon-star-outline-lg' => '星形輪廓 Lg',
        'sicon-reset-lg' => '重設 Lg',
        'sicon-exchange-lg' => '交換 Lg',
        'sicon-help-lg' => '説明 Lg',
        'sicon-close-lg' => '關閉 Lg',
        'sicon-plus-lg' => '加 Lg',
        'sicon-shortcuts-lg' => '捷徑 Lg',
        'sicon-search-lg' => '搜尋 Lg',
        'sicon-email-lg' => '電子郵件 Lg',
        'sicon-note-lg' => '附註 Lg',
        'sicon-document-lg' => '文件 Lg',
        'sicon-add-dashlet-lg' => '新增 Dashlet Lg',
        'sicon-collapse-lg' => '摺疊 Lg',
        'sicon-hamburger-lg' => '漢堡包 Lg',
        'sicon-pin-fill-lg' => 'Pin 碼填入 Lg',
        'sicon-expand-lg' => '展開 Lg',
        'sicon-copy-lg' => '複製 Lg',
        'sicon-dashboard-lg' => '儀表板 Lg',
        'sicon-star-outline' => '星形輪廓',
        'sicon-reset' => '重設',
        'sicon-unlink' => '取消連結',
        'sicon-phone-lg' => '電話 Lg',
        'sicon-attach' => '附加',
        'sicon-case-lg' => '案例 Lg',
        'sicon-arrow-right-lg' => '向右箭頭 Lg',
        'sicon-check-circle-lg' => '核取圓圈 Lg',
        'sicon-text-formatting' => '文字格式',
        'sicon-check-circle' => '核取圓圈',
        'sicon-upload-lg' => '上傳 Lg',
        'sicon-flag-lg' => '旗標 Lg',
        'sicon-studio-lg' => 'Studio Lg',
        'sicon-contact-lg' => '聯絡人 Lg',
        'sicon-edit-lg' => '編輯 Lg',
        'sicon-arrow-left' => '向左箭頭',
        'sicon-reply-all' => '回覆所有',
        'sicon-message-lg' => '訊息 Lg',
        'sicon-info-lg' => '資訊 Lg',
        'sicon-error-lg' => '錯誤 Lg',
        'sicon-check-circle-line-lg' => '核取圓圈行 Lg',
        'sicon-warning-line-lg' => '警告行 Lg',
        'sicon-arrow-up' => '向上箭頭',
        'sicon-arrow-right' => '向右箭頭',
        'sicon-nodes' => '節點',
        'sicon-hide' => '隱藏',
        'sicon-help' => '說明',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => '訊息',
        'sicon-sugar-predict-lg' => 'Sugar 預測 Lg',
        'sicon-sugar-predict' => 'Sugar 預測',
        'sicon-opportunity-lg' => '商機 Lg',
        'sicon-lead-lg' => '潛在客戶 Lg',
        'sicon-account-lg' => '帳戶 Lg',
        'sicon-user-sm' => '使用者 Sm',
        'sicon-quote-lg' => '報價 Lg',
        'sicon-equal' => '等於',
        'sicon-slicers-xl' => '交叉分析篩選器 Xl',
        'sicon-escalation-lg' => '升級 Lg',
        'sicon-add-circle-lg' => '新增圓圈 Lg',
        'sicon-add-line-lg' => '新增行 Lg',
        'sicon-add-target-lg' => '新增目標 Lg',
        'sicon-help-circle-lg' => '說明圓圈 Lg',
        'sicon-divide-line-lg' => '劃分行 Lg',
        'sicon-string' => '字串',
        'sicon-filter' => '篩選器',
        'sicon-number' => '編號',
        'sicon-format-lg' => '格式 Lg',
        'sicon-insights-lg' => '見解 Lg',
        'sicon-invalid-circle-lg' => '無效的圓圈 Lg',
        'sicon-layout-xl' => '版面配置 Xl',
        'sicon-layout-lg' => '版面配置 Lg',
        'sicon-multiply-line-lg' => '倍增線 Lg',
        'sicon-redo-lg' => '重做 Lg',
        'sicon-refresh-lg' => '重新整理 Lg',
        'sicon-undo-lg' => '復原 Lg',
        'sicon-activity-feed-xl' => '活動摘要 Xl',
        'sicon-chevron-left-xl' => '左＞形箭號 Xl',
        'sicon-close-xl' => '關閉 Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => '見解 Xl',
        'sicon-hide-lg' => '隱藏 Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => '註解 Xl',
        'sicon-share-lg' => '共用 Lg',
        'sicon-trash' => '垃圾桶',
        'sicon-launch-lg' => '啟動 Lg',
        'sicon-thumbs-up-lg' => '大拇指向上 Lg',
        'sicon-thumbs-down-lg' => '大拇指向下 Lg',
        'sicon-warning-lg' => '警告 Lg',
        'sicon-wizard-circle-xl' => '精靈圓圈 Xl',
        'sicon-bell-cross-lg' => '鈴鐺十字架 Lg',
        'sicon-bell-lg' => '鈴鐺 Lg',
        'sicon-daily-lg' => '每日 Lg',
        'sicon-cloud-download-lg' => '雲端下載 Lg',
        'sicon-unlock' => '解除鎖定',
        'sicon-news-lg' => '新聞 Lg',
        'sicon-weekly-lg' => '每週 Lg',
        'sicon-knowledgebase-xl' => '知識庫 Xl',
        'sicon-remove' => '移除',
        'sicon-chevron-down' => 'V 字形',
        'sicon-slicers-lg' => '交叉分析篩選器 Lg',
        'sicon-save-lg' => '儲存 Lg',
        'sicon-info-circle-lg' => '資訊圓圈 Lg',
        'sicon-chevron-right' => '右＞形箭號',
        'sicon-warning-circle-lg' => '警告圈 Lg',
        'sicon-right-paren-line-lg' => '右括號行 Lg',
        'sicon-comment-lg' => '註解 Lg',
        'sicon-target-lg' => '目標 Lg',
        'sicon-subtract-line-lg' => '減去行 lg',
        'sicon-settings-lg' => '設定 Lg',
        'sicon-left-paren-line-lg' => '左括號行 Lg',
        'sicon-preview-lg' => '預覽 Lg',
        'sicon-thumbs-down-line-lg' => '大拇指向下行 Lg',
        'sicon-thumbs-up-line-lg' => '大拇指向上行 Lg',
        'sicon-send-lg' => '傳送 Lg',
        'sicon-contact-xl' => '聯絡人 Xl',
        'sicon-wizard-circle-line-xl' => '精靈圓圈行 Xl',
        'sicon-trash-lg' => '垃圾桶 Lg',
        'sicon-pin-lg' => 'Pin 碼 Lg',
        'sicon-clock-lg' => '時鐘 Lg',
        'sicon-comment-line-xl' => '註解行 Xl',
        'sicon-dropdown-editor' => '下拉式清單編輯器',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => '錯誤',
        'sicon-catalog' => '目錄',
        'sicon-cloud' => '雲端',
        'sicon-config-api' => '設定 Api',
        'sicon-config-nav' => '設定 Nav',
        'sicon-connectors' => '連接器',
        'sicon-contracts' => '合約',
        'sicon-currencies' => '貨幣',
        'sicon-diagnostics' => '診斷',
        'sicon-sugar-club' => 'Sugar 俱樂部',
        'sicon-email-campaign' => '電子郵件推廣活動',
        'sicon-email-inbound' => '輸入電子郵件',
        'sicon-email-queue' => '電子郵件佇列',
        'sicon-forecasts' => '預測',
        'sicon-display-modules' => '顯示模組',
        'sicon-email-contacts' => '電子郵件聯絡人',
        'sicon-import' => '匯入',
        'sicon-log-viewer' => '記錄檢視器',
        'sicon-lab' => '實驗室',
        'sicon-map-pin' => '地圖釘',
        'sicon-manufacturers' => '製造商',
        'sicon-update' => '更新',
        'sicon-content-security' => '內容安全',
        'sicon-module-builder' => '模組建立器',
        'sicon-languages' => '語言',
        'sicon-module-loader' => '模組載入器',
        'sicon-oauth-key' => 'OAuth 金鑰',
        'sicon-password-mgmt' => '密碼管理',
        'sicon-opportunities' => '商機',
        'sicon-upgrade' => '升級',
        'sicon-portal' => '入口網站',
        'sicon-product-types' => '產品類型',
        'sicon-quotes' => '報價',
        'sicon-relate-fields' => '相關欄位',
        'sicon-repair' => '修復',
        'sicon-role-mgmt' => '角色管理',
        'sicon-scheduler' => '排程器',
        'sicon-shippers' => '運輸服務供應商',
        'sicon-studio' => 'Studio',
        'sicon-web-logic' => '網路邏輯',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => '稅率',
        'sicon-team-mgmt' => '小組管理',
        'sicon-team-perm' => '小組權限',
        'sicon-tracker' => '追蹤器',
        'sicon-workflow' => '工作流程',
        'sicon-mask' => '遮罩',
        'sicon-mask-disabled' => '遮罩已停用',
        'sicon-email-archive' => '電子郵件封存',
        'sicon-mobile' => '行動裝置',
        'sicon-archive' => '封存',
        'sicon-automate-scroll' => '豎向捲動檢視',
        'sicon-automate-stacked' => '橫向捲動檢視',
        'sicon-pdf-manager' => 'PDF 管理員',
        'sicon-my-sites' => '我的網站',
        'sicon-cloud-insights' => '雲端見解',
        'sicon-sugar-logo-24' => 'Sugar 標誌 24',
        'sicon-sugar-logo-16' => 'Sugar 標誌 16',
        'sicon-task-lg' => '工作 Lg',
        'sicon-web-lg' => '網路 Lg',
        'sicon-events-lg' => '活動 Lg',
        'sicon-sugar-logo-12' => 'Sugar 標誌 12',
        'sicon-tag' => '標籤',
        'sicon-tag-lg' => '標籤 Lg',
        'sicon-bell-lg-line' => '鈴鐺 Lg 行',
        'sicon-matrix-xxl' => '矩陣 Xxl',
        'sicon-advanced-filter' => '進階篩選器',
        'sicon-rows-and-columns-xxl' => '列和欄 Xxl',
        'sicon-summation-details-xxl' => '求和詳情 Xxl',
        'sicon-summation-xxl' => '求和 Xxl',
        'sicon-lock-lg' => '鎖定 Lg',
        'sicon-csv-file-xxl' => 'Csv 檔 Xxl',
        'sicon-logo-linkedin' => '標誌 Linkedin',
        'sicon-briefcase' => '公事包',
        'sicon-car-front' => '汽車前部',
        'sicon-airplane' => '飛機',
        'sicon-laptop' => '筆記型電腦',
        'sicon-logo-instagram' => '標誌 Instagram',
        'sicon-single-bed' => '單人床',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => '標誌 Snapchat',
        'sicon-video-lg' => '視訊 Lg',
        'sicon-reply' => '回覆',
        'sicon-subtract' => '減去',
        'sicon-arrow-up-circle-line' => '向上箭頭圓圈行',
        'sicon-asterisk' => '星號',
        'sicon-dot-circle-o-lg' => '點圓圈 O Lg',
        'sicon-forward' => '轉寄',
        'sicon-video' => '視訊',
        'sicon-gavel' => '木槌',
        'sicon-login' => '登入',
        'sicon-pdf-file-xxl' => 'Pdf 檔 Xxl',
        'sicon-login-lg' => '登入 Lg',
        'sicon-cloud-download-xl' => '雲端下載 Xl',
        'sicon-campaigns-lg' => '推廣活動 Lg',
        'sicon-customer-journey-stages-lg' => '客戶旅程階段 Lg',
        'sicon-role-mgmt-lg' => '角色管理 Lg',
        'sicon-default-module-lg' => '預設模組 Lg',
        'sicon-quoted-line-items-lg' => '報價項目 Lg',
        'sicon-projects-lg' => '專案 Lg',
        'sicon-process-business-rules-lg' => '處理程序商務規則 Lg',
        'sicon-process-email-templates-lg' => '處理程序電子郵件範本 Lg',
        'sicon-processes-lg' => '處理程序 Lg',
        'sicon-process-definitions-lg' => '處理程序定義 Lg',
        'sicon-target-lists-lg' => '目標清單 Lg',
        'sicon-purchased-line-items-lg' => '購買項目 Lg',
        'sicon-user-group-lg' => '使用者群組 Lg',
        'sicon-revenue-line-items-lg' => '營收項目 Lg',
        'sicon-business-centers-lg' => '商務中心 Lg',
        'sicon-logo-fb-simple' => '簡單的標誌 Fb',
        'sicon-forecasts-lg' => '預測 Lg',
        'sicon-contracts-lg' => '合約 Lg',
        'sicon-purchase-lg' => '購買 Lg',
        'sicon-sugar-live-lg' => 'Sugar Live Lg',
        'sicon-customer-journey-lg' => '客戶旅程 Lg',
        'sicon-data-privacy-lg' => '資料隱私權 Lg',
        'sicon-home-lg' => '首頁 Lg',
        'sicon-data-table' => '資料表',
        'sicon-medical-clipboard-lg' => '醫療剪貼板 Lg',
        'sicon-privacy-lg' => '隱私權 Lg',
        'sicon-marketplace' => '市場',
        'sicon-marketplace-lg' => '市場 Lg',
        'sicon-blockquote-lg' => '區塊引述 Lg',
        'sicon-casino-lg' => '賭場 Lg',
        'sicon-jacuzzi-lg' => '按摩浴缸 Lg',
        'sicon-scissors-lg' => '剪刀 Lg',
        'sicon-storage-lg' => '儲存 Lg',
        'sicon-fan-lg' => '風扇 Lg',
        'sicon-medicine-lg' => '藥物 Lg',
        'sicon-plant-lg' => '工廠 Lg',
        'sicon-telescope-lg' => '望遠鏡 Lg',
        'sicon-smart-phone-lg' => '智慧型電話 Lg',
        'sicon-coffee-lg' => '咖啡 Lg',
        'sicon-martini-lg' => '馬丁尼 Lg',
        'sicon-cocktail-lg' => '雞尾酒 Lg',
        'sicon-stadium-lg' => '體育場 Lg',
        'sicon-fire-lg' => '火 Lg',
        'sicon-window-lg' => '窗戶 Lg',
        'sicon-lotus-lg' => '蓮花 Lg',
        'sicon-windmill-lg' => '風車 Lg',
        'sicon-spades-lg' => '黑桃 Lg',
        'sicon-hearts-lg' => '紅心 Lg',
        'sicon-diamonds-lg' => '方塊 Lg',
        'sicon-clubs-lg' => '梅花 lg',
        'sicon-skull-lg' => '骷髏頭 Lg',
        'sicon-send' => '傳送',
        'sicon-world-lg' => '世界 Lg',
        'sicon-airplane-lg' => '飛機 Lg',
        'sicon-planet-lg' => '行星 Lg',
        'sicon-trainer-lg' => '訓練員 Lg',
        'sicon-calculator-lg' => '計算機 Lg',
        'sicon-tv-lg' => '電視 Lg',
        'sicon-video-player-lg' => '視訊播放器 Lg',
        'sicon-media-player-lg' => '媒體播放器 Lg',
        'sicon-decentralize-lg' => '去中心化 Lg',
        'sicon-statistics-lg' => '統計 Lg',
        'sicon-virus-lg' => '病毒 Lg',
        'sicon-shield-lg' => '保護盾 Lg',
        'sicon-plug-lg' => '插頭 Lg',
        'sicon-shuttle-lg' => '穿梭工具 Lg',
        'sicon-soundwave-lg' => '聲波 Lg',
        'sicon-graph-lg' => '圖形 Lg',
        'sicon-playlist-lg' => '播放清單 Lg',
        'sicon-voice-recognition-lg' => '語音辨識 Lg',
        'sicon-machine-learning-lg' => '機器學習 Lg',
        'sicon-bed-lg' => '床 Lg',
        'sicon-blueprint-lg' => '藍圖 Lg',
        'sicon-content-delivery-lg' => '內容傳遞 Lg',
        'sicon-questionnaire-lg' => '問卷 Lg',
        'sicon-presentation-lg' => '簡報 Lg',
        'sicon-organic-lg' => '有機 Lg',
        'sicon-transactions-lg' => '交易 Lg',
        'sicon-wand-lg' => '條形碼閱讀機 Lg',
        'sicon-bin-lg' => '桶 Lg',
        'sicon-sync-lg' => '同步 Lg',
        'sicon-external-authentication-lg' => '外部驗證 Lg',
        'sicon-tracking-activity-lg' => '追蹤活動 Lg',
        'sicon-account' => '帳戶',
        'sicon-meetings-lg' => '會議 Lg',
        'sicon-stacked' => '水平分割視圖',
        'sicon-sidebyside' => '垂直分割視圖',
        ],

        'module_colors_dom' => [
        'army' => '軍隊',
        'coral' => '珊瑚',
        'green' => '綠色',
        'orange' => '橘色',
        'ocean' => '海洋',
        'pacific' => '太平洋',
        'pink' => '粉色',
        'purple' => '紫色',
        'red' => '紅色',
        'teal' => '青色',
        'yellow' => '黃色',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => '新的',
        'In Progress' => '進行中',
        'Closed' => '已關閉',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => '停用',
        'Lack of Progress' => '缺乏進展',
        'Customer-Imposed Deadline' => '客戶設置的截止日期',
        'Account at Risk' => '帳戶存在風險',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => '客戶要求',
        'Internally Requested' => '內部要求',
        ],
        'parent_type_display_escalations' => [
        'Cases' => '案例',
        'Bugs' => 'Bug',
        'Accounts' => '帳戶',
        'Opportunities' => '機會',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => '肯定',
        'Negative' => '否定',
        'Neutral' => '中性',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => '不可能',
        '02_less_likely' => '不太可能',
        '03_neutral' => '中性的',
        '04_more_likely' => '很有可能',
        '05_very_likely' => '非常有可能',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => '與客戶不匹配',
        '02_no_match' => '',
        '01_matches_customers' => '與客戶匹配',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => '潛在客戶',
        'Accounts' => '帳戶',
        'Contacts' => '聯絡人',
        'Cases' => '案例',
        'Opportunities' => '商機',
        ],
        'dri_workflows_state_list' => [
        'not_started' => '未開始',
        'in_progress' => '進行中',
        'completed' => '已完成',
        'cancelled' => '已取消',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => '無',
        'create' => '建立時',
        'stage_start' => '階段啟動時',
        'previous_activity_completed' => '上一個活動已完成',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => '目前使用者',
        'parent_assignee' => '父項受託人',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => '建立天數',
        'days_from_stage_started' => '從階段啟動到現在的天數',
        'days_from_previous_activity_completed' => '從上一個活動已完成到現在的天數',
        'days_from_parent_date_field' => '從父項日期欄位開始的天數',
        'days_from_specific_activity_completed' => '從特定活動已完成到現在的天數',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => '建立時',
        'stage_started' => '階段啟動時',
        'previous_activity_completed' => '上一個活動已完成時',
        'parent_date_field' => '在父項日期欄位',
        'specific_activity_completed' => '特定活動已完成',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => '絕對',
        'Percentage' => '百分比',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => '客戶工作',
        'milestone' => '里程碑',
        'internal_task' => '內部工作',
        'agency_task' => '代理工作',
        'automatic_task' => '自動工作',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => '工作',
        'Calls' => '通話',
        'Meetings' => '會議',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => '無',
        'create' => '建立時',
        'stage_start' => '階段啟動時',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => '繼承',
        'current_user' => '目前使用者',
        'parent_assignee' => '父項受託人',
        'user' => '使用者',
        'team' => '小組',
        'user_team' => '使用者與小組',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => '繼承',
        'none' => '無',
        'create' => '建立時',
        'stage_start' => '階段啟動時',
        'previous_activity_completed' => '上一個活動已完成',
        'specific_activity_completed' => '特定活動已完成',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => '未開始',
        'in_progress' => '進行中',
        'not_completed' => '未完成',
        'completed' => '已完成',
        'cancelled' => '已取消',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => '編輯階段',
        'stage_add_task_button' => '建立工作',
        'stage_add_meeting_button' => '排程會議',
        'stage_add_call_button' => '排程通話',
        'stage_delete_button' => '刪除階段',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => '新增工作',
        'activity_add_sub_meeting_button' => '排程會議',
        'activity_add_sub_call_button' => '排程通話',
        'activity_not_applicable_button' => '不適用',
        'activity_delete_button' => '刪除',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => '設定不適用',
        'remove_open_activities' => '移除開啟的活動',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => '預設',
        'custom' => '自訂',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => 'GET',
        'POST' => 'POST',
        'PUT' => 'PUT',
        'PATCH' => 'PATCH',
        'DELETE' => 'DELETE',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => '跳過請求',
        'json' => 'JSON',
        'http_query' => 'HTTP 查詢',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => '無回應',
        'json' => 'JSON',
        'http_query' => 'HTTP 查詢',
        'text' => '純文字',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => '建立之前',
        'after_create' => '建立之後',
        'before_in_progress' => '進行中之前',
        'after_in_progress' => '進行中之後',
        'before_completed' => '已完成之前',
        'after_completed' => '已完成之後',
        'before_not_applicable' => '不適用之前',
        'after_not_applicable' => '不適用之後',
        'before_delete' => '刪除前',
        'after_delete' => '刪除後',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => '傳送智慧指南資訊',
        'custom_body' => '傳送自訂貼文正文',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => '進行中',
        'completed' => '已完成',
        'not_applicable' => '不適用',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => '檢視記錄',
        'create_record' => '建立記錄',
        'update_record' => '更新記錄',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => '自動建立記錄',
        'manual_create' => '手動建立記錄',
        'automatic_update' => '自動更新記錄',
        'manual_update' => '手動更新記錄',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => '智慧指南範本',
        'DRI_SubWorkflow_Templates' => '階段範本',
        'DRI_Workflow_Task_Templates' => '活動範本',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => '是',
        'no' => '否',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => '已保留',
        'Not Held' => '未舉行',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => '已保留',
        'Not Held' => '未舉行',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => '已完成',
        'Not Applicable' => '不適用',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => '智慧指南範本',
        'DRI_SubWorkflow_Templates' => '階段範本',
        'DRI_Workflow_Task_Templates' => '活動範本',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => '工作',
        'Meetings' => '會議',
        'Calls' => '通話',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => '當前工作',
        'Calls' => '當前通話',
        'Meetings' => '當前會議',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => '特定使用者',
        'specific_contacts' => '特定聯絡人',
        'related_parent_users' => '相關父項使用者',
        'related_parent_contacts' => '相關父項聯絡人',
        'add_all_contacts_from_parent' => '新增父項所有聯絡人',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => '使用者',
        'specific_contacts' => '聯絡人',
        'related_parent_users' => '使用者',
        'related_parent_contacts' => '聯絡人',
        'add_all_contacts_from_parent' => '聯絡人',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => '分鐘',
        'hours' => '小時',
        'days' => '天',
        'months' => '月',
        ],
        'cj_relative_date_type_list' => [
        'days' => '天',
        'months' => '月',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => '固定日期',
        'relative' => '相對日期',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => '使用者',
        'teams' => '小組',
        'roles' => '角色',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Sugar 操作的 Smart Guide',
        'sugar_action_to_smart_guide' => 'Smart Guide 的 Sugar 操作',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide 階段',
        'Smart Guide Activities' => 'Smart Guide 活動',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => '已完成',
        'cancelled' => '已取消',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => '進行中',
        'completed' => '已完成',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => '進行中',
        'completed' => '已完成',
        'not_applicable' => '不適用',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => '將所有活動標記為「已完成」',
        'mark_all_not_applicable' => '將所有未完成的活動標記為不適用',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => '美國（俄勒岡州）[us-west-2]',
        'ca-central-1' => '加拿大（中部）[ca-central-1]',
        'ap-southeast-1' => '亞太地區（新加坡）[ap-southeast-1]',
        'ap-southeast-2' => '亞太地區（雪梨）[ap-southeast-2]',
        'eu-central-1' => '歐洲（法蘭克福）[eu-central-1]',
        'eu-west-2' => '歐洲（倫敦）[eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => '記錄標題', // Studio editing of record views
    'LBL_RECORD_BODY' => '名片', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => '顯示更多', // Studio editing of record views
    'LBL_FAVORITE' => '最愛', // Record view header panel element
    'LBL_FOLLOW' => '關注', // Record view header panel element
    'LBL_FOLLOW_LINK' => '關注連結',
    'LBL_TOGGLE_VISIBILITY' => '切換可見度', // Record view header panel element
    'LBL_ACTIVITIES' => '活動流',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM、Sugar 和 3-D 立方體是 SugarCRM Inc. 的註冊商標。 ' .
        '該產品中使用或出現的所有其他公司和產品的名稱可能是' .
        'SugarCRM®、 Sugar Enterprise™ 和 Sugar™ 是 SugarCRM Inc的商標。',
    'LBL_TRADEMARK2' => 'SugarCRM ®、Sugar Enterprise™ 和 Sugar™ 是 SugarCRM Inc. 的商標。',
    'LBL_SEND_INVITE' => '傳送邀請',
    'LBL_INVITEES' => '客人',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => '訪客將不會收到您的邀請',
    'LBL_SELECT_ACTION_LABEL' => '選取動作',
    'LBL_TOGGLE_DRAWER' => '切換抽屜',
    'LBL_TOUR_NEXT' => '下一步',
    'LBL_TOUR_SKIP' => '跳過',
    'LBL_TOUR_BACK' => '返回',
    'LBL_TOUR_CLOSE' => '關閉',
    'LBL_TOUR_BTN_DONE' => '已完成',
    'LBL_TOUR_TAKE_TOUR' => '瀏覽嚮導',
    'LBL_TOUR_FULL_TOUR' => '完整嚮導',
    'LBL_TOUR_MODULE' => '遊覽此頁面',
    'LBL_TOUR_END_TOUR' => '結束嚮導',
    'LBL_TOUR_OVERVIEW' => '頁面概覽',
    'LBL_TOUR_REVISIT' => '隨時按一下此處顯示嚮導。',
    'LBL_MY_AREA_LINKS' => '我的區域連結： ' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => '獲取連接' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => '歡迎' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => '進階搜尋' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => '更多詳細資料' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => '編輯內嵌' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => '檢視' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => '搜尋' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => '搜尋...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => '移除' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => '新增' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => '欄' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '2 欄' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '3 欄' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => '進階搜尋' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => '新增' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => '隱藏/顯示' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => '刪除' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => '新增' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => '清除' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => 'vCard' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => '取消連結' /*for 508 compliance fix*/,
    'LBL_ADD' => '新增' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => '公司標誌' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => '行事曆' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => '您選擇的下拉列表值更改了記錄視圖佈局。' .
        '此新佈局中隱藏的字段的值已清除。 ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => '開啟',
    'LBL_SIDEBAR_NAV_CLOSE' => '關閉',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} 功能表',
    'LBL_GOTO_SUGARCRM_COM' => '前往 SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => '主要模組導覽',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => '切換子面板',

    'LBL_ADVANCED' => '進階',
    'LBL_BASIC' => '基礎',
    'LBL_MODULE_FILTER' => '篩選按...',
    'LBL_CONNECTORS_POPUPS' => '連接器快顯視窗',
    'LBL_CLOSEINLINE' => '關閉',
    'LBL_EDITINLINE' => '編輯',
    'LBL_VIEWINLINE' => '檢視',
    'LBL_INFOINLINE' => '資訊',
    'LBL_POWERED_BY_SUGARCRM' => '由 SugarCRM 提供技術支援',
    'LBL_PRINT' => '列印',
    'LBL_HELP' => '說明',
    'LBL_TOUR' => '嚮導',
    'LBL_TOUR_LINK' => '遊覽此頁面',
    'LBL_MOBILE' => '行動',
    'LBL_ID_FF_SELECT' => '選擇',
    'DEFAULT' => '基礎',
    'LBL_SORT' => '排序',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => '新增伺服器...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => '透過 SSL 或 TLS 啟用 SMTP？',
    'LBL_NO_ACTION' => '沒有該名稱的操作。',
    'LBL_NO_DATA' => '無資料',
    'LBL_NOT_APPLICABLE' => '不適用',
    'LBL_ROUTING_ADD_RULE' => '新增規則',
    'LBL_ROUTING_ALL' => '至少',
    'LBL_ROUTING_ANY' => '任何',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => '取消',
    'LBL_ROUTING_BUTTON_SAVE' => '儲存規則',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => '複製郵件',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => '刪除 Sugar 對象',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => '刪除檔案',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => '刪除電子郵件',
    'LBL_ROUTING_ACTIONS_FORWARD' => '轉寄電子郵件',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => '標記電子郵件',
    'LBL_ROUTING_ACTIONS_MARK_READ' => '標記為已讀',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => '標記為未讀',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => '移動電子郵件',
    'LBL_ROUTING_ACTIONS_PEFORM' => '執行下列動作',
    'LBL_ROUTING_ACTIONS_REPLY' => '回覆電子郵件',

    'LBL_ROUTING_CHECK_RULE' => "偵測到錯誤：\n",
    'LBL_ROUTING_CHECK_RULE_DESC' => '請驗證所有標記的欄位。',
    'LBL_ROUTING_CONFIRM_DELETE' => "您確定要刪除此規則嗎？\n此動作無法復原。",

    'LBL_ROUTING_FLAGGED' => '設置標識',
    'LBL_ROUTING_FORM_DESC' => '儲存規則將立即被激活。',
    'LBL_ROUTING_FW' => '轉寄：',
    'LBL_ROUTING_LIST_TITLE' => '規則',
    'LBL_ROUTING_MATCH' => '如果',
    'LBL_ROUTING_MATCH_2' => '符合下列條件︰',
    'LBL_NOTIFICATIONS' => '通知',
    'LBL_ROUTING_MATCH_CC_ADDR' => '抄送',
    'LBL_ROUTING_MATCH_DESCRIPTION' => '正文內容',
    'LBL_ROUTING_MATCH_FROM_ADDR' => '發件者',
    'LBL_ROUTING_MATCH_NAME' => '主題',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => '高優先順序',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => '標準優先順序',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => '低優先順序',
    'LBL_ROUTING_MATCH_TO_ADDR' => '至',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => '包含',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => '不包含',

    'LBL_ROUTING_NAME' => '規則名稱',
    'LBL_ROUTING_NEW_NAME' => '新規則',
    'LBL_ROUTING_ONE_MOMENT' => '請稍等片刻...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => '隨後是原始郵件。',
    'LBL_ROUTING_RE' => '回覆：',
    'LBL_ROUTING_SAVING_RULE' => '正在儲存規則',
    'LBL_ROUTING_SUB_DESC' => '檢查的規則正在使用中。按一下名稱來編輯。',
    'LBL_ROUTING_TO' => '收件者',
    'LBL_ROUTING_TO_ADDRESS' => '至地址',
    'LBL_ROUTING_WITH_TEMPLATE' => '與範本',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => '此記錄目前包含辦公室電話和地址欄位的值。如需使用您選取的帳戶中的下列辦公室電話和地址，請按一下「確定」。如需保留目前值，按一下「取消」。',
    'LBL_DROP_HERE' => '[拖放於此處]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => '編輯',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => '預填充 Gmail&#153; 預設值',
    'LBL_EMAIL_ACCOUNTS_NAME' => '名稱',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => '外寄郵件伺服器屬性',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => '郵件傳輸代理程式',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => '使用 SMTP 驗證？',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP 密碼',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP 連接埠',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP 伺服器',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => '連接時使用 SSL ',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP 使用者名稱',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => '預設',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => '警告︰缺少外寄郵件帳戶使用者名稱和密碼。',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => '必須填寫 SMTP 使用者名稱',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => '必須填寫 SMTP 密碼',
    'LBL_EMAIL_ACCOUNTS_TITLE' => '郵件帳戶管理',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => '下一個版本將不再支援 POP3 類型的郵件伺服器協定。只支援 IMAP。',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => '設定郵件帳戶以檢視您的電子郵件帳戶即將收到的電子郵件。',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => '提供 SMTP 郵件伺服器資訊，以用於郵件帳戶中的外寄電子郵件。',
    'LBL_EMAIL_ADD' => '新增電子郵件',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => '已完成',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => '清除',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => '收件者：',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => '抄送：',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => '密件抄送：',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => '收件者/抄送/密件抄送',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => '新清單',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => '電子郵件地址',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => '目前僅支援連絡人編輯。',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => '篩選器',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => '名字/帳戶名稱',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => '姓氏',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => '我的連絡人',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => '我的郵寄清單',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => '名稱',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => '找不到地址',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => '儲存並添加至地址簿',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => '搜尋',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => '選取電子郵件收件者',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => '地址簿',
    'LBL_EMAIL_REPORTS_TITLE' => '報表',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => '警告！您正在刪除的外寄帳戶與現有傳入帳戶相關聯。 您確定要繼續嗎？',
    'LBL_EMAIL_ADDRESSES' => '電子郵件',
    'LBL_EMAIL_ADDRESS_PRIMARY' => '電子郵件地址',
    'LBL_EMAIL_ADDRESSES_TITLE' => '電子郵件地址',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => '匯入至 Sugar',
    'LBL_EMAIL_ASSIGNMENT' => '指派',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => '附加',
    'LBL_EMAIL_ATTACHMENT' => '附加',
    'LBL_EMAIL_ATTACHMENTS' => '從本地系統',
    'LBL_EMAIL_ATTACHMENTS2' => '從 Sugar 文件',
    'LBL_EMAIL_ATTACHMENTS3' => '範本附件',
    'LBL_EMAIL_ATTACHMENTS_FILE' => '檔案',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => '文件',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => '內嵌',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => '附件上載失敗',
    'LBL_REMOVING_ATTACHMENT' => '正在移除附件...',
    'LBL_EMAIL_BCC' => '密件副本',
    'LBL_EMAIL_CANCEL' => '取消',
    'LBL_EMAIL_CC' => '抄送',
    'LBL_EMAIL_CHARSET' => '字元集',
    'LBL_EMAIL_CHECK' => '檢查郵件',
    'LBL_EMAIL_CHECKING_NEW' => '檢查新電子郵件',
    'LBL_EMAIL_CHECKING_DESC' => '請稍候...<br><br>如果這就您第一次查看郵件帳戶，它可能需要一些時間。',
    'LBL_EMAIL_CLOSE' => '關閉',
    'LBL_EMAIL_COFFEE_BREAK' => '檢查新電子郵件。<br><br>較大的郵件帳戶可能要花費大量的時間。',
    'LBL_EMAIL_COMMON' => '常見',

    'LBL_EMAIL_COMPOSE' => '電子郵件',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => '請輸入此電子郵件的收件者。',
    'LBL_EMAIL_COMPOSE_LINK_TO' => '關聯至',
    'LBL_EMAIL_COMPOSE_NO_BODY' => '此電子郵件的正文為空。要發送嗎？',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => '此電子郵件沒有主題。要發送嗎？',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '（無主題）',
    'LBL_EMAIL_COMPOSE_READ' => '閱讀和撰寫電子郵件',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => '從郵件帳戶傳送',
    'LBL_EMAIL_COMPOSE_OPTIONS' => '選項',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => '請在抄送和密件副本欄位輸入有效的電子郵件地址',

    'LBL_EMAIL_CONFIRM_CLOSE' => '要丟棄這封電子郵件嗎？',
    'LBL_EMAIL_CONFIRM_DELETE' => '從地址簿中移除這些項目？',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => '您確定要刪除這個簽名嗎？',

    'LBL_EMAIL_CREATE_NEW' => '--儲存時建立--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => '多個',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => '空',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => '按寄件者顯示傳送日期',
    'LBL_EMAIL_DATE_RECEIVED' => '接收日期',
    'LBL_EMAIL_ASSIGNED_TO_USER' => '已指派至使用者',
    'LBL_EMAIL_DATE_TODAY' => '今天',
    'LBL_EMAIL_DATE_YESTERDAY' => '昨天',
    'LBL_EMAIL_DD_TEXT' => '已選取的電子郵件。',
    'LBL_EMAIL_DEFAULTS' => '預設值',
    'LBL_EMAIL_DELETE' => '刪除',
    'LBL_EMAIL_DELETE_CONFIRM' => '刪除選取的訊息？',
    'LBL_EMAIL_DELETE_SUCCESS' => '已成功刪除電子郵件。',
    'LBL_EMAIL_DELETING_MESSAGE' => '正在刪除訊息',
    'LBL_EMAIL_DETAILS' => '詳細資料',
    'LBL_EMAIL_DISPLAY_MSG' => '正在顯示電子郵件 {0} - 第 {1} 封，共 {2} 封',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => '正在顯示電子郵件地址 {0} - 第 {1} 個，共 {2} 個',

    'LBL_EMAIL_EDIT_CONTACT' => '編輯連絡人',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => '使用連絡人時，只能使用主要地址。',
    'LBL_EMAIL_EDIT_MAILING_LIST' => '編輯郵寄清單',

    'LBL_EMAIL_EMPTYING_TRASH' => '正在清空垃圾桶',
    'LBL_EMAIL_DELETING_OUTBOUND' => '正在刪除外寄伺服器',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => '正在清除快取檔案',
    'LBL_EMAIL_EMPTY_MSG' => '沒有要顯示的電子郵件。',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => '沒有要顯示的電子郵件地址。',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => '資料夾名稱必須唯一且不得為空。請再試一次。',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => '無法刪除資料夾。該資料夾或其子資料夾有關聯的電子郵件或郵箱。',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => '無法從路徑確定所需的資料夾。請再試一次。',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => '請檢查您的設定。',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => '請確保輸入您的姓氏。',
    'LBL_EMAIL_ERROR_DESC' => '偵測到錯誤：',
    'LBL_EMAIL_DELETE_ERROR_DESC' => '您無此區域的存取權限。請連絡您的站點管理員以取得權限。',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar 資料夾名稱必須是唯一的。',
    'LBL_EMAIL_ERROR_EMPTY' => '請輸入搜尋標準。',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => '出錯',
    'LBL_EMAIL_ERROR_LIST_NAME' => '已存在一封使用此名稱的電子郵件',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => '從伺服器上移除資訊',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => '訊息將從伺服器移除，或移動至不同的資料夾',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => '連接郵件伺服器失敗。請連絡管理員',
    'LBL_EMAIL_ERROR_MOVE' => '目前不支援在伺服器之間和/或郵件帳戶之間移動電子郵件。',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => '移動錯誤',
    'LBL_EMAIL_ERROR_NAME' => '必須填寫名稱。',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => '必須填寫發件者地址。請輸入有效電子郵件地址。',
    'LBL_EMAIL_ERROR_NO_FILE' => '請提供檔案。',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => '目前不支援 IMAP 資料夾重新命名。',
    'LBL_EMAIL_ERROR_SERVER' => '必須填寫郵件伺服器位址。',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => '郵件帳戶可能未儲存。',
    'LBL_EMAIL_ERROR_TIMEOUT' => '與郵件伺服器通訊時出錯。',
    'LBL_EMAIL_ERROR_USER' => '必須填寫登入名稱。',
    'LBL_EMAIL_ERROR_PASSWORD' => '必須填寫密碼。',
    'LBL_EMAIL_ERROR_PORT' => '必須填寫郵件伺服器連接埠。',
    'LBL_EMAIL_ERROR_PROTOCOL' => '必須填寫伺服器協定。',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => '必須提供受監視的資料夾。',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => '必須提供 Trash 資料夾。',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => '此資訊不可用。',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => '未指定外寄郵件伺服器。',
    'LBL_EMAIL_FOLDERS' => '資料夾',
    'LBL_EMAIL_FOLDERS_ACTIONS' => '移動至',
    'LBL_EMAIL_FOLDERS_ADD' => '新增',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => '新增資料夾',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => '重新命名資料夾',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => '儲存',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => '新增此資料夾至',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => '無法變更此資料夾',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => '您確定要刪除此資料夾嗎？不可反轉此流程。資料夾刪除將串連至所有包含此資料夾的其他資料夾。',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => '新資料夾名稱',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => '請選取一個資料夾，然後執行此動作。',
    'LBL_EMAIL_FOLDERS_TITLE' => '資料夾管理',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => '使用群組',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => '指派至小組',
    'LBL_EMAIL_FORWARD' => '轉寄',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => '正在下載 [total] 封電子郵件中的第 [count] 封',
    'LBL_EMAIL_FOUND' => '已找到',
    'LBL_EMAIL_FROM' => '發件者',
    'LBL_EMAIL_GROUP' => '群組',
    'LBL_EMAIL_UPPER_CASE_GROUP' => '群組',
    'LBL_EMAIL_HOME_FOLDER' => '首頁',
    'LBL_EMAIL_HTML_RTF' => '傳送 HTML',
    'LBL_EMAIL_IE_DELETE' => '正在刪除郵件帳戶',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => '正在刪除簽名',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => '您確定要刪除此郵件帳戶嗎？',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => '已成功刪除。',
    'LBL_EMAIL_IE_SAVE' => '正在儲存郵件帳戶資訊',
    'LBL_EMAIL_IMPORTING_EMAIL' => '正在匯入電子郵件',
    'LBL_EMAIL_IMPORT_EMAIL' => '匯入至 Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => '匯入設定',
    'LBL_EMAIL_INVALID' => '無效',
    'LBL_EMAIL_LINK_RECORD' => '按一下此處',
    'LBL_EMAIL_LIST_RENAME_TITLE' => '重新命名郵寄清單',
    'LBL_EMAIL_LIST_RENAME_DESC ' => '為此郵寄清單輸入一個新名稱',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => '從郵寄清單中移除這些項目？',
    'LBL_EMAIL_LOADING' => '載入中...',
    'LBL_EMAIL_MARK' => '標記',
    'LBL_EMAIL_MARK_FLAGGED' => '為已標幟',
    'LBL_EMAIL_MARK_READ' => '為已讀',
    'LBL_EMAIL_MARK_UNFLAGGED' => '為未標幟',
    'LBL_EMAIL_MARK_UNREAD' => '為未讀',
    'LBL_EMAIL_ASSIGN_TO' => '指派給',

    'LBL_EMAIL_MENU_ADD_FOLDER' => '建立資料夾',
    'LBL_EMAIL_MENU_COMPOSE' => '撰寫',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => '刪除資料夾',
    'LBL_EMAIL_MENU_EDIT' => '編輯',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => '清空垃圾桶',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => '同步',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => '清除快取檔案',
    'LBL_EMAIL_MENU_REMOVE' => '移除',
    'LBL_EMAIL_MENU_RENAME' => '重新命名',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => '重新命名資料夾',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => '正在重新命名資料夾',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => '請在嘗試此作業前做出選擇。',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => '建立資料夾 (遠端或在 Sugar 中)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => '將此類電子郵件封存至 SugarCRM',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => '向選取的郵寄清單發送電子郵件',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => '向此連絡人發送電子郵件',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => '移除連絡人',
    'LBL_EMAIL_MENU_HELP_DELETE' => '刪除這些電子郵件',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => '刪除資料夾 (遠端或在 Sugar 中)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => '編輯連絡人',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => '編輯郵寄清單',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => '清空您的郵件帳戶中的所有 Trash 資料夾',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => '將所有電子郵件標記為已標識',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => '將所有電子郵件標記為已讀',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => '將所有電子郵件標記為未標識',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => '將所有電子郵件標記為未讀',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => '移除郵寄清單',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => '重新命名資料夾 (遠端或在 Sugar 中)',
    'LBL_EMAIL_MENU_HELP_REPLY' => '回覆這些電子郵件',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => '回覆給這些電子郵件的所有收件者',

    'LBL_EMAIL_MESSAGES' => '訊息',

    'LBL_EMAIL_ML_NAME' => '清單名稱',
    'LBL_EMAIL_ML_ADDRESSES_1' => '選取的清單地址',
    'LBL_EMAIL_ML_ADDRESSES_2' => '可用清單地址',

    'LBL_EMAIL_MULTISELECT' => '<b>按一下 Ctrl </b> 選取多項<br />(Mac 使用者使用 <b>CMD 鍵</b>)',

    'LBL_EMAIL_NO' => '否',
    'LBL_EMAIL_NOT_SENT' => '發送請求電子郵件時遇到問題。請連絡系統管理員。',
    'LBL_INSERT_TO_USER_PWD_FAILED' => '無法插入 users_password_link。',

    'LBL_EMAIL_OK' => '確定',
    'LBL_EMAIL_ONE_MOMENT' => '請稍等片刻...',
    'LBL_EMAIL_OPEN_ALL' => '打開多個訊息',
    'LBL_EMAIL_OPTIONS' => '選項',
    'LBL_EMAIL_QUICK_COMPOSE' => '快速撰寫',
    'LBL_EMAIL_OPT_OUT' => '選擇退出',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => '選擇退出和無效的',
    'LBL_EMAIL_PAGE_AFTER' => '{0}',
    'LBL_EMAIL_PAGE_BEFORE' => '頁面',
    'LBL_EMAIL_PERFORMING_TASK' => '正在執行工作',
    'LBL_EMAIL_PRIMARY' => '主要',
    'LBL_EMAIL_PRINT' => '列印',

    'LBL_EMAIL_QC_BUGS' => '錯誤',
    'LBL_EMAIL_QC_CASES' => '實例',
    'LBL_EMAIL_QC_LEADS' => '潛在客戶',
    'LBL_EMAIL_QC_CONTACTS' => '連絡人',
    'LBL_EMAIL_QC_TASKS' => '工作',
    'LBL_EMAIL_QC_OPPORTUNITIES' => '商機',
    'LBL_EMAIL_QUICK_CREATE' => '快速建立',

    'LBL_EMAIL_REBUILDING_FOLDERS' => '正在重建資料夾',
    'LBL_EMAIL_RELATE_TO' => '相關',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => '檢視關係',
    'LBL_EMAIL_RECORD' => '電子郵件記錄',
    'LBL_EMAIL_REMOVE' => '移除',
    'LBL_EMAIL_REPLY' => '回覆',
    'LBL_EMAIL_REPLY_ALL' => '回覆所有',
    'LBL_EMAIL_REPLY_TO' => '收件者',
    'LBL_EMAIL_RETRIEVING_LIST' => '正在抓取電子郵件清單',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => '正在抓取資訊',
    'LBL_EMAIL_RETRIEVING_RECORD' => '正在抓取電子郵件記錄',
    'LBL_EMAIL_SELECT_ONE_RECORD' => '請僅選取一條電子郵件記錄',
    'LBL_EMAIL_RETURN_TO_VIEW' => '返回至上一個模組？',
    'LBL_EMAIL_REVERT' => '還原',
    'LBL_EMAIL_RELATE_EMAIL' => '關聯郵件',

    'LBL_EMAIL_RULES_TITLE' => '規則管理',

    'LBL_EMAIL_SAVE' => '儲存',
    'LBL_EMAIL_SAVE_AND_REPLY' => '儲存和回覆',
    'LBL_EMAIL_SAVE_DRAFT' => '儲存草稿',

    'LBL_EMAIL_SEARCHING' => '執行搜尋',
    'LBL_EMAIL_SEARCH_ADVANCED' => '進階搜尋',
    'LBL_EMAIL_SEARCH_DATE_FROM' => '開始日期',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => '結束日期',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => '正文文字',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => '沒有符合您的搜尋標準的結果。',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => '搜尋結果',
    'LBL_EMAIL_SEARCH_TITLE' => '簡易搜尋',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => '搜尋電子郵件帳戶',

    'LBL_EMAIL_SELECT' => '選擇',

    'LBL_EMAIL_SEND' => '傳送',
    'LBL_EMAIL_SENDING_EMAIL' => '正在傳送電子郵件',

    'LBL_EMAIL_SETTINGS' => '設定',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 列',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 欄',
    'LBL_EMAIL_SETTINGS_LAYOUT' => '版面配置樣式',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => '郵件帳戶',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => '清除表單',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => '在檢視表中匯入電子郵件',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => '檢查新郵件',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => '使用預覽窗格',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => '使用快顯視窗',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => '每頁顯示電子郵件數',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => '編輯郵件帳戶',
    'LBL_EMAIL_SETTINGS_FOLDERS' => '資料夾',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => '發件者地址',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => '用於測試通知的電子郵件地址：',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => '收件者電子郵件地址',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => '發件者姓名',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => '收件者地址',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => '全螢幕',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => '同步所有郵件帳戶',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => '已使用外寄郵件設定將電子郵件傳送至指定電子郵件地址。請查看能否收到郵件以驗證設定是否正確。',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => '執行此動作將同步郵件帳戶及其內容。',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => '執行完全同步？\n較大的郵件帳戶可能需要幾分鐘時間。',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => '按一下 Shift 鍵或 Ctrl 鍵以選取多個資料夾。',
    'LBL_EMAIL_SETTINGS_GENERAL' => '一般',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => '可用群組資料夾',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => '建立群組資料夾',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => '正在儲存群組資料夾',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => '正在抓取群組資料夾',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => '編輯群組資料夾',

    'LBL_EMAIL_SETTINGS_NAME' => '郵件帳戶名稱',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => '選取收件匣中每頁顯示的郵件數目。此設置可能需要重新整理頁面才能生效。',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => '正在抓取郵件帳戶',
    'LBL_EMAIL_SETTINGS_RULES' => '規則',
    'LBL_EMAIL_SETTINGS_SAVED' => '已儲存此設置。',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => '您必須重新載入此頁面以使新設定生效。',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => '僅傳送純文字電子郵件',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => '使用中',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => '每頁的電子郵件',
    'LBL_EMAIL_SETTINGS_TAB_POS' => '將標籤放置於底部',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => '視覺效果設定',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => '首選項',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => '顯示進階',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => '可用使用者資料夾',
    'LBL_EMAIL_ERROR_PREPEND' => '錯誤：',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => '您為正在使用的郵件帳戶選取的外寄郵件伺服器無效。請檢查設定或為此郵件帳戶選取不同的郵件伺服器。',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => '未設定外寄郵件伺服器，無法傳送電子郵件。請設定外寄郵件伺服器，或在「設定 >> 郵件帳戶」中為您正在使用的郵件帳戶選取一個外寄郵件伺服器。',
    'LBL_EMAIL_SHOW_READ' => '顯示所有',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => '僅顯示未讀郵件',
    'LBL_EMAIL_SIGNATURES' => '簽名',
    'LBL_EMAIL_SIGNATURE_CREATE' => '建立簽名',
    'LBL_EMAIL_SIGNATURE_NAME' => '簽名名稱',
    'LBL_EMAIL_SIGNATURE_TEXT' => '簽名主體',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google Less-Secure 應用程式',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! 郵箱',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => '其他',
    'LBL_EMAIL_AUTHORIZE' => '授權',
    'LBL_EMAIL_AUTHORIZED' => '已授權',
    'LBL_EMAIL_NOT_AUTHORIZED' => '未授權',
    'LBL_EMAIL_AUTH_WARNING' => '管理员必須先通過“管理”>“連接器”配置 {0} 連接器，然後才能設置此帳戶。有關詳細訊息，請參閱 {1} 文檔。',
    'LBL_EMAIL_AUTH_API_ERROR' => '檢索連接器訊息時出錯',
    'LBL_EMAIL_AUTH_FAILURE' => '授權失敗。',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => '請在保存之前授權帳戶。',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => '請在測試之前授權帳戶。',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => '帳戶未經授權',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[遠端資料夾]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[Sugar 資料夾]',
    'LBL_EMAIL_SUBJECT' => '主題',
    'LBL_EMAIL_SUCCESS' => '成功',
    'LBL_EMAIL_SUGAR_FOLDER' => 'SugarFolder',
    'LBL_EMAIL_TEAMS' => '指派至小組',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => '電子郵件範本的正文為空',
    'LBL_EMAIL_TEMPLATES' => '範本',
    'LBL_EMAIL_TEXT_FIRST' => '第一頁',
    'LBL_EMAIL_TEXT_PREV' => '上一頁',
    'LBL_EMAIL_TEXT_NEXT' => '下一頁',
    'LBL_EMAIL_TEXT_LAST' => '最後一頁',
    'LBL_EMAIL_TEXT_REFRESH' => '重新整理',
    'LBL_EMAIL_TO' => '至',
    'LBL_EMAIL_TOGGLE_LIST' => '切換清單',
    'LBL_EMAIL_VIEW' => '檢視',
    'LBL_EMAIL_VIEWS' => '檢視表',
    'LBL_EMAIL_VIEW_HEADERS' => '顯示標題',
    'LBL_EMAIL_VIEW_PRINTABLE' => '可列印版本',
    'LBL_EMAIL_VIEW_RAW' => '顯示原始電子郵件',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => '使用 POP3 時不支援此功能',
    'LBL_DEFAULT_LINK_TEXT' => '預設連結文字。',
    'LBL_EMAIL_YES' => '是',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => '傳送測試電子郵件',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => '已傳送測試電子郵件',


    'LBL_EMAIL_MESSAGE_NO' => '訊息編號',
    'LBL_EMAIL_IMPORT_SUCCESS' => '已通過匯入',
    'LBL_EMAIL_IMPORT_FAIL' => '匯入失敗，因為訊息已匯入或已從伺服器刪除。',

    'LBL_EMAILS_FROM' => '已傳送電子郵件',
    'LBL_EMAILS_RECEIVED' => '電子郵件已接收',
    'LBL_EMAIL_ADDRESSES_USED' => '在電子郵件中使用的電子郵件地址',
    'LBL_EMAIL_ADDRESS' => '電子郵件地址',
    'LBL_FROM' => '發件者',
    'LBL_TO' => '收件者',
    'LBL_CC' => 'CC',
    'LBL_BCC' => '密件副本',

    'LBL_START_DATE' => '開始日期',
    'LBL_END_DATE' => '結束日期',
    'LBL_START' => '開始',
    'LBL_END' => '結束',
    'LBL_DATE_LINKED' => '連結日期',

    'LBL_LINK_NONE' => '無',
    'LBL_LINK_ALL' => '所有',
    'LBL_LINK_RECORDS' => '記錄',
    'LBL_LINK_SELECT' => '選擇',
    'LBL_LINK_ACTIONS' => '動作',
    'LBL_LINK_MORE' => '更多',
    'LBL_CLOSE_ACTIVITY_HEADER' => '確認',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => '要關閉此 #module# 嗎？',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => '以後不顯示此訊息：&nbsp;',
    'LBL_INVALID_FILE_EXTENSION' => '無效的副檔名',
    'LBL_LIST_TEAM' => '小組',
    'LBL_TEAM' => '小組：',
    'LBL_TEAMS' => '小組',
    'LBL_TEAM_SET_ID' => '小組集 ID',
    'LBL_TEAM_SET_SELECTED_ID' => '選定的團隊集合 ID',
    'LBL_TEAM_SET_SELECTED' => '已選取',
    'LBL_TEAM_SET_ENABLE' => '啟用附加使用權限',
    'LBL_TEAM_SET_DISABLE' => '停用附加使用權限',
    'LBL_TEAM_SET' => '小組集',
    'LBL_TEAM_SET_SELECTED_TEAMS' => '已選取小組',
    'LBL_SEARCH_UNAVAILABLE' => '搜尋不可用，請稍後再試一次。',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => '未指定主要小組',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => '嘗試移除主要小組 ID {0} 時出錯，此 ID 用於 {1} 模組，其 ID 為 {2}',
    'LBL_TEAM_ADD' => '新增&nbsp;小組',
    'LBL_TEAM_REMOVE' => '移除小組',
    'LBL_TEAM_PRIMARY' => '設定為主要小組',

    'LBL_CLOSE_BUTTON_LABEL' => '關閉',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} 標記為 {{status}}。',

    'LBL_FOCUS' => '注目',

    'LBL_QUERY_VALID' => '有效',
    'LBL_QUERY_ERROR' => '錯誤！',
    'LBL_QUERY_CHILD' => '有效的子查詢',
    'ERROR_EXAMINE_MSG' => '請檢查下面的錯誤訊息：',
    'NO_QUERY_SELECTED' => '您選取的資料格式不包含查詢。 請為此資料格式選取自訂查詢。',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => '出錯：',
    'ERR_AJAX_LOAD_FAILURE' => '處理您的請求時出錯，請稍後再試一次。',
    'ERR_AJAX_LOAD_FOOTER' => '如果此錯誤仍然存在，請要求您的管理員停用此模組的 Ajax',
    'ERR_CREATING_FIELDS' => '填寫其他詳情欄位時出錯：',
    'ERR_CREATING_TABLE' => '建立表格時出錯：',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => '小數點分隔符不能使用與千位分隔符相同的字元。請更改其中一個值。',
    'ERR_DELETE_RECORD' => '必須指定記錄編號才能刪除連絡人。',
    'ERR_EXPORT_DISABLED' => '匯出已停用。',
    'ERR_EXPORT_TYPE' => '匯出時出錯',
    'ERR_REPORTS_DISABLED_EXPORT' => '已停用報告匯出',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => '僅管理員用戶可以匯出',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => '報表使用沒有匯出存取權限的模組',
    'ERR_REPORTS_EXPORT_OWNER' => '報表使用有擁有者匯出存取權限的模組',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => '報表使用有列出限制存取的模組',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => '報表使用有視圖限制存取的模組',
    'ERR_REPORTS_ACCESS_DISABLED' => '報表使用有限制存取的模組',
    'ERR_REPORTS_FIELDS_RESTRICTED' => '報表使用有限制存取的欄位',
    'ERR_INVALID_AMOUNT' => '請輸入一個有效金額。',
    'ERR_INVALID_DATE_FORMAT' => '日期格式必須為：',
    'ERR_INVALID_DATE' => '請輸入一個有效日期。',
    'ERR_INVALID_DAY' => '請輸入有效天。',
    'ERR_INVALID_EMAIL_ADDRESS' => '不是有效的電子郵件地址。',
    'ERR_INVALID_FILE_REFERENCE' => '無效檔案參考',
    'ERR_INVALID_HOUR' => '請輸入有效小時。',
    'ERR_INVALID_MONTH' => '請輸入有效的月份。',
    'ERR_INVALID_TIME' => '請輸入有效的時間。',
    'ERR_INVALID_YEAR' => '請輸入有效的 4 位數年份。',
    'ERR_NEED_ACTIVE_SESSION' => '需要一個使用中工作階段才能匯出內容。',
    'ERR_NO_HEADER_ID' => '該功能在此主題中不可用。',
    'ERR_NOT_ADMIN' => '未經授權存取管理。',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        '只可在<a href="%s" target="_blank">SugarCloud 設置</a>中進行密碼管理。',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => '如果要更改唯讀欄位, 請與您的Sugar管理員聯繫。',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => '請訪問 <a href="{0}" target="_blank">SugarCloud 設置</a> 對唯獨字段進行變更。',
    'ERR_MISSING_REQUIRED_FIELDS' => '缺少必填欄位：',
    'ERR_INVALID_REQUIRED_FIELDS' => '無效的必填欄位：',
    'ERR_INVALID_VALUE' => '無效值：',
    'ERR_NO_SUCH_FILE' => '檔案在系統中不存在',
    'ERR_NO_SINGLE_QUOTE' => '無法將單引號用於',
    'ERR_NOTHING_SELECTED' => '請在繼續之前做出選擇。',
    'ERR_OPPORTUNITY_NAME_DUPE' => '已存在名稱為 %s 的商機。請在下方輸入另一個名稱。',
    'ERR_OPPORTUNITY_NAME_MISSING' => '未輸入商機名稱。請在下方輸入商機名稱。',
    'ERR_QUOTE_CONVERTED' => '此報價已轉換至一個商機。',
    'ERR_POTENTIAL_SEGFAULT' => '偵測到可能的 Apache 分割故障。請通知您的管理員以確認此問題，並要求她/他報告至 SugarCRM。',
    'ERR_SELF_REPORTING' => '使用者無法報告至本人。',
    'ERR_SINGLE_QUOTE' => '此欄位不支援使用單引號。請變更值。',
    'ERR_SQS_NO_MATCH_FIELD' => '欄位沒有匹配項：',
    'ERR_SQS_NO_MATCH' => '無匹配',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => '請在 displayParams 屬性中為終極資料定義指定「key」索引。',
    'ERR_EXISTING_PORTAL_USERNAME' => '錯誤：入口網站名稱已指派給另一個連絡人。',
    'ERR_PORTAL_NAME_CHECK' => '無法驗證該入口網站使用者是否是唯一的',
    'ERR_COMPATIBLE_PRECISION_VALUE' => '欄位值與精確值不相容',
    'ERR_EXTERNAL_API_SAVE_FAIL' => '嘗試儲存外部帳戶時出錯。',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => '上載時出錯。請確保您正在上載的檔案不為空。',
    'ERR_NO_DB' => '無法連接至資料庫。請參閱 sugarcrm.log 了解詳細資料。',
    'ERR_DB_FAIL' => '資料庫故障。請參閱 sugarcrm.log 了解詳細資料。',
    'ERR_EXTERNAL_API_403' => '使用權限被拒。不支援此檔案類型。',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth 存取權杖已丟失。',
    'ERR_DB_VERSION' => 'Sugar CRM {0} 檔案只能在 Sugar CRM {1} 資料庫中使用。',
    'ERR_DB_QUERY' => '{0}：查詢失敗：{1}',
    'ERR_UW_RETIRED' => '此版本的升級精靈不可用。',
    'ERR_NOT_CLOUD_INSTANCE' => 'Sugar 的執行個體既非 SugarCloud 執行個體，也沒有設定成 SugarCloud 見解。',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => '您沒有權限建立 {moduleName}。如需權限，請連絡您的管理員。',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => '目前使用者沒有權限變更 {moduleName} 配置設定。',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => '目前使用者沒有權限變更 {moduleName} 配置設定。',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => '您沒有權限將 {moduleName} 添加為最愛。如需權限，請連絡您的管理員。',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => '您沒有權限訂閱 {moduleName}。如需權限，請連絡您的管理員。',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => '負載中worksheet_columns_related_fields不存在',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns 不是陣列',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => '負載中 summary_columns_related_fields不存在',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows 不是陣列',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => '負載中footer_rows_related_fields不存在',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => '您的請求由於未知的例外狀況而失敗。',
    'EXCEPTION_FATAL_ERROR' => '您的請求無法完成。出現一個嚴重錯誤。請查看記錄檔了解更多詳細資料。',
    'EXCEPTION_NEED_LOGIN' => '您需要登入以執行此動作。',
    'EXCEPTION_INVALID_TOKEN' => '您的驗證權杖無效。',
    'EXCEPTION_NOT_AUTHORIZED' => '您沒有權限執行此動作。如需權限，請連絡您的管理員。',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => '您沒有權限檢視檔案 。如需權限，請連絡您的管理員。',
    'EXCEPTION_INACTIVE_PORTAL_USER' => '您無法存取入口網站，因為您的入口網站帳戶還未激活。如需權限，請連絡您的管理員。',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => '入口網站未正確設定。請連絡您的入口網站管理員取得援助。',
    'EXCEPTION_NO_METHOD' => '不支援您的請求。找不到您為此路徑請求的 HTTP 方法。',
    'EXCEPTION_NOT_FOUND' => '找不到您請求的資源。找不到請求所指定路徑的處理常式。',
    'EXCEPTION_MISSING_PARAMTER' => '您的請求缺乏一個必要參數。',
    'EXCEPTION_INVALID_PARAMETER' => '您的請求包含一個無效參數。',
    'EXCEPTION_REQUEST_FAILURE' => '您的請求無法完成。',
    'EXCEPTION_METADATA_OUT_OF_DATE' => '您的中繼資料或使用者雜湊與伺服器不一致。請重新同步您的中繼資料。',
    'EXCEPTION_REQUEST_TOO_LARGE' => '您的請求太大，因而無法處理。',
    'EXCEPTION_EDIT_CONFLICT' => '編輯衝突，請重新載入記錄資料。',
    'EXCEPTION_METADATA_CONFLICT' => '中繼資料衝突，請重新載入中繼資料。',
    'EXCEPTION_CLIENT_OUTDATED' => '您的軟體已過期，請更新您的用戶端，然後嘗試重新連接。',
    'EXCEPTION_CONNECTOR_RESPONSE' => '連接器或整合請求導致失敗的回應。',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM 正處於維護模式。只有管理員可以登入。請連絡您的管理員了解詳細資料。',
    'EXCEPTION_SERVICE_UNAVAILABLE' => '伺服器無法處理您的請求，因為伺服器目前繁忙或不可用。',
    'EXCEPTION_SEARCH_UNAVAILABLE' => '搜尋引擎暫時不可用。',
    'EXCEPTION_SEARCH_RUNTIME' => '搜尋引擎執行階段出錯。請連絡您的系統管理員。',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => '無法編輯流程鎖定的欄位。',
    'EXCEPTION_MODULE_DISABLED' => '此模塊已針對當前用戶禁用。',
    'EXCEPTION_FIELD_DISABLED' => '此字段已針對當前用戶禁用。',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => '此用戶端不受允許',
    'EXCEPTION_MODULELOADER_UPLOAD' => '上傳軟件包的功能不適用於您的許可證類型',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => '由於一般故障或錯誤而發生異常狀況。但此異常範圍的原因通常不是由於更具體的 API 異常範圍。',
    'EXCEPTION_FATAL_ERROR_DESC' => '無法處理您提出的請求，或者有錯誤的回應。這通常意味著出現致命錯誤，您可在應用程式記錄檔中確定具體故障。',
    'EXCEPTION_INCORRECT_VERSION_DESC' => '您正在使用的 API 版本不是目前請求需要的版本。',
    'EXCEPTION_NEED_LOGIN_DESC' => '請求的端點需要身份驗證，而提出請求的取用者沒有經過驗證。',
    'EXCEPTION_INVALID_TOKEN_DESC' => '表示請求提供的驗證 Token 無效。這通常是由於 Token 過期，但也可能由於 Token 格式不正確或出現錯誤。',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => '表示提出請求的取用者未獲授權執行所請求的行動。',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => '與已登入使用者關聯的入口網站帳戶目前未在使用中。這需要由客戶支援採取此行動。',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => '表示入口網站應用程式未正確設定且無法使用。這需要由入口網站管理員完成此行動。',
    'EXCEPTION_NO_METHOD_DESC' => '端點不支援正在提出的 HTTP 請求類型，比如這可能由於 POST 請求發送到了僅支援 GET 請求的端點。',
    'EXCEPTION_NOT_FOUND_DESC' => '端點無法找到請求的資源，或沒有此請求的處理常式。',
    'EXCEPTION_EDIT_CONFLICT_DESC' => '表示可能正在同時對同一記錄進行編輯，目前的記錄編輯請求可能會影響之前的編輯。',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => '表示伺服器上的終極資料與用戶端目前正在使用的終極資料不一致。這可能由系統設定變更、工作室中的模組變更、新模組部署以及其他系統變更造成。',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => '請求太大，伺服器無法處理。',
    'EXCEPTION_MISSING_PARAMTER_DESC' => '表示請求缺少一個必要的參數。',
    'EXCEPTION_INVALID_PARAMETER_DESC' => '表示請求傳送的一個參數無效。',
    'EXCEPTION_REQUEST_FAILURE_DESC' => '請求無法完成。',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => '表示取用 API 的用戶端已過期，必須進行更新，才能進一步取用 API。',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => '表示透過 API 向其他服務、端點或 URI 提出的請求已失敗，或無法由伺服器處理。',
    'EXCEPTION_MAINTENANCE_DESC' => '對 API 適用的 SugarCRM 實例處於維護模式。API 存取僅限管理員。',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => '表示伺服器忙碌、多載或已關閉。',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => '由於連接問題，搜尋引擎後端目前暫時不可用。請在「管理員」->「搜尋」->「測試」中確認連接和設定。',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => '搜尋引擎出現執行階段例外狀況。請查看 sugarcrm.log 了解更多詳細資料。',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => '無法對執行中流程當前鎖定的欄位進行編輯。',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s 已被執行中流程鎖定，無法編輯。',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s 已被執行中流程鎖定，無法編輯。',
    'EXCEPTION_MODULE_DISABLED_DESC' => '此模塊已針對當前用戶禁用。',
    'EXCEPTION_FIELD_DISABLED_DESC' => '此字段已針對當前用戶禁用。',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => '此用戶端不受允許',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => '系統中已經存在具有相同名稱的檔案。',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => '日期 {0} 未定義錯誤時間週期',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => '此時間週期已經存在子週期',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => '分時間週期不能有子週期',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => '無法抓取任何 {0} 類型的時間週期。',
    'ERR_NO_ACTIVE_TIMEPERIOD' => '當前設定沒有使用中時間週期。',
    'LBL_CURRENT_TIMEPERIOD' => '目前時間週期',
    'LBL_PREVIOUS_TIMEPERIOD' => '上一個時間週期',
    'LBL_NEXT_TIMEPERIOD' => '下一個時間週期',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => '上一個、目前、下一個',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => '您無法刪除帶已結束銷售階段的記錄。',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => '您無法刪除帶已結束銷售狀態的記錄。',

    'WARNING_NO_DELETE_SELECTED_STAGE' => '一個或多個已選取記錄帶「結束並贏得客戶」或「結束但客戶流失」銷售階段，無法被刪除。',
    'WARNING_NO_DELETE_SELECTED_STATUS' => '一個或多個已選取記錄帶「結束並贏得客戶」或「結束但客戶流失」狀態，無法被刪除。',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => '帳戶',
    'LBL_OLD_ACCOUNT_LINK' => '舊賬戶',
    'LBL_ACCOUNTS' => '帳戶',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => '活動',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => '檢視摘要',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => '檢視摘要',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => '新增',
    'LBL_ADD_BUTTON' => '新增',
    'LBL_ADD_DASHLET_BUTTON' => '添加列表',
    'LBL_ADD_DOCUMENT' => '新增文件',
    'LBL_REPLACE_BUTTON' => '替代',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => '新增至目標清單',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => '新增至目標清單',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => '按一下以關閉',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => '關閉',
    'LBL_ADDITIONAL_DETAILS' => '更多詳細資料',
    'LBL_ADMIN' => '管理員',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => '封存',
    'LBL_ASSIGNED_TO_USER' => '已指派至使用者',
    'LBL_ASSIGNED_TO' => '指派至：',
    'LBL_BACK' => '返回',
    'LBL_BASE_RATE' => '基底匯率',
    'LBL_BILL_TO_ACCOUNT' => '收票方賬戶',
    'LBL_BILL_TO_CONTACT' => '收票方連絡人',
    'LBL_BILLING_ADDRESS' => '帳單地址',
    'LBL_QUICK_CREATE_TITLE' => '快速建立',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => '錯誤',
    'LBL_BY' => '透過',
    'LBL_CALLS' => '通話',
    'LBL_CALL' => '通話',
    'LBL_CAMPAIGNS_SEND_QUEUED' => '傳送已佇列推廣活動電子郵件',
    'LBL_SUBMIT_BUTTON_LABEL' => '提交',
    'LBL_CASE' => '實例',
    'LBL_CASES' => '實例',
    'LBL_MESSAGE' => '訊息',
    'LBL_MESSAGES' => '訊息',
    'LBL_ESCALATIONS' => '升級',
    'LBL_ESCALATION' => '升級',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign 信封',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign 信封',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => '選擇簽名者收件人',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => '修改密碼',
    'LBL_CHANGE_BUTTON_LABEL' => '變更',
    'LBL_CHANGE_BUTTON_TITLE' => '變更',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => '檢查所有',
    'LBL_CITY' => '城市',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => '清除',
    'LBL_CLEAR_BUTTON_TITLE' => '清除',
    'LBL_CLEARALL' => '清除所有',
    'LBL_CLICK_TO_EDIT' => '按一下以編輯',
    'LBL_CLOSE_BUTTON_TITLE' => '關閉',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => '關閉視窗',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => '關閉所有',
    'LBL_CLOSEALL_BUTTON_TITLE' => '關閉所有',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => '關閉和新建',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => '關閉和新建',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => '複製記錄網址',
    'LBL_OPEN_ITEMS' => '打開項目：',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => '撰寫電子郵件',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => '電子郵件',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => '撰寫電子郵件',
    'LBL_SEARCH_DROPDOWN_YES' => '是',
    'LBL_SEARCH_DROPDOWN_NO' => '否',
    'LBL_CONTACT_LIST' => '連絡人清單',
    'LBL_CONTACT' => '連絡人',
    'LBL_CONTACTS' => '連絡人',
    'LBL_CONTRACTS' => '合約',
    'LBL_COUNTRY' => '國家：',
    'LBL_RESET_BUTTON_LABEL' => '重設',
    'LBL_CREATE_BUTTON_LABEL' => '建立',
    'LBL_CREATED_BY_USER' => '由使用者建立',
    'LBL_CREATED_USER' => '由使用者建立',
    'LBL_CREATED_ID' => '按 ID 建立',
    'LBL_CREATED' => '建立人',
    'LBL_CREATE_NEW_TARGET_LIST' => '建立新目標清單',
    'LBL_CURRENT_USER_FILTER' => '我的項目：',
    'LBL_CURRENCY' => '貨幣：',
    'LBL_CURRENCIES' => '貨幣：',
    'LBL_CURRENCY_NAME' => '貨幣名稱',
    'LBL_CURRENCY_SYMBOL' => '貨幣符號',
    'LBL_CURRENCY_RATE' => '基準利率：',
    'LBL_CURRENCY_ID' => '貨幣 ID',
    'LBL_DOCUMENTS' => '文件',
    'LBL_DATE_ENTERED' => '建立日期：',
    'LBL_DATE_MODIFIED' => '修改日期：',
    'LBL_ACTIVITY_MODIFIED' => '已修改',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => '編輯概述選項卡',
    'LBL_EDIT_MODULE_TABS_BUTTON' => '編輯模組選項卡',
    'LBL_EDIT_BUTTON' => '編輯',
    'LBL_DUPLICATE_BUTTON' => '複製',
    'LBL_DELETE_BUTTON' => '刪除',
    'LBL_DELETE' => '刪除',
    'LBL_DELETED' => '已刪除',
    'LBL_DIRECT_REPORTS' => '直屬員工',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => '已完成',
    'LBL_DONE_BUTTON_TITLE' => '已完成',
    'LBL_DST_NEEDS_FIXIN' => '應用程式要求應用日光節約時間修復。請造訪管理員主控台中的<a href="index.php?module=Administration&action=DstFix">修復</a>連結並應用日光節約時間修復。',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => '編輯時新建',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => '編輯時新建',
    'LBL_EDIT_IN_NEW_TAB' => '編輯新分頁',
    'LBL_FAVORITES' => '最愛',
    'LBL_FILTER' => '篩選條件',
    'LBL_DEFAULT_DATA_FILTER' => '預設資料篩選器',
    'LBL_FILTER_MENU_BY' => '篩選功能表',
    'LBL_FILTER_SELECT_FIELD' => '選取欄位...',
    'LBL_FILTER_SELECT_OPERATOR' => '選取操作員...',
    'LBL_FILTER_CREATE_NEW' => '建立',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => '生成篩選器(未保存)',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '(未保存)',
    'LBL_FILTER_CREATE_FILTER' => '建立新的篩選條件',
    'LBL_FILTER_CLOSE_FILTER' => '關閉過濾器',
    'LBL_FILTER_EDIT_FILTER' => '編輯篩選器',
    'LBL_FILTER_ALL_RECORDS' => '所有記錄',
    'TPL_FILTER_SAVE' => '您已成功建立篩選器 {{name}}。',
    'LBL_FILTER_BETWEEN_FROM' => '發件者',
    'LBL_FILTER_BETWEEN_TO' => '至',
    'LBL_FILTER_DATEBETWEEN_FROM' => '開始日期',
    'LBL_FILTER_DATEBETWEEN_TO' => '結束日期',
    'LBL_FOLLOWING' => '正在關注',
    'LBL_UNFOLLOW' => '取消關注',
    'LBL_VCARD' => 'vCard',
    'LBL_VCARD_DOWNLOAD' => '下載 vCard',
    'LBL_EMPTY_VCARD' => '請選取一個 vCard 檔案',
    'LBL_IMAGE' => '圖像',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard 沒有此模組要求的所有必填欄位。',
    'LBL_VCARD_ERROR_FILESIZE' => '已上載檔案超過了 HTML 表單中指定的 30000 位元大小限制。',
    'LBL_VCARD_ERROR_DEFAULT' => '上載 vCard 檔案時出錯。',
    'TPL_IMPORT_VCARD_FAILURE' => '無法從 vCard 建立 {{module}}',
    'LBL_IMPORT_VCARD' => '匯入 vCard：',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => '匯入 vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => '匯入 vCard',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => '檢視',
    'LBL_VIEW_BUTTON_TITLE' => '檢視',
    'LBL_VIEW_BUTTON' => '檢視',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => '以 PDF 格式發送電子郵件',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => '以 PDF 格式發送電子郵件',
    'LBL_EMAIL' => '電子郵件',
    'LBL_EMAILS' => '電子郵件',
    'LBL_EMPLOYEES' => '員工',
    'LBL_ENTER_DATE' => '輸入日期',
    'LBL_EXPORT_ALL' => '匯出所有',
    'LBL_EXPORT' => '匯出',
    'LBL_FAVORITES_FILTER' => '我的最愛：',
    'LBL_GLOBAL_SEARCH' => '全域搜尋',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => '全域搜尋模組篩選器',
    'LBL_GLOBAL_SEARCH_RUN' => '運行全域搜尋',
    'LBL_GO_BUTTON_LABEL' => '前往',
    'LBL_GS_HELP' => '此搜尋使用的欄位在該模組中顯示如上。亮顯文字與您的搜尋標準相符。',
    'LBL_HIDE' => '隱藏',
    'LBL_ID' => 'ID',
    'LBL_IMPORT' => '匯入',
    'LBL_IMPORT_STARTED' => '已開始匯入：',
    'LBL_MISSING_CUSTOM_DELIMITER' => '必須指定自訂分隔符。',
    'LBL_LAST_VIEWED' => '最近檢視',
    'LBL_SELECTED_RECORDS' => '已選取：',
    'TPL_MAX_PILLS_DISPLAYED' => '只顯示 {{maxPillsDisplayed}} 記錄。',
    'TPL_MORE_RECORDS' => '已選取更多 {{recordsLeft}} 記錄。',
    'TPL_RECORDS_SELECTED' => '已選取 {{recordsLeft}} 記錄。',
    'LBL_SHOW_LESS' => '顯示小於',
    'LBL_SHOW_MORE' => '顯示更多',
    'LBL_SHOW_MORE_MODULE' => '更多 {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => '更多近期記錄...',
    'LBL_SHOW_LESS_RECENTS' => '小於近期記錄',
    'LBL_SHOW_MORE_RESULTS' => '更多搜尋結果...',
    'TPL_SHOW_MORE_MODULE' => '更多 {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => '更多 {{name}}...',
    'LBL_TODAYS_ACTIVITIES' => '今日活動',
    'LBL_LEADS' => '潛在客戶',
    'LBL_LEAD' => '潛在客戶',
    'LBL_QUOTES_BILL_TO' => '報價（帳單至）',
    'LBL_LESS' => '小於',
    'LBL_CAMPAIGN' => '推廣活動：',
    'LBL_CAMPAIGNS' => '推廣活動',
    'LBL_CAMPAIGNLOG' => 'CampaignLog',
    'LBL_CAMPAIGN_CONTACT' => '推廣活動',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => '主題：',
    'LBL_THEME_PICKER' => '頁面樣式',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => '警告：選取的主題不支援 Internet Explorer 6。按一下「確定」以選取，或按一下「取消」選取不同主題。',
    'LBL_FOUND_IN_RELEASE' => '已在版本中發現',
    'LBL_FIXED_IN_RELEASE' => '發行版本中修復',
    'LBL_LIST_ACCOUNT_NAME' => '帳戶名稱',
    'LBL_LIST_ASSIGNED_USER' => '使用者',
    'LBL_LIST_CONTACT_NAME' => '連絡人姓名',
    'LBL_LIST_CONTACT_ROLE' => '連絡人角色',
    'LBL_LIST_DATE_ENTERED' => '建立日期',
    'LBL_LIST_EMAIL' => '電子郵件',
    'LBL_LIST_NAME' => '名稱',
    'LBL_LIST_OF' => '的',
    'LBL_LIST_PHONE' => '電話',
    'LBL_LIST_RELATED_TO' => '關聯至',
    'LBL_LIST_USER_NAME' => '使用者名稱',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => '您確定要更新整個清單嗎？',
    'LBL_LISTVIEW_NO_SELECTED' => '請選取至少 1 項記錄以繼續操作。',
    'LBL_LISTVIEW_TWO_REQUIRED' => '請選取至少 2 項記錄以繼續操作。',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => '請選取10 項以下的記錄以繼續操作。',
    'LBL_LISTVIEW_ALL' => '所有',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => '凍結第 1 列',
    'LBL_DUPECHECK_FILTER_DEFAULT' => '所有重複項',
    'LBL_LISTVIEW_NONE' => '取消所有已選取項',
    'LBL_LISTVIEW_OPTION_CURRENT' => '選取此頁面',
    'LBL_LISTVIEW_OPTION_ENTIRE' => '選取所有',
    'LBL_LISTVIEW_OPTION_SELECTED' => '已選取記錄',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => '已選取：',
    'LBL_LISTVIEW_SELECTED_CLEAR' => '清除所有項目。',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => '選取所有記錄',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => '結果集中有超過 {{num}} 項記錄。您已選取前 {{num}} 項記錄。',
    'TPL_LISTVIEW_SELECTED' => '您已在結果集中選取 {{num}} 項記錄。',
    'TPL_LISTVIEW_SELECTED_ONE' => '您已在結果集中選取 1 項記錄。',
    'TPL_LISTVIEW_SELECTED_ALL' => '您已選取結果集中的所有 {{num}} 項記錄。',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => '您已選取此檢視表中的所有 {{num}} 項記錄。{{link}} 在結果集內。',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => '在 {{total}} 條記錄中上傳 {{num}} 條',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(約剩下 {{time}} {{unit}})',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => '大量更新失敗。啟動新的嘗試 ({{total}} 項中的 {{num}} 項)。',
    'TPL_MASSUPDATE_WARNING_CLOSE' => '未完成大量更新。{{num}} 記錄保持不變。',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => '未完成大量更新。{{num}} 記錄保持不變。',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '{{remain}} 個記錄因權限或錯誤而被忽略。',
    'TPL_MASSUPDATE_SUCCESS' => '已成功更新 {{num}} 項記錄。',
    'TPL_MASSUPDATE_TITLE' => '{{module}} 大量更新',
    'TPL_MASSDELETE_PROGRESS_STATUS' => '在 {{total}} 條記錄中刪除 {{num}} 條',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(約剩下 {{time}} {{unit}})',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => '大量刪除失敗。啟動新的嘗試 ({{total}} 項中的 {{num}} 項)。',
    'TPL_MASSDELETE_WARNING_CLOSE' => '未完成大量更新。剩餘 {{num}} 項記錄。',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => '未完成大量更新。剩餘 {{num}} 項記錄。',
    'TPL_MASSDELETE_SUCCESS' => '已成功刪除 {{num}} 項記錄。',
    'TPL_MASSDELETE_TITLE' => '{{module}} 大量刪除',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => '正在新增 {{total}} 項中的第 {{num}} 項',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(約剩下 {{time}} {{unit}})',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => '大量新增至目標清單失敗。啟動新的嘗試 （{{total}} 項中的 {{num}} 項）。',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => '未完成大量新增至目標清單。還有 {{num}} 項記錄未新增。',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => '未完成大量新增至目標清單。還有 {{num}} 項記錄未新增。',
    'TPL_MASSADDTOLIST_SUCCESS' => '已成功新增 {{num}} 項記錄。',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}}大量新增至目標清單',
    'TPL_MASSLINK_PROGRESS_STATUS' => '正在連結 {{total}} 項中的第 {{num}} 項',
    'TPL_MASSLINK_DURATION_FORMAT' => '(約剩下 {{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => '大量連結失敗。啟動新的嘗試 ({{total}} 項中的 {{num}} 項)。',
    'TPL_MASSLINK_WARNING_CLOSE' => '未完成大量連結。還有 {{num}} 項記錄未新增。',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => '未完成大量連結。還有 {{num}} 項記錄未新增。',
    'TPL_MASSLINK_SUCCESS' => '已成功連結 {{num}} 項記錄。',
    'TPL_MASSLINK_TITLE' => '{{module}} 大量連結',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => '選擇',
    'LBL_LISTVIEW_ACTIONS' => '動作',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => '選擇此頁面上的所有記錄',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => '取消選擇此頁面上的所有記錄',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{total}} 項中的第 {{num}} 項',
    'TPL_LIST_HEADER_COUNT_LOADING' => '加載的 {{num}} 條',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => '按一下查看總計',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => '的',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => '獲取頁數',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'David',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Livingstone',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Dr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Code Monkey Extraordinaire',
    'LBL_LOGIN_TO_ACCESS' => '請登入以存取此區域。',
    'LBL_LOGOUT' => '登出',
    'LBL_FINISH_IMPERSONATING' => '完成模擬',
    'LBL_RESET_MFA' => '重置多重身份驗證',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}，您目前正在模仿 {{user}}。',
    'LBL_PROFILE' => '設定檔',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => '合併列印',
    'LBL_MASS_UPDATE' => '大規模更新',
    'LBL_MASS_UPDATE_ALL_RECORDS' => '選擇所有記錄進行批量更新',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => '在批量更新中包含記錄',
    'LBL_MASS_UPDATE_ADD_FIELD' => '新增欄位',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => '移除欄位',
    'LBL_GENERATE_QUOTE' => '產生報價',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => '「大量更新」作業請求沒有可用欄位',
    'LBL_MASS_UPDATE_JOB_QUEUED' => '您的「大量更新」請求已經被排程。',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => '服務開始日期晚於服務結束日期',
    'LBL_MASS_UPDATE_SUCCESS' => '已成功更新所有記錄。',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => '已將選取的記錄新增至 <a href="{{listUrl}}">{{listName}}</a>目標清單。',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => '您將選取記錄新增至 <a href="{{listUrl}}">{{listName}}</a>目標清單的請求已經被排程。',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => '更新將移除以下值：',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => '按一下「取消」保存現有值。按一下「確認」移除這些值。',
    'LBL_OPT_OUT_FLAG_PRIMARY' => '選擇退出主電子郵件',
    'LBL_MEETINGS' => '會議',
    'LBL_MEETING' => '會議',
    'LBL_MEETING_GO_BACK' => '返回會議',
    'LBL_MEMBERS' => '成員',
    'LBL_MEMBER_OF' => '成員',
    'LBL_MODIFIED_BY_USER' => '由使用者修改',
    'LBL_MODIFIED_USER' => '由使用者修改',
    'LBL_MODIFIED' => '修改人',
    'LBL_MODIFIED_NAME' => '修改人',
    'LBL_MODIFIED_ID' => '按 ID 修改',
    'LBL_MORE' => '更多',
    'LBL_MORE_MODULES' => '更多模組',
    'LBL_MORE_TABS' => '更多分頁',
    'LBL_MULTIPLE_MODULES' => '多個模組',
    'LBL_COUNT_MODULES' => '{{count}} 個模組',
    'LBL_MY_ACCOUNT' => '我的設定',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => '系統預設',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => '使用者預設',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => '使用者帳戶',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => '群組帳戶',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => '名稱',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => '建立',
    'LBL_NEW_BUTTON_TITLE' => '建立',
    'LBL_NEXT_BUTTON_LABEL' => '下一步',
    'LBL_NOTES' => '附註',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => '打開所有',
    'LBL_OPENALL_BUTTON_TITLE' => '打開所有',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => '打開至：',
    'LBL_OPENTO_BUTTON_TITLE' => '打開至：',
    'LBL_OPEN_IN_NEW_TAB' => '開啟新分頁',
    'LBL_OPPORTUNITIES' => '商機',
    'LBL_OPPORTUNITY_NAME' => '商機名稱',
    'LBL_OPPORTUNITY' => '商機',
    'LBL_OR' => '或',
    'LBL_LOWER_OR' => '或',
    'LBL_PANEL_ASSIGNMENT' => '其他',
    'LBL_PANEL_ADVANCED' => '更多資訊',
    'LBL_PANEL_BODY' => '概觀',
    'LBL_PARENT_TYPE' => '父代類型',
    'LBL_RELATED_TYPE' => '相關類型',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => '範圍',
    'LBL_PICTURE_FILE' => '虛擬人偶',
    'LBL_POSTAL_CODE' => '郵遞區號：',
    'LBL_PRIMARY_ADDRESS_CITY' => '主要地址城市：',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => '主要地址國家：',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => '主要地址郵遞區號：',
    'LBL_PRIMARY_ADDRESS_STATE' => '主要地址州：',
    'LBL_PRIMARY_ADDRESS_STREET_2' => '主要地址街道 2：',
    'LBL_PRIMARY_ADDRESS_STREET_3' => '主要地址街道 3：',
    'LBL_PRIMARY_ADDRESS_STREET' => '主要地址街道：',
    'LBL_PRIMARY_ADDRESS' => '主要地址：',

    'LBL_BILLING_STREET' => '街道：',
    'LBL_SHIPPING_STREET' => '街道：',

    'LBL_PRODUCT_BUNDLES' => '產品同捆',
    'LBL_PRODUCTS' => '產品',
    'LBL_PROJECT_TASKS' => '專案工作',
    'LBL_PRODUCT_TEMPLATES' => '產品範本',
    'LBL_PROJECTS' => '專案',
    'LBL_PROSPECTS' => '目標',
    'LBL_QUICK_CREATE_MENU' => '快速建立功能表',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => '從報價單建立商機',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => '從報價單建立商機',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => '建立商機......',
    'LBL_QUOTES_SHIP_TO' => '報價（送貨至）',
    'LBL_QUOTES' => '報價',

    'LBL_FORECAST_WORKSHEETS' => '預測工作表',
    'LBL_FORECAST_WORKSHEET' => '預測工作表',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => '邀請',
    'LBL_INVITED' => '已邀請',
    'LBL_RECOMMENDED_INVITES' => '推薦的邀請',
    'LBL_INSTANCES' => '實例',
    'LBL_YOUR_INSTANCES' => '您的實例',
    'LBL_INSTANCE_USERS' => '實例使用者',
    'LBL_SWITCH_INSTANCE' => '切換至此實例',
    'LBL_LAST_LOGIN' => '上次登入',
    'LBL_ENTER_EMAIL' => '輸入受邀者電子郵件...',
    'LBL_INSTANCE_IN_USE' => '使用中的實例',
    'LBL_INSTANCE_ACTIVE' => '您已經準備好使用此實例！',
    'LBL_INSTANCE_INVITE_SENT' => '邀請已發送至',
    'LBL_INSTANCE_SWITCH_FAILED' => '無法切換實例',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => '提醒',
    'LBL_REMINDERS_OVERDUE' => '逾期',
    'LBL_REMINDERS_UPCOMING' => '即將開始的',
    'LBL_REMINDERS_NONE_FOUND' => '找不到提醒。',
    'LBL_REMINDERS_FINISHED' => '已完成！',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => '商機計量',

    'LBL_SWEETSPOT' => 'Sweet Spot',
    'LBL_SWEETSPOT_CONFIG' => 'Sweet Spot 設定面板',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => '熱鍵	',
    'LBL_SWEETSPOT_CONFIG_ERR' => '無法更新設定首選項：{{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => 'Sweet Spot 動作',
    'LBL_SWEETSPOT_KEY' => '關鍵字',
    'LBL_SWEETSPOT_REMOVE' => '移除動作',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => '熱鍵	',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => '動作',
    'LBL_SWEETSPOT_RECORDS_SECTION' => '記錄',
    'LBL_SWEETSPOT_THEME' => '主題',
    'LBL_SWEETSPOT_THEME_SELECT' => '選取主題',

    'LBL_RELATED' => '相關',
    'LBL_RELATED_INFORMATION' => '相關資訊',
    'LBL_RELATED_RECORDS' => '相關 {{module}}',
    'LBL_REPORTS_TO' => '報表發送對象',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => '表示必填欄位',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => '已完成',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => '另存為',
    'LBL_SAVE_AS_BUTTON_TITLE' => '另存為',
    'LBL_FULL_FORM_BUTTON_KEY' => 'L',
    'LBL_FULL_FORM_BUTTON_LABEL' => '完整表單',
    'LBL_FULL_FORM_BUTTON_TITLE' => '完整表單',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => '儲存和建立新',
    'LBL_SAVE_NEW_BUTTON_TITLE' => '儲存和建立新',
    'LBL_SAVE_OBJECT' => '儲存 {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => '搜尋',
    'LBL_SEARCH_BUTTON_TITLE' => '搜尋',
    'LBL_SEARCH' => '搜尋',
    'LBL_SEARCH_TIPS' => '按一下「搜尋」按鈕或按一下 Enter 獲取完全相符項。',
    'LBL_SEARCH_TIPS_2' => '按一下「搜尋」按鈕或按一下 Enter 獲取完全相符項',
    'LBL_SEARCH_MORE' => '更多',
    'LBL_SEE_ALL' => '查看所有',
    'LBL_SEARCH_LOAD_MORE' => '載入更多',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => '無效檔案格式，只能上載圖像檔案。',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => '不再支援圖像格式 {0}。',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => '選擇',
    'LBL_SELECT_BUTTON_TITLE' => '選擇',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => '新增小組',
    'LBL_SELECT_TEAMS_TITLE' => '新增小組',
    'LBL_SELECT_APPEND_TEAMS' => '附加小組',
    'LBL_SELECT_APPEND_VALUES' => '附加值',
    'LBL_SELECT_APPEND_TAGS' => '附加標籤',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => '瀏覽文件',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => '瀏覽文件',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => '選取連絡人',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => '選取連絡人',
    'LBL_GRID_SELECTED_FILE' => '已選取的檔案',
    'LBL_GRID_SELECTED_FILES' => '已選取的檔案',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => '從報表中選取',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => '選取報表',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => '選取使用者',
    'LBL_SELECT_USER_BUTTON_TITLE' => '選取使用者',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => '清除選取項目',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => '清除選取項目',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => '清除選取項目',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => '清除選取項目',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => '選取檔案',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => '選取檔案',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => '清除檔案',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => '清除檔案',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => '選取使用者',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => '選取使用者',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => '清除使用者',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => '清除使用者',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => '選取帳戶',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => '選取帳戶',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => '清除帳戶',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => '清除帳戶',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => '選取推廣活動',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => '選取推廣活動',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => '清除推廣活動',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => '清除推廣活動',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => '選取連絡人',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => '選取連絡人',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => '清除連絡人',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => '清除連絡人',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => '選取小組',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => '選取小組',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => '清除小組',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => '清除小組',
    'LBL_SERVER_RESPONSE_RESOURCES' => '用於建構此頁面的資源（查詢、檔案）',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => '秒。',
    'LBL_SERVER_RESPONSE_TIME' => '伺服器回應時間：',
    'LBL_SERVER_MEMORY_BYTES' => '位元',
    'LBL_SERVER_MEMORY_USAGE' => '伺服器記憶體使用量：{0}{1}',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => '使用量：- 模組：{0} - 動作： {1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => '伺服器最大記憶體使用量：{0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => '收貨帳戶',
    'LBL_SHIP_TO_CONTACT' => '收貨連絡人',
    'LBL_SHIPPING_ADDRESS' => '運送地址',
    'LBL_SHORTCUTS' => '捷徑',
    'LBL_SHOW' => '顯示',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => '狀態：',
    'LBL_STATUS_UPDATED' => '已為此事件更新您的狀態！',
    'LBL_STATUS_NOT_UPDATED' => '您還未更新此事件的狀態。',
    'LBL_STATUS' => '狀態：',
    'LBL_STREET' => '街道',
    'LBL_SUBJECT' => '主題',

    'LBL_INBOUNDEMAIL_ID' => '輸入電子郵件 ID',
    'LBL_EAMP_ID' => '驗證令牌 ID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        '保留所有權利。<br />SugarCRM、Sugar 和 3-D 立方體是 SugarCRM Inc. 的註冊商標。 ' .
        '該產品中使用或出現的所有其他公司和產品的名稱可能是' .
        '與此類名稱有關的公司的商標。',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => '已完成排程的工作',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => '已成功運行已排程的工作',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => '營收項目現已在您的 Sugar 實例中啟用',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => '營收項目現已在您的 Sugar 實例中啟用，所有現有商機資料均已處理。您的實例已經準備好配合營收項目使用。如需了解已做出變更的更多詳細資料，請參閱 {{doc_url}}。
誠摯的 SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => '您現在可配合商機在 Sugar 實例中使用預測模組。',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => 'Sugar 實例中的預測模組現在可配合商機使用。所有先前營收項目預測提交資料均已移除，此實例可用於配合商機建立和提交預測。如需了解已做出變更的更多詳細資料，請參閱 {{doc_url}}。
誠摯的 SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => '現已在您的 Sugar 實例中停用營收項目',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => '營收項目現已在您的 Sugar 實例中停用，所有現有營收項目資料均已處理。您的實例已經準備好配合商機使用。如需了解已做出變更的更多詳細資料，請參閱 {{doc_url}}。
誠摯的 SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => '商機設定文件',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => '登入',
    'LBL_LOGIN_WELCOME_TO' => '歡迎來到',
    'LBL_LOGIN_OPTIONS' => '選項',
    'LBL_LOGIN_FORGOT_PASSWORD' => '忘記密碼？',
    'LBL_LOGIN_SUBMIT' => '提交',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => '太多次失敗登入嘗試。',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => '您可重新嘗試登入',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => '天。',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => '小時',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => '分鐘',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => '秒',
    'LBL_LOGIN_ADMIN_CALL' => '請連絡系統管理員。',
    'LBL_LOGIN_USERNAME' => '使用者名稱',
    'LBL_LOGIN_PASSWORD' => '密碼',
    'LBL_LOGGED_OUT' => '您已經登出。',
    'LBL_LOGIN_FORM_LABEL' => '在表單中顯示記錄',
    'LBL_RETURN_TO_LOGIN_PAGE' => '返回到登入',
    'LBL_LOGIN_INACTIVE_USER' => '停用用戶',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => '門戶或團隊使用者不能登入。',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => '儀表板',
    'LBL_SYNC' => '同步',
    'LBL_TASKS' => '工作',
    'LBL_TEAMS_LINK' => '小組',
    'LBL_THEME_COLOR' => '顏色',
    'LBL_THEME_FONT' => '字型',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => '排程會議',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => '排程會議',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => '封存電子郵件',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => '封存電子郵件',
    'LBL_UNAUTH_ADMIN' => '未經授權的管理存取',
    'LBL_UNDELETE_BUTTON_LABEL' => '取消刪除',
    'LBL_UNDELETE_BUTTON_TITLE' => '取消刪除',
    'LBL_UNDELETE_BUTTON' => '取消刪除',
    'LBL_UNDELETE' => '取消刪除',
    'LBL_UNSYNC' => '取消同步',
    'LBL_UPDATE' => '更新',
    'LBL_UPDATES' => '更新',
    'LBL_USER_LIST' => '使用者清單',
    'LBL_USER_MENU' => '使用者功能表',
    'LBL_USERS_SYNC' => '使用者同步',
    'LBL_USERS' => '使用者',
    'LBL_USER' => '使用者',
    'LBL_CURRENT_USER' => '目前使用者',
    'LBL_VERIFY_EMAIL_ADDRESS' => '檢查現有電子郵件項目...',
    'LBL_VERIFY_PORTAL_NAME' => '檢查現有入口網站名稱...',
    'LBL_VIEW_IMAGE' => '檢視',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => '以 PDF 格式列印',
    'LBL_VIEW_PDF_BUTTON_TITLE' => '以 PDF 格式列印',

    'LBL_KBDOCUMENTS' => '知識庫',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => '關於',
    'LNK_ADVANCED_SEARCH' => '進階搜尋',
    'LNK_BASIC_SEARCH' => '基礎搜尋',
    'LNK_SEARCH_NO_RESULTS' => '找不到結果。',
    'LNK_SEARCH_FTS_VIEW_ALL' => '檢視所有結果',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => '顯示所有',
    'LNK_CLOSE' => '關閉',
    'LBL_MODIFY_CURRENT_SEARCH' => '修改目前搜尋',
    'LNK_SAVED_VIEWS' => '配置選項',
    'LNK_DELETE_ALL' => '刪除所有',
    'LNK_DELETE' => '刪除',
    'LNK_EDIT' => '編輯',
    'LNK_VIEW' => '檢視',
    'LNK_GET_LATEST' => '獲取最新',
    'LNK_GET_LATEST_TOOLTIP' => '使用最新版本取代',
    'LNK_HELP' => '說明',
    'LNK_CREATE' => '建立',
    'LNK_CREATE_WHEN_EMPTY' => '立即建立記錄。',
    'LNK_LIST_END' => '結束',
    'LNK_LIST_NEXT' => '下一步',
    'LNK_LIST_PREVIOUS' => '上一步',
    'LNK_LIST_RETURN' => '返回至清單',
    'LNK_LIST_START' => '開始',
    'LNK_LOAD_SIGNED' => '簽名',
    'LNK_LOAD_SIGNED_TOOLTIP' => '使用已簽名文件取代',
    'LNK_PRINT' => '列印',
    'LNK_BACKTOTOP' => '返回頂部',
    'LNK_REMOVE' => '移除',
    'LNK_RESUME' => '繼續',
    'LNK_VIEW_CHANGE_LOG' => '查看稽核紀錄',
    'TPL_AUDIT_LOG_TITLE' => '{{{name}}} 稽核記錄',
    'LBL_AUDIT_EMAIL_TOOLTIP' => '點擊查看電子郵件地址審核記錄',
    'LBL_NO_SEARCH_RESULTS' => '沒有找到搜尋結果',
    'NTC_CLICK_BACK' => '請按一下瀏覽器返回按鈕，並修復此錯誤。',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => '您確定要刪除選取的記錄嗎？',
    'NTC_TEMPLATE_IS_USED' => '範本已至少在一個電子郵件行銷記錄中使用。您確定要刪除嗎？',
    'NTC_TEMPLATES_IS_USED' => "以下範本在電子郵件行銷記錄中使用。您確定要刪除它們嗎？\n",
    'NTC_DELETE_CONFIRMATION' => '確定要刪除此記錄嗎？',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => '您確定要刪除 {0} 嗎？',
    'LBL_METRIC_DELETE_WARNING' => '已被共享此量度數據選項卡的所有用戶也將失去訪問權限。',
    'NTC_DELETE_CONFIRMATION_NUM' => '您確定要刪除 ',
    'NTC_UPDATE_CONFIRMATION_NUM' => '您確定要更新 ',
    'NTC_DELETE_SELECTED_RECORDS' => '選取的記錄？',
    'LBL_DELETE_FILTER_CONFIRMATION' => '此篩選器將從所有檢視表中移除；這可能包括 Dashlet 的資料設定。您確定要刪除此篩選器嗎？',
    'TPL_DELETE_FILTER_SUCCESS' => '您已刪除篩選器 {{name}}。',
    'NTC_DELETE_SUCCESS' => '您已刪除 {0}。',
    'NTC_UNLINK_CONFIRMATION' => '您確定要取消此記錄的連結嗎？',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => '您確定要取消 {0} 的連結嗎？',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => '確定要取消與 {0} 的鏈接嗎？這也會將他們從案例的主要聯繫人字段中刪除。',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0} 無法取消鏈接，因為他們是此案例的主要聯繫人。在取消鏈接此記錄之前更新主要聯繫人字段。',
    'NTC_UNLINK_SUCCESS' => '您已取消 {0} 的連結',
    'NTC_LOGIN_MESSAGE' => '請輸入您的使用者名稱和密碼。',
    'NTC_NO_ITEMS_DISPLAY' => '無',
    'NTC_REMOVE_CONFIRMATION' => '您確定要移除此關係嗎？此操作只會移除關係，而不會刪除記錄。',
    'NTC_REQUIRED' => '表示必填欄位',
    'NTC_SUPPORT_SUGARCRM' => '透過 PayPal 捐贈支援 SugarCRM 的開放來源專案— 快速、免費、安全的應用程式！',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => '歡迎',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => '請取代 SugarCRM 標誌。',
    'FATAL_LICENSE_ALTERED' => '您的授權自上次驗證以來已進行修改。',
    'ERROR_FULLY_EXPIRED' => "貴公司的 SugarCRM 授權已過期 7 天以上，需要進行更新。只有管理員能夠登入。",
    'ERROR_LICENSE_EXPIRED' => "貴公司的 SugarCRM 授權需要更新。只有管理員能夠登入。",
    'WARN_LICENSE_EXPIRED' => "貴公司的 SugarCRM 授權很快就將過期。",
    'ERROR_LICENSE_VALIDATION' => "貴公司的 SugarCRM 授權需要驗證。只有管理員能夠登入。",
    'WARN_LICENSE_VALIDATION' => "貴公司的 SugarCRM 授權很快需要驗證。",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>警告：</b>您的瀏覽器在 IE 相容性檢視中是不支援的。',
    'WARN_LICENSE_SEATS' => '警告：現用使用者的數量已超過授權允許的最大數量。',
    'WARN_LICENSE_SEATS_MAXED' => '警告：現用使用者的數量超過了授權允許的最大數量。',
    'ERROR_LICENSE_SEATS_MAXED' =>
        '活動使用者數超過了許可證限制。請與管理員聯繫。',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => '只有管理員才能登入。',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        '用戶通行證已達上限。只有現存用戶可以登入。',
    'WARN_ONLY_ADMINS' => '只有管理員才能登入。',
    'WARN_UNSAVED_CHANGES' => '您將在未儲存您對記錄做出的任何修改的情況下離開此記錄。您確定要離開這個記錄瀏覽嗎？',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => '刷新瀏覽器將自動關閉您打開的所有 SugarLive 呼叫或聊天會話，所有未保存的更改都將丟失。您要繼續嗎？',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => '您還有未儲存的變更。您確定要離開此頁面並放棄變更嗎？',
    'LBL_MFA_RESET_CONFIRMATION' => '您是否確定要參加您的<a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">多因素驗證</a>？
執行此操作會立即使您註銷，下次登錄時您將需要使用驗證器應用驗證身份。',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => '確認並退出',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => '一個或多個Dashlet包含為保存的更改。是否確定關閉抽屜?',
    'LBL_NAVIGATE_TO_REPORTS' => '您將移動至報表模組。系統將不會儲存您對 Dashlet 做出的變更。繼續？',
    'ERROR_NO_RECORD' => '抓取記錄時出錯。此記錄可能已刪除或您沒有此記錄的檢視權限。',
    'ERROR_TYPE_NOT_VALID' => '錯誤。此類型無效。',
    'ERROR_MAX_FIELD_LENGTH' => '錯誤。此欄位的最大長度為 {{this}}。',
    'ERROR_MIN_FIELD_LENGTH' => '錯誤。此欄位的最小長度為 {{this}}。',
    'ERROR_EMAIL' => '錯誤。無效的電子郵件地址：{{#each this}}{{{this}}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => '錯誤。至少應設定一個主要地址。',
    'ERROR_DUPLICATE_EMAIL' => '錯誤。重複的電子郵件地址：{{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => '錯誤。此欄位為必填欄位。',
    'ERROR_MINVALUE' => '錯誤。此欄位最小值為 {{this}}。',
    'ERROR_MAXVALUE' => '錯誤。此欄位最大值為 {{this}}。',
    'ERROR_IS_GREATER_THAN' => '錯誤。此欄位值必須大於 {{this}}。',
    'ERROR_IS_LESS_THAN' => '錯誤。此欄位值必須小於 {{this}}。',
    'ERROR_DATETIME' => '錯誤。此欄位需填寫有效日期。',
    'ERROR_IS_BEFORE' => '錯誤。此欄位日期必須早於 {{this}} 欄位的日期。',
    'ERROR_IS_AFTER' => '錯誤。此欄位日期必須晚於 {{this}} 欄位的日期。',
    'ERROR_TIME_IS_BEFORE' => '出現錯誤。此欄位的時間必須早於{{this}} 欄位的時間。',
    'ERROR_TIME_IS_AFTER' => '出現錯誤。此欄位的時間必須晚於{{this}} 欄位的時間。',
    'ERROR_NUMBER' => '錯誤。此欄位需填寫有效數字。',
    'ERROR_INT' => '出現錯誤。無效整數。',
    'ERROR_URL' => '錯誤。URL無效。',
    'ERROR_NO_BEAN' => '無法取得 Bean。',
    'ERROR_ACCESS_MODULE' => '您沒有此模組的存取權限。',
    'ERROR_MAX_FILESIZE_EXCEEDED' => '附件太大。',
    'ERROR_UPLOAD_FAILED' => '錯誤。檔案上載失敗。',
    'ERROR_UPLOAD_ACCESS_PD' => '您沒有權限為此模組建立 [流程定義] 。',
    'ERROR_UPLOAD_ACCESS_BR' => '您沒有權限為此模組建立 [業務規則] 。',
    'ERROR_UPLOAD_ACCESS_ET' => '您沒有權限為此模組建立 [電子郵件範本] 。',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => '錯誤。你輸入了不支援的運算子。',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => '錯誤。您輸入了無效的運算子。',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => '錯誤。您輸入了無效的篩選器。',
    'ERROR_PA_UNSUPPORTED_FILE' => '匯入失敗。請檢查 Sugar 記錄檔了解更多詳情。',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => '匯入失敗。流程定義中的部分群組欄位被鎖定。' .
        ' 必須將流程定義中的這些欄位解鎖，以匯入定義。',
    'ERROR_EXP_DATE_LOW' => '錯誤。到期日期不得早於發佈日期。',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => '錯誤。已核准狀態要求填寫發佈日期。',
    'ERROR_ACTIVE_DATE_EMPTY' => '發佈日期為空。',
    'ERROR_ACTIVE_DATE_LOW' => '錯誤。發佈日期必須在當前日期之後。',
    'LBL_DUP_MERGE' => '查找重複項',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => '{{module}} 已停用重複項檢查。',
    'LBL_MANAGE_SUBSCRIPTIONS' => '管理訂閱',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => '管理訂閱目的',
    'LBL_SUBSCRIBE' => '訂閱',
    'LBL_UNSUBSCRIBE' => '取消訂閱',
    'LBL_CREATE_LINK_RECORD' => '建立並連結記錄',
    'LBL_CREATE_LINK_BUTTON_LABEL' => '建立並連結記錄',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '已連結 {{reportCount}} 記錄。',
    'LBL_LINK_FROM_REPORT_NO_DATA' => '無要連結的記錄。',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => '選取的報表並非基於正確的模組類型。',
    'ERROR_EMPTY_LINK_MODULE' => '請先選取關係。',
    // Ajax status strings
    'LBL_LOADING' => '載入中...',
    'LBL_LOADING_NO_DOTS' => '載入中',
    'LBL_SEARCHING' => '正在搜尋...',
    'LBL_SEARCH_UNDERWAY' => '正在搜尋',
    'LBL_SAVING_LAYOUT' => '正在儲存版面配置...',
    'LBL_SAVED_LAYOUT' => '已儲存版面配置。',
    'LBL_SAVED' => '已儲存',
    'LBL_SAVING' => '正在儲存',
    'LBL_FAILED' => '失敗！',
    'LBL_DISPLAY_COLUMNS' => '顯示欄',
    'LBL_HIDE_COLUMNS' => '隱藏欄',
    'LBL_SEARCH_CRITERIA' => '搜尋標準',
    'LBL_SAVED_VIEWS' => '已儲存檢視表',
    'LBL_PROCESSING_REQUEST' => '正在處理..',
    'LBL_REQUEST_PROCESSED' => '已完成',
    'LBL_AJAX_FAILURE' => 'Ajax 失敗',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => '搜尋 ...',
    'LBL_SAVED_SEARCH_SHORTCUT' => '已儲存搜尋',
    'LBL_SEARCH_POPULATE_ONLY' => '使用上述搜尋表單執行搜尋',
    'LBL_SEARCH_NO_RESULTS' => '找不到結果：',
    'LBL_SEARCH_FOR' => '搜尋目的',
    'LBL_SEARCH_FOR_MORE' => '搜尋更多...',
    'LBL_SEARCH_SELECT' => '選取...',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => '搜尋並選取...',
    'LBL_SEARCH_SELECT_MODULE' => '選取{{module}}...',
    'LBL_DETAILVIEW' => '詳細資料檢視表',
    'LBL_LISTVIEW' => '清單檢視',
    'LBL_EDITVIEW' => '編輯檢視表',
    'LBL_SEARCHFORM' => '搜尋表單',
    'LBL_SAVED_SEARCH_ERROR' => '請為此檢視表提供名稱。',
    'LBL_DISPLAY_LOG' => '顯示記錄檔',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => '位置：',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => '描述：',
    'MSG_JS_ALERT_MTG_REMINDER_START' => '正在開始',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => '按一下「確定」檢視此通話或按一下「取消」關閉此訊息。',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => '按一下「確定」檢視此會議或按一下「取消」關閉此訊息。',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => '找不到結果。',
    'MSG_LIST_VIEW_NO_RESULTS' => '未找到 <item1> 的結果',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => '建立 <item1> 為新 <item2>',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => '您目前未儲存任何 <item1> 記錄。立即儲存 <item2> 或 <item3> 記錄。',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => '您目前未儲存任何 <item1> 記錄。立即儲存 <item2> 記錄。',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => '您可從 <item2> 建立 <item1>。<item3><item2>清單。',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => '積極的',
    'LBL_SENTIMENT_NEUTRAL' => '中性的',
    'LBL_SENTIMENT_NEGATIVE' => '消極的',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => '未配置量度數據選項卡',
    'LBL_NO_METRIC_VISIBLE' => '不顯示指標索引標籤',
    'LBL_MAKE_METRIC_VISIBLE' => '選擇「組織」使指標索引標籤可見',
    'LBL_PLEASE_CONTACT_ADMIN' => '請連絡系統管理員。',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => '按一下此處',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => '新增至我的最愛',
    'LBL_MARK_AS_FAVORITES' => '標記為最愛',
    'LBL_CREATE_CONTACT' => '建立連絡人',
    'LBL_CREATE_NOTE' => '建立附註',
    'LBL_CREATE_OPPORTUNITY' => '建立商機',
    'LBL_SCHEDULE_CALL' => '記錄通話',
    'LBL_SCHEDULE_CALL2' => '通話',
    'LBL_SCHEDULE_MEETING' => '排程會議',
    'LBL_SCHEDULE_MEETING2' => '會議',
    'LBL_CREATE_MESSAGE' => '建立訊息',
    'LBL_CREATE_MESSAGE2' => '訊息',
    'LBL_CREATE_TASK' => '建立工作',
    'LBL_CREATE_TASK2' => '任務',
    'LBL_REMOVE_FROM_FAVORITES' => '從我的最愛中移除',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => '附註',
    'LBL_DOWNLOAD_ALL' => '全部下載',
    'LBL_DOWNLOAD_ONE' => '下載',
    'LBL_ATTACHMENTS' => '附件',
    'LBL_ADD_ATTACHMENT' => '瀏覽',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => '產生表單',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => '將網路儲存至潛在客戶表單',

    'LBL_PLEASE_SELECT' => '請選擇',
    'LBL_REDIRECT_URL' => '重新導向 URL',
    'LBL_RELATED_CAMPAIGN' => '相關推廣活動',
    'LBL_ADD_ALL_LEAD_FIELDS' => '新增所有欄位',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => '移除所有欄位',
    'LBL_ONLY_IMAGE_ATTACHMENT' => '只能嵌入以下支援的圖像類型附件：JPG、PNG。',
    'LBL_REMOVE' => '移除',
    'LBL_TRAINING' => '支援',
    'ERR_DATABASE_CONN_DROPPED' => '執行查詢時出錯。可能您的資料庫已刪除連接。請重新整理此頁面，您可能需要重新啟動網路伺服器。',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => '設定 {0} 關係時出錯：{1}',
    'ERR_MSSQL_DB_CONTEXT' => '將資料庫路徑位置變更為',
    'ERR_MSSQL_WARNING' => '警告：',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => '無法剖析 vCard 格式',
    'ERR_VCARD_FILE_MISSING' => 'vcf 檔案丟失',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => '警告：欄位 [field] 在 [moduleDir] vardefs.php 檔案中沒有對應條目。',
    'ERR_CANNOT_CREATE_METADATA_FILE' => '錯誤：檔案 [file] 丟失。無法建立，因為找不到對應的 HTML 檔案。',
    'ERR_CANNOT_FIND_MODULE' => '錯誤：模組 [module] 不存在。',
    'LBL_ALT_ADDRESS' => '其他地址：',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => '錯誤：displayParams 數組中「key 」和「copy」 元素的引數數量不相等。',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'displayParams 數組中缺少索引：',

    'LBL_DASHLET' => 'Dashlet',
    'LBL_DASHLET_CONFIGURE_FILTERS' => '篩選器',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => '僅限我的項目',
    'LBL_DASHLET_CONFIGURE_TITLE' => '標題',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => '顯示列',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => '關聯至目前記錄',
    'LBL_DASHLET_CONFIGURE_LINKED' => '已連結欄位',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => '凍結第一列',

    'LBL_REMOVE_DASHLET_CONFIRM' => '您確定要移除 Sugar Dashlet 嗎？',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => '您確定要移除此列嗎？',
    'LBL_MAXIMUM_OF' => '最大值',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => ' 欄可顯示。',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => '儀表板',
    'LBL_DEFAULT_DASHBOARD_TITLE' => '我的儀表板',
    'LBL_COLLAPSE_ALL' => '摺疊所有',
    'LBL_EXPAND_ALL' => '展開所有',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => '編輯',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => '查看報告',
    'LBL_DASHLET_REFRESH_LABEL' => '重新整理',
    'LBL_DASHLET_REMOVE_LABEL' => '移除',
    'LBL_DASHLET_DROP_HERE' => '放置於此處',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => '關閉',
    'LBL_DASHLET_MAXIMIZE' => '打開',
    'LBL_DASHLET_CONFIGURE' => '設定',
    'LBL_DASHLET_TOGGLE' => '開啟/關閉',
    'LBL_SIDEPANE_TOGGLE' => '開啟/關閉側窗格',
    'LBL_RESTORE_DEFAULT_DASHLETS' => '還原預設儀表板',
    'LBL_NO_DASHBOARD_CONFIGURED' => '未設定儀表板',
    'LBL_CREATE_DASHBOARD_LINK' => '建立儀表板',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => '說明',
    'LBL_HELPLET_TOGGLE' => '打開/關閉',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => '模組',
    'LBL_FACET_MODIFIED_BY_ME' => '由我修改的',
    'LBL_FACET_CREATED_BY_ME' => '由我建立',
    'LBL_FACET_MY_FAVORITES' => '我的最愛',
    'LBL_FACET_ASSIGNED_TO_ME' => '指派給我的',
    'LBL_FACET_NO_DATA' => '此 Facet 沒有資料。',

    'LBL_DASHLET_LISTVIEW_NAME' => '清單檢視表',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => '按照您定義的標準列出來自特定模組的記錄。',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => '控制列表視圖',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => '列出特定模組中與您在控制台中常看的紀錄相關的紀錄。',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => '記錄檢視',
    'LBL_RELATED_RECORDS' => '相關 {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => '在分頁中顯示紀錄，可選擇是否要標為相關記錄。',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => '基準記錄類型',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => '此{{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => '分頁',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => '基本版面配置預覽',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => '警告，只有 {{numWord}} ({{num}}) 模組可以顯示在分頁上。 ' .
        '在新增其他模組之前，請將一個以上的模組先移除。',
    'LBL_SIX' => '六', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => '評論日誌',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => '按記錄顯示評論',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => '尚無可用評論',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => '新增',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => '新增評論',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => '檢視全部',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => '資料不可用。您無權存取這些模組。' .
    " \n請更新或移除此 dashlet。",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => '我的 {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => '顯示部分尚無指定記錄',
    'LBL_CONTENT_SEARCH_DASHLET' => '內容搜尋 Dashlet',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => '我們能幫助你什麼，{{username}}？',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => '要創立一個案件嗎?',

    'LBL_DASHLET_OPPORTUNITY_NAME' => '商機計量',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => '關聯帳戶的商機指標。',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => '產品目錄快速精選',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => '列出最近使用的專案和產品，并保存為最愛',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => '最近使用',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => '最愛',

    'LBL_DASHBOARD_CREATE' => '建立儀表板',
    'LBL_DASHBOARD_DUPLICATE' => '複製儀表板',
    'LBL_DASHBOARD_DELETE' => '刪除儀表板',
    'LBL_PIN_TO_TOP' => '固定到頂部',
    'LBL_PIN_TO_BOTTOM' => '固定到底部',
    'LBL_MANAGE_DASHBOARDS' => '管理儀表板',

    'LBL_DASHBOARD_CONFIG' => '儀表板設定',
    'LBL_LIST_VIEW__NAME' => '清單檢視',
    'LBL_PIPELINE_VIEW_NAME' => '並排檢視',
    'LBL_PIPELINE_VIEW_BTN' => '並排檢視',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '按{{fieldName}} 的{{module}}',
    'LBL_VISUAL_PIPELINE_DISABLED' => '尚未啟用並排檢視',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => '目前未找到任何記錄。',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => '實例摘要',
    'LBL_DASHLET_ITERACTIONS_NAME' => '時間軸',
    'LBL_DASHLET_ATTACHMENTS_NAME' => '附註與附件',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => '屬於記錄的附註和附件',
    'LBL_DASHLET_PIPLINE_NAME' => '案源',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => '最近的 Tweets - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => '無已儲存的儀表板',

    'LBL_DNB_AND' => '和',
    'LBL_DNB_PRIM_NAME_DESC' => '記錄該組織名稱的文字',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => '回覆',
    'LBL_TWITTER_RETWEET' => '轉發',
    'LBL_TWITTER_FAVORITE' => '最愛',
    'LBL_TWITTER_FOLLOW' => '關注',
    'LBL_TWITTER_DESCRIPTION' => '查看匹配的 twitter 使用者的個人資料、微博、轉發和微博回覆。',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => '顯示列',
    'LBL_TWITTER_MY_ACCOUNT' => '我的帳戶',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => '來源 Tweet：',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => '學習資源',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => '培訓與證書',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub 社區',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => '文件與支援',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters 市場',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => '按國家劃分的銷售額',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => '按國家地圖顯示銷售圖表。',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => '知識庫分類和已發佈文章',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => '顯示知識庫分類和已發佈文章樹狀圖',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => '知識庫搜尋',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => '顯示已發布知識庫文章和類別的可搜尋樹狀圖。',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => '以其他語言發佈的文章',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => '顯示已發佈的本地化知識庫文章清單',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => '最有用的已發佈知識庫文章',
    'LBL_DASHLET_MOST_USEFUL_DESC' => '顯示最受歡迎和查看最多的知識庫文章',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} 按 {{label}} "{{value}}" 篩選',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => '文章有用程度',
    'LBL_DASHLET_USEFULNESS_DESC' => '顯示說明知識庫文章有用程度的圖表',

    'LBL_ADD_PAGE' => '新增頁面',
    'LBL_LOADING_PAGE' => '正在載入頁面，請稍等...',
    'LBL_SEARCH_RESULTS' => '搜尋結果',
    'LBL_SEARCH_RESULTS_FOR' => '搜尋結果用途：',
    'LBL_SEARCH_HELP_TITLE' => '搜尋提示',
    'LBL_SEARCH_RESULTS_FOUND' => '找到搜尋結果',
    'LBL_SEARCH_RESULTS_TIME' => '女士',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => '我的案源',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "我的小組的案源",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => '銷售案源圖表',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => '顯示目前案源圖表。',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => '無影像',

    'LBL_MODULE' => '模組',
    'LBL_RELATIONSHIP' => '關係',
    'LBL_SINGULAR_LABEL' => '單數標籤',
    'LBL_PLURAL_LABEL' => '複數標籤',
    'LBL_MODULE_DISPLAY' => '顯示',
    'LBL_MODULE_DISPLAY_TYPE' => '顯示類型',
    'LBL_MODULE_ICON' => '圖示',
    'LBL_MODULE_COLOR' => '模組背景顏色',
    'LBL_LANGUAGE_SELECTOR' => '語言',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => '模組設定',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => '已儲存模組設定。',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => '從左側複製地址：',
    'LBL_SAVE_AND_CONTINUE' => '儲存並繼續',

    'LBL_SEARCH_HELP_TEXT' => '<p>< br / > <strong>多選控制</strong></p><ul><li>按一下值以選擇一個屬性。</li><li>按住 Ctrl 鍵選&nbsp;&nbsp;取多個選項。Mac 使用者可按住 CMD。</li><li>要選取兩個屬性之間的所有值&nbsp;，請按一下第一個值&nbsp;，然後按住 shift 並按一下最後一個值。</li></ul><p><strong>進階搜尋和版面配置選項</strong><br><br>使用<b>儲存搜尋和版面設定佈局</b>選項，您可以儲存一組搜尋參數和/或一個自訂清單檢視表版面配置，以便將來快速獲取所需的搜尋結果。您可以儲存無限數量的自訂搜尋和版面配置。所有已儲存搜尋都將按名稱顯示在「已儲存搜尋」清單中，最近載入的已儲存搜尋將顯示在清單的頂部。<br><br>要自訂「清單檢視表」版面配置，請使用「隱藏欄」和「顯示欄」方塊來選取要在搜尋結果中顯示的欄位。例如，您可以檢視或隱藏詳細資訊，如在搜尋結果中顯示記錄名稱和指派的使用者和指派的小組。要在「清單檢視表」中新增欄，請在「隱藏欄」清單中選取該欄位，利用向左的箭頭將其移至「顯示欄」清單。要在「清單檢視表」中刪除欄，請在「顯示欄」清單中選取該欄位，利用向右的箭頭將其移至「隱藏欄」清單。<br><br>如果您儲存版面配置設定，您將能夠隨時載入以在自訂佈局配置中查看搜尋結果。 <br><br>要儲存並更新搜尋和/或版面設定：<ol><li>在<b>將搜尋結果儲存為</b> 欄位輸入搜尋結果的名稱，然後按一下<b>儲存</b>。現在，名稱將顯示在<b>清除</b>按鈕旁的「已儲存搜尋」清單中。</li><li>若要檢視已儲存的搜尋，請從「已儲存搜尋」清單中選取，搜尋結果將在清單檢視表中顯示。</li><li>若要更新已儲存搜尋的屬性，從清單中選取已儲存的搜尋，在「進階搜尋」區輸入新的搜尋標準和/或版面配置選項，然後按一下<b>修改目前搜尋</b>旁邊的<b>更新</b>。</li><li>若要刪除已儲存的搜尋，請在「已儲存搜尋」清單中選取，按一下<b>修改目前搜尋</b>旁邊的<b>刪除</b>，然後按一下<b>確定</b>以確認刪除。</li></ol><p><strong>提示</strong><br><br>使用 % 作為萬用字元運算子可進行更廣泛的搜尋。例如，「Apple」只會搜尋完全匹配的結果，您可以將搜尋更改為「Apples%」，這將為您搜尋到以「Apple」開頭，但可以包含其他字元的搜尋結果。</p>',

    //resource management
    'ERR_QUERY_LIMIT' => '錯誤：$module 模組達到 $limit 查詢限制。',
    'ERROR_NOTIFY_OVERRIDE' => '錯誤：ResourceObserver->notify() 需要被複寫。',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => '錯誤：無法建立監視器，因為中繼資料檔案為空或檔案不存在。',
    'ERR_MONITOR_NOT_CONFIGURED' => '錯誤：沒有為請求的名稱設定監視器',
    'ERR_UNDEFINED_METRIC' => '錯誤：無法為為定義的指標設定值',
    'ERR_STORE_FILE_MISSING' => '錯誤：找不到存放實作檔案',

    'LBL_MONITOR_ID' => '監視器 ID',
    'LBL_TEAM_ID' => '小組 ID',
    'LBL_SELECT_MODULE' => '選取一個模組：',
    'LBL_USER_ID' => '使用者 ID',
    'LBL_MODULE_NAME' => '模組名稱',
    'LBL_MODULE_ALL' => '所有',
    'LBL_ITEM_ID' => '項目 ID',
    'LBL_ITEM_SUMMARY' => '項目摘要',
    'LBL_ACTION' => '動作',
    'LBL_SESSION_ID' => '工作階段 ID',
    'LBL_BREADCRUMBSTACK_CREATED' => '已為用戶 ID {0} 建立 BreadCrumbStack',
    'LBL_VISIBLE' => '記錄可見',
    'LBL_DATE_LAST_ACTION' => '上次動作的日期',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL 文字',
    'LBL_QUERY_HASH' => 'SQL 雜湊',
    'LBL_SEC_TOTAL' => '總秒數',
    'LBL_SEC_AVG' => '平均秒數',
    'LBL_RUN_COUNT' => '查詢計數',

    //Tracker Sessions
    'LBL_CLIENT_IP' => '用戶端 IP 位址',
    'LBL_DATE_START' => '開始日期',
    'LBL_ACTIVE' => '使用中工作階段',
    'LBL_ROUNDTRIPS' => '動作計數',
    'LBL_SECONDS' => '使用中秒數',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => '資料庫來回',
    'LBL_FILES_OPENED' => '已存取檔案',
    'LBL_MEMORY_USAGE' => '記憶體使用量（位元）',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => '正在載入 Twitter 連接器...',
    'LBL_TWITTER_DATA_EMPTY' => '沒有來自 Twitter 的可用資料',

    'LBL_PLUGIN_OUTLOOK_NAME' => '適用於 Outlook 的外掛程式',
    'LBL_PLUGIN_OUTLOOK_DESC' => '將 Sugar 電子郵件和行事曆資訊和 Microsoft Outlook 整合。',
    'LBL_PLUGIN_WORD_NAME' => '適用於 Word 的 Sugar 外掛程式',
    'LBL_PLUGIN_WORD_DESC' => '用來自 SugarCRM 的資訊自動套印信件、直效行銷郵件和其他 Microsoft 文件。',
    'LBL_PLUGIN_EXCEL_NAME' => '適用於 Excel 的 Sugar 外掛程式',
    'LBL_PLUGIN_EXCEL_DESC' => '將 Sugar 與工作表整合以獲取更好的關鍵指標分析資料。',
    'LBL_PLUGINS_TITLE' => '適用於 Microsoft Office<sup>TM</sup> 的 Sugar 外掛程式',
    'LBL_PLUGINS_DESC' => '在<a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">外掛程式文件</a>內進一步了解外掛程式的功能。',

    'LBL_PLUGINS_LOTUS_TITLE' => '適用於 Lotus Notes<sup>TM</sup> 的 Sugar 外掛程式',
    'LBL_PLUGIN_LOTUS_NAME' => '適用於 Lotus Notes 的 Sugar 外掛程式',
    'LBL_PLUGIN_LOTUS_DESC' => '整合 Sugar 和 Lotus Notes。',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => '沒有早於',
    'MSG_IS_MORE_THAN' => '超過',
    'MSG_IS_LESS_THAN' => '小於',
    'MSG_SHOULD_BE' => '應該為',
    'MSG_OR_GREATER' => '或大於',
    'MSG_EXCEEDS_MAXLEN' => '超過指定的最大長度 ',

    'LBL_PORTAL_WELCOME_TITLE' => '歡迎使用 Sugar Portal 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar 入口網站是為客戶提供案例、錯誤和新聞稿等實時檢視表的框架。這是面向 Sugar 的外部介面，可部署至任何網站。請持續關注，了解未來版本中的更多客戶自助功能，如專案管理和論壇。',
    'LBL_LIST' => '清單',
    'LBL_CREATE_CASE' => '建立實例',
    'LBL_CREATE_BUG' => '建立錯誤',
    'LBL_NO_RECORDS_FOUND' => '- 找到 0 條記錄 -',

    'DATA_TYPE_DUE' => '到期：',
    'DATA_TYPE_START' => '開始：',
    'DATA_TYPE_SENT' => '已傳送：',
    'DATA_TYPE_MODIFIED' => '已修改：',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => '計數',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => '目標圖像：',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => '選取日期',

    'LBL_VALIDATE_RANGE' => '未在有效範圍內',
    'LBL_VALIDATE_URL' => '為無效 URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => '所有',

    'LBL_OPERATOR_IN_TEXT' => '屬於以下之一：',
    'LBL_OPERATOR_NOT_IN_TEXT' => '不屬於以下之一：',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => '錯誤：Bean 參數的陣列個數和結果的陣列個數不一致。',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => '錯誤：模組對應項目不存在。',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => '錯誤：無法為 {0} 連接器抓去資料。服務目前可能無法訪問或配置設定可能無效。連接器錯誤訊息：({1})。',
    'ERROR_CONNECTOR_CONFIGURE' => '無法抓取資料，服務目前可能無法訪問或配置設定可能無效。',
    'LBL_CONNECT_TWITTER' => '連接至 Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => '找不到 Twitter ID 的有效時間表：',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => '設定 Twitter 連接器',
    'LBL_CONNECT_TEST_FAIL' => '錯誤：連接器配置設定可能無效。請連絡您的管理員。',
    'LBL_CONFIGURE_TWITTER' => '連絡您的管理員以設定 Twitter',
    'LBL_MERGE_CONNECTORS' => '獲取資料',
    'LBL_NO_DATA_AVAILABLE' => '沒有可用資料。',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => '您確定要停用此模組的連接器整合嗎？',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => '無法連接 Elastic 伺服器',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => '無法刪除全域小組。',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => '無法刪除此私人小組 [{0}]，除非刪除 [{1}] 使用者。',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => '您關閉了 Abobe Flash 或正在使用 Adobe Flash Player 的先前版本。如需取得 Flash Player 的最新版本，請<a href="http://www.adobe.com/go/getflashplayer/">按一下此處</a>。',
    //Collection Field
    'LBL_COLLECTION_NAME' => '名稱',
    'LBL_COLLECTION_PRIMARY' => '主要',
    'ERROR_MISSING_COLLECTION_SELECTION' => '空的必填欄位',
    'LBL_COLLECTION_EXACT' => '完全符合',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => '如需獲得最佳體驗，請使用 IIS/FastCGI sapi，並在 php.ini 檔案中將 fastcgi.logging 設定為 0。',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => '已指派至',
    'LBL_DESCRIPTION' => '描述',
    'LBL_PRIMARY_CONTACT_NAME' => '主要連絡人',
    'LBL_PRIMARY_CONTACT_ID' => '主要連絡人 ID',

    'LBL_NONE' => '-無-',
    'LBL_YESTERDAY' => '昨天',
    'LBL_TODAY' => '今天',
    'LBL_TOMORROW' => '明天',
    'LBL_NEXT_WEEK' => '下週',
    'LBL_NEXT_MONDAY' => '下週一',
    'LBL_NEXT_FRIDAY' => '下週五',
    'LBL_TWO_WEEKS' => '兩週',
    'LBL_NEXT_MONTH' => '下個月',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => '第一天或下個月',
    'LBL_THREE_MONTHS' => '三個月',
    'LBL_SIXMONTHS' => '六個月',
    'LBL_NEXT_YEAR' => '明年',
    'LBL_FILTERED' => '已篩選',

    //Datetimecombo fields
    'LBL_HOURS' => '小時',
    'LBL_MINUTES' => '分鐘',
    'LBL_MERIDIEM' => '正午',
    'LBL_DATE' => '日期',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => '自動重新整理',

    'LBL_DURATION_DAY' => '天',
    'LBL_DURATION_HOUR' => '小時',
    'LBL_DURATION_MINUTE' => '分鐘',
    'LBL_DURATION_DAYS' => '天',
    'LBL_DURATION_HOURS' => '小時',
    'LBL_DURATION_MINUTES' => '分鐘',
    'LBL_DURATION_SECONDS' => '秒',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => '選擇月份',
    'LBL_ENTER_YEAR' => '輸入年份',
    'LBL_ENTER_VALID_YEAR' => '請輸入一個有效年份',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => '請輸入數值型美國電話號碼，包括區號。',
    'LBL_CCP_NOT_INITIATED' => '在代理未登錄時嘗試使用 CCP 撥號。',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => '無法通過 CCP 發起通話。',
    'LBL_CCP_DIALING_ERROR' => '無法根據撥出的號碼完成此通話。',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => '在撥出電話之前，請關閉 SugarLive 中的所有聊天會話。',

    //File write error label
    'ERR_FILE_WRITE' => '錯誤：無法寫入檔案 {0}。請檢查系統和網路伺服器權限。',
    'ERR_FILE_NOT_FOUND' => '錯誤：無法載入檔案 {0}。請檢查系統和網路伺服器權限。',

    'LBL_AND' => '和',
    'LBL_BEFORE' => '之前',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => '從您的電腦載入',
    'LBL_SEARCH_EXTERNAL_API' => '外部來源的檔案',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => '上傳到外部源',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => '從外部來源連結',
    'LBL_EXTERNAL_SECURITY_LEVEL' => '安全',
    'LBL_SHARE_PRIVATE' => '私人',
    'LBL_SHARE_COMPANY' => '公司',
    'LBL_SHARE_LINKABLE' => '可連結',
    'LBL_SHARE_PUBLIC' => '公共',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS 訂閱',
    'LBL_RSS_RECORDS_FOUND' => '記錄已找到',
    'ERR_RSS_INVALID_INPUT' => 'RSS 不是有效輸入類型',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS 不是此方法的有效回應類型',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => 'Google Docs 不支援您提供的檔案格式。',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => '空',
    'LBL_IS_EMPTY' => '為空',
    'LBL_IS_NOT_EMPTY' => '不為空',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '「此為範例匯入檔案，它可為即將匯入的預期內容提供範例。」
「此檔案為逗號分隔 .csv 檔案，使用雙引號作為欄位限定詞。」

「標題列是檔案的頂行，且包括了您將在應用程式中看到的欄位標籤。」
「這些標籤用於將檔案中的資料對應至應用程式中的欄位。」
「注意：資料庫名稱也可以用於標題列。這有助於您在使用 phpMyAdmin 或者其它資料管理工具時匯入已匯出的資料清單。」
「欄順序並不重要，因為匯入流程會將資料匹配至標題列中的對應欄位。」

「根據以下步驟將此檔案用作範本：」
「1. 刪除資料的範例行」
「2. 刪除您正在閱讀的說明內容」
「3. 將您自己的資料匯入至對應的欄和列」
「4. 將文件儲存至您系統的特定位置」
「5. 在應用程式的動作菜單中按一下「匯入」選項，並選取文件上載」   ',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => '指派的使用者 ID',
    'LBL_EXPORT_CREATED_BY' => '按 ID 建立',
    'LBL_EXPORT_MODIFIED_USER_ID' => '按 ID 修改',
    'LBL_EXPORT_REPORTS_TO_ID' => '報表發送對象 ID',
    'LBL_EXPORT_TEAM_ID' => '小組 ID',
    'LBL_EXPORT_TEAM_SET_ID' => '小組集 ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => '指派的使用者',
    'LBL_EXPORT_FULL_NAME' => '全名',
    'LBL_EXPORT_TEAM_NAME' => '小組',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => '正在瀏覽... ',

    'LBL_PENDING_NOTIFICATIONS' => '通知',
    'LBL_ALT_ADD_TEAM_ROW' => '新增新小組列',
    'LBL_ALT_REMOVE_TEAM_ROW' => '移除小組',
    'LBL_ALT_SPOT_SEARCH' => 'Spot 搜尋',
    'LBL_ALT_NOT_SORTED' => '未排序',
    'LBL_ALT_SORT_DESC' => '已遞減排序',
    'LBL_ALT_SORT_ASC' => '已遞增排序',
    'LBL_ALT_SORTABLE' => '可排序',
    'LBL_ALT_NOT_SORTABLE' => '不可排序',
    'LBL_ALT_SORT' => '排序',
    'LBL_ALT_SHOW_OPTIONS' => '顯示選項',
    'LBL_ALT_HIDE_OPTIONS' => '隱藏選項',
    'LBL_ALT_MOVE_COLUMN_LEFT' => '將選取項目移動至左側清單',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => '將選取項目移動至右側清單',
    'LBL_ALT_MOVE_COLUMN_UP' => '以顯示的清單順序向上移動選取項目',
    'LBL_ALT_MOVE_COLUMN_DOWN' => '以顯示的清單順序向下移動選取項目',
    'LBL_ALT_INFO' => '資訊',
    'MSG_DUPLICATE' => '您將要建立的 {0} 記錄可能與已存在的 {0} 記錄重複。包含類此名稱的 {1} 記錄如下所示。<br>按一下「建立」{1} 繼續建立此新 {0}，或選取下方列出的現有 {0}。',
    'MSG_SHOW_DUPLICATES' => '您將要建立的 {0} 記錄可能與已存在的 {0} 記錄重複。下面列出另包含類似名稱的 {1} 記錄。按一下「儲存」繼續建立此新 {0}，或按一下「取消」返回模組而不建立 {0}。',
    'LBL_EMAIL_TITLE' => '電子郵件地址',
    'LBL_EMAIL_OPT_TITLE' => '選擇退出電子郵件地址',
    'LBL_EMAIL_INV_TITLE' => '無效電子郵件地址',
    'LBL_EMAIL_PRIM_TITLE' => '主要電子郵件地址',
    'LBL_SELECT_ALL_TITLE' => '選取所有',
    'LBL_SELECT_THIS_ROW_TITLE' => '選取此列',
    'LBL_TEAM_SELECTED_TITLE' => '已選取小組 ',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => '選取以設定為主要小組',
    'LBL_TEAM_TBSELECTED_TITLE' => '小組被標記為選擇的小組',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => '將此小組標記為選擇的小組',
    'LBL_SEARCH_AND_SELECT' => '搜尋並選取 {{module}}',
    'TPL_SEARCH_AND_ADD' => '搜尋並新增 {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => '錯誤：上載時出錯。錯誤代碼：{0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => '錯誤：上載時出錯。錯誤代碼：{0} - {1}。最大上載大小為 {2}',
    'UPLOAD_ERROR_HOME_TEXT' => '錯誤：上載時出錯，請連絡管理員取得幫助。',
    'UPLOAD_MAXIMUM_EXCEEDED' => '上載大小 ({0} 位元) 超過允許最大值：{1} 位元 ',
    'UPLOAD_REQUEST_ERROR' => '發生了一個錯誤。請重新整理您的頁面然後再試一次。',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => '編輯',
    'LBL_ADD_BUTTON_LABEL' => '新增',
    'LBL_EDIT_BUTTON_TITLE' => '編輯',
    'LBL_REFRESH_BUTTON_LABEL' => '重新整理',
    'LBL_REFRESH_BUTTON_TITLE' => '重新整理',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => '複製',
    'LBL_DUPLICATE_BUTTON_TITLE' => '複製',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => '報表排程',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => '報表排程',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => '報表詳細資料',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => '報表詳細資料',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => '刪除',
    'LBL_DELETE_BUTTON_TITLE' => '刪除',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => '儲存',
    'LBL_SAVE_BUTTON_TITLE' => '儲存',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => '取消',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => '停止。',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => '留在頁面上。',
    'LBL_CANCEL_BUTTON_TITLE' => '取消',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => '共享',
    'LBL_SHARE_BUTTON_TITLE' => '共享',
    'LBL_START_BUTTON_LABEL' => '開始',
    'LBL_START_BUTTON_TITLE' => '開始',
    'LBL_FINISH_BUTTON_LABEL' => '完成',
    'LBL_FINISH_BUTTON_TITLE' => '完成',
    'LBL_CONFIRM_BUTTON_LABEL' => '確認',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => '繼續。',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => '離開頁面並捨棄變更。',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => '鍵盤捷徑',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>表單功能 - Alt+</strong><br/> I = <b>編輯</b> (詳情檢視表)<br/> U = <b>複製</b> (詳情檢視表)<br/> D = <b>刪除</b> (詳情檢視表)<br/> R =<b>共享</b> (詳情檢視表)<br/> A = <b>儲存</b> (編輯檢視表)<br/> L =<b>取消</b> (編輯檢視表) <br/><br/></p><p><strong>搜尋和導覽  - Alt+</strong><br/> 7 = 在編輯表單中首先輸入<br/> 8 = 進階搜尋連結<br/> 9 = 首個搜尋表單輸入<br/> 0 = 同意的搜尋輸入<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => '升級',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => '共享',
    'TPL_RECORD_SHARE_SUBJECT' => '共享 {{module}}{{name}} 來自 {{appId}}',
    'TPL_RECORD_SHARE_BODY' => '請從 {{appId}} 取出 {{module}}{{name}}',

    'ERR_CONNECTOR_NOT_ARRAY' => '{0} 中的連接器陣列未正確定義，或為空值且無法使用。',
    'LBL_PDF_VIEW' => '下載 PDF',
    'LBL_PDF_EMAIL' => '電子郵件 PDF',

    'ERR_SUHOSIN' => 'Suhosin 已阻止上載流，請新增 &quot;上載&quot; 至 suhosin.executor.include.whitelist （查看 sugarcrm.log 了解更多資訊）',

    //for sidecar
    'LBL_TIME_AGO_NOW' => '立即',
    'LBL_TIME_AGO_SECONDS' => '不到 1 分鐘前',
    'LBL_TIME_AGO_MINUTE' => '約 1 分鐘前',
    'LBL_TIME_AGO_MINUTES' => '{{this}} 分鐘前',
    'LBL_TIME_AGO_HOUR' => '約 1 小時前',
    'LBL_TIME_AGO_HOURS' => '{{this}} 小時前',
    'LBL_TIME_AGO_DAY' => '昨天',
    'LBL_TIME_AGO_DAYS' => '{{this}} 天前',
    'LBL_TIME_AGO_YEAR' => '1 年多以前',
    'LBL_TIME_UNTIL_SECONDS' => '不到 1 分鐘後',
    'LBL_TIME_UNTIL_MINUTE' => '約 1 分鐘後',
    'LBL_TIME_UNTIL_MINUTES' => '{{this}} 分鐘後',
    'LBL_TIME_UNTIL_HOUR' => '約 1 小時後',
    'LBL_TIME_UNTIL_HOURS' => '{{this}} 小時後',
    'LBL_TIME_UNTIL_DAY' => '明天',
    'LBL_TIME_UNTIL_DAYS' => '{{this}} 天後',
    'LBL_TIME_UNTIL_YEAR' => '一年多後',
    'LBL_TIME_RELATIVE' => '發佈 {{relativetime}} 於 {{date}} {{time}}',
    'LBL_LAST_TOUCHED' => '最後一次連絡 {{relativetime}} 於 {{date}} {{time}}',
    'LBL_LAST_COMMIT' => '最後提交: ',
    'LBL_LISTVIEW_NO_RECORDS' => '沒有可用資料。',
    'LBL_DETAILVIEW_NO_RECORDS' => '目前這條記錄不能轉換。',
    'LBL_REFINE_LIST' => '精簡清單',
    'LBL_SEARCH_BY' => '搜尋人',
    'LBL_PREVIEW' => '預覽',
    'LBL_COLUMNS' => '欄',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => '已停用預覽：沒有可用資料',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => '已停用預覽：沒有權限訪問記錄',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => '已停用預覽：沒有可用資料',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => '已停用預覽：作為當前記錄',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => '已停用預覽：記錄已刪除或沒有權限訪問記錄',
    'LBL_PREVIEW_PREVIOUS' => '預覽上一項',
    'LBL_PREVIEW_NEXT' => '預覽下一項',
    'LBL_PREVIEW_CLOSE' => '預覽關閉',
    'LBL_STREAM_NO_RECORDS' => '目前此記錄沒有筆記。請按一下新增附註連結以新增。',
    'LBL_DUPLICATES_FOUND' => '找到 {{duplicateCount}} 個重複項。',
    'LBL_NO_DUPLICATES_FOUND' => '未找到重複項。',
    'LBL_RESET_DEFAULT_VIEW' => '重置預設檢視表',
    'LBL_RESET_DEFAULT_WIDTHS' => '重置預設寬度',
    'LBL_TIMEZONE_UPDATED' => 'Sugar 已更新您的使用者個人資料時區，以與您的瀏覽器時區相符',
    'LBL_SUCCESS' => '成功',
    'LBL_ERROR' => ' 錯誤',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => '合併重複項',
    'LBL_MERGE_DUPLICATES_PROCEED' => '您確定要繼續嗎？取消以中止。確認以刪除記錄。',
    'LBL_MERGE_DUPLICATES_CONFIRM' => '此動作將刪除以下記錄：',
    'LBL_MERGE' => '合併',
    'TPL_MERGING_RECORDS' => '正在合併 {{mergeCount}} 條記錄',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        '傳遞的記錄數量無效。有效範圍為 {{minRecords}} 至 {{maxRecords}} 條記錄。',
    'LBL_MERGE_NO_ACCESS' =>
        '您沒有權限執行這項操作。必須至少有一條可編輯記錄。',
    'LBL_MERGE_LOCKED' => '選定用於合併的部分記錄中包含被流程鎖定編輯的欄位，目前無法合併。',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        '切換至新的主記錄將捨棄所有變更。您確定要切換嗎？',
    'LBL_MERGE_DUPLICATES_TITLE' => '合併相關記錄',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => '已合併：{{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        '合併關聯 {{objectName}} 失敗。發起新嘗試 {{total}} 中的 {{num}}。',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        '合併相關 {{objectName}} 失敗。',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        '合併相關記錄不完整。某些記錄依然未合併。',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        '某些關聯記錄未正確合併。按取消以中止。按確認以繼續合併。',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        '所有關聯記錄都將移動至主記錄。',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        '確定要從合併中移除此記錄嗎？',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => '從合併中移除此記錄',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => '傳遞的記錄數量無效。有效範圍為 1 至 {{maxRecords}} 條記錄。',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => '您提供的使用者名稱/密碼組合不正確，請再試一次。',
    'LBL_INVALID_CREDS_TITLE' => '無效認證',
    'LBL_INVALID_GRANT' => '您的 Token 無效或已過期。請重新登入。',
    'LBL_INVALID_GRANT_TITLE' => 'Token 已過期',
    'LBL_AUTH_FAILED' => '用戶端驗證失敗。',
    'LBL_AUTH_FAILED_TITLE' => '無效用戶端',
    'LBL_INVALID_REQUEST' => '請求無效或格式不正確。請聯絡技術支援。',
    'LBL_INVALID_REQUEST_TITLE' => '無效請求',
    'LBL_REQUEST_TIMEOUT' => '伺服器沒有響應。請檢查網路連結。',
    'LBL_REQUEST_TIMEOUT_TITLE' => '請求超時：',
    'LBL_UNAUTHORIZED' => '抱歉，您沒有權限訪問該資源。',
    'LBL_UNAUTHORIZED_TITLE' => '未授權',
    'LBL_RESOURCE_UNAVAILABLE' => '資源不可用。',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => '停止使用',
    'LBL_METHOD_NOT_ALLOWED' => '不允許此資源使用 HTTP 方法。請連絡技術支援。',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => '不允許的方法',
    'LBL_PRECONDITION_MISSING' => '請求失敗，或參數缺少/無效。請連絡技術支援',
    'LBL_PRECONDITION_MISSING_TITLE' => '錯誤： ',
    'LBL_INVALID_412_RESPONSE' => '請求失敗導致應用程式無法使用。請連絡技術支援。',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => '不允許編輯模組中的欄位 {0}：{1}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => '不允許在此記錄上執行動作 {0}',
    'LBL_LOGIN_BUTTON_LABEL' => '登入',
    'LBL_ACTIVITY_VIEW_TOUR' => '活動檢視表嚮導',
    'LNK_TOUR' => '嚮導',
    'LNK_MOBILE' => '行動电话',
    'LBL_FEEDBACK' => '回饋',
    'LBL_SUPPORT' => '支援',
    'LBL_LANGUAGE' => '語言 / Sprache / Idioma',
    'LBL_LOADING_LANGUAGE' => '正在載入語言套件',
    'LBL_UPLOADING' => '正在上傳',
    'LBL_UPLOADING_DOTS' => '正在上傳...',
    'LBL_IMAGE_DELETE_CONFIRM' => '您確定要刪除這張圖像嗎？',
    'LBL_FILE_DELETE_CONFIRM' => '您確定要刪除這個檔案嗎？此操作不能被撤銷。',
    'LBL_FILE_DELETED' => '成功刪除檔案',

    //theme roller
    'LBL_PORTAL_THEME' => '入口網站主題',
    'LBL_THEME_PREVIEW' => '門戶主題預覽',
    'LBL_LOADING_PREVIEW' => '正在載入預覽',
    'LBL_RESET' => '重設',
    'LBL_COLORS' => '顏色',
    'BorderColor' => '框線顏色',
    'NavigationBar' => '導覽列',
    'PrimaryButton' => '主按鈕',
    'LBL_SAVE_AND_DEPLOY_BTN' => '儲存與部署',
    'LBL_RESET_THEME_LNK' => '還原預設主題',
    'LBL_RESET_THEME_MODAL_INFO' => '您確定要放棄主題自訂並替換為預設主題嗎？',
    'LBL_RESET_THEME_PROCESS' => '正在還原預設主題...',
    'LBL_SAVE_THEME_PROCESS' => '正在儲存主題...',

    // image loader
    'LBL_SELECT_PHOTO' => '選取一張照片',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => '強化的 Sugar 預測功能',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"> <div style="float: left; width: 300px;"> <ul><li class="fa fa-check"> 設定您的預測參數</li> <li class="fa fa-check">輕鬆追蹤預計銷售額和管道健康</li> <li class="fa fa-check">根據您的銷售小組的預計銷售額進行預測</li></ul></div> <div class="well"style="float: left; width: 220px; margin-left: 20px;"> <img src="themes/default/images/pt-screen1-thumb.png"width="220"id="thumbnail_1"class="thumb"></div></div> <div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => '設定預測參數',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">選擇會計年度的開始日期</li> <li class="fa fa-check">設置時間段是不是每年或每季度</li> <li class="fa fa-check">決定多少過去和未來時間段需要在工作表中可見</li> <li class="fa fa-check">選擇預測至標記為包含、 排除或上行機會</li> <li class="fa fa-check">選擇預測方案來確定可能，最佳及最差預測</li></ul></div> 3</div> <div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => '管理銷售小組的預期銷售額',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">選區時間段以檢視預測</li><li class="fa fa-check">檢視銷售小組成員的工作表並提供經過調整的預測</li><li class="fa fa-check">當銷售小組成員提交新預測時查看警示</li><li class="fa fa-check">儲存預測工作表的草稿版本，或直接將預測提交給您的經理</li><li class="fa fa-check">檢閱先前提交歷史</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => '管理銷售小組的預期銷售額',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">檢視 Pareto 圖表，了解所有銷售小組成員預測的案源分析資料</li><li class="fa fa-check">按照可能、最佳或最差預測設定預期銷售額的蛇覺效果</li><li class="fa fa-check">檢視預期銷售，以及離群組配額還有多大差距</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => '管理您擁有的預測銷售額',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">為您的預測選取一個時間段</li><li class="fa fa-check">檢閱並逐行編輯金額和贏得客戶可能性以進行快速假設性分析</li><li class="fa fa-check">儲存預測工作表的草稿版本，或直接將預測提交給您的經理</li><li class="fa fa-check">檢閱先前提交歷史</li><li class="fa fa-check">向經理提交預測，並校閱先前提交歷史。</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => '管理您擁有的預測銷售額',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">查看 Pareto 圖表，了解您的商機一段時間以來的管道分析</li><li class="fa fa-check">選擇按照銷售階段或贏得客戶可能性對管道配送可視化</li><li class="fa fa-check">檢視預期銷售，以及您離分配的配額還有多大差距</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Sugar 最新動態',
    'LBL_TOUR_WATCH' => '觀看 Sugar 最新動態',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="fa fa-check">提升的外觀與風格－現已加入全新現代主體。</li><li class="fa fa-check">強化的預測模組－現配備直觀的使用者介面和全新資料視覺效果</li></ul>',
    'LBL_TOUR_VISIT' => '如需更多資訊，請造訪我們的應用程式',
    'LBL_TOUR_DONE' => '您已經完成了！',
    'LBL_TOUR_REFERENCE_1' => '您可隨時參考我們的',
    'LBL_TOUR_REFERENCE_2' => '透過設定檔功能表下放的「支援」連結',
    'LNK_TOUR_DOCUMENTATION' => '文件',
    'LBL_TOUR_CALENDAR_URL_1' => '您是否經常將 SugarCRM 行事曆共享至第 3 方應用程式，如 Microsoft Outlook 或 Exchange：若是，您有一個新的 URL。這個更安全的新 URL 包含一個個人金鑰，它可防止未經授權發佈您的行事曆。',
    'LBL_TOUR_CALENDAR_URL_2' => '抓取新的共享行事曆 URL。',
    'LBL_TOUR_CUBE' => '存取儀表板和活動流',
    'LBL_TOUR_NAV_BAR' => '在導覽功能表存取所有模組並進行各項操作',
    'LBL_TOUR_NOTIFICATIONS' => '按一下查看通知',
    'LBL_TOUR_SEARCH' => '選取一個或多個模組並搜尋',
    'LBL_TOUR_AVATAR' => '獲取有關應用程式的更多詳細資料或登出',
    'LBL_TOUR_ADD' => '從此處建立記錄',
    'LBL_TOUR_LIST_INT_TOGGLE' => '按一下以關閉或打開資訊窗格',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => '選擇查看活動或記錄清單',
    'LBL_TOUR_LIST_FILTER1' => '篩選列允許搜尋這個模組',
    'LBL_TOUR_LIST_FILTER2' => '選取預先定義的篩選或建立新篩選',
    'LBL_TOUR_LIST_FILTER_SEARCH' => '在此處輸入以按照名稱搜尋',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => '選取以編輯列或預覽詳細資料',
    'LBL_TOUR_RECORD_ACTIONS' => '對記錄進行操作',
    'LBL_TOUR_RECORD_SUBPANEL' => '按一下標題以展開和折疊子面板',
    'LBL_TOUR_RECORD_INLINEEDIT' => '可適當更新記錄名稱',
    'LBL_TOUR_RECORD_STATUS' => '在此處查找記錄等級狀態',
    'LBL_TOUR_RECORD_SHOWMORE' => '按一下查看記錄的更多資料',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => '選擇查看活動或關聯記錄',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => '按一下以編輯每個內嵌欄位',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => '建立新 Dashlet 群組',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => '為 Dashlet 群組指定名稱',
    'LBL_TOUR_RECORD_DASHLETCOG' => '選取以移除 Dashlet 或變更設定',
    'LBL_TOUR_INTRO' =>'<h4>歡迎使用 Sugar</h4> 我們將帶您快速瀏覽一些功能。請使用< and >螢幕底部的箭頭瀏覽快速嚮導。<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">新功能</a><p class="details">了解不同版本之間的重要變化。</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">進一步了解 Sugar</a><p class="details">一款穩定可靠的線上學習、現場與虛擬課堂訓練、網路研討會和視訊教程庫。</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">取得支援</a><p class="details">需要幫助、存在疑問或希望提供建議幫助改進 Sugar？</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => '檢視記錄清單並記錄操作。',
    'LBL_TOUR_RECORD_INTRO' => '檢視此記錄詳細資料並查看所有關聯資料。',
    'LBL_TOUR_FORECAST_INTRO' => '管理管道和預測。',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => '選擇一個時間週期以查看相應預測',
    'LBL_TOUR_FORECASTS_COMMITS' => '按一下查看以往提交記錄',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => '按一下以編輯內嵌資料',
    'LBL_TOUR_FORECASTS_PROGRESS' => '檢視配額的差值',
    'LBL_TOUR_FORECASTS_CHART' => '檢視預測分配',
    'LBL_TOUR_TOUR' => '隨時存取嚮導',
    'LBL_TOUR_TAGS_ADD' => '按一下標籤以新增和移除標籤',
    'LBL_TOUR_TAGS_DELETE' => '如需刪除標籤，使用退格鍵或按一下每個標籤上的 [X] 按鈕',
    'LBL_TOUR_RECORD_SAVE' => '完成後，按一下「儲存」',


    'LBL_FUTURE' => '未來',
    'LBL_REQUIRED_FIELD' => '必填',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => '報價項目',
    'LBL_DISCOUNT_TOTAL' => '總折扣',
    'LBL_DISCOUNT_PERCENT' => '% 百分比',
    'LBL_DISCOUNT_SELECT' => '確定折扣是百分比還是固定金額',
    'LBL_TAX' => '稅',
    'LBL_SHIPPING' => '運送',
    'LBL_GRAND_TOTAL' => '總計',
    'LBL_QUOTES_POPULATE_ADDRESS' => '使用帳戶的個人資料自動輸入帳單寄送地址',
    'LBL_QLI_ADD_GROUP' => '新增群組',
    'LBL_QLI_COMMENT' => '註解',
    'LBL_SELECT_ACTION' => '選取動作',
    'LBL_QLI_GROUP_NAME' => '群組名稱',
    'LBL_GROUP_TOTAL' => '群組合計',
    'LBL_ITEM_NAME' => '項目',
    'LBL_QLI_DELETE' => '您確定要刪除此報價項目嗎？',
    'LBL_QLI_COMMENT_DELETE' => '您確定要刪除此報價項目註解嗎？',
    'LBL_QLI_GROUP_DELETE' => '是否確實要刪除群組 {0}？所有項目都將被移動到預設群組。',
    'LBL_QLI_GROUP_EMPTY' => '無報價項目',
    // end of: Quotes related

    'LBL_OPTIONAL' => '可選',
    'LBL_RELATED_MODULE' => '相關 {{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => '相關 {{{this}}}',
    'LBL_CREATE_MODULE' => '建立 {{{this}}}',
    'LBL_EDIT' => '編輯 {{{this}}}',
    'LBL_ASSOC' => '連結 {{{this}}}',
    'LBL_ASSIGN' => '選取 {{{this}}}',
    'LBL_EDIT_RELATED' => '編輯關聯 {{{this}}}',
    'LBL_CREATE_RELATED' => '建立關聯 {{{this}}}',
    'LBL_ASSOC_EXISTING' => '連結現有 {{{this}}}',
    'LBL_SEARCH_ALL' => '搜尋所有 {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => '搜尋所有記錄...',
    'LBL_SEARCH_ALL_MODULES' => '搜尋所有',
    'LBL_OK' => '確定',
    'LBL_YES' => '是',
    'LBL_NO' => '否',
    'LBL_SHOW_NUMBERING' => '顯示階段編號',
    'LBL_HIDE_NUMBERING' => '隱藏階段編號',
    'LBL_CALL_BUTTON' => '通話',
    'LBL_SMS_BUTTON' => 'SMS',
    'LBL_EMAIL_BUTTON' => '電子郵件',
    'LBL_HONEYPOT' => '如果您是真人，請不要填寫。',
    'LBL_LINK_BUTTON' => '連結',
    'LBL_UNLINK_BUTTON' => '取消連結',
    'LBL_MAP_BUTTON' => '地圖',
    'LBL_FILE_BUTTON' => '檔案',
    'LBL_URL_BUTTON' => '網路',
    'LBL_WARNING' => '警告',
    'LBL_CONFIRM' => '確認',
    'LBL_CONFIRMATION_POPUP' => '確認快顯視窗',
    'LBL_NO_ACCESS' => '（無存取權限）',
    'LBL_NO_ACCESS_LOWER' => '沒有存取權限',
    'LBL_NO_FIELD_ACCESS' => '沒有存取權限',
    'LBL_NO_LICENSE_ACCESS' => '需要許可',
    'LBL_VALUE_ERASED' => '值已刪除',
    'LBL_VALUE_ERASED_TOOLTIP' => '此資訊已通過資料隱私請求刪除',
    'LBL_CREATE_RELATED_RECORD' => '建立關聯記錄',
    'LBL_ASSOC_RELATED_RECORD' => '連結現有記錄',
    'LBL_CHOOSE_LINK' => '選擇連結類型',
    'LBL_CHOOSE_PARENT_TYPE' => '選擇父代類型',
    'LBL_HOME' => '首頁',
    'ERR_NO_DOCS' => '沒有可用文件',
    'ERR_NO_RECORDS_SELECTED' => '您還未選取任何記錄。',
    'LBL_DELETING' => '正在刪除...',
    'LBL_UNLINKING' => '正在取消連結...',
    'LBL_UNLINKED' => '已取消連結',
    'LBL_LEGAL' => '法律',
    'LBL_UPCOMING' => '我近期的活動',
    'LBL_RECENTLY_UPDATED' => '最近更新',
    'LBL_NOTES_SUBPANEL_TITLE' => '附註',
    'LBL_MEETINGS_SUBPANEL_TITLE' => '會議',
    'LBL_TASKS_SUBPANEL_TITLE' => '工作',
    'LBL_CALLS_SUBPANEL_TITLE' => '通話',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => '帳戶',
    'LBL_CONTACTS_SUBPANEL_TITLE' => '聯絡人',
    'LBL_EMAILS_SUBPANEL_TITLE' => '電子郵件',
    'LBL_SHIFTS_SUBPANEL_TITLE' => '班表',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => '報價項目',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => '班表的例外',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => '文件',
    'LBL_ESCALATIONS' => '升級',
    'LBL_ESCALATED' => '已升級',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => '升級',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => '其他相關升級',
    'LBL_ESCALATIONS' => '升級',
    'LNK_SETTINGS' => '設定',
    'LBL_MOBILE_SUPPORT' => '支援',
    'LBL_MOBILE_SHOW_MORE' => '顯示更多...',
    'LBL_MOBILE_SHOW_MORE_TOP' => '顯示更多...',
    'LBL_MOBILE_NO_RECORDS' => '找不到記錄',
    'LBL_MOBILE_SEARCH_TEAMS' => '搜尋小組...',
    'LBL_MOBILE_SELECT_TEAMS' => '選取小組',
    'LBL_MOBILE_WAIT' => '請稍等...',
    'LBL_MOBILE_LOGING_OUT' => '請稍等，正在登出...',
    'LBL_MOBILE_RELOGIN_BUTTON' => '重新登入',
    'LBL_MOBILE_META_SYNC_FAILED' => '無法與伺服器同步',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => '無法與伺服器同步。重試？',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => '隱私，條款與細則',
    'LBL_MOBILE_APP_VERSION' => '應用程式版本',
    'LBL_MOBILE_SERVER_VERSION' => '伺服器版本',
    'LBL_MOBILE_SERVER_URL' => '伺服器 URL',
    'LBL_MOBILE_PTR_PULL' => '往下拉動以重新整理...',
    'LBL_MOBILE_PTR_RELEASE' => '鬆開來更新...',
    'LBL_MOBILE_EDIT_REL' => '編輯關係',
    'LBL_MOBILE_DESKTOP' => '桌面版',
    'LBL_MOBILE_DELETE_CONFIRM' => '確定要刪除此記錄嗎？',
    'LBL_MOBILE_UNLINK_CONFIRM' => '您確定要取消此記錄的連結嗎？',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => '您想要記錄您的上次通話嗎？',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => '選擇收件者',
    'LBL_MOBILE_CHOOSE_PHONE' => '選擇電話號碼',
    'LBL_MOBILE_CHOOSE_URL' => '選擇 URL',
    'LBL_MOBILE_CHOOSE_DOC' => '選擇文件',
    'LBL_MOBILE_CHOOSE_LOCATION' => '選擇位置',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => '無可用動作',
    'LBL_MOBILE_FEEDBACK' => '回饋',
    'LBL_MOBILE_DOC' => '文件',
    'LBL_MOBILE_DOWNLOAD_STARTED' => '已開始下載：{{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => '已完成下載：{{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => '正在上載檔案...',
    'LBL_MOBILE_UPLOAD_SUCCESS' => '成功上載檔案',
    'LBL_MOBILE_PROCESSING_IMAGE' => '正在準備圖像...',
    'LBL_CLOSE_SAVE_BUTTON' => '關閉工作並儲存',
    'LBL_LATER' => '稍後',
    'LBL_USE_HTTPS' => '使用安全連接',
    'LBL_LOADING_FILES' => '仍在載入文件清單。請稍後再試一次',
    'LBL_NEW_WEB_VERSION' => '此應用程式有新版本。您想要更新嗎?',
    'LBL_SET_FONTSIZE' => '字型大小',
    'LBL_FONTSIZE_TINY' => '很小',
    'LBL_FONTSIZE_SMALL' => '小',
    'LBL_FONTSIZE_NORMAL' => '標準 (預設)',
    'LBL_FONTSIZE_LARGE' => '大',
    'LBL_FONTSIZE_LARGER' => '很大',
    'LBL_FONTSIZE_HUGE' => '非常大',
    'LBL_FONTSIZE_EXTRA_HUGE' => '巨大',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "下載失敗\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => '更多...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '...小於',
    'LBL_OFFLINE_MODE' => '離線模式',
    'LBL_OFFLINE_DELETED' => '找不到記錄。',
    'LBL_OFFLINE_DELETED_RELATED' => '找不到關聯記錄。可能已刪除或已取消連結。',
    'LBL_OFFLINE_PREFETCH_PROMPT' => '正在下載您指派、最愛或關注的記錄以便離線存取，這會花費一些時間。建議您使用快速連接。要繼續嗎？',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => '您是否要立即下載您指派、最愛或關注的記錄以便離線存取？此作業會花費一些時間，建議您使用快速連接。您可於稍後在「主功能表 > 離線」下載。',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => '已成功下載記錄',
    'LBL_OFFLINE_PREFETCH_ACTION' => '下載您的記錄...',
    'LBL_OFFLINE_PREFETCH_ERROR' => '下載記錄時出錯',
    'LBL_OFFLINE_PREFETCHING' => '正在載入記錄...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => '正在載入 {{module}}{{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => '剩餘時間 {{estimatedTime}} 秒...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => '{{module}} 完成載入',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => '正在清理儲存體...',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => '完成清理',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => '您要復原此變更嗎？',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => '已完成復原',
    'LBL_OFFLINE_ROLLBACK_FAILED' => '復原失敗',
    'LBL_OFFLINE_CLEAR_DB' => '清空儲存體...',
    'LBL_OFFLINE_COMPACT_DB' => '壓縮儲存體...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => '此動作將刪除您一段時間沒有存取的記錄。繼續？',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => '您要刪除本地儲存體中的所有記錄嗎？',
    'LNK_OFFLINE_SETTINGS' => '離線',
    'LBL_OFFLINE_SETTINGS' => '偵錯設定',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => '沒有變更需要同步。',
    'LBL_OFFLINE_STATUS_PENDING_TX' => '變更正在等待同步。',
    'LBL_OFFLINE_STATUS_ONLINE' => '裝置為連線狀態。',
    'LBL_OFFLINE_STATUS_OFFLINE' => '裝置為離線狀態。',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => '無法存取伺服器。',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => '上次同步嘗試失敗。請檢查交易記錄。',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => '同步進行中...',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => '已同步交易。',
    'LBL_OFFLINE_ENABLE_PROMPT' => '您確定要關閉離線支援嗎？',
    'LBL_OFFLINE_DISABLE_PROMPT' => '您要關閉離線支援嗎？您將丟失所有待同步的修改。',
    'LBL_OFFLINE_ENABLED' => '已啟用離線模式',
    'LBL_OFFLINE_DISABLED' => '已停用離線模式',
    'LBL_OFFLINE_STATS' => '儲存體統計資料',
    'LBL_OFFLINE_SERVER_FETCH' => '正在從伺服器獲取...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => '有人已在伺服器上編輯相同的記錄。按「確認」以自動合併您的變更或按「拒絕」以放棄變更。',
    'LBL_OFFLINE_LAST_SYNC_TS' => '上次同步嘗試：{{ts}}',
    'LBL_ACTION_UPDATE' => '更新',
    'LBL_ACTION_CREATE' => '建立',
    'LBL_ACTION_DELETE' => '刪除',
    'LBL_ACTION_LINK' => '連結',
    'LBL_ACTION_UNLINK' => '取消連結',
    'LBL_ACTION_FAVORITE' => '最愛',
    'LBL_ACTION_FOLLOW' => '關注',
    'LBL_ACTION_CREATE_EXPLANATION' => '建立 {{module}} "{{name}}"',
    'LBL_ACTION_UPDATE_EXPLANATION' => '更新 {{module}} "{{name}}"',
    'LBL_ACTION_DELETE_EXPLANATION' => '刪除 {{module}} "{{name}}"',
    'LBL_ACTION_LINK_EXPLANATION' => '將 {{module}} "{{name}}" 連結至 {{relatedModule}}"{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => '取消 {{module}} "{{name}}" 和 {{relatedModule}} "{{relatedName}}" 的連結',
    'LBL_ACTION_FOLLOW_EXPLANATION' => '關注 {{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => '取消關注 {{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => '已將 {{module}} "{{name}}" 添加至最愛',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => '已取消將 {{module}} "{{name}}" 添加至最愛',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => '已建立 {{module}} "{{name}}" 關聯至 {{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => '主要',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => '退出',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => '加入',
    'LBL_EMAIL_ACTION_SET_VALID' => '有效',
    'LBL_EMAIL_ACTION_SET_INVALID' => '無效',
    'LBL_ROLLBACK_BUTTON' => '復原',
    'LBL_TX_LOG' => '交易記錄',
    'LBL_TX_LOG_DETAIL' => '交易詳細資料',
    'LBL_RECORD_DELETED' => '(已刪除記錄)',
    'LBL_NOT_AVAILABLE' => 'N/A',
    'LBL_FILE_SIZE' => '檔案大小',
    'LBL_FILE_SIZE_UNITS_B' => '位元',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => '選擇項目',
    'LBL_OFFLINE_DB_SIZE' => '資料庫大小',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => '每個模組的記錄',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => '記錄總數量',
    'LBL_RECORD_NOT_FOUND' => '找不到記錄。',
    'LBL_RELATED_RECORD_NOT_FOUND' => '找不到關聯記錄。',
    'LBL_NOT_AUTHORIZED' => '您無權檢視此記錄。',
    'LBL_MOBILE_PROCESSING_FILE' => '正在準備檔案...',
    'LNK_THIRD_PARTY_SOFTWARE' => '第三方軟體',
    'LNK_TERMS_OF_USE' => '使用條款',
    'LNK_PRIVACY_POLICY' => '隱私權政策',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => '單一登入',
    'LBL_RECENTS' => '最近',
    'LBL_SHOWING_CACHED_DATA' => '無法存取伺服器。正在顯示最新可用資料 ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => '關閉 {{moduleSingular}} 並儲存',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => '特定儀表板',
    'LBL_MOBILE_SPECIFIC_MODULE' => '特定模組',
    'LBL_MOBILE_DEFAULT_VIEW' => '啟動螢幕',
    'LBL_MOBILE_DEFAULT_MODULE' => '已選取模組',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => '已選取儀表板',
    'LBL_MOBILE_DEFAULT_DASHLET' => '已選取 Dashlet',
    'LBL_ALL_DASHLETS' => '所有 Dashlet',
    'LBL_MOBILE_GLOBAL_SEARCH' => '全域搜尋',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => '輸入 @ 提到其他使用者。輸入 # 參考其他記錄。',
    'LBL_MOBILE_NEW_COMMENT' => '新註解',
    'LBL_RECENTLY_VIEWED' => '最近檢視',
    'LBL_FILE_STORED_LOCALLY' => '文件儲存於本地空間，在設備連上網路時將立刻同步。',
    'LBL_IDM_USER_PROFILE_READONLY' => '如果您想要更改某些不可編輯的字段，請聯絡管理員，告知想更改的內容。',
    'LBL_ACTIVITY_POST' => '{{{link}}} 上的 {{{value}}}',
    'LBL_COMMENTLOG_EMPTY' => '無評論',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => '顯示下 {{{commentsLeft}}} 條評論',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => '摺疊',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => '確認創建評論',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => '評論日誌不能為空白',
    'LBL_MOBILE_PDF_DOWNLOAD' => '下載 {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => '無法與伺服器同步',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => '未授權的訪問。',
    'ERR_MOBILE_INVALID_CREDS' => '無效使用名或密碼。',
    'ERR_MOBILE_SESSION_EXPIRED' => '您的工作階段已過期。',
    'ERR_MOBILE_NOT_FOUND' => '找不到資源。',
    'ERR_MOBILE_TIMEOUT' => '伺服器沒有響應。',
    'ERR_MOBILE_CONNECTION_FAILED' => '無法連結伺服器。',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => '網際網路連接不可用。',
    'ERR_MOBILE_INTERNAL' => '內部錯誤 ({{{code}}})。請稍後再試一次。',
    'ERR_MOBILE_VALIDATION' => '記錄無效',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => '不相容的伺服器類別：{{{flavor}}}。支援的伺服器類別：{{{supportedFlavors}}}。',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => '不相容的伺服器版本：{{{version}}}。要求的最低版本：{{{minVersion}}}。',
    'ERR_MOBILE_EMAIL' => '錯誤。無效電子郵件地址。',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => '不支援此文件類型。',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => '授權失敗。',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => '找不到請求的資源。',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => '內部伺服器錯誤。',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => '不可使用。',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => '服務不可用。',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => '出現一個意外錯誤。',
    'ERR_MOBILE_UPLOAD' => '上載檔案時出錯',
    'ERR_MOBILE_FILE_PROCESSING' => '檔案處理時出錯',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => '裝置儲存體不可用',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => '您的應用程式已過期，且不再與您正在連接的 {{{brandName}}} 實例相容。您想要從 App Store 下載應用程式新版本嗎？',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => '伺服器設定已變更，要求重新載入。繼續？',
    'ERR_MOBILE_CONFLICT' => '有人已在伺服器上編輯相同的記錄。按「確認」以自動合併您的變更或按「拒絕」以放棄變更。',
    'ERR_MOBILE_METADATA_CHANGED' => '伺服器設定已變更。',
    'ERR_MOBILE_FILE_READ' => '無法讀取檔案',
    'ERR_MOBILE_FILE_NOT_FOUND' => '找不到檔案',
    'ERR_MOBILE_FILE_NOT_READABLE' => '檔案不可讀取',
    'ERR_MOBILE_FILE_ABORTED' => '已中止讀取作業',
    'ERR_MOBILE_FILE_SECURITY' => '檔案已鎖定',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => '移動版不支援此功能。您要繼續打開桌面版嗎？',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => '檔案太大。允許的最大大小為 {{size}}',
    'ERR_OFFLINE' => '離線錯誤',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => '無法打開本地儲存體',
    'ERR_OFFLINE_STORAGE_CREATE' => '無法建立本地儲存體',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => '無法建立本地儲存體：您的空間不足。',
    'ERR_OFFLINE_OUT_OF_SPACE' => '您的本地儲存體的空間不足。',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => '資料庫清理失敗',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => '您的離線儲存體空間不足。建議您清理儲存體。這可能需要幾分鐘時間。',
    'ERR_OFFLINE_PREFETCH_FAILED' => '無法從伺服器預先擷取記錄',
    'ERR_OFFLINE_SYNC_ERROR' => '同步處理錯誤',
    'ERR_OFFLINE_SYNC_CONFLICT' => '同步處理衝突',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => '無法獲取伺服器時間',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => '無法啟用離線模式。無法存取伺服器。',
    'LBL_EXPORT_CSV' => '匯出 CSV',
    'LBL_ERR_EXPORTING_CSV' => '匯出失敗',
    'LBL_ERR_EXPORT_ALL' => '獲取所選記錄的數據失敗，請重試',
    'LBL_LIST_SETTINGS_RESTORE' => '恢復默認值',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => '恢復字段？',
    'LBL_LIST_SETTINGS_TITLE' => '列表視圖生成器',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => '可用字段',
    'LBL_LIST_SETTINGS_REMOVE' => '刪除',
    'LBL_LIST_SETTINGS_TEXT' => '將字段拖入列表視圖構建器並重新排列它們以設計 {{moduleName}} 列表視圖。',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => '佈局中必須至少添加一個字段。',
    'LBL_LIST_SETTINGS_EMPTY' => '沒有可用的字段',
    'LBL_LIST_SETTINGS_NO_MATCHING' => '找不到匹配的字段',
    'LBL_LIST_FILTER' => '現場搜索',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => '電子郵件客戶端',
    'LBL_DEFAULT_SYSTEM_CLIENT' => '外部電子郵件客戶端',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar 電子郵件客戶端',
    'LBL_OFFLINE_CAPABILITIES' => '啟用離線功能',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => '交易刪除失敗。',
    'LBL_OFFLINE_TRANSACTION_DELETED' => '交易已刪除。',
    'LBL_SECURE_MODE' => '增強的安全模式',
    'LBL_SECURE_MODE_ANDROID_TEXT' => '啟用此設置可在應用程式處於後台時隱藏 Sugar Mobile 的內容，並隨時阻止應用程式的螢幕截圖。',
    'LBL_SECURE_MODE_IOS_TEXT' => '此文件類型包含的數據格式以原始格式，可以在電子表格應用程序中打開。其中包含報告數據，但不包括表格和表格。',
    'LBL_ALWAYS_OFFLINE_MODE' => '實時離線模式',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => '您正在持續離線模式下工作。您要重新連接嗎？',
    'LBL_RECONNECT' => '重新連接',
    'LBL_STAY_OFFLINE' => '保持離線',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => '您試用訪問的模塊在 Sugar Mobile 上不可用。',
    'LBL_MOBILE_RELEASE_NOTE' => 'Sugar Mobile {{platform}} 發行說明',
    'LBL_MOBILE_USER_GUIDE' => 'Sugar Mobile {{platform}} 用戶指南',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => '包含這些字組',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => '排除這些字組',
    'LBL_NOTIFICATIONS_CHANNEL' => '更新',
    'LBL_APPLY_BUTTON_LABEL' => '套用',
    'LBL_ACTION_CREATE_FAILURE' => "無法儲存記錄：\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "無法更新記錄：\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => '無法解析服務器上的字段計算。',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => '以下欄位無效：{{{fields}}}。',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>成功。</b> 您已成功創建 {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}"。</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>成功。</b> 您已成功更新紀錄',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => '無法從服務器獲取電子郵件數據。',
    'LBL_ASSIGN_SUCCESS' => '<b>成功。</b> 記錄已分配给 {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => '這篇郵件保存為草稿？',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => '保存為草稿',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => '丟棄電子郵件',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => '如果不保存草稿，您將遺棄此電子郵件。',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => '選擇簽名',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => '選擇電子郵件模板',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => '模板內容將覆蓋此電子郵件中的所有內容。您確定要使用此模板並包含內容嗎？',
    'LBL_MOBILE_EMAIL_COMPOSE' => '撰寫電子郵件',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => '您的電子郵件中包含的變量將使用相關收件人記錄中的值進行替換。發送前請確認相關收件人字段設置正確。',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => '找不到輸出電子郵件帳戶。請聯繫您的 Sugar 管理員。',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' 以及 {{{count}}} 更多',
    'LBL_RECEPIENTS_EMAIL_ADD' => '新增電子郵件',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => '鍵入聯繫人姓名或電子郵件',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}} (新電子郵件)',
    'LBL_TEMPLATE_HAS_VARIABLES' => '變數',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => '電子郵件範本',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => '活動範本',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => '工作流程範本',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => '系統範本',
    'LBL_FILTER_EDIT' => '編輯篩選器',
    'LBL_FILTER_MY_FILTER' => '我的篩選器',
    'LBL_FILTER_MY_FILTER_BY' => '我的篩選器 {{{filters}}}',
    'LBL_FILTER_SAVE' => '儲存篩選條件',
    'LBL_SELECT_PARAM' => '選擇',
    'LBL_SELECT_MODULES' => '模塊選擇器',
    'LBL_SELECT_ADDITIONAL_PARAMS' => '選擇其他參數',
    'LBL_FILTER_TEMPORARY' => '臨時篩選器',
    'LBL_ERROR_FILE_UPLOAD' => '無法上傳 {{{fieldLabel}}} 文件「{{{fileName}}}」。{{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">查看失敗紀錄</a>',
    'LBL_FILE_UPLOAD_ONE' => '正在儲存文件...',
    'LBL_FILE_UPLOAD_MANY' => '正在保存文件 {{{index}}}，共 {{{total}}}...',
    'LNK_NOTIFICATIONS_SETTINGS' => '通知設置',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => '管理您的推送通知',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "使用設備的通知設置控制通知的顯示方式。",
    'LBL_NOTIFICATION_ASSIGMENTS' => '指派',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => '當記錄分配給您時接收通知。',
    'LBL_NOTIFICATION_MENTIONS' => '提及',
    'LBL_NOTIFICATION_MENTIONS_DSC' => '當您在評論日誌條目中被提及時接收通知。',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => '管理員尚未將註釋日誌字段添加到此佈局中。請聯繫您的 Sugar 管理員。',
    'ERR_NO_PERMISSION_TITLE' => '請允許訪問',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} 需要相機訪問權限，以便您可以附加照片。請在系統設置中允許相機訪問。',
    'LBL_MOBILE_SYSTEM_SETTINGS' => '設定',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => '持續時間',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => '剩餘的時間',
    'LBL_LIST_SUPPORT_EXPIRES' => '過期',
    'LBL_CASCADE_RLI_EDIT' => '更新未結算收入單項',
    'LBL_MOBILE_CALENDAR' => '行事曆',
    'LBL_MOBILE_CALENDAR_SETTINGS' => '行事曆設定',
    'LBL_MOBILE_CALENDAR_WEEK_START' => '週開始日',
    'LBL_MOBILE_CALENDAR_MODULES' => '要顯示的事件',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}}小時:{{{minutes}}}分鐘',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} 小時',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} 分鐘',
    'LBL_MOBILE_CALENDAR_TODAY' => '今天',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => '新增 {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => '安排活動',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => '請啟用至少一種事件類型。',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => '整天',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => '未能加載行事曆。',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => '此操作在 Sugar Mobile 中不可用。您要改為打開桌面應用程式嗎？',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => '選擇範例',
    'LBL_DOC_MERGES_ACTION_MERGE' => '合併',
    'LBL_ERROR_IMAGE_NO_EXIF' => '錯誤：HEIC 檔案中缺少 EXIF 資料',
    'LBL_ERROR_IMAGE_TOO_BIG' => '錯誤：圖像解析度太高',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => '錯誤：無法處理圖像',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => '錯誤：無法將圖像渲染到畫布',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => '錯誤：無法將檔案載入為圖像',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '已選擇 1 項',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '已選擇 {{{count}}} 個項目',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => '選取所有',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => '您已在此視圖中選擇 {{{count}}} 條記錄。選擇所有記錄？',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => '選擇 {{{count}}} 條記錄',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => '您確定要刪除選取的記錄嗎？',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => '正在刪除 {{{total}}} 條紀錄中的 {{{count}}} 條',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => '在所選記錄中找不到有效的電子郵件',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => '外觀',
    'LBL_MOBILE_APP_THEME_SYSTEM' => '使用系統設置',
    'LBL_MOBILE_APP_THEME_LIGHT' => '淺',
    'LBL_MOBILE_APP_THEME_DARK' => '深',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => '新檔案名稱',
    'LBL_ATTACHMENT_RENAME_MSG' => '重新命名檔案',
    // Filters related
    'LBL_CREATED_BY_ME' => '由我建立',
    'LBL_OPERATOR_ONE_OF' => '是其中的',
    'LBL_OPERATOR_NOT_ONE_OF' => '不是其中的',
    'LBL_OPERATOR_CONTAINS' => '其中的',
    'LBL_OPERATOR_CONTAINS_WORD' => '包含',
    'LBL_OPERATOR_NOT_CONTAINS' => '不是其中的',
    'LBL_OPERATOR_EMPTY' => '為空',
    'LBL_OPERATOR_NOT_EMPTY' => '不為空',
    'LBL_OPERATOR_MATCHES' => '完全匹配',
    'LBL_OPERATOR_STARTS_WITH' => '開始於',
    'LBL_OPERATOR_EQUALS' => '等於',
    'LBL_OPERATOR_NOT_EQUALS' => '不等於',
    'LBL_OPERATOR_GREATER_THAN' => '大於',
    'LBL_OPERATOR_LESS_THAN' => '小於',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => '大於等於',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => '小於等於',
    'LBL_OPERATOR_BETWEEN' => '之間',
    'LBL_OPERATOR_BEFORE' => '之前',
    'LBL_OPERATOR_AFTER' => '之後',
    'LBL_OPERATOR_YESTERDAY' => '昨天',
    'LBL_OPERATOR_TODAY' => '今天',
    'LBL_OPERATOR_TOMORROW' => '明天',
    'LBL_OPERATOR_LAST_7_DAYS' => '過去 7 天',
    'LBL_OPERATOR_NEXT_7_DAYS' => '未來 7 天',
    'LBL_OPERATOR_LAST_30_DAYS' => '過去 30 天',
    'LBL_OPERATOR_NEXT_30_DAYS' => '未來 30 天',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => '超過 __ 天前',
    'LBL_OPERATOR_LAST_X_DAYS' => '過去 __ 天',
    'LBL_OPERATOR_NEXT_X_DAYS' => '未來 __ 天',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => '超過未來 __ 天',
    'LBL_OPERATOR_LAST_MONTH' => '上個月',
    'LBL_OPERATOR_THIS_MONTH' => '本月',
    'LBL_OPERATOR_NEXT_MONTH' => '下個月',
    'LBL_OPERATOR_LAST_YEAR' => '去年',
    'LBL_OPERATOR_THIS_YEAR' => '今年',
    'LBL_OPERATOR_NEXT_YEAR' => '明年',
    'LBL_OPERATOR_IS' => '是',
    'LBL_OPERATOR_IS_NOT' => '不是',
    'LBL_OPERATOR_AFTER_TODAY' => '今天之後',
    'LBL_OPERATOR_BEFORE_TODAY' => '今天之前',
    'LBL_ERROR_FILTER_EMPTY' => '請添加過濾條件。',
    'LBL_ADD_FILTER' => '增加條件',
    'LBL_FILTER_NAME' => '篩選器名稱',
    'LBL_FILTER_FIELD' => '欄位',
    'LBL_FILTER_OPERATOR' => '運算子',
    'LBL_FILTER_VALUE' => '值',
    'LBL_FILTER_SYNC_TO_SERVER' => '保存至桌面 App',
    'LBL_FILTER_LOCAL' => '本地篩選器',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => '歡迎來到 {{{brandName}}}。<br/><br/>讓我們重點介紹一些新功能...',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => '主功能表導覽。',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => '每個檢視表的可用操作。',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => '全域搜尋記錄。',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => '篩選清單以顯示我最愛的記錄。',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => '篩選清單以顯示分配給我的記錄。',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => '將記錄標記為最愛。',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => '我今天開始的近期事件。',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => '最近修改的記錄。',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => '記錄可執行的操作。',
    'LBL_MOBILE_TUTORIAL_HOME_END' => '享受所有新功能！',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => '這是 Plus 功能表。',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => '關閉 Plus 功能表。',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => '選取特定操組以檢視執行。',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => '這是首頁功能表。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => '關閉首頁功能表。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => '檢視特定模組。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => '自訂應用程式。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => '在網路瀏覽器中打開 Sugar。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => '檢視您的個人檔案。',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => '這是詳細頁面。',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => '關於記錄的最重要的資訊。',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => '檢視其他資訊或編輯記錄。',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => '記錄可執行的操作。',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => '前往上一頁。',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => '隨時存取嚮導。',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => '返回。',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => '按一下打開關聯記錄。',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => '關注/取消關注記錄。',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => '按一下展開詳細資訊。',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => '主功能表檢視表。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => '主功能表在螢幕左側打開。',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => '詳細資料檢視表',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => '詳情檢視表在螢幕右側打開。',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => '使用下方的箭頭快速瀏覽此功能表的關鍵元件。',

    'LBL_COMMENT_ADD' => '添加注釋',
    'LBL_REQUIRED' => '必填',
    'LBL_MORE_BUTTON' => '更多',
    'LBL_NO_OPTIONS' => '無可用選項',
    'LBL_TRY_AGAIN' => '再試一次',
    'LBL_NEW_RECORDS' => '最近建立',
    'LBL_ASSIGNED_TO_ME' => '我的 {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => '所有 {{{module}}}',
    'LBL_UNFAVORITE' => '不喜愛的',
    'LBL_ACTIVITY_CREATE' => '已創建 {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => '更新 {{{changes}}} {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_LINK' => '連結 {{{relatedRecord}}} 到 {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => '取消 {{{relatedRecord}}} 到 {{{record}}} {{{module}}} 的連結',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{relationship}} 對 {{parentModule}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => '下載相關記錄...',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => '您的儀表板配置已更改。是否要重新載入？',
    'LBL_RECORDS' => '記錄',
    'LBL_DASHBOARDS' => '儀表板',
    'LBL_TEMPLATES' => '範本',
    'LBL_NON_TEMPLATES' => '非範本',
    'LBL_IS_TEMPLATE' => '是範本',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => '您的選擇包含無法批量更新的儀表板範本。請取消選擇範本以繼續。',
    'LBL_UNSELECT_DELETE_TEMPLATES' => '您的選擇包含無法批量刪除的儀表板範本。請取消選擇範本以繼續。',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => '搜尋 {{searchCriteria}}...',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => '主功能表',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => '快速建立新記錄',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => '刷卡以瞭解更多選項',
    'LBL_DETAILS' => '詳細資料',
    'LBL_DETAIL_RELATED' => '相關',
    'LBL_CREATE_RELATED_MODULE_WARN' => '這個 {{module}} 需要 {{relatedModule}}。 <a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>創建一個 {{relatedModule}} 記錄</a>。',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => '編輯記錄',
    'LBL_OFFLINE_MENU_SETTINGS' => '離線設定',
    'LBL_OFFLINE_DEBUG_SETTINGS' => '偵錯設定',
    'LBL_OFFLINE_TOTAL_RECORDS' => '總記錄',
    'LBL_OFFLINE_LAST_DOWNLOAD' => '上次下載',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => '無法下載該檔。',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => '無法從伺服器載入儀表板',
    'ERR_FILTERS_FETCHING' => '無法獲取篩選器',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => '無法加密本地儲存體',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => '加密離線資料。這可能需要幾分鐘時間。',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => '已完成離線資料加密。',
    'ERR_ACCESS_SPECIFIC_MODULE' => '您沒有訪問 {{{module}}} 模組的許可權。',
    'LBL_SKIP' => '跳過',
    'LBL_CONTINUE' => '繼續',
    'LBL_ENABLE' => '啟用',
    'LBL_MOBILE_TRIAL_UNTIL' => '試用直到',
    'LBL_MOBILE_SDK_VERSION' => '試用直到',
    'LBL_LOG_LEVEL' => '記錄層級',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => '登錄設定已重新配置。',
    'LBL_TRIAL_PERIOD_EXPIRED' => '您的試用期已過期。',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => '伺服器不支援安全連線。請關閉安全連線。',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => '伺服器支援安全連線。請打開安全連線。',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => '您的連接不安全。請與管理員聯繫。',
    'LBL_LOGIN_SETTINGS_HEADER' => '登錄設定',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => '設置您的 {{{brandName}}} 實例',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => '為了確保應用程式正常作業，您需要输入 {{{brandName}}} 實例的 URL。如果您沒有實例 URL，請聯絡管理員。',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => '啟用 {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => '設定 {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => '使用手指登錄',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "您的設備上未設置{{{biometryType}}} 。 轉到設備設置以設置 {{{biometryType}}}。設置後，在主功能表 >> 設置中啟用 {{{brandName}}} {{{biometryType}}}。",
    'LBL_TOUCH_ID_DISCLAIMER' => '使用 {{{biometryType}}} 與 {{{brandName}}} 將允許您使用您的生物識別識別碼，而不是輸入您的密碼來訪問 {{{brandName}}}。',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => '你想繼續進行 {{{biometryType}}} 嗎？    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => '輸入 {{{brandName}}} 密碼以啟用 {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => '設置',
    'LBL_MDM_CONFIRM_CHANGE' => '已通過移動設備管理器更改應用程式配置。請重新登錄已應用變更。',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => '請通過設備設定為 {{{brandName}}} 授予訪問您所在位置的權限。',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => '當前位置不可用',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "當前位置搜尋超時。\n請再試一次。",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => '位置地標不可用',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => '位置座標無效',
    'ERR_MOBILE_INVALID_PASSWORD' => '無效的密碼。',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => '您的應用程式已過期，且不再與您正在連接的 {{{brandName}}} 實例相容。您要更新嗎？',
    'LBL_MOBILE_BY' => '透過',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => '此篩選器在離線時不可用。',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => '離線記錄',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => '下載設置',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => '下載已分配、已收藏和已關注的紀錄以便離線訪問。您可以在離線設置中更新首選項。',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => '您的記錄已下載完畢。現在您可以在離線模式下訪問它們。',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "未下载完所有紀錄。\n是否要重試一次？",
    'LBL_BULK_LOAD_USE_CELLULAR' => '使用蜂窩數據',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => '不是現在',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => '已暂停下載，您再次打開應用程式時會繼續下載。',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => '正在下載 {{{module}}}: {{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => '更新最新記錄',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => '正在等待連接',
    'LBL_BULK_LOAD_STATUS_PAUSED' => '暫停',
    'LBL_BULK_LOAD_STATUS_STOPPING' => '停止',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => '下載',
    'LBL_BULK_LOAD_BTN_PAUSE' => '暫停',
    'LBL_BULK_LOAD_BTN_RESUME' => '繼續',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => '預設情況下僅使用 WiFi 連接',
    'LBL_NPS_RATING_MSG' => "你如何對你的 \n{{{productName}}} 經驗進行評分？",
    'LBL_NPS_THANKS_MSG' => '感謝您的回饋!',
    'LBL_NPS_APPSTORE_RATE_MSG' => '你介意在App商店評分嗎？',
    'LBL_NPS_NO_THANKS' => '不，謝謝',
    'LBL_NPS_NOT_NOW' => '不是現在',
    'LBL_NPS_RATE_NOW' => '現在',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => '網路不可用。您仍可以在離線時使用該應用程式',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => '您的更改將在連線時同步。 <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>查看詳細資訊</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => '有未同步的資料。請檢查 <a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>事務日誌</a>',
    'LBL_CONVERT' => '轉換',
    'LBL_CONVERT_LEAD' => '轉換潛在客戶',
    'LBL_SEARCH_EXISTING_RECORD' => '搜尋現有 {{{this}}}',
    'LBL_DUPLICATES_CHECK_FAILED' => '重複確認失敗',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => '您希望移動關聯活動至連絡人記錄嗎?',
    'LBL_LEAD_CONVERSION_SUCCESS' => '您已成功轉換潛在客戶 {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => '未找到重複項。',
    'ERR_LEAD_CONVERSION_FAIL' => '潛在客戶轉換失敗',
    'LBL_SELECT_DUPLICATE_RECORD' => '從重複 {{{modulePlural}}} 中選擇',
    'LBL_SELECTED_EXISTING_RECORD' => '已選取 {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => '新建 {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => '後退按鈕',
    'LBL_VO_HOME_BTN' => '首頁按鈕',
    'LBL_VO_DASHBOARD_BTN' => '儀表板按鈕',
    'LBL_VO_SEARCH_BTN' => '搜尋按鈕',
    'LBL_VO_RIGHT_MENU_BTN' => '右功能表按鈕',
    'LBL_VO_ADD_BTN' => '添加按鈕',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => '折扣',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => '選擇一個地圖 app',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => '所選的 {{entityName}} 具有相關值：{{localizedFieldNames}}。取消以保留現有值。確認用新值覆蓋。',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => '啟用了數據加密。',
    'LBL_LEAD_ALREADY_CONVERTED' => '選定的潛在客戶已經轉換。',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => '僅當設備在線時此操作才可用',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => '確定要從報價中建立此商機嗎？',
    'LBL_TAG_ADD' => '新增標籤',
    'LBL_TAG_ENTER_TAG_NAME' => '輸入標籤',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => '設備離線時，不支援依照標籤過濾。',
    'LBL_COMMENTLOG_SHOWCOMMENT' => '顯示全部評論',
    'LBL_COMMENT_VIEW' => '檢視注釋',
    'LBL_PMSE_LABEL_DUEDATE' => '到期日',
    'LBL_PMSE_DUE' => '到期',
    'LBL_PMSE_DUE_ON' => '到期於',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => '請先建立 {{conversionParentModuleName}}',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => '缺少必需的記錄：{{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => '選擇圖像品質。保存到伺服器之前，將相應調整圖像大小。所選的值將在將來用作所有類似操作的默認值。',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => '估算文件大小...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => '估計的文件大小為',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => '圖像品質',
    'LBL_IMAGE_QUALITY_BEST' => '原始大小',
    'LBL_IMAGE_QUALITY_GOOD' => '高品質',
    'LBL_IMAGE_QUALITY_POOR' => '小容量',
    'LBL_IMAGE_QUALITY_BTN' => '壓縮：{{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => '列出字段 {{module}}',
    'LBL_LIST_RESET_FIELDS' => '重設為預設',
    'LBL_LIST_NOT_ENOUGH' => '請至少設置 1 個活動字段。',
    'LBL_LOGIN_PERMISSION_ABORTED' => '您需要登錄並接受權限才能使用 SugarCRM 實例。',
    'LBL_SELECTING_EXISTING_RECORD' => '正在選取 {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => '正在新建 {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => '圖片大小',
    'LBL_COPY_ADDRESS' => '複製地址',
    'LBL_OPEN_IN' => '開啟用',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => '無選取的檔案',
    'LBL_ATTACHMENT_ADD' => '附加',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => '此應用程式使用 cookies',
    'LBL_USE_COOKIES_CONFIRM' => '此應用程式使用 cookies 來幫助為您提供更好的體驗。如果繼續，則表示您同意我們根據隱私政策使用 cookies。',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => '您正在使用即將發布的移動版本中與 Sugar Mobile 不兼容的 Sugar 實例。請要求您的管理員盡快升級 Sugar。',
    'ERROR_TAG_NAME_INVALID' => '標籤名稱不能包含 “ {{{forbiddenChars}}}” 字符',
    'ERROR_NO_TAGS_FOUND' => '沒有與 “ {{{{searchQuery}}}” 匹配的標籤',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} 記錄具有一個或多個無效值，無法保存。您是否要編輯記錄以便執行 {{{actionLabel}}} 動作？',
    'ERR_MOBILE_METADATA_RELOAD' => '管理員對您的 Sugar 實例進行了配置更改。按確定以將您的應用程序配置與服務器同步。',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => '此應用程式使用 cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => '選擇以接受(必選)',
    'LBL_USER_COOKIE_CONSENT_TEXT' => '此應用程式使用 cookies 來幫助為您提供更好的體驗。如果繼續，則表示您同意我們根據<a href="{{href}}" target="_blank">隱私政策</a>使用 cookies。',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => '記錄檢視表允許您查看記錄詳細資料。',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => '附註讓您與其他入口網站使用者和支援代表合作。',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => '按一次此處為記錄新增附註。',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => '按一下這些圖示檢視附加附註的詳細資料。',

    //for portal
    'LBL_PORTAL_HOME' => '首頁儀表板',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => '所有開放實例',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => '最近已解決的案件',
    'LBL_PORTAL_SEARCH' => '按名稱、編號搜尋',
    'LBL_SIGNUP_BUTTON_LABEL' => '註冊',
    'LBL_PORTAL_NO_EMAIL' => '沒有收到電子郵寄嗎?',
    'LBL_PORTAL_FORGOT_PASSWORD' => '忘記密碼',
    'LBL_PORTAL_FORGOT_USERNAME' => '忘記使用者名稱',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => '請輸入兩次密碼。密碼必須符合。',
    'LBL_PORTAL_RESET_PASSWORD' => '重設密碼',
    'LBL_PORTAL_REENTER_PASSWORD' => '再次輸入密碼',
    'LBL_PORTAL_PASSWORD_MISMATCH' => '密碼不符合，請再試一次',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => '密碼已經重新設定成功。',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => '發生錯誤。請發起重設新密碼的請求。',
    'LBL_PORTAL_SIGNUP_PROCESS' => '正在註冊',
    'LBL_PORTAL_SIGNUP_TITLE' => '感謝您的註冊',
    'LBL_PORTAL_SIGNUP' => '我們將會在確認詳細訊息後通知您。',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => '名字',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => '姓氏',
    'LBL_PORTAL_SIGNUP_USER_NAME' => '使用者名稱',
    'LBL_PORTAL_SIGNUP_EMAIL' => '電子郵件地址',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (可選)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => '國家',
    'LBL_PORTAL_SIGNUP_STATE' => '狀態',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => '公司名稱',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => '職務 (可選)',
    'LBL_PORTAL_SIGNUP_PASSWORD' => '密碼',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => '確認密碼',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => '忘記登入',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => '忘記密碼？',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => '請連絡 Sugar 管理員以重置密碼。',
    'LBL_PORTAL_LOGIN_USERNAME' => '使用者名稱',
    'LBL_PORTAL_LOGIN_PASSWORD' => '密碼',
    'LBL_PORTAL_LOADING' => '載入中',
    'LBL_PORTAL_SAVING' => '正在儲存',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => '頁面不可用',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "抱歉，該功能目前不可用。",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => '顯示 "{query}" 的搜尋結果',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => '沒有收到電子郵寄嗎?',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => '如需要協助或需要聯繫我們，請使用下列任一方法： ',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => '電話: ',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => '電子郵件: ',
    'LBL_PORTAL_CONTACT_INFO_WEB' => '網路: ',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => '您確定要關閉聊天嗎？',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => '建立附註或新增附件',
    'LBL_PORTAL_NEW_NOTE_BTN' => '新增附註',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => '登入失敗。請重試一次。',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => '無效認證',
    'LBL_PORTAL_INVALID_GRANT' => '您的會話已過期。請重新登入。',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => '會話已過期',
    'LBL_PORTAL_AUTH_FAILED' => '用戶端驗證失敗。',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => '無效用戶端',
    'LBL_PORTAL_INVALID_REQUEST' => '請求無效或格式不正確。請聯絡技術支援。',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => '無效請求',
    'LBL_PORTAL_REQUEST_TIMEOUT' => '請求超時。',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => '請求超時',
    'LBL_PORTAL_UNAUTHORIZED' => '抱歉，您沒有權限訪問該資源。',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => '未授權',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => '資源不可用。',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => '停止使用',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => '不允許此資源使用 HTTP 方法。請連絡技術支援。',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => '不允許的方法',
    'LBL_PORTAL_PRECONDITION_MISSING' => '請求失敗，或參數缺少/無效。請連絡技術支援',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => '錯誤： ',
    'LBL_PORTAL_MIN_MODULES' => '您至少應啟用實例、錯誤或知識庫模組才能使用此應用程式。',
    'LBL_PORTAL_ERROR' => ' 錯誤',
    'LBL_PORTAL_ROUTE_ERROR' => '載入模組時遇到問題。請稍候再試一次或連絡支援。',
    'LBL_PORTAL_OFFLINE' => '抱歉，應用程式目前不可用。請連絡網站管理員。',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => '變更密碼',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => '用戶名已經被註冊。請送出忘記密碼請求或選擇其他用戶名。',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => '所提供的電子郵件無效。',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => '密碼不一致。',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => '服務控制台',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => '概觀',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => '恢復默認儀表板',
    'LBL_UNTITLED' => '未命名',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => '續訂控制台',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => '概觀',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => '階段/狀態',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => '姓名/帳戶名稱',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => '全渠道儀表板',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => '客戶',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} 於 {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => '您的瀏覽器不支援 SugarLive。請使用 Google Chrome 或 Mozilla Firefox。',
    'LBL_OMNICHANNEL_RECORD_CREATED' => '已建立 <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a>，其中包含您的會話詳細。',
    'LBL_OMNICHANNEL_SUBJECT' => '主題',
    'LBL_OMNICHANNEL_DESCRIPTION' => '描述',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => '訊息摘要',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => '實例摘要',
    'LBL_OMNICHANNEL_LINK_TO' => '將 {{fromModule}} 連結到 {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => '連結到{{module}}',
    'LBL_OMNICHANNEL_LINKED' => '已連結',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => '您的瀏覽器不支援聊天。請使用 Google Chrome 或 Mozilla Firefox。',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => '請聯系您的 Sugar 管理員獲取幫助。',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => '配置版面',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => '請在進行撥出電話之前完成 SugarLive 的配置。',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => '請在打開 SugarLive 之前完成對 SugarLive 佈局的配置。',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => '在配置 SugarLive 佈局之前，請在 SugarLive 中將自己設置為“離線”。',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => '緊湊檢視表',
    'LBL_OMNICHANNEL_FULL_VIEW' => '全視圖',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR 儀表板',
    'LBL_SALES_MANAGER_CONSOLE' => '銷售經理儀表板',
    'LBL_SALES_REP_CONSOLE' => '銷售代表儀表板',
    'LBL_MARKETING_CONSOLE' => '行銷儀表板',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => '客戶成功儀表板',
    'LBL_EXECUTIVE_CONSOLE' => '主管儀表板',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => '恢復選項卡為默認',
    'LBL_CONFIGURE_SUMMARY_PANEL' => '配置摘要面板',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => '使用者設定檔',
    'LBL_WIZ_COMPLETE_TITLE' => '安裝完成',
    'LBL_SETUP_COMPLETE_INFO' => '開始使用 Sugar！',
    'LBL_SETUP_USER_INFO' => '設定您的使用者資訊',
    'LBL_WIZ_USER_LOCALE_TITLE' => '使用者地區設定',
    'LBL_SETUP_USER_LOCALE_INFO' => '設置您的時區、 日期和名稱格式',
    'LBL_WIZ_START_SUGAR' => '啟動 Sugar',
    'LBL_WIZ_FIRST_NAME' => '名字',
    'LBL_WIZ_LAST_NAME' => '姓氏',
    'LBL_WIZ_EMAIL' => '電子郵件',
    'LBL_WIZ_TIMEZONE' => '時區',
    'LBL_WIZ_TIMEFORMAT' => '時間格式',
    'LBL_WIZ_DATE_FORMAT' => '日期格式',
    'LBL_WIZ_NAME_FORMAT' => '名稱格式',
    'LBL_SETUP_PROGRESS' => '安裝進度',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar 訓練',
    'LBL_WIZ_DOCUMENTATION' => '文件',
    'LBL_WIZ_KNOWLEDGE_BASE' => '知識庫',
    'LBL_WIZ_FORUMS' => '論壇',
    'TPL_TIMEZONE_DIFFERENT' => '瀏覽器的時區與已儲存時區 {{link}} 不一致',
    'LBL_TIMEZONE_DIFFERENT_LINK' => '調整您的時區。',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => '地區設定',
    'LBL_WIZ_EMAIL_SETTINGS' => '電子郵件設定',
    'LBL_WIZ_IMPORT_DATA' => '匯入資料',
    'LBL_WIZ_CREATE_USERS' => '建立使用者',
    'LBL_WIZ_APPLICATION_SETTINGS' => '系統設定',
    'LBL_WIZ_CONFIGURE_APPLICATION' => '工作室',

    'LBL_CSP_ERROR_MESSAGE' => '您輸入的值不受支持或不符合可接受的格式。有關可接受的字段值和格式的列表，請參閱<a href="{{linkToDocumentation}}" target="_blank">系統</a>文檔。',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => '此內容尚未被批准。請更新系統的<a href="{{linkToDocumentation}}" target="_blank">內容安全策略設置</a>。',
    'LBL_CSP_ERROR_MESSAGE_USER' => '此內容尚未被批准。請您的管理員更新系統的<a href="{{linkToDocumentation}}" target="_blank">內容安全策略設置</a>。設置更新後，您將需要刷新瀏覽器以使更改生效。',

    // For password related labels
    'LBL_PASSWORD' => '密碼',
    'LBL_CHANGE_YOUR_PASSWORD' => '變更您的密碼',
    'LBL_PASSWORD_REQUIREMENTS' => '密碼要求',
    'LBL_CURRENT_PASSWORD' => '目前密碼',
    'LBL_NEW_PASSWORD1' => '新密碼',
    'LBL_NEW_PASSWORD2' => '確認密碼',
    'LBL_PASSWORD_CHANGED' => '您已成功變更密碼',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => '請輸入您的密碼確認。',
    'ERR_ENTER_NEW_PASSWORD' => '請輸入您的新密碼。',
    'ERR_ENTER_OLD_PASSWORD' => '請輸入您目前的密碼。',
    'ERR_REENTER_PASSWORDS' => '輸入的密碼必須一致。',
    'ERR_PASSWORD_MISMATCH' => '您輸入的密碼與系統儲存的密碼不一致。',
    'LBL_CANNOT_SEND_PASSWORD' => '無法傳送密碼',
    'LBL_REQUEST_PASSWORD' => '請求密碼',
    'LBL_RESET_PASSWORD' => '重設密碼',
    'LBL_RESET_PASSWORD_MESSAGE' => '請輸入您的用戶名，我們將發送重設密碼的連結。',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => '請查看您的電子郵件 <br><br> 我們已經向儲存的電子郵件地址發送密碼重設的指示。',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => '錯誤：更新此使用者密碼時遇到問題。',
    'LBL_INCORRECT_PASSWORD' => '錯誤：密碼不正確。',
    'LBL_PASSWORD_ENFORCE_TITLE' => '您輸入的密碼不滿足密碼要求。請再試一次。',
    'LBL_PASSWORD_MIN_LENGTH' => '最小長度為 {0}。',
    'LBL_PASSWORD_MAX_LENGTH' => '最大長度為 {0}。',
    'LBL_PASSWORD_ONE_UPPERCASE' => '必須包含大寫字母 (A-Z)。',
    'LBL_PASSWORD_ONE_LOWERCASE' => '必須包含小寫字母 (a-z).',
    'LBL_PASSWORD_ONE_NUMBER' => '必須包含數字 (0-9)。',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => '必須包含特殊符號 (~!@#$%^&*()_+-={}|)。',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => '密碼不能與正則表達式模式相符合: {0}。',

    'LBL_PREFERRED_LANGUAGE' => '語言喜好設定：',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => '無法寄送重設密碼的電子郵件。',

    //Saved Reports
    'LBL_REPORT_SELECT' => '選取一個報表',
    'LBL_REPORT_AUTO_REFRESH' => '自動重新整理',
    'LBL_REPORT_EDIT' => '編輯已選取報表',
    'LBL_REFRESH_LIST_AND_CHART' => '刷新列表和圖表',
    'LBL_NO_CHART_REPORT_AVAILABLE' => '沒有可用圖表。',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => '此報告不包含任何篩選器。',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => '您只有隱藏的運行時篩選器，請參閱高級篩選器。',
    'LBL_RUNTIME_FILTERS' => '執行階段篩選器',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => '日期與使用者的偏好日期格式不相符： ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => '此 dashlet 沒有執行階段篩選器',
    'LBL_DASHBOARD_FILTER_GROUP' => '新篩選器',
    'LBL_RUNTIME_FILTER_LIMITATION' => '您需要選擇至少一個值。',
    'LBL_RESET_FILTERS_TO_DEFAULT' => '重置為預設篩選器',
    'LBL_COPY_FILTER_SUMMARY' => '複製篩選器摘要',
    'LBL_APPLY_FILTERS' => '套用',
    'LBL_REPORTS_FILTERS' => '篩選器',
    'LBL_RUNTIME_FILTERS_INVALID' => '由於值無效，無法應用運行時篩選器',
    'LBL_RUNTIME_FILTERS_COPIED' => '篩選器摘要已復製到剪貼板。',
    'LBL_ADVANCED_FILTERS' => '進階篩選器',
    'LBL_ADVANCED_OR_DESC' => '滿足任何條件時包括',
    'LBL_ADVANCED_AND_DESC' => '滿足所有條件時包括',
    'LBL_ORIGINAL_DESIGN_FILTER' => '這是原創設計的篩選器',
    'LBL_AND_UPPERCASE' => '和',
    'LBL_REPORTS_PREVIEW_LIMITATION' => '此功能在預覽模式下不可用',
    'LBL_REPORT_DEFAULT_NAME' => '無標題報告',
    'LBL_REPORT_QUERY' => '查詢',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => '與當前記錄相關',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => '已連結欄位',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => '鏈接字段不能為空',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => '未選擇用戶。',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => '折線圖與此報告不相容',
    'LBL_REPORT_DASHLET' => '報告儀表板',
    'LBL_REPORTS_DASHLET_DATATABLE' => '數據表',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => '執行階段篩選器',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => '數據表預覽',
    'LBL_REPORTS_DASHLET_CHART' => '圖表',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => '圖表預覽',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => '篩選器預覽',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => '所選報告不支持圖表。',
    'LBL_REPORTS_DASHLET_LABELS' => '標籤',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => '顯示總記錄數',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => '排序順序',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => '默認選定視圖',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => '主要圖表排序順序',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => '次要圖表排序順序',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => '沒有 {{module}} 鏈接到選定的報告',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => '此報告類型不可用',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => '此功能僅在圖表選項卡上可用',
    'LBL_REPORTS_CHART_TYPE' => '圖表類型',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => '橫條圖值放置',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => '顯示總計',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => '顯示圖例',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => '顯示 x 軸標籤',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => '顯示 y 軸標籤',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => '列數顯示限制',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => '您沒有使用這些執行階段篩選器的權限。',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => '未知',
    'ERR_HTTP_DEFAULT_TITLE' => '未知錯誤',
    'ERR_HTTP_DEFAULT_TEXT' => '未知錯誤。',
    'ERR_HTTP_DEFAULT_ACTION' => '返回上一頁。',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => '錯誤：無效請求',
    'ERR_HTTP_400_TEXT_LINE1' => '您的瀏覽器傳送了伺服器無法理解的請求。',
    'ERR_HTTP_400_TEXT_LINE2' => '請連絡 Sugar 管理員了解更多詳細資料。',
    'ERR_HTTP_400_ACTION' => '返回上一頁。',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => '資料不可用',
    'ERR_HTTP_404_TEXT_LINE1' => '頁面不存在或您無此頁面的存取權限。',
    'ERR_HTTP_404_TEXT_LINE2' => '請再試一次。如果錯誤繼續出現，請連絡您的 Sugar 管理員。',
    'ERR_HTTP_404_ACTION' => '返回上一頁。',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP：500 內部伺服器錯誤',
    'ERR_HTTP_500_TEXT_LINE1' => '伺服器遇到錯誤，無法完成您的請求。',
    'ERR_HTTP_500_TEXT_LINE2' => '請再試一次。如果錯誤繼續出現，請連絡您的 Sugar 管理員。',
    'ERR_HTTP_500_ACTION' => '請連絡技術支援。',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 內部伺服器錯誤',
    'ERR_HTTP_502_TEXT_LINE1' => '伺服器遇到暫時性錯誤，無法完成您的請求。',
    'ERR_HTTP_502_TEXT_LINE2' => '請再試一次。如果錯誤繼續出現，請連絡您的 Sugar 管理員。',
    'ERR_HTTP_502_ACTION' => '請連絡技術支援。',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 內部伺服器錯誤',
    'ERR_HTTP_503_TEXT_LINE1' => '伺服器不可用來完成您的請求。',
    'ERR_HTTP_503_TEXT_LINE2' => '請稍後再試一次。如果錯誤繼續出現，請連絡您的 Sugar 管理員。',
    'ERR_HTTP_503_ACTION' => '請連絡技術支援。',

    'ERR_RENDER_FAILED_TITLE' => '檢視轉譯器失敗',
    'ERR_RENDER_FAILED_MSG' => '無法轉譯檢視表',
    'ERR_RENDER_FIELD_FAILED_TITLE' => '欄位轉譯失敗',
    'ERR_RENDER_FIELD_FAILED_MSG' => '無法轉譯 {0} 欄位。',

    'ERR_NO_VIEW_ACCESS_TITLE' => '已拒絕存取',
    'ERR_NO_VIEW_ACCESS_REASON' => '您無存取此頁面的權限。',
    'ERR_NO_VIEW_ACCESS_ACTION' => '連絡您的管理員請求存取。',
    'ERR_NO_VIEW_ACCESS_MSG' => '連絡您的管理員取得 {0} 模組檢視表的存取權限。',

    'ERR_LAYOUT_RENDER_TITLE' => '版面配置轉譯失敗',
    'ERR_LAYOUT_RENDER_MSG' => '哎呀！我們無法轉譯任何內容。請稍候再試一次或連絡支援團隊。',
    'ERR_INTERNAL_ERR_MSG' => '內部錯誤',
    'ERR_GENERIC_TITLE' => ' 錯誤',
    'ERR_CONTACT_TECH_SUPPORT' => '請連絡技術支援。',

    'LBL_SYNCED_RECURRING_MSG' => '您無法編輯此記錄，因為它是從外部用戶端同步的。',
    'LBL_EXISTING' => '已存在',
    'LBL_PANEL_DEFAULT' => '預設',
    'ERR_BAD_RESPONSE_FROM_SERVER' => '不正確的伺服器回應',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => '執行AssignTo 動作過程中出錯。',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => '您無法訪問“{{name}}”。請聯繫您的管理員。',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => '年 {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} 季度{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => '更多動作',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => '警示',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => '忽略重複並儲存',
    'LBL_RESTORE' => '重置為初始值',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => '標記為擦除的記錄',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => '顯示與資料隱私請求相關的記錄， '
        . '擦除資訊。',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS 訂閱',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => '新增外部 RSS 或部落格摘要，了解最新動態。',
    'LBL_RSS_FEED_URL' => '摘要 URL',
    'LBL_RSS_FEED_AUTHOR' => '作者：',
    'LBL_RSS_FEED_ENTRIES_COUNT' => '顯示的項目數量',
    'LBL_ERR_LOADING_RSS_FEED' => '載入 RSS 摘要失敗',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => '我的項目',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => '小組項目',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => '允許使用者將 Sugar 應用程式添加到儀錶板',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => '歷史',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => '歷史 Dashlet 顯示已舉辦會議、已記錄通話、已接收和已傳送的電子郵件。',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => '電子郵件',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => '電子郵件',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => '我的歷史',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => '小組歷史',
    'LBL_UNASSIGNED' => '未指派',
    'LBL_ARCHIVE_EMAIL' => '封存電子郵件',
    'LBL_EMAIL_ARCHIVED' => '已封存電子郵件',
    'LBL_CREATE_ARCHIVED_EMAIL' => '建立已存檔的電子郵件',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => '已規劃活動',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => '已規劃活動 Dashlet 顯示已排程的會議和通話。',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => '今天',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => '未來',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => '我的活動',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => '小組活動',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => '已保留',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => '您確定要將 {0} 標記為已關閉嗎？',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => '進行中的工作',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => '進行中的工作 Dashlet 小時已經到期、即將開始和待辦工作。',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => '現在到期',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => '即將開始的',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => '待辦',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => '已完成',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => '您確定要關閉 {0} 為已完成嗎？',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '我的工作',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => '小組工作',
    'LBL_LIST_REMOVE_EMAIL_INFO' => '您正在修改的記錄上還有其他電子郵件。現在，它將成為主電子郵件並在下方填充。',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => '已停用工作',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => '工作 Dashlet 顯示延遲和已完成的工作。',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => '已延期',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => '已完成',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => '上次修改 {{relativetime}} 於 {{date}} 的 {{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '我的工作',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => '小組工作',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => '目前檢視過的案件',

    'LBL_REPORT_DASHLET_TITLE_12' => '按照用戶和狀態排列公開案件',
    'LBL_REPORT_DASHLET_TITLE_125' => '按月搜尋商務中心的新案件',
    'LBL_REPORT_DASHLET_TITLE_126' => '最近建立的案件',
    'LBL_REPORT_DASHLET_TITLE_127' => '按月搜尋客戶層新案件',
    'LBL_REPORT_DASHLET_TITLE_128' => '按客戶層按優先次序公開案件',
    'LBL_REPORT_DASHLET_TITLE_129' => '本月商務中心已解決的案件總數',
    'LBL_REPORT_DASHLET_TITLE_130' => '本月代理商已解決的案件總數',
    'LBL_REPORT_DASHLET_TITLE_131' => '最近已解決的案件清單',
    'LBL_REPORT_DASHLET_TITLE_132' => '按月搜尋本週已解決的案件',
    'LBL_REPORT_DASHLET_TITLE_133' => '今日截止逾期的案件',
    'LBL_REPORT_DASHLET_TITLE_134' => '今日截止逾期的所有案件',
    'LBL_REPORT_DASHLET_TITLE_135' => '按待處理日期搜尋公開案件',
    'LBL_REPORT_DASHLET_TITLE_136' => '按待處理日期搜尋所有公開案件',
    'LBL_REPORT_DASHLET_TITLE_137' => '按狀態搜尋公開案件',
    'LBL_REPORT_DASHLET_TITLE_138' => '按狀態搜尋上週案件',
    'LBL_REPORT_DASHLET_TITLE_139' => '經我指派的公開任務狀態',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP 或舊 REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => '邏輯掛鉤',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar 工作流',
    'LBL_AUDIT_SUBJECT_USER' => '使用者',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => '圖表',
    'LBL_CHART_NO_DATA' => '沒有可用資料。',
    'LBL_CHART_LEGEND_CLOSE' => '隱藏圖例',
    'LBL_CHART_LEGEND_OPEN' => '顯示圖例',
    'LBL_CHART_CONTROLS_CLOSE' => '隱藏控制項',
    'LBL_CHART_CONTROLS_OPEN' => '顯示控制項',
    'LBL_CHART_UNDEFINED' => '未定義',
    'LBL_CHART_NO_LABEL' => '未定義',
    'LBL_CHART_AMOUNT' => '金額',
    'LBL_CHART_COUNT' => '計數',
    'LBL_CHART_PERCENT' => '百分比',
    'LBL_CHART_GROUP' => '群組',
    'LBL_CHART_DATE' => '日期',
    'LBL_CHART_KEY' => '金鑰',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => '圖表類型',
    'LBL_CHART_CONFIG_SHOW_TITLE' => '顯示標題',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => '顯示總計',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => '顯示 x 軸標籤',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => '顯示 y 軸標籤',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => '核取顯示方法',
    'LBL_CHART_CONFIG_TICK_WRAP' => '換行核取',
    'LBL_CHART_CONFIG_TICK_STAGGER' => '間隔核取',
    'LBL_CHART_CONFIG_TICK_ROTATE' => '旋轉核取',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => '橫條圖值放置',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => '橫條圖顯示選項',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => '允許捲動',
    'LBL_CHART_CONFIG_STACK_DATA' => '堆疊資料數列',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => '隱藏空群組',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => '已傳送',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => '已儲存記錄。', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => '您已成功建立 {{moduleSingularLower}}<a href="#{{buildRoute model=this}}">{{name}}</a>。', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => '成功建立 {{moduleSingularLower}}。',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => '您已成功建立此記錄，但您無權限存取此記錄。', // use when user has no access to the model
    'LBL_VALIDATING' => '正在驗證...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => '成功：',
    'LBL_ALERT_TITLE_WARNING' => '警告：',
    'LBL_ALERT_TITLE_NOTICE' => '通知：',
    'LBL_ALERT_TITLE_ERROR' => '錯誤：',
    'LBL_ALERT_TITLE_LOADING' => '載入中',
    'LBL_ALERT_NO_ACCESS' => '您沒有訪問應用於此儀表板的篩選器。',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => '使用您自己的篩選器複製儀表板以配置此儀表板。',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => '不再支援您的瀏覽器版本，或者您正在使用不受支援的瀏覽器。',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => '支援的平台',
    'LBL_ALERT_CONFIRM_DELETE' => '您確定要刪除此項目嗎？',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => '您確定要刪除這些項目嗎？',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => '選區的記錄將複寫以下值：{{values}}。按「取消」以保留現有值。按「確認」使用新值複寫。',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => '此為您的模組為其他關聯模組提供的用於顯示的子面板',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => '發件者：',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => '收件者：',

    //organization chart
    'LBL_ORG_CHART' => '組織圖表',
    'LBL_ORG_CHART_DESC' => '顯示組織的員工結構。',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => '切換方向',
    'LBL_ORG_CHART_TOOLTIP_NODES' => '顯示所有節點',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => '縮放到合適大小',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => '實例摘要',
    'LBL_CASE_SUMMARY_CHART_DESC' => '顯示相關實例概覽。',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => '摘要',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => '已結束實例',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => '開放實例',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => '前 10 名銷售額',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => '在泡泡圖中顯示前十名的銷售額。',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => '我的項目',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "我的小組的項目",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => '預設日期篩選器',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => '預設資料集',

    'LBL_PRODUCT_CATALOG_NAME' => '產品目錄',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => '產品目錄',
    'LBL_PRODUCT_CATALOG_DESC' => '從您的產品目錄查看和添加項目。',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => '從您的產品目錄查看和添加項目。',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}} 於 {{date}} 的 {{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => '輸入附註或拖放附件。輸入 @ 提到其他使用者。輸入 # 參考其他記錄。',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => '新增註解 &hellip; 輸入 @ 提到其他使用者。輸入 # 參考其他記錄。',
    'LBL_ACTIVITY_STREAM' => '活動流',
    'LBL_ACTIVITY_STREAM_DISABLED' => '未啟用互動流',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => '此模組未啟用活動流。',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => '更多貼文...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => '於',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => '我的活動流',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => '檢視對記錄執行的活動清單，並建立和發佈註解。',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => '活動流已禁用',

    'LBL_DATA_VIEW' => '資料檢視表',
    'LBL_COMMENT' => '註解',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => '連接伺服器時出錯。請再試一次。',
    'ERR_RESOLVE_ERRORS' => '繼續前請修正任何錯誤。',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => '為了批准，必須填寫所有必要欄位；但是，您仍然可以拒絕或路由此記錄。',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => '為了拒絕/路由所有必需的欄位必須填寫。',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => '重新整理清單',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => '更新標題',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => '更多',
    'LBL_TEXTAREA_LESS' => '小於',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}} 附件',
    'LBL_CREATE_ATTACHMENT' => '建立附件',
    'LBL_DASHLET_REFRESH' => '重新整理',
    'LBL_DASHLET_MOVE' => '移動',
    'LBL_DASHLET_CLOSE' => '關閉',

    'LBL_DASHLET_FORECAST_NAME' => '預測',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => '預測長條圖',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => '預測橫條圖',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => '預測目的',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => '顯示特定時間週期內的預測橫條圖',
    'LBL_DASHLET_FORECASTS_GROUPBY' => '分組依據',
    'LBL_DASHLET_FORECASTS_DATASET' => '資料集',
    'LBL_DASHLET_FORECASTS_DETAILS' => '預測的詳細資料',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => '顯示目前預測詳細資料。',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => '已儲存報告圖表 Dashlet',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => '顯示來自已儲存報表的任意圖表。',

    'LBL_QUESTION_MARK' => '？',

    'LBL_DASHLET_RELATED_DOCUMENTS' => '已發佈的相關文章',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => '顯示已發布的相關知識庫文章的清單',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => '歷史摘要',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => '更多歷史...',
    'LBL_RELATED_CONTACT' => '相關連絡人',
    'LBL_MODULE_TYPE' => '類型',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => '電子郵件收件者',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => '電子郵件發件者',
    'LBL_PREVIEW_BWC_TOOLTIP' => '無法預覽傳統模組',

    //SFA
    'LBL_BEST' => '最佳',
    'LBL_WORST' => '最差',
    'LBL_LIKELY' => '可能金額',
    'LBL_BEST_FORECAST' => '提交(最佳)',
    'LBL_WORST_FORECAST' => '提交(最差)',
    'LBL_LIKELY_FORECAST' => '提交(可能)',
    'LBL_BEST_ADJUSTED' => '調整後提交(最佳)',
    'LBL_WORST_ADJUSTED' => '調整後提交(最差)',
    'LBL_LIKELY_ADJUSTED' => '調整後提交(可能)',
    'LBL_AMOUNT_USDOLLAR' => '已轉換金額',
    'LBL_OVERDUE' => '逾期',

    'LBL_PASSWORD_REQUEST_SENT' => '您的請求已提交。',
    'LBL_PASSWORD_REQUEST_ERROR' => '抓取您的使用者名稱和電子郵件組合時遇到問題。',

    'LBL_REMINDER_TITLE' => '提醒',
    'LBL_CLICK_TO_DRILLDOWN' => '按一下以向下切入',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => '您無法停用所有語言。',

    'LBL_UPDATE_CALC_FIELDS' => '重新計算值',

    //Optimistic Locking
    'LBL_YOU' => '您',
    'LBL_RESOLVE_CONFLICT' => '為 {{name}} 解決衝突',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => '如需更多資訊，請參閱 {{{more_info_url}}}{{plural_module_name}} 文件。{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => '沒有可用資料',
    'LBL_NEED_HELP' => '在新事物上需要幫助？',
    'LBL_NEW_CASE' => '新實例',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => '說明 Dashlet 提供屬於您正在檢視的模組的特定信息，以及前往應用程式指南中的對應文件（如「潛在客戶」文件）的連結，以讓您了解更多資訊。',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => '清單檢視表說明',
    'LBL_HELP_RECORDS' => "模組的清單檢視表顯示符合目前搜尋標準以及使用者擁有存取權限的所有記錄。您可在清單檢視表的欄位內檢視每條記錄的基本詳細資料，或按一下記錄名稱打開記錄檢視表。",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => '記錄檢視表說明',
    'LBL_HELP_RECORD' => '此記錄檢視表提供每條記錄的詳細資訊，以及與之連結的記錄的部分詳細資料。

- 按一下每條記錄或「編輯」按鈕，即可編輯此記錄的欄位。
- 將左下角窗格切換至「資料檢視表」，可檢視或修改子面板其他記錄的連結
- 將左下角窗格切換至「活動流」，可與使用者註解互動或檢視記錄變更歷史
- 使用記錄名稱右側的圖示追蹤此記錄或將其新增至我的最愛。
- 「編輯」按鈕右側的下來式「動作」功能表提供其他動作選項。',

    // create view
    'LBL_HELP_CREATE_TITLE' => '{{module_name}} 建立',
    'LBL_HELP_CREATE' => '建立 {{plural_module_name}}： 
1. 按需提供欄位值。 
 * 標記為「必填」的欄位在儲存前必須先填寫完整。
 * 按一下「顯示更多」以顯示更多欄位（若需）。 
2. 按一下「儲存」以完成新記錄並返回 {{plural_module_name}}。',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => '偵測到可能的重複項',
    'LBL_HELP_DUPLICATE' => 'Sugar 偵測到您正在建立的記錄可能已經存在。

如需修改現有記錄而非建立新記錄，按一下目標記錄右側的「選取並編輯」按鈕。現有記錄中的任何空白欄位都將填入您此前輸入的值。按一下「儲存」在現有記錄上做出變更。

相反，如果您想要使用您輸入的值，而非現有記錄的值，按一下「重設為初始值」。隨後，您輸入的值將應用至現有記錄，您亦可做出其他變更，然後按一下「儲存」在現有記錄上完成修改。

如需使用您已經輸入的值建立新記錄，請按一下螢幕右上角的「忽略重複並儲存」。',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => '缺少 SMTP 伺服器設定',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => '如需傳送記錄分配通知，必須在 {{emailSettingsUrl}} 設定 SMTP 伺服器。',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => '電子郵件設定',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => '新庫存報表可用',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => '新庫存報表已存在於你的 ',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => '報表模組',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => '他們備標為"庫存報表"，可以進行篩選。報告也根據內容被標記為"銷售與營銷"、"客戶服務"、"數據隱私"或"管理"。更多訊息請參閱',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => '文件',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM 允許進階使用者使用鍵盤捷徑快速執行特定任務，以提高生產力。右側表格說明了可用捷徑和鍵位，及其對應的功能。',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>支援的按鍵</h1><ul><li>所有字母數位字元和符號</li> <li>shift、ctrl、alt、command、mod (Windows/Linux 為 ctrl ，Mac 為 command)</li> <li>enter、esc、 space、tab、 pageup、 pagedown、end、home、ins、 del、backspace</li></ul><h1>支援的功能</h1><ul><li>按鍵組合︰ctrl + m</li> <li>多個按鍵︰m，ctrl + m</li> <li>按鍵順序 ︰ m</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => '全域捷徑',
    'LBL_CONTEXTUAL_SHORTCUTS' => '關聯式捷徑',
    'LBL_SHORTCUT_KEY_KEY' => '金鑰',
    'LBL_SHORTCUT_FUNCTION' => '功能',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => '設定關聯式捷徑',
    'LBL_SHORTCUT_CONFIG_DISABLED' => '沒有要設定的關聯式捷徑',
    'LBL_SHORTCUT_HELP' => '顯示捷徑說明頁面',
    'LBL_SHORTCUT_QUICK_CREATE' => '切換快速建立功能表',
    'LBL_SHORTCUT_SEARCH' => '集中於全域搜尋欄位',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => '切換側邊列',
    'LBL_SHORTCUT_CREATE_RECORD' => '建立新記錄',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => '選取清單的下一條記錄',
    'LBL_SHORTCUT_NAVIGATE_UP' => '選取清單的上一條記錄',
    'LBL_SHORTCUT_SCROLL_LEFT' => '向左捲動清單',
    'LBL_SHORTCUT_SCROLL_RIGHT' => '向右捲動清單',
    'LBL_SHORTCUT_OPEN' => '打開清單中的選定記錄',
    'LBL_SHORTCUT_EDIT_SELECTED' => '編輯清單中的選取記錄',
    'LBL_SHORTCUT_RECORD_DELETE' => '刪除記錄',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => '退出清單內嵌編輯模式而不儲存。',
    'LBL_SHORTCUT_RECORD_SAVE' => '儲存記錄',
    'LBL_SHORTCUT_RECORD_CANCEL' => '清除記錄的所有變更',
    'LBL_SHORTCUT_FAVORITE_RECORD' => '將記錄標記為最愛',
    'LBL_SHORTCUT_FOLLOW_RECORD' => '關注記錄',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => '預覽記錄',
    'LBL_SHORTCUT_MARK_SELECTED' => '將記錄標記為已選取',
    'LBL_SHORTCUT_SELECT_ALL' => '選取所有',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => '打開大量動作下拉式功能表',
    'LBL_SHORTCUT_FILTER_SEARCH' => '集中於清單篩選欄位',
    'LBL_SHORTCUT_FILTER_CREATE' => '建立新清單篩選',
    'LBL_SHORTCUT_FILTER_EDIT' => '編輯目前清單篩選器',
    'LBL_SHORTCUT_FILTER_SHOW' => '打開清單篩選功能表',
    'LBL_SHORTCUT_RECORD_EDIT' => '編輯記錄',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => '打開上一條記錄',
    'LBL_SHORTCUT_RECORD_NEXT' => '打開下一個記錄',
    'LBL_SHORTCUT_COPY_RECORD' => '複製目前記錄',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => '打開主動作下拉式功能表',
    'LBL_SHORTCUT_CLOSE_DRAWER' => '關閉抽屜',
    'LBL_SHORTCUT_FILTER_ADD' => '在篩選器中新增標準',
    'LBL_SHORTCUT_FILTER_REMOVE' => '從篩選器中移除上一標準',
    'LBL_SHORTCUT_FILTER_CLOSE' => '關閉篩選器',
    'LBL_SHORTCUT_FILTER_SAVE' => '儲存篩選條件',
    'LBL_SHORTCUT_FILTER_DELETE' => '刪除篩選器',
    'LBL_SHORTCUT_FILTER_RESET' => '重置篩選器',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => '新增列',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => '移除列',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => '關閉大量更新',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => '更新記錄',
    'LBL_CREATE_CATEGORY' => '建立<div class="btn-link" data-action="create-new">分類</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => '確認',
    'LBL_SHORTCUT_ALERT_CANCEL' => '取消',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => '在多選欄位選取一個項目',
    'LBL_SHORTCUT_SWEETSPOT' => '切換 Sweet Spot 列',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => '隱藏 Sweet Spot 列',
    'LBL_SHORTCUT_SAVE_CONFIG' => '儲存設定',
    'LBL_SHORTCUT_RESTORE' => '還原預設',
    'LBL_SHORTCUT_CONFIG_ERROR' => '在伺服器上儲存自訂快速鍵時出錯。請再試一次。',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}} 設定',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '已儲存 {{module}} 配置設定。',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}} 設定錯誤',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}} 沒有任何配置設定',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => '使用者無 {{module}} 的存取權限',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => '使用者無權限配置 {{module}} 設定',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => '需修正 {{module}} 的資料庫設定',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => '到',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => '開始和結束日期',

    'LBL_CALENDAR_START_DATE' => '開始日期',
    'LBL_CALENDAR_END_DATE' => '結束日期',
    'LBL_CALENDAR_DURATION' => '持續時間',
    'LBL_CALENDAR_RECURRENCE' => '週期',
    'LBL_CALENDAR_REMINDERS' => '提醒',

    'LBL_CALENDAR_CUSTOM_DATE' => '自訂日期',
    'LBL_CALENDAR_REPEAT_TYPE' => '重複類型',
    'LBL_CALENDAR_REPEAT_INTERVAL' => '重複間隔',
    'LBL_CALENDAR_REPEAT_DOW' => '一週內的重複天數',
    'LBL_CALENDAR_REPEAT_ON' => '重複執行',
    'LBL_CALENDAR_REPEAT' => '重複',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => '重複直到',
    'LBL_CALENDAR_REPEAT_COUNT' => '重複發生次數',
    'LBL_CALENDAR_REPEAT_SELECTOR' => '重複選取器',
    'LBL_CALENDAR_REPEAT_DAYS' => '日期',
    'LBL_CALENDAR_REPEAT_MONTH' => '一年中的月份',
    'LBL_CALENDAR_REPEAT_ORDINAL' => '重複序號',
    'LBL_CALENDAR_REPEAT_UNIT' => '重複單位',
    'TPL_REPEAT_INTERVAL' => '每 {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => '此系列使用「重複執行」選項，該選項在 Sugar 中不可用，因為該系列同步自一個行事曆用戶端。如果您想要保持在特定日期重複執行，請在您的行事曆用戶端中編輯該系列。在 Sugar 中編輯該系列會將「重複執行」設定為「無」。<br><br>是否繼續？',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => '必須使用序列中的第一條記錄變更發生次數',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => '週期規則不會導致產生事件。',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => '出席',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => '已拒絕',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => '暫訂',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => '無回覆',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => '排程不可用',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => '可用視圖',
    'LBL_CALENDAR_DASHLET_NAME' => '日程計畫任務',
    'LBL_CALENDAR_DEFAULT_VIEW' => '默認視圖',
    'LBL_CALENDAR_MY_CALENDARS' => '我的日程',
    'LBL_CALENDAR_OTHER_CALENDARS' => '用戶和團隊日程',
    'LBL_CALENDAR' => '日程',

    'LBL_CALENDAR_DAY' => '天',
    'LBL_CALENDAR_WEEK' => '週',
    'LBL_CALENDAR_MONTH' => '月',
    'LBL_CALENDAR_YEAR' => '年',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '第 2 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '第 3 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '第 4 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '第 5 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '第 6 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '第 7 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '第 8 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '第 9 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '第 10 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '第 11 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '第 12 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '第 13 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '第 14 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '第 15 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '第 16 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '第 17 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '第 18 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '第 19 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '第 20 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '第 21 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '第 22 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '第 23 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '第 24 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '第 25 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '第 26 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '第 27 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '第 28 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '第 29 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '第 30 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '第 31 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '第 32 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '第 33 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '第 34 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '第 35 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '第 36 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '第 37 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '第 38 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '第 39 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '第 40 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '第 41 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '第 42 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '第 43 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '第 44 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '第 45 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '第 46 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '第 47 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '第 48 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '第 49 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '第 50 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '第 51 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '第 52 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '第 53 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '第 54 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '第 55 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '第 56 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '第 57 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '第 58 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '第 59 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '第 60 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '第 61 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '第 62 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '第 63 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '第 64 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '第 65 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '第 66 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '第 67 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '第 68 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '第 69 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '第 70 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '第 71 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '第 72 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '第 73 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '第 74 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '第 75 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '第 76 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '第 77 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '第 78 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '第 79 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '第 80 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '第 81 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '第 82 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '第 83 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '第 84 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '第 85 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '第 86 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '第 87 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '第 88 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '第 89 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '第 90 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '第 91 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '第 92 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '第 93 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '第 94 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '第 95 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '第 96 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '第 97 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '第 98 次',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '第 99 次',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => '抓取排程時出錯。',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => '儲存並發送邀請',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => '接受狀態',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => '流程',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => '進程儀表板顯示可在SugarBPM內部使用的範本。',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => '流程定義',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => '進程定義儀錶盤顯示可在SugarBPM內部使用的範本。',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => '建立流程定義',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => '匯入流程定義',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => '流程商務規則',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => '流程商務規則儀錶盤顯示可在SugarBPM內部使用的範本。',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => '建立流程商務規則',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => '匯入流程商務規則',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => '流程電子郵件範本',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => '處理電子郵件範本儀錶盤顯示可在SugarBPM內部使用的範本。',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => '建立流程電子郵件範本',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => '匯入流程電子郵件範本',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => '當您在 Sugar 其他實例中開發流程/業務規則/電子郵件範本時，我們強烈建議於您生產系統中精確再製一個實例。在 Sugar 獨立實例內建立的流程/業務規則/電子郵件範本可能無法在完成匯入後正常工作。流程/業務規則/電子郵件範本可能依賴特定工作室或應用程式級別的變更，包括但不限於自訂欄位名稱、下拉式清單值、資料庫 ID 等。如果此類值與建立流程/商務規則/電子郵件範本的實例不一致，您可能需要手動在目標實例中重建流程/商務規則/電子郵件範本。',
    'LBL_PMSE_IMPORT_CONFIRMATION' => '您仍然想使用此匯入繼續嗎？',
    'LBL_PMSE_EXPORT_CONFIRMATION' => '您仍然想使用此匯出繼續嗎？',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => '以下下拉式選單欄位包含無效選項',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => '按流程分類的擱置活動',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => '擱置活動',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => '按流程分類的擱置活動',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => '所有流程',
    'LBL_RECORD_DASHBOARD' => '記錄儀表板',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => '流程狀態摘要',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => '流程狀態描述',

    'LBL_PMSE_IN_PROGESS_STATUS' => '進行中',
    'LBL_PMSE_COMPLETED_STATUS' => '已完成',
    'LBL_PMSE_CANCELLED_STATUS' => '已取消',
    'LBL_PMSE_TERMINATED_STATUS' => '已終止',
    'LBL_PMSE_ERROR_STATUS' => ' 錯誤',
    'LBL_PMSE_SETTINGS' => 'SugarBPM設置',

    'LBL_PRO_DISABLE_CONFIRMATION' => '您確定要停用此記錄嗎？',
    'LBL_PRO_ENABLE_CONFIRMATION' => '您確定要啟用此記錄嗎？',
    'LBL_PRO_DELETE_CONFIRMATION' => '確定要刪除此記錄嗎？',

    'LBL_PRO_ENABLE' => '正在更新',
    'LBL_PRO_DISABLE' => '正在更新',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} 正參與一項流程，並且可能包含一些鎖定欄位。如需編輯記錄，按一下此處 {{link}}。',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => '此欄位已鎖定，因為它涉及一項執行中的程序。',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => '此記錄正參與一項流程，可能包含一些鎖定欄位。',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => '商務中心',
    'LBL_BUSINESS_CENTER_ID' => '商務中心識別碼',
    'LBL_BUSINESS_CENTER_NAME' => '商務中心名稱',

    'LBL_PLIS_ACTIVITIES' => '購買項目的活動',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(新標籤)',
    'LBL_TAG_FETCH_ERROR' => '抓取標籤時出錯。',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'Sugar 7 要求使用 javascript。請在瀏覽器中啟用 javascript 以使用 Sugar 7。',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => '已序列化資料無法取消序列化',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => '序列化資料無法取消序列化，因為其含有對象或等級參考',

    'LBL_FIELD_TRIMMED' => '由於超過最大字元限制，欄位已被修剪。',
    'LBL_FIELDSIZE_OVERFLOW' => '欄位超出最大字元限制。',
    'LBL_TINYMCE_TARGET_SAME' => '相同視窗',
    'LBL_TINYMCE_TARGET_NEW' => '新視窗',

    'LBL_OUTBOUND_EMAILS' => '電子郵件設定',
    'LBL_OUTBOUND_EMAIL' => '電子郵件設定',

    'LBL_EMAIL_PARTICIPANTS' => '電子郵件的參與者',
    'LBL_EMAIL_PARTICIPANT' => '電子郵件的參與者',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => '數據隱私',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => '數據隱私',
    'LBL_DATAPRIVACY_VIEW_PII' => '查看個人資訊',
    'LBL_DATAPRIVACY_MARKFORERASE' => '標記擦除',
    'LBL_DATAPRIVACY_FIELDNAME' => '欄位',
    'LBL_DATAPRIVACY_VALUE' => '值',
    'LBL_DATAPRIVACY_CHANGED_BY' => '變更人',
    'LBL_DATAPRIVACY_SOURCE' => '來源',
    'LBL_DATAPRIVACY_CHANGE_DATE' => '最近更新',
    'LBL_DATAPRIVACY_PII' => '個人資訊',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => '標記擦除',
    'TPL_DATAPRIVACY_PII_TITLE' => '{{{name}}} 的個人資訊',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => '更改計時器',
    'LBL_MESSAGES_SUBPANEL_TITLE' => '訊息',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => '複製到剪貼簿!',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => '無法複製到剪貼簿',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => '複製確認鏈接',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => '時間軸',
    'LBL_NO_ACTIVITY' => '無活動',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} 時間軸',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => '更多',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => '小於',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => '時間軸顯示當前記錄的相關記錄，並選擇欄位隨時間推移的更新。',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => '顯示更多...',
    'LBL_COMMENT_LOG_SHOW_LESS' => '顯示小於...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => '無數據可用',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => '模塊未獲得許可。',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => '活動訂閱',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => '只能為鏈接到單個帳戶的模組添加此儀表。請參閱<a href={{linkToDocumentation}}>活動訂閱儀表</a> 文檔了解更多訊息。',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => '顯示屬於此帳戶的購買:',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => '特定帳戶的活動訂閱',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => '，數量 {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => '總計:',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => '無活動訂閱',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => '此 Dashlet 需要 {{module_name}} 才可運作。請聯絡您的管理員請求啟用 {{module_name}}。',
    'LBL_PURCHASE_HISTORY_DASHLET' => '購買歷史紀錄',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => '特定帳戶的所有購買。',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => '只可為連結到單個帳戶的模組添加此 dashlet。請參閱<a href={{linkToDocumentation}} target="_blank">購買歷史紀錄 dashlet</a> 文件獲取更多訊息。',
    'LBL_NO_PURCHASE_HISTORY' => '沒有可顯示的購買',
    'LBL_NO_PLIS' => '沒有已購買單項',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => '總計',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => '數量',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => '此 dashlet 需要“購買”和“已購買單項”才可運行。請告知管理員啟用“購物”和“已購買單項”。',
    'LBL_SEARCH_PURCHASE_NAME' => '以購買名稱搜索...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => '使用Studio來編輯記錄，即可前往並檢視dashlet版面配置 ' .
        'Studio > {{module}} > 布局 > 紀錄 Dashlet 視圖。 <a href={{linkToStudio}}>在 Studio 中編輯</a>。',
    'LBL_SERVICE_LEVEL' => '服務等級',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => '編號',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => '待處理',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => '優先次序/狀態',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => '主旨/描述',

//Service Duration
    'LBL_SERVICE_DURATION' => '服務持續時間',
    'LBL_SERVICE_DURATION_VALUE' => '服務持續時間值',
    'LBL_SERVICE_DURATION_UNIT' => '服務持續時間單位',
    'LBL_LOCK_DURATION' => '鎖定時長',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP 無法加載。請' .
        '確保您使用的是 ' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">受支援的瀏覽器</a>。 ' .
        '如果問題仍存在，請聯絡您的 Sugar 管理員。',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => '您的 Sugar 管理員尚未為 Amazon Connect 配置您的實例。',
    'ERROR_OMNICHANNEL_TIMEOUT' => '無法與 Amazon Connect 建立連接。請聯繫您的 Sugar 管理員獲得幫助。',
    'LBL_OMNICHANNEL_UNKNOWN' => '未知',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => '焦點抽屜',
    'LBL_CLOSE_FOCUS_DRAWER' => '關閉焦點抽屜',
    'LBL_EXTERNAL_GUESTS' => '外部客戶',
    'LBL_MY_FAVORITE_TASKS' => '我的收藏夾任務',
    'LBL_RECORD' => '記錄',

    'LBL_MY_TASKS' => '我的任務',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => '在模組：{1} 中找不到字段：{0}',
    'LBL_INTEGRATE_INVALID_PARAM' => '在模組： {2} 中找不到 {0}：{1} 的紀錄',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => '無法找到名為：{0} 的關係',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => '模組：{3} 中 Id 為 {0}，並具有 {1}：{2} 的數據庫條目已存在',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => '軟刪除（刪除標誌 = 1）',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => '在模組 {2} 上找到 {0} {1} 的多個數據庫紀錄。 ' .
        '請移除或更新相應的匹配紀錄。匹配紀錄：{3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => '下一次運行',
    'LBL_TIME_AWARE_TYPE' => '類型',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => '顯示標籤',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => '開啟紀錄預覽',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => '新增',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => '幫助不可用',
    'LBL_ACTIONBUTTON_FUNCTIONS' => '功能',
    'LBL_ACTIONBUTTON_FIELDS' => '欄位',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => '選取欄位...',
    'LBL_ACTIONBUTTON_ROLLUP' => '彙總',
    'LBL_ACTIONBUTTON_RELATED' => '相關',
    'LBL_ACTIONBUTTON_SAVE' => '儲存',
    'LBL_ACTIONBUTTON_CANCEL' => '取消',
    'LBL_ACTIONBUTTON_R_MODULE' => '相關模組',
    'LBL_ACTIONBUTTON_R_FIELDS' => '相關欄位',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => '彙總模組',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => '彙總欄位',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => '彙總功能',
    'LBL_ACTIONBUTTON_MINIMUM' => '最小',
    'LBL_ACTIONBUTTON_MAXIMUM' => '最大',
    'LBL_ACTIONBUTTON_AVERAGE' => '平均值',
    'LBL_ACTIONBUTTON_SUM' => '加總',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => '指派紀錄',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => '撰寫電子郵件',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => '建立紀錄',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => '文件合併',
    'LBL_ACTIONBUTTON_OPEN_URL' => '打開 Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => '執行報表',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => '更新記錄',
    'LBL_ACTIONBUTTON_ACTION' => '動作',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => '指派給',
    'LBL_ACTIONBUTTON_EMAIL_TO' => '電子郵件收件者',
    'LBL_ACTIONBUTTON_USE_PMSE' => '使用 PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => '範本',
    'LBL_ACTIONBUTTON_MODULE' => '模組',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => '顯示設置',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => '類型',
    'LBL_ACTIONBUTTON_DROPDOWN' => '下拉式清單',
    'LBL_ACTIONBUTTON_BUTTON' => '按鈕',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => '按鈕群組',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => '顯示記錄標籤',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => '在標題顯示',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => '編輯時隱藏',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => '在焦點儀表板標題上顯示',
    'LBL_ACTIONBUTTON_DASHBOARD' => '儀表板',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => '焦點儀表板標題',
    'LBL_ACTIONBUTTON_SIZE' => '大小',
    'LBL_ACTIONBUTTON_DEFAULT' => '預設',
    'LBL_ACTIONBUTTON_SMALL' => '小',
    'LBL_ACTIONBUTTON_LARGE' => '大',
    'LBL_ACTIONBUTTON_CALCULATED' => '計算',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => '轉換為 PDF',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => '文件合併',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => '預覽',
    'LBL_ACTIONBUTTON_PROPERTIES' => '屬性',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => '標籤',
    'LBL_ACTIONBUTTON_DESC' => '工具提示',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => '顯示標籤',
    'LBL_ACTIONBUTTON_SHOW_ICON' => '顯示 ICON',
    'LBL_ACTIONBUTTON_SCHEME' => '配色方案',
    'LBL_ACTIONBUTTON_ICON' => 'ICON',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => '相依',
    'LBL_ACTIONBUTTON_DESIGN' => '布局配置',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => '錯誤時停止',
    'LBL_ACTIONBUTTON_AUTOSAVE' => '自動儲存',
    'LBL_ACTIONBUTTON_CONFIG' => '配置',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => '請在保存前配置您的按鈕。',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => '配置按鈕',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => '自動建立',
    'LBL_ACTIONBUTTON_LINK' => '建立與父級的關係',
    'LBL_ACTIONBUTTON_COPY_PARENT' => '複製父值',
    'LBL_ACTIONBUTTON_PRESET' => '設定欄位值',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => '從父級複製欄位值',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => '選擇...',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => '從父字段 ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => '您確定要刪除此按鈕嗎？',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => '您確定要刪除此動作嗎？',
    'LBL_ACTIONBUTTON_INVALID_DATA' => '無效的操作按鈕數據',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => '請在儲存前選擇模組。',
    'LBL_ACTIONBUTTON_SELECT_LINK' => '請在保存前選擇一個鏈接。如果沒有可用鏈接，請取消選中鏈接選項。',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => '請在保存前選擇一條記錄。',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => '請在儲存前選擇模板。',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => '基本的',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => '次要',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => '高可視化',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => '海洋',
    'LBL_ACTIONBUTTON_THEME_PINK' => '粉色的',
    'LBL_ACTIONBUTTON_THEME_ARMY' => '軍隊',
    'LBL_ACTIONBUTTON_THEME_TEAL' => '青色',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => '太平洋',
    'LBL_ACTIONBUTTON_THEME_GREEN' => '綠色',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => '黃色',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => '橘色',
    'LBL_ACTIONBUTTON_THEME_RED' => '紅色',
    'LBL_ACTIONBUTTON_THEME_CORAL' => '珊瑚',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => '紫色',
    'LBL_ACTIONBUTTON_FORMULA' => '計算公式',
    'LBL_ACTIONBUTTON_ACTIONS' => '動作',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => '驗證按鈕數據時出錯。',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => '按鈕至少需要有一個標籤或圖標集。',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => '請輸入有效的按鈕標籤。',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => '由於缺少必需值，無法創建記錄。請聯繫您的管理員。',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => '此按鈕類型必須至少有兩個活動按鈕。',
    'LBL_ACTIONBUTTON_RECORD' => '記錄視圖',
    'LBL_ACTIONBUTTON_ACTION_MENU' => '操作選單',
    'LBL_ACTIONBUTTON_ORDER' => '排序',
    'LBL_ACTIONBUTTON_LIST_VIEW' => '清單檢視',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => '記錄視圖標題',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => '記錄視圖 Dashlet 標題',
    'LBL_ACTIONBUTTON_SUBPANELS' => '子面板',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => '任務序列執行引擎執行以下操作失敗： ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => '新增操作',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => '刪除此操作',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => '目前使用者',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => '文檔合併',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => '合併文檔至 PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => '公司規模',
    'LBL_HINT_COMPANY_INDUSTRY' => '行業',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => '行業標籤',
    'LBL_HINT_COMPANY_LOCATION' => '公司地址',
    'LBL_HINT_COMPANY_DESCRIPTION' => '公司描述',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => '成立年份',
    'LBL_HINT_COMPANY_FACEBOOK' => '公司脸书',
    'LBL_HINT_COMPANY_TWITTER' => '公司 Twitter',
    'LBL_HINT_COMPANY_PIC' => '公司標誌',
    'LBL_HINT_CONTACT_PIC' => '連絡人照片',
    'LBL_HINT_COMPANY_WEBSITE' => '公司網站',
    'LBL_HINT_PHOTO' => '照片連結',
    'LBL_HINT_JOB_2' => '上個工作',
    'LBL_HINT_EDUCATION' => '教育',
    'LBL_HINT_EDUCATION_2' => '額外教育',
    'LBL_HINT_TWITTER' => 'Twitter 連結',
    'LBL_HINT_FACEBOOK' => '脸书連結',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS 代碼',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC 代碼',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => '財政年度末',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => '年收入',
    'LBL_HINT_PHONE_1' => '電話 1',
    'LBL_HINT_PHONE_2' => '電話 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => '連接表',
    'LBL_HINT_FULL_NAME' => '全名',
    'LBL_HINT_JOB_TITLE' => '職位名稱',
    'LBL_HINT_OFFICE_PHONE' => '辦公室電話',
    'LBL_HINT_MOBILE_PHONE' => '行動電話',
    'LBL_HINT_OTHER_PHONE' => '其他電話',
    'LBL_HINT_WEBSITE' => '網站',
    'LBL_HINT_MSG_OVERWRITE_ALL' => '是否要用 Sugar Hint 中的新數據覆蓋此記錄的所有現有數據？',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => '是否要使用 Sugar Hint 中的新 {{fieldName}} 覆蓋此記錄的現有 {{fieldName}}?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => '將刪除所有與帳戶相關的數據，是否確實要繼續?',
    'LBL_HINT_COMPANY_LOGO' => '標誌',
    'LBL_HINT_CONTACTS_AVATAR' => '照片',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint 帳套表標記',

    'LBL_HINT_LOADING' => '載入中 ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => '正在卸載 Sugar Hint，請稍候',
    'LBL_HINT_VALUE_ERASED' => ' 值已刪除 ',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => '此資訊已通過資料隱私請求刪除',

    'LBL_HINT_UNINSTALL_TITLE' => '請從下面選擇一個卸載選項：',
    'LBL_HINT_UNINSTALL_PARTIAL' => '僅卸載 Hint 包',
    'LBL_HINT_UNINSTALL_FULL' => '完全卸載 Hint',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => '此選項將刪除提示 MLP，並禁用 Sugar Hint Insights 的所有活動訂閱。重新安裝 Hint 將自動重新激活訂閱。',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => '此選項將執行 Hint 完全卸載，包括刪除 MLP 和刪除所有配置和訂閱信息。',
    'LBL_HINT_UNINSTALL' => '解除安裝',
    'LBL_HINT_UNINSTALL_HEADER' => '卸載 Sugar Hint',
    'LBL_HINT_CANCEL' => '取消',
    'LBL_HINT_UNINSTALL_WARNING1' => '警告：只有在以後不打算再次使用 Hint 時，才選擇此選項。在執行卸載之前，請完成 Sugar 數據庫的完整備份，並將 Sugar 置於維護模式。 ',
    'LBL_HINT_UNINSTALL_WARNING2' => '查看 ',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint 管理指南 ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => '了解卸載過程的詳細信息。',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => '是否確定只卸載 Sugar Hint 包？',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => '是否確定要完全卸載 Sugar Hint？',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '(注意：無法撤消此操作)',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint 字段',
    'LBL_HINT_NO_RESULTS_MSG' => '未找到結果。',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => '基本 Hint 面板布局',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => '帳戶',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => '連絡人',
    'LBL_HINT_CONFIG_TAB_LEADS' => '潛在客戶',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => '展開的 Hint 面板布局',
    'LBL_HINT_CONFIG_DIR_PAR1' => '通過在上面的 Hint 面板佈局部分中拖放來重新排列字段。',
    'LBL_HINT_CONFIG_DIR_PAR2' => '有關詳細說明和默認字段列表，請參閱 ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' 以恢復默認設置 ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => '模組。',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => '是否確實要還原回 {{module}} 模塊的默認值？',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => '按一下此處',
    'LBL_HINT_CONFIG_NAME' => 'Hint 管理指南。',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => '欄位',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => '充實的字段',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => '本節列出了所有 Hint 字段和通過 Hint 充實後的所有 Sugar 字段。提示字段用星號（*）標記，並且只有在經過充實後才能顯示在 Hint 面板中。',
    'LBL_HINT_CONFIG_FIELD_NAME' => '字段名稱',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => '充實字段',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => '在 Hint 中顯示',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => '在 Hint 面板中顯示',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => '其他 Sugar 字段',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => '本節列出了所有未通過 Hint 充實的 Sugar 字段。',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => '警告',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => '警告：您即將與 Sugar Hint Insights 服務同步。任何待處理的電子郵件摘要故事都將丟失，現有新聞將從消息渠道中清除。所有類型的通知都將在同步完成後恢復。',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => '下面列出了與您的 {{_moduleSingular}} 相關的建議公司。選擇要顯示的公司數據。',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => '未選擇任何帳戶',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => '找到多封電子郵件，請選擇要導入的電子郵件： ',

    'LBL_HINT_HELP_MESSAGE1' => '根據輸入的數據，Hint 無法在系統中找到匹配項。',
    'LBL_HINT_HELP_MESSAGE2' => 'Hint 中的最佳結果可以通過一個人的姓名和電子郵件地址找到。',
    'LBL_HINT_HELP_MESSAGE3' => 'Hint 中的最佳結果可以通過公司網站 url 找到。',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "輸入 {{_moduleSingular}} 的公司名稱或網站，Hint 將搜索其他數據。",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "輸入您的 {{currentModule}} 的電子郵件地址，Hint 將搜索其他數據。",

    'LBL_HINT_HISTORY_NONE' => '無可用於歷史視圖的數據',
    'LBL_HINT_HISTORY_TITLE' => '活動歷史',

    'LBL_HINT_PREVIEW_TITLE' => '數據充實',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Hint 服務的許可證已過期。請聯繫 SugarCRM 管理員以續訂許可證。',
    'LBL_HINT_PREVIEW_QUESTION' => '想知道 Hint 能為您和您的公司做些什麼嗎？請聯繫您的 SugarCRM 管理員以添加 Hint。',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => '找不到帳戶信息',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => '找到充實的數據 - 點擊以將所有充實的數據保存到記錄中。',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => '點擊以將充實的數據保存到記錄中。',

    'LBL_HINT_CONTACTS_TITLE' => '相關聯繫人',
    'LBL_HINT_CONTACTS_NONE' => '無相關連絡人',

    'LBL_HINT_NEWS' => '新',
    'LBL_HINT_GENERAL' => '一般',
    'LBL_HINT_ALL_NEWS' => '所有新聞',
    'LBL_HINT_FILTER_NEWS' => '過濾新聞',
    'LBL_HINT_FINANCIAL_NEWS' => '財務',
    'LBL_HINT_PERSONNEL_NEWS' => '全體人員',
    'LBL_HINT_PRESS_RELEASES' => '新聞稿',
    'LBL_HINT_OTHER_NEWS' => '其他',
    'LBL_HINT_NEWS_PLACEHOLDER' => '搜索新聞文章',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => '無可用新聞',
    'LBL_NEW_NOTIFICATIONS' => '新通知',
    'LBL_HINT_DASHLET_ALLOWED1' => '您必須擁有 Sugar Hint 許可證才能查看 Sugar Hint Insights 渠道。詢問您的管理員關於獲取 Sugar Hint 許可證的信息。',

    'LBL_HINT_FOR' => '為',
    'LBL_HINT_WITH' => '和',
    'LBL_HINT_SHOW_ME' => '顯示更多： ',
    'LBL_HINT_NOTIFY_ME_BY' => '通知方法： ',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights 首選項中心',
    'LBL_NOTIFICATIONS_KEY_TITLE' => '首選項選項鍵',
    'LBL_HINT_PREFERENCES' => '首選項',
    'LBL_HINT_MINIMUM_PREFERENCES' => '已禁用刪除，至少需要一條偏好聲明',
    'LBL_HINT_MAXIMUM_PREFERENCES' => '添加已禁用，您已達到首選項聲明的最大值',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => '包含在 Sugar Hint Insights 渠道中',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => '彈出式桌面通知',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => '必須在所有瀏覽器和所有台式計算機上啟用通知才能始終接收通知。',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => '有些瀏覽器，如 Internet Explorer，不支持通知。使用不支持通知的瀏覽器時，無法啟用通知。',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => '為每個通知發送即時電子郵件警報',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => '發送每日電子郵件摘要',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => '發送每週電子郵件摘要',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => '無法保存首選項。請檢查系統連接，然後重試。',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => '某些必填字段缺少值。請檢查您的首選項，並確保填寫了所有必填字段。',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => '您將啟用瀏覽器通知以獲取 Sugar Hint Insights。點擊確認繼續。然後，瀏覽器將請求您允許接收通知事件。',
    'LBL_HINT_PUSH_ERROR' => '已在沒有依賴項的情況下為 {{options.type}} 註冊了推送通知插件。插件將無法正常工作，請確保提供工作文件的路徑以及在服務器上保存訂閱的方法。',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => '為所有用戶啟用 Hint 通知',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => '為所有用戶關閉 Hint 通知',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => '警告：卸載 Sugar Hint 期間無法禁用通知。要禁用通知，請安裝 Sugar Hint 5.4.0 或更高版本，然後使用 Sugar 的 “管理”部分中的 Sugar Hint 卸載程序執行完全卸載。',
    'LBL_HINT_ENRICH_ALL' => '擴充全部',
    'LBL_HINT_NO_LICENSE_ACCESS' => '需要 Hint 授權',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => '映射配置',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => '地理編碼器日誌查看器',
    'LBL_MAP_MAP' => '地圖',
    'LBL_MAP_MAPS' => '地圖',
    'LBL_MAP_GEOCODING_RECORD' => '地理編碼',
    'LBL_MAP_GEOCODE_SUCCESS' => '記錄已成功進行地理編碼。',
    'LBL_MAP_LATITUDE' => '緯度',
    'LBL_MAP_LONGITUDE' => '經度',
    'LBL_MAP_SEARCH_BY_ADDRESS' => '按地址搜尋...',
    'LBL_MAP_ALREADY_GEOCODED' => '當前記錄已進行地理編碼。是否確實要覆蓋此記錄的地理編碼？',
    'LBL_MAPS_MANUAL_GEOCODING' => '手工地理編碼',
    'LBL_MAP_POINT_COORDINATES' => '地圖點坐標',
    'LBL_MAP_CALCULATING_DIRECTIONS' => '計算最優路徑...',
    'LBL_MAP_DIRECTIONS' => '方向',
    'LBL_MAP_DIRECTIONS_FROM_USER' => '從當前用戶開始的方向',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => '從此記錄開始的方向',
    'LBL_MAPS_RADIUS_INPUT' => '半徑（0-250）',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => '在距離郵政編碼的半徑範圍內',
    'LBL_MAPS_DISTANCE' => '距離',
    'LBL_MAPS_CENTER_ZIP_CODE' => '郵遞區號',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => '無效配置： ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> 字段映射無效。',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => '映射類型',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => '縮放層級',
    'LBL_MAPS_DASHLET' => '地圖',
    'LBL_MAPS_DASHLET_DESCRIPTION' => '在地圖上顯示地理編碼記錄。',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => '映射不適用於此模塊。請在管理控制台中啟用它。',
    'LBL_MAP_MODULES' => '模組',
    'LBL_MAP_FILTER_BY' => '篩選按',
    'LBL_MAP_UNIT_TYPE' => '單位類型',
    'LBL_MAP_UNIT_TYPE_MILES' => '公尺',
    'LBL_MAP_UNIT_TYPE_KM' => '公里',
    'LBL_MAP_ADDRESS' => '地址',
    'LBL_MAP_NO_STARTING_POINT' => '起點未進行地理編碼。',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => '起點紀錄未進行地理編碼。',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => '一些選定的記錄未進行地理編碼，因此也不會顯示在地圖上。',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => '記錄未進行地理編碼。',
    'LBL_MAPS_MODULE_FIELDS' => '模組欄位',
    'LBL_MAPS_SELECT_FIELD' => '選取欄位',
    'LBL_MAPS_RELATE_RECORD' => '關聯紀錄',
    'LBL_MAPS_MAPPING_TYPE' => '映射類型',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => '無地理編碼記錄',
    'LBL_MAPS_ADDRESS' => '地址',
    'LBL_MAPS_ASSIGNED_USER_NAME' => '指派的使用者',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => '給定點的街道側視圖不可用',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> 記錄對映射無效。請從列表中刪除該模塊。',
    'LBL_MAPS_CLOSE_TOOLTIP' => '關閉',
    'LBL_MAPS_EXPAND_TOOLTIP' => '展開',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => '另存為 PDF',
    'LBL_MAPS_EMAIL_LINK' => '電子郵件連結',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => '您必須至少有一條地理編碼記錄。',
    'LBL_MAPS_GENERATING' => '正在生成地圖...',
    'LBL_MAPS_POINTS' => '映射點',
    'LBL_MAPS_POINT' => '點',
    'LBL_MAPS_TRAVEL_DETAILS' => '行進詳情',
    'LBL_MAPS_TOTAL_DISTANCE' => '總距離',
    'LBL_MAPS_TOTAL_DURATION' => '總持續時間',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => '交通順暢情況下總持續時間',
    'LBL_MAPS_ITINERARY' => '行程',
    'LBL_MAPS_TRAVEL_DISTANCE' => '行進距離',
    'LBL_MAPS_TRAVEL_DURATION' => '行進時間',
    'LBL_MAPS_TRAVEL_STEPS' => '步數',
    'LBL_MAPS_TRAVEL_WARNINGS' => '警告',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => '必應地圖在共享地圖上最多支持 10 個精確定位點。請檢查您的選擇。',
    'LBL_MAPS_NO_LICENSE_ACCESS' => '所需的地圖許可證',
    'LBL_MAPS_SHARE_HELLO' => '您好,',
    'LBL_MAPS_SHARE_HEADER' => '您由於以下幾點請求必應地圖：',
    'LBL_MAPS_SHARE_OPEN_URL' => '以下網址將在必應地圖上打開包含上述點的地圖：',
    'LBL_MAPS_SHARE_SHOW_MAP' => '在必應地圖上顯示地圖',
    'LBL_MAPS_MAP_ON_BING_WEB' => '必應地圖',
    'LBL_MAPS_NO_VALID_ITINERARY' => '找不到所提供路徑的路線。',
    'LBL_MAPS_GEOCODE_STATUS' => '地理編碼狀態',
    'LBL_MAPS_GEOCODED' => '地理編碼',
    'LBL_MAPS_NOT_GEOCODED' => '没有地理编码',
    'LBL_MAPS_NOT_FOUND' => '無效的地址',
    'LBL_MAPS_GEOCODING_FAILED' => '地理編碼失敗',
    'LBL_MAPS_QUEUED' => '排隊',
    'LBL_MAPS_REQUEUED' => '重新排隊',
    'LBL_MAPS_RELATED_RECORD' => '關聯紀錄',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => '查看報告',
    'LBL_REPORT_DASHLET_DESC' => '顯示已保存的報告',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => '重置為Dashlet默認值',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => '重置為報告默認值',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => '刷新結果',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => '將圖表複製到剪貼板',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => '下載圖表',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => '已編輯 Dashlet {{label}} 的報表，並且 Dashlet 已重設為預設設定。',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => '您沒有使用此欄位的權限。',

    'LBL_INVALID_FORMULA' => '無效的公式',
    'LBL_RETURN_TYPE_MISSMATCH' => '函數返回類型不匹配',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => '預測',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => '理想客戶特徵',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => '關閉週預測分數',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => '預測值',
    'LBL_AI_CONV_BIN_ACCURACY' => '預測倉精度',
    'LBL_AI_CONV_MULTIPLIER' => '預測乘數',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP值',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP Bin精度',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP倍增器',
    'LBL_AI_NEW' => '新',
    'LBL_AI_ENTERED' => '已輸入',
    'LBL_AI_CREATED' => '已建立',
    'LBL_AI_WEEK' => '週',
    'LBL_AI_MONTH' => '月',
    'LBL_AI_QUARTER' => '季度',
    'LBL_AI_BYWEEK' => '按週',
    'LBL_AI_BYMONTH' => '按月',
    'LBL_AI_BYQUARTER' => '按季度',
    'LBL_AI_WEEKTREND' => '每週趨勢',
    'LBL_AI_MONTHLYTREND' => '每月趨勢',
    'LBL_AI_QUARTERTREND' => '季度趨勢',
    'LBL_AI_TREND' => '趨勢依據',
    'LBL_AI_TRENDS' => '趨勢依據',
    'LBL_AI_VELOCITY' => '更迭速度',
    'LBL_AI_TOPX' => '前 {X}',
    'LBL_AI_TIMESPAN' => '階段之間的時間跨度 -',
    'LBL_AI_BUSINESSTREND' => '與業務趨勢',
    'LBL_AI_SUGARINSIGHTINTRO' => '隆重推出 Sugar Insights！',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights 利用定量分析來產生對 SugarCRM 資料的新見解。在 Sugar，我們一直在尋找新的方法來協助您充分利用資料，做出明智的決策，對於我們希望透過 Sugar Insights 提供的功能而言，這只是一個開始。',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights 利用定量分析來產生對 SugarCRM 資料的新見解。',
    'LBL_AI_FIRMO' => '企業概要',
    'LBL_AI_TOTALCOUNT' => '總計',
    'LBL_AI_DAYSFROMLATESTACT' => '自上次以來的天數',
    'LBL_AI_DAYSSINCE' => '存在時間',
    'LBL_AI_FIELDISSET' => '存在',
    'LBL_AI_CONTACTCOMPLETENESS' => '聯絡資訊的完整性',
    'LBL_AI_CUTDATE' => '預測期間',
    'LBL_AI_FROMLASTCHANGE' => '自上次功能值變更起的天數',
    'LBL_AI_CALLSHELD' => '保留的呼叫總數',
    'LBL_AI_CALLSPLANNED' => '計劃的呼叫總數',
    'LBL_AI_OUTBOUNDCALLS' => '呼出通話總數',
    'LBL_AI_INBOUNDCALLS' => '呼入通話總數',
    'LBL_AI_AVGCALLDURATION' => '平均通話時長',
    'LBL_AI_EMAILSARCHIVED' => '已封存電子郵件總數',
    'LBL_AI_EMAILSREAD' => '已讀電子郵件總數',
    'LBL_AI_EMAILSSENT' => '已傳送電子郵件總數',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => '「預期結束日期」變更為較晚日期的記錄總數',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => '「預期結束日期」變更為較早日期的記錄總數',
    'LBL_AI_AMOUNTINCREASED' => '金額增長的商機總數',
    'LBL_AI_AMOUNTDECREASED' => '金額減少的商機總數',

    // User last state
    'LBL_LAST_STATE' => '最後狀態',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => '發送到 DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => '取消編輯收件人',
    'LBL_RECIPIENT_ROLE' => '收件者角色',
    // Base sales stages
    'LBL_OPEN' => '打開',
    'LBL_CLOSED_WON' => '結束並贏得客戶',
    'LBL_CLOSED_LOST' => '結束但客戶流失',
    'LBL_KIOSK_ADD_FILES' => '新增檔案',
    'LBL_KIOSK_ADD_DROP_FILES' => '在此處添加或刪除文件',
    'LBL_KIOSK_CANCEL' => '取消',
    'LBL_KIOSK_EDIT' => '編輯',
    'LBL_KIOSK_EMAIL' => '電子郵件',
    'LBL_KIOSK_FILES_UPLOADING' => '正在上傳',
    'LBL_KIOSK_FILES_ERROR' => '附件上載失敗',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => '附件太大。',
    'LBL_KIOSK_FILTER_SEARCH' => '搜尋',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => 'Kiosk',
    'LBL_KIOSK_LANGUAGE' => '語言',
    'LBL_KIOSK_LAST_UPDATED' => '最近更新',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => '檢視',
    'LBL_KIOSK_MENU' => '菜單',
    'LBL_KIOSK_MOBILE_PHONE' => '行動電話',
    'LBL_KIOSK_MY_ACTIVITIES' => '我的活動',
    'LBL_KIOSK_MY_PROFILE' => '我的個人資料',
    'LBL_KIOSK_NAME' => '名稱',
    'LBL_KIOSK_OFFICE_PHONE' => '辦公室電話',
    'LBL_KIOSK_ORGANIZATION' => '組織',
    'LBL_KIOSK_PAGINATION_FOOTER' => '每頁行數',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => '由 SugarCRM 提供技術支援',
    'LBL_KIOSK_SAVE_CHANGES' => '儲存變更',
    'LBL_KIOSK_SHOW_HIDE' => '顯示/隱藏',
    'LBL_KIOSK_SIGN_IN' => '登入',
    'LBL_KIOSK_SIGN_OUT' => '登出',
    'LBL_KIOSK_SORT_BY' => '排序依據',
    'LBL_KIOSK_SUBMIT' => '提交',
    'LBL_KIOSK_TIMEZONE' => '時區',
    'LBL_KIOSK_ACTIVITY' => '活動',
    'LBL_KIOSK_NO_ACTIVITY' => '沒有要顯示的活動',
    'LBL_KIOSK_OLDEST_FIRST' => '最舊的優先',
    'LBL_KIOSK_NEWEST_FIRST' => '最新的優先',
    'LBL_KIOSK_SHOW_MORE' => '顯示更多',
    'LBL_KIOSK_ADD_A_REPLY' => '添加回复',
    'LBL_KIOSK_REPLY_EMPTY' => '回復不能留空。',
    'LBL_KIOSK_NUM_MORE' => '{{num}} 更多',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => '歡迎',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => '快速存取您的資源。',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => '搜索案例',
    'LBL_KIOSK_SHOW_ALL' => '顯示所有',
    'LBL_KIOSK_404_TITLE' => '我們找不到此項目',
    'LBL_KIOSK_TENANT_404_TITLE' => '未找到租戶',
    'LBL_KIOSK_404_MESSAGE' => '您點選的連結已移除、暫時不可用，或者您輸入了無效的 URL。',
    'LBL_KIOSK_TENANT_404_MESSAGE' => '請確保您輸入的 URL 正確。如需進一步協助，請聯絡支援人員。',
    'LBL_KIOSK_BACK_TO_HOME' => '返回首頁',
    'LBL_KIOSK_ERROR_CODE' => '{code} 錯誤： ',
    'LBL_KIOSK_401_TITLE' => '未授權',
    'LBL_KIOSK_401_MESSAGE' => '您沒有檢視此頁面的權限。',
    'LBL_KIOSK_403_TITLE' => '未授權',
    'LBL_KIOSK_403_MESSAGE' => '您沒有存取此頁面的權限。',
    'LBL_KIOSK_500_TITLE' => '伺服器無回應',
    'LBL_KIOSK_500_MESSAGE' => '我們這邊出現了一些問題。',
    'LBL_KIOSK_GO_BACK' => '返回',
    'LBL_KIOSK_DUPLICATE_ERROR' => '找到重複記錄',
    'LBL_KIOSK_ACCOUNT' => '帳戶',
    'LBL_KIOSK_STATUS' => '狀態',
    'LBL_KIOSK_DEACTIVATE' => '停用',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => '使用者已被停用',
    'LBL_KIOSK_MANAGE_USERS' => '管理使用者',
    'LBL_KIOSK_LAST_LOGIN' => '上次登入',
    'LBL_KIOSK_FIRST_NAME' => '名字',
    'LBL_KIOSK_LAST_NAME' => '姓氏',
    'LBL_KIOSK_ROLE' => '角色',
    'LBL_KIOSK_INVITE' => '邀請',
    'LBL_KIOSK_SEND_INVITES' => '傳送邀請',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => '邀請已成功傳送',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => '邀請未傳送',
    'LBL_KIOSK_REACTIVATE' => '重新啟用',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => '使用者已重新啟用',
    'LBL_KIOSK_RESET_PASSWORD' => '重設密碼',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => '重設密碼電子郵件已傳送',
    'LBL_KIOSK_USER_PROFILE' => '使用者設定檔',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => '您的使用者已被停用。請聯絡管理員。',
    'LBL_KIOSK_BACK_TO_LOGIN' => '返回登入',
    'LBL_KIOSK_REVOKE_INVITATION' => '撤銷邀請',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => '邀請已成功撤銷',
    'LBL_KIOSK_SEARCH_AND_SELECT' => '搜尋並選取...',
    'LBL_KIOSK_NO_MATCHES' => '未找到匹配項',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => '設定檔已更新。',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => '更新設定檔時出錯。',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => '回覆： {caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => '文件',
    'LBL_KIOSK_DOCUMENTS_DESC' => '檢視、搜尋和下載傳入的共用文件。',
    'LBL_KIOSK_CASES' => '案例',
    'LBL_KIOSK_CASES_DESC' => '檢視、搜尋和回覆與您分享的案例。',
    'LBL_KIOSK_DOWNLOAD' => '下載',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => '檔案已成功下載',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => '開始',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => '為了更好地協助您，請向我們提供您的姓名。',
    'LBL_KIOSK_SAVE' => '儲存',
    'LBL_KIOSK_SHARED' => '已分享',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => '歡迎，{firstName} {lastInitial}。',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => '背景顏色',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => '背景影像 URL',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => '建議選擇檔案大小小於 400K 的影像。',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => '背景類型',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => '首頁背景',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => '主題',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => '主要主題顏色',
    'LBL_KIOSK_CONFIG_APP_NAME' => '應用程式名稱',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => '這是應用程式的標題，顯示在標誌旁邊。',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => '應用程式標誌 URL',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => '建議選擇最容易在小尺寸（例如，社交媒體設定檔）下檢視的標誌。還建議檔案大小小於 200K。',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => '應用程式最愛圖示 URL',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => '最愛圖示是顯示在瀏覽器索引標簽內頁面標題旁邊的小標誌。',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => '自動重新指派開啟的活動',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => '已達到使用者限制',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => '無效的授權金鑰',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => '無效的應用程式',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => '無效的應用程式',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => '損壞的驗證金鑰',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => '授權已過期',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => '遺漏資訊',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => '遺漏驗證金鑰',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => '使用者缺少存取權限',
    'LBL_DRI_WORKFLOW' => '智慧指南',
    'LBL_DRI_WORKFLOWS' => '智慧指南',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => '智慧指南階段範本',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => '智慧指南階段範本',
    'LBL_DRI_WORKFLOW_TEMPLATE' => '智慧指南範本',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => '智慧指南活動範本',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => '活動範本',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => '網路掛鉤',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate 網路掛鉤',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => '目前智慧指南活動位置',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate 網路掛鉤',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate 網路掛鉤',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar 操作',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar 操作',
    'LBL_CJ_FORM' => 'Smart Guide Sugar 操作',
    'LBL_DRI_SUBWORKFLOW' => '智慧指南階段',
    'LBL_DRI_SUBWORKFLOWS' => '智慧指南階段',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => '智慧指南活動範本',
    'LBL_DRI_WORKFLOW_TEMPLATES' => '智慧指南範本',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => '智慧指南順序',
    'LBL_CJ_ACTUAL_SORT_ORDER' => '智慧指南實際順序',
    'LBL_CUSTOMER_JOURNEY_SCORE' => '智慧指南分數',
    'LBL_CJ_MOMENTUM_POINTS' => '智慧指南動量點',
    'LBL_CJ_MOMENTUM_SCORE' => '智慧指南動量分數',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => '智慧指南允許活動依據',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => '智慧指南進度',
    'LBL_CJ_MOMENTUM_RATIO' => '智慧指南動量比',
    'LBL_CUSTOMER_JOURNEY_POINTS' => '智慧指南點',
    'LBL_CUSTOMER_JOURNEY_TYPE' => '智慧指南工作',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => '智慧指南父項活動類型',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => '智慧指南封鎖依據',
    'LBL_CJ_BLOCKED_BY_STAGES' => '智慧指南按階段封鎖',
    'LBL_CJ_PARENT_ACTIVITY_ID' => '智慧指南父項活動 ID',
    'LBL_START_NEXT_JOURNEY_ID' => '啟動下一個智慧指南 ID',
    'LBL_CJ_URL' => '智慧指南 Url',
    'LBL_IS_CJ_PARENT_ACTIVITY' => '為智慧指南父項活動',
    'LBL_CJ_MOMENTUM_START_DATE' => '智慧指南動量開始日期',
    'LBL_CJ_MOMENTUM_END_DATE' => '智慧指南動量結束日期',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => '小工具版面配置設定',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => '小工具版面配置設定',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => '同一範本中智慧指南的最大數量',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => '使用中',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => '已封存',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => '顯示',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => '隱藏',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => '垂直模式',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => '水平模式',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => '無效的授權',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} 已將以下智慧指南活動指派給 {{assigned_user}}。</p>
    <ul>{{activities}}</ul>
    
    <p>您可以在以下網址檢閱這些活動：<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => '無效的授權',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => '已達到使用者限制，您有 {{gracePeriodDays}} 天的時間升級授權。',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - 指派的智慧指南活動',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => '您已超出 Sugar Automate 使用者限制 {0}<br>
    <br>
    請聯絡 <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> 以提高使用者限制或減少使用該外掛程式的使用者數量。',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => '已達到 Sugar Automate 使用者限制',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => '您的 Sugar Automate 授權將在 {0} 天后到期。 <br>
    <br>
    請聯絡 SugarCRM 或您的 Sugar 合作夥伴進行續訂，防止服務中斷。',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate 授權即將到期',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => '測試網路掛鉤',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide 進度',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => '顯示 Sugar Automate「Smart Guide 進度」圓形圖。',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => '顯示網路掛鉤回應',
    'LBL_DASHLET_SEND_LABEL' => '傳送請求',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => '指派我',
    'LBL_COMPLETE_BUTTON_TITLE' => '完成',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => '完成所有工作',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => '刪除階段',
    'LBL_START_CYCLE_BUTTON_TITLE' => '開始',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => '不適用',
    'LBL_ADD_STAGE_BUTTON_TITLE' => '新增階段',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => '檢視',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => '編輯 Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => '取消',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => '封存',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => '取消封存',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => '設定範本',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => '新增工作',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => '排程會議',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => '排程通話',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => '在未來',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => '逾期',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => '今天',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => '明天',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => '確定要取消此智慧指南嗎？',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => '您即將完成所有工作。確定要繼續嗎？',
    'LBL_CJ_BLOCK_BY' => '您有一個未解決的相關工作：{{Name}}。請在完成所有工作之前完成此工作。',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => '您有多個未解決的相關工作。請在完成所有工作之前完成這些工作。',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => '您已成功完成所有工作',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => '確定要封存此智慧指南嗎？',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => '確定要取消封存此智慧指南嗎？',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate：智慧指南（Focus Drawer 和控制台）',
    'LBL_CJ_AS_A_DASHLET_DESC' => '在服務/續訂控制台和 Focus Drawer 儀表板上檢視使用中的智慧指南。',
    'LBL_CJ_PROCESSING_REQUEST' => '正在處理..',
    'LBL_CJ_SUCCESS' => '您已成功完成所有工作',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '未啟用 {module} 模組',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => '儲存所有顯示設定。',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => '智慧指南動量',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => '顯示 Sugar Automate「智慧指南動量」度量圖表。',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide 進度',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => '顯示 Sugar Automate「Smart Guide 進度」圓形圖。',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => '找不到父項',
    'CJ_NOT_FOUND_EXCEPTION' => '找不到帶 {data} 的 {moduleName}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => '智慧指南必須在封存前完成或取消',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => '在當前 Sugar 授權中未啟用 Sugar Automate',
    'LBL_ACTION_NOT_FOUND' => '找不到動作，請聯絡系統管理員',
    'LBL_CJ_SELECT_FIELD' => '選取欄位',
    'LBL_CJ_SELECT_OPERATOR' => '選擇運算子',
    'LBL_CJ_SELECT_VALUE' => '選擇值',
    'LBL_CJ_ENTER_VALUE' => '輸入值',
    'LBL_CJ_FORM_BATCH_TITLE' => '正在儲存記錄',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => '偵測到作用中的智慧指南...',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => '正在處理作用中的 sugar 動作...',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => '正在更新作用中的智慧指南...',
    'LBL_CJ_FORM_BATCH_SUCCESS' => '記錄和關聯的 Smart Guide 已成功更新。',
    'LBL_CJ_FORM_BATCH_FAILURE' => '關聯的智慧指南更新失敗。如果錯誤仍然存在，請聯繫 Sugar 管理員以尋求幫助。',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => '關聯的智慧指南更新失敗。請檢閱 <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">記錄</a>以解決錯誤。',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} 已成功連結。',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => '連結 <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} 時出現問題。如果問題持續，請聯絡 Sugar 支援。',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} 已成功連結。',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => '連結 {{modulePluralLower}} 時出現問題。如果問題持續，請聯絡 Sugar 支援。',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => '連結 {{moduleSingularLower}} 時出現問題。如果問題持續，請聯絡 Sugar 支援。',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => '{{stage}} 階段中已存在名為 <a href="#{{module}}/{{id}}">{{name}}</a> 的 {{moduleSingularLower}}。',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => '已選擇名為 <a href="#{{module}}/{{id}}">{{name}}</a> 的 {{moduleSingularLower}}。',
    'LBL_CJ_ARCHIVED' => '已封存',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => '選取 Smart Guide 範本...',
    'LBL_ALL_SMART_GUIDES' => '所有 Smart Guide',
    'LBL_ACTIVE_SMART_GUIDES' => '作用中的 Smart Guide',
    'LBL_ARCHIVED_SMART_GUIDES' => '已封存的 Smart Guide',
    'LBL_VERTICAL_SCROLL_VIEW' => '豎向堆疊檢視',
    'LBL_HORIZONTAL_SCROLL_VIEW' => '橫向堆疊檢視',
    'LBL_DRI_WORKFLOWS_FILTER' => '篩選器',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => '此動作無法完成。此活動模組的「狀態」欄位設定為「唯讀」，這阻止了可更新「狀態」欄位的所有 Smart Guide 動作。',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => '此動作無法完成。此活動和/或子活動模組的「狀態」欄位設定為「唯讀」，這阻止了可更新「狀態」欄位的所有 Smart Guide 動作。',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => '指南中部分活動模組的「狀態」欄位設定為「唯讀」，這些活動將在指南取消時保持不更改。',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => '已複製到剪貼簿。',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => '刪除所有週期',
    'ERROR_RECURRENCE_EVENT_PARAMS' => '無效的週期設定',
    'ERROR_INTERVAL_INVALID' => '重複間隔時間必須介於 1 和 99 之間',
    'LBL_RECURRENCE_ADD' => '設定',
    'LBL_REPEAT_DAYS' => '每月天數',
    'LBL_REPEAT_END_TYPES' => '重複',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => '導覽提供者',
    'LBL_MOBILE_PDF_EMAIL' => '電子郵件 {{{pdfTemplateName}}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => '正在傳送',
    'LBL_MOBILE_EMAIL_SENT' => '已傳送',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => '電子郵件已儲存為草稿。',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => '新增附件',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => '從本地上傳',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar 文件',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => '您對此記錄進行的編輯變更了此視圖。',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'SugarCRM Mobile 應用程式版本資訊',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM Mobile 應用程式使用指南',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile 無法在取得根權限的行動裝置上使用。請在未取得根權限的裝置上開啟該應用程式。',
    'LBL_VO_BUILD_ROUTE' => '建置路徑',
    'LBL_FILTER_MY_DISTANCE_FILTER' => '我的距離篩選器',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => '該文件將在背景產生。開啟「文件合併」頁面以存取該檔案。',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => '無法獲取範本。請聯絡管理員以獲取協助。',
    'LBL_MAP_ERROR_LOAD' => '無法載入地圖',
    'LBL_MAP_DISTANCE' => '距離',
    'LBL_SELECT_UNIT_TYPE' => '單位類型',
    'LBL_MAPS_UNIT_MILES' => '英哩',
    'LBL_MAPS_UNIT_KILOMETERS' => '公里',
    'LBL_RADIUS' => '半徑',
    'LBL_ZIP_CODE' => '郵遞區號',
    'LBL_MOBILE_CHOOSE_ADDRESS' => '選擇地址',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => '無法根據地址建立地理編碼：{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => '記錄未進行地理編碼。',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => '記錄不包含任何地址資料。是否要在地圖上手動定位此記錄？',
    'LBL_ERR_SHOW_ON_MAP' => '無法開啟所選記錄的地圖。',
    'LBL_ERR_MISSING_ON_MAP' => '某些記錄缺少地址資料，沒有顯示出來',
    'LBL_MAPS_ROUTE' => '路徑',
    'LBL_MAPS_PROVIDER' => 'Sugar 地圖',
    'LBL_MAPS_CURRENT_LOC_ERROR' => '無法確定當前位置。',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => '最多支援 {{{num}}} 條記錄用於對應。',
    'LBL_ALL_MODULES' => '所有模組',
    'LBL_DRIVE_SHARE_LINK' => '共用連結',
    'LBL_DRIVE_LOAD_FILES_ERROR' => '無法載入檔案。',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => '名稱不能為空',
    'LBL_DRIVE_FOLDER_CREATED' => '資料夾已建立。',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => '無法建立資料夾。',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => '無法上傳檔案。',
    'LBL_DRIVE_NO_ROOT_FOLDER' => '請先建立根資料夾',
    'LBL_EDIT_ALL_RECURRENCES' => '編輯所有週期',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => '無法在 Dropbox 中開啟檔案',
    'LBL_FILE_NOT_AVAILABLE' => '無法開啟檔案',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => '方向',
    'LBL_MAPS_ROUTE_NOT_FOUND' => '找不到所提供路徑的路線',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => '附近',
    'LBL_TAGS' => '標籤',

    'LBL_CALLER_ID_SETTINGS' => '來電顯示設定',
    'LBL_CALLER_ID_ENABLED' => '來電顯示已啟用',
    'LBL_CALLER_ID_ENABLED_TEXT' => '在呼入通話中，將顯示與電話號碼匹配的聯絡人或潛在客戶的姓名。',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => '要允許行動應用程式顯示來電方名字，請在裝置上執行以下步驟：<br><br>1. 開啟 iOS 設定 > 電話 > 呼叫封鎖和識別。<br>2. 啟用「{{{brandName}}}」。',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => '要允許行動應用程式顯示來電方名字，請在裝置上執行以下步驟：<br>1. 開啟 iOS 設定 > 電話 > 呼叫封鎖和識別。<br>2. 移至「權限」。<br>3. 啟用「電話」權限。<br><br> 要將此應用程式設定為預設來電顯示處理程式，請移至裝置設定。<br>1.導覽至應用程式。<br>2. 選擇預設應用程式。<br>3. 選擇來電顯示和垃圾訊息應用程式。<br>4. 選擇此應用程式作為預設選項。',
    'LBL_CALLER_ID_SYNC_HINT' => '檢查 Sugar 執行個體中記錄（例如聯絡人、潛在客戶）中聯絡人資訊的變更。',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => '移至設定',
    'LBL_CALLER_ID_SYNC' => '同步記錄資料',
    'LBL_CALLER_ID_NOT_ENABLED' => '同步之前，必須在系統設定中啟用來電顯示。',
    'LBL_CALLER_ID_SETUP_ENABLE' => '啟用',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => '稍後在設定中',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => '此應用程式支援來電顯示功能。<br> 為了讓此功能正常運作，按下啟用按鈕后，系統將提示您授予兩個權限。<br> 要確保來電顯示功能正常工作，您需要授予管理通話的權限，並選擇此應用程式作為預設來電顯示處理程式。<br> 如果不授予管理通話的權限，則也無法記錄從應用程式發出的呼叫。',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => '要允許 SugarCRM 行動應用程式顯示來電方名字，請在裝置上執行以下步驟：<br><br>1. 開啟 iOS 設定 > 電話 > 呼叫封鎖和識別。<br>2. 啟用應用程式。',
    'LBL_MOBILE_LAST_SYNC' => '上次同步',
    'LBL_CALLER_ID_SYNCING' => '正在與伺服器同步。',
    'LBL_NEVER' => '從不',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} 不能為空白。',
    'LBL_ADD_RELATED_RECORD' => '相關 {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => '您沒有使用來電顯示所需的權限。請聯絡您的管理員。',
    'LBL_CALLER_ID_FETCHING' => '正在同步…',
    'LBL_CALLER_ID_FETCH_ALL' => '重新同步所有記錄',
    'LBL_CALLER_ID_FETCH_NEW' => '檢查記錄更新',

    'LBL_SORT_BY' => '排序方式',
    'LBL_PRIMARY_SORT' => '主要排序',
    'LBL_SECONDARY_SORT' => '次要排序',
    'LBL_OF' => '的',
    'LBL_TABLE_FREEZE_FIRST' => '凍結第一欄',
    'LBL_TABLE_SETTINGS_TITLE' => '欄檢視選項',
    'LBL_TABLE_SETTINGS_NO_COL' => '必須至少選擇一欄。',
    'LBL_TABLE_TOGGLER_INFO' => '顯示或隱藏欄，並將其拖曳成您偏好的順序。',
    'LBL_RUNTIME_FILTERS_TITLE' => '執行階段篩選器',
    'LBL_FILTER_CONDITION' => '選取條件',
    'LBL_FILTER_VALUES' => '值',
    'LBL_TABLE_EXPAND' => '全部展開',
    'LBL_TABLE_COLLAPSE' => '全部摺疊',
    'LBL_RUNTIME_FILTERS_DEFAULT' => '伺服器錯誤。無法載入相關的執行階段篩選器。',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => '發佈/訂閱模組活動推送訂閱',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => '發佈/訂閱模組活動推送訂閱',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => '面板 - 頂部',
    'panel_bottom' => '面板 - 底部',
    'tab_first' => '索引標籤 - 第一個',
    'tab_last' => '索引標籤 - 最後一個',
];

$app_list_strings['activity_user_options'] = [
    '7' => '過去 7 天',
    '30' => '過去 30 天',
    '90' => '上個季度',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => '今天',
    'future' => '未來',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => '是',
    'group' => '否',
];

$app_list_strings['history_filter_options'] = [
    7 => '過去 7 天',
    30 => '過去 30 天',
    90 => '上個季度',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => '是',
    'group' => '否',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => '是',
    'group' => '否',
];

$app_list_strings['list_visibility_options'] = [
    '1' => '是',
    '0' => '否',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => '本季度',
    'next' => '下個季度',
    'year' => '今年',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => '我的記錄',
    'group' => '群組記錄',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => '我的案源',
    'group' => '我的小組的案源',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => '我的預測',
    'group' => '我的小組的預測',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => '商機',
    'RevenueLineItems' => '商機和營收項目',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => '最晚結束日期',
    'earliest' => '最早結束日期',
];

$app_list_strings['moduleList']['Library'] = '庫';
$app_list_strings['moduleListSingular']['Library'] = '庫';
$app_list_strings['library_type'] = ['Books' => '書籍', 'Music' => '音樂', 'DVD' => 'DVD', 'Magazines' => '雜誌'];
$app_list_strings['moduleList']['EmailAddresses'] = '電子郵件地址';
$app_list_strings['moduleListSingular']['EmailAddresses'] = '電子郵件地址';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => '草稿',
    'in-review' => '審查中',
    'approved' => '已核准',
    'published' => '已發佈',
    'expired' => '已過期',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--管理員動作--',
        'Create New Tag' => '建立新標籤',
        'Delete Tag' => '刪除標籤',
        'Rename Tag' => '重命名標籤',
        'Move Selected Articles' => '移動選取的文章',
        'Apply Tags On Articles' => '將標籤應用至文章',
        'Delete Selected Articles' => '刪除選取的文章',
    ];

$app_list_strings['moduleList']['Words'] = '字組';
$app_list_strings['moduleListSingular']['Words'] = '字組';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = '建立文章';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => 'ABU DHABI',
    'ADEN' => '亞丁',
    'AFGHANISTAN' => '阿富汗',
    'ALBANIA' => '阿爾巴尼亞',
    'ALGERIA' => '阿爾及利亞',
    'AMERICAN SAMOA' => '美屬薩摩亞',
    'ANDORRA' => 'ANDORRA',
    'ANGOLA' => '安哥拉',
    'ANTARCTICA' => '南極洲',
    'ANTIGUA' => '安提瓜',
    'ARGENTINA' => '阿根廷',
    'ARMENIA' => 'ARMENIA',
    'ARUBA' => 'ARUBA',
    'AUSTRALIA' => '澳洲',
    'AUSTRIA' => '奧地利',
    'AZERBAIJAN' => '亞塞拜然',
    'BAHAMAS' => 'BAHAMAS',
    'BAHRAIN' => '巴林',
    'BANGLADESH' => '孟加拉國',
    'BARBADOS' => '巴巴多斯',
    'BELARUS' => '白俄羅斯',
    'BELGIUM' => '比利時',
    'BELIZE' => '貝里斯',
    'BENIN' => '貝寧',
    'BERMUDA' => '百慕達',
    'BHUTAN' => '不丹',
    'BOLIVIA' => '玻利維亞',
    'BOSNIA' => '波士尼亞',
    'BOTSWANA' => '博茨瓦納',
    'BOUVET ISLAND' => '布維島',
    'BRAZIL' => '巴西',
    'BRITISH ANTARCTICA TERRITORY' => '英屬南極領地',
    'BRITISH INDIAN OCEAN TERRITORY' => '英屬印度洋領土',
    'BRITISH VIRGIN ISLANDS' => '英屬維爾京群島',
    'BRITISH WEST INDIES' => '英屬西印度群島',
    'BRUNEI' => '汶萊',
    'BULGARIA' => '保加利亞',
    'BURKINA FASO' => '布吉納法索',
    'BURUNDI' => '蒲隆地',
    'CAMBODIA' => '柬埔寨',
    'CAMEROON' => '喀麥隆',
    'CANADA' => '加拿大',
    'CANAL ZONE' => '運河區',
    'CANARY ISLAND' => '加那利島',
    'CAPE VERDI ISLANDS' => '海角威爾第群島',
    'CAYMAN ISLANDS' => '開曼群島',
    'CEVLON' => '錫蘭',
    'CHAD' => '乍得',
    'CHANNEL ISLAND UK' => '英國海峽群島',
    'CHILE' => '智利',
    'CHINA' => '中國',
    'CHRISTMAS ISLAND' => '聖誕島',
    'COCOS (KEELING) ISLAND' => '科科斯 (基林) 島',
    'COLOMBIA' => '哥倫比亞',
    'COMORO ISLANDS' => '科摩羅群島',
    'CONGO' => '剛果',
    'CONGO KINSHASA' => '剛果金夏沙',
    'COOK ISLANDS' => '科克群島',
    'COSTA RICA' => '哥斯大黎加',
    'CROATIA' => '克羅地亞',
    'CUBA' => '古巴',
    'CURACAO' => 'CURACAO',
    'CYPRUS' => '賽普勒斯',
    'CZECH REPUBLIC' => '捷克共和國',
    'DAHOMEY' => '達荷美',
    'DENMARK' => '丹麥',
    'DJIBOUTI' => '吉布地',
    'DOMINICA' => '多米尼克',
    'DOMINICAN REPUBLIC' => '多明尼加共和國',
    'DUBAI' => 'DUBAI',
    'ECUADOR' => 'ECUADOR',
    'EGYPT' => '埃及',
    'EL SALVADOR' => '薩爾瓦多',
    'EQUATORIAL GUINEA' => '赤道幾內亞',
    'ESTONIA' => '愛沙尼亞',
    'ETHIOPIA' => '埃塞俄比亞',
    'FAEROE ISLANDS' => 'FAEROE ISLANDS',
    'FALKLAND ISLANDS' => '福克蘭群島',
    'FIJI' => 'FIJI',
    'FINLAND' => 'FINLAND',
    'FRANCE' => '法國',
    'FRENCH GUIANA' => 'FRENCH GUIANA',
    'FRENCH POLYNESIA' => 'FRENCH POLYNESIA',
    'GABON' => '加蓬',
    'GAMBIA' => 'GAMBIA',
    'GEORGIA' => '喬治亞州',
    'GERMANY' => '德國',
    'GHANA' => '加納',
    'GIBRALTAR' => '直布羅陀',
    'GREECE' => '希臘',
    'GREENLAND' => '格陵蘭',
    'GUADELOUPE' => '哥德洛普島',
    'GUAM' => '關島',
    'GUATEMALA' => '瓜地馬拉',
    'GUINEA' => '幾內亞',
    'GUYANA' => '蓋亞納',
    'HAITI' => '海地',
    'HONDURAS' => '宏都拉斯',
    'HONG KONG' => '香港',
    'HUNGARY' => '匈牙利',
    'ICELAND' => '冰島',
    'IFNI' => 'IFNI',
    'INDIA' => '印度',
    'INDONESIA' => '印尼',
    'IRAN' => '伊朗',
    'IRAQ' => '伊拉克',
    'IRELAND' => '愛爾蘭',
    'ISRAEL' => '以色列',
    'ITALY' => '義大利',
    'IVORY COAST' => '象牙海岸',
    'JAMAICA' => '牙買加',
    'JAPAN' => '日本',
    'JORDAN' => '約旦',
    'KAZAKHSTAN' => '哈薩克斯坦',
    'KENYA' => '肯亞',
    'KOREA' => 'KOREA',
    'KOREA, SOUTH' => 'KOREA, SOUTH',
    'KUWAIT' => '科威特',
    'KYRGYZSTAN' => '吉爾吉斯斯坦',
    'LAOS' => '老撾',
    'LATVIA' => '拉托維亞',
    'LEBANON' => '黎巴嫩',
    'LEEWARD ISLANDS' => '背風島',
    'LESOTHO' => '賴索托',
    'LIBYA' => '利比亞',
    'LIECHTENSTEIN' => '列支敦斯登',
    'LITHUANIA' => '立陶宛',
    'LUXEMBOURG' => '盧森堡',
    'MACAO' => '澳門',
    'MACEDONIA' => '馬其頓',
    'MADAGASCAR' => '馬達加斯加',
    'MALAWI' => '馬拉威',
    'MALAYSIA' => '馬來西亞',
    'MALDIVES' => '馬爾地夫',
    'MALI' => 'MALI',
    'MALTA' => '馬爾他',
    'MARTINIQUE' => '馬丁尼克島',
    'MAURITANIA' => '茅利塔尼亞',
    'MAURITIUS' => '模里西斯',
    'MELANESIA' => '美拉尼西亞',
    'MEXICO' => '墨西哥',
    'MOLDOVIA' => '摩爾多瓦',
    'MONACO' => 'MONACO',
    'MONGOLIA' => '蒙古',
    'MOROCCO' => '摩洛哥',
    'MOZAMBIQUE' => '莫三比克',
    'MYANAMAR' => 'MYANAMAR',
    'NAMIBIA' => '納米比亞',
    'NEPAL' => '尼泊爾',
    'NETHERLANDS' => '荷蘭',
    'NETHERLANDS ANTILLES' => '荷屬安地列斯群島',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => '荷蘭荷屬安的列斯中立區',
    'NEW CALADONIA' => '新加多利亞',
    'NEW HEBRIDES' => '新赫布里底',
    'NEW ZEALAND' => '紐西蘭',
    'NICARAGUA' => 'NICARAGUA',
    'NIGER' => '尼日爾',
    'NIGERIA' => '奈及利亞',
    'NORFOLK ISLAND' => '諾福克島',
    'NORWAY' => '挪威',
    'OMAN' => '阿曼',
    'OTHER' => '其他',
    'PACIFIC ISLAND' => '太平洋島嶼',
    'PAKISTAN' => '巴基斯坦',
    'PANAMA' => '巴拿馬',
    'PAPUA NEW GUINEA' => '巴布亞紐幾內亞',
    'PARAGUAY' => '巴拉圭',
    'PERU' => '秘魯',
    'PHILIPPINES' => '菲律賓',
    'POLAND' => '波蘭',
    'PORTUGAL' => '葡萄牙',
    'PORTUGUESE TIMOR' => '葡屬帝汶',
    'PUERTO RICO' => '波多黎各',
    'QATAR' => '卡塔爾',
    'REPUBLIC OF BELARUS' => '白俄羅斯共和國',
    'REPUBLIC OF SOUTH AFRICA' => '南非共和國',
    'REUNION' => '留尼旺島',
    'ROMANIA' => '羅馬尼亞',
    'RUSSIA' => '俄羅斯',
    'RWANDA' => '盧安達',
    'RYUKYU ISLANDS' => '琉球群島',
    'SABAH' => '薩巴赫',
    'SAN MARINO' => '聖馬利諾',
    'SAUDI ARABIA' => '沙烏地阿拉伯',
    'SENEGAL' => '塞內加爾',
    'SERBIA' => '塞爾維亞',
    'SEYCHELLES' => '塞席爾',
    'SIERRA LEONE' => '塞拉里昂',
    'SINGAPORE' => '新加坡',
    'SLOVAKIA' => '斯洛伐克',
    'SLOVENIA' => '斯洛維尼亞',
    'SOMALILIAND' => 'SOMALILIAND',
    'SOUTH AFRICA' => '南非',
    'SOUTH YEMEN' => '南葉門',
    'SPAIN' => '西班牙',
    'SPANISH SAHARA' => '西班牙撒哈拉',
    'SRI LANKA' => '斯里蘭卡',
    'ST. KITTS AND NEVIS' => 'ST. KITTS AND NEVIS',
    'ST. LUCIA' => 'ST. LUCIA',
    'SUDAN' => '蘇丹',
    'SURINAM' => 'SURINAM',
    'SW AFRICA' => '非洲西南部',
    'SWAZILAND' => '史瓦濟蘭',
    'SWEDEN' => '瑞典',
    'SWITZERLAND' => '瑞士',
    'SYRIA' => '敘利亞',
    'TAIWAN' => '臺灣',
    'TAJIKISTAN' => '塔吉克斯坦',
    'TANZANIA' => '坦尚尼亞',
    'THAILAND' => '泰國',
    'TONGA' => '湯加',
    'TRINIDAD' => '特立尼達',
    'TUNISIA' => 'TUNISIA',
    'TURKEY' => '土耳其',
    'UGANDA' => '烏干達',
    'UKRAINE' => '烏克蘭',
    'UNITED ARAB EMIRATES' => '阿拉伯聯合大公國',
    'UNITED KINGDOM' => '英國',
    'UPPER VOLTA' => '上沃爾特',
    'URUGUAY' => '烏拉圭',
    'US PACIFIC ISLAND' => '美屬太平洋島嶼',
    'US VIRGIN ISLANDS' => '美屬維爾京群島',
    'USA' => '美國',
    'UZBEKISTAN' => '烏茲別克斯坦',
    'VANUATU' => '瓦努阿圖',
    'VATICAN CITY' => '梵蒂岡城',
    'VENEZUELA' => '委內瑞拉',
    'VIETNAM' => '越南',
    'WAKE ISLAND' => '威克島',
    'WEST INDIES' => '西印度群島',
    'WESTERN SAHARA' => '西撒哈拉',
    'YEMEN' => '葉門',
    'ZAIRE' => 'ZAIRE',
    'ZAMBIA' => '尚比亞',
    'ZIMBABWE' => '辛巴威',
];

$app_list_strings['state_dom'] = [
    'AL' => '阿拉巴馬州',
    'AK' => '阿拉斯加',
    'AZ' => '亞利桑那州',
    'AR' => '阿肯色州',
    'CA' => '加州',
    'CO' => '科羅拉多州',
    'CT' => '康涅狄格州',
    'DE' => '特拉華州',
    'DC' => '哥倫比亞特區',
    'FL' => '佛羅里達州',
    'GA' => '喬治亞州',
    'HI' => '夏威夷',
    'ID' => '愛達荷州',
    'IL' => '伊利諾州',
    'IN' => '印第安那州',
    'IA' => '愛荷華州',
    'KS' => '堪薩斯州',
    'KY' => '肯塔基州',
    'LA' => '路易斯安那州',
    'ME' => '緬因州',
    'MD' => '馬里蘭州',
    'MA' => '麻塞諸塞州',
    'MI' => '密歇根州',
    'MN' => '明尼蘇達州',
    'MS' => '密西西比州',
    'MO' => '密蘇里州',
    'MT' => '蒙大拿州',
    'NE' => '內布拉斯加州',
    'NV' => '內華達州',
    'NH' => '新罕布夏州',
    'NJ' => '新澤西州',
    'NM' => '新墨西哥州',
    'NY' => '紐約州',
    'NC' => '北卡羅萊納州',
    'ND' => '北達科塔州',
    'OH' => '俄亥俄州',
    'OK' => '奧克拉荷馬',
    'OR' => '俄勒岡州',
    'PA' => '賓夕法尼亞州',
    'RI' => '羅德島',
    'SC' => '南卡羅萊納州',
    'SD' => '南達科他州',
    'TN' => '田納西州',
    'TX' => '德克薩斯州',
    'UT' => '猶他州',
    'VT' => '佛蒙特州',
    'VA' => '弗吉尼亞州',
    'WA' => '華盛頓',
    'WV' => '西佛吉尼亞州',
    'WI' => '威斯康辛州',
    'WY' => '懷俄明州',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (臺灣和香港)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (MS 斯拉夫文)',
    'CP1252' => 'CP1252 (MS 西歐和美國)',
    'EUC-CN' => 'EUC-CN (簡體中文 GB2312)',
    'EUC-JP' => 'EUC-JP (Unix 日文)',
    'EUC-KR' => 'EUC-KR (韓文)',
    'EUC-TW' => 'EUC-TW (台灣繁體)',
    'ISO-2022-JP' => 'ISO-2022-JP (日文)',
    'ISO-2022-KR' => 'ISO-2022-KR (韓文)',
    'ISO-8859-1' => 'ISO-8859-1 (西歐和美國)',
    'ISO-8859-2' => 'ISO-8859-2 (中歐和東歐)',
    'ISO-8859-3' => 'ISO-8859-3 (拉丁文 3)',
    'ISO-8859-4' => 'ISO-8859-4 (拉丁文 4)',
    'ISO-8859-5' => 'ISO-8859-5 (斯拉夫文)',
    'ISO-8859-6' => 'ISO-8859-6 (阿拉伯文)',
    'ISO-8859-7' => 'ISO-8859-7 (希臘文)',
    'ISO-8859-8' => 'ISO-8859-8 (希伯來文)',
    'ISO-8859-9' => 'ISO-8859-9 (拉丁文 5)',
    'ISO-8859-10' => 'ISO-8859-10 (拉丁文 6)',
    'ISO-8859-13' => 'ISO-8859-13 (拉丁文 7)',
    'ISO-8859-14' => 'ISO-8859-14 (拉丁文 8)',
    'ISO-8859-15' => 'ISO-8859-15 (拉丁文 9)',
    'KOI8-R' => 'KOI8-R (斯拉夫俄文)',
    'KOI8-U' => 'KOI8-U (斯拉夫烏克蘭文)',
    'SJIS' => 'SJIS (MS 日文)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => '非洲/阿爾及爾',
    'Africa/Luanda' => '非洲/魯安達',
    'Africa/Porto-Novo' => '非洲/新港',
    'Africa/Gaborone' => '非洲/嘉柏隆里',
    'Africa/Ouagadougou' => '非洲/瓦加杜古',
    'Africa/Bujumbura' => '非洲/布松布拉',
    'Africa/Douala' => '非洲/杜阿拉',
    'Atlantic/Cape_Verde' => '大西洋/維德角',
    'Africa/Bangui' => '非洲/班基',
    'Africa/Ndjamena' => '非洲/恩賈梅納',
    'Indian/Comoro' => '印度洋/科摩羅',
    'Africa/Kinshasa' => '非洲/金夏沙',
    'Africa/Lubumbashi' => '非洲/盧本巴希',
    'Africa/Brazzaville' => '非洲/布拉柴維爾',
    'Africa/Abidjan' => '非洲/阿比讓',
    'Africa/Djibouti' => '非洲/吉布地',
    'Africa/Cairo' => '非洲/開羅',
    'Africa/Malabo' => '非洲/馬拉博',
    'Africa/Asmera' => '非洲/阿斯馬拉',
    'Africa/Addis_Ababa' => '非洲/亞的斯亞貝巴',
    'Africa/Libreville' => '非洲/自由市',
    'Africa/Banjul' => '非洲/班竹',
    'Africa/Accra' => '非洲/阿克拉',
    'Africa/Conakry' => '非洲/柯那克里',
    'Africa/Bissau' => '非洲/比索',
    'Africa/Nairobi' => '非洲/奈洛比',
    'Africa/Maseru' => '非洲/馬塞魯',
    'Africa/Monrovia' => '非洲/蒙羅維亞',
    'Africa/Tripoli' => '非洲/的黎波里',
    'Indian/Antananarivo' => '印度洋/安塔那那利佛',
    'Africa/Blantyre' => '非洲/布蘭太爾',
    'Africa/Bamako' => '非洲/巴馬科',
    'Africa/Nouakchott' => '非洲/諾克少',
    'Indian/Mauritius' => '印度洋/模里西斯',
    'Indian/Mayotte' => '印度洋/馬約特',
    'Africa/Casablanca' => '非洲/卡薩布蘭卡',
    'Africa/El_Aaiun' => '非洲/阿尤恩',
    'Africa/Maputo' => '非洲/馬布多',
    'Africa/Windhoek' => '非洲/溫吐克',
    'Africa/Niamey' => '非洲/尼阿美',
    'Africa/Lagos' => '非洲/拉各斯',
    'Indian/Reunion' => '印度洋/留尼旺島',
    'Africa/Kigali' => '非洲/吉佳利',
    'Atlantic/St_Helena' => '大西洋/聖海倫娜',
    'Africa/Sao_Tome' => '非洲/聖多美',
    'Africa/Dakar' => '非洲/達喀爾',
    'Indian/Mahe' => '印度洋/馬埃島',
    'Africa/Freetown' => '非洲/自由城',
    'Africa/Mogadishu' => '非洲/摩加迪休',
    'Africa/Johannesburg' => '非洲/約翰尼斯堡',
    'Africa/Khartoum' => '非洲/喀土穆',
    'Africa/Mbabane' => '非洲/墨巴本',
    'Africa/Dar_es_Salaam' => '非洲/達累斯薩拉姆',
    'Africa/Lome' => '非洲/洛美',
    'Africa/Tunis' => '非洲/突尼斯',
    'Africa/Kampala' => '非洲/坎帕拉',
    'Africa/Lusaka' => '非洲/路沙卡',
    'Africa/Harare' => '非洲/哈拉雷',
    'Antarctica/Casey' => '南極洲/凱西',
    'Antarctica/Davis' => '南極洲/戴維斯',
    'Antarctica/Mawson' => '南極洲/莫森',
    'Indian/Kerguelen' => '印度洋/凱爾蓋朗',
    'Antarctica/DumontDUrville' => '南極洲/DumontDUrville',
    'Antarctica/Syowa' => '南極洲/昭和',
    'Antarctica/Vostok' => '南極洲/沃斯托克',
    'Antarctica/Rothera' => '南極洲/羅瑟拉',
    'Antarctica/Palmer' => '南極洲/帕默',
    'Antarctica/McMurdo' => '南極洲/麥克默多',
    'Asia/Kabul' => '亞洲/喀布爾',
    'Asia/Yerevan' => '亞洲/葉里溫',
    'Asia/Baku' => '亞洲/巴庫',
    'Asia/Bahrain' => '亞洲/巴林',
    'Asia/Dhaka' => '亞洲/達卡',
    'Asia/Thimphu' => '亞洲/辛布',
    'Indian/Chagos' => '印度洋/查戈斯',
    'Asia/Brunei' => '亞洲/汶萊',
    'Asia/Rangoon' => '亞洲/仰光',
    'Asia/Phnom_Penh' => '亞洲/金邊',
    'Asia/Beijing' => '亞洲/北京',
    'Asia/Harbin' => '亞洲/哈爾濱',
    'Asia/Shanghai' => '亞洲/上海',
    'Asia/Chongqing' => '亞洲/重慶',
    'Asia/Urumqi' => '亞洲/烏魯木齊',
    'Asia/Kashgar' => '亞洲/喀什',
    'Asia/Hong_Kong' => '亞洲/香港',
    'Asia/Taipei' => '亞洲/臺北',
    'Asia/Macau' => '亞洲/澳門',
    'Asia/Nicosia' => '亞洲/尼古西亞',
    'Asia/Tbilisi' => '亞洲/第比利斯',
    'Asia/Dili' => '亞洲/帝利',
    'Asia/Calcutta' => '亞洲/加爾各答',
    'Asia/Jakarta' => '亞洲/雅加達',
    'Asia/Pontianak' => '亞洲/坤甸',
    'Asia/Makassar' => '亞洲/望加錫',
    'Asia/Jayapura' => '亞洲/查亞普拉',
    'Asia/Tehran' => '亞洲/德黑蘭',
    'Asia/Baghdad' => '亞洲/巴格達',
    'Asia/Jerusalem' => '亞洲/耶路撒冷',
    'Asia/Tokyo' => '亞洲/東京',
    'Asia/Amman' => '亞洲/安曼',
    'Asia/Almaty' => '亞洲/阿拉木圖',
    'Asia/Qyzylorda' => '亞洲/基茲',
    'Asia/Aqtobe' => '亞洲/阿克托別',
    'Asia/Aqtau' => '亞洲/阿克陶',
    'Asia/Oral' => '亞洲/烏拉爾',
    'Asia/Bishkek' => '亞洲/比什凱克',
    'Asia/Seoul' => '亞洲/首爾',
    'Asia/Pyongyang' => '亞洲/平壤',
    'Asia/Kuwait' => '亞洲/科威特',
    'Asia/Vientiane' => '亞洲/萬象',
    'Asia/Beirut' => '亞洲/貝魯特',
    'Asia/Kuala_Lumpur' => '亞洲/吉隆坡',
    'Asia/Kuching' => '亞洲/古晉',
    'Indian/Maldives' => '印度/馬爾地夫',
    'Asia/Hovd' => '亞洲/科布多',
    'Asia/Ulaanbaatar' => '亞洲/烏蘭巴托',
    'Asia/Choibalsan' => '亞洲/喬巴山',
    'Asia/Katmandu' => '亞洲/加德滿都',
    'Asia/Muscat' => '亞洲/馬斯喀特',
    'Asia/Karachi' => '亞洲/卡拉奇',
    'Asia/Gaza' => '亞洲/加沙',
    'Asia/Manila' => '亞洲/馬尼拉',
    'Asia/Qatar' => '亞洲/卡塔爾',
    'Asia/Riyadh' => '亞洲/利雅德',
    'Asia/Singapore' => '亞洲/新加坡',
    'Asia/Colombo' => '亞洲/可倫坡',
    'Asia/Damascus' => '亞洲/大馬士革',
    'Asia/Dushanbe' => '亞洲/杜桑貝',
    'Asia/Bangkok' => '亞洲/曼谷',
    'Asia/Ashgabat' => '亞洲/阿什哈巴',
    'Asia/Dubai' => '亞洲/迪拜',
    'Asia/Samarkand' => '亞洲/撒馬爾罕',
    'Asia/Tashkent' => '亞洲/塔什干',
    'Asia/Saigon' => '亞洲/西貢',
    'Asia/Aden' => '亞洲/亞丁',
    'Australia/Darwin' => '澳洲/達爾文',
    'Australia/Perth' => '澳洲/珀斯',
    'Australia/Brisbane' => '澳洲/布里斯班',
    'Australia/Lindeman' => '澳洲/德曼',
    'Australia/Adelaide' => '澳洲/阿德萊德',
    'Australia/Hobart' => '澳洲/霍巴特',
    'Australia/Currie' => '澳洲/柯里',
    'Australia/Melbourne' => '澳洲/墨爾本',
    'Australia/Sydney' => '澳洲/悉尼',
    'Australia/Broken_Hill' => '澳洲/布洛肯希爾',
    'Indian/Christmas' => '印度洋/聖誕島',
    'Pacific/Rarotonga' => '太平洋/拉羅湯加',
    'Indian/Cocos' => '印度洋/科科島',
    'Pacific/Fiji' => '太平洋/斐濟',
    'Pacific/Gambier' => '太平洋/甘比爾',
    'Pacific/Marquesas' => '太平洋/馬克薩斯群島',
    'Pacific/Tahiti' => '太平洋/大溪地',
    'Pacific/Guam' => '太平洋/關島',
    'Pacific/Tarawa' => '太平洋/塔拉瓦',
    'Pacific/Enderbury' => '太平洋/坎頓',
    'Pacific/Kiritimati' => '太平洋/基里地馬地島',
    'Pacific/Saipan' => '太平洋/塞班島',
    'Pacific/Majuro' => '太平洋/麥哲魯',
    'Pacific/Kwajalein' => '太平洋/夸賈林島',
    'Pacific/Truk' => '太平洋/特魯克島',
    'Pacific/Ponape' => '太平洋/波納佩島',
    'Pacific/Kosrae' => '太平洋/科斯雷島',
    'Pacific/Nauru' => '太平洋/瑙魯島',
    'Pacific/Noumea' => '太平洋/諾美亞',
    'Pacific/Auckland' => '太平洋/奧克蘭島',
    'Pacific/Chatham' => '太平洋/漆咸島',
    'Pacific/Niue' => '太平洋/紐埃島',
    'Pacific/Norfolk' => '太平洋/諾福克島',
    'Pacific/Palau' => '太平洋/帕勞島',
    'Pacific/Port_Moresby' => '太平洋/摩爾斯貝港',
    'Pacific/Pitcairn' => '太平洋/皮特凱恩島',
    'Pacific/Pago_Pago' => '太平洋/帕果帕果島',
    'Pacific/Apia' => '太平洋/亞庇島',
    'Pacific/Guadalcanal' => '太平洋/瓜達爾卡納爾島',
    'Pacific/Fakaofo' => '太平洋/法考福島',
    'Pacific/Tongatapu' => '太平洋/湯加塔布島',
    'Pacific/Funafuti' => '太平洋/富納富提島',
    'Pacific/Johnston' => '太平洋/莊士敦島',
    'Pacific/Midway' => '太平洋/中途島',
    'Pacific/Wake' => '太平洋/威克島',
    'Pacific/Efate' => '太平洋/埃法特島',
    'Pacific/Wallis' => '太平洋/沃利斯島',
    'Europe/London' => '歐洲/倫敦',
    'Europe/Dublin' => '歐洲/都柏林',
    'WET' => 'WET',
    'CET' => 'CET',
    'MET' => 'MET',
    'EET' => 'EET',
    'Europe/Tirane' => '歐洲/地拉那',
    'Europe/Andorra' => '歐洲/安道爾',
    'Europe/Vienna' => '歐洲/維也納',
    'Europe/Minsk' => '歐洲/明斯克',
    'Europe/Brussels' => '歐洲/布魯塞爾',
    'Europe/Sofia' => '歐洲/索菲亞',
    'Europe/Prague' => '歐洲/布拉格',
    'Europe/Copenhagen' => '歐洲/哥本哈根',
    'Atlantic/Faeroe' => '大西洋/法羅群島',
    'America/Danmarkshavn' => '美洲/Danmarkshavn',
    'America/Scoresbysund' => '美洲/斯科斯比松',
    'America/Godthab' => '美洲/戈特霍布',
    'America/Thule' => '美洲/圖勒',
    'Europe/Tallinn' => '歐洲/塔林',
    'Europe/Helsinki' => '歐洲/赫爾辛基',
    'Europe/Paris' => '歐洲/巴黎',
    'Europe/Berlin' => '歐洲/柏林',
    'Europe/Gibraltar' => '歐洲/直布羅陀',
    'Europe/Athens' => '歐洲/雅典',
    'Europe/Budapest' => '歐洲/布達佩斯',
    'Atlantic/Reykjavik' => '大西洋/雷克雅維克',
    'Europe/Rome' => '歐洲/羅馬',
    'Europe/Riga' => '歐洲/里加',
    'Europe/Vaduz' => '歐洲/瓦都茲',
    'Europe/Vilnius' => '歐洲/維爾紐斯',
    'Europe/Luxembourg' => '歐洲/盧森堡',
    'Europe/Malta' => '歐洲/馬爾他',
    'Europe/Chisinau' => '歐洲/基希訥烏',
    'Europe/Monaco' => '歐洲/摩納哥',
    'Europe/Amsterdam' => '歐洲/阿姆斯特丹',
    'Europe/Oslo' => '歐洲/奧斯陸',
    'Europe/Warsaw' => '歐洲/華沙',
    'Europe/Lisbon' => '歐洲/里斯本',
    'Atlantic/Azores' => '大西洋/亞速爾群島',
    'Atlantic/Madeira' => '大西洋/馬德拉',
    'Europe/Bucharest' => '歐洲/布加勒斯特',
    'Europe/Kaliningrad' => '歐洲/加里甯格勒',
    'Europe/Moscow' => '歐洲/莫斯科',
    'Europe/Samara' => '歐洲/薩馬拉',
    'Asia/Yekaterinburg' => '亞洲/葉卡特琳堡',
    'Asia/Omsk' => '亞洲/鄂木斯克',
    'Asia/Novosibirsk' => '亞洲/新西伯利亞',
    'Asia/Krasnoyarsk' => '亞洲/克拉斯諾雅斯克',
    'Asia/Irkutsk' => '亞洲/伊爾庫次克',
    'Asia/Yakutsk' => '亞洲/亞庫次克',
    'Asia/Vladivostok' => '亞洲/符拉迪沃斯托克',
    'Asia/Sakhalin' => '亞洲/薩哈林島',
    'Asia/Magadan' => '亞洲/馬加丹',
    'Asia/Kamchatka' => '亞洲/勘察加半島',
    'Asia/Anadyr' => '亞洲/阿納德爾',
    'Europe/Belgrade' => '歐洲/貝爾格勒',
    'Europe/Madrid' => '歐洲/馬德里',
    'Africa/Ceuta' => '非洲/休達',
    'Atlantic/Canary' => '大西洋/加納利群島',
    'Europe/Stockholm' => '歐洲/斯德哥爾摩',
    'Europe/Zurich' => '歐洲/蘇黎世',
    'Europe/Istanbul' => '歐洲/伊斯坦布爾',
    'Europe/Kiev' => '歐洲/基輔',
    'Europe/Uzhgorod' => '歐洲/烏日哥羅德',
    'Europe/Zaporozhye' => '歐洲/扎波羅熱',
    'Europe/Simferopol' => '歐洲/辛菲羅波爾',
    'America/New_York' => '美洲/紐約',
    'America/Chicago' => '美洲/芝加哥',
    'America/North_Dakota/Center' => '美洲/北達科他州/Center',
    'America/Denver' => '美洲/丹佛',
    'America/Los_Angeles' => '美洲/洛杉磯',
    'America/Juneau' => '美洲/朱諾',
    'America/Yakutat' => '美洲/亞庫塔特',
    'America/Anchorage' => '美洲/安克雷奇',
    'America/Nome' => '美洲/諾姆',
    'America/Adak' => '美洲/阿達克',
    'Pacific/Honolulu' => '太平洋/檀香山',
    'America/Phoenix' => '美洲/菲尼克斯',
    'America/Boise' => '美洲/博伊西',
    'America/Indiana/Indianapolis' => '美洲/印第安那州/印弟安納波里斯',
    'America/Indiana/Marengo' => '美洲/印第安那州/馬倫戈',
    'America/Indiana/Knox' => '美洲/印第安那州/諾克斯',
    'America/Indiana/Vevay' => '美洲/印第安那州/韋韋',
    'America/Kentucky/Louisville' => '美洲/肯塔基州/路易斯維爾',
    'America/Kentucky/Monticello' => '美洲/肯塔基州/蒙蒂塞洛',
    'America/Detroit' => '美洲/底特律',
    'America/Menominee' => '美洲/梅諾米尼',
    'America/St_Johns' => '美洲/聖約翰斯',
    'America/Goose_Bay' => '美洲/古斯灣',
    'America/Halifax' => '美洲/哈利法克斯',
    'America/Glace_Bay' => '美洲/葛萊斯灣',
    'America/Montreal' => '美洲/蒙特利爾',
    'America/Toronto' => '美洲/多倫多',
    'America/Thunder_Bay' => '美洲/桑德貝',
    'America/Nipigon' => '美洲/尼皮貢',
    'America/Rainy_River' => '美洲/瑞尼河',
    'America/Winnipeg' => '美洲/溫尼伯',
    'America/Regina' => '美洲/里賈納',
    'America/Swift_Current' => '美洲/斯威夫特卡倫特',
    'America/Edmonton' => '美洲/埃德蒙頓',
    'America/Vancouver' => '美洲/溫哥華',
    'America/Dawson_Creek' => '美洲/道森克里克',
    'America/Pangnirtung' => '美洲/龐納唐',
    'America/Iqaluit' => '美洲/伊魁特',
    'America/Coral_Harbour' => '美國/科勒爾',
    'America/Rankin_Inlet' => '美洲/蘭京灣',
    'America/Cambridge_Bay' => '美洲/劍橋灣',
    'America/Yellowknife' => '美洲/耶洛奈夫',
    'America/Inuvik' => '美洲/伊努維克',
    'America/Whitehorse' => '美洲/懷特霍斯',
    'America/Dawson' => '美洲/道森',
    'America/Cancun' => '美洲/坎昆',
    'America/Merida' => '美洲/梅里達',
    'America/Monterrey' => '美洲/蒙特雷',
    'America/Mexico_City' => '美洲/墨西哥城',
    'America/Chihuahua' => '美洲/奇瓦瓦',
    'America/Hermosillo' => '美洲/埃莫西約',
    'America/Mazatlan' => '美洲/馬薩特蘭',
    'America/Tijuana' => '美洲/蒂華納',
    'America/Anguilla' => '美洲/安圭拉',
    'America/Antigua' => '美洲/安提瓜',
    'America/Nassau' => '美洲/拿索',
    'America/Barbados' => '美洲/巴巴多斯',
    'America/Belize' => '美洲/貝里斯',
    'Atlantic/Bermuda' => '大西洋/百慕達',
    'America/Cayman' => '美洲/開曼',
    'America/Costa_Rica' => '美洲/哥斯大黎加',
    'America/Havana' => '美洲/哈瓦那',
    'America/Dominica' => '美洲/多米尼克',
    'America/Santo_Domingo' => '美洲/聖多明戈',
    'America/El_Salvador' => '美國/薩爾瓦多',
    'America/Grenada' => '美洲/格瑞那達',
    'America/Guadeloupe' => '美洲/哥德洛普島',
    'America/Guatemala' => '美洲/瓜地馬拉',
    'America/Port-au-Prince' => '美國/太子港',
    'America/Tegucigalpa' => '美洲/德古西加巴',
    'America/Jamaica' => '美洲/牙買加',
    'America/Martinique' => '美洲/馬丁尼克島',
    'America/Montserrat' => '美洲/蒙特塞拉特',
    'America/Managua' => '美洲/馬納瓜',
    'America/Panama' => '美洲/巴拿馬',
    'America/Puerto_Rico' => '美洲/波多黎各',
    'America/St_Kitts' => '美國/聖基茨',
    'America/St_Lucia' => '美洲/聖盧西亞',
    'America/Miquelon' => '美洲/密克隆島',
    'America/St_Vincent' => '美洲/聖文森特',
    'America/Grand_Turk' => '美洲/大特克島',
    'America/Tortola' => '美洲/托爾托拉',
    'America/St_Thomas' => '美國/聖托馬斯',
    'America/Argentina/Buenos_Aires' => '美國/阿根廷/布宜諾斯艾利斯',
    'America/Argentina/Cordoba' => '美洲/阿根廷/科爾多瓦',
    'America/Argentina/Tucuman' => '美洲/阿根廷/圖庫',
    'America/Argentina/La_Rioja' => '美洲/阿根廷/拉里奧哈',
    'America/Argentina/San_Juan' => '美國/阿根廷/聖胡安',
    'America/Argentina/Jujuy' => '美洲/阿根廷/胡胡伊',
    'America/Argentina/Catamarca' => '美洲/阿根廷/卡塔馬卡',
    'America/Argentina/Mendoza' => '美洲/阿根廷/門多薩',
    'America/Argentina/Rio_Gallegos' => '美國/阿根廷/里奧加耶戈斯',
    'America/Argentina/Ushuaia' => '美洲/阿根廷/烏斯懷亞',
    'America/Aruba' => '美洲/阿路巴',
    'America/La_Paz' => '美洲/拉巴斯',
    'America/Noronha' => '美洲/迪諾羅尼亞',
    'America/Belem' => '美洲/貝倫',
    'America/Fortaleza' => '美洲/福塔雷薩',
    'America/Recife' => '美洲/累西腓',
    'America/Araguaina' => '美國/阿拉瓜伊納',
    'America/Maceio' => '美洲/馬賽約',
    'America/Bahia' => '美洲/巴伊亞',
    'America/Sao_Paulo' => '美洲/聖保羅',
    'America/Campo_Grande' => '美國/坎普格蘭',
    'America/Cuiaba' => '美洲/庫亞巴',
    'America/Porto_Velho' => '美洲/波多偉柳',
    'America/Boa_Vista' => '美洲/博阿維斯塔',
    'America/Manaus' => '美洲/馬瑙斯',
    'America/Eirunepe' => '美洲/埃魯內佩',
    'America/Rio_Branco' => '美洲/里約布蘭柯',
    'America/Santiago' => '美洲/聖地牙哥',
    'Pacific/Easter' => '太平洋/復活島',
    'America/Bogota' => '美洲/波哥大',
    'America/Curacao' => '美洲/古拉梳島',
    'America/Guayaquil' => '美洲/瓜亞基爾',
    'Pacific/Galapagos' => '太平洋/加拉帕戈',
    'Atlantic/Stanley' => '大西洋/丹利島',
    'America/Cayenne' => '美洲/卡宴',
    'America/Guyana' => '美洲/蓋亞納',
    'America/Asuncion' => '美洲/亞松森',
    'America/Lima' => '美洲/利馬',
    'Atlantic/South_Georgia' => '大西洋/南喬治亞島',
    'America/Paramaribo' => '美洲/巴拉馬利波',
    'America/Port_of_Spain' => '美洲/西班牙港',
    'America/Montevideo' => '美洲/蒙特維多',
    'America/Caracas' => '美洲/卡拉卡斯',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = '最愛';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = '最愛';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => 'GoToMeeting',
    'IBMSmartCloud' => 'IBM SmartCloud',
    'Google' => 'Google',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => 'Google Contacts',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => 'Google Drive',
];
$app_list_strings['token_status'] = [
    1 => '請求',
    2 => '存取',
    3 => '無效',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar 使用者',
    'support_portal' => '支援入口網站',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => '宣傳活動',
    'email' => '電子郵件',
    'workflow' => '工作流程',
    'system' => '系統',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => '宣傳活動',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => '宣傳活動',
    'email' => '電子郵件',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => '文件',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => '兩個範圍',
    'show_buckets' => '三個範圍',
    'show_custom_buckets' => '自訂範圍',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => '基於日期的年份',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => '年度 (季度子週期)',
    'Quarter' => '季度 (月份子週期)',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => '營收項目',
    'Opportunities' => '商機',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => '是',
    'no' => '否',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => '警示',
    'information' => '資訊',
    'other' => '其他',
    'success' => '成功',
    'warning' => '警告',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => '發佈',
    'GET' => '獲取',
    'PUT' => '放置',
    'DELETE' => '刪除',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => '手動',
    '5' => '每 5 分鐘',
    '15' => '每 15 分鐘',
    '30' => '每 30 分鐘',
    '60' => '每小時',
];

$app_list_strings['moduleList']['KBDocuments'] = '知識庫文件';
$app_list_strings['moduleListSingular']['KBDocuments'] = '知識庫文件';
$app_list_strings['moduleList']['KBContents'] = '知識庫';
$app_list_strings['moduleListSingular']['KBContents'] = '知識庫文章';
$app_list_strings['moduleList']['KBArticles'] = '知識庫文章';
$app_list_strings['moduleListSingular']['KBArticles'] = '知識庫文章';
$app_list_strings['moduleList']['KBContentTemplates'] = '知識庫範本';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = '知識庫範本';
$app_list_strings['moduleList']['EmbeddedFiles'] = '已嵌入檔案';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = '已嵌入檔案';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J $',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => '瑞士法郎',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => '列克',
    'USD' => '美元',
    'AFN' => '阿富汗尼',
    'ARS' => '比索',
    'AWG' => '荷蘭盾',
    'AUD' => '美元',
    'AZN' => '新馬納特',
    'BSD' => '美元',
    'BBD' => '美元',
    'BYR' => '盧布',
    'EUR' => '歐元',
    'BZD' => '美元',
    'BMD' => '美元',
    'BOB' => '玻利維亞諾',
    'BAM' => '可兌換馬克',
    'BWP' => '普拉',
    'BGN' => '列弗',
    'BRL' => '雷亞爾',
    'GBP' => '英鎊',
    'BND' => '美元',
    'KHR' => '瑞爾',
    'CAD' => '美元',
    'KYD' => '美元',
    'CLP' => '比索',
    'CNY' => '人民幣元',
    'COP' => '比索',
    'CRC' => 'ColÃ³n',
    'HRK' => '庫納',
    'CUP' => '比索',
    'CZK' => '克朗',
    'DKK' => '克朗納',
    'DOP' => '比索',
    'XCD' => '美元',
    'EGP' => '英鎊',
    'SVC' => '科朗',
    'EEK' => '克朗',
    'FKP' => '英鎊',
    'FJD' => '美元',
    'GHC' => '塞地',
    'GIP' => '英鎊',
    'GTQ' => '格查爾',
    'GGP' => '英鎊',
    'GYD' => '美元',
    'HNL' => '倫皮拉',
    'HKD' => '美元',
    'HUF' => '福林',
    'ISK' => '克朗',
    'INR' => '盧比',
    'IDR' => '盧比',
    'IRR' => '裡亞爾',
    'IMP' => '英鎊',
    'ILS' => '新謝克爾',
    'JMD' => '美元',
    'JPY' => '日元',
    'JEP' => '英鎊',
    'KZT' => '堅戈',
    'KPW' => '韓元',
    'KRW' => '韓元',
    'KGS' => '索姆',
    'LAK' => '基普',
    'LVL' => '拉特',
    'LBP' => '英鎊',
    'LRD' => '美元',
    'CHF' => '瑞士法郎',
    'LTL' => '立特',
    'MKD' => '第納爾',
    'MYR' => '林吉特',
    'MUR' => '盧比',
    'MXN' => '比索',
    'MNT' => '圖格裡克',
    'MZN' => '梅蒂卡爾',
    'NAD' => '美元',
    'NPR' => '盧比',
    'ANG' => '荷蘭盾',
    'NZD' => '美元',
    'NIO' => '科多巴',
    'NGN' => '奈拉',
    'NOK' => '克朗',
    'OMR' => '裡亞爾',
    'PKR' => '盧比',
    'PAB' => '巴爾博亞',
    'PYG' => '瓜拉尼',
    'PEN' => '索爾',
    'PHP' => '比索',
    'PLN' => '茲羅提',
    'QAR' => '裡亞爾',
    'RON' => '新雷',
    'RUB' => '盧布',
    'SHP' => '英鎊',
    'SAR' => '裡亞爾',
    'RSD' => '第納爾',
    'SCR' => '盧比',
    'SGD' => '美元',
    'SBD' => '美元',
    'SOS' => '先令',
    'ZAR' => '蘭德',
    'LKR' => '盧比',
    'SEK' => '克朗',
    'SRD' => '美元',
    'SYP' => '英鎊',
    'TWD' => '新美元',
    'THB' => '泰銖',
    'TTD' => '美元',
    'TRY' => '里拉',
    'TRL' => '里拉',
    'TVD' => '美元',
    'UAH' => '格里夫尼亞',
    'UYU' => '比索',
    'UZS' => '索姆',
    'VEF' => '玻利瓦',
    'VND' => '盾',
    'YER' => '裡亞爾',
    'ZWD' => '辛巴威元',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => '很高',
    '4' => '高',
    '3' => '中性的',
    '2' => '低',
    '1' => '很低',
];
$app_list_strings['process_et_field_type'] = [
    'none' => '無',
    'future' => '當前值',
    'old' => '舊值',
    'both' => '當前和舊值',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => '按一下',
];

$app_list_strings['merge_status_list'] = [
    'processing' => '正在處理',
    'error' => '錯誤',
    'success' => '成功',
    'canceled' => '已取消',
    'document_load' => '正在加載模組',
    'tags_extract' => '正在提取標籤',
    'tags_validate' => '正在驗證標籤',
    'data_retrieving' => '正在檢索數據',
    'serialize_document' => '並接文檔',
    'send_document' => '向您發送文檔',
];

$app_list_strings['merge_type_list'] = [
    'merge' => '合併',
    'convert' => 'PDF 合併',
    'multimerge' => '批量合併',
    'multimerge_convert' => '批量合併 PDF',
    'labelsgenerate' => '生成標籤',
    'labelsgenerate_convert' => '生成標籤 PDF',
    'excel' => 'Excel 合併',
    'excel_convert' => 'Excel 合併轉換',
    'presentation' => 'PowerPoint 合併',
    'presentation_convert' => 'PowerPoint 合併 PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => '我的帳戶',
    'favorites' => '收藏夾帳戶',
    'tags' => '標記的帳戶',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => '所有新聞',
    'General' => '一般',
    'Finance' => '財務',
    'People' => '全體人員',
    'Press Releases' => '新聞稿',
    'Other' => '其他',
];

$app_strings['LBL_OWNERS'] = '擁有者';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = '雲端';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = '雲端集成渠道';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = '複製連結';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = '下載';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = '創建 Sugar 文件';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = '無法下載該檔';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = '雲渠道不存在';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar 文件已建立';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = '發送到 DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign 無法從此位置使用。';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = '無法從該位置將文件合併到 Word/Excel/PowerPoint';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = '無法從該位置將文件合併到 DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = '無法從該位置將文件合併到 PDF';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = '只有當您有權在此位置上傳時，您的簽名檔案才會上傳到此處。';
$app_strings['LBL_DOC_MERGE_TO'] = '合併文檔至';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = '我的檔案';
$app_strings['LBL_SHARED_WITH_ME'] = '與我分享';
$app_strings['LBL_CLOUD_PROVIDER'] = '雲提供商';

$app_list_strings['drive_types'] = [
    'google' => 'Google Drive',
    'onedrive' => 'Microsoft Onedrive',
    'dropbox' => 'Dropbox Drive',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = '與我分享';
$app_strings['LBL_MY_FILES'] = '我的檔案';
$app_strings['LBL_UPLOAD_FILE'] = '上載檔案';
$app_strings['LBL_FOLDER_NOT_FOUND'] = '找不到資料夾';
$app_strings['LBL_CREATE_FOLDER'] = '建立資料夾';
$app_strings['LBL_LOAD_MORE'] = '載入更多...';
$app_strings['LBL_NEW_FOLDER'] = '新資料夾';
$app_strings['LBL_FOLDER_NAME'] = '資料夾名稱: ';
$app_strings['LBL_PERMISSION_ERROR'] = '您無權在當前路徑上執行此操作。';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = '您無權繼續當前路徑上操作。';
$app_strings['LBL_FILE_UPLOADED'] = '文件已上傳。';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = '由於檔案很大，上傳需要一些時間。';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = '一條或多條文件記錄沒有附加檔案。請將檔案附加到記錄並重試，或單獨將特定記錄與檔案同步。';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = '未找到與 Google 的連接...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = '未找到與 Microsoft 的連接...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = '未找到與 Dropbox 的連接...';
$app_strings['LBL_MICROSOFT_DELAY'] = '與 OneDrive 同步可能需要一段時間';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = '確定要刪除這個文件嗎？';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive 上傳已完成。';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' 已成功上傳。';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = '加載路徑時出錯。';
$app_strings['LBL_INVALID_DRIVE_FILE'] = '錯誤已經發生，因為該文件已損壞。';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = '文檔 <i>"{{documentName}}"</i> 已保存到您的雲驅動器，並添加到文檔模塊。';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = '您沒有權限刪除此檔案。';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = '您沒有權限刪除此資料夾。';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = '您沒有將檔案上傳到此位置的權限。';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = '您沒有在此位置建立資料夾的權限。';
$app_strings['LBL_NO_FOLDER_CREATE'] = '無法在此位置建立資料夾。';
$app_strings['LBL_NO_FILE_UPLOAD'] = '無法將檔案上傳到此位置。';
$app_strings['LBL_SITES'] = '網站';
$app_strings['LBL_SHARED'] = '已共用';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = '連結已建立。按下按鈕以將連結複製到剪貼簿。';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = '複製到剪貼簿';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-空白-',
    'Exact' => '完全符合',
    'Null_address_components' => '一個或多個地址組件為空',
    'Invalid_address' => '地址無效，服務器返回錯誤',
    'Invalid_server_response_not_XML' => '無效的服務器響應，不是 XML',
    'Invalid_address_no_location' => '地址無效，服務器未返回任何位置',
    'Ambiguous_address' => '地址不明確，多個匹配項',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => '道路',
    'a' => '航空',
    'rd' => '道路漆黑',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', '英語(US)']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['美國東部時間', '紐約(EST)'],
    ['太平洋標準時間', '洛杉磯(PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['新的', '新的'],
    ['已指派', '已指派'],
    ['關門', '關門'],
    ['待輸入', '待輸入'],
    ['已拒絕', '已拒絕'],
    ['複製', '複製'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['管理', '管理'],
    ['產品', '產品'],
    ['使用者', '使用者'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', '高'],
    ['P2', '中'],
    ['P3', '低'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['使用者', '使用者'],
    ['管理員，使用者', '管理員'],
    ['客戶經理，使用者', '客戶經理'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', '過去 30 天'],
    ['last_90_days', '過去 90 天'],
    ['this_year', '去年'],
    ['自訂', '自訂範圍'],
    ['全部', '全部'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['預設', '預設'],
    ['顏色', '純色'],
    ['Url', '自訂影像'],
];
