<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/Resources/Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */
//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = [
//e.g. auf Deutsch 'Contacts'=>'Contakten',
    'language_pack_name' => '美式英文',
    'moduleList' => [
        'Home' => '首页',
        'Contacts' => '联系人',
        'Accounts' => '帐户',
        'Opportunities' => '商业机会',
        'Cases' => '客户反馈',
        'Notes' => '笔记',
        'Calls' => '电话',
        'Emails' => '电子邮件',
        'Meetings' => '会议',
        'Tasks' => '任务',
        'Calendar' => '日程安排',
        'Leads' => '潜在客户',
        'Currencies' => '货币',
        'Contracts' => '合同',
        'Quotes' => '报价',
        'Products' => '已报价单项',
        'WebLogicHooks' => '网络逻辑钩',
        'ProductCategories' => '产品类别',
        'ProductTypes' => '产品类型',
        'ProductTemplates' => '产品目录',
        'ProductBundles' => '产品包',
        'ProductBundleNotes' => '产品包记录',
        'Reports' => '报表',
        'Forecasts' => '预测',
        'ForecastWorksheets' => '预测工作表',
        'ForecastManagerWorksheets' => '预测经理工作表',
        'VisualPipeline' => '可视管道',
        'ConsoleConfiguration' => '控制台配置',
        'SugarLive' => 'SugarLive',
        'Quotas' => '定额',
        'Teams' => '团队',
        'TeamNotices' => '团队通知',
        'Manufacturers' => '制造商',
        'Activities' => '活动',
        'Comments' => '备注',
        'Subscriptions' => '订阅',
        'Bugs' => '缺陷',
        'Feeds' => 'RSS',
        'iFrames' => '我的网站',
        'TimePeriods' => '时段',
        'TaxRates' => '税率',
        'ContractTypes' => '合同类型',
        'Schedulers' => '计划任务',
        'Project' => '项目',
        'ProjectTask' => '项目任务',
        'Campaigns' => '市场活动',
        'CampaignLog' => '市场活动日志',
        'CampaignTrackers' => '市场活动跟踪器',
        'Documents' => '文档',
        'DocumentRevisions' => '文档版本',
        'Connectors' => '连接器',
        'Notifications' => '通知',
        'Sync' => '同步',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'ExternalUsers' => '外部用户',
        'ReportMaker' => '高级报表',
        'DataSets' => '数据格式',
        'CustomQueries' => '自定义查询',
        'pmse_Inbox' => '流程',
        'pmse_Project' => '流程定义',
        'pmse_Business_Rules' => '流程商务规则',
        'pmse_Emails_Templates' => '流程电子邮件模板',
        'BusinessCenters' => '业务中心',
        'Shifts' => '班次',
        'ShiftExceptions' => '班次异常',
        'Purchases' => '购买',
        'PurchasedLineItems' => '已购买单项',
        'MobileDevices' => '移动设备',
        'PushNotifications' => '推送通知',
        'Escalations' => '升级',
        'DocumentTemplates' => '文档模板',
        'DocumentMerges' => '文档合并',
        'CloudDrivePaths' => '云驱动器路径',
        'WorkFlow' => '工作流定义',
        'EAPM' => '外部帐户',
        'Worksheet' => '工作表',
        'Users' => '用户',
        'Employees' => '员工',
        'Administration' => '管理',
        'ACLRoles' => '角色',
        'InboundEmail' => '入站电子邮件',
        'Releases' => '发布版本',
        'Prospects' => '目标',
        'Queues' => '队列',
        'EmailMarketing' => '电子邮件营销',
        'EmailTemplates' => '电子邮件模板',
        'SNIP' => '电子邮件归档',
        'ProspectLists' => '目标列表',
        'SavedSearch' => '保存的搜索',
        'UpgradeWizard' => '升级向导',
        'Trackers' => '跟踪器',
        'TrackerPerfs' => '跟踪器表现',
        'TrackerSessions' => '跟踪器会话',
        'TrackerQueries' => '跟踪器查询',
        'FAQ' => '常见问题',
        'Newsletters' => '新闻邮件',
        'SugarFavorites' => '收藏夹',
        'PdfManager' => 'PDF 经理',
        'DataArchiver' => '数据存档程序',
        'ArchiveRuns' => '归档运行',

        'OAuthKeys' => 'OAuth 用户密匙',
        'OAuthTokens' => 'OAuth 令牌',
        'Filters' => '过滤器',
        'UserSignatures' => '电子邮件签名',
        'Shippers' => '运输供应商',
        'Styleguide' => '设计指南',
        'Feedbacks' => '反馈',
        'Tags' => '标签',
        'Categories' => '类别',
        'Dashboards' => '仪表板',
        'OutboundEmail' => '电子邮件设置',
        'EmailParticipants' => '电子邮件参与者',
        'DataPrivacy' => '数据隐私',
        'ReportSchedules' => '报告日程',
        'CommentLog' => '评论日志',
        'Holidays' => '假期',
        'ChangeTimers' => '更改计时器',
        'Metrics' => '量度数据',
        'Messages' => '消息',
        'Audit' => '审计',
        'RevenueLineItems' => '营收单项',
        'DocuSignEnvelopes' => 'DocuSign 信封',
        'Geocode' => '地理编码',
        'DRI_Workflows' => '智能指南',
        'DRI_Workflow_Task_Templates' => '智能指南活动模板',
        'DRI_SubWorkflows' => '智能指南阶段',
        'DRI_Workflow_Templates' => '智能指南模板',
        'CJ_WebHooks' => 'Sugar Automate 网络钩子',
        'CJ_Forms' => 'Smart Guide Sugar 操作',
        'DRI_SubWorkflow_Templates' => '智能指南阶段模板',
        'PubSub_ModuleEvent_PushSubs' => '发布/订阅模块事件推送订阅',
    ],

    'moduleIconList' => [
        'Home' => '主页',
        'Contacts' => '联系人',
        'Accounts' => '账户',
        'Opportunities' => '商业机会',
        'Cases' => 'CS',
        'Notes' => '笔记',
        'Calls' => 'Cl',
        'Emails' => '电子邮件',
        'Meetings' => '会议',
        'Tasks' => '任务',
        'Calendar' => '日程',
        'Leads' => '潜在客户',
        'Currencies' => '货币',
        'Contracts' => '合同',
        'Quotes' => '引用',
        'Products' => 'QL',
        'WebLogicHooks' => 'WL',
        'ProductCategories' => 'PG',
        'ProductTypes' => '产品类型',
        'ProductTemplates' => 'PC',
        'ProductBundles' => '产品捆绑',
        'ProductBundleNotes' => '产品捆绑',
        'Reports' => '报告',
        'Forecasts' => '预测',
        'ForecastWorksheets' => '预测工作表',
        'ForecastManagerWorksheets' => '预测经理',
        'Quotas' => '定额',
        'VisualPipeline' => '可视化管道',
        'ConsoleConfiguration' => '控制台配置',
        'SugarLive' => 'Sugar 现场直播',
        'Teams' => '团队',
        'TeamNotices' => '团队通知',
        'Manufacturers' => '生产者',
        'Activities' => '活动',
        'Comments' => '评论',
        'Subscriptions' => '订阅',
        'Bugs' => '漏洞',
        'Feeds' => 'RS',
        'iFrames' => 'MS',
        'TimePeriods' => '时间段',
        'TaxRates' => '税率',
        'ContractTypes' => '合同类型',
        'Schedulers' => '调度器',
        'Project' => '项目',
        'ProjectTask' => '项目任务',
        'Campaigns' => '市场活动',
        'CampaignLog' => '活动日志',
        'CampaignTrackers' => '活动跟踪器',
        'Documents' => '文档',
        'DocumentRevisions' => '文档修订',
        'Connectors' => '连接器',
        'Notifications' => '通知',
        'Sync' => '同步',
        'HintAccountsets' => '提示账户组',
        'HintNotificationTargets' => '提示通知目标',
        'HintNewsNotifications' => '提示新闻通知',
        'HintEnrichFieldConfigs' => '提示丰富字段配置',
        'ExternalUsers' => '外部用户',
        'ReportMaker' => 'AR',
        'DataSets' => 'DF',
        'CustomQueries' => '自定义查询',
        'pmse_Inbox' => 'Pr',
        'pmse_Project' => 'PD',
        'pmse_Business_Rules' => 'PB',
        'pmse_Emails_Templates' => 'PE',
        'BusinessCenters' => 'BC',
        'Shifts' => '转换',
        'ShiftExceptions' => '转换例外情况',
        'Purchases' => '购买',
        'PurchasedLineItems' => 'PL',
        'MobileDevices' => '移动设备',
        'PushNotifications' => '推送通知',
        'Escalations' => '升级',
        'DocumentTemplates' => '数据技术',
        'DocumentMerges' => '数据管理',
        'CloudDrivePaths' => 'CD',
        'WorkFlow' => 'WD',
        'EAPM' => 'EA',
        'Worksheet' => '工作表',
        'Users' => '用户',
        'Employees' => '员工',
        'Administration' => '管理',
        'ACLRoles' => 'Ro',
        'InboundEmail' => '收到的邮件',
        'Releases' => '发布',
        'Prospects' => 'Ta',
        'Queues' => '队列',
        'EmailMarketing' => '电子邮件营销',
        'EmailTemplates' => '电子邮件模板',
        'SNIP' => 'EA',
        'ProspectLists' => 'TL',
        'SavedSearch' => '保存的搜索',
        'UpgradeWizard' => '升级向导',
        'Trackers' => '跟踪器',
        'TrackerPerfs' => '跟踪器性能',
        'TrackerSessions' => '跟踪器会话',
        'TrackerQueries' => '跟踪器查询',
        'FAQ' => '常问问题',
        'Newsletters' => '时事通讯',
        'SugarFavorites' => '收藏夹',
        'PdfManager' => 'Pdf 经理',
        'DataArchiver' => '数据存档程序',
        'ArchiveRuns' => '存档运行',
        'OAuthKeys' => 'OC',
        'OAuthTokens' => 'OAuth 标记',
        'Filters' => '筛选器',
        'UserSignatures' => 'ES',
        'Shippers' => '发货人',
        'Styleguide' => '风格指南',
        'Feedbacks' => '反馈',
        'Tags' => '标签',
        'Categories' => '类别',
        'Dashboards' => 'Ds',
        'OutboundEmail' => 'ES',
        'EmailParticipants' => '向参与者发送电子邮件',
        'DataPrivacy' => 'DP',
        'ReportSchedules' => '报告时间表',
        'CommentLog' => '评论日志',
        'Holidays' => '假期',
        'ChangeTimers' => '更改计时器',
        'Metrics' => '指标',
        'Messages' => '消息',
        'Audit' => '审计',
        'RevenueLineItems' => '收入行项目',
        'DocuSignEnvelopes' => 'DS',
        'Geocode' => '地理编码',
        'DRI_Workflows' => 'SG',
        'DRI_Workflow_Task_Templates' => 'SG',
        'DRI_SubWorkflows' => 'SG',
        'DRI_Workflow_Templates' => 'SG',
        'CJ_WebHooks' => 'SA',
        'CJ_Forms' => 'SG',
        'DRI_SubWorkflow_Templates' => 'SG',
        'Library' => '文件库',
        'EmailAddresses' => '电子邮件地址',
        'Words' => '词语',
        'Sugar_Favorites' => '收藏夹',
        'KBDocuments' => 'KB',
        'KBContents' => 'KB',
        'KBArticles' => 'KB',
        'KBContentTemplates' => 'KB',
        'KBLocalizations' => 'Lo',
        'KBRevisions' => 'Re',
        'EmbeddedFiles' => '嵌入式文件',
    ],

    'moduleListSingular' => [
        'Home' => '首页',
        'Dashboards' => '仪表板',
        'Styleguide' => '设计指南',
        'Contacts' => '联系人',
        'Accounts' => '帐户',
        'Opportunities' => '商业机会',
        'Cases' => '客户反馈',
        'Notes' => '笔记',
        'Calls' => '电话',
        'Emails' => '电子邮件',
        'Meetings' => '会议',
        'Tasks' => '任务',
        'Calendar' => '日程安排',
        'Leads' => '潜在客户',
        'Manufacturers' => '制造商',
        'VisualPipeline' => '可视管道',
        'ConsoleConfiguration' => '控制台配置',
        'MobileDevices' => '移动设备',
        'SugarLive' => 'SugarLive',
        'Contracts' => '合同',
        'Quotes' => '报价',
        'Products' => '已报价单项',
        'ProductCategories' => '产品类别',
        'ProductBundles' => '产品包',
        'ProductBundleNotes' => '产品包记录',
        'RevenueLineItems' => '营收单项',
        'WebLogicHooks' => '网络逻辑钩',
        'Reports' => '报表',
        'Forecasts' => '预测',
        'ForecastWorksheets' => '预测工作表',
        'ForecastManagerWorksheets' => '预测经理工作表',
        'Quotas' => '定额',
        'Teams' => '团队',
        'TeamNotices' => '团队通知',
        'Activities' => '活动',
        'ActivityStream' => '活动流',
        'Bugs' => '错误',
        'Feeds' => 'RSS',
        'iFrames' => '我的网站',
        'TimePeriods' => '时段',
        'TaxRates' => '税率',
        'ContractTypes' => '合同类型',
        'Schedulers' => '计划任务',
        'Campaigns' => '市场活动',
        'CampaignLog' => '市场活动日志',
        'Project' => '项目',
        'ProjectTask' => '项目任务',
        'Prospects' => '目标',
        'ProspectLists' => '目标列表',
        'CampaignTrackers' => '市场活动跟踪器',
        'Documents' => '文档',
        'DocumentRevisions' => '文档修订',
        'Connectors' => '连接器',
        'Notifications' => '通知',
        'Sync' => '同步',
        'PdfManager' => 'PDF 经理',
        'DataArchiver' => '数据存档程序',
        'ArchiveRuns' => '归档运行',
        'ExternalUsers' => '外部用户',
        'ReportMaker' => '高级报表',
        'DataSets' => '数据格式',
        'CustomQueries' => '自定义查询',
        'pmse_Inbox' => '流程',
        'pmse_Project' => '流程定义',
        'pmse_Business_Rules' => '流程商务规则',
        'pmse_Emails_Templates' => '流程电子邮件模板',
        'BusinessCenters' => '业务中心',
        'Shifts' => '班次',
        'ShiftExceptions' => '班次异常',
        'Purchases' => '购买',
        'PurchasedLineItems' => '已购买单项',
        'PushNotifications' => '推送通知',
        'Escalations' => '升级',
        'DocumentTemplates' => '文档模板',
        'DocumentMerges' => '文档合并',
        'CloudDrivePaths' => '云驱动器路径',
        'WorkFlow' => '工作流',
        'EAPM' => '外部帐户',
        'Worksheet' => '工作表',
        'Users' => '用户',
        'SugarFavorites' => 'Sugar 收藏',
        'Employees' => '员工',
        'Administration' => '管理',
        'ACLRoles' => '角色',
        'InboundEmail' => '入站电子邮件',
        'Releases' => '发布版本',
        'Queues' => '队列',
        'EmailMarketing' => '电子邮件营销',
        'EmailTemplates' => '电子邮件模板',
        'SNIP' => '电子邮件归档',
        'SavedSearch' => '保存的搜索',
        'UpgradeWizard' => '升级向导',
        'Trackers' => '跟踪器',
        'TrackerPerfs' => '跟踪器表现',
        'TrackerSessions' => '跟踪器会话',
        'TrackerQueries' => '跟踪器查询',
        'FAQ' => '常见问题',
        'Newsletters' => '简讯',
        'OAuthKeys' => 'OAuth 用户密匙',
        'OAuthTokens' => '开放认证标记',
        'Filters' => '筛选器',
        'Comments' => '评论',
        'CommentLog' => '评论日志',
        'Currencies' => '货币',
        'ProductTemplates' => 'Product',
        'ProductTypes' => '产品类型',
        'Shippers' => '运输供应商',
        'Subscriptions' => '订阅',
        'UserSignatures' => '电子邮件签名',
        'Feedbacks' => '反馈',
        'Tags' => '标签',
        'Categories' => '类别：',
        'OutboundEmail' => '电子邮件设置',
        'EmailParticipants' => '电子邮件参与者',
        'DataPrivacy' => '数据隐私',
        'ReportSchedules' => '报告日程',
        'Holidays' => '假期',
        'ChangeTimers' => '更改计时器',
        'Metrics' => '量度数据',
        'Messages' => '消息',
        'Audit' => '审计',
        'DocuSignEnvelopes' => 'DocuSignEnvelope',
        'HintAccountsets' => 'HintAccountsets',
        'HintNotificationTargets' => 'HintNotificationTargets',
        'HintNewsNotifications' => 'HintNewsNotifications',
        'HintEnrichFieldConfigs' => 'HintEnrichFieldConfigs',
        'Geocode' => '地理编码',
        'DRI_Workflows' => '智能指南',
        'DRI_Workflow_Task_Templates' => '智能指南活动模板',
        'DRI_SubWorkflows' => '智能指南阶段',
        'DRI_Workflow_Templates' => '智能指南模板',
        'CJ_WebHooks' => 'Sugar Automate 网络钩子',
        'CJ_Forms' => 'Smart Guide Sugar 操作',
        'DRI_SubWorkflow_Templates' => '智能指南阶段模板',
        'PubSub_ModuleEvent_PushSubs' => '发布/订阅模块事件推送订阅',
    ],

    /*
 * @deprecated as of 7.2.0 since it is only used on massupdate in BWC mode.
 * @see `filter_checkbox_dom` and `checkbox_massupdate_dom` for sidecar-compatibility.
 */
    'checkbox_dom' => [
        '' => '',
        '1' => '是',
        '2' => '否',
    ],

    'checkbox_massupdate_dom' => [
        0 => '否',
        1 => '是',
    ],

    'notifications_status_dom' => [
        0 => '未读',
        1 => '已读',
    ],

    'optout_dom' => [
        '' => '-无-',
        'false' => '否',
        'true' => '是',
    ],

    //e.g. en français 'Analyst'=>'Analyste',
    'account_type_dom' => [
        '' => '',
        'Analyst' => '分析人士',
        'Competitor' => '竞争对手',
        'Customer' => '客户',
        'Integrator' => '整合商',
        'Investor' => '投资者',
        'Partner' => '合作伙伴',
        'Press' => '新闻',
        'Prospect' => '前景',
        'Reseller' => '经销商',
        'Other' => '其他',
    ],
    //e.g. en español 'Apparel'=>'Ropa',
    'industry_dom' => [
        '' => '',
        'Apparel' => '服装',
        'Banking' => '银行',
        'Biotechnology' => '生物技术',
        'Chemicals' => '化学化工',
        'Communications' => '通讯',
        'Construction' => '建筑',
        'Consulting' => '咨询',
        'Education' => '教育',
        'Electronics' => '电子',
        'Energy' => '能源',
        'Engineering' => '工程设计',
        'Entertainment' => '娱乐',
        'Environmental' => '环境',
        'Finance' => '金融',
        'Government' => '政府',
        'Healthcare' => '卫生保健',
        'Hospitality' => '酒店与款待',
        'Insurance' => '保险',
        'Machinery' => '机械',
        'Manufacturing' => '制造',
        'Media' => '媒体',
        'Not For Profit' => '非盈利',
        'Recreation' => '娱乐',
        'Retail' => '零售',
        'Shipping' => '海运',
        'Technology' => '技术',
        'Telecommunications' => '电信',
        'Transportation' => '运输',
        'Utilities' => '公共事业',
        'Other' => '其他',
    ],
    'file_type_dom' => [
        'PDF' => 'PDF',
        'CSV' => 'CSV',
        'PDF and CSV' => 'PDF 和 CSV',
    ],
    'embed_report_dom' => [
        '' => '',
        'Chart' => '图表',
        'Data Table' => '数据表',
        'Chart and Data Table' => '图表和数据表',
    ],
    'message_status_dom' => [
        '' => '',
        'In Progress' => '处理中',
        'Completed' => '已完成',
    ],
    'message_direction_dom' => [
        '' => '',
        'Inbound' => '收件箱',
        'Outbound' => '发件箱',
    ],
    'message_channel_type_dom' => [
        '' => '',
        'Chat' => '聊天',
    ],
    'service_level_dom' => [
        '' => '',
        'T1' => '第 1 级',
        'T2' => '第 2 级',
        'T3' => '第 3 级',
        'T4' => '第 4 级',
    ],
    'generate_purchase_dom' => [
        '' => '',
        'Yes' => '是',
        'No' => '否',
        'Completed' => '已完成',
    ],
    'purchased_line_items_status_dom' => [
        '' => '',
        'Future' => '未来',
        'Active' => '活动',
        'Past' => '过去',
    ],
    'aws_connect_identity_dom' => [
        'Connect' => 'Amazon Connect',
        'SAML' => 'SAML 2.0',
        // TODO - Active Directory Text
    ],
    'lead_source_default_key' => '自我生成',
    'lead_source_dom' => [
        '' => '',
        'Cold Call' => '冷电话',
        'Existing Customer' => '现有客户',
        'Self Generated' => '自我生成',
        'Employee' => '员工',
        'Partner' => '合作伙伴',
        'Public Relations' => '公共关系',
        'Direct Mail' => '直邮',
        'Conference' => '会议',
        'Trade Show' => '展览',
        'Web Site' => '网站',
        'Word of mouth' => '口碑',
        'Email' => '电子邮件',
        'Campaign' => '市场活动',
        'Support Portal User Registration' => '支持门户用户注册',
        'Other' => '其他',
    ],
    'metric_status_dom' => [
        'Inactive' => '不活动',
        'Active' => '活动',
    ],
    'opportunity_type_dom' => [
        '' => '',
        'Existing Business' => '现有业务',
        'New Business' => '新业务',
    ],
    'taxrate_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
    ],
    'roi_type_dom' => [
        'Revenue' => '收入',
        'Investment' => '投入',
        'Expected_Revenue' => '期望收益',
        'Budget' => '预算',

    ],
    //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
    'opportunity_relationship_type_default_key' => '主要决策人',
    'opportunity_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '主要决策人',
        'Business Decision Maker' => '业务决策人',
        'Business Evaluator' => '业务评估人',
        'Technical Decision Maker' => '技术决策人',
        'Technical Evaluator' => '技术评估人',
        'Executive Sponsor' => '管理层赞助人',
        'Influencer' => '影响者',
        'Other' => '其他',
    ],

    'manufacturer_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
    ],

    'shipper_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
    ],

    //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
    'case_relationship_type_default_key' => '主要联系人',
    'case_relationship_type_dom' => [
        '' => '',
        'Primary Contact' => '主要联系人',
        'Alternate Contact' => '其他联系人',
    ],
    'field_name_placement_dom' => [
        'field_on_side' => '字段值旁边',
        'field_on_top' => '字段值上方',
    ],
    'payment_terms' => [
        '' => '',
        'Net 15' => '货到 15 天付款',
        'Net 30' => '货到 30 天付款',
    ],
    'sales_stage_default_key' => '销售前景',
    'fts_type' => [
        'Elastic' => '弹性搜索',
    ],
    'fts_transport_list' => [
        'http' => 'http',
        'https' => 'https',
    ],
    'sales_stage_dom' => [
        'Prospecting' => '销售前景',
        'Qualification' => '资格',
        'Needs Analysis' => '需求分析',
        'Value Proposition' => '价值陈述',
        'Id. Decision Makers' => '辨识决策人',
        'Perception Analysis' => '看法分析',
        'Proposal/Price Quote' => '建议 / 出价',
        'Negotiation/Review' => '谈判 / 评估',
        'Closed Won' => '谈成结束',
        'Closed Lost' => '丢单结束',
    ],
    'sales_status_with_quote_dom' => [
        'New' => '新建',
        'In Progress' => '处理中',
        'Closed Won' => '谈成结束',
        'Closed Lost' => '丢单结束',
        'Converted to Quote' => '转换为报价',
    ],
    'sales_status_dom' => [
        'New' => '新建',
        'In Progress' => '处理中',
        'Closed Won' => '谈成结束',
        'Closed Lost' => '丢单结束',
    ],

    'commit_stage_binary_dom' => [
        'include' => '包含',
        'exclude' => '排除',
    ],
    'commit_stage_dom' => [
        'include' => '包含',
        'upside' => '提升',
        'exclude' => '排除',
    ],

    'commit_stage_custom_dom' => [
        'include' => '包含',
        'upside' => '提升',
        'exclude' => '排除',
    ],

    'in_total_group_stages' => [
        'Draft' => '草稿',
        'Negotiation' => '谈判',
        'Delivered' => '已交付',
        'On Hold' => '等候',
        'Confirmed' => '已确认',
        'Closed Accepted' => '谈成结束',
        'Closed Lost' => '丢单结束',
        'Closed Dead' => '未成结束',
    ],
    'sales_probability_dom' => // keys must be the same as sales_stage_dom
        [
            'Prospecting' => '10',
            'Qualification' => '20',
            'Needs Analysis' => '25',
            'Value Proposition' => '30',
            'Id. Decision Makers' => '40',
            'Perception Analysis' => '50',
            'Proposal/Price Quote' => '65',
            'Negotiation/Review' => '80',
            'Closed Won' => '100',
            'Closed Lost' => '0',
        ],
    'activity_dom' => [
        'Call' => '电话',
        'Meeting' => '会议',
        'Task' => '任务',
        'Email' => '电子邮件',
        'Note' => '笔记',
    ],
        'salutation_dom' => [
        '' => '',
        'Mr.' => '先生',
        'Ms.' => '女士',
        'Mrs.' => '夫人',
        'Dr.' => '博士',
        'Prof.' => '教授',
        'Mx.' => 'Mx。',
        ],
    //time is in seconds; the greater the time the longer it takes;
        'reminder_max_time' => 90000,
        'reminder_time_options' => [
        '-1' => '无',
        60 => '1 分钟之前',
        300 => '5 分钟之前',
        600 => '10 分钟之前',
        900 => '15 分钟之前',
        1800 => '30 分钟之前',
        3600 => '1 个小时之前',
        7200 => '2 个小时之前',
        10800 => '3 个小时之前',
        18000 => '5 个小时之前',
        86400 => '1 天之前',
        ],

        'task_priority_default' => '中',
        'task_priority_dom' => [
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'task_status_default' => '未开始',
        'task_status_dom' => [
        'Not Started' => '未开始',
        'In Progress' => '处理中',
        'Completed' => '完成',
        'Pending Input' => '待输入',
        'Deferred' => '改期',
        'Not Applicable' => '不适用',
        ],
        'meeting_status_default' => '已计划',
        'meeting_status_dom' => [
        'Planned' => '已安排',
        'Held' => '已完成',
        'Not Held' => '已取消',
        'Deferred' => '延期',
        ],
        'extapi_meeting_password' => [
        'WebEx' => 'WebEx',
        ],
        'meeting_type_dom' => [
        'Other' => '其他',
        'Sugar' => 'SugarCRM',
        ],
        'call_status_default' => '已计划',
        'call_status_dom' => [
        'Planned' => '已安排',
        'In Progress' => '进行中',
        'Held' => '已完成',
        'Not Held' => '已取消',
        'Deferred' => '延期',
        ],
        'call_direction_default' => '发件箱',
        'call_direction_dom' => [
        'Inbound' => '收件箱',
        'Outbound' => '发件箱',
        ],
        'lead_status_dom' => [
        '' => '',
        'New' => '新建',
        'Assigned' => '已分配',
        'In Process' => '处理中',
        'Converted' => '已转换的',
        'Recycled' => '已循环',
        'Dead' => '终结',
        ],
        'gender_list' => [
        'male' => '男性',
        'female' => '女性',
        'other' => '其他',
        ],
    //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
        'case_status_default_key' => '新建',
        'case_status_dom' => [
        'New' => '新建',
        'Assigned' => '已分配',
        'Closed' => '已关闭',
        'Pending Input' => '待输入',
        'Rejected' => '已拒绝',
        'Duplicate' => '复制',
        ],
        'case_priority_default_key' => 'P2',
        'case_priority_dom' => [
        'P1' => '高',
        'P2' => '中',
        'P3' => '低',
        ],
        'user_type_dom' => [
        'RegularUser' => '普通用户',
        'Administrator' => '管理员',
        ],
        'user_type_bool_dom' => [
            false => '普通用户',
            true => '管理员',
        ],
        'user_type_group_bool_dom' => [
            true => '组用户',
        ],
        'user_type_portal_bool_dom' => [
            true => '门户网站 API 用户',
        ],
        'license_type_dom' => [
        'CURRENT' => '现有产品',
        'SUGAR_SERVE' => 'Sugar 服务',
        'SUGAR_SELL' => 'Sugar 销售',
        ],
        'user_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
        ],
        'employee_status_dom' => [
        'Active' => '在职',
        'Terminated' => '离职',
        'Leave of Absence' => '请假',
        ],
        'messenger_type_dom' => [
        '' => '',
        'MSN' => 'MSN',
        'Yahoo!' => 'Yahoo!',
        'AOL' => 'AOL',
        ],
        'external_user_status_dom' => [
        'Active' => '活动的',
        'Inactive' => '不活动的',
        ],
        'project_task_priority_options' => [
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'project_task_priority_default' => '中',

        'project_task_status_options' => [
        'Not Started' => '未开始',
        'In Progress' => '处理中',
        'Completed' => '完成',
        'Pending Input' => '待输入',
        'Deferred' => '改期',
        ],
        'project_task_utilization_options' => [
        '0' => '无',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
        ],

        'project_status_dom' => [
        'Draft' => '草稿',
        'In Review' => '检查中',
        'Published' => '已发布',
        ],
        'project_status_default' => '草稿',

        'project_duration_units_dom' => [
        'Days' => '天',
        'Hours' => '小时',
        ],

        'project_priority_options' => [
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'project_priority_default' => '中',
    //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
        'record_type_default_key' => '帐户',
        'record_type_display' => [
        '' => '',
        'Accounts' => '帐户',
        'Opportunities' => '商业机会',
        'Cases' => '客户反馈',
        'Leads' => '潜在客户',
        'Contacts' => '联系人', // cn (11/22/2005) added to support Emails
        'Products' => '已报价单项',
        'Quotes' => '报价',
        'Bugs' => '错误',
        'Project' => '项目',

        'Prospects' => '目标',
        'ProjectTask' => '项目任务',

        'Tasks' => '任务',
        'KBContents' => '知识库',
        'Notes' => '笔记',
        ],

        'record_type_display_notes' => [
        'Accounts' => '帐户',
        'Contacts' => '联系人',
        'Opportunities' => '商业机会',
        'Tasks' => '任务',
        'ProductTemplates' => '产品目录',
        'Quotes' => '报价',
        'Products' => '已报价单项',
        'Contracts' => '合同',
        'Emails' => '电子邮件',

        'Bugs' => '错误',
        'Project' => '项目',
        'ProjectTask' => '项目任务',
        'Prospects' => '目标',
        'Cases' => '客户反馈',
        'Leads' => '潜在客户',

        'Meetings' => '会议',
        'Calls' => '电话',
        'KBContents' => '知识库',
        'PurchasedLineItems' => '已购买单项',
        'Purchases' => '购买',
        'Escalations' => '升级',
        ],
        'record_type_display_emailparticipants' => [
        'Accounts' => '账户',
        'Contacts' => '联系人',
        'Employees' => '员工',
        'Leads' => '潜在客户',
        'Prospects' => '目标',
        'Users' => '用户',
        ],

        'parent_type_display' => [
        'Accounts' => '帐户',
        'Contacts' => '联系人',
        'Tasks' => '任务',
        'Opportunities' => '商业机会',
        'Products' => '已报价单项',
        'Quotes' => '报价',

        'Bugs' => '缺陷',
        'Cases' => '客户反馈',
        'Leads' => '潜在客户',

        'Project' => '项目',
        'ProjectTask' => '项目任务',

        'Prospects' => '目标',
        'KBContents' => '知识库',
        'Notes' => '笔记',
        'PurchasedLineItems' => '已购买单项',
        'Purchases' => '购买',
        'Escalations' => '升级',
        ],

        'changetimer_parent_type' => [
        'Cases' => '客户反馈',
        ],

        'product_status_default_key' => '已交付',
        'product_status_quote_key' => '报价',
        'product_status_dom' => [
        '' => '',
        'Quotes' => '已报价',
        'Orders' => '已订购',
        'Ship' => '已发货',
        ],
        'active_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
        'Retired' => '已过期',
        ],
        'appearance_options' => [
        'system_default' => '使用系统设置',
        'light' => '光',
        'dark' => '暗',
        ],


        'pricing_formula_default_key' => '固定',
        'pricing_formula_dom' => [
        'Fixed' => '固定价格',
        'ProfitMargin' => '利润率',
        'PercentageMarkup' => '超过成本销价',
        'PercentageDiscount' => '折扣单价',
        'IsList' => '和单价相同',
        ],
        'product_template_status_dom' => [
        'Available' => '有库存',
        'Unavailable' => '已脱销',
        ],
        'tax_class_dom' => [
        'Taxable' => '有税的',
        'Non-Taxable' => '无税的',
        ],
        'support_term_dom' => [
        '+6 months' => '六个月',
        '+1 year' => '一年',
        '+2 years' => '二年',
        ],

        'quote_type_dom' => [
        'Quotes' => '报价',
        'Orders' => '排序',
        ],
        'default_quote_stage_key' => '草稿',
        'quote_stage_dom' => [
        'Draft' => '草稿',
        'Negotiation' => '谈判',
        'Delivered' => '已交付',
        'On Hold' => '等候',
        'Confirmed' => '已确认',
        'Closed Accepted' => '谈成结束',
        'Closed Lost' => '丢单结束',
        'Closed Dead' => '未成结束',
        ],
        'default_order_stage_key' => '未决定',
        'order_stage_dom' => [
        'Pending' => '未决定',
        'Confirmed' => '已确认',
        'On Hold' => '等候',
        'Shipped' => '已发货',
        'Cancelled' => '已取消',
        ],

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
        'quote_relationship_type_default_key' => '主要决策人',
        'quote_relationship_type_dom' => [
        '' => '',
        'Primary Decision Maker' => '主要决策人',
        'Business Decision Maker' => '业务决策人',
        'Business Evaluator' => '业务评估人',
        'Technical Decision Maker' => '技术决策人',
        'Technical Evaluator' => '技术评估人',
        'Executive Sponsor' => '管理层赞助人',
        'Influencer' => '影响者',
        'Other' => '其他',
        ],
        'layouts_dom' => [
        'Standard' => '报价',
        'Invoice' => '发票',
        ],
        'issue_priority_default_key' => '中',
        'issue_priority_dom' => [
        'Urgent' => '紧急',
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'issue_resolution_default_key' => '',
        'issue_resolution_dom' => [
        '' => '',
        'Accepted' => '已接受',
        'Duplicate' => '复制',
        'Closed' => '已关闭',
        'Out of Date' => '过期',
        'Invalid' => '无效',
        ],

        'issue_status_default_key' => '新建',
        'issue_status_dom' => [
        'New' => '新建',
        'Assigned' => '已分配',
        'Closed' => '已关闭',
        'Pending' => '未决定',
        'Rejected' => '已拒绝',
        ],

        'bug_priority_default_key' => '中',
        'bug_priority_dom' => [
        'Urgent' => '紧急',
        'High' => '高',
        'Medium' => '中',
        'Low' => '低',
        ],
        'bug_resolution_default_key' => '',
        'bug_resolution_dom' => [
        '' => '',
        'Accepted' => '已接受',
        'Duplicate' => '复制',
        'Fixed' => '固定',
        'Out of Date' => '过期',
        'Invalid' => '无效',
        'Later' => '以后',
        ],
        'bug_status_default_key' => '新建',
        'bug_status_dom' => [
        'New' => '新建',
        'Assigned' => '已分配',
        'Closed' => '已关闭',
        'Pending' => '未决定',
        'Rejected' => '已拒绝',
        ],
        'bug_type_default_key' => '错误',
        'bug_type_dom' => [
        'Defect' => '缺陷',
        'Feature' => '特征',
        ],
        'case_type_dom' => [
        'Administration' => '管理',
        'Product' => '产品',
        'User' => '用户',
        ],
        'source_default_key' => '',
        'source_dom' => [
        '' => '',
        'Internal' => '内部',
        'Forum' => '论坛',
        'Web' => '网络',
        'InboundEmail' => '电子邮件',
        'Twitter' => 'Twitter',
        'Portal' => '门户',
        ],
        'cases_source_dom' => [
        '' => '',
        'Internal' => '内部',
        'Forum' => '论坛',
        'Web' => '网络',
        'InboundEmail' => '电子邮件',
        'Twitter' => 'Twitter',
        'Portal' => '门户',
        'Phone' => '电话',
        'Chat' => '聊天',
        'Chatbot' => '聊天机器人',
        ],
        'dataprivacy_type_default_key' => '',
        'dataprivacy_type_dom' => [
        '' => '',
        'Request for Data Privacy Policy' => '索取数据隐私政策',
        'Send Personal Information being processed' => '发送正在处理的个人信息',
        'Rectify Information' => '改正信息',
        'Request to Erase Information' => '请求删除信息',
        'Export Information' => '导出信息',
        'Restrict Processing' => '限制处理',
        'Object to Processing' => '拒绝处理',
        'Consent to Process' => '同意处理',
        'Withdraw Consent' => '撤消同意',
        'Other' => '其他',
        ],
        'dataprivacy_business_purpose_dom' => [
        'Business Communications' => '商业通讯',
        'Marketing Communications by company' => '公司的市场营销通讯',
        'Marketing Communications by partners' => '合作伙伴的市场营销通讯',
        ],
        'dataprivacy_status_default_key' => '已开放',
        'dataprivacy_status_dom' => [
        'Open' => '已开放',
        'Closed' => '已完成',
        'Rejected' => '已拒绝',
        ],
        'dataprivacy_priority_default_key' => '低',
        'dataprivacy_priority_dom' => [
        'Low' => '低',
        'Medium' => '中',
        'High' => '高',
        ],
        'business_day_status_dom' => [
        'Open' => '已开放',
        'Open 24 Hours' => '24 小时开放',
        'Closed' => '已关闭',
        ],
        'product_category_default_key' => '',
        'product_category_dom' => [
        '' => '',
        'Accounts' => '帐户',
        'Activities' => '活动',
        'Bug Tracker' => '缺陷跟踪',
        'Calendar' => '日程安排',
        'Calls' => '电话',
        'Campaigns' => '市场活动',
        'Cases' => '客户反馈',
        'Contacts' => '联系人',
        'Currencies' => '货币',
        'Dashboard' => '仪表板',
        'Documents' => '文档',
        'Emails' => '电子邮件',
        'Feeds' => '订阅',
        'Forecasts' => '预测',
        'Help' => '帮助',
        'Home' => '首页',
        'Leads' => '潜在客户',
        'Meetings' => '会议',
        'Notes' => '笔记',
        'Opportunities' => '商业机会',
        'Outlook Plugin' => 'Outlook 插件',
        'Product Catalog' => '产品目录',
        'Products' => '已报价单项',
        'RevenueLineItems' => '营收单项',
        'Projects' => '项目',
        'Quotes' => '报价',
        'Releases' => '发布版本',
        'RSS' => 'RSS',
        'Studio' => '工作室',
        'Upgrade' => '升级',
        'Users' => '用户',
        'OutboundEmail' => '电子邮件设置',
        ],
    /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
        'campaign_status_dom' => [
        '' => '',
        'Planning' => '计划中',
        'Active' => '在职',
        'Inactive' => '停用',
        'Complete' => '完成',
        'In Queue' => '队列中',
        'Sending' => '发送中',
        ],
        'campaign_type_dom' => [
        '' => '',
        'Telesales' => '电话行销',
        'Mail' => '邮件',
        'Email' => '电子邮件',
        'Print' => '打印',
        'Web' => '网络',
        'Radio' => '单选框',
        'Television' => '电视',
        'NewsLetter' => '简讯',
        ],
        'web_to_lead_redirect_type_dom' => [
        'GET' => 'GET',
        'POST' => 'POST',
        ],
        'newsletter_frequency_dom' => [
        '' => '',
        'Weekly' => '每星期',
        'Monthly' => '每月',
        'Quarterly' => '每季度',
        'Annually' => '每年',
        ],

        'notifymail_sendtype' => [
        'SMTP' => 'SMTP',
        ],
        'dom_cal_month_long' => [
        '0' => '',
        '1' => '1 月',
        '2' => '2 月',
        '3' => '3 月',
        '4' => '4 月',
        '5' => '5 月',
        '6' => '6 月',
        '7' => '7 月',
        '8' => '8 月',
        '9' => '9 月',
        '10' => '10 月',
        '11' => '11 月',
        '12' => '12 月',
        ],
        'dom_cal_month_short' => [
        '0' => '',
        '1' => '1 月',
        '2' => '2 月',
        '3' => '3 月',
        '4' => '4 月',
        '5' => '5 月',
        '6' => '6 月',
        '7' => '7 月',
        '8' => '8 月',
        '9' => '9 月',
        '10' => '10 月',
        '11' => '11 月',
        '12' => '12 月',
        ],
        'dom_cal_day_long' => [
        '0' => '',
        '1' => '星期日',
        '2' => '星期一',
        '3' => '星期二',
        '4' => '星期三',
        '5' => '星期四',
        '6' => '星期五',
        '7' => '星期六',
        ],
        'dom_cal_day_short' => [
        '0' => '',
        '1' => '星期日',
        '2' => '星期一',
        '3' => '星期二',
        '4' => '星期三',
        '5' => '星期四',
        '6' => '星期五',
        '7' => '星期六',
        ],
        'dom_cal_day_min' => [
        '0' => '',
        '1' => '周日',
        '2' => '周一',
        '3' => '周二',
        '4' => '周三',
        '5' => '周四',
        '6' => '周五',
        '7' => '周六',
        ],
        'dom_cal_day_of_week' => [
        '0' => '星期日',
        '1' => '星期一',
        '2' => '星期二',
        '3' => '星期三',
        '4' => '星期四',
        '5' => '星期五',
        '6' => '星期六',
        ],
        'dom_meridiem_lowercase' => [
        'am' => '上午',
        'pm' => '下午',
        ],
        'dom_meridiem_uppercase' => [
        'AM' => '上午',
        'PM' => '下午',
        ],

        'dom_report_types' => [
        'tabular' => '行与列',
        'summary' => '合计',
        'detailed_summary' => '合计（附明细）',
        'Matrix' => '报表',
        ],


        'dom_email_types' => [
        'out' => '已发送',
        'archived' => '已存档',
        'draft' => '草稿',
        'inbound' => '收件箱',
        'campaign' => '市场活动',
        ],
        'dom_email_status' => [
        'archived' => '已存档',
        'closed' => '已关闭',
        'draft' => '草稿',
        'read' => '已读',
        'replied' => '已回复',
        'sent' => '已发送',
        'send_error' => '发送错误',
        'unread' => '未读',
        ],
        'dom_email_archived_status' => [
        'archived' => '已存档',
        ],

        'dom_email_server_type' => ['' => '--无--',
        'imap' => 'IMAP',
        ],
        'dom_mailbox_type' => [/*''           => '--None Specified--',*/
        'pick' => '--无--',
        'createcase' => '新增客户反馈',
        'bounce' => '退信处理',
        ],
        'dom_email_distribution' => ['' => '--无--',
        'direct' => '直接指派',
        'roundRobin' => '循环',
        'leastBusy' => '最少忙碌',
        ],
        'dom_email_distribution_for_auto_create' => ['roundRobin' => '循环',
        'leastBusy' => '最少忙碌',
        'none' => '无',
        ],
        'dom_email_errors' => [1 => '直接指派项目时只能选择一个用户。',
        2 => '直接指派项目时只能指派选择的项目。',
        ],
        'dom_email_bool' => ['bool_true' => '是',
        'bool_false' => '否',
        ],
        'dom_int_bool' => [1 => '是',
        0 => '否',
        ],
        'dom_switch_bool' => ['on' => '是',
        'off' => '否',
        '' => '否',],

        'dom_email_link_type' => ['sugar' => 'Sugar 邮件客户端',
        'mailto' => '外部邮件客户端'],


        'dom_email_editor_option' => ['' => '默认电子邮件格式',
        'html' => 'HTML 电子邮件',
        'plain' => '纯文本电子邮件'],

        'schedulers_times_dom' => ['not run' => '超时, 没有被执行',
        'ready' => '就绪',
        'in progress' => '处理中',
        'failed' => '失败',
        'completed' => '完成',
        'no curl' => '未运行：没有可利用的 cURL',
        ],

        'dom_email_states' => [
        'Draft' => '草稿',
        'Archived' => '已存档',
        ],

        'dom_email_direction' => [
        'Unknown' => '未知',
        'Outbound' => '发件箱',
        'Inbound' => '收件箱',
        'Internal' => '内部',
        ],

        'scheduler_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
        ],

        'scheduler_period_dom' => [
        'min' => '分钟',
        'hour' => '小时',
        ],
        'forecast_type_dom' => [
        'Direct' => '直接',
        'Rollup' => '汇总',
        ],
        'document_category_dom' => [
        '' => '',
        'Marketing' => '市场营销',
        'Knowledge Base' => '知识库',
        'Sales' => '销售',
        ],

        'document_subcategory_dom' => [
        '' => '',
        'Marketing Collateral' => '营销资料',
        'Product Brochures' => '产品手册',
        'FAQ' => '常见问题',
        ],

        'document_status_dom' => [
        'Active' => '在职',
        'Draft' => '草稿',
        'FAQ' => '常见问题',
        'Expired' => '失效',
        'Under Review' => '审查中',
        'Pending' => '未决定',
        ],
        'document_template_type_dom' => [
        '' => '',
        'mailmerge' => '邮件合并',
        'eula' => '最终用户许可协议',
        'nda' => '保密协议',
        'license' => '许可证协议',
        ],
        'dom_meeting_accept_options' => [
        'accept' => '接受',
        'decline' => '回拒',
        'tentative' => '暂时',
        ],
        'dom_meeting_accept_status' => [
        'accept' => '已接受',
        'decline' => '回拒',
        'tentative' => '暂时',
        'none' => '无',
        ],
        'dataset_output_default_dom' => [
        'table' => '表',
        ],
        'report_maker_status_dom' => [
        'Single Module' => '单个模块',
        'Multi Module' => '多个模块',
        ],
        'report_align_dom' => [
        'left' => '左边',
        'center' => '居中',
        'right' => '右边',
        ],

        'width_type_dom' => [
        '%' => '百分比 (%)',
        'px' => '像素 (px)',
        ],
        'report_color_dom' => [
        '' => '默认',
        'black' => '黑色',
        'green' => '绿色',
        'blue' => '蓝色',
        'red' => '红色',
        'white' => '白色',
        'DarkGreen' => '深绿',
        'LightGray' => '淡灰色',
        'DodgerBlue' => '宝蓝色',
        'LightBlue' => '淡蓝色',
        ],
        'font_size_dom' => [
        '-5' => '较小 (-5)',
        '-4' => '较小 (-4)',
        '-3' => '较小 (-3)',
        '-2' => '较小 (-2)',
        '-1' => '较小 (-1)',
        'Default' => '默认',
        '1' => '较大 (+1)',
        '2' => '较大 (+2)',
        '3' => '较大 (+3)',
        '4' => '较大 (+4)',
        '5' => '较大 (+5)',
        ],
        'query_type_dom' => [
        'Main Query' => '主查询',
//  'Sub Query' => 'Sub Query',
//  'Reverse Sub Query' => 'Reverse Sub Query',
        ],
        'query_column_type_dom' => [
        'Display' => '显示',
//  'Group By' => 'Group By',
        'Calculation' => '计算',
        ],
        'query_display_type_dom' => [
        'Default' => '默认',
        'Custom' => '自定义',
        'Hidden' => '隐藏',
        ],

        'query_groupby_qualifier_dom' => [
        'Day' => '天',
        'Week' => '周',
        'Month' => '月',
        'Quarter' => '季度',
        'Year' => '年',
        ],

        'query_groupby_qualifier_qty_dom' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        '12' => '12',
        '18' => '18',
        '24' => '24',
        ],

        'query_groupby_qualifier_start_dom' => [
        '0' => '现在',
        '-1' => '-1',
        '-2' => '-2',
        '-3' => '-3',
        '-4' => '-4',
        '-5' => '-5',
        '-6' => '-6',
        '-7' => '-7',
        '-8' => '-8',
        '-9' => '-9',
        '-10' => '-10',
        '-12' => '-12',
        '-18' => '-18',
        '-24' => '-24',
        ],
        'query_groupby_calc_type_dom' => [
        'SUM' => '总数',
        'AVG' => '平均',
        'COUNT' => '计数',
        'STDDEV' => '标准偏差',
        'VARIANCE' => '差异',
//  'Custom' => 'Custom',
        ],
        'query_groupby_type_dom' => [
        'Field' => '标准字段',
        'Time' => '时间间隔',
//  'Custom' => 'Custom Group By',
        ],

        'query_groupby_axis_dom' => [
        'Rows' => '行 (Y-轴)',
        'Columns' => '列 (X-轴)',
        ],

        'query_calc_calc_type_dom' => [
        'SUM' => '总数',
        'AVG' => '平均',
        'MAX' => '最大',
        'MIN' => '最小',
        'COUNT' => '计数',
        'STDDEV' => '标准偏差',
        'VARIANCE' => '差异',
        ],
        'query_calc_type_dom' => [
        'Standard' => '标准',
//  'Sub-Query' => 'Sub Query',
        'Math' => '数学计算',
        ],

        'query_calc_leftright_type_dom' => [
        'Field' => '字段',
        'Value' => '值',
        'Group' => '组',
        ],


        'dataset_layout_type_dom' => [
        'Column' => '列',
        //'Row' => 'Row',
        ],

        'custom_layout_dom' => [
        'Disabled' => '禁用',
        'Enabled' => '已启用',
        ],
        'dataset_att_display_type_dom' => [
        'Normal' => '正常',
        'Scalar' => '标量',
        ],
        'dataset_att_format_type_dom' => [
        'Text' => '文本',
        'Accounting' => '会计',
        'Date' => '日期',
        'Datetime' => '日期时间',
        ],
        'dataset_att_format_type_scalar_dom' => [
        'Year' => '年',
        'Quarter' => '季度',
        'Month' => '月',
        'Week' => '周',
        'Day' => '天',
        ],
        'dataset_style_dom' => [
        'normal' => '正常',
        'bold' => '粗体',
        'italic' => '斜体',
        ],

        'query_calc_oper_dom' => [
        '+' => '(+) 加',
        '-' => '(-) 减',
        '*' => '(X) 乘',
        '/' => '(/) 除',
        ],
        'wflow_type_dom' => [
        'Normal' => '记录保存后',
        'Time' => '时间过去后',
        ],
        'mselect_type_dom' => [
        'Equals' => '是',
        'in' => '其中之一',
        ],
        'mselect_multi_type_dom' => [
        'in' => '其中之一',
        'not_in' => '不是其中之一',
        ],
        'cselect_type_dom' => [
        'Equals' => '等于',
        'Does not Equal' => '不等于',
        ],
        'dselect_type_dom' => [
        'Equals' => '等于',
        'Less Than' => '少于',
        'More Than' => '多于',
        'Does not Equal' => '不等于',
        ],
        'bselect_type_dom' => [
        'bool_true' => '是',
        'bool_false' => '否',
        ],
        'bopselect_type_dom' => [
        'Equals' => '等于',
        ],
        'tselect_type_dom' => [
        '0' => '0 小时',
        '14440' => '4 小时',
        '28800' => '8 小时',
        '43200' => '12 小时',
        '86400' => '1 天',
        '172800' => '2 天',
        '259200' => '3 天',
        '345600' => '4 天',
        '432000' => '5 天',
        '604800' => '1 周',
        '1209600' => '2 周',
        '1814400' => '3 周',
        '2592000' => '30 天',
        '5184000' => '60 天',
        '7776000' => '90 天',
        '10368000' => '120 天',
        '12960000' => '150 天',
        '15552000' => '180 天',
        ],
        'dtselect_type_dom' => [
        'More Than' => '多于',
        'Less Than' => '小于',
        ],
        'wflow_alert_type_dom' => [
        'Email' => '电子邮件',
        'Invite' => '邀请',
        ],
        'wflow_source_type_dom' => [
        'Normal Message' => '正常消息',
        'Custom Template' => '自定义模板',
        'System Default' => '系统默认',
        ],
        'wflow_user_type_dom' => [
        'current_user' => '当前用户',
        'rel_user' => '相关用户',
        'rel_user_custom' => '相关自定义用户',
        'specific_team' => '指定团队',
        'specific_role' => '指定角色',
        'specific_user' => '指定用户',
        ],
        'wflow_array_type_dom' => [
        'future' => '新值',
        'past' => '旧值',
        ],
        'wflow_relate_type_dom' => [
        'Self' => '用户',
        'Manager' => "用户的经理",
        ],
        'wflow_address_type_dom' => [
        'to' => '收件人：',
        'cc' => '抄送：',
        'bcc' => '密件抄送：',
        ],
        'wflow_address_type_invite_dom' => [
        'to' => '收件人：',
        'cc' => '抄送：',
        'bcc' => '密件抄送：',
        'invite_only' => '(仅邀请)',
        ],
        'wflow_address_type_to_only_dom' => [
        'to' => '收件人：',
        ],
        'wflow_action_type_dom' => [
        'update' => '更新记录',
        'update_rel' => '更新相关记录',
        'new' => '新增记录',
        ],
        'wflow_action_datetime_type_dom' => [
        'Triggered Date' => '触发日期',
        'Existing Value' => '已有值',
        ],
        'wflow_set_type_dom' => [
        'Basic' => '基本选项',
        'Advanced' => '高级选项',
        ],
        'wflow_adv_user_type_dom' => [
        'assigned_user_id' => '被分配触发记录的用户',
        'modified_user_id' => '最后修改触发记录的用户',
        'created_by' => '创建触发记录的用户',
        'current_user' => '当前用户',
        ],
        'wflow_adv_team_type_dom' => [
        'team_id' => '当前触发记录的团队',
        'team_set_id' => '触发记录的当前团队集',
        'current_team' => '已登录用户的团队',
        ],
        'wflow_adv_enum_type_dom' => [
        'retreat' => '向后移动下拉框通过',
        'advance' => '向前移动下拉框通过',
        ],
        'wflow_record_type_dom' => [
        'All' => '新增和更新记录',
        'New' => '仅新增记录',
        'Update' => '仅更新记录',
        ],
        'wflow_rel_type_dom' => [
        'all' => '所有相关的',
        //'first' => 'The first related',
        'filter' => '筛选相关的',
        ],
        'wflow_relfilter_type_dom' => [
        'all' => '所有相关的',
        'any' => '任何有相关的',
        ],
        'wflow_fire_order_dom' => ['alerts_actions' => '警告后行动',
        'actions_alerts' => '行动后警告'],


        'duration_intervals' => ['0' => '00',
        '15' => '15',
        '30' => '30',
        '45' => '45'],

        'repeat_type_dom' => [
        '' => '无',
        'Daily' => '每天',
        'Weekly' => '每星期',
        'Monthly' => '每月',
        'Yearly' => '每年',
        ],

        'repeat_intervals' => [
        '' => '',
        'Daily' => '天',
        'Weekly' => '周',
        'Monthly' => '月',
        'Yearly' => '年',
        ],

        'repeat_end_types' => [
        'Until' => '直到',
        'Occurrences' => '出现',
        ],

        'duration_hours_intervals' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        ],

        'repeat_interval_number' => [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        17 => '17',
        18 => '18',
        19 => '19',
        20 => '20',
        21 => '21',
        22 => '22',
        23 => '23',
        24 => '24',
        25 => '25',
        26 => '26',
        27 => '27',
        28 => '28',
        29 => '29',
        30 => '30',
        31 => '31',
        32 => '32',
        33 => '33',
        34 => '34',
        35 => '35',
        36 => '36',
        37 => '37',
        38 => '38',
        39 => '39',
        40 => '40',
        41 => '41',
        42 => '42',
        43 => '43',
        44 => '44',
        45 => '45',
        46 => '46',
        47 => '47',
        48 => '48',
        49 => '49',
        50 => '50',
        51 => '51',
        52 => '52',
        53 => '53',
        54 => '54',
        55 => '55',
        56 => '56',
        57 => '57',
        58 => '58',
        59 => '59',
        60 => '60',
        61 => '61',
        62 => '62',
        63 => '63',
        64 => '64',
        65 => '65',
        66 => '66',
        67 => '67',
        68 => '68',
        69 => '69',
        70 => '70',
        71 => '71',
        72 => '72',
        73 => '73',
        74 => '74',
        75 => '75',
        76 => '76',
        77 => '77',
        78 => '78',
        79 => '79',
        80 => '80',
        81 => '81',
        82 => '82',
        83 => '83',
        84 => '84',
        85 => '85',
        86 => '86',
        87 => '87',
        88 => '88',
        89 => '89',
        90 => '90',
        91 => '91',
        92 => '92',
        93 => '93',
        94 => '94',
        95 => '95',
        96 => '96',
        97 => '97',
        98 => '98',
        99 => '99',
        ],

        'repeat_selector_dom' => [
        'None' => '无',
        'Each' => '每个',
        'On' => '于',
        ],

        'repeat_ordinal_dom' => [
        'first' => '第一',
        'second' => '第二',
        'third' => '第三',
        'fourth' => '第四',
        'fifth' => '第五',
        'last' => '最后',
        ],

        'repeat_unit_dom' => [
        'Sun' => '星期日',
        'Mon' => '星期一',
        'Tue' => '星期二',
        'Wed' => '星期三',
        'Thu' => '星期四',
        'Fri' => '星期五',
        'Sat' => '星期六',
        'Day' => '天',
        'WD' => '工作日',
        'WE' => '周末',
        ],

        'duration_dom' => [
        '' => '无',
        '900' => '15分钟',
        '1800' => '30分钟',
        '2700' => '45分钟',
        '3600' => '1小时',
        '5400' => '1.5 小时',
        '7200' => '2小时',
        '10800' => '3小时',
        '21600' => '6小时',
        '86400' => '1 天',
        '172800' => '2 天',
        '259200' => '3 天',
        '604800' => '1 周',
        ],
        'repeat_month_dom' => [
        '1' => '1 月',
        '2' => '2 月',
        '3' => '3 月',
        '4' => '4 月',
        '5' => '5 月',
        '6' => '6 月',
        '7' => '7 月',
        '8' => '8 月',
        '9' => '9 月',
        '10' => '10 月',
        '11' => '11 月',
        '12' => '12 月',
        ],

// deferred
    /*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Users',
    'Teams' => 'Teams',
    'Mailbox' => 'Mailbox',
),
*/
//prospect list type dom
        'prospect_list_type_dom' => [
        'default' => '默认',
        'seed' => '种子',
        'exempt_domain' => '阻止列表 – 根据域',
        'exempt_address' => '阻止列表 – 根据电子邮件地址',
        'exempt' => '阻止列表 – 根据编号',
        'test' => '测试',
        ],
        'currency_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
        ],
        'email_settings_num_dom' => [
        '10' => '10',
        '20' => '20',
        '50' => '50',
        ],
        'email_marketing_status_dom' => [
        '' => '',
        'active' => '在职',
        'inactive' => '停用',
        ],

        'campainglog_activity_type_dom' => [
        '' => '',
        'targeted' => '发送消息/尝试发送',
        'send error' => '退信，其它',
        'invalid email' => '退信，无效的邮箱',
        'link' => '点击链接',
        'viewed' => '已查看的信息',
        'removed' => '选择退出',
        'lead' => '已创建的潜在客户',
        'contact' => '现有联系人',
        'blocked' => '禁止的邮件地址或域',
        ],

        'campainglog_target_type_dom' => [
        'Contacts' => '联系人',
        'Users' => '用户',
        'Prospects' => '目标',
        'Leads' => '潜在客户',
        'Accounts' => '帐户',
        ],
        'merge_operators_dom' => [
        'like' => '包括',
        'exact' => '准确匹配',
        'start' => '开始于',
        ],

        'custom_fields_importable_dom' => [
        'true' => '是',
        'false' => '否',
        'required' => '必填项',
        ],

        'fts_field_config' => [
        '0' => '禁用',
        '2' => '可搜索的',
        ],

        'custom_fields_merge_dup_dom' => [
        0 => '禁用',
        1 => '已启用',
        2 => '在筛选',
        3 => '默认选择的筛选',
        4 => '只筛选',
        ],

        'navigation_paradigms' => [
        'm' => '模块',
        'gm' => '分组模块',
        ],

    // Contracts module enums

        'contract_status_dom' => [
        'notstarted' => '未开始',
        'inprogress' => '处理中',
        'signed' => '已签署',
        ],

        'contract_payment_frequency_dom' => [
        'monthly' => '每月',
        'quarterly' => '每季度',
        'halfyearly' => '每半年',
        'yearly' => '每年',
        ],

        'contract_expiration_notice_dom' => [
        '1' => '1 天',
        '3' => '3 天',
        '5' => '5 天',
        '7' => '1 周',
        '14' => '2 周',
        '21' => '3 周',
        '31' => '1 个月',
        ],
        'projects_priority_options' => [
        'high' => '高',
        'medium' => '中',
        'low' => '低',
        ],

        'projects_status_options' => [
        'notstarted' => '未开始',
        'inprogress' => '处理中',
        'completed' => '完成',
        ],
    // strings to pass to Flash charts
        'chart_strings' => [
        'expandlegend' => '打开图例',
        'collapselegend' => '关闭图例',
        'clickfordrilldown' => '单击获取更多信息',
        'drilldownoptions' => '获取何种信息',
        'detailview' => '更多细节...',
        'piechart' => '饼状图表',
        'groupchart' => '图表组',
        'stackedchart' => '图表栈',
        'barchart' => '柱状图表',
        'horizontalbarchart' => '水平柱状图表',
        'linechart' => '线状图表',
        'noData' => '无效数据',
        'print' => '打印',
        'pieWedgeName' => '段',
        ],
        'chart_types' => [
        'hBarF' => '水平柱（叠加）',
        'hGBarF' => '水平柱（分组）',
        'vBarF' => '垂直柱（叠加）',
        'vGBarF' => '垂直柱（分组）',
        'pieF' => '饼图',
        'funnelF' => '漏斗形图',
        'lineF' => '线图',
        'donutF' => '圆环',
        'treemapF' => '树形图',
        ],
        'd3_value_placement' => [
        '0' => '无',
        '1' => '默认',
        'start' => '开始',
        'middle' => '中阶段',
        'end' => '结束',
        'top' => '顶部',
        'total' => '总计',
        ],
        'pipeline_chart_dom' => [
        'fun' => '漏斗形图',
        'hbar' => '水平柱',
        ],
        'release_status_dom' => [
        'Active' => '在职',
        'Inactive' => '停用',
        ],
        'email_settings_for_ssl' => [
        '0' => '无',
        '1' => 'SSL',
        '2' => 'TLS',
        ],
        'mail_smtptype_options' => [
        'google_oauth2' => 'Google',
        'exchange_online' => 'Exchange Online',
        'outlook' => 'Outlook',
        'google' => 'Google Less Secure 应用程序',
        'exchange' => 'Exchange',
        'other' => '其他',
        ],
        'dom_imaptype_options' => [
        'google_oauth2' => 'Google Mail',
        'exchange_online' => 'Exchange Online',
        'other' => '其他',
        ],
        'import_enclosure_options' => [
        '&#39;' => '单引号 (&#39;)',
        '"' => '双引号 (")',
        '' => '无',
        'other' => '其他：',
        ],
        'import_delimeter_options' => [
        ',' => ',',
        ';' => ';',
        '\t' => '\t',
        '.' => '。',
        ':' => ':',
        '|' => '|',
        'other' => '其他：',
        ],
        'link_target_dom' => [
        '_blank' => '新窗口',
        '_self' => '同一窗口',
        ],
        'dashlet_auto_refresh_options' => [
        '-1' => '不要自动刷新',
        '30' => '每隔 30 秒',
        '60' => '每隔 1 分钟',
        '180' => '每隔 3 分钟',
        '300' => '每隔 5 分钟',
        '600' => '每隔 10 分钟',
        ],
        'sugar7_dashlet_reports_auto_refresh_options' => [
        '0' => '无',
        '15' => '每隔 15 分钟',
        '30' => '每隔 30 分钟',
        '45' => '每隔 45 分钟',
        '60' => '每隔 1 小时',
        '120' => '每隔 2 小时',
        ],
        'dashlet_auto_refresh_options_admin' => [
        '-1' => '从不',
        '30' => '每隔 30 秒',
        '60' => '每隔 1 分钟',
        '180' => '每隔 3 分钟',
        '300' => '每隔 5 分钟',
        '600' => '每隔 10 分钟',
        ],
        'sugar7_dashlet_auto_refresh_options' => [
        '0' => '无',
        '1' => '每隔 1 分钟',
        '5' => '每隔 5 分钟',
        '10' => '每隔 10 分钟',
        '15' => '每隔 15 分钟',
        '30' => '每隔 30 分钟',
        ],
        'dashlet_limit_options' => [
        5 => 5,
        10 => 10,
        15 => 15,
        20 => 20,
        ],
        'dashlet_webpage_limit_options' => [
        1 => 1,
        3 => 3,
        5 => 5,
        10 => 10,
        ],
        'default_currency_significant_digits_dom' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6,
        ],
        'date_range_search_dom' => [
        '=' => '等于',
        'not_equal' => '不在',
        'greater_than' => '后',
        'less_than' => '前',
        'last_7_days' => '最近 7 天',
        'next_7_days' => '未来 7 天',
        'last_30_days' => '最近 30 天',
        'next_30_days' => '未来 30 天',
        'last_month' => '上个月',
        'this_month' => '本月',
        'next_month' => '下个月',
        'last_year' => '去年',
        'this_year' => '今年',
        'next_year' => '明年',
        'between' => '之间',
        ],
        'date_range_operator_dom' => [
        'last_year' => '去年',
        'last_month' => '上个月',
        'last_30_days' => '最近 30 天',
        'last_7_days' => '最近 7 天',
        'this_month' => '本月',
        'this_year' => '今年',
        'next_7_days' => '未来 7 天',
        'next_30_days' => '未来 30 天',
        'next_month' => '下个月',
        'next_year' => '明年',
        ],
        'numeric_range_search_dom' => [
        '=' => '等于',
        'not_equal' => '不等于',
        'greater_than' => '大于',
        'greater_than_equals' => '大于或等于',
        'less_than' => '少于',
        'less_than_equals' => '少于或等于',
        'between' => '之间',
        ],

        'filter_checkbox_dom' => [
        0 => '不确实',
        1 => '确实',
        ],

        'opportunity_metrics_dom' => [
        'won' => '谈成',
        'lost' => '丢单',
        'active' => '在职',
        ],

        'sweetspot_theme_options' => [
        'default' => '默认',
        'light' => '淡',
        'dark' => '深',
        ],
        'repeat_days_dom' => [
        [1, 8, 15, 22, 29],
        [2, 9, 16, 23, 30],
        [3, 10, 17, 24, 31],
        [4, 11, 18, 25],
        [5, 12, 19, 26],
        [6, 13, 20, 27],
        [7, 14, 21, 28],
        ],
        'lead_conv_activity_opt' => [
        'move' => '移动',
        'donothing' => '不操作',
        ],
        'processes_auto_save_interval' => [
        0 => '从不',
        30000 => '每 30 秒',
        60000 => '每 1 分钟',
        120000 => '每 2 分钟',
        180000 => '每 3 分钟',
        240000 => '每 4 分钟',
        300000 => '每 5 分钟',
        ],
        'first_response_met_sla_dom' => [
        '' => '',
        'Yes' => '是',
        'No' => '否',
        ],
        'aws_end_chat_button_height' => [
        '30' => '30',
        '35' => '35',
        '40' => '40',
        '45' => '45',
        ],
        'aws_end_chat_button_width' => [
        '100' => '100',
        '110' => '110',
        '120' => '120',
        '130' => '130',
        '140' => '140',
        '150' => '150',
        ],
        'forecasts_chart_options_group' => [
        'forecast' => '预测中',
        'sales_stage' => '销售阶段',
        'probability' => '成交概率',
        ],
        'forecasts_options_dataset' => [
        'likely' => '可能',
        'best' => '最佳',
        'worst' => '最差',
        ],
        'webLogicHookList' => [
        'after_save' => '保存后',
        'after_delete' => '删除后',
        'after_relationship_add' => '关联后',
        'after_relationship_delete' => '取消关联后',
        'after_login' => '登陆后',
        'after_logout' => '登出后',
        'after_login_failed' => '登录失败后',
        ],
        'process_definition_status_dom' => [
        'ACTIVE' => '已启用',
        'INACTIVE' => '禁用',
        ],
        'dashboard_view_name_list' => [
        'record' => '记录',
        'records' => '列表',
        'activities' => '活动流',
        'multi-line' => '多行列表',
        'omnichannel' => '全渠道',
        'home' => 'Home',
        'focus' => '焦点抽屉',
        ],
        'metric_context_list' => [
        'service_console' => '服务控制台',
        'renewals_console' => '续订控制台',
        ],
        'reportschedule_time_interval_dom' => [
        '3600' => '每小时',
        '21600' => '每 6 小时',
        '43200' => '每 12 小时',
        '86400' => '每天',
        '604800' => '每周',
        '1209600' => '每 2 周',
        '2419200' => '每 4 周',
        ],
        'pipeline_records_per_column' => [
        '10' => '10',
        '15' => '15',
        '20' => '20',
        ],
    //Service Duration
        'service_duration_unit_dom' => [
        'year' => '年',
        'month' => '月',
        'day' => '天',
        ],
        'shift_exception_type_dom' => [
        'time_off' => '休息时间',
        'event' => '事件',
        'other' => '其他',
        ],
        'purchase_history_sort_dom' => [
        'end_date:desc' => '日期（上次 {{module}}）',
        'start_date:asc' => '日期（首次 {{module}}）',
        'total_revenue:desc' => '价格（最高总计）',
        'total_revenue:asc' => '价格（最低总计）',
        ],
        'calendar_type_list' => [
        'main' => '日历中心',
        ],
        'calendar_views_options' => [
        'day' => '天',
        'week' => '周',
        'workWeek' => '工作周',
        'expandedMonth' => '月',
        'agenda' => '议程',
        'timeline' => '时间表',
        'monthSchedule' => '计划任务',
        ],
        'docusign_envelope_status_list' => [
        'created' => '已创建',
        'completed' => '已完成',
        'declined' => '已拒绝',
        'delivered' => '已交付',
        'sent' => '已发送',
        'signed' => '已签署',
        'voided' => '无效',
        ],
        'docusign_recipient_selection_list' => [
        'show' => '显示潜在收件人列表',
        'dont_show' => '不要显示潜在的收件人',
        ],
        'docusign_recipient_type_list' => [
        'signer' => '签名者',
        'carbon_copy' => '查看器（复写本）',
        'certified_delivery' => '查看器（认证交付）',
        ],
        'portaltheme_banner_background_style_dom' => [
        'default' => '默认',
        'color' => '颜色',
        'image' => '图片',
        ],
        'module_display_type_dom' => [
        'abbreviation' => '缩略',
        'icon' => '图标',
        ],
        'module_icons_dom' => [
        'sicon-arrow-down' => '向下箭头',
        'sicon-chevron-left' => 'Chevron 向左',
        'sicon-check' => '检查',
        'sicon-clock' => '时钟',
        'sicon-dashboard-default' => '仪表板默认值',
        'sicon-dashboard' => '仪表板',
        'sicon-edit' => '编辑',
        'sicon-caret-down' => '插入符号',
        'sicon-folder' => '文件夹',
        'sicon-info' => '信息',
        'sicon-kebab' => 'Kebab',
        'sicon-link' => '链接',
        'sicon-list' => '列表',
        'sicon-logout' => '退出',
        'sicon-minus' => '减号',
        'sicon-folder-open' => '文件夹打开',
        'sicon-plus-sm' => '加 Sm',
        'sicon-refresh' => '刷新',
        'sicon-plus' => '加',
        'sicon-settings' => '设置',
        'sicon-arrow-right-double' => '双击向右箭头',
        'sicon-reports' => '报告',
        'sicon-user' => '用户',
        'sicon-upload' => '上传',
        'sicon-user-group' => '用户组',
        'sicon-arrow-left-double' => '双击向左箭头',
        'sicon-chevron-up' => 'Chevron 向上',
        'sicon-caret-up' => '插入符号向上',
        'sicon-star-fill' => '星形填充',
        'sicon-download' => '下载',
        'sicon-close' => '关闭',
        'sicon-tile-view' => '平铺视图',
        'sicon-list-view' => '列表视图',
        'sicon-thumbs-down' => '拇指向下',
        'sicon-warning-circle' => '警告圈',
        'sicon-phone' => '电话',
        'sicon-email' => '电子邮件',
        'sicon-document' => '文档',
        'sicon-note' => '备注',
        'sicon-preview' => '预览',
        'sicon-copy' => '复制',
        'sicon-launch' => '运行',
        'sicon-lock' => '锁定',
        'sicon-arrow-top-right' => '右上角箭头',
        'sicon-full-screen' => '全屏',
        'sicon-full-screen-exit' => '退出全屏',
        'sicon-expand-left' => '向左展开',
        'sicon-expand-right' => '向右展开',
        'sicon-focus-drawer' => '焦点抽屉',
        'sicon-ban' => '禁止',
        'sicon-thumbs-up' => '竖起拇指',
        'sicon-search' => '搜索',
        'sicon-calendar' => '日历',
        'sicon-calendar-lg' => '日历 lg',
        'sicon-mobile-lg' => '移动 Lg',
        'sicon-star-fill-lg' => '星形填充 LG',
        'sicon-star-outline-lg' => '星形轮廓 Lg',
        'sicon-reset-lg' => '重置 Lg',
        'sicon-exchange-lg' => '交换 Lg',
        'sicon-help-lg' => '帮助 Lg',
        'sicon-close-lg' => '关闭 Lg',
        'sicon-plus-lg' => '加 Lg',
        'sicon-shortcuts-lg' => '快捷键 Lg',
        'sicon-search-lg' => '搜索 Lg',
        'sicon-email-lg' => '电子邮件 Lg',
        'sicon-note-lg' => '注释 Lg',
        'sicon-document-lg' => '文档 Lg',
        'sicon-add-dashlet-lg' => '添加 Dashlet Lg',
        'sicon-collapse-lg' => '折叠 Lg',
        'sicon-hamburger-lg' => '汉堡包 Lg',
        'sicon-pin-fill-lg' => 'Pin 码填充 Lg',
        'sicon-expand-lg' => '展开 Lg',
        'sicon-copy-lg' => '复制 Lg',
        'sicon-dashboard-lg' => '仪表板 Lg',
        'sicon-star-outline' => '星形轮廓',
        'sicon-reset' => '重置',
        'sicon-unlink' => '取消链接',
        'sicon-phone-lg' => '电话 Lg',
        'sicon-attach' => '附加',
        'sicon-case-lg' => '案例 Lg',
        'sicon-arrow-right-lg' => '向右箭头 Lg',
        'sicon-check-circle-lg' => '勾选圆圈 Lg',
        'sicon-text-formatting' => '文本格式',
        'sicon-check-circle' => '勾选圆圈',
        'sicon-upload-lg' => '上传 Lg',
        'sicon-flag-lg' => '标记 Lg',
        'sicon-studio-lg' => '工作室 Lg',
        'sicon-contact-lg' => '联系人 Lg',
        'sicon-edit-lg' => '编辑 Lg',
        'sicon-arrow-left' => '向左箭头',
        'sicon-reply-all' => '全部回复',
        'sicon-message-lg' => '消息 Lg',
        'sicon-info-lg' => '信息 Lg',
        'sicon-error-lg' => '错误 Lg',
        'sicon-check-circle-line-lg' => '勾选圆圈行 Lg',
        'sicon-warning-line-lg' => '警告行 Lg',
        'sicon-arrow-up' => '向上箭头',
        'sicon-arrow-right' => '向右箭头',
        'sicon-nodes' => '节点',
        'sicon-hide' => '隐藏',
        'sicon-help' => '帮助',
        'sicon-twitter' => 'Twitter',
        'sicon-message' => '消息',
        'sicon-sugar-predict-lg' => 'Sugar 预测 Lg',
        'sicon-sugar-predict' => 'Sugar 预测',
        'sicon-opportunity-lg' => '商业机会 Lg',
        'sicon-lead-lg' => '潜在客户 Lg',
        'sicon-account-lg' => '帐户 Lg',
        'sicon-user-sm' => '用户 Sm',
        'sicon-quote-lg' => '报价 Lg',
        'sicon-equal' => '等于',
        'sicon-slicers-xl' => '切片器 XL',
        'sicon-escalation-lg' => '升级 Lg',
        'sicon-add-circle-lg' => '添加圆圈 Lg',
        'sicon-add-line-lg' => '添加行 Lg',
        'sicon-add-target-lg' => '添加目标 Lg',
        'sicon-help-circle-lg' => '帮助圆圈 Lg',
        'sicon-divide-line-lg' => '分界线 Lg',
        'sicon-string' => '字符串',
        'sicon-filter' => '筛选器',
        'sicon-number' => '编号',
        'sicon-format-lg' => '格式 Lg',
        'sicon-insights-lg' => '洞察 Lg',
        'sicon-invalid-circle-lg' => '无效圆圈 Lg',
        'sicon-layout-xl' => '布局 Xl',
        'sicon-layout-lg' => '布局 Lg',
        'sicon-multiply-line-lg' => '倍增线 Lg',
        'sicon-redo-lg' => '重做 Lg',
        'sicon-refresh-lg' => '刷新 Lg',
        'sicon-undo-lg' => '撤消 Lg',
        'sicon-activity-feed-xl' => '活动反馈 Xl',
        'sicon-chevron-left-xl' => 'Chevron 向左 Xl',
        'sicon-close-xl' => '关闭 Xl',
        'sicon-kebab-lg' => 'Kebab Lg',
        'sicon-insights-xl' => '洞察 Xl',
        'sicon-hide-lg' => '隐藏 Lg',
        'sicon-kebab-xl' => 'Kebab Xl',
        'sicon-comment-xl' => '注释 Xl',
        'sicon-share-lg' => '分享 Lg',
        'sicon-trash' => '垃圾桶',
        'sicon-launch-lg' => '启动 Lg',
        'sicon-thumbs-up-lg' => '竖起拇指 Lg',
        'sicon-thumbs-down-lg' => '拇指向下 Lg',
        'sicon-warning-lg' => '警告 Lg',
        'sicon-wizard-circle-xl' => '向导圆圈 Xl',
        'sicon-bell-cross-lg' => '铃铛十字架 Lg',
        'sicon-bell-lg' => '铃铛 Lg ',
        'sicon-daily-lg' => '每日 Lg',
        'sicon-cloud-download-lg' => '云下载 Lg',
        'sicon-unlock' => '解锁',
        'sicon-news-lg' => '新闻 Lg',
        'sicon-weekly-lg' => '每周 Lg',
        'sicon-knowledgebase-xl' => '知识库 Xl',
        'sicon-remove' => '删除',
        'sicon-chevron-down' => 'Chevron 向下',
        'sicon-slicers-lg' => '切片器 Lg',
        'sicon-save-lg' => '保存 Lg',
        'sicon-info-circle-lg' => '信息圆圈 Lg',
        'sicon-chevron-right' => 'Chevron 向右',
        'sicon-warning-circle-lg' => '警告圆圈 Lg',
        'sicon-right-paren-line-lg' => '右圆括号行 Lg',
        'sicon-comment-lg' => '注释 Lg',
        'sicon-target-lg' => '目标 Lg',
        'sicon-subtract-line-lg' => '减法行 Lg',
        'sicon-settings-lg' => '设置 Lg',
        'sicon-left-paren-line-lg' => '左圆括号行 Lg',
        'sicon-preview-lg' => '预览 Lg',
        'sicon-thumbs-down-line-lg' => '拇指向下行 Lg',
        'sicon-thumbs-up-line-lg' => '竖起拇指行 Lg',
        'sicon-send-lg' => '发送 Lg',
        'sicon-contact-xl' => '联系人 Xl',
        'sicon-wizard-circle-line-xl' => '向导圆圈行 Xl',
        'sicon-trash-lg' => '垃圾桶 Lg',
        'sicon-pin-lg' => 'Pin 码 Lg',
        'sicon-clock-lg' => '时钟 Lg',
        'sicon-comment-line-xl' => '注释行 Xl',
        'sicon-dropdown-editor' => '下拉列表编辑器',
        'sicon-amazon' => 'Amazon',
        'sicon-bug' => '
漏洞',
        'sicon-catalog' => '目录',
        'sicon-cloud' => '云',
        'sicon-config-api' => '配置 Api',
        'sicon-config-nav' => '配置 Nav',
        'sicon-connectors' => '连接器',
        'sicon-contracts' => '合同',
        'sicon-currencies' => '货币',
        'sicon-diagnostics' => '诊断',
        'sicon-sugar-club' => 'Sugar 俱乐部',
        'sicon-email-campaign' => '电子邮件市场活动',
        'sicon-email-inbound' => '入站电子邮件',
        'sicon-email-queue' => '电子邮件队列',
        'sicon-forecasts' => '预测',
        'sicon-display-modules' => '显示模块',
        'sicon-email-contacts' => '电子邮件联系人',
        'sicon-import' => '导入',
        'sicon-log-viewer' => '日志查看器',
        'sicon-lab' => '实验室',
        'sicon-map-pin' => '地图 Pin 码',
        'sicon-manufacturers' => '制造商',
        'sicon-update' => '更新',
        'sicon-content-security' => '内容安全',
        'sicon-module-builder' => '模块生成器',
        'sicon-languages' => '语言',
        'sicon-module-loader' => '模块加载器',
        'sicon-oauth-key' => 'Oauth 密匙',
        'sicon-password-mgmt' => '密码管理',
        'sicon-opportunities' => '机会',
        'sicon-upgrade' => '升级',
        'sicon-portal' => '门户',
        'sicon-product-types' => '产品类型',
        'sicon-quotes' => '报价',
        'sicon-relate-fields' => '关联字段',
        'sicon-repair' => '修复',
        'sicon-role-mgmt' => '角色管理',
        'sicon-scheduler' => '计划任务',
        'sicon-shippers' => '运输供应商',
        'sicon-studio' => '工作室',
        'sicon-web-logic' => '网络逻辑',
        'sicon-sugar-u' => 'Sugar U',
        'sicon-tax-rates' => '税率',
        'sicon-team-mgmt' => '团队管理',
        'sicon-team-perm' => '团队许可',
        'sicon-tracker' => '跟踪器',
        'sicon-workflow' => '工作流',
        'sicon-mask' => '掩码',
        'sicon-mask-disabled' => '掩码已禁用',
        'sicon-email-archive' => '电子邮件存档',
        'sicon-mobile' => '移动设备',
        'sicon-archive' => '存档',
        'sicon-automate-scroll' => '纵向滚动视图',
        'sicon-automate-stacked' => '横向滚动视图',
        'sicon-pdf-manager' => 'PDF 文档管理器',
        'sicon-my-sites' => '我的网站',
        'sicon-cloud-insights' => '云洞察',
        'sicon-sugar-logo-24' => 'Sugar 标志 24',
        'sicon-sugar-logo-16' => 'Sugar 标志 16',
        'sicon-task-lg' => '任务 Lg',
        'sicon-web-lg' => '网络 Lg',
        'sicon-events-lg' => '活动 Lg',
        'sicon-sugar-logo-12' => 'Sugar 标志 12',
        'sicon-tag' => '标签',
        'sicon-tag-lg' => '标签 Lg',
        'sicon-bell-lg-line' => '铃铛 Lg 行',
        'sicon-matrix-xxl' => '矩阵 Xxl',
        'sicon-advanced-filter' => '高级筛选器',
        'sicon-rows-and-columns-xxl' => '行和列 Xxl',
        'sicon-summation-details-xxl' => '求和详情 Xxl',
        'sicon-summation-xxl' => '求和 Xxl',
        'sicon-lock-lg' => '锁定 Lg',
        'sicon-csv-file-xxl' => 'Csv 文件 Xxl',
        'sicon-logo-linkedin' => 'Linkedin 标志 ',
        'sicon-briefcase' => '公文包',
        'sicon-car-front' => '汽车前部',
        'sicon-airplane' => '飞机',
        'sicon-laptop' => '笔记本电脑',
        'sicon-logo-instagram' => 'Instagram 标志',
        'sicon-single-bed' => '单人床',
        'sicon-tiktok' => 'Tiktok',
        'sicon-logo-snapchat' => '标志快照',
        'sicon-video-lg' => '视频 Lg',
        'sicon-reply' => '回复',
        'sicon-subtract' => '减去',
        'sicon-arrow-up-circle-line' => '向上箭头圆圈行',
        'sicon-asterisk' => '星号',
        'sicon-dot-circle-o-lg' => '点圆圈 O Lg',
        'sicon-forward' => '转发',
        'sicon-video' => '视频',
        'sicon-gavel' => '木槌',
        'sicon-login' => '登录',
        'sicon-pdf-file-xxl' => 'Pdf 文件 Xxl',
        'sicon-login-lg' => '登录 Lg',
        'sicon-cloud-download-xl' => '云下载 Xl',
        'sicon-campaigns-lg' => '市场活动 Lg',
        'sicon-customer-journey-stages-lg' => '客户旅程阶段 Lg',
        'sicon-role-mgmt-lg' => '角色管理 Lg',
        'sicon-default-module-lg' => '默认模块 Lg',
        'sicon-quoted-line-items-lg' => '已报价单项 Lg',
        'sicon-projects-lg' => '项目 Lg',
        'sicon-process-business-rules-lg' => '流程商务规则 Lg',
        'sicon-process-email-templates-lg' => '流程电子邮件模板 Lg',
        'sicon-processes-lg' => '流程 Lg',
        'sicon-process-definitions-lg' => '流程定义 Lg',
        'sicon-target-lists-lg' => '目标列表 Lg',
        'sicon-purchased-line-items-lg' => '已购买单项 Lg',
        'sicon-user-group-lg' => '用户组 Lg',
        'sicon-revenue-line-items-lg' => '营收单项 Lg',
        'sicon-business-centers-lg' => '业务中心 Lg',
        'sicon-logo-fb-simple' => '简单 Fb 徽标',
        'sicon-forecasts-lg' => '预测 Lg',
        'sicon-contracts-lg' => '联系人 Lg',
        'sicon-purchase-lg' => '购买 Lg',
        'sicon-sugar-live-lg' => 'Sugar 现场 Lg',
        'sicon-customer-journey-lg' => '客户行程 Lg',
        'sicon-data-privacy-lg' => '数据隐私 Lg',
        'sicon-home-lg' => '首页 Lg',
        'sicon-data-table' => '数据表',
        'sicon-medical-clipboard-lg' => '病历单 Lg',
        'sicon-privacy-lg' => '隐私 Lg',
        'sicon-marketplace' => '市场',
        'sicon-marketplace-lg' => '市场 Lg',
        'sicon-blockquote-lg' => '块引用 Lg',
        'sicon-casino-lg' => '赌场 Lg',
        'sicon-jacuzzi-lg' => '按摩浴缸 Lg',
        'sicon-scissors-lg' => '剪刀 Lg',
        'sicon-storage-lg' => '存储 Lg',
        'sicon-fan-lg' => '风扇 Lg',
        'sicon-medicine-lg' => '药物 Lg',
        'sicon-plant-lg' => '植物 Lg',
        'sicon-telescope-lg' => '望远镜 Lg',
        'sicon-smart-phone-lg' => '智能手机 Lg',
        'sicon-coffee-lg' => '咖啡 Lg',
        'sicon-martini-lg' => '马提尼 Lg',
        'sicon-cocktail-lg' => '鸡尾酒 Lg',
        'sicon-stadium-lg' => '体育场 Lg',
        'sicon-fire-lg' => '火 Lg',
        'sicon-window-lg' => '窗户 Lg',
        'sicon-lotus-lg' => '莲花 Lg',
        'sicon-windmill-lg' => '风车 Lg',
        'sicon-spades-lg' => '黑桃 Lg',
        'sicon-hearts-lg' => '红心 Lg',
        'sicon-diamonds-lg' => '钻石 Lg',
        'sicon-clubs-lg' => '俱乐部 Lg',
        'sicon-skull-lg' => '骷髅头 Lg',
        'sicon-send' => '发送',
        'sicon-world-lg' => '世界 Lg',
        'sicon-airplane-lg' => '飞机 Lg',
        'sicon-planet-lg' => '行星 Lg',
        'sicon-trainer-lg' => '培训师 Lg',
        'sicon-calculator-lg' => '计算器 Lg',
        'sicon-tv-lg' => '电视 Lg',
        'sicon-video-player-lg' => '视频播放器 Lg',
        'sicon-media-player-lg' => '媒体播放器 Lg',
        'sicon-decentralize-lg' => '去中心化 Lg',
        'sicon-statistics-lg' => '统计 Lg',
        'sicon-virus-lg' => '病毒 Lg',
        'sicon-shield-lg' => '屏蔽 Lg',
        'sicon-plug-lg' => '插头 Lg',
        'sicon-shuttle-lg' => '穿梭 Lg',
        'sicon-soundwave-lg' => '声波 Lg',
        'sicon-graph-lg' => '图形 Lg',
        'sicon-playlist-lg' => '播放列表 Lg',
        'sicon-voice-recognition-lg' => '语音识别 Lg',
        'sicon-machine-learning-lg' => '机器学习 Lg',
        'sicon-bed-lg' => '床 Lg',
        'sicon-blueprint-lg' => '蓝图 Lg',
        'sicon-content-delivery-lg' => '内容交付 Lg',
        'sicon-questionnaire-lg' => '问卷 Lg',
        'sicon-presentation-lg' => '介绍 Lg',
        'sicon-organic-lg' => '有机 Lg',
        'sicon-transactions-lg' => '交易 Lg',
        'sicon-wand-lg' => '条码阅读机 Lg',
        'sicon-bin-lg' => '垃圾桶 Lg',
        'sicon-sync-lg' => '同步 Lg',
        'sicon-external-authentication-lg' => '外部身份验证 Lg',
        'sicon-tracking-activity-lg' => '跟踪活动 Lg',
        'sicon-account' => '账户',
        'sicon-meetings-lg' => '会议  Lg',
        'sicon-stacked' => '横向分屏视图',
        'sicon-sidebyside' => '纵向分屏视图',
        ],

        'module_colors_dom' => [
        'army' => '部队',
        'coral' => '珊瑚',
        'green' => '绿色',
        'orange' => '橙色',
        'ocean' => '海洋',
        'pacific' => '太平洋',
        'pink' => '粉色',
        'purple' => '紫色',
        'red' => '红色',
        'teal' => '青色',
        'yellow' => '黄色',
        ],
    // Escalations module
        'escalation_status_dom' => [
        'New' => '新',
        'In Progress' => '正在进行',
        'Closed' => '已关闭',
        ],
        'escalation_reason_dom' => [
        'Inactivity' => '停用',
        'Lack of Progress' => '进展中断',
        'Customer-Imposed Deadline' => '客户设置的截止日期',
        'Account at Risk' => '账户存在风险',
        ],
        'escalation_source_dom' => [
        'Customer Requested' => '客户要求',
        'Internally Requested' => '内部要求',
        ],
        'parent_type_display_escalations' => [
        'Cases' => '案例',
        'Bugs' => '漏洞',
        'Accounts' => '账户',
        'Opportunities' => '机会',
        ],

    // Sentiment
        'sentiment_score_dom' => [
        'Positive' => '肯定',
        'Negative' => '否定',
        'Neutral' => '中性',
        ],
        'ai_conv_score_classification_dropdown' => [
        '' => '',
        '01_not_likely' => '不可能',
        '02_less_likely' => '不太可能',
        '03_neutral' => '中性',
        '04_more_likely' => '很有可能',
        '05_very_likely' => '非常有可能',
        ],
        'ai_icp_fit_score_classification_dropdown' => [
        '' => '',
        '03_does_not_match_customers' => '与客户不匹配',
        '02_no_match' => '',
        '01_matches_customers' => '与客户匹配',
        ],

    // Sugar Automate
        'dri_workflow_templates_available_modules_list' => [
        'Leads' => '潜在客户',
        'Accounts' => '账户',
        'Contacts' => '联系人',
        'Cases' => '案例',
        'Opportunities' => '商业机会',
        ],
        'dri_workflows_state_list' => [
        'not_started' => '未开始',
        'in_progress' => '进行中',
        'completed' => '已完成',
        'cancelled' => '已取消',
        ],
        'dri_workflow_templates_assignee_rule_list' => [
        'none' => '无',
        'create' => '创建时',
        'stage_start' => '阶段开始时',
        'previous_activity_completed' => '上一个活动已完成',
        ],
        'dri_workflow_templates_target_assignee_list' => [
        'current_user' => '当前用户',
        'parent_assignee' => '父任务分配对象',
        ],
        'dri_workflow_task_templates_task_due_date_type_list' => [
        '' => '',
        'days_from_created' => '创建天数',
        'days_from_stage_started' => '从阶段开始到现在的天数',
        'days_from_previous_activity_completed' => '从上一个活动已完成到现在的天数',
        'days_from_parent_date_field' => '从父日期字段开始的天数',
        'days_from_specific_activity_completed' => '从特定活动已完成到现在的天数',
        ],
        'dri_workflow_task_templates_momentum_start_type_list' => [
        '' => '',
        'created' => '创建时',
        'stage_started' => '阶段开始时',
        'previous_activity_completed' => '上一个活动已完成时',
        'parent_date_field' => '在父日期字段时',
        'specific_activity_completed' => '特定活动已完成',
        ],
        'dri_workflow_task_templates_due_date_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_due_date_criteria_list' => [
        'Absolute' => '绝对',
        'Percentage' => '百分比',
        ],
        'dri_workflow_task_templates_momentum_start_field_list' => [
        '' => '',
        ],
        'dri_workflow_task_templates_type_list' => [
        '' => '',
        'customer_task' => '客户任务',
        'milestone' => '里程碑',
        'internal_task' => '内部任务',
        'agency_task' => '代理任务',
        'automatic_task' => '自动任务',
        ],
        'dri_workflow_task_templates_activity_type_list' => [
        'Tasks' => '任务',
        'Calls' => '通话',
        'Meetings' => '会议',
        ],
        'dri_workflow_task_templates_points_list' => [
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
        '7' => '7',
        '8' => '8',
        '9' => '9',
        '10' => '10',
        ],
        'dri_workflow_task_templates_momentum_points_list' => [
        '10' => '10',
        '20' => '20',
        '30' => '30',
        '40' => '40',
        '50' => '50',
        '60' => '60',
        '70' => '70',
        '80' => '80',
        '90' => '90',
        '100' => '100',
        ],
        'dri_workflow_task_templates_send_invites_list' => [
        'none' => '无',
        'create' => '创建时',
        'stage_start' => '阶段开始时',
        ],
        'dri_workflow_task_templates_target_assignee_list' => [
        'inherit' => '继承',
        'current_user' => '当前用户',
        'parent_assignee' => '父任务分配对象',
        'user' => '用户',
        'team' => '团队',
        'user_team' => '用户和团队',
        ],
        'dri_workflow_task_templates_assignee_rule_list' => [
        'inherit' => '继承',
        'none' => '无',
        'create' => '创建时',
        'stage_start' => '阶段开始时',
        'previous_activity_completed' => '上一个活动已完成',
        'specific_activity_completed' => '特定活动已完成',
        ],
        'dri_subworkflows_state_list' => [
        'not_started' => '未开始',
        'in_progress' => '正在进行',
        'not_completed' => '未完成',
        'completed' => '已完成',
        'cancelled' => '已取消',
        ],
        'dri_workflow_templates_disabled_stage_actions_list' => [
        'stage_edit_button' => '编辑阶段',
        'stage_add_task_button' => '创建任务',
        'stage_add_meeting_button' => '安排会议',
        'stage_add_call_button' => '安排通话',
        'stage_delete_button' => '删除阶段',
        ],
        'dri_workflow_templates_disabled_activity_actions_list' => [
        'activity_add_sub_task_button' => '添加任务',
        'activity_add_sub_meeting_button' => '安排会议',
        'activity_add_sub_call_button' => '安排通话',
        'activity_not_applicable_button' => '不适用',
        'activity_delete_button' => '删除',
        ],
        'dri_workflow_templates_cancel_action_list' => [
        'set_not_applicable' => '设置为不适用',
        'remove_open_activities' => '删除打开的活动',
        ],
        'dri_workflow_templates_not_applicable_action_list' => [
        'default' => '默认',
        'custom' => '自定义',
        ],
        'cj_webhooks_request_method_list' => [
        'GET' => '获取',
        'POST' => '发布',
        'PUT' => '放置',
        'PATCH' => '补丁',
        'DELETE' => '删除',
        ],
        'cj_webhooks_request_format_list' => [
        'skip_request' => '跳过请求',
        'json' => 'JSON',
        'http_query' => 'HTTP 查询',
        ],
        'cj_webhooks_response_format_list' => [
        'no_response' => '无回应',
        'json' => 'JSON',
        'http_query' => 'HTTP 查询',
        'text' => '纯文本',
        ],
        'cj_webhooks_trigger_event_list' => [
        '' => '',
        'before_create' => '创建之前',
        'after_create' => '创建之后',
        'before_in_progress' => '进行中之前',
        'after_in_progress' => '进行中之后',
        'before_completed' => '完成之前',
        'after_completed' => '完成之后',
        'before_not_applicable' => '不适用之前',
        'after_not_applicable' => '不适用之后',
        'before_delete' => '删除前',
        'after_delete' => '删除后',
        ],
        'cj_webhooks_request_body_list' => [
        'journey_body' => '发送智能指南信息',
        'custom_body' => '发送自定义帖子正文',
        ],
        'cj_forms_trigger_event_list' => [
        '' => '',
        'in_progress' => '进行中',
        'completed' => '已完成',
        'not_applicable' => '不适用',
        ],
        'cj_forms_action_type_list' => [
        '' => '',
        'view_record' => '查看记录',
        'create_record' => '创建记录',
        'update_record' => '更新记录',
        ],
        'cj_forms_action_trigger_type_list' => [
        'automatic_create' => '自动创建记录',
        'manual_create' => '手动创建记录',
        'automatic_update' => '自动更新记录',
        'manual_update' => '手动更新记录',
        ],
        'cj_forms_parent_type_list' => [
        '' => '',
        'DRI_Workflow_Templates' => '智能指南模板',
        'DRI_SubWorkflow_Templates' => '阶段模板',
        'DRI_Workflow_Task_Templates' => '活动模板',
        ],
        'cj_forms_display_rsa_icon' => [
        'yes' => '是',
        'no' => '否',
        ],
        'cj_calls_completed_status_list' => [
        'Held' => '举行',
        'Not Held' => '未举行',
        ],
        'cj_meetings_completed_status_list' => [
        'Held' => '举行',
        'Not Held' => '未举行',
        ],
        'cj_tasks_completed_status_list' => [
        'Completed' => '已完成',
        'Not Applicable' => '不适用',
        ],
        'cj_webhooks_parent_type_list' => [
        'DRI_Workflow_Templates' => '智能指南模板',
        'DRI_SubWorkflow_Templates' => '阶段模板',
        'DRI_Workflow_Task_Templates' => '活动模板',
        ],
        'dri_cj_parent_activity_type_list' => [
        'Tasks' => '任务',
        'Meetings' => '会议',
        'Calls' => '通话',
        ],
        'dri_workflows_parent_type_list' => [
        'Tasks' => '当前任务',
        'Calls' => '当前通话',
        'Meetings' => '当前会议',
        ],
        'cj_select_to_options_list' => [
        '' => '',
        'specific_users' => '特定用户',
        'specific_contacts' => '特定联系人',
        'related_parent_users' => '相关父级用户',
        'related_parent_contacts' => '相关父级联系人',
        'add_all_contacts_from_parent' => '添加父级所有联系人',
        ],
        'cj_select_to_options_list_module_mapping' => [
        '' => '',
        'specific_users' => '用户',
        'specific_contacts' => '联系人',
        'related_parent_users' => '用户',
        'related_parent_contacts' => '联系人',
        'add_all_contacts_from_parent' => '联系人',
        ],
        'cj_relative_datetime_type_list' => [
        'minutes' => '分钟',
        'hours' => '小时',
        'days' => '天',
        'months' => '月',
        ],
        'cj_relative_date_type_list' => [
        'days' => '天',
        'months' => '月',
        ],
        'cj_date_type_selection_list' => [
        'fixed' => '固定日期',
        'relative' => '相对日期',
        ],
        'cj_blank_list' => [
        '' => '',
        ],
        'cj_allow_activity_by_list' => [
        '' => '',
        'users' => '用户',
        'teams' => '团队',
        'roles' => '角色',
        ],
        'cj_forms_main_trigger_type_list' => [
        '' => '',
        'smart_guide_to_sugar_action' => 'Sugar 操作 Smart Guide',
        'sugar_action_to_smart_guide' => 'Smart Guide Sugar 操作',
        ],
        'cj_forms_module_trigger_list' => [
        '' => '',
        ],
        'cj_forms_taget_action_module_list' => [
        '' => '',
        'Smart Guide Stage' => 'Smart Guide 阶段',
        'Smart Guide Activities' => 'Smart Guide 活动',
        'Smart Guide' => 'Smart Guide',
        ],
        'dri_workflow_action_list' => [
        '' => '',
        'completed' => '已完成',
        'cancelled' => '已取消',
        ],
        'dri_subworkflow_action_list' => [
        '' => '',
        'in_progress' => '进行中',
        'completed' => '已完成',
        ],
        'dri_workflow_activities_action_list' => [
        '' => '',
        'in_progress' => '进行中',
        'completed' => '已完成',
        'not_applicable' => '不适用',
        ],
        'dri_subworkflow_complete_action_list' => [
        '' => '',
        'mark_all_completed' => '将所有活动标记为“已完成”',
        'mark_all_not_applicable' => '将所有未完成的活动标记为“不适用”',
        ],
        'doc_merge_default_region_url' => [
        'us-west-2' => '美国（俄勒冈州）[us-west-2]',
        'ca-central-1' => '加拿大（中部）[ca-central-1]',
        'ap-southeast-1' => '亚太地区（新加坡）[ap-southeast-1]',
        'ap-southeast-2' => '亚太地区（悉尼）[ap-southeast-2]',
        'eu-central-1' => '欧洲（法兰克福）[eu-central-1]',
        'eu-west-2' => '欧洲（伦敦）[eu-west-2]',
        ],
];

$app_strings = [
    'LBL_RECORD_HEADER' => '记录标题', // Studio editing of record views
    'LBL_RECORD_BODY' => '商务名片', // Studio editing of record views
    'LBL_RECORD_SHOWMORE' => '显示全部', // Studio editing of record views
    'LBL_FAVORITE' => '收藏夹', // Record view header panel element
    'LBL_FOLLOW' => '跟踪', // Record view header panel element
    'LBL_FOLLOW_LINK' => '跟踪链接',
    'LBL_TOGGLE_VISIBILITY' => '切换可见选择', // Record view header panel element
    'LBL_ACTIVITIES' => '活动流',
    'LBL_COPYRIGHT' => 'Copyright © 2004-2024 SugarCRM Inc. All Rights Reserved.',
    'LBL_TRADEMARK' => 'SugarCRM、Sugar 和 3-D 立方体均为 SugarCRM Inc. 的注册商标。' .
        '该产品中使用或出现的任何其他公司和产品名称可能是 ' .
        'SugarCRM ®、Sugar Enterprise™ 和 Sugar™ 是 SugarCRM Inc 的商标。',
    'LBL_TRADEMARK2' => 'SugarCRM ®、Sugar Enterprise™ 和 Sugar™ 是 SugarCRM Inc. 的商标。',
    'LBL_SEND_INVITE' => '发送邀请',
    'LBL_INVITEES' => '受邀者',
    'LBL_GUEST_WILL_NOT_RECEIVE_INVITE' => '客户收不到您的邀请',
    'LBL_SELECT_ACTION_LABEL' => '选择动作',
    'LBL_TOGGLE_DRAWER' => '切换选项抽屉',
    'LBL_TOUR_NEXT' => '下一步',
    'LBL_TOUR_SKIP' => '跳过',
    'LBL_TOUR_BACK' => '返回',
    'LBL_TOUR_CLOSE' => '关闭',
    'LBL_TOUR_BTN_DONE' => '完成',
    'LBL_TOUR_TAKE_TOUR' => '观看简介',
    'LBL_TOUR_FULL_TOUR' => '全套简介',
    'LBL_TOUR_MODULE' => '浏览此页',
    'LBL_TOUR_END_TOUR' => '简介结束',
    'LBL_TOUR_OVERVIEW' => '本页概述',
    'LBL_TOUR_REVISIT' => '单击此处即可开始浏览简介。',
    'LBL_MY_AREA_LINKS' => '我的区域链接：' /*for 508 compliance fix*/,
    'LBL_GETTINGAIR' => '获取连接' /*for 508 compliance fix*/,
    'LBL_WELCOMEBAR' => '欢迎' /*for 508 compliance fix*/,
    'LBL_ADVANCEDSEARCH' => '高级查找' /*for 508 compliance fix*/,
    'LBL_MOREDETAIL' => '更多详情' /*for 508 compliance fix*/,
    'LBL_EDIT_INLINE' => '联机编辑' /*for 508 compliance fix*/,
    'LBL_VIEW_INLINE' => '查看' /*for 508 compliance fix*/,
    'LBL_BASIC_SEARCH' => '查找' /*for 508 compliance fix*/,
    'LBL_BASIC_QUICK_SEARCH' => '搜索...' /*for 508 compliance fix*/,
    'LBL_PROJECT_MINUS' => '移除' /*for 508 compliance fix*/,
    'LBL_PROJECT_PLUS' => '添加' /*for 508 compliance fix*/,
    'LBL_Blank' => ' ' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_1' => '列' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_2' => '两列' /*for 508 compliance fix*/,
    'LBL_ICON_COLUMN_3' => '三列' /*for 508 compliance fix*/,
    'LBL_ADVANCED_SEARCH' => '高级查找' /*for 508 compliance fix*/,
    'LBL_ID_FF_ADD' => '添加' /*for 508 compliance fix*/,
    'LBL_HIDE_SHOW' => '隐藏/显示' /*for 508 compliance fix*/,
    'LBL_DELETE_INLINE' => '删除' /*for 508 compliance fix*/,
    'LBL_PLUS_INLINE' => '添加' /*for 508 compliance fix*/,
    'LBL_ID_FF_CLEAR' => '清除' /*for 508 compliance fix*/,
    'LBL_ID_FF_VCARD' => '电子名片' /*for 508 compliance fix*/,
    'LBL_ID_FF_REMOVE' => '取消链接' /*for 508 compliance fix*/,
    'LBL_ADD' => '添加' /*for 508 compliance fix*/,
    'LBL_COMPANY_LOGO' => '公司Logo' /*for 508 compliance fix*/,
    'LBL_JS_CALENDAR' => '日历' /*for 508 compliance fix*/,
    'LBL_DROPDOWN_VIEW_CHANGE_WARNING' => '您选择的下拉列表值更改了记录视图布局。 ' .
        '此新布局中隐藏的字段的值已清除。 ',

    // Side navigation bar labels
    'LBL_SIDEBAR_NAV_OPEN' => '打开',
    'LBL_SIDEBAR_NAV_CLOSE' => '关闭',
    'LBL_SIDEBAR_NAV_ITEM_MENU' => '{{subject}} 菜单',
    'LBL_GOTO_SUGARCRM_COM' => '转到 SugarCRM.com',

    // ARIA label additions (should be lowercase)
    'LBL_ARIA_MODULENAVIGATION' => '主模块导航',
    'LBL_ARIA_TOGGLE_SUBPANEL_VISIBILITY' => '切换子面板',

    'LBL_ADVANCED' => '高级',
    'LBL_BASIC' => '基本',
    'LBL_MODULE_FILTER' => '筛选器',
    'LBL_CONNECTORS_POPUPS' => '连接器弹出窗口',
    'LBL_CLOSEINLINE' => '关闭',
    'LBL_EDITINLINE' => '编辑',
    'LBL_VIEWINLINE' => '查看',
    'LBL_INFOINLINE' => '信息',
    'LBL_POWERED_BY_SUGARCRM' => 'SugarCRM 提供动力',
    'LBL_PRINT' => '打印',
    'LBL_HELP' => '帮助',
    'LBL_TOUR' => '活动视图游览',
    'LBL_TOUR_LINK' => '浏览此页',
    'LBL_MOBILE' => '移动电话:',
    'LBL_ID_FF_SELECT' => '选择',
    'DEFAULT' => '基本',
    'LBL_SORT' => '排序',
    'LBL_OUTBOUND_EMAIL_ADD_SERVER' => '添加服务器...',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => '启用基于SSL或TLS的SMTP？',
    'LBL_NO_ACTION' => '没有该名称的操作。',
    'LBL_NO_DATA' => '无数据',
    'LBL_NOT_APPLICABLE' => '不适用',
    'LBL_ROUTING_ADD_RULE' => '添加规则',
    'LBL_ROUTING_ALL' => '至少',
    'LBL_ROUTING_ANY' => '任何',
    'LBL_ROUTING_BREAK' => '-',
    'LBL_ROUTING_BUTTON_CANCEL' => '取消',
    'LBL_ROUTING_BUTTON_SAVE' => '保存规则',

    'LBL_ROUTING_ACTIONS_COPY_MAIL' => '复制邮件',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN' => '删除 Sugar 对象',
    'LBL_ROUTING_ACTIONS_DELETE_FILE' => '删除文件',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL' => '删除邮件',
    'LBL_ROUTING_ACTIONS_FORWARD' => '转发邮件',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED' => '标志邮件',
    'LBL_ROUTING_ACTIONS_MARK_READ' => '标注邮件',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD' => '标注未读',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL' => '移动邮件',
    'LBL_ROUTING_ACTIONS_PEFORM' => '执行下列的动作',
    'LBL_ROUTING_ACTIONS_REPLY' => '回复邮件',

    'LBL_ROUTING_CHECK_RULE' => "一个错误被发现，",
    'LBL_ROUTING_CHECK_RULE_DESC' => '请验证所有被标注的字段。',
    'LBL_ROUTING_CONFIRM_DELETE' => "您确定您要删除这条规则么? 这个操作不可以被恢复。",

    'LBL_ROUTING_FLAGGED' => '标志设置',
    'LBL_ROUTING_FORM_DESC' => '保存的规则会被立即激活',
    'LBL_ROUTING_FW' => '转发： ',
    'LBL_ROUTING_LIST_TITLE' => '规则',
    'LBL_ROUTING_MATCH' => '如果',
    'LBL_ROUTING_MATCH_2' => '符合以下条件:',
    'LBL_NOTIFICATIONS' => '通知',
    'LBL_ROUTING_MATCH_CC_ADDR' => '抄送',
    'LBL_ROUTING_MATCH_DESCRIPTION' => '主体内容',
    'LBL_ROUTING_MATCH_FROM_ADDR' => '来自',
    'LBL_ROUTING_MATCH_NAME' => '题目',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH' => '高优先级',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL' => '中优先级',
    'LBL_ROUTING_MATCH_PRIORITY_LOW' => '低优先级',
    'LBL_ROUTING_MATCH_TO_ADDR' => '至',
    'LBL_ROUTING_MATCH_TYPE_MATCH' => '包含',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH' => '不包含',

    'LBL_ROUTING_NAME' => '规则名称',
    'LBL_ROUTING_NEW_NAME' => '新规则',
    'LBL_ROUTING_ONE_MOMENT' => '请稍等...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS' => '原始信息跟踪。',
    'LBL_ROUTING_RE' => '答复：',
    'LBL_ROUTING_SAVING_RULE' => '保存规则',
    'LBL_ROUTING_SUB_DESC' => '检查的规则是有效的。 点击名称来编辑。',
    'LBL_ROUTING_TO' => '至',
    'LBL_ROUTING_TO_ADDRESS' => '至地址',
    'LBL_ROUTING_WITH_TEMPLATE' => '与模板',
    'NTC_OVERWRITE_ADDRESS_PHONE_CONFIRM' => '当前表单中的电话和地址字段不为空。要覆盖选中客户的电话和地址信息，请点击"OK"。要保持原值，请点击"取消"。',
    'LBL_DROP_HERE' => '[放置此处]',
    'LBL_EMAIL_ACCOUNTS_EDIT' => '编辑',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS' => '预先填入 Gmail&#153; 默认值',
    'LBL_EMAIL_ACCOUNTS_NAME' => '名称',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND' => '邮件发送服务器属性',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE' => '邮件转交代理',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ' => '使用 SMTP 认证？',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS' => 'SMTP 密码',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT' => 'SMTP端口',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER' => 'SMTP服务器',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL' => '连接时使用 SSL',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER' => 'SMTP用户名',
    'LBL_EMAIL_ACCOUNTS_SMTPDEFAULT' => '默认',
    'LBL_EMAIL_WARNING_MISSING_USER_CREDS' => '警告：缺少发送邮件帐户用户名和密码。',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER_REQD' => 'SMTP 用户名是必需的',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS_REQD' => 'SMTP 密码是必需的',
    'LBL_EMAIL_ACCOUNTS_TITLE' => '邮件帐户管理',
    'LBL_EMAIL_POP3_REMOVE_MESSAGE' => 'POP3邮件服务器协议类型将不会在下一个版本中支持。只将支持IMAP。',
    'LBL_EMAIL_ACCOUNTS_SUBTITLE' => '设置邮件帐户，查看您的电子邮件帐户接收电子邮件。',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND_SUBTITLE' => '提供SMTP邮件服务器的信息，以用于在邮件帐户传出的电子邮件。',
    'LBL_EMAIL_ADD' => '添加邮件',

    'LBL_EMAIL_ADDRESS_BOOK_ADD' => '完成',
    'LBL_EMAIL_ADDRESS_BOOK_CLEAR' => '清空',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_TO' => '收件人:',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_CC' => '抄送：',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_BCC' => '密件抄送：',
    'LBL_EMAIL_ADDRESS_BOOK_ADRRESS_TYPE' => '收件人/抄送/密件抄送',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST' => '新建列表',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR' => '邮件地址',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT' => '现在只有编辑联系人是被支持的。',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER' => '筛选器',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME' => '名字/账户名',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME' => '姓',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS' => '我的联系人',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS' => '我的邮件列表',
    'LBL_EMAIL_ADDRESS_BOOK_NAME' => '名称',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND' => '无地址被发现',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD' => '保存并添加到地址薄',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH' => '查找',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE' => '选择电子邮件收件人',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE' => '地址薄',
    'LBL_EMAIL_REPORTS_TITLE' => '报表',
    'LBL_EMAIL_REMOVE_SMTP_WARNING' => '警告！您正在试图删除的外发邮件帐户是已经关联到一个现有外送邮箱的帐户。您确定要继续吗？',
    'LBL_EMAIL_ADDRESSES' => '电子邮件',
    'LBL_EMAIL_ADDRESS_PRIMARY' => '邮件地址',
    'LBL_EMAIL_ADDRESSES_TITLE' => '电子邮件地址',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR' => '导入到Sugar',
    'LBL_EMAIL_ASSIGNMENT' => '分配',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL' => '添加附件',
    'LBL_EMAIL_ATTACHMENT' => '附件',
    'LBL_EMAIL_ATTACHMENTS' => '来自本地系统',
    'LBL_EMAIL_ATTACHMENTS2' => '来自 Sugar 文档',
    'LBL_EMAIL_ATTACHMENTS3' => '模板附件',
    'LBL_EMAIL_ATTACHMENTS_FILE' => '文件',
    'LBL_EMAIL_ATTACHMENTS_DOCUMENT' => '文档',
    'LBL_EMAIL_ATTACHMENTS_EMBEDED' => '插入邮件',
    'LBL_EMAIL_ATTACHMENT_UPLOAD_FAILED' => '附近上传失败',
    'LBL_REMOVING_ATTACHMENT' => '正在移除附件...',
    'LBL_EMAIL_BCC' => '密件抄送',
    'LBL_EMAIL_CANCEL' => '取消',
    'LBL_EMAIL_CC' => '抄送',
    'LBL_EMAIL_CHARSET' => '字符集设置',
    'LBL_EMAIL_CHECK' => '查看邮件',
    'LBL_EMAIL_CHECKING_NEW' => '查收新邮件',
    'LBL_EMAIL_CHECKING_DESC' => '请稍候...<br><br>如果这是为此邮件帐户做首次查收, 它将花费一些时间。',
    'LBL_EMAIL_CLOSE' => '关闭',
    'LBL_EMAIL_COFFEE_BREAK' => '查收新邮件。<br><br>大邮箱可能花费更多时间。',
    'LBL_EMAIL_COMMON' => '普通',

    'LBL_EMAIL_COMPOSE' => '电子邮件',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS' => '请为邮件输入收件人。',
    'LBL_EMAIL_COMPOSE_LINK_TO' => '关联到',
    'LBL_EMAIL_COMPOSE_NO_BODY' => '邮件内容为空。 无论如何都发送吗?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT' => '此邮件没有主题，是否继续发送？',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL' => '（无主题）',
    'LBL_EMAIL_COMPOSE_READ' => '阅读和撰写邮件',
    'LBL_EMAIL_COMPOSE_SEND_FROM' => '从邮件帐户中发送',
    'LBL_EMAIL_COMPOSE_OPTIONS' => '选项',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS' => '以下字段请输入有效的电子邮件地址：收件人、抄送、密件抄送',

    'LBL_EMAIL_CONFIRM_CLOSE' => '放弃这封邮件么？',
    'LBL_EMAIL_CONFIRM_DELETE' => '要从您的地址簿中移除这些输入吗?',
    'LBL_EMAIL_CONFIRM_DELETE_SIGNATURE' => '确认删除此签名?',

    'LBL_EMAIL_CREATE_NEW' => '--保存后创建--',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS' => '多种',
    'LBL_EMAIL_MULT_GROUP_FOLDER_ACCOUNTS_EMPTY' => '空',
    'LBL_EMAIL_DATE_SENT_BY_SENDER' => '发送者发出日期',
    'LBL_EMAIL_DATE_RECEIVED' => '接收时间',
    'LBL_EMAIL_ASSIGNED_TO_USER' => '指派给用户',
    'LBL_EMAIL_DATE_TODAY' => '今天',
    'LBL_EMAIL_DATE_YESTERDAY' => '昨天',
    'LBL_EMAIL_DD_TEXT' => '选择的邮件',
    'LBL_EMAIL_DEFAULTS' => '默认',
    'LBL_EMAIL_DELETE' => '删除',
    'LBL_EMAIL_DELETE_CONFIRM' => '删除选择的信息么?',
    'LBL_EMAIL_DELETE_SUCCESS' => '邮件删除成功',
    'LBL_EMAIL_DELETING_MESSAGE' => '删除信息中',
    'LBL_EMAIL_DETAILS' => '详细',
    'LBL_EMAIL_DISPLAY_MSG' => '显示邮件(s) {0} - {1} of {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG' => '显示邮件地址 {0} - {1} of {2}',

    'LBL_EMAIL_EDIT_CONTACT' => '编辑联系人',
    'LBL_EMAIL_EDIT_CONTACT_WARN' => '处理联系人时，只使用主要地址。',
    'LBL_EMAIL_EDIT_MAILING_LIST' => '编辑邮件列表',

    'LBL_EMAIL_EMPTYING_TRASH' => '清空垃圾箱',
    'LBL_EMAIL_DELETING_OUTBOUND' => '删除发件服务器',
    'LBL_EMAIL_CLEARING_CACHE_FILES' => '清除缓存文件',
    'LBL_EMAIL_EMPTY_MSG' => '无邮件显示',
    'LBL_EMAIL_EMPTY_ADDR_MSG' => '无邮件地址显示',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER' => '文件夹名称是唯一且不空。请重试。',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER' => '不能删除文件夹。 文件夹和它的子文件夹都与一个邮箱相关联。',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE' => '从上下文不能确定文件夹的用意,重试。',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS' => '请查看您的设置。',
    'LBL_EMAIL_ERROR_CONTACT_NAME' => '请确定您输入了一个姓。',
    'LBL_EMAIL_ERROR_DESC' => '发现错误：',
    'LBL_EMAIL_DELETE_ERROR_DESC' => '您无权限访问此区域，请联系管理员以获得权限。',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME' => 'Sugar 文件夹名一定是唯一的。',
    'LBL_EMAIL_ERROR_EMPTY' => '请输入一些查找标准.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE' => '发生了一个错误',
    'LBL_EMAIL_ERROR_LIST_NAME' => '一封名称已经存在的电子邮件',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED' => '消息从服务器上移除',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED' => '消息不是被从服务器上删除就是转移到一个不同的文件夹中',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION' => '连接邮件服务器失败。 请联系您的管理员',
    'LBL_EMAIL_ERROR_MOVE' => '在服务器和邮件帐户中移动邮件目前还不被支持。',
    'LBL_EMAIL_ERROR_MOVE_TITLE' => '移动错误',
    'LBL_EMAIL_ERROR_NAME' => '名称是被需要的',
    'LBL_EMAIL_ERROR_FROM_ADDRESS' => '来源地址是被需要的 ， 请输入一个有效的电子邮件地址。',
    'LBL_EMAIL_ERROR_NO_FILE' => '请提供一个文件',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAP文件夹重命名这次不被支持。',
    'LBL_EMAIL_ERROR_SERVER' => '一个邮件服务器地址是需要的。',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT' => '邮件帐户可能未被保存。',
    'LBL_EMAIL_ERROR_TIMEOUT' => '在与邮件服务器通信时发生错误。',
    'LBL_EMAIL_ERROR_USER' => '需要登陆名称。',
    'LBL_EMAIL_ERROR_PASSWORD' => '需要密码。',
    'LBL_EMAIL_ERROR_PORT' => '需要邮件服务端口。',
    'LBL_EMAIL_ERROR_PROTOCOL' => '需要服务协议。',
    'LBL_EMAIL_ERROR_MONITORED_FOLDER' => '需要设定被监督的文件夹。',
    'LBL_EMAIL_ERROR_TRASH_FOLDER' => '需要设定垃圾文件夹。',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE' => '这个信息是无效的',
    'LBL_EMAIL_ERROR_NO_OUTBOUND' => '没有指定外发邮件服务器。',
    'LBL_EMAIL_FOLDERS' => '文件夹',
    'LBL_EMAIL_FOLDERS_ACTIONS' => '移动到',
    'LBL_EMAIL_FOLDERS_ADD' => '添加',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE' => '添加新文件夹',
    'LBL_EMAIL_FOLDERS_RENAME_DIALOG_TITLE' => '重命名新文件夹',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER' => '保存',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO' => '添加新文件夹到',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME' => '这个文件夹不能被改变',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM' => '您确定您要删除这个文件夹吗?\n这个过程不能被回滚。\n文件夹删除将关联到所有包含的文件夹。',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER' => '新文件夹名称',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE' => '在执行这个操作之前请指定一个文件夹。',
    'LBL_EMAIL_FOLDERS_TITLE' => '文件夹管理',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER' => '分配给团队',
    'LBL_EMAIL_FOLDERS_USING_TEAM' => '分配给团队',
    'LBL_EMAIL_FORWARD' => '转发',
    'LBL_EMAIL_DELIMITER' => '::;::',
    'LBL_EMAIL_DOWNLOAD_STATUS' => '下载 [[count]]  [[total]] 邮件',
    'LBL_EMAIL_FOUND' => '找到',
    'LBL_EMAIL_FROM' => '从',
    'LBL_EMAIL_GROUP' => '组',
    'LBL_EMAIL_UPPER_CASE_GROUP' => '组',
    'LBL_EMAIL_HOME_FOLDER' => '主页',
    'LBL_EMAIL_HTML_RTF' => '发送 HTML',
    'LBL_EMAIL_IE_DELETE' => '删除邮件账户',
    'LBL_EMAIL_IE_DELETE_SIGNATURE' => '删除签名',
    'LBL_EMAIL_IE_DELETE_CONFIRM' => '您确定您要删除这个邮件帐户吗?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL' => '删除成功',
    'LBL_EMAIL_IE_SAVE' => '保存邮件帐户信息',
    'LBL_EMAIL_IMPORTING_EMAIL' => '导入邮件',
    'LBL_EMAIL_IMPORT_EMAIL' => '导入到Sugar',
    'LBL_EMAIL_IMPORT_SETTINGS' => '导入设置',
    'LBL_EMAIL_INVALID' => '无效',
    'LBL_EMAIL_LINK_RECORD' => '点击此处',
    'LBL_EMAIL_LIST_RENAME_TITLE' => '重命名邮件列表',
    'LBL_EMAIL_LIST_RENAME_DESC ' => '为此邮件列表输入一个新名称',
    'LBL_EMAIL_CONFIRM_DELETE_LIST' => '在您的邮件列表中删除这些输入?',
    'LBL_EMAIL_LOADING' => '加载中...',
    'LBL_EMAIL_MARK' => '标记',
    'LBL_EMAIL_MARK_FLAGGED' => '作为标志',
    'LBL_EMAIL_MARK_READ' => '作为已读',
    'LBL_EMAIL_MARK_UNFLAGGED' => '作为无标志',
    'LBL_EMAIL_MARK_UNREAD' => '作为未读',
    'LBL_EMAIL_ASSIGN_TO' => '分配给',

    'LBL_EMAIL_MENU_ADD_FOLDER' => '创建文件夹',
    'LBL_EMAIL_MENU_COMPOSE' => '排版',
    'LBL_EMAIL_MENU_DELETE_FOLDER' => '删除文件夹',
    'LBL_EMAIL_MENU_EDIT' => '编辑',
    'LBL_EMAIL_MENU_EMPTY_TRASH' => '清空垃圾箱',
    'LBL_EMAIL_MENU_SYNCHRONIZE' => '同步',
    'LBL_EMAIL_MENU_CLEAR_CACHE' => '清除缓存文件',
    'LBL_EMAIL_MENU_REMOVE' => '删除',
    'LBL_EMAIL_MENU_RENAME' => '重命名',
    'LBL_EMAIL_MENU_RENAME_FOLDER' => '重命名文件夹',
    'LBL_EMAIL_MENU_RENAMING_FOLDER' => '重命名文件夹',
    'LBL_EMAIL_MENU_MAKE_SELECTION' => '请在此操作之前做一个选择。',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER' => '创建一个文件夹 (远程或在Sugar中)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE' => '在SugarCRM激活这些邮件',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST' => '邮件选择邮件列表',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE' => '发邮件给这个联系人',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE' => '移除一个联系人',
    'LBL_EMAIL_MENU_HELP_DELETE' => '删除这些邮件',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER' => '删除一个文件 (远程或在Sugar中)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT' => '编辑一个联系人',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST' => '编辑一个邮件列表',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH' => '为您邮件庄户清空所有破损的文件夹',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED' => '标记这些邮件为标志的',
    'LBL_EMAIL_MENU_HELP_MARK_READ' => '标记这些邮件已读',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED' => '标记这些邮件未标志',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD' => '标记这些邮件未未读',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST' => '删除邮件列表',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER' => '重命名一个文件夹 （远程或在 Sugar 中）',
    'LBL_EMAIL_MENU_HELP_REPLY' => '回复这些邮件',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL' => '回复给所有这些邮件的接受者',

    'LBL_EMAIL_MESSAGES' => '消息',

    'LBL_EMAIL_ML_NAME' => '列表名称',
    'LBL_EMAIL_ML_ADDRESSES_1' => '选择列表地址',
    'LBL_EMAIL_ML_ADDRESSES_2' => '有效列表地址',

    'LBL_EMAIL_MULTISELECT' => '<b>Ctrl-点击</b> 选择多个<br />(Mac用户使用 <b>CMD-点击</b>)',

    'LBL_EMAIL_NO' => '否',
    'LBL_EMAIL_NOT_SENT' => '系统不能处理你的请求。请联系系统管理员。',
    'LBL_INSERT_TO_USER_PWD_FAILED' => '无法插入 users_password_link。',

    'LBL_EMAIL_OK' => '确定',
    'LBL_EMAIL_ONE_MOMENT' => '请稍等一会...',
    'LBL_EMAIL_OPEN_ALL' => '打开多行消息',
    'LBL_EMAIL_OPTIONS' => '选项',
    'LBL_EMAIL_QUICK_COMPOSE' => '快速撰写',
    'LBL_EMAIL_OPT_OUT' => '选出',
    'LBL_EMAIL_OPT_OUT_AND_INVALID' => '选出和无效的',
    'LBL_EMAIL_PAGE_AFTER' => '的 {0}',
    'LBL_EMAIL_PAGE_BEFORE' => '页',
    'LBL_EMAIL_PERFORMING_TASK' => '完成任务',
    'LBL_EMAIL_PRIMARY' => '主要',
    'LBL_EMAIL_PRINT' => '打印',

    'LBL_EMAIL_QC_BUGS' => '错误',
    'LBL_EMAIL_QC_CASES' => '客户反馈信息',
    'LBL_EMAIL_QC_LEADS' => '潜在客户',
    'LBL_EMAIL_QC_CONTACTS' => '联系人',
    'LBL_EMAIL_QC_TASKS' => '任务',
    'LBL_EMAIL_QC_OPPORTUNITIES' => '机会',
    'LBL_EMAIL_QUICK_CREATE' => '快速创建',

    'LBL_EMAIL_REBUILDING_FOLDERS' => '重建文件夹',
    'LBL_EMAIL_RELATE_TO' => '相关',
    'LBL_EMAIL_VIEW_RELATIONSHIPS' => '查看关系',
    'LBL_EMAIL_RECORD' => '邮件记录',
    'LBL_EMAIL_REMOVE' => '移除',
    'LBL_EMAIL_REPLY' => '回复',
    'LBL_EMAIL_REPLY_ALL' => '回复全部',
    'LBL_EMAIL_REPLY_TO' => '回复',
    'LBL_EMAIL_RETRIEVING_LIST' => '查询邮件列表',
    'LBL_EMAIL_RETRIEVING_MESSAGE' => '查询消息',
    'LBL_EMAIL_RETRIEVING_RECORD' => '查询邮件记录',
    'LBL_EMAIL_SELECT_ONE_RECORD' => '请选择一条邮件记录',
    'LBL_EMAIL_RETURN_TO_VIEW' => '返回到前一个模块？',
    'LBL_EMAIL_REVERT' => '查询',
    'LBL_EMAIL_RELATE_EMAIL' => '相关邮件',

    'LBL_EMAIL_RULES_TITLE' => '规则管理',

    'LBL_EMAIL_SAVE' => '保存',
    'LBL_EMAIL_SAVE_AND_REPLY' => '保存和回复',
    'LBL_EMAIL_SAVE_DRAFT' => '保存草稿',

    'LBL_EMAIL_SEARCHING' => '引导查找',
    'LBL_EMAIL_SEARCH_ADVANCED' => '高级查找',
    'LBL_EMAIL_SEARCH_DATE_FROM' => '开始日期',
    'LBL_EMAIL_SEARCH_DATE_UNTIL' => '结束日期',
    'LBL_EMAIL_SEARCH_FULL_TEXT' => '文章内容',
    'LBL_EMAIL_SEARCH_NO_RESULTS' => '无结果匹配您的查找规则',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE' => '搜索结果',
    'LBL_EMAIL_SEARCH_TITLE' => '简单查找',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS' => '查找邮件账户',

    'LBL_EMAIL_SELECT' => '选择',

    'LBL_EMAIL_SEND' => '发送',
    'LBL_EMAIL_SENDING_EMAIL' => '发送邮件中',

    'LBL_EMAIL_SETTINGS' => '设置',
    'LBL_EMAIL_SETTINGS_2_ROWS' => '2 行',
    'LBL_EMAIL_SETTINGS_3_COLS' => '3 列',
    'LBL_EMAIL_SETTINGS_LAYOUT' => '版面布局风格',
    'LBL_EMAIL_SETTINGS_ACCOUNTS' => '邮件账户',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT' => '清除窗口',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT' => '在视图上导入邮件',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL' => '查找新邮件',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE' => '使用预览窗格',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP' => '使用弹出窗口',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM' => '每页邮件数量',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT' => '编辑邮件账户',
    'LBL_EMAIL_SETTINGS_FOLDERS' => '文件夹',
    'LBL_EMAIL_SETTINGS_FROM_ADDR' => '来源地址',
    'LBL_EMAIL_SETTINGS_FROM_TO_EMAIL_ADDR' => '接受测试通知的电邮地址：',
    'LBL_EMAIL_SETTINGS_TO_EMAIL_ADDR' => '收件人邮件地址',
    'LBL_EMAIL_SETTINGS_FROM_NAME' => '来源名称',
    'LBL_EMAIL_SETTINGS_REPLY_TO_ADDR' => '回复地址',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN' => '全屏幕',
    'LBL_EMAIL_SETTINGS_FULL_SYNC' => '同步所有邮件帐户',
    'LBL_EMAIL_TEST_NOTIFICATION_SENT' => '电子邮件已经有设定的发件服务器发送到指定的邮箱。请检查是否收到电子邮件以确定发件服务器设置是否正确。',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC' => '执行本动作将同步邮件帐户和它们的内容。',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN' => '执行一个全同步吗?\n大邮件帐户可能会花费几分钟。',
    'LBL_EMAIL_SUBSCRIPTION_FOLDER_HELP' => '按Shift键或Ctrl键来选在多个文件夹。',
    'LBL_EMAIL_SETTINGS_GENERAL' => '全部',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS' => '有效组文件夹',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE' => '创建组文件夹',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => '保存组文件夹',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP' => '恢复组文件夹',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => '编辑组文件夹',

    'LBL_EMAIL_SETTINGS_NAME' => '邮件账户名称',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH' => '这些设置将需要页面刷新被激活。',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => '恢复邮件账户',
    'LBL_EMAIL_SETTINGS_RULES' => '规则',
    'LBL_EMAIL_SETTINGS_SAVED' => '设置已经保存。\n\n您必须重新加载页面使新设置有效。',
    'LBL_EMAIL_SETTINGS_MUST_RELOAD' => '你必须重新加载页面为新设置生效。',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS' => '仅发送纯文本电子邮件',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS' => '激活邮件账户',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST' => '每页邮件数量',
    'LBL_EMAIL_SETTINGS_TAB_POS' => '在底部放入标签',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT' => '可视设置',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES' => '偏好',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV' => '显示高级',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS' => '有效用户文件夹',
    'LBL_EMAIL_ERROR_PREPEND' => '错误:',
    'LBL_EMAIL_INVALID_PERSONAL_OUTBOUND' => '您选择的外发邮件服务器是无效的。请检查设置或选择另一个不同的邮件帐户。',
    'LBL_EMAIL_INVALID_SYSTEM_OUTBOUND' => '未配置外部邮件服务器，不能发送邮件。请在设置>>邮件账户中配置一个外部邮件服务器或者为邮件账户选择一个外部邮件服务器。',
    'LBL_EMAIL_SHOW_READ' => '显示所有',
    'LBL_EMAIL_SHOW_UNREAD_ONLY' => '只显示未读',
    'LBL_EMAIL_SIGNATURES' => '签名',
    'LBL_EMAIL_SIGNATURE_CREATE' => '创建签名',
    'LBL_EMAIL_SIGNATURE_NAME' => '命名名称',
    'LBL_EMAIL_SIGNATURE_TEXT' => '签名内容',
    'LBL_SMTPTYPE_MICROSOFT' => 'Microsoft',
    'LBL_SMTPTYPE_GOOGLE_OAUTH2' => 'Google',
    'LBL_SMTPTYPE_EXCHANGE_ONLINE' => 'Exchange Online',
    'LBL_SMTPTYPE_GMAIL' => 'Google Less-Secure 应用程序',
    'LBL_SMTPTYPE_YAHOO' => '雅虎电邮',
    'LBL_SMTPTYPE_EXCHANGE' => '微软交流群组软件',
    'LBL_SMTPTYPE_OTHER' => '其他',
    'LBL_EMAIL_AUTHORIZE' => '授权',
    'LBL_EMAIL_AUTHORIZED' => '已授权',
    'LBL_EMAIL_NOT_AUTHORIZED' => '未授权',
    'LBL_EMAIL_AUTH_WARNING' => '管理员必须先通过“管理”>“连接器”配置 {0} 连接器，然后才能设置此账户。有关详细信息，请参阅 {1} 文档。',
    'LBL_EMAIL_AUTH_API_ERROR' => '检索连接器信息时出错',
    'LBL_EMAIL_AUTH_FAILURE' => '授权失败。',
    'LBL_EMAIL_PLEASE_AUTHORIZE' => '请在保存之前授权账户。',
    'LBL_EMAIL_PLEASE_AUTHORIZE_TESTING' => '请在测试之前授权账户。',
    'LBL_EMAIL_ACCOUNT_NOT_AUTHORIZED' => '账户未经授权',
    'LBL_EMAIL_SPACER_MAIL_SERVER' => '[远程文件夹]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER' => '[ Sugar 文件夹]',
    'LBL_EMAIL_SUBJECT' => '主题',
    'LBL_EMAIL_SUCCESS' => '成功',
    'LBL_EMAIL_SUGAR_FOLDER' => 'Sugar文件夹',
    'LBL_EMAIL_TEAMS' => '分配给团队',
    'LBL_EMAIL_TEMPLATE_EDIT_PLAIN_TEXT' => '电子邮件模板的纯文本为空',
    'LBL_EMAIL_TEMPLATES' => '模板',
    'LBL_EMAIL_TEXT_FIRST' => '首页',
    'LBL_EMAIL_TEXT_PREV' => '前一页',
    'LBL_EMAIL_TEXT_NEXT' => '下一页',
    'LBL_EMAIL_TEXT_LAST' => '最后一页',
    'LBL_EMAIL_TEXT_REFRESH' => '刷新',
    'LBL_EMAIL_TO' => '到',
    'LBL_EMAIL_TOGGLE_LIST' => '切换邮件列表',
    'LBL_EMAIL_VIEW' => '查看',
    'LBL_EMAIL_VIEWS' => '视图',
    'LBL_EMAIL_VIEW_HEADERS' => '查看头',
    'LBL_EMAIL_VIEW_PRINTABLE' => '打印版',
    'LBL_EMAIL_VIEW_RAW' => '显示原始邮件',
    'LBL_EMAIL_VIEW_UNSUPPORTED' => '当使用POP3协议这项功能不被支持。',
    'LBL_DEFAULT_LINK_TEXT' => '默认连文本',
    'LBL_EMAIL_YES' => '是',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS' => '发送测试邮件',
    'LBL_EMAIL_TEST_OUTBOUND_SETTINGS_SENT' => '测试邮件已发送',


    'LBL_EMAIL_MESSAGE_NO' => '消息',
    'LBL_EMAIL_IMPORT_SUCCESS' => 'I导入成功',
    'LBL_EMAIL_IMPORT_FAIL' => '导入失败，该消息已导入或已从服务器删除',

    'LBL_EMAILS_FROM' => '电子邮件已发送',
    'LBL_EMAILS_RECEIVED' => '电子邮件已接收',
    'LBL_EMAIL_ADDRESSES_USED' => '电子邮件中使用的电子邮件址',
    'LBL_EMAIL_ADDRESS' => '电子邮件地址',
    'LBL_FROM' => '发件人',
    'LBL_TO' => '收件人',
    'LBL_CC' => '抄送',
    'LBL_BCC' => '密件抄送',

    'LBL_START_DATE' => '开始日期',
    'LBL_END_DATE' => '结束日期',
    'LBL_START' => '开始',
    'LBL_END' => '结束',
    'LBL_DATE_LINKED' => '链接日期',

    'LBL_LINK_NONE' => '无',
    'LBL_LINK_ALL' => '全部',
    'LBL_LINK_RECORDS' => '记录',
    'LBL_LINK_SELECT' => '选择',
    'LBL_LINK_ACTIONS' => '操作',
    'LBL_LINK_MORE' => '更多',
    'LBL_CLOSE_ACTIVITY_HEADER' => '确认',
    'LBL_CLOSE_ACTIVITY_CONFIRM' => '您确定要关闭这个 #module#?',
    'LBL_CLOSE_ACTIVITY_REMEMBER' => '不显示在未来此消息：: &nbsp;',
    'LBL_INVALID_FILE_EXTENSION' => '无效的文件扩展名',
    'LBL_LIST_TEAM' => '团队',
    'LBL_TEAM' => '团队:',
    'LBL_TEAMS' => '团队',
    'LBL_TEAM_SET_ID' => '团队信息',
    'LBL_TEAM_SET_SELECTED_ID' => '所选团队',
    'LBL_TEAM_SET_SELECTED' => '已选择',
    'LBL_TEAM_SET_ENABLE' => '启用附加权限',
    'LBL_TEAM_SET_DISABLE' => '禁用附加权限',
    'LBL_TEAM_SET' => '团队列表',
    'LBL_TEAM_SET_SELECTED_TEAMS' => '选择团队',
    'LBL_SEARCH_UNAVAILABLE' => '搜索无效，请稍后再尝试.',
    'ERR_NO_PRIMARY_TEAM_SPECIFIED' => '没有指定主要团队',
    'LBL_REMOVE_PRIMARY_TEAM_ERROR' => '试图从模块[{1}]中删除编号为[{2}]的主团队[{0}]失败',
    'LBL_TEAM_ADD' => '添加团队',
    'LBL_TEAM_REMOVE' => '删除团队',
    'LBL_TEAM_PRIMARY' => '设定为主团队',

    'LBL_CLOSE_BUTTON_LABEL' => '关闭',
    'TPL_STATUS_CHANGE_SUCCESS' => '{{moduleSingular}} 标记为 {{status}}。',

    'LBL_FOCUS' => '焦点',

    'LBL_QUERY_VALID' => '有效',
    'LBL_QUERY_ERROR' => '错误！',
    'LBL_QUERY_CHILD' => '有效的子查询',
    'ERROR_EXAMINE_MSG' => '请检查下面的错误消息:',
    'NO_QUERY_SELECTED' => '您选择的数据格式不包含查询。请为这个数据格式选择自定义查询。',

    'ERR_FIELD_TOO_LARGE' => 'The {0} content is too large. Please make the {0} shorter and try again.',
    'ERR_AJAX_LOAD' => '出现错误:',
    'ERR_AJAX_LOAD_FAILURE' => '您的操作要求出现错误，请稍后重试.',
    'ERR_AJAX_LOAD_FOOTER' => '如果该错误仍出现，请联系您的管理员在这个模块上禁用Ajax',
    'ERR_CREATING_FIELDS' => '显示在详情栏中的错误:',
    'ERR_CREATING_TABLE' => '新增表错误：',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP' => 'T小数分隔符和千分符不能相同。

请更改它们的值。',
    'ERR_DELETE_RECORD' => '必须指定记录编号才能删除客户。',
    'ERR_EXPORT_DISABLED' => '禁止导出。',
    'ERR_EXPORT_TYPE' => '错误导出',
    'ERR_REPORTS_DISABLED_EXPORT' => '报告导出已禁用',
    'ERR_REPORTS_ADMIN_EXPORT_ONLY' => '只有管理员用户可以导出',
    'ERR_REPORTS_EXPORT_NOT_ALLOWED' => '报表使用没有导出访问权限的模块',
    'ERR_REPORTS_EXPORT_OWNER' => '报表使用具有所有者导出访问权限的模块',
    'ERR_REPORTS_LIST_NOT_ALLOWED' => '报表使用具有列表受限访问权限的模块',
    'ERR_REPORTS_VIEW_NOT_ALLOWED' => '报表使用具有查看受限访问权限的模块',
    'ERR_REPORTS_ACCESS_DISABLED' => '报表使用具有受限访问权限的模块',
    'ERR_REPORTS_FIELDS_RESTRICTED' => '报表使用具有受限访问权限的字段',
    'ERR_INVALID_AMOUNT' => '请输入有效金额',
    'ERR_INVALID_DATE_FORMAT' => '日期格式必须是:',
    'ERR_INVALID_DATE' => '请输入有效日期。',
    'ERR_INVALID_DAY' => '请输入有效天。',
    'ERR_INVALID_EMAIL_ADDRESS' => '不是有效的电子邮件地址。',
    'ERR_INVALID_FILE_REFERENCE' => '无效文件引用',
    'ERR_INVALID_HOUR' => '请输入有小小时',
    'ERR_INVALID_MONTH' => '请输入有效月',
    'ERR_INVALID_TIME' => '请输入有效时间',
    'ERR_INVALID_YEAR' => '请输入有效四位数',
    'ERR_NEED_ACTIVE_SESSION' => '需要一个可用的会话来导出内容。',
    'ERR_NO_HEADER_ID' => '此功能在本主题中无效',
    'ERR_NOT_ADMIN' => '没有管理权限。',
    'ERR_PASSWORD_MANAGEMENT_DISABLED_FOR_IDM_MODE' =>
        '仅可在 <a href="%s" target="_blank">SugarCloud 设置</a>中进行密码管理。',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE' => '如果需要更改只读字段，请联系您的 Sugar 管理员。',
    'ERR_UPDATE_PERSON_PRIMARY_EMAIL_IN_IDM_MODE_ADMIN' => '请访问 <a href="{0}" target="_blank">SugarCloud 设置</a> 对只读字段进行变更。',
    'ERR_MISSING_REQUIRED_FIELDS' => '缺少必填字段:',
    'ERR_INVALID_REQUIRED_FIELDS' => '无效的必填字段:',
    'ERR_INVALID_VALUE' => '无效值：',
    'ERR_NO_SUCH_FILE' => '文件在系统中不存在',
    'ERR_NO_SINGLE_QUOTE' => '不可以使用单引号',
    'ERR_NOTHING_SELECTED' => '继续之前请选择',
    'ERR_OPPORTUNITY_NAME_DUPE' => '商业机会名称 %s 已存在，请输入另一个名称。',
    'ERR_OPPORTUNITY_NAME_MISSING' => '商业机会名称不能为空。请输入以下的商业机会名称。',
    'ERR_QUOTE_CONVERTED' => '此报价已转换的机会。',
    'ERR_POTENTIAL_SEGFAULT' => '检测到一个 Apache 潜在的分割故障。请通知您的系统管理员来确认这个问题，让他报告给 SugarCRM。',
    'ERR_SELF_REPORTING' => '用户不可以给自己汇报。',
    'ERR_SINGLE_QUOTE' => '这个字段不支持使用单引号。请改变字段值。',
    'ERR_SQS_NO_MATCH_FIELD' => '没有匹配字段:',
    'ERR_SQS_NO_MATCH' => '没有匹配',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => '请声明 &#39;关键值&#39; 索引在显示参数属性中为元数据定义。',
    'ERR_EXISTING_PORTAL_USERNAME' => '错误：门户名称已经分配给另外联系人.',
    'ERR_PORTAL_NAME_CHECK' => '无法验证用户名是唯一的',
    'ERR_COMPATIBLE_PRECISION_VALUE' => '数值与精度不匹配',
    'ERR_EXTERNAL_API_SAVE_FAIL' => '当尝试保存对外账户时发生错误。',
    'ERR_EXTERNAL_API_UPLOAD_FAIL' => '上传时发生错误。 请确认您上传的文件不是空的。',
    'ERR_NO_DB' => '不能连接到数据库， 请参考sugarcrm.log 查看将更多细节。',
    'ERR_DB_FAIL' => '数据库失败。 请参考 sugarcrm.log 查看更多细节。',
    'ERR_EXTERNAL_API_403' => '没有访问权利。 文件类型不被支持。',
    'ERR_EXTERNAL_API_NO_OAUTH_TOKEN' => 'OAuth访问Token丢失。',
    'ERR_DB_VERSION' => 'SugarCRM {0} 文件只能被用于SugarCRM {1} 数据库.',
    'ERR_DB_QUERY' => '{0}: 查询失败：{1}',
    'ERR_UW_RETIRED' => '不可以在这个版本升级。',
    'ERR_NOT_CLOUD_INSTANCE' => '此 Sugar 实例不是 SugarCloud 实例，或者没有针对 SugarCloud Insights 进行配置。',


    'EXCEPTION_CREATE_MODULE_NOT_AUTHORIZED' => '您没有权限创建 {moduleName}。联系您的管理员来获取帮助。',
    'EXCEPTION_CHANGE_MODULE_CONFIG_NOT_AUTHORIZED' => '当前用户无权更改的 {moduleName} 配置设置',
    'EXCEPTION_ACCESS_MODULE_CONFIG_NOT_AUTHORIZED' => '当前用户无权更改的 {moduleName} 配置设置',
    'EXCEPTION_FAVORITE_MODULE_NOT_AUTHORIZED' => '您无权收藏{moduleName}。如果你需要访问与管理员联系。',
    'EXCEPTION_SUBSCRIBE_MODULE_NOT_AUTHORIZED' => '您无权订阅{moduleName}。如果你需要访问与管理员联系。',

    //Quotes Config Api Specific exceptions
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS' => 'worksheet_columns is not an array',
    'EXCEPTION_MISSING_WORKSHEET_COLUMNS_RELATED_FIELDS' => '有效荷载中未找到 worksheet_columns_related_fields ',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS' => 'summary_columns 不是一个数组',
    'EXCEPTION_MISSING_SUMMARY_COLUMNS_RELATED_FIELDS' => '有效荷载中未找到 summary_columns_related_fields',
    'EXCEPTION_MISSING_FOOTER_ROWS' => 'footer_rows 不是一个数组',
    'EXCEPTION_MISSING_FOOTER_ROWS_RELATED_FIELDS' => '有效荷载中未找到 footer_rows_related_fields ',

    // Default SugarApiException error messages
    'EXCEPTION_UNKNOWN_EXCEPTION' => '您的请求由于未知原因失败。',
    'EXCEPTION_FATAL_ERROR' => '您的请求没有完成。一个严重错误已出现。检查日志来获得更多信息。',
    'EXCEPTION_NEED_LOGIN' => '您必须登陆来执行这个操作。',
    'EXCEPTION_INVALID_TOKEN' => '您的身份验证是无效的。',
    'EXCEPTION_NOT_AUTHORIZED' => '您没有权限完成这个操作。联系您的管理员来获得帮助。',
    'EXCEPTION_NOT_AUTHORIZED_TO_DATA' => '您没有权限查看数据 。联系您的管理员来获取帮助。',
    'EXCEPTION_INACTIVE_PORTAL_USER' => '您不能访问门户网站，因为门户网站的帐户处于非激活状态。如果你需要访问，请联系客户支持。',
    'EXCEPTION_PORTAL_NOT_CONFIGURED' => '门户没有被正确配置。联系您的门户管理员来获得帮助。',
    'EXCEPTION_NO_METHOD' => '您的请求不只好吃。无法找到您请求路径的HTTP类型。',
    'EXCEPTION_NOT_FOUND' => '您请求的资源无法找到。无法找到请求中指定路径的处理器。',
    'EXCEPTION_MISSING_PARAMTER' => '您请求中一个必须的参数丢失。',
    'EXCEPTION_INVALID_PARAMETER' => '您请求中一个参数无效。',
    'EXCEPTION_REQUEST_FAILURE' => '您的请求无法完成。',
    'EXCEPTION_METADATA_OUT_OF_DATE' => '您的元数据或用户的哈希值与服务器不匹配。请重新同步元数据。',
    'EXCEPTION_REQUEST_TOO_LARGE' => '您的请求太大无法处理。',
    'EXCEPTION_EDIT_CONFLICT' => '编辑冲突，请重新记录数据。',
    'EXCEPTION_METADATA_CONFLICT' => '元数据的冲突，请重新载入数据。',
    'EXCEPTION_CLIENT_OUTDATED' => '您的软件是过时了，请更新您的客户端，然后再次尝试连接。',
    'EXCEPTION_CONNECTOR_RESPONSE' => '连接器或整合请求导致失败反应。',
    'EXCEPTION_MAINTENANCE' => 'SugarCRM处在维护模式。只有管理员可以登录。请与您的管理员。',
    'EXCEPTION_SERVICE_UNAVAILABLE' => '服务器无法处理您的请求，因为此时服务器繁忙或不可用。',
    'EXCEPTION_SEARCH_UNAVAILABLE' => '搜索引擎暂时不可用。',
    'EXCEPTION_SEARCH_RUNTIME' => '搜索引擎运行时出错。请联系您的系统管理员。',
    'EXCEPTION_INVALID_PLATFORM' => 'Invalid platform specified.',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT' => '流程锁定的字段不能进行编辑。',
    'EXCEPTION_MODULE_DISABLED' => '此模块已针对当前用户禁用。',
    'EXCEPTION_FIELD_DISABLED' => '此字段已针对当前用户禁用。',
    'EXCEPTION_CLIENT_NOT_ALLOWED' => '此客户端不受允许',
    'EXCEPTION_MODULELOADER_UPLOAD' => '上传软件包的功能不适用于您的许可证类型',
    // Default SugarApiException descriptions, used in the exceptions help endpoint
    'EXCEPTION_UNKNOWN_EXCEPTION_DESC' => '错误条件。',
    'EXCEPTION_FATAL_ERROR_DESC' => '无法处理该操作或反馈出错。这通常由于发生一个致命错误，该错误可以在程序日志中看到。',
    'EXCEPTION_INCORRECT_VERSION_DESC' => '这条指令和您正在使用的API版本不正确。',
    'EXCEPTION_NEED_LOGIN_DESC' => '请求端未被验证。',
    'EXCEPTION_INVALID_TOKEN_DESC' => '认证密钥无效，这可能是因为密钥过期或不正确。',
    'EXCEPTION_NOT_AUTHORIZED_DESC' => '顾客未被验证无法执行该命令。',
    'EXCEPTION_INACTIVE_PORTAL_USER_DESC' => '用户相关的前台账号未被激活，请联系客服。',
    'EXCEPTION_PORTAL_NOT_CONFIGURED_DESC' => '说明前台程序没有正确配置或没有正被使用，这需要前台程序管理员来采取行动。',
    'EXCEPTION_NO_METHOD_DESC' => '终端不支持 HTTP 请求类型，比如这可能是 POST 请求发给了只支持 GET 请求的终端。',
    'EXCEPTION_NOT_FOUND_DESC' => '终端无法定位请资源，或者没有处理器(handler)处理该请求。',
    'EXCEPTION_EDIT_CONFLICT_DESC' => '可能有其他修改在同时进行，此修改可能会对该记录的之前修改产生影响。',
    'EXCEPTION_METADATA_OUT_OF_DATE_DESC' => '服务器和客户端的metadata不符合。这可能是由于系统设置改变造成，或者工作室的模块变更或新模块部署造成。',
    'EXCEPTION_REQUEST_TOO_LARGE_DESC' => '请求太大无法被服务器处理。',
    'EXCEPTION_MISSING_PARAMTER_DESC' => '该请求的必要参数缺失',
    'EXCEPTION_INVALID_PARAMETER_DESC' => '此请求的参数无效。',
    'EXCEPTION_REQUEST_FAILURE_DESC' => '此请求无法完成。',
    'EXCEPTION_CLIENT_OUTDATED_DESC' => 'API 已过期，请更新。',
    'EXCEPTION_CONNECTOR_RESPONSE_DESC' => '表示通过 API 发出请求给另一服务、结束点或URL已失败或无法经服务器处理。',
    'EXCEPTION_MAINTENANCE_DESC' => '此SugarCRM实例处于维护模式，API访问仅限于管理员。',
    'EXCEPTION_SERVICE_UNAVAILABLE_DESC' => '指示服务器繁忙、 过载或故障。',
    'EXCEPTION_SEARCH_UNAVAILABLE_DESC' => '由于连接问题，搜索引擎后端暂时不可用。请按照“管理>搜索>测试”确认连接和配置。',
    'EXCEPTION_SEARCH_RUNTIME_DESC' => '搜索引擎出现运行时异常。请访问 sugarcrm.log 查阅更多详情。',
    'EXCEPTION_INVALID_PLATFORM_DESC' => 'Indicates the platform specified during authenication is unknown. Custom platforms must be added to custom/client/platforms.php',
    'EXCEPTION_FIELD_LOCKED_FOR_EDIT_DESC' => '运行的流程当前锁定的字段不能进行编辑。',
    'EXCEPTION_FIELD_IS_LOCKED_FOR_EDIT' => '%s 被运行流程锁定，不能进行编辑。',
    'EXCEPTION_FIELDS_ARE_LOCKED_FOR_EDIT' => '%s 被运行流程锁定，不能进行编辑。',
    'EXCEPTION_MODULE_DISABLED_DESC' => '此模块已针对当前用户禁用。',
    'EXCEPTION_FIELD_DISABLED_DESC' => '此字段已针对当前用户禁用。',
    'EXCEPTION_CLIENT_NOT_ALLOWED_DESC' => '此客户端不受允许',

    //Lotus Live specific error messages
    'ERR_EXTERNAL_API_LOTUS_LIVE_CONFLICT' => '相同名字的文件已存在于系统中.',

    //Forecast specific error messages
    'ERR_TIMEPERIOD_UNDEFINED_FOR_DATE' => '日期 {0}时段为定义',
    'ERR_TIMEPERIOD_ALREADY_HAS_LEAVES' => '此时段已有子周期',
    'ERR_TIMEPERIOD_ALREADY_LEAF' => '子时间段不能有子周期',
    'ERR_TIMEPERIOD_TYPE_DOES_NOT_EXIST' => '无法检索任何时间周期类型：{0}',
    'ERR_NO_ACTIVE_TIMEPERIOD' => '可用时段不适用于当前设置。',
    'LBL_CURRENT_TIMEPERIOD' => '当前时间周期',
    'LBL_PREVIOUS_TIMEPERIOD' => '上个时间周期',
    'LBL_NEXT_TIMEPERIOD' => '下个时间周期',
    'LBL_PREVIOUS_CURRENT_NEXT_TIMEPERIODS' => '上一个,当前,下一个',

    'NOTICE_NO_DELETE_CLOSED_STAGE' => '您不能删除带关闭销售阶段的记录。',
    'NOTICE_NO_DELETE_CLOSED_STATUS' => '您不能删除带关闭销售状态的记录。',

    'WARNING_NO_DELETE_SELECTED_STAGE' => '一个或多个所选的记录带有谈成结束或丢单结束的销售阶段，不能删除。',
    'WARNING_NO_DELETE_SELECTED_STATUS' => '一个或多个所选的记录带有谈成结束或丢单结束的状态，不能删除。',
    'WARNING_NO_DELETE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be deleted.',

    'WARNING_NO_MASSUPDATE_SELECTED_STAGE' => 'One or more of the selected records has a sales stage of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_SELECTED_STATUS' => 'One or more of the selected records has a status of Closed Won or Closed Lost and cannot be mass updated.',
    'WARNING_NO_MASSUPDATE_CLOSED_SELECTED_STATUS' => 'One or more of the selected records has a Revenue Line Item with status of ' .
        'Closed Won or Closed Lost and cannot be mass updated.',

    'LBL_ACCOUNT' => '帐户',
    'LBL_OLD_ACCOUNT_LINK' => '旧账号',
    'LBL_ACCOUNTS' => '帐户',
    'LBL_ACTIVITIES_SUBPANEL_TITLE' => '活动',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => '查看摘要',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => '查看摘要 [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => '添加',
    'LBL_ADD_BUTTON' => '添加',
    'LBL_ADD_DASHLET_BUTTON' => '添加仪表',
    'LBL_ADD_DOCUMENT' => '增加文档',
    'LBL_REPLACE_BUTTON' => '替代',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => '添加到目标列表',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => '添加到目标列表',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => '点击关闭',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => '关闭',
    'LBL_ADDITIONAL_DETAILS' => '额外细节',
    'LBL_ADMIN' => '系统管理',
    'LBL_ALT_HOT_KEY' => '',
    'LBL_ARCHIVE' => '存档',
    'LBL_ASSIGNED_TO_USER' => '负责人',
    'LBL_ASSIGNED_TO' => '负责人：',
    'LBL_BACK' => '上一步',
    'LBL_BASE_RATE' => '基本利率',
    'LBL_BILL_TO_ACCOUNT' => '付款客户',
    'LBL_BILL_TO_CONTACT' => '付款联系人',
    'LBL_BILLING_ADDRESS' => '账单地址',
    'LBL_QUICK_CREATE_TITLE' => '快速创建',
    'LBL_BROWSER_TITLE' => 'SugarCRM',
    'TPL_BROWSER_SUGAR7_RECORDS_TITLE' => '{{module}} &raquo; {{appId}}',
    'TPL_BROWSER_SUGAR7_RECORD_TITLE' => '{{#if name}}{{name}} &raquo; {{/if}}{{module}} &raquo; {{appId}}',
    'LBL_BUGS' => '缺陷追踪',
    'LBL_BY' => '通过',
    'LBL_CALLS' => '电话',
    'LBL_CALL' => '电话',
    'LBL_CAMPAIGNS_SEND_QUEUED' => '发送队列中的市场活动邮件',
    'LBL_SUBMIT_BUTTON_LABEL' => '提交',
    'LBL_CASE' => '客户反馈',
    'LBL_CASES' => '客户反馈',
    'LBL_MESSAGE' => '消息',
    'LBL_MESSAGES' => '消息',
    'LBL_ESCALATIONS' => '升级',
    'LBL_ESCALATION' => '升级',
    'LBL_DOCUSIGN_ENVELOPES' => 'DocuSign 信封',
    'LBL_DOCUSIGN_ENVELOPE' => 'DocuSign 信封',
    'LBL_DOCUSIGN_SELECT_RECIPIENTS' => '选择签名者收件人',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_PASSWORD' => '修改密码',
    'LBL_CHANGE_BUTTON_LABEL' => '更改',
    'LBL_CHANGE_BUTTON_TITLE' => '更改 [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => '全选',
    'LBL_CITY' => '城市',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => '清除',
    'LBL_CLEAR_BUTTON_TITLE' => '清除 [Alt+C]',
    'LBL_CLEARALL' => '清除全部',
    'LBL_CLICK_TO_EDIT' => 'Click to Edit',
    'LBL_CLOSE_BUTTON_TITLE' => '关闭',
    'LBL_CLOSE_BUTTON_KEY' => 'Q',
    'LBL_CLOSE_WINDOW' => '关闭窗口',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => '全部关闭',
    'LBL_CLOSEALL_BUTTON_TITLE' => '全部关闭 [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => '关闭并且新增',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => '关闭并且新增',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COPY_RECORD_URL' => '复制记录 URL',
    'LBL_OPEN_ITEMS' => '开放项目:',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => '撰写电子邮件',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL2' => '电子邮件',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => '撰写电子邮件[Alt+L]',
    'LBL_SEARCH_DROPDOWN_YES' => '是',
    'LBL_SEARCH_DROPDOWN_NO' => '否',
    'LBL_CONTACT_LIST' => '联系人列表',
    'LBL_CONTACT' => '连体人',
    'LBL_CONTACTS' => '联系人',
    'LBL_CONTRACTS' => '合同',
    'LBL_COUNTRY' => '国家/地区：',
    'LBL_RESET_BUTTON_LABEL' => '重置',
    'LBL_CREATE_BUTTON_LABEL' => '创建',
    'LBL_CREATED_BY_USER' => '由用户创建',
    'LBL_CREATED_USER' => '由用户创建',
    'LBL_CREATED_ID' => '创建人 ID',
    'LBL_CREATED' => '创建人',
    'LBL_CREATE_NEW_TARGET_LIST' => '创建新的目标列表',
    'LBL_CURRENT_USER_FILTER' => '我的项目：',
    'LBL_CURRENCY' => '货币:',
    'LBL_CURRENCIES' => '货币',
    'LBL_CURRENCY_NAME' => '货币名称',
    'LBL_CURRENCY_SYMBOL' => '货币符号:',
    'LBL_CURRENCY_RATE' => '汇率',
    'LBL_CURRENCY_ID' => '货币 ID',
    'LBL_DOCUMENTS' => '文档',
    'LBL_DATE_ENTERED' => '创建日期：',
    'LBL_DATE_MODIFIED' => '修改日期:',
    'LBL_ACTIVITY_MODIFIED' => '已修改',
    'LBL_EDIT_OVERVIEW_TAB_BUTTON' => '编辑概述选项卡',
    'LBL_EDIT_MODULE_TABS_BUTTON' => '编辑模块选项卡',
    'LBL_EDIT_BUTTON' => '编辑',
    'LBL_DUPLICATE_BUTTON' => '复制',
    'LBL_DELETE_BUTTON' => '删除',
    'LBL_DELETE' => '删除',
    'LBL_DELETED' => '已删除',
    'LBL_DIRECT_REPORTS' => '直接报告人',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => '完成',
    'LBL_DONE_BUTTON_TITLE' => '完成 [Alt+X]',
    'LBL_DST_NEEDS_FIXIN' => '应用程序需要设置夏令时，请转制管理员控制台下的 <a href="index.php?module=Administration&action=DstFix"> 修复</a> 链接，应用夏令时的修复程序。',
    'LBL_EDIT_AS_NEW_BUTTON_LABEL' => '编辑时新建',
    'LBL_EDIT_AS_NEW_BUTTON_TITLE' => '编辑时新建',
    'LBL_EDIT_IN_NEW_TAB' => '在新选项卡中编辑',
    'LBL_FAVORITES' => '收藏夹',
    'LBL_FILTER' => '筛选器:',
    'LBL_DEFAULT_DATA_FILTER' => '默认数据过滤',
    'LBL_FILTER_MENU_BY' => '筛选菜单根据',
    'LBL_FILTER_SELECT_FIELD' => '选择字段',
    'LBL_FILTER_SELECT_OPERATOR' => '选择运营商',
    'LBL_FILTER_CREATE_NEW' => '创建',
    'LBL_FILTER_CREATE_NEW_UNSAVED' => '生成筛选器（未保存）',
    'LBL_FILTER_EDIT_UNSAVED_SUFFIX' => '（未保存）',
    'LBL_FILTER_CREATE_FILTER' => '创建新筛选器',
    'LBL_FILTER_CLOSE_FILTER' => '关闭筛选器',
    'LBL_FILTER_EDIT_FILTER' => '编辑筛选器',
    'LBL_FILTER_ALL_RECORDS' => '所有记录',
    'TPL_FILTER_SAVE' => '成功创建筛选器{{name}}.',
    'LBL_FILTER_BETWEEN_FROM' => '来自',
    'LBL_FILTER_BETWEEN_TO' => '到',
    'LBL_FILTER_DATEBETWEEN_FROM' => '开始日期',
    'LBL_FILTER_DATEBETWEEN_TO' => '结束日期',
    'LBL_FOLLOWING' => '已关注',
    'LBL_UNFOLLOW' => '取消关注',
    'LBL_VCARD' => '电子名片',
    'LBL_VCARD_DOWNLOAD' => '下载 .vcf',
    'LBL_EMPTY_VCARD' => '请选择一个 vCard 文件',
    'LBL_IMAGE' => '图片',
    'LBL_EMPTY_REQUIRED_VCARD' => 'vCard没有包含此模块所有必填项。',
    'LBL_VCARD_ERROR_FILESIZE' => '上传的文件超过了HTML的30000字节限制。',
    'LBL_VCARD_ERROR_DEFAULT' => '上传vCard文件出错。',
    'TPL_IMPORT_VCARD_FAILURE' => '从 vCard创建 {{module}} 失败',
    'LBL_IMPORT_VCARD' => '导入 vCard:',
    'LBL_IMPORT_VCARD_BUTTON_KEY' => 'I',
    'LBL_IMPORT_VCARD_BUTTON_LABEL' => '导入 vCard',
    'LBL_IMPORT_VCARD_BUTTON_TITLE' => '导入 vCard',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => '查看',
    'LBL_VIEW_BUTTON_TITLE' => '查看',
    'LBL_VIEW_BUTTON' => '查看',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => '以PDF格式发送电子邮件',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => '以PDF格式发送电子邮件 [Alt+M]',
    'LBL_EMAIL' => '电子邮件',
    'LBL_EMAILS' => '电子邮件',
    'LBL_EMPLOYEES' => '员工',
    'LBL_ENTER_DATE' => '输入日期',
    'LBL_EXPORT_ALL' => '全部导出',
    'LBL_EXPORT' => '导出',
    'LBL_FAVORITES_FILTER' => '我的收藏夹：',
    'LBL_GLOBAL_SEARCH' => '全局搜索',
    'LBL_GLOBAL_SEARCH_MODULE_FILTER' => '全局搜索模块筛选器',
    'LBL_GLOBAL_SEARCH_RUN' => '运行全局搜索',
    'LBL_GO_BUTTON_LABEL' => '开始',
    'LBL_GS_HELP' => '此次搜索的字段在该模版显示如上.着重显示的内容与您的搜索条件相符.',
    'LBL_HIDE' => '隐藏',
    'LBL_ID' => '编号',
    'LBL_IMPORT' => '导入',
    'LBL_IMPORT_STARTED' => '已开始导入：',
    'LBL_MISSING_CUSTOM_DELIMITER' => '必须指定一个字定义的分隔符。',
    'LBL_LAST_VIEWED' => '最近查看的',
    'LBL_SELECTED_RECORDS' => '已选择: ',
    'TPL_MAX_PILLS_DISPLAYED' => 'Only {{maxPillsDisplayed}} records are shown.',
    'TPL_MORE_RECORDS' => '{{recordsLeft}} more records selected.',
    'TPL_RECORDS_SELECTED' => '{{recordsLeft}} records selected.',
    'LBL_SHOW_LESS' => '简略显示',
    'LBL_SHOW_MORE' => '显示更多',
    'LBL_SHOW_MORE_MODULE' => '更多 {{{module}}}...',
    'LBL_SHOW_MORE_RECENTS' => '更多近期记录...',
    'LBL_SHOW_LESS_RECENTS' => '更少...',
    'LBL_SHOW_MORE_RESULTS' => '更多搜索结果……',
    'TPL_SHOW_MORE_MODULE' => '更多 {{module}}...',
    'LBL_SHOW_MORE_GENERIC' => '更多{{name}}...',
    'LBL_TODAYS_ACTIVITIES' => '今日市场活动',
    'LBL_LEADS' => '潜在客户',
    'LBL_LEAD' => '潜在客户',
    'LBL_QUOTES_BILL_TO' => '报价（账单抬头）',
    'LBL_LESS' => '少于',
    'LBL_CAMPAIGN' => '市场活动:',
    'LBL_CAMPAIGNS' => '市场扩东',
    'LBL_CAMPAIGNLOG' => '市场活动日志',
    'LBL_CAMPAIGN_CONTACT' => '市场活动',
    'LBL_CAMPAIGN_ID' => 'campaign_id',
    'LBL_THEME' => '主题：',
    'LBL_THEME_PICKER' => '页面样式',
    'LBL_THEME_PICKER_IE6COMPAT_CHECK' => '警告：所选主题不支持 IE 6。点击确定应用所选主题，或者点击取消选择其他主题。',
    'LBL_FOUND_IN_RELEASE' => '在发布版本中存在',
    'LBL_FIXED_IN_RELEASE' => '在现有版本上修复',
    'LBL_LIST_ACCOUNT_NAME' => '账户名称',
    'LBL_LIST_ASSIGNED_USER' => '用户',
    'LBL_LIST_CONTACT_NAME' => '联系人姓名',
    'LBL_LIST_CONTACT_ROLE' => '联系人角色',
    'LBL_LIST_DATE_ENTERED' => '创建日期',
    'LBL_LIST_EMAIL' => '电子邮件',
    'LBL_LIST_NAME' => '名称',
    'LBL_LIST_OF' => '的',
    'LBL_LIST_PHONE' => '电话',
    'LBL_LIST_RELATED_TO' => '关联到',
    'LBL_LIST_USER_NAME' => '用户名称',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => '您确定您要更新整个列表？',
    'LBL_LISTVIEW_NO_SELECTED' => '请选择至少1条记录进行操作。',
    'LBL_LISTVIEW_TWO_REQUIRED' => '请选择至少2条记录进行操作。',
    'LBL_LISTVIEW_LESS_THAN_TEN_SELECT' => '请选择10条以下的记录来执行操作',
    'LBL_LISTVIEW_ALL' => '全部',
    'LBL_LISTVIEW_FREEZE_COLUMN_1' => '冻结第 1 列',
    'LBL_DUPECHECK_FILTER_DEFAULT' => '所有重复',
    'LBL_LISTVIEW_NONE' => '删除全部',
    'LBL_LISTVIEW_OPTION_CURRENT' => '选择此页',
    'LBL_LISTVIEW_OPTION_ENTIRE' => '选择全部',
    'LBL_LISTVIEW_OPTION_SELECTED' => '已选择的记录',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => '已选择: ',
    'LBL_LISTVIEW_SELECTED_CLEAR' => '清除所有选择。',
    'LBL_LISTVIEW_SELECT_ALL_RECORDS' => '选择所有记录',
    'TPL_LISTVIEW_SELECTED_FIRST_OFFSET' => '结果中有超出 {{num}} 记录. 您已经选择了前 {{num}} 记录.',
    'TPL_LISTVIEW_SELECTED' => '您已经选择了结果中的 {{num}} 记录.',
    'TPL_LISTVIEW_SELECTED_ONE' => '您已经选择了结果集中的 1 条记录。',
    'TPL_LISTVIEW_SELECTED_ALL' => '您已经选择了结果中的全部 {{num}}记录.',
    'TPL_LISTVIEW_SELECT_ALL_RECORDS' => '您已经选择了此视图中的全部 {{num}} 记录. {{link}} .',
    'TPL_MASSUPDATE_PROGRESS_STATUS' => '在 {{total}}条记录中上传 {{num}} 条',
    'TPL_MASSUPDATE_DURATION_FORMAT' => '(尚存约{{time}} {{unit}})',
    'TPL_MASSUPDATE_FAIL_TO_ATTEMPT' => '批量更新失败，重新尝试({{num}} of {{total}}).',
    'TPL_MASSUPDATE_WARNING_CLOSE' => '批量更新未完成. {{num}}条记录无变化.',
    'TPL_MASSUPDATE_WARNING_INCOMPLETE' => '批量更新未完成. {{num}}条记录无变化.',
    'TPL_MASSUPDATE_WARNING_PERMISSION' => '由于权限或错误，{{remain}}个记录被忽略。',
    'TPL_MASSUPDATE_SUCCESS' => '{{num}}条记录更新成功',
    'TPL_MASSUPDATE_TITLE' => '{{module}}批量更新',
    'TPL_MASSDELETE_PROGRESS_STATUS' => '在 {{total}}条记录中删除 {{num}} 条',
    'TPL_MASSDELETE_DURATION_FORMAT' => '(尚存约{{time}} {{unit}})',
    'TPL_MASSDELETE_FAIL_TO_ATTEMPT' => '批量删除失败. 重新尝试 ({{num}} of {{total}}).',
    'TPL_MASSDELETE_WARNING_CLOSE' => '批量删除失败. {{num}} record(s) remain.',
    'TPL_MASSDELETE_WARNING_INCOMPLETE' => '批量删除失败. {{num}} record(s) remain.',
    'TPL_MASSDELETE_SUCCESS' => '{{num}} record(s) 已经成功删除。',
    'TPL_MASSDELETE_TITLE' => '{{module}}批量删除',
    'TPL_MASSADDTOLIST_PROGRESS_STATUS' => '增加 {{num}} of {{total}}.',
    'TPL_MASSADDTOLIST_DURATION_FORMAT' => '(尚存约{{time}} {{unit}})',
    'TPL_MASSADDTOLIST_FAIL_TO_ATTEMPT' => '批量添加到目标列表失败. Initiating new attempt ({{num}} of {{total}}).',
    'TPL_MASSADDTOLIST_WARNING_CLOSE' => '批量添加到目标列表未完成. {{num}}条 records没有加入.',
    'TPL_MASSADDTOLIST_WARNING_INCOMPLETE' => '批量添加到目标列表未完成. {{num}}条 records没有加入.',
    'TPL_MASSADDTOLIST_SUCCESS' => '{{num}}条 records已经成功添加.',
    'TPL_MASSADDTOLIST_TITLE' => '{{module}} 批量添加到目标列表',
    'TPL_MASSLINK_PROGRESS_STATUS' => '链接 {{num}} 和 {{total}}.',
    'TPL_MASSLINK_DURATION_FORMAT' => '(尚存约{{time}} {{unit}})',
    'TPL_MASSLINK_FAIL_TO_ATTEMPT' => '批量链接失败，重新尝试，({{num}} of {{total}})',
    'TPL_MASSLINK_WARNING_CLOSE' => '批量链接未完成.{{num}}记录未添加.',
    'TPL_MASSLINK_WARNING_INCOMPLETE' => '批量链接未完成.{{num}}记录未添加.',
    'TPL_MASSLINK_SUCCESS' => '{{num}} 记录已经成功连接。',
    'TPL_MASSLINK_TITLE' => '{{module}} 批量连接',

    'LBL_LISTVIEW_SELECT_AND_EDIT' => '选择',
    'LBL_LISTVIEW_ACTIONS' => '操作',

    'LBL_LISTVIEW_SELECT_ALL_ON_PAGE' => '选择此页面上的所有记录',
    'LBL_LISTVIEW_DESELECT_ALL_ON_PAGE' => '取消选择此页面上的所有记录',

    'TPL_LIST_HEADER_COUNT' => '{{num}}',
    'TPL_LIST_HEADER_COUNT_PARTIAL' => '{{num}}+',
    'TPL_LIST_HEADER_COUNT_TOTAL' => '{{num}} / {{total}}',
    'TPL_LIST_HEADER_COUNT_LOADING' => '加载的 {{num}} 条',
    'TPL_LIST_HEADER_COUNT_TOOLTIP' => '点击查看全部',
    // List View Pagination
    'LBL_LIST_PAGINATION_OF' => '的',
    'LBL_GET_PAGE_COUNT_TOOLTIP' => '获取页数',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => '大卫',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => '利文斯通',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => '先生.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => '异常代码',
    'LBL_LOGIN_TO_ACCESS' => '请登录以访问这个区域。',
    'LBL_LOGOUT' => '退出',
    'LBL_FINISH_IMPERSONATING' => '结束模仿',
    'LBL_RESET_MFA' => '重置多因素验证',
    'LBL_YOU_ARE_CURRENTLY_IMPERSONATING' => '{{sudoer}}，您目前正在模仿 {{user}}.',
    'LBL_PROFILE' => '用户资料',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => '邮件合并',
    'LBL_MASS_UPDATE' => '批量更新',
    'LBL_MASS_UPDATE_ALL_RECORDS' => '选择所有记录进行批量更新',
    'LBL_MASS_UPDATE_SINGLE_RECORD' => '将记录包含在批量更新中',
    'LBL_MASS_UPDATE_ADD_FIELD' => '添加字段',
    'LBL_MASS_UPDATE_REMOVE_FIELD' => '删除字段',
    'LBL_GENERATE_QUOTE' => '生成报价',
    'LBL_NO_MASS_UPDATE_FIELDS_AVAILABLE' => '没有批量更新的匹配项',
    'LBL_MASS_UPDATE_JOB_QUEUED' => '您批量更新的请求已经被安排',
    'LBL_MASS_UPDATE_WARNING_SERVICE_START_DATE' => '服务开始日期晚于服务结束日期',
    'LBL_MASS_UPDATE_SUCCESS' => '所有记录已完成更新',
    'TPL_MASS_ADD_TO_LIST_SUCCESS' => '所选记录已被添加到 <a href="{{listUrl}}">{{listName}}</a>目标列表。',
    'TPL_MASS_ADD_TO_LIST_QUEUED' => '您批量更新到<a href="{{listUrl}}">{{listName}}</a> 目标列表的请求已经被安排。',
    'LBL_MASS_UPDATE_EMPTY_VALUES' => '以下属性有空值：',
    'LBL_MASS_UPDATE_EMPTY_CONFIRM' => '现有值将被替换为空值。您要继续吗？',
    'LBL_OPT_OUT_FLAG_PRIMARY' => '主邮箱添加剔除标记',
    'LBL_MEETINGS' => '会议',
    'LBL_MEETING' => '会议',
    'LBL_MEETING_GO_BACK' => '回到会议',
    'LBL_MEMBERS' => '成员',
    'LBL_MEMBER_OF' => '成员',
    'LBL_MODIFIED_BY_USER' => '由用户修改',
    'LBL_MODIFIED_USER' => '由用户修改',
    'LBL_MODIFIED' => '修改人',
    'LBL_MODIFIED_NAME' => '修改人姓名',
    'LBL_MODIFIED_ID' => '修改人 ID',
    'LBL_MORE' => '更多',
    'LBL_MORE_MODULES' => '更多模块',
    'LBL_MORE_TABS' => '更多标签',
    'LBL_MULTIPLE_MODULES' => '多模块',
    'LBL_COUNT_MODULES' => '{{count}} 模块',
    'LBL_MY_ACCOUNT' => '我的设置',
    'LBL_SYSTEM_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => '系统默认',
    'LBL_USER_DEFAULT_OUTBOUND_EMAIL_CONFIGURATION' => '用户默认',
    'LBL_USER_OUTBOUND_EMAIL_ACCOUNT_CONFIGURATION' => '用户账户',
    'LBL_GROUP_EMAIL_ACCOUNT_CONFIGURATION' => '组账户',
    'LBL_OUTBOUND_EMAIL_CONFIGURATION_DISPLAY_NAME' => '{0} ({1}) - [{2}]',
    'LBL_NAME' => '名称',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => '创建',
    'LBL_NEW_BUTTON_TITLE' => '创建',
    'LBL_NEXT_BUTTON_LABEL' => '下一步',
    'LBL_NOTES' => '笔记',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => '全部开放',
    'LBL_OPENALL_BUTTON_TITLE' => '全部开放 [Alt+O]',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => '开放到：',
    'LBL_OPENTO_BUTTON_TITLE' => '开放到：',
    'LBL_OPEN_IN_NEW_TAB' => '在新选项卡中打开',
    'LBL_OPPORTUNITIES' => '商业机会',
    'LBL_OPPORTUNITY_NAME' => '商业机会名称',
    'LBL_OPPORTUNITY' => '商业机会',
    'LBL_OR' => 'OR',
    'LBL_LOWER_OR' => '或者',
    'LBL_PANEL_ASSIGNMENT' => '其他',
    'LBL_PANEL_ADVANCED' => '更多信息',
    'LBL_PANEL_BODY' => '概述',
    'LBL_PARENT_TYPE' => '父类型',
    'LBL_RELATED_TYPE' => '相关类型',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_PHASE' => '阶段',
    'LBL_PICTURE_FILE' => '阿凡达',
    'LBL_POSTAL_CODE' => '邮编：',
    'LBL_PRIMARY_ADDRESS_CITY' => '主要住址城市：',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => '主要住址国家/地区：',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => '主要住址邮政编码：',
    'LBL_PRIMARY_ADDRESS_STATE' => '主要住址省份：',
    'LBL_PRIMARY_ADDRESS_STREET_2' => '主要地址街道2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => '主要地址街道 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => '主要住址街道：',
    'LBL_PRIMARY_ADDRESS' => '主要地址：',

    'LBL_BILLING_STREET' => '街道：',
    'LBL_SHIPPING_STREET' => '街道：',

    'LBL_PRODUCT_BUNDLES' => '产品包',
    'LBL_PRODUCTS' => '产品',
    'LBL_PROJECT_TASKS' => '项目任务',
    'LBL_PRODUCT_TEMPLATES' => '产品模板',
    'LBL_PROJECTS' => '项目',
    'LBL_PROSPECTS' => '目标',
    'LBL_QUICK_CREATE_MENU' => '快速创建菜单',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => '根据报价创建商业机会',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => '根据报价创建商业机会[Alt+O]',
    'LBL_QUOTE_TO_OPPORTUNITY_STATUS' => '创建商业机会......',
    'LBL_QUOTES_SHIP_TO' => '报价运往到',
    'LBL_QUOTES' => '报价',

    'LBL_FORECAST_WORKSHEETS' => '预测工作表',
    'LBL_FORECAST_WORKSHEET' => '预测工作表',

    // Strings for Instance Picker Widget
    'LBL_INVITE' => '邀请',
    'LBL_INVITED' => '邀请',
    'LBL_RECOMMENDED_INVITES' => '建议邀请',
    'LBL_INSTANCES' => '实例',
    'LBL_YOUR_INSTANCES' => '您的实例',
    'LBL_INSTANCE_USERS' => '实例用户',
    'LBL_SWITCH_INSTANCE' => '切换到该实例',
    'LBL_LAST_LOGIN' => '最后登录',
    'LBL_ENTER_EMAIL' => '输入受邀者的电子邮件...',
    'LBL_INSTANCE_IN_USE' => '实例使用中',
    'LBL_INSTANCE_ACTIVE' => '您已经在使用该实例',
    'LBL_INSTANCE_INVITE_SENT' => '邀请发送到',
    'LBL_INSTANCE_SWITCH_FAILED' => '无法切换实例',

    // Strings for Reminder Widget
    'LBL_REMINDERS' => '提醒',
    'LBL_REMINDERS_OVERDUE' => '过期的',
    'LBL_REMINDERS_UPCOMING' => '即将到来',
    'LBL_REMINDERS_NONE_FOUND' => '没有找到提醒。',
    'LBL_REMINDERS_FINISHED' => '完成！',

    // Strings for Opportunity Metrics dashlet
    'LBL_OPPORTUNITY_METRICS' => '商业机会指标',

    'LBL_SWEETSPOT' => '最优点位',
    'LBL_SWEETSPOT_CONFIG' => '最优点位配置控制板',
    'LBL_SWEETSPOT_CONFIG_HOTKEYS' => '快捷键',
    'LBL_SWEETSPOT_CONFIG_ERR' => '升级配置的参数选择失败：{{errorMsg}}',
    'LBL_SWEETSPOT_ACTION' => '最优点位动作',
    'LBL_SWEETSPOT_KEY' => '关键词',
    'LBL_SWEETSPOT_REMOVE' => '移除动作',
    'LBL_SWEETSPOT_KEYWORDS_SECTION' => '快捷键',
    'LBL_SWEETSPOT_ACTIONS_SECTION' => '动作',
    'LBL_SWEETSPOT_RECORDS_SECTION' => '记录',
    'LBL_SWEETSPOT_THEME' => '主题',
    'LBL_SWEETSPOT_THEME_SELECT' => '选择主题',

    'LBL_RELATED' => '关联',
    'LBL_RELATED_INFORMATION' => '相关信息',
    'LBL_RELATED_RECORDS' => '相关 {{module}}',
    'LBL_REPORTS_TO' => '汇报对象',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_REQUIRED_TITLE' => '表示必填字段',
    'LBL_EMAIL_DONE_BUTTON_LABEL' => '完成',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => '另存为',
    'LBL_SAVE_AS_BUTTON_TITLE' => '另存为 [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => '完全式',
    'LBL_FULL_FORM_BUTTON_TITLE' => '完全式 [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => '保存并且新增',
    'LBL_SAVE_NEW_BUTTON_TITLE' => '保存并且新增 [Alt+V]',
    'LBL_SAVE_OBJECT' => '保存 {0}',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => '查找',
    'LBL_SEARCH_BUTTON_TITLE' => '查找',
    'LBL_SEARCH' => '查找',
    'LBL_SEARCH_TIPS' => '点击搜索按钮或点回车键来获得他们的准确匹配。',
    'LBL_SEARCH_TIPS_2' => '点击搜索按钮或点回车键来获得准确匹配于',
    'LBL_SEARCH_MORE' => '更多',
    'LBL_SEE_ALL' => '查看所有',
    'LBL_SEARCH_LOAD_MORE' => '载入更多',
    'LBL_UPLOAD_IMAGE_FILE_INVALID' => '无效文件格式，只有图片格式的文件可以被上传。',
    'LBL_UPLOAD_IMAGE_FILE_NOT_SUPPORTED' => '图片格式 {0}不支持.',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => '选择',
    'LBL_SELECT_BUTTON_TITLE' => '选择 [Alt+T]',
    'LBL_SELECT_TEAMS_KEY' => 'Z',
    'LBL_SELECT_TEAMS_LABEL' => '添加团队',
    'LBL_SELECT_TEAMS_TITLE' => '添加团队',
    'LBL_SELECT_APPEND_TEAMS' => '追加团队',
    'LBL_SELECT_APPEND_VALUES' => '附加值',
    'LBL_SELECT_APPEND_TAGS' => '附加标签',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => '浏览文档',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => '浏览文档 [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => '选择联系人',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => '选择联系人[Alt+T]',
    'LBL_GRID_SELECTED_FILE' => '选择的文件',
    'LBL_GRID_SELECTED_FILES' => '选择的文件',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => '从报表中选择',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => '选择报表',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => '选择用户',
    'LBL_SELECT_USER_BUTTON_TITLE' => '选择用户 [Alt+U]',
    // Clear buttons take up too many keys, lets default the relate and collection ones to be empty
    'LBL_ACCESSKEY_CLEAR_RELATE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_RELATE_TITLE' => '清除选项',
    'LBL_ACCESSKEY_CLEAR_RELATE_LABEL' => '清除选项',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_TITLE' => '清除选项',
    'LBL_ACCESSKEY_CLEAR_COLLECTION_LABEL' => '清除选项',
    'LBL_ACCESSKEY_SELECT_FILE_KEY' => 'F',
    'LBL_ACCESSKEY_SELECT_FILE_TITLE' => '选择文件',
    'LBL_ACCESSKEY_SELECT_FILE_LABEL' => '选择文件',
    'LBL_ACCESSKEY_CLEAR_FILE_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_FILE_TITLE' => '清除文件',
    'LBL_ACCESSKEY_CLEAR_FILE_LABEL' => '清除文件',


    'LBL_ACCESSKEY_SELECT_USERS_KEY' => 'U',
    'LBL_ACCESSKEY_SELECT_USERS_TITLE' => '选择用户',
    'LBL_ACCESSKEY_SELECT_USERS_LABEL' => '选择用户',
    'LBL_ACCESSKEY_CLEAR_USERS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_USERS_TITLE' => '清除用户',
    'LBL_ACCESSKEY_CLEAR_USERS_LABEL' => '清除用户',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_KEY' => 'A',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_TITLE' => '选择账户',
    'LBL_ACCESSKEY_SELECT_ACCOUNTS_LABEL' => '选择账户',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_TITLE' => '清除账户',
    'LBL_ACCESSKEY_CLEAR_ACCOUNTS_LABEL' => '清除账户',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_KEY' => 'M',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_TITLE' => '选择市场活动',
    'LBL_ACCESSKEY_SELECT_CAMPAIGNS_LABEL' => '选择市场活动',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_TITLE' => '清除市场活动',
    'LBL_ACCESSKEY_CLEAR_CAMPAIGNS_LABEL' => '清除市场活动',
    'LBL_ACCESSKEY_SELECT_CONTACTS_KEY' => 'C',
    'LBL_ACCESSKEY_SELECT_CONTACTS_TITLE' => '选择联系人',
    'LBL_ACCESSKEY_SELECT_CONTACTS_LABEL' => '选择联系人',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_TITLE' => '清除联系人',
    'LBL_ACCESSKEY_CLEAR_CONTACTS_LABEL' => '清除联系人',
    'LBL_ACCESSKEY_SELECT_TEAMSET_KEY' => 'Z',
    'LBL_ACCESSKEY_SELECT_TEAMSET_TITLE' => '选择团队',
    'LBL_ACCESSKEY_SELECT_TEAMSET_LABEL' => '选择团队',
    'LBL_ACCESSKEY_CLEAR_TEAMS_KEY' => ' ',
    'LBL_ACCESSKEY_CLEAR_TEAMS_TITLE' => '清除团队',
    'LBL_ACCESSKEY_CLEAR_TEAMS_LABEL' => '清除团队',
    'LBL_SERVER_RESPONSE_RESOURCES' => '设计该页面所用的资源 (问题, 文档)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => '秒。',
    'LBL_SERVER_RESPONSE_TIME' => '服务器响应时间：',
    'LBL_SERVER_MEMORY_BYTES' => '字节',
    'LBL_SERVER_MEMORY_USAGE' => '服务器内存使用：{0} ({1})',
    'LBL_SERVER_MEMORY_LOG_MESSAGE' => '使用： - 模块：{0} - 操作：{1}',
    'LBL_SERVER_PEAK_MEMORY_USAGE' => '服务器高峰内存使用：{0} ({1})',
    'LBL_SHIP_TO_ACCOUNT' => '运输至账户',
    'LBL_SHIP_TO_CONTACT' => '运输至联系人',
    'LBL_SHIPPING_ADDRESS' => '装运地址',
    'LBL_SHORTCUTS' => '快捷方式',
    'LBL_SHOW' => '显示',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => '省份：',
    'LBL_STATUS_UPDATED' => '对于这个事件，您的状态已更新！',
    'LBL_STATUS_NOT_UPDATED' => '对于这个事件，您的状态还未更新！',
    'LBL_STATUS' => '状态:',
    'LBL_STREET' => '街道',
    'LBL_SUBJECT' => '主题',

    'LBL_INBOUNDEMAIL_ID' => '收件箱编号',
    'LBL_EAMP_ID' => '验证令牌 ID',

    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.

    'LBL_SUGAR_COPYRIGHT_SUB' =>
        '&copy; 2004-2024 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> ' .
        '保留所有权利。<br />SugarCRM、Sugar 和 3-D Cube 均为 SugarCRM Inc. 的注册商标。 ' .
        '该产品中使用或出现的任何其他公司和产品名称可能是' .
        '与此类名称有关的公司的商标。',

    // GENERIC JOB NOTIFICATIONS LABELS
    'LBL_JOB_NOTIFICATION_SUBJECT_GENERIC' => '计划的作业完成了',
    'LBL_JOB_NOTIFICATION_BODY_GENERIC' => '计划的作业成功执行',

    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_SUBJECT' => '您的Sugar实例的营收单项现在激活了',
    'LBL_JOB_NOTIFICATION_OPPS_WITH_RLIS_BODY' => '营收单项已在您的Sugar实例内启用，所有现有商业机会数据也经过处理。您的实例可以开始使用营收单项。欲知关于此变更的详情，请参阅{{doc_url}}。谢谢 SugarCRM',

    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_SUBJECT' => '预测模块现在可配合您的 Sugar 实例的商业机会使用',
    'LBL_JOB_NOTIFICATION_OPP_FORECAST_SYNC_BODY' => '您的 Sugar 实例的预测模块现在可以配合商业机会使用。所有过去的营收单项的预测提交数据已经移除，此实例可以为商业机会创建和提交预测。欲知关于此变更的详情，请参阅{{doc_url}}。谢谢 SugarCRM',

    'LBL_JOB_NOTIFICATION_RLI_NOTE_SUBJECT' => '您的Sugar实例的营收单项已经禁用',
    'LBL_JOB_NOTIFICATION_RLI_NOTE_BODY' => '您的 Sugar 实例的营收单项已经禁用，所有营收单项数据已经处理。此实例可以为商业机会使用。欲知关于此变更的详情，请参阅{{doc_url}}。谢谢 SugarCRM',

    'LBL_JOB_NOTIFICATION_DOC_LINK_TEXT' => '商业机会配置文档',

    // LOGIN PAGE STRINGS
    'LBL_LOGIN_BUTTON_KEY' => 'L',
    'LBL_LOGIN_BUTTON_TITLE' => '登录',
    'LBL_LOGIN_WELCOME_TO' => '欢迎来到',
    'LBL_LOGIN_OPTIONS' => '选项',
    'LBL_LOGIN_FORGOT_PASSWORD' => '忘记密码？',
    'LBL_LOGIN_SUBMIT' => '提交',
    'LBL_LOGIN_ATTEMPTS_OVERRUN' => '登录失败次数过多。',
    'LBL_LOGIN_LOGIN_TIME_ALLOWED' => '请尝试重新登录',
    'LBL_LOGIN_LOGIN_TIME_DAYS' => '天。',
    'LBL_LOGIN_LOGIN_TIME_HOURS' => '小时。',
    'LBL_LOGIN_LOGIN_TIME_MINUTES' => '分钟。',
    'LBL_LOGIN_LOGIN_TIME_SECONDS' => '秒。',
    'LBL_LOGIN_ADMIN_CALL' => '请联系系统管理员。',
    'LBL_LOGIN_USERNAME' => '用户名',
    'LBL_LOGIN_PASSWORD' => '密码',
    'LBL_LOGGED_OUT' => '您已经退出系统',
    'LBL_LOGIN_FORM_LABEL' => '显示日志表格',
    'LBL_RETURN_TO_LOGIN_PAGE' => '返回至登录',
    'LBL_LOGIN_INACTIVE_USER' => '停用用户',
    'LBL_LOGIN_PORTAL_GROUP_CANT_LOGIN' => '门户或团队用户无法登录。',
    // END LOGIN PAGE STRINGS

    'LBL_TABGROUP_HOME' => '仪表板',
    'LBL_SYNC' => '同步',
    'LBL_TASKS' => '任务',
    'LBL_TEAMS_LINK' => '团队',
    'LBL_THEME_COLOR' => '颜色',
    'LBL_THEME_FONT' => '字体',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_SCHEDULE_MEETING_BUTTON_TITLE' => '安排会议',
    'LBL_SCHEDULE_MEETING_BUTTON_KEY' => 'M',
    'LBL_SCHEDULE_MEETING_BUTTON_LABEL' => '安排会议',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => '存档电子邮件',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => '存档电子邮件 [Alt+K]',
    'LBL_UNAUTH_ADMIN' => '没有管理权限',
    'LBL_UNDELETE_BUTTON_LABEL' => '不删除',
    'LBL_UNDELETE_BUTTON_TITLE' => '不删除 [Alt+D]',
    'LBL_UNDELETE_BUTTON' => '不删除',
    'LBL_UNDELETE' => '不删除',
    'LBL_UNSYNC' => '不同步',
    'LBL_UPDATE' => '更新',
    'LBL_UPDATES' => '更新',
    'LBL_USER_LIST' => '用户列表',
    'LBL_USER_MENU' => '用户菜单',
    'LBL_USERS_SYNC' => '用户同步',
    'LBL_USERS' => '用户',
    'LBL_USER' => '用户',
    'LBL_CURRENT_USER' => '当前用户',
    'LBL_VERIFY_EMAIL_ADDRESS' => '查看是否存在新邮件...',
    'LBL_VERIFY_PORTAL_NAME' => '查看存在的门户名称...',
    'LBL_VIEW_IMAGE' => '查看',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => '以PDF格式打印',
    'LBL_VIEW_PDF_BUTTON_TITLE' => '以PDF格式打印[Alt+P]',

    'LBL_KBDOCUMENTS' => '知识库',
    'ERR_EMPTY_NODE_NAME' => 'You cannot add a category without title',


    'LNK_ABOUT' => '关于',
    'LNK_ADVANCED_SEARCH' => '高级查找',
    'LNK_BASIC_SEARCH' => '基本查找',
    'LNK_SEARCH_NO_RESULTS' => '未找到结果。',
    'LNK_SEARCH_FTS_VIEW_ALL' => '查看所有结果',
    'LNK_SEARCH_NONFTS_VIEW_ALL' => '显示所有',
    'LNK_CLOSE' => '关闭',
    'LBL_MODIFY_CURRENT_SEARCH' => '修改当前查询',
    'LNK_SAVED_VIEWS' => '布局选项',
    'LNK_DELETE_ALL' => '删除所有',
    'LNK_DELETE' => '删除',
    'LNK_EDIT' => '编辑',
    'LNK_VIEW' => '查看',
    'LNK_GET_LATEST' => '获取最新的',
    'LNK_GET_LATEST_TOOLTIP' => '用最新版本替换',
    'LNK_HELP' => '帮助',
    'LNK_CREATE' => '创建',
    'LNK_CREATE_WHEN_EMPTY' => '现在创建一条新记录',
    'LNK_LIST_END' => '末页',
    'LNK_LIST_NEXT' => '下页',
    'LNK_LIST_PREVIOUS' => '上页',
    'LNK_LIST_RETURN' => '返回列表',
    'LNK_LIST_START' => '首页',
    'LNK_LOAD_SIGNED' => '签署',
    'LNK_LOAD_SIGNED_TOOLTIP' => '用签署文件代替',
    'LNK_PRINT' => '打印',
    'LNK_BACKTOTOP' => '回到顶部',
    'LNK_REMOVE' => '移除',
    'LNK_RESUME' => '重试',
    'LNK_VIEW_CHANGE_LOG' => '查看审计日志',
    'TPL_AUDIT_LOG_TITLE' => '{{{name}}} 的审计日志',
    'LBL_AUDIT_EMAIL_TOOLTIP' => '点击以查看电子邮件地址审计日志',
    'LBL_NO_SEARCH_RESULTS' => '没有为您的搜索找到任何结果',
    'NTC_CLICK_BACK' => '请按浏览器的“返回”按钮返回，并纠正错误。',
    'NTC_DATE_FORMAT' => '(yyyy-mm-dd)',
    'NTC_DATE_TIME_FORMAT' => '(yyyy-mm-dd 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => '确定要删除所选择的记录吗?',
    'NTC_TEMPLATE_IS_USED' => '这个模板至少被1个营销活动所使用。确定要删除它吗？',
    'NTC_TEMPLATES_IS_USED' => "下列模板在营销活动中被使用。确定要删除它们吗？",
    'NTC_DELETE_CONFIRMATION' => '您确定要删除这条记录吗？',
    'NTC_DELETE_CONFIRMATION_FORMATTED' => '您确定要删除 {0}？',
    'LBL_METRIC_DELETE_WARNING' => '已被共享此量度数据选项卡的所有用户也将失去访问权限。',
    'NTC_DELETE_CONFIRMATION_NUM' => '您确定要删除',
    'NTC_UPDATE_CONFIRMATION_NUM' => '您确定要更新',
    'NTC_DELETE_SELECTED_RECORDS' => '选择记录?',
    'LBL_DELETE_FILTER_CONFIRMATION' => '从所有视图中删除筛选器；可能包括dashlets的配置数据。您确定要删除这个筛选器吗?',
    'TPL_DELETE_FILTER_SUCCESS' => '成功删除筛选器{{name}}。',
    'NTC_DELETE_SUCCESS' => '您已删除 {0}。',
    'NTC_UNLINK_CONFIRMATION' => '您确定要取消链接',
    'NTC_UNLINK_CONFIRMATION_FORMATTED' => '您确定要断开 {0}？',
    'NTC_UNLINK_CASES_CONTACT_CONFIRMATION' => '是否确定要取消链接 {0}？这还会将其从客户反馈的“主要联系人”字段中移除。',
    'NTC_UNLINK_CASES_CONTACT_ERROR' => '{0} 无法取消链接，因为他们是此客户反馈上的主要联系人。请先更新“主要联系人”字段，然后再取消链接此记录。',
    'NTC_UNLINK_SUCCESS' => '已取消链接 {0}。',
    'NTC_LOGIN_MESSAGE' => '请输入用户名和密码',
    'NTC_NO_ITEMS_DISPLAY' => '无',
    'NTC_REMOVE_CONFIRMATION' => '您确定要移除这个关系吗? 只有一处关系。 记录不会被删除。',
    'NTC_REQUIRED' => '表示必填字段',
    'NTC_SUPPORT_SUGARCRM' => '支持 SugarCRM 开源项目，通过 paypal 捐赠它。-它是快速、免费和安全的软件！',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => '欢迎',
    'NTC_YEAR_FORMAT' => '(yyyy)',
    'LOGIN_LOGO_ERROR' => '请更换 SugarCRM 标识。',
    'FATAL_LICENSE_ALTERED' => '您的授权自上次验证已更改',
    'ERROR_FULLY_EXPIRED' => "您公司 SugarCRM 的许可已经超期 7 天以上，需要进行修订。只有管理员可以登陆",
    'ERROR_LICENSE_EXPIRED' => "您公司SugarCRM的许可需要被更新，只有管理员可以登陆",
    'WARN_LICENSE_EXPIRED' => "您公司的许可证即将过期",
    'ERROR_LICENSE_VALIDATION' => "您公司 SugarCRM 的许可需要被验证. 只有管理员可以登陆",
    'WARN_LICENSE_VALIDATION' => "贵公司的 SugarCRM 许可很快需要验证",
    'WARN_BROWSER_IE_COMPATIBILITY_MODE_WARNING' => '<b>警告:</b> 你的IE浏览器在兼容视图下是不支持的.',
    'WARN_LICENSE_SEATS' => '警告：活动用户数量已经达到许可证允许的最大值。',
    'WARN_LICENSE_SEATS_MAXED' => '警告：活动用户数量已经超过许可证允许的最大值。',
    'ERROR_LICENSE_SEATS_MAXED' =>
        '活动用户的数量超过许可证数量限制。请联系您的管理员。',
    'ERROR_LICENSE_TYPE_SEATS_MAXED' =>
        'Number of active %s users exceeds License Count limits. Please contact your Administrator.',
    'ERROR_LICENSE_SEATS_MAXED_ONLY_ADMINS' => '只有管理员才可以登录。',
    'WARN_LICENSE_SEATS_MAXED_ONLY_EXISTING_USERS' =>
        '已达到用户许可证数量限制。仅当前用户可以登录。',
    'WARN_ONLY_ADMINS' => '只有管理员才可以登录。',
    'WARN_UNSAVED_CHANGES' => '您将在没有保存修改的情况下离开。您确定要离开么？',
    'LBL_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => '刷新浏览器将自动关闭您已打开的所有 SugarLive 通话或聊天会话，任何未保存更改将丢失。是否想要继续？',
    'LBL_PORTAL_CHAT_WARN_ACTIVE_CCP_UNSAVED_CHANGES' => 'Refreshing the browser will automatically close your chat session. Do you wish to proceed?',
    'LBL_WARN_UNSAVED_CHANGES' => '您的更改未保存，您确定要离开页面放弃更改吗？',
    'LBL_MFA_RESET_CONFIRMATION' => '您是否确定要重置您的<a href="https://support.sugarcrm.com/SmartLinks/Custom/Logging_In_Using_MFA/" target="_blank">多因素验证</a>？
执行此操作会立即使您注销，下次登录时您将需要使用验证器应用验证身份。',
    'LBL_MFA_RESET_CONFIRMATION_BTN' => '确认并注销',
    'LBL_ONE_OR_MORE_UNSAVED_CHANGES' => '一个或多个 Dashlet 包含未保存的更改。是否确定要关闭抽屉？',
    'LBL_NAVIGATE_TO_REPORTS' => '您将打开报告模块，您对dashlet的修改将不会被保存，是否继续？',
    'ERROR_NO_RECORD' => '检索记录出错。这条记录可能已被删除，或者您可能没有权限查看。',
    'ERROR_TYPE_NOT_VALID' => '错误。无效的类型。',
    'ERROR_MAX_FIELD_LENGTH' => '错误。这个字段的最大长度为{{this}}。',
    'ERROR_MIN_FIELD_LENGTH' => '错误。这个字段的最小长度为 {{this}}。',
    'ERROR_EMAIL' => '错误。无效电子邮件地址： {{#each this}}{{this}} {{/each}}',
    'ERROR_PRIMARY_EMAIL' => '错误。至少一个主地址应该被设置。',
    'ERROR_DUPLICATE_EMAIL' => '错误。电子邮件地址重复：{{#each this}}{{this}} {{/each}}',
    'ERROR_FIELD_REQUIRED' => '错误。此字段是必须的。',
    'ERROR_MINVALUE' => '错误。 此字段的最小值是{{this}}.',
    'ERROR_MAXVALUE' => '错误。此字段的最大值是{{this}}.',
    'ERROR_IS_GREATER_THAN' => '错误。此字段的值必须大于{{this}}。',
    'ERROR_IS_LESS_THAN' => '错误。此字段的值必须小于{{this}}。',
    'ERROR_DATETIME' => '错误。此字段需要一个有效日期。',
    'ERROR_IS_BEFORE' => '错误。此字段的日期不能晚于 {{this}}字段的日期之后.',
    'ERROR_IS_AFTER' => '错误。此字段的日期不能晚于 {{this}}字段的日期之前.',
    'ERROR_TIME_IS_BEFORE' => '错误。此字段的时间必须早于 {{this}} 字段的时间。',
    'ERROR_TIME_IS_AFTER' => '错误。此字段的时间必须晚于 {{this}} 字段的时间。',
    'ERROR_NUMBER' => '错误，这个域需要一个有效的数字。',
    'ERROR_INT' => '错误。无效整数。',
    'ERROR_URL' => '错误。URL 无效。',
    'ERROR_NO_BEAN' => '获取 Bean 失败。',
    'ERROR_ACCESS_MODULE' => '您没有访问该模块。',
    'ERROR_MAX_FILESIZE_EXCEEDED' => '错误：附件太大。',
    'ERROR_UPLOAD_FAILED' => '错误：文件上载失败。',
    'ERROR_UPLOAD_ACCESS_PD' => '您没有权限创建此模块的 [流程定义]。',
    'ERROR_UPLOAD_ACCESS_BR' => '您没有权限创建此模块的 [商务规则]。',
    'ERROR_UPLOAD_ACCESS_ET' => '您没有权限创建此模块的 [电子邮件模板]。',
    'ERROR_PA_FILTER_UNSUPPORTED_OPERATOR' => '出错。您输入了不受支持的运算符。',
    'ERROR_PA_FILTER_INVALID_OPERATOR' => '出错。您输入了无效的运算符。',
    'ERROR_PA_FILTER_UNSUPPORTED_FILTER' => '出错。您输入了无效的筛选器。',
    'ERROR_PA_UNSUPPORTED_FILE' => 'Import failed. Please check your sugar log for more details.',
    'ERROR_AWF_PARTIAL_LOCKED_GROUP' => '导入失败，流程定义中的部分分组字段被锁定。' .
        ' 必须将流程定义中的这些字段解锁，以便导入定义。',
    'ERROR_EXP_DATE_LOW' => '错误。到期日期不能早于公布的日期。',
    'ERROR_ACTIVE_DATE_APPROVE_REQUIRED' => '出错。已批准状态需要发布日期。',
    'ERROR_ACTIVE_DATE_EMPTY' => '发布日期为空。',
    'ERROR_ACTIVE_DATE_LOW' => 'Error. The Publish Date must occur on a later date than today&#39;s date.',
    'LBL_DUP_MERGE' => '查找重复记录',
    'ERR_DUPLICATE_CHECK_IS_DISABLED' => '禁用 {{module}} 的重复项检查。',
    'LBL_MANAGE_SUBSCRIPTIONS' => '管理订阅',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR' => '管理订阅为',
    'LBL_SUBSCRIBE' => '订阅',
    'LBL_UNSUBSCRIBE' => '不订阅',
    'LBL_CREATE_LINK_RECORD' => '创建和链接记录',
    'LBL_CREATE_LINK_BUTTON_LABEL' => '创建和链接记录',
    'LBL_LINK_FROM_REPORT_SUCCESS' => '{{reportCount}} 已被链接到记录。',
    'LBL_LINK_FROM_REPORT_NO_DATA' => '没有链接记录。',
    'LBL_LINK_FROM_REPORT_WRONG_MODULE' => '报表类型选择错误。',
    'ERROR_EMPTY_LINK_MODULE' => '请先选择的关系。',
    // Ajax status strings
    'LBL_LOADING' => '加载中 ...',
    'LBL_LOADING_NO_DOTS' => '加载',
    'LBL_SEARCHING' => '查找中······',
    'LBL_SEARCH_UNDERWAY' => '搜索',
    'LBL_SAVING_LAYOUT' => '布局保存中...',
    'LBL_SAVED_LAYOUT' => '布局已经被保存',
    'LBL_SAVED' => '已保存',
    'LBL_SAVING' => '保存中',
    'LBL_FAILED' => '失败!',
    'LBL_DISPLAY_COLUMNS' => '显示列',
    'LBL_HIDE_COLUMNS' => '隐藏列',
    'LBL_SEARCH_CRITERIA' => '查找标准',
    'LBL_SAVED_VIEWS' => '已保存的视图',
    'LBL_PROCESSING_REQUEST' => '处理中..',
    'LBL_REQUEST_PROCESSED' => '完成',
    'LBL_AJAX_FAILURE' => 'Ajax 失败',
    'LBL_SEARCH_PARENT_RELATED_ITEM' => '搜索...',
    'LBL_SAVED_SEARCH_SHORTCUT' => '已保存的查找',
    'LBL_SEARCH_POPULATE_ONLY' => '用上面的查找表单进行查找',
    'LBL_SEARCH_NO_RESULTS' => '没有找到',
    'LBL_SEARCH_FOR' => '搜索',
    'LBL_SEARCH_FOR_MORE' => '查询更多',
    'LBL_SEARCH_SELECT' => '选择……',
    'LBL_SEARCH_AND_SELECT_ELLIPSIS' => '搜索并选择……',
    'LBL_SEARCH_SELECT_MODULE' => '选择 {{module}}...',
    'LBL_DETAILVIEW' => '细节视图',
    'LBL_LISTVIEW' => '列表视图',
    'LBL_EDITVIEW' => '编辑视图',
    'LBL_SEARCHFORM' => '查找表单',
    'LBL_SAVED_SEARCH_ERROR' => '请为这个视图提供一个名称',
    'LBL_DISPLAY_LOG' => '显示体制',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => '地点：',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => '说明：',
    'MSG_JS_ALERT_MTG_REMINDER_START' => '开始',
    'MSG_JS_ALERT_MTG_REMINDER_CALL_MSG' => '点击“确定”来查看这条消息，或者点击“取消”放弃查看这条消息。',
    'MSG_JS_ALERT_MTG_REMINDER_MEETING_MSG' => '点击确定来查看会议或点击取消来放弃查看消息',
    'MSG_LIST_VIEW_NO_RESULTS_BASIC' => '没查找到结果。',
    'MSG_LIST_VIEW_NO_RESULTS' => '没有查找到 <item1>的结果',
    'MSG_LIST_VIEW_NO_RESULTS_SUBMSG' => '创建 <item1> 为一个新的 <item2>',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS' => '您当前没有任何保存 <item1> 记录。现在创建一个<item2> 或者 <item3>。',
    'MSG_EMPTY_LIST_VIEW_NO_RESULTS_NO_IMPORT' => '您目前没有保存<item1>记录<item2>。',
    'MSG_EMPTY_LIST_VIEW_GO_TO_PARENT' => '你从 <item2>、<item3>和<item2>列表可以创建 <item1>。',

    // sentiment
    'LBL_SENTIMENT_POSITIVE' => '积极',
    'LBL_SENTIMENT_NEUTRAL' => '中性',
    'LBL_SENTIMENT_NEGATIVE' => '消极',

    // Console Metric Tabs
    'LBL_NO_METRIC_CONFIGURED' => '未配置量度数据选项卡',
    'LBL_NO_METRIC_VISIBLE' => '不可见指标选项卡',
    'LBL_MAKE_METRIC_VISIBLE' => '选择“组织”以使指标选项卡可见',
    'LBL_PLEASE_CONTACT_ADMIN' => '请与管理员联系',

    'LBL_GENERATING_PDF' => 'Generating PDF',
    'LBL_CLICK_HERE' => '点击此处',
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => '添加到我的收藏夹',
    'LBL_MARK_AS_FAVORITES' => '标记为收藏',
    'LBL_CREATE_CONTACT' => '新增联系人',
    'LBL_CREATE_NOTE' => '创建笔记',
    'LBL_CREATE_OPPORTUNITY' => '创建商业机会',
    'LBL_SCHEDULE_CALL' => '记录电话',
    'LBL_SCHEDULE_CALL2' => '电话',
    'LBL_SCHEDULE_MEETING' => '安排会议',
    'LBL_SCHEDULE_MEETING2' => '会议',
    'LBL_CREATE_MESSAGE' => '创建消息',
    'LBL_CREATE_MESSAGE2' => '消息',
    'LBL_CREATE_TASK' => '创建任务',
    'LBL_CREATE_TASK2' => '任务',
    'LBL_REMOVE_FROM_FAVORITES' => '从我的收藏夹中移除',
    'LBL_CREATE_NOTE_OR_ATTACHMENT' => 'Create Note or Attachment',
    'LBL_CREATE_NOTE_OR_ATTACHMENT2' => '笔记',
    'LBL_DOWNLOAD_ALL' => '全部下载',
    'LBL_DOWNLOAD_ONE' => '下载',
    'LBL_ATTACHMENTS' => '附件',
    'LBL_ADD_ATTACHMENT' => '浏览',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => '产生列表',
    'LBL_SAVE_WEB_TO_LEAD_FORM' => '保存潜在客户表单的网页',

    'LBL_PLEASE_SELECT' => '请选择',
    'LBL_REDIRECT_URL' => '转载网址',
    'LBL_RELATED_CAMPAIGN' => '相关市场活动',
    'LBL_ADD_ALL_LEAD_FIELDS' => '添加所有的字段',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => '移除所有字段',
    'LBL_ONLY_IMAGE_ATTACHMENT' => '只有图片类型的附件才可以被嵌入',
    'LBL_REMOVE' => '移除',
    'LBL_TRAINING' => '支持',
    'ERR_DATABASE_CONN_DROPPED' => '执行查询出现错误。很可能是数据库未被连接上。请刷新当前页，您可能需要重新启动网络服务。',
    'ERR_DATABSE_RELATIONSHIP_QUERY' => '错误设定 {0} 关联关系: {1}',
    'ERR_MSSQL_DB_CONTEXT' => '修改数据库文本',
    'ERR_MSSQL_WARNING' => '警告：',

    //Import vCard
    'ERR_VCARD_FILE_PARSE' => '无法解析vCard格式',
    'ERR_VCARD_FILE_MISSING' => 'vcf文件丢失',
    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => '警告：字段 [[field]] 没有一个映射的条目 [moduleDir] vardefs.php 文件中',
    'ERR_CANNOT_CREATE_METADATA_FILE' => '错误：缺少文件 [[file]]。 无法创建，因为没有相应的 HTML 文件被发现。',
    'ERR_CANNOT_FIND_MODULE' => '错误：Module [module] 不存在。',
    'LBL_ALT_ADDRESS' => '其他地址：',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => '错误: 有一些不相等若干论据关于 &#39;key&#39; 和 &#39;copy&#39; 元素在显示参数的数组中。',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => '在显示参数数组丢失索引关于:',

    'LBL_DASHLET' => '仪表',
    'LBL_DASHLET_CONFIGURE_FILTERS' => '筛选器',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => '只显示我的项目',
    'LBL_DASHLET_CONFIGURE_TITLE' => '标题',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => '显示行',
    'LBL_DASHLET_CONFIGURE_INTELLIGENT' => '关联当前记录',
    'LBL_DASHLET_CONFIGURE_LINKED' => '相关领域',
    'LBL_DASHLET_FREEZE_FIRST_COLUMN' => '冻结第一列',

    'LBL_REMOVE_DASHLET_CONFIRM' => '您确定要删除这个 Sugar 仪表吗?',
    'LBL_REMOVE_DASHLET_ROW_CONFIRM' => '您确定想要删除行吗?',
    'LBL_MAXIMUM_OF' => '最大值',
    'LBL_COLUMNS_CAN_BE_DISPLAYED' => '显示列',

    /* SugarCRM Dashboard */
    'LBL_DASHBOARD' => '仪表板',
    'LBL_DEFAULT_DASHBOARD_TITLE' => '我的仪表板',
    'LBL_COLLAPSE_ALL' => '全部折叠',
    'LBL_EXPAND_ALL' => '全部展开',
    'LBL_DASHLET_CONFIG_EDIT_LABEL' => '编辑',
    'LBL_DASHLET_CONFIG_VIEW_REPORT' => '查看报告',
    'LBL_DASHLET_REFRESH_LABEL' => '刷新',
    'LBL_DASHLET_REMOVE_LABEL' => '移除',
    'LBL_DASHLET_DROP_HERE' => '放置此处',
    'LBL_DASHLET_MINIMIZE_ALL' => 'Collapse All Dashlets',
    'LBL_DASHLET_MAXIMIZE_ALL' => 'Expand All Dashlets',
    'LBL_DASHLET_MINIMIZE' => '最小化',
    'LBL_DASHLET_MAXIMIZE' => '最大化',
    'LBL_DASHLET_CONFIGURE' => '配置',
    'LBL_DASHLET_TOGGLE' => '打开/关闭仪表板',
    'LBL_SIDEPANE_TOGGLE' => '打开/关闭侧边窗格',
    'LBL_RESTORE_DEFAULT_DASHLETS' => '恢复默认仪表',
    'LBL_NO_DASHBOARD_CONFIGURED' => '没有配置仪表板',
    'LBL_CREATE_DASHBOARD_LINK' => '创建仪表板',

    /* SugarCRM Help Component */
    'LBL_DEFAULT_HELP_COMPONENT_TITLE' => '说明',
    'LBL_HELPLET_TOGGLE' => '打开/关闭',

    /* SugarCRM search facets */
    'LBL_FACET_MODULES' => '模块',
    'LBL_FACET_MODIFIED_BY_ME' => '由我修改',
    'LBL_FACET_CREATED_BY_ME' => '由我创建',
    'LBL_FACET_MY_FAVORITES' => '我的收藏夹',
    'LBL_FACET_ASSIGNED_TO_ME' => '分配给我',
    'LBL_FACET_NO_DATA' => '没有此方面的数据。',

    'LBL_DASHLET_LISTVIEW_NAME' => '列表视图',
    'LBL_DASHLET_LISTVIEW_DESCRIPTION' => '根据您定义的标准从一个特定的模块列表记录。',

    // Console List view dashlet
    'LBL_DASHLET_CONSOLE_LISTVIEW_NAME' => '控制台列表视图',
    'LBL_DASHLET_CONSOLE_LISTVIEW_DESCRIPTION' => '列出特定模块中与您在控制台中查看的记录相关的记录。',

    // Record view dashlet
    'LBL_DASHLET_RECORDVIEW_NAME' => '记录视图',
    'LBL_RELATED_RECORDS' => '相关 {{module}}',
    'LBL_DASHLET_RECORDVIEW_DESCRIPTION' => '在选项卡中显示记录和可选的相关记录。',
    'LBL_DASHLET_RECORDVIEW_BASE_RECORD_TYPE' => '基本记录类型',
    'TPL_DASHLET_RECORDVIEW_THIS_RECORD_TYPE' => '此 {{moduleSingular}}',
    'LBL_DASHLET_RECORDVIEW_TABS' => '选项卡',
    'LBL_DASHLET_RECORDVIEW_BASIC_LAYOUT_PREVIEW' => '基本布局预览',
    'TPL_DASHLET_RECORDVIEW_TOO_MANY_TABS' => '警告，选项卡中仅可显示 {{numWord}} ({{num}}) 个模块。 ' .
        '请在添加其他模块前移除一个或多个模块。',
    'LBL_SIX' => '六', // record view dashlet tab limit
    'LBL_DASHLET_NO_TABS_AVAILABLE' => 'No tabs available. Please add a module in the tabs field above.',

    //Commentlog Dashlet
    'LBL_DASHLET_COMMENTLOG_NAME' => '评论日志',
    'LBL_DASHLET_COMMENTLOG_DESCRIPTION' => '显示记录的评论',
    'LBL_COMMENTS_LOG_DASHLET_NO_COMMENTS' => '没有可用评论',
    'LBL_COMMENTS_LOG_DASHLET_BUTTON_ADD' => '添加',
    'LBL_COMMENTS_LOG_DASHLET_PLACEHOLDER' => '添加评论',
    'LBL_COMMENTS_LOG_DASHLET_VIEW_ALL' => '查看全部',
    'LBL_TABBED_DASHLET_MODULES_UNAVAILABLE' => '数据不可用。您无权访问这些模块。' .
    " \n请更新或删除此 Dashlet。",
    
    'LBL_DASHLET_MODULE_UNAVAILABLE' => 'Data not available. You do not have permission to access this module.' .
        " \nPlease update or remove this dashlet.",
    'TPL_DASHLET_MY_MODULE' => '我的 {{module}}',
    'LBL_DASHLET_PICK_A_RECORD' => '没有选择要显示的记录',
    'LBL_CONTENT_SEARCH_DASHLET' => '内容搜索 Dashlet',
    'LBL_CONTENT_SEARCH_DASHLET_GREETING' => '我们可以帮助您什么呢，{{username}}？',
    'LBL_CONTENT_SEARCH_DASHLET_DISABLED' => '是否想要创建客户反馈？',

    'LBL_DASHLET_OPPORTUNITY_NAME' => '商业机会指标',
    'LBL_DASHLET_OPPORTUNITY_DESCRIPTION' => '相关账户的商业机会指标。',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_NAME' => '产品目录快速选择',
    'LBL_PRODUCT_QUICK_PICKS_DASHLET_DESCRIPTION' => '列出最近使用的条目和产品，保存至收藏夹',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_RECENT_TAB' => '最近使用的',
    'LBL_DASHLET_PRODUCT_QUICK_PICKS_FAVORITES_TAB' => '收藏夹',

    'LBL_DASHBOARD_CREATE' => '创建仪表板',
    'LBL_DASHBOARD_DUPLICATE' => '复制仪表板',
    'LBL_DASHBOARD_DELETE' => '删除仪表板',
    'LBL_PIN_TO_TOP' => '固定到顶部',
    'LBL_PIN_TO_BOTTOM' => '固定到底部',
    'LBL_MANAGE_DASHBOARDS' => '管理仪表板',

    'LBL_DASHBOARD_CONFIG' => '仪表板配置',
    'LBL_LIST_VIEW__NAME' => '列表视图',
    'LBL_PIPELINE_VIEW_NAME' => '平铺视图',
    'LBL_PIPELINE_VIEW_BTN' => '平铺视图',
    'LBL_PIPELINE_VIEW_TAB_NAME' => '按 {{fieldName}} 对 {{module}} 进行排序',
    'LBL_VISUAL_PIPELINE_DISABLED' => '平铺视图未启用',
    'LBL_VISUAL_PIPELINE_MOVE_FAILED' => '{{recordName}} could not be moved to {{columnLabel}} because of the following fields: ',

    'LBL_DASHLET_NO_RECORDS' => '没有发现记录。',
    'LBL_DASHLET_CASES_SUMMARY_NAME' => '客户反馈总结',
    'LBL_DASHLET_ITERACTIONS_NAME' => '时间表',
    'LBL_DASHLET_ATTACHMENTS_NAME' => '笔记与附件',
    'LBL_DASHLET_ATTACHMENTS_DESCRIPTION' => '注释和附件所属的记录',
    'LBL_DASHLET_PIPLINE_NAME' => '管道',

    'LBL_DASHLET_RECENT_TWEETS_SUGARCRM_NAME' => '近期推文 - @{{twitter}}',

    'LBL_DASHBOARD_NO_RECORDS' => '没有保存的仪表板',

    'LBL_DNB_AND' => '和',
    'LBL_DNB_PRIM_NAME_DESC' => '文字记录这个组织的名称',

    /* Twitter Dashlet */
    'LBL_TWITTER_REPLY' => '回复',
    'LBL_TWITTER_RETWEET' => '转推',
    'LBL_TWITTER_FAVORITE' => '收藏夹',
    'LBL_TWITTER_FOLLOW' => '跟踪',
    'LBL_TWITTER_DESCRIPTION' => '查看符合的twitter用户&#39；的用户资料和tweets、 retweet和tweets的回复',
    'LBL_TWITTER_ID' => 'Twitter ID',
    'LBL_TWITTER_DISPLAY_ROWS' => '显示行数',
    'LBL_TWITTER_MY_ACCOUNT' => '我的帐户',
    'LBL_TWITTER_NAME' => 'Twitter',
    'LBL_TWITTER_SOURCE' => 'Twitter源：',

    /* Learning Resources */
    'LBL_LEARNING_RESOURCES_TITLE' => '学习资源',
    'LBL_LEARNING_RESOURCES_SUGAR_UNIVERSITY_LINK' => '培训与证书',
    'LBL_LEARNING_RESOURCES_COMMUNITY_LINK' => 'SugarClub 社区',
    'LBL_LEARNING_RESOURCES_SUPPORT_LINK' => '文档与支持',
    'LBL_LEARNING_RESOURCES_SUGAR_OUTFITTERS_LINK' => 'SugarOutfitters 市场',

    /* Country Chart Dashlet */
    'LBL_DASHLET_COUNTRY_CHART_NAME' => '按国家显示销售区域',
    'LBL_DASHLET_COUNTRY_CHART_DESCRIPTION' => '由国家地图显示销量榜',

    /* Knowledge base category tree dashlet */
    'LBL_DASHLET_CATEGORIES_NAME' => '知识库类别 & 发表的文章',
    'LBL_DASHLET_CATEGORIES_DESCRIPTION' => 'Displays a tree view of knowledge base categories & published articles',

    /* Knowledge base category tree with search dashlet */
    'LBL_DASHLET_KB_SEARCH_NAME' => '知识库搜索',
    'LBL_DASHLET_KB_SEARCH_DESCRIPTION' => '显示已发布知识库文章和类别的可搜索树视图。',

    /* Knowledge base localizations dashlet */
    'LBL_DASHLET_LOCALIZATIONS_NAME' => '以其他语言发表的文章',
    'LBL_DASHLET_LOCALIZATIONS_DESCRIPTION' => 'Displays a list of published, localized knowledge base articles',

    // Most Useful Knowledge Base Articles dashlet
    'LBL_DASHLET_MOST_USEFUL_NAME' => '最实用的已发表的知识库文章',
    'LBL_DASHLET_MOST_USEFUL_DESC' => '显示最受欢迎和查看最多的知识库文章',

    'LBL_FILTERED_LIST_BY_FIELD' => '{{module}} 按 {{label}} "{{value}}" 筛选',

    // Usefulness for Articles dashlet
    'LBL_DASHLET_USEFULNESS_NAME' => '文章的有用性',
    'LBL_DASHLET_USEFULNESS_DESC' => 'Displays a chart showing how useful the knowledge base article is',

    'LBL_ADD_PAGE' => '添加页',
    'LBL_LOADING_PAGE' => '加载页中，请稍等...',
    'LBL_SEARCH_RESULTS' => '搜索结果',
    'LBL_SEARCH_RESULTS_FOR' => '搜索结果： ',
    'LBL_SEARCH_HELP_TITLE' => '检索提示',
    'LBL_SEARCH_RESULTS_FOUND' => '查找到搜索结果',
    'LBL_SEARCH_RESULTS_TIME' => '分',

    /* Sales Pipeline Dashlet */
    'LBL_DASHLET_MY_PIPELINE' => '我的管道',
    'LBL_DASHLET_MY_TEAMS_PIPELINE' => "我团队的管道",
    'LBL_DASHLET_SALES_PIPELINE_CHART_NAME' => '销售管道图表',
    'LBL_DASHLET_SALES_PIPELINE_CHART_DESC' => '显示当前管道图表。',
    /* End Sales Pipeline Dashlet */

    'LBL_NO_IMAGE' => '无图像',

    'LBL_MODULE' => '模块',
    'LBL_RELATIONSHIP' => '关系',
    'LBL_SINGULAR_LABEL' => '单数标签',
    'LBL_PLURAL_LABEL' => '复数标签',
    'LBL_MODULE_DISPLAY' => '显示',
    'LBL_MODULE_DISPLAY_TYPE' => '显示类型',
    'LBL_MODULE_ICON' => '图标',
    'LBL_MODULE_COLOR' => '模块背景颜色',
    'LBL_LANGUAGE_SELECTOR' => '语言',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS' => '模块设置',
    'LBL_MODULE_NAMES_AND_ICONS_SETTINGS_SAVED' => '模块设置已保存。',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => '从左侧复制地址:',
    'LBL_SAVE_AND_CONTINUE' => '保存并继续',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>多项选择控制</strong></p><ul><li>点击一个值选择一个属性。Ctrl-点击&nbsp；来&nbsp;选择多个。 Mac用户使用 CMD-点击。</li><li>在两个属性中来选择所有值，&nbsp; 点击第一个值&nbsp;之后shift-点击最后一个值。</li></ul><p><strong>高级查找 & 布局选项</strong><br><br>使用 <b>保存查找 & 布局</b> 选项, 您可以保存一组查找参数和/或一个客户化列表显示界面为了快速获得将来想要得到的查找结果。您能保存一个不受限数目的客户化查找和布局。 所有保存的查找以名称的形式出现在保存的查找列表中，与上次加载保存的查找出现在列表顶部。<br><br>客户化订制列表显示布局，使用隐藏列框来选择哪个字段显示在查找结果中。 例如，您可以显示或隐藏细节如记录名称和负责用户，负责团队在查找结果中。添加一列来显示列，在隐藏列表中选择字段并使用左边箭头符号来移动它显示的列表。从列表显示中移动一列，从显示的列表中选择它并用右箭头符号移动它到隐藏列中。<br><br>如果您保存布局设置，您将能够加载它们在任何时间来显示查找结果在客户布局中。<br><br>保存和更新一个查找和/或布局：<ol><li>输入一个名称为查找结果在 <b>保存这个查找为</b>字段并点击 <b>保存</b>。当前名称显示在保存的查找列表邻近<b>清除</b> 按钮。</li><li>查看保存查找,选择它从保存的查找列表中。查找结果显示在列表显示中。</li><li>更新保存的查找属性，在列表中选择保存的查找，输入新查找规则和/或布局悬想在高级查找区域，并点击 <b>更新</b> 邻近 <b>修改当前查找</b>。</li><li>删除一个保存的查找，选择它在保存的查找列表中点击 <b>删除</b> 邻近于 <b>修改当前查找</b>，并之后点击 <b>确定</b> 来确认删除。</li></ol></p>',

    //resource management
    'ERR_QUERY_LIMIT' => '错误：$limit 查询限制达到 $module 模块。',
    'ERROR_NOTIFY_OVERRIDE' => '错误： ResourceObserver->notify() 需要被重写。',

    //tracker labels
    'ERR_MONITOR_FILE_MISSING' => '错误：无法创建监视器，因为metedata文件为空或者不存在',
    'ERR_MONITOR_NOT_CONFIGURED' => '错误：没有配置为所请求名称的监控器',
    'ERR_UNDEFINED_METRIC' => '错误： 不能为未定义量设置值',
    'ERR_STORE_FILE_MISSING' => '错误：不能找到实现存储的文件',

    'LBL_MONITOR_ID' => '监视器编号',
    'LBL_TEAM_ID' => '团队编号',
    'LBL_SELECT_MODULE' => '选择一个模块:',
    'LBL_USER_ID' => '用户 ID',
    'LBL_MODULE_NAME' => '模块名称',
    'LBL_MODULE_ALL' => '所有',
    'LBL_ITEM_ID' => '项目 ID',
    'LBL_ITEM_SUMMARY' => '项目汇总',
    'LBL_ACTION' => '操作',
    'LBL_SESSION_ID' => 'Session 编号',
    'LBL_BREADCRUMBSTACK_CREATED' => '为用户id {0} 创建的BreadCrumbStack',
    'LBL_VISIBLE' => '记录可见',
    'LBL_DATE_LAST_ACTION' => '上次操作日期',

    //Tracker Queries
    'LBL_SQL_TEXT' => 'SQL 文本',
    'LBL_QUERY_HASH' => 'SQL 哈希',
    'LBL_SEC_TOTAL' => '总秒数',
    'LBL_SEC_AVG' => '平均秒数',
    'LBL_RUN_COUNT' => '查询总数',

    //Tracker Sessions
    'LBL_CLIENT_IP' => '客户端IP地址',
    'LBL_DATE_START' => '开始时间',
    'LBL_ACTIVE' => 'Session激活',
    'LBL_ROUNDTRIPS' => 'Session周转',
    'LBL_SECONDS' => '秒数',

    //Tracker Performance
    'LBL_DB_ROUND_TRIPS' => '数据库周转',
    'LBL_FILES_OPENED' => '访问过的文件',
    'LBL_MEMORY_USAGE' => '内存使用',

    //Twitter Connector
    'LBL_TWITTER_DATA_LOADING' => '加载 Twitter 连接器...',
    'LBL_TWITTER_DATA_EMPTY' => '不能从Twitter获得有效的数据',

    'LBL_PLUGIN_OUTLOOK_NAME' => 'Sugar的Outlook插件',
    'LBL_PLUGIN_OUTLOOK_DESC' => '和 Outlook 整合 Sugar 的邮件与日程安排信息',
    'LBL_PLUGIN_WORD_NAME' => 'Sugar的Word插件',
    'LBL_PLUGIN_WORD_DESC' => '从 SugarCRM 到自动发布信息',
    'LBL_PLUGIN_EXCEL_NAME' => 'Sugar的Excel插件',
    'LBL_PLUGIN_EXCEL_DESC' => '用表格的形式整合Sugar以便于关键指标分析',
    'LBL_PLUGINS_TITLE' => '针对 Microsoft Office <sup>TM</sup>的Sugar插件',
    'LBL_PLUGINS_DESC' => '阅读关于插件的功能，请参阅<a href="https://www.sugarcrm.com/crm/support/documentation/SugarPlugIns">Plug-Ins Documentation</a>。',

    'LBL_PLUGINS_LOTUS_TITLE' => 'Lotus Notes 的 Sugar 插件 <sup>TM</sup>',
    'LBL_PLUGIN_LOTUS_NAME' => 'Lotus Notes 的 Sugar 插件',
    'LBL_PLUGIN_LOTUS_DESC' => 'Lotus Notes 与 Sugar 的整合。',


    //jc:#12287 - For javascript validation messages
    'MSG_IS_NOT_BEFORE' => '必须遭遇',
    'MSG_IS_MORE_THAN' => '多于',
    'MSG_IS_LESS_THAN' => '小于',
    'MSG_SHOULD_BE' => '应该是',
    'MSG_OR_GREATER' => '或大于',
    'MSG_EXCEEDS_MAXLEN' => '超过指定的最大长度',

    'LBL_PORTAL_WELCOME_TITLE' => '欢迎来到Sugar门户 5.1.0',
    'LBL_PORTAL_WELCOME_INFO' => 'Sugar Portal 是一个给客户提供实时的客户反馈，缺陷追踪和新闻订阅到框架。它是一个面对 Sugar 的内部接口，且可部署到任何 Web 站点上。持续的为客户自助服务，例如项目管理和论坛进行调整优化。',
    'LBL_LIST' => '列表',
    'LBL_CREATE_CASE' => '创建客户反馈',
    'LBL_CREATE_BUG' => '创建错误',
    'LBL_NO_RECORDS_FOUND' => '- 0 条 记录被找到 -',

    'DATA_TYPE_DUE' => '到期：',
    'DATA_TYPE_START' => '开始：',
    'DATA_TYPE_SENT' => '已发送：',
    'DATA_TYPE_MODIFIED' => '已修改：',


    //jchi at 608/06/2008 10913am china time for the bug 12253.
    'LBL_REPORT_NEWREPORT_COLUMNS_TAB_COUNT' => '合计',
    //jchi #19433
    'LBL_OBJECT_IMAGE' => '目标图形',
    //jchi #12300
    'LBL_MASSUPDATE_DATE' => '请选择日期',

    'LBL_VALIDATE_RANGE' => '不在有效范围之内',
    'LBL_VALIDATE_URL' => '非有效 URL',

    //jchi #  20776
    'LBL_DROPDOWN_LIST_ALL' => '全部',

    'LBL_OPERATOR_IN_TEXT' => '属于:',
    'LBL_OPERATOR_NOT_IN_TEXT' => '不属于:',


    //Connector
    'ERR_CONNECTOR_FILL_BEANS_SIZE_MISMATCH' => '错误：Bean 参数的数组个数和结果数组的个数不相符。',
    'ERR_MISSING_MAPPING_ENTRY_FORM_MODULE' => '错误：模块映射入口不存在。',
    'ERROR_UNABLE_TO_RETRIEVE_DATA' => '错误：{0}连接器不能获得数据。 服务现在可能无法进入或 配置设置无效。连接器错误信息：({1})。',
    'ERROR_CONNECTOR_CONFIGURE' => '无法检索数据。该服务目前可能无法访问或配置设置可能无效。',
    'LBL_CONNECT_TWITTER' => '链接到 Twitter',
    'LBL_ERROR_CANNOT_FIND_TWITTER' => '从Twitter ID找不到有效的时间表',
    'LBL_CONNECT_TWITTER_FOR_ADMIN' => '配置 Twitter Connector',
    'LBL_CONNECT_TEST_FAIL' => '错误：连接器配置设置可能无效。请与管理员联系。',
    'LBL_CONFIGURE_TWITTER' => '联系管理员配置Twitter',
    'LBL_MERGE_CONNECTORS' => '获取数据',
    'LBL_NO_DATA_AVAILABLE' => '没有可用的数据。',
    'LBL_MERGE_CONNECTORS_BUTTON_KEY' => '[D]',
    'LBL_REMOVE_MODULE_ENTRY' => '你确定要对这个模块停用连接器吗？',

    //Elastic
    'ERR_ELASTIC_TEST_FAILED' => '未能连接到弹性服务器',

    //cma
    'LBL_MASSUPDATE_DELETE_GLOBAL_TEAM' => '对不起，你不能删除全局团队。 异常退出。',
    'LBL_MASSUPDATE_DELETE_USER_EXISTS' => '[{1}] 用户被删除后，才能删除此私人团队 [{0}]。',

    //martin #25548
    'LBL_NO_FLASH_PLAYER' => '请先安装或者打开已经安装的Flash。<a href="http://www.adobe.com/go/getflashplayer/">点击获得最新的Flash播放器</a>。',
    //Collection Field
    'LBL_COLLECTION_NAME' => '名称',
    'LBL_COLLECTION_PRIMARY' => '主要团队',
    'ERROR_MISSING_COLLECTION_SELECTION' => '清空必要字段',
    'LBL_COLLECTION_EXACT' => '确切团队',

    // fastcgi checks
    'LBL_FASTCGI_LOGGING' => '为了得到使用IIS/FastCGI sapi的最佳体验，请在你的php.ini文件中设置fastcgi.logging为0。',
    //MB -Fixed Bug #32812 -Max
    'LBL_ASSIGNED_TO_NAME' => '负责人',
    'LBL_DESCRIPTION' => '说明',
    'LBL_PRIMARY_CONTACT_NAME' => '主要联系人',
    'LBL_PRIMARY_CONTACT_ID' => '主要联系人 ID',

    'LBL_NONE' => '-无-',
    'LBL_YESTERDAY' => '昨天',
    'LBL_TODAY' => '今天',
    'LBL_TOMORROW' => '明天',
    'LBL_NEXT_WEEK' => '下周',
    'LBL_NEXT_MONDAY' => '下周一',
    'LBL_NEXT_FRIDAY' => '下周五',
    'LBL_TWO_WEEKS' => '两周',
    'LBL_NEXT_MONTH' => '下个月',
    'LBL_FIRST_DAY_OF_NEXT_MONTH' => '下个月第一天',
    'LBL_THREE_MONTHS' => '三个月',
    'LBL_SIXMONTHS' => '六个月',
    'LBL_NEXT_YEAR' => '下一年',
    'LBL_FILTERED' => '筛选的',

    //Datetimecombo fields
    'LBL_HOURS' => '小时',
    'LBL_MINUTES' => '分钟',
    'LBL_MERIDIEM' => '正午',
    'LBL_DATE' => '日期',
    'LBL_DASHLET_CONFIGURE_AUTOREFRESH' => '自动更新',

    'LBL_DURATION_DAY' => '天',
    'LBL_DURATION_HOUR' => '小时',
    'LBL_DURATION_MINUTE' => '分钟',
    'LBL_DURATION_DAYS' => '天',
    'LBL_DURATION_HOURS' => '小时',
    'LBL_DURATION_MINUTES' => '分钟',
    'LBL_DURATION_SECONDS' => '秒',

    //Calendar widget labels
    'LBL_CHOOSE_MONTH' => '选择月',
    'LBL_ENTER_YEAR' => '输入年',
    'LBL_ENTER_VALID_YEAR' => '请输入有效年',

    //SugarFieldPhone labels
    'LBL_INVALID_USA_PHONE_FORMAT' => '请输入美国的电话号码, 包括电话区号。',
    'LBL_CCP_NOT_INITIATED' => '在代理未登录时尝试使用 CCP 拨号。',
    'LBL_CCP_LIBRARY_CALLOUT_ERROR' => '无法通过 CCP 发起通话。',
    'LBL_CCP_DIALING_ERROR' => '无法根据拨出的号码完成此通话。',
    'LBL_CCP_DIALOUT_NOT_ALLOWED' => '请在拨出电话前关闭 SugarLive 中的所有聊天会话。',

    //File write error label
    'ERR_FILE_WRITE' => '错误：不能写文件 {0} .请检查系统和网络服务器权限。',
    'ERR_FILE_NOT_FOUND' => '错误：不能装入文件 {0}.  请检查系统和网络服务权限。',

    'LBL_AND' => '和',
    'LBL_BEFORE' => '之前',

    // File fields
    'LBL_UPLOAD_FROM_COMPUTER' => '从您的电脑上传',
    'LBL_SEARCH_EXTERNAL_API' => '存档在外部文件',
    'LBL_FILE_UPLOAD_TO_EXTERNAL_API' => '上传到外部来源',
    'LBL_FILE_LINK_FROM_EXTERNAL_API' => '从外部来源链接',
    'LBL_EXTERNAL_SECURITY_LEVEL' => '安全',
    'LBL_SHARE_PRIVATE' => '私人的',
    'LBL_SHARE_COMPANY' => '公司',
    'LBL_SHARE_LINKABLE' => '可链接的',
    'LBL_SHARE_PUBLIC' => '公共的',


    // Web Services REST RSS
    'LBL_RSS_FEED' => 'RSS信息源',
    'LBL_RSS_RECORDS_FOUND' => '发现记录',
    'ERR_RSS_INVALID_INPUT' => 'RSS 不是有效的输入类型',
    'ERR_RSS_INVALID_RESPONSE' => 'RSS 不是这个程序的有效回复类型',

    //External API Error Messages
    'ERR_GOOGLE_API_415' => '谷歌文件不支持您提供的文件格式',

    'LBL_BLANK_VALUE' => '<empty>',
    'LBL_EMPTY' => '空白',
    'LBL_IS_EMPTY' => '空白',
    'LBL_IS_NOT_EMPTY' => '非空白',
    //IMPORT SAMPLE TEXT
    'LBL_IMPORT_SAMPLE_FILE_TEXT' => '"这是一份导入的样板文件，为即将导入的预期文件提供范例."
"该文件为逗号定界档，使用双引号作为限定字段。"

"标题行是文件顶行，包括了您会在应用程序中看到的字段标签。"
"这些标签用于匹配文件中的数据和应用程序中的字段。"
"注意: 数据名字也可以用于标题行。这有助于您在使用数据库管理或者其它数据管理工具时导入外部数据列表。"
"出列顺序并不重要，因为导入的过程会将数据匹配到标题行中的对应字段。"

"根据以下步骤使用该文件作为模版："
"1. 删除数据的样板行"
"2. 删除您现在真正阅读的帮助内容"
"3. 把您自己的数据输入到对应的行和列中"
"4. 把文件保存到您系统的特定位置"
"5. 在程序中从操作菜单中点击导入选项，并选择文件上传"',
    //define labels to be used for overriding local values during import/export
    // ID labels
    'LBL_EXPORT_ASSIGNED_USER_ID' => '担当ID',
    'LBL_EXPORT_CREATED_BY' => '创建人 ID',
    'LBL_EXPORT_MODIFIED_USER_ID' => '修改人 ID',
    'LBL_EXPORT_REPORTS_TO_ID' => '汇报对象 ID',
    'LBL_EXPORT_TEAM_ID' => '团队ID',
    'LBL_EXPORT_TEAM_SET_ID' => '团队组 ID',
    // Other labels
    'LBL_EXPORT_ASSIGNED_USER_NAME' => '被分配者',
    'LBL_EXPORT_FULL_NAME' => '全名',
    'LBL_EXPORT_TEAM_NAME' => '团队',

    'LBL_QUICKEDIT_NODEFS_NAVIGATION' => '查找中...',

    'LBL_PENDING_NOTIFICATIONS' => '提示',
    'LBL_ALT_ADD_TEAM_ROW' => '新增团队行',
    'LBL_ALT_REMOVE_TEAM_ROW' => '删除团队',
    'LBL_ALT_SPOT_SEARCH' => '地点搜索',
    'LBL_ALT_NOT_SORTED' => '未排序',
    'LBL_ALT_SORT_DESC' => '降序分类',
    'LBL_ALT_SORT_ASC' => '升序分类',
    'LBL_ALT_SORTABLE' => '可排序',
    'LBL_ALT_NOT_SORTABLE' => '不可排序',
    'LBL_ALT_SORT' => '排序',
    'LBL_ALT_SHOW_OPTIONS' => '显示选项',
    'LBL_ALT_HIDE_OPTIONS' => '隐藏选项',
    'LBL_ALT_MOVE_COLUMN_LEFT' => '将选中项移至显示列表左端',
    'LBL_ALT_MOVE_COLUMN_RIGHT' => '将选中项移至显示列表右端',
    'LBL_ALT_MOVE_COLUMN_UP' => '将选中项移至显示列表上端',
    'LBL_ALT_MOVE_COLUMN_DOWN' => '将选中项移至显示列表下端',
    'LBL_ALT_INFO' => '信息',
    'MSG_DUPLICATE' => '您将创建的{0}记录可能与以下显示的已有{0}记录重复。<br>点击创建 {1} 继续创建 {0}, 或者选择以下已有{0}。',
    'MSG_SHOW_DUPLICATES' => '您将创建的{0}记录可能与以下显示的已有{0}记录重复。 {1} 包含类似名字的记录如下。点击保存继续创建该记录{0}, 或点击取消返回，跳过创建 {0}。',
    'LBL_EMAIL_TITLE' => '电子邮件地址',
    'LBL_EMAIL_OPT_TITLE' => '被退回邮箱',
    'LBL_EMAIL_INV_TITLE' => '无效电子邮件地址',
    'LBL_EMAIL_PRIM_TITLE' => '主要邮箱',
    'LBL_SELECT_ALL_TITLE' => '选择全部',
    'LBL_SELECT_THIS_ROW_TITLE' => '选择该行',
    'LBL_TEAM_SELECTED_TITLE' => '被选团队',
    'LBL_TEAM_SELECT_AS_PRIM_TITLE' => '选择该团队为主要团队',
    'LBL_TEAM_TBSELECTED_TITLE' => '团队被标记为选择的团队 ',
    'LBL_TEAM_SELECT_AS_TBSELECTED_TITLE' => '将该团队标记为选择的团队',
    'LBL_SEARCH_AND_SELECT' => '查找和选择 {{module}}',
    'TPL_SEARCH_AND_ADD' => '搜索并添加 {{module}}',

    //for upload errors
    'UPLOAD_ERROR_TEXT' => '错误：上传过程出错. 错误代码: {0} - {1}',
    'UPLOAD_ERROR_TEXT_SIZEINFO' => '错误：上传过程出错. 错误代码. 错误代码: {0} - {1}. 上传的最大值为{2}',
    'UPLOAD_ERROR_HOME_TEXT' => '错误：上传过程出错. 请联系管理者获取帮助.',
    'UPLOAD_MAXIMUM_EXCEEDED' => '上传的大小({0} bytes) 超出最大允许值: {1} 字节',
    'UPLOAD_REQUEST_ERROR' => '已经发生错误。请刷新你的页面,再试一次。',

    //508 used Access Keys
    'LBL_EDIT_BUTTON_KEY' => 'i',
    'LBL_EDIT_BUTTON_LABEL' => '编辑',
    'LBL_ADD_BUTTON_LABEL' => '添加',
    'LBL_EDIT_BUTTON_TITLE' => '编辑',
    'LBL_REFRESH_BUTTON_LABEL' => '刷新',
    'LBL_REFRESH_BUTTON_TITLE' => '刷新',
    'LBL_DUPLICATE_BUTTON_KEY' => 'u',
    'LBL_DUPLICATE_BUTTON_LABEL' => '重复',
    'LBL_DUPLICATE_BUTTON_TITLE' => '重复',
    'LBL_REPORT_SCHEDULES_BUTTON_LABEL' => '报告日程',
    'LBL_REPORT_SCHEDULES_BUTTON_TITLE' => '报告日程',
    'LBL_REPORT_DETAILS_BUTTON_LABEL' => '报表细节',
    'LBL_REPORT_DETAILS_BUTTON_TITLE' => '报表细节',
    'LBL_DELETE_BUTTON_KEY' => 'd',
    'LBL_DELETE_BUTTON_LABEL' => '删除',
    'LBL_DELETE_BUTTON_TITLE' => '删除',
    'LBL_SAVE_BUTTON_KEY' => 'a',
    'LBL_SAVE_BUTTON_LABEL' => '保存',
    'LBL_SAVE_BUTTON_TITLE' => '保存',
    'LBL_CANCEL_BUTTON_KEY' => 'l',
    'LBL_CANCEL_BUTTON_LABEL' => '取消',
    'LBL_CANCEL_BUTTON_LABEL_CONT' => '停止',
    'LBL_CANCEL_BUTTON_LABEL_UNSAVED_CONT' => '停留在本页',
    'LBL_CANCEL_BUTTON_TITLE' => '取消',
    'LBL_SHARE_BUTTON_KEY' => 'r',
    'LBL_SHARE_BUTTON_LABEL' => '分享',
    'LBL_SHARE_BUTTON_TITLE' => '分享',
    'LBL_START_BUTTON_LABEL' => '开始',
    'LBL_START_BUTTON_TITLE' => '开始',
    'LBL_FINISH_BUTTON_LABEL' => '完成',
    'LBL_FINISH_BUTTON_TITLE' => '完成',
    'LBL_CONFIRM_BUTTON_LABEL' => '确定',
    'LBL_CONFIRM_BUTTON_LABEL_CONT' => '继续',
    'LBL_CONFIRM_BUTTON_LABEL_UNSAVED_CONT' => '离开页面并放弃更改。',
    'LBL_FIRST_INPUT_EDIT_VIEW_KEY' => '7',
    'LBL_ADV_SEARCH_LNK_KEY' => '8',
    'LBL_FIRST_INPUT_SEARCH_KEY' => '9',
    'LBL_GLOBAL_SEARCH_LNK_KEY' => '0',
    'LBL_KEYBOARD_SHORTCUTS_HELP_TITLE' => '键盘快捷方式',
    'LBL_KEYBOARD_SHORTCUTS_HELP' => '<p><strong>表格功能- Alt+</strong><br/> I = ed<b>I</b>t (查看详情)<br/> U = d<b>U</b>复制(查看详情)<br/> D = <b>D</b>删除 (查看详情)<br/> A = s<b>A</b>ve (编辑视图)<br/> L = cance<b>L</b> (编辑视图) <br/><br/></p><p><strong>搜索和导航  - Alt+</strong><br/> 7 = 在编辑表上的首次输入<br/> 8 = 高级搜索链接<br/> 9 = 首次的搜索表格输入<br/> 0 = 统一的搜索输入<br></p>',

    // For Escalating a record
    'LBL_ESCALATE_BUTTON_LABEL' => '升级',

    // Share feature on record
    'LBL_RECORD_SHARE_BUTTON' => '分享',
    'TPL_RECORD_SHARE_SUBJECT' => '分享 {{module}} {{name}} from {{appId}}',
    'TPL_RECORD_SHARE_BODY' => '请检查 {{module}} {{name}} from {{appId}}',

    'ERR_CONNECTOR_NOT_ARRAY' => '在 {0} 中的连接器排列被错误定义，或者空白，或者无法使用。',
    'LBL_PDF_VIEW' => '下载PDF',
    'LBL_PDF_EMAIL' => '邮件发送PDF',

    'ERR_SUHOSIN' => '升级流被Suhosin阻止，请添加 "upload" 至suhosin.executor.include.whitelist （查看sugarcrm.log来获得更多信息）',

    //for sidecar
    'LBL_TIME_AGO_NOW' => '立即',
    'LBL_TIME_AGO_SECONDS' => '一分钟以内',
    'LBL_TIME_AGO_MINUTE' => '约一分钟前',
    'LBL_TIME_AGO_MINUTES' => '{{this}} 分钟前',
    'LBL_TIME_AGO_HOUR' => '约一个小时前',
    'LBL_TIME_AGO_HOURS' => '{{this}} 小时前',
    'LBL_TIME_AGO_DAY' => '昨天',
    'LBL_TIME_AGO_DAYS' => '{{this}} 天前',
    'LBL_TIME_AGO_YEAR' => '一年多前',
    'LBL_TIME_UNTIL_SECONDS' => '不到一分钟',
    'LBL_TIME_UNTIL_MINUTE' => '大约1分钟',
    'LBL_TIME_UNTIL_MINUTES' => '在{{this}} 分钟',
    'LBL_TIME_UNTIL_HOUR' => '在大约一个小时',
    'LBL_TIME_UNTIL_HOURS' => '{{this}} 小时',
    'LBL_TIME_UNTIL_DAY' => '明天',
    'LBL_TIME_UNTIL_DAYS' => '{{this}} 天内',
    'LBL_TIME_UNTIL_YEAR' => '一年多',
    'LBL_TIME_RELATIVE' => '发布{{relativetime}}于{{date}}的{{time}}',
    'LBL_LAST_TOUCHED' => '最后一次接触{{relativetime}}于{{date}}的{{time}}',
    'LBL_LAST_COMMIT' => '上次承诺: ',
    'LBL_LISTVIEW_NO_RECORDS' => '没有可用的数据。',
    'LBL_DETAILVIEW_NO_RECORDS' => '当前这条记录不能被表示。',
    'LBL_REFINE_LIST' => '筛选列表',
    'LBL_SEARCH_BY' => '搜索按',
    'LBL_PREVIEW' => '预览',
    'LBL_COLUMNS' => '列数',
    'LBL_PREVIEW_DISABLED_NO_RECORD' => '预览失败：无可用数据',
    'LBL_PREVIEW_DISABLED_NO_ACCESS' => '预览失败：未能获取记录',
    'LBL_PREVIEW_DISABLED_ATTACHMENT' => '预览失败：无可用数据',
    'LBL_PREVIEW_DISABLED_SAME_RECORD' => '预览禁用：作为当前记录',
    'LBL_PREVIEW_DISABLED_DELETED_OR_NO_ACCESS' => '预览禁用：记录删除或不记录访问',
    'LBL_PREVIEW_PREVIOUS' => '预览上一页',
    'LBL_PREVIEW_NEXT' => '预览下一页',
    'LBL_PREVIEW_CLOSE' => '结束预览',
    'LBL_STREAM_NO_RECORDS' => '当前这条记录没有注释。请添加注释，点击“添加注释”链接。',
    'LBL_DUPLICATES_FOUND' => '{{duplicateCount}}发现重复',
    'LBL_NO_DUPLICATES_FOUND' => '未找到任何重复项。',
    'LBL_RESET_DEFAULT_VIEW' => '重置默认视图',
    'LBL_RESET_DEFAULT_WIDTHS' => '重置默认宽度',
    'LBL_TIMEZONE_UPDATED' => 'Sugar 已更新您的用户个人资料时区，以匹配您的浏览器时区',
    'LBL_SUCCESS' => '成功',
    'LBL_ERROR' => '错误',

    //Merge Duplicates
    'LBL_MERGE_DUPLICATES' => '合并重复项',
    'LBL_MERGE_DUPLICATES_PROCEED' => '你要继续吗？',
    'LBL_MERGE_DUPLICATES_CONFIRM' => '这个动作会删除下列记录',
    'LBL_MERGE' => '合并',
    'TPL_MERGING_RECORDS' => '合并 {{mergeCount}}条记录',
    'TPL_MERGE_INVALID_NUMBER_RECORDS' =>
        '无效的数字传递的记录。 有效范围是从{{minRecords}} 到 {{maxRecords}} records。',
    'LBL_MERGE_NO_ACCESS' =>
        '您没有访问权限才能执行此操作',
    'LBL_MERGE_LOCKED' => '一些被选中合并的记录所包含的字段被流程锁定编辑，此时无法合并。',
    'LBL_MERGE_NO_ACCESS_TO_A_FEW_RECORDS' =>
        'One or more selected records cannot be deleted. ' .
        'Those records have been removed from the list to merge.',
    'LBL_MERGE_UNSAVED_CHANGES' =>
        '您将要更改主记录不保存您所作的任何更改。所有的更改将会丢失。您确定要继续吗？',
    'LBL_MERGE_DUPLICATES_TITLE' => '合并相关记录',
    'TPL_MERGE_DUPLICATES_PROGRESS_STATUS' => '合并：{{percent}}%',
    'TPL_MERGE_DUPLICATES_FAIL_TO_ATTEMPT' =>
        '合并关联 {{objectName}} 失败.开始新的尝试从 ({{num}} of {{total}}).',
    'TPL_MERGE_DUPLICATES_FAIL' =>
        '合并关联 {{objectName}} 失败',
    'LBL_MERGE_DUPLICATES_WARNING_CLOSE' =>
        '合并相关记录不完整。一些记录仍然未合并。',
    'LBL_MERGE_DUPLICATES_FAIL_PROCESS' =>
        '合并相关记录不完整。一些记录仍然未合并。你要继续吗？',
    'TPL_MERGE_DUPLICATES_STAT' =>
        '{{#with stat}}{{records}} records were merged successfully. ' .
        '{{total}} related records were added.{{/with}}',
    'TPL_MERGE_DUPLICATES_IDENTICAL' =>
        '所有相关的记录移到主要记录。',
    'LBL_MERGE_DUPLICATES_REMOVE' =>
        '您确定要删除合并这条记录?',
    'LBL_MERGE_DUPLICATES_REMOVE_TOOLTIP' => '合并删除记录',

    //Filters
    'TPL_FILTER_MAX_NUMBER_RECORDS' => '忽略无效的记录数。有效范围为 1 至 {{maxRecords}} 记录。',

    //for sugar7 errors
    'LBL_INVALID_CREDS' => '所提供的用户名/密码组合不正确，请再试一次。',
    'LBL_INVALID_CREDS_TITLE' => '无效的认证',
    'LBL_INVALID_GRANT' => '您的令牌是无效或已过期。请重新登录。',
    'LBL_INVALID_GRANT_TITLE' => 'Token过期',
    'LBL_AUTH_FAILED' => '客户端身份验证失败。',
    'LBL_AUTH_FAILED_TITLE' => '无效的客户端',
    'LBL_INVALID_REQUEST' => '提出请求无效或格式不正确。请联系技术支持。',
    'LBL_INVALID_REQUEST_TITLE' => '无效的请求',
    'LBL_REQUEST_TIMEOUT' => '服务器未响应。请检查您的网络连接。',
    'LBL_REQUEST_TIMEOUT_TITLE' => '请求超时：',
    'LBL_UNAUTHORIZED' => '很抱歉，您无权访问该资源。',
    'LBL_UNAUTHORIZED_TITLE' => 'HTTP 错误: 未授权',
    'LBL_RESOURCE_UNAVAILABLE' => '资源不可用。',
    'LBL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP 错误: 被禁止',
    'LBL_METHOD_NOT_ALLOWED' => '该资源不支持HTTP方法。请联系技术支持。',
    'LBL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP 错误: 不允许的方法',
    'LBL_PRECONDITION_MISSING' => '请求失败，缺少或无效的参数。请联系技术支持',
    'LBL_PRECONDITION_MISSING_TITLE' => '错误：',
    'LBL_INVALID_412_RESPONSE' => '请求失败导致应用程序无法使用。请联系技术支持。',

    //SugarApiExceptionNotAuthorized language string
    'SUGAR_API_EXCEPTION_NOT_AUTHORIZED' => '在模块中:{1}不允许编辑字段{0}',
    'SUGAR_API_EXCEPTION_RECORD_NOT_AUTHORIZED' => '不允许执行操作 "{0}" 在这条记录',
    'LBL_LOGIN_BUTTON_LABEL' => '登录',
    'LBL_ACTIVITY_VIEW_TOUR' => '活动视图之旅',
    'LNK_TOUR' => '游览',
    'LNK_MOBILE' => '移动电话',
    'LBL_FEEDBACK' => '反馈',
    'LBL_SUPPORT' => '支持',
    'LBL_LANGUAGE' => '语言:',
    'LBL_LOADING_LANGUAGE' => '载入语言包',
    'LBL_UPLOADING' => '上传',
    'LBL_UPLOADING_DOTS' => '正在上传……',
    'LBL_IMAGE_DELETE_CONFIRM' => '您确定要删除这张图片？',
    'LBL_FILE_DELETE_CONFIRM' => '您确定要删除这个文件？这不能撤消。',
    'LBL_FILE_DELETED' => '文件被成功删除',

    //theme roller
    'LBL_PORTAL_THEME' => '门户主题',
    'LBL_THEME_PREVIEW' => '门户主题预览',
    'LBL_LOADING_PREVIEW' => '加载预览',
    'LBL_RESET' => '重置',
    'LBL_COLORS' => '颜色',
    'BorderColor' => '边框色',
    'NavigationBar' => '导航条',
    'PrimaryButton' => '主按钮',
    'LBL_SAVE_AND_DEPLOY_BTN' => '保存与部署',
    'LBL_RESET_THEME_LNK' => '恢复默认主题',
    'LBL_RESET_THEME_MODAL_INFO' => '你要删除您的自定义主题与默认主题。',
    'LBL_RESET_THEME_PROCESS' => '正在恢复默认主题...',
    'LBL_SAVE_THEME_PROCESS' => '正在默认主题...',

    // image loader
    'LBL_SELECT_PHOTO' => '选择一个照片',

    //in app tour
    'LBL_TOUR_SCREEN_1_TITLE_670' => '在Sugar中增强了预测功能',
    'LBL_TOUR_SCREEN_1_DESCRIPTION_670' => '<div style="float: left;"> <div style="float: left; width: 300px;"> <ul><li class="fa fa-check"> 设置你预测的参数</li> <li class="fa fa-check"> 很容易跟踪预计的销售额和管道健康</li> <li class="fa fa-check"> 预测基于从您的销售团队的预计销售额</li></ul></div> <div class="well"style="float: left; width: 220px; margin-left: 20px;"> <img src="themes/default/images/pt-screen1-thumb.png"width="220"id="thumbnail_1"class="thumb"></div></div> <div class="clear"></div>',
    'LBL_TOUR_SCREEN_2_TITLE_670' => '设置你的预测参数',
    'LBL_TOUR_SCREEN_2_DESCRIPTION_670' => '<div style="float: left;"> <div style="float: left; width: 300px;"> <ul><li class="fa fa-check"> 选择会计年度的开始日期</li> <li class="fa fa-check"> 设置时间段是不是每年或每季度</li> <li class="fa fa-check"> 决定多少过去和未来时间段需要在工作表中可见</li> <li class="fa fa-check"> 选择预测范围来标记为包含、 排除或上行机会</li> <li class="fa fa-check"> 选择预测的方案，以确定有可能，最好和最坏的预测</li></ul></div> <div class="well"style="float: left; width: 220px; margin-left: 20px;"> <img src="themes/default/images/pt-screen2-thumb.png"width="220"id="thumbnail_2"class="thumb"></div></div> <div class="clear"></div>',
    'LBL_TOUR_SCREEN_3_TITLE_670' => '管理销售团队的销售计划',
    'LBL_TOUR_SCREEN_3_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">选择时间周期来回顾预测</li><br />  <li class="fa fa-check">查看您的销售团队成员的工作表,并提供调整预测功能。</li><li class="fa fa-check">查看提示当销售团队成员提交的新预测工作表</li><br />  <li class="fa fa-check">保存为草稿预测工作表或提交给你的经理</li><li class="fa fa-check">查看上次提交历史记录。</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen3-thumb.png" width="220" id="thumbnail_3" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_4_TITLE_670' => '管理销售团队的销售计划',
    'LBL_TOUR_SCREEN_4_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">查看帕累托图表管道，预测分析所有销售团队成员</li><li class="fa fa-check">选择可视化的预计销售可能性,预测最好或最坏。</li><li class="fa fa-check">查看预计销售情况和如何完成你的团队销售指标。</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen4-thumb.png" width="220" id="thumbnail_4" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_5_TITLE_670' => '管理自己的销售计划',
    'LBL_TOUR_SCREEN_5_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><br />  <li class="fa fa-check">为你的预测选择时间段</li><br />  <li class="fa fa-check">为快速假设分析和编辑数量和赢的概率</li><li class="fa fa-check">保存为草稿预测工作表或提交预测给你的经理</li><li class="fa fa-check">查看之前的提交历史</li><li class="fa fa-check">提交预测给经理并查看之前的提交历史</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen5-thumb.png" width="220" id="thumbnail_5" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_SCREEN_6_TITLE_670' => '管理自己的销售计划',
    'LBL_TOUR_SCREEN_6_DESCRIPTION_670' => '<div style="float: left;"><div style="float: left; width: 300px;"><ul><li class="fa fa-check">查看一个时段的帕累托图潜在销售分析以显示商业机会。</li><li class="fa fa-check">选择潜在销售分布可视化销售阶段或成功概率。</li><li class="fa fa-check">查看是预计销售，已经您离目标销售的距离。</li></ul></div><div class="well" style="float: left; width: 220px; margin-left: 20px;"><img src="themes/default/images/pt-screen6-thumb.png" width="220" id="thumbnail_6" class="thumb"></div></div><div class="clear"></div>',
    'LBL_TOUR_WELCOME' => 'Sugar有什么新特性?',
    'LBL_TOUR_WATCH' => '查看Sugar有什么新特性?',
    'LBL_TOUR_FEATURES_670' => '<ul style=""><li class="fa fa-check">改进的外观和个性化 - 现在正以崭新的现代主题。</li><li class="fa fa-check">增强预测模块-直观的用户界面和新的数据可视化</li></ul>',
    'LBL_TOUR_VISIT' => '有关详细信息，请访问我们的应用程序',
    'LBL_TOUR_DONE' => '您已完成！',
    'LBL_TOUR_REFERENCE_1' => '您可以参考我们的',
    'LBL_TOUR_REFERENCE_2' => '通过“支持”下的链接配置文件菜单。',
    'LNK_TOUR_DOCUMENTATION' => '文件',
    'LBL_TOUR_CALENDAR_URL_1' => '与第三方应用程序分享你的 SugarCRM 日程安排吗?（如Microsoft Outlook 或 Exchange）。如果是这样，你有一个新的URL。这个一个新的、更安全的URL，这将防止未经授权就发布你的日程安排。',
    'LBL_TOUR_CALENDAR_URL_2' => '检索共享 URL 日程安排',
    'LBL_TOUR_CUBE' => '访问仪表板和活动流',
    'LBL_TOUR_NAV_BAR' => '访问“导航”菜单中的所有模块并执行操作',
    'LBL_TOUR_NOTIFICATIONS' => '点击查看通知',
    'LBL_TOUR_SEARCH' => '选择一个或多个模块并进行搜索',
    'LBL_TOUR_AVATAR' => '获取更多有关应用程序或“注销”的详细信息',
    'LBL_TOUR_ADD' => '从这里创建记录',
    'LBL_TOUR_LIST_INT_TOGGLE' => '点击打开或关闭智能面板',
    'LBL_TOUR_LIST_ACTIVTYSTREAMLIST_TOGGLE' => '选择查看活动或记录的列表',
    'LBL_TOUR_LIST_FILTER1' => '筛选器栏让搜索这个模块',
    'LBL_TOUR_LIST_FILTER2' => '选择预定义筛选器或创建新',
    'LBL_TOUR_LIST_FILTER_SEARCH' => '在这里输入要搜素的名称',
    'LBL_TOUR_LIST_FILTER_PREVIEW' => '选择要编辑的行或预览细节',
    'LBL_TOUR_RECORD_ACTIONS' => '采取行动的记录',
    'LBL_TOUR_RECORD_SUBPANEL' => '点击标题可展开和折叠子面板',
    'LBL_TOUR_RECORD_INLINEEDIT' => '记录的名称可以随时更新',
    'LBL_TOUR_RECORD_STATUS' => '在这里查看记录的等级信息',
    'LBL_TOUR_RECORD_SHOWMORE' => '点击查看记录更多的信息',
    'LBL_TOUR_RECORD_TOGGLEACTIVITIES' => '选择查看活动或相关记录',
    'LBL_TOUR_RECORD_INLINEEDITRECORD' => '点击编辑每一个内嵌字段',
    'LBL_TOUR_RECORD_DASHBOARDACTIONS' => '为仪表板创建一个新的组',
    'LBL_TOUR_RECORD_DASHBOARDNAME' => '为仪表板的组分配一个名称',
    'LBL_TOUR_RECORD_DASHLETCOG' => '选择移除一个仪表板或者修改设置',
    'LBL_TOUR_INTRO' =>'<h4>欢迎使用 Sugar</h4> 我们将带您快速浏览一些功能。请使用屏幕底部的 <  和  > 箭头浏览快速向导。<ul class="resource-list"><li class="resource"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank"><span class="label label-module label-module-md pull-left blue"><i class="fa fa-2x fa-magic"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/02_Documentation/01_Sugar_Editions/" target="_blank">新功能</a><p class="details">了解各版本间的重要变更</p></div></li><li class="resource"><a href="http://university.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left green"><i class="fa fa-2x fa-book"></i></span></a><div class="resource-info"><a href="http://university.sugarcrm.com/" target="_blank">详细了解 Sugar</a><p class="details">一款稳定可靠的在线学习、真实与虚拟课堂训练、网络研讨会和视频教程库。</p></div></li><li class="resource"><a href="http://support.sugarcrm.com/" target="_blank"><span class="label label-module label-module-md pull-left red"><i class="fa fa-2x fa-question-circle"></i></span></a><div class="resource-info"><a href="http://support.sugarcrm.com/" target="_blank">获取帮助</a><p class="details">需要帮助，有问题或者希望提供帮助改进 Sugar 的建议？</p></div></li></ul>',
    'LBL_TOUR_LIST_INTRO' => '查看记录列表并记录活动。',
    'LBL_TOUR_RECORD_INTRO' => '查看这个记录的详细资料，和相关的所有数据。',
    'LBL_TOUR_FORECAST_INTRO' => '管理销售漏斗和预测信息。',
    'LBL_TOUR_FORECASTS_TIMEPERIODS' => '选择一个时间段查看相应的预测',
    'LBL_TOUR_FORECASTS_COMMITS' => '提交前点击查看',
    'LBL_TOUR_FORECASTS_INLINEEDIT' => '点击编辑内嵌数据',
    'LBL_TOUR_FORECASTS_PROGRESS' => '检查定额的差值',
    'LBL_TOUR_FORECASTS_CHART' => '回顾预测的分配信息',
    'LBL_TOUR_TOUR' => '在任何时候访问向导',
    'LBL_TOUR_TAGS_ADD' => '点击标记字段可添加和删除标记',
    'LBL_TOUR_TAGS_DELETE' => '若要删除标签，则使用退格键或点击每一标记上的 [X] 按钮',
    'LBL_TOUR_RECORD_SAVE' => '一旦准备就绪，点击保存',


    'LBL_FUTURE' => '新值',
    'LBL_REQUIRED_FIELD' => '必填',

    // For nomad mobile
    // start of: Quotes related
    'LBL_QLI_SINGLE_TITLE' => '已报价单项',
    'LBL_DISCOUNT_TOTAL' => '折扣总计',
    'LBL_DISCOUNT_PERCENT' => '百分比',
    'LBL_DISCOUNT_SELECT' => '确定折扣是百分比还是固定金额',
    'LBL_TAX' => '税费',
    'LBL_SHIPPING' => '运费',
    'LBL_GRAND_TOTAL' => '总计',
    'LBL_QUOTES_POPULATE_ADDRESS' => '从账户配置文件自动填充付款地址',
    'LBL_QLI_ADD_GROUP' => '添加一个组',
    'LBL_QLI_COMMENT' => '备注',
    'LBL_SELECT_ACTION' => '选择动作',
    'LBL_QLI_GROUP_NAME' => '组名',
    'LBL_GROUP_TOTAL' => '组总和',
    'LBL_ITEM_NAME' => '单项',
    'LBL_QLI_DELETE' => '您确定要删除这个单项吗？',
    'LBL_QLI_COMMENT_DELETE' => '您确定要删除这个单项注释吗？',
    'LBL_QLI_GROUP_DELETE' => '您确实希望删除组{0}吗？全部项都将移至默认组中。',
    'LBL_QLI_GROUP_EMPTY' => '无已报价单项',
    // end of: Quotes related

    'LBL_OPTIONAL' => '可选',
    'LBL_RELATED_MODULE' => '关联{{{this}}}',
    'LBL_RELATED_MODULE_PLURAL' => '关联{{{this}}}',
    'LBL_CREATE_MODULE' => '新建{{{this}}}',
    'LBL_EDIT' => '编辑{{{this}}}',
    'LBL_ASSOC' => '关联 {{{this}}}',
    'LBL_ASSIGN' => '选择 {{{this}}}',
    'LBL_EDIT_RELATED' => '编辑关联 {{{this}}}',
    'LBL_CREATE_RELATED' => '创建关联 {{{this}}}',
    'LBL_ASSOC_EXISTING' => '存在关联 {{{this}}}',
    'LBL_SEARCH_ALL' => '搜索全部 {{{this}}}...',
    'LBL_SEARCH_ALL_RECORDS' => '搜索全部记录',
    'LBL_SEARCH_ALL_MODULES' => '全局搜索',
    'LBL_OK' => '确定',
    'LBL_YES' => '是',
    'LBL_NO' => '否',
    'LBL_SHOW_NUMBERING' => '显示阶段编号',
    'LBL_HIDE_NUMBERING' => '隐藏阶段编号',
    'LBL_CALL_BUTTON' => '电话:',
    'LBL_SMS_BUTTON' => '短信',
    'LBL_EMAIL_BUTTON' => '电子邮件',
    'LBL_HONEYPOT' => '如果您是真人请不要填写',
    'LBL_LINK_BUTTON' => '链接',
    'LBL_UNLINK_BUTTON' => '取消链接',
    'LBL_MAP_BUTTON' => '映射',
    'LBL_FILE_BUTTON' => '文件',
    'LBL_URL_BUTTON' => '网络',
    'LBL_WARNING' => '警告',
    'LBL_CONFIRM' => '确认',
    'LBL_CONFIRMATION_POPUP' => '确认弹出窗口',
    'LBL_NO_ACCESS' => '(没有权限)',
    'LBL_NO_ACCESS_LOWER' => '用户未连接到记录',
    'LBL_NO_FIELD_ACCESS' => '没有权限',
    'LBL_NO_LICENSE_ACCESS' => '所需的许可证',
    'LBL_VALUE_ERASED' => '值已删除',
    'LBL_VALUE_ERASED_TOOLTIP' => '此信息已通过数据隐私请求删除',
    'LBL_CREATE_RELATED_RECORD' => '建立关联记录',
    'LBL_ASSOC_RELATED_RECORD' => '关联存在的记录',
    'LBL_CHOOSE_LINK' => '选择链接类型',
    'LBL_CHOOSE_PARENT_TYPE' => '选择父级类型',
    'LBL_HOME' => '首页',
    'ERR_NO_DOCS' => '没有有效文档',
    'ERR_NO_RECORDS_SELECTED' => '你不能选择任何记录',
    'LBL_DELETING' => '删除中...',
    'LBL_UNLINKING' => '正在取消链接...',
    'LBL_UNLINKED' => '已取消链接',
    'LBL_LEGAL' => '合法的',
    'LBL_UPCOMING' => '我的近期会议',
    'LBL_RECENTLY_UPDATED' => '最新更新',
    'LBL_NOTES_SUBPANEL_TITLE' => '笔记',
    'LBL_MEETINGS_SUBPANEL_TITLE' => '会议',
    'LBL_TASKS_SUBPANEL_TITLE' => '任务',
    'LBL_CALLS_SUBPANEL_TITLE' => '电话',
    'LBL_ACCOUNTS_SUBPANEL_TITLE' => '帐户',
    'LBL_CONTACTS_SUBPANEL_TITLE' => '联系人',
    'LBL_EMAILS_SUBPANEL_TITLE' => '电子邮件',
    'LBL_SHIFTS_SUBPANEL_TITLE' => '班次',
    'LBL_PRODUCTS_SUBPANEL_TITLE' => '已报价单项',
    'LBL_SHIFTS_EXCEPTIONS_SUBPANEL_TITLE' => '班次异常',
    'LBL_DOCUMENTS_SUBPANEL_TITLE' => '文档',
    'LBL_ESCALATIONS' => '升级',
    'LBL_ESCALATED' => '已升级',
    'LBL_ESCALATIONS_SUBPANEL_TITLE' => '背景',
    'LBL_OTHER_ESCALATIONS_SUBPANEL_TITLE' => '其他相关升级',
    'LBL_ESCALATIONS' => '升级',
    'LNK_SETTINGS' => '设置',
    'LBL_MOBILE_SUPPORT' => '支持',
    'LBL_MOBILE_SHOW_MORE' => '显示更多...',
    'LBL_MOBILE_SHOW_MORE_TOP' => '显示更多...',
    'LBL_MOBILE_NO_RECORDS' => '未找到记录',
    'LBL_MOBILE_SEARCH_TEAMS' => '搜索团队',
    'LBL_MOBILE_SELECT_TEAMS' => '选择团队',
    'LBL_MOBILE_WAIT' => '请等待...',
    'LBL_MOBILE_LOGING_OUT' => '请稍等，正在注销...',
    'LBL_MOBILE_RELOGIN_BUTTON' => '重新登录',
    'LBL_MOBILE_META_SYNC_FAILED' => '不能够同步服务器，是否重试?',
    'LBL_MOBILE_META_SYNC_FAILED_RETRY' => '无法与服务器同步，重试？',
    'LBL_MOBILE_PRIVACY_TERMS_CONDITIONS' => '隐私、条款和条件',
    'LBL_MOBILE_APP_VERSION' => '应用版本',
    'LBL_MOBILE_SERVER_VERSION' => '服务器版本',
    'LBL_MOBILE_SERVER_URL' => '服务器 URL',
    'LBL_MOBILE_PTR_PULL' => '下拉刷新....',
    'LBL_MOBILE_PTR_RELEASE' => '松开来刷新....',
    'LBL_MOBILE_EDIT_REL' => '编辑关系',
    'LBL_MOBILE_DESKTOP' => '桌面版',
    'LBL_MOBILE_DELETE_CONFIRM' => '您确定要删除这条记录吗？',
    'LBL_MOBILE_UNLINK_CONFIRM' => '你确认要解除这条记录的链接?',
    'LBL_MOBILE_LOG_CALL_CONFIRM' => '你想记录最后的电话吗?',
    'LBL_MOBILE_CHOOSE_RECIPIENT' => '选择接受者',
    'LBL_MOBILE_CHOOSE_PHONE' => '选择电话号码',
    'LBL_MOBILE_CHOOSE_URL' => '选择URL',
    'LBL_MOBILE_CHOOSE_DOC' => '选择文档',
    'LBL_MOBILE_CHOOSE_LOCATION' => '选择位置',
    'LBL_MOBILE_NO_ACTIONS_AVAILABLE' => '没有有效动作',
    'LBL_MOBILE_FEEDBACK' => '反馈',
    'LBL_MOBILE_DOC' => '文档',
    'LBL_MOBILE_DOWNLOAD_STARTED' => '开始下载: {{{this}}}',
    'LBL_MOBILE_DOWNLOAD_COMPLETED' => '下载完成: {{{this}}}',
    'LBL_MOBILE_UPLOAD_IN_PROGRESS' => '上传文件',
    'LBL_MOBILE_UPLOAD_SUCCESS' => '文件上传成功',
    'LBL_MOBILE_PROCESSING_IMAGE' => '准备图片',
    'LBL_CLOSE_SAVE_BUTTON' => '关闭任务和保存',
    'LBL_LATER' => '以后',
    'LBL_USE_HTTPS' => '使用安全连接',
    'LBL_LOADING_FILES' => '正在显示文档列表，请稍后再试。',
    'LBL_NEW_WEB_VERSION' => '一个新的SugarCRM的移动版本提供下载。您要更新吗？',
    'LBL_SET_FONTSIZE' => '字体大小',
    'LBL_FONTSIZE_TINY' => '很小',
    'LBL_FONTSIZE_SMALL' => '小',
    'LBL_FONTSIZE_NORMAL' => '标准（默认）',
    'LBL_FONTSIZE_LARGE' => '大',
    'LBL_FONTSIZE_LARGER' => '很大',
    'LBL_FONTSIZE_HUGE' => '非常大',
    'LBL_FONTSIZE_EXTRA_HUGE' => '最大',
    'LBL_MOBILE_DOWNLOAD_FAILED' => "下载失败\n{{{this}}}",
    'LBL_MOBILE_DETAIL_SHOW_MORE' => '更多...',
    'LBL_MOBILE_DETAIL_SHOW_LESS' => '更少',
    'LBL_OFFLINE_MODE' => '离线模式',
    'LBL_OFFLINE_DELETED' => '记录未找到',
    'LBL_OFFLINE_DELETED_RELATED' => '相关记录未找到，可能被删除或没有连接。',
    'LBL_OFFLINE_PREFETCH_PROMPT' => '下载您被分配、标记和跟踪的记录以便于在离线模式时使用，这会花费一些时间，建议您使用高速宽带网络。是否继续？',
    'LBL_OFFLINE_PREFETCH_FIRST_PROMPT' => '您是否希望下载您被分配，标记，和跟踪的记录以便于离线模式使用，这会花费一些时间，建议您使用高速宽带网络。您也可以稍后从“主菜单>离线模式”进入。',
    'LBL_OFFLINE_PREFETCH_SUCCESS' => '记录下载完成。',
    'LBL_OFFLINE_PREFETCH_ACTION' => '正在下载您的记录',
    'LBL_OFFLINE_PREFETCH_ERROR' => '下载记录出错',
    'LBL_OFFLINE_PREFETCHING' => '正在显示记录...',
    'LBL_OFFLINE_PREFETCHING_MODULE' => '正在显示 {{module}} {{progressValue}}...',
    'LBL_OFFLINE_PREFETCHING_EST_TIME' => '剩余时间 {{estimatedTime}}s...',
    'LBL_OFFLINE_PREFETCHING_MODULE_COMPLETE' => '引导 {{module}} 模块完成',
    'LBL_OFFLINE_DB_CLEANING_IN_PROGRESS' => '正在清理存储……',
    'LBL_OFFLINE_DB_CLEANING_COMPLETED' => '清理完毕',
    'LBL_OFFLINE_ROLLBACK_PROMPT' => '您希望恢复上次修改吗？',
    'LBL_OFFLINE_ROLLBACK_SUCCESS' => '恢复完成',
    'LBL_OFFLINE_ROLLBACK_FAILED' => '恢复失败',
    'LBL_OFFLINE_CLEAR_DB' => '清理存储……',
    'LBL_OFFLINE_COMPACT_DB' => '压缩存储...',
    'LBL_OFFLINE_CLEAN_UP_PROMPT' => '此命令将删除那些您一段时间没有访问的数据，是否继续?',
    'LBL_OFFLINE_CLEAR_DB_PROMPT' => '您是否要删除本地保存所有记录？',
    'LNK_OFFLINE_SETTINGS' => '离线',
    'LBL_OFFLINE_SETTINGS' => '排除错误设置',
    'LBL_OFFLINE_STATUS_NO_PENDING_TX' => '没有修改需要同步',
    'LBL_OFFLINE_STATUS_PENDING_TX' => '修改正在等待同步',
    'LBL_OFFLINE_STATUS_ONLINE' => '设备在线',
    'LBL_OFFLINE_STATUS_OFFLINE' => '设备离线',
    'LBL_OFFLINE_STATUS_BAD_NETWORK' => '无法访问服务器。',
    'LBL_OFFLINE_STATUS_SYNC_FAILED' => '上次同步失败，请检查日志。',
    'LBL_OFFLINE_SYNC_IN_PROGRESS' => '正在同步',
    'LBL_OFFLINE_TRANSACTION_SYNCED' => '记录同步完成。',
    'LBL_OFFLINE_ENABLE_PROMPT' => '你是否确认关闭离线支持？',
    'LBL_OFFLINE_DISABLE_PROMPT' => '你是否确认关闭离线支持？所有待同步的修改将不会保存。',
    'LBL_OFFLINE_ENABLED' => '启用离线模式',
    'LBL_OFFLINE_DISABLED' => '离线模式关闭',
    'LBL_OFFLINE_STATS' => '存储数据',
    'LBL_OFFLINE_SERVER_FETCH' => '从服务器获取...',
    'LBL_OFFLINE_MERGE_DATA_CONFIRM' => '服务器上该记录已被其他用户修改，请确认是否使用您的修改更新该记录或是放弃修改？',
    'LBL_OFFLINE_LAST_SYNC_TS' => '上次同步: {{ts}}',
    'LBL_ACTION_UPDATE' => '更新',
    'LBL_ACTION_CREATE' => '创建',
    'LBL_ACTION_DELETE' => '删除',
    'LBL_ACTION_LINK' => '链接',
    'LBL_ACTION_UNLINK' => '取消链接',
    'LBL_ACTION_FAVORITE' => '收藏夹',
    'LBL_ACTION_FOLLOW' => '跟踪',
    'LBL_ACTION_CREATE_EXPLANATION' => '{{module}} "{{name}}" 已创建',
    'LBL_ACTION_UPDATE_EXPLANATION' => '{{module}} "{{name}}" 已更新',
    'LBL_ACTION_DELETE_EXPLANATION' => '{{module}} "{{name}}" 已删除',
    'LBL_ACTION_LINK_EXPLANATION' => '已连接 {{module}} "{{name}}" 和 {{relatedModule}} "{{relatedName}}"',
    'LBL_ACTION_UNLINK_EXPLANATION' => '从{{relatedModule}} "{{relatedName}}" 解除{{module}} "{{name}}"的链接',
    'LBL_ACTION_FOLLOW_EXPLANATION' => '跟踪{{module}} "{{name}}"',
    'LBL_ACTION_UNFOLLOW_EXPLANATION' => '停止跟踪{{module}} "{{name}}"',
    'LBL_ACTION_FAVORITE_EXPLANATION' => '收藏{{module}} "{{name}}"',
    'LBL_ACTION_UNFAVORITE_EXPLANATION' => '不收藏{{module}} "{{name}}"',
    'LBL_ACTION_CREATE_RELATED_EXPLANATION' => '创建{{module}} "{{name}}"关联到{{relatedModule}} "{{relatedName}}"',
    'LBL_EMAIL_ACTION_SET_PRIMARY' => '首要',
    'LBL_EMAIL_ACTION_SET_OPT_OUT' => '退出',
    'LBL_EMAIL_ACTION_SET_OPT_IN' => '加入',
    'LBL_EMAIL_ACTION_SET_VALID' => '有效',
    'LBL_EMAIL_ACTION_SET_INVALID' => '无效',
    'LBL_ROLLBACK_BUTTON' => '往后恢复',
    'LBL_TX_LOG' => '传输日志',
    'LBL_TX_LOG_DETAIL' => '交易详情',
    'LBL_RECORD_DELETED' => '(记录删除了)',
    'LBL_NOT_AVAILABLE' => '无',
    'LBL_FILE_SIZE' => '文件大小',
    'LBL_FILE_SIZE_UNITS_B' => '字节',
    'LBL_FILE_SIZE_UNITS_KB' => 'kB',
    'LBL_FILE_SIZE_UNITS_MB' => 'MB',
    'LBL_CHOOSE_ITEMS' => '选择项',
    'LBL_OFFLINE_DB_SIZE' => '数据库尺寸',
    'LBL_OFFLINE_RECORDS_PER_MODULE' => '每模块的记录',
    'LBL_OFFLINE_TOTAL_RECORDS_COUNT' => '总共记录',
    'LBL_RECORD_NOT_FOUND' => '记录没找到。',
    'LBL_RELATED_RECORD_NOT_FOUND' => '相关记录没找到。',
    'LBL_NOT_AUTHORIZED' => '您无权限访问此记录。',
    'LBL_MOBILE_PROCESSING_FILE' => '文件在准备中...',
    'LNK_THIRD_PARTY_SOFTWARE' => '第三方软件',
    'LNK_TERMS_OF_USE' => '使用条件',
    'LNK_PRIVACY_POLICY' => '隐私政策',
    'LBL_EXTERNAL_LOGIN_BUTTON_TITLE' => '单一签入',
    'LBL_RECENTS' => '最近',
    'LBL_SHOWING_CACHED_DATA' => '无法访问服务器。显示最新的可用数据 ({{lastFetched}})',
    'LBL_CLOSE_AND_SAVE_BUTTON' => '关闭 {{moduleSingular}} 并保存',
    'LBL_MOBILE_SPECIFIC_DASHBOARD' => '特定仪表板',
    'LBL_MOBILE_SPECIFIC_MODULE' => '特定模块',
    'LBL_MOBILE_DEFAULT_VIEW' => '开始屏幕',
    'LBL_MOBILE_DEFAULT_MODULE' => '已选模块',
    'LBL_MOBILE_DEFAULT_DASHBOARD' => '已选仪表板',
    'LBL_MOBILE_DEFAULT_DASHLET' => '已选仪表盘',
    'LBL_ALL_DASHLETS' => '所有仪表盘',
    'LBL_MOBILE_GLOBAL_SEARCH' => '全局搜索',
    'LBL_MOBILE_ACTIVITYSTREAM_POST_PLACEHOLDER' => '如要提及用户，请键入 @。如要参考记录，请键入 #。',
    'LBL_MOBILE_NEW_COMMENT' => '新评论',
    'LBL_RECENTLY_VIEWED' => '最近查看的',
    'LBL_FILE_STORED_LOCALLY' => '文件存储在本地存储中，在设备联网后将立即同步。',
    'LBL_IDM_USER_PROFILE_READONLY' => '如果您想要更改某些不可编辑的字段，请联系管理员，告知这些更改内容。',
    'LBL_ACTIVITY_POST' => '{{{link}}} 上的 {{{value}}}',
    'LBL_COMMENTLOG_EMPTY' => '无评论',
    'LBL_COMMENTLOG_EXPANDBUTTON_EXPAND' => '显示后 {{{commentsLeft}}} 条评论',
    'LBL_COMMENTLOG_EXPANDBUTTON_COLLAPSE' => '折叠',
    'LBL_COMMENTLOG_CONFIRM_CREATE' => '确认创建评论',
    'LBL_COMMENTLOG_ERROR_IS_EMPTY' => '评论日志不能为空',
    'LBL_MOBILE_PDF_DOWNLOAD' => '下载 {{{pdfTemplateName}}} PDF',

    'ERR_SYNC_FAILED' => '不能同步服务器',
    'ERR_MOBILE_SSO_NOT_CONFIGURED' => 'The Sugar instance at the provided URL is not configured for Single Sign-On. Please turn off Single Sign-On or contact your administrator for assistance.',
    'ERR_MOBILE_NOT_AUTHORIZED' => '访问没有被授权。',
    'ERR_MOBILE_INVALID_CREDS' => '无效的用户名和密码。',
    'ERR_MOBILE_SESSION_EXPIRED' => '您的回话已经过期。',
    'ERR_MOBILE_NOT_FOUND' => '没有找到资源。',
    'ERR_MOBILE_TIMEOUT' => '服务器没有响应。',
    'ERR_MOBILE_CONNECTION_FAILED' => '无法访问服务器。',
    'ERR_MOBILE_NOT_FOUND_LOGIN' => 'No {{{brandName}}} instance found at the provided URL (error {{{code}}}).',
    'ERR_MOBILE_INTERNET_UNAVAILABLE' => '互联网连接不可用。',
    'ERR_MOBILE_INTERNAL' => '网络错误 ({{{code}}}). 请稍后重试.',
    'ERR_MOBILE_VALIDATION' => '无效记录.',
    'ERR_SERVER_FLAVOR_INCOMPATIBLE' => '不兼容的服务器: {{{flavor}}}. Supported flavors: {{{supportedFlavors}}}.',
    'ERR_SERVER_VERSION_INCOMPATIBLE' => '不匹配的服务器版本: {{{version}}}. 最低要求的版本: {{{minVersion}}}.',
    'ERR_MOBILE_EMAIL' => '无效的电子邮件地址。',
    'ERR_MOBILE_FILE_NOT_SUPPORTED' => '不支持这个文档类型。',
    'ERR_MOBILE_BROWSER_NOT_AUTHORIZED' => '授权失败。',
    'ERR_MOBILE_BROWSER_PAGE_NOT_FOUND' => '请求的资源没有找到。',
    'ERR_MOBILE_BROWSER_INTERNAL_SERVER_ERROR' => '互联网服务器错误。',
    'ERR_MOBILE_BROWSER_FORBIDDEN' => '禁止。',
    'ERR_MOBILE_BROWSER_SERVICE_UNAVAILABLE' => '服务不可用。',
    'ERR_MOBILE_GENERIC_NATIVE_ERROR' => '发生一个意外的错误。',
    'ERR_MOBILE_UPLOAD' => '文件上传时出错',
    'ERR_MOBILE_FILE_PROCESSING' => '文件处理时出错',
    'ERR_MOBILE_STORAGE_UNAVAILABLE' => '存储设备不可用',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION' => '您的应用已经过时，不再兼容您正在连接的 {{{brandName}}} 。您希望只应用程序商店下载新版本吗?',
    'ERR_MOBILE_METADATA_CHANGED_RELOAD' => '服务器配置已修改需要重新引导，是否继续？',
    'ERR_MOBILE_CONFLICT' => '服务器上该记录已被其他用户修改，请确认是否使用您的修改来更新该记录或是放弃您的修改？',
    'ERR_MOBILE_METADATA_CHANGED' => '服务器配置已修改。',
    'ERR_MOBILE_FILE_READ' => '读取文件失败',
    'ERR_MOBILE_FILE_NOT_FOUND' => '文件没有找到',
    'ERR_MOBILE_FILE_NOT_READABLE' => '文件不可读',
    'ERR_MOBILE_FILE_ABORTED' => '读操作已取消',
    'ERR_MOBILE_FILE_SECURITY' => '文件已取消',
    'ERR_MOBILE_VIEW_NOT_SUPPORTED' => '手机版不支持此功能。您是否打开桌面版本？',
    'ERR_MOBILE_FILE_SIZE_LIMIT_EXCEEDED' => '文件尺寸太大，最大允许尺寸是 {{size}}',
    'ERR_OFFLINE' => '离线错误',
    'ERR_OFFLINE_STORAGE_UNAVAILABLE' => '打开本地存储出错',
    'ERR_OFFLINE_STORAGE_CREATE' => '创建本地存储失败',
    'ERR_OFFLINE_START_FAILED_OUT_OF_SPACE' => '创建本地存储失败:您本地存储空间不足。',
    'ERR_OFFLINE_OUT_OF_SPACE' => '您的本地存储空间不足。',
    'ERR_OFFLINE_DB_CLEANING_ERROR' => '数据库清理失败',
    'ERR_OFFLINE_CLEAN_UP_CONFIRMATION' => '您的离线存储空间不足。建议进行存储清理。这可能需要几分钟时间。',
    'ERR_OFFLINE_PREFETCH_FAILED' => '从服务器预取数据失败',
    'ERR_OFFLINE_SYNC_ERROR' => '同步错误',
    'ERR_OFFLINE_SYNC_CONFLICT' => '同步冲突',
    'ERR_OFFLINE_SERVERTIME_UNAVAILABLE' => '获取服务器时间失败',
    'ERR_OFFLINE_NO_CONNECTION_ENABLE_ERROR' => '无法启用脱机模式。无法访问服务器。',
    'LBL_EXPORT_CSV' => '导出 CSV',
    'LBL_ERR_EXPORTING_CSV' => '导出失败',
    'LBL_ERR_EXPORT_ALL' => '无法获取所选记录的数据，请重试',
    'LBL_LIST_SETTINGS_RESTORE' => '恢复默认设置',
    'LBL_LIST_SETTINGS_RESTORE_CONFIRM' => '恢复字段？',
    'LBL_LIST_SETTINGS_TITLE' => '列表视图生成器',
    'LBL_LIST_SETTINGS_TEXT_TITLE' => '可用字段',
    'LBL_LIST_SETTINGS_REMOVE' => '删除',
    'LBL_LIST_SETTINGS_TEXT' => '将字段拖到列表视图生成器中并重新排列，以设计 {{moduleName}} 列表视图。',
    'LBL_LIST_SETTINGS_ERROR_EMPTY' => '布局中必须至少添加一个字段。',
    'LBL_LIST_SETTINGS_EMPTY' => '无可用字段',
    'LBL_LIST_SETTINGS_NO_MATCHING' => '找不到匹配字段',
    'LBL_LIST_FILTER' => '字段搜索',
    'LBL_MOBILE_APP_EMAIL_CLIENT' => '电子邮件客户端',
    'LBL_DEFAULT_SYSTEM_CLIENT' => '外部电子邮件客户端',
    'LBL_SUGAR_MOBILE_CLIENT' => 'Sugar 电子邮件客户端',
    'LBL_OFFLINE_CAPABILITIES' => '启用离线功能',
    'LBL_OFFLINE_TRANSACTION_DELETE_ERROR' => '交易删除失败。',
    'LBL_OFFLINE_TRANSACTION_DELETED' => '交易已删除。',
    'LBL_SECURE_MODE' => '增强安全模式',
    'LBL_SECURE_MODE_ANDROID_TEXT' => '启用此设置可在应用程序处于后台时隐藏 Sugar Mobile 的内容，并随时阻止应用程序的屏幕截图。',
    'LBL_SECURE_MODE_IOS_TEXT' => '启用此设置可在应用程序处于后台时隐藏 Sugar Mobile 的内容。',
    'LBL_ALWAYS_OFFLINE_MODE' => '始终离线模式',
    'LBL_ALWAYS_OFFLINE_MODE_ENABLED_PROMPT' => '您正在始终离线模式下工作。您要重新连接吗？',
    'LBL_RECONNECT' => '重新连接',
    'LBL_STAY_OFFLINE' => '保持离线',
    'ERR_MOBILE_MODULE_NOT_SUPPORTED' => '您尝试访问的模块在 Sugar Mobile 上不可用。',
    'LBL_MOBILE_RELEASE_NOTE' => 'Sugar Mobile {{platform}} 发行说明',
    'LBL_MOBILE_USER_GUIDE' => 'Sugar Mobile {{platform}} 用户指南',
    'LBL_OPERATOR_CONTAINING_THESE_WORDS' => '包含这些词语',
    'LBL_OPERATOR_EXCLUDING_THESE_WORDS' => '不包含这些词语',
    'LBL_NOTIFICATIONS_CHANNEL' => '更新',
    'LBL_APPLY_BUTTON_LABEL' => '应用',
    'LBL_ACTION_CREATE_FAILURE' => "无法保存记录：\n {{{reason}}}",
    'LBL_ACTION_UPDATE_FAILURE' => "无法更新记录：\n {{{reason}}}",
    'LBL_ACTION_FIELD_CALC_ERROR' => '无法解析服务器上的字段计算。',
    'LBL_ACTION_MODEL_VALIDATION_ERROR' => '以下字段无效：{{{fields}}}。',
    'LBL_ACTION_CREATE_RECORD_SUCCESS' => '<b>成功。</b> 您已成功创建 {{{module}}} <a href="#{{{recordUrl}}}">"{{{recordName}}}"。</a>',
    'LBL_ACTION_UPDATE_SUCCESS' => '<b>成功。</b> 您已成功更新记录',
    'LBL_ACTION_COMPOSE_FAILED_DATA_FETCH' => '无法从服务器获取电子邮件数据。',
    'LBL_ASSIGN_SUCCESS' => '<b>成功。</b> 记录已分配给 {{{userName}}}',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_TITLE' => '将此电子邮件保存为草稿？',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CONFIRM' => '保存为草稿',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_CANCEL' => '丢弃电子邮件',
    'LBL_MOBILE_EMAIL_SAVE_DRAFT_MSG' => '如果不保存草稿，您将丢失此电子邮件。',
    'LBL_MOBILE_EMAIL_CHOOSE_SIGNATURE' => '选择签名',
    'LBL_MOBILE_EMAIL_CHOOSE_TEMPLATE' => '选择电子邮件模板',
    'LBL_MOBILE_EMAIL_CONFIRM_TEMPLATE' => '模板将覆盖此电子邮件中的所有内容。您确定要使用此模板并覆盖内容吗？',
    'LBL_MOBILE_EMAIL_COMPOSE' => '撰写电子邮件',
    'LBL_MOBILE_EMAIL_NO_RELATED_TO_WITH_TEMPLATE_SEND_ANYWAYS' => '您的电子邮件中包含的变量将使用相关收件人记录中的值进行替换。发送前请确认相关收件人字段设置正确。',
    'LBL_ERR_NO_OUTBOUND_ACCOUNTS_AVAILABLE' => '找不到输出电子邮件帐户。请联系您的 Sugar 管理员。',
    'LBL_EMAIL_MORE_RECIPIENTS' => ' 以及 {{{count}}} 更多',
    'LBL_RECEPIENTS_EMAIL_ADD' => '添加电子邮件',
    'LBL_EMAIL_RECIPIENTS_EMPTY_HINT' => '键入联系人姓名或电子邮件',
    'LBL_EMAIL_RECIPIENT_NEW_EMAIL' => '{{{email}}}（新电子邮件）',
    'LBL_TEMPLATE_HAS_VARIABLES' => '变量',
    'LBL_FILTER_EMAIL_TYPE_TEMPLATES' => '电子邮件模板',
    'LBL_FILTER_CAMPAIGN_TYPE_TEMPLATES' => '市场活动模板',
    'LBL_FILTER_WORKFLOW_TYPE_TEMPLATES' => '工作流模板',
    'LBL_FILTER_SYSTEM_TYPE_TEMPLATES' => '系统模板',
    'LBL_FILTER_EDIT' => '编辑筛选器',
    'LBL_FILTER_MY_FILTER' => '我的筛选器',
    'LBL_FILTER_MY_FILTER_BY' => '我的筛选器 {{{filters}}}',
    'LBL_FILTER_SAVE' => '保存筛选器',
    'LBL_SELECT_PARAM' => '选择',
    'LBL_SELECT_MODULES' => '模块选择器',
    'LBL_SELECT_ADDITIONAL_PARAMS' => '选择其他参数',
    'LBL_FILTER_TEMPORARY' => '临时筛选器',
    'LBL_ERROR_FILE_UPLOAD' => '无法上传 {{{fieldLabel}}} 文件”{{{fileName}}}". {{{reason}}}',
    'LBL_ERROR_EDIT_FAILED_UPLOAD' => '<br/><a href="#{{{recordUrl}}}">查看失败记录</a>',
    'LBL_FILE_UPLOAD_ONE' => '正在保存规则......',
    'LBL_FILE_UPLOAD_MANY' => '正在保存文件 {{{index}}}，共 {{{total}}}......',
    'LNK_NOTIFICATIONS_SETTINGS' => '通知设置',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS' => '管理推送通知',
    'LBL_PUSH_NOTIFICATIONS_SETTINGS_FOOTER' => "使用设备的通知设置控制通知的显示方式。",
    'LBL_NOTIFICATION_ASSIGMENTS' => '分配',
    'LBL_NOTIFICATION_ASSIGMENTS_DSC' => '当有记录指派给您的时候，接收通知。',
    'LBL_NOTIFICATION_MENTIONS' => '提及',
    'LBL_NOTIFICATION_MENTIONS_DSC' => '在评论日志条目中提及您时接收通知。',
    'LBL_NOTIFICATIONS_COMMENTLOG_MISSING' => '管理员尚未将评论日志字段添加到此布局中。请联系您的 Sugar 管理员。',
    'ERR_NO_PERMISSION_TITLE' => '请允许访问',
    'ERR_NO_CAMERA_PERMISSION_MSG' => '{{{brandName}}} 需要相机访问权限，以便您可以附加照片。请在系统设置中允许相机访问。',
    'LBL_MOBILE_SYSTEM_SETTINGS' => '设置',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_DURATION' => '持续时间',
    'LBL_ACTIVE_SUBSCRIPTIONS_FIELD_TIMEREMAINING' => '剩余时间',
    'LBL_LIST_SUPPORT_EXPIRES' => '有效期',
    'LBL_CASCADE_RLI_EDIT' => '更新未结算收入单项',
    'LBL_MOBILE_CALENDAR' => '日程',
    'LBL_MOBILE_CALENDAR_SETTINGS' => '日程设置',
    'LBL_MOBILE_CALENDAR_WEEK_START' => '周开始日',
    'LBL_MOBILE_CALENDAR_MODULES' => '要显示的事件',
    'LBL_MOBILE_CALENDAR_DURATION_HR_MIN' => '{{{hours}}} 小时：{{{minutes}}} 分钟',
    'LBL_MOBILE_CALENDAR_DURATION_HR' => '{{{hours}}} 小时',
    'LBL_MOBILE_CALENDAR_DURATION_MIN' => '{{{minutes}}} 分钟',
    'LBL_MOBILE_CALENDAR_TODAY' => '今天',
    'LBL_MOBILE_CALENDAR_CREATE_MSG' => '添加 {{{moduleName}}}',
    'LBL_MOBILE_CALENDAR_CREATE_TITLE' => '安排活动',
    'LBL_MOBILE_CALENDAR_ERROR_NO_MODULE' => '请至少启用一种事件类型。',
    'LBL_MOBILE_CALENDAR_EVENT_ALL_DAY' => '全天',
    'LBL_MOBILE_CALENDAR_INITIALIZATION_ERROR' => '无法加载日程。',
    'LBL_ACTIONBUTTON_NOT_SUPPORTED_ACTION' => '此操作在 Sugar Mobile 中不可用。您要改为打开桌面应用程序吗？',
    'LBL_DOC_MERGES_SELECT_TEMPLATE' => '选择模板',
    'LBL_DOC_MERGES_ACTION_MERGE' => '合并',
    'LBL_ERROR_IMAGE_NO_EXIF' => '错误：HEIC 文件中缺少 EXIF 数据',
    'LBL_ERROR_IMAGE_TOO_BIG' => '错误：图像分辨率过高',
    'LBL_ERROR_IMAGE_CANNOT_PROCESS' => '错误：无法处理图像',
    'LBL_ERROR_IMAGE_CANVAS_FAILED' => '错误：无法将图像渲染到画布',
    'LBL_ERROR_IMAGE_LOAD_FAILED' => '错误：无法将文件加载为图像',
    'LBL_ACTIONS_SELECTION_COUNT_SINGLE' => '已选择 1 项',
    'LBL_ACTIONS_SELECTION_COUNT_MULTIPLE' => '已选择 {{{count}}} 个项目',
    'LBL_ACTIONS_SELECT_ALL_TITLE' => '选择全部',
    'LBL_ACTIONS_SELECT_ALL_HEADER' => '您已在此视图中选择 {{{count}}} 条记录。选择所有记录？',
    'LBL_ACTIONS_SELECT_ALL_VISIBLE' => '选择 {{{count}}} 条记录',
    'LBL_ACTIONS_SELECT_DELETE_CONFIRM' => '您确定要删除所选择的记录吗?',
    'LBL_ACTIONS_MASS_DELETE_PROGRESS' => '正在删除 {{{total}}} 条记录中 {{{count}}} 条',
    'LBL_ACTIONS_MASS_EMAIL_EMPTY' => '在所选记录中找不到有效的电子邮件',

    // Dark mode related
    'LBL_MOBILE_APP_THEME' => '外观',
    'LBL_MOBILE_APP_THEME_SYSTEM' => '使用系统设置',
    'LBL_MOBILE_APP_THEME_LIGHT' => '浅色',
    'LBL_MOBILE_APP_THEME_DARK' => '深色',
    // Attachments related
    'LBL_ATTACHMENT_RENAME_TITLE' => '新文件名',
    'LBL_ATTACHMENT_RENAME_MSG' => '重命名文件',
    // Filters related
    'LBL_CREATED_BY_ME' => '由我创建',
    'LBL_OPERATOR_ONE_OF' => '是其中之一',
    'LBL_OPERATOR_NOT_ONE_OF' => '不是其中之一',
    'LBL_OPERATOR_CONTAINS' => '其中的',
    'LBL_OPERATOR_CONTAINS_WORD' => '包含',
    'LBL_OPERATOR_NOT_CONTAINS' => '不是其中的',
    'LBL_OPERATOR_EMPTY' => '为空',
    'LBL_OPERATOR_NOT_EMPTY' => '不为空',
    'LBL_OPERATOR_MATCHES' => '完全符合',
    'LBL_OPERATOR_STARTS_WITH' => '开始于',
    'LBL_OPERATOR_EQUALS' => '等于',
    'LBL_OPERATOR_NOT_EQUALS' => '不等于',
    'LBL_OPERATOR_GREATER_THAN' => '大于',
    'LBL_OPERATOR_LESS_THAN' => '小于',
    'LBL_OPERATOR_GREATER_THAN_OR_EQUALS' => '大于或等于',
    'LBL_OPERATOR_LESS_THAN_OR_EQUALS' => '小于或等于',
    'LBL_OPERATOR_BETWEEN' => '之间',
    'LBL_OPERATOR_BEFORE' => '早于',
    'LBL_OPERATOR_AFTER' => '晚于',
    'LBL_OPERATOR_YESTERDAY' => '昨天',
    'LBL_OPERATOR_TODAY' => '今天',
    'LBL_OPERATOR_TOMORROW' => '明天',
    'LBL_OPERATOR_LAST_7_DAYS' => '最近 7 天',
    'LBL_OPERATOR_NEXT_7_DAYS' => '未来 7 天',
    'LBL_OPERATOR_LAST_30_DAYS' => '最近 30 天',
    'LBL_OPERATOR_NEXT_30_DAYS' => '未来 30 天',
    'LBL_OPERATOR_MORE_X_DAYS_AGO' => '超过__天前',
    'LBL_OPERATOR_LAST_X_DAYS' => '最近 __ 天',
    'LBL_OPERATOR_NEXT_X_DAYS' => '接下来 __ 天',
    'LBL_OPERATOR_MORE_X_DAYS_AHEAD' => '未来超过 __ 天',
    'LBL_OPERATOR_LAST_MONTH' => '上个月',
    'LBL_OPERATOR_THIS_MONTH' => '本月',
    'LBL_OPERATOR_NEXT_MONTH' => '下个月',
    'LBL_OPERATOR_LAST_YEAR' => '去年',
    'LBL_OPERATOR_THIS_YEAR' => '今年',
    'LBL_OPERATOR_NEXT_YEAR' => '下一年',
    'LBL_OPERATOR_IS' => '是',
    'LBL_OPERATOR_IS_NOT' => '不是',
    'LBL_OPERATOR_AFTER_TODAY' => '今天之后',
    'LBL_OPERATOR_BEFORE_TODAY' => '今天之前',
    'LBL_ERROR_FILTER_EMPTY' => '请添加筛选器条件。',
    'LBL_ADD_FILTER' => '添加条件',
    'LBL_FILTER_NAME' => '筛选器名称',
    'LBL_FILTER_FIELD' => '字段',
    'LBL_FILTER_OPERATOR' => '运算符',
    'LBL_FILTER_VALUE' => '值',
    'LBL_FILTER_SYNC_TO_SERVER' => '保存至桌面应用',
    'LBL_FILTER_LOCAL' => '本地筛选器',

    // Nomad Tutorial
    'LBL_MOBILE_TUTORIAL_HOME_INTRO' => '欢迎来到 {{{brandName}}}。<br/> <br/>让我们着重介绍一些新的功能......',
    'LBL_MOBILE_TUTORIAL_HOME_LOGO' => '主导航菜单。',
    'LBL_MOBILE_TUTORIAL_HOME_CREATE' => '可用操作/视图。',
    'LBL_MOBILE_TUTORIAL_HOME_SEARCH' => '全局搜索记录。',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_BTN' => '筛选列表来显示我收藏的记录',
    'LBL_MOBILE_TUTORIAL_HOME_MY_ITEMS_BTN' => '筛选列表显示分配给我的记录。',
    'LBL_MOBILE_TUTORIAL_HOME_FAVORITES_ICON' => '标记为收藏',
    'LBL_MOBILE_TUTORIAL_HOME_UPCOMING' => '我今天开始即将开始的事件。',
    'LBL_MOBILE_TUTORIAL_HOME_RECENT' => '最近修改的记录。',
    'LBL_MOBILE_TUTORIAL_HOME_GRIP' => '在记录上执行可用操作。',
    'LBL_MOBILE_TUTORIAL_HOME_END' => '享受所有的新功能！',

    'LBL_MOBILE_TUTORIAL_PLUS_MENU_INTRO' => '这是plus菜单。',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_CREATE' => '关闭plus菜单。',
    'LBL_MOBILE_TUTORIAL_PLUS_MENU_ACTIONS' => '选择指定的操作来查看执行。',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO' => '这是首页菜单。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_LOGO' => '关闭首页菜单。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_MODULES' => '查看指定模块。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_SETTINGS' => '定制应用程序。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_DESKTOP' => '在浏览器中打开Sugar',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_PROFILE' => '查看你的个人资料。',

    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO' => '这是详细页。',
    'LBL_MOBILE_TUTORIAL_DETAIL_CARD' => '最重要的信息记录。',
    'LBL_MOBILE_TUTORIAL_DETAIL_RIGHT_ACTION' => '查看其他信息或编辑一条记录。',
    'LBL_MOBILE_TUTORIAL_DETAIL_RECORD_ACTIONS' => '记录上的可用操作。',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK' => '去上一个页面。',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_TOUR' => '随时访问浏览介绍。',
    'LBL_MOBILE_TUTORIAL_DETAIL_BACK_TABLET' => '返回。',
    'LBL_MOBILE_TUTORIAL_DETAIL_RELATE_LINK' => '单击即可打开相关记录。',
    'LBL_MOBILE_TUTORIAL_DETAIL_FOLLOW' => '跟踪/停止跟踪记录。',
    'LBL_MOBILE_TUTORIAL_DETAIL_SHOW_MORE' => '单击即可扩展详细信息。',

    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TITLE' => '主菜单视图。',
    'LBL_MOBILE_TUTORIAL_HOME_MENU_INTRO_TEXT' => '主菜单在您的屏幕左侧打开。',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TITLE' => '细节视图',
    'LBL_MOBILE_TUTORIAL_DETAIL_INTRO_TEXT' => '细节视图在您的屏幕右侧打开。',
    'LBL_MOBILE_TUTORIAL_CONTROL_PANEL' => '使用以下箭头浏览此菜单各关键内容。',

    'LBL_COMMENT_ADD' => '添加注释',
    'LBL_REQUIRED' => '必填',
    'LBL_MORE_BUTTON' => '更多',
    'LBL_NO_OPTIONS' => '无可用选项',
    'LBL_TRY_AGAIN' => '重试',
    'LBL_NEW_RECORDS' => '最近创建的',
    'LBL_ASSIGNED_TO_ME' => '我的 {{{module}}}',
    'LBL_LISTVIEW_FILTER_ALL' => '所有 {{{module}}}',
    'LBL_UNFAVORITE' => '未收藏',
    'LBL_ACTIVITY_CREATE' => '已创建 {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UPDATE' => '已在 {{{record}}} {{{module}}} 上更新 {{{changes}}}',
    'LBL_ACTIVITY_LINK' => '已将 {{{relatedRecord}}} 链接至 {{{record}}} {{{module}}}',
    'LBL_ACTIVITY_UNLINK' => '已从 {{{record}}} {{{module}}} 取消 {{{relatedRecord}}} 的链接',
    'LBL_OFFLINE_PREFETCHING_RELATIONSHIP' => '{{parentModule}} 的 {{relationship}}',
    'LBL_OFFLINE_PREFETCH_RELATED_ACTION' => '下载相关记录…',
    'LBL_DASHBOARDS_CHANGED_PROMPT' => '您的仪表板配置已更改。是否要重新加载？',
    'LBL_RECORDS' => '记录',
    'LBL_DASHBOARDS' => '仪表板',
    'LBL_TEMPLATES' => '模板',
    'LBL_NON_TEMPLATES' => '非模板',
    'LBL_IS_TEMPLATE' => '是模板',
    'LBL_UNSELECT_UPDATE_TEMPLATES' => '您的选择包含无法批量更新的仪表板模板。请取消选择模板以继续。',
    'LBL_UNSELECT_DELETE_TEMPLATES' => '您的选择包含无法批量删除的仪表板模板。请取消选择模板以继续。',
    'LBL_MOBILE_SEARCH_PLACEHOLDER' => '搜索 {{searchCriteria}}…',

    'LBL_MOBILE_TUTORIAL_HOME_MENU' => '主菜单',
    'LBL_MOBILE_TUTORIAL_HOME_PLUS' => '快速创建新记录',
    'LBL_MOBILE_TUTORIAL_HOME_SWIPE' => '轻扫以查看更多选项',
    'LBL_DETAILS' => '详细信息',
    'LBL_DETAIL_RELATED' => '相关',
    'LBL_CREATE_RELATED_MODULE_WARN' => '此 {{module}} 需要一个 {{relatedModule}}。<a class=&#39;alert-link&#39; href=&#39;{{{createLink}}}&#39;>创建一个 {{relatedModule}} 
记录</a>。',
    'LBL_MOBILE_TUTORIAL_DETAIL_EDIT_ACTION' => '编辑记录',
    'LBL_OFFLINE_MENU_SETTINGS' => '离线设置',
    'LBL_OFFLINE_DEBUG_SETTINGS' => '调试设置',
    'LBL_OFFLINE_TOTAL_RECORDS' => '记录总数',
    'LBL_OFFLINE_LAST_DOWNLOAD' => '上次下载',
    'ERR_MOBILE_FILE_DOWNLOAD_FAILED' => '无法下载文件。',
    'ERR_MOBILE_DASHBOARDS_FETCHING' => '从服务器加载仪表板失败',
    'ERR_FILTERS_FETCHING' => '无法获取筛选器',
    'ERR_OFFLINE_ENCRYPTION_FAILED' => '加密本地存储失败',
    'LBL_OFFLINE_ENCRYPTION_IN_PROGRESS' => '正在加密离线数据。这可能需要几分钟。',
    'LBL_OFFLINE_ENCRYPTION_SUCCESS' => '离线数据加密完成。',
    'ERR_ACCESS_SPECIFIC_MODULE' => '您没有访问 {{{module}}} 模块的权限。',
    'LBL_SKIP' => '跳过',
    'LBL_CONTINUE' => '继续',
    'LBL_ENABLE' => '启用',
    'LBL_MOBILE_TRIAL_UNTIL' => '试用有效期至',
    'LBL_MOBILE_SDK_VERSION' => 'SDK 版本',
    'LBL_LOG_LEVEL' => '日志级别',
    'LBL_RECONFIGURE_LOGIN_SETTINGS_CONFIRM' => '已重新配置登录设置。',
    'LBL_TRIAL_PERIOD_EXPIRED' => '您的试用期已过。',
    'ERR_MOBILE_HTTPS_CONNECTION_FAILED_LOGIN' => '服务器不支持安全连接。请关闭安全连接。',
    'ERR_MOBILE_HTTP_CONNECTION_FAILED_LOGIN' => '服务器支持安全连接。请打开安全连接。',
    'ERR_MOBILE_HTTP_CONNECTION_USE_MSG' => '您的连接不安全。请联系管理员。',
    'LBL_LOGIN_SETTINGS_HEADER' => '登录设置',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_TITLE' => '设置您的 {{{brandName}}} 实例',
    'LBL_LOGIN_SETTINGS_INSTANCE_SETUP_DESC' => '为了确保应用程序正常工作，您需要输入 {{{brandName}}} 实例的 URL。如果您没有实例 URL，请联系管理员。',
    'LBL_FACEID' => 'Face ID',
    'LBL_TOUCHID' => 'Touch ID',
    'LBL_ENABLE_TOUCHID' => '启用 {{{biometryType}}}',
    'LBL_SETUP_TOUCHID' => '设置 {{{biometryType}}}',
    'LBL_TOUCH_ID_AUTHENTICATE_SUBTITLE' => '使用指纹登录',
    'LBL_TOUCH_ID_NOT_ENROLLED_MSG' => "未在设备上设置 {{{biometryType}}}。

请在设备设置中设置 {{{biometryType}}}。设置后，在“主菜单” > “设置”中为 {{{brandName}}} 启用
 {{{biometryType}}}。",
    'LBL_TOUCH_ID_DISCLAIMER' => '在 {{{brandName}}} 上使用 {{{biometryType}}} 将允许您使用生物识别符访问 {{{brandName}}}，而不是输入密码。',
    'LBL_TOUCH_ID_ENABLE_CONFIRM_MSG' => '您是否要继续使用 {{{biometryType}}}？    ',
    'LBL_TOUCH_ID_ENTER_PASSWORD_TITLE' => '输入 {{{brandName}}} 密码以启用 {{{biometryType}}}',
    'LBL_SETUPBUDDY_HEADER_TITLE' => '设置',
    'LBL_MDM_CONFIRM_CHANGE' => '已通过移动设备管理器更改应用程序配置。请重新登录以应用更改。',
    'ERR_GEOLOCATION_PERMISSION_DENIED' => '请通过设备设置为 {{{brandName}}} 授予访问您所在位置的权限。',
    'ERR_GEOLOCATION_POSITION_UNAVAILABLE_MSG' => '当前位置不可用',
    'ERR_GEOLOCATION_POSITION_TIMEOUT_MSG' => "当前位置检索超时。\n请重试。",
    'ERR_GEOLOCATION_PLACEMARKS_UNAVAILABLE_MSG' => '位置地标不可用',
    'ERR_GEOLOCATION_INVALID_COORDINATES_MSG' => '位置坐标无效',
    'ERR_MOBILE_INVALID_PASSWORD' => '密码无效。',
    'ERR_MOBILE_INCOMPATIBLE_CLIENT_VERSION_UPDATE' => '您的应用已经过时，不再兼容您正在连接的 {{{brandName}}} 实例。您是否要更新？',
    'LBL_MOBILE_BY' => '通过',
    'LBL_MOBILE_FILTER_IS_NOT_AVAILABLE' => '筛选器无法离线使用',
    'LBL_BULK_LOAD_OFFLINE_RECORDS' => '离线记录',
    'LBL_BULK_LOAD_DOWNLOAD_SETTINGS' => '下载设置',
    'LBL_BULK_LOAD_PREFETCH_MESSAGE' => '下载已分配、已收藏和已关注的记录以便离线访问。您可以在离线设置中更新首选项。',
    'LBL_BULK_LOAD_COMPLETED_MESSAGE' => '您的记录已完成下载。现在，您可以在离线模式下访问它们。',
    'LBL_BULK_LOAD_ERROR_CONFIRM' => "未下载完所有记录。\n是否要重试？",
    'LBL_BULK_LOAD_USE_CELLULAR' => '使用蜂窝数据',
    'LBL_BULK_LOAD_NOT_RIGHT_NOW' => '现在不',
    'LBL_BULK_LOAD_PAUSED_MESSAGE' => '已暂停下载，您再次打开应用程序时会继续下载。',
    'LBL_BULK_LOAD_STATUS_DOWNLOADING' => '正在下载 {{{module}}}：{{count}}',
    'LBL_BULK_LOAD_STATUS_IDLE' => '更新最新记录',
    'LBL_BULK_LOAD_STATUS_WAITING_FOR_CONNECTION' => '正在等待连接',
    'LBL_BULK_LOAD_STATUS_PAUSED' => '已暂停',
    'LBL_BULK_LOAD_STATUS_STOPPING' => '正在停止',
    'LBL_BULK_LOAD_BTN_DOWNLOAD' => '下载',
    'LBL_BULK_LOAD_BTN_PAUSE' => '暂停',
    'LBL_BULK_LOAD_BTN_RESUME' => '继续',
    'LBL_BULK_LOAD_CONNECTION_USE_MESSAGE' => '默认只使用 WiFi 连接',
    'LBL_NPS_RATING_MSG' => "您将如何评价 \n{{{productName}}} 的使用体验？",
    'LBL_NPS_THANKS_MSG' => '感谢反馈！',
    'LBL_NPS_APPSTORE_RATE_MSG' => '您是否愿意在 App Store 上对它进行评价？',
    'LBL_NPS_NO_THANKS' => '不，谢谢',
    'LBL_NPS_NOT_NOW' => '现在不要',
    'LBL_NPS_RATE_NOW' => '立即评价',
    'WARN_MOBILE_INTERNET_UNAVAILABLE' => '网络不可用。您仍然可以离线使用应用程序',
    'WARN_MOBILE_INTERNET_UNAVAILABLE_AND_UNSYNCED_TRANSACTIONS' => '当您上线后，您所做的更改将会同步。<a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>请参见详细说明</a>',
    'ERR_MOBILE_INTERNET_UNAVAILABLE_AND_TRANSACTION_ERRORS' => '有未同步的数据。请查看<a class=&#39;alert-link&#39; href=&#39;{{{link}}}&#39;>传输日志</a>',
    'LBL_CONVERT' => '转换',
    'LBL_CONVERT_LEAD' => '转换潜在客户',
    'LBL_SEARCH_EXISTING_RECORD' => '搜索现有的 {{{this}}}',
    'LBL_DUPLICATES_CHECK_FAILED' => '重复项检查失败',
    'LBL_MOVE_RELATED_ACTIVITIES_PROMPT' => '是否要将相关活动移动到联系人记录？',
    'LBL_LEAD_CONVERSION_SUCCESS' => '您成功转换了潜在客户 {{{name}}}',
    'LBL_MOBILE_NO_DUPLICATES_FOUND' => '未找到任何重复项。',
    'ERR_LEAD_CONVERSION_FAIL' => '潜在客户转换失败',
    'LBL_SELECT_DUPLICATE_RECORD' => '从重复项 {{{modulePlural}}} 中选择',
    'LBL_SELECTED_EXISTING_RECORD' => '已选择 {{{moduleSingular}}}',
    'LBL_CREATED_NEW_RECORD' => '已创建新 {{{moduleSingular}}}',
    'LBL_VO_BACK_BTN' => '“返回”按钮',
    'LBL_VO_HOME_BTN' => '“主页”按钮',
    'LBL_VO_DASHBOARD_BTN' => '“仪表板”按钮',
    'LBL_VO_SEARCH_BTN' => '“搜索”按钮',
    'LBL_VO_RIGHT_MENU_BTN' => '右侧菜单按钮',
    'LBL_VO_ADD_BTN' => '“添加”按钮',

    // Sugar Mobile additions for 10.3
    'LBL_DISCOUNT_AMOUNT' => '折扣',
    'LBL_MOBILE_CHOOSE_NAVIGATOR' => '选择映射应用程序',
    'LBL_OVERWRITE_PROCESS_CLAIM_QUESTION' => '选中的 {{entityName}} 具有相关值：{{localizedFieldNames}}。取消以保持现有值。确认以使用新值覆盖。',
    'LBL_OFFLINE_DATA_ENCRYPTION_ENABLED' => '已启用数据加密。',
    'LBL_LEAD_ALREADY_CONVERTED' => '所选线索已转化。',
    'LBL_OPERATION_NOT_AVAILABLE_OFFLINE' => '此操作仅当设备联网时可用',
    'LBL_QUOTES_GENERATE_OPPORTUNITY' => '您确定要从报价创建商业机会吗？',
    'LBL_TAG_ADD' => '添加标签',
    'LBL_TAG_ENTER_TAG_NAME' => '输入标签',
    'LBL_TAG_OFFLINE_READ_NOT_SUPPORTED' => '当设备离线时，不支持按标签筛选。',
    'LBL_COMMENTLOG_SHOWCOMMENT' => '显示完整评论',
    'LBL_COMMENT_VIEW' => '查看评论',
    'LBL_PMSE_LABEL_DUEDATE' => '到期日期',
    'LBL_PMSE_DUE' => '到期',
    'LBL_PMSE_DUE_ON' => '到期日期',
    'LBL_LEAD_CONVERSION_PARENT_RECORD_REQUIRED' => '请先创建 {{conversionParentModuleName}}',
    'LBL_LEAD_CONVERSION_MISSING_REQUIRED' => '缺少必要的记录：{{{missingRecords}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_HINT' => '选择图像质量。在保存至服务器前，将对图像大小进行相应的调整。所选值将在未来用作所有相似操作的默认值。',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATING' => '正在估计文件大小...',
    'LBL_IMAGE_QUALITY_SELECTOR_CALCULATED' => '估计文件大小为',
    'LBL_IMAGE_QUALITY_SELECTOR_HEADER' => '图像质量',
    'LBL_IMAGE_QUALITY_BEST' => '原始大小',
    'LBL_IMAGE_QUALITY_GOOD' => '高品质',
    'LBL_IMAGE_QUALITY_POOR' => '小尺寸',
    'LBL_IMAGE_QUALITY_BTN' => '压缩：{{{rate}}}',
    'LBL_LIST_CONFIGURABLE_HEADER' => '在 {{module}} 上列出字段',
    'LBL_LIST_RESET_FIELDS' => '重设为默认值',
    'LBL_LIST_NOT_ENOUGH' => '请设置至少 1 个活动字段。',
    'LBL_LOGIN_PERMISSION_ABORTED' => '您需要登录并接受权限才能使用 SugarCRM 实例。',
    'LBL_SELECTING_EXISTING_RECORD' => '正在选择 {{{moduleSingular}}}',
    'LBL_CREATING_NEW_RECORD' => '正在创建新 {{{moduleSingular}}}',
    'LBL_IMAGE_QUALITY_SELECTOR_LABEL' => '图像大小',
    'LBL_COPY_ADDRESS' => '复制地址',
    'LBL_OPEN_IN' => '打开位置',
    'LBL_MULTIATTACHMENTS_NO_FILE_SELECTED' => '未选择文件。',
    'LBL_ATTACHMENT_ADD' => '附加',

    // Mobile cookie consent
    'LBL_USE_COOKIES_CONFIRM_TITLE' => '此应用程式使用 cookies',
    'LBL_USE_COOKIES_CONFIRM' => '此应用程式使用 cookies 来帮助为您提供更好的体验。如果继续，则表明您同意我们根据隐私政策使用 cookies。',

    // Mobile warnings
    'WARN_SERVER_OUTDATED' => '您正在使用在即将发布的移动版本中与 Sugar Mobile 不兼容的 Sugar 实例。 请要求您的管理员尽快升级 Sugar。',
    'ERROR_TAG_NAME_INVALID' => '标签名称不能包含 "{{{forbiddenChars}}}" 字符',
    'ERROR_NO_TAGS_FOUND' => '没有与 "{{{searchQuery}}}" 匹配的标签',
    'ERR_PA_RECORD_INVALID' => '{{{moduleName}}} 记录具有一个或多个无效值，无法保存。是否想要编辑记录以执行 {{{actionLabel}}} 操作？',
    'ERR_MOBILE_METADATA_RELOAD' => '一位管理员在您的 Sugar 实例中进行了配置更改。按一下“确定”以将应用程序的配置与服务器同步。',

    // Cookie consent
    'LBL_WIZ_USER_COOKIE_CONSENT' => '此应用程式使用 cookies',
    'LBL_USER_CLICK_FOR_COOKIE_CONSENT' => '选中以接受（必选）',
    'LBL_USER_COOKIE_CONSENT_TEXT' => '此应用程式使用 cookies 来帮助为您提供更好的体验。如果继续，则表明您同意我们根据<a href="{{href}}" target="_blank">隐私政策</a>使用 cookies。',

    //begin portal

    //portal record tutorial
    'LBL_PORTAL_TOUR_RECORD_DETAILS' => '记录视图允许您查看记录的详细信息。',
    'LBL_PORTAL_TOUR_RECORD_NOTES' => 'Notes 能让您与其他门户用户和支持代表合作。',
    'LBL_PORTAL_TOUR_RECORD_ADD_NOTE' => '点击此处，添加笔记到记录中。',
    'LBL_PORTAL_TOUR_RECORD_VIEW_NOTE' => '点击这些图标来查看附加的注意事项的详细信息。',

    //for portal
    'LBL_PORTAL_HOME' => '首页仪表板',
    'LBL_PORTAL_DASHBOARD_ALL_OPEN_CASES' => '所有待处理的客户反馈',
    'LBL_PORTAL_DASHBOARD_RECENT_CASES' => '最近已解决的客户反馈',
    'LBL_PORTAL_SEARCH' => '搜索按姓名，号码',
    'LBL_SIGNUP_BUTTON_LABEL' => '签约',
    'LBL_PORTAL_NO_EMAIL' => '没有收到电子邮件？',
    'LBL_PORTAL_FORGOT_PASSWORD' => '忘记密码',
    'LBL_PORTAL_FORGOT_USERNAME' => '忘记用户名',
    'LBL_PORTAL_ENTER_PASSWORD_TWICE' => '输入您的密码两次。密码必须相匹配。',
    'LBL_PORTAL_RESET_PASSWORD' => '重设密码',
    'LBL_PORTAL_REENTER_PASSWORD' => '重新输入密码',
    'LBL_PORTAL_PASSWORD_MISMATCH' => '密码不匹配，请再次输入',
    'LBL_PORTAL_PASSWORD_RESET_SUCCESS' => '您的密码已成功重设。',
    'LBL_PORTAL_PASSWORD_RESET_ERR_GENERAL' => '出现错误。请发起新密码重设请求。',
    'LBL_PORTAL_SIGNUP_PROCESS' => '注册',
    'LBL_PORTAL_SIGNUP_TITLE' => '谢谢您注册',
    'LBL_PORTAL_SIGNUP' => '在确认您的详细信息后，我们将通知您。',
    'LBL_PORTAL_SIGNUP_FIRST_NAME' => '名',
    'LBL_PORTAL_SIGNUP_LAST_NAME' => '姓',
    'LBL_PORTAL_SIGNUP_USER_NAME' => '用户名',
    'LBL_PORTAL_SIGNUP_EMAIL' => '电子邮件地址',
    'LBL_PORTAL_SIGNUP_PHONE' => '(###) ###-#### (可选)',
    'LBL_PORTAL_SIGNUP_COUNTRY' => '国家',
    'LBL_PORTAL_SIGNUP_STATE' => '省份',
    'LBL_PORTAL_SIGNUP_COMPANY_NAME' => '公司名称',
    'LBL_PORTAL_SIGNUP_JOBTITLE' => '职位（可选）',
    'LBL_PORTAL_SIGNUP_PASSWORD' => '密码',
    'LBL_PORTAL_SIGNUP_PASSWORD1' => '确认密码',
    'LBL_PORTAL_SIGNUP_FORGOT_LOGIN' => '忘记登录',

    'LNK_PORTAL_LOGIN_FORGOTPASSWORD' => '忘记密码？',
    'LBL_PORTAL_LOGIN_FORGOTPASSWORD' => '请联系您的 Sugar 管理员来重置密码。',
    'LBL_PORTAL_LOGIN_USERNAME' => '用户名',
    'LBL_PORTAL_LOGIN_PASSWORD' => '密码',
    'LBL_PORTAL_LOADING' => '加载中',
    'LBL_PORTAL_SAVING' => '保存中',
    'LBL_PORTAL_PAGE_NOT_AVAIL' => '页面无法访问',
    'LBL_PORTAL_NOT_ENABLED_MSG' => "抱歉，这个目前目前不可用。",
    'LBL_PORTAL_SEARCH_RESULTS_TITLE' => '为 "{query}"显示搜索结果',
    'LBL_PORTAL_DIDNT_GET_EMAIL' => '没有收到电子邮件？',
    'LBL_PORTAL_CONTACT_INFO_CONTACT_US' => '如需协助或需要联系我们，请使用以下任一方式：',
    'LBL_PORTAL_CONTACT_INFO_PHONE' => '电话：',
    'LBL_PORTAL_CONTACT_INFO_EMAIL' => '电子邮件：',
    'LBL_PORTAL_CONTACT_INFO_WEB' => '网络：',
    'LBL_PORTAL_CHAT_RUN_BUTTON_HELLO' => 'Hello there!',
    'LBL_PORTAL_CHAT_RUN_BUTTON_START' => 'Click to start chat',
    'LBL_PORTAL_CHAT_RUN_BUTTON_CONTINUE' => 'Click to open chat',
    'LBL_PORTAL_CHAT_CONFIRMATION_CLOSE' => '您确定想要关闭聊天吗？',

    // Portal timeline view
    'LBL_PORTAL_NEW_NOTE_TITLE' => '新增笔记或添加附件',
    'LBL_PORTAL_NEW_NOTE_BTN' => '添加笔记',

    //for portal errors
    'LBL_PORTAL_LOGIN_UNSUCCESSFUL' => '您的登录不成功。请重试。',
    'LBL_PORTAL_INVALID_CREDS_TITLE' => '无效的认证',
    'LBL_PORTAL_INVALID_GRANT' => '您的会话已过期。请重新登录。',
    'LBL_PORTAL_INVALID_GRANT_TITLE' => '会话已过期',
    'LBL_PORTAL_AUTH_FAILED' => '客户端身份验证失败。',
    'LBL_PORTAL_AUTH_FAILED_TITLE' => '无效的客户端',
    'LBL_PORTAL_INVALID_REQUEST' => '提出请求无效或格式不正确。请联系技术支持。',
    'LBL_PORTAL_INVALID_REQUEST_TITLE' => '无效的请求',
    'LBL_PORTAL_REQUEST_TIMEOUT' => '请求超时。',
    'LBL_PORTAL_REQUEST_TIMEOUT_TITLE' => '请求超时',
    'LBL_PORTAL_UNAUTHORIZED' => '很抱歉，您无权访问该资源。',
    'LBL_PORTAL_UNAUTHORIZED_TITLE' => 'HTTP 错误: 未授权',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE' => '资源不可用。',
    'LBL_PORTAL_RESOURCE_UNAVAILABLE_TITLE' => 'HTTP 错误: 被禁止',
    'LBL_PORTAL_METHOD_NOT_ALLOWED' => '该资源不支持HTTP方法。请联系技术支持。',
    'LBL_PORTAL_METHOD_NOT_ALLOWED_TITLE' => 'HTTP 错误: 不允许的方法',
    'LBL_PORTAL_PRECONDITION_MISSING' => '请求失败，缺少或无效的参数。请联系技术支持',
    'LBL_PORTAL_PRECONDITION_MISSING_TITLE' => '错误：',
    'LBL_PORTAL_MIN_MODULES' => '至少，你可以在应用程序中使用客户反馈，缺陷追踪和知识库模块。',
    'LBL_PORTAL_ERROR' => '错误',
    'LBL_PORTAL_ROUTE_ERROR' => '发行加载模块。请稍后再试，或者联系技术支持。',
    'LBL_PORTAL_OFFLINE' => '很抱歉，此时的应用程序不可用。请与网站管理员联系。',
    'LBL_CONTACT_EDIT_PASSWORD_LNK_TEXT' => '修改密码',
    'LBL_PORTAL_SIGNUP_USER_NAME_ERROR' => '用户名已在此系统中注册。请发起忘记密码请求或选择其他用户名。',
    'LBL_PORTAL_SIGNUP_EMAIL_ERROR' => '所提供的电子邮件无效。',
    'LBL_PORTAL_SIGNUP_PASSWORD_ERROR' => '密码不匹配。',
    //end portal

    // Final name given by marketing is Service Console
    // Original name for this feature was Agent Workbench and was used
    // throughout the development of this product.
    'LBL_AGENT_WORKBENCH' => '服务控制台',
    'LBL_AGENT_WORKBENCH_OVERVIEW' => '概述',
    'LBL_CASE_OVERDUE' => 'Overdue',
    'LBL_CASE_DUE_SOON' => 'Due soon',
    'LBL_CASE_DUE_LATER' => 'Due later',

    'LBL_RESTORE_DASHBOARD_DEFAULT' => '恢复默认仪表板',
    'LBL_UNTITLED' => '无标题',

    // Renewals Console
    'LBL_RENEWALS_CONSOLE' => '续订控制台',
    'LBL_RENEWALS_CONSOLE_OVERVIEW' => '概述',
    'LBL_RENEWALS_CONSOLE_STAGE_STATUS' => '阶段/状态',
    'LBL_RENEWALS_CONSOLE_NAME_ACCOUNT' => '姓名/账户名称',
    'LBL_RENEWALS_CONSOLE_AMOUNT' => 'Worst | Likely | Best',

    // Omnichannel Console
    'LBL_OMNICHANNEL' => 'SugarLive',
    'LBL_OMNICHANNEL_DASHBOARD' => '全渠道仪表板',
    'LBL_OMNICHANNEL_DEFAULT_CUSTOMER_NAME' => '客户',
    'TPL_OMNICHANNEL_NEW_RECORD_TITLE' => '{{type}} {{direction}} {{identifier}} 于 {{time}}',
    'LBL_OMNICHANNEL_UNSUPPORTED_BROWSER' => '您的浏览器不支持 SugarLive。请使用 Google Chrome 或 Mozilla Firefox。',
    'LBL_OMNICHANNEL_RECORD_CREATED' => '已创建 <a href="#{{buildRoute model=this}}">{{moduleSingularLower}}</a>，其中包含您的会话详情。',
    'LBL_OMNICHANNEL_SUBJECT' => '主题',
    'LBL_OMNICHANNEL_DESCRIPTION' => '描述',
    'LBL_OMNICHANNEL_CHAT_SUMMARY' => '信息摘要',
    'LBL_OMNICHANNEL_CALL_SUMMARY' => '通话摘要',
    'LBL_OMNICHANNEL_LINK_TO' => '将 {{fromModule}} 链接到 {{toModule}}',
    'LBL_OMNICHANNEL_LINK_RECORD' => '链接至 {{module}}',
    'LBL_OMNICHANNEL_LINKED' => '已链接',
    'LBL_PORTALCHAT_UNSUPPORTED_BROWSER' => '您的浏览器不支持聊天。请使用 Google Chrome 或 Mozilla Firefox。',
    'LBL_PORTALCHAT_CAN_NOT_LOAD_LIB' => '请联系您的 Sugar 管理员获取帮助。',
    'LBL_OMNICHANNEL_CONFIG_LAYOUT' => '配置布局',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OUTBOUND_CALL' => '请在拨出电话前结束配置 SugarLive。',
    'LBL_OMNICHANNEL_FINISH_CONFIGURING_BEFORE_OPENING_SUGARLIVE' => '请在打开 SugarLive 前结束配置 SugarLive 布局。',
    'LBL_OMNICHANNEL_SET_OFFLINE_BEFORE_CONFIGURING' => '在配置 SugarLive 布局前，在 SugarLive 中将您自己设置为“离线”。',
    'LBL_OMNICHANNEL_COMPACT_VIEW' => '紧凑视图',
    'LBL_OMNICHANNEL_FULL_VIEW' => '完整视图',

    //14.0 Dashboards
    'LBL_BDR_CONSOLE' => 'BDR 仪表板',
    'LBL_SALES_MANAGER_CONSOLE' => '销售经理仪表板',
    'LBL_SALES_REP_CONSOLE' => '销售代表仪表板',
    'LBL_MARKETING_CONSOLE' => '营销仪表板',
    'LBL_CUSTOMER_SUCCESS_CONSOLE' => '客户成功仪表板',
    'LBL_EXECUTIVE_CONSOLE' => '主管仪表板',

    // Omnichannel Console Config
    'LBL_RESTORE_TAB_DEFAULT' => '将选项卡恢复为默认',
    'LBL_CONFIGURE_SUMMARY_PANEL' => '配置摘要面板',

    //First time login wizard
    'LBL_WIZ_USER_PROFILE_TITLE' => '用户配置文件',
    'LBL_WIZ_COMPLETE_TITLE' => '安装完成',
    'LBL_SETUP_COMPLETE_INFO' => '开始使用Sugar！',
    'LBL_SETUP_USER_INFO' => '设定您的用户信息',
    'LBL_WIZ_USER_LOCALE_TITLE' => '用户区域设置',
    'LBL_SETUP_USER_LOCALE_INFO' => '设置时区，日期和名称格式',
    'LBL_WIZ_START_SUGAR' => '开始Sugar之旅',
    'LBL_WIZ_FIRST_NAME' => '名',
    'LBL_WIZ_LAST_NAME' => '姓',
    'LBL_WIZ_EMAIL' => '电子邮件',
    'LBL_WIZ_TIMEZONE' => '时区',
    'LBL_WIZ_TIMEFORMAT' => '时间格式:',
    'LBL_WIZ_DATE_FORMAT' => '日期格式:',
    'LBL_WIZ_NAME_FORMAT' => '姓名格式',
    'LBL_SETUP_PROGRESS' => '安装进度',
    //User wizard links
    'LBL_WIZ_SUGAR_TRAINING' => 'Sugar培训',
    'LBL_WIZ_DOCUMENTATION' => '文件',
    'LBL_WIZ_KNOWLEDGE_BASE' => '知识库',
    'LBL_WIZ_FORUMS' => '论坛',
    'TPL_TIMEZONE_DIFFERENT' => '您的浏览器的时区与您保存的时区不匹配{{link}}',
    'LBL_TIMEZONE_DIFFERENT_LINK' => '调整您的时区',
    //Admin wizard links
    'LBL_WIZ_SYSTEM_LOCALE_SETTINGS' => '区域设置',
    'LBL_WIZ_EMAIL_SETTINGS' => '电子邮件设置',
    'LBL_WIZ_IMPORT_DATA' => '导入数据',
    'LBL_WIZ_CREATE_USERS' => '创建用户',
    'LBL_WIZ_APPLICATION_SETTINGS' => '系统设置',
    'LBL_WIZ_CONFIGURE_APPLICATION' => '工作室',

    'LBL_CSP_ERROR_MESSAGE' => '您输入的值不受支持或不是可接受的格式。如需获取可接受字段值和格式的列表，请参阅<a href="{{linkToDocumentation}}" target="_blank">系统</a>文档.',
    'LBL_CSP_ERROR_MESSAGE_ADMIN' => '此内容尚未批准。请更新系统的<a href="{{linkToDocumentation}}" target="_blank">内容安全政策设置</a>。',
    'LBL_CSP_ERROR_MESSAGE_USER' => '此内容尚未批准。请要求管理员更新系统的<a href="{{linkToDocumentation}}" target="_blank">内容安全政策设置</a>。在设置更新后，您将需要刷新浏览器以使更改生效。',

    // For password related labels
    'LBL_PASSWORD' => '密码',
    'LBL_CHANGE_YOUR_PASSWORD' => '更改密码',
    'LBL_PASSWORD_REQUIREMENTS' => '密码规则',
    'LBL_CURRENT_PASSWORD' => '当前密码',
    'LBL_NEW_PASSWORD1' => '新密码',
    'LBL_NEW_PASSWORD2' => '确认密码',
    'LBL_PASSWORD_CHANGED' => '您已成功更改密码',
    'ERR_ENTER_CONFIRMATION_PASSWORD' => '请输入您的密码确认。',
    'ERR_ENTER_NEW_PASSWORD' => '请输入您的新密码。',
    'ERR_ENTER_OLD_PASSWORD' => '请输入您的当前密码。',
    'ERR_REENTER_PASSWORDS' => '请重新输入密码。“新密码”和“确认密码”不匹配。',
    'ERR_PASSWORD_MISMATCH' => '输入密码与系统密码不匹配。',
    'LBL_CANNOT_SEND_PASSWORD' => '不能发送密码',
    'LBL_REQUEST_PASSWORD' => '需要密码',
    'LBL_RESET_PASSWORD' => '重设密码',
    'LBL_RESET_PASSWORD_MESSAGE' => '请输入您的用户名，我们将向您发送链接以重设密码。',
    'LBL_RESET_PASSWORD_CONFIRMATION_MESSAGE' => '请查看您的电子邮件 <br><br> 我们已向我们存档的电子邮件地址发送密码重设指示。',
    'LBL_PASSWORD_UPDATE_GENERIC_ISSUE' => '错误:用户密码更新有问题。',
    'LBL_INCORRECT_PASSWORD' => '错误：密码错误。',
    'LBL_PASSWORD_ENFORCE_TITLE' => '您输入的密码不符合密码要求，请重试。',
    'LBL_PASSWORD_MIN_LENGTH' => '最小长度为 {0}。',
    'LBL_PASSWORD_MAX_LENGTH' => '最大长度为 {0}。',
    'LBL_PASSWORD_ONE_UPPERCASE' => '必须包含大写字母 (A-Z)。',
    'LBL_PASSWORD_ONE_LOWERCASE' => '必须包含小写字母 (a-z)。',
    'LBL_PASSWORD_ONE_NUMBER' => '必须包含数字 (0-9)。',
    'LBL_PASSWORD_ONE_SPECIAL_CHAR' => '必须包含特殊字符 (~!@#$%^&*()_+-={}|)。',
    'LBL_PASSWORD_REGEX_REQUIREMENT' => '密码不能与正则表达式模式相匹配：{0}。',

    'LBL_PREFERRED_LANGUAGE' => '首选语言：',
    'LBL_PASSWORD_RESET_EMAIL_FAIL' => '无法发送密码重设电子邮件。',

    //Saved Reports
    'LBL_REPORT_SELECT' => '选择报告',
    'LBL_REPORT_AUTO_REFRESH' => '自动刷新',
    'LBL_REPORT_EDIT' => '编辑所选报告',
    'LBL_REFRESH_LIST_AND_CHART' => '刷新列表和图表',
    'LBL_NO_CHART_REPORT_AVAILABLE' => '没有可用的图表。',
    'LBL_NO_FILTERS_REPORT_AVAILABLE' => '此报告不包含任何筛选器。',
    'LBL_NO_RUNTIME_FILTERS_REPORT_AVAILABLE' => '您只有隐藏的运行时筛选器，请参阅高级筛选器。',
    'LBL_RUNTIME_FILTERS' => '运行时筛选器',
    'LBL_RUNTIME_FILTER_DATE_PREF_MISSMATCH' => '日期与用户的首选日期格式不匹配： ',
    'LBL_DASHLET_NO_RUNTIME_FILTERS' => '此 Dashlet 没有运行时筛选器',
    'LBL_DASHBOARD_FILTER_GROUP' => '新筛选器',
    'LBL_RUNTIME_FILTER_LIMITATION' => '您至少需要选择一个值。',
    'LBL_RESET_FILTERS_TO_DEFAULT' => '重置为默认筛选器',
    'LBL_COPY_FILTER_SUMMARY' => '复制筛选器摘要',
    'LBL_APPLY_FILTERS' => '应用',
    'LBL_REPORTS_FILTERS' => '筛选器',
    'LBL_RUNTIME_FILTERS_INVALID' => '由于值无效，无法应用运行时筛选器',
    'LBL_RUNTIME_FILTERS_COPIED' => '筛选器摘要已复制到剪贴板。',
    'LBL_ADVANCED_FILTERS' => '高级筛选器',
    'LBL_ADVANCED_OR_DESC' => '满足任何条件时包括',
    'LBL_ADVANCED_AND_DESC' => '满足所有条件时包括',
    'LBL_ORIGINAL_DESIGN_FILTER' => '这是原创设计的筛选器',
    'LBL_AND_UPPERCASE' => '和',
    'LBL_REPORTS_PREVIEW_LIMITATION' => '此功能在预览模式下不可用',
    'LBL_REPORT_DEFAULT_NAME' => '无标题报告',
    'LBL_REPORT_QUERY' => '查询',
    'LBL_REPORTS_DASHLET_INTELLIGENT' => '与当前记录相关',
    'LBL_REPORTS_DASHLET_RELATED_LINK' => '链接字段',
    'LBL_REPORTS_DASHLET_INVALID_LINK' => '链接字段不能为空',
    'LBL_REPORTS_DASHLET_INVALID_REPORT' => '未选择报告。',
    'LBL_REPORTS_DASHLET_LINE_CHART_INVALID' => '折线图与此报表不兼容',
    'LBL_REPORT_DASHLET' => '报告仪表板',
    'LBL_REPORTS_DASHLET_DATATABLE' => '数据表',
    'LBL_REPORTS_DASHLET_RUNTIME_FILTERS' => '运行时筛选器',
    'LBL_REPORTS_DASHLET_DATATABLE_PREVIEW' => '数据表预览',
    'LBL_REPORTS_DASHLET_CHART' => '图表',
    'LBL_REPORTS_DASHLET_CHART_PREVIEW' => '图表预览',
    'LBL_REPORTS_DASHLET_FILTER_PREVIEW' => '筛选器预览',
    'LBL_REPORTS_DASHLET_INVALID_FEATURE' => '所选报告不支持图表。',
    'LBL_REPORTS_DASHLET_LABELS' => '标签',
    'LBL_REPORTS_DASHLET_SHOW_COUNT' => '显示总记录数',
    'LBL_REPORTS_DASHLET_SORT_ORDER' => '排序顺序',
    'LBL_REPORTS_DASHLET_DEFAULT_VIEW' => '默认选定视图',
    'LBL_REPORTS_DASHLET_PRIMARY_CHART_SORT' => '主要图表排序顺序',
    'LBL_REPORTS_DASHLET_SECONDARY_CHART_SORT' => '次要图表排序顺序',
    'LBL_REPORTS_DASHLET_NO_LINKS_SELECTED' => '没有 {{module}} 链接到选定的报告',
    'LBL_REPORTS_DASHLET_NO_AVAILABLE_FOR_REPORT_TYPE' => '此报告类型不可用',
    'LBL_REPORTS_DASHLET_UNABLE_TO_DOWNLOAD_CHART_TAB' => '此功能仅在图表选项卡上可用',
    'LBL_REPORTS_CHART_TYPE' => '图表类型',
    'LBL_REPORTS_CHART_CONFIG_VALUE_PLACEMENT' => '柱状图值的放置',
    'LBL_REPORTS_CHART_CONFIG_SHOW_TOTAL' => '显示总计',
    'LBL_REPORTS_CHART_LEGEND_OPEN' => '显示图例',
    'LBL_REPORTS_CHART_CONFIG_SHOW_XAXIS_LABEL' => '显示 x 轴标签',
    'LBL_REPORTS_CHART_CONFIG_SHOW_YAXIS_LABEL' => '显示 y 轴标签',
    'LBL_REPORTS_DASHLET_CONFIGURE_DISPLAY_ROWS' => '行数显示限制',
    'LBL_REPORTS_DASHLET_RUNTIME_NO_PERMISSONS' => '您无权使用这些运行时筛选器。',

    //sidecar errors
    'ERR_HTTP_DEFAULT_TYPE' => '未知',
    'ERR_HTTP_DEFAULT_TITLE' => '未知的错误',
    'ERR_HTTP_DEFAULT_TEXT' => '未知错误。',
    'ERR_HTTP_DEFAULT_ACTION' => '回到前一页。',

    'ERR_HTTP_400_TYPE' => '400',
    'ERR_HTTP_400_TITLE' => '错误：无效请求',
    'ERR_HTTP_400_TEXT_LINE1' => '你的浏览器发送了服务器无法理解的请求。',
    'ERR_HTTP_400_TEXT_LINE2' => '欲知详情，请联系你的Sugar管理员。',
    'ERR_HTTP_400_ACTION' => '回到前一页。',

    'ERR_HTTP_404_TYPE' => '404',
    'ERR_HTTP_404_TITLE' => 'HTTP: 404 Not Found',
    'ERR_HTTP_404_TEXT_LINE1' => '页面不存在或您没有访问该页面的权限。',
    'ERR_HTTP_404_TEXT_LINE2' => '请重试。如果错误仍然存在，请联系您的 Sugar 管理员。',
    'ERR_HTTP_404_ACTION' => '回到前一页。',

    'ERR_HTTP_500_TYPE' => '500',
    'ERR_HTTP_500_TITLE' => 'HTTP: 500内部服务器错误',
    'ERR_HTTP_500_TEXT_LINE1' => '服务器遇到错误，无法完成您的请求。',
    'ERR_HTTP_500_TEXT_LINE2' => '请重试。如果错误仍然存在，请联系您的 Sugar 管理员。',
    'ERR_HTTP_500_ACTION' => '请联系技术支持',

    'ERR_HTTP_502_TYPE' => '502',
    'ERR_HTTP_502_TITLE' => 'HTTP: 502 内部服务器错误',
    'ERR_HTTP_502_TEXT_LINE1' => '服务器暂时出现错误，无法完成您的请求。',
    'ERR_HTTP_502_TEXT_LINE2' => '请重试。如果错误仍然存在，请联系您的 Sugar 管理员。',
    'ERR_HTTP_502_ACTION' => '请联系技术支持。',

    'ERR_HTTP_503_TYPE' => '503',
    'ERR_HTTP_503_TITLE' => 'HTTP: 503 内部服务器错误',
    'ERR_HTTP_503_TEXT_LINE1' => '服务器不可用，无法完成您的请求。',
    'ERR_HTTP_503_TEXT_LINE2' => '请稍后重试。如果错误仍然存在，请联系您的 Sugar 管理员。',
    'ERR_HTTP_503_ACTION' => '请联系技术支持。',

    'ERR_RENDER_FAILED_TITLE' => '渲染失败',
    'ERR_RENDER_FAILED_MSG' => '无法渲染视图',
    'ERR_RENDER_FIELD_FAILED_TITLE' => '字段渲染失败',
    'ERR_RENDER_FIELD_FAILED_MSG' => '无法使用 {0} 字段.',

    'ERR_NO_VIEW_ACCESS_TITLE' => '访问被拒绝',
    'ERR_NO_VIEW_ACCESS_REASON' => '您没有权限访问此页面。',
    'ERR_NO_VIEW_ACCESS_ACTION' => '请与管理员联系，以请求访问。',
    'ERR_NO_VIEW_ACCESS_MSG' => '请联系您的技术支持管理员访问 {0} 模块。',

    'ERR_LAYOUT_RENDER_TITLE' => '布局渲染失败',
    'ERR_LAYOUT_RENDER_MSG' => '不能够呈现任何内容。请稍后再试，或者联系技术支持。',
    'ERR_INTERNAL_ERR_MSG' => '内部错误',
    'ERR_GENERIC_TITLE' => '错误',
    'ERR_CONTACT_TECH_SUPPORT' => '请联系技术支持。',

    'LBL_SYNCED_RECURRING_MSG' => '您不能编辑这个记录因为它与外部客户端同步。',
    'LBL_EXISTING' => '存在的',
    'LBL_PANEL_DEFAULT' => '默认',
    'ERR_BAD_RESPONSE_FROM_SERVER' => '服务器错误的响应',

    //Sidecar expression context
    'ERR_ASSIGNTO_ACTION' => '执行“分配至”动作过程中出错。',

    //Generic error for displaying that the user does not have access to something
    'ERR_NO_ACCESS' => '您无法访问“{{name}}”。请联系您的管理员。',

    //These are for the timeperiod name formats
    'LBL_ANNUAL_TIMEPERIOD_FORMAT' => '年 {0}',
    'LBL_QUARTER_TIMEPERIOD_FORMAT' => '{1} 季度{0}',
    'LBL_MONTH_TIMEPERIOD_FORMAT' => '{0}',

    'LBL_MORE_ACTION' => '更多动作',

    //quickcreate modal dialog
    'LBL_MESSAGE_BOX_TITLE' => '警告',
    'LBL_IGNORE_DUPLICATE_AND_SAVE' => '忽略重复并保存',
    'LBL_RESTORE' => '重置',

    //Data Privacy Erasure Dashlet
    'LBL_MARKED_FOR_ERASURE_TITLE' => '已标记为删除的记录',
    'LBL_MARKED_FOR_ERASURE_DASHLET_DESCRIPTION' => '显示与数据隐私请求相关的记录，以 '
        . '删除信息。',

    // RSS Feed dashlet
    'LBL_RSS_FEED_DASHLET' => 'RSS信息源',
    'LBL_RSS_FEED_DASHLET_DESCRIPTION' => '欲知最新信息，添加外接RSS或博客信息源。',
    'LBL_RSS_FEED_URL' => '信息源URL',
    'LBL_RSS_FEED_AUTHOR' => '作者：',
    'LBL_RSS_FEED_ENTRIES_COUNT' => '显示几个条目：',
    'LBL_ERR_LOADING_RSS_FEED' => '加载 RSS 信息流失败',

    // tabbed dashlet
    'TPL_TABBED_DASHLET_USER_BUTTON_LABEL' => '我的项目',
    'TPL_TABBED_DASHLET_GROUP_BUTTON_LABEL' => '团队的项目',

    // Sugar Apps Dashlet
    'LBL_SUGAR_APPS_DASHLET_LABEL' => 'Sugar Apps Dashlet',
    'LBL_SUGAR_APPS_DASHLET_DESC' => '允许用户将 Sugar 应用程序添加到仪表板',
    'LBL_SUGAR_APPS_DASHLET_APP_SELECT_LABEL' => 'Select a Sugar App',
    'LBL_SUGAR_APPS_DASHLET_CATALOG_ERROR' => 'This Sugar App is currently unavailable with error code {{errorCode}}. Please refresh the page or check with your Administrator if the problem persists.',

    // history dashlet
    'LBL_HISTORY_DASHLET' => '历史',
    'LBL_HISTORY_DASHLET_DESCRIPTION' => '历史记录仪表盘显示发送召开会议，电话记录，收到的电子邮件和电子邮件。',
    'LBL_HISTORY_DASHLET_EMAIL_SINGULAR' => '电子邮件',
    'LBL_HISTORY_DASHLET_EMAIL_PLURAL' => '电子邮件',
    'LBL_HISTORY_DASHLET_USER_BUTTON_LABEL' => '我的历史记录',
    'LBL_HISTORY_DASHLET_GROUP_BUTTON_LABEL' => '团队历史记录',
    'LBL_UNASSIGNED' => '未分配',
    'LBL_ARCHIVE_EMAIL' => '存档电子邮件',
    'LBL_EMAIL_ARCHIVED' => '电子邮件归档',
    'LBL_CREATE_ARCHIVED_EMAIL' => '创建已存档电子邮件',

    // planned activities dashlet
    'LBL_PLANNED_ACTIVITIES_DASHLET' => '计划的行动',
    'LBL_PLANNED_ACTIVITIES_DASHLET_DESCRIPTION' => '计划中的行动仪表物件显示预定的会议和电话。',
    'LBL_PLANNED_ACTIVITIES_DASHLET_TODAY_BUTTON_LABEL' => '今天',
    'LBL_PLANNED_ACTIVITIES_DASHLET_FUTURE_BUTTON_LABEL' => '未来',
    'LBL_PLANNED_ACTIVITIES_DASHLET_USER_BUTTON_LABEL' => '我的活动',
    'LBL_PLANNED_ACTIVITIES_DASHLET_GROUP_BUTTON_LABEL' => '团队的活动',
    'LBL_PLANNED_ACTIVITIES_DASHLET_HELD_ACTIVITY' => '完成',
    'LBL_PLANNED_ACTIVITIES_DASHLET_CONFIRM_CLOSE' => '您确定要把{0}标记为关闭吗？',

    // active tasks dashlet
    'LBL_ACTIVE_TASKS_DASHLET' => '激活的任务',
    'LBL_ACTIVE_TASKS_DASHLET_DESCRIPTION' => '激活的任务仪表盘显示现在，即将到来的任务。',
    'LBL_ACTIVE_TASKS_DASHLET_DUE_NOW' => '现在的',
    'LBL_ACTIVE_TASKS_DASHLET_UPCOMING' => '即将到来',
    'LBL_ACTIVE_TASKS_DASHLET_TODO' => '未来的',
    'LBL_ACTIVE_TASKS_DASHLET_COMPLETE_TASK' => '完成',
    'LBL_ACTIVE_TASKS_DASHLET_CONFIRM_CLOSE' => '您确定要关闭{0}完成吗？',
    'LBL_ACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '我的任务',
    'LBL_ACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => '团队任务',
    'LBL_LIST_REMOVE_EMAIL_INFO' => '您正在修改的记录有另一个的电子邮件地址，现在将成为主电子邮件并生成如下。',
    // inactive tasks dashlet
    'LBL_INACTIVE_TASKS_DASHLET' => '未激活的任务',
    'LBL_INACTIVE_TASKS_DASHLET_DESCRIPTION' => '任务仪表盘显示递延的和完成的任务。',
    'LBL_INACTIVE_TASKS_DASHLET_DEFERRED' => '延期',
    'LBL_INACTIVE_TASKS_DASHLET_COMPLETED' => '完成',
    'TPL_INACTIVE_TASKS_DASHLET_TIME_RELATIVE' => '最后一次修改{{relativetime}}于{{date}}的{{time}}',
    'LBL_INACTIVE_TASKS_DASHLET_USER_BUTTON_LABEL' => '我的任务',
    'LBL_INACTIVE_TASKS_DASHLET_GROUP_BUTTON_LABEL' => '团队任务',

    'LBL_RECENTLY_VIEWED_CASES_DASHLET' => '我最近查看的客户反馈',

    'LBL_REPORT_DASHLET_TITLE_12' => '按用户按状态排序的未决客户反馈',
    'LBL_REPORT_DASHLET_TITLE_125' => '按业务中心按周排序的新客户反馈',
    'LBL_REPORT_DASHLET_TITLE_126' => '最近创建的客户反馈',
    'LBL_REPORT_DASHLET_TITLE_127' => '按客户层按周排序的新客户反馈',
    'LBL_REPORT_DASHLET_TITLE_128' => '按客户层和优先级排序的未决客户反馈',
    'LBL_REPORT_DASHLET_TITLE_129' => '按业务中心排序的本月已解决总客户反馈',
    'LBL_REPORT_DASHLET_TITLE_130' => '按代理排序的本月已解决总客户反馈',
    'LBL_REPORT_DASHLET_TITLE_131' => '最近已解决客户反馈列表',
    'LBL_REPORT_DASHLET_TITLE_132' => '我本月已解决的客户反馈（按周排序）',
    'LBL_REPORT_DASHLET_TITLE_133' => '今日到期和已过期的我的客户反馈',
    'LBL_REPORT_DASHLET_TITLE_134' => '今日到期和已过期的全部客户反馈',
    'LBL_REPORT_DASHLET_TITLE_135' => '我的未决客户反馈（按跟踪日期排序）',
    'LBL_REPORT_DASHLET_TITLE_136' => '全部未决客户反馈（按跟踪日期排序）',
    'LBL_REPORT_DASHLET_TITLE_137' => '我的未决客户反馈（按状态排序）',
    'LBL_REPORT_DASHLET_TITLE_138' => '我上周的客户反馈（按状态排序）',
    'LBL_REPORT_DASHLET_TITLE_139' => '我分配的待处理任务的状态',

    //Audit subjects
    'LBL_AUDIT_SUBJECT_ADVANCED-WORKFLOW' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_API-BWC' => 'BWC UI',
    'LBL_AUDIT_SUBJECT_API-REST' => 'REST API',
    'LBL_AUDIT_SUBJECT_API-RPC' => 'SOAP 或 Old REST API',
    'LBL_AUDIT_SUBJECT_CLI' => 'CLI',
    'LBL_AUDIT_SUBJECT_CRON-JOB' => 'Cron Job',
    'LBL_AUDIT_SUBJECT_LOGIC-HOOK' => 'Logic Hook',
    'LBL_AUDIT_SUBJECT_MARKETO' => 'Marketo',
    'LBL_AUDIT_SUBJECT_SUGAR-BPM' => 'SugarBPM',
    'LBL_AUDIT_SUBJECT_SUGAR-WORKFLOW' => 'Sugar 工作流',
    'LBL_AUDIT_SUBJECT_USER' => '用户',
    'LBL_AUDIT_SUBJECT_WEB-TO-LEAD' => 'Web to Lead',

    //common chart strings
    'LBL_CHART' => '表图',
    'LBL_CHART_NO_DATA' => '没有可用的数据。',
    'LBL_CHART_LEGEND_CLOSE' => '隐藏图例',
    'LBL_CHART_LEGEND_OPEN' => '显示图例',
    'LBL_CHART_CONTROLS_CLOSE' => '隐藏控制',
    'LBL_CHART_CONTROLS_OPEN' => '显示控制',
    'LBL_CHART_UNDEFINED' => '未定义',
    'LBL_CHART_NO_LABEL' => '未定义',
    'LBL_CHART_AMOUNT' => '金额',
    'LBL_CHART_COUNT' => '计数',
    'LBL_CHART_PERCENT' => '百分比',
    'LBL_CHART_GROUP' => '组',
    'LBL_CHART_DATE' => '日期',
    'LBL_CHART_KEY' => '关键值',

    //common chart config field labels
    'LBL_CHART_CONFIG_CHART_TYPE' => '图表类型',
    'LBL_CHART_CONFIG_SHOW_TITLE' => '显示标题',
    'LBL_CHART_CONFIG_SHOW_TOTAL' => '显示总计',
    'LBL_CHART_CONFIG_SHOW_XAXIS_LABEL' => '显示x轴标签',
    'LBL_CHART_CONFIG_SHOW_YAXIS_LABEL' => '显示y轴标签',
    'LBL_CHART_CONFIG_TICK_DISPLAY' => '勾选显示方法',
    'LBL_CHART_CONFIG_TICK_WRAP' => '勾选换行',
    'LBL_CHART_CONFIG_TICK_STAGGER' => '搓开勾选',
    'LBL_CHART_CONFIG_TICK_ROTATE' => '循环勾选',
    'LBL_CHART_CONFIG_VALUE_PLACEMENT' => '柱状图值的放置',
    'LBL_CHART_CONFIG_BAR_CHART_OPTIONS' => '柱状图显示选择',
    'LBL_CHART_CONFIG_ALLOW_SCROLLING' => '允许滚动',
    'LBL_CHART_CONFIG_STACK_DATA' => '堆栈系列',
    'LBL_CHART_CONFIG_HIDE_EMPTY_GROUPS' => '隐藏空的组',


    // interactions chart dashlet
    'LBL_EMAIL_SENT' => '已发送',
    'LBL_EMAIL_RECV' => 'rec',

    //record save
    'LBL_RECORD_SAVED' => '记录已保存。', // use when there is no information about the record
    'LBL_RECORD_SAVED_SUCCESS' => '您成功创建 {{moduleSingularLower}} <a href="#{{buildRoute model=this}}">{{name}}</a>.', // use when a model is available
    'LBL_RECORD_SAVED_SUCCESS_NO_LINK' => '成功创建 {{moduleSingularLower}}。',
    'LBL_RECORD_SAVED_ACCESS_DENIED' => '您成功地创建了这个记录，但是您没有权限访问此记录。', // use when user has no access to the model
    'LBL_VALIDATING' => '验证中...',

    //for sidecar alert view
    'LBL_ALERT_TITLE_SUCCESS' => '成功：',
    'LBL_ALERT_TITLE_WARNING' => '警告：',
    'LBL_ALERT_TITLE_NOTICE' => '请注意：',
    'LBL_ALERT_TITLE_ERROR' => '错误',
    'LBL_ALERT_TITLE_LOADING' => '加载中 ...',
    'LBL_ALERT_NO_ACCESS' => '您尚未访问应用于此栏的筛选器。',
    'LBL_ALERT_NO_ACCESS_SUPPORT' => '复制此面板以使用您自己的筛选器配置此栏。',
    'LBL_ALERT_BROWSER_NOT_SUPPORTED' => '您的浏览器版本不再支持或您使用不受支援的浏览器。',
    'LBL_ALERT_SUPPORTED_PLATFORMS_LINK' => '支持的平台',
    'LBL_ALERT_CONFIRM_DELETE' => '您确定要删除这一项吗？',
    'LBL_ALERT_CONFIRM_DELETE_PLURAL' => '您确定要删除这些项吗？',

    //opportunity chart
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM' => '所选记录会覆盖以下值：{{values}}。取消以保留现有值。确认以使用新值覆盖。',
    'TPL_OVERWRITE_POPULATED_DATA_CONFIRM_WITH_MODULE_SINGULAR' => '选中的{{moduleSingularLower}}相关值:{{values}}。取消现有值。确认要覆盖新值。',
    'LBL_OVERWRITE_POPULATED_DATA_FROM' => '发件人：',
    'LBL_OVERWRITE_POPULATED_DATA_TO' => '到：',

    //organization chart
    'LBL_ORG_CHART' => '架构图',
    'LBL_ORG_CHART_DESC' => '显示员工组织架构图',
    'LBL_ORG_CHART_TOOLTIP_TOGGLE' => '切换方向',
    'LBL_ORG_CHART_TOOLTIP_NODES' => '显示所有节点',
    'LBL_ORG_CHART_TOOLTIP_ZOOM' => '缩放以适合',


    //cases summary chart
    'LBL_CASE_SUMMARY_CHART' => '客户反馈总结',
    'LBL_CASE_SUMMARY_CHART_DESC' => '显示相关客户反馈的概况。',
    'LBL_DASHLET_CASESSUMMARY_SUMMARY' => '总结',
    'LBL_DASHLET_CASESSUMMARY_CLOSE_CASES' => '关闭客户反馈',
    'LBL_DASHLET_CASESSUMMARY_OPEN_CASES' => '打开任务',

    //top 10 opportunities chart
    // these are the generic ones, the module specific ones are in the modules language files
    'LBL_DASHLET_TOP10_SALES_OPPORTUNITIES_NAME' => 'Top 10 销售收入线项目',
    'LBL_TOP10_OPPORTUNITIES_CHART_DESC' => '显示十大收入线项目在气泡图。',
    'LBL_TOP10_OPPORTUNITIES_MY_OPP' => '我的项目',
    'LBL_TOP10_OPPORTUNITIES_MY_TEAMS_OPP' => "我的团队的项目",
    'LBL_TOP10_OPPORTUNITIES_FILTER_DURATIONS' => '默认的日期筛选器',
    'LBL_TOP10_OPPORTUNITIES_DEFAULT_DATASET' => '默认的数据集',

    'LBL_PRODUCT_CATALOG_NAME' => '产品目录',
    'LBL_PRODUCT_CATALOG_DASHLET_NAME' => '产品目录',
    'LBL_PRODUCT_CATALOG_DESC' => '从您的产品目录查看和添加项目。',
    'LBL_PRODUCT_CATALOG_DASHLET_DESC' => '从您的产品目录查看和添加项目。',

    // Activity stream
    'LBL_TIME_RELATIVE_ACTIVITIES' => '{{relativetime}}于{{date}}的{{time}}',
    'LBL_ACTIVITYSTREAM_POST_PLACEHOLDER' => '输入注释，或拖放附件. 输入 @ 提交给用户. 输入 #关联一条记录.',
    'LBL_ACTIVITYSTREAM_COMMENT_PLACEHOLDER' => '添加您的评论...输入@提交给一个用户。键入＃引用的记录。',
    'LBL_ACTIVITY_STREAM' => '活动流',
    'LBL_ACTIVITY_STREAM_DISABLED' => '活动流没有启用',
    'LBL_ACTIVITY_STREAM_DISABLED_MODULE' => '活动流无法应用于此模块',
    'LBL_ACTIVTY_STREAM_SHOW_MORE' => '更多内容...',
    'LBL_ACTIVITYSTREAM_RELATIVETIME_ON' => 'on',
    'LBL_ACTIVITY_STREAM_DASHLET_NAME' => '我的活动流',
    'LBL_ACTIVITY_STREAM_DASHLET_DESCRIPTION' => '查看对记录执行的活动列表并创建和发表评论。',
    'EXCEPTION_ACTIVITY_STREAM_DISABLED' => '活动流已禁用',

    'LBL_DATA_VIEW' => '数据视图',
    'LBL_COMMENT' => '评论',

    //application error messages
    'ERR_GENERIC_SERVER_ERROR' => '在连接到服务器时出现错误。请再试一次。',
    'ERR_RESOLVE_ERRORS' => '安装前，请先解决全部错误。',

    // AWF activity error message
    'ERR_AWF_APPROVE_VALIDATION_ERROR' => '若要核准，必须填写所有必填字段；但是您仍然可以拒绝或路由此记录。',
    'ERR_AWF_REJECT_VALIDATION_ERROR' => '若要拒绝/路由，必须填写所有必填字段。',

    // Refresh button on list views
    'LBL_LIST_REFRESH' => '刷新列表',
    // Refresh button on tile views
    'LBL_TILE_REFRESH' => '刷新平铺',

    // Textarea field.
    'LBL_TEXTAREA_MORE' => '更多',
    'LBL_TEXTAREA_LESS' => '更少',

    //attachments dashlet
    'LBL_MODULE_ATTACHMENTS_TITLE' => '{{module}}附件',
    'LBL_CREATE_ATTACHMENT' => '创建附件',
    'LBL_DASHLET_REFRESH' => '刷新',
    'LBL_DASHLET_MOVE' => '移动',
    'LBL_DASHLET_CLOSE' => '关闭：',

    'LBL_DASHLET_FORECAST_NAME' => '预测中',
    'LBL_DASHLET_FORECASTS_CHART_NAME' => '预测图',
    'LBL_DASHLET_FORECAST_PARETO_CHART_NAME' => 'Pareto预测图',
    'LBL_DASHLET_FORECASTS_FOR_CHART_NAME' => '预测',
    'LBL_DASHLET_FORECASTS_CHART_DESC' => '显示特定时间段的预测条形图',
    'LBL_DASHLET_FORECASTS_GROUPBY' => '分组',
    'LBL_DASHLET_FORECASTS_DATASET' => '数据集',
    'LBL_DASHLET_FORECASTS_DETAILS' => '详细预测',
    'LBL_DASHLET_FORECASTS_DETAILS_DESC' => '显示当前预测的详细信息。',

    'LBL_DASHLET_SAVED_REPORTS_CHART' => '保存的报表图例仪表盘',
    'LBL_DASHLET_SAVED_REPORTS_CHART_DESC' => '从保存的报表显示图表',

    'LBL_QUESTION_MARK' => '？',

    'LBL_DASHLET_RELATED_DOCUMENTS' => '已发表的相关文章',
    'LBL_DASHLET_RELATED_DOCUMENTS_DESC' => 'Displays a list of published, related knowledge base articles',

    // Historical Summary
    'LBL_HISTORICAL_SUMMARY' => '历史总结',
    'TPL_HISTORICAL_SUMMARY' => 'Historical Summary for {{name}}',
    'LBL_MORE_HISTORY' => '更多历史',
    'LBL_RELATED_CONTACT' => '相关联系人',
    'LBL_MODULE_TYPE' => '类型',
    'LBL_HISTORICAL_SUMMARY_EMAIL_TO' => '电子邮件发送至',
    'LBL_HISTORICAL_SUMMARY_EMAIL_FROM' => '电子邮件来自',
    'LBL_PREVIEW_BWC_TOOLTIP' => '旧模块无法预览',

    //SFA
    'LBL_BEST' => '最佳',
    'LBL_WORST' => '最差',
    'LBL_LIKELY' => '大概金额',
    'LBL_BEST_FORECAST' => '提交（最佳）',
    'LBL_WORST_FORECAST' => '提交（最差）',
    'LBL_LIKELY_FORECAST' => '提交（可能）',
    'LBL_BEST_ADJUSTED' => '调整后提交（最佳）',
    'LBL_WORST_ADJUSTED' => '调整后提交（最差）',
    'LBL_LIKELY_ADJUSTED' => '调整后提交（可能）',
    'LBL_AMOUNT_USDOLLAR' => '折算金额',
    'LBL_OVERDUE' => '过期的',

    'LBL_PASSWORD_REQUEST_SENT' => '您的请求已提交。',
    'LBL_PASSWORD_REQUEST_ERROR' => '检索您的用户名和电子邮件相结合时有一个问题。',

    'LBL_REMINDER_TITLE' => '提醒',
    'LBL_CLICK_TO_DRILLDOWN' => '点击下降至',

    'LBL_CAN_NOT_DISABLE_ALL_LANG' => '您不能禁用所有的语言。',

    'LBL_UPDATE_CALC_FIELDS' => '重新计算价值',

    //Optimistic Locking
    'LBL_YOU' => '您',
    'LBL_RESOLVE_CONFLICT' => '解决冲突 {{name}}',

    // Generic Help Strings
    'LBL_HELP_MORE_INFO' => '更多信息，请参阅 {{{more_info_url}}} {{plural_module_name}} 文件。{{{more_info_url_close}}}',
    'LBL_HELP_NO_HELP' => '没有可用的数据',
    'LBL_NEED_HELP' => '有些新内容需要帮助？',
    'LBL_NEW_CASE' => '新增客户反馈',

    // Dashlet Preview Help String
    'LBL_HELP_PREVIEW' => '帮助仪表提供您正常浏览的模块的详细信息，并提供链接到其他相关文档以便您获取很多信息。',

    // list view (AKA Records)
    'LBL_HELP_RECORDS_TITLE' => '列表视图帮助',
    'LBL_HELP_RECORDS' => "模块的列表视图显示用户有权限访问并满足现有搜索条件的记录。您可以在列表视图直接查看记录的基本信息，或者通过点击记录名称打开记录的详细视图查看详细信息。",

    // record view (AKA Detail View)
    'LBL_HELP_RECORD_TITLE' => '记录查看帮助',
    'LBL_HELP_RECORD' => '记录视图提供此单个记录的详细信息和其他相关关联信息。
- 通过点击单个字段或“编辑”按钮，编辑此记录的字段。
- 通过切换左下角窗格至“数据视图”，查看或修改子面板其它记录的链接。
- 通过切换左下角窗格至“活动流”，交互查看用户注释以及记录更改历史。
- 使用记录名称右侧的图标关注此记录或将此记录新增至收藏夹。
- “编辑”按钮右侧的下拉“操作”菜单提供其它操作选项。',

    // create view
    'LBL_HELP_CREATE_TITLE' => '创建 {{module_name}}',
    'LBL_HELP_CREATE' => '创建{{plural_module_name}}：
1. 按要求填写字段值。
 * 标记为“必填”的字段在保存前必须先填写完整。
 * 如有需要，点击“显示更多”以显示其它字段。
2. 点击“保存”以完成新记录，并返回至 {{plural_module_name}} 列表视图。',

    // duplicate view
    'LBL_HELP_DUPLICATE_TITLE' => '重复检测',
    'LBL_HELP_DUPLICATE' => 'Sugar检测到系统上已存在您要创建的记录。

若您不再创建新记录，要修改现有记录，单击所需记录右侧的"选择并编辑"。现有记录上的任何空白字段将填上您刚输入的值。单击“保存”即可变更现有记录。

若您决定采用您刚输入的值而不是现有记录上的值，单击“重置到原始”。您所输入的值将应用到现有记录上，接着您可继续添加修改，之后单击“保存”即可完成对现有记录的修改。

若要使用您所输入的值创建新记录，单击屏幕右上方的“忽略复制并保存”。',

    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_SUBJECT' => 'SMTP服务器未配置',
    'TPL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_DESCRIPTION' => '要发送记录分配的提醒，您需要在 {{emailSettingsUrl}}中配置SMTP服务器.',
    'LBL_MISSING_SMPT_SERVER_SETTINGS_NOTIFICATION_LINK_TEXT' => '电子邮件设置',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_SUBJECT' => '新库存报告可用',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_1' => '新库存报告已存在于你的',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_2' => '报告模块',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_3' => '他们被标为“库存报告”，可以进行筛选。报告也根据内容被标记为“销售和营销”、“客户服务”、“数据隐私”或“管理” 。更多信息请参阅',
    'LBL_NEW_OOB_REPORTS_NOTIFICATION_DESC_4' => '文档',

    // shortcut keys help
    'LBL_SHORTCUT_KEYS_HELP_ABOUT' => 'SugarCRM允许进阶的用户使用键盘快捷键完成某些任务以提高效率。右侧的表格描述了可用快捷键的键位及功能。',
    'LBL_SHORTCUT_KEYS_CONFIG_HELP' => '<h1>支持键</h1><ul><li>所有字母字符和符号</li><li>shift、ctrl、alt、command、mod （ Windows/Linux 中的 ctrl 键和 Macs 中的 command 键）</li><li>enter、esc、space、tab、pageup、pagedown、end、home、ins、del、backspace</li></ul><h1>支持功能</h1><ul><li>组合键: ctrl+m</li><li>多键：m、ctrl+m</li><li>键序列：m a</li></ul>',
    'LBL_GLOBAL_SHORTCUTS' => '全局快捷键',
    'LBL_CONTEXTUAL_SHORTCUTS' => '文脉上的快捷键',
    'LBL_SHORTCUT_KEY_KEY' => '密匙',
    'LBL_SHORTCUT_FUNCTION' => '功能',
    'LBL_SHORTCUT_CONFIG_HEADERPANE' => '配置文脉上的快捷键',
    'LBL_SHORTCUT_CONFIG_DISABLED' => '无文脉快捷键可配置',
    'LBL_SHORTCUT_HELP' => '显示快捷键帮助页',
    'LBL_SHORTCUT_QUICK_CREATE' => '隐藏/显示快速创建菜单',
    'LBL_SHORTCUT_SEARCH' => '关注全局搜索字段',
    'LBL_SHORTCUT_SIDEBAR_TOGGLE' => '隐藏/显示侧边栏',
    'LBL_SHORTCUT_CREATE_RECORD' => '创建新记录',
    'LBL_SHORTCUT_NAVIGATE_DOWN' => '选择列表下一条记录',
    'LBL_SHORTCUT_NAVIGATE_UP' => '选择列表上一条记录',
    'LBL_SHORTCUT_SCROLL_LEFT' => '向左滚动列表',
    'LBL_SHORTCUT_SCROLL_RIGHT' => '向右滚动列表',
    'LBL_SHORTCUT_OPEN' => '打开列表中的选中记录',
    'LBL_SHORTCUT_EDIT_SELECTED' => '编辑列表中的选中记录',
    'LBL_SHORTCUT_RECORD_DELETE' => '删除记录',
    'LBL_SHORTCUT_CANCEL_INLINE_EDIT' => '退出列表行间编辑模式且不保存',
    'LBL_SHORTCUT_RECORD_SAVE' => '保存记录',
    'LBL_SHORTCUT_RECORD_CANCEL' => '清空对记录的所有修改',
    'LBL_SHORTCUT_FAVORITE_RECORD' => '标记记录为收藏',
    'LBL_SHORTCUT_FOLLOW_RECORD' => '关注记录',
    'LBL_SHORTCUT_PREVIEW_SELECTED' => '预览记录',
    'LBL_SHORTCUT_MARK_SELECTED' => '标记记录为选中',
    'LBL_SHORTCUT_SELECT_ALL' => '选择全部',
    'LBL_SHORTCUT_OPEN_MASS_ACTION' => '打开批量操作下拉菜单',
    'LBL_SHORTCUT_FILTER_SEARCH' => '关注列表筛选器字段',
    'LBL_SHORTCUT_FILTER_CREATE' => '创建新列表筛选器',
    'LBL_SHORTCUT_FILTER_EDIT' => '编辑当前列表筛选器',
    'LBL_SHORTCUT_FILTER_SHOW' => '打开列表筛选器菜单',
    'LBL_SHORTCUT_RECORD_EDIT' => '编辑记录',
    'LBL_SHORTCUT_RECORD_PREVIOUS' => '打开上一条记录',
    'LBL_SHORTCUT_RECORD_NEXT' => '打开下一条记录',
    'LBL_SHORTCUT_COPY_RECORD' => '复制当前记录',
    'LBL_SHORTCUT_OPEN_MORE_ACTION' => '打开主操作下拉菜单',
    'LBL_SHORTCUT_CLOSE_DRAWER' => '关闭抽屉',
    'LBL_SHORTCUT_FILTER_ADD' => '添加新条件至筛选器',
    'LBL_SHORTCUT_FILTER_REMOVE' => '移除筛选器的最后一个条件',
    'LBL_SHORTCUT_FILTER_CLOSE' => '关闭筛选器',
    'LBL_SHORTCUT_FILTER_SAVE' => '保存筛选器',
    'LBL_SHORTCUT_FILTER_DELETE' => '删除筛选器',
    'LBL_SHORTCUT_FILTER_RESET' => '重置筛选器',
    'LBL_SHORTCUT_MASS_UPDATE_ADD' => '添加行',
    'LBL_SHORTCUT_MASS_UPDATE_REMOVE' => '移除行',
    'LBL_SHORTCUT_MASS_UPDATE_CANCEL' => '关闭批量更新',
    'LBL_SHORTCUT_MASS_UPDATE_SAVE' => '更新记录',
    'LBL_CREATE_CATEGORY' => '创建 <div class="btn-link" data-action="create-new">类别</div>',
    'LBL_SHORTCUT_ALERT_CONFIRM' => '确定',
    'LBL_SHORTCUT_ALERT_CANCEL' => '取消',
    'LBL_SHORTCUT_DRAGDROPSELECT2_SELECTALL' => '选择多选字段中的所有项目',
    'LBL_SHORTCUT_SWEETSPOT' => '切换到最优点位栏',
    'LBL_SHORTCUT_SWEETSPOT_HIDE' => '隐藏最佳点条块',
    'LBL_SHORTCUT_SAVE_CONFIG' => '保存配置',
    'LBL_SHORTCUT_RESTORE' => '恢复为默认值',
    'LBL_SHORTCUT_CONFIG_ERROR' => '在服务器上保存自定义快捷键时出现错误，请重试。',

    // config drawer
    'LBL_CONFIG_TITLE_MODULE_SETTINGS' => '{{module}}设置',
    'LBL_CONFIG_MODULE_SETTINGS_SAVED' => '{{module}}配置设置已经保存。',
    'LBL_CONFIG_BLOCKED_TITLE' => '{{module}}配置错误',
    'LBL_CONFIG_BLOCKED_DESC_NO_CONFIG_METADATA' => '{{module}}不设任何配置设置',
    'LBL_CONFIG_BLOCKED_DESC_USER_ACCESS' => '用户没有权限访问{{module}}',
    'LBL_CONFIG_BLOCKED_DESC_MODULE_ACCESS' => '用户没有权限配置{{module}}设置',
    'LBL_CONFIG_BLOCKED_DESC_CONFIG_ACCESS' => '{{module}}的数据库设置需要修理。',

    // duration field
    'LBL_START_AND_END_DATE' => '{{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_SAME_DAY' => '{{date}} {{start}} - {{end}} ({{duration}})',
    'LBL_START_AND_END_DATE_TO' => '到',
    'LBL_START_AND_END_DATE_DETAIL_VIEW' => '开始和结束日期',

    'LBL_CALENDAR_START_DATE' => '开始日期',
    'LBL_CALENDAR_END_DATE' => '结束日期',
    'LBL_CALENDAR_DURATION' => '期限',
    'LBL_CALENDAR_RECURRENCE' => '复发',
    'LBL_CALENDAR_REMINDERS' => '提醒',

    'LBL_CALENDAR_CUSTOM_DATE' => '自定义日期',
    'LBL_CALENDAR_REPEAT_TYPE' => '重复类型',
    'LBL_CALENDAR_REPEAT_INTERVAL' => '重复间隔',
    'LBL_CALENDAR_REPEAT_DOW' => '重复于周之日',
    'LBL_CALENDAR_REPEAT_ON' => '重复开启',
    'LBL_CALENDAR_REPEAT' => '重复',
    'LBL_CALENDAR_REPEAT_UNTIL_DATE' => '重复直到',
    'LBL_CALENDAR_REPEAT_COUNT' => '重复事件',
    'LBL_CALENDAR_REPEAT_SELECTOR' => '重复选择器',
    'LBL_CALENDAR_REPEAT_DAYS' => '每月天数',
    'LBL_CALENDAR_REPEAT_MONTH' => '一年中的月份',
    'LBL_CALENDAR_REPEAT_ORDINAL' => '重复顺序',
    'LBL_CALENDAR_REPEAT_UNIT' => '重复单元',
    'TPL_REPEAT_INTERVAL' => '每个 {{repeatIntervalValue}} {{repeatTypeValue}}',
    'LBL_UNSUPPORTED_RRULE' => '此系列使用“重复打开”选项，该选项在 Sugar 中不可用，因为该系列是从日历客户端同步的。如果您想在特定日期继续重复，请在您的日历客户端中编辑此系列。在 Sugar 中编辑此系列会将“重复打开”设置为“无”。<br><br>是否要继续？',

    'ERR_CALENDAR_CANNOT_UPDATE_FROM_CHILD' => '重复变更必须在系列的第一个记录执行。',
    'ERR_CALENDAR_NO_EVENTS_GENERATED' => '复发规则不会导致生成事件。',

    'LBL_CALENDAR_EVENT_RESPONSE_ACCEPT' => '参加',
    'LBL_CALENDAR_EVENT_RESPONSE_DECLINE' => '拒绝',
    'LBL_CALENDAR_EVENT_RESPONSE_TENTATIVE' => '搁置',
    'LBL_CALENDAR_EVENT_RESPONSE_NONE' => '无回复',
    'LBL_CALENDAR_EVENT_SCHEDULE_UNAVAILABLE' => '日程安排不能用',

    'LBL_CALENDAR_AVAILABLE_VIEWS' => '可用视图',
    'LBL_CALENDAR_DASHLET_NAME' => '日程计划任务',
    'LBL_CALENDAR_DEFAULT_VIEW' => '默认视图',
    'LBL_CALENDAR_MY_CALENDARS' => '我的日程',
    'LBL_CALENDAR_OTHER_CALENDARS' => '用户和团队日程',
    'LBL_CALENDAR' => '日程',

    'LBL_CALENDAR_DAY' => '日',
    'LBL_CALENDAR_WEEK' => '周',
    'LBL_CALENDAR_MONTH' => '月',
    'LBL_CALENDAR_YEAR' => '年',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_2'  => '第 2',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_3'  => '第 3',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_4'  => '第 4',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_5'  => '第 5',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_6'  => '第 6',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_7'  => '第 7',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_8'  => '第 8',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_9'  => '第 9',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_10' => '第 10',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_11' => '第 11',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_12' => '第 12',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_13' => '第 13',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_14' => '第 14',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_15' => '第 15',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_16' => '第 16',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_17' => '第 17',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_18' => '第 18',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_19' => '第 19',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_20' => '第 20',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_21' => '第 21',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_22' => '第 22',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_23' => '第 23',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_24' => '第 24',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_25' => '第 25',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_26' => '第 26',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_27' => '第 27',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_28' => '第 28',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_29' => '第 29',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_30' => '第 30',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_31' => '第 31',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_32' => '第 32',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_33' => '第 33',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_34' => '第 34',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_35' => '第 35',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_36' => '第 36',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_37' => '第 37',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_38' => '第 38',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_39' => '第 39',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_40' => '第 40',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_41' => '第 41',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_42' => '第 42',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_43' => '第 43',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_44' => '第 44',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_45' => '第 45',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_46' => '第 46',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_47' => '第 47',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_48' => '第 48',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_49' => '第 49',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_50' => '第 50',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_51' => '第 51',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_52' => '第 52',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_53' => '第 53',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_54' => '第 54',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_55' => '第 55',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_56' => '第 56',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_57' => '第 57',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_58' => '第 58',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_59' => '第 59',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_60' => '第 60',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_61' => '第 61',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_62' => '第 62',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_63' => '第 63',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_64' => '第 64',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_65' => '第 65',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_66' => '第 66',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_67' => '第 67',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_68' => '第 68',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_69' => '第 69',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_70' => '第 70',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_71' => '第 71',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_72' => '第 72',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_73' => '第 73',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_74' => '第 74',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_75' => '第 75',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_76' => '第 76',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_77' => '第 77',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_78' => '第 78',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_79' => '第 79',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_80' => '第 80',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_81' => '第 81',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_82' => '第 82',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_83' => '第 83',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_84' => '第 84',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_85' => '第 85',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_86' => '第 86',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_87' => '第 87',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_88' => '第 88',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_89' => '第 89',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_90' => '第 90',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_91' => '第 91',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_92' => '第 92',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_93' => '第 93',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_94' => '第 94',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_95' => '第 95',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_96' => '第 96',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_97' => '第 97',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_98' => '第 98',
    'LBL_CALENDAR_REPEAT_INTERVAL_VALUE_99' => '第 99',


    'LBL_ERROR_RETRIEVING_FREE_BUSY' => '调出日程时出错。',

    'LBL_SAVE_AND_SEND_INVITES_BUTTON' => '保存并发送邀请',

    // Meetings, Calls, and Messages accept status
    'LBL_ACCEPT_STATUS' => '接收状态',

    //PMSE Processes
    'LBL_PMSE_PROCESSES_DASHLET' => '流程',
    // SugarBPM should be SugarBPM<sup class="trademark>TM</sup> here, but we don't have a mechanism on the front end to
    // not escape HTML in a dynamic list collection. So for now, this, and the next three instances of SugarBPM, must
    // stay plain.
    'LBL_PMSE_PROCESSES_DASHLET_DESCRIPTION' => '流程栏显示可在 SugarBPM 内部使用的模板。',

    //PMSE Process Definitions Dashlet
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET' => '流程定义',
    'LBL_PMSE_PROCESS_DEFINITIONS_DASHLET_DESCRIPTION' => '流程定义栏显示可在 SugarBPM 内部使用的模板。',
    'LNK_PMSE_PROCESS_DEFINITIONS_NEW_RECORD' => '新增流程定义',
    'LNK_PMSE_PROCESS_DEFINITIONS_IMPORT_RECORD' => '导入流程定义',

    //PMSE Process Business Rules
    'LBL_PMSE_BUSINESS_RULES_DASHLET' => '流程商务规则',
    'LBL_PMSE_BUSINESS_RULES_DASHLET_DESCRIPTION' => '流程商务规则栏显示可在 SugarBPM 内部使用的模板。',
    'LNK_PMSE_BUSINESS_RULES_NEW_RECORD' => '新增流程商务规则',
    'LNK_PMSE_BUSINESS_RULES_IMPORT_RECORD' => '导入流程商务规则',

    //PMSE Email Templates Dashlet
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET' => '流程电子邮件模板',
    'LBL_PMSE_EMAIL_TEMPLATES_DASHLET_DESCRIPTION' => '流程电子邮件模板栏显示可在 SugarBPM 内部使用的模板。',
    'LNK_PMSE_EMAIL_TEMPLATES_NEW_RECORD' => '新增流程电子邮件模板',
    'LNK_PMSE_EMAIL_TEMPLATES_IMPORT_RECORD' => '导入流程电子邮件模板',

    //PMSE Modules Export/Import
    'LBL_PMSE_IMPORT_EXPORT_WARNING' => '当在不同的 Sugar 实例中创建流程/商务规则/电子邮件模板时，我们强烈建议该实例应与您的生产系统完全一样。导入完成后，建在独立的 Sugar 实例中的流程/商务规则/电子邮件模板可能无法按预期正常运行。流程/商务规则/电子邮件模板可能依赖于特定的工作室或应用级别的改变，包括但不是限于：自定义字段名称、下拉列表值、数据库 ID 等。如果这些值没有与创建流程/商务规则/电子邮件模板的实例完全相同，则您需要在目标实例中手动重建流程/商务规则/电子邮件模板。',
    'LBL_PMSE_IMPORT_CONFIRMATION' => '您是否仍想继续进行此导入?',
    'LBL_PMSE_EXPORT_CONFIRMATION' => '您是否仍想继续进行此导出?',

    //PMSE Activity Change Field
    'LBL_PMSE_ACTIVITY_CHANGE_FIELD_WARNING' => '以下下拉列表字段包含无效选项',

    //DASHBOARDS
    'LBL_PMSE_PROCESS_USERS_CHART_NAME' => '按流程的待执行活动',
    'LBL_PMSE_PROCESS_USERS_CHART_NAME_RECORD' => '待执行的活动',
    'LBL_PMSE_PROCESS_USERS_CHART_DESCRIPTION' => '按流程的待执行活动',
    'LBL_PMSE_ALL_PROCESSES_LABEL' => '全部流程',
    'LBL_RECORD_DASHBOARD' => '记录仪表板',


    'LBL_PMSE_PROCESS_STATUS_CHART_NAME' => '流程状态简述',
    'LBL_PMSE_PROCESS_STATUS_CHART_DESCRIPTION' => '流程状态说明',

    'LBL_PMSE_IN_PROGESS_STATUS' => '处理中',
    'LBL_PMSE_COMPLETED_STATUS' => '已完成',
    'LBL_PMSE_CANCELLED_STATUS' => '已取消',
    'LBL_PMSE_TERMINATED_STATUS' => '终止',
    'LBL_PMSE_ERROR_STATUS' => '错误',
    'LBL_PMSE_SETTINGS' => 'SugarBPM 设置',

    'LBL_PRO_DISABLE_CONFIRMATION' => '您是否确定要关闭这条记录？',
    'LBL_PRO_ENABLE_CONFIRMATION' => '您是否确定要激活这条记录？',
    'LBL_PRO_DELETE_CONFIRMATION' => '您确定要删除这条记录吗？',

    'LBL_PRO_ENABLE' => '更新中',
    'LBL_PRO_DISABLE' => '更新中',
    'LBL_PA_PRODEF_HAS_PENDING_PROCESSES' => 'This Process Definition cannot be deleted because it has pending processes running.',

    // Locked Fields
    // @codingStandardsIgnoreStart
    'LBL_LOCKED_FIELD_INLINE_EDIT' => '{{link}} 正在参与流程，可能包含一些锁定的字段。如要编辑这些字段，请点击{{link}}。',
    'LBL_LOCKED_FIELD_RECORD_VIEW_TOOLTIP' => '该字段已锁定，因为它参与了运行流程。',
    'LBL_LOCKED_FIELD_RECORD_VIEW_WARNING' => '该记录正参与流程，可能包含一些锁定的字段。',
    // @codingStandardsIgnoreEnd

    'LBL_BUSINESS_CENTER' => '业务中心',
    'LBL_BUSINESS_CENTER_ID' => '业务中心 ID',
    'LBL_BUSINESS_CENTER_NAME' => '业务中心名称',

    'LBL_PLIS_ACTIVITIES' => '已购买单项活动',

    //Tag Strings
    'LBL_TAG_NEW_TAG' => '(新标记)',
    'LBL_TAG_FETCH_ERROR' => '检索标记时出错。',

    // Javascript enable string
    'LBL_ENABLE_JAVASCRIPT' => 'Sugar 7 需要javascript。请启动Javascript以便继续使用Sugar 7。',

    // Failure handling in SugarBPM upgraders
    'LBL_PA_UNSERIALIZE_DATA_FAILURE' => '已序列化的数据无法进行反序列化',
    'LBL_PA_UNSERIALIZE_OBJECT_FAILURE' => '已序列化的数据无法进行反序列化，因为其中包含对象或类别的引用',

    'LBL_FIELD_TRIMMED' => '由于超过最大字符限制，字段被调整。',
    'LBL_FIELDSIZE_OVERFLOW' => '字段超出最大字符数限制。',
    'LBL_TINYMCE_TARGET_SAME' => '相同窗口',
    'LBL_TINYMCE_TARGET_NEW' => '新窗口',

    'LBL_OUTBOUND_EMAILS' => '电子邮件设置',
    'LBL_OUTBOUND_EMAIL' => '电子邮件设置',

    'LBL_EMAIL_PARTICIPANTS' => '电子邮件参与者',
    'LBL_EMAIL_PARTICIPANT' => '电子邮件参与者',

    'LBL_EMAIL_ADDRESS_OPTED_OUT' => 'Opted out of email campaigns',

    'LBL_DATAPRIVACY' => '数据隐私',
    'LBL_DATAPRIVACY_SUBPANEL_TITLE' => '数据隐私',
    'LBL_DATAPRIVACY_VIEW_PII' => '查看个人信息',
    'LBL_DATAPRIVACY_MARKFORERASE' => '标记以删除',
    'LBL_DATAPRIVACY_FIELDNAME' => '字段',
    'LBL_DATAPRIVACY_VALUE' => '值',
    'LBL_DATAPRIVACY_CHANGED_BY' => '修改人',
    'LBL_DATAPRIVACY_SOURCE' => '来源',
    'LBL_DATAPRIVACY_CHANGE_DATE' => '上次更新日期',
    'LBL_DATAPRIVACY_PII' => '个人信息',
    'LBL_DATAPRIVACY_MARK_FOR_ERASURE' => '标记已删除',
    'TPL_DATAPRIVACY_PII_TITLE' => '{{{name}}} 的个人信息',

    'LBL_CHANGETIMERS_SUBPANEL_TITLE' => '更改计时器',
    'LBL_MESSAGES_SUBPANEL_TITLE' => '消息',

    'LBL_TEXT_COPIED_TO_CLIPBOARD_SUCCESS' => '已复制到您的剪贴板！',
    'LBL_TEXT_COPIED_TO_CLIPBOARD_ERROR' => '无法复制到您的剪贴板',

    'LBL_COPY_EMAIL_ADDRESS_CONFIRMATION_LINK' => '复制确认链接',

    // Activity Timeline Dashlet
    'LBL_ACTIVITY_TIMELINE_DASHLET' => '时间表',
    'LBL_NO_ACTIVITY' => '无活动',
    'TPL_ACTIVITY_TIMELINE_DASHLET' => '{{moduleSingular}} 时间表',
    'LBL_ACTIVITY_TIMELINE_SHOW_MORE' => '更多',
    'LBL_ACTIVITY_TIMELINE_SHOW_LESS' => '更少',
    'LBL_ACTIVITY_TIMELINE_DASHLET_DESCRIPTION' => '时间轴显示当前记录的相关记录，并选择字段随时间推移的更新。',

    // Comment Log
    'LBL_COMMENT_LOG_SHOW_MORE' => '显示更多...',
    'LBL_COMMENT_LOG_SHOW_LESS' => '简略显示...',
    'LBL_NO_DATA_AVAILABLE_NO_PERIOD' => '无可用数据',

    // Dashlet Console List
    'LBL_MODULE_UNAVAILABLE' => '模块未获许可。',

    // Active Subscriptions and Purchase History dashlets
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET' => '活动订阅',
    'LBL_ACTIVE_SUBSCRIPTIONS_UNAVAILABLE' => '只能为链接到单个账户的模块添加此仪表。请参阅<a href={{linkToDocumentation}}>活动订阅仪表</a> 文档了解更多信息。',
    'LBL_LINKED_SUBSCRIPTIONS_ACCOUNT_FIELD' => '显示属于此帐户的购买：',
    'LBL_ACTIVE_SUBSCRIPTIONS_DASHLET_DESCRIPTION' => '特定账户的活动订阅。',
    'LBL_ACTIVE_SUBSCRIPTIONS_QUANTITY' => '，数量 {{quantity}}',
    'LBL_ACTIVE_SUBSCRIPTIONS_TOTAL' => '总计：',
    'LBL_NO_ACTIVE_SUBSCRIPTIONS' => '无活动订阅',
    'LBL_REQUIRE_REVENUE_LINE_ITEMS' => '此 Dashlet 需要 {{module_name}} 才可运作。请联络您的管理员请求启用 {{module_name}}。',
    'LBL_PURCHASE_HISTORY_DASHLET' => '购买历史记录',
    'LBL_PURCHASE_HISTORY_DASHLET_DESCRIPTION' => '特定账户的所有购买。',
    'LBL_PURCHASE_HISTORY_UNAVAILABLE' => '仅可为链接到单个账户的模块添加此 dashlet。请参阅<a href={{linkToDocumentation}} target="_blank">购买历史记录 dashlet</a> 文档获取更多信息。',
    'LBL_NO_PURCHASE_HISTORY' => '没有可显示的购买',
    'LBL_NO_PLIS' => '没有已购买单项',
    'LBL_PURCHASE_HISTORY_TOTAL_CURRENCY' => '总计',
    'LBL_PURCHASE_HISTORY_TOTAL_QUANTITY' => '数量',
    'LBL_REQUIRE_PURCHASES_AND_PLIS' => '此 dashlet 需要“购买”和“已购买单项”才可运作。请告知管理员启用“购买”和“已购买单项”。',
    'LBL_SEARCH_PURCHASE_NAME' => '按购买名称搜索...',

    // Customer Service
    'LBL_EDIT_IN_STUDIO' => '前往以下位置，使用 Studio 编辑记录视图 dashlet 布局' .
        'Studio > {{module}} > 布局 > 记录 Dashlet 视图。 <a href={{linkToStudio}}>在 Studio 中编辑</a>。',
    'LBL_SERVICE_LEVEL' => '服务等级',
    // Agent Workbench
    'LBL_AGENT_WORKBENCH_NUMBER' => '编号',
    'LBL_AGENT_WORKBENCH_FOLLOW_UP' => '跟踪',
    'LBL_AGENT_WORKBENCH_PRIORITY_STATUS' => '优先级/状态',
    'LBL_AGENT_WORKBENCH_SUBJECT_DESCRIPTION' => '主题/描述',

//Service Duration
    'LBL_SERVICE_DURATION' => '服务持续时间',
    'LBL_SERVICE_DURATION_VALUE' => '服务持续时间值',
    'LBL_SERVICE_DURATION_UNIT' => '服务持续时间单位',
    'LBL_LOCK_DURATION' => '锁定时长',

// Omnichannel
    'ERROR_OMNICHANNEL_LOAD_FAILED' => 'Amazon Connect CCP 无法加载。请' .
        '确保您使用的是' .
        '<a href="https://docs.aws.amazon.com/connect/latest/adminguide/browsers.html" target="_blank" rel="nofollow noopener noreferrer">受支持的浏览器</a>。' .
        '如果问题仍然存在，请联系您的 Sugar 管理员。',
    'ERROR_OMNICHANNEL_NOT_CONFIGURED' => '您的 Sugar 管理员尚未为 Amazon Connect 配置您的实例。',
    'ERROR_OMNICHANNEL_TIMEOUT' => '无法与 Amazon Connect 建立连接。请联系您的 Sugar 管理员以获得帮助。',
    'LBL_OMNICHANNEL_UNKNOWN' => '未知',
    'LBL_OMNICHANNEL_CONFIG_SUMMARY' => 'Summary Panel',

    // Focus Drawer dashboards
    'LBL_FOCUS_DRAWER_DASHBOARD' => '焦点抽屉',
    'LBL_CLOSE_FOCUS_DRAWER' => '关闭焦点抽屉',
    'LBL_EXTERNAL_GUESTS' => '外部客户',
    'LBL_MY_FAVORITE_TASKS' => '我的收藏夹任务',
    'LBL_RECORD' => '记录',

    'LBL_MY_TASKS' => '我的任务',

    // Sugar Integrate
    'LBL_INTEGRATE_INVALID_FIELD' => '在模块：{1} 中找不到字段:：{0}',
    'LBL_INTEGRATE_INVALID_PARAM' => '在模块： {2} 中找不到 {0}：{1} 的记录',
    'LBL_INTEGRATE_INVALID_RELATIONSHIP' => '无法找到名为：{0} 的关系',
    'LBL_INTEGRATE_DUPLICATE_PARAM' => '模块：{3} 中 ID 为 {0}，并具有 {1}：{2} 的数据库条目已存在',
    'LBL_INTEGRATE_DUPLICATE_RECORDS_DELETED' => '软删除（删除标志 = 1）',
    'LBL_INTEGRATE_DUPLICATE_RECORDS' => '在模块 {2} 上找到 {0} {1} 的多个数据库记录。 ' .
        '请移除或更新相应的匹配记录。匹配记录：{3}',

    // Time-Aware Schedules
    'LBL_TIME_AWARE_NEXT_RUN' => '下一次运行',
    'LBL_TIME_AWARE_TYPE' => '类型',
    'LBL_TIME_AWARE_BEAN_ID' => 'Bean ID',

    // Export display label
    'LBL_ENUM_DISPLAY_LABEL' => '显示标签',

    'LBL_BLANK' => '-blank-',

    'LBL_OPEN_RECORD_VIEW' => '打开记录视图',

    // actionbutton
    'LBL_ACTIONBUTTON_ADD' => '添加',
    'LBL_ACTIONBUTTON_HELP_NOT_AVAILABLE' => '帮助不可用',
    'LBL_ACTIONBUTTON_FUNCTIONS' => '函数',
    'LBL_ACTIONBUTTON_FIELDS' => '字段',
    'LBL_ACTIONBUTTON_SELECT_FIELD' => '选择字段...',
    'LBL_ACTIONBUTTON_ROLLUP' => '汇总',
    'LBL_ACTIONBUTTON_RELATED' => '关联',
    'LBL_ACTIONBUTTON_SAVE' => '保存',
    'LBL_ACTIONBUTTON_CANCEL' => '取消',
    'LBL_ACTIONBUTTON_R_MODULE' => '关联模块',
    'LBL_ACTIONBUTTON_R_FIELDS' => '关联字段',
    'LBL_ACTIONBUTTON_ROLL_MODULE' => '汇总模块',
    'LBL_ACTIONBUTTON_ROLL_FIELDS' => '汇总字段',
    'LBL_ACTIONBUTTON_ROLL_TYPE' => '汇总函数',
    'LBL_ACTIONBUTTON_MINIMUM' => '最小值',
    'LBL_ACTIONBUTTON_MAXIMUM' => '最大值',
    'LBL_ACTIONBUTTON_AVERAGE' => '平均值',
    'LBL_ACTIONBUTTON_SUM' => '总和',
    'LBL_ACTIONBUTTON_ASSIGN_RECORD' => '分配记录',
    'LBL_ACTIONBUTTON_COMPOSE_EMAIL' => '撰写电子邮件',
    'LBL_ACTIONBUTTON_CREATE_RECORD' => '创建记录',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => '文档合并',
    'LBL_ACTIONBUTTON_OPEN_URL' => '打开 Url',
    'LBL_ACTIONBUTTON_RUN_REPORT' => '运行报表',
    'LBL_ACTIONBUTTON_UPDATE_RECORD' => '更新记录',
    'LBL_ACTIONBUTTON_ACTION' => '操作',
    'LBL_ACTIONBUTTON_ASSIGN_TO' => '分配给',
    'LBL_ACTIONBUTTON_EMAIL_TO' => '发送电子邮件至',
    'LBL_ACTIONBUTTON_USE_PMSE' => '使用 PMSE',
    'LBL_ACTIONBUTTON_TEMPLATE' => '模板',
    'LBL_ACTIONBUTTON_MODULE' => '模块',
    'LBL_ACTIONBUTTON_DISPLAY_SETTINGS' => '显示设置',
    'LBL_ACTIONBUTTON_BUTTON_TYPE' => '类型',
    'LBL_ACTIONBUTTON_DROPDOWN' => '下拉列表',
    'LBL_ACTIONBUTTON_BUTTON' => '按钮',
    'LBL_ACTIONBUTTON_BUTTON_GROUP' => '按钮组',
    'LBL_ACTIONBUTTON_SHOW_FIELD_LABEL' => '显示记录标签',
    'LBL_ACTIONBUTTON_SHOW_RECORD_HEADER' => '查看头',
    'LBL_ACTIONBUTTON_HIDE_ON_EDIT' => '在编辑中隐藏',
    'LBL_ACTIONBUTTON_DISPLAY_ON_FOCUS_DASHBOARD' => '显示在焦点仪表板标题上',
    'LBL_ACTIONBUTTON_DASHBOARD' => '仪表板',
    'LBL_ACTIONBUTTON_FOCUS_DASHBOARD_HEADER' => '焦点仪表板标题',
    'LBL_ACTIONBUTTON_SIZE' => '大小',
    'LBL_ACTIONBUTTON_DEFAULT' => '默认',
    'LBL_ACTIONBUTTON_SMALL' => '小',
    'LBL_ACTIONBUTTON_LARGE' => '大',
    'LBL_ACTIONBUTTON_CALCULATED' => '已计算',
    'LBL_ACTIONBUTTON_DOCUMENT_CONVERT' => '转换成 PDF 格式',
    'LBL_ACTIONBUTTON_DOCUMENT_MERGE' => '文档合并',
    'LBL_ACTIONBUTTON_URL' => 'URL',
    'LBL_ACTIONBUTTON_PREVIEW' => '预览',
    'LBL_ACTIONBUTTON_PROPERTIES' => '属性',
    'LBL_ACTIONBUTTON_LABEL_TITLE' => '标签',
    'LBL_ACTIONBUTTON_DESC' => '工具提示',
    'LBL_ACTIONBUTTON_SHOW_LABEL' => '显示标签',
    'LBL_ACTIONBUTTON_SHOW_ICON' => '显示图标',
    'LBL_ACTIONBUTTON_SCHEME' => '配色方案',
    'LBL_ACTIONBUTTON_ICON' => '图标',
    'LBL_ACTIONBUTTON_IS_DEPENDENT' => '附属',
    'LBL_ACTIONBUTTON_DESIGN' => '布局配置',
    'LBL_ACTIONBUTTON_STOP_ON_ERROR' => '出错时停止',
    'LBL_ACTIONBUTTON_AUTOSAVE' => '自动保存',
    'LBL_ACTIONBUTTON_CONFIG' => '配置',
    'LBL_ACTIONBUTTON_CONFIG_ERROR' => '请在保存前配置您的操作按钮。',
    'LBL_ACTIONBUTTON_CONFIG_BTN' => '配置按钮',
    'LBL_ACTIONBUTTON_AUTO_CREATE' => '自动创建',
    'LBL_ACTIONBUTTON_LINK' => '创建与父级的关系',
    'LBL_ACTIONBUTTON_COPY_PARENT' => '复制父值',
    'LBL_ACTIONBUTTON_PRESET' => '设置字段值',
    'LBL_ACTIONBUTTON_PRESET_PARENT' => '从父级复制字段值',
    'LBL_ACTIONBUTTON_SELECT_OPTION' => '选择…',
    'LBL_ACTIONBUTTON_PARENT_FIELD' => '从父字段 ',
    'LBL_ACTIONBUTTON_DELETE_BUTTON' => '是否确定要删除此按钮？',
    'LBL_ACTIONBUTTON_DELETE_ACTION' => '是否确定要删除此操作？',
    'LBL_ACTIONBUTTON_INVALID_DATA' => '无效操作按钮数据',
    'LBL_ACTIONBUTTON_SELECT_MODULE' => '请在保存前选择一个模块。',
    'LBL_ACTIONBUTTON_SELECT_LINK' => '请在保存前选择一个链接。如果无可用链接，请取消选中链接选项。',
    'LBL_ACTIONBUTTON_SELECT_RECORD' => '请在保存前选择一个记录。',
    'LBL_ACTIONBUTTON_SELECT_TEMPLATE' => '请在保存前选择一个模板。',
    'LBL_ACTIONBUTTON_THEME_PRIMARY' => '主要',
    'LBL_ACTIONBUTTON_THEME_SECONDARY' => '次要',
    'LBL_ACTIONBUTTON_THEME_HIGHVIZ' => 'HighViz',
    'LBL_ACTIONBUTTON_THEME_OCEAN' => '海洋',
    'LBL_ACTIONBUTTON_THEME_PINK' => '粉色',
    'LBL_ACTIONBUTTON_THEME_ARMY' => '军队',
    'LBL_ACTIONBUTTON_THEME_TEAL' => '青色',
    'LBL_ACTIONBUTTON_THEME_PACIFIC' => '太平洋',
    'LBL_ACTIONBUTTON_THEME_GREEN' => '绿色',
    'LBL_ACTIONBUTTON_THEME_YELLOW' => '黄色',
    'LBL_ACTIONBUTTON_THEME_ORANGE' => '橙色',
    'LBL_ACTIONBUTTON_THEME_RED' => '红色',
    'LBL_ACTIONBUTTON_THEME_CORAL' => '珊瑚色',
    'LBL_ACTIONBUTTON_THEME_PURPLE' => '紫色',
    'LBL_ACTIONBUTTON_FORMULA' => '公式',
    'LBL_ACTIONBUTTON_ACTIONS' => '操作',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR' => '验证按钮数据时出错。',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL_OR_ICON' => '按钮需要设置至少一个标签或图标。',
    'LBL_ACTIONBUTTON_VALIDATION_ERROR_NEED_LABEL' => '请输入有效的按钮标签。',
    'LBL_ACTIONBUTTON_INVALID_FIELD_VALUES' => '由于缺少必要的值，无法创建记录。请联系您的管理员。',
    'LBL_ACTIONBUTTON_INVALID_DROPDOWN_ERROR' => '此按钮类型必须至少有两个活动按钮。',
    'LBL_ACTIONBUTTON_RECORD' => '记录视图',
    'LBL_ACTIONBUTTON_ACTION_MENU' => '操作菜单',
    'LBL_ACTIONBUTTON_ORDER' => '排序',
    'LBL_ACTIONBUTTON_LIST_VIEW' => '列表视图',
    'LBL_ACTIONBUTTON_RECORD_VIEW' => '记录视图页眉',
    'LBL_ACTIONBUTTON_RECORD_VIEW_DASHLET' => '记录视图 Dashlet 页眉',
    'LBL_ACTIONBUTTON_SUBPANELS' => '子面板',
    'LBL_ACTIONBUTTON_TASK_SEQUENCE_FAILED' => '任务序列执行引擎执行以下操作失败： ',
    'LBL_ACTIONBUTTON_ADD_ACTION' => '添加操作',
    'LBL_ACTIONBUTTON_REMOVE_ACTION' => '删除此操作',
    'LBL_ACTIONBUTTON_ASSIGN_CURRENT_USER' => '当前用户',

    //document merging
    'LBL_MERGE_TEMPLATE_BUTTON_LABEL' => '文档合并',
    'LBL_MERGE_TEMPLATE_PDF_BUTTON_LABEL' => '文档合并到 PDF',

    //hint
    'LBL_HINT_COMPANY_SIZE' => '公司规模',
    'LBL_HINT_COMPANY_INDUSTRY' => '行业',
    'LBL_HINT_COMPANY_INDUSTRY_TAGS' => '行业标签',
    'LBL_HINT_COMPANY_LOCATION' => '公司地址',
    'LBL_HINT_COMPANY_DESCRIPTION' => '公司描述',
    'LBL_HINT_COMPANY_FOUNDED_YEAR' => '成立年份',
    'LBL_HINT_COMPANY_FACEBOOK' => '公司脸书',
    'LBL_HINT_COMPANY_TWITTER' => '公司 Twitter',
    'LBL_HINT_COMPANY_PIC' => '公司标志',
    'LBL_HINT_CONTACT_PIC' => '联系人照片',
    'LBL_HINT_COMPANY_WEBSITE' => '公司网站',
    'LBL_HINT_PHOTO' => '照片链接',
    'LBL_HINT_JOB_2' => '以前的工作',
    'LBL_HINT_EDUCATION' => '教育',
    'LBL_HINT_EDUCATION_2' => '额外教育',
    'LBL_HINT_TWITTER' => 'Twitter 链接',
    'LBL_HINT_FACEBOOK' => '脸书链接',
    'LBL_HINT_COMPANY_NAICS_CODE_LABEL' => 'NAICS 代码',
    'LBL_HINT_COMPANY_SIC_CODE_LABEL' => 'SIC 代码',
    'LBL_HINT_COMPANY_FISCAL_YEAR_END' => '财政年度末',
    'LBL_HINT_COMPANY_ANNUAL_REVENUE' => '年营业额',
    'LBL_HINT_PHONE_1' => '电话 1',
    'LBL_HINT_PHONE_2' => '电话 2',
    'LBL_HINT_PANEL' => 'Sugar Hint',
    'LBL_HINT_JOIN_TABLE' => '连接表',
    'LBL_HINT_FULL_NAME' => '全名',
    'LBL_HINT_JOB_TITLE' => '职位名称',
    'LBL_HINT_OFFICE_PHONE' => '办公电话',
    'LBL_HINT_MOBILE_PHONE' => '手机',
    'LBL_HINT_OTHER_PHONE' => '其他电话',
    'LBL_HINT_WEBSITE' => '网站',
    'LBL_HINT_MSG_OVERWRITE_ALL' => '是否要用 Sugar Hint 中的新数据覆盖此记录的所有现有数据？',
    'LBL_HINT_MSG_OVERWRITE_FIELD' => '是否要使用 Sugar Hint 中的新 {{fieldName}} 覆盖此记录的现有 {{fieldName}}?',
    'LBL_HINT_MSG_TOTAL_OVERWRITE' => '将删除所有与帐户相关的数据，是否确实要继续?',
    'LBL_HINT_COMPANY_LOGO' => '标志',
    'LBL_HINT_CONTACTS_AVATAR' => '照片',
    'LBL_HINT_ACCOUNTSETS' => 'Sugar Hint 帐套表标记',

    'LBL_HINT_LOADING' => '加载 ...',
    'LBL_HINT_UNINSTALL_PROCESSING' => '正在卸载 Sugar Hint，请稍候',
    'LBL_HINT_VALUE_ERASED' => '值已删除',
    'LBL_HINT_VALUE_ERASED_TOOLTIP' => '此信息已通过数据隐私请求删除',

    'LBL_HINT_UNINSTALL_TITLE' => '请从下面选择一个卸载选项：',
    'LBL_HINT_UNINSTALL_PARTIAL' => '仅卸载 Hint 包',
    'LBL_HINT_UNINSTALL_FULL' => '完全卸载 Hint',
    'LBL_HINT_UNINSTALL_PARTIAL_DESCRIPTION' => '此选项将删除提示 MLP，并禁用 Sugar Hint Insights 的所有活动订阅。重新安装 Hint 将自动重新激活订阅。',
    'LBL_HINT_UNINSTALL_FULL_DESCRIPTION' => '此选项将执行 Hint 完全卸载，包括删除 MLP 和删除所有配置和订阅信息。',
    'LBL_HINT_UNINSTALL' => '卸载',
    'LBL_HINT_UNINSTALL_HEADER' => '卸载 Sugar Hint',
    'LBL_HINT_CANCEL' => '取消',
    'LBL_HINT_UNINSTALL_WARNING1' => '警告：只有在以后不打算再次使用 Hint 时，才选择此选项。在执行卸载之前，请完成 Sugar 数据库的完整备份，并将 Sugar 置于维护模式。',
    'LBL_HINT_UNINSTALL_WARNING2' => '查看',
    'LBL_HINT_UNINSTALL_WARNING_LINK' => 'Sugar Hint 管理指南 ', // TODO: This URL needs to be changed.
    'LBL_HINT_UNINSTALL_WARNING3' => '了解卸载过程的详细信息。',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE1' => '是否确定只卸载 Sugar Hint 包？',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2' => '是否确定要完全卸载 Sugar Hint？',
    'LBL_HINT_UNINSTALL_WARNING_MESSAGE2_SUBTEXT' => '（注意：无法撤消此操作）',

    'LBL_HINT_CONFIG_TITLE' => 'Sugar Hint 字段',
    'LBL_HINT_NO_RESULTS_MSG' => '未找到结果。',
    'LBL_HINT_CONFIG_BASIC_PREVIEW' => '基本 Hint 面板布局',
    'LBL_HINT_CONFIG_TAB_ACCOUNTS' => '帐户',
    'LBL_HINT_CONFIG_TAB_CONTACTS' => '联系人',
    'LBL_HINT_CONFIG_TAB_LEADS' => '潜在客户',
    'LBL_HINT_CONFIG_EXPANDED_PREVIEW' => '展开的 Hint 面板布局',
    'LBL_HINT_CONFIG_DIR_PAR1' => '通过在上面的 Hint 面板布局部分中拖放来重新排列字段。',
    'LBL_HINT_CONFIG_DIR_PAR2' => '有关详细说明和默认字段列表，请参阅 ',
    'LBL_HINT_CONFIG_RESTORE_TEXT' => ' 以恢复默认设置 ',
    'LBL_HINT_CONFIG_MODULE_TEXT' => '模块。',
    'LBL_HINT_CONFIG_WARNING_MESSAGE' => '是否确实要还原回 {{module}} 模块的默认值？',
    'LBL_HINT_CONFIG_RESTORE_BUTTON' => '点击此处',
    'LBL_HINT_CONFIG_NAME' => 'Hint 管理指南。',
    'LBL_HINT_CONFIG_FIELD_SELECTOR' => '字段',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE' => '充实的字段',
    'LBL_HINT_ENRICHED_FIELD_SUBTITLE_NOTE' => '本节列出了所有 Hint 字段和通过 Hint 充实后的所有 Sugar 字段。提示字段用星号（*）标记，并且只有在经过充实后才能显示在 Hint 面板中。',
    'LBL_HINT_CONFIG_FIELD_NAME' => '字段名称',
    'LBL_HINT_CONFIG_ENRICH_FIELD' => '充实字段',
    'LBL_HINT_CONFIG_FIELD_SHOW1' => '在 Hint 中显示',
    'LBL_HINT_CONFIG_FIELD_SHOW2' => '在 Hint 面板中显示',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE' => '其他 Sugar 字段',
    'LBL_HINT_ADDITIONAL_FIELD_SUBTITLE_NOTE' => '本节列出了所有未通过 Hint 充实的 Sugar 字段。',
    'LBL_HINT_RESYNC_NOTIFICATION_TITLE' => '警告',
    'LBL_HINT_RESYNC_NOTIFICATION_DESCRIPTION' => '警告：您即将与 Sugar Hint Insights 服务同步。任何待处理的电子邮件摘要故事都将丢失，现有新闻将从消息渠道中清除。所有类型的通知都将在同步完成后恢复。',

    'LBL_HINT_ACCOUNT_CHANGE_TITLE' => '下面列出了与您的 {{_moduleSingular}} 相关的建议公司。选择要显示的公司数据。',
    'LBL_HINT_NO_ACCOUNT_SELECTED' => '未选择任何帐户',

    'LBL_HINT_EMAIL_IMPORT_TITLE' => '找到多封电子邮件，请选择要导入的电子邮件： ',

    'LBL_HINT_HELP_MESSAGE1' => '根据输入的数据，Hint 无法在系统中找到匹配项。',
    'LBL_HINT_HELP_MESSAGE2' => 'Hint 中的最佳结果可以通过一个人的姓名和电子邮件地址找到。',
    'LBL_HINT_HELP_MESSAGE3' => 'Hint 中的最佳结果可以通过公司网站 url 找到。',
    'LBL_HINT_HELP_DEFAULT_MESSAGE1A' => "输入 {{_moduleSingular}} 的公司名称或网站，Hint 将搜索其他数据。",
    'LBL_HINT_HELP_DEFAULT_MESSAGE1B' => "输入您的 {{currentModule}} 的电子邮件地址，Hint 将搜索其他数据。",

    'LBL_HINT_HISTORY_NONE' => '无可用于历史视图的数据',
    'LBL_HINT_HISTORY_TITLE' => '活动历史',

    'LBL_HINT_PREVIEW_TITLE' => '数据充实',
    'LBL_HINT_PREVIEW_LICENSE_EXPIRED' => 'Hint 服务的许可证已过期。请联系 SugarCRM 管理员以续订许可证。',
    'LBL_HINT_PREVIEW_QUESTION' => '想知道 Hint 能为您和您的公司做些什么吗？请联系您的 SugarCRM 管理员以添加 Hint。',
    'LBL_HINT_PREVIEW_NO_ACCOUNT_INFO' => '找不到帐户信息',
    'LBL_HINT_PREVIEW_TOOLTIP_TITLE' => '找到充实的数据 - 点击以将所有充实的数据保存到记录中。',
    'LBL_HINT_PREVIEW_CLICK_TO_SAVE' => '点击以将充实的数据保存到记录中。',

    'LBL_HINT_CONTACTS_TITLE' => '相关联系人',
    'LBL_HINT_CONTACTS_NONE' => '无相关联系人',

    'LBL_HINT_NEWS' => '新闻',
    'LBL_HINT_GENERAL' => '常规',
    'LBL_HINT_ALL_NEWS' => '所有新闻',
    'LBL_HINT_FILTER_NEWS' => '过滤新闻',
    'LBL_HINT_FINANCIAL_NEWS' => '财务',
    'LBL_HINT_PERSONNEL_NEWS' => '全体人员',
    'LBL_HINT_PRESS_RELEASES' => '新闻稿',
    'LBL_HINT_OTHER_NEWS' => '其他',
    'LBL_HINT_NEWS_PLACEHOLDER' => '搜索新闻文章',
    'LBL_HINT_NEWS_ALERT' => 'Sugar Hint Insights',
    'LBL_HINT_NEWS_NONE' => '无可用新闻',
    'LBL_NEW_NOTIFICATIONS' => '新通知',
    'LBL_HINT_DASHLET_ALLOWED1' => '您必须拥有 Sugar Hint 许可证才能查看 Sugar Hint Insights 渠道。询问您的管理员关于获取 Sugar Hint 许可证的信息。',

    'LBL_HINT_FOR' => '为',
    'LBL_HINT_WITH' => '和',
    'LBL_HINT_SHOW_ME' => '显示更多： ',
    'LBL_HINT_NOTIFY_ME_BY' => '通过以下方式通知我： ',

    'LBL_NOTIFICATIONS_TITLE' => 'Sugar Hint Insights 首选项中心',
    'LBL_NOTIFICATIONS_KEY_TITLE' => '首选项选项键',
    'LBL_HINT_PREFERENCES' => '首选项',
    'LBL_HINT_MINIMUM_PREFERENCES' => '已禁用删除，至少需要一条偏好声明',
    'LBL_HINT_MAXIMUM_PREFERENCES' => '添加已禁用，您已达到首选项声明的最大值',

    'LBL_NOTIFICATIONS_KEY_TITLE_DASHLET' => '包含在 Sugar Hint Insights 渠道中',
    'LBL_NOTIFICATIONS_KEY_TITLE_BROWSER' => '弹出式桌面通知',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER' => '必须在所有浏览器和所有台式计算机上启用通知才能始终接收通知。',
    'LBL_NOTIFICATIONS_KEY_DESCR_BROWSER_DISABLED' => '有些浏览器，如 Internet Explorer，不支持通知。使用不支持通知的浏览器时，无法启用通知。',
    'LBL_NOTIFICATIONS_KEY_TITLE_EMAIL' => '为每个通知发送即时电子邮件警报',
    'LBL_NOTIFICATIONS_KEY_TITLE_DAILY' => '发送每日电子邮件摘要',
    'LBL_NOTIFICATIONS_KEY_TITLE_WEEKLY' => '发送每周电子邮件摘要',

    'LBL_NOTIFICATIONS_ERROR_MESSAGE_FAILEDSYNC' => '无法保存首选项。请检查系统连接，然后重试。',
    'LBL_NOTIFICATIONS_ERROR_MESSAGE_MISSING_REQUIRED' => '某些必填字段缺少值。请检查您的首选项，并确保填写了所有必填字段。',

    'LBL_HINT_PUSH_MESSAGES_PERMISSION' => '您将启用浏览器通知以获取 Sugar Hint Insights。点击确认继续。然后，浏览器将请求您允许接收通知事件。',
    'LBL_HINT_PUSH_ERROR' => '已在没有依赖项的情况下为 {{options.type}} 注册了推送通知插件。插件将无法正常工作，请确保提供工作文件的路径以及在服务器上保存订阅的方法。',

    'LBL_HINT_CONFIG_ENABLE_NOTIFICATIONS' => '为所有用户启用 Hint 通知',
    'LBL_HINT_CONFIG_DISABLE_NOTIFICATIONS' => '为所有用户关闭 Hint 通知',

    'LBL_HINT_SOFT_DISABLE_NOTIFICATIONS_FAILURE' => '警告：卸载 Sugar Hint 期间无法禁用通知。要禁用通知，请安装 Sugar Hint 5.4.0 或更高版本，然后使用 Sugar 的 “管理”部分中的 Sugar Hint 卸载程序执行完全卸载。',
    'LBL_HINT_ENRICH_ALL' => '丰富所有内容',
    'LBL_HINT_NO_LICENSE_ACCESS' => '需要提示许可证',


    //Maps
    'LBL_MAP_CONFIG_TITLE' => '映射配置',
    'LBL_MAP_CONFIG_GEOCODE_LOG_VIEWER' => '地理编码器日志查看器',
    'LBL_MAP_MAP' => '映射',
    'LBL_MAP_MAPS' => '地图',
    'LBL_MAP_GEOCODING_RECORD' => '地理编码',
    'LBL_MAP_GEOCODE_SUCCESS' => '记录已成功进行地理编码。',
    'LBL_MAP_LATITUDE' => '纬度',
    'LBL_MAP_LONGITUDE' => '经度',
    'LBL_MAP_SEARCH_BY_ADDRESS' => '按地址搜索...',
    'LBL_MAP_ALREADY_GEOCODED' => '当前记录已进行地理编码。是否确实要覆盖此记录的地理编码？',
    'LBL_MAPS_MANUAL_GEOCODING' => '手工地理编码',
    'LBL_MAP_POINT_COORDINATES' => '地图点坐标',
    'LBL_MAP_CALCULATING_DIRECTIONS' => '计算最优路径...',
    'LBL_MAP_DIRECTIONS' => '指示',
    'LBL_MAP_DIRECTIONS_FROM_USER' => '从当前用户开始的方向',
    'LBL_MAP_DIRECTIONS_FROM_RECORD' => '从此记录开始的方向',
    'LBL_MAPS_RADIUS_INPUT' => '半径（0-250）',
    'LBL_MAPS_IN_RADIUS_FROM_ZIP' => '在距离邮政编码的半径范围内',
    'LBL_MAPS_DISTANCE' => '距离',
    'LBL_MAPS_CENTER_ZIP_CODE' => '邮政编码',
    'LBL_MAPS_CONFIG_INVALID_MODULE_TITLE' => '无效配置： ',
    'LBL_MAPS_CONFIG_INVALID_MODULE' => '<strong>{{module}}</strong> 字段映射无效。',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_TYPE' => '映射类型',
    'LBL_MAP_DASHLET_CONFIGURE_MAP_ZOOM' => '缩放级别',
    'LBL_MAPS_DASHLET' => '地图',
    'LBL_MAPS_DASHLET_DESCRIPTION' => '在地图上显示地理编码记录。',
    'LBL_MAPS_DASHLET_MODULE_UNAVAILABLE' => '映射不适用于此模块。请在管理控制台中启用它。',
    'LBL_MAP_MODULES' => '模块',
    'LBL_MAP_FILTER_BY' => '筛选条件',
    'LBL_MAP_UNIT_TYPE' => '单位类型',
    'LBL_MAP_UNIT_TYPE_MILES' => '英里',
    'LBL_MAP_UNIT_TYPE_KM' => '千米',
    'LBL_MAP_ADDRESS' => '地址',
    'LBL_MAP_NO_STARTING_POINT' => '起点未进行地理编码。',
    'LBL_MAPS_MISSING_GEOCODING_START_POINT' => '起点记录未进行地理编码。',
    'LBL_MAPS_MISSING_GEOCODING_RECORDS' => '一些选定的记录未进行地理编码，因此也不会显示在地图上。',
    'LBL_MAPS_MISSING_GEOCODING_RECORD' => '记录未进行地理编码。',
    'LBL_MAPS_MODULE_FIELDS' => '模块字段',
    'LBL_MAPS_SELECT_FIELD' => '选择字段',
    'LBL_MAPS_RELATE_RECORD' => '相关记录',
    'LBL_MAPS_MAPPING_TYPE' => '映射类型',
    'LBL_MAPS_NO_GEOCODED_RECORDS' => '无地理编码记录',
    'LBL_MAPS_ADDRESS' => '地址',
    'LBL_MAPS_ASSIGNED_USER_NAME' => '指派的用户',
    'LBL_MAPS_STREET_VIEW_POINT_NOT_AVAILABLE' => '给定点的街道侧视图不可用',
    'LBL_MAPS_INVALID_MODULE' => '<strong>{0}</strong> 记录对映射无效。请从列表中删除该模块。',
    'LBL_MAPS_CLOSE_TOOLTIP' => '关闭',
    'LBL_MAPS_EXPAND_TOOLTIP' => '展开',
    'LBL_MAPS_SAVE_PDF_TOOLTIP' => '另存为 PDF',
    'LBL_MAPS_EMAIL_LINK' => '电子邮件链接',
    'LBL_MAPS_ONE_GEOCDED_RECORD_NEEDED' => '您必须至少有一条地理编码记录。',
    'LBL_MAPS_GENERATING' => '正在生成地图...',
    'LBL_MAPS_POINTS' => '映射点',
    'LBL_MAPS_POINT' => '点',
    'LBL_MAPS_TRAVEL_DETAILS' => '行进详情',
    'LBL_MAPS_TOTAL_DISTANCE' => '总距离',
    'LBL_MAPS_TOTAL_DURATION' => '总持续时间',
    'LBL_MAPS_TOTAL_DURATION_WITHOUT_TRAFIC' => '交通顺畅情况下总持续时间',
    'LBL_MAPS_ITINERARY' => '行程',
    'LBL_MAPS_TRAVEL_DISTANCE' => '行进距离',
    'LBL_MAPS_TRAVEL_DURATION' => '行进持续时间',
    'LBL_MAPS_TRAVEL_STEPS' => '步数',
    'LBL_MAPS_TRAVEL_WARNINGS' => '警告',
    'LBL_MAPS_MAX_GEOCDED_RECORD_EXCEDED' => '必应地图在共享地图上最多支持 10 个精确定位点。请检查您的选择。',
    'LBL_MAPS_NO_LICENSE_ACCESS' => '所需的地图许可证',
    'LBL_MAPS_SHARE_HELLO' => '您好,',
    'LBL_MAPS_SHARE_HEADER' => '您由于以下几点请求必应地图：',
    'LBL_MAPS_SHARE_OPEN_URL' => '以下网址将在必应地图上打开包含上述点的地图：',
    'LBL_MAPS_SHARE_SHOW_MAP' => '在必应地图上显示地图',
    'LBL_MAPS_MAP_ON_BING_WEB' => '必应地图',
    'LBL_MAPS_NO_VALID_ITINERARY' => '找不到所提供路径的路线。',
    'LBL_MAPS_GEOCODE_STATUS' => '地理编码状态',
    'LBL_MAPS_GEOCODED' => '地理编码',
    'LBL_MAPS_NOT_GEOCODED' => '没有地理编码',
    'LBL_MAPS_NOT_FOUND' => '地址无效',
    'LBL_MAPS_GEOCODING_FAILED' => '地理编码失败',
    'LBL_MAPS_QUEUED' => '排队',
    'LBL_MAPS_REQUEUED' => '重新排队',
    'LBL_MAPS_RELATED_RECORD' => '相关记录',

    //Report Dashlet
    'LBL_REPORT_DASHLET_CONFIG_VIEW_REPORT' => '查看报告',
    'LBL_REPORT_DASHLET_DESC' => '显示已保存的报告',
    'LBL_REPORT_DASHLET_RESET_DEFAULT' => '重置为Dashlet默认值',
    'LBL_REPORT_DASHLET_RESET_REPORT_DEFAULT' => '重置为报告默认值',
    'LBL_REPORT_DASHLET_REFRESH_RESULTS' => '刷新结果',
    'LBL_REPORT_DASHLET_COPY_CHART_CLIPBOARD' => '将图表复制到剪贴板',
    'LBL_REPORT_DASHLET_DOWNLOAD_CHART' => '下载图表',
    'LBL_REPORT_DASHLET_REST_TO_REPORT_DEFAULTS' => '已编辑 Dashlet {{label}} 的报告，并且 Dashlet 已重置为默认配置。',

    'LBL_NO_FIELD_PERMISSION_TO_FILTER' => '您无权使用此字段。',

    'LBL_INVALID_FORMULA' => '无效公式',
    'LBL_RETURN_TYPE_MISSMATCH' => '函数返回类型不匹配',

    'LBL_PREDICT_TOOLTIP' => 'SugarPredict',

    'LBL_AI_CONV_SCORE_CLASSIFICATION_FIELD' => '预测',
    'LBL_AI_ICP_FIT_SCORE_CLASSIFICATION_FIELD' => '理想客户特征',
    'LBL_AI_OPP_CLOSE_WEEK_SCORES' => '关闭周预测分数',
    'LBL_AI_CONV_SCORE_ABSOLUTE' => '预测值',
    'LBL_AI_CONV_BIN_ACCURACY' => '预测仓精度',
    'LBL_AI_CONV_MULTIPLIER' => '预测乘数',
    'LBL_AI_ICP_FIT_SCORE_ABSOLUTE' => 'ICP值',
    'LBL_AI_ICP_FIT_BIN_ACCURACY' => 'ICP Bin精度',
    'LBL_AI_ICP_FIT_MULTIPLIER' => 'ICP倍增器',
    'LBL_AI_NEW' => '新增功能',
    'LBL_AI_ENTERED' => '进入',
    'LBL_AI_CREATED' => '创建',
    'LBL_AI_WEEK' => '周',
    'LBL_AI_MONTH' => '月',
    'LBL_AI_QUARTER' => '季度',
    'LBL_AI_BYWEEK' => '按周',
    'LBL_AI_BYMONTH' => '按月',
    'LBL_AI_BYQUARTER' => '按季度',
    'LBL_AI_WEEKTREND' => '周趋势',
    'LBL_AI_MONTHLYTREND' => '月度趋势',
    'LBL_AI_QUARTERTREND' => '季度趋势',
    'LBL_AI_TREND' => '趋势',
    'LBL_AI_TRENDS' => '趋势',
    'LBL_AI_VELOCITY' => '速度',
    'LBL_AI_TOPX' => '返回页首 {X}',
    'LBL_AI_TIMESPAN' => '阶段之间的时间跨度 -',
    'LBL_AI_BUSINESSTREND' => '与商业趋势',
    'LBL_AI_SUGARINSIGHTINTRO' => '介绍 Sugar Insights！',
    'LBL_AI_SUGARINSIGHTSDESC' => 'Sugar Insights 利用定量分析来生成对 SugarCRM 数据的新见解。在 Sugar，我们一直在寻找新的方法来帮助您充分利用数据，做出明智的决策，而这只是我们希望通过 Sugar Insights 提供的功能的开始。',
    'LBL_AI_SUGARINSIGHTS_DASHLET_NAME' => 'Sugar Insights',
    'LBL_AI_SUGARINSIGHTS_DASHLET_DESC' => 'Sugar Insights 利用定量分析来生成对 SugarCRM 数据的新见解。',
    'LBL_AI_FIRMO' => '企业概要',
    'LBL_AI_TOTALCOUNT' => '总数',
    'LBL_AI_DAYSFROMLATESTACT' => '自上次以来的天数',
    'LBL_AI_DAYSSINCE' => '年龄',
    'LBL_AI_FIELDISSET' => '存在',
    'LBL_AI_CONTACTCOMPLETENESS' => '联系信息的完整性',
    'LBL_AI_CUTDATE' => '预测期',
    'LBL_AI_FROMLASTCHANGE' => '自上次要素值更改起的天数',
    'LBL_AI_CALLSHELD' => '保留的呼叫总数',
    'LBL_AI_CALLSPLANNED' => '计划的呼叫总数',
    'LBL_AI_OUTBOUNDCALLS' => '呼出呼叫总数',
    'LBL_AI_INBOUNDCALLS' => '呼入呼叫总数',
    'LBL_AI_AVGCALLDURATION' => '平均呼叫时长',
    'LBL_AI_EMAILSARCHIVED' => '已存档电子邮件的总数',
    'LBL_AI_EMAILSREAD' => '阅读的电子邮件总数',
    'LBL_AI_EMAILSSENT' => '发送的电子邮件总数',
    'LBL_AI_CLOSEDATEPUSHEDBACK' => '将预期结束日期更改为较晚日期的记录总数',
    'LBL_AI_CLOSEDATEPUSHEDFORWARD' => '将预期结束日期更改为更早日期的记录总数',
    'LBL_AI_AMOUNTINCREASED' => '金额增加的总机会',
    'LBL_AI_AMOUNTDECREASED' => '金额减少的总机会',

    // User last state
    'LBL_LAST_STATE' => '最后状态',
    // DocuSign
    'LBL_SEND_TO_DOCUSIGN_BUTTON_LABEL' => '发送到 DocuSign',
    'LBL_SHORTCUT_EDIT_RECIPIENT_CANCEL' => '取消编辑收件人',
    'LBL_RECIPIENT_ROLE' => '收件人角色',
    // Base sales stages
    'LBL_OPEN' => '打开',
    'LBL_CLOSED_WON' => '谈成结束',
    'LBL_CLOSED_LOST' => '丢单结束',
    'LBL_KIOSK_ADD_FILES' => '添加文件',
    'LBL_KIOSK_ADD_DROP_FILES' => '在此处添加或删除文件',
    'LBL_KIOSK_CANCEL' => '取消',
    'LBL_KIOSK_EDIT' => '编辑',
    'LBL_KIOSK_EMAIL' => '电子邮件',
    'LBL_KIOSK_FILES_UPLOADING' => '正在上传',
    'LBL_KIOSK_FILES_ERROR' => '附件上传失败',
    'LBL_KIOSK_FILES_ERROR_TOO_LARGE' => '附件太大',
    'LBL_KIOSK_FILTER_SEARCH' => '搜索',
    'LBL_KIOSK_ID' => 'ID',
    'LBL_KIOSK_TITLE' => '资讯亭',
    'LBL_KIOSK_LANGUAGE' => '语言',
    'LBL_KIOSK_LAST_UPDATED' => '上次更新',
    'LBL_KIOSK_LIST_VIEW_SELECTION' => '查看',
    'LBL_KIOSK_MENU' => '菜单',
    'LBL_KIOSK_MOBILE_PHONE' => '移动电话',
    'LBL_KIOSK_MY_ACTIVITIES' => '我的活动',
    'LBL_KIOSK_MY_PROFILE' => '我的个人资料',
    'LBL_KIOSK_NAME' => '姓名',
    'LBL_KIOSK_OFFICE_PHONE' => '办公电话',
    'LBL_KIOSK_ORGANIZATION' => '组织',
    'LBL_KIOSK_PAGINATION_FOOTER' => '每页行数：',
    'LBL_KIOSK_POWERED_BY_SUGARCRM' => '由SugarCRM提供支持',
    'LBL_KIOSK_SAVE_CHANGES' => '保存更改',
    'LBL_KIOSK_SHOW_HIDE' => '显示/隐藏',
    'LBL_KIOSK_SIGN_IN' => '登录',
    'LBL_KIOSK_SIGN_OUT' => '注销',
    'LBL_KIOSK_SORT_BY' => '排序标准',
    'LBL_KIOSK_SUBMIT' => '提交',
    'LBL_KIOSK_TIMEZONE' => '时区',
    'LBL_KIOSK_ACTIVITY' => '活动',
    'LBL_KIOSK_NO_ACTIVITY' => '没有要显示的活动',
    'LBL_KIOSK_OLDEST_FIRST' => '最旧的优先',
    'LBL_KIOSK_NEWEST_FIRST' => '最新的优先',
    'LBL_KIOSK_SHOW_MORE' => '显示更多',
    'LBL_KIOSK_ADD_A_REPLY' => '添加回复',
    'LBL_KIOSK_REPLY_EMPTY' => '回复不能留空。',
    'LBL_KIOSK_NUM_MORE' => '{{num}} 更多',
    'LBL_KIOSK_HOMEPAGE_WELCOME1' => '欢迎',
    'LBL_KIOSK_HOMEPAGE_WELCOME2' => '快速访问您的资源。',
    'LBL_KIOSK_HOMEPAGE_SEARCH_PLACEHOLDER' => '搜索案例',
    'LBL_KIOSK_SHOW_ALL' => '显示所有',
    'LBL_KIOSK_404_TITLE' => '我们找不到这个',
    'LBL_KIOSK_TENANT_404_TITLE' => '未找到租户',
    'LBL_KIOSK_404_MESSAGE' => '您点击的链接已被移除、暂时不可用或输入了无效的网址。',
    'LBL_KIOSK_TENANT_404_MESSAGE' => '请确保您拥有正确的网址。如需进一步帮助，请联系支持人员。',
    'LBL_KIOSK_BACK_TO_HOME' => '返回首页',
    'LBL_KIOSK_ERROR_CODE' => '{code} 错误： ',
    'LBL_KIOSK_401_TITLE' => '未授权',
    'LBL_KIOSK_401_MESSAGE' => '您无权查看此页面。',
    'LBL_KIOSK_403_TITLE' => '未授权',
    'LBL_KIOSK_403_MESSAGE' => '您无权查看此页面。',
    'LBL_KIOSK_500_TITLE' => '服务器无响应',
    'LBL_KIOSK_500_MESSAGE' => '我们这边出了点问题。',
    'LBL_KIOSK_GO_BACK' => '返回',
    'LBL_KIOSK_DUPLICATE_ERROR' => '找到重复记录',
    'LBL_KIOSK_ACCOUNT' => '帐户',
    'LBL_KIOSK_STATUS' => '状态',
    'LBL_KIOSK_DEACTIVATE' => '停用',
    'LBL_KIOSK_DEACTIVATE_SUCCESS' => '用户已被停用',
    'LBL_KIOSK_MANAGE_USERS' => '管理用户',
    'LBL_KIOSK_LAST_LOGIN' => '上次登录',
    'LBL_KIOSK_FIRST_NAME' => '名字',
    'LBL_KIOSK_LAST_NAME' => '姓氏',
    'LBL_KIOSK_ROLE' => '角色',
    'LBL_KIOSK_INVITE' => '邀请',
    'LBL_KIOSK_SEND_INVITES' => '发送邀请',
    'LBL_KIOSK_INVITE_USERS_SUCCESS' => '邀请已成功发送',
    'LBL_KIOSK_INVITE_USERS_FAILURE' => '邀请未发送',
    'LBL_KIOSK_REACTIVATE' => '重新激活',
    'LBL_KIOSK_REACTIVATE_SUCCESS' => '用户已重新激活',
    'LBL_KIOSK_RESET_PASSWORD' => '重置密码',
    'LBL_KIOSK_RESET_PASSWORD_SUCCESS' => '重置密码电子邮件已发送',
    'LBL_KIOSK_USER_PROFILE' => '用户资料',
    'LBL_KIOSK_401_USER_BLOCKED_MESSAGE' => '您的用户已被停用。请联系您的管理员。',
    'LBL_KIOSK_BACK_TO_LOGIN' => '返回登录',
    'LBL_KIOSK_REVOKE_INVITATION' => '撤销邀请',
    'LBL_KIOSK_REVOKE_INVITATION_SUCCESS' => '邀请已成功撤销',
    'LBL_KIOSK_SEARCH_AND_SELECT' => '搜索并选择......',
    'LBL_KIOSK_NO_MATCHES' => '未找到匹配项',
    'LBL_KIOSK_PROFILE_UPDATE_SUCCESS' => '配置文件已更新。',
    'LBL_KIOSK_PROFILE_UPDATE_ERROR' => '更新配置文件时出错。',
    'LBL_KIOSK_NOTES_SUBJECT_TITLE' => '回复：{caseSubject}',
    'LBL_KIOSK_DOCUMENTS' => '文档',
    'LBL_KIOSK_DOCUMENTS_DESC' => '查看、搜索和下载传入的共享文档。',
    'LBL_KIOSK_CASES' => '案例',
    'LBL_KIOSK_CASES_DESC' => '查看、搜索和回复与您共享的案例。',
    'LBL_KIOSK_DOWNLOAD' => '下载',
    'LBL_KIOSK_DOWNLOAD_SUCCESS' => '文件下载成功',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_TITLE' => '入门',
    'LBL_KIOSK_FIRST_TIME_LOGIN_MODAL_DESCRIPTION' => '为了更好地为您提供帮助，请向我们提供您的名字和姓氏。',
    'LBL_KIOSK_SAVE' => '保存',
    'LBL_KIOSK_SHARED' => '已共享',
    'LBL_KIOSK_HOMEPAGE_WELCOME1_PERSONAL' => '欢迎，{firstName} {lastInitial}。',
    'LBL_KIOSK_CONFIG_BACKGROUND_COLOR' => '背景颜色',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL' => '背景图片 URL',
    'LBL_KIOSK_CONFIG_BACKGROUND_IMG_URL_SUBTITLE' => '建议选择文件大小小于 400K 的图片。',
    'LBL_KIOSK_CONFIG_BACKGROUND_TYPE' => '背景类型',
    'LBL_KIOSK_CONFIG_HOME_TILE_TITLE' => '主页背景',
    'LBL_KIOSK_CONFIG_THEME_TILE_TITLE' => '主题',
    'LBL_KIOSK_CONFIG_THEME_PRIMARY_COLOR' => '主要主题颜色',
    'LBL_KIOSK_CONFIG_APP_NAME' => '应用名称',
    'LBL_KIOSK_CONFIG_APP_NAME_SUBTITLE' => '这是应用程序的标题，显示在徽标旁边。',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL' => '应用徽标 URL',
    'LBL_KIOSK_CONFIG_APP_LOGO_URL_SUBTITLE' => '建议选择最容易在小尺寸（例如，社交媒体资料）下查看的徽标。还建议文件大小小于 200K。',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL' => '应用网站图标 URL',
    'LBL_KIOSK_CONFIG_APP_FAVICON_URL_SUBTITLE' => '网站图标是一个小徽标，显示在浏览器选项卡中的页面标题旁边。',

    // Sugar Automate
    'LBL_UPDATE_ASSIGNEES' => '自动重新分配打开的活动',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_USER_LIMIT_REACHED' => '已达到用户限制',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_LICENSE_KEY' => '无效的许可证密钥',
    'LBL_CUSTOMER_JOURNEY_ERROR_INVALID_APPLICATION_LICENSE_KEY' => '无效的应用程序',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_LICENSE_KEY' => '无效的应用程序',
    'LBL_CUSTOMER_JOURNEY_ERROR_CORRUPT_VALIDATION_KEY' => '损坏的验证密钥',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_EXPIRED' => '许可证过期',
    'LBL_CUSTOMER_JOURNEY_ERROR_LICENSE_KEY_MISSING_INFO' => '缺少信息',
    'LBL_CUSTOMER_JOURNEY_ERROR_MISSING_VALIDATION_KEY' => '缺少验证密钥',
    'LBL_CUSTOMER_JOURNEY_ERROR_USER_MISSING_ACCESS' => '用户缺少访问权限',
    'LBL_DRI_WORKFLOW' => '智能指南',
    'LBL_DRI_WORKFLOWS' => '智能指南',
    'LBL_DRI_SUBWORKFLOW_TEMPLATE' => '智能指南阶段模板',
    'LBL_DRI_SUBWORKFLOW_TEMPLATES' => '智能指南阶段模板',
    'LBL_DRI_WORKFLOW_TEMPLATE' => '智能指南模板',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATE' => '智能指南活动模板',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES_SUBPANEL_TITLE' => '活动模板',
    'LBL_CJ_WEBHOOKS_SUBPANEL_TITLE' => '网络挂钩',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate 网络钩子',
    'LBL_CURRENT_CJ_ACTIVITY_AT' => '当前智能指南活动位置',
    'LBL_CJ_WEBHOOKS' => 'Sugar Automate 网络钩子',
    'LBL_CJ_WEBHOOK' => 'Sugar Automate 网络钩子',
    'LBL_CJ_FORMS_SUBPANEL_TITLE' => 'Sugar 操作',
    'LBL_CJ_FORMS' => 'Smart Guide Sugar 操作',
    'LBL_CJ_FORM' => 'Smart Guide Sugar 操作',
    'LBL_DRI_SUBWORKFLOW' => '智能指南阶段',
    'LBL_DRI_SUBWORKFLOWS' => '智能指南阶段',
    'LBL_DRI_WORKFLOW_TASK_TEMPLATES' => '智能指南活动模板',
    'LBL_DRI_WORKFLOW_TEMPLATES' => '智能指南模板',
    'LBL_DRI_WORKFLOW_SORT_ORDER' => '智能指南订单',
    'LBL_CJ_ACTUAL_SORT_ORDER' => '智能指南实际订单',
    'LBL_CUSTOMER_JOURNEY_SCORE' => '智能指南分数',
    'LBL_CJ_MOMENTUM_POINTS' => '智能导向动量点',
    'LBL_CJ_MOMENTUM_SCORE' => '智能指南动量分数',
    'LBL_CJ_ALLOW_ACTIVITY_BY' => '智能指南允许活动依据',
    'LBL_CUSTOMER_JOURNEY_PROGRESS' => '智能指南进度',
    'LBL_CJ_MOMENTUM_RATIO' => '智能导向动量比',
    'LBL_CUSTOMER_JOURNEY_POINTS' => '智能指南点',
    'LBL_CUSTOMER_JOURNEY_TYPE' => '智能指南任务',
    'LBL_CJ_PARENT_ACTIVITY_TYPE' => '智能指南父活动类型',
    'LBL_CUSTOMER_JOURNEY_BLOCKED_BY' => '智能指南被屏蔽的原因',
    'LBL_CJ_BLOCKED_BY_STAGES' => '智能指南被阶段屏蔽',
    'LBL_CJ_PARENT_ACTIVITY_ID' => '智能指南父活动 Id',
    'LBL_START_NEXT_JOURNEY_ID' => '启动下一个智能指南 Id',
    'LBL_CJ_URL' => '智能指南网址',
    'LBL_IS_CJ_PARENT_ACTIVITY' => '是智能指南父活动',
    'LBL_CJ_MOMENTUM_START_DATE' => '智能指南动量开始日期',
    'LBL_CJ_MOMENTUM_END_DATE' => '智能指南动量结束日期',
    'LBL_WIDGET_LAYOUT_CONFIGURATION_HEADER' => '小组件布局配置',
    'LBL_WIDGET_LAYOUT_CONFIGURATION' => '小组件布局配置',
    'CJ_SAME_JOURNEY_LIMIT_REACH_EXCEPTION' => '同一模板中智能指南的最大数量',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ACTIVE' => '活动的',
    'LBL_CUSTOMER_JOURNEY_WIDGET_ARCHIVE' => '已存档',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_SHOW' => '显示',
    'LBL_CUSTOMER_JOURNEY_STAGE_NUMBER_HIDE' => '隐藏',
    'LBL_CJ_PRESENTATION_MODE_VERTICAL' => '垂直模式',
    'LBL_CJ_PRESENTATION_MODE_HORIZONTAL' => '水平模式',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => '许可证无效',
    'LBL_ASSIGNMENT_NOTIFICATION_HTML' => '<div>
    <p>{{assigned_by}} 已将以下智能指南活动分配给 {{assigned_user}}。</p>
    <ul>{{activities}}</ul>
    
    <p>您可以在以下网址查看这些活动：<br/>
    <<a href=\\"{{module_link}}\\">{{module_link}}</a>></p>
    </div>',
    'LBL_CUSTOMER_JOURNEY_INVALID_LICENSE' => '许可证无效',
    'LBL_CJ_REMAINING_DAYS_WHEN_USER_LIMIT_REACHED' => '已达到用户限制，您有 {{gracePeriodDays}} 天的时间升级许可证。',
    'LBL_ASSIGNMENT_NOTIFICATION_SUBJECT' => 'SugarCRM - 指定的智能指南活动',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_DESCRIPTION' => '您的 Sugar Automate 用户限制已超出 {0}<br>
    <br>
    请联系 <a href=\\"mailto:customersuccess@sugarcrm.com\\">customersuccess@sugarcrm.com</a> 以提高用户限制或减少使用该插件的用户数量。',
    'LBL_CUSTOMER_JOURNEY_USER_LIMIT_REACHED_NAME' => 'Sugar Automate 已达到用户限制',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_DESCRIPTION' => '您的 Sugar Automate 许可证将在 {0} 天后到期。 <br>
    <br>
    请联系 SugarCRM 或您的 Sugar 合作伙伴进行续订并防止服务中断。',
    'LBL_CUSTOMER_JOURNEY_LICENSE_ABOUT_TO_EXPIRE_NAME' => 'Sugar Automate 许可证即将到期',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_TITLE' => '测试网络钩子',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide 进度',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => '显示 Sugar Automate “Smart Guide 进度”饼图。',
    'LBL_DEFAULT_TEST_WEB_HOOK_DASHLET_DESC' => '显示网络钩子响应',
    'LBL_DASHLET_SEND_LABEL' => '发送请求',
    'LBL_ASSIGN_ME_BUTTON_TITLE' => '分配给我',
    'LBL_COMPLETE_BUTTON_TITLE' => '完成',
    'LBL_COMPLETE_PARENT_BUTTON_TITLE' => '完成所有任务',
    'LBL_DELETE_STAGE_BUTTON_TITLE' => '删除阶段',
    'LBL_START_CYCLE_BUTTON_TITLE' => '开始',
    'LBL_NOT_APPLICABLE_BUTTON_TITLE' => '不适用',
    'LBL_ADD_STAGE_BUTTON_TITLE' => '添加阶段',
    'LBL_VIEW_JOURNEY_BUTTON_TITLE' => '查看',
    'LBL_EDIT_JOURNEY_BUTTON_TITLE' => '编辑 Smart Guide',
    'LBL_CANCEL_JOURNEY_BUTTON_TITLE' => '取消',
    'LBL_ARCHIVE_JOURNEY_BUTTON_TITLE' => '存档',
    'LBL_UNARCHIVE_JOURNEY_BUTTON_TITLE' => '取消存档',
    'LBL_CONFIGURE_TEMPLATE_BUTTON_TITLE' => '配置模板',
    'LBL_ADD_CJ_SUB_TASK_BUTTON_TITLE' => '添加任务',
    'LBL_ADD_CJ_SUB_MEETING_BUTTON_TITLE' => '安排会议',
    'LBL_ADD_CJ_SUB_CALL_BUTTON_TITLE' => '安排通话',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_FUTURE' => '在未来',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_OVERDUE' => '逾期',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TODAY' => '今天',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TOMORROW' => '明天',
    'LBL_CUSTOMER_JOURNEY_ACTIVITY_DUE_DATE_TEXT' => '{{fieldName}} {{status}}
    {{formatUser}} ({{fromNow}})',
    'LBL_CJ_CANCEL_CONFIRMATION' => '是否确定要取消此智能指南？',
    'LBL_CJ_COMPLETE_ALL_TASKS_CONFIRMATION' => '您即将完成所有任务。您确定要继续吗？',
    'LBL_CJ_BLOCK_BY' => '您有一个未解决的相关任务： {{Name}}。请在完成所有任务之前完成此任务。',
    'LBL_CJ_MULTIPLE_BLOCK_BY' => '您有多个未解决的相关任务。请在完成所有任务之前完成这些任务。',
    'LBL_CJ_COMPLETE_ALL_TASKS_COMPLETION' => '您已成功完成所有任务',
    'LBL_CJ_ARCHIVE_CONFIRMATION' => '是否确定要存档此智能指南？',
    'LBL_CJ_UNARCHIVE_CONFIRMATION' => '是否确定要取消存档此智能指南？',
    'LBL_CJ_AS_A_DASHLET' => 'Sugar Automate：智能指南（焦点抽屉和控制台）',
    'LBL_CJ_AS_A_DASHLET_DESC' => '在服务/续订控制台和焦点抽屉仪表板上查看有效的智能指南。',
    'LBL_CJ_PROCESSING_REQUEST' => '正在处理..',
    'LBL_CJ_SUCCESS' => '您已成功完成所有任务',
    'LBL_CUSTOMER_JOURNEY_MODULE_NOT_ENABLED' => '未启用 {module} 模块',
    'LBL_RECORDVIEW_DISPLAY_SETTINGS_SAVED' => '保存所有显示设置。',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_TITLE' => '智能指南动量',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_MOMENTUM_DASHLET_DESC' => '显示 Sugar Automate “智能指南动量”量表图表。',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_TITLE' => 'Smart Guide 进度',
    'LBL_DEFAULT_DRI_CUSTOMER_JOURNEY_DASHLET_DESC' => '显示 Sugar Automate “Smart Guide 进度”饼图。',
    'CJ_PARENT_NOT_FOUND_EXCEPTION' => '找不到父项',
    'CJ_NOT_FOUND_EXCEPTION' => '找不到 {moduleName} {data}',
    'CJ_JOURNEY_NOT_COMPLETED_EXCEPTION' => '智能指南必须在存档前完成或取消',
    'LBL_CUSTOMER_JOURNEY_LICENSE_LOAD_ERROR' => 'Sugar Automate 在当前 Sugar 许可证中未启用',
    'LBL_ACTION_NOT_FOUND' => '找不到操作，请联系系统管理员',
    'LBL_CJ_SELECT_FIELD' => '选择字段',
    'LBL_CJ_SELECT_OPERATOR' => '选择操作员',
    'LBL_CJ_SELECT_VALUE' => '选择值',
    'LBL_CJ_ENTER_VALUE' => '输入值',
    'LBL_CJ_FORM_BATCH_TITLE' => '保存记录',
    'LBL_CJ_FORM_BATCH_ACTIVE_SMART_GUIDES_DETECTED' => '检测到活动 Smart Guides......',
    'LBL_CJ_FORM_BATCH_PROCESSING_ACTIVE_SUGAR_ACTIONS' => '处理活动 Sugar 操作......',
    'LBL_CJ_FORM_BATCH_UPDATING_ACTIVE_SMART_GUIDES' => '正在更新活动的 Smart Guides......',
    'LBL_CJ_FORM_BATCH_SUCCESS' => '记录和关联的 Smart Guides 已成功更新。',
    'LBL_CJ_FORM_BATCH_FAILURE' => '关联的 Smart Guides 无法更新。如果错误仍然存在，请联系您的 Sugar 管理员寻求帮助。',
    'LBL_CJ_FORM_BATCH_FAILURE_FOR_ADMIN' => '关联的 Smart Guides 无法更新。请查看 <a href="index.php?action=LogView&module=Configurator&doaction=all&filter=Sugar+Actions+:+Sugar+Action+to+Smart+Guide" target="_blank">日志</a> 以排查错误。',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS' => '<a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} 已成功链接。',
    'LBL_CJ_ACTIVITY_LINK_ERROR' => '链接 <a href="#{{module}}/{{id}}">{{name}}</a> {{moduleSingularLower}} 存在问题。如果问题持续存在，请联系 Sugar 支持。',
    'LBL_CJ_ACTIVITY_LINK_SUCCESS_PLURAL' => '{{modulePluralLower}} 已成功链接。',
    'LBL_CJ_ACTIVITY_LINK_ERROR_PLURAL' => '链接 {{modulePluralLower}} 存在问题。如果问题持续存在，请联系 Sugar 支持。',
    'LBL_CJ_ACTIVITY_LINK_ERROR_GENERIC' => '链接 {{moduleSingularLower}} 存在问题。如果问题持续存在，请联系 Sugar 支持。',
    'LBL_CJ_ACTIVITY_DUPLICATE_EXISTING' => '在 {{stage}} 阶段中已经有一个名为 <a href="#{{module}}/{{id}}">{{name}}</a> 的 {{moduleSingularLower}} 。',
    'LBL_CJ_ACTIVITY_DUPLICATE_SELECTED' => '已选中名为 <a href="#{{module}}/{{id}}">{{name}}</a> 的 {{moduleSingularLower}} 。',
    'LBL_CJ_ARCHIVED' => '已存档',
    'LBL_SELECT_SMART_GUIDE_TEMPLATE_PLACEHOLDER' => '选择 Smart Guide 模板......',
    'LBL_ALL_SMART_GUIDES' => '所有 Smart Guides',
    'LBL_ACTIVE_SMART_GUIDES' => '不活动的 Smart Guides',
    'LBL_ARCHIVED_SMART_GUIDES' => '存档的 Smart Guides',
    'LBL_VERTICAL_SCROLL_VIEW' => '纵向堆叠视图',
    'LBL_HORIZONTAL_SCROLL_VIEW' => '横向滚动视图',
    'LBL_DRI_WORKFLOWS_FILTER' => '筛选器',
    'LBL_ACTIVITY_STATUS_READ_ONLY' => '此操作无法完成。此活动模块的“状态”字段设置为“只读”，这阻止了更新“状态”字段的所有 Smart Guide 操作。',
    'LBL_CHILD_ACTIVITY_STATUS_READ_ONLY' => '此操作无法完成。此活动和/或子活动模块的“状态”字段设置为“只读”，这阻止了更新“状态”字段的所有 Smart Guide 操作。',
    'LBL_GUIDE_CANCELLATION_ACTION_ACTIVITY_STATUS_READ_ONLY' => '指南中部分活动模块的“状态”字段设置为“只读”，这些活动在指南取消时将保持不变。',

    // more MOBILE stuff
    'LBL_MOBILE_COPIED_TO_CLIPBOARD' => '已复制到剪贴板。',
    'LBL_MOBILE_DELETE_ALL_OCCURRENCES' => '删除所有重复出现内容',
    'ERROR_RECURRENCE_EVENT_PARAMS' => '无效的重复出现内容设置',
    'ERROR_INTERVAL_INVALID' => '重复间隔时间必须介于 1 和 99 之间',
    'LBL_RECURRENCE_ADD' => '配置',
    'LBL_REPEAT_DAYS' => '每月天数',
    'LBL_REPEAT_END_TYPES' => '重复',
    'LBL_MOBILE_DEFAULT_MAPS_APP' => '导航提供商',
    'LBL_MOBILE_PDF_EMAIL' => '电子邮件 {{{pdfTemplateName}}} PDF',
    'LBL_MOBILE_EMAIL_SENDING' => '发送中',
    'LBL_MOBILE_EMAIL_SENT' => '已发送',
    'LBL_MOBILE_EMAIL_SAVED_DRAFT' => '电子邮件另存为草稿。',
    'LBL_MOBILE_EMAIL_CHOOSE_ATTACHMENT' => '添加附件',
    'LBL_MOBILE_EMAIL_LOCAL_ATTACHMENT' => '从本地上传',
    'LBL_MOBILE_EMAIL_SUGAR_DOCUMENT_ATTACHMENT' => 'Sugar 文档',
    'LBL_DROPDOWN_VIEW_CHANGE_INFO' => '您选择的下拉列表值更改了记录视图布局。',
    'LBL_MOBILE_RELEASE_NOTE_ALL' => 'SugarCRM 移动应用程序发行说明',
    'LBL_MOBILE_USER_GUIDE_ALL' => 'SugarCRM 移动应用程序用户指南',
    'ERR_MOBILE_ROOTED' => 'Sugar Mobile 不能在已 Root 的移动设备上使用。请在未 Root 的设备上打开应用程序。',
    'LBL_VO_BUILD_ROUTE' => '构建路径',
    'LBL_FILTER_MY_DISTANCE_FILTER' => '我的距离筛选器',
    'LBL_ACTIONBUTTON_DOC_MERGE_STARTED' => '文档将在后台生成。打开“文档合并”页面，访问该文件。',
    'LBL_ACTIONBUTTON_DOC_MERGE_NO_TEMPLATE' => '无法获取模板。请联系管理员以获取帮助。',
    'LBL_MAP_ERROR_LOAD' => '无法加载地图',
    'LBL_MAP_DISTANCE' => '距离',
    'LBL_SELECT_UNIT_TYPE' => '单位类型',
    'LBL_MAPS_UNIT_MILES' => '英里',
    'LBL_MAPS_UNIT_KILOMETERS' => '千米',
    'LBL_RADIUS' => '半径',
    'LBL_ZIP_CODE' => '邮政编码',
    'LBL_MOBILE_CHOOSE_ADDRESS' => '选择地址',
    'LBL_MOBILE_ADDRESS_NOT_GEOCODED' => '无法从地址创建地理代码：{{{address}}}',
    'LBL_MOBILE_GEOCODE_SAVE_ERROR' => '记录未进行地理编码。',
    'LBL_MOBILE_GEOCODE_MANUAL_CONFIRM' => '记录不包含任何地址数据。是否要在地图上手动定位此记录？',
    'LBL_ERR_SHOW_ON_MAP' => '无法打开所选记录的地图。',
    'LBL_ERR_MISSING_ON_MAP' => '一些记录缺少地址数据，没有显示出来',
    'LBL_MAPS_ROUTE' => '路径',
    'LBL_MAPS_PROVIDER' => 'Sugar 地图',
    'LBL_MAPS_CURRENT_LOC_ERROR' => '无法确定当前位置。',
    'LBL_MAPS_MAX_COLLECTION_LENGTH' => '最多支持 {{{num}}} 条记录用于映射。',
    'LBL_ALL_MODULES' => '所有模块',
    'LBL_DRIVE_SHARE_LINK' => '共享链接',
    'LBL_DRIVE_LOAD_FILES_ERROR' => '无法加载文件。',
    'LBL_DRIVE_NAME_EMPTY_ERROR' => '名称不能为空',
    'LBL_DRIVE_FOLDER_CREATED' => '文件夹已创建。',
    'LBL_DRIVE_FOLDER_CREATE_ERROR' => '无法创建文件夹。',
    'LBL_DRIVE_FILE_UPLOAD_ERROR' => '无法上传文件。',
    'LBL_DRIVE_NO_ROOT_FOLDER' => '请先创建根文件夹',
    'LBL_EDIT_ALL_RECURRENCES' => '编辑所有重复周期',
    'LBL_DROPBOX_FILE_NOT_AVAILABLE' => '无法在 Dropbox 中打开文件',
    'LBL_FILE_NOT_AVAILABLE' => '无法打开文件',
    'LBL_MAP_ROUTE_FROM_A_CURRENT_RECORD' => '方向',
    'LBL_MAPS_ROUTE_NOT_FOUND' => '找不到所提供路径的路线',
    'LBL_MAPS_IN_RADIUS_FROM_CURRENT_LOCATION' => '附近',
    'LBL_TAGS' => '标签',

    'LBL_CALLER_ID_SETTINGS' => '来电显示设置',
    'LBL_CALLER_ID_ENABLED' => '来电显示已启用',
    'LBL_CALLER_ID_ENABLED_TEXT' => '在传入呼叫中，将显示与电话号码匹配的联系人或潜在客户的姓名。',
    'LBL_CALLER_ID_SETTINGS_HINT_IOS' => '要允许移动应用显示来电显示，请在您的设备上按照以下步骤操作：<br><br>1. 打开 iOS 设置 > 电话 > 呼叫阻止和识别。<br>2. 启用”{{{brandName}}}"。',
    'LBL_CALLER_ID_SETTINGS_HINT_ANDROID' => '要允许移动应用显示来电显示，请在您的设备上按照以下步骤操作：<br>1. 打开应用程序设置。<br>2. 转到权限。<br>3. 启用电话权限。<br><br> 若要将此应用程序设置为默认的来电显示处理程序，请转到设备设置。<br>1. 导航到应用程序。<br>2. 选择默认应用程序。<br>3. 选择来电显示和垃圾邮件应用程序。<br>4. 选择此应用程序作为默认选项。',
    'LBL_CALLER_ID_SYNC_HINT' => '检查 Sugar 实例中记录（例如联系人、潜在客户）中联系人信息的更改。',
    'LBL_CALLER_ID_GO_TO_SETTINGS' => '转到“设置”',
    'LBL_CALLER_ID_SYNC' => '同步记录数据',
    'LBL_CALLER_ID_NOT_ENABLED' => '同步之前，必须在系统设置中启用来电显示。',
    'LBL_CALLER_ID_SETUP_ENABLE' => '启用',
    'LBL_CALLER_ID_SETUP_LATER_IN_SETTINGS' => '稍后在设置中',
    'LBL_CALLER_ID_SETUP_HINT_ANDROID' => '此应用程序支持来电显示功能。<br> 为了此功能正常运行，按下启用按钮后，系统将提示您授予两个权限。<br> 若要确保来电显示功能正常工作，您需要授予管理呼叫的权限，并选择此应用程序作为默认来电显示处理程序。<br> 如果不授予管理呼叫的权限，则也无法记录从应用程序发出的呼叫。',
    'LBL_CALLER_ID_SETUP_HINT_IOS' => '要允许 SugarCRM 移动应用显示来电显示，请在您的设备上按照以下步骤操作：<br><br>1. 打开 iOS 设置 > 电话 > 呼叫阻止和识别。<br>2. 启用应用程序。',
    'LBL_MOBILE_LAST_SYNC' => '上次同步',
    'LBL_CALLER_ID_SYNCING' => '与服务器同步。',
    'LBL_NEVER' => '从不',
    'LBL_RLI_MISSING_ERROR' => '{{{moduleName}}} 不能为空。',
    'LBL_ADD_RELATED_RECORD' => '相关 {{{moduleSingular}}}',
    'LBL_CALLER_ID_NO_PERMISSION' => '您没有使用来电显示所需的权限。请联系您的管理员。',
    'LBL_CALLER_ID_FETCHING' => '同步……',
    'LBL_CALLER_ID_FETCH_ALL' => '重新同步所有记录',
    'LBL_CALLER_ID_FETCH_NEW' => '检查记录更新',

    'LBL_SORT_BY' => '排序方式',
    'LBL_PRIMARY_SORT' => '主要排序',
    'LBL_SECONDARY_SORT' => '次要排序',
    'LBL_OF' => '的',
    'LBL_TABLE_FREEZE_FIRST' => '冻结第一列',
    'LBL_TABLE_SETTINGS_TITLE' => '列视图选项',
    'LBL_TABLE_SETTINGS_NO_COL' => '必须至少选择一列。',
    'LBL_TABLE_TOGGLER_INFO' => '显示或隐藏列，并将它们拖动到您喜欢的顺序。',
    'LBL_RUNTIME_FILTERS_TITLE' => '运行时筛选器',
    'LBL_FILTER_CONDITION' => '选择条件',
    'LBL_FILTER_VALUES' => '值',
    'LBL_TABLE_EXPAND' => '全部展开',
    'LBL_TABLE_COLLAPSE' => '全部折叠',
    'LBL_RUNTIME_FILTERS_DEFAULT' => '服务器错误。无法加载相关的运行时筛选器。',

    // Pub/Sub
    'LBL_PUBSUB_MODULEEVENT_PUSHSUBS' => '发布/订阅模块事件推送订阅',
    'LBL_PUBSUB_MODULEEVENT_PUSHSUB' => '发布/订阅模块事件推送订阅',
];

$app_list_strings['configure_record_view_display_dom'] = [
    'panel_top' => '面板 - 顶部',
    'panel_bottom' => '面板 - 底部',
    'tab_first' => '选项卡 - 第一个',
    'tab_last' => '选项卡 - 最后一个',
];

$app_list_strings['activity_user_options'] = [
    '7' => '最近 7 天',
    '30' => '最近 30 天',
    '90' => '上个季度',
];

$app_list_strings['http_type_protocol_options'] = [
    'http' => 'http',
    'https' => 'https',
];

$app_list_strings['planned_activities_filter_options'] = [
    'today' => '今天',
    'future' => '新值',
];

$app_list_strings['planned_activities_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['planned_activities_visibility_options'] = [
    'user' => '是',
    'group' => '否',
];

$app_list_strings['history_filter_options'] = [
    7 => '最近 7 天',
    30 => '最近 30 天',
    90 => '上个季度',
];

$app_list_strings['history_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['history_visibility_options'] = [
    'user' => '是',
    'group' => '否',
];

$app_list_strings['tasks_limit_options'] = [
    5 => 5,
    10 => 10,
    15 => 15,
    20 => 20,
];

$app_list_strings['tasks_visibility_options'] = [
    'user' => '是',
    'group' => '否',
];

$app_list_strings['list_visibility_options'] = [
    '1' => '是',
    '0' => '否',
];

$app_list_strings['generic_timeperiod_options'] = [
    'current' => '本季度',
    'next' => '下个季度',
    'year' => '今年',
];

// see sugarcrm/clients/base/views/bubblechart/bubblechart.php
$app_list_strings['top10_opportunities_visibility_options'] = [
    'user' => '我的记录',
    'group' => '团队的记录',
];
$app_list_strings['forecast_pipeline_visibility_options'] = [
    'user' => '我的管道',
    'group' => '我团队的管道',
];
$app_list_strings['forecast_pareto_visibility_options'] = [
    'user' => '我的预测',
    'group' => '我团队的预测',
];

$app_list_strings['opps_config_view_by_options_dom'] = [
    'Opportunities' => '商业机会',
    'RevenueLineItems' => '商业机会和营收单项',
];

$app_list_strings['opps_config_view_by_closedate_rollup_dom'] = [
    'latest' => '最新截止日期',
    'earliest' => '最早截止日期',
];

$app_list_strings['moduleList']['Library'] = '库';
$app_list_strings['moduleListSingular']['Library'] = '库';
$app_list_strings['library_type'] = ['Books' => '书籍', 'Music' => '音乐', 'DVD' => 'DVD', 'Magazines' => '杂志'];
$app_list_strings['moduleList']['EmailAddresses'] = '电子邮件地址';
$app_list_strings['moduleListSingular']['EmailAddresses'] = '电子邮件地址';

$app_list_strings['kbdocument_status_dom'] = [
    'draft' => '草稿',
    'in-review' => '检查中',
    'approved' => '已批准的',
    'published' => '已发布',
    'expired' => '失效',
];

$app_list_strings['kbadmin_actions_dom'] =
    [
        '' => '--管理员动作--',
        'Create New Tag' => '创建新标签',
        'Delete Tag' => '删除标签',
        'Rename Tag' => '重命名标签',
        'Move Selected Articles' => '移动选择的文章',
        'Apply Tags On Articles' => '把标签应用于文章',
        'Delete Selected Articles' => '删除选择的文章',
    ];

$app_list_strings['moduleList']['Words'] = '文字';
$app_list_strings['moduleListSingular']['Words'] = 'Words';
$app_strings['LBL_CREATE_KB_DOCUMENT'] = '创建文章';

$app_list_strings['countries_dom'] = [
    '' => '',
    'ABU DHABI' => '阿布扎比',
    'ADEN' => '亚丁',
    'AFGHANISTAN' => '阿富汗',
    'ALBANIA' => '阿尔巴尼亚',
    'ALGERIA' => '阿尔及利亚',
    'AMERICAN SAMOA' => '美属萨摩亚',
    'ANDORRA' => '安道尔',
    'ANGOLA' => '安哥拉',
    'ANTARCTICA' => '南极洲',
    'ANTIGUA' => '安提瓜',
    'ARGENTINA' => '阿根廷',
    'ARMENIA' => '亚美尼亚',
    'ARUBA' => '阿鲁巴',
    'AUSTRALIA' => '澳大利亚',
    'AUSTRIA' => '奥地利',
    'AZERBAIJAN' => '阿塞拜疆',
    'BAHAMAS' => '巴哈马',
    'BAHRAIN' => '巴林',
    'BANGLADESH' => '孟加拉国',
    'BARBADOS' => '巴巴多斯',
    'BELARUS' => '白俄罗斯',
    'BELGIUM' => '比利时',
    'BELIZE' => '伯利兹',
    'BENIN' => '贝宁',
    'BERMUDA' => '百慕大',
    'BHUTAN' => '不丹',
    'BOLIVIA' => '玻利维亚',
    'BOSNIA' => '波斯尼亚',
    'BOTSWANA' => '博茨瓦纳',
    'BOUVET ISLAND' => '布维岛',
    'BRAZIL' => '巴西',
    'BRITISH ANTARCTICA TERRITORY' => '英国南极洲领土',
    'BRITISH INDIAN OCEAN TERRITORY' => '英属印度洋领地',
    'BRITISH VIRGIN ISLANDS' => '英属维尔京群岛',
    'BRITISH WEST INDIES' => '英属西印度群岛',
    'BRUNEI' => '文莱',
    'BULGARIA' => '保加利亚',
    'BURKINA FASO' => '布吉纳法索',
    'BURUNDI' => '布隆迪',
    'CAMBODIA' => '柬埔寨',
    'CAMEROON' => '喀麦隆',
    'CANADA' => '加拿大',
    'CANAL ZONE' => '运河区',
    'CANARY ISLAND' => '加纳利岛',
    'CAPE VERDI ISLANDS' => '哥连臣角威尔第群岛',
    'CAYMAN ISLANDS' => '开曼群岛',
    'CEVLON' => ' 锡兰',
    'CHAD' => '乍得',
    'CHANNEL ISLAND UK' => '频道岛屋',
    'CHILE' => '智利',
    'CHINA' => '中国',
    'CHRISTMAS ISLAND' => '圣诞岛',
    'COCOS (KEELING) ISLAND' => '科科斯（基林）岛',
    'COLOMBIA' => '哥伦比亚',
    'COMORO ISLANDS' => '科摩罗群岛',
    'CONGO' => '刚果',
    'CONGO KINSHASA' => '刚果金沙萨',
    'COOK ISLANDS' => '库克群岛',
    'COSTA RICA' => '哥斯达黎加',
    'CROATIA' => '克罗地亚',
    'CUBA' => '古巴',
    'CURACAO' => '库拉索',
    'CYPRUS' => '塞浦路斯',
    'CZECH REPUBLIC' => '捷克共和国',
    'DAHOMEY' => '达荷美',
    'DENMARK' => '丹麦',
    'DJIBOUTI' => '吉布提',
    'DOMINICA' => '多米尼加',
    'DOMINICAN REPUBLIC' => '多米尼加共和国',
    'DUBAI' => '迪拜',
    'ECUADOR' => '厄瓜多尔',
    'EGYPT' => '埃及',
    'EL SALVADOR' => '萨尔瓦多',
    'EQUATORIAL GUINEA' => '赤道几内亚',
    'ESTONIA' => '爱沙尼亚',
    'ETHIOPIA' => '埃塞俄比亚',
    'FAEROE ISLANDS' => '法罗群岛',
    'FALKLAND ISLANDS' => '福克兰群岛',
    'FIJI' => '斐济',
    'FINLAND' => '芬兰',
    'FRANCE' => '法国',
    'FRENCH GUIANA' => '法属圭亚那',
    'FRENCH POLYNESIA' => '法属波利尼西亚',
    'GABON' => '加蓬',
    'GAMBIA' => '冈比亚',
    'GEORGIA' => '乔治亚州',
    'GERMANY' => '德国',
    'GHANA' => '加纳',
    'GIBRALTAR' => '直布罗陀',
    'GREECE' => '希腊',
    'GREENLAND' => '格陵兰岛',
    'GUADELOUPE' => '瓜德罗普岛',
    'GUAM' => '关岛',
    'GUATEMALA' => '危地马拉',
    'GUINEA' => '几内亚',
    'GUYANA' => '圭亚那',
    'HAITI' => '海地',
    'HONDURAS' => '洪都拉斯',
    'HONG KONG' => '香港',
    'HUNGARY' => '匈牙利',
    'ICELAND' => '冰岛',
    'IFNI' => '伊夫尼',
    'INDIA' => '印度',
    'INDONESIA' => '印度尼西亚',
    'IRAN' => '伊朗',
    'IRAQ' => '伊拉克',
    'IRELAND' => '爱尔兰',
    'ISRAEL' => '以色列',
    'ITALY' => '意大利',
    'IVORY COAST' => '象牙海岸',
    'JAMAICA' => '牙买加',
    'JAPAN' => '日本',
    'JORDAN' => '约旦',
    'KAZAKHSTAN' => '哈萨克斯坦',
    'KENYA' => '肯尼亚',
    'KOREA' => '韩国',
    'KOREA, SOUTH' => '南朝鲜',
    'KUWAIT' => '科威特',
    'KYRGYZSTAN' => '吉尔吉斯斯坦',
    'LAOS' => '老挝',
    'LATVIA' => '拉脱维亚',
    'LEBANON' => '黎巴嫩',
    'LEEWARD ISLANDS' => '背风群岛',
    'LESOTHO' => '莱索托',
    'LIBYA' => '利比亚',
    'LIECHTENSTEIN' => '列支敦士登',
    'LITHUANIA' => '立陶宛',
    'LUXEMBOURG' => '卢森堡',
    'MACAO' => '澳门',
    'MACEDONIA' => '马其顿',
    'MADAGASCAR' => '马达加斯加',
    'MALAWI' => '马拉维',
    'MALAYSIA' => '马来西亚',
    'MALDIVES' => '马尔代夫',
    'MALI' => '马里',
    'MALTA' => '马耳他',
    'MARTINIQUE' => '马提尼克岛',
    'MAURITANIA' => '毛里塔尼亚',
    'MAURITIUS' => '毛里求斯',
    'MELANESIA' => '美拉尼西亚',
    'MEXICO' => '墨西哥',
    'MOLDOVIA' => '摩尔多瓦',
    'MONACO' => '摩纳哥',
    'MONGOLIA' => '蒙古',
    'MOROCCO' => '摩洛哥',
    'MOZAMBIQUE' => '莫桑比克',
    'MYANAMAR' => '缅甸',
    'NAMIBIA' => '纳米比亚',
    'NEPAL' => '尼泊尔',
    'NETHERLANDS' => '荷兰',
    'NETHERLANDS ANTILLES' => '荷属安的列斯群岛',
    'NETHERLANDS ANTILLES NEUTRAL ZONE' => '荷属安的列斯群岛中立区',
    'NEW CALADONIA' => '新加多利亚',
    'NEW HEBRIDES' => '新赫布里底',
    'NEW ZEALAND' => '新西兰',
    'NICARAGUA' => '尼加拉瓜',
    'NIGER' => '尼日尔',
    'NIGERIA' => '尼日利亚',
    'NORFOLK ISLAND' => '诺福克岛',
    'NORWAY' => '挪威',
    'OMAN' => '阿曼',
    'OTHER' => '其他',
    'PACIFIC ISLAND' => '太平洋岛国',
    'PAKISTAN' => '巴基斯坦',
    'PANAMA' => '巴拿马',
    'PAPUA NEW GUINEA' => '巴布亚新几内亚',
    'PARAGUAY' => '巴拉圭',
    'PERU' => '秘鲁',
    'PHILIPPINES' => '菲律宾',
    'POLAND' => '波兰',
    'PORTUGAL' => '葡萄牙',
    'PORTUGUESE TIMOR' => '葡萄牙帝汶',
    'PUERTO RICO' => '波多黎各',
    'QATAR' => '卡塔尔',
    'REPUBLIC OF BELARUS' => '白俄罗斯共和国',
    'REPUBLIC OF SOUTH AFRICA' => '南非共和国',
    'REUNION' => '留尼汪岛',
    'ROMANIA' => '罗马尼亚',
    'RUSSIA' => '俄罗斯',
    'RWANDA' => '卢旺达',
    'RYUKYU ISLANDS' => '琉球群岛',
    'SABAH' => '沙巴',
    'SAN MARINO' => '圣马力诺',
    'SAUDI ARABIA' => '沙特阿拉伯',
    'SENEGAL' => '塞内加尔',
    'SERBIA' => '塞尔维亚',
    'SEYCHELLES' => '塞舌尔',
    'SIERRA LEONE' => '塞拉利昂',
    'SINGAPORE' => '新加坡',
    'SLOVAKIA' => '斯洛伐克',
    'SLOVENIA' => '斯洛文尼亚',
    'SOMALILIAND' => '索马里兰',
    'SOUTH AFRICA' => '南非',
    'SOUTH YEMEN' => '南也门',
    'SPAIN' => '西班牙',
    'SPANISH SAHARA' => '西班牙撒哈拉',
    'SRI LANKA' => '斯里兰卡',
    'ST. KITTS AND NEVIS' => '圣基茨和尼维斯',
    'ST. LUCIA' => '圣露西娅',
    'SUDAN' => '苏丹',
    'SURINAM' => '苏里南',
    'SW AFRICA' => '西南非洲',
    'SWAZILAND' => '斯威士兰',
    'SWEDEN' => '瑞典',
    'SWITZERLAND' => '瑞士',
    'SYRIA' => '叙利亚',
    'TAIWAN' => '台湾',
    'TAJIKISTAN' => '塔吉克斯坦',
    'TANZANIA' => '坦桑尼亚',
    'THAILAND' => '泰国',
    'TONGA' => '汤加',
    'TRINIDAD' => '特立尼达拉岛',
    'TUNISIA' => '突尼斯',
    'TURKEY' => '土耳其',
    'UGANDA' => '乌干达',
    'UKRAINE' => '乌克兰',
    'UNITED ARAB EMIRATES' => '阿拉伯联合酋长国',
    'UNITED KINGDOM' => '英国',
    'UPPER VOLTA' => '上沃尔特',
    'URUGUAY' => '乌拉圭',
    'US PACIFIC ISLAND' => '美军太平洋岛屿',
    'US VIRGIN ISLANDS' => '美属维尔京群岛',
    'USA' => '美国',
    'UZBEKISTAN' => '乌兹别克斯坦',
    'VANUATU' => '瓦努阿图',
    'VATICAN CITY' => '梵蒂冈城',
    'VENEZUELA' => '委内瑞拉',
    'VIETNAM' => '越南',
    'WAKE ISLAND' => '威克岛',
    'WEST INDIES' => '西印度群岛',
    'WESTERN SAHARA' => '西撒哈拉',
    'YEMEN' => '也门',
    'ZAIRE' => '扎伊尔',
    'ZAMBIA' => '赞比亚',
    'ZIMBABWE' => '津巴布韦',
];

$app_list_strings['state_dom'] = [
    'AL' => '阿拉巴马州',
    'AK' => '阿拉斯加',
    'AZ' => '亚利桑那州',
    'AR' => '阿肯色州',
    'CA' => '加利福尼亚州',
    'CO' => '科罗拉多州',
    'CT' => '康涅狄格州',
    'DE' => '特拉华州',
    'DC' => '哥伦比亚特区',
    'FL' => '佛罗里达州',
    'GA' => '乔治亚州',
    'HI' => '夏威夷',
    'ID' => '爱达荷州',
    'IL' => '伊利诺伊州',
    'IN' => '印第安纳州',
    'IA' => '爱荷华州',
    'KS' => '堪萨斯州',
    'KY' => '肯塔基州',
    'LA' => '路易斯安那州',
    'ME' => '缅因州',
    'MD' => '马里兰州',
    'MA' => '马萨诸塞州',
    'MI' => '密歇根州',
    'MN' => '明尼苏达州',
    'MS' => '密西西比州',
    'MO' => '密苏里州',
    'MT' => '蒙大拿州',
    'NE' => '内布拉斯加州',
    'NV' => '内华达州',
    'NH' => '新罕布什尔州',
    'NJ' => '新泽西州',
    'NM' => '新墨西哥州',
    'NY' => '纽约州',
    'NC' => '北卡罗莱纳州',
    'ND' => '北达科他州',
    'OH' => '俄亥俄州',
    'OK' => '俄克拉荷马州',
    'OR' => '俄勒冈州',
    'PA' => '宾夕法尼亚州',
    'RI' => '罗德岛州',
    'SC' => '南卡罗莱纳州',
    'SD' => '南达科他州',
    'TN' => '田纳西州',
    'TX' => '德克萨斯州',
    'UT' => '犹他州',
    'VT' => '佛蒙特州',
    'VA' => '弗吉尼亚州',
    'WA' => '华盛顿',
    'WV' => '西弗吉尼亚州',
    'WI' => '威斯康星州',
    'WY' => '怀俄明州',
];

$app_list_strings['charset_dom'] = [
    'BIG-5' => 'BIG-5 (台湾和香港)',
    /*'CP866'     => 'CP866', // ms-dos Cyrillic */
    /*'CP949'     => 'CP949 (Microsoft Korean)', */
    'CP1251' => 'CP1251 (微软西里尔)',
    'CP1252' => 'CP1252 (微软西欧和美国)',
    'EUC-CN' => 'EUC-CN (简体中文GB2312)',
    'EUC-JP' => 'EUC-JP (Unix日本)',
    'EUC-KR' => 'EUC-KR (韩国)',
    'EUC-TW' => 'EUC-TW (台湾)',
    'ISO-2022-JP' => 'ISO-2022-JP (日本)',
    'ISO-2022-KR' => 'ISO-2022-KR (韩国)',
    'ISO-8859-1' => 'ISO-8859-1 (西欧和美国)',
    'ISO-8859-2' => 'ISO-8859-2 (中东欧)',
    'ISO-8859-3' => 'ISO-8859-3 (拉丁 3)',
    'ISO-8859-4' => 'ISO-8859-4 (拉丁 4)',
    'ISO-8859-5' => 'ISO-8859-5 (西里尔)',
    'ISO-8859-6' => 'ISO-8859-6 (阿拉伯)',
    'ISO-8859-7' => 'ISO-8859-7 (希腊)',
    'ISO-8859-8' => 'ISO-8859-8 (希伯来)',
    'ISO-8859-9' => 'ISO-8859-9 (拉丁 5)',
    'ISO-8859-10' => 'ISO-8859-10 (拉丁 6)',
    'ISO-8859-13' => 'ISO-8859-13 (拉丁 7)',
    'ISO-8859-14' => 'ISO-8859-14 (拉丁 8)',
    'ISO-8859-15' => 'ISO-8859-15 (拉丁 9)',
    'KOI8-R' => 'KOI8-R (西里尔俄罗斯)',
    'KOI8-U' => 'KOI8-U (西里尔乌克兰)',
    'SJIS' => 'SJIS (微软日本)',
    'UTF-8' => 'UTF-8',
];

$app_list_strings['timezone_dom'] = [

    'Africa/Algiers' => '非洲/阿尔及尔',
    'Africa/Luanda' => '非洲/罗安达',
    'Africa/Porto-Novo' => '非洲/波多诺伏',
    'Africa/Gaborone' => '非洲/哈博罗内',
    'Africa/Ouagadougou' => '非洲/瓦加杜古',
    'Africa/Bujumbura' => '非洲/布琼布拉',
    'Africa/Douala' => '非洲/杜阿拉',
    'Atlantic/Cape_Verde' => '大西洋/佛得角',
    'Africa/Bangui' => '非洲/班吉',
    'Africa/Ndjamena' => '非洲/恩贾梅纳',
    'Indian/Comoro' => '印度洋/科摩罗',
    'Africa/Kinshasa' => '非洲/金沙萨',
    'Africa/Lubumbashi' => '非洲/卢本巴希',
    'Africa/Brazzaville' => '非洲/布拉柴维尔',
    'Africa/Abidjan' => '非洲/阿比让',
    'Africa/Djibouti' => '非洲/吉布提',
    'Africa/Cairo' => '非洲/开罗',
    'Africa/Malabo' => '非洲/马拉博',
    'Africa/Asmera' => '非洲/阿斯马拉',
    'Africa/Addis_Ababa' => '非洲/亚的斯亚贝巴',
    'Africa/Libreville' => '非洲/利伯维尔',
    'Africa/Banjul' => '非洲/班珠尔',
    'Africa/Accra' => '非洲/阿克拉',
    'Africa/Conakry' => '非洲/科纳克里',
    'Africa/Bissau' => '非洲/比绍',
    'Africa/Nairobi' => '非洲/内罗毕',
    'Africa/Maseru' => '非洲/马塞卢',
    'Africa/Monrovia' => '非洲/蒙罗维亚',
    'Africa/Tripoli' => '非洲/的黎波里',
    'Indian/Antananarivo' => '印度洋/塔那那利佛',
    'Africa/Blantyre' => '非洲/布兰太尔',
    'Africa/Bamako' => '非洲/巴马科',
    'Africa/Nouakchott' => '非洲/努瓦克肖特',
    'Indian/Mauritius' => '印度洋/毛里求斯',
    'Indian/Mayotte' => '印度洋/马约特',
    'Africa/Casablanca' => '非洲/卡萨布兰卡',
    'Africa/El_Aaiun' => '非洲/阿尤恩',
    'Africa/Maputo' => '非洲/马普托',
    'Africa/Windhoek' => '非洲/温得和克',
    'Africa/Niamey' => '非洲/尼亚美',
    'Africa/Lagos' => '非洲/拉各斯',
    'Indian/Reunion' => '印度洋/留尼汪岛',
    'Africa/Kigali' => '非洲/基加利',
    'Atlantic/St_Helena' => '大西洋/圣赫勒拿岛',
    'Africa/Sao_Tome' => '非洲/圣多美',
    'Africa/Dakar' => '非洲/达喀尔',
    'Indian/Mahe' => '印度洋/马埃',
    'Africa/Freetown' => '非洲/弗里敦',
    'Africa/Mogadishu' => '非洲/摩加迪沙',
    'Africa/Johannesburg' => '非洲/约翰内斯堡',
    'Africa/Khartoum' => '非洲/喀土穆',
    'Africa/Mbabane' => '非洲/姆巴巴内',
    'Africa/Dar_es_Salaam' => '非洲/达累斯萨拉姆',
    'Africa/Lome' => '非洲/洛美',
    'Africa/Tunis' => '非洲/突尼斯',
    'Africa/Kampala' => '非洲/坎帕拉',
    'Africa/Lusaka' => '非洲/卢萨卡',
    'Africa/Harare' => '非洲/哈尔',
    'Antarctica/Casey' => '南极洲/凯西站',
    'Antarctica/Davis' => '南极洲/戴维斯站',
    'Antarctica/Mawson' => '南极洲/莫森站',
    'Indian/Kerguelen' => '印度洋/克尔格伦群岛',
    'Antarctica/DumontDUrville' => '南极洲/都蒙特得乌尔维尔站',
    'Antarctica/Syowa' => '南极洲/斯由瓦站',
    'Antarctica/Vostok' => '南极洲/东方站',
    'Antarctica/Rothera' => '南极洲/罗西拉',
    'Antarctica/Palmer' => '南极洲/帕玛',
    'Antarctica/McMurdo' => '南极洲/麦克默多站',
    'Asia/Kabul' => '亚洲/喀布尔',
    'Asia/Yerevan' => '亚洲/埃里温',
    'Asia/Baku' => '亚洲/巴库',
    'Asia/Bahrain' => '亚洲/巴林',
    'Asia/Dhaka' => '亚洲/达卡',
    'Asia/Thimphu' => '亚洲/廷布',
    'Indian/Chagos' => '印度洋/查戈斯群岛',
    'Asia/Brunei' => '亚洲/文莱',
    'Asia/Rangoon' => '亚洲/仰光',
    'Asia/Phnom_Penh' => '亚洲/金边',
    'Asia/Beijing' => '亚洲/北京',
    'Asia/Harbin' => '亚洲/哈尔滨',
    'Asia/Shanghai' => '亚洲/上海',
    'Asia/Chongqing' => '亚洲/重庆',
    'Asia/Urumqi' => '亚洲/乌鲁木齐',
    'Asia/Kashgar' => '亚洲/喀什',
    'Asia/Hong_Kong' => '亚洲/香港',
    'Asia/Taipei' => '亚洲/台北',
    'Asia/Macau' => '亚洲/澳门',
    'Asia/Nicosia' => '亚洲/尼科西亚',
    'Asia/Tbilisi' => '亚洲/梯比利斯',
    'Asia/Dili' => '亚洲/帝力',
    'Asia/Calcutta' => '亚洲/加尔各答',
    'Asia/Jakarta' => '亚洲/雅加达',
    'Asia/Pontianak' => '亚洲/坤甸',
    'Asia/Makassar' => '亚洲/望加锡',
    'Asia/Jayapura' => '亚洲/查亚普拉',
    'Asia/Tehran' => '亚洲/德黑兰',
    'Asia/Baghdad' => '亚洲/巴格达',
    'Asia/Jerusalem' => '亚洲/耶路撒冷',
    'Asia/Tokyo' => '亚洲/东京',
    'Asia/Amman' => '亚洲/安曼',
    'Asia/Almaty' => '亚洲/阿拉木图',
    'Asia/Qyzylorda' => '亚洲/奥尔达',
    'Asia/Aqtobe' => '亚洲/阿克托博',
    'Asia/Aqtau' => '亚洲/阿克陶',
    'Asia/Oral' => '亚洲/乌拉尔',
    'Asia/Bishkek' => '亚洲/比什凯克',
    'Asia/Seoul' => '亚洲/汉城',
    'Asia/Pyongyang' => '亚洲/平壤',
    'Asia/Kuwait' => '亚洲/科威特',
    'Asia/Vientiane' => '亚洲/万象',
    'Asia/Beirut' => '亚洲/贝鲁特',
    'Asia/Kuala_Lumpur' => '亚洲/吉隆坡',
    'Asia/Kuching' => '亚洲/古晋',
    'Indian/Maldives' => '印度洋/马尔代夫',
    'Asia/Hovd' => '亚洲/霍伏得',
    'Asia/Ulaanbaatar' => '亚洲/乌兰巴托',
    'Asia/Choibalsan' => '亚洲/乔巴山',
    'Asia/Katmandu' => '亚洲/加德满都',
    'Asia/Muscat' => '亚洲/马斯喀特',
    'Asia/Karachi' => '亚洲/卡拉奇',
    'Asia/Gaza' => '亚洲/加沙',
    'Asia/Manila' => '亚洲/马尼拉',
    'Asia/Qatar' => '亚洲/卡塔尔',
    'Asia/Riyadh' => '亚洲/利雅得',
    'Asia/Singapore' => '亚洲/新加坡',
    'Asia/Colombo' => '亚洲/科伦坡',
    'Asia/Damascus' => '亚洲/大马士革',
    'Asia/Dushanbe' => '亚洲/杜尚别',
    'Asia/Bangkok' => '亚洲/曼谷',
    'Asia/Ashgabat' => '亚洲/阿什哈巴德',
    'Asia/Dubai' => '亚洲/迪拜',
    'Asia/Samarkand' => '亚洲/撒马尔罕',
    'Asia/Tashkent' => '亚洲/塔什干',
    'Asia/Saigon' => '亚洲/西贡',
    'Asia/Aden' => '亚洲/亚丁',
    'Australia/Darwin' => '澳大利亚/达尔文',
    'Australia/Perth' => '澳大利亚/佩思',
    'Australia/Brisbane' => '澳大利亚/布里斯班',
    'Australia/Lindeman' => '澳大利亚/林德曼岛',
    'Australia/Adelaide' => '澳大利亚/阿得雷德',
    'Australia/Hobart' => '澳大利亚/霍巴特',
    'Australia/Currie' => '澳大利亚/柯里',
    'Australia/Melbourne' => '澳大利亚/墨尔本',
    'Australia/Sydney' => '澳大利亚/悉尼',
    'Australia/Broken_Hill' => '澳大利亚/断山',
    'Indian/Christmas' => '印度洋/圣诞岛',
    'Pacific/Rarotonga' => '太平洋/拉罗汤加岛',
    'Indian/Cocos' => '印度洋/可可斯岛',
    'Pacific/Fiji' => '太平洋/斐济',
    'Pacific/Gambier' => '太平洋/冈比亚岛',
    'Pacific/Marquesas' => '太平洋/马尔萨斯群岛',
    'Pacific/Tahiti' => '太平洋/塔希提岛',
    'Pacific/Guam' => '太平洋/关岛',
    'Pacific/Tarawa' => '太平洋/塔拉瓦岛',
    'Pacific/Enderbury' => '太平洋/恩的伯利',
    'Pacific/Kiritimati' => '太平洋/基里提马蒂',
    'Pacific/Saipan' => '太平洋/塞班岛',
    'Pacific/Majuro' => '太平洋/马朱罗',
    'Pacific/Kwajalein' => '太平洋/卡瓦加兰',
    'Pacific/Truk' => '太平洋/特鲁克群岛',
    'Pacific/Ponape' => '太平洋/波纳佩',
    'Pacific/Kosrae' => '太平洋/库赛埃',
    'Pacific/Nauru' => '太平洋/瑙鲁',
    'Pacific/Noumea' => '太平洋/努美阿',
    'Pacific/Auckland' => '太平洋/奥克兰',
    'Pacific/Chatham' => '太平洋/查塔姆',
    'Pacific/Niue' => '太平洋/扭埃',
    'Pacific/Norfolk' => '太平洋/诺福克',
    'Pacific/Palau' => '太平洋/帕劳',
    'Pacific/Port_Moresby' => '太平洋/莫尔兹比港',
    'Pacific/Pitcairn' => '太平洋/皮特克恩岛',
    'Pacific/Pago_Pago' => '太平洋/帕果帕果',
    'Pacific/Apia' => '太平洋/阿批亚',
    'Pacific/Guadalcanal' => '太平洋/瓜达尔卡纳尔岛',
    'Pacific/Fakaofo' => '太平洋/法考福',
    'Pacific/Tongatapu' => '太平洋/汤加塔埔',
    'Pacific/Funafuti' => '太平洋/富纳富提',
    'Pacific/Johnston' => '太平洋/约翰斯顿岛',
    'Pacific/Midway' => '太平洋/中途岛',
    'Pacific/Wake' => '太平洋/威克岛',
    'Pacific/Efate' => '太平洋/埃法特',
    'Pacific/Wallis' => '太平洋/瓦利斯岛',
    'Europe/London' => '欧洲/伦敦',
    'Europe/Dublin' => '欧洲/都柏林',
    'WET' => '西部欧洲时间',
    'CET' => '中部欧洲时间',
    'MET' => '欧洲中部时间',
    'EET' => '欧洲东部时间',
    'Europe/Tirane' => '欧洲/地拉那',
    'Europe/Andorra' => '欧洲/安道尔',
    'Europe/Vienna' => '欧洲/维也纳',
    'Europe/Minsk' => '欧洲/明斯克',
    'Europe/Brussels' => '欧洲/布鲁塞尔',
    'Europe/Sofia' => '欧洲/索非亚',
    'Europe/Prague' => '欧洲/布拉格',
    'Europe/Copenhagen' => '欧洲/哥本哈根',
    'Atlantic/Faeroe' => '大西洋/法罗群岛',
    'America/Danmarkshavn' => '美洲/格陵兰东北城市',
    'America/Scoresbysund' => '美洲/斯格里斯比桑得',
    'America/Godthab' => '美洲/戈德霍普',
    'America/Thule' => '美洲/图列',
    'Europe/Tallinn' => '欧洲/塔林',
    'Europe/Helsinki' => '欧洲/赫尔辛基',
    'Europe/Paris' => '欧洲/巴黎',
    'Europe/Berlin' => '欧洲/伯林',
    'Europe/Gibraltar' => '欧洲/直布罗陀',
    'Europe/Athens' => '欧洲/雅典',
    'Europe/Budapest' => '欧洲/布达佩斯',
    'Atlantic/Reykjavik' => '大西洋/雷克雅未克',
    'Europe/Rome' => '欧洲/罗马',
    'Europe/Riga' => '欧洲/里加',
    'Europe/Vaduz' => '欧洲/瓦杜兹',
    'Europe/Vilnius' => '欧洲/维尔纽斯',
    'Europe/Luxembourg' => '欧洲/卢森堡',
    'Europe/Malta' => '欧洲/马尔他',
    'Europe/Chisinau' => '欧洲/基希讷乌',
    'Europe/Monaco' => '欧洲/摩纳哥',
    'Europe/Amsterdam' => '欧洲/阿姆斯特丹',
    'Europe/Oslo' => '欧洲/奥斯陆',
    'Europe/Warsaw' => '欧洲/华沙',
    'Europe/Lisbon' => '欧洲/里斯本',
    'Atlantic/Azores' => '大西洋/亚速尔',
    'Atlantic/Madeira' => '大西洋/马德拉群岛',
    'Europe/Bucharest' => '欧洲/布加勒斯特',
    'Europe/Kaliningrad' => '欧洲/加里宁格勒',
    'Europe/Moscow' => '欧洲/莫斯科',
    'Europe/Samara' => '欧洲/萨马拉',
    'Asia/Yekaterinburg' => '亚洲/叶卡捷琳堡',
    'Asia/Omsk' => '亚洲/鄂木斯克',
    'Asia/Novosibirsk' => '亚洲/诺夫哥罗德',
    'Asia/Krasnoyarsk' => '亚洲/克拉斯诺亚尔斯克',
    'Asia/Irkutsk' => '亚洲/伊尔库茨克',
    'Asia/Yakutsk' => '亚洲/雅库次克',
    'Asia/Vladivostok' => '亚洲/符拉迪沃斯托克',
    'Asia/Sakhalin' => '亚洲/萨哈林',
    'Asia/Magadan' => '亚洲/玛格丹',
    'Asia/Kamchatka' => '亚洲/勘察加',
    'Asia/Anadyr' => '亚洲/阿纳德尔',
    'Europe/Belgrade' => '欧洲/贝尔格莱德',
    'Europe/Madrid' => '欧洲/马德里',
    'Africa/Ceuta' => '非洲/休达',
    'Atlantic/Canary' => '大西洋/加那利',
    'Europe/Stockholm' => '欧洲/斯德哥尔摩',
    'Europe/Zurich' => '欧洲/苏黎世',
    'Europe/Istanbul' => '欧洲/伊斯坦布尔',
    'Europe/Kiev' => '欧洲/基辅',
    'Europe/Uzhgorod' => '欧洲/乌兹哥罗德',
    'Europe/Zaporozhye' => '欧洲/扎波罗热',
    'Europe/Simferopol' => '欧洲/辛菲罗波尔',
    'America/New_York' => '美洲/纽约',
    'America/Chicago' => '美洲/芝加哥',
    'America/North_Dakota/Center' => '美洲/北达科达州/中部',
    'America/Denver' => '美洲/丹佛',
    'America/Los_Angeles' => '美洲/洛杉矶',
    'America/Juneau' => '美洲/朱诺',
    'America/Yakutat' => '美洲/亚库塔特',
    'America/Anchorage' => '美洲/安科雷齐',
    'America/Nome' => '美洲/诺姆',
    'America/Adak' => '美洲/埃达克',
    'Pacific/Honolulu' => '太平洋/火奴鲁鲁',
    'America/Phoenix' => '美洲/菲尼克斯',
    'America/Boise' => '美洲/博伊西',
    'America/Indiana/Indianapolis' => '美洲/印第安那/印第安纳波利斯',
    'America/Indiana/Marengo' => '美洲/印第安那/马伦哥',
    'America/Indiana/Knox' => '美洲/印第安那/诺克斯',
    'America/Indiana/Vevay' => '美洲/印第安那/瓦维',
    'America/Kentucky/Louisville' => '美洲/肯塔基/路易斯维尔',
    'America/Kentucky/Monticello' => '美洲/肯塔基/蒙帝塞罗',
    'America/Detroit' => '美洲/底特律',
    'America/Menominee' => '美洲/梅诺米尼',
    'America/St_Johns' => '美洲/圣约翰',
    'America/Goose_Bay' => '美洲/古斯贝',
    'America/Halifax' => '美洲/哈利法克斯',
    'America/Glace_Bay' => '美洲/格雷斯湾',
    'America/Montreal' => '美洲/蒙特利尔',
    'America/Toronto' => '美洲/多伦多',
    'America/Thunder_Bay' => '美洲/桑德贝',
    'America/Nipigon' => '美洲/尼皮冈',
    'America/Rainy_River' => '美洲/多雨河',
    'America/Winnipeg' => '美洲/温尼伯',
    'America/Regina' => '美洲/里加纳',
    'America/Swift_Current' => '美洲/斯威福特卡润特',
    'America/Edmonton' => '美洲/埃德蒙顿',
    'America/Vancouver' => '美洲/温哥华',
    'America/Dawson_Creek' => '美洲/道森溪',
    'America/Pangnirtung' => '美洲/潘尼尔顿',
    'America/Iqaluit' => '美洲/伊魁特',
    'America/Coral_Harbour' => '美洲/珊瑚港',
    'America/Rankin_Inlet' => '美洲/润进入口',
    'America/Cambridge_Bay' => '美洲/剑桥湾',
    'America/Yellowknife' => '美洲/黄刀镇',
    'America/Inuvik' => '美洲/伊努维克',
    'America/Whitehorse' => '美洲/白马',
    'America/Dawson' => '美洲/道森',
    'America/Cancun' => '美洲/坎昆',
    'America/Merida' => '美洲/梅里达',
    'America/Monterrey' => '美洲/蒙特雷',
    'America/Mexico_City' => '美洲/墨西哥城',
    'America/Chihuahua' => '美洲/奇瓦瓦',
    'America/Hermosillo' => '美洲/埃尔莫西略',
    'America/Mazatlan' => '美洲/马萨特兰',
    'America/Tijuana' => '美洲/蒂华纳',
    'America/Anguilla' => '美洲/安圭拉',
    'America/Antigua' => '美洲/安提瓜岛',
    'America/Nassau' => '美洲/拿骚',
    'America/Barbados' => '美洲/巴巴多斯',
    'America/Belize' => '美洲/伯利兹',
    'Atlantic/Bermuda' => '大西洋/百慕大',
    'America/Cayman' => '美洲/开曼',
    'America/Costa_Rica' => '美洲/哥斯达黎加',
    'America/Havana' => '美洲/哈瓦那',
    'America/Dominica' => '美洲/多米尼加',
    'America/Santo_Domingo' => '美洲/圣多明各',
    'America/El_Salvador' => '美洲/萨尔瓦多',
    'America/Grenada' => '美洲/格林纳达',
    'America/Guadeloupe' => '美洲/瓜德罗普岛',
    'America/Guatemala' => '美洲/危地马拉',
    'America/Port-au-Prince' => '美洲/太子港',
    'America/Tegucigalpa' => '美洲/特古西加尔巴',
    'America/Jamaica' => '美洲/牙买加',
    'America/Martinique' => '美洲/马提尼克岛',
    'America/Montserrat' => '美洲/蒙特塞拉特',
    'America/Managua' => '美洲/马那瓜',
    'America/Panama' => '美洲/巴拿马',
    'America/Puerto_Rico' => '美洲/波多黎各',
    'America/St_Kitts' => '美洲/圣基茨',
    'America/St_Lucia' => '美洲/圣卢西亚',
    'America/Miquelon' => '美洲/密克隆',
    'America/St_Vincent' => '美洲/圣文森特',
    'America/Grand_Turk' => '美洲/大特克岛',
    'America/Tortola' => '美洲/托投拉',
    'America/St_Thomas' => '美洲/圣托马斯',
    'America/Argentina/Buenos_Aires' => '美洲/阿根廷/布宜诺斯艾利斯',
    'America/Argentina/Cordoba' => '美洲/阿根廷/科尔多瓦',
    'America/Argentina/Tucuman' => '美洲/阿根廷/图库曼',
    'America/Argentina/La_Rioja' => '美洲/阿根廷/里奥哈',
    'America/Argentina/San_Juan' => '美洲/阿根廷/圣胡安',
    'America/Argentina/Jujuy' => '美洲/阿根廷/胡胡伊',
    'America/Argentina/Catamarca' => '美洲/阿根廷/卡塔马卡',
    'America/Argentina/Mendoza' => '美洲/阿根廷/门多萨',
    'America/Argentina/Rio_Gallegos' => '美洲/阿根廷/里约热内卢',
    'America/Argentina/Ushuaia' => '美洲/阿根廷/乌斯怀亚',
    'America/Aruba' => '美洲/阿鲁巴',
    'America/La_Paz' => '美洲/拉巴斯',
    'America/Noronha' => '美洲/诺罗尼亚',
    'America/Belem' => '美洲/贝伦',
    'America/Fortaleza' => '美洲/福塔雷萨',
    'America/Recife' => '美洲/累西腓',
    'America/Araguaina' => '美洲/阿拉瓜伊纳',
    'America/Maceio' => '美洲/马塞约',
    'America/Bahia' => '美洲/Bahia',
    'America/Sao_Paulo' => '美洲/圣保罗',
    'America/Campo_Grande' => '美洲/大坎普',
    'America/Cuiaba' => '美洲/库亚巴',
    'America/Porto_Velho' => '美洲/波多韦柳',
    'America/Boa_Vista' => '美洲/泊亚维斯特',
    'America/Manaus' => '美洲/马瑙斯',
    'America/Eirunepe' => '美洲/依伦尼贝',
    'America/Rio_Branco' => '美洲/里约布兰科',
    'America/Santiago' => '美洲/圣地亚哥',
    'Pacific/Easter' => '美洲/复活节岛',
    'America/Bogota' => '美洲/波哥大',
    'America/Curacao' => '美洲/库拉索',
    'America/Guayaquil' => '美洲/瓜亚基尔',
    'Pacific/Galapagos' => '太平洋/加拉帕戈斯群岛',
    'Atlantic/Stanley' => '大西洋/斯坦利',
    'America/Cayenne' => '美洲/卡宴',
    'America/Guyana' => '美洲/圭亚那',
    'America/Asuncion' => '美洲/亚松森',
    'America/Lima' => '美洲/利马',
    'Atlantic/South_Georgia' => '大西洋/南乔治亚',
    'America/Paramaribo' => '美洲/帕拉马里博',
    'America/Port_of_Spain' => '美洲/西班牙港',
    'America/Montevideo' => '美洲/蒙得维的亚',
    'America/Caracas' => '美洲/加拉加斯',
];

$app_list_strings['moduleList']['Sugar_Favorites'] = '收藏夹';
$app_list_strings['moduleListSingular']['Sugar_Favorites'] = '收藏夹';
$app_list_strings['eapm_list'] = [
    'Sugar' => 'Sugar',
    'WebEx' => 'WebEx',
    'GoToMeeting' => '会翼通',
    'IBMSmartCloud' => 'IBM 智慧云',
    'Google' => '谷歌',
    'Box' => 'Box.net',
    'Twitter' => 'Twitter',
    'Microsoft' => 'Microsoft',
];
$app_list_strings['eapm_list_import'] = [
    'Google' => '谷歌联系人',
];
$app_list_strings['eapm_list_documents'] = [
    'Google' => '谷歌驱动器',
];
$app_list_strings['token_status'] = [
    1 => '请求',
    2 => '访问',
    3 => '无效',
];
$app_list_strings['oauth_type_dom'] = [
    'oauth1' => 'OAuth 1.0',
    'oauth2' => 'OAuth 2.0',
];
$app_list_strings['oauth_client_type_dom'] = [
    'user' => 'Sugar 用户',
    'support_portal' => '支持门户网站',
];

$app_list_strings ['emailTemplates_type_list'] = [
    '' => '',
    'campaign' => '市场活动',
    'email' => '电子邮件',
    'workflow' => '工作流',
    'system' => '系统',
];

$app_list_strings ['emailTemplates_type_list_campaigns'] = [
    '' => '',
    'campaign' => '市场活动',
];

$app_list_strings ['emailTemplates_type_list_no_workflow'] = [
    '' => '',
    'campaign' => '市场活动',
    'email' => '电子邮件',
];
$app_list_strings ['documentation'] = [
    'LBL_DOCS' => '文件',
    'ULT' => '01_Sugar_Ultimate',
    'ENT' => '02_Sugar_Enterprise',
    'CORP' => '03_Sugar_Corporate',
    'PRO' => '04_Sugar_Professional',
];

$app_list_strings['forecasts_config_ranges_options_dom'] = [
    'show_binary' => '两个范围',
    'show_buckets' => '三个范围',
    'show_custom_buckets' => '自定义范围',
];
$app_list_strings['forecasts_timeperiod_types_dom'] = [
    'chronological' => '基于日期的年份',
];
$app_list_strings['forecasts_timeperiod_options_dom'] = [
    'Annual' => '每年（季度子周期）',
    'Quarter' => '季度（月度分时段）',
];
$app_list_strings['forecasts_config_worksheet_layout_forecast_by_options_dom'] = [
    'RevenueLineItems' => '营收单项',
    'Opportunities' => '商业机会',
];

$app_list_strings['forecast_fiscal_year_options'] = [
    'current_year' => '{{year}}',
    'next_year' => '{{year}}',
];

$app_list_strings ['pdfmanager_yes_no_list'] = [
    'yes' => '是',
    'no' => '否',
];

$app_list_strings['notifications_severity_list'] = [
    'alert' => '警惕',
    'information' => '信息',
    'other' => '其他',
    'success' => '成功',
    'warning' => '警告',
];

$app_list_strings['web_hook_request_method_list'] = [
    'POST' => 'POST',
    'GET' => 'GET',
    'PUT' => 'PUT',
    'DELETE' => '删除',
];

$app_list_strings['email_check_interval_dom'] = [
    '-1' => '手动',
    '5' => '每隔 5 分钟',
    '15' => '每隔 15 分钟',
    '30' => '每隔 30 分钟',
    '60' => '每隔 1 小时',
];

$app_list_strings['moduleList']['KBDocuments'] = '知识库文件';
$app_list_strings['moduleListSingular']['KBDocuments'] = '知识库文件';
$app_list_strings['moduleList']['KBContents'] = '知识库';
$app_list_strings['moduleListSingular']['KBContents'] = '知识库文章';
$app_list_strings['moduleList']['KBArticles'] = '知识库文章';
$app_list_strings['moduleListSingular']['KBArticles'] = '知识库文章';
$app_list_strings['moduleList']['KBContentTemplates'] = '知识库模板';
$app_list_strings['moduleListSingular']['KBContentTemplates'] = '知识库模板';
$app_list_strings['moduleList']['EmbeddedFiles'] = '嵌入的文件';
$app_list_strings['moduleListSingular']['EmbeddedFiles'] = '嵌入的文件';

$app_list_strings['iso_currency_symbol'] = [
    'ALL' => 'Lek',
    'USD' => '$',
    'AFN' => '؋',
    'ARS' => '$',
    'AWG' => 'ƒ',
    'AUD' => '$',
    'AZN' => 'ман',
    'BSD' => '$',
    'BBD' => '$',
    'BYR' => 'p.',
    'EUR' => '€',
    'BZD' => 'BZ$',
    'BMD' => '$',
    'BOB' => '$b',
    'BAM' => 'KM',
    'BWP' => 'P',
    'BGN' => 'лв',
    'BRL' => 'R$',
    'GBP' => '£',
    'BND' => '$',
    'KHR' => '៛',
    'CAD' => '$',
    'KYD' => '$',
    'CLP' => '$',
    'CNY' => '¥',
    'COP' => '$',
    'CRC' => '₡',
    'HRK' => 'kn',
    'CUP' => '₱',
    'CZK' => 'Kč',
    'DKK' => 'kr',
    'DOP' => 'RD$',
    'XCD' => '$',
    'EGP' => '£',
    'SVC' => '$',
    'EEK' => 'kr',
    'FKP' => '£',
    'FJD' => '$',
    'GHC' => '¢',
    'GIP' => '£',
    'GTQ' => 'Q',
    'GGP' => '£',
    'GYD' => '$',
    'HNL' => 'L',
    'HKD' => '$',
    'HUF' => 'Ft',
    'ISK' => 'kr',
    'INR' => '₨',
    'IDR' => 'Rp',
    'IRR' => '77e8',
    'IMP' => '£',
    'ILS' => '₪',
    'JMD' => 'J$',
    'JPY' => '¥',
    'JEP' => '£',
    'KZT' => 'лв',
    'KPW' => '₩',
    'KRW' => '₩',
    'KGS' => 'лв',
    'LAK' => '₭',
    'LVL' => 'Ls',
    'LBP' => '£',
    'LRD' => '$',
    'CHF' => 'CHF',
    'LTL' => 'Lt',
    'MKD' => 'ден',
    'MYR' => 'RM',
    'MUR' => '₨',
    'MXN' => '$',
    'MNT' => '₮',
    'MZN' => 'MT',
    'NAD' => '$',
    'NPR' => '₨',
    'ANG' => 'ƒ',
    'NZD' => '$',
    'NIO' => 'C$',
    'NGN' => '₦',
    'NOK' => 'kr',
    'OMR' => '77e8',
    'PKR' => '₨',
    'PAB' => 'B/.',
    'PYG' => 'Gs',
    'PEN' => 'S/.',
    'PHP' => '₱',
    'PLN' => 'zł',
    'QAR' => '77e8',
    'RON' => 'lei',
    'RUB' => 'руб',
    'SHP' => '£',
    'SAR' => '77e8',
    'RSD' => 'Дин.',
    'SCR' => '₨',
    'SGD' => '$',
    'SBD' => '$',
    'SOS' => 'S',
    'ZAR' => 'R',
    'LKR' => '₨',
    'SEK' => 'kr',
    'SRD' => '$',
    'SYP' => '£',
    'TWD' => 'NT$',
    'THB' => '฿',
    'TTD' => 'TT$',
    'TRY' => 'TL',
    'TRL' => '₤',
    'TVD' => '$',
    'UAH' => '₴',
    'UYU' => '$U',
    'UZS' => 'лв',
    'VEF' => 'Bs',
    'VND' => '₫',
    'YER' => '77e8',
    'ZWD' => 'Z$',
];

$app_list_strings['iso_currency_name'] = [
    'ALL' => '列克',
    'USD' => '美元',
    'AFN' => '阿富汗尼',
    'ARS' => '比索',
    'AWG' => '荷兰盾',
    'AUD' => '美元',
    'AZN' => '新马纳特',
    'BSD' => '美元',
    'BBD' => '美元',
    'BYR' => '卢布',
    'EUR' => '欧元',
    'BZD' => '美元',
    'BMD' => '美元',
    'BOB' => '玻利维亚诺',
    'BAM' => '可兑换马克',
    'BWP' => '普拉',
    'BGN' => '列弗',
    'BRL' => '雷亚尔',
    'GBP' => '英镑',
    'BND' => '美元',
    'KHR' => '瑞尔',
    'CAD' => '美元',
    'KYD' => '美元',
    'CLP' => '比索',
    'CNY' => '人民币元',
    'COP' => '比索',
    'CRC' => 'ColÃ³n',
    'HRK' => '库纳',
    'CUP' => '比索',
    'CZK' => '捷克克朗',
    'DKK' => '克罗钠',
    'DOP' => '比索',
    'XCD' => '美元',
    'EGP' => '英镑',
    'SVC' => '科郎',
    'EEK' => '克朗',
    'FKP' => '英镑',
    'FJD' => '美元',
    'GHC' => '塞地',
    'GIP' => '英镑',
    'GTQ' => '格查尔',
    'GGP' => '英镑',
    'GYD' => '美元',
    'HNL' => '伦皮拉',
    'HKD' => '美元',
    'HUF' => '福林',
    'ISK' => '克朗',
    'INR' => '卢比',
    'IDR' => '卢比',
    'IRR' => '里亚尔',
    'IMP' => '英镑',
    'ILS' => '新舍客勒',
    'JMD' => '美元',
    'JPY' => '日元',
    'JEP' => '英镑',
    'KZT' => '坚戈',
    'KPW' => '韩元',
    'KRW' => '圆',
    'KGS' => '索姆',
    'LAK' => '基普',
    'LVL' => '拉特',
    'LBP' => '英镑',
    'LRD' => '美元',
    'CHF' => '瑞士法郎',
    'LTL' => '立特',
    'MKD' => '代纳尔',
    'MYR' => '林吉特',
    'MUR' => '卢比',
    'MXN' => '比索',
    'MNT' => '图格里克',
    'MZN' => '梅蒂卡尔',
    'NAD' => '美元',
    'NPR' => '卢比',
    'ANG' => '荷兰盾',
    'NZD' => '美元',
    'NIO' => '科多巴',
    'NGN' => '奈拉',
    'NOK' => '克朗',
    'OMR' => '里亚尔',
    'PKR' => '卢比',
    'PAB' => '巴波亚',
    'PYG' => '瓜拉尼',
    'PEN' => '新索尔',
    'PHP' => '比索',
    'PLN' => '兹罗提',
    'QAR' => '里亚尔',
    'RON' => '新雷',
    'RUB' => '卢布',
    'SHP' => '英镑',
    'SAR' => '里亚尔',
    'RSD' => '第纳尔',
    'SCR' => '卢比',
    'SGD' => '美元',
    'SBD' => '美元',
    'SOS' => '先令',
    'ZAR' => '兰特',
    'LKR' => '卢比',
    'SEK' => '克朗',
    'SRD' => '美元',
    'SYP' => '英镑',
    'TWD' => '新美元',
    'THB' => '铢',
    'TTD' => '美元',
    'TRY' => '里拉',
    'TRL' => '里拉',
    'TVD' => '美元',
    'UAH' => '格里夫尼亚',
    'UYU' => '比索',
    'UZS' => '索姆',
    'VEF' => '玻利瓦',
    'VND' => '盾',
    'YER' => '里亚尔',
    'ZWD' => '津巴布韦元',
];

$app_list_strings['market_interest_prediction_dom'] = [
    '5' => '很高',
    '4' => '高',
    '3' => '中性',
    '2' => '低',
    '1' => '很低',
];
$app_list_strings['process_et_field_type'] = [
    'none' => '无',
    'future' => '当前值',
    'old' => '旧值',
    'both' => '当前值和旧值',
];
$app_list_strings['business_rule_type_list'] = [
    'single' => '单击',
];

$app_list_strings['merge_status_list'] = [
    'processing' => '正在处理',
    'error' => '错误',
    'success' => '成功',
    'canceled' => '已取消',
    'document_load' => '正在加载模板',
    'tags_extract' => '正在提取标签',
    'tags_validate' => '正在验证标签',
    'data_retrieving' => '正在检索数据',
    'serialize_document' => '拼接文档',
    'send_document' => '向您发送文档',
];

$app_list_strings['merge_type_list'] = [
    'merge' => '合并',
    'convert' => 'PDF 合并',
    'multimerge' => '批量合并',
    'multimerge_convert' => '批量合并 PDF',
    'labelsgenerate' => '生成标签',
    'labelsgenerate_convert' => '生成标签 PDF',
    'excel' => 'Excel 合并',
    'excel_convert' => 'Excel 合并转换',
    'presentation' => 'PowerPoint 合并',
    'presentation_convert' => 'PowerPoint 合并 PDF',
];

$app_list_strings['file_type_list'] = [
    'DOC' => 'DOC',
    'PDF' => 'PDF',
    'PPT' => 'PPT',
    'XLS' => 'XLS',
];

$app_list_strings['stage2_preferences_type'] = [
    'owner' => '我的帐户',
    'favorites' => '收藏夹账户',
    'tags' => '标记的帐户',
];

$app_list_strings['stage2_preferences_category'] = [
    'All' => '所有新闻',
    'General' => '常规',
    'Finance' => '财务',
    'People' => '全体人员',
    'Press Releases' => '新闻稿',
    'Other' => '其他',
];

$app_strings['LBL_OWNERS'] = '负责人';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_NAME'] = '云驱动';
$app_strings['LBL_DASHLET_CLOUD_DRIVE_DESCRIPTION'] = '云驱动集成渠道';
$app_strings['LBL_COPY_GOOGLE_DRIVE_LINK'] = '复制链接';
$app_strings['LBL_DOWNLOAD_DRIVE_FILE'] = '下载';
$app_strings['LBL_CREATE_SUGAR_DOCUMENT'] = '创建 Sugar 文档';
$app_strings['LBL_DRIVE_UNABLE_TO_DOWNLOAD'] = '无法下载此文件';
$app_strings['LBL_DRIVE_CLOUD_DASHLET_NOT_PRESENT'] = '云渠道不存在';
$app_strings['LBL_DRIVE_DOCUMENT_CREATED'] = 'Sugar 文件已创建';
$app_strings['LBL_SEND_TO_DOCUSIGN'] = '发送到DocuSign';
$app_strings['LBL_NO_SEND_TO_DOCUSIGN'] = 'DocuSign 无法从此位置使用。';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_WEP'] = '“文档合并到 Word/Excel/PowerPoint”无法从此位置使用';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_DS'] = '“文档合并到 DocuSign”无法从此位置使用';
$app_strings['LBL_NO_SEND_TO_DOCMERGE_PDF'] = '“文档合并到 PDF”无法从此位置使用';
$app_strings['LBL_DOCUSIGN_PERMISSIONS'] = '只有当您有权在此位置上传时，您的签名文件才会上传到此处。';
$app_strings['LBL_DOC_MERGE_TO'] = 'Doc合并至';
$app_strings['LBL_DOC_MERGE_TO_DOCUSIGN'] = 'DocuSign';
$app_strings['LBL_DOC_MERGE_WORD_EXCEL_POWERPOINT'] = 'Word/Excel/Powerpoint';
$app_strings['LBL_DOC_MERGE_TO_PDF'] = 'PDF';

$app_string['LBL_MY_FILES'] = '我的文件';
$app_strings['LBL_SHARED_WITH_ME'] = '已与我共享';
$app_strings['LBL_CLOUD_PROVIDER'] = '云提供商';

$app_list_strings['drive_types'] = [
    'google' => '谷歌驱动器',
    'onedrive' => '微软网盘',
    'dropbox' => 'Dropbox 驱动器',
    'sharepoint' => 'Microsoft SharePoint',
];
$app_strings['LBL_SHARED_WITH_ME'] = '已与我共享';
$app_strings['LBL_MY_FILES'] = '我的文件';
$app_strings['LBL_UPLOAD_FILE'] = '上传文件';
$app_strings['LBL_FOLDER_NOT_FOUND'] = '找不到文件夹';
$app_strings['LBL_CREATE_FOLDER'] = '创建文件夹';
$app_strings['LBL_LOAD_MORE'] = '加载更多...';
$app_strings['LBL_NEW_FOLDER'] = '新建文件夹';
$app_strings['LBL_FOLDER_NAME'] = '文件名称： ';
$app_strings['LBL_PERMISSION_ERROR'] = '您无权在当前路径上执行此操作。';
$app_strings['LBL_MICROSOFT_PERMISSION_ERROR'] = '您无权继续当前路径上操作。';
$app_strings['LBL_FILE_UPLOADED'] = '文件已上传。';
$app_strings['LBL_LARGE_FILE_UPLOAD'] = '由于文件很大，上传需要一段时间。';
$app_strings['LBL_ERR_NO_FILE_ATTACHED'] = '一条或多条文档记录没有附加文件。请将文件附加到记录并重试，或单独将特定记录与文件同步。';

$app_strings['LBL_CHECK_GOOGLE_CONNECTION'] = '未找到与 Google 的连接...';
$app_strings['LBL_CHECK_MICROSOFT_CONNECTION'] = '找不到与 Microsoft 的连接...';
$app_strings['LBL_CHECK_DROPBOX_CONNECTION'] = '未找到与 Dropbox 的连接......';
$app_strings['LBL_MICROSOFT_DELAY'] = '与 OneDrive 同步可能需要一段时间';
$app_strings['LBL_DRIVE_DELETE_CONFIRM'] = '您确实要删除这个文件吗？';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE'] = 'OneDrive 上传已完成。';
$app_strings['LBL_MICROSOFT_UPLOAD_COMPLETE_DESCRIPTION'] = ' 已成功上传。';
$app_strings['LBL_DRIVE_LOAD_PATH_ERROR'] = '加载路径时出错。';
$app_strings['LBL_INVALID_DRIVE_FILE'] = '错误已经发生，因为该文件已损坏。';
$app_strings['LBL_UPLOAD_AND_LINK_COMPLETE'] = '文档 <i>"{{documentName}}"</i> 已保存到您的云驱动器，并添加到文档模块。';
$app_strings['LBL_NO_PERMISSION_FILE_ERROR'] = '您没有权限删除此文件。';
$app_strings['LBL_NO_PERMISSION_FOLDER_ERROR'] = '您没有删除此文件夹的权限。';
$app_strings['LBL_NO_PERMISSION_FILE_UPLOAD_ERROR'] = '您没有将文件上载到此位置的权限。';
$app_strings['LBL_NO_PERMISSION_FOLDER_CREATE_ERROR'] = '您没有在此位置创建文件夹的权限。';
$app_strings['LBL_NO_FOLDER_CREATE'] = '无法在此位置创建文件夹。';
$app_strings['LBL_NO_FILE_UPLOAD'] = '无法将文件上载到此位置。';
$app_strings['LBL_SITES'] = '网站';
$app_strings['LBL_SHARED'] = '共享';
$app_strings['LBL_COPY_LINK_CONFIRMATION'] = '链接已创建。点击该按钮将链接复制到剪贴板。';
$app_strings['LBL_COPY_CLIPBOARD_CONFIRMATION'] = '复制到剪贴板';


$app_list_strings['gc_status_list'] = [
    '-blank-' => '-空白-',
    'Exact' => '精确',
    'Null_address_components' => '一个或多个地址组件为空',
    'Invalid_address' => '地址无效，服务器返回错误',
    'Invalid_server_response_not_XML' => '无效的服务器响应，不是 XML',
    'Invalid_address_no_location' => '地址无效，服务器未返回任何位置',
    'Ambiguous_address' => '地址不明确，多个匹配项',
];

$app_list_strings['maps_display_type_list'] = [
    'r' => '道路',
    'a' => '航空',
    'rd' => '道路漆黑',
];

$app_list_strings['maps_display_zoom_list'] = [
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '11' => '11',
    '12' => '12',
    '13' => '13',
    '14' => '14',
    '15' => '15',
    '16' => '16',
    '17' => '17',
    '18' => '18',
    '19' => '19',
];

$app_list_strings['kiosk_available_language_dom'] = [['en_us', '英语（美国）']];
$app_list_strings['kiosk_available_timezone_dom'] = [
    ['美国东部时间', '纽约 (EST)'],
    ['太平洋标准时间', '洛杉矶 (PST)'],
];
$app_list_strings['kiosk_case_status_dom'] = [
    ['新建', '新建'],
    ['已分配', '已分配'],
    ['已关闭', '已关闭'],
    ['待输入', '待输入'],
    ['已拒绝', '已拒绝'],
    ['复制', '复制'],
];
$app_list_strings['kiosk_case_type_dom'] = [
    ['管理', '管理'],
    ['产品', '产品'],
    ['用户', '用户'],
];
$app_list_strings['kiosk_case_priority_dom'] = [
    ['P1', '高'],
    ['P2', '中等'],
    ['P3', '低'],
];

$app_list_strings['kiosk_invitations_roles_dom'] = [
    ['用户', '用户'],
    ['管理员、用户', '管理'],
    ['客户经理，用户', '客户经理'],
];

$app_list_strings['kiosk_document_shared_dom'] = [
    ['last_30_days', '过去 30 天'],
    ['last_90_days', '过去 90 天'],
    ['this_year', '去年'],
    ['自定义', '自定义范围'],
    ['全部', '全部'],
];

$app_list_strings['kiosk_background_type_dom'] = [
    ['默认', '默认'],
    ['颜色', '纯色'],
    ['Url', '自定义图片'],
];
